'HUB75 test 6bit color 2bit per component(RGB)and some fill bits = 1byte      |
' tested with "ES-P2.5-I Pin2dmd led panel" 1/16 scan from AE
' gp0  RED0              Connection HUB75
' gp1  GREEN0
' gp2  BLUE0                  +----+
' gp3  RED1              RED0 |1 16| GREEN0
' gp4  GREEN1           BLUE0 |2 15| GND
' gp5  BLUE1             RED1 |3 14| GREEN1
' gp6  A                BLUE1  4 13| E
' gp7  B                    A  5 12| B
' gp8  C                    C |6 11| D
' gp9  D                  CLK |7 10| LATCH
' gp10 E                  /OE |8  9| GND
' gp11 CLK                    +----+
' gp12 LATCH
' gp13 /OE
' The reduction to only 6bit was usefull to minimize the time for preparing
' display-data (pack and mix now~6ms)2040@48MHz.
'-----------------------------------------------------------------------------|
Option EXPLICIT
Option DEFAULT NONE

' vars for display: buffers and PIO-calculation
Dim integer Work(2047) '32raw x 64col only 2bit/(RGB), pack first 8x8 in 2 parts
Dim integer StrB(1024-1) 'char height x display wide
Dim integer ChrB(256-1)  'for unpack+coloring  max 64xNo cols with 16 rows
'pack to
Dim integer Uppr(127) 'data packed
Dim integer Down(127) 'data packed
'for mask and shift
Dim integer AdrM(127) 'EOL mask;                fix after init
Dim integer AddM(127) 'holds the bitmask        not fix
Dim integer Tmp1(127) 'for temporary results    not fix
Dim integer Tmp2(127) 'for temporary results    not fix
'for save displaydata
Dim integer Pack
PIO make ring buffer Pack,256*8  'in bytes

'pointer: used for memory copy
Dim integer WAdr = Peek(VarAddr Work(0))   'upper org (integer 64bit)
Dim integer VAdr = Peek(VarAddr Work(1024))'lower org (integer 64bit)
Dim integer UAdr = Peek(VarAddr Uppr())    'pointer to upper
Dim integer DAdr = Peek(VarAddr Down())    'pointer to lower
Dim integer pAdM = Peek(VarAddr AddM())    'pionter to bit-mask
Dim integer pTmp = Peek(VarAddr Tmp1())    'pointer because of copy
Dim integer pAA0 = Peek(VarAddr Pack(0))   'pointer because of copy
Dim integer pAA1 = Peek(VarAddr Pack(128)) 'pointer because of copy

'font vars
Dim integer pStB = Peek(VarAddr StrB())    'for copy str.pattern to Work()
Dim integer pChB = Peek(VarAddr ChrB())    'for unpack char-pattern
Dim Integer FSize, FRows 'for font
Dim Integer FoIf(2,95)   'FontInfo  integer/char  address,width,height(byte)

'ColorTable
Dim integer CrTb(21)
Dim float Tic1,Tic2

'display start ----------------------------------------------------------------|

MyInit()'init EOL-Mask and ColorTable
DupD()'init buffer before start: blank with BOS and EOLs by "first save"

'init one PIO prog
'there is a problem with "DMA TX off",I can not stop/restart after Ctrl+C
If MM.Info(PIO TX DMA) Then
  Print "PIO TX DMA still running !!!!"
  PIO DMA TX OFF
  Pause 100
  PIO stop 1,0
  Pause 100
  If MM.Info(PIO TX DMA) Then Print "rest Pico": CPU RESTART
End If

InitHub75Pio()' with PIO CLEAR 1

StartHub75Pio()'start with ringbuffer

'tics--------------------------------------------------------------------------|
'SetTick   30,DupD  ,1 'DisplayUpDate: makes a display-flush every 30ms


'-application consts/vars -----------------------------------------------------|
Dim integer i,j,k,w,h


' application start -----------------------------------------------------------|

j = 1
Do 'main loop
              '  string   x  y  wide  color
  'DrawStringScr("hub75", 7, 15, 63, Rgb222(0,1,0))
  For i = 0 To 3
    DrawStringScr(Time$ , 4, 15, 60, Rgb222(1,1,0))
    DrawStringScr("DEMO",10,  0, 53, Rgb222(0,3-i,i))
    DupD
    Pause 1000
  Next i
  DrawCls()

  For i = 0 To 500
    DrawCharScr(Chr$(48+Rnd*50), Rnd*50, Rnd*15, (Rnd*63)<<1)
    DupD
  Next i
  DrawCls()

  For i = 0 To 100
    DrawCircle(6+(Rnd*51),6+(Rnd*19),6, (Rnd*63)<<1)
    DupD
  Next i
  DrawCls()

  For i = 0 To 31
   DrawLine( 0, 31-i, 63, i,(j Mod 20)+1)
   Inc j
   DupD  'DisplayUpDate
   'max speed Pause 30
  Next i
  For i = 0 To 63
   k = i
   DrawLine( k, 0, 63-k ,31,(j Mod 20)+1)
   Inc j
   DupD
   'Pause 30
  Next i
  DrawCls()

  For i = 0 To 200
    DrawRecHoll(Rnd*56 ,Rnd*24, 8, 8, (Rnd*63)<<1)
    DupD
    'Pause 30
  Next i
  DrawCls()

  For i = 0 To 200
    DrawRecFill(Rnd*56 ,Rnd*24, 8, 8, (Rnd*63)<<1)
    DupD
    'Pause 30
  Next i
  DrawCls()

Loop 'end main loop


'- subs/functions -------------------------------------------------------------|
Sub DrawCharScr( C$, x%, y%, Col%)
Local Integer cId, sAdr, dAdr, FntL, i
  'before get char, get the info
  cId  = Asc(Mid$(C$,1,1))-32
  sAdr = FoIf( 0, cId) 'start-adr 1st column of fontpattern
  FntL = FoIf( 1, cId) 'fontLen from font.info
  Memory unpack sAdr,pChB,FntL<<4,1 '16=4;8=3 'todo: get from font
  Math SCALE  ChrB(), Col%, ChrB()  'single color
  'char is in the box-> copy to screen
  For i = 0 To 15  'copy by line to work()  | y-offset      no  sinc dinc
    Memory Copy Integer pChB+(i<<3), WAdr+((((y%+i)<<6)+x%)<<3), FntL, 16, 1
  Next i 'line
End Sub

Sub DrawStringScr(st$, x%, y%, w%, Col%)' string, x, y, wide, color
Local integer StLn, idx, tLen, cId
  Math Set 0, StrB() 'clear buffer
  StLn = 0
  tLen = Len(st$)
  For idx = 1 To tLen
    cId = Asc(Mid$(st$,idx,1))-32
    StLn = DrawCharBox(cId, StLn+1, w%, Col%)
  Next idx
  'copy result to screen
  For idx = 0 To 15  'copy by line to work()  | y-offset          no  sinc dinc
   'Memory Copy Integer pChB+(idx<<3),WAdr+((((y%+idx)<<6)+x%)<<3), 16, 16, 1
   Memory Copy Integer pStB+(idx<<3),WAdr+((((y%+idx)<<6)+x%)<<3), StLn, 16, 1
  Next idx 'line
End Sub

Function DrawCharBox(ch%, off%, max%, Col% ) As integer 'fill char-box(StrB)
 Local Integer std,sts,ccn, sAdr, dAdr, FntL
  'before get char, get the info
  sAdr = FoIf( 0, ch%) 'start-adr 1st column of fontpattern
  FntL = FoIf( 1, ch%) 'fontLen from font.info
  Memory unpack sAdr,pChB,FntL<<4, 1'16=4;8=3 'todo: get from font
  Math SCALE  ChrB(), Col%, ChrB()  'single color
  If off% < 0 Then 'min.0 for first column
    std = 0         'dest. in column 'column char(i) to column led-matrix(j)
    sts = Abs(off%)
    ccn = FntL-sts 'column count substract because offs is negativ
  Else
    std = off% 'dest. in column for led-matrix(j)
    sts = 0
    ccn = FntL 'columns of char will fit
  End If
  If std < max% Then '< MaxColumn; dest. in column;led-array(????)
    If std+ccn > max% Then ccn = max% - std 'not all columns of char will fit
    dAdr = Peek(VarAddr StrB(std<<4)) 'buffer for stringpattern same height as
    sAdr = Peek(VarAddr ChrB(sts<<4)) '- font height
    Memory Copy Integer sAdr, dAdr, ccn<<4 'hole/part-char copy
  End If
  DrawCharBox = std+ccn
End Function 'DrawString


' Midpoint circle algorithm
Sub DrawCircle(x0 As Integer, y0 As Integer , radi As Integer, Col As Integer)
 Local Integer x=radi
 Local Integer y
 ' Decision criterion divided by 2 evaluated at x=r, y=0
 Local Integer dOv2=1-x
 Do While(x>=y)
   Work(x0+x+((y0+y)<<6))=Col
   Work(x0-x+((y0+y)<<6))=Col
   Work(x0+x+((y0-y)<<6))=Col
   Work(x0-x+((y0-y)<<6))=Col
   Work(x0+y+((y0+x)<<6))=Col
   Work(x0-y+((y0+x)<<6))=Col
   Work(x0+y+((y0-x)<<6))=Col
   Work(x0-y+((y0-x)<<6))=Col
   Inc y
   If dOv2 <= 0 Then
     Inc dOv2, y*2+1 ' Change in decision criterion for y -> y +1
   Else
     Inc x,-1
     Inc dOv2,(y-x)*2+1 '  Change for y -> y +1, x -> x -1
   End If
 Loop
End Sub

'-----------------------------------------------------------------
' draws a line with bresenham from the coordinates x0,y0 to x1,y1
' from the net
'-----------------------------------------------------------------
Sub DrawLine(x0%,y0%,x1%,y1%,cid%)
 Local integer dx= Abs(x1%-x0%),sx=Choice(x0%<x1%,1,-1)
 Local integer dy=-Abs(y1%-y0%),sy=Choice(y0%<y1%,1,-1)
 Local integer er=dx+dy,e2
 Do
  Work(x0%+(y0%<<6))=CrTb(cid%)
  If (x0%=x1%)And(y0%=y1%) Then Exit Do
  e2=er<<1
  If (e2>=dy)Then Inc er,dy: Inc x0%,sx
  If (e2<=dx)Then Inc er,dx: Inc y0%,sy
 Loop
End Sub

Sub DrawRecFill(x% ,y%, w%, h%, col%)
Local integer i,j
 For  i= 0 To h%-1   '               *64      *8
   Memory Set Integer WAdr+((((y%+i)<<6)+x%)<<3),col%,w%
   'memory set is not very save!!!! but quick if w% > 0
   'For j = 0 To w%-1     'save but slow
   '  Work(x%+j+((y%+i)<<6))=col%
   'Next j
 Next i
End Sub

Sub DrawRecHoll(x%, y%, w%, h%, col%)
Local integer i
 'memory set is not very save!!! but quick if w% > 0
  Memory Set Integer WAdr+((( y%      <<6)+x%)<<3),col%,w% 'top
  Memory Set Integer WAdr+((((y%+h%-1)<<6)+x%)<<3),col%,w% 'down
  'For i = 0 To w%-1         'save but slow
  '  Work(x%+i+ (y%<<6))=col%
  '  Work(x%+i+((y%+h%-1)<<6))=col%
  'Next i
  For i = 1 To h%-2
    Work(x%+((y%+i)<<6))=col%       'left
    Work(x%+w%-1+((y%+i)<<6))=col%  'right
  Next i
End Sub

Sub DrawPixel(x%,y%,c%)
  Work(x%+(y%<<6))=c%
  'in preparation to switch to byte-oriented displayarea
  'Memory Set Integer WAdr+((((y%)<<6)+x%)<<3),CrTb(c%),1
End Sub

Sub DrawCls()
  Memory Set Integer WAdr, 1, 2048 'black transparent
End Sub

'------------------------------------------------------------------------------|
Sub StartHub75Pio()
  PIO dma tx 1,0,0,Pack(),,,512 '32 bit transfers, do for ever
End Sub

Sub InitHub75Pio()
  SetPin gp0,pio1 ' out RED0
  SetPin gp1,pio1 ' out RED1
  SetPin gp2,pio1 ' out GREEN0
  SetPin gp3,pio1 ' out GREEN1
  SetPin gp4,pio1 ' out BLUE0
  SetPin gp5,pio1 ' out BLUE1
  SetPin gp6,pio1 ' out A
  SetPin gp7,pio1 ' out B
  SetPin gp8,pio1 ' out C
  SetPin gp9,pio1 ' out D
  SetPin gp10,pio1' out E
  SetPin gp11,pio1' sideset CLK
  SetPin gp12,pio1' set LATCH
  SetPin gp13,pio1' set /OE
 'pull = 32 bit ; out-shiftdir is right
 'YRrGgBb0 0RrGgBb0 0RrGgBb0 0RrGgBbX ->
 'X marks BOS(BeginOfSequence),Y marks EOL(EndOfLine)
  PIO CLEAR 1
  PIO ASSEMBLE 1, ".program data"
  PIO ASSEMBLE 1, ".line 0"
  PIO ASSEMBLE 1, ".side_set 1"
  PIO ASSEMBLE 1, ".wrap target"
  PIO ASSEMBLE 1, "line:"
  PIO ASSEMBLE 1, "out x,    1  side 0 "    '1 if there is a BOS,it is here
  PIO ASSEMBLE 1, "jmp !x,NoBos side 0 "    'jump over next step if no BOS
  PIO ASSEMBLE 1, "irq set 1    side 0 "    'BeginOfSequence -> sync SM-ctrl
  PIO ASSEMBLE 1, "NoBos:"
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '6 shift RrGgBb-data from osr
  PIO ASSEMBLE 1, "out null, 2  side 1 [1]" 'clk+2 no data
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '6 shift RrGgBb-data from osr
  PIO ASSEMBLE 1, "out null, 2  side 1 [1]" 'clk+2 no data
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '2 shift RrGgBb-data from osr
  PIO ASSEMBLE 1, "out null, 2  side 1 [1]" 'clk+2
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '6 shift RrGgBb-data from osr
  PIO ASSEMBLE 1, "out y,    1  side 1 [1]" 'clk+if there is an EOL,it is here
  PIO ASSEMBLE 1, "jmp !y,line  side 0 "    'no EOL->continue
  PIO ASSEMBLE 1, "irq set 2    side 0 [4]" 'EndOfLine-> SM-ctrl:need some time
  PIO ASSEMBLE 1, ".wrap"                   '3ticsx64pixs = 192 tics-max delay??
  PIO ASSEMBLE 1, ".end program"' list"
 'init data must be global for re-init in PIO TX IRQ
  Dim integer Exe0 = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  Dim integer Pin0 = Pio(pinctrl 1,0,6,,gp11,,gp0)' add setpin for debug
  Dim integer Shi0 = Pio(shiftctrl 0,0,0,1,0,1)'InShDir(l),OutShDir(r)
  Dim integer Fre0 = 9700000' ~1.66ms(600Hz) for the page (3 x 1bit-frame)
  PIO init machine 1,0,Fre0,Pin0,Exe0,Shi0,0,1,1,1'side_set-,set-,outDir=out
 'only the second PIO waits for IRQs(BOS,EOL), beware from Deadlock
 'X = Frame-Level, 2 for bit1, 1 for bit0, up to 15 if 5bits(16*9delay=144)
 'Y = address of line, startval 7(1/8), 15(1/16er), 31(1/32)scan
  PIO ASSEMBLE 1, ".program ctrl"
  PIO ASSEMBLE 1, ".line 13"
  PIO ASSEMBLE 1, ".wrap target"
  PIO ASSEMBLE 1, "start:"            'begin of sequence for jmp
  PIO ASSEMBLE 1, "wait 1 irq 1"      'wait for BOS(BeginOfSequence)
  PIO ASSEMBLE 1, "set x, 2"          '2^(Frame-1)in sequence: show msb first!
  PIO ASSEMBLE 1, "mov OSR, x"        'save frames-level, also to shift(/2)
  PIO ASSEMBLE 1, "frame:"            'one sequence => some frames(2bit:2frames)
  PIO ASSEMBLE 1, "set y, 15"         'reset line-adr; scan: 1/16(15),1/32(31)
  PIO ASSEMBLE 1, "line:"             'output of pixel-data is in SM-data
  PIO ASSEMBLE 1, "wait 1 irq 2  "    'wait for EOL(EndOfLine) from SM-data
  PIO ASSEMBLE 1, "set pins, &b11"    '1. /OE off, latch on
  PIO ASSEMBLE 1, "mov pins,y    "    '2. out new address(ABCDE)
  PIO ASSEMBLE 1, "set pins, &b00"    '3. /OE on, latch off
  PIO ASSEMBLE 1, "mov x,OSR"         'reload level for the delay of this line
  PIO ASSEMBLE 1, "delay:"            'check future: wait EndOfShow from SM-data
  PIO ASSEMBLE 1, "nop            [31]"'calc: max.level*dly must < 150(tested)
' PIO ASSEMBLE 1, "nop            [31]"'use no sync-irq(shown) to SM-data
' PIO ASSEMBLE 1, "nop            [13]"'danger of DeadLock !!!
  PIO ASSEMBLE 1, "jmp x--,delay"     'SM-data is already working
  PIO ASSEMBLE 1, "set pins, &b10"    '/OE off, latch off
  PIO ASSEMBLE 1, "jmp y--,line"      'dec adr for next line
  PIO ASSEMBLE 1, "out null,1   "     'one frame finished -> dec framelevel(/2)
  PIO ASSEMBLE 1, "mov x,OSR"         'reload for compare
  PIO ASSEMBLE 1, "jmp !x, start" 'there are no more frames in the sequence.Trys
  PIO ASSEMBLE 1, "jmp frame"     'with "jmp !OSRE frame" did not work because
  PIO ASSEMBLE 1, ".wrap"         'OSRE counts the outs since last pull, not val
  PIO ASSEMBLE 1, ".end program"' list"

  Dim integer Exe1 = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  Dim integer Pin1 = Pio(pinctrl 0,2,5,,,gp12,gp6)' add setpin for debug
  PIO init machine 1,1,Fre0,Pin1,Exe1,Shi0,13,1,1,1'side_set-,set-,outDir=out
  PIO start 1,1 '"crtl" starts first and wait immediately for irq from "data"
End Sub 'InitHub75Pio()

Sub DupD() 'DisplayUpDate, then we need it not in every sub/function
' tic1 = Timer
  Pack4Hub(2048) 'pack,mix and save in ringbuffer
' tic2 = Timer
' Print tic2-tic1
End Sub

Sub Pack4Hub( size As integer)
 'pack and interlace Work()-data to Hub75-PIO DMA-array(Pack())
 Memory pack  WAdr, UAdr, size>>1,8 '00123456 for example bitnames at start
 Memory pack  VAdr, DAdr, size>>1,8 '00ABCDEF
 'shift, mask and add Uppr(),Down() to seperate bits in mixed arrays
 Memory set pAdM,&b01110000,size>>1 'bit1:(MSB)01230000>>0+0ABC0000>>3->x123ABCx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask first bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask first bits from down
 Math shift Tmp2(),    -3,Tmp2(),u 'unsigned shift down right!!!!!!
 Math c_OR Tmp2(),Tmp1(),Tmp1()     'add up and down
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Tmp1(0)=Tmp1(0) Or &h1             'now add BeginOfSequence(BOS)-flag
 Memory copy integer pTmp,pAA0,size>>4,1,1 'copy first part to ringbuffer
 Memory set pAdM,&b00001110,size>>1 'bit0:(LSB)00004560<<3+0000DEF0>>3->x456DEFx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask second bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask second bits from down
 Math shift Tmp1(),     3,Tmp1()    'shift them left
 Math c_OR Tmp1(),Tmp2(),Tmp1()     'add down and up
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Memory copy integer pTmp,pAA1,size>>4,1,1 'copy second part to ringbuffer
End Sub 'Pack4Hub()

Sub MyInit()
Local Integer actP 'act. position must be counted because variable width
Local Integer i,j,x,y
Local Integer FCnt, RCnt, CCnt
 ' could be more by 6bit
 '                 rgb
 CrTb( 0)= RGB222(0,0,0) 'black
 'black->red
 CrTb( 1)= RGB222(1,0,0)
 CrTb( 2)= RGB222(2,0,0)
 CrTb( 3)= RGB222(3,0,0)
 'red->blue
 CrTb( 4)= RGB222(3,0,1)'
 CrTb( 5)= RGB222(2,0,1)'
 CrTb( 6)= RGB222(2,0,2)'
 CrTb( 7)= RGB222(1,0,2)'
 CrTb( 8)= RGB222(0,0,3)'
 'blue->green
 CrTb( 9)= RGB222(0,1,3)'
 CrTb(10)= RGB222(0,1,2)'
 CrTb(11)= RGB222(0,2,2)'
 CrTb(12)= RGB222(0,2,1)'
 CrTb(13)= RGB222(0,3,0)'
 'green->yellow
 CrTb(14)= RGB222(1,3,0)'
 CrTb(15)= RGB222(1,2,0)'
 CrTb(16)= RGB222(2,2,0)'
 CrTb(17)= RGB222(2,1,0)'
 CrTb(18)= RGB222(3,0,0)'
 'yellow->white
 CrTb(19)= RGB222(1,1,1)'
 CrTb(20)= RGB222(2,2,2)'
 CrTb(21)= RGB222(3,3,3)'

'init EOL-mask. Have to be changed when wider displays are used
 For j = 0 To 15 'every line
   AdrM((j*8)+7) = &h8000000000000000'EOL
 Next j

 'read fontdata --------------------------------------------------------------|
 Restore fHead
 Read FSize '
 Read FRows '
 Read FCnt  'FontCount
 RCnt = 16-1'todo: get RCnt from data:but copying is more complicated if not 16
 Dim Integer MyFo(FSize-1) 'size should be at top of fontdata, just readed

 Restore fWidth   'go to width-info of font
 For i = 0 To FCnt-1
   Read FoIf(1,i) 'get width and store it to FontInfo-array
 Next i

 Restore fData 'go to fontpattern
 actP  = 0
 For i = 0 To FCnt-1
   FoIf(0,i) = Peek(VarAddr MyFo(actP))'get adress and store it
   CCnt = FoIf(1,i)-1    'ColCount is allready stored
   'new! packed 8bytes/integer
    Select Case FRows
    Case 1 To 8
      For j = 0 To (CCnt>>3) 'through the columns
        Read MyFo(actP) 'read 8 columns
        Inc actP
      Next j
    Case 9 To 16
      For j = 0 To (CCnt>>2) 'through the columns
        Read MyFo(actP) 'read four columns
        Inc actP
      Next j
    Case Else
      Print "??????????";
   End Select
 Next i
'------------------------------------------------------------------------------
'font Leelawadee_UI(202)size for array(pix)
fHead:
Data &h00CE 'size for array(hex)
Data &h10   'height
Data &h60   'char-count(ptr)
fData: '--------------------------------------------------------------------
Data &h0000000000000000                                                '20:
Data &h000078007F707F70                                                '21:!
Data &h7000000070007000, &h0000000000007000                            '22:"
Data &h7F000FE009E00100, &h7D007FE00BE07900, &h0000000000000900        '23:#
Data &hFFFC66307E303C60, &h000001E073F06330                            '24:$
Data &h447044107C003800, &h0EE007003B807CE0, &h01F04110711039F0        '>nl
Data &h00000000000000E0                                                '25:%
Data &h6E307E303BE001C0, &h39E07B706E306630, &h1E301F3003F001E0        '>nl
Data &h0000000000000030                                                '26:&
Data &h0000000070007000                                                '27:'
Data &h6006381C1FF807E0, &h0000000000004002                            '28:(
Data &h0FF03FFC780E4002                                                '29:)
Data &h78001E0034003000, &h0000300034001E00                            '2A:*
Data &h0FF0018001800180, &h0180018001800FF0                            '2B:+
Data &h00000030003C000C                                                '2C:,
Data &h0180018001800180                                                '2D:-
Data &h0000007000700070                                                '2E:.
Data &h07C001F0003C000C, &h0000600078001F00                            '2F:/
Data &h603070703FE01FC0, &h00001FC03FE07070                            '30:0
Data &h7FF0300018000000, &h0000000000007FF0                            '31:1
Data &h633061B030F00070, &h00003C307E306330                            '32:2
Data &h6630663070700000, &h000039E07FE06630                            '33:3
Data &h38C00CC007C003C0, &h000000C07FF07FF0                            '34:4
Data &h66307E307E700060, &h000003C067E06630                            '35:5
Data &h663072303FE00FC0, &h000003C067E06630                            '36:6
Data &h67C061F060306000, &h0000600078007E00                            '37:7
Data &h663067307FF039E0, &h000039E07FF06730                            '38:8
Data &h633063303F301E00, &h00001F803FE06270                            '39:9
Data &h000000000E700E70                                                '3A::
Data &h00000E700E780018                                                '3B:;
Data &h06C0028003800100, &h00000C60044006C0                            '3C:<
Data &h06C006C006C006C0, &h000006C006C006C0                            '3D:=
Data &h06C006C004400C60, &h0000010003800280                            '3E:>
Data &h6770637060703000, &h0000000038007C00                            '3F:?
Data &h13D81C300FE007C0, &h27E82428242837E8, &h0FC01860302827E8        '>nl
Data &h0000000000000780                                                '40:@
Data &h1FC007F000F00010, &h3FC07CC060C07CC0, &h0000001000F007F0        '41:A
Data &h663066307FF07FF0, &h39C07BE066706630                            '42:B
Data &h603030703FE00F80, &h3060707060306030                            '43:C
Data &h603060307FF07FF0, &h38E0707060306030, &h000000000F803FC0        '44:D
Data &h663066307FF07FF0, &h0000603066306630                            '45:E
Data &h630063007FF07FF0, &h0000000063006300                            '46:F
Data &h703038601FE00F80, &h63F0633063306030, &h00000000000073E0        '47:G
Data &h060006007FF07FF0, &h7FF0060006000600, &h0000000000007FF0        '48:H
Data &h000000007FF07FF0                                                '49:I
Data &h7FE0003000300030, &h0000000000007FC0                            '4A:J
Data &h0F8006007FF07FF0, &h6030707079F01FC0, &h0000000000004010        '4B:K
Data &h003000307FF07FF0, &h0000000000300030                            '4C:L
Data &h7F0078007FF07FF0, &h07E000F001F00FE0, &h7FF07FF078003F00        '4D:M
Data &h1C0078007FF07FF0, &h00F001C007800F00, &h000000007FF07FF0        '4E:N
Data &h603030603FE00F80, &h3060603060306030, &h000000000F803FE0        '4F:O
Data &h630063007FF07FF0, &h3C003E0063006300                            '50:P
Data &h603030603FE00F80, &h307C603060306030, &h000000040F8C3FFC        '51:Q
Data &h630063007FF07FF0, &h3C307EF067E063C0, &h0000000000000010        '52:R
Data &h673066303E303C70, &h000071E063E06330                            '53:S
Data &h7FF0600060006000, &h6000600060007FF0                            '54:T
Data &h003000707FE07FC0, &h7FE0007000300030, &h0000000000007FC0        '55:U
Data &h1FE07F0078004000, &h1FE003F0003003F0, &h0000400078007F00        '56:V
Data &h0FF07FC07E006000, &h7C003FC003F00070, &h007007F07F807C00        '>nl
Data &h60007E007FC007F0                                                '57:W
Data &h3FE078F060304010, &h78F03FE00F800F80, &h0000000040106070        '58:X
Data &h3E00780070004000, &h78001E0007F00FF0, &h0000000040007000        '59:Y
Data &h63F060F060706030, &h78307E306F3067B0, &h0000000060307030        '5A:Z
Data &h600660067FFE7FFE                                                '5B:[
Data &h0F803E0078006000, &h000C003C00F803E0                            '5C:\
Data &h7FFE7FFE60066006                                                '5D:]
Data &h60003C000F000300, &h000003000F003C00                            '5E:^
Data &h0004000400040004, &h0000000400040004                            '5F:_
Data &h60004000C0008000, &h0000000000002000                            '60:`
Data &h0D300DB00DF000E0, &h000007F00FF00D20                            '61:a
Data &h0C300620FFF0FFF0, &h03C00FE00C700C30                            '62:b
Data &h0C300E7007E003C0, &h000000000C700C30                            '63:c
Data &h0C300E7007E003C0, &hFFF0FFF004600C30                            '64:d
Data &h0DB00DB007E003C0, &h000003800FB00DB0                            '65:e
Data &hCC00FFF07FF00C00, &h000000000000CC00                            '66:f
Data &h0C330E7307E703C0, &h0FFC0FFE04670C33                            '67:g
Data &h0C000400FFF0FFF0, &h000007F00FF00C00                            '68:h
Data &h00000000EFF0EFF0                                                '69:i
Data &h0000EFFCEFFF0003                                                '6A:j
Data &h03C00180FFF0FFF0, &h08100C300E7007E0                            '6B:k
Data &h00000000FFF0FFF0                                                '6C:l
Data &h0C0004000FF00FF0, &h040007F00FF00C00, &h07F00FF00C000C00        '6D:m
Data &h0C0004000FF00FF0, &h000007F00FF00C00                            '6E:n
Data &h0C300E7007E003C0, &h03C007E00C300C30                            '6F:o
Data &h0C3006200FFF0FFF, &h03C00FE00C700C30                            '70:p
Data &h0C300E7007E003C0, &h0FFF0FFF04600C30                            '71:q
Data &h0C0006000FF00FF0, &h0000000000000C00                            '72:r
Data &h0DF00DB00FB00730, &h0000000000000CE0                            '73:s
Data &h0C303FF03FE00C00, &h0000000000000C30                            '74:t
Data &h003000300FF00FE0, &h00000FF00FF00020                            '75:u
Data &h03F00FE00F000800, &h0F000FC003F00030, &h0000000000000800        '76:v
Data &h00F00FF00F800C00, &h0FC00C000FC000F0, &h0F8007F0007003F0        '>nl
Data &h0000000000000C00                                                '77:w
Data &h07E00FF00C300810, &h0C300FF007E00180, &h0000000000000810        '78:x
Data &h03FF0FC30F030803, &h0F000FC001F8007E, &h0000000000000800        '79:y
Data &h0DF00CF00C700C30, &h0C300E300F300FB0                            '7A:z
Data &h40027EFE3FFC0100                                                '7B:{
Data &h00000000FFFFFFFF                                                '7C:|
Data &h01003FFC7EFE4002                                                '7D:}
Data &h6C0044006C003800, &h0000000000003800                            '7E:~
Data &hFFFFFFFFFFFFFFFF, &hFFFFFFFFFFFFFFFF, &hFFFFFFFFFFFFFFFF        '>nl
Data &hFFFFFFFFFFFFFFFF                          'block for 16x16 pics  7F:
fWidth: '-------------------------------------------------------------------
Data &h01, &h03, &h05, &h09, &h07, &h0D, &h0D, &h02, &h05, &h04, &h07, &h08
Data &h03, &h04, &h03, &h07, &h07, &h07, &h07, &h07, &h07, &h07, &h07, &h07
Data &h07, &h07, &h02, &h03, &h07, &h07, &h07, &h06, &h0D, &h0B, &h08, &h08
Data &h0A, &h07, &h06, &h09, &h09, &h02, &h05, &h09, &h06, &h0C, &h0A, &h0A
Data &h08, &h0B, &h09, &h07, &h08, &h09, &h0B, &h10, &h0A, &h0A, &h0A, &h04
Data &h08, &h04, &h07, &h07, &h05, &h07, &h08, &h06, &h08, &h07, &h05, &h08
Data &h07, &h02, &h03, &h08, &h02, &h0C, &h07, &h08, &h08, &h08, &h05, &h05
Data &h05, &h07, &h09, &h0D, &h09, &h09, &h08, &h04, &h02, &h04, &h05, &h0F
End Sub 'MyInit()

'helper ----------------------------------------------------------------------

Function RGB222(R%,B%,G%) As integer
'lsb for transparency(multilayer), msb is empty at the moment (RGB555T)
Local res%                                 '-1 because bit1 already shifted
   res% =        ((R% And 1)<<1)+((R% And 2)<<3)
   res% = res% Or((G% And 1)<<2)+((G% And 2)<<4)
   res% = res% Or((B% And 1)<<3)+((B% And 2)<<5)
   RGB222 = res%
End Function                                                                                                                       