'HUB75 test 12bit color 4bit per component(rgb444)and some fill bits = 1byte   |
' tested with P3(2121)64X64-32S-6.0 from AE
' gp0  RED0              Connection HUB75
' gp1  GREEN0
' gp2  BLUE0                  +----+
' gp3  RED1              RED0 |1 16| GREEN0
' gp4  GREEN1           BLUE0 |2 15| GND
' gp5  BLUE1             RED1 |3 14| GREEN1
' gp6  A                BLUE1  4 13| E
' gp7  B                    A  5 12| B
' gp8  C                    C |6 11| D
' gp9  D                  CLK |7 10| LATCH
' gp10 E                  /OE |8  9| GND
' gp11 CLK                    +----+
' gp12 LATCH
' gp13 /OE
' The reduction to only 12bit to minimize the time for preparing
' display-data (pack and mix now~7ms)2040 @48MHz.
'-----------------------------------------------------------------------------|
Option EXPLICIT
Option DEFAULT NONE
' vars for display: buffers and PIO-calculation
Dim Integer FInf(2,3) '??array to save pic-info aIdx | adr,size,width,height
Dim integer Work(4095) '32raw*64col only 2bit/(RGB), pack first 8x8 in 2 parts
'Dim integer Back(4095) not enough heap for Back/Bmp-Layer on rp2040

Dim integer StrB(1024-1) 'char height x display wide 16x64
Dim integer StBg(1024-1) 'char height x display wide 16x64

Dim integer ChrB(256-1)  'for unpack+coloring  max 16x16
'pack to
Dim integer Uppr(511) 'data packed 16
Dim integer Down(511) 'data packed 16

'for mask and shift
Dim integer AdrM(511) 'EOL mask;                fix after init
Dim integer AddM(511) 'holds the bitmask        not fix
Dim integer Tmp1(511) 'for temporary results    not fix
Dim integer Tmp2(511) 'for temporary results    not fix
'for save displaydata
Dim integer Pack
PIO make ring buffer Pack,1024*8  'in bytes by 4bit/color

'pointer: used for memory copy
Dim integer WAdr = Peek(VarAddr Work(0))    'upper org (integer 64bit)
Dim integer VAdr = Peek(VarAddr Work(2048)) 'lower org (integer 64bit)
Dim integer UAdr = Peek(VarAddr Uppr())     'pointer to upper
Dim integer DAdr = Peek(VarAddr Down())     'pointer to lower
Dim integer pAdM = Peek(VarAddr AddM())     'pionter to bit-mask
Dim integer pTmp = Peek(VarAddr Tmp1())     'pointer because of copy
Dim integer pAA0 = Peek(VarAddr Pack(0))    'pointer because of copy
Dim integer pAA1 = Peek(VarAddr Pack(256))  'pointer because of copy
Dim integer pAA2 = Peek(VarAddr Pack(512))  'pointer because of copy
Dim integer pAA3 = Peek(VarAddr Pack(768))  'pointer because of copy
'font vars
Dim integer pStB = Peek(VarAddr StrB())     'for copy str.pattern to Work()
Dim integer pChB = Peek(VarAddr ChrB())     'for unpack char-pattern
Dim Integer FSize, FRows 'for font
Dim Integer FoIf(2,95,1) 'FontInfo  integer/char  address,width,height(byte)
Const Fo16=0 'font-nr
Const Fo8 =1
'ColorTable
Const c_bk=0,c_re=1,c_gr=2,c_bl=3,c_ye=4,c_ma=5,c_cy=6,c_wr=7,c_gb=8,c_gd=9
Dim integer CrTb(56) '10 base, 47 gradient
'--------------------
Dim float Tic1,Tic2 'for debugging

'display start ----------------------------------------------------------------|
MyInit() 'init EOL-Mask and ColorTable
DupD()   'init buffer before start: blank with BOS and EOLs by "first save"

'init one PIO prog
'there is a problem with "DMA TX off",I can not stop/restart after Ctrl+C
If MM.Info(PIO TX DMA) Then
  Print "PIO TX DMA still running !!!!"
  PIO DMA TX OFF
  Pause 100
  PIO stop 1,0
  Pause 100
  If MM.Info(PIO TX DMA) Then Print "reset Pico": CPU RESTART
End If

InitHub75Pio()' with PIO CLEAR 1
StartHub75Pio()'start with ringbuffer

'tics--------------------------------------------------------------------------|
'SetTick   30,DupD  ,1 'DisplayUpDate: makes a display-flush every 30ms
'later

'-application consts/vars -----------------------------------------------------|
' all over the place, only for demonstration
Dim integer i,j,k,l,m,  w,h ,c,s
Dim float  a,b,z,r
Dim string TmpStr
Dim integer tops(15)= (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)

' application start -----------------------------------------------------------|
j = 1
k = 1
Do 'main loop
  /* 
  HubClearScr(0) 'for display test
  HubStringBox(Fo8,"colortest", 10,55, 63, CrTb(c_gb))
  For i = 0 To 14
    HubDrawRecFill(i*4, 0,4,10,RGB444(i+1,0,0))
    HubDrawRecFill(i*4,10,4,10,RGB444(0,i+1,0))
    HubDrawRecFill(i*4,20,4,10,RGB444(0,0,i+1))
    HubDrawRecFill(i*4,30,4,10, CrTb(i))
  Next i
  DupD(): Pause 1000
  HubClearScr(0)
  End
  For i = 0 To 2 'flashing
    HubStringBox(Fo8,"pixeltest", 10,55, 53, CrTb(c_gb))
    DupD()
    Pause 300
    HubClearScr(0)
    DupD()
    Pause 300
  Next i
  HubClearScr(0)
  HubStringBox(Fo8,"red",2,55, 61, CrTb(c_re))
  DupD():  Pause 500
  HubClearScr(CrTb(c_re))
  DupD(): Pause 1000
  HubClearScr(0)
  HubStringBox(Fo8,"blue", 2,55, 61, CrTb(c_bl))
  DupD():  Pause 500
  HubClearScr(CrTb(c_bl))
  DupD(): Pause 1000
  HubClearScr(0)
  HubStringBox(Fo8,"blue", 2,55, 61, CrTb(c_gr))
  DupD():  Pause 500
  HubClearScr(CrTb(c_gr))
  DupD(): Pause 1000
  */
'start -------------------------------------------
  HubClearScr(0)
  z = 0.4
  For i = 0 To 23
    r= 20-i/10
    w=r*Sin(z)
    h=r*Cos(z)
    HubDrawChar(Fo16,"S",32+w,19+h,CrTb(c_re))
    HubDrawChar(Fo16,"t",   i,47-i,CrTb(c_bl))
    HubDrawChar(Fo16,"a", 6+i, 1+i,CrTb(c_gr))
    HubDrawChar(Fo16,"r",60-i,47-i,CrTb(c_ye))
    HubDrawChar(Fo16,"t", 43,  1+i,CrTb(c_ma))
    DupD():Pause 30
    If i < 23 Then HubClearScr(0)
    Inc z,0.2 'for spiral "S"
  Next i
  Pause 1000
'move out Right
  For i = 0 To 48
     ScrMoveRight(28,38)'area
     DupD()
     Pause 30
  Next i
'welcome
  HubStringBox(Fo8,"welcome to" , 4,55, 60, CrTb(c_wr))
  HubStringBox(Fo8,"my Hub75" , 10,47, 51, CrTb(c_gr))
  HubDrawChar(Fo16,"D"          , 6,31,rgb444(15,7,7)))
  HubDrawChar(Fo16,"E"          ,20,31,rgb444(7,15,7)))
  HubDrawChar(Fo16,"M"          ,31,31,rgb444(7,7,15)))
  HubDrawChar(Fo16,"O"          ,47,31,CrTb(c_ye))
  HubStringBox(Fo8,Day$(now)    , 0,17, 63, CrTb(c_cy))
  HubStringBox(Fo8,Date$        , 0, 9, 63, rgb444(0,13,7))
  HubDrawRecFill(0,0,64,9,rgb444(7,7,0)))
  For i = 0 To 86
   HubStringBox(Fo8,"with 2 fonts and 4096 colors ",2,25,60,CrTb(5),0,-i)
   HubStringBox(Fo8,Time$ ,10, 0, 63, rgb444(0,0,14),rgb444(7,7,0))
   DupD()
   Pause 10
  Next i
  For i = 1 To 55
    HubStringBox(Fo8,"4096 colors ",1,25,62,CrTb(i))
    HubStringBox(Fo8,Time$ ,10, 0, 63, rgb444(0,0,14),rgb444(7,7,0))
   DupD()
   Pause 30
  Next i
  Pause 1000
'wipe out lines
  For i = 0 To 8
    BoxScrollUp(  0,56,63,63)
    BoxScrollUp(  0,48,63,55)
    BoxScrollUp(  0,40,63,47)
    BoxScrollUp(  0,33,63,39)
    BoxScrollUp(  0,25,63,32)
    BoxScrollDown(0,17,63,24)
    BoxScrollDown(0, 9,63,16)
    BoxScrollDown(0, 0,63, 8)
    DupD()
    Pause 40
  Next i
  Pause 300
'info basics
 For i = 0 To 104
   HubStringBox(Fo8," what can we do with this ??? ",1,25,62,CrTb(6),0,-i)
   DupD()
   Pause 10
 Next i
 Pause 1000
 HubClearScr(0)
 For i = 0 To 64
   HubStringBox(Fo8," first" ,6,45,62,CrTb(4),0,-56+i)
   HubStringBox(Fo8,"  the"  ,7,35,62,CrTb(5),0,-56+i)
   HubStringBox(Fo8," basics",5,25,62,CrTb(6),0,-56+i)
   HubStringBox(Fo8,"  !!!"  ,9,15,62,CrTb(7),0,-56+i)
   DupD()
   Pause 15
 Next i
 Pause 1000
 HubClearScr(0)
'bars vertical
  For i = 0 To 40
    For j = 0 To 12
      k = 14+Sin((i+j/2))*14 '0-28
      HubDrawRecFill(0  ,j*5, 63     ,4,CrTb(j+35))
      HubDrawRecFill(3+k,j*5,(58-k*2),4,CrTb(c_bk))
    Next j
    DupD()
    Pause 40
  Next i
  Pause 100
'bars horizontal
  For i = 0 To 163'32
    For j = 0 To 7
      k = 28+Sin((i/11+j/4))*26 '0-28 64-8-2->54/2->27 max
      w = 20+Cos((i/7+j/4))*18 '0-28
      If Tops(j)  <=k Then Tops(j)  =k Else Inc Tops(j),-1'=(Tops(j)+k+4)
      If Tops(j+8)<=w Then Tops(j+8)=w Else Inc Tops(j+8),-1
      HubDrawHLine(  j*8,Tops(j)  ,3,CrTb(c_re))
      HubDrawHLine(4+j*8,Tops(j+8),3,CrTb(c_bl))
      HubDrawRecFill(j*8  , 0, 3,k, CrTb(j+10))
      HubDrawRecFill(j*8+4, 0, 3,w, CrTb(j+25))
    Next j
    DupD()
    'Pause 10
    HubClearScr(CrTb(c_gd))
    HubStringBox(Fo16,"BLACK", 8, 38, 50,CrTb(c_bk),CrTb(c_gd))
  Next i
  HubClearScr(0)
  Pause 100
'plas first fill
  HubClearScr(0)
  HubStringBox(Fo8,"calculate",12,40,51,rgb444(4,8,8))
  DupD()
  z = -100
  For i = 0 To 63
    Inc z,0.01
    b = 50+Sin(z*2)*50
    For k = 10 To 73
      a = Sin(b/5)+Cos((b+k)/11)+Log(i+k)
      HubDrawPixel(k-10,i,CrTb(10+(a*12)Mod 47))
    Next k
    'DupD()
  Next i
'plas move and fill
  For j = 0 To 290
    ScrMoveDown()
    Inc z,0.01
    b = 50+Sin(z*2)*50
    For k = 10 To 73
      a = Sin(b/5)+Cos((b+k)/11)+Log(i+j+k)
      HubDrawPixel(k-10,63,CrTb(10+(a*12)Mod 47))
    Next k
    DupD()
  Next j
  Pause 1000
  HubDiaClear(0)
'munching
  For w = 8 To 23
    For h = 8 To 23
      c=(w Xor h) And 15
      HubDrawRecFill(w*2 ,h*2, 2, 2, rgb444(c,c,c))
  Next h,w
  DupD()
  For w = 0 To 7
    For h = 8 To 23
      c=(w Xor h) And 15
      HubDrawRecFill(w*2 ,h*2, 2, 2, rgb444(0,0,c))
  Next h,w
  DupD()
  For w = 0 To 15
    For h = 24 To 31
      c=(w Xor h) And 15
      HubDrawRecFill(w*2 ,h*2, 2, 2, rgb444(c,c,0))
  Next h,w
  DupD()
  For w = 16 To 31
    For h = 24 To 31
      c=(w Xor(55-h)) And 15
      HubDrawRecFill(w*2 ,h*2, 2, 2, rgb444(0,c,c))
  Next h,w
  DupD()
  For w = 24 To 31
    For h = 8 To 23
      c=((w)Xor(31-h)) And 15
      HubDrawRecFill(w*2 ,h*2, 2, 2, rgb444(c,0,c))
  Next h,w
  DupD()
  For w = 16 To 31
    For h = 0 To 7
      c=(w Xor h) And 15
      HubDrawRecFill(w*2 ,h*2, 2, 2, rgb444(0,c,0))
  Next h,w
  DupD()
  For w = 0 To 15
    For h = 0 To 7
      c=(w Xor(7-h)) And 15
      HubDrawRecFill(w*2 ,h*2, 2, 2, rgb444(c,0,0))
  Next h,w
  DupD()
  Pause 500
  HubCombClear(1,0)'0:hori 1:verti
'phases
  HubClearScr(0)
  HubStringBox(Fo8,"static top",4,50,59,rgb444(5,0,15))
  HubStringBox(Fo8,"and footer",4,2,59,rgb444(15,0,5))
  For i = 0 To 300
     ScrMoveLeft(20,40)'area
     HubDrawPixel(62,30+Sin(i/15)*8,CrTb((i Mod 45)+10))
     HubDrawPixel(62,30+Cos(i/8)*6, CrTb(((i+15)Mod 45)+10))
     HubDrawPixel(62,30-Sin(i/9)*10,CrTb(((i+30)Mod 45)+10))
     DupD()
     Pause 5
  Next i
  HubClearScr(0)
  DupD()
'rnd char
  For i = 0 To 150
    HubDrawChar(Fo16,Chr$(64+Rnd*27), Rnd*48, Rnd*48,CrTb(Rnd*56))
    DupD()
    'Pause 500
  Next i
  HubClearScr(0)
'rnd circle
  For i = 0 To 100
    h = 4+Rnd*10
    HubDrawCircle(h+(Rnd*(63-h*2)),h+(Rnd*(63-h*2)),h,CrTb(Rnd*56))
    DupD()
  Next i
  HubClearScr(0)
'rnd fullcircle
  For i = 0 To 100
    h = 4+Rnd*10
    HubDrawCircleFill(h+(Rnd*(63-h*2)),h+(Rnd*(63-h*2)),h,CrTb(Rnd*56))
    DupD()
  Next i
  HubClearScr(0)
'rotate line
  For i = 0 To 63
   HubDrawLine( 0, 63-i, 63, i,CrTb((j Mod 45)+10))
   Inc j
   DupD()
   'Pause 30
  Next i
  For i = 0 To 63
   k = i
   HubDrawLine( k, 0, 63-k ,63,CrTb((j Mod 45)+10))
   Inc j
   DupD()
   'Pause 30
  Next i
  Pause 300
  HubCombClear(0,0)'0:hori 1:verti
'rnd rec
  For i = 0 To 200
    h = 4+Rnd*14
    w = 22-h
    HubDrawRecHoll(Rnd*(64-w),Rnd*(64-h),w,h,CrTb(Rnd*56))
    DupD()
    'Pause 30
  Next i
  HubClearScr(0)
'rnd fillrec
  For i = 0 To 200
    h = 4+Rnd*14
    w = 22-h
    HubDrawRecFill(Rnd*(64-w),Rnd*(64-h),w,h,CrTb(Rnd*56))
    DupD()
    'Pause 30
  Next i
'info picture
 HubClearScr(0)
 For i = 0 To 58
   HubStringBox(Fo8,"now "     ,17,55,46,CrTb(4),0,63-i)
   HubStringBox(Fo8,"some "    ,13,45,50,CrTb(5),0,63-i)
   HubStringBox(Fo8,"pictures ", 5,35,58,CrTb(6),0,63-i)
   HubStringBox(Fo8," !!! "    ,16,25,47,CrTb(7),0,63-i)
   DupD()
   Pause 10
 Next i
 'Pause 100
 For i = 0 To 180
   HubStringBox(Fo8," some should look familiar ",2,15,61,CrTb(2),0,50-i)
   DupD()
   Pause 10
 Next i
'picture
 Drive "A:"
 LoadBmp("Affe.bmp")
 DupD(): 'pause 1000
 LoadBmp("Tut.bmp")
 DupD(): 'Pause 1000
 LoadBmp("Frau2.bmp")
 DupD(): 'Pause 1000

 LoadBmp("Apfel.bmp")
 DupD(): 'pause 1000
 LoadBmp("BigBen.bmp")
 DupD(): 'Pause 1000
 LoadBmp("EisVog.bmp")
 DupD(): 'Pause 1000

 LoadBmp("C64.bmp")
 DupD(): 'Pause 1000
 LoadBmp("Clown.bmp")
 DupD(): 'Pause 1000
 LoadBmp("FoxHi.bmp")
 DupD(): Pause 000

 HubSpiralClear(0)
'flash end
  For i = 0 To 50 Step 1
   HubDrawChar(Fo16,"E", 18, 24 ,CrTb(10+(1+i)Mod 47))
   HubDrawChar(Fo16,"N", 27, 24 ,CrTb(10+(2+i)Mod 47))
   HubDrawChar(Fo16,"D", 39, 24 ,CrTb(10+(3+i)Mod 47))
   DupD()
   Pause 20
  Next i
  HubClearScr(0)
  DupD()
  End
Loop 'end main loop

'- subs/functions -------------------------------------------------------------|
Sub HubClearScr(Col%)
  Memory Set Integer WAdr, Col%, 4096 'black transparent
End Sub

Sub HubDiaClear(Col%)
  For i = 0 To 7
    h = i*8:w = 0
    Do While h>=0
      HubDrawRecFill(w,h,4,4,Col%)
      HubDrawRecFill(w,60-h,4,4,Col%)
      Inc w,4:Inc h,-4
    Loop
    DupD():Pause 30
  Next i
  For i = 0 To 7
    w = i*8+4:h = 60
    Do While w<61
      HubDrawRecFill(w,h,4,4,Col%)
      HubDrawRecFill(w,60-h,4,4,Col%)
      Inc w,4:Inc h,-4
    Loop
    DupD():Pause 30
  Next i
End Sub

Sub HubCombClear(ori%,Col%)
Local integer i,j
 If ori% Then 'vertical
   For i = 0 To 15
    For j = 0 To 7
      HubDrawRecFill(  j*8,60-i*4,4,4,Col%)
      HubDrawRecFill(4+j*8,   i*4,4,4,Col%)
    Next j
    DupD()
    Pause 30
   Next i
 Else  'horizontal
   For i = 0 To 15
    For j = 0 To 7
      HubDrawRecFill(60-i*4,  j*8,4,4,Col%)
      HubDrawRecFill(   i*4,4+j*8,4,4,Col%)
    Next j
    DupD()
    Pause 30
   Next i
 End If
End Sub 'comb clear

Sub HubSpiralClear(Col%)
Local integer w=60,h=60,k=0,l=4,i=0,j=0
 For m = 0 To 7
   Do While i<w
     HubDrawRecFill(i,j, 4, 4, Col%)
     DupD
     Pause 5
     Inc i,4
   Loop
   Do While j<h
     HubDrawRecFill(i,j, 4, 4, Col%)
     DupD()
     Pause 5
     Inc j,4
   Loop
   Do While i>k
     HubDrawRecFill(i,j, 4, 4, Col%)
     DupD()
     Pause 5
     Inc i,-4
   Loop
   Do While j>l
     HubDrawRecFill(i,j, 4, 4, Col%)
     DupD()
     Pause 5
     Inc j,-4
   Loop
   Inc w,-4: Inc h,-4: Inc k,4: Inc l,4
 Next m
 HubDrawRecFill(28,32,4,4,Col%) ' clear last tile
 DupD()
End Sub

Sub HubDrawChar(Fod%, C$, x%, y%, Col%)
Local Integer cId, sAdr, dAdr, FntL, FntH, i
  'before get char, get the info
  cId  = Asc(Mid$(C$,1,1))-32
  sAdr = FoIf( 0, cId, Fod%) 'start-adr 1st column of fontpattern
  FntL = FoIf( 1, cId, Fod%) 'fontLen from font.info
  FntH = FoIf( 2, cId, Fod%) 'fontHeight
  Memory unpack sAdr,pChB,FntL<<4,1 '16=4;8=3 'todo: get from font
  Math SCALE  ChrB(), Col%, ChrB()  'single color
  'char is in the box -> copy to screen: loopcount from height
  For i = 0 To FntH-1 'copy by line to work()  | y-offset      no  sinc dinc
    Memory Copy Integer pChB+(i<<3), WAdr+((((y%+i)<<6)+x%)<<3), FntL, FntH, 1
  Next i 'line
End Sub

Sub HubStringBox(Fod%,st$, x%,y%,w%,fCl%,bCl%,ofs%)'str,x,y,wide,fCl,bCl,offset
Local integer StLn, idx, tLen, cId, FntH, FntL
  Math Set 0, StrB() 'clear buffer
  FntH = FoIf( 2, 1, Fod%)    'fontHeight any char
  StLn = ofs%'0
  tLen = Len(st$)
  'Math Set 0,StrB()
  idx = 1
  Do While(idx<tLen+1)And(StLn<w%)
    cId = Asc(Mid$(st$,idx,1))
    FntL = FoIf(1,cId-32,Fod%)'fontLen from font.info
    If StLn+FntL<1 Then
      Inc StLn,FntL+1
    Else
      StLn = BoxDrawChar(Fod%,cId, StLn+1, w%)
    End If
    Inc idx
  Loop
  'now color it/ new with background-color
  If bCl% Then
    Math Set 1,StBg()
    Math C_Xor  StBg(),StrB(),StBg() 'invert char-pattern to background
    Math SCALE  StBg(), bCl%, StBg() 'color all than char with backColor
    Math SCALE  StrB(), fCl%, StrB() 'color char with frontColor
    Math C_Or   StrB(),StBg(),StrB() 'merge front and back
  Else
    Math SCALE  StrB(), fCl%, StrB() 'single color
  End If
  'copy result to screen
  For idx = 0 To FntH-1 'copy by line to work()  | y-offset        no  sinc dinc
    Memory Copy Integer pStB+(idx<<3),WAdr+((((y%+idx)<<6)+x%)<<3),StLn,FntH,1
  Next idx 'line
End Sub

Function BoxDrawChar(Fod%,cId%,off%,max%)As integer 'fill char-box(StrB)
 Local Integer std,sts,ccn, sAdr, dAdr, FntL, Div
  'before get char, get the info
  sAdr = FoIf(0,cId%-32,Fod%) 'start-adr 1st column of fontpattern
  FntL = FoIf(1,cId%-32,Fod%) 'fontLen from font.info
  Div  = 4-Fod%
  Memory unpack sAdr,pChB,FntL<<Div, 1 '16=4;8=3 'todo: get from font
  If off% < 0 Then 'min.0 for first column
    std = 0         'dest. in column 'column char(i) to column led-matrix(j)
    sts = Abs(off%)
    ccn = FntL-sts 'column count substract because offs is negativ
  Else
    std = off% 'dest. in column for led-matrix(j)
    sts = 0
    ccn = FntL 'columns of char will fit
  End If
  If std < max% Then '< MaxColumn; dest. in column;led-array: global(???)
    If std+ccn > max% Then ccn = max% - std 'not all columns of char will fit
    dAdr = Peek(VarAddr StrB(std<<Div)) 'buffer for stringpattern same height as
    sAdr = Peek(VarAddr ChrB(sts<<Div)) '- font height
    Memory Copy Integer sAdr, dAdr, ccn<<Div 'hole/part-char copy
  End If
  BoxDrawChar = std+ccn
End Function 'DrawString

' Midpoint circle algorithm
Sub HubDrawCircle(x0 As Integer,y0 As Integer, radi As Integer, Col As Integer)
 Local Integer x=radi
 Local Integer y
 ' Decision criterion divided by 2 evaluated at x=r, y=0
 Local Integer dOv2=1-x
 Do While(x>=y)
   Work(x0+x+((y0+y)<<6))=Col
   Work(x0-x+((y0+y)<<6))=Col
   Work(x0+x+((y0-y)<<6))=Col
   Work(x0-x+((y0-y)<<6))=Col
   Work(x0+y+((y0+x)<<6))=Col
   Work(x0-y+((y0+x)<<6))=Col
   Work(x0+y+((y0-x)<<6))=Col
   Work(x0-y+((y0-x)<<6))=Col
   Inc y
   If dOv2 <= 0 Then
     Inc dOv2, y*2+1 ' Change in decision criterion for y -> y +1
   Else
     Inc x,-1
     Inc dOv2,(y-x)*2+1 '  Change for y -> y +1, x -> x -1
   End If
 Loop
End Sub


Sub HubDrawCircleFill(x0%,y0%, r%, Col%)
 Local Integer x=r%
 Local Integer y
 ' Decision criterion divided by 2 evaluated at x=r, y=0
 Local Integer dOv2=1-x
 Do While(x>=y)
   HubDrawHLine(x0%-x,y0%+y,1+(x<<1),Col%)
   HubDrawHLine(x0%-x,y0%-y,1+(x<<1),Col%)
   HubDrawHLine(x0%-y,y0%-x,1+(y<<1),Col%)
   HubDrawHLine(x0%-y,y0%+x,1+(y<<1),Col%)
   Inc y
   If dOv2 <= 0 Then
     Inc dOv2, y*2+1 ' Change in decision criterion for y -> y +1
   Else
     Inc x,-1
     Inc dOv2,(y-x)*2+1 '  Change for y -> y +1, x -> x -1
   End If
 Loop
End Sub
'------------------------------------------------------------------
' special handling for horizont- and vertical lines much more speed
'------------------------------------------------------------------
Sub HubDrawHLine(x%,y%,w%,col%)
  Memory Set Integer WAdr+(((y%<<6)+x%)<<3),col%,w%
End Sub
Sub HubDrawVLine(x%,y%,h%,col%)
  Memory Set Integer WAdr+(((y%<<6)+x%)<<3),col%, h%,64'inc of wide
End Sub
'------------------------------------------------------------------
' draws a line with bresenham from the coordinates x0,y0 to x1,y1
' from the net
'------------------------------------------------------------------
Sub HubDrawLine(x0%,y0%,x1%,y1%,col%)
 Local integer dx= Abs(x1%-x0%),sx=Choice(x0%<x1%,1,-1)
 Local integer dy=-Abs(y1%-y0%),sy=Choice(y0%<y1%,1,-1)
 Local integer er=dx+dy,e2
 Do
  Work(x0%+(y0%<<6))=col%
  If (x0%=x1%)And(y0%=y1%) Then Exit Do
  e2=er<<1
  If (e2>=dy)Then Inc er,dy: Inc x0%,sx
  If (e2<=dx)Then Inc er,dx: Inc y0%,sy
 Loop
End Sub

Sub HubDrawRecFill(x% ,y%, w%, h%, col%)
Local integer i,j

 If h%>w% Then
  For i=0 To w%-1
    Memory Set Integer WAdr+(((y%<<6)+x%+i)<<3),col%, h%,64'inc of wide
  Next i
 Else
  For i=0 To h%-1   '               *64      *8
    Memory Set Integer WAdr+((((y%+i)<<6)+x%)<<3),col%,w%
    'memory set is not very safe!!!! but quick if w% > 0
    'For j = 0 To w%-1     'safe but slow
    '  Work(x%+j+((y%+i)<<6))=col%
    'Next j
  Next i
 End If

End Sub

Sub HubDrawRecHoll(x%, y%, w%, h%, col%)
Local integer i
 'memory set is not very safe!!! but quick if w% > 0
  Memory Set Integer WAdr+((( y%      <<6)+x%)<<3),col%,w% 'top
  Memory Set Integer WAdr+((((y%+h%-1)<<6)+x%)<<3),col%,w% 'down
  Memory Set Integer WAdr+(((y%<<6)+x%)<<3),col%, h%,64'inc of wide
  Memory Set Integer WAdr+(((y%<<6)+x%+w%-1)<<3),col%, h%,64'inc of wide
End Sub

Sub HubDrawPixel(x%,y%,col%)
  Work(x%+(y%<<6))=col%
End Sub

Sub HubDrawPixelCl(x%,y%,col%) 'with clipping !!! safe but slow
 If x%>=0 And x%<64 And y%>=0 And y%<64 Then Work(x%+(y%<<6))=col%
End Sub

Sub HubDrawRecFillCl(x% ,y%, w%, h%, col%) 'quick and dirty, only for demo
Local integer i,j
 If x%>=0 And x%<64 And y%>=0 And y%<64 Then 'start outside->exit
  If x%+w% > 63 Then w%=63-x%
  If y%+h% > 63 Then h%=63-y%
  For  i= 0 To h%-1   '               *64      *8
    Memory Set Integer WAdr+((((y%+i)<<6)+x%)<<3),col%,w%
  Next i
 End If
End Sub

Sub BoxScrollDown(x0%,y0%,x1%,y1%)
Local integer y, w=x1%-x0%+1, h=y1%-y0%
Local integer adr = WAdr+(((y0%<<6)+x0%)<<3)
 For y = 0 To h-1
   Memory copy integer adr+((y+1)<<9),adr+(y<<9),w,1,1
   Memory set integer  adr+((y+1)<<9),0,w
 Next y
End Sub

Sub BoxScrollUp(x0%,y0%,x1%,y1%)
Local integer y, w=x1%-x0%+1, h=y1%-y0%
Local integer adr = WAdr+(((y0%<<6)+x0%)<<3)
 For y = h-1 To 0 Step -1
   Memory copy integer adr+(y<<9),adr+((y+1)<<9),w,1,1
   Memory set integer  adr+(y<<9),0,w
 Next y
End Sub

Sub ScrMoveDown()'whole
  Memory copy integer WAdr+(64<<3), WAdr, 4032,1,1
End Sub

Sub ScrMoveUp()  'whole
  Memory copy integer WAdr, WAdr+(64<<3), 4032,1,1
End Sub

Sub ScrMoveLeft(y0%,y1%)'area
Local integer y
 For y = y0% To y1%
   Memory copy integer WAdr+(y<<9)+8,WAdr+(y<<9),63,1,1
 Next y
End Sub

Sub ScrMoveRight(y0%,y1%)'area
Local integer y
 For y = y0% To y1%
   Memory copy integer WAdr+(y<<9),WAdr+(y<<9)+8,63,1,1
 Next y
End Sub



'------------------------------------------------------------------------------|
Sub StartHub75Pio()
  PIO dma tx 1,0,0,Pack(),,,2048 '32 bit transfers, do for ever
End Sub

Sub InitHub75Pio()
  SetPin gp0,pio1 ' out RED
  SetPin gp1,pio1 ' out GREEN
  SetPin gp2,pio1 ' out BLUE
  SetPin gp3,pio1 ' out red
  SetPin gp4,pio1 ' out green
  SetPin gp5,pio1 ' out blue
  SetPin gp6,pio1 ' out A
  SetPin gp7,pio1 ' out B
  SetPin gp8,pio1 ' out C
  SetPin gp9,pio1 ' out D
  SetPin gp10,pio1' out E
  SetPin gp11,pio1' sideset CLK
  SetPin gp12,pio1' set LATCH
  SetPin gp13,pio1' set /OE
 'pull = 32 bit ; out-shiftdir is right
 'YRGBrgb0 0RGBrgb0 0RGBrgb0 0RGBrgbX
 'X=1 marks BOS(BeginOfSequence),Y=1 marks EOL(EndOfLine)
  PIO CLEAR 1
  PIO ASSEMBLE 1, ".program data"
  PIO ASSEMBLE 1, ".line 0"
  PIO ASSEMBLE 1, ".side_set 1"
  PIO ASSEMBLE 1, ".wrap target"
  PIO ASSEMBLE 1, "line:"
  PIO ASSEMBLE 1, "out x,    1  side 0 "    '1 if there is a BOS,it is here
  PIO ASSEMBLE 1, "jmp !x,NoBos side 0 "    'jump over next step if no BOS
  PIO ASSEMBLE 1, "irq set 1    side 0 "    'BeginOfSequence -> sync SM-ctrl
  PIO ASSEMBLE 1, "NoBos:"
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '6 shift RGBrgb-data from osr
  PIO ASSEMBLE 1, "out null, 2  side 1 [1]" 'clk+2 no data
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '6 shift RGBrgb-data from osr
  PIO ASSEMBLE 1, "out null, 2  side 1 [1]" 'clk+2 no data
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '2 shift RGBrgb-data from osr
  PIO ASSEMBLE 1, "out null, 2  side 1 [1]" 'clk+2
  PIO ASSEMBLE 1, "out pins, 6  side 0 "    '6 shift RGBrgb-data from osr
  PIO ASSEMBLE 1, "out y,    1  side 1 [1]" 'clk+if there is an EOL,it is here
  PIO ASSEMBLE 1, "jmp !y,line  side 0 "    'no EOL->continue
  PIO ASSEMBLE 1, "irq set 2    side 0 [4]" 'EndOfLine-> SM-ctrl:need some time
  PIO ASSEMBLE 1, ".wrap"                   '3ticsx64pixs = 192 tics-max delay??
  PIO ASSEMBLE 1, ".end program"' list"
 'init data must be global for re-init in PIO TX IRQ
  Dim integer Exe0 = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  Dim integer Pin0 = Pio(pinctrl 1,0,6,,gp11,,gp0)' add setpin for debug
  Dim integer Shi0 = Pio(shiftctrl 0,0,0,1,0,1)'InShDir(l),OutShDir(r)
  Dim integer Fre0 = 10700000
  PIO init machine 1,0,Fre0,Pin0,Exe0,Shi0,0,1,1,1'side_set-,set-,outDir=out
 'only the second PIO waits for IRQs(BOS,EOL), beware from Deadlock
 'X = Frame-Level, 2 for bit1, 1 for bit0, up to 15 if 5bits(16*9delay=144)
 'Y = address of line, startval 7(1/8), 15(1/16er), 31(1/32)scan
  PIO ASSEMBLE 1, ".program ctrl"
  PIO ASSEMBLE 1, ".line 13"
  PIO ASSEMBLE 1, ".wrap target"
  PIO ASSEMBLE 1, "start:"            'begin of sequence for jmp
  PIO ASSEMBLE 1, "wait 1 irq 1"      'wait for BOS(BeginOfSequence)
  PIO ASSEMBLE 1, "set x, 15"         '2^(Frames-1)for 4bit:>7,<16 :msb first!
  PIO ASSEMBLE 1, "mov OSR, x"        'save frame-level, also to shift(/2)
  PIO ASSEMBLE 1, "frame:"            'one sequence => some frames(2bit:2frames)
  PIO ASSEMBLE 1, "set y, 31"         'reset line-adr; scan: 1/16(15),1/32(31)
  PIO ASSEMBLE 1, "line:"             'output of pixel-data is in SM-data
  PIO ASSEMBLE 1, "wait 1 irq 2  "    'wait for EOL(EndOfLine) from SM-data
  PIO ASSEMBLE 1, "set pins, &b11"    '1. /OE off, latch on
  PIO ASSEMBLE 1, "mov pins,y    "    '2. out new address(ABCDE)
  PIO ASSEMBLE 1, "mov x,OSR"         'reload level for the delay of this line
  PIO ASSEMBLE 1, "set pins, &b00"    '3. /OE on, latch off
  PIO ASSEMBLE 1, "delay:"            'check:4future wait EndOfShow from SM-data
                                      'max[5]x(31) must be < 150(tested)
  PIO ASSEMBLE 1, "jmp x--,delay [4]" 'SM-data is working parallel(shift data)
  PIO ASSEMBLE 1, "set pins, &b10"    '/OE off, latch off
  PIO ASSEMBLE 1, "jmp y--,line"      'dec adr for next line
  PIO ASSEMBLE 1, "out null,1"        'one frame finished -> dec framelevel(/2)
  PIO ASSEMBLE 1, "mov x,OSR"         'reload for compare
  PIO ASSEMBLE 1, "jmp !x, start" 'there are no more frames in the sequence.Trys
  PIO ASSEMBLE 1, "jmp frame"     'with "jmp !OSRE frame" did not work because
  PIO ASSEMBLE 1, ".wrap"         'OSRE counts the outs since last pull,not vals
  PIO ASSEMBLE 1, ".end program"' list"

  Dim integer Exe1 = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  Dim integer Pin1 = Pio(pinctrl 0,2,5,,,gp12,gp6)' add setpin for debug
  PIO init machine 1,1,Fre0,Pin1,Exe1,Shi0,13,1,1,1'side_set-,set-,outDir=out
  PIO start 1,1 '"crtl" starts first and wait immediately for irq from "data"
End Sub 'InitHub75Pio()

Sub DupD() 'DisplayUpDate, if used with Tick
 tic1 = Timer
  Pack4Hub(4096) 'pack,mix and save in ringbuffer
 tic2 = Timer
 Print tic2-tic1
End Sub

Sub Pack4Hub( size As integer)
 'pack and interlace Work()-data to Hub75-PIO DMA-array(Pack())
 Memory pack  WAdr, UAdr, size>>1,16 '01234560 for example bitnames at start
 Memory pack  VAdr, DAdr, size>>1,16 '0ABCDEF0
 'shift, mask and add Uppr(),Down() to seperate bits in mixed arrays
 Memory set pAdM,&b01110000,size    'bit1:(MSB)01230000>>0+0ABC0000>>3->y123ABCx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask first bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask first bits from down
 Math shift Tmp2(),    -3,Tmp2(),u'unsigned shift down right!!!!!!
 Math c_OR Tmp2(),Tmp1(),Tmp1()     'add up and down
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Tmp1(0)=Tmp1(0) Or &h100           'now add BeginOfSequence(BOS)-flag
 Memory copy pTmp+1,pAA0,size>>1,2,1'copy bit3 part to ringbuffer
 Memory copy pTmp,pAA2,size>>1,2,1  'copy bit1 part to ringbuffer
 Memory set pAdM,&b00001110,size    'bit0:(LSB)00004560<<3+0000DEF0>>3->y456DEFx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask second bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask second bits from down
 Math shift Tmp1(),     3,Tmp1()    'shift them left
 Math c_OR Tmp1(),Tmp2(),Tmp1()     'add down and up
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Memory copy pTmp+1,pAA1,size>>1,2,1'copy bit2 part to ringbuffer
 Memory copy pTmp,pAA3,size>>1,2,1  'copy bit0 part to ringbuffer
End Sub 'Pack4Hub()

Sub MyInit()
Local Integer actP 'act. position must be counted because variable width
Local Integer i,j,x,y
Local Integer FCnt, RCnt, CCnt
 '                 rgb
 CrTb( 0)= rgb444(0,0,0) 'black
 'normal base colors
 CrTb( 1)= RGB444(12,0,0)'red
 CrTb( 2)= RGB444(0,12,0)'green
 CrTb( 3)= RGB444(0,0,12)'blue
 CrTb( 4)= RGB444(10,10,0)'yellow
 CrTb( 5)= RGB444(10,0,10)'magenta
 CrTb( 6)= RGB444(0,10,10)'cyan
 CrTb( 7)= RGB444(10,10,10)'white
 CrTb( 8)= RGB444(5,5,5)'grey bright
 CrTb( 9)= RGB444(1,1,1)'grey dark
 'red->green
 For i = 0 To 15:CrTb(10+i)=rgb444(15-i,i,0):Next i
 'green->blue
 For i = 0 To 15:CrTb(26+i)=rgb444(0,15-i,i):Next i
 'blue->red-1
 For i = 0 To 14:CrTb(42+i)=rgb444(i,0,15-i):Next i

'init EOL-mask. Have to be changed when wider displays are used
 For j = 0 To 31 'every line two times because of 2byte color
  AdrM((j<<4)+15)= &h8080000000000000'EOL for both colorbytes:split after shrink
  'AdrM((j<<3)+7) = &h8000000000000000'EOL  2bit/colorchannel
 Next j

'read fontdata ----------------------------------------------------------------|
' font 0
 Restore fHead16
 Read FSize '
 Read FRows '
 Read FCnt  'FontCount
 RCnt = 16-1'todo: get RCnt from data:but copying is more complicated if not 16
 Dim Integer MyFo16(FSize-1) 'size should be at top of fontdata, just readed
 Restore fWidth16   'go to width-info of font
 For i = 0 To FCnt-1
   Read FoIf(1,i,0) 'get width and store it to FontInfo-array
        FoIf(2,i,0)=FRows
 Next i
 Restore fData16 'go to fontpattern
 actP  = 0
 For i = 0 To FCnt-1
   FoIf(0,i,0) = Peek(VarAddr MyFo16(actP))'get adress and store it
   CCnt = FoIf(1,i,0)-1    'ColCount is allready stored
   'new! packed 8bytes/integer
    Select Case FRows
    Case 1 To 8
      For j = 0 To (CCnt>>3) 'through the columns
        Read MyFo8(actP) 'read 8 columns
        Inc actP
      Next j
    Case 9 To 16
      For j = 0 To (CCnt>>2) 'through the columns
        Read MyFo16(actP) 'read four columns
        Inc actP
      Next j
    Case Else
      Print "???";
   End Select
 Next i
'- font 1 ---------------------------
 Restore fHead8
 Read FSize '
 Read FRows '
 Read FCnt  'FontCount
 RCnt = 8-1'todo: get RCnt from data:but copying is more complicated if not 8
 Dim Integer MyFo8(FSize-1) 'size should be at top of fontdata, just readed
 Restore fWidth8   'go to width-info of font
 For i = 0 To FCnt-1
   Read FoIf(1,i,1) 'get width and store it to FontInfo-array
        FoIf(2,i,1)=FRows
 Next i
 Restore fData8 'go to fontpattern
 actP  = 0
 For i = 0 To FCnt-1
   FoIf(0,i,1) = Peek(VarAddr MyFo8(actP))'get adress and store it
   CCnt = FoIf(1,i,1)-1    'ColCount is allready stored
   'new! packed 8bytes/integer
    Select Case FRows
    Case 1 To 8
      For j = 0 To (CCnt>>3) 'through the columns
        Read MyFo8(actP) 'read 8 columns
        Inc actP
      Next j
    Case 9 To 16
      For j = 0 To (CCnt>>2) 'through the columns
        Read MyFo16(actP) 'read four columns
        Inc actP
      Next j
    Case Else
      Print "???";
   End Select
 Next i
End Sub 'MyInit()

' bmps ----------------------------------------------------------------------|
Sub  LoadBmp( Fn As string)
' Id for imageNo, Fn Filename, dm Dimmer greater is darker
' pos|  len |
' 11  4 byte offBits
' 19  4 byte biWidth
' 23  4 byte biHeight
' 55  begin of data
Local integer x, y, fill
 Open Fn For input As #1
  '- read parts of bmp-header       IDs: Adr =0, S=1, W=2, H=3
  Seek #1,19                   'skip headersize
  FInf(0,2) = ReadDWord()           'width
  FInf(0,3) = ReadDWord()           'height
  FInf(0,1) = FInf(0,2)*FInf(0,3) 'pixelcount(size)
  FInf(0,0) = Peek(VarAddr Work())

'now read bmp-data
  Seek #1,55                     'skip planes, bitcount, compress, ...
  For y = 0 To FInf(0,3)-1
    For x = 0 To FInf(0,2)-1    'over the width
      Work((y<<6)+x)= ReadPixel()  '2 bytes BGR-values
    Next x
    fill = 3-Loc(#1)And 3        'check for 4-byte boundary/line
    If fill>0 Then x=Asc(Input$(fill,#1)) 'skip dummy-data
  Next y
 Close #1
End Sub

Function ReadPixel() As Integer
Local integer B,G,R,res%
 G=Asc(Input$(1,#1))
 B=Asc(Input$(1,#1))
 R=Asc(Input$(1,#1))
 'returns only the most signifant 4bits of each color
 res%=1    Or((R% And 16)>>3)Or((R% And 32)>>1)Or((R% And 64)<<3)Or((R% And 128)<<5)
 res%=res% Or((G% And 16)>>2)Or((G% And 32)   )Or((G% And 64)<<4)Or((G% And 128)<<6)
 res%=res% Or((B% And 16)>>1)Or((B% And 32)<<1)Or((B% And 64)<<5)Or((B% And 128)<<7)
 ReadPixel = res% 'RGB444(Re>>4,Gr>>4,Bl>>4)
End Function

Function ReadDWord() As Integer
'reads four bytes from file
Local integer lsb,msb,msb1,msb2
  lsb =Asc(Input$(1,#1))
  msb =Asc(Input$(1,#1))
  msb1=Asc(Input$(1,#1))
  msb2=Asc(Input$(1,#1))
  ReadDWord = (msb2<<24)+(msb1<<16)+(msb<<8)+lsb
End Function

'helper ----------------------------------------------------------------------
Function RGB444(R%,B%,G%) As integer
'possible lsb for transparency(multilayer)?,msb is empty at the moment
'idea is:get 2x2bit in 2 bytes 0000rrrr,0000gggg,0000bbbb -> yrgbrgbx,yrgbrgbx
Local res%
 res%=1    Or((R% And 1)<<1)Or((R% And 2)<<3)Or((R% And 4)<<7)Or((R% And 8)<<9)
 res%=res% Or((G% And 1)<<2)Or((G% And 2)<<4)Or((G% And 4)<<8)Or((G% And 8)<<10)
 res%=res% Or((B% And 1)<<3)Or((B% And 2)<<5)Or((B% And 4)<<9)Or((B% And 8)<<11)
 RGB444 = res%
End Function

'font data --------------------------------------------------------------------
'font Leelawadee_UI(202)size for array(pix)
fHead16:
Data &h00CE 'size for array(hex)
Data &h10   'height
Data &h60   'char-count(ptr)
fData16: '--------------------------------------------------------------------
Data &h0000000000000000                                                '20:(d32)
Data &h000078007F707F70                                                '21:!
Data &h7000000070007000, &h0000000000007000                            '22:"
Data &h7F000FE009E00100, &h7D007FE00BE07900, &h0000000000000900        '23:#
Data &hFFFC66307E303C60, &h000001E073F06330                            '24:$
Data &h447044107C003800, &h0EE007003B807CE0, &h01F04110711039F0        '>nl
Data &h00000000000000E0                                                '25:%
Data &h6E307E303BE001C0, &h39E07B706E306630, &h1E301F3003F001E0        '>nl
Data &h0000000000000030                                                '26:&
Data &h0000000070007000                                                '27:'
Data &h6006381C1FF807E0, &h0000000000004002                            '28:(
Data &h0FF03FFC780E4002                                                '29:)
Data &h78001E0034003000, &h0000300034001E00                            '2A:*
Data &h0FF0018001800180, &h0180018001800FF0                            '2B:+
Data &h00000030003C000C                                                '2C:,
Data &h0180018001800180                                                '2D:-
Data &h0000007000700070                                                '2E:.
Data &h07C001F0003C000C, &h0000600078001F00                            '2F:/
Data &h603070703FE01FC0, &h00001FC03FE07070                            '30:0
Data &h7FF0300018000000, &h0000000000007FF0                            '31:1
Data &h633061B030F00070, &h00003C307E306330                            '32:2
Data &h6630663070700000, &h000039E07FE06630                            '33:3
Data &h38C00CC007C003C0, &h000000C07FF07FF0                            '34:4
Data &h66307E307E700060, &h000003C067E06630                            '35:5
Data &h663072303FE00FC0, &h000003C067E06630                            '36:6
Data &h67C061F060306000, &h0000600078007E00                            '37:7
Data &h663067307FF039E0, &h000039E07FF06730                            '38:8
Data &h633063303F301E00, &h00001F803FE06270                            '39:9
Data &h000000000E700E70                                                '3A::
Data &h00000E700E780018                                                '3B:;
Data &h06C0028003800100, &h00000C60044006C0                            '3C:<
Data &h06C006C006C006C0, &h000006C006C006C0                            '3D:=
Data &h06C006C004400C60, &h0000010003800280                            '3E:>
Data &h6770637060703000, &h0000000038007C00                            '3F:?
Data &h13D81C300FE007C0, &h27E82428242837E8, &h0FC01860302827E8        '>nl
Data &h0000000000000780                                                '40:@
Data &h1FC007F000F00010, &h3FC07CC060C07CC0, &h0000001000F007F0        '41:A
Data &h663066307FF07FF0, &h39C07BE066706630                            '42:B
Data &h603030703FE00F80, &h3060707060306030                            '43:C
Data &h603060307FF07FF0, &h38E0707060306030, &h000000000F803FC0        '44:D
Data &h663066307FF07FF0, &h0000603066306630                            '45:E
Data &h630063007FF07FF0, &h0000000063006300                            '46:F
Data &h703038601FE00F80, &h63F0633063306030, &h00000000000073E0        '47:G
Data &h060006007FF07FF0, &h7FF0060006000600, &h0000000000007FF0        '48:H
Data &h000000007FF07FF0                                                '49:I
Data &h7FE0003000300030, &h0000000000007FC0                            '4A:J
Data &h0F8006007FF07FF0, &h6030707079F01FC0, &h0000000000004010        '4B:K
Data &h003000307FF07FF0, &h0000000000300030                            '4C:L
Data &h7F0078007FF07FF0, &h07E000F001F00FE0, &h7FF07FF078003F00        '4D:M
Data &h1C0078007FF07FF0, &h00F001C007800F00, &h000000007FF07FF0        '4E:N
Data &h603030603FE00F80, &h3060603060306030, &h000000000F803FE0        '4F:O
Data &h630063007FF07FF0, &h3C003E0063006300                            '50:P
Data &h603030603FE00F80, &h307C603060306030, &h000000040F8C3FFC        '51:Q
Data &h630063007FF07FF0, &h3C307EF067E063C0, &h0000000000000010        '52:R
Data &h673066303E303C70, &h000071E063E06330                            '53:S
Data &h7FF0600060006000, &h6000600060007FF0                            '54:T
Data &h003000707FE07FC0, &h7FE0007000300030, &h0000000000007FC0        '55:U
Data &h1FE07F0078004000, &h1FE003F0003003F0, &h0000400078007F00        '56:V
Data &h0FF07FC07E006000, &h7C003FC003F00070, &h007007F07F807C00        '>nl
Data &h60007E007FC007F0                                                '57:W
Data &h3FE078F060304010, &h78F03FE00F800F80, &h0000000040106070        '58:X
Data &h3E00780070004000, &h78001E0007F00FF0, &h0000000040007000        '59:Y
Data &h63F060F060706030, &h78307E306F3067B0, &h0000000060307030        '5A:Z
Data &h600660067FFE7FFE                                                '5B:[
Data &h0F803E0078006000, &h000C003C00F803E0                            '5C:\
Data &h7FFE7FFE60066006                                                '5D:]
Data &h60003C000F000300, &h000003000F003C00                            '5E:^
Data &h0004000400040004, &h0000000400040004                            '5F:_
Data &h60004000C0008000, &h0000000000002000                            '60:`
Data &h0D300DB00DF000E0, &h000007F00FF00D20                            '61:a
Data &h0C300620FFF0FFF0, &h03C00FE00C700C30                            '62:b
Data &h0C300E7007E003C0, &h000000000C700C30                            '63:c
Data &h0C300E7007E003C0, &hFFF0FFF004600C30                            '64:d
Data &h0DB00DB007E003C0, &h000003800FB00DB0                            '65:e
Data &hCC00FFF07FF00C00, &h000000000000CC00                            '66:f
Data &h0C330E7307E703C0, &h0FFC0FFE04670C33                            '67:g
Data &h0C000400FFF0FFF0, &h000007F00FF00C00                            '68:h
Data &h00000000EFF0EFF0                                                '69:i
Data &h0000EFFCEFFF0003                                                '6A:j
Data &h03C00180FFF0FFF0, &h08100C300E7007E0                            '6B:k
Data &h00000000FFF0FFF0                                                '6C:l
Data &h0C0004000FF00FF0, &h040007F00FF00C00, &h07F00FF00C000C00        '6D:m
Data &h0C0004000FF00FF0, &h000007F00FF00C00                            '6E:n
Data &h0C300E7007E003C0, &h03C007E00C300C30                            '6F:o
Data &h0C3006200FFF0FFF, &h03C00FE00C700C30                            '70:p
Data &h0C300E7007E003C0, &h0FFF0FFF04600C30                            '71:q
Data &h0C0006000FF00FF0, &h0000000000000C00                            '72:r
Data &h0DF00DB00FB00730, &h0000000000000CE0                            '73:s
Data &h0C303FF03FE00C00, &h0000000000000C30                            '74:t
Data &h003000300FF00FE0, &h00000FF00FF00020                            '75:u
Data &h03F00FE00F000800, &h0F000FC003F00030, &h0000000000000800        '76:v
Data &h00F00FF00F800C00, &h0FC00C000FC000F0, &h0F8007F0007003F0        '>nl
Data &h0000000000000C00                                                '77:w
Data &h07E00FF00C300810, &h0C300FF007E00180, &h0000000000000810        '78:x
Data &h03FF0FC30F030803, &h0F000FC001F8007E, &h0000000000000800        '79:y
Data &h0DF00CF00C700C30, &h0C300E300F300FB0                            '7A:z
Data &h40027EFE3FFC0100                                                '7B:{
Data &h00000000FFFFFFFF                                                '7C:|
Data &h01003FFC7EFE4002                                                '7D:}
Data &h6C0044006C003800, &h0000000000003800                            '7E:~
Data &hFFFFFFFFFFFFFFFF, &hFFFFFFFFFFFFFFFF, &hFFFFFFFFFFFFFFFF        '>nl
Data &hFFFFFFFFFFFFFFFF                          'block for 16x16 pics  7F:
fWidth16: '------------------------------------------------------------------
Data &h01, &h03, &h05, &h09, &h07, &h0D, &h0D, &h02, &h05, &h04, &h07, &h08
Data &h03, &h04, &h03, &h07, &h07, &h07, &h07, &h07, &h07, &h07, &h07, &h07
Data &h07, &h07, &h02, &h03, &h07, &h07, &h07, &h06, &h0D, &h0B, &h08, &h08
Data &h0A, &h07, &h06, &h09, &h09, &h02, &h05, &h09, &h06, &h0C, &h0A, &h0A
Data &h08, &h0B, &h09, &h07, &h08, &h09, &h0B, &h10, &h0A, &h0A, &h0A, &h04
Data &h08, &h04, &h07, &h07, &h05, &h07, &h08, &h06, &h08, &h07, &h05, &h08
Data &h07, &h02, &h03, &h08, &h02, &h0C, &h07, &h08, &h08, &h08, &h05, &h05
Data &h05, &h07, &h09, &h0D, &h09, &h09, &h08, &h04, &h02, &h04, &h05, &h0F

'font Terminal(95)size for array(pix)---------------------------------------
fHead8:
Data &h005F 'size for array(hex)
Data &h08   'height
Data &h5F   'char-count(ptr)
fData8: '--------------------------------------------------------------------
Data &h0000000000000000                                                '20:
Data &h000000000060FA60                                                '21:!
Data &h000000C0E000C0E0                                                '22:"
Data &h000000247E247E24                                                '23:#
Data &h000000004856D424                                                '24:$
Data &h000000C62610C8C6                                                '25:%
Data &h0000000A046A926C                                                '26:&
Data &h000000000000C0E0                                                '27:'
Data &h000000000000827C                                                '28:(
Data &h0000000000007C82                                                '29:)
Data &h0000001054385410                                                '2A:*
Data &h00000010107C1010                                                '2B:+
Data &h0000000000060700                                                '2C:,
Data &h0000001010101010                                                '2D:-
Data &h0000000000060600                                                '2E:.
Data &h0000004020100804                                                '2F:/
Data &h0000007CA2928A7C                                                '30:0
Data &h0000000002FE4200                                                '31:1
Data &h0000006292928A46                                                '32:2
Data &h0000006C92929244                                                '33:3
Data &h00000008FE482818                                                '34:4
Data &h0000008C929292F4                                                '35:5
Data &h0000000C9292523C                                                '36:6
Data &h000000C0A0908E80                                                '37:7
Data &h0000006C9292926C                                                '38:8
Data &h0000007894929260                                                '39:9
Data &h0000000000363600                                                '3A::
Data &h0000000000363700                                                '3B:;
Data &h0000000082442810                                                '3C:<
Data &h0000002828282828                                                '3D:=
Data &h0000000010284482                                                '3E:>
Data &h00000060909A8040                                                '3F:?
Data &h00000078AABA827C                                                '40:@
Data &h0000007E8888887E                                                '41:A
Data &h0000006C929292FE                                                '42:B
Data &h000000448282827C                                                '43:C
Data &h0000007C828282FE                                                '44:D
Data &h00000082929292FE                                                '45:E
Data &h00000080909090FE                                                '46:F
Data &h0000005E9292827C                                                '47:G
Data &h000000FE101010FE                                                '48:H
Data &h000000000082FE82                                                '49:I
Data &h000000FC0202020C                                                '4A:J
Data &h00000082442810FE                                                '4B:K
Data &h00000002020202FE                                                '4C:L
Data &h000000FE402040FE                                                '4D:M
Data &h000000FE102040FE                                                '4E:N
Data &h0000007C8282827C                                                '4F:O
Data &h00000060909090FE                                                '50:P
Data &h0000007A848A827C                                                '51:Q
Data &h00000066989090FE                                                '52:R
Data &h0000004C92929264                                                '53:S
Data &h0000008080FE8080                                                '54:T
Data &h000000FC020202FC                                                '55:U
Data &h000000F8040204F8                                                '56:V
Data &h000000FC023C02FC                                                '57:W
Data &h000000C6281028C6                                                '58:X
Data &h000000E0100E10E0                                                '59:Y
Data &h000000C2A2928A86                                                '5A:Z
Data &h00000000008282FE                                                '5B:[
Data &h0000000408102040                                                '5C:\
Data &h0000000000FE8282                                                '5D:]
Data &h0000002040804020                                                '5E:^
Data &h0000000101010101                                                '5F:_
Data &h000000000000E0C0                                                '60:`
Data &h0000001E2A2A2A04                                                '61:a
Data &h0000001C222222FE                                                '62:b
Data &h000000142222221C                                                '63:c
Data &h000000FE2222221C                                                '64:d
Data &h000000102A2A2A1C                                                '65:e
Data &h0000000090907E10                                                '66:f
Data &h0000003E25252518                                                '67:g
Data &h000000001E2020FE                                                '68:h
Data &h00000000000002BE                                                '69:i
Data &h00000000BE210102                                                '6A:j
Data &h00000000221408FE                                                '6B:k
Data &h00000000000002FE                                                '6C:l
Data &h0000001E2018203E                                                '6D:m
Data &h000000001E20203E                                                '6E:n
Data &h0000001C2222221C                                                '6F:o
Data &h0000001C2222223F                                                '70:p
Data &h0000003F2222221C                                                '71:q
Data &h0000001020221E22                                                '72:r
Data &h000000042A2A2A10                                                '73:s
Data &h0000000024227C20                                                '74:t
Data &h000000003E04023C                                                '75:u
Data &h000000003804023C                                                '76:v
Data &h0000003C060C063C                                                '77:w
Data &h0000000036080836                                                '78:x
Data &h000000003C060539                                                '79:y
Data &h00000000322A2A26                                                '7A:z
Data &h0000000082827C10                                                '7B:{
Data &h000000000000FE00                                                '7C:|
Data &h00000000107C8282                                                '7D:}
Data &h0000000060909060                                                '7E:~
fWidth8: '-----------------------------------------------------------------
Data &h03, &h03, &h05, &h05, &h04, &h05, &h05, &h02, &h02, &h02, &h05, &h05
Data &h03, &h05, &h03, &h05, &h05, &h05, &h05, &h05, &h05, &h05, &h05, &h05
Data &h05, &h05, &h03, &h03, &h04, &h05, &h04, &h05, &h05, &h05, &h05, &h05
Data &h05, &h05, &h05, &h05, &h05, &h03, &h05, &h05, &h05, &h05, &h05, &h05
Data &h05, &h05, &h05, &h05, &h05, &h05, &h05, &h05, &h05, &h05, &h05, &h03
Data &h05, &h03, &h05, &h05, &h02, &h05, &h05, &h05, &h05, &h05, &h04, &h05
Data &h04, &h02, &h04, &h04, &h02, &h05, &h04, &h05, &h05, &h05, &h05, &h05
Data &h04, &h04, &h04, &h05, &h04, &h04, &h04, &h04, &h02, &h04, &h04

Sub mm.end
  PIO DMA TX OFF
  PIO stop 1,0
  PIO stop 1,1
End Sub