'HUB75 test 12bit color 4bit per component(rgb444)and some fill bits = 1byte   |
' tested with two(chained) P3(2121)64X64-32S-6.0 from AE -> 128x64
' gp0  RED0              Connection HUB75
' gp1  GREEN0
' gp2  BLUE0                  +----+
' gp3  RED1              RED0 |1 16| GREEN0
' gp4  GREEN1           BLUE0 |2 15| GND
' gp5  BLUE1             RED1 |3 14| GREEN1
' gp6  A                BLUE1  4 13| E
' gp7  B                    A  5 12| B
' gp8  C                    C |6 11| D
' gp9  D                  CLK |7 10| LATCH
' gp10 E                  /OE |8  9| GND
' gp11 CLK                    +----+
' gp12 LATCH
' gp13 /OE
'
' * UserDriver should not be able to use "-1" for transparent text/bitmap *
' * this one use "1" for that, because the LSB will be rejected anyway    *
'
'this version is for Hub75-displays with 1/8,1/16 and 1/32 scan
'after reset by setting options the lcdpanel must be new configured
'-----------------------------------------------------------------------------|
Option EXPLICIT
Option DEFAULT NONE
'consts for hub-display
Const HubH    = 64
Const HubW    = 128
'Const HubScan = 8-1
'Const HubScan = 16-1
Const HubScan = 32-1
Const HubPixs = HubH*HubW
Const HubPixsD= HubH*HubW/4
Const HubBytes= HubH*HubW/8

' vars for display: buffers and PIO-calculation
Dim integer Work(HubBytes-1)' -> byte

'copy to
Dim integer Uppr(HubBytes-1) 'for data packed 12bit-color in 16bit
Dim integer Down(HubBytes-1) 'for data packed 12bit-color in 16bit

'for mask and shift
Dim integer AdrM(HubBytes-1) 'EOL mask;             fix after init
Dim integer AddM(HubBytes-1) 'holds the bitmasks    in Pack4Hub
Dim integer Tmp1(HubBytes-1) 'for temporary results in Pack4Hub
Dim integer Tmp2(HubBytes-1) 'for temporary results in Pack4Hub

'for save displaydata(ringbuffer)
Dim integer Pack
PIO make ring buffer Pack,HubPixs 'HubH*HubW/2 (2pix/byte)*2frames(2bits)

'pointer: used for memory copy
Dim integer WAdr = Peek(VarAddr Work(0))     'upper half of org(integer 64bit)
Dim integer VAdr = Peek(VarAddr Work(HubPixs/16))'low half of org(integer 64bit)

Dim integer UAdr = Peek(VarAddr Uppr())      'ptr to upper half packed(16bit)
Dim integer DAdr = Peek(VarAddr Down())      'ptr to lower half packed(16bit)
Dim integer pAdM = Peek(VarAddr AddM())      'ptr to bit-mask
Dim integer pTmp = Peek(VarAddr Tmp1())      'ptr to
Dim integer pAA0 = Peek(VarAddr Pack(0))     'ptr to ringbuffer-start bit3
Dim integer pAA1 = Peek(VarAddr Pack(HubBytes/2))'ptr to ringbuffer-start bit2

'-for userpanel----------------------------------------------------------------|
'if used Memory Unpack FONTS
Dim integer bma(512-1)    'memory for unpack "user_bitmap" (forground-color)
Dim integer bmap = Peek(VarAddr bma())
Dim integer StBg(512-1)   'background-color layer for "user_bitmap"

'-this and that----------------------------------------------------------------|
Dim float Tic1,Tic2 'for debugging/analyse
Dim integer turm,baue,runn,BitM3

turmr:
Data &b00000000
Data &b01011010
Data &b01011010
Data &b01111110
Data &b00111100
Data &b00111100
Data &b00111100
Data &b01111110
bauer:
Data &b00000000
Data &b00000000
Data &b00111000
Data &b01111100
Data &b01111100
Data &b00111000
Data &b00111000
Data &b11111110
runner:
Data &b00000000
Data &b00111000
Data &b01111100
Data &b00111000
Data &b01111100
Data &b00111000
Data &b00111000
Data &b11111110
BitMap3:
Data &b10001001
Data &b01000100
Data &b00100010
Data &b00010001
Data &b10001000
Data &b01000100
Data &b00100010
Data &b10010001

turm = ReadBitMap8x8("turmr")'only 8x8
baue = ReadBitMap8x8("bauer")
runn = ReadBitMap8x8("runner")
BitM3 = ReadBitMap8x8("BitMap3")

'display start ----------------------------------------------------------------|
MyInit() 'init EOL-Mask and ColorTable
DupD()   'init buffer before start: blank with BOS and EOLs by "first save"

'init PIO
'there is a problem with "DMA TX off",I can not stop/restart after Ctrl+C
If MM.Info(PIO TX DMA) Then
  Print "PIO TX DMA still running !!!!"
  PIO DMA TX OFF
  Pause 100
  PIO stop 1,0
  Pause 100
  If MM.Info(PIO TX DMA) Then Print "reset Pico": CPU RESTART
End If

InitHub75Pio()' with PIO CLEAR 1
StartHub75Pio()'start with ringbuffer

'tics--------------------------------------------------------------------------|

'-application consts/vars -----------------------------------------------------|
Dim integer i,j,a,R,G,B,S,C,X,Y

Dim integer px5(4)=(3,26,0,23,13),py5(4)=(0,16,16,0,26)
Dim integer pxt5(4),pyt5(4)                   'for displace
Dim integer px10(9),py10(9),pxt10(9),pyt10(9) 'for generate and displace


' application start -----------------------------------------------------------|
'init poly10
For i=0 To 9
  px10(i)=-(Sin((i*Pi/5))*(6+(i And 1)*10))+16
  py10(i)= (Cos((i*Pi/5))*(6+(i And 1)*10))+16
Next i

'init sys-display
On error skip
Option lcdpanel user, HubW, HubH

'intro
Text MM.HRES, 2,"Hub75 display driver",RT,7,1,RGB(0,255,255)
Text MM.HRES,12,"in BASIC",RT,7,1,RGB(255,255,0)
For i = 28 To 213
  y = Abs(Cos(i/(1300/i*2)))*(229-i)/5
  Circle 8+i/2,MM.VRES-9-y, 8, 0,1,0,RGB(red): DupD()
  Circle 8+i/2,MM.VRES-9-y, 8, 0,1,0,0 'erase old pos
Next i

'Bitmaps
CLS 0:DupD()
For y = 0 To MM.VRES Step 32
  For x = 0 To MM.HRES Step 32          'chessboard
    Box x   ,y   ,16,16,0,0,RGB(64,64,0)
    Box x+16,y   ,16,16,0,0,RGB(0,0,64)
    Box x   ,y+16,16,16,0,0,RGB(0,0,64)
    Box x+16,y+16,16,16,0,0,RGB(64,64,0):DupD()
  Next x
Next y
GUI Bitmap  4, 4,turm, 8,8,1,RGB(255,0,0),1
GUI Bitmap 20, 4,baue, 8,8,1,RGB(255,0,0),1
GUI Bitmap 20,20,baue, 8,8,1,RGB(0,0,255),1
GUI Bitmap 20,36,baue, 8,8,1,RGB(255,0,0),1
GUI Bitmap 20,52,baue, 8,8,1,RGB(0,0,255),1
GUI Bitmap 36,36,runn, 8,8,1,RGB(0,0,255),1
GUI Bitmap 48,32,BitM3,8,8,3,0,1

Text MM.HRES/2,2,"Gui Bitmaps",CT,7,1,RGB(255,255,255),1'print transparent
DupD()
Pause 2000

'lines and
CLS 0
For i = 15 To 63
  Line i   ,  0, MM.HRES/2,MM.VRES/2, 1, RGB(i*4+3,0,0)
  Line i   , 63, MM.HRES/2,MM.VRES/2, 1, RGB(i*4+3,i*4+3,0): DupD()
Next i
For i = 0 To 48
  Line i+64,  0, MM.HRES/2,MM.VRES/2, 1, RGB(0,(63-i)*4+3,0)
  Line i+64, 63, MM.HRES/2,MM.VRES/2, 1, RGB(0,0,(63-i)*4+3): DupD()
Next i
'pixel
For i = 0 To 127
  a = Sin(i/10)*19+MM.VRES/2
  b = Cos(i/12)*15+MM.VRES/2
  c = Sin((i+15)/15)*10+MM.VRES/2
  Pixel i, a, RGB(0,255,0)
  Pixel i, b, RGB(255,0,255)
  Pixel i, c, RGB(0,255,255): DupD()
Next i
Text MM.HRES/2,1 ,"Lines and Pixel",CT,7,1,RGB(255,255,255),1:DupD()
Pause 2000

'polygon
CLS 0
Text MM.HRES/2,2,"Polygon filled",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 60
 R=(Rnd*15)<<4
 G=(Rnd*15)<<4
 B=(Rnd*15)<<4
 x = Rnd*102
 y = Rnd*38
 Math add px5(), x, pxt5()
 Math add py5(), y, pyt5()
 Polygon 5, pxt5(), pyt5(), RGB(r,g,b), RGB(r,g,b): DupD()
Next i

CLS 0
Text MM.HRES/2,2 ,"Polygon unfilled",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 60
 R=(Rnd*15)<<4
 G=(Rnd*15)<<4
 B=(Rnd*15)<<4
 x = Rnd*96
 y = Rnd*32
 Math add px10(), x, pxt10()
 Math add py10(), y, pyt10()
 Polygon 10, pxt10(), pyt10(), RGB(r,g,b): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Arcs",CT,7,1,RGB(0,255,64):DupD()
 Arc MM.HRES/2-48, MM.VRES/2-16, 9, 15,   0, 120,RGB(red)
 Arc MM.HRES/2-48, MM.VRES/2-16, 9, 15, 120, 240,RGB(green)
 Arc MM.HRES/2-48, MM.VRES/2-16, 9, 15, 240, 360,RGB(blue)
 Arc MM.HRES/2-48, MM.VRES/2+16, 0, 15,  20, 100,RGB(64,64,64)
 Arc MM.HRES/2-48, MM.VRES/2+16, 0, 15, 100, 300,RGB(255,64,64)
 Arc MM.HRES/2-48, MM.VRES/2+16, 0, 15, 300, 380,RGB(128,128,128)
 Arc MM.HRES/2-2,  MM.VRES/2+2 ,15, 22,  45, 225,RGB(255,0,64)
 Arc MM.HRES/2-2,  MM.VRES/2+2 ,15, 22, 225, 360,RGB(64,0,255)
 Arc MM.HRES/2-2,  MM.VRES/2+2 , 9, 15,  90, 180,RGB(64,64,128)
 Arc MM.HRES/2-2,  MM.VRES/2+2 , 9, 15, 180,  20,RGB(0,64,64)
 Arc MM.HRES/2+40, MM.VRES/2+15, 8, 15,  90, 360,RGB(128,128,0)
 Arc MM.HRES/2+40, MM.VRES/2-16, 0, 15, 280, 100,RGB(128,0,255): DupD()
Pause 1000

CLS 0
Text MM.HRES/2,2,"Circle",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 100
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*8+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,1,1,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Circle filled",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 150
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*8+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,0,1,0,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox r=3",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 100
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*10+10
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox filled",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 70
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*10+10
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B),RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Box",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 250
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*15+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,1,RGB(R,G,B): DupD()
Next i

CLS 0:DupD()
Text MM.HRES/2,2,"Box filled",CT,7,1,RGB(0,255,64):DupD()
Pause 800
For i = 0 To 250
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*15+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,0,0,RGB(R,G,B): DupD()
Next i

'Fonts
CLS 0:DupD()
Text 2,MM.VRES-9  ,"font8",LT,8,1,RGB(magenta)
Text 1,MM.VRES-18 ,"font7",LT,7,1,RGB(red)
Text 1,MM.VRES-30 ,"font1",LT,1,1,RGB(green)
Text 1,MM.VRES-45 ,"font4",LT,4,1,RGB(blue)
Text 1,MM.VRES-63 ,"font2",LT,2,1,RGB(cyan)
Text MM.HRES-1,MM.VRES,"font7 s2",RB,7,2,RGB(yellow)
Text MM.HRES-1,MM.VRES-17,"font8 s2",RB,8,2,RGB(lilac): DupD()
Pause 1000

CLS 0:DupD()
Text MM.HRES/2,1  ,"can we run" ,CT,7,1,RGB(255,255,0)
Text MM.HRES/2,12 ,"Font 9"     ,CT,7,1,RGB(255,255,64)
Text MM.HRES/2,23 ,"VGA-Demo"   ,CT,7,1,RGB(255,255,128):DupD
Pause 1000
 For i=0 To 3
  For j=0 To 7
    Text j*16,i*16,Chr$(Rnd*7+32),LT,9,1,RGB(255,255,255):DupD()
  Next j
 Next
Pause 1000

CLS 0:DupD()
Text MM.HRES/2,1  ,"or something"  ,CT,7,1,RGB(blue)
Text MM.HRES/2,12 ,"others"        ,CT,7,1,RGB(blue)
Text MM.HRES/2,23 ,"thanks to"     ,CT,7,1,RGB(blue)
Text MM.HRES/2,33 ,"javavi"        ,CT,7,1,RGB(yellow)
Text MM.HRES/2,43 ,"best wishes!!!",CT,7,1,RGB(yellow):DupD
Pause 2000

'fake game
CLS 0
Text MM.HRES/2,0,"00000",CT,8,1,RGB(white)
For r=0 To 2: Proc(8*r,MM.VRES-1,6,RGB(blue)):Next 'extra lifes
For r=1 To 8                                      'flyer
 Proc(12*r+2,MM.VRES-51, 8,RGB(yellow))
 Proc(12*r+2,MM.VRES-41,10,RGB(magenta))
 Proc(12*r+2,MM.VRES-31, 9,RGB(red))
Next r
For i = 0 To 50
  j = Sin(i/10)*32
  If i<18 Then Proc(MM.HRES/2,MM.VRES-15-i,2 ,RGB(cyan)) 'paint shot
  Proc(MM.HRES/2-6+j,MM.VRES-1  ,12,RGB(cyan))   :DupD() 'paint ship,show news
  If i<18 Then Proc(MM.HRES/2,MM.VRES-15-i,2 ,0)         'erase shot
  Proc(MM.HRES/2-6+j,MM.VRES-1,12,0)                     'erase ship
  If i=18 Then
    Text MM.HRES/2,0,"00300",CT,8,1,RGB(white)
    Proc(12*5+2,MM.VRES-31, 9,0)
  EndIf
Next i

'Text orientation
CLS 0:DupD()
Text 50        ,1           ,"text"     ,CT,7,1,RGB(255,255,255)
Text 50        ,12          ,"orientation",CT,7,1,RGB(255,255,255)

Text 96        ,2           ,"vertical",CTV,7,1,RGB(255,255,0)
Text MM.HRES/2-20,MM.VRES-12,"inverted",CBI,7,1,RGB(128,64,255)
Text 0         ,2           ,"counter" ,LBU,7,1,RGB(0,255,64)
Text MM.HRES-10,2           ,"clock"   ,RTD,7,1,RGB(255,64,64):DupD()
Pause 2000

CLS 0:DupD()
Text MM.HRES/2,1 ,"Text align",CT,7,1,RGB(0,255,64),0:DupD()
Text 0        ,0      ,"LT" ,LT,2,1,RGB(64,64,255),RGB(64, 0, 0)
Text MM.HRES  ,0      ,"RT" ,RT,2,1,RGB(64,64,255),RGB(64,64, 0)
Text 0        ,MM.VRES,"LB" ,LB,2,1,RGB(64,64,255),RGB(0 ,64,64)
Text MM.HRES  ,MM.VRES,"RB" ,RB,2,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Line 24,         20, MM.HRES-25, MM.VRES-21
Line 24, MM.VRES-21, MM.HRES-25,         20
Text MM.HRES/2,MM.VRES/2 ,"CM"  ,CM,1,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Pause 2000

'demo clock
CLS 0
Text MM.HRES/2,MM.VRES/2+2,Date$    ,CM,2,1,RGB(0,255,255)
Text 2        ,MM.VRES/2-15,Day$(now),LM,2,1,RGB(255,0,255)
Text MM.HRES/2     ,1 ,"thats the end-scene",CT,7,1,RGB(64,64,255)
Box     15,MM.VRES-21, 98,21,0,0,RGB(yellow)
Circle  14,MM.VRES-11,  9, 0,1,0,RGB(yellow)
Circle 113,MM.VRES-11,  9, 0,1,0,RGB(yellow): DupD()
For i = 0 To 60
  Text MM.HRES/2+1,MM.VRES,Time$,CB,8,3,0,RGB(255,255,0): DupD()
Next i

End

'- subs application -----------------------------------------------------------|
Sub Proc(x0%,y0%,q%,c%)'game
Local integer i,a,w,u,x,y
 a=1: w=x0%: u=w+1*q%
 For x=1 To (q%+2)/2
  y=y0%: i=1
  Do
   If i And a Then Pixel w,y,c% :Pixel u,y,c%
   Inc y,-1:Inc i,i
  Loop Until i>a
  a=a*(q%+1-x)/x
  Inc w,1:Inc u,-1
 Next
End Sub

'- subs user display ----------------------------------------------------------|
Sub mm.user_rectangle(x1%,y1%,x2%,y2%,col%)
Local integer C,w,h,i,t
If x1%>x2% Then t=x2%:x2%=x1%:x1%=t '18.Oct.25 note from Peter
If y1%>y2% Then t=y2%:y2%=y1%:y1%=t 'the calling function did not sort!!!
'I hope you know what you do, coords outside screen will be skipped
If x1%<0 Or y1%<0 Or x2%>MM.HRES-1 Or y2%>MM.VRES-1 Then Exit Sub
 C=rgb2222(col%)
 w=x2%-x1%
 h=y2%-y1%
 If 0 Then'h>w Then
  For i=0 To w                                 'why is there no increment???????
   Memory Set WAdr+((MM.VRES-y2%-1  )*MM.HRES)+x1%+i,C,h+1,MM.HRES
  Next i
 Else
  For i=0 To h
   Memory Set WAdr+((MM.VRES-y2%-1+i)*MM.HRES)+x1%  ,C,w+1
  Next i
 End If
End Sub

Sub mm.user_bitmap(x%,y%,w%,h%, s% ,Fc%,Bc%,bitmap%)
'the data-structure is not optimal for this display and "UnPack"
'todo: For more speed always invert ??????
Local integer Fcol,Bcol,i,j,k,m,n,o,p
 If x%<0 Or y%<0 Or x%+w%*s%>MM.HRES Or y%+h%*s%>MM.VRES Then Exit Sub
 Fcol = rgb2222(Fc%)
 Bcol = rgb2222(Bc%)
 Memory unpack bitmap%,bma(),w%*h%,1
 Math Set 1,StBg()
 Math C_Xor StBg(),bma(),StBg()'invert char-pattern to background
 Math SCALE StBg(),Bcol,StBg() 'color all than char with backColor
 Math SCALE bma(),Fcol,bma()   'color char with frontColor
 Math C_Or  bma(),StBg(),bma() 'merge front and back
 j=1 :k=0 :m=7: n = 0 'init
 For i = 0 To w%*h%-1
   If bma(n*8+m)>0 Then 'transparent
     If s% = 1 Then     'scale
       Memory Set WAdr+(((MM.VRES-y%-j)*MM.HRES)+x%+k), bma(n*8+m),1
     Else
       For o = 0 To s%-1
         Memory Set WAdr+(((MM.VRES-y%-j*s%+o)*MM.HRES)+x%+k*s%),bma(n*8+m),s%
       Next o
     End If
   EndIf
   Inc k                     'des count
   If k = w% Then k=0: Inc j 'des line count
   Inc m,-1                  'src pos
   If m < 0  Then m=7: Inc n 'src block
 Next i
End Sub

'-PIO-------------------------------------------------------------------------|
Sub StartHub75Pio()
  PIO dma tx 1,0,0,Pack(),,,HubPixs/4 '32bit = 8 pixel * 2( 2bit color))
End Sub

Sub InitHub75Pio()
Local integer ExeC,PinC,ShiC,Freq, pnl 'PioNextLine
  SetPin gp0,pio1 ' out RED
  SetPin gp1,pio1 ' out GREEN
  SetPin gp2,pio1 ' out BLUE
  SetPin gp3,pio1 ' out red
  SetPin gp4,pio1 ' out green
  SetPin gp5,pio1 ' out blue
  SetPin gp6,pio1 ' out A
  SetPin gp7,pio1 ' out B
  SetPin gp8,pio1 ' out C
  SetPin gp9,pio1 ' out D
  SetPin gp10,pio1' out E
  SetPin gp11,pio1' sideset CLK
  SetPin gp12,pio1' set LATCH
  SetPin gp13,pio1' set /OE
 'pull = 32 bit ; out-shiftdir is right
 'YRGBrgb0 0RGBrgb0 0RGBrgb0 0RGBrgbX ->
 'X=1 marks BOS(BeginOfSequence),Y=1 marks EOL(EndOfLine)
  PIO CLEAR 1
  pnl = Pio(next line 1)
  PIO assemble 1
  .program hub
   .side set 1
   .line next
   .wrap target
    .label NoEof
     Out x,    1  side 0     '1 if there is a BOS,it is here
     Jmp !x,NoBos side 0     'jump over next step if no BOS
      IRQ SET 1   side 0     'BeginOfSequence -> sync SM-ctrl
     .label NoBos
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2 no data
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2 no data
     Out pins, 6  side 0     '2 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out y,    1  side 1 [1] 'clk+if there is an EOL,it is here
    Jmp !y,NoEof  side 0     'no EOL->continue
    IRQ SET 2     side 0 [4] 'EndOfLine-> SM-ctrl:need some time
   .wrap                     '3ticsx64pixs = 192 tics-max delay??
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,6,,gp11,,gp0)' add setpin for debug
  ShiC = Pio(shiftctrl 0,0,0,1,0,1)'InShDir(l),OutShDir(r)
  Freq = 10700000
  PIO init machine 1,0,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out

  'X = Frame-Level, 2 for bit1, 1 for bit0, up to 15 if 5bits(16*9delay=144)
  'Y = address of line, startval 7(1/8), 15(1/16er), 31(1/32)scan
  pnl = Pio(next line 1)
  PIO assemble 1
  .program ctrl
   .side set 1
   .line next
   Pull block         side 0 'get linescan
   Mov isr,osr        side 0 'save for recall
   .wrap target
     Wait 1 irq 1     side 0 'wait for BOS(BeginOfSequence)
     Set x, 15        side 0 '2^(Frames-1)for 4bit:>7,<16 :msb first!
     Mov OSR, x       side 0 'save frame-level, also to shift(/2)
     .label frame            'one sequence => some frames(2bit:2frames)
      Mov y,isr       side 0 'reset line-adr; scan: 1/16(15),1/32(31)
      .label raw             'output of pixel-data is in SM-data
        Wait 1 irq 2  side 0 'wait for EOL(EndOfLine) from SM-data
        Mov pins,y    side 1 'Latch out new address(ABCDE)
        Mov x,OSR     side 1 'Latch reload level for the delay of this line
        .label delay
          IRQ SET 3   side 0 'max[15]x(10) must be < 150(tested)
        Jmp x--,delay side 0 [10]'SM-data is working parallel(shift data)
      Jmp y--,raw     side 0 'dec adr for next line
      Out null,1      side 0 'one frame finished -> dec framelevel(/2)
      Mov x,OSR       side 0 'reload for compare
      Set y,0         side 0 'I thought y is null from the loop,but is not so!!
     Jmp x!=y,frame   side 0 'there are  more frames in the sequence.
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,5,,gp12,,gp6)' add setpin for debug
  PIO init machine 1,1,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,1 '"crtl" starts first and wait immediately for irq from "data"
  PIO write 1,1,1,HubScan

  pnl = Pio(next line 1)
  PIO assemble 1
   .program delay
    .side set 1
    .line next
    .wrap target
      Wait 1 irq 3    side 1 'wait for EOL(EndOfLine) from SM-data
      Nop             side 0 [7]
    .wrap
   .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,,,,gp13,,)' add setpin for debug
  PIO init machine 1,2,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,2 '"delay" starts first and wait immediately for irq from "crtl"
End Sub 'InitHub75Pio()

Sub DupD() 'DisplayUpDate, if used with Tick
 'tic1 = Timer
  Pack4Hub(HubPixs) 'pack,mix and save in ringbuffer
 'tic2 = Timer
 'Print tic2-tic1
End Sub

Sub Pack4Hub( size As integer)
 'interlace Work()-data to Hub75-PIO DMA-array(Pack())
 Memory copy  WAdr, UAdr, size>>1   '01234560 for example bitnames at start
 Memory copy  VAdr, DAdr, size>>1   '0ABCDEF0
 Memory set pAdM,&b01110000,size>>1    'bit1:(MSB)01230000>>0+0ABC0000>>3->y123ABCx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask first bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask first bits from down
 Math shift Tmp2(),    -3,Tmp2(),u'unsigned shift down right!!!!!!
 Math c_OR Tmp2(),Tmp1(),Tmp1()     'add up and down
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Tmp1(0)=Tmp1(0) Or &h1             'now add BeginOfSequence(BOS)-flag
 Memory copy integer pTmp,pAA0,size>>4,1,1  'copy bit1 part to ringbuffer
 Memory set pAdM,&b00001110,size>>1  'bit0:(LSB)00004560<<3+0000DEF0>>3->y456DEFx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask second bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask second bits from down
 Math shift Tmp1(),     3,Tmp1()    'shift them left
 Math c_OR Tmp1(),Tmp2(),Tmp1()     'add down and up
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Memory copy integer pTmp,pAA1,size>>4,1,1  'copy bit0 part to ringbuffer
End Sub 'Pack4Hub()

Sub MyInit()
Local Integer j
 'set EOLs
 For j = 0 To HubH/2-1 'every line two times because of 2byte color
  'AdrM((j*16)+15) = &h8000000000000000'EOL pos = (j*HubW/8)+HubW/8-1
  AdrM((j*HubW/8)+HubW/8-1) = &h8000000000000000'EOL pos =
 Next j
End Sub

'helper ----------------------------------------------------------------------
Function ReadBitMap8x8(s$) As integer
Local integer i,tmp,res
Execute "restore "+s$
  For i = 0 To 7
    Read tmp
    Inc res,tmp<<(i*8)
  Next i
  ReadBitMap8x8 = res
End Function

Function Rgb2222(col%)As integer
Local integer R,G,B
If col%=1 Then rgb2222=0:Exit Function
 R = (col% And &hff0000)>>22
 G = (col% And &hff00)>>14
 B = (col% And &hff)>>6
 rgb2222 = rgb222(R,G,B)
End Function

Function RGB222(R%,B%,G%) As integer
'possible lsb for transparency(XOR-mask)?,msb is empty at the moment
'idea is:get 2x2bit in 2 bytes 0000rrrr,0000gggg,0000bbbb -> yrgbrgbx,yrgbrgbx
Local res%
 res%=1    Or((R% And 1)<<1)Or((R% And 2)<<3)
 res%=res% Or((G% And 1)<<2)Or((G% And 2)<<4)
 res%=res% Or((B% And 1)<<3)Or((B% And 2)<<5)
 RGB222 = res%
End Function

'---------------------------------------------------------------------------------
Sub mm.end
  PIO DMA TX OFF
  PIO stop 1,0
  PIO stop 1,1
  PIO stop 1,2
End Sub

DefineFont #9
08201010
C003C003 C003C003 C003C003 DFFBDFFB DFFBDFFB C003C003 C003C003 C003C003
C003C003 0000E001 FC03F001 FFF0FFC7 E3FF0FFF 800FC03F 80070000 C003C003
C003C003 C003C003 0000C003 FFFFFFFF FFFFFFFF C0030000 C003C003 C003C003
C003C003 80078007 402F000F 77EF63EF F7C6F7EE F000F402 E001E001 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E003E003 FC01F001 7FF8FFE0 0FFE3FFC 800F003F C0078007 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E001E003 FC00F001 3FF87FE0 07FE1FFC 800F003F C0078007 C003C003
End DefineFont