'HUB75 driver 6bit color: 2bit per component(rgb222)                           |
' tested with 32x64/128/256; 64x64/128/256
'
' gp0  RED0  -+            Connection HUB75
' gp1  GREEN0 |
' gp2  BLUE0  SM0 out         +----+
' gp3  RED1   |          RED0 |1 16| GREEN0
' gp4  GREEN1 |         BLUE0 |2 15| GND
' gp5  BLUE1 -+          RED1 |3 14| GREEN1
' gp6  A     -+         BLUE1  4 13| E
' gp7  B      |             A  5 12| B
' gp8  C      SM1 out       C |6 11| D
' gp9  D      |           CLK |7 10| LATCH
' gp10 E     -+           /OE |8  9| GND
' gp11 CLK   -SM0 sset        +----+
' gp12 LATCH -SM1 sset
' gp13 /OE   -SM2 sset
'
' * UserDriver should not be able to use "-1" for transparent text/bitmap *
' * this one use "1" for that, because the LSB will be rejected anyway    *
'
'some displays exchanged GREEN and BLUE->see function Rgb2222(col%)As integer
'
'this version is for Hub75-displays with 1/8,1/16 or 1/32 scan (H:16,32,64)
'the wide has to be a power of 2 -> 32,64,128,256,...
'!!attention: in case of use displays <64-Wide decrease "Set x,15" to 8 in SM1
'------------------------------------------------------------------------------|
Option EXPLICIT
Option DEFAULT NONE
'consts for hub-display
Const HubH    = 32
Const HubW    = 64
Const HubScan = HubH/2-1    'there should be others but they are not supported
Const HubPixs = HubH*HubW
Const HubInts = HubH*HubW/8 '8 bytes = 1 int

' vars for display: buffers and PIO-calculation
Dim integer Work(HubInts-1)

'copy to
Dim integer Uppr(HubInts/2-1) 'for temp data rgb222 in 8bit
Dim integer Down(HubInts/2-1) 'for temp data rgb222 in 8bit

'for mask and shift
Dim integer AdrM(HubInts/2-1) 'EOL mask;             fix after init
Dim integer AddM(HubInts/2-1) 'holds the bitmasks    in Pack4Hub
Dim integer Tmp1(HubInts/2-1) 'for temporary results in Pack4Hub
Dim integer Tmp2(HubInts/2-1) 'for temporary results in Pack4Hub

'for save displaydata(ringbuffer)
Dim integer Pack
PIO make ring buffer Pack,HubPixs 'in byte HubH*HubW

'pointer: used for memory copy
Dim integer WAdr = Peek(VarAddr Work(0))        'upper half of org
Dim integer VAdr = Peek(VarAddr Work(HubInts/2))'lower half of org

Dim integer UAdr = Peek(VarAddr Uppr())         'ptr to upper half copy
Dim integer DAdr = Peek(VarAddr Down())         'ptr to lower half copy
Dim integer pAdM = Peek(VarAddr AddM())         'ptr to bit-mask
Dim integer pTmp = Peek(VarAddr Tmp1())         'ptr to temp results
Dim integer pAA0 = Peek(VarAddr Pack(0))        'ptr to ringbuffer-start bit1
Dim integer pAA1 = Peek(VarAddr Pack(HubInts/2))'ptr to ringbuffer-start bit0

'-for userpanel----------------------------------------------------------------|
'if used Memory Unpack FONTS
Dim integer bma(1024-1)    'memory for unpack "user_bitmap" (forground-color)
Dim integer bmap = Peek(VarAddr bma())
Dim integer StBg(1024-1)   'background-color layer for "user_bitmap"

'-this and that----------------------------------------------------------------|
Dim float Tic1,Tic2 'for debugging/analyse

'display start ----------------------------------------------------------------|
MyInit() 'init EOL-Mask and ColorTable
DupD()   'init buffer before start: blank with BOS and EOLs by "first save"

'init sys-display
On error skip
Option lcdpanel user, HubW, HubH

If (MM.HRES<>HubW)Or(MM.VRES<>HubH) Then
  Print "error: display config wrong!!! first: option lcdpanel disable"
  End
EndIf

'init PIO
'there is a problem with "DMA TX off",I can not stop/restart after Ctrl+C
If MM.Info(PIO TX DMA) Then
  Print "PIO TX DMA still running !!!!"
  PIO DMA TX OFF
  Pause 100
  PIO stop 1,0
  Pause 100
  If MM.Info(PIO TX DMA) Then Print "reset Pico": CPU RESTART
End If

InitHub75Pio()' with PIO CLEAR 1
StartHub75Pio()'start with ringbuffer

'tics--------------------------------------------------------------------------|

'-application consts/vars -----------------------------------------------------|
Dim integer i,j,a,R,G,B,S,C,X,Y

Dim integer px5(4)=(3,26,0,23,13),py5(4)=(0,16,16,0,26)
Dim integer pxt5(4),pyt5(4)                   'for displace
Dim integer px10(9),py10(9),pxt10(9),pyt10(9) 'for generate and displace


' application start -----------------------------------------------------------|
'init poly10
For i=0 To 9
  px10(i)=-(Sin((i*Pi/5))*(4+(i And 1)*7))+11
  py10(i)= (Cos((i*Pi/5))*(4+(i And 1)*7))+11
Next i

'welcome
CLS 0
Text MM.HRES/2,MM.VRES/2-5,"generic"  ,CB,7,1,RGB(255,255,0),1
Text MM.HRES/2,MM.VRES/2  ,"HubDriver",CM,7,1,RGB(0,255,0)  ,1
Text MM.HRES/2,MM.VRES/2+5,"in BASIC" ,CT,7,1,RGB(0,255,255),1:DupD()

Pause 2000
'colortest
CLS 0:DupD()
Text MM.HRES/2,MM.VRES/2,"colortest",CM,7,1,RGB(255,255,0),1:DupD()
Pause 2000
CLS RGB(red):DupD()
Pause 1000
CLS RGB(green):DupD()
Pause 1000
CLS RGB(blue):DupD()
Pause 1000
CLS RGB(yellow):DupD()
Pause 1000
CLS RGB(cyan):DupD()
Pause 1000
CLS RGB(magenta):DupD()
Pause 1000
CLS RGB(grey):DupD()
Pause 1000
CLS (0):DupD()
Pause 1000

'Bitmaps
CLS 0:DupD()
For y = 0 To MM.VRES Step 32
  For x = 0 To MM.HRES Step 32          'chessboard
    Box x   ,y   ,16,16,0,0,RGB(64,64,0)
    Box x+16,y   ,16,16,0,0,RGB(0,0,64)
    Box x   ,y+16,16,16,0,0,RGB(0,0,64)
    Box x+16,y+16,16,16,0,0,RGB(64,64,0):DupD()
  Next x
Next y
GUI Bitmap MM.HRES/2-12,20,&hff8155aa55aa81ff,8,8,1,RGB(green),1
GUI Bitmap MM.HRES/2   , 0,&haa55aa55aa55aa55,8,8,4,RGB(cyan),1
GUI Bitmap MM.HRES/2-32,16,&hff8155aa55aa81ff,8,8,2,RGB(red),0
GUI Bitmap MM.HRES/2+20,20,&haa55aa55aa55aa55,8,8,1,RGB(magenta),0
Text MM.HRES/2,2,"Bitmaps",CT,7,1,RGB(255,255,255)
DupD()
Pause 2000

'lines and
CLS 0
For i = 0 To MM.HRES/2
  Line i,        0, MM.HRES-i-1,MM.VRES/2,1,RGB((i/8 Mod 4)<<6,0,0)
  Line i,MM.VRES/2, MM.HRES-i-1,MM.VRES-1,1,RGB(0,(i/8 Mod 4)<<6,0)
  DupD()
Next i
For i = MM.HRES/2 To MM.HRES-1
  Line i,        0, MM.HRES-i-1,MM.VRES/2,1,RGB(0,0,(i/8 Mod 4)<<6)
  Line i,MM.VRES/2, MM.HRES-i-1,MM.VRES-1,1,RGB((i/8 Mod 4)<<6,(i/8 Mod 4)<<6,0)
  DupD()
Next i

'pixel
For i = 0 To MM.HRES
  a = Sin(i/10)*15+MM.VRES/2
  b = Cos(i/12)*13+MM.VRES/2
  c = Sin((i+15)/15)*10+MM.VRES/2
  Pixel i, a, RGB(0,255,0)
  Pixel i, b, RGB(255,0,255)
  Pixel i, c, RGB(0,255,255): DupD()
Next i
Text MM.HRES/2,1 ,"Lines",CT,7,1,RGB(255,255,255),1:DupD()
Pause 200

'polygon
CLS 0
Text MM.HRES/2,2,"Poly fill",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 30
 R=(Rnd*15)<<4
 G=(Rnd*15)<<4
 B=(Rnd*15)<<4
 x = Rnd*(MM.HRES-14)+1
 y = Rnd*(MM.VRES-14)+1
 Math add px5(), x, pxt5()
 Math add py5(), y, pyt5()
 Polygon 5, pxt5(), pyt5(), RGB(r,g,b), RGB(r,g,b): DupD()
Next i

CLS 0
Text MM.HRES/2,2 ,"Polygon",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 60
 R=(Rnd*15)<<4
 G=(Rnd*15)<<4
 B=(Rnd*15)<<4
 x = Rnd*(MM.HRES-14)
 y = Rnd*(MM.VRES-14)
 Math add px10(), x, pxt10()
 Math add py10(), y, pyt10()
 Polygon 10, pxt10(), pyt10(), RGB(r,g,b): DupD()
Next i

CLS 0
Text 0,0,"Arcs",LT,7,1,RGB(0,255,64):DupD()
 Arc MM.HRES/2,  MM.VRES/2 ,10, 16,  45, 225,RGB(255,0,64)
 Arc MM.HRES/2,  MM.VRES/2 ,10, 16, 225, 360,RGB(64,0,255)
 Arc MM.HRES/2,  MM.VRES/2 , 6, 10,  90, 180,RGB(64,64,128)
 Arc MM.HRES/2,  MM.VRES/2 , 6, 10, 180,  20,RGB(0,64,64):DupD
Pause 1000

CLS 0
Text MM.HRES/2,2,"Circle",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 100
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*5+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,1,1,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Circle f",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 150
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*5+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,0,1,0,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox r=3",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 100
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*9+7
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox fl",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 70
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*9+7
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B),RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Box",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 250
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*10+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,1,RGB(R,G,B): DupD()
Next i

CLS 0:DupD()
Text MM.HRES/2,2,"Box filled",CT,7,1,RGB(0,255,64):DupD()
Pause 800
For i = 0 To 250
  R=(Rnd*15)<<4
  G=(Rnd*15)<<4
  B=(Rnd*15)<<4
  S=Rnd*10+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,0,0,RGB(R,G,B): DupD()
Next i

'Fonts
CLS 0:DupD()
Text MM.HRES/2,  1 ,"font8",CT,8,1,RGB(magenta)
Text MM.HRES/2,  7 ,"font7",CT,7,1,RGB(red)
Text MM.HRES/2, 15 ,"font1",CT,1,1,RGB(green):DupD()
Pause 1000

CLS 0
Text MM.HRES/2,1  ,"can we run" ,CT,7,1,RGB(255,255,0)
Text MM.HRES/2,12 ,"Font 9"     ,CT,7,1,RGB(255,255,64)
Text MM.HRES/2,23 ,"VGA-Demo"   ,CT,7,1,RGB(255,255,128):DupD
Pause 1000

 For i=0 To MM.VRES/16
  For j=0 To MM.HRES/16
    Text j*16,i*16,Chr$(Rnd*7+32),LT,9,1,RGB(255,255,255):DupD()
  Next j
 Next
Pause 1000

'Text orientation
CLS 0:DupD()
Text MM.HRES/2   ,8         ,"text"        ,CT,8,1,RGB(255,255,255)
Text MM.HRES/2   ,0         ," orientation",CT,8,1,RGB(255,255,255)
Text MM.HRES/2-23,2         ,"vertical"    ,LTV,8,1,RGB(255,255,0)
Text MM.HRES/2   ,MM.VRES-7 ,"invert"      ,CBI,8,1,RGB(128,64,255)
Text 0           ,2         ,"counter"     ,LBU,8,1,RGB(0,255,64)
Text MM.HRES-7   ,2         ,"clock"       ,RTD,8,1,RGB(255,64,64):DupD()
Pause 2000

CLS 0:DupD()
Text MM.HRES/2,1,"Text align",CT,8,1,RGB(0,255,64),0:DupD()
Text 0        ,0        ,"LT",LT,8,1,RGB(64,64,255),RGB(64, 0, 0)
Text MM.HRES  ,0        ,"RT",RT,8,1,RGB(64,64,255),RGB(64,64, 0)
Text 0        ,MM.VRES  ,"LB",LB,8,1,RGB(64,64,255),RGB(0 ,64,64)
Text MM.HRES  ,MM.VRES  ,"RB",RB,8,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Text MM.HRES/2,MM.VRES/2,"CM",CM,8,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Pause 2000

CLS 0:DupD()
Text MM.HRES/2,MM.VRES/2,"FIN",CM,1,1,RGB(64,192,64),0:DupD()
Pause 1000
End

'- subs application -----------------------------------------------------------|

'- subs user display ----------------------------------------------------------|
Sub mm.user_rectangle(x1%,y1%,x2%,y2%,col%)
Local integer C,w,h,i,t
If x1%>x2% Then t=x2%:x2%=x1%:x1%=t '18.Oct.25 note from Peter
If y1%>y2% Then t=y2%:y2%=y1%:y1%=t 'the calling function did not sort!!!
'I hope you know what you do, coords outside screen will be skipped
'more tests will decrease speed
If x1%<0 Or y1%<0 Or x2%>MM.HRES-1 Or y2%>MM.VRES-1 Then Exit Sub
 C=rgb2222(col%)
 w=x2%-x1%
 h=y2%-y1%
 If 0 Then'h>w Then
  For i=0 To w            'set byte: why is there no increment for bytes???????
   Memory Set WAdr+((MM.VRES-y2%-1  )*MM.HRES)+x1%+i,C,h+1,MM.HRES
  Next i
 Else
  For i=0 To h
   Memory Set WAdr+((MM.VRES-y2%-1+i)*MM.HRES)+x1%  ,C,w+1
  Next i
 End If
End Sub

Sub mm.user_bitmap(x%,y%,w%,h%, s% ,Fc%,Bc%,bitmap%)
'the data-structure is not optimal for this display and "UnPack"
'todo: For more speed always invert ??????
Local integer Fcol,Bcol,i,j,k,m,n,o,p
'I hope you know what you do, coords outside screen will be skipped
'more tests will decrease speed
 If x%<0 Or y%<0 Or x%+w%*s%>MM.HRES Or y%+h%*s%>MM.VRES Then Exit Sub
 Fcol = rgb2222(Fc%)
 Bcol = rgb2222(Bc%)
 Memory unpack bitmap%,bma(),w%*h%,1
 Math Set 1,StBg()
 Math C_Xor StBg(),bma(),StBg()'invert char-pattern to background
 Math SCALE StBg(),Bcol,StBg() 'color all than char with backColor
 Math SCALE bma(),Fcol,bma()   'color char with frontColor
 Math C_Or  bma(),StBg(),bma() 'merge front and back
 j=1 :k=0 :m=7: n = 0 'init
 For i = 0 To w%*h%-1
   If bma(n*8+m)>0 Then 'transparent
     If s% = 1 Then     'scale
       Memory Set WAdr+(((MM.VRES-y%-j)*MM.HRES)+x%+k), bma(n*8+m),1
     Else
       For o = 0 To s%-1
         Memory Set WAdr+(((MM.VRES-y%-j*s%+o)*MM.HRES)+x%+k*s%),bma(n*8+m),s%
       Next o
     End If
   EndIf
   Inc k                     'des count
   If k = w% Then k=0: Inc j 'des line count
   Inc m,-1                  'src pos
   If m < 0  Then m=7: Inc n 'src block
 Next i
End Sub

'-PIO-------------------------------------------------------------------------|
Sub StartHub75Pio()
  PIO dma tx 1,0,0,Pack(),,,HubInts*2 '32bit = 8 pixel*2(2bit color))
End Sub

Sub InitHub75Pio()
Local integer ExeC,PinC,ShiC,Freq, pnl 'PioNextLine
  SetPin gp0,pio1 ' out RED
  SetPin gp1,pio1 ' out GREEN
  SetPin gp2,pio1 ' out BLUE
  SetPin gp3,pio1 ' out red
  SetPin gp4,pio1 ' out green
  SetPin gp5,pio1 ' out blue
  SetPin gp6,pio1 ' out A
  SetPin gp7,pio1 ' out B
  SetPin gp8,pio1 ' out C
  SetPin gp9,pio1 ' out D
  SetPin gp10,pio1' out E
  SetPin gp11,pio1' sideset CLK
  SetPin gp12,pio1' set LATCH
  SetPin gp13,pio1' set /OE
 'pull = 32 bit ; out-shiftdir is right
 'YRGBrgb0 0RGBrgb0 0RGBrgb0 0RGBrgbX ->
 'X=1 marks BOS(BeginOfSequence),Y=1 marks EOL(EndOfLine)
  PIO CLEAR 1
  pnl = Pio(next line 1)
  PIO assemble 1
  .program hub
   .side set 1
   .line next
   .wrap target
    .label NoEof
     Out x,    1  side 0     '1 if there is a BOS,it is here
     Jmp !x,NoBos side 0     'jump over next step if no BOS
      IRQ SET 1   side 0     'BeginOfSequence -> sync SM-ctrl
     .label NoBos
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2 no data
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2 no data
     Out pins, 6  side 0     '2 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out y,    1  side 1 [1] 'clk+if there is an EOL,it is here
    Jmp !y,NoEof  side 0     'no EOL->continue
    IRQ SET 2     side 0 [4] 'EndOfLine-> SM-ctrl:need some time
   .wrap                     '3ticsx64pixs = 192 tics-max delay??
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,6,,gp11,,gp0)' add setpin for debug
  ShiC = Pio(shiftctrl 0,0,0,1,0,1)'InShDir(l),OutShDir(r)
  Freq = 10700000
  PIO init machine 1,0,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
 'X = Frame-Level, 2 for bit1, 1 for bit0, up to 15 if 5bits(16*9delay=144)
 'Y = address of line, startval 7(1/8), 15(1/16er), 31(1/32)scan
  pnl = Pio(next line 1)
  PIO assemble 1
  .program ctrl
   .side set 1
   .line next
   Pull block         side 0 'get linescan
   Mov isr,osr        side 0 'save for recall
   .wrap target
     Wait 1 irq 1     side 0 'wait for BOS(BeginOfSequence)
     Set x,15         side 0 '2^(Frames+1)for 2bit: max.: 8(W<=32),15(W>=64)!!!!
     Mov OSR, x       side 0 'save frame-level, also to shift(/2)
     .label frame            'one sequence => some frames(2bit:2frames)
      Mov y,isr       side 0 'reset line-adr; scan: 1/16(15),1/32(31)
      .label raw             'output of pixel-data is in SM-data
        Wait 1 irq 2  side 0 'wait for EOL(EndOfLine) from SM-data
        Mov pins,y    side 1 'Latch out new address(ABCDE)
        Mov x,OSR     side 1 'Latch reload level for the delay of this line
        .label delay
          IRQ SET 3   side 0 'max[15]x(10) must be < 150(tested)
        Jmp x--,delay side 0 [10]'SM-data is working parallel(shift data)
      Jmp y--,raw     side 0 'dec adr for next line
      Out null,1      side 0 'one frame finished -> dec framelevel(/2)
      Mov x,OSR       side 0 'reload for compare
      Set y,0         side 0 'I thought y is null from the loop,but is not so!!
     Jmp x!=y,frame   side 0 'there are  more frames in the sequence.
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,5,,gp12,,gp6)' add setpin for debug
  PIO init machine 1,1,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,1 '"crtl" starts first and wait immediately for irq from "data"
  PIO write 1,1,1,HubScan 'init value for number of lines
 'new: own SM for lighting, idea was dimming with fifo ?? need more optimization
  pnl = Pio(next line 1)
  PIO assemble 1
   .program delay
    .side set 1
    .line next
    .wrap target
      Wait 1 irq 3    side 1    'signal from SM-data
      Nop             side 0 [7]'greater val inc brightness max"10"by wide<=64
    .wrap                       'if more needed-> decrease SM0 with more delays
   .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,,,,gp13,,)' add setpin for debug
  PIO init machine 1,2,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,2 '"delay" starts first and wait immediately for irq from "crtl"
End Sub 'InitHub75Pio()

Sub DupD() 'DisplayUpDate, if used with Tick
 'tic1 = Timer
  Pack4Hub(HubPixs) 'interchange and save in ringbuffer
 'tic2 = Timer
 'Print tic2-tic1
End Sub

Sub Pack4Hub( size As integer)
 'interlace Work()-data to Hub75-PIO DMA-array(Pack())
 Memory copy  WAdr, UAdr, size>>1   '01234560 for example bitnames at start
 Memory copy  VAdr, DAdr, size>>1   '0ABCDEF0
 Memory set pAdM,&b01110000,size>>1 'bit1:(MSB)01230000>>0+0ABC0000>>3->y123ABCx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask first bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask first bits from down
 Math shift Tmp2(),    -3,Tmp2(),u'unsigned shift down right!!!!!!
 Math c_OR Tmp2(),Tmp1(),Tmp1()     'add up and down
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Tmp1(0)=Tmp1(0) Or &h1             'now add BeginOfSequence(BOS)-flag
 Memory copy integer pTmp,pAA0,size>>4,1,1  'copy bit1 part to ringbuffer
 Memory set pAdM,&b00001110,size>>1  'bit0:(LSB)00004560<<3+0000DEF0>>3->y456DEFx
 Math c_AND Uppr(),AddM(),Tmp1()    'mask second bits from up
 Math c_AND Down(),AddM(),Tmp2()    'mask second bits from down
 Math shift Tmp1(),     3,Tmp1()    'shift them left
 Math c_OR Tmp1(),Tmp2(),Tmp1()     'add down and up
 Math c_OR Tmp1(),AdrM(),Tmp1()     'add EOL's
 Memory copy integer pTmp,pAA1,size>>4,1,1  'copy bit0 part to ringbuffer
End Sub 'Pack4Hub()

Sub MyInit()
Local Integer j
 'set EOLs
 For j = 0 To HubScan 'todo: memory set integer ????
  AdrM((j*HubW/8)+(HubW/8-1)) = &h8000000000000000'EOL
 Next j
End Sub

'helper ----------------------------------------------------------------------
Function Rgb2222(col%)As integer
Local integer R,G,B
If col%=1 Then rgb2222=0:Exit Function
 R = (col% And &hff0000)>>22
 G = (col% And &hff00)>>14
 B = (col% And &hff)>>6
 rgb2222 = rgb222(R,G,B)
End Function

Function RGB222(R%,B%,G%) As integer
'possible lsb for transparency(XOR-mask)?,msb not in use at the moment
Local res%
 res%=1    Or((R% And 1)<<1)Or((R% And 2)<<3)
 res%=res% Or((G% And 1)<<2)Or((G% And 2)<<4)
 res%=res% Or((B% And 1)<<3)Or((B% And 2)<<5)
 RGB222 = res%
End Function

'---------------------------------------------------------------------------------
Sub mm.end
  PIO DMA TX OFF
  PIO stop 1,0
  PIO stop 1,1
  PIO stop 1,2
End Sub

DefineFont #9
08201010
C003C003 C003C003 C003C003 DFFBDFFB DFFBDFFB C003C003 C003C003 C003C003
C003C003 0000E001 FC03F001 FFF0FFC7 E3FF0FFF 800FC03F 80070000 C003C003
C003C003 C003C003 0000C003 FFFFFFFF FFFFFFFF C0030000 C003C003 C003C003
C003C003 80078007 402F000F 77EF63EF F7C6F7EE F000F402 E001E001 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E003E003 FC01F001 7FF8FFE0 0FFE3FFC 800F003F C0078007 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E001E003 FC00F001 3FF87FE0 07FE1FFC 800F003F C0078007 C003C003
End DefineFont