'HUB75 driver 6bit color: 2bit per component(rgb222)                           |
' tested with 32x64/128/256; 64x64/128/256
'
' gp0  RED0  -+             Connection HUB75
' gp1  GREEN0 |
' gp2  BLUE0  SM0 out          +----+
' gp3  RED1   |           RED0 |1 16| GREEN0
' gp4  GREEN1 |          BLUE0 |2 15| GND
' gp5  BLUE1 -+           RED1 |3 14| GREEN1
' gp6  A     -+          BLUE1  4 13| E
' gp7  B      |              A  5 12| B
' gp8  C      SM1 out        C |6 11| D
' gp9  D      |            CLK |7 10| LATCH
' gp10 E     -+            /OE |8  9| GND
' gp11 CLK   -SM0 sset         +----+
' gp12 LATCH -SM1 sset
' gp13 /OE   -SM2 sset
'
' * UserDriver should not be able to use "-1" for transparent text/bitmap *
' * this one use "1" for that, because the LSB will be rejected anyway    *
'
'some displays exchanged colorchanels or for other routings on board
'see function Rgb2222(col%)As integer
'
'this version is for Hub75-displays with 1/8, 1/16 or 1/32 scan(max.5 Adr-lines)
'the wide has to be a power of 2 -> 32,64,128,256,...(using ringbuffer)
'
'OPTION SDCARD  CS_pin, CLK_pin, MOSI_pin, MISO_pin
'------------------------------------------------------------------------------|
Option EXPLICIT
Option DEFAULT INTEGER

Const MSB     = 128
'consts for hub-display
'if you use stacked displays they must be equal.e.g. 32x128 stack 2 -> 64x64
Const HubStack= 2   '1: no stack; 2: stacked: first botton to second top
Const HubH    = 64  'real hight * stacks => MM.VRES(virtual)
Const HubW    = 128 'real wide  / stacks => MM.HRES(virtual)
Const HubScan = HubH/2-1    'there should be others but they are not supported
Const HubPixs = HubH*HubW
Const HubInts = HubH*HubW/8 '8 bytes = 1 int

'ringbuffer for PIO DMA TX finally contains the twisted display-data
'2 parts: first half:bit0-pattern twisted up/down, second bit1-pattern twisted
Dim Pack
PIO make ring buffer Pack,HubPixs 'in byte HubH*HubW

' vars for display: buffers and PIO-calculation
Dim Work(HubInts-1)    'contains display-data 1pixel = 1byte
Dim Stacker(HubInts-1) 'contains stacked display-data

'copy to separate arrays to be able to use Math-functions
Dim Uppr(HubInts/2-1) 'for temp data rgb222 in 8bit
Dim Down(HubInts/2-1) 'for temp data rgb222 in 8bit

'for precalculated data(MyInit):for use with Math-functions
Dim Ad0M(HubInts/2-1) 'BOS-,EOL- and Brightness-mask for Bit0-frame
Dim Ad1M(HubInts/2-1) 'BOS-,EOL- and Brightness-mask for Bit1-frame

'for mask and shift: separate arrays to be able to use Math-functions
Dim AddM(HubInts/2-1) 'holds the bitmasks    in Pack4Hub
Dim Tmp1(HubInts/2-1) 'for temporary results in Pack4Hub
Dim Tmp2(HubInts/2-1) 'for temporary results in Pack4Hub

'pointer: used for memory functions
Dim WAdr = Peek(VarAddr Work(0))           'upper half of org
Dim VAdr = Peek(VarAddr Work(HubInts/2))   'lower half of org
Dim UAdr = Peek(VarAddr Uppr())            'ptr to upper half copy
Dim DAdr = Peek(VarAddr Down())            'ptr to lower half copy
Dim pAdM = Peek(VarAddr AddM())            'ptr to bit-mask
Dim pTmp = Peek(VarAddr Tmp1())            'ptr to temp results
Dim pAA0 = Peek(VarAddr Pack(0))           'ptr to ringbuffer-start bit1
Dim pAA1 = Peek(VarAddr Pack(HubInts/2))   'ptr to ringbuffer-start bit0
Dim pAd0 = Peek(VarAddr Ad0M())            'ptr to Brightness-mask
Dim pAd1 = Peek(VarAddr Ad1M())            'ptr to Brightness-mask
Dim pSt0 = Peek(VarAddr Stacker(0))        'ptr to stacker
Dim pSt1 = Peek(VarAddr Stacker(HubInts/2))'ptr to stacker
'display start ----------------------------------------------------------------|
Dim float tic1,tic2
Init(50)'init BOS-,EOL- and OEO-Mask; parameter for Brightness(10-100)
        '- also first copy to ringbuffer
'init sys-display config
If (HubStack<0)Or(HubStack>2) Then Print "error: number of stacks!!!":End

On error skip
Option lcdpanel user, HubW/HubStack, HubH*HubStack    'inform system about display config

If (MM.HRES<>HubW/HubStack)Or(MM.VRES<>HubH*HubStack) Then
  Print "error: display config wrong!!! first: option lcdpanel disable"
  End
EndIf

'init PIO
'there is a problem with "DMA TX off",I can not stop/restart after Ctrl+C
If MM.Info(PIO TX DMA) Then
  Print "PIO TX DMA still running !!!!"
  PIO DMA TX OFF
  Pause 100
  PIO stop 1,0
  Pause 100
  If MM.Info(PIO TX DMA) Then Print "resetting Pico": CPU RESTART
End If

InitHub75Pio() 'create the POIs and starts SM1 and SM2, PIO write "scans" to SM1
StartHub75Pio()'start SM0 with DMA TX "ringbuffer"

'-application consts/vars -----------------------------------------------------|
Dim i,j,a,R,G,B,S,C,X,Y

Dim px5(4)=(3,26,0,23,13),py5(4)=(0,16,16,0,26) 'created by pencil
Dim pxt5(4),pyt5(4)                             'for displace
Dim px10(9),py10(9),pxt10(9),pyt10(9)           'for generate and displace

' application start -----------------------------------------------------------|
'init polygon10 "star"
For i=0 To 9
  px10(i)=-(Sin((i*Pi/5))*(4+(i And 1)*7))+11
  py10(i)= (Cos((i*Pi/5))*(4+(i And 1)*7))+11
Next i

CLS 0
Drive "b:"
Load image "ErdBeer.bmp",0,32
DupD()
Pause 1000

'welcome
 CLS 0
 Text MM.HRES/2, 0 ,"Driver in"  ,CT,7,1,RGB(255,255,0)
 Text MM.HRES/2, 9 ,"BASIC with" ,CT,7,1,RGB(0,255,0)
 Text MM.HRES/2,18 ,"brightness" ,CT,8,1,RGB(255,255,255)
 Text MM.HRES/2,25 ,"control"    ,CT,8,1,RGB(0,255,255):DupD()
 Pause 2000

'test place
 CLS 0
 Box  MM.HRES/2   , 1,10,10,0,0,RGB( 64,0,0)
 Box  MM.HRES/2+10, 1,10,10,0,0,RGB(128,0,0)
 Box  MM.HRES/2+20, 1,10,10,0,0,RGB(196,0,0)

 Box  MM.HRES/2   ,11,10,10,0,0,RGB(0, 64,0)
 Box  MM.HRES/2+10,11,10,10,0,0,RGB(0,128,0)
 Box  MM.HRES/2+20,11,10,10,0,0,RGB(0,196,0)

 Box  MM.HRES/2   ,21,10,10,0,0,RGB(0,0, 64)
 Box  MM.HRES/2+10,21,10,10,0,0,RGB(0,0,128)
 Box  MM.HRES/2+20,21,10,10,0,0,RGB(0,0,196)

For i = 1 To 20
 Text 3,MM.VRES/2,Str$(i*5,3)+"%",LM,7,1,RGB(yellow):DupD()
 Init(i*5) 'vari brightness
 Pause 500
Next i
Init(50) '50% brightness

'colortest
CLS 0:DupD()
Text MM.HRES/2,MM.VRES/2,"colortest",CM,7,1,RGB(128,128,128),1:DupD()
Pause 2000
CLS RGB(red):DupD()
Pause 1000
CLS RGB(green):DupD()
Pause 1000
CLS RGB(blue):DupD()
Pause 1000
CLS RGB(yellow):DupD()
Pause 1000
CLS RGB(cyan):DupD()
Pause 1000
CLS RGB(magenta):DupD()
Pause 1000
CLS RGB(grey):DupD()
Pause 1000

'scrolltext demo for static content
CLS 0
Dim string tStr,ScollText="MMBasic is amazing"
 For j = 1 To Len(ScollText)
   R=(Rnd*3)<<6
   G=(Rnd*3)<<6
   B=(Rnd*3)<<6
   tStr = Mid$(ScollText,j,1)
   For i = 0 To 7 'font-wide
     Timer =0
     StripeMoveLeft(MM.VRES/2-5,MM.VRES/2+5)
     Text  MM.HRES+7-i, MM.VRES/2, tStr, RM,1,1,RGB(R,G,B):DupD()
     Do While Timer < 30:Pause 1:Loop 'to reduce the bumpiness @150MHz 2350
   Next i
 Next j
Pause 1000
 For i = 0 To 126
   StripeMoveLeft(MM.VRES/2-5,MM.VRES/2+5):DupD()
   Pause 30
 Next i

'Bitmaps
CLS 0:DupD()
For y = 0 To MM.VRES Step 32
  For x = 0 To MM.HRES Step 32          'chessboard
    Box x   ,y   ,16,16,0,0,RGB(64,64,0)
    Box x+16,y   ,16,16,0,0,RGB(0,0,64)
    Box x   ,y+16,16,16,0,0,RGB(0,0,64)
    Box x+16,y+16,16,16,0,0,RGB(64,64,0):DupD()
  Next x
Next y
GUI Bitmap MM.HRES/2-12,20,&hff8155aa55aa81ff,8,8,1,RGB(green),1
GUI Bitmap MM.HRES/2   , 0,&haa55aa55aa55aa55,8,8,4,RGB(cyan),1
GUI Bitmap MM.HRES/2-32,16,&hff8155aa55aa81ff,8,8,2,RGB(red),0
GUI Bitmap MM.HRES/2+20,20,&haa55aa55aa55aa55,8,8,1,RGB(magenta),0
Text MM.HRES/2,2,"Bitmaps",CT,7,1,RGB(255,255,255)
DupD()
Pause 2000

'lines and
CLS 0
For i = 0 To MM.HRES/2
  Line i,        0, MM.HRES-i-1,MM.VRES/2,1,RGB((i/8 Mod 4)<<6,0,0)
  Line i,MM.VRES/2, MM.HRES-i-1,MM.VRES-1,1,RGB(0,(i/8 Mod 4)<<6,0)
  DupD()
Next i
For i = MM.HRES/2 To MM.HRES-1
  Line i,        0, MM.HRES-i-1,MM.VRES/2,1,RGB(0,0,(i/8 Mod 4)<<6)
  Line i,MM.VRES/2, MM.HRES-i-1,MM.VRES-1,1,RGB((i/8 Mod 4)<<6,(i/8 Mod 4)<<6,0)
  DupD()
Next i

'pixel
For i = 0 To MM.HRES
  a = Sin(i/10)*15+MM.VRES/2
  b = Cos(i/12)*13+MM.VRES/2
  c = Sin((i+15)/15)*10+MM.VRES/2
  Pixel i, a, RGB(0,255,0)
  Pixel i, b, RGB(255,0,255)
  Pixel i, c, RGB(0,255,255): DupD()
Next i
Text MM.HRES/2,1 ,"Lines",CT,7,1,RGB(255,255,255),1:DupD()
Pause 200

'polygon
CLS 0
Text MM.HRES/2,2,"Poly fill",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 30
 R=(Rnd*3)<<6
 G=(Rnd*3)<<6
 B=(Rnd*3)<<6
 x = Rnd*(MM.HRES-14)+1
 y = Rnd*(MM.VRES-14)+1
 Math add px5(), x, pxt5()
 Math add py5(), y, pyt5()
 Polygon 5, pxt5(), pyt5(), RGB(r,g,b), RGB(r,g,b): DupD()
Next i

CLS 0
Text MM.HRES/2,2 ,"Polygon",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 60
 R=(Rnd*3)<<6
 G=(Rnd*3)<<6
 B=(Rnd*3)<<6
 x = Rnd*(MM.HRES-14)
 y = Rnd*(MM.VRES-14)
 Math add px10(), x, pxt10()
 Math add py10(), y, pyt10()
 Polygon 10, pxt10(), pyt10(), RGB(r,g,b): DupD()
Next i

CLS 0
 Arc MM.HRES/2,  MM.VRES/2 ,10, 16,  45, 225,RGB(255,0,64)
 Arc MM.HRES/2,  MM.VRES/2 ,10, 16, 225, 360,RGB(64,0,255)
 Arc MM.HRES/2,  MM.VRES/2 , 6, 10,  90, 180,RGB(64,64,128)
 Arc MM.HRES/2,  MM.VRES/2 , 6, 10, 180,  20,RGB(0,64,64)
 Text 0,0,"Arcs",LT,7,1,RGB(0,255,64),1:DupD()
Pause 1000

CLS 0
Text MM.HRES/2,2,"Circle",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 100
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*5+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,1,1,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Circle fill",CT,8,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 150
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*5+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,0,1,0,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox r=3",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 100
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*9+7
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox fl",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 70
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*9+7
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B),RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Box",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 250
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*10+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,1,RGB(R,G,B): DupD()
Next i

CLS 0:DupD()
Text MM.HRES/2,2,"Box filled",CT,7,1,RGB(0,255,64):DupD()
Pause 800
For i = 0 To 250
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*10+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,0,0,RGB(R,G,B): DupD()
Next i

'Fonts
CLS 0:DupD()
Text MM.HRES/2,  1 ,"font8",CT,8,1,RGB(magenta)
Text MM.HRES/2,  7 ,"font7",CT,7,1,RGB(red)
Text MM.HRES/2, 15 ,"font1",CT,1,1,RGB(green):DupD()
Pause 1000

CLS 0
Text MM.HRES/2,1  ,"can we run" ,CT,7,1,RGB(255,255,0)
Text MM.HRES/2,12 ,"Font 9"     ,CT,7,1,RGB(255,255,64)
Text MM.HRES/2,23 ,"VGA-Demo"   ,CT,7,1,RGB(255,255,128):DupD
Pause 1000

 For i=0 To MM.VRES/16-1
  For j=0 To MM.HRES/16-1
    Text j*16,i*16,Chr$(Rnd*7+32),LT,9,1,RGB(255,255,255):DupD()
  Next j
 Next
Pause 1000

'Text orientation
CLS 0:DupD()
Text MM.HRES/2   ,8         ,"text"        ,CT,8,1,RGB(255,255,255)
Text MM.HRES/2+3 ,0         ,"orientation",CT,8,1,RGB(255,255,255)
Text MM.HRES/2-24,2         ,"vertical"    ,LTV,8,1,RGB(255,255,0)
Text MM.HRES/2   ,MM.VRES-7 ,"invert"      ,CBI,8,1,RGB(128,64,255)
Text 0           ,2         ,"counter"     ,LBU,8,1,RGB(0,255,64)
Text MM.HRES-7   ,2         ,"clock"       ,RTD,8,1,RGB(255,64,64):DupD()
Pause 2000

CLS 0:DupD()
Text MM.HRES/2,1,"Text align",CT,8,1,RGB(0,255,64),0:DupD()
Text 0        ,0        ,"LT",LT,8,1,RGB(64,64,255),RGB(64, 0, 0)
Text MM.HRES  ,0        ,"RT",RT,8,1,RGB(64,64,255),RGB(64,64, 0)
Text 0        ,MM.VRES  ,"LB",LB,8,1,RGB(64,64,255),RGB(0 ,64,64)
Text MM.HRES  ,MM.VRES  ,"RB",RB,8,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Text MM.HRES/2,MM.VRES/2,"CM",CM,8,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Pause 2000

CLS 0:DupD()
Text MM.HRES/2,MM.VRES/2,"FIN",CM,1,1,RGB(64,192,64),0:DupD()
Pause 1000
End

'- subs application -----------------------------------------------------------|
Sub StripeMoveLeft(slY0,slY1)'area
Local slY,slT
If slY0>slY1 Then slT=slY1:slY1=slY0:slY0=slT
 For slY = slY0 To slY1
   Memory copy WAdr+(slY*MM.HRES)+1,WAdr+(slY*MM.HRES),MM.HRES-1,1,1
 Next slY
End Sub

Sub StripeMoveRight(srY0,srY1)'area
Local srY,srT
If srY0>srY1 Then srT=srY1:srY1=srY0:srY0=srT
 For srY = srY0 To srY1
   Memory copy WAdr+(srY*MM.HRES), WAdr+(srY*MM.HRES)+1,MM.HRES-1,1,1
 Next srY
End Sub

'- subs user display ----------------------------------------------------------|
Sub mm.user_rectangle(x1,y1,x2,y2,col)

Local rC,rW,rH,rI,rT,rBas
If x1>x2 Then rT=x2:x2=x1:x1=rT '18.Oct.25 note from Peter
If y1>y2 Then rT=y2:y2=y1:y1=rT 'the calling function did not sort!!!
'I hope you know what you do, coords outside screen will be skipped
'more tests will decrease speed
If x1<0 Or y1<0 Or x2>MM.HRES-1 Or y2>MM.VRES-1 Then Exit Sub
 rC= rgb2222(col)
 rW=x2-x1+1
 rH=y2-y1
 rBas=(MM.VRES-y2-1)*MM.HRES+x1
 For rI=0 To rH
   '       base-address + row*MM.HRES + x-pos,color,count(wide)
   Memory Set WAdr+rBas+rI*MM.HRES,rC,rW
 Next rI
End Sub

Sub mm.user_bitmap(x0,y0,bW,bH,bS,Fc,Bc,bitmap)
Local bI,bK,bM,bO,bDat,bMas,Fcol,Bcol,Acol,bYba
 Fcol= rgb2222(Fc)
 Bcol= rgb2222(Bc)
 bYba= MM.VRES-y0-1            'calc outside loop
 bMas= 0                       'init val to read byte first
 bI  = bW*bH                   'all-count
 bK=0: bM=0                    'init
 Do While bI
   If Not bMas Then            'byte scan fin -> next
    bDat = Peek(BP bitmap)
    bMas = MSB                 'reset mask msb first
   End If                      'mask = 0
   Acol = Choice(bDat And bMas,Fcol,Bcol)
   If (x0+bK)<MM.HRES And Acol Then'not outside & not 0(transparent)
    If bS = 1 Then             'no scale
      Memory Set WAdr+(bYba-bM)*MM.HRES+x0+bK,Acol,1
    Else                       'scale > 1
     For bO = 0 To bS-1
      Memory Set WAdr+(bYba-bM*bS+bO)*MM.HRES+x0+bK*bS,Acol,bS
     Next bO
    EndIf 'scale
   EndIf 'transparent
   Inc bK                      'column-counter
   If bK = bW Then Inc bM: bK = 0 'cr lf(line-conter)
   bMas = bMas>>1              'move mask
   Inc bI,-1                   'bit-countdown
 Loop
End Sub

'-PIO-------------------------------------------------------------------------|
Sub StartHub75Pio()
  PIO dma tx 1,0,0,Pack(),,,HubInts*2 '32bit count = 2*64bit count))
End Sub

Sub InitHub75Pio()
Local ExeC,PinC,ShiC,Freq,pnl'PioNextLine
  SetPin gp0,pio1 ' out RED  -----+
  SetPin gp1,pio1 ' out GREEN     |
  SetPin gp2,pio1 ' out BLUE      SM0 out
  SetPin gp3,pio1 ' out red       |
  SetPin gp4,pio1 ' out green     |
  SetPin gp5,pio1 ' out blue -----+
  SetPin gp6,pio1 ' out A    -----+
  SetPin gp7,pio1 ' out B         |
  SetPin gp8,pio1 ' out C         SM1 out
  SetPin gp9,pio1 ' out D         |
  SetPin gp10,pio1' out E     ----+
  SetPin gp11,pio1' sideset CLK --SM0 sset
  SetPin gp12,pio1' set LATCH   --SM1 sset
  SetPin gp13,pio1' set /OE     --SM2 sset

 'data-structure: bgr for upper half, BGR for lower half
 'YBGRbgr0....ZBGRbgr00BGRbgrZ....0BGRbgrX ->output dir
 'X=1 marks BOS(BeginOfSequence),Y=1 marks EOL(EndOfLine),Z marks EOE(End/OE)
 'pull = 32 bit ; out-shiftdir is right
  PIO CLEAR 1
 'SM0: in pio-prog x is used for all flags one after another
  pnl = Pio(next line 1)
  PIO assemble 1
  .program hub
   .side set 1
   .line next
   .wrap target
    .label NoEof
     Out x,    1  side 0     'if there is a BOS,it is here
     Jmp !x,NoBos side 0     'jump over if no BOS
      IRQ SET 1   side 0     'BOS(BeginOfSequence)-> inform SM1-ctrl
     .label NoBos
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out x,    2  side 1     '1 if there is a BOS,it is here
     Jmp !x,No0EO side 1     'jump over if no EOE(End/OE)
      IRQ SET 4   side 0     'inform SM2: switch leds off(one of two possible)
     .label No0EO            '
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2 no data
     Out pins, 6  side 0     '2 shift RGBrgb-data from osr
     Out x,    2  side 1     '1 if there is a EOE
     Jmp !x,No1EO side 1     'jump over next step if no BOS
      IRQ SET 4   side 0     'inform SM2: switch leds off(one of two possible)
     .label No1EO            '/OE-off
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out x,    1  side 1     'clk+if there is an EOL,it is here
    Jmp !x,NoEof  side 1     'no EOL->continue
    IRQ SET 2     side 0 [4] 'EndOfLine-> SM1-ctrl:need some time for latching
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,6,,gp11,,gp0) 'sideset:gp11(CLK), out:gp0,1,2,3,4,5
  ShiC = Pio(shiftctrl 0,0,0,1,0,1)'InShDir(l),OutShDir(r)
  Freq = 10700000
  PIO init machine 1,0,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
 'SM1: Y = address of line, startval 7(1/8), 15(1/16er), 31(1/32)scan
  pnl = Pio(next line 1)
  PIO assemble 1
  .program ctrl
   .side set 1
   .line next
   Pull block       side 0 'get linescan
   .wrap target
     Mov y,osr      side 0 'reset line-adr; scan: 1/16(15),1/32(31)
     Wait 1 irq 1   side 0 'wait for BOS(BeginOfSequence)->line reset from SM0
     .label row
      Wait 1 irq 2  side 0 'wait for EOL(EndOfLine) from SM0-data
      Mov pins,y    side 0 'Latch and out new address(ABCDE)
      IRQ CLEAR 4   side 1 'because there could be two, the calculated and saver
      IRQ SET 3     side 1 'inform SM2-delay to switch leds on
     Jmp y--,row    side 0 'dec adr for next line
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,5,,gp12,,gp6) 'sideset:gp12(LATCH), out:gp6,7,8,9,10
  PIO init machine 1,1,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,1   'starts read HubScan(blocked) then wait for irq from SM0-data
  PIO write 1,1,1,HubScan 'init value for row-adr, counting down
 'SM2 for brightness; on: at line end, off: triggered by EOE-flag in next line
  pnl = Pio(next line 1)
  PIO assemble 1
   .program delay
    .side set 1
    .line next
    .wrap target
      Wait 1 irq 3    side 1   'leds off  signal from SM1-ctrl
      Wait 1 irq 4    side 0   'leds on   signal from SM0-data
    .wrap
   .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,,,,gp13,,) 'sideset:gp12(/OE)
  PIO init machine 1,2,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,2 '"delay" starts first and wait immediately for irq from "crtl"
End Sub 'InitHub75Pio()


Sub DupD() 'DisplayUpDate
Local dI,ddC=MM.VRES/2
tic1=Timer
 If HubStack >1 Then 'stacked->rearrange by copying to an other array
   For dI=0 To ddC-1
    Memory copy WAdr+(dI+ddC)*MM.HRES, pSt0+dI*HubW        , MM.HRES
    Memory copy WAdr+(dI    )*MM.HRES, pSt0+dI*HubW+MM.HRES, MM.HRES
   Next dI
   Pack4Hub(pSt0,pSt1,HubPixs>>1)
 Else
   Pack4Hub(WAdr,VAdr,HubPixs>>1) 'interchange and save in ringbuffer
 EndIf
tic2=Timer
Print tic2-tic1
End Sub

Sub Pack4Hub(Adr0,Adr1,size)
 'twist and separate by bit-level Work()-data to PIO DMA TX-array(Pack())
 Memory copy Adr0,UAdr,size     '01234560 for example bitnames at start
 Memory copy Adr1,DAdr,size     '0ABCDEF0
 Memory set pAdM,&b01110000,size'bit1:(MSB)01230000>>0+0ABC0000>>3->0123ABC0
 Math c_AND Uppr(),AddM(),Tmp1()'mask first bits from up
 Math c_AND Down(),AddM(),Tmp2()'mask first bits from down
 Math shift Tmp2(),-3,Tmp2(),u  'unsigned shift down right!!!!!!
 Math c_OR Tmp2(),Tmp1(),Tmp1() 'add up and down-temporary results
 Math c_OR Tmp1(),Ad1M(),Tmp1() 'add EOLs and EOEs
 Memory copy pTmp,pAA0,size     'copy bit1 part to ringbuffer
 Memory set pAdM,&b00001110,size'bit0:(LSB)00004560<<3+0000DEF0>>3->0456DEF0
 Math c_AND Uppr(),AddM(),Tmp1()'mask second bits from up
 Math c_AND Down(),AddM(),Tmp2()'mask second bits from down
 Math shift Tmp1(),3,Tmp1()     'shift them left
 Math c_OR Tmp1(),Tmp2(),Tmp1() 'add up and down-temporary results
 Math c_OR Tmp1(),Ad0M(),Tmp1() 'add EOLs and EOEs
 Memory copy pTmp,pAA1,size     'copy bit0 part to ringbuffer
End Sub 'Pack4Hub()

Sub Init(iBr)'5..100
Local iI,iA,iX,iY,iP,iW
 'first clear old data
 Math Set 0 ,Ad0M()
 Math Set 0 ,Ad1M()
 'set BOS (flag BeginOfSequence)
 Memory set integer pAd1,&h1, 1
 Memory set integer pAd0,&h1, 1
 'set EOL (flag EndOfLine)           +saver:last possible pos
 Memory set integer pAd1+(HubW-8),&h8100000000000000, HubScan+1,HubW/8
 Memory set integer pAd0+(HubW-8),&h8100000000000000, HubScan+1,HubW/8
 'set EOE (flag leds off)
 If iBr<  5 Then iBr=5   'min for 32 wide:10%; for 64 wide 5%; for 128: 3%
 If iBr>100 Then iBr=100
 iA = Int(HubW * iBr / 400 - 0.5) 'calc brightness idx
 'timing for bit0
 iX=Int(iA/2)           'calc the double
 iY=iA Mod 2            'calc which one
 iP=1+(iX*4)+iY         'calc byteposition in this line
 iW=Choice(iY,&h80,&h01)'select the pattern
 For iI = 1 To HubScan  'skip first, will be set with pos for bit1
  Memory set Byte pAd0+(iI*HubW)+iP,iW,1
 Next iI
 Memory set Byte pAd1+iP,iW,1'set with pos for bit1
 'timing for bit1
 iP=1+(iA*4)            'calc for bit1-level, should be about twice of bit2-val
 For iI = 1 To HubScan  'skip first, is allready set with pos for bit1
  Memory set Byte pAd1+(iI*HubW)+iP ,&h01,1
 Next iI
 Memory set Byte pAd0+iP,&h01,1'set with pos for bit0
 DupD() 'update data in ringbuffer
End Sub

'helper ----------------------------------------------------------------------

Function RGB222(rrR,rrG,rrB) As integer
'possible lsb for transparency(XOR-mask)?,msb not in use at the moment
Local res
 res=1   Or((rrR And 1)<<1)Or((rrR And 2)<<3)
 res=res Or((rrG And 1)<<2)Or((rrG And 2)<<4)
 res=res Or((rrB And 1)<<3)Or((rrB And 2)<<5)
 RGB222 = res
End Function

Function Rgb2222(col)
Local Rd,Gr,Bl
If col=1 Then rgb2222=0:Exit Function
 Bl = (col And &hf00000)>>22
 Gr = (col And &hf000)>>14
 Rd = (col And &hf0)>>6
 Rgb2222=1 Or(Bl And 1)<<1 Or(Bl And 2)<<3 Or(Rd And 1)<<2 Or(Rd And 2)<<4
 Rgb2222=Rgb2222 Or(Gr And 1)<<3 Or(Gr And 2)<<5
End Function

'---------------------------------------------------------------------------------
Sub mm.end
  PIO DMA TX OFF
  PIO stop 1,2
  PIO stop 1,1
  PIO stop 1,0
  SetPin gp13,dout:Pin(gp13)=1 'set /OE (sometimes it stay on)
End Sub

DefineFont #9
08201010
C003C003 C003C003 C003C003 DFFBDFFB DFFBDFFB C003C003 C003C003 C003C003
C003C003 0000E001 FC03F001 FFF0FFC7 E3FF0FFF 800FC03F 80070000 C003C003
C003C003 C003C003 0000C003 FFFFFFFF FFFFFFFF C0030000 C003C003 C003C003
C003C003 80078007 402F000F 77EF63EF F7C6F7EE F000F402 E001E001 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E003E003 FC01F001 7FF8FFE0 0FFE3FFC 800F003F C0078007 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E001E003 FC00F001 3FF87FE0 07FE1FFC 800F003F C0078007 C003C003
End DefineFont