'RADIATION MONITOR V1.1 - BY D. SCHMAEH - GERMANY - 2022 -------
'
'IMPORTANT! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'To set the count pin before using this program, it is mendatory
'to configure it prior with OPTION COUNT!
'This program uses Pin1 (GP0) for counting. It is triggered by
'a falling edge (2).

MODE 1
SetPin 1, cin, 2 'Set pin 1(GP0) for Count Input on falling edge
SetTick 60000, setProgDrawFlag             'refresh every Minute
Option explicit
RTC gettime

Dim STRING startTime
Dim integer minute=1            'Array position of "minuteCount"
Dim integer one_sixth_hour=1    'Array position of "hourCount"
Dim minutesCount(1440)          'Array to store all minutes of a day
Dim hoursCount(144)             'Array to store 576/4=144*10 minutes
Dim integer avrg_last_ten_min=0 'Average of last ten minutes
Dim integer count_to_ten=0      'Counter for 10min trigger
Dim integer startCount=0        'temp test...
Dim integer count_to_144=0
Dim integer newScaleMinutes=0   'If min > scale & redraw
Dim integer oldCount

'Declare Drawing variables ++++++++++++++++++++++++++++++++++++
Dim integer hourDiagram=0
Dim integer yRow, xCol, xDash, yDash, xScale, mScaleVal, yScale
Dim integer xProgGraph=50, cGraph, cGraph_old
Dim float uScaleIndex, convFactor=0.0028, uScaleVal
Dim integer progDraw, maxedOut
Dim float uScaleMax, yGraphAdj=10

'Declare Counting variables +++++++++++++++++++++++++++++++++++
Dim integer count

'Redraw Graph variables +++++++++++++++++++++++++++++++++++++++
Dim integer xRedrawGraph=50, rGraph, rGraph_old
Dim integer recalcStart

'Declare Stats variables ++++++++++++++++++++++++++++++++++++++
Dim FLOAT cDose, actualDose, lastDose
Dim Float minimum, maximum, average

'Refresh bar variables ++++++++++++++++++++++++++++++++++++++++
Dim FLOAT yRefreshBar
Dim Integer secondTimer

'Chart indicator ++++++++++++++++++++++++++++++++++++++++++++++
Dim Integer x1Tri=52, x2Tri=56, x3Tri=54, chartPos=1
Dim String keyPressed
Dim Float readChart


'Welcome & Version Info etc. ================================
CLS
Box 55,85,530,130,1,RGB(green)   'Info Box Frame
Box 60,90,520,120,2,RGB(black),RGB(green)   'Info Box Frame
Text 125,120,"RADIATION MONITOR - V1.1",,3,1,RGB(black),RGB(green)
Text 175,175,"   BY D. SCHMAEH 2022   ",,2,1,RGB(black),RGB(green)
Pause 2500

CLS
Timer = 0          'reset timer for refresh bar visualization
startTime = Time$                        'get start time once
drawAxisGrid()                               'draw chart once

'Draw all chart stuff =======================================
Sub drawAxisGrid
 CLS
 Box 0,2,637,20,1,RGB(green)   'Info Box
 Text 2,7,"RADIATION MONITOR V1.1 - BY D.SCHMAEH",,1,1,RGB(green)
 Box 0,23,637,40,1,RGB(green)  'Info Box

 Box 0,350,637,420,1,RGB(green)   'Bottom Info Box
 Box 349,352,11,125,1,RGB(green)  'Refresh Bar Box
 Line 362,350,362,480,,RGB(green) 'Draw box seperator
 Line 363,458,635,458,,RGB(green) 'Draw box seperator
 Line 0,458,345,458,,RGB(green)   'Draw box seperator
 Line 345,352,345,480,,RGB(green) 'Draw box seperator

 'Draw Table Text ------------------------------
  Text 370,360,"START TIME      :",,1,1,RGB(green)
  Text 510,360,startTime,,1,1,RGB(green)
  Text 370,380,"CUMULATIVE DOSE :",,1,1,RGB(green)
  Text 370,400,"MINIMUM         :",,1,1,RGB(green)
  Text 370,420,"MAXIMUM         :",,1,1,RGB(green)
  Text 370,440,"AVERAGE         :",,1,1,RGB(green)
  Text 370,464,"REFRESH IN      :",,1,1,RGB(green)

 'Draw OPTION / FEATURE Text -------------------
  Text 5,360,"NAVIGATION   (<>)",,1,1,RGB(green)
  Text 5,380,"CALIBRATION  (F1)",,1,1,RGB(green)
  Text 5,400,"SAVE SCREEN  (F2)",,1,1,RGB(green)
  Text 5,420,"LOG TO CARD  (F3)",,1,1,RGB(green)
  Text 5,440,"24h DIAGRAM  (F4)",,1,1,RGB(green)

 'Draw dotted Grit -----------------------------
 For yRow=100 To 300 Step 20 'Draw Rows (300-100=200 -> 200/20 = 10 rows)
  For xCol=50 To 626 Step 24 'Draw Columns (626-50=576 -> 576/24 = 24 columns)
   Line xCol,yRow,xCol,yRow,,RGB(green)
  Next xCol
 Next yRow

 'Draw solid Axis ----------------------------------
 Line 50,300,626,300,,RGB(green)        'Draw X-axis
 Line 50,100,50,300,,RGB(green)         'Draw Y-axis

 'Draw dashed lines --------------------------------
 For xDash=50 To 626 Step 24          'Draw dashed X
  Line xDash,297,xDash,305,,RGB(red)
 Next xDash

 For yDash=100 To 300 Step 20         'Draw dashed Y
  Line 45,yDash,53,yDash,,RGB(red)
 Next yDash

 'Labels --------------------------------------------
 Text 1,70,"uSv/h ",,1,1                       'uSv/h
If hourDiagram = 0 Then
 Text 626,305,"t ",,1,1                         'Time
EndIf
 Text 1,30,"uSv/h: ",,1,1,RGB(green)      'draw uSv/h
 Text 370,30,"CPM :",,1,1,RGB(green)      'draw CPM

If hourDiagram = 0 Then ' Draw minute Diagram -------
 For xScale=40 To 626 Step 120
  Text xScale,310,Str$(mScaleVal),,1,1 'Minutes Scale
  mScaleVal=mScaleVal+30
 Next xScale
 mScaleVal=0        'Reset value for the next trigger

 For xScale=40 To 626 Step 120
  Text xScale,325,"Min",,1,1 'Minutes Scale
  mScaleVal=mScaleVal+30
 Next xScale
 mScaleVal=0        'Reset value for the next trigger

Else 'Draw hour diagram -----------------------------
 For xScale=45 To 261 Step 24 'Draw hours 0 to 9
  Text xScale,310,Str$(mScaleVal),,1,1 'Hour Scale
  mScaleVal=mScaleVal+1
 Next xScale
 mScaleVal=10       'set for seamles continuation of scale

 For xScale=280 To 624 Step 24 'Draw hours 10 to 24
  Text xScale,310,Str$(mScaleVal),,1,1 'Hour Scale
  mScaleVal=mScaleVal+1
 Next xScale
 mScaleVal=0        'Reset value for the next trigger

  Text 620,325,"h",,1,1 'Hour Scale

EndIf

 uScaleVal=(20/yGraphAdj)*convFactor

 For yScale=295 To 95 Step -20
  Text 1,yScale,Str$(uScaleIndex,2,2),,1,1'uSv/h Scale w/ 2 dec. pl.
  uScaleIndex=uScaleIndex+uScaleVal
 Next yScale
 uScaleIndex=0       'Reset value for the next trigger

End Sub

'MAIN LOOP #########################################################
Do

  If count <> oldCount Then
    Play Tone 2700,5400,2
    oldCount = count
  EndIf

  count = Pin(1)                             'Get actual counts


  refreshBar()                               'Draw refresh bar
  readKeystrokes()                           'Position in Chart

  If minute =1440 Then              '24h-limit reached, reset everything
    totalReset()
  EndIf

  If one_sixth_hour >=144 Then      'Reset 24h values
    For one_sixth_hour=1 To 144     'Cycle through every array value
      hoursCount(one_sixth_hour)=0  'Set every value zero
    Next
    one_sixth_hour=1                'Reset
    If hourDiagram=1 Then           'If 24h view active
      drawAxisGrid()                'Redraw
    EndIf
  EndIf

  If progDraw Then                  'Every minute progress drawing the Graph
    everyTenMinutes()               'Check if it's time to store in hourCount()
    minutesCount(minute)=count      'Store actual CPM to Array
    checkMaxScale()                 'Check if scale is maxed out
    doTheStats()                    'Do the stats math
    Box 349,352,11,125,1,RGB(green),RGB(black)  'Reset Refresh Bar Box
    If maxedOut=0 Then              'Not maxed out
     If hourDiagram=0 Then
      drawGraph()
     EndIf
      minute = minute+1             'Increment minute
      progDraw = 0
      count = 0
      Pin(1)= 0
      Box 0,23,637,40,1,RGB(green),RGB(black)        'Redraw Info Box
      Text 1,30,"uSv/h: ",,1,1,RGB(green)            'Redraw uSv/h
      Text 370,30,"CPM :",,1,1,RGB(green)            'Redraw CPM
    EndIf
  EndIf

  If xProgGraph=626 And count_to_144 = 144 Then   'If End of Scale, redraw
    xProgGraph=50           'Reset Graph x-axis progress pixel to 50
    xRedrawGraph=50
    cGraph=0
    cGraph_old=0
    rGraph=0
    rGraph_old=0
    drawAxisGrid()
  EndIf

 'Draw Time & Date -----------------------------
  Text 520,7,"TIME: "+Time$,,1,1,RGB(green)
  Text 370,7,"DATE: "+Date$,,1,1,RGB(green)
 'Draw Counts & uSv/h --------------------------
  Text 410,30,Str$(count),,5,1
  Text 50,30,Str$(count * convFactor),,5,1

Loop
'###########################################################

'Draw Graph -----------------------------------------------
Sub drawGraph
  xProgGraph = xProgGraph + 4     'Progress 4 pixels on x-axis
  cGraph = count * yGraphAdj      'Graph enlargement
 'Finally Draw Line Graph ----------------------
  Line xProgGraph-4,300-cGraph_old,xProgGraph,300-cGraph,,RGB(green)
  cGraph_old = cGraph
End Sub

'Set flag for periodical graphDraw (every minute triggered) =============
Sub setProgDrawFlag
  progDraw = 1
  Timer = 0                    'Reset timer for refresh bar visualization
End Sub

'Recalculating values for the new graph & draw them =====================
Sub recalcArray
If hourDiagram = 0 Then 'If in "minute view"
 For recalcStart=newScaleMinutes+1 To minute-1
    xRedrawGraph = xRedrawGraph + 4
    rGraph = minutesCount(recalcStart) * yGraphAdj    'Graph enlargement
    'Redraw Line Graph --------------------------------------------------
    Line xRedrawGraph-4,300-rGraph_old,xRedrawGraph,300-rGraph,,RGB(green)
    rGraph_old = rGraph
  Next recalcStart
  xProgGraph = xRedrawGraph  'Assign coordinates to regular graph drawing
  cGraph = rGraph            'to seamlingless fit the two lines
  cGraph_old = rGraph_old    ' ...
  xRedrawGraph = 50          'Reset for new round
  rGraph_old = 0             'Reset for new round
Else                    'Else we are in 24h view
 For recalcStart=1 To one_sixth_hour-1
    xRedrawGraph = xRedrawGraph + 4
    rGraph = hoursCount(recalcStart) * yGraphAdj    'Graph enlargement
    'Redraw Line Graph --------------------------------------------------
    Line xRedrawGraph-4,300-rGraph_old,xRedrawGraph,300-rGraph,,RGB(green)
    rGraph_old = rGraph
  Next recalcStart
  xProgGraph = xRedrawGraph  'Assign coordinates to regular graph drawing
  cGraph = rGraph            'to seamlingless fit the two lines
  cGraph_old = rGraph_old    ' ...
  xRedrawGraph = 50          'Reset for new round
  rGraph_old = 0             'Reset for new round
EndIf

End Sub

'Check whether a new scale is needed =========================================
Sub checkMaxScale
  uScaleMax=(200/yGraphAdj)*convFactor
  Do While count*convFactor > uScaleMax   'Time to adj. Graph & Scale?
    yGraphAdj=yGraphAdj-0.02              'Set new "scale factor"
    uScaleMax=(200/yGraphAdj)*convFactor  'Set scale maximum
    maxedOut=1
  Loop

  If maxedOut=1 Then
    drawAxisGrid()
    recalcArray()
    maxedOut=0
  EndIf

End Sub

'Calc. & print all the stats =================================================
Sub doTheStats
'Cumulative dose Math -------------------------
 actualDose = count * convFactor 'Calc. cumulative dose
 cDose = actualDose + lastDose
 lastDose = cDose

 If minute = 1 Then
  minimum = actualDose 'Set the minimum for the first minute as initial value
 EndIf

 Text 510,380,Str$(cDose,0,2)+" uSv",,1,1,RGB(green)

 'Minimum uSv ---------------------------------
 If actualDose < minimum And minute > 1 Then
  minimum = actualDose
 EndIf
 Text 510,400,Str$(minimum,0,2)+" uSv",,1,1,RGB(green)

 'Maximum uSv ---------------------------------
 If minute >=2 Then
  maximum = Math(MAX minutesCount())
  maximum = maximum * convFactor
  Text 510,420,Str$(maximum,0,2)+" uSv",,1,1,RGB(green)
 EndIf
 'Average uSv ---------------------------------
 If minute >= 2 Then
  average = Math(SUM minutesCount())
  average = average * convFactor
  average = average / minute
  Text 510,440,Str$(average,0,2)+" uSv",,1,1,RGB(green)
 EndIf
End Sub

'Just show the stats, don't compute! =========================================
Sub justShowStats
   Text 510,380,Str$(cDose,0,2)+" uSv",,1,1,RGB(green)
   Text 510,400,Str$(minimum,0,2)+" uSv",,1,1,RGB(green)
   Text 510,420,Str$(maximum,0,2)+" uSv",,1,1,RGB(green)
   Text 510,440,Str$(average,0,2)+" uSv",,1,1,RGB(green)
End Sub


'Refresh bar calc. and visual ================================================
Sub refreshBar
 secondTimer = Timer/1000
 Text 510,464,Str$(60-secondTimer,2,0)+" Sec.",,1,1,RGB(green)
 Box 352,355,5,secondTimer*2,1,RGB(green),RGB(green) 'refresh bar
End Sub

'Read keystrokes / action  ===================================================
Sub readKeystrokes

 keyPressed=Inkey$                        'Get Keystroke

  'If arrow keys are pressed one can navigate through the chart to see the
  'radiation at cursor position (access via array minutesCount(...))
  If keyPressed=Chr$(130) Then            'Left Arrow Key moves cursor 4px left
    Box 52,85,585,5,1,RGB(black),RGB(black)
    If x1Tri >= 56 Then
      x1Tri=x1Tri-4
    EndIf
    If x2Tri >= 60 Then
      x2Tri=x2Tri-4
    EndIf
    If x3Tri >= 58 Then
      x3Tri=x3Tri-4
    EndIf
    If chartPos >= 2 Then
      chartPos=chartPos-1
    EndIf
    Triangle x1Tri,85,x2Tri,85,x3Tri,88,RGB(green),1
   If hourDiagram = 0 Then
    readChart = minutesCount(chartPos+newScaleMinutes)    'Get Array Data
    Text 5,464,"> "+Str$(readChart*convFactor,2,3)+" uSv/h ",,1,1,RGB(green)
    Text 150,464,"(Min: "+Str$(chartPos+newScaleMinutes,3,0)+")",,1,1,RGB(green)
   Else
    readChart = hoursCount(chartPos)      'Get Array Data
    Text 5,464,"> "+Str$(readChart*convFactor,2,3)+" uSv/h ",,1,1,RGB(green)
    Text 150,464,"(Min: "+Str$(chartPos*10,3,0)+")",,1,1,RGB(green)
   EndIf
  EndIf

  If keyPressed=Chr$(131) Then            'Right Arrow Key moves cursor 4px right
    Box 52,85,585,5,1,RGB(black),RGB(black)
    If x1Tri <= 620 Then
      x1Tri=x1Tri+4
    EndIf
    If x2Tri <= 624 Then
      x2Tri=x2Tri+4
    EndIf
    If x3Tri <= 622 Then
      x3Tri=x3Tri+4
    EndIf
    If chartPos >=1 And chartPos <= 143 Then
      chartPos=chartPos+1
    EndIf
    Triangle x1Tri,85,x2Tri,85,x3Tri,88,RGB(green),1
   If hourDiagram = 0 Then
    readChart = minutesCount(chartPos+newScaleMinutes)    'Get Array Data
    Text 5,464,"> "+Str$(readChart*convFactor,2,3)+" uSv/h ",,1,1,RGB(green)
    Text 150,464,"(Min: "+Str$(chartPos+newScaleMinutes,3,0)+")",,1,1,RGB(green)
   Else
    readChart = hoursCount(chartPos)      'Get Array Data
    Text 5,464,"> "+Str$(readChart*convFactor,2,3)+" uSv/h ",,1,1,RGB(green)
    Text 150,464,"(Min: "+Str$(chartPos*10,3,0)+")",,1,1,RGB(green)
   EndIf
  EndIf


  If keyPressed=Chr$(148) Then            'If F4-key (148) pressed...
    If hourDiagram=0 Then                 'Switch to 24h mode
      hourDiagram=1
      drawAxisGrid()
      recalcArray()                       'Recalculate Array
      justShowStats()                     'Show Stats, NOT compute!
    Else
      hourDiagram=0                       'Switch to minute mode
      drawAxisGrid()
      recalcArray()                       'Recalculate Array
      justShowStats()                     'Show Stats, NOT compute!
    EndIf
  EndIf


  If keyPressed=Chr$(146) Then            'If F2-key (146) pressed...
    Text 5,464,"> SAVE IMAGE...                   ",,1,1,RGB(green)
    Save image "geiger"
    Text 5,464,"> IMAGE SAVED!                    ",,1,1,RGB(green)
  EndIf


  If keyPressed=Chr$(145) Then            'If F1-key (145) pressed...
    Box 0,2,637,345,1,RGB(green),RGB(green)   'Info Box
    Box 60,90,520,120,4,RGB(black),RGB(green)   'Info Box Frame
    Text 70,100,"SYSTEM HALTED - WAIT FOR INPUT ",,3,1,RGB(black),RGB(green)
    Text 185,150,"(uSv/h = CPM * CALIBRATION FACTOR) ",,1,1,RGB(black),RGB(green)
    Text 240,170,"CURRENT VALUE: "+Str$(convFactor),,1,1,RGB(black),RGB(green)
    Text 5,464,"> ",,1,1,RGB(green)
    Input "ENTER CALIBRATION FACTOR: ", convFactor

    'Reset all variables ---------------
    totalReset()
  EndIf
End Sub


Sub everyTenMinutes
  If count_to_ten = 10 Then   'Time to get last ten readings
    For startCount=minute To minute-10 Step-1
      avrg_last_ten_min = avrg_last_ten_min + minutesCount(startCount)
    Next startCount
    avrg_last_ten_min=avrg_last_ten_min/10'Calculate avrg of last ten readings
    hoursCount(one_sixth_hour) = avrg_last_ten_min  'Save avrg to array
    one_sixth_hour = one_sixth_hour+1     'increment array index
   ' unsure if this makes sense:
    If hourDiagram = 1 Then
   '   drawGraph()
      recalcArray()
    EndIf

  EndIf

  If count_to_ten >= 10 Then
    count_to_ten = 0
  EndIf

    If count_to_144 = 144 Then
      newScaleMinutes=newScaleMinutes+144
      count_to_144 = 0
    EndIf

  count_to_ten = count_to_ten+1
  count_to_144 = count_to_144+1
End Sub


Sub totalReset
    'Reset all variables ---------------
    For minute=1 To 1440
     minutesCount(minute)=0
    Next minute
    minute=1
    startCount=0
    xProgGraph=50
    cGraph=0
    cGraph_old=0
    progDraw=0
    maxedOut=0
    yGraphAdj=10
    count=0
    Pin(1)=0
    xRedrawGraph=50
    rGraph=0
    rGraph_old=0
    cDose=0
    actualDose=0
    lastDose=0
    minimum=0
    maximum=0
    average=0
    yRefreshBar=0
    secondTimer=0
    readChart=0
    x1Tri=52
    x2Tri=56
    x3Tri=54
    chartPos=1
    avrg_last_ten_min=0
    count_to_ten=0
    count_to_144=0
    newScaleMinutes=0
    Timer =0
    startTime=Time$
    CLS
    drawAxisGrid()
End Sub
