'Example Touch control CST328

'General Info:
'n: Number of fingers detected
'Int: Interrupt detected flag

'Description of variables 1st finger:
'f1 : Status of 1st finger (0=not detected, 6=finger detected)
'x1 : upper eight bits of X-Position
'y1 : upper eight bits of y-Position
'xy1: upper 4 bits X_Coordinate value & lower 4 bits Y_Coordinate value
'p1: pressue finger (diameter)


'Description of variables 2nd finger:
'f2 : Status of 1st finger (0=not detected, 6=finger detected)
'x2 : upper eight bits of X-Position
'y2 : upper eight bits of y-Position
'xy2: upper 4 bits X_Coordinate value & lower 4 bits Y_Coordinate value
'p2: pressue finger (diameter)

'Up to 5 fingers can be detected. Adresses see last 2 pages of datasheet.


SetPin gp18,intb,SUB_TEST 'Define interrupt-pin & name of interrupt subroutine

'Start Main Program:

Do

'If 1 finger detected:
If int=1 And n=1 Then
xc1=(x1*16) Or ((xy1 And &HF0)/16)'calculate x coordinate of portrait mode
yc1=(y1*16) Or (xy1 And &H0F)'calculate y coordinate of portrait mode
Pixel 320-yc1,xc1,RGB(red)'plot pixel adapted to landscape mode
int=0' Reset interrupt flag
EndIf

'If 2 fingers detected:
If int=1 And n=2 Then
xc1=(x1*16) Or ((xy1 And &HF0)/16)
yc1=(y1*16) Or (xy1 And &H0F)
Pixel 320-yc1,xc1,RGB(green)
xc2=(x2*16) Or ((xy2 And &HF0)/16)
yc2=(y2*16) Or (xy2 And &H0F)
Pixel 320-yc2,xc2,RGB(red)
int=0
EndIf

'If 3 fingers detected:
If int=1 And n=3 Then
CLS 'Clear screen
int=0
EndIf

'If 4 fingers detected:
If int=1 And n=4 Then
Text 80,100,"4 Fingers detected"
int=0
EndIf

'If 5 fingers detected:
If int=1 And n=5 Then
Print f1;" ";x1;" ";y1;" ";xy1;" ";p1;" ";n;"   ";
Print f2;" ";x2;" ";y2;" ";xy2;" ";p2
Int=0
EndIf

Loop




Sub SUB_TEST 'Interrupt subroutine
'Select register adress of 1st finger status(0xD000):
I2C2 write &H1A,0,2,&HD0,&H00
'Read register 1st finger status (not pressed=H00,pressed=H06):
I2C2 read &H1A,0,1,f1
'Select register adress upper X coordinate 1st finger(0xD001):
I2C2 write &H1A,0,2,&HD0,&H01
'Read register upper x coordinate 1st finger (X_Position>>4):
I2C2 read &H1A,0,1,x1
'Select register adress upper Y coordinate 1st finger(0xD002):
I2C2 write &H1A,0,2,&HD0,&H02
'Read register upper Y coordinate 1st finger (Y_Position>>4):
I2C2 read &H1A,0,1,y1
'Select register adress of 1st finger X and Y coordinate (0xD003):
I2C2 write &H1A,0,2,&HD0,&H03
'Read combi register (upper 4 bits:X_Position),( lower 4 bits:Y_Position):
I2C2 read &H1A,0,1,xy1
'Select register adress of 1st finger pressure value (0xD004):
I2C2 write &H1A,0,2,&HD0,&H04
'Read register of 1s finger pressure value:
I2C2 read &H1A,0,1,p1
'Select register adress of number of fingers detected:
I2C2 write &H1A,0,2,&HD0,&H05
'Read number of fingers detected on the screen:
I2C2 read &H1A,0,1,n


'From here the registers of the 2nd finger will be evaluated

'Select register adress of 2nd finger status(0xD007)
I2C2 write &H1A,0,2,&HD0,&H07
'Read register 2nd finger status (not pressed=H00,pressed=H16):
I2C2 read &H1A,0,1,f2
'Select register adress upper X coordinate 2nd finger(0xD008):
I2C2 write &H1A,0,2,&HD0,&H08
'Read register upper x coordinate 2nd finger (X_Position>>4):
I2C2 read &H1A,0,1,x2
'Select register adress upper Y coordinate 2nd finger(0xD009):
I2C2 write &H1A,0,2,&HD0,&H09
'Read register upper Y coordinate 2nd finger (Y_Position>>4):
I2C2 read &H1A,0,1,y2
'Select register adress of 1st finger X and Y coordinate (0xD00A):
I2C2 write &H1A,0,2,&HD0,&H0A
'Read combi register (upper 4 bits:X_Position),( lower 4 bits:Y_Position).
I2C2 read &H1A,0,1,xy2
'Select register adress of 2nd finger pressure value (0xD00B):
I2C2 write &H1A,0,2,&HD0,&H0B
'Read register of 2nd finger pressure value
I2C2 read &H1A,0,1,p2

Int=1 'Set interrupt flag

'From here registers/data for 3rd to 5th finger can be read accordingly
'Adresses see last pages of datasheet.

End Sub
                                                                                                      