'Routine to take over RTC-Data from PCF85063A into MMBasic during startup.
'In addition for battery only operation the BAT_EN signal will be set after
'MMBasic has started.In this case the BAT_PWR button must be pressed
'until startup has been performed.

Sub MM.STARTUP
'Specify GP26 for battery enable signal(BAT_EN):
SetPin GP26,dout
'Set GP26 if MMBasic has been startet to allow batter operation:
Pin(GP26)=1
Dim A%(11)
'Set pointer to  adress &H04:
I2C2 write &H51,0,1,&H04
'Read adresses &H04 to &H0A:
I2C2 read &H51,0,7,A%()
'Check if RTC-Oscillator failure bit has been set:
If (A%(0)>89) Then Text 100,80,"RTC-Failure":A%(0)=0

'Convert BCD-values to Decimal:
For i=0 To 6
A%(i)=(A%(i)>>4)*10+(A%(i) And 15)
Next i

'Set mmBasic Date and Time:
Date$=Str$(A%(3))+"-"+Str$(A%(5))+"-"+Str$(A%(6))
Time$=Str$(A%(2))+":"+Str$(A%(1))+":"+Str$(A%(0))

'Demo/Test-part only:
SetPin GP27,ain' Set GP27 to monitor battery voltage
Do
For i=10 To 200
Text i,100,Time$
Text i,120,Date$
Text i,140,Str$(U_Bat)
Pause 1000
U_Bat=3.0282*Pin(gp27)
If U_Bat<4 Then Pin(GP26)=0'Switch off if battery voltage<4V
Text i,100,"           "
Text i,120,"           "
Text i,140,"           "
Next i
Loop

End Sub
                                       