' ClockClock24 By K. Moore 21/09/22
' adapted for VGA by Volhout

' turn off default typing and force explicit typing
Option EXPLICIT
Option DEFAULT NONE
MODE 1
FRAMEBUFFER create
FRAMEBUFFER write f
' Screen = 640*480
Const width = 640
Const heigh = 480
' colours used
Const c.face = RGB(black)
Const c.outline = RGB(white)
Const c.hand = RGB(white)
Const c.bg = RGB(black)
Const c.date = RGB(white)
Colour c.hand, c.bg ' Set the default colours
Const c.dispt = 8000   ' iterations at 'update' rate
Const udanm = 80 '40'80'0 ' animate at approx 5Hz, including calculation time.
Const udidl = 180 ' idle at approx 5Hz, including calculation time.
Const uk=1   ' UK of US date format, set to 0 for US.

Dim Integer ctrx(7)=(40,120,200,280,360,440,520,600)
Dim Integer ctry(2)=(160,240,320), r=40
Dim Integer dig(3),  min, lmin=60, nu, k, j, tim, hand, row, col, col1, ck
Dim Integer hl(1)=((r*0.94), (r*0.8))
' use if drawing rectangular hands
Dim Integer hsx(48), hsy(48), hxl0(48), hyl0(48), hxl1(48), hyl1(48), hxl2(48), hyl2(48), hxl3(48), hyl3(48)
Dim Integer htick(47), htickl(47), hands, hands1, hour, lasthour=24, lr
Dim Integer off, udt, udh, hc, animate, animatetype, handrates=1, aninc, fine=180
Dim Float   hpos(47), hinc(47), aclk
Const  sx=6, wi=10,  fo=-3, psx=0.75

' use for rectangular hands
Dim Integer n(11)=(4,4,4,4,4,4,4,4,4,4,4,4)
Dim Integer mdig(5,9)=(15,45,45,15,45,45,23,23,23,15,45,45,0,0,0,15,45,30,0,0,0,15,30,45,15,0,23,15,45,45,0,0,0,30,15,45,0,45,0,30,30,30,0,23,23,15,45,45,15,45,45,15,45,45,15,0,0,15,45,45)
Dim Integer hdig(5,9)=(0,15,0,30,15,30,23,23,23,20,15,45,0,15,45,30,30,30,0,0,0,30,45,30,15,45,23,15,15,45,15,45,0,30,30,30,15,15,45,30,15,45,0,23,23,30,15,45,0,0,0,30,30,30,0,45,0,30,15,30)
Dim mo$(11) = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"), dt$

TILE 0,0, RGB(cobalt), RGB(black), 40,3
TILE 0,7, RGB(red), RGB(black), 40, 20
TILE 20,7, RGB(green), RGB(Black), 20, 20
animate=0
udt=1
aclk=-60/fine

CLS
' draw clock outline and face.
  For row=0 To 2
    For col=0 To 7
      Circle ctrx(col), ctry(row), r,,,c.outline,c.face
    Next
  Next
'Timer =0
' To reduce display flicker, the clocks are now updated in groups of 6 the 6
' clocks are also spread out across the screen, hopefully to improve the visual
' effect, this has meant having to create 4 arrays for each block of 6, which
' unfortunately are accessed from a case statment, because you can't use multi
' dimension arrarys in a Polygon or Triangle command.
  Do
    min=Val(Mid$(Time$,4,2))
' Check to see if Minute has changed, if so update the new hand positions and rates
    If udt Then
      fine=180
      If animate=2 Then
' select different hand rates and directions
        Select Case handrates
        Case 1
          handinc1
        Case 2
          handinc2
        Case 2
          handinc3
        Case 2
          handinc4
        Case Else
          handinc5
        End Select
      ElseIf animate=3 Then
' Force a time update
        lmin=61
      EndIf
      If min<>lmin Then
        lmin=min
        animate=0
        If Not(min Mod 12) Then
          animate=1
          Inc animatetype,1
          If animatetype>=6 Then
            animatetype=1
            Inc handrates,1
            If handrates>=6 Then
              handrates=1
            EndIf
          EndIf
        EndIf
' Display the date at midnight.
        hour=Val(Left$(Time$, 2))
        If hour<lasthour Then
          lasthour=hour
          dt$=Day$(Date$)
          If uk Then
            dt$=dt$+" "+Left$(Date$, 2)+mo$(Val(Mid$(Date$, 4, 2))-1)
          Else
            dt$=dt$+" "+mo$(Val(Mid$(Date$, 4, 2))-1)+Left$(Date$, 2)
          EndIf
          Text 90, 42, dt$+" "+Right$(Date$,4)+"  ", "LB", 5, 1, c.date
        EndIf
        udt=0 : off=0
' Save away the previous hand positions
        Math add htick(),0,htickl() : Math add htick(),0,hpos()
        If animate=1 Then
' select a different hand start pattern
          Select Case animatetype
          Case 1
            initanimate1
          Case 2
            initanimate4
          Case 3
            initanimate3
          Case 4
            initanimate2
          Case Else
            initanimate5
          End Select
        Else
          handinctime
        EndIf
      EndIf
' slow down looping when nothing happening
      If animate=1 Then Pause udidl
'      Timer =0
' we have new hand positions, so move hand towards their new positions
    Else
      displclocks
    EndIf
'  Next
  Loop

Sub displclocks
Local Integer cx, cy
Local Float hp, rh

 Do While udt=0
  hands=0
  For col=0 To 3
   ck=0
   For hand=0 To 1
    For row=0 To 2
     For lr=0 To 1
      col1=col+lr*4
      hands1=hands+lr*24
      cx=ctrx(col1) : cy=ctry(row)
      Inc hpos(hands1),hinc(hands1)
      hp=hpos(hands1)
      rh=Rad((hp+wi)*sx)
      hsx(ck)= cx+Cos(rh)*fo
      hsy(ck)= cy+Sin(rh)*fo
      Inc ck,1
      rh=Rad((hp-wi)*sx)
      hsx(ck)= cx+Cos(rh)*fo
      hsy(ck)= cy+Sin(rh)*fo
      Inc ck,1
      rh=Rad((hp+psx)*sx)
      hsx(ck)= cx+Cos(rh)*hl(hand)
      hsy(ck)= cy+Sin(rh)*hl(hand)
      Inc ck,1
      rh=Rad((hp-psx)*sx)
      hsx(ck)= cx+Cos(rh)*hl(hand)
      hsy(ck)= cy+Sin(rh)*hl(hand)
      Inc ck,1
     Next
     Inc hands,1
    Next
   Next
' Erase the old hands.
   Select Case col
   Case 0
    Polygon n(),hxl0(),hyl0(),c.face,c.face
   Case 1
    Polygon n(),hxl1(),hyl1(),c.face,c.face
   Case 2
    Polygon n(),hxl2(),hyl2(),c.face,c.face
   Case Else
    Polygon n(),hxl3(),hyl3(),c.face,c.face
   End Select
' Draw new hands.
   Polygon n(),hsx(),hsy(),,c.hand
   FRAMEBUFFER copy f,n,b
' copy the new hands, so we can erase them next time
   Select Case col
   Case 0
    Math add hsx(),0,hxl0():Math add hsy(),0,hyl0()
   Case 1
    Math add hsx(),0,hxl1():Math add hsy(),0,hyl1()
   Case 2
    Math add hsx(),0,hxl2():Math add hsy(),0,hyl2()
   Case Else
    Math add hsx(),0,hxl3():Math add hsy(),0,hyl3()
   End Select
  Next
' check for when we've finished moving hands
  Inc off,1
  If off=fine Then udt=1 : Inc animate,1':Print Timer
  Pause udanm
 Loop
End Sub

Sub handinctime
  dig(2)=min\10 : dig(3)=min Mod 10
  dig(0)=hour\10 : dig(1)=hour Mod 10
  hands=0
  For col=0 To 7
    For hand=0 To 1
      k=col\2
      j=Choice(col Mod 2, 3,0)
' Special case for digit '1' to improve loyout of digits.
      If (k=1 And dig(1)=1) Or (k=3 And Dig(3)=1) Then
        j=Choice(col=2 Or col=6, 3,0)
      EndIf
' reverse the hand directions for each column, just because :-)
      aclk=aclk* -1
      For row=0 To 2
' check for hour or minute hand positions
        htick(hands)=Choice(hand, hdig(row+j,dig(k)), mdig(row+j,dig(k)))
' calculate the difference between old and new hand positions
        hc=htick(hands)-htickl(hands)
        hinc(hands)=Choice(hc, hc/fine, aclk)
        Inc hands,1
      Next
    Next
  Next
End Sub

Sub initanimate1
  hands=0
  For col=0 To 7 Step 2
    For row=0 To 2
      htick(hands)=45
      hc=htick(hands)-htickl(hands)
      hinc(hands)=Choice(hc, hc/fine, aclk)
      htick(hands+3)=0
      hc=htick(hands+3)-htickl(hands+3)
      hinc(hands+3)=Choice(hc, hc/fine, aclk)
      Inc hands,1
    Next
    Inc hands,3
    For row=0 To 2
      htick(hands)=15
      hc=htick(hands)-htickl(hands)
      hinc(hands)=Choice(hc, hc/fine, aclk)
      htick(hands+3)=30
      hc=htick(hands+3)-htickl(hands+3)
      hinc(hands+3)=Choice(hc, hc/fine, aclk)
      Inc hands,1
    Next
    Inc hands,3
  Next
End Sub

Sub handinc1
  aclk=aclk* -1
  For col=0 To 47
    hinc(col)=aclk
  Next
  udt=0 : off=0 : fine=360 ' go round twice
End Sub

Sub initanimate2
  hands=0
  For col=0 To 7
    For row=0 To 2
      htick(hands)=22-col*2
      hc=htick(hands)-htickl(hands)
      hinc(hands)=Choice(hc, hc/fine, aclk)
      htick(hands+3)=52-col*2
      hc=htick(hands+3)-htickl(hands+3)
      hinc(hands+3)=Choice(hc, hc/fine, aclk)
      Inc hands,1
    Next
    Inc hands,3
  Next
End Sub

Sub handinc2
  hands=0
  For col=0 To 7
    For row=0 To 2
      hinc(hands)=aclk/2
      hinc(hands+3)=-aclk
      Inc hands,1
    Next
    Inc hands,3
  Next
  udt=0 : off=0 : fine=360 ' go round twice
End Sub

Sub initanimate3
  hands=0
  For col=0 To 7
    For row=0 To 2
      htick(hands)=22
      hc=htick(hands)-htickl(hands)
      hinc(hands)=Choice(hc, hc/fine, aclk)
      htick(hands+3)=22
      hc=htick(hands+3)-htickl(hands+3)
      hinc(hands+3)=Choice(hc, hc/fine, aclk)
      Inc hands,1
    Next
    Inc hands,3
  Next
End Sub

Sub handinc3
  hands=0
  For col=0 To 7
    For row=0 To 2
      hinc(hands)=aclk
      hinc(hands+3)=-aclk
      Inc hands,1
    Next
    Inc hands,3
  Next
  udt=0 : off=0 : fine=360 ' go round twice
End Sub

Sub initanimate4
  hands=0
  For col=0 To 7 Step 2
    For row=0 To 2
      htick(hands)=30
      hc=htick(hands)-htickl(hands)
      hinc(hands)=Choice(hc, hc/fine, aclk)
      htick(hands+3)=0
      hc=htick(hands+3)-htickl(hands+3)
      hinc(hands+3)=Choice(hc, hc/fine, aclk)
      Inc hands,1
    Next
    Inc hands,3
    For row=0 To 2
      htick(hands)=45
      hc=htick(hands)-htickl(hands)
      hinc(hands)=Choice(hc, hc/fine, aclk)
      htick(hands+3)=15
      hc=htick(hands+3)-htickl(hands+3)
      hinc(hands+3)=Choice(hc, hc/fine, aclk)
      Inc hands,1
    Next
    Inc hands,3
  Next
End Sub

Sub handinc4
  hands=0
  For col=0 To 7 Step 2
    For row=0 To 2
      hinc(hands)=aclk
      hinc(hands+3)=aclk
      Inc hands,1
    Next
    Inc hands,3
    For row=0 To 2
      hinc(hands)=aclk/2
      hinc(hands+3)=aclk/2
      Inc hands,1
    Next
    Inc hands,3
  Next
  udt=0 : off=0 : fine=360 ' go round twice
End Sub

Sub initanimate5
  hands=0
  For col=0 To 7
    For row=0 To 2
      htick(hands)=45
      hc=htick(hands)-htickl(hands)
      hinc(hands)=Choice(hc, hc/fine, aclk)
      htick(hands+3)=15
      hc=htick(hands+3)-htickl(hands+3)
      hinc(hands+3)=Choice(hc, hc/fine, aclk)
      Inc hands,1
    Next
    Inc hands,3
  Next
End Sub

Sub handinc5
  hands=0
  For col=0 To 7
    For row=0 To 2
      hinc(hands)=aclk
      hinc(hands+3)=aclk/2
      Inc hands,1
    Next
    Inc hands,3
  Next
  udt=0 : off=0 : fine=360 ' go round twice
End Sub
