  'flappy bird for picomiteVGA

  'versions
  ' flappy7   first release
  ' flappy8   fixed collision bug, screen corruption in fall
  ' flappy9   fl_day2 background and pipe/animation adaptions
  ' flappy10  sfx added, end game added, fl_day6 background, store scores
  ' flappy11  uses graphics in flash slot in preparation of LCD
  ' flappy11_game_mite  version for Game*Mite

  path$="B:/flappy11/"

  'setup memory and screen
  Option DEFAULT integer
  FRAMEBUFFER layer 9 'foreground layer, mageta = transparent
  FRAMEBUFFER create  'background layer for LCD blit

  If MM.Info(platform)="Game*Mite" Then init_gpio

  'load graphics element index and prepare flash data
  fl_adr=MM.Info(flash address 3) 'load flash start adress
  'flash slot #3 has the exact same start address as the library
  Flash disk load 3, path$+"gfx/gfx.bin",o

  Open path$+"gfx/gfx_index.txt" For input As #1
  Dim indx(26):For i=0 To 25:Input #1,a$:indx(i)=Val(a$)+fl_adr:Next
  Close #1


  'load background on to layer N
  FRAMEBUFFER write F
  Load image path$+"gfx/fl_dayc.bmp"


  'game defines
  h_beat=100    'speed of the game
  gap=90        'between columns
  xb=100        'bird start position (constant)
  yb=100        'bird vertical position
  v=3           'falling speed due to gravity
  xnp=320       'new pipe position
  ynp=40        'new pipe length (default)
  pgap=80       'gap between top and bottom pites
  spr=4         'default bird sprite
  Dim yy(1)     'pipe height last 2 pipes
  pn=1          'pipe number to be shifted in right side
  die=16:hit=17:swoosh=18:wing=19   'sfx samples
  Dim scores(3)=(0,5,10,15) 'default highscore list
  Dim medal$(3)=("no_","b","s","g") 'prefix names for medal graphics


  'get old scores from flash
  Open path$+"score.txt" For input As #1
  For i=1 To 3:Input #1,a$:scores(i)=Val(a$):Next
  Close #1


  'title screen
  FRAMEBUFFER write L:CLS RGB(magenta)
  Blit memory indx(17),70,50 'title
  FRAMEBUFFER merge 9,b
  Pause 3000


  'create start instructions
  CLS RGB(magenta)
  Blit memory indx(18),70,40 'get ready
  Blit memory indx(19),130,110 'tap tap
  FRAMEBUFFER merge 9,b
  Do : Loop While read_input$()=""
  CLS RGB(magenta)


  'init for main game loop
  Pause 500
  Play modfile path$+"sfx/sll3sfx2.mod"
  Pause 500:Timer =0


  'main game loop

  'to distribute the CPU load, the actions are sequenced depending the xnp number
  '320...296: draw a new pipe (pn) at right side
  '295...255: check bird collisions with pipe (pn-2)
  '254      : write number to pipe pn
  '253...231: nothing happens here yet
  '230      : change xpn back to 320.

  Do
    'debug loop time
    'Text 0,0,Right$("00"+Str$(timer,3,0),3)

    'player input through keyboard, clearing buffer, check loop time
    k$=""
    Do
      tmp$=read_input$()
      If tmp$<>"" Then k$=tmp$  'keep last valid key
      Pause 10
    Loop Until Timer>h_beat
    Timer =0


    'determine new bird position and sprite depending player key entry
    Inc v,3                       'falling speed increases
    If v>-2 Then spr=4          'flaps up
    If v>5 Then spr=17:v=10      'to a max of 5
    If k$=" " Then Play modsample wing,4:spr=5:v=-14  '-8 flaps down and you rise
    If yb+v<0 Or yb+v>196 Then
      If pn<3 Then pn=2
      you_die
    EndIf


    'add a new pipe at the right side of the screen
    Inc xnp,-4
    If xnp=(318-gap) Then 'we need a new post
      xnp=320                           'wrap around
      Inc pn,1                          'new pipe
      yy(0)=yy(1):yy(1)=ynp+8           'memory of pipe lenght
      ynp=8*Int(14*Rnd())               'new pipe length defined
    EndIf

    'check collision with pipe (pn-2) that is closest to the bird
    xx=xnp-2*gap
    If xx>76 And xx<=116 And pn>2 Then
      If yb+v<yy(0)+12 Or yb+v>yy(0)+pgap-12 Then you_die
    EndIf
    'number the new pipe
    If xnp=256 Then
      Box xnp+8,2,16,16,1,0,RGB(red)
      writenumber(xnp+11,5,pn)
    EndIf


    'move screen
    Blit 4,0,0,0,319,208
    Line 316,0,316,239,4,RGB(magenta)  'erase old column line for line

    'update bird
    Box xb-4,yb,18,12,1,RGB(magenta),RGB(magenta) 'kill old bird
    yb=yb+v                                       'new bird position
    Blit memory indx(spr-1),xb,yb                 'write new bird

    'write new pipe, when 320>xpn>295
    If xnp>295 Then write_pipe(xnp,ynp)

    FRAMEBUFFER merge 9,b

  Loop


  'keyboard or controller input, can be expanded for controllers
Function read_input$()
  read_input$=""
  a$=Inkey$
  If a$=" " Then
    read_input$=a$
  Else
    If MM.Info(platform)="Game*Mite" Then
      If Pin(gp10)=0 And butn_hld > 3 Then read_input$=" ":butn_hld=0 'if "UP" pressed then output <space>
      Inc butn_hld
    EndIf
  EndIf
End Function

  'write a number n to screen at position x,y
Sub writenumber(x,y,n)
  If n<10 Then
    Blit memory indx(n+6),x+2,y,0    'single digit
  Else
    Blit memory indx(n\10+6),x,y,0    'first digit
    Blit memory indx((n Mod 10)+6),x+5,y,0 'second digit
  EndIf
End Sub


  'create a pipe at xnp from top to ynp, and the antagonist
Sub write_pipe(x,n)
  Local i,j
  For i=0 To n Step 8
    Blit memory indx(0),x,i 'top pipe
  Next
  j=i
  Blit memory indx(2),x,j 'top fitting
  For i=j+12+pgap To 200 Step 8
    Blit memory indx(0),x,i 'bottom pipe
  Next
  Blit memory indx(0),x,201 'last part bottom pipe
  Blit memory indx(1),x,j+pgap 'bottom fitting
End Sub


  'end of game sequence
Sub you_die
  Box xb,yb,16,12,1,RGB(magenta),RGB(magenta) '  'kill old bird (non-smart)

  Play modsample hit,4
  animate_fall
  Play modsample die,4
  Pause 1000 'for freeing SD card SPI bus

  i=arrangescores(pn-2)

  Blit memory indx(20),70,30 'gameover
  Blit memory indx(21),80,90 'scoreboard
  writenumber(80+129,90+27,pn-2)
  writenumber(80+129,90+60,scores(3))
  Blit memory indx(22+i),100,120 'title
  FRAMEBUFFER merge 9,b

  Pause 1000
  Do : Loop While read_input$()=""
  Run
End Sub
                 

  'drop the bird from collision point to the ground
Sub animate_fall
  Blit framebuffer L,F,0,0,0,0,320,240,9  'copy L to F to avoid corruption
  CLS RGB(magenta)                        'clear L
  v=1
  Do
    Box xb,yb,12,16,1,RGB(magenta),RGB(magenta)   'kill old bird
    yb=yb+v
    Blit memory indx(5),xb,yb 'dropping bird
    Pause 50
    FRAMEBUFFER merge 9,b
    v=Min(v+1,8)
  Loop Until yb>196
End Sub


  'sort the scores, and return current score position in the list
Function arrangescores(n)
  scores(0)=n
  Sort scores(),,0  'sort in ascending order
  For i=0 To 3
    If scores(i)=n Then arrangescores=i
  Next
  savescore
End Function


  'write the new score list to flash
Sub savescore
  'save new scores
  Open path$+"score.txt" For output As #1
  For i=1 To 3:Print #1,Str$(scores(i)):Next
  Close #1
End Sub


  'set IO pin direction
Sub init_gpio
  SetPin gp10,din,pullup 'UP key
End Sub
