' Multiple Clocks. By K. Moore 17/12/23
' binary clock is, Seconds, Minutes, Hours, Day of month, Month, Year(less 2000)
' only good till 2063!
' Three touch points are
' Top Right     = Brightness up
' Bottom Right  = Brightness down
' Middle        = move on to ClockClock

' turn off default typing and force explicit typing
Option EXPLICIT
Option DEFAULT NONE
' turn off blinking LED while running
SetPin GP25, DOUT
' Screen = 480*320
Const width = 480
Const height = 320
Const update = 180 ' update at 5Hz
' colours used in the analogue clock
Const c.face = RGB(72, 72, 136)
Const c.bezel = RGB(white)
Const c.majormark = RGB(green)
Const c.minormark = RGB(green)
Const c.hourhand = RGB(yellow)
Const c.minutehand = RGB(cyan)
Const c.secondhand = RGB(red)
Const c.background = RGB(black) '
Const c.displaytime = 4000   ' iterations at 'update' rate
Colour c.bezel, c.background ' Set the default colours

Font 1, 3 ' Set the default font
Dim Integer column, pix, lastmin=60, lastsec=60, brup, dayb=95, eveb=75, nightb=5
Dim Integer hour, lasthour=24, bright, animatetype, handrates, BSTdone
Dim mo$(11) = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")

' Special narrow font for Large Roman numerals
DefineFont #10
05410C08
18180000 18000000 00000018 ' :
1010107C 10101010 7C101010 ' I
82828282 44444444 10282828 ' V
80808080 80808080 FE808080 ' L
44828282 28101028 82828244 ' X
End DefineFont
'
'
'
' set screen backlight to day value
VAR Restore
If bright=0 Then bright=dayb
'Backlight bright

CLS
  Matrix2
  ScrollTime
  AnlgClk(0)
  bubble
  Digi
  WordClock
  Matrix2
  AnlgClk(1)
  Roman
  bubble
  Binary
  AnlgClk(2)
  Matrix2
  Led7seg
  bubble
VAR Save bright, BSTdone
Flash Run 3

Sub bubble
Local Float u(51),w(51),a,p,q,t,h,v=0,x=0
Local Integer g,b,i,j,c(51),d(51),e(51),n(51),nn
Local Integer f(13,41),l(13,41),m(25,41),cc,dd,z,k
Const r=(2*Pi)/235

CLS RGB(black)
t=Rnd*10:h=t+5:Math set 4,e()
't=1
nn=Peek(varaddr n())
cc=Peek(varaddr c())
dd=Peek(varaddr d())
'
For g=0 To 41
 For b=0 To 51
  n(b)=RGB(g*5+49,b*4+50,70*((g+b>30)+(g+b<60)))
  If g<26 And b<13 Then n(b)=RGB(0,160,200)
 Next
Memory pack nn, Peek(varaddr m(0,g)),52,32
Next g
Do
Inc t,0.02:g=0':Print Timer:Timer =0
For i=50 To 255 Step 5
b=0:a=r*i
z=Peek(varaddr f(0,g)):Memory unpack z,cc,52,16
k=Peek(varaddr l(0,g)):Memory unpack k,dd,52,16
Box c(),d(),e(),e(),0,,0
For j=50 To 255 Step 4:u(b)=Sin(i+v)+Sin(x):v=Cos(i+v)+Cos(x):x=u(b)+a+t:w(b)=v:Inc b:Next
Math Scale u(),118,c():Math Scale w(),78,d():Math Add c(),236,c():Math Add d(),158,d()
Memory unpack Peek(varaddr m(0,g)),nn,52,32:Box c(),d(),e(),e(),0,,n()
Memory pack cc,z,52,16:Memory pack dd,k,52,16:Inc g
Next i
Loop Until t>h
End Sub

Sub Led7seg
' Define the coordinates for each segment
Local Integer dig(1,1,6)=(18,40,62,40, 0,48,0,158, 66,48,66,158, 18,153,62,153, 0,164,0,274,66, 164,66,274, 18,268,62,268)
' Define which segment is lit, 9=off
Local Integer num(6,9)=(0,1,2,9,4,5,6, 9,9,2,9,9,5,9, 0,9,2,3,4,9,6, 0,9,2,3,9,5,6, 9,1,2,3,9,5,9, 0,1,9,3,9,5,6, 0,1,9,3,4,5,6, 0,9,2,9,9,5,9, 0,1,2,3,4,5,6, 0,1,2,3,9,5,6)
Local Integer x,y,z,d,i,min,sec,blink, p(4)=(10,120,240,270,380)

  lastmin=60
  CLS
  For i=0 To c.displaytime
    sec=Val(Right$(Time$,2))
    If sec<>lastsec Then
      lastsec=sec
      If blink Then
        blink=0
        Circle p(2), 100, 12, 0, , RGB(RED), RGB(RED)
        Circle p(2), 220, 12, 0, , RGB(RED), RGB(RED)
      Else
        blink=1
        Circle p(2), 100, 12, 0, , RGB(BLACK), RGB(BLACK)
        Circle p(2), 220, 12, 0, , RGB(BLACK), RGB(BLACK)
      EndIf
      min=Val(Mid$(Time$,4,2))
      If min<>lastmin Then
        lastmin=min
        hour=Val(Left$(Time$, 2))
        For z=0 To 4
          If z<>2 Then
            d=Val(Mid$(Time$, z+1,1))
            For x=0 To 6
              If num(x,d)<9) Then
                Line dig(0,0,num(x,d))+p(z), dig(1,0,num(x,d)), dig(0,1,num(x,d))+p(z), dig(1,1,num(x,d)), 15, RGB(Red))
              Else
                Line dig(0,0,x)+p(z), dig(1,0,x), dig(0,1,x)+p(z), dig(1,1,x), 15, RGB(BLACK)
              EndIf
            Next x
          EndIf
        Next z
      EndIf
    EndIf
    Brightness
    Pause update
  Next i
End Sub


Sub AnlgClk( Type As Integer )
Local Integer m, s, ana.r=height/2, ana.x=width/2.8, ana.y=height/2
Local Integer i, y, j=13, k, tip(3)
Local Float xx, yy, r1, r2, r22, tim
Local Integer minutes, hr, sec, handsx(5), handsy(5), handsxl(5), handsyl(5)
Local Integer handcol(1)=(c.hourhand, c.minutehand), h(1)=(3,3), secsx(3), secsy(3)

  CLS
  If Type<>0 Then Inc ana.r,-25:Inc ana.x,8
  Circle ana.x, ana.y, ana.r, 5, 1, c.bezel, c.face
  For i = 0 To 59
    If i Mod 5=0 Then
    Inc j,-1
      For y = -2 To +2
        tim = (i + y/10) : xx = Cos(Rad(tim * 6)) : yy = Sin(Rad(tim * 6))
        r1=Choice(i Mod 15, ana.r - 15, ana.r - 20)
        r2 = ana.r - 5
        Line  ana.x + xx*r1, ana.y - yy*r1, ana.x + xx*r2, ana.y - yy*r2, 1, c.majormark
      Next y
      If Type>0 Then
        k=j+3
        r22=r2
        If k>12 Then Inc k,-12
        If Type=1 Then
          If k>9 Then Inc r22,8
          Text ana.x + xx*(r22+25), ana.y - yy*(r2+19), Str$(k), "CM", 3, 1, RGB(MAGENTA)
        Else
          If k=9 Or k=10 Then Inc r22,-15
          Text ana.x + xx*(r22+42), ana.y - yy*(r2+19), Numeral(k), "CM", 10, 2, RGB(MAGENTA)
        EndIf
      EndIf
    Else
      tim = i : xx = Cos(Rad(tim * 6)) : yy = Sin(Rad(tim * 6))
      r1 = ana.r - 10 : r2 = ana.r - 5
      Line  ana.x + xx*r1, ana.y - yy*r1, ana.x + xx*r2, ana.y - yy*r2, 1, c.majormark
    EndIf
  Next i

' display current date don't disply day of week if fast scrolling date
  Text 270, 32, Day$(Date$), "LB", 5, 1, RGB(ORANGE)
  Text 322, 32, Left$(Date$, 3)+mo$(Val(Mid$(Date$, 4, 2))-1), "LT", 5, 1, RGB(ORANGE)
  Text 362, 65, Right$(Date$,4), "LT", 5, 1, RGB(ORANGE)

  lastmin=60
  handsx(0)=0
  handsxl(0)=0
  For i = 0 To c.displaytime

    s = Val(Right$(Time$,2))
    sec = s-15

    If sec<>lastsec Then
      m = Val(Mid$(Time$, 4, 2))
      minutes = m-15
      tip(0)=ana.r*0.868
      tip(1)=-ana.r*0.375
' blank previous seconds hand
      secsx(0)=GetX(lastsec-0.6, tip(1), ana.x)
      secsy(0)=GetY(lastsec-0.6, tip(1))
      secsx(1)=GetX(lastsec+0.6, tip(1), ana.x)
      secsy(1)=GetY(lastsec+0.6, tip(1))
      secsx(2)=GetX(lastsec-0.2, tip(0), ana.x)
      secsy(2)=GetY(lastsec-0.2, tip(0))
      secsx(3)=GetX(lastsec+0.2, tip(0), ana.x)
      secsy(3)=GetY(lastsec+0.2, tip(0))
      lastsec=sec
      Polygon 4, secsx(), secsy(), c.face, c.face
      If handsx(0)<>0 Then
' Re-draw the hands incase they were blanked by seconds hand
        Polygon h(),handsx(),handsy(),handcol(),handcol()

      EndIf
      If minutes<>lastmin Then
        lastmin=minutes
        hour=Val(Left$(Time$, 2))
        hr = hour-3+m/60
        If hr >= 12 Then Inc hr,-12
        Math add handsx(),0,handsxl() : Math add handsy(),0,handsyl()
        tip(2)=ana.r*0.075
        tip(3)=ana.r*0.05
        handsx(0) = GetX((hr*5)-15, tip(2), ana.x)
        handsy(0) = GetY((hr*5)-15, tip(2))
        handsx(1) = GetX((hr*5)+15, tip(2), ana.x)
        handsy(1) = GetY((hr*5)+15, tip(2))
        handsx(2) = GetX(hr*5, ana.r*0.55, ana.x)
        handsy(2) = GetY(hr*5, ana.r*0.55)
        handsx(3) = GetX(minutes-15, tip(3), ana.x)
        handsy(3) = GetY(minutes-15, tip(3))
        handsx(4) = GetX(minutes+15, tip(3), ana.x)
        handsy(4) = GetY(minutes+15, tip(3))
        handsx(5) = GetX(minutes, tip(0), ana.x)
        handsy(5) = GetY(minutes, tip(0))
        If handsxl(0)<>0 Then
' blank previous hands & draw new hands
          Polygon h(),handsxl(),handsyl(),c.face,c.face
        EndIf
        Polygon h(),handsx(),handsy(),handcol(),handcol()
      EndIf
' Draw seconds hand
      secsx(0)=GetX(Sec-0.6, tip(1), ana.x)
      secsy(0)=GetY(Sec-0.6, tip(1))
      secsx(1)=GetX(Sec+0.6, tip(1), ana.x)
      secsy(1)=GetY(Sec+0.6, tip(1))
      secsx(2)=GetX(Sec-0.2, tip(0), ana.x)
      secsy(2)=GetY(Sec-0.2, tip(0))
      secsx(3)=GetX(Sec+0.2, tip(0), ana.x)
      secsy(3)=GetY(Sec+0.2, tip(0))
      Polygon 4, secsx(), secsy(), c.secondhand, c.secondhand
      Circle ana.x, ana.y, ana.r*0.08, 2, 1, c.secondhand, c.secondhand
    EndIf
    Brightness
    Pause update
  Next i
End Sub

' utility to get the x coord of a vector on the analogue clock
Function GetX(tim As Float, r As Float, anax As Integer) As Integer 'Float
  Local Float t = tim
  If t>359 Then Inc t,-360
  If t<0 Then Inc t,360
  GetX = anax+Cos(Rad(t*6))*r
End Function

' utility to get the y coord of a vector on the analogue clock
Function GetY(tim As Float, r As Float) As Integer 'Float
  Local Float t = tim
  If t>359 Then Inc t,-360
  If t<0 Then Inc t,360
  GetY = height/2+Sin(Rad(t*6))*r
End Function


Sub Roman
' Draw Roman Digital Clock
Local INTEGER digits(2), i, j, offset, l, lasthr
Local String time

  lastmin=60
  For i=0 To c.displaytime
' Get seconds
  digits(2) = Val(Right$(Time$,2))
'  digits(0) = 23
'  digits(1) = 38
'  digits(2) = 59
  If lastsec<>digits(2) Then
    lastsec=digits(2)
    digits(1) = Val(Mid$(Time$, 4, 2))
    offset=88
    l=2
    If lastmin<>digits(1) Then
      lastmin=digits(1)
      offset=8 : l=0
      CLS
      hour = Val(Left$(Time$, 2))
      lasthr = hour
      digits(0) = hour
    EndIf
    For j=l To 2
      time=Numeral(digits(j))
' Check for 0 as it does not exist in Roman Numerals
      If lastsec=0 And j=2 Then
        Text offset, offset*2.4, "- -", "LT", 4, 6, RGB(ORANGE)
      ElseIf lastmin=0 And j=1 Then
        Text offset, offset*2.4, "- -", "LT", 4, 6, RGB(ORANGE)
      ElseIf lasthr=0 And j=0 Then
        Text offset, offset*2.4, "- -", "LT", 4, 6, RGB(ORANGE)
      Else
        Text offset, offset*2.4, time+"   ", "LT", 10, 6, RGB(ORANGE)
      EndIf
      If j=0 Then Text offset+265, offset*2.4+14, "Hora", "LT", 3, 3, RGB(ORANGE)
      Inc offset,40
    Next j
  EndIf
  Brightness
  Pause update
  Next i
End Sub

Sub Digi
' Draw standard red LED digital clock
Local INTEGER digits(2), i, j, m=10, n=5, x=42, y=20
Local String time

  CLS
  lastmin=60
  For i=0 To c.displaytime
' Get seconds
  digits(2) = Val(Right$(Time$,2))

  If lastsec<>digits(2) Then
    lastsec=digits(2)
    hour = Val(Left$(Time$, 2))
    digits(0) = hour
    digits(1) = Val(Mid$(Time$, 4, 2))

    For j=0 To 2
      If digits(j)<10 Then time=time+"0"
      Inc time,Str$(digits(j))
      If j<2 Then time=time+":"
    Next j

    If y>260 Then
      m=(Rnd+.5)* -18
    ElseIf y<20 Then
      m=(Rnd+.5)*25
    EndIf
    If x>160 Then
      n=(Rnd+.5)* -10
    ElseIf x<10 Then
      n=(Rnd+.5)*15
    EndIf
'    Text x, y, "        ", "LT", 8, 8, RGB(0,0,0)
    Box x, y, 310, 60, 0,, RGB(0,0,0)
    Inc x,n
    Inc y,m
    Text x, y, time, "LT", 8, 10, RGB(RED)
  EndIf
  Brightness
  Pause update
  time=""
  Next i
End Sub

Function Numeral( number As Integer ) As String
Local INTEGER num(6) = (1,4,5,9,10,40,50), digits(2)
Local STRING time="", sym(6) = ("B","BC","C","BE","E","ED","D")
Local Integer div, i=6

  Do While number<>0
    div = number\num(i)
    number = number Mod num(i)
    Do While div<>0
      Numeral=Numeral+sym(i)
      Inc div,-1
    Loop
    Inc i,-1
  Loop
End Function

' only works on display that can be read
Sub Matrix1
Local INTEGER i, j, pix, column
  CLS
  For i=0 To c.displaytime/20
' Draw 'Matrix' falling code display

' Insert a new random 'code'
    pix = Int(Rnd*41)*8+2
    Line pix,0,pix+3,0,2,RGB(50,255,40)
    pix = Int(Rnd*41)*8+2
    Line pix,0,pix+3,0,2,RGB(50,255,40)
'    Pause update
    For column=2 To 314 Step 8
' Move the 'code' down one line
      Blit column, 0, column, 8, 4, 232
    Next
' Calculate the new colour for top row.
    For column=2 To 318 Step 8
' extract the green colour only and fade it as 'code' drops
      pix = Pixel(column, 8)
      If pix <> 0 Then
        pix = (pix And &HFF00)>>8
        If pix>100 Then
          Inc pix,-13
        ElseIf pix>13 Then
          Inc pix,-2
        EndIf
        Line column, 0, column+3, 0, 2, RGB(50,pix,40)
      EndIf
    Next
  Brightness
  Next
End Sub

Sub Matrix2
Local INTEGER s(59,39),p(59),q(59),z(59),i,j=39,k=-1280,l,c,r,x,n,m,y,t(59)
  CLS
  For y=0 To 472 Step 8: p(y\8)=y : q(y\8)=y+6 : Next
' Draw 'Matrix' falling code display then Insert a new random 'code' at screen X position j
  For i=0 To c.displaytime\10
   m=Rnd*59:n=Rnd*59
' Set to white initially
   s(m,j)=&hF0FFFF : s(n,j)=&hF0FFFF
' Move the 'code' down one line, gradually decreasing Green brightness
   Math Slice s(),,j,t():t(m)=&hff00:t(n)=&hff00
   For y=0To 59:t(y)=Choice(t(y)<&h1000,0,t(y)+k):Next
   Inc j,-1:If j<0 Then j=39
   Math Insert s(),,j,t():r=j
' Output to display
   For y=0To 312 Step 8
    Math set y,z():Math Slice s(),,r,t()
    Line p(),z(),q(),z(),4,t()
'    If (r Mod 2) Then: Line p(),z1(),q(),z2(),1,t():Else : Line p(),z2(),q(),z1(),1,t():EndIf
    Inc r:If r>39 Then r=0
   Next
   Brightness
'Print Timer:Timer =0
'   Pause update\4
  Next
End Sub
'    For r=28To 0Step-1
'      Math Slice s(),,r,t():Math Insert s(),,r+1,t()
'      Math Add t(),-13,t():Math Insert s(),,r,t()
'      y=r<<3
'      For c=0To 39:x=c<<3:If s(c,r)>0Then:Line x,y,x+3,y,2,s(c,r)<<8:EndIf :Next
'    Next
' even up fall rate as screen fills
'  If i<30 Then Pause 100-i*3

' Move the 'code' down one line
'    For col=0 To 39
'      xpos=col<<3
'      For row=29 To 0 Step -1
'        If screen(col,row)>0 Then
'          ypos=row<<3
'          screen(col,row+1)=screen(col,row)
'          Line xpos, ypos, xpos+3, ypos, 2, RGB(50,screen(col,row),40)
'          screen(col,row)=screen(col,row)-13
'        EndIf
'      Next
'    Next


Sub Binary
Local INTEGER digit(5), digitl(5)=(24,24,24,24,24,24), dig, bit, bitpat
Local Integer i
  CLS
  Text 0, 15, "Se", "LT", 8, 3, RGB(GREEN)
  Text 0, 70, "Mi", "LT", 8, 3, RGB(GREEN)
  Text 0, 125, "Hr", "LT", 8, 3, RGB(GREEN)
  Text 0, 180, "Dy", "LT", 8, 3, RGB(GREEN)
  Text 0, 230, "Mo", "LT", 8, 3, RGB(GREEN)
  Text 0, 285, "Yr", "LT", 8, 3, RGB(GREEN)
  For i=0 To c.displaytime
' only update time/date digits when required
    digit(5) = Val(Right$(Time$, 2))  ' seconds
    If digit(5) <> digitl(5) Then
      digit(4) = Val(Mid$(Time$, 4, 2)) ' minutes
      If digit(4) <> digitl(4) Then
        hour = Val(Left$(Time$, 2))   ' hours
        digit(3) = hour
        If digit(3) <> digitl(3) Then
          digit(2) = Val(Left$(Date$, 2))   ' day of month
          digit(1) = Val(Mid$(Date$, 4, 2)) ' month
          digit(0) = Val(Right$(Date$, 4))-2000 ' year
        EndIf
      EndIf
    EndIf

' loop for each time/date digit
    For dig=0 To 5
' has the numeric time/date value changed
      If digit(dig) <> digitl(dig) Then
        digitl(dig)=digit(dig)
        bitpat=digit(dig)
        For bit=0 To 5
' calculate the binary pattern for this digit
          If bitpat Mod 2 = 0 Then
            Box (5-bit)*76+30, (5-dig)*54, 54, 46, 0,, RGB(0,130,0)
          Else
            Box (5-bit)*76+30, (5-dig)*54, 54, 46, 0,, RGB(0,250,0)
          EndIf
          bitpat=bitpat\2
        Next
      EndIf
    Next
  Brightness
  Pause update
  Next i
End Sub

Sub ScrollTime
Local Integer i, m, length, xpos=0, scroll=1
Local String tim, displtim

  lastmin=60
  For i=0 To c.displaytime*2

    m = Val(Mid$(Time$, 4, 2))

    If m<>lastmin Then
      lastmin=m
      hour = Val(Left$(Time$, 2))
      If m=0 Then
        tim="  The Time by my wrist is "+TimeText(hour)
      ElseIf m<10 Then
        tim="  The Time by my wrist is "+TimeText(hour)+" O' "+TimeText(m)
      Else
        tim="  The Time by my wrist is "+TimeText(hour)+" "+TimeText(m)
      EndIf
      tim=tim+" Precisely :-)  The Ti"
      length=(Len(tim)*2)-17
    EndIf

    Inc xpos,1
    If xpos>length Then xpos=0

    If (xpos Mod 2)=0 Then
      displtim=Mid$(tim,((xpos\2)+1),8)
      Text 0, 100, displtim, "LT", 3, 4, RGB(MAGENTA)
    Else
      Text -25, 100, displtim, "LT", 3, 4, RGB(MAGENTA)
    EndIf

    Brightness
    Pause update\30
  Next
End Sub

Sub WordClock
Local Integer i, m, s

  lastsec=60
  CLS
  For i=0 To c.displaytime

  s = Val(Right$(Time$,2))

  If s<>lastsec Then
    lastsec=s
    m= Val(Mid$(Time$, 4, 2))
    hour= Val(Left$(Time$, 2))

    If m<> lastmin Then
      lastmin=m
      Text 0, 0, "The Time is :-", "LT", 7, 5, RGB(CYAN)
      If m=0 Then
        Text 0, 70, " "+TimeText(hour)+" &", "LT", 7, 5, RGB(CYAN)
        Text 0, 140, "               ", "LT", 7, 5, RGB(CYAN)
      ElseIf m<10 Then
        Text 0, 70, " "+TimeText(hour)+" O'   ", "LT", 7, 5, RGB(CYAN)
        Text 0, 140, "  "+TimeText(m)+" &    ", "LT", 7, 5, RGB(CYAN)
      Else
        Text 0, 70, " "+TimeText(hour)+"   ", "LT", 7, 5, RGB(CYAN)
        Text 0, 140, "  "+TimeText(m)+" &    ", "LT", 7, 5, RGB(CYAN)
      EndIf
    EndIf

    If s=0 Then
     Text 0, 210, "   Zero      ", "LT", 7, 5, RGB(CYAN)
     Text 0, 280, "    Seconds", "LT", 7, 5, RGB(CYAN)
    Else
     Text 0, 210, "   "+TimeText(s)+"      ", "LT", 7, 5, RGB(CYAN)
     Text 0, 280, "    Seconds", "LT", 7, 5, RGB(CYAN)
    EndIf
  EndIf
  Brightness
  Pause update
 Next
End Sub

Function TimeText(num As Integer) As String
Local Integer tens, tenths
Local String tenth(19)=("Zero","One","Two","Three","Four","Five","Six","Seven","Eight","Nine","Ten","Eleven","Twelve","Thirteen","Fourteen","Fifteen","Sixteen","Seventeen","Eighteen","Nineteen")
Local String ten(5)=("","Ten","Twenty","Thirty","Fourty","Fifty")

  If num <20 Then
    TimeText=tenth(num)
  Else
    tens = num\10
    tenths = num Mod 10
      TimeText=Choice(tenths, ten(tens)+" "+tenth(tenths), ten(tens))
  EndIf
End Function

Sub Brightness
Local Integer month

' change brightness using screen touch points
  If Touch(DOWN) Then
    If Touch(X) <160 Then
      If Touch(Y) <160 Then
        bright= Choice( bright<10, bright+1, bright+5)
        If bright >100 Then bright=100
      ElseIf Touch(Y) >=160 Then
        bright= Choice( bright<10, bright-1, bright-5)
        If bright <0 Then bright = 0
      EndIf
     ' Backlight bright
    ElseIf Touch(X) >160 And Touch(X) <320 Then
      VAR Save bright, BSTdone
      Flash Run 3
    EndIf
  EndIf
' Set screen brightness for dusk, month depentant
  If brup > 3000 Then
    brup=0
    If hour <> lasthour Then
      lasthour=hour
      month= Val(Mid$(Date$, 4, 2))
' Jan, Nov or Dec
      If (month=1 Or month=11 Or month=12) And (hour=8 Or hour=15) Then
        bright=eveb
        If hour=8 Then bright=dayb
' May, June, July
      ElseIf (month=5 Or month=6 Or month=7) And (hour=5 Or hour=20) Then
        bright=eveb
        If hour=5 Then bright=dayb
' Feb, Oct
      ElseIf (month=2 Or month=10) And (hour=7 Or hour=16) Then
        bright=eveb
        If hour=7 Then bright=dayb
' March, Sept
      ElseIf (month=3 Or month=9) And (hour=6 Or hour=18) Then
        bright=eveb
        If hour=6 Then bright=dayb
' April, Aug
      ElseIf (month=4 Or month=8) And (hour=5 Or hour=19) Then
        bright=eveb
        If hour=5 Then bright=dayb
' Any other time of day
' Set to very dim over night.
      ElseIf hour=23 Then
        bright=nightb
      EndIf

' Update actual screen brightnes
     ' Backlight bright

' Now check for SummerTime, and ajust as appropriate.
      If hour=2 And Eval(Left$(Date$,2))>24 And Day$(Date$)="Sunday" And Not BSTdone Then
       If month=3 Then
        BSTdone=1
        Inc hour
       ' RTC Settime Eval(Right$(Date$,4)),month,Eval(Left$(Date$,2)),hour,Eval(Mid$(Time$,4,2)),Eval(Right$(Time$,2))
       ElseIf month=10 Then
        BSTdone=1
        Inc hour,-1
       ' RTC Settime Eval(Right$(Date$,4)),month,Eval(Left$(Date$,2)),hour,Eval(Mid$(Time$,4,2)),Eval(Right$(Time$,2))
       EndIf
      EndIf
      If BSTdone And hour>2 Then BSTdone=0
    EndIf
  EndIf
  Inc brup
End Sub
