'HUB75 driver 6bit color(rgb222)
'this version is for Hub75-displays with max.5 Adr-lines(1/8, 1/16 or 1/32 scan)
' the wide has to be a power of 2 -> 32,64,128,256,...(using ringbuffer)       |
' tested with 32x64/128/256; 64x64/128/256
'
' Connection PICO          Connection HUB75
'
' gp0  RED0  -+
' gp1  GREEN0 |
' gp2  BLUE0  SM0 out          +----+
' gp3  RED1   |           RED0 |1 16| GREEN0
' gp4  GREEN1 |          BLUE0 |2 15| GND
' gp5  BLUE1 -+           RED1 |3 14| GREEN1
' gp6  A     -+          BLUE1  4 13| E
' gp7  B      |              A  5 12| B
' gp8  C      SM1 out        C |6 11| D
' gp9  D      |            CLK |7 10| LATCH
' gp10 E     -+            /OE |8  9| GND
' gp11 CLK   -SM0 sset         +----+
' gp12 LATCH -SM1 sset
' gp13 /OE   -SM2 sset
'
' examples of connecting more then one panel
'   stacked    con.          attached         attached & stacked        con.
'  +--------+pico       +--------+--------+   +--------+--------+        _
'32|        | [+]1>[] 32|      HS=1       | 32|        |        |pico   / \
'  | HS=2   |    __/    |     32x128      |   |       HS=2      | [+]1>[] []2>[]
'  +-64x64--+   /       +--------+--------+   +------64x128-----+    _________/
'32|        |  []2>[]       64       64     32|        |        |   /
'  |        |           pico   con.           |        |        |  []3>[] []4>[]
'  +--------+            [+]1>[] []2>[]       +--------+--------+       \_/
'      64                      \_/                64       64
'
' some displays exchanged colorchanels or for other routings on board
' look for "InitCt("rgb")"
'
'OPTION SDCARD  CS_pin, CLK_pin, MOSI_pin, MISO_pin
'------------------------------------------------------------------------------|
Option EXPLICIT
Option DEFAULT INTEGER

Const MSB     = 128
'consts for hub-display
'if you use stacked displays they must be equal.e.g. 32x128 stack 2 -> 64x64
Const HubStack= 1   '1: no stack; 2: stacked: first botton to second top
Const HubH    = 64  'real height * stacks => MM.VRES(virtual);val:16,32,64
Const HubW    = 128 'or 256 real  wide  / stacks => MM.HRES(virtual);val:32,64,128,256
Const HubScan = HubH/2-1    'there should be others but they are not supported
Const HubPixs = HubH*HubW   '
Const HubInts = HubH*HubW/8 '8 bytes = 1 int

'ringbuffer for PIO DMA TX finally contains the twisted display-data
'2 parts: first half:bit0-pattern twisted up/down, second bit1-pattern twisted
Dim Pack
PIO make ring buffer Pack,HubPixs 'in byte HubH*HubW

' vars for display: buffers and PIO-calculation
Dim Work(HubInts-1)    'contains display-data 1pixel = 1byte
Dim Stacker(HubInts-1) 'contains stacked display-data

'copy to separate arrays to be able to use Math-functions
Dim Uppr(HubInts/2-1) 'for temp data rgb222 in 8bit
Dim Down(HubInts/2-1) 'for temp data rgb222 in 8bit

'for precalculated data(MyInit):for use with Math-functions
Dim Ad0M(HubInts/2-1) 'BOS-,EOL- and Brightness-mask for Bit0-frame
Dim Ad1M(HubInts/2-1) 'BOS-,EOL- and Brightness-mask for Bit1-frame

'for mask and shift: separate arrays to be able to use Math-functions
Dim AddM(HubInts/2-1) 'holds the bitmasks    in Pack4Hub
Dim Tmp1(HubInts/2-1) 'for temporary results in Pack4Hub
Dim Tmp2(HubInts/2-1) 'for temporary results in Pack4Hub

'pointer: used for memory functions
Dim WAdr = Peek(VarAddr Work(0))           'upper half of org
Dim VAdr = Peek(VarAddr Work(HubInts/2))   'lower half of org
Dim UAdr = Peek(VarAddr Uppr())            'ptr to upper half copy
Dim DAdr = Peek(VarAddr Down())            'ptr to lower half copy
Dim pAdM = Peek(VarAddr AddM())            'ptr to bit-mask
Dim pTmp = Peek(VarAddr Tmp1())            'ptr to temp results
Dim pAA0 = Peek(VarAddr Pack(0))           'ptr to ringbuffer-start bit1
Dim pAA1 = Peek(VarAddr Pack(HubInts/2))   'ptr to ringbuffer-start bit0
Dim pAd0 = Peek(VarAddr Ad0M())            'ptr to Brightness-mask
Dim pAd1 = Peek(VarAddr Ad1M())            'ptr to Brightness-mask
Dim pSt0 = Peek(VarAddr Stacker(0))        'ptr to stacker
Dim pSt1 = Peek(VarAddr Stacker(HubInts/2))'ptr to stacker

'display start ----------------------------------------------------------------|
Dim C6Tb(63) 'precalculated colors
Dim rC,Bcol,Fcol,lFco=-1,lBco=-1,lCol=-1

Dim float tic1,tic2
InitCt("brg") 'switch color-channels here

InitMasks(50)'init BOS-,EOL- and OEO-Mask; parameter for Brightness(10-100)
             '- also first copy to ringbuffer
'init sys-display config
If (HubStack<0)Or(HubStack>2) Then Print "error: number of stacks!!!":End

On error skip
Option lcdpanel user, HubW/HubStack, HubH*HubStack' inform system about display config

If (MM.HRES<>HubW/HubStack)Or(MM.VRES<>HubH*HubStack) Then
  Print "error: display config wrong!!! first: option lcdpanel disable"
  End
EndIf

'init PIO
'there is a problem with "DMA TX off",I can not stop/restart after Ctrl+C
If MM.Info(PIO TX DMA) Then
  Print "PIO TX DMA still running !!!!"
  PIO DMA TX OFF
  Pause 100
  PIO stop 1,0
  Pause 100
  If MM.Info(PIO TX DMA) Then Print "resetting Pico": CPU RESTART
End If

InitHub75Pio() 'create the POIs and starts SM1 and SM2, PIO write "scans" to SM1
StartHub75Pio()'start SM0 with DMA TX "ringbuffer"

'-application consts/vars -----------------------------------------------------|
Dim i,j,a,R,G,B,RP
'Dim String RP Length 5

' application start -----------------------------------------------------------|
Dim string tStr,ScollText1="Merry Christmas Ho!Ho!Ho!"
Dim string ScrollText2="Happy New"
Dim string ScrollText3="Year :-)"
'Set 50% Bright
InitMasks(50) '50% brightness

Drive "b:"
 Do
  HubScrBmp("IMG_rr.bmp")
  HubScrBmp("Banner2.bmp")
'  HubScrBmp("MChristm.bmp")
 Loop Until Inkey$<>""
End

'- subs application -----------------------------------------------------------|
Sub HubScrBmp( Fn As string) 'scroll (24bit)bmp direct from file to screen
'to make it easier, the bmp have to be rotated 90 degree right and mirrored
Local integer lGap, lWid, lHei, lBas, lEnd, lPos, lRow, x
 Open Fn For input As #1
  '- read parts of bmp-header       IDs: Adr =0, S=1, W=2, H=3
  Seek #1,19      ' skip headersize
  lWid = HubRDW() ' wide
  lHei = HubRDW() ' height
  lBas = WAdr+MM.HRES-1        ' adr of column to insert (TopRight)
  lEnd = WAdr+MM.HRES*MM.VRES-1' adr of column to insert (BottomRight)
  'now read bmp-data: bmp-lines to display-columns
  Seek #1,55                     'skip planes, bitcount, compress, ...
  For lRow = 0 To lHei 'height
   'todo:check if lWid <> MM.VRES
   For lPos = lBas To lEnd Step MM.HRES 'over the wide: topleft -> last column
     Memory set lPos, HubRP(),1
   Next ' lPos
   'todo: handle if lWid <> MM.VRES
   lGap = 3-Loc(#1)And 3        'check for 4-byte boundary/line
   If lGap>0 Then x=Asc(Input$(lGap,#1)) 'skip dummy-data
   'todo: delay ?
   DupD()
   StripeMoveLeft(0,63)
'   StripeMoveup(70,80)
'   StripeMoveDn(40,50)
'   Pause 20
Print Timer:Timer =0
  Next ' lRow
 Close #1
End Sub

Function HubRP()'read pixel
'Local B,G,R,res
' R=Asc(Input$(1,#1))
' G=Asc(Input$(1,#1))
' B=Asc(Input$(1,#1))
' res=      ((R And &hc0)>>6)
' res=res Or((G And &hc0)>>4)
' res=res Or((B And &hc0)>>2)
' HubRP = C6Tb(res)
'Rp=Input$(3,1)
'HubRP=C6Tb((Byte(RP,1)And &hC0)>>6 Or(Byte(RP,2)And &hC0)>>4 Or(Byte(RP,3)And &hC0)>>2)
RP=Asc(Input$(1,1))>>6 Or(Asc(Input$(1,1))>>6)<<2 Or(Asc(Input$(1,1))>>6)<<4
HubRP = C6Tb(RP)
End Function

Function HubRDW()'read dword
'reads four bytes from file
Local integer lsb,msb,msb1,msb2
  lsb =Asc(Input$(1,#1))
  msb =Asc(Input$(1,#1))
  msb1=Asc(Input$(1,#1))
  msb2=Asc(Input$(1,#1))
  HubRDW = (msb2<<24)+(msb1<<16)+(msb<<8)+lsb
End Function

Sub StripeMoveLeft(slY0,slY1)'Start & End of strip width
Local slT,sWid=MM.HRES,sDec=sWid-1
If slY0>slY1 Then slT=slY1:slY1=slY0:slY0=slT
Local sSrc=WAdr+slY0*sWid,sEnd=WAdr+slY1*sWid
 For slT=sSrc To sEnd Step sWid:Memory copy slT+1,slT,sDec
Next 'slT
End Sub

Sub StripeMoveRight(srY0,srY1)'Start & End of strip width
Local srT,sWid=MM.HRES,sDec=sWid-1
If srY0>srY1 Then srT=srY1:srY1=srY0:srY0=srT
Local sSrc=WAdr+srY0*sWid,sEnd=WAdr+srY1*sWid
 For srT=sSrc To sEnd Step sWid:Memory copy srT,srT+1,sDec
 Next 'srT
End Sub

Sub StripeMoveUp(suX0,suX1)'Start & End of strip width
Local suT
If suX0>suX1 Then suT=suX1:suX1=suX0:suX0=suT
Local sEnd=WAdr+suX0,sSrc=sEnd+MM.HRES*MM.VRES-MM.HRES,sWid=suX1-suX0
 For suT=sSrc To sEnd Step -MM.HRES:Memory copy suT,suT+MM.HRES,sWid
 Next 'suT
End Sub

Sub StripeMoveDn(suX0,suX1)'Start & End of strip width
Local sdT
If suX0>suX1 Then sdT=suX1:suX1=suX0:suX0=sdT
Local sSrc=WAdr+suX0,sEnd=sSrc-MM.HRES+MM.VRES*MM.HRES,sWid=suX1-suX0
 For sdT=sSrc To sEnd Step MM.HRES:Memory copy sdT,sdT-MM.HRES,sWid
 Next 'sdT
End Sub

'- subs user display ----------------------------------------------------------|
Sub mm.user_rectangle(x1,y1,x2,y2,col)
col=col And &hC0C0C0' no background: no use of transparency
If (lcol<>col)Then
 rC=rgbTo222(col):lcol=col
EndIf
If (x1=x2)And(y1=y2)Then'Short cut for single pixel
 Memory set WAdr+x1+(MM.VRES-y1-1)*MM.HRES,rC,1:Exit Sub
EndIf
Local rT,rI,rWid=MM.HRES
If (x1>x2)Then rT=x2:x2=x1:x1=rT'
If (y1>y2)Then rT=y2:y2=y1:y1=rT'the calling function did not sort!!!
'more tests decrease speed, coords outside screen will skip the hole rec
If (x1<0)Or(y1<0)Or(x2>MM.HRES-1)Or(y2>MM.VRES-1)Then Exit Sub
Local rW=x2-x1+1,rH=y2-y1,rBas=WAdr+(MM.VRES-y2-1)*rWid+x1,rTes=rBas+rH*rWid
For rI=rBas To rTes Step rWid:Memory Set rI,rC,rW
Next
End Sub

Sub mm.user_bitmap(x0,y0,bW,bH,bS,Fc,Bc,bitmap)
Local bK,bM,bMas,bO,bDat,Acol
Local bWid=MM.HRES,bBas=WAdr+x0,bI=bW*bH,bYba=MM.VRES-y0-1
 Fc=Fc And &hC0C0C1
 If (lFco<>Fc)Then Fcol=rgb2222(Fc):lFco=Fc
 Bc=Bc And &hC0C0C1
 If (lBco<>Bc)Then Bcol=rgb2222(Bc):lBco=Bc
If bS=1 Then'no scale
 Do While bI
  If Not bMas Then
   bDat=Peek(BP bitmap):bMas=MSB'next byte; reset mask msb
  EndIf
  Acol=Choice(bDat And bMas,Fcol,Bcol)
  If (x0+bK)<bWid And Acol Then
   Memory Set bBas+(bYba-bM)*bWid+bK,Acol,1
  EndIf
  Inc bK'                      column-counter
  If bK=bW Then Inc bM:bK=0'   cr lf(line-conter)
  bMas=bMas>>1'                move mask
  Inc bI,-1'                   bit-countdown
 Loop
Else ' scale > 1
 Do While bI
  If Not bMas Then'            byte scan fin -> next
   bDat=Peek(BP bitmap):bMas=MSB'reset mask msb first
  EndIf '                      mask = 0
  Acol=Choice(bDat And bMas,Fcol,Bcol)
  If (x0+bK)<bWid And Acol Then'not outside & not 0(transparent)
   For bO = 0 To bS-1
    Memory Set bBas+(bYba-bM*bS+bO)*bWid+bK*bS,Acol,bS
   Next 'bO
  EndIf '  transparent
  Inc bK'                      column-counter
  If bK=bW Then Inc bM:bK=0'   cr lf(line-conter)
  bMas=bMas>>1'                move mask
  Inc bI,-1'                   bit-countdown
 Loop
EndIf
End Sub

'-PIO-------------------------------------------------------------------------|
Sub StartHub75Pio()
  PIO dma tx 1,0,0,Pack(),,,HubInts*2 '32bit count = 2*64bit count))
End Sub

Sub InitHub75Pio()
Local ExeC,PinC,ShiC,Freq,pnl'PioNextLine
  SetPin gp0,pio1 ' out RED  -----+
  SetPin gp1,pio1 ' out GREEN     |
  SetPin gp2,pio1 ' out BLUE      SM0 out
  SetPin gp3,pio1 ' out red       |
  SetPin gp4,pio1 ' out green     |
  SetPin gp5,pio1 ' out blue -----+
  SetPin gp6,pio1 ' out A    -----+
  SetPin gp7,pio1 ' out B         |
  SetPin gp8,pio1 ' out C         SM1 out
  SetPin gp9,pio1 ' out D         |
  SetPin gp10,pio1' out E     ----+
  SetPin gp11,pio1' sideset CLK --SM0 sset
  SetPin gp12,pio1' sideset LATCH-SM1 sset
  SetPin gp13,pio1' sideset /OE --SM2 sset

 'data-structure: bgr for upper half, BGR for lower half
 'YBGRbgr0....ZBGRbgr00BGRbgrZ....0BGRbgrX ->output dir
 'X=1 marks BOS(BeginOfSequence),Y=1 marks EOL(EndOfLine),Z marks EOE(End/OE)
 'pull = 32 bit ; out-shiftdir is right
  PIO CLEAR 1
 'SM0: in pio-prog x is used for all flags one after another
  pnl = Pio(next line 1)
  PIO assemble 1
  .program hub
   .side set 1
   .line next
   .wrap target
    .label NoEof
     Out x,    1  side 0     'if there is a BOS,it is here
     Jmp !x,NoBos side 0     'jump over if no BOS
      IRQ SET 1   side 0     'BOS(BeginOfSequence)-> inform SM1-ctrl
     .label NoBos
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out x,    2  side 1     '1 if there is a BOS,it is here
     Jmp !x,No0EO side 1     'jump over if no EOE(End/OE)
      IRQ SET 4   side 0     'inform SM2: switch leds off(one of two possible)
     .label No0EO            '
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out null, 2  side 1 [1] 'clk+2 no data
     Out pins, 6  side 0     '2 shift RGBrgb-data from osr
     Out x,    2  side 1     '1 if there is a EOE
     Jmp !x,No1EO side 1     'jump over next step if no BOS
      IRQ SET 4   side 0     'inform SM2: switch leds off(one of two possible)
     .label No1EO            '/OE-off
     Out pins, 6  side 0     '6 shift RGBrgb-data from osr
     Out x,    1  side 1     'clk+if there is an EOL,it is here
    Jmp !x,NoEof  side 1     'no EOL->continue
    IRQ SET 2     side 0 [4] 'EndOfLine-> SM1-ctrl:need some time for latching
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,6,,gp11,,gp0) 'sideset:gp11(CLK), out:gp0,1,2,3,4,5
  ShiC = Pio(shiftctrl 0,0,0,1,0,1)'InShDir(l),OutShDir(r)
  Freq = 10700000
  PIO init machine 1,0,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
 'SM1: Y = address of line, startval 7(1/8), 15(1/16er), 31(1/32)scan
  pnl = Pio(next line 1)
  PIO assemble 1
  .program ctrl
   .side set 1
   .line next
   Pull block       side 0 'get linescan
   .wrap target
     Mov y,osr      side 0 'reset line-adr; scan: 1/16(15),1/32(31)
     Wait 1 irq 1   side 0 'wait for BOS(BeginOfSequence)->line reset from SM0
     .label row
      Wait 1 irq 2  side 0 'wait for EOL(EndOfLine) from SM0-data
      Mov pins,y    side 0 'Latch and out new address(ABCDE)
      IRQ CLEAR 4   side 1 'because there could be two, the calculated and saver
      IRQ SET 3     side 1 'inform SM2-delay to switch leds on
     Jmp y--,row    side 0 'dec adr for next line
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,5,,gp12,,gp6) 'sideset:gp12(LATCH), out:gp6,7,8,9,10
  PIO init machine 1,1,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,1   'starts read HubScan(blocked) then wait for irq from SM0-data
  PIO write 1,1,1,HubScan 'init value for row-adr, counting down
 'SM2 for brightness; on: at line end, off: triggered by EOE-flag in next line
  pnl = Pio(next line 1)
  PIO assemble 1
   .program delay
    .side set 1
    .line next
    .wrap target
      Wait 1 irq 3    side 1   'leds off  signal from SM1-ctrl
      Wait 1 irq 4    side 0   'leds on   signal from SM0-data
    .wrap
   .end program 'list
  ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,,,,gp13,,) 'sideset:gp12(/OE)
  PIO init machine 1,2,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO start 1,2 '"delay" starts first and wait immediately for irq from "crtl"
End Sub 'InitHub75Pio()

Sub DupD() 'DisplayUpDate
Local src0,src1,des0,stop
 If HubStack >1 Then 'stacked->rearrange by copying to an other array
  src0=WAdr
  src1=Wadr+MM.VRES/2*MM.HRES
  des0=pSt0
  stop=src1
  Do 'interlace lines
   Memory copy src1,des0,MM.HRES
   Inc src1,MM.HRES:Inc des0,MM.HRES
   Memory copy src0,des0,MM.HRES
   Inc src0,MM.HRES:Inc des0,MM.HRES
  Loop Until src0=stop 'src1 at start
  Pack4Hub(pSt0,pSt1,HubPixs>>1)
 Else
  Pack4Hub(WAdr,VAdr,HubPixs>>1)'interchange and save in ringbuffer
 EndIf
End Sub

Sub Pack4Hub(Adr0,Adr1,size)
'twist and separate by bit-level Work()-data to PIO DMA TX-array(Pack())
Memory copy Adr0,UAdr,size'     01234560 for example bitnames at start
Memory copy Adr1,DAdr,size'     0ABCDEF0
Memory set pAdM,&b01110000,size'bit1:(MSB)01230000>>0+0ABC0000>>3->0123ABC0
Math c_AND Uppr(),AddM(),Tmp1()'mask first bits from up
Math c_AND Down(),AddM(),Tmp2()'mask first bits from down
Math shift Tmp2(),-3,Tmp2(),u'  unsigned shift down right!!!!!!
Math c_OR Tmp2(),Tmp1(),Tmp1()' add up and down-temporary results
Math c_OR Tmp1(),Ad1M(),Tmp1()' add EOLs and EOEs
Memory copy pTmp,pAA0,size'     copy bit1 part to ringbuffer
Memory set pAdM,&b00001110,size'bit0:(LSB)00004560<<3+0000DEF0>>3->0456DEF0
Math c_AND Uppr(),AddM(),Tmp1()'mask second bits from up
Math c_AND Down(),AddM(),Tmp2()'mask second bits from down
Math shift Tmp1(),3,Tmp1()'     shift them left
Math c_OR Tmp1(),Tmp2(),Tmp1()' add up and down-temporary results
Math c_OR Tmp1(),Ad0M(),Tmp1()' add EOLs and EOEs
Memory copy pTmp,pAA1,size'     copy bit0 part to ringbuffer
End Sub 'Pack4Hub()

Sub InitMasks(iBr)'5..100
Local iI,iA,iX,iY,iP,iW
 'first clear old data
 Math Set 0 ,Ad0M()
 Math Set 0 ,Ad1M()
 'set BOS (flag BeginOfSequence)
 Memory set integer pAd1,&h1, 1
 Memory set integer pAd0,&h1, 1
 'set EOL (flag EndOfLine)           +saver:last possible pos
 Memory set integer pAd1+(HubW-8),&h8100000000000000, HubScan+1,HubW/8
 Memory set integer pAd0+(HubW-8),&h8100000000000000, HubScan+1,HubW/8
 'set EOE (flag leds off)
 If iBr<  5 Then iBr=5   'min for 32 wide:10%; for 64 wide 5%; for 128: 3%
 If iBr>100 Then iBr=100
 iA = Int(HubW * iBr / 400 - 0.5) 'calc brightness idx
 'timing for bit0
 iX=Int(iA/2)           'calc the double
 iY=iA Mod 2            'calc which one
 iP=1+(iX*4)+iY         'calc byteposition in this line
 iW=Choice(iY,&h80,&h01)'select the pattern
 For iI = 1 To HubScan  'skip first, will be set with pos for bit1
  Memory set Byte pAd0+(iI*HubW)+iP,iW,1
 Next 'iI
 Memory set Byte pAd1+iP,iW,1'set with pos for bit1
 'timing for bit1
 iP=1+(iA*4)            'calc for bit1-level, should be about twice of bit2-val
 For iI = 1 To HubScan  'skip first, is allready set with pos for bit1
  Memory set Byte pAd1+(iI*HubW)+iP ,&h01,1
 Next 'iI
 Memory set Byte pAd0+iP,&h01,1'set with pos for bit0
 DupD() 'update data in ringbuffer
End Sub

Sub InitCt(Mix$)
Local iI,iRd,iGr,iBl
  'create colortable
 Mix$=UCase$(Mix$)
 For iRd = 0 To 3
  For iGr = 0 To 3
    For iBl = 0 To 3
     iI =  1 Or(iBl And 1)<<1 Or(iBl And 2)<<3
     iI = iI Or(iGr And 1)<<2 Or(iGr And 2)<<4
     iI = iI Or(iRd And 1)<<3 Or(iRd And 2)<<5
     Select Case Mix$ 'channel-config(3!)
      Case "RGB"
        C6Tb(iBl*16+iGr*4+iRd)=iI
      Case "RBG"
        C6Tb(iGr*16+iBl*4+iRd)=iI
      Case "GRB"
        C6Tb(iBl*16+iRd*4+iGr)=iI
      Case "GBR"
        C6Tb(iRd*16+iBl*4+iGr)=iI
      Case "BRG"
        C6Tb(iGr*16+iRd*4+iBl)=iI
      Case "BGR"
        C6Tb(iRd*16+iGr*4+iBl)=iI
     End Select
 Next iBl,iGr,iRd
End Sub

'helper ----------------------------------------------------------------------
Function Rgb2222(col)'for bitmaps
 If col=1 Then rgb2222=0:Exit Function
 Rgb2222=C6Tb((col And &hc00000)>>18 Or(col And &hc000)>>12 Or(col And &hc0)>>6)
End Function

Function RgbTo222(col)'for recs/pixel: no transparency
 RgbTo222=C6Tb((col And &hc00000)>>18 Or(col And &hc000)>>12 Or(col And &hc0)>>6)
End Function
'---------------------------------------------------------------------------------
Sub mm.end
  PIO DMA TX OFF
  PIO stop 1,2
  PIO stop 1,1
  PIO stop 1,0
  SetPin gp13,dout:Pin(gp13)=1 'set /OE (sometimes it stay on)
End Sub

DefineFont #9
08201010
C003C003 C003C003 C003C003 DFFBDFFB DFFBDFFB C003C003 C003C003 C003C003
C003C003 0000E001 FC03F001 FFF0FFC7 E3FF0FFF 800FC03F 80070000 C003C003
C003C003 C003C003 0000C003 FFFFFFFF FFFFFFFF C0030000 C003C003 C003C003
C003C003 80078007 402F000F 77EF63EF F7C6F7EE F000F402 E001E001 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E003E003 FC01F001 7FF8FFE0 0FFE3FFC 800F003F C0078007 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E001E003 FC00F001 3FF87FE0 07FE1FFC 800F003F C0078007 C003C003
End DefineFont
