'---AmpHour.bas-----------------------------------------------------------------
'As a Dinosaur I need this reminder as to how to do it.
'On Debian Bookworm
'1: On Rpi-Zero (the Broker), with Debian Bookworm
'   sudo apt-get install mosquitto mosquitto-clients
'   edit /etc/mosquitto/mosquitto.conf and add the following lines:
'   allow_anonymous true
'   listener 1883
'   Create Hotspot (Rpi-Hotspot) with following settings:
'   Tick Connect Automatically,SSID = Rpi-Hotspot,Mode = Hotspot, Band = 2.4Ghz
'   Security = WPA/WPA2/WPA3 Personal,Enter Password,
'   IPv4 = Shared to other computers
'   Enter desired IP for Broker,Mask = 24,Gateway = same IP (it works)
'
'2: On Rpi-Pico
'   At Command line : OPTION WIFI SSID$,PASSWD$  will connect to Broker.
'                     OPTION WIFI Rpi-Hotspot,"*******"
'3: Run the Rpi-Pico program below,
'     A DO/LOOP continously calls TimeGet and TaskScan
'     As StepNbr is 0 at boot, that is the first Case taken.
'     Step  0 Confirms (once) we can reach the Hotspot and then disconnects.
'     Step  1 Publishes (once) Time to Rpi-Zero (Pico has TC).
'     Step  2 Publishes (once) Pico's IP address (you can Ping from Zero)
'     Step  3 Publishes (repeatedly) an incrementing TxValue.
'     Step  4 Backs up A/H value every Hour. Also checks if Rpi-Hotspot is connected.
'4: On Linux PC (a Client)  , sudo apt-get install mosquitto-clients
'   Connect to Rpi-Hotspot, Edit connection as per Rpi-Zero with new IP
'   and route with Broker IP, then use the following but use your Broker IP:
'   mosquitto_pub -h 192.168.0.101 -m "Test Message " -t YourTopic -d
'5: When ever settings are changed, the Pico has to be reset.
'   Purging mosquitto in Linux to re-install involves manually removing
'   the /etc/mosquitto folder.
'
'   Note: Haven't tested yet for how long the broker will hold onto message.
'         Because Clients are sending every 30 sec's, I check every 20 sec'c.
'   Run commands below at prompt.
'   OPTION SYSTEM I2C GP8,GP9
'   OPTION AUTORUN  ON
'   OPTION WIFI "Rpi-Hotspot","********"
'   OUTSTANDING Problem: Every second power boot the connection fails.;
'-------------------------------------------------------------------------------
OPTION EXPLICIT
OPTION DEFAULT NONE
DIM STRING  IP$,Tyd$,Err$
Dim Integer CalTime,mSec,StepNbr,StartTime,CommFlag,BootFlag
Dim Integer StartTime0,Delay0                     'variables for  each Task
Dim Integer StartTime1,Delay1
Dim Integer StartTime2,Delay2
Dim Integer StartTime3,Delay3
Dim Integer StartTime4,Delay4
Dim Float TxValue

SUB MM.STARTUP                                    'Initialise PicoMite 'FoldHere
  RTC GETTIME                                     'DS3231 on I2C GP8,GP9
END SUB
Sub MM.PROMPT                                     'declare Time as Prompt 'FoldHere
  Print Time$ ">";
End Sub
SUB Initialize 'FoldHere
    If MM.Watchdog Then
        Print "Watchdog reboot happened"
        Err$ = "WatchDog"
    EndIf
    VAR RESTORE
    CalTime    = Timer
    pause 2550                                    'get the timer above zero a bit.
    mSEc       = (Timer - CalTime)
    StartTime  = mSec
    StartTime0 = mSec                             'So that next delay is correct
    StartTime1 = mSec
    StartTime2 = mSec
    StartTime3 = mSec
    StartTime4 = mSec
    WatchDog 300000                               '5 min before reboot
    Print "Var Restored    = ";TxValue
    Print "Got RTC         = ";Time$
    Print "Got Version     = ";MM.Ver
    Print "On platform     = ";MM.Device$
    Print "CPU Speed       = ";MM.INFO(CPUSPEED)
    Print "Drive Capacity  = ";MM.INFO$(DISK SIZE)
    Print "Drive SpaceLeft = ";MM.INFO(Free Space)
    Print "Nbr of Variables= ";MM.INFO(VARCNT)
    If TxValue = 0 Then
        TxValue = 70.01
        VAR Save TxValue
    EndIf
End Sub
Sub WiFi_Bootup 'FoldHere
  'If Connected, Stat = 1, If NO HotSpot then Stat = -3
  'If at power up there is no Wifi then the A/H routine will run without
  'trying to connect for 1 Hr by using CPU-Restart.
  LOCAL Integer Stat
  Stat = MM.INFO(Wifi Status)
  If Stat > 0 Then 
      StepNbr = 0
      WifiConnect
    Else
      Print "Wait 60 Sec's for TxValue send."     'Not available, so monitor A/H only.
      StepNbr = 3
  EndIf
End Sub
Sub TimeGet()                                     'get latest mSec & check Task Flags 'FoldHere
    mSec  = (Timer - CalTime)                     'mSec elapsed since program started
    If mSec - StartTime0 >= 50 Then               'Boot Pause let Rpi-Zero catch up.
      StartTime0 = mSec :Delay0 = 1               'reset flags
    EndIf
    If mSec - StartTime1 >= 25000 Then            'allow Time Send after 1 min.
      If Delay1 = 0 Then                          '0 means Repeat -1 - no more
        StartTime1 = mSec :Delay1 = 1             'reset flags
      EndIf
    EndIf
    If mSec - StartTime2 >= 30000 Then            'allow IP send.
      If Delay2 = 0 Then
        StartTime2 = mSec :Delay2 = 1
      EndIf
    EndIf
    If mSec - StartTime3 >= 60000 Then            'allow A/H send.
      If Delay3 = 0 Then
        StartTime3 = mSec :Delay3 = 1
      EndIf
    EndIf
    If mSec - StartTime4 >= 3600000 Then          'allow VAR SAVE of A/H
      If Delay4 = 0 Then                          'Once per Hr x 24 = 8760 per year
        StartTime4 = mSec :Delay4 = 1             '= 10 years of Write / Erase b4 failure.
      EndIf
    EndIf
End Sub
Sub WifiConnect 'FoldHere
    CommFlag = 0
    If MM.INFO(Wifi Status) > 0 Then              'See if Connected to Rpi-Hotspot
      'Print "Wifi Status";MM.INFO(Wifi Status),StepNbr
      DO
        If InStr(MM.INFO(IP ADDRESS),"192.168.0.") > 0 Then
            Print "Conn from;";MM.INFO(IP Address) 'and have a valid IP
            CommFlag = 1                          'then set Flag for this episode
            Exit Do
          Else
            Print "NO Conn.;";MM.INFO(IP Address)
            If StepNbr = 0 Then                   'Only at original power up
              IF mSec - StartTime > 100 THEN      'if not there by 100mSec
                Print "WifiConnect:CPU Restarting" 'even 15 sec's doesn't help
                CPU RESTART                       'so may as well restart.
              EndIf
            EndIf
            Exit do
        EndIf
      LOOP
      If CommFlag = 1 Then
        ON Error skip 1
        WEB MQTT Connect "192.168.0.101", 1883,"Rpi-Hotspot","76216770"
        WEB MQTT subscribe "AmpHr"                'get what we sent
      EndIF
End Sub
Sub TaskScan                                      'Step through each Task 'FoldHere
    Select case StepNbr
    Case 0                                        'At startup it comes here first
        If Delay0 = 1 Then
            If MM.INFO(Wifi Status) > 0 Then WifiConnect
            If CommFlag = 1 Then                  'If we are connected
                WEB MQTT CLOSE
                Print "Connection success."
                Print "Wait 25 Sec's for Time send "
                StartTime0 = mSec :Delay0 = -1    'Cancel Case 0
                StartTime1 = mSec :Delay1 = 0     'refresh Case 3 Timer.
                StartTime2 = mSec :Delay2 = 0     'refresh Case 3 Timer.
                StartTime3 = mSec :Delay3 = 0     'refresh Case 3 Timer.
                StepNbr    = 1                    'Jump ahead to A/H Tx.
            EndIf
        EndIf
   Case 1                                         ' Time send; only once
        If Delay1 = 1 Then
            If MM.INFO(Wifi Status) > 0 Then WifiConnect
            Tyd$ = Time$
            If CommFlag = 1 Then
              WEB MQTT PUBLISH "AmpHr",Tyd$ , 0 ,1
              WEB MQTT CLOSE
              Print "Time Sent;";Tyd$
              Delay1 = -1
            EndIf
            Print "Wait 30 sec's for IP send."    'send only once
            StartTime2 = mSec :Delay2 = 0         'refresh delay for next step.
            StartTime3 = mSec :Delay3 = 0         'refresh delay for next step.
        EndIf
        StepNbr = 2
    Case 2                                        'IP Addr send; only once
        If Delay2 = 1 Then
            If MM.INFO(Wifi Status) > 0 Then WifiConnect
            IP$ = MM.INFO(IP ADDRESS)             'Get my IP address
            WEB MQTT PUBLISH "AmpHr",IP$,0,1
            WEB MQTT CLOSE
            Print "IP Sent;";IP$
            Print "Wait 60 Sec's for TxValue send."
            Delay2 = -1
            StartTime3 = mSec :Delay3 = 0         'setup delay for next step.
        EndIf
        StepNbr = 3
    Case 3                                        'Repeat send incrementing value.
        If Delay3 = 1 Then                        '30 Sec time is up.
            CommFlag = 0
            Print "Step 3 Wifi Status = ";MM.Info(Wifi Status)
            If MM.INFO(Wifi Status) > 0 Then WifiConnect
            IF TxValue = 0 Then VAR RESTORE       'NEW will destroy saved VAR
            TxValue = TxValue + 0.1
            If CommFlag = 1 Then
                  WEB MQTT PUBLISH "AmpHr",Str$(TxValue) , 1 ,1
                  WEB MQTT CLOSE
                  Print "A/H  sent = ";TxValue
                  StartTime3 = mSec :Delay3 = 0
              Else
                  StartTime3 = mSec :Delay3 = 0
                  Print "A/H updated = ";TxValue
            EndIf
        EndIf
        StepNbr = 4
    Case 4
        If Delay4 = 1 Then                        '1 Hour's time is up.(10 year life)
            Print "StepNbr 4 ";
            If MM.INFO(Wifi Status) < 1 Then      'if we are NOT connected
                web scan a%()                     'see if SSID has popped up
                longstring print a%()
                if linstr(a%(),"Rpi-Hotspot") then BootFlag = 1 'yes so set flag
            EndIf
            VAR Save TxValue                      'Saving for possible reboot
            StartTime4 = mSec :Delay4 = 0
            Print "Var TxValue saved"
            If BootFlag = 1 Then                  'SSID was discovered, so reboot.
              Print "CPU Restart"
              CPU RESTART
            EndIf
        EndIf
        StepNbr = 5
    Case 5
        If Err$ <> "" Then                        'if a Watchdog reboot happened
            If MM.INFO(Wifi Status) > 0 Then WifiConnect
            If CommFlag = 1 Then
              Tyd$ = Time$
              WEB MQTT PUBLISH "AmpHr",Err$ , 0 ,1 'send Time & err to Rpi-Zero
              WEB MQTT CLOSE
            EndIf
        EndIf
        Watchdog 300000                           'keep the dog awake.
        StepNbr = 6                               'OR the next step for Program.
    Case 6
      If CommFlag = 1 Then
          StepNbr = 1
        Else
          StepNbr = 3
      EndIf
    End Select
End Sub

  DIM A%(1024)
  web scan a%()                     'see if SSID has popped up
  longstring print a%()
  if linstr(a%(),"Rpi-Hotspot") then
      If MM.INFO(IP ADDRESS) = "0.0.0.0" Then  
          Print "Step 0 IP ";MM.INFO(IP Address)  
          Print "Step 0 Rebbot"
          CPU RESTART
      EndIF
  EndIF

  Initialize
  WiFi_Bootup
  Do
      TimeGet                                     'get the latest time in mSec.
      TaskScan                                    'see which tasks need attention.
      If StepNbr = 7 Then exit do                 'a way to exit program
  Loop
  WEB MQTT CLOSE
  Print "Tot ziens"
  End
