Type A2Ds
    Handle           as Long
    SampleCnt        as Integer
    Sample(1 to 500) as Integer<16>
    Accum            as ULong
    NoCharge         as ULong
    AccCnt           as Integer
    Hi               as Integer<16>
    Cell             as Integer<16>
    Reply            as Integer<16>
    i2cReg           as UInteger<16>
    Version          as Integer<16>
    Config(1 to 4)   as UInteger<16>
    CellCnt(1 to 4)  as Long
    Convert(1 to 5)  as Single
    CellV(1 to 4)    as Single
    TrueV(1 to 4)    as Single
    BattV            as Single
    csvFile          as String * 36
End Type
Dim shared A2D as A2Ds
Sub Initialise()        '' Set Variables
''==========================================================
''Comes here once to initialise preset values.
''==========================================================
    Times.mSec       = (Timer - Times.CalTime) * 1000       '' mSec since program start
    Times.LoopTime0  = 1000                                 '' HeartBeat 1 Sec Flash
    Times.LoopTime1  = 30000                                '' Check Cells every 30 Sec's
    Times.StartTime1 = Times.mSec
    Times.LoopTime2  = 60000                                '' Send Report every minute
    Times.StartTime2 = Times.mSec
                                 '' SS  Cell   4.096V  128 SPS 
    A2D.Config(1)    = &H83C3    '' 1   100    0011    1000     0011      C3 83   swapped to 83C3
    A2D.Config(2)    = &H83D3    ''     101                               D3
    A2D.Config(3)    = &H83E3    ''     110                               E3
    A2D.Config(4)    = &H83F3    ''     111                               F3
    A2D.Convert(1)   = 0.1274856
    A2D.Convert(2)   = 0.1278072
    A2D.Convert(3)   = 0.1267943
    A2D.Convert(4)   = 0.1272855                            '' mV per count
    A2D.Convert(5)   = 0.5091420                            '' mV per count
End sub
Sub OpenPort()          '' Open I2C Port
''==========================================================
'' Comes here once to Open I2C port,
'' shares the file handle with 4 x A2D
''==========================================================
    Status.error = 0
    With A2D                                                '' operate on 1 cell at the time
        .Version = gpioInitialise()
        Print "Version ;";.Version
        .Handle = i2copen(1,&h48,0)                         ''returns 0 if OK
        If .Handle < 0 Then                                 
                Print "Error with ic2 Opening ";.Version;",";.Handle;
                gpioTerminate()
                Sleep
                End -1
            Else
                Print "I2C Handle = ";.Handle               '' pigpio i2copen replies with 0
        EndIf                                               '' if open was successfull.
    End With
End Sub
Sub ReadaCell()         '' Get 500 reads for one Cell
    With A2D
        Locate 4 + A2D.Cell, 42:Print "<--";                '' Indicate which cell we are reading.
        Dim as Integer Xq
        Do
            .Reply = I2CWriteWordData(.Handle,1,A2D.Config(A2D.Cell)) '' Write Config Reg (1) Incl Single shot start.
            If .Reply = 0 Then                              '' command accepted.
                    sleep 8                                 '' 128 sps = 7.8 mSec + 10% say 10 mSec to complete .
                    .i2cReg = 0                             '' Set to Data Reg (0).
                    .SampleCnt += 1                         '' Inc sample counter.
                    .Reply = i2cReadWordData( .Handle, .i2cReg) '' Get a Reading.
                    SWAP16( .Reply)                         '' Swap for Little Endian.
                    .Sample(.SampleCnt) = .Reply            '' Save the sample.
                Else
                    Color 4
                    Locate 22,20: Print "No Reply from I2C port.  ";
                    Color 15
                    Exit Do
            EndIf
            If .SampleCnt = 500 Then Exit Do                '' Get out after 500 reads.
        Loop
        Locate 4 + .Cell, 42:Print "   ";                   '' Blank out Indicator.
    End With
    ''------------------------------------------------------
    '' Only Once save the 500 reads from Cell.
    '' Type in 'r' to remove files and allow a new save. 
    ''------------------------------------------------------
    If Times.mSec - A2D.NoCharge > 10000 Then               '' Only Write csv files if no
        Select case A2D.Cell                                '' charging has happened for 10 Secs
            Case 1                                                      
                A2D.csvFile = "/home/dinosaur/Downloads/Cell1.csv"
            Case 2
                A2D.csvFile = "/home/dinosaur/Downloads/Cell2.csv"
            Case 3
                A2D.csvFile = "/home/dinosaur/Downloads/Cell3.csv"
            Case 4
                A2D.csvFile = "/home/dinosaur/Downloads/Cell4.csv"
        End Select
        Dim as Integer Xq
        Dim as Long Df = FreeFile
        If not (FileExists(A2D.csvFile)) Then               '' Only write the file once.
            Open A2D.csvFile for Output as #Df              '' Pressing 'r' will REMOVE the file
            For Xq = 1 to 500                               '' so it can be re-written.
                Print #df,A2D.Sample(Xq);",";
            Next
            Close #Df
        Endif
    EndIf
End Sub
Sub Samplesort()        '' Fill .Accum with highest - 20 samples
    Dim as Integer Xq
    For Xq = 1 to A2d.SampleCnt                             '' Find the Highest value
        With A2D
            If .Sample(Xq) > .Hi Then .Hi = .Sample(Xq)                 
        End With
    Next
    For Xq = 1 to A2d.SampleCnt                             '' Now sort the samples
        With A2D
            If .Sample(Xq) > ( .Hi - 20) Then               '' 80% of samples are in top 15 counts
                .Accum += .Sample(Xq)                       '' Save any samples that qualify.
                .AccCnt += 1                                '' Inc counter for later division.
            EndIf
        End With
    Next
    A2D.CellCnt(A2D.Cell) = A2D.Accum / A2D.AccCnt          '' This is the count for the TrueV(n)
End Sub
Sub Calc_Results()      '' Convert counts to Voltages
    With A2D
        Select case .Cell
            Case 1
                .TrueV(1) = (.CellCnt(1) * .Convert(1))     '' No divider resistors on this Cell
                .CellV(1) = .TrueV(1) / 1000                '' so we can convert directly to CellV(1)
                Report.CellCnt(1) = Str(.CellCnt(1))
                Report.CellVolts(1) = Str(.CellV(1)) 
            Case 2
                .TrueV(2) = (.CellCnt(2) * 2) * .Convert(2) ''Counts WRTEarth X 2 x Constant = TrueV(n) mV WRTE
                .CellV(2) = (.TrueV(2) - .TrueV(1)) / 1000  ''mV of previous .TrueV subtracted converted to Volts.
                Report.CellCnt(2) = Str(.CellCnt(2) * 2)
                Report.CellVolts(2) = Str(.CellV(2)) 
            Case 3
                .TrueV(3) = (.CellCnt(3) * 3) * .Convert(3) ''Counts WRTEarth X 3 x Constant = mV WRTE
                .CellV(3) = (.TrueV(3) - .TrueV(2)) / 1000 
                Report.CellCnt(3) = Str(.CellCnt(3) * 3)
                Report.CellVolts(3) = Str(.CellV(3)) 
            Case 4
                .TrueV(4) = (.CellCnt(4) * 4) * .Convert(4) ''Counts WRTEarth X 4 x Constant = mV WRTE
                .CellV(4) = (.TrueV(4) - .TrueV(3)) / 1000 
                Report.CellCnt(4)   = Str(.CellCnt(4) * 4)
                Report.CellVolts(4) = Str(.CellV(4)) 
                .BattV = .CellCnt(4) * .Convert(5) / 1000   '' Calculate battery V from Cell4 
                Locate 15, 1:print Cint( .TrueV(1));                    
                Locate 15, 9:Print Cint( .TrueV(2));
                Locate 15,19:Print Cint( .TrueV(3));
                Locate 15,29:Print Cint( .TrueV(4));
        End Select
        ''----Calculate the CellDelta----
        If .Cell = 4 Then                                   '' 4 means we have read all cells
            Dim as Integer Xq
            Dim as single XHi,XLo
            XLo = 4:XHi = 0
            For Xq = 1 to 4                                 '' Find Highest & Lowest Cell
                If .CellV(Xq) < XLo Then Xlo = .CellV(Xq)
                If .CellV(Xq) > XHi Then XHi = .CellV(Xq)
            Next
            Status.CellsDelta = XHi - XLo                   '' Highest difference between Cells
        EndIf
        Locate 4 + .Cell ,1 :Print .CellCnt(.Cell);         '' Print Volt to 3 dec places
        Locate 4 + .Cell ,10:Print Using "#.###"; .CellV( .Cell); 
        Locate 9 ,9:Print Using "##.###"; (.CellV(1) + .CellV(2) + .CellV(3) + .CellV(4))
    End With                                                            
End Sub
