'******************************************************************************
'                     BCX - The Basic To C/C++ Translator
'               Copyright 1999 Kevin Diggins (All Rights Reserved)
'                   Significant Contributors to the BCX project
'  (Devs)   Robert Wishlaw, Wayne Halsdorf, Mike Henning, Ljubisa Knezevic
' (Hosting)       Jeff Shollenberger, Fernando Ortiz, Dave Navarro
'******************************************************************************
'      BCX is distributed under the general conditions of the MIT License.
'                https://en.wikipedia.org/wiki/MIT_License
'                                MIT License
'******************************************************************************
' Permission is hereby granted, free of charge, to any person obtaining a copy
' of this software and associated documentation files (the "Software"), to deal
' in the Software without restriction, including without limitation the rights
' to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
' copies of the Software, and to permit persons to whom the Software is furnished
' to do so, subject to the following conditions:
'
' The above copyright notice and this permission notice shall be included in
' all copies or substantial portions of the Software.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
' OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
' FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
' AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
' LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
' FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
' IN THE SOFTWARE.
'******************************************************************************
$NOINI                                   ' Do not use BCX.ini, if one exists.
$GENFREE                                 ' Emit code that frees dynamic vars.
$WARNINGS_OFF                            ' Suppress C/C++ compiler warnings.
$IPRINT_OFF                              ' Disable "\" to "\\" conversions.
'******************************************************************************
MACRO __BCX__    = 1                     ' Tell BCX we are translating BC.bas
MACRO BCXSTRINGS = 2048                  ' Default size for static string vars.
MACRO BCX_COLORS = TRUE                  ' Colorize (or not) BCX's output.
MACRO VERSION$   = "7.9.0 (06/18/2022)"  ' Embed this into the executable.
'******************************************************************************
'  These BCX_STR equates are to remind BCX code maintainers from accidently
'  changing certain output lines of code that are used for $PROJECT SUPPORT.
'******************************************************************************
MACRO BCX_STR_RUNTIME     = "Runtime Functions"
MACRO BCX_STR_VBS_STRUCTS = "VBScript Support Structures"
MACRO BCX_STR_USR_CONST   = "User Defined Constants"
MACRO BCX_STR_SYS_CONST   = "System Defined Constants"
MACRO BCX_STR_STD_PROTOS  = "Standard Prototypes"
MACRO BCX_STR_SYS_VARS    = "System Variables"
MACRO BCX_STR_USR_VARS    = "User's Global Variables"
MACRO BCX_STR_STD_MACROS  = "Standard Macros"
MACRO BCX_STR_MAIN_PROG   = "Main Program"
MACRO BCX_STR_USR_PROCS   = "User's Subs and Functions"
MACRO BCX_STR_USR_PROTOS  = "User's Prototypes"
MACRO BCX_STR_USR_TYPES   = "User Defined Types And Unions"
'***********************************************************
'  An assortment of macros used throughout the translator
'***********************************************************
MACRO IAm(X)              = ((X)<>1)
MACRO IAmNot(X)           = ((X)==0)
MACRO FirstTime(X)        = ((X)==0)
MACRO IDont(X)            = ((X)==0)
MACRO GetAsPosF(S,E)      = GetAsPos((S),(E),1)
MACRO GetAsPosB(S,E)      = GetAsPos((S),(E),-1)
MACRO iMatchLft(A,B)      = iMatch((A),(B),0)
MACRO iMatchWrd(A,B)      = iMatch((A),(B),1)
MACRO iMatchRgt(A,B)      = iMatch((A),(B),2)
MACRO WordsInTable(A)     = (SIZEOF(A)/SIZEOF(A[0]))
MACRO GetBrkPairPosF(S,E) = GetBracketPair((S),(E),1)
MACRO GetBrkPairPosB(S,E) = GetBracketPair((S),(E),-1)
MACRO IVAL(A)             = atol((char*)(A))
MACRO fprintf             = ReDirectFPrint
'***********************************************************
'                 User Defined Type Support
'***********************************************************
MACRO MaxElements         =  256     ' Previously 128
MACRO MaxTypes            = 1024     ' Previously 512
MACRO MaxLocalVars        = 8192     ' Previously 512
MACRO MaxGlobalVars       = 8192     ' Previously 4096 -- max: 233,000
MACRO MaxLib              =   64     ' Max no. of libraries
'***********************************************************
'                      Bracket Handling
'***********************************************************
MACRO c_SglQt             =   39
MACRO c_DblQt             =   34
MACRO c_LPar              =   40
MACRO c_RPar              =   41
MACRO c_Comma             =   44
MACRO c_LtBkt             =   91
MACRO c_RtBkt             =   93
'***********************************************************
ENUM
   vt_UNKNOWN             '  Not a Variable
   vt_STRLIT              '  "Quoted String Literal"
   vt_INTEGER             '  Integer%
   vt_SINGLE              '  Single!
   vt_DOUBLE              '  Double#
   vt_LDOUBLE             '  Long Double`
   vt_LLONG               '  Long Long
   vt_STRVAR              '  StringVariable$
   vt_DECFUNC             '  Translated Decimal Func: Strlen,Asin
   vt_NUMBER              '  A Pure Literal Number
   vt_FILEPTR             '  @ FILE*
   vt_UDT                 '  User ( or Windows ) Defined Type
   vt_STRUCT              '  Structures
   vt_UNION               '  Unions
   vt_LPSTR               '  Pointer to string
   vt_BOOL                '  Bool
   vt_CHAR                '  char
   vt_LPSTRPTR            '  pointer to string array
   vt_PCHAR               '  pointer to char
   vt_CHARPTR             '  pointer to char
   vt_VOID                '  null
   vt_LONG                '  32-bit signed integer
   vt_WORD                '  16-bit unsigned integer
   vt_DWORD               '  32-bit unsigned integer
   vt_FARPROC             '  Pointer to a function
   vt_LPBYTE              '  pointer to a byte
   vt_LRESULT             '  32/64-bit signed integer
   vt_BYTE                '  byte
   vt_SHORT               '  16-bit signed integer
   vt_USHORT              '  16-bit unsigned integer
   vt_UINT                '  unsigned 32-bit integer
   vt_ULONG               '  unsigned 32-bit integer
   vt_ULONGLONG           '  unsigned 64-bit integer
   vt_HWND                '  32/64-bit pointer
   vt_HDC                 '  32/64-bit pointer
   vt_COLORREF            '  32-bit unsigned integer
   vt_HANDLE              '  32/64-bit pointer
   vt_HINSTANCE           '  32/64-bit pointer
   vt_WNDCLASSEX          '  32/64-bit pointer
   vt_HFONT               '  32/64-bit pointer
   vt_CONSTRDESTR         '  BCX identifier for CONSTRUCTOR/DESTRUCTOR
   vt_VARIANT_BOOL        '  Bool types identifier
   vt__VARIANT_BOOL       '  Bool values identifier
   vt_SCODE               '  unsigned 32-bit integer
   vt_CY                  '  signed 64-bit integer representing a currency value
   vt_DATE                '  32-bit composite variable representing a date and time
   vt_BSTR                '  32-bit composite variable representing an OLE  string
   vt_IUnknown            '  32/64-bit pointer to an IUnknown interface pointer
   vt_IDispatch           '  32/64-bit pointer to an IDispatch pointer
   vt_SAFEARRAY           '  32/64-bit pointer to a SAFEARRAY structure
   vt_PVOID               '  32/64-bit void pointer
   vt_DECIMAL             '  32/64-bit pointer to a DECIMAL member of a VARIANT structure
   vt_DOCINFO             '  32/64-bit pointer to a DOCINFO structure
   vt_LOGFONT             '  32/64-bit pointer
   vt_TEXTMETRIC          '  32/64-bit pointer to a TEXTMETRIC structure
   vt_WINBOOL             '  Alias for BOOL
   vt_VARIANT             '  32/64-bit pointer to a VARIANT structure
END ENUM

'********************************************************************************
MACRO vt_VarMin  =  2
MACRO vt_VarMax  =  vt_VARIANT
'********************************************************************************

ENUM                      ' OSVersion return values
   OSUnknown = (-2)
   OSError   = (-1)
   OS_3x
   OS_95
   OS_98
   OS_ME
   OS_NT3
   OS_2000
   OS_XP
   OS_XP_Pro_x64
   OS_Server_2003
   OS_Home_Server
   OS_Server_2003_R2
   OS_Vista
   OS_Server_2008
   OS_Server_2008_R2
   OS_Win_7
   OS_Server_2012
   OS_Win_8
   OS_Win_81
   OS_Server_2012_R2
   OS_Win_10
   OS_Server_2016
   OS_Win_11
END ENUM

'*********************************
ENUM  ' InFunction types
   eFunctionType = (1)
   eSubType
END ENUM
'*********************************

ENUM  ' SUB EmitIfCond types
   ePart
   eFull
   eStringPart
   eStringFull
END ENUM

'*********************************

ENUM                      '***** MEMSET/STATIC Truth Table ******
   ImDim       = 0x0001    '  DIM         A        MEMSET  STATIC
   ImLocal     = 0x0002    '  LOCAL       B        MEMSET  STATIC
   ImRaw       = 0x0004    '  RAW         C
   ImStatic    = 0x0008    '  STATIC      D                STATIC
   ImAuto      = 0x0010    '  AUTO        E        MEMSET
   ImRegister  = 0x0020    '  REGISTER    F
   ImCPPPrvDim = 0x0040    '  ImCPPPrvDim
END  ENUM

'*********************************

ENUM
   mt_ProcessSetCommand
   mt_FuncSubDecC_Dec
   mt_FuncSubDecC_DecAParam
   mt_FuncSubDecC_DecNoParam
   mt_Opts
   mt_OptsAParam
   mt_OptsNoParam
   mt_OverLoad
   mt_OverLoadAParam
   mt_OverLoadNoParam
   mt_ConsDes
   mt_ConsDesAParam
   mt_ConsDesNoParam
END ENUM


ENUM
   eDoNothing
   eStartSysVariables
   eDoSysVariables
   eStartUserVariables
   eDoUserVariables
   eStartMacros
   eDoMacros
   eStartStdProtos
   eDoStdProtos
   eStartUserProtos
   eDoUserProtos
   eStartUserConst
   eDoUserConst
   eStartSysConst
   eDoSysConst
   eDoMainProgram
   eDoUserProcs
   eStartUserTypes
   eDoUserTypes
END ENUM


'*****************************************
' Variable types for COM, OLE and VARIANT
'*****************************************

ENUM
   comvt_BAD = (-1)
   comvt_TRUE
   comvt_FALSE
   comvt_BOOL
   comvt__VARIANT_BOOL
   comvt_BSTR
   comvt_STRVAR
   comvt_R4
   comvt_R8
   comvt_R8_LITERAL
   comvt_CY
   comvt_DATE
   comvt_DISPATCH
   comvt_PVOID
   comvt_ERROR
   comvt_VARIANT
   comvt_UNKNOWN
   comvt_DECIMAL
   comvt_I1
   comvt_UI1
   comvt_I2
   comvt_UI2
   comvt_I4
   comvt_I4_LITERAL
   comvt_UI4
   comvt_I8
   comvt_UI8
   comvt_INT
   comvt_UINT
   comvt_VOID
   comvt_OBJECT
   comvt_EMPTY
   comvt_NULL
   comvt_HRESULT
   comvt_PTR
   comvt_SAFEARRAY
   comvt_CARRAY
   comvt_USERDEFINED
   comvt_LPSTR
   comvt_LPWSTR
   comvt_RECORD
   comvt_INT_PTR
   comvt_UINT_PTR
   comvt_FILETIME
   comvt_BLOB
   comvt_STREAM
   comvt_STORAGE
   comvt_STREAMED_OBJECT
   comvt_STORED_OBJECT
   comvt_BLOB_OBJECT
   comvt_CF
   comvt_CLSID
   comvt_VERSIONED_STREAM
   comvt_BSTR_BLOB
   comvt_NAMED_ARGUMENT
   comvt_CAST
   comvt_DEFAULT
   comvt_VECTOR   = 0x1000  ' unused
   comvt_ARRAY    = 0x2000
   comvt_BYREF    = 0x4000
   comvt_TYPEMASK = 0x0FFF
   comvt_ILLEGAL  = 0xFFFF  ' unused
END ENUM


'**************************************************************
'                 LATE BINDING COM SUPPORT
'**************************************************************

TYPE COM_NAMES_STORAGE       ' used for COM variables
   name[cSizeOfName] AS CHAR
   initialized       AS BOOL
END TYPE

MACRO cMaxComStk       = 256
MACRO cMaxParamToken   = 64
MACRO cSizeOfName      = 64
MACRO COM_STACK_SIZE   = 64  ' number of chained dispatch objects.
MACRO COM_Max_Gl_Objs  = 64  ' max allowable GLOBAL COM objects
MACRO COM_Max_Lc_Objs  = 64  ' max allowable LOCAL  COM objects (SUBs and FUNCs)
MACRO COM_Max_Withs    = 32  ' max allowable nested (WITH-END WITH) constructions

GLOBAL ComNdx
GLOBAL ComStk$ [cMaxComStk]
GLOBAL ParamToken$ [cMaxParamToken]

'**************************************************************
'             END OF LATE BINDING COM SUPPORT
'**************************************************************

MACRO cCommaPos = 128
TYPE functionParse
   NumArgs
   CommaPos [cCommaPos]
END TYPE

'**************************************************************
'               These need to always stay in sync
'**************************************************************

MACRO VARTYPES$ = "%$#!@`"

SET VarTypeLookup[] AS PCHAR
   "int", "int", "char *", "double", "float", "FILE *", "long double"
END SET

'**************************************************************
'    Used to keep track of status of a SELECT structure
'**************************************************************

TYPE tagSelectInfo
   CaseStk$
   CaseElseFlag
   CaseFlag
   iStartCase
   NoBreak
   iJumpTo
END TYPE

MACRO cMaxNestedSelects = 16
GLOBAL SelectState[cMaxNestedSelects] AS tagSelectInfo

'**************************************************************
' Structure used in Emitter's findword - Lookup done on pszWord
'**************************************************************

MACRO NOTFOUND = (-1)
TYPE tagWords
   pszWord AS PCHAR
   iType   AS INT
   FUNCTION Emitter(Lookup$, FuncRetnFlag AS PINT) AS INT
END TYPE

'**************************************************************

TYPE ARGTYPE
   Arg$
   ArgType AS INT
END TYPE


MACRO cMAXProtoType    = 8192
MACRO cSizeOfCondition =  512
TYPE tagProtoStore
   Prototype$
   Condition[cSizeOfCondition]      AS CHAR
   CondLevel                        AS INT
END TYPE


MACRO cSizeOfElementName = 64
TYPE Element
   ElementType                      AS INT
   ElementID                        AS INT
   ElementDynaPtr                   AS INT
   ElementName$[cSizeOfElementName] AS CHAR
END TYPE


MACRO cSizeOfVarName = 64
TYPE UserTypeDefs
   TypeofDef                        AS INT
   EleCnt                           AS INT
   Elements[MaxElements]            AS Element
   VarName[cSizeOfVarName]          AS CHAR
END TYPE
MACRO cSizeOfLabel = 10


TYPE tagLoopLoc
   iLoopType                        AS INT
   iLoopLine                        AS INT
   iJumpTo                          AS INT
   szUseNeedLabel [cSizeOfLabel]    AS CHAR
END TYPE


MACRO cSizeOfVarDim     = 128
MACRO cSizeOfVarCondDef = 128
MACRO cSizeOfVarModule  = 300
TYPE VarInfo
   VarLine                          AS INT
   VarType                          AS INT
   VarDef                           AS INT
   VarPntr                          AS INT
   VarSF                            AS INT
   VarExtn                          AS INT
   VarCondLevel                     AS INT
   VarEmitFlag                      AS INT
   VarConstant                      AS INT
   VarName    [cSizeOfVarName]      AS CHAR
   VarDim     [cSizeOfVarDim]       AS CHAR
   VarModule  [cSizeOfVarModule]    AS CHAR
   VarCondDef [cSizeOfVarCondDef]   AS CHAR
END TYPE


TYPE VARCODE
   VarNo                            AS INT
   Methd                            AS INT
   IsPtrFlag                        AS INT
   IsExported                       AS INT
   UseInLine                        AS INT
   szFunctionName$
   Header$
   Proto$
   Functype$
   StaticOut$
   Token$
   AsToken$
END TYPE


' Types used in LoopType
ENUM
   ePrinterGroup   = 0x0001
   eFontGroup      = 0x0002
   eClassName      = 0x0004
   eBCX_hInstance  = 0x0008
END ENUM


ENUM   ' Types used in LoopType
   lt_DOLOOP = 1
   lt_DOWHILELOOP
   lt_DOUNTILLOOP
   lt_WHILEWEND
   lt_FORNEXT
   lt_SELECT
   lt_FORXNEXT
END ENUM


ENUM
   eExitingMoreThan1Loop = 1
END ENUM


TYPE tagVVN
   sNAME AS PCHAR
   iTYPE AS INT
   iPTRS AS INT
END TYPE


SET atVARIANTVALUENAMES[] AS tagVVN
   {"bVal"      , vt_BYTE           , 0},
   {"bool"      , vt__VARIANT_BOOL  , 0},
   {"boolVal"   , vt_VARIANT_BOOL   , 0},
   {"bstrVal"   , vt_BSTR           , 0},
   {"byref"     , vt_PVOID          , 0},
   {"cVal"      , vt_CHAR           , 0},
   {"cyVal"     , vt_CY             , 0},
   {"date"      , vt_DATE           , 0},
   {"dblVal"    , vt_DOUBLE         , 0},
   {"fltVal"    , vt_SINGLE         , 0},
   {"iVal"      , vt_SHORT          , 0},
   {"intVal"    , vt_INTEGER        , 0},
   {"lVal"      , vt_LONG           , 0},
   {"llVal"     , vt_LLONG          , 0},
   {"parray"    , vt_SAFEARRAY      , 1},
   {"pbVal"     , vt_BYTE           , 1},
   {"pbool"     , vt__VARIANT_BOOL  , 1},
   {"pboolVal"  , vt_VARIANT_BOOL   , 1},
   {"pbstrVal"  , vt_BSTR           , 1},
   {"pcVal"     , vt_CHAR           , 1},
   {"pcyVal"    , vt_CY             , 1},
   {"pdate"     , vt_DATE           , 1},
   {"pdblVal"   , vt_DOUBLE         , 1},
   {"pdecVal"   , vt_DECIMAL        , 1},
   {"pdispVal"  , vt_IDispatch      , 1},
   {"pfltVal"   , vt_SINGLE         , 1},
   {"piVal"     , vt_SHORT          , 1},
   {"pintVal"   , vt_INTEGER        , 1},
   {"plVal"     , vt_LONG           , 1},
   {"pllVal"    , vt_LLONG          , 1},
   {"pparray"   , vt_SAFEARRAY      , 2},
   {"ppdispVal" , vt_IDispatch      , 2},
   {"ppunkVal"  , vt_IUnknown       , 2},
   {"pscode"    , vt_SCODE          , 1},
   {"puiVal"    , vt_USHORT         , 1},
   {"pulVal"    , vt_ULONG          , 1},
   {"pullVal"   , vt_ULONGLONG      , 1},
   {"punkVal"   , vt_IUnknown       , 1},
   {"pvarVal"   , vt_VARIANT        , 1},
   {"scode"     , vt_SCODE          , 0},
   {"uiVal"     , vt_USHORT         , 0},
   {"uintVal"   , vt_UINT           , 0},
   {"ulVal"     , vt_ULONG          , 0},
   {"ullVal"    , vt_ULONGLONG      , 0},
   {NULL        , 0                 , 0}
END SET


TYPE tagVTCASTS
   pszCAST AS PCHAR
   iCASTID AS INT
END TYPE


SET ptVCasts[] AS tagVTCASTS
   {"VT_BOOL"    , comvt_BOOL},
   {"VT_BSTR"    , comvt_BSTR},
   {"VT_CY"      , comvt_CY},
   {"VT_DATE"    , comvt_DATE},
   {"VT_DECIMAL" , comvt_DECIMAL},
   {"VT_DISPATCH", comvt_DISPATCH},
   {"VT_ERROR"   , comvt_ERROR},
   {"VT_I1"      , comvt_I1},
   {"VT_I2"      , comvt_I2},
   {"VT_I4"      , comvt_I4},
   {"VT_I8"      , comvt_I8},
   {"VT_INT"     , comvt_INT},
   {"VT_R4"      , comvt_R4},
   {"VT_R8"      , comvt_R8},
   {"VT_UI1"     , comvt_UI1},
   {"VT_UI2"     , comvt_UI2},
   {"VT_UI4"     , comvt_UI4},
   {"VT_UI8"     , comvt_UI8},
   {"VT_UINT"    , comvt_UINT},
   {"VT_UNKNOWN" , comvt_UNKNOWN},
   {NULL         , 0}
END SET


TYPE tagCCASTS
   pszCAST AS PCHAR
   pszVAL AS PCHAR
END TYPE


SET ptCCasts[] AS tagCCASTS
   {"BYTE"     , "bVal"},
   {"CHAR"     , "cVal"},
   {"DOUBLE"   , "dblVal"},
   {"FLOAT"    , "fltVal"},
   {"IDispatch", "pdispVal"},
   {"INT"      , "intVal"},
   {"IUnknown" , "punkVal"},
   {"LONG"     , "lVal"},
   {"LONGLONG" , "llVal"},
   {"PVOID"    , "byref"},
   {"SHORT"    , "iVal"},
   {"UINT"     , "uintVal"},
   {"ULONG"    , "ulVal"},
   {"ULONGLONG", "ullVal"},
   {"USHORT"   , "uiVal"},
   {NULL       , NULL}
END SET



SET tBcxWords[] AS tagWords
   ' Must be in lower case and in alphabetical order
   {"abs"              , vt_DOUBLE  , NULL},
   {"acos"             , vt_DOUBLE  , NULL},
   {"acosh"            , vt_DOUBLE  , NULL},
   {"acosl"            , vt_LDOUBLE , NULL},
   {"asin"             , vt_DOUBLE  , NULL},
   {"asinh"            , vt_DOUBLE  , NULL},
   {"asinl"            , vt_LDOUBLE , NULL},
   {"atan"             , vt_DOUBLE  , NULL},
   {"atanh"            , vt_DOUBLE  , NULL},
   {"atanl"            , vt_LDOUBLE , NULL},
   {"band"             , vt_DECFUNC , NULL},
   {"bin2dec"          , vt_INTEGER , NULL},
   {"bor"              , vt_DECFUNC , NULL},
   {"cos"              , vt_DOUBLE  , NULL},
   {"cosh"             , vt_DOUBLE  , NULL},
   {"cosl"             , vt_LDOUBLE , NULL},
   {"csrlin"           , vt_DECFUNC , NULL},
   {"cursorx"          , vt_DECFUNC , NULL},
   {"cursory"          , vt_DECFUNC , NULL},
   {"dsplit"           , vt_DECFUNC , NULL},
   {"exist"            , vt_DECFUNC , NULL},
   {"exp"              , vt_DOUBLE  , NULL},
   {"expl"             , vt_LDOUBLE , NULL},
   {"fabs"             , vt_DOUBLE  , NULL},
   {"fabsf"            , vt_SINGLE  , NULL},
   {"fabsl"            , vt_LDOUBLE , NULL},
   {"findfirstinstance", vt_DECFUNC , NULL},
   {"fint"             , vt_INTEGER , NULL},
   {"fix"              , vt_DECFUNC , NULL},
   {"frac"             , vt_DOUBLE  , NULL},
   {"fracl"            , vt_LDOUBLE , NULL},
   {"freefile"         , vt_FILEPTR , NULL},
   {"getattr"          , vt_DECFUNC , NULL},
   {"hex2dec"          , vt_INTEGER , NULL},
   {"hypot"            , vt_DOUBLE  , NULL},
   {"hypotl"           , vt_LDOUBLE , NULL},
   {"iif"              , vt_DOUBLE  , NULL},
   {"inchr"            , vt_DECFUNC , NULL},
   {"instr"            , vt_DECFUNC , NULL},
   {"instrrev"         , vt_DECFUNC , NULL},
   {"isfile"           , vt_INTEGER , NULL},
   {"isfolder"         , vt_INTEGER , NULL},
   {"ishidden"         , vt_INTEGER , NULL},
   {"isreadonly"       , vt_INTEGER , NULL},
   {"issystem"         , vt_INTEGER , NULL},
   {"kbhit"            , vt_DECFUNC , NULL},
   {"keypress()"       , vt_DECFUNC , NULL},
   {"labs"             , vt_LONG    , NULL},
   {"llabs"            , vt_LLONG   , NULL},
   {"lof"              , vt_DOUBLE  , NULL},
   {"log"              , vt_DOUBLE  , NULL},
   {"log10"            , vt_DOUBLE  , NULL},
   {"log10l"           , vt_LDOUBLE , NULL},
   {"logl"             , vt_LDOUBLE , NULL},
   {"max"              , vt_DOUBLE  , NULL},
   {"min"              , vt_DOUBLE  , NULL},
   {"msgbox"           , vt_DECFUNC , NULL},
   {"pos"              , vt_DECFUNC , NULL},
   {"pow"              , vt_DOUBLE  , NULL},
   {"powl"             , vt_LDOUBLE , NULL},
   {"qbcolor"          , vt_DECFUNC , NULL},
   {"rnd"              , vt_SINGLE  , NULL},
   {"round"            , vt_DOUBLE  , NULL},
   {"screen"           , vt_DECFUNC , NULL},
   {"sgn"              , vt_DECFUNC , NULL},
   {"sin"              , vt_DOUBLE  , NULL},
   {"sinh"             , vt_DOUBLE  , NULL},
   {"sinl"             , vt_LDOUBLE , NULL},
   {"sizeof"           , vt_DECFUNC , NULL},
   {"split"            , vt_DECFUNC , NULL},
   {"sqrt"             , vt_DOUBLE  , NULL},
   {"sqrtl"            , vt_LDOUBLE , NULL},
   {"strlen"           , vt_DECFUNC , NULL},
   {"tally"            , vt_DECFUNC , NULL},
   {"tan"              , vt_DOUBLE  , NULL},
   {"tanh"             , vt_DOUBLE  , NULL},
   {"tanl"             , vt_LDOUBLE , NULL},
   {"textmode"         , vt_DOUBLE  , NULL},
   {"timer"            , vt_SINGLE  , NULL},
   {"val"              , vt_DOUBLE  , NULL},
   {"vall"             , vt_LDOUBLE , NULL}
END SET


SET tTypes[] AS tagWords
   '*************************************************
   ' Must be in lower case and in alphabetical order
   '*************************************************
   {"bool"       , vt_BOOL        , NULL},
   {"boolean"    , vt_BOOL        , NULL},
   {"bstr"       , vt_BSTR        , NULL},
   {"byte"       , vt_BYTE        , NULL},
   {"char"       , vt_CHAR        , NULL},
   {"colorref"   , vt_COLORREF    , NULL},
   {"double"     , vt_DOUBLE      , NULL},
   {"dword"      , vt_DWORD       , NULL},
   {"farproc"    , vt_FARPROC     , NULL},
   {"file"       , vt_FILEPTR     , NULL},
   {"float"      , vt_SINGLE      , NULL},
   {"handle"     , vt_HANDLE      , NULL},
   {"hdc"        , vt_HDC         , NULL},
   {"hfont"      , vt_HFONT       , NULL},
   {"hwnd"       , vt_HWND        , NULL},
   {"int"        , vt_INTEGER     , NULL},
   {"ldouble"    , vt_LDOUBLE     , NULL},
   {"llong"      , vt_LLONG       , NULL},
   {"long"       , vt_LONG        , NULL},
   {"longlong"   , vt_LLONG       , NULL},
   {"lpbyte"     , vt_LPBYTE      , NULL},
   {"lpstr"      , vt_LPSTR       , NULL},
   {"lresult"    , vt_LRESULT     , NULL},
   {"pchar"      , vt_PCHAR       , NULL},
   {"short"      , vt_SHORT       , NULL},
   {"string"     , vt_STRVAR      , NULL},
   {"uint"       , vt_UINT        , NULL},
   {"ulong"      , vt_ULONG       , NULL},
   {"ulonglong"  , vt_ULONGLONG   , NULL},
   {"ushort"     , vt_USHORT      , NULL},
   {"variant"    , vt_VARIANT     , NULL},
   {"void"       , vt_VOID        , NULL},
   {"winbool"    , vt_WINBOOL     , NULL},
   {"wndclassex" , vt_WNDCLASSEX  , NULL}
END SET


SET atEmitWords[] AS tagWords
   '*************************************************
   ' Must be in lower case and in alphabetical order
   '*************************************************
   {"$$repeat$"           ,0, Emit_StringProcs},
   {"_chdir"              ,0, Emit_FolderDriveProcs},
   {"_mkdir"              ,0, Emit_FolderDriveProcs},
   {"_rmdir"              ,0, Emit_FolderDriveProcs},
   {"asm"                 ,0, Emit_CPP},
   {"auto"                ,0, Emit_OtherProcs},
   {"bcx_set_edit_color"  ,0, Emit_GUIProcs},
   {"bcx_set_font"        ,0, Emit_GUIProcs},
   {"bcx_set_label_color" ,0, Emit_GUIProcs},
   {"beginblock"          ,0, Emit_ControlFlow},
   {"call"                ,0, Emit_ControlFlow},
   {"case"                ,0, Emit_ControlFlow},
   {"caseelse"            ,0, Emit_ControlFlow},
   {"catch"               ,0, Emit_CPP},
   {"chdir"               ,0, Emit_FolderDriveProcs},
   {"class"               ,0, Emit_CPP},
   {"clear"               ,0, Emit_OtherProcs},
   {"close"               ,0, Emit_FileIO},
   {"cls"                 ,0, Emit_ConsoleOnlyProcs},
   {"color"               ,0, Emit_ConsoleOnlyProcs},
   {"const"               ,0, Emit_OtherProcs},
   {"constructor"         ,0, Emit_ConDes},
   {"continue"            ,0, Emit_ControlFlow},
   {"copyfile"            ,0, Emit_FileManagementProcs},
   {"data"                ,0, Emit_OtherProcs},
   {"declare"             ,0, Emit_OtherProcs},
   {"decr"                ,0, Emit_MathProcs},
   {"delay"               ,0, Emit_ConsoleOnlyProcs},
   {"delete"              ,0, Emit_CPP},
   {"destructor"          ,0, Emit_ConDes},
   {"dialogbox"           ,0, Emit_DialogBox},
   {"dim"                 ,0, Emit_OtherProcs},
   {"do"                  ,0, Emit_ControlFlow},
   {"dynamic"             ,0, Emit_Dynamic},
   {"ejectpage"           ,0, Emit_PrinterProcs},
   {"else"                ,0, Emit_ControlFlow},
   {"elseif"              ,0, Emit_ControlFlow},
   {"end"                 ,0, Emit_ControlFlow},
   {"endblock"            ,0, Emit_ControlFlow},
   {"endclass"            ,0, Emit_CPP},
   {"endconstructor"      ,0, Emit_ConDes},
   {"enddestructor"       ,0, Emit_ConDes},
   {"endfunction"         ,0, Emit_EndFuncSub},
   {"endif"               ,0, Emit_ControlFlow},
   {"endnamespace"        ,0, Emit_CPP},
   {"endpptype"           ,0, Emit_PPType},
   {"endprepend"          ,0, Emit_ControlFlow},
   {"endprogram"          ,0, Emit_ControlFlow},
   {"endrepeat"           ,0, Emit_ControlFlow},
   {"endselect"           ,0, Emit_ControlFlow},
   {"endsub"              ,0, Emit_EndFuncSub},
   {"endtemplate"         ,0, Emit_template},
   {"endtry"              ,0, Emit_CPP},
   {"endtype"             ,0, Emit_Type},
   {"endunion"            ,0, Emit_Union},
   {"endwhile"            ,0, Emit_ControlFlow},
   {"endwith"             ,0, Emit_ControlFlow},
   {"exit"                ,0, Emit_ControlFlow},
   {"extern"              ,0, Emit_OtherProcs},
   {"fallthrough"         ,0, Emit_ControlFlow},
   {"finput"              ,0, Emit_FileIOProcs},
   {"for"                 ,0, Emit_ControlFlow},
   {"fprint"              ,0, Emit_FileIOProcs},
   {"free"                ,0, Emit_Dynamic},
   {"function"            ,0, Emit_FuncSub},
   {"functionreturn"      ,0, Emit_FunctionReturn},
   {"fwrite"              ,0, Emit_FileIOProcs},
   {"global"              ,0, Emit_Shared_Global},
   {"gosub"               ,0, Emit_ControlFlow},
   {"goto"                ,0, Emit_ControlFlow},
   {"gui"                 ,0, Emit_GUIProcs},
   {"if"                  ,0, Emit_ControlFlow},
   {"impfunction"         ,0, Emit_Implied},
   {"incr"                ,0, Emit_MathProcs},
   {"input"               ,0, Emit_KeyboardProcs},
   {"insertmenu"          ,0, Emit_GUIProcs},
   {"kill"                ,0, Emit_FileManagementProcs},
   {"lineinput"           ,0, Emit_FileIOProcs},
   {"local"               ,0, Emit_OtherProcs},
   {"locate"              ,0, Emit_ConsoleOnlyProcs},
   {"loop"                ,0, Emit_ControlFlow},
   {"lprint"              ,0, Emit_PrinterProcs},
   {"mdigui"              ,0, Emit_GUIProcs},
   {"midstr"              ,0, Emit_StringProcs},
   {"mkdir"               ,0, Emit_FolderDriveProcs},
   {"msgbox"              ,0, Emit_GUIProcs},
   {"namespace"           ,0, Emit_CPP},
   {"next"                ,0, Emit_ControlFlow},
   {"open"                ,0, Emit_FileIO},
   {"optfunction"         ,0, Emit_OptFuncSub},
   {"optsub"              ,0, Emit_OptFuncSub},
   {"overloadedfunction"  ,0, Emit_OverLoadFuncSub},
   {"overloadedsub"       ,0, Emit_OverLoadFuncSub},
   {"panel"               ,0, Emit_ConsoleOnlyProcs},
   {"pptype"              ,0, Emit_PPType},
   {"prepend"             ,0, Emit_ControlFlow},
   {"print"               ,0, Emit_ConsoleOnlyProcs},
   {"printerclose"        ,0, Emit_PrinterProcs},
   {"printeropen"         ,0, Emit_PrinterProcs},
   {"private"             ,0, Emit_CPP},
   {"privatedim"          ,0, Emit_OtherProcs},
   {"privatefunction"     ,0, Emit_FuncSub},
   {"privatesub"          ,0, Emit_FuncSub},
   {"protected"           ,0, Emit_CPP},
   {"public"              ,0, Emit_CPP},
   {"publicfunction"      ,0, Emit_FuncSub},
   {"publicsub"           ,0, Emit_FuncSub},
   {"qsort"               ,0, Emit_ArrayProcs},
   {"qsortidx"            ,0, Emit_ArrayProcs},
   {"raw"                 ,0, Emit_OtherProcs},
   {"record"              ,0, Emit_FileIO},
   {"redim"               ,0, Emit_OtherProcs},
   {"register"            ,0, Emit_OtherProcs},
   {"rename"              ,0, Emit_FileManagementProcs},
   {"repeat"              ,0, Emit_ControlFlow},
   {"return"              ,0, Emit_ControlFlow},
   {"rmdir"               ,0, Emit_FolderDriveProcs},
   {"run"                 ,0, Emit_OtherProcs},
   {"seek"                ,0, Emit_FileIOProcs},
   {"select"              ,0, Emit_ControlFlow},
   {"seteof"              ,0, Emit_FileIOProcs},
   {"shared"              ,0, Emit_Shared_Global},
   {"shell"               ,0, Emit_OtherProcs},
   {"sprint"              ,0, Emit_PrinterProcs},
   {"static"              ,0, Emit_OtherProcs},
   {"sub"                 ,0, Emit_FuncSub},
   {"swap"                ,0, Emit_OtherProcs},
   {"template"            ,0, Emit_template},
   {"textmode"            ,0, Emit_ConsoleOnlyProcs},
   {"throw"               ,0, Emit_CPP},
   {"try"                 ,0, Emit_CPP},
   {"type"                ,0, Emit_Type},
   {"union"               ,0, Emit_Union},
   {"wend"                ,0, Emit_ControlFlow},
   {"while"               ,0, Emit_ControlFlow},
   {"with"                ,0, Emit_ControlFlow},
   {"write"               ,0, Emit_ConsoleOnlyProcs},
   {"xfor"                ,0, Emit_ControlFlow},
   {"xnext"               ,0, Emit_ControlFlow},
   {"~else"               ,0, Emit_ConditionalCompilation},
   {"~elseif"             ,0, Emit_ConditionalCompilation},
   {"~endif"              ,0, Emit_ConditionalCompilation},
   {"~get"                ,0, Emit_FileIOProcs},
   {"~hscroll"            ,0, Emit_GUIProcs},
   {"~if"                 ,0, Emit_ConditionalCompilation},
   {"~ifdef"              ,0, Emit_ConditionalCompilation},
   {"~ifndef"             ,0, Emit_ConditionalCompilation},
   {"~pragmaoptimizeoff"  ,0, Emit_ConditionalCompilation},
   {"~pragmaoptimizeon"   ,0, Emit_ConditionalCompilation},
   {"~put"                ,0, Emit_FileIOProcs},
   {"~vscroll"            ,0, Emit_GUIProcs}
END SET



SET tDirectives[] AS tagWords
   '*************************************************
   ' Must be in lower case and in alphabetical order
   '*************************************************
   {"#include"            ,0, Doinclude     },
   {"$accelerator"        ,0, Doaccelerator },
   {"$asm"                ,0, Doasm         },
   {"$bcx_resource"       ,0, Dobcx_resource},
   {"$bcxstrsize"         ,0, DoBcxStrSize  },
   {"$bcxversion"         ,0, Dobcxversion  },
   {"$case_off"           ,0, DoCase_offon  },
   {"$case_on"            ,0, DoCase_offon  },
   {"$catch"              ,0, Docatch       },
   {"$ccode"              ,0, Doccode       },
   {"$class"              ,0, Doclass       },
   {"$com_off"            ,0, Docom_op      },
   {"$com_on"             ,0, Docom_op      },
   {"$com_trace"          ,0, Docom_op      },
   {"$comment"            ,0, Docomment     },
   {"$compiler"           ,0, Docompiler    },
   {"$cpp"                ,0, Docpp         },
   {"$cpphdr"             ,0, Docpphdr      },
   {"$cproto"             ,0, Docproto      },
   {"$debug"              ,0, Dodebug       },
   {"$define"             ,0, Dodefine      },
   {"$dll"                ,0, Dodll         },
   {"$endnamespace"       ,0, DoNameSpace   },
   {"$endtry"             ,0, DoTry         },
   {"$filetest"           ,0, Dofiletest    },
   {"$fill"               ,0, Dofillstring  },
   {"$fsstatic"           ,0, Dofsstatic    },
   {"$genfree"            ,0, Dogenfree     },
   {"$header"             ,0, Doheader      },
   {"$include"            ,0, Doinclude     },
   {"$interface"          ,0, Dointerface   },
   {"$iprint_off"         ,0, Doiprint_offon},
   {"$iprint_on"          ,0, Doiprint_offon},
   {"$leanandmean"        ,0, Doleanandmean },
   {"$liberror"           ,0, Doliberror    },
   {"$library"            ,0, Dolibrary     },
   {"$linker"             ,0, Dolinker      },
   {"$mt"                 ,0, Domultithread },
   {"$multi"              ,0, Domultithread },
   {"$namespace"          ,0, DoNameSpace   },
   {"$nodllmain"          ,0, Dodll         },
   {"$noini"              ,0, Donoini       },
   {"$noio"               ,0, Donoio        },
   {"$nolibrary"          ,0, Doremovelib   },
   {"$nomain"             ,0, Donomain      },
   {"$nowin"              ,0, Donowin       },
   {"$onentry"            ,0, Doonentry     },
   {"$onexit"             ,0, Doonexit      },
   {"$optimizer"          ,0, Dooptimizer   },
   {"$pack"               ,0, Dopack        },
   {"$pp"                 ,0, Dopp          },
   {"$prj"                ,0, Doprj         },
   {"$prjuse"             ,0, Doprj         },
   {"$project"            ,0, Doproject     },
   {"$rems"               ,0, Dorems        },
   {"$resource"           ,0, Doresource    },
   {"$source"             ,0, Dosource      },
   {"$stdcall"            ,0, Dostdcall     },
   {"$test"               ,0, Dotest        },
   {"$throw"              ,0, Dothrow       },
   {"$trace"              ,0, Dotrace       },
   {"$try"                ,0, DoTry         },
   {"$typedef"            ,0, Dotypedef     },
   {"$usenamespace"       ,0, DoNameSpace   },
   {"$warnings"           ,0, DoWarnings    },
   {"$warnings_off"       ,0, DoWarnings    },
   {"$zap"                ,0, DoZap         }
END SET
'***************************************************
$TYPEDEF UINT_PTR (CALLBACK *CPP_FARPROC)(PCHAR)
'***************************************************
'     GLOBAL CONSTANTS AND RELATED VARIABLES
'***************************************************
MACRO   cMaxStk        = 4096
MACRO   cMaxByref      =  128
MACRO   cMaxDLLDecl    = 1024
MACRO   cMaxLoopLocal  =  256
GLOBAL  LinesWritten
GLOBAL  DebugModeOff
'***************************************************
MACRO   cMaxConstMacros = 1024
GLOBAL  ConstMacro$ [cMaxConstMacros]
GLOBAL  ConstMacroCnt AS INT
MACRO   MAXFILES = 256
GLOBAL  ByrefVars$ [cMaxByref]
GLOBAL  ByrefCnt
GLOBAL  LoopLocalVar [cMaxLoopLocal]
GLOBAL  LoopLocalCnt
GLOBAL  LoopType [cMaxLoopLocal] AS tagLoopLoc
GLOBAL  LoopTypeCnt
GLOBAL  FileNames$ [MAXFILES]                  ' array of source filenames
GLOBAL  LineNum [MAXFILES]                     ' line no in source files, also uses FileNdx
GLOBAL  FPtr [MAXFILES] AS FILE                ' Controls $Include Files
GLOBAL  FileNdx                                ' index of source files
'***************************************************
GLOBAL  Outfile AS FILE
GLOBAL  iDoWhile
GLOBAL  iLoopCond
GLOBAL  GlobalVarCnt
MACRO   cMaxBaseTypeDefs = 16
GLOBAL  BaseTypeDefsCnt  [cMaxBaseTypeDefs]
GLOBAL  TypeDefName$     [cMaxBaseTypeDefs]
GLOBAL  TypeDefsCnt
GLOBAL  GlobalDynaCnt
GLOBAL  LocalVarCnt
GLOBAL  LocalDynArrCnt                         ' Local Dynamic String Array Stack Counter
GLOBAL  LocalDynaCnt                           ' Queue Stack Counter
GLOBAL  CombineRes                             ' Join generated rc file with existing rc file
GLOBAL  UserResFile$                           ' holds name of user's *.rc file
GLOBAL  ResCompiler$                           ' resource compiler, lrc.exe
GLOBAL  FPtrNdx                                ' Controls $Include Files
GLOBAL  Stk$             [cMaxStk]             ' Parse array
GLOBAL  ProtoType        [cMAXProtoType] AS tagProtoStore  ' C prototype declarations of user's func's
MACRO   cMaxSingleLineIFLines = 256
GLOBAL  SrcStk$          [cMaxSingleLineIFLines]  ' used in parsing single line if-THEN-else
MACRO   cMaxSplitLines = 256
GLOBAL  SplitStk$        [cMaxSplitLines]         ' used in parsing ":" separated lines
GLOBAL  SplitCnt
GLOBAL  SplitCur
GLOBAL  SrcTmp$                                ' used for storing string to use as parameter to Parse()
MACRO   cMaxOnEntry = 256
GLOBAL  Entry$           [cMaxOnEntry]         ' Controls the $OnEntry
MACRO   cMaxOnExit = 256
GLOBAL  Xit$             [cMaxOnExit]          ' Controls the $OnExit
MACRO   cMaxLocalDynArr = 256
GLOBAL  LocalDynArrName$ [cMaxLocalDynArr]     ' Queues LOCAL dynamic string arrays
MACRO   cMaxGlobalDyna = 256
GLOBAL  GlobalDynaStr$   [cMaxGlobalDyna]
MACRO   cMaxDynaStr = 256
GLOBAL  DynaStr$         [cMaxDynaStr]         ' Queues Dynamic strings in SUBS/FUNCTIONS
MACRO   cMaxStartSub = 32
GLOBAL  StartSub$        [cMaxStartSub]        ' user's startup code subs
GLOBAL  StartNdx                               ' index for StartSub$
MACRO   cMaxExitSub = 32
GLOBAL  ExitSub$         [cMaxExitSub]         ' user's exit code subs
GLOBAL  ExitNdx                                ' index for ExitSub$
GLOBAL  Library$         [MaxLib]              ' stores libraries to used
GLOBAL  GlobalVarHash    [MaxGlobalVars]
GLOBAL  GlobalVars       [MaxGlobalVars] AS VarInfo
GLOBAL  LocalVars        [MaxLocalVars]  AS VarInfo
GLOBAL  TypeDefs         [MaxTypes]      AS UserTypeDefs
GLOBAL  UmQt                                   ' Handles quoted lines split with a contination _

'***************************************
' GLOBALS for parsing C++ statements
'***************************************

GLOBAL  UseCpp
GLOBAL  UseCpphdr
GLOBAL  UseIO
GLOBAL  InNameSpace
GLOBAL  InClass
GLOBAL  InPPType
GLOBAL  InClassName$
GLOBAL  iClassCnt
MACRO   cMaxClassNames = 1024
GLOBAL  ClassNames$[cMaxClassNames]
GLOBAL  InClassPP$
GLOBAL  IsVirtual
GLOBAL  szVirtual$
GLOBAL  UsingTemplate
GLOBAL  WasAClass
GLOBAL  HasVector

'**********************************************************************

GLOBAL  UseInLine
GLOBAL  Accelerator$
GLOBAL  CallBackFlag
GLOBAL  CallType$               ' Calling convention cdecl, stdcall ...
GLOBAL  LabelGenerator = 1000
GLOBAL  CaseVar$
GLOBAL  Cmd$
GLOBAL  Comma
GLOBAL  Compiler$
GLOBAL  CmdLineConst$
GLOBAL  CmdLineFileOut$
GLOBAL  CurrentFuncType
GLOBAL  DoCountLines
GLOBAL  DimType$
MACRO   cSizeOfDllDecl = 512
GLOBAL  DllDecl$ [cMaxDLLDecl][cSizeOfDllDecl] AS CHAR
GLOBAL  DllCnt
MACRO   cSizeOfLoadlibs = 512
MACRO   cMaxLoadlibs = 128
GLOBAL  Loadlibs$ [cMaxLoadlibs][cSizeOfLoadlibs] AS CHAR
GLOBAL  LoadLibsCnt
GLOBAL  Elapsed AS SINGLE
GLOBAL  EndOfProgram
GLOBAL  EntryCnt
GLOBAL  ErrFile
GLOBAL  ExitSubFunc
GLOBAL  szFile$
GLOBAL  Filnam$
GLOBAL  ForceMainToFunc
GLOBAL  FunctionName$
GLOBAL  szFileHandle$
GLOBAL  HFileCnt
MACRO   MaxHFiles = 128
GLOBAL  HFiles$[MaxHFiles]
GLOBAL  HFile$
GLOBAL  InConditional
GLOBAL  InIfDef$
GLOBAL  Indent
GLOBAL  InfoBoxWarn
GLOBAL  InDialogEvt
GLOBAL  ModDialogEvt
GLOBAL  InFunction
GLOBAL  InMain
GLOBAL  InWinMain
GLOBAL  IsCallBack
GLOBAL  UseFileTest = TRUE
GLOBAL  UseCProto
GLOBAL  InBlock
MACRO   cMaxLocalInBlocks = 16
GLOBAL  LocalInBlock[cMaxLocalInBlocks]
GLOBAL  InTypeDef
GLOBAL  NoTypeDeclare
GLOBAL  InsertComments
'************************ <Variable_Storage_Type>
GLOBAL  IsAuto
GLOBAL  IsDim
GLOBAL  IsLocal
GLOBAL  IsRaw
GLOBAL  IsRegister
GLOBAL  IsStatic
'************************ <Variable_Storage_Type>
GLOBAL  InDebug
GLOBAL  IsStdFunc
GLOBAL  KillCFile
GLOBAL  Keyword1$
GLOBAL  LastCmd
GLOBAL  LinesRead
GLOBAL  Linker$
GLOBAL  MakeDLL
GLOBAL  Ndx
GLOBAL  NoMain AS BOOL
GLOBAL  NoDllMain AS BOOL
GLOBAL  OkayToSend AS BOOL
GLOBAL  OptimizerEnabled AS BOOL
GLOBAL  OptimizerFirstSetting AS BOOL
GLOBAL  OptionBase
GLOBAL  OutfileClone$
GLOBAL  PassOne AS BOOL
GLOBAL  Project$
GLOBAL  ProtoCnt
GLOBAL  StateIdx
GLOBAL  PPFlag AS BOOL
GLOBAL  PPDLL_HANDLE AS HINSTANCE
GLOBAL  PPProc AS CPP_FARPROC
GLOBAL  Use_LoadLibraryError        ' Use error routine when loading libraries
GLOBAL  LibraryErrorLog$            ' [Path\][Name] of error log for loading libraries
GLOBAL  Use_Project AS BOOL         ' Vic McClung for $PROJECT Support
GLOBAL  Gen_Header AS BOOL          ' Vic McClung for $PROJECT Support
GLOBAL  Project_Main$               ' main file in $PROJECT
GLOBAL  Project_List$               ' list of files in project
GLOBAL  Project_Path$               ' path for project output files, i.e. .h;.c;.cpp
GLOBAL  NoRT AS BOOL                ' Emit all c\c++ code -EXCEPT- BCX runtime c\c++ code
GLOBAL  Quiet AS BOOL               ' no output to screen, for use with BCX Builder
GLOBAL  WarningFlag AS BOOL
GLOBAL  ZapFlag AS BOOL             ' remove default libs and headers [-z]
GLOBAL  ReDirect AS BOOL
GLOBAL  SaveOutfileNum AS FILE
GLOBAL  Scoot$
GLOBAL  ShowStatus
GLOBAL  SrcCnt
GLOBAL  SrcFlag
GLOBAL  TraceFlag
GLOBAL  TestForBcxIni AS BOOL
GLOBAL  FileIn$
GLOBAL  FileOut$
GLOBAL  FileErr$
GLOBAL  iEmitVarGroup
GLOBAL  Res_File$
GLOBAL  ResFileOut$
GLOBAL  Test
GLOBAL  Statements
GLOBAL  IgnoreStrCase       ' TRUE | FALSE depending on $CASE_ON | $CASE_OFF
GLOBAL  TestState
GLOBAL  gszType$
GLOBAL  TranslateSlash
GLOBAL  Use_BcxTmpStr
GLOBAL  Use_Bcx_stricmp
GLOBAL  UseStdCall
GLOBAL  Use_LCaseTbl
GLOBAL  Use_UCaseTbl
GLOBAL  WinHeaders
GLOBAL  Var$
GLOBAL  XitCount
GLOBAL  GTmp$
GLOBAL  ConstLastDef$
GLOBAL  UserBcxStrSize$      ' $BCXSTRSIZE support
GLOBAL  TS_CompPtr           ' flag for empty tokens in Stk$[] in TokenSubstitutions
'**********************************************************************
'   Use_ Vars control and limit the runtime functions that BCX emits
'**********************************************************************
GLOBAL  Use_GUINoMain
GLOBAL  Use_MDIGUINoMain
GLOBAL  GUIIcon$
GLOBAL  GUIMetric$
GLOBAL  Use_Wingui
GLOBAL  Use_MainEvent
GLOBAL  Use_Mdigui
GLOBAL  Use_ShowModal
GLOBAL  Use_EndModal
GLOBAL  Use_BCX_MsgPump
GLOBAL  Use_BCX_MDI_MsgPump
GLOBAL  Use_BCX_Wnd
GLOBAL  Use_BCX_FrameWnd
GLOBAL  Use_BCX_SetBkGrdBrush
GLOBAL  Use_BCX_SetClassStyle
GLOBAL  Use_BCX_SetIcon
GLOBAL  Use_BCX_SetIconSm
GLOBAL  Use_BCX_SetMetric
GLOBAL  Use_BCX_InitGUI
GLOBAL  Use_BCX_RegWnd
GLOBAL  Use_BCX_SetCursor
GLOBAL  Use_AnsiToWide
GLOBAL  Use_Asinh
GLOBAL  Use_Acosh
GLOBAL  Use_AppActivate
GLOBAL  Use_Atanh
GLOBAL  Use_Asc
GLOBAL  Use_AppExeName
GLOBAL  Use_AppExePath
GLOBAL  Use_Bff
GLOBAL  Use_Boolstr
GLOBAL  Use_Bnot
GLOBAL  Use_BCX_BmpWidth
GLOBAL  Use_BCX_BmpHeight
GLOBAL  Use_BCX_Class_Info
GLOBAL  Use_BCX_LoadBMP
GLOBAL  Use_BCX_LoadImage
GLOBAL  Use_BCX_Control
GLOBAL  Use_BCX_Colordlg
GLOBAL  Use_BCX_Cursor
GLOBAL  Use_BCX_Fontdlg
GLOBAL  Use_BCX_Floodfill
GLOBAL  Use_BCX_Get
GLOBAL  Use_BcxSplitPath
GLOBAL  Use_BCX_Path
GLOBAL  Use_BCX_Put
GLOBAL  Use_BCX_Preset
GLOBAL  Use_BCX_Pset
GLOBAL  Use_BCX_Line
GLOBAL  Use_BCX_Lineto
GLOBAL  Use_BCX_Circle
GLOBAL  Use_BCX_Ellipse
GLOBAL  Use_BCX_Rectangle
GLOBAL  Use_BCX_Resize
GLOBAL  Use_BCX_Roundrect
GLOBAL  Use_BCX_Getpixel
GLOBAL  Use_BCX_Arc
GLOBAL  Use_BCX_OlePicture
GLOBAL  Use_BCX_Polygon
GLOBAL  Use_BCX_PolyBezier
GLOBAL  Use_BCX_Polyline
GLOBAL  Use_BCX_Print
GLOBAL  Use_BCX_Tile
GLOBAL  Use_BCX_Slider
GLOBAL  Use_BCX_Splitter
GLOBAL  Use_BCX_Tab
GLOBAL  Use_BCX_Toolbar
GLOBAL  Use_BCX_UpDown
GLOBAL  Use_BCX_Get_UpDown
GLOBAL  Use_Bin
GLOBAL  Use_Bin2dec
GLOBAL  Use_Cast
GLOBAL  Use_Cvd
GLOBAL  Use_Cvld
GLOBAL  Use_Cvi
GLOBAL  Use_Cvl
GLOBAL  Use_Cvs
GLOBAL  Use_Cdbl
GLOBAL  Use_Cldbl
GLOBAL  Use_Csng
GLOBAL  Use_Clear
GLOBAL  Use_Clip_Getbitmap
GLOBAL  Use_Clip_Setbitmap
GLOBAL  Use_Clip_Gettext
GLOBAL  Use_Clip_Gettextsize
GLOBAL  Use_Clip_Reset
GLOBAL  Use_Clip_Settext
GLOBAL  Use_Chr
GLOBAL  Use_Cbool
GLOBAL  Use_Cint
GLOBAL  Use_Clng
GLOBAL  Use_Cls
GLOBAL  Use_Color
GLOBAL  Use_Command
GLOBAL  Use_ComboBoxLoadFile
GLOBAL  Use_Console
GLOBAL  Use_Consolesize
GLOBAL  Use_ContainedIn
GLOBAL  Use_Cpad
GLOBAL  Use_Static
GLOBAL  Use_CreateRegInt
GLOBAL  Use_CreateRegString
GLOBAL  Use_Crlf
GLOBAL  Use_Csrlin
GLOBAL  Use_Curdir
GLOBAL  Use_Cursor
GLOBAL  Use_Date
GLOBAL  Use_IsoDate
GLOBAL  Use_Datacount
GLOBAL  Use_Del
GLOBAL  Use_DeleteRegKey
GLOBAL  Use_Diskfree
GLOBAL  Use_Diskused
GLOBAL  Use_Disksize
GLOBAL  Use_Doevents
GLOBAL  Use_Download
GLOBAL  Use_Draw
GLOBAL  Use_Dynacall
GLOBAL  Use_DynacallA
GLOBAL  Use_DynacallCommon
GLOBAL  Use_DynamicA
GLOBAL  Use_DrawTransBMP
GLOBAL  Use_Elf
GLOBAL  Use_Enclose
GLOBAL  Use_Environ
GLOBAL  Use_EnumFile
GLOBAL  Use_Eof
GLOBAL  Use_EqualTo
GLOBAL  Use_Exist
GLOBAL  Use_ExitCode
GLOBAL  Use_Extract
GLOBAL  Use_LeanAndMean
GLOBAL  Use_LoadFile
GLOBAL  Use_FillArray
GLOBAL  Use_FirstInstance
GLOBAL  Use_Findfirst
GLOBAL  Use_Findnext
GLOBAL  Use_FindInType
GLOBAL  Use_Fint
GLOBAL  Use_Fix
GLOBAL  Use_FileLocked
GLOBAL  Use_Frac
GLOBAL  Use_Fracl
GLOBAL  Use_Freefile
GLOBAL  Use_Get
GLOBAL  Use_GetBmp
GLOBAL  Use_SetDimension
GLOBAL  Use_GetDimension
GLOBAL  Use_Getdrive
GLOBAL  Use_Getfilename
GLOBAL  Use_Getattr
GLOBAL  Use_GetResource
GLOBAL  Use_GetSpecialFolder
GLOBAL  Use_GetSpecialFolderex
GLOBAL  Use_GetTextSize
GLOBAL  Use_GenFree
GLOBAL  Use_GoSub
GLOBAL  Use_Hex
GLOBAL  Use_Hex2Dec
GLOBAL  Use_Hook
GLOBAL  Use_Iif
GLOBAL  Use_Inputbuffer
GLOBAL  Use_Inkey
GLOBAL  Use_InkeyD
GLOBAL  Use_Inputbox
GLOBAL  Use_Infobox
GLOBAL  Use_BoxCommon
GLOBAL  Use_Isptr
GLOBAL  Use_Ins
GLOBAL  Use_Instr
GLOBAL  Use_Inchr
GLOBAL  Use_iReplace
GLOBAL  Use_IRemove
GLOBAL  Use_Instrrev
GLOBAL  Use_Imod
GLOBAL  Use_Istrue
GLOBAL  Use_Isfalse
GLOBAL  Use_Isnull
GLOBAL  Use_Notnull
GLOBAL  Use_Iszero
GLOBAL  Use_Issystem
GLOBAL  Use_Ishidden
GLOBAL  Use_Isreadonly
GLOBAL  Use_Isfolder
GLOBAL  Use_Isfile
GLOBAL  Use_Join
GLOBAL  Use_Keypress
GLOBAL  Use_KBinput
GLOBAL  Use_Lcase
GLOBAL  Use_LccPath
GLOBAL  Use_PellesPath
GLOBAL  Use_Ldouble
GLOBAL  Use_Left
GLOBAL  Use_LeftStr
GLOBAL  Use_Like
GLOBAL  Use_LineinputKB
GLOBAL  Use_ListBoxLoadFile
GLOBAL  Use_Loc
GLOBAL  Use_Longestline
GLOBAL  Use_Locate
GLOBAL  Use_Lof
GLOBAL  Use_Lpad
GLOBAL  Use_Ltrim
GLOBAL  Use_Mcase
GLOBAL  Use_Mid
GLOBAL  Use_Midstr
GLOBAL  Use_Msgbox
GLOBAL  Use_Mkd
GLOBAL  Use_Mkld
GLOBAL  Use_Mki
GLOBAL  Use_Mkl
GLOBAL  Use_Mks
GLOBAL  Use_Mkpath
GLOBAL  Use_Min
GLOBAL  Use_Modstyle
GLOBAL  Use_Max
GLOBAL  Use_NamePathFromFP
GLOBAL  Use_Nextlinelen
GLOBAL  Use_Now
GLOBAL  Use_Notzero
GLOBAL  Use_NotEqualTo
GLOBAL  Use_Numqsortdint
GLOBAL  Use_Numqsortaint
GLOBAL  Use_Numqsortdfloat
GLOBAL  Use_Numqsortafloat
GLOBAL  Use_Numqsortddouble
GLOBAL  Use_Numqsortadouble
GLOBAL  Use_Idxqsort
GLOBAL  Use_IdxqsortSt
GLOBAL  Use_PtrqsortSt
GLOBAL  Use_PushPopColors
GLOBAL  Use_Oct
GLOBAL  Use_Overloaded
GLOBAL  Use_OSVersion
GLOBAL  Use_Panel
GLOBAL  Use_Pause
GLOBAL  Use_PeekStr
GLOBAL  Use_Pos
GLOBAL  Use_Printer
GLOBAL  Use_ProgressBar
GLOBAL  Use_Proto
GLOBAL  Use_Put
GLOBAL  Use_QBColor
GLOBAL  Use_Randomize
GLOBAL  Use_Read
GLOBAL  Use_Readnum
GLOBAL  Use_Rec
GLOBAL  Use_RecCount
GLOBAL  Use_Remain
GLOBAL  Use_Remove
GLOBAL  Use_Repeat
GLOBAL  Use_Replace
GLOBAL  Use_Reverse
GLOBAL  Use_Right
GLOBAL  Use_RightStr
GLOBAL  Use_Rpad
GLOBAL  Use_Rnd
GLOBAL  Use_Rnd2
GLOBAL  Use_Exp
GLOBAL  Use_Retain
GLOBAL  Use_Round
GLOBAL  Use_Rtrim
GLOBAL  Use_Run
GLOBAL  Use_SaveBmp
GLOBAL  Use_Scan
GLOBAL  Use_Screen
GLOBAL  Use_Setattr
GLOBAL  Use_Seteof
GLOBAL  Use_SearchPath
GLOBAL  Use_Set_BCX_Bitmap
GLOBAL  Use_Set_BCX_Bitmap2
GLOBAL  Use_Set_BCX_BmpButton
GLOBAL  Use_Set_BCX_Icon
GLOBAL  Use_Sgn
GLOBAL  Use_SingleFile AS BOOL
GLOBAL  Use_Sound
GLOBAL  Use_Space
GLOBAL  Use_Split
GLOBAL  Use_DSplit
GLOBAL  Use_StartupCode
GLOBAL  Use_Stristr
GLOBAL  Use_Str
GLOBAL  Use_Strl
GLOBAL  Use_Strim
GLOBAL  Use_String
GLOBAL  Use_Strptr
GLOBAL  Use_Strqsorta
GLOBAL  Use_Strqsortas
GLOBAL  Use_Strqsortd
GLOBAL  Use_Strqsortds
GLOBAL  Use_Strqsorts
GLOBAL  Use_Strtoken
GLOBAL  Use_DynStrqsorta
GLOBAL  Use_DynStrqsortas
GLOBAL  Use_DynStrqsortd
GLOBAL  Use_DynStrqsortds
GLOBAL  Use_DynAlphaNumericA
GLOBAL  Use_DynAlphaNumericD
GLOBAL  Use_AlphaNumericA
GLOBAL  Use_AlphaNumericD
GLOBAL  Use_AlphaNumeric
GLOBAL  Use_RegExist
GLOBAL  Use_RegInt
GLOBAL  Use_RegString
GLOBAL  Use_Resource
GLOBAL  Use_GenResFile
GLOBAL  Use_Swap
GLOBAL  Use_Sysdir
GLOBAL  Use_SysMacros
GLOBAL  Use_SysStr
GLOBAL  Use_sziif
GLOBAL  Use_Tally
GLOBAL  Use_Tempdir
GLOBAL  Use_TempFileName
GLOBAL  Use_Textmode
GLOBAL  Use_Threads
GLOBAL  Use_Time
GLOBAL  Use_Timer
GLOBAL  Use_Treeview
GLOBAL  Use_Trim
GLOBAL  Use_Ucase
GLOBAL  Use_Using
GLOBAL  Use_Ubound
GLOBAL  Use_Unwrap
GLOBAL  Use_VChr
GLOBAL  Use_VBS
GLOBAL  Use_Verify
GLOBAL  Use_Val
GLOBAL  Use_Vall
GLOBAL  Use_WideToAnsi
GLOBAL  Use_Vscroll
GLOBAL  Use_Hscroll
GLOBAL  Use_Windir
GLOBAL  Use_Wrap

'*******************

GLOBAL  Use_BCX_Input
GLOBAL  Use_BCX_ToolTip
GLOBAL  Use_Bitmap
GLOBAL  Use_Blackrect
GLOBAL  Use_BmpButton
GLOBAL  Use_Button
GLOBAL  Use_Center
GLOBAL  Use_Checkbox
GLOBAL  Use_Combobox
GLOBAL  Use_Datepick
GLOBAL  Use_Edit
GLOBAL  Use_BCXMDialog
GLOBAL  Use_BCXDialog
GLOBAL  Use_BCXDialogCommon
GLOBAL  Use_Form
GLOBAL  Use_GetText
GLOBAL  Use_Grayrect
GLOBAL  Use_Group
GLOBAL  Use_Hide
GLOBAL  Use_Icon
GLOBAL  Use_Label
GLOBAL  Use_Listbox
GLOBAL  Use_Listview
GLOBAL  Use_PlayWav
GLOBAL  Use_Radio
GLOBAL  Use_Refresh
GLOBAL  Use_Richedit
GLOBAL  Use_SetColor
GLOBAL  Use_Setclientsize
GLOBAL  Use_SetFont
GLOBAL  Use_SetFormColor
GLOBAL  Use_SetText
GLOBAL  Use_Show
GLOBAL  Use_Status
GLOBAL  Use_Whiterect

'********************************
' PB Compatible String Constants
'********************************

GLOBAL  Use_BEL
GLOBAL  Use_BS
GLOBAL  Use_CR
GLOBAL  Use_DDQ
GLOBAL  Use_DQ
GLOBAL  Use_EF
GLOBAL  Use_ESC
GLOBAL  Use_FF
GLOBAL  Use_LF
GLOBAL  Use_NUL
GLOBAL  Use_SPC
GLOBAL  Use_TAB
GLOBAL  Use_VT

'**************************************************************

GLOBAL  cppFile$       ' C/C++ file
GLOBAL  prcFile$       ' translated subs and functions
GLOBAL  udtFile$       ' translated User Defined Types
GLOBAL  datFile$       ' translated DATA statements
GLOBAL  UsrFile$       ' User's translated CONSTants
GLOBAL  SysFile$       ' system translated CONSTants
GLOBAL  ovrFile$       ' translated overloaded subs and functions
GLOBAL  hdrFile$       ' user specified .h directives
GLOBAL  setFile$       ' translated GLOBAL set statements
GLOBAL  resFile$       ' user specified .rc directives
GLOBAL  enuFile$       ' user's GLOBAL enum blocks
GLOBAL  defFile$       ' user's $DEFINE statements
'*************************************************************************
'               GLOBAL VARIABLES FOR LATE BINDING COM SUPPORT
'*************************************************************************

GLOBAL  ComSwitchON = FALSE          ' flag indicating use of COM in source
GLOBAL  ProcessingCOM_Set
GLOBAL  COM_gl_names [COM_Max_Gl_Objs+1] AS COM_NAMES_STORAGE  ' COM objects GLOBAL names
GLOBAL  COM_lc_names [COM_Max_Lc_Objs+1] AS COM_NAMES_STORAGE  ' COM objects LOCAL  names (SUBs and FUNCs)
GLOBAL  COM_gl_names_index%          ' count of com objects used as GLOBAL variables
GLOBAL  COM_lc_names_index%          ' count of com objects used as LOCAL variables (SUBs and FUNCs)
GLOBAL  COM_gl_names_free_index%     ' pointer to a free space in COM_gl_names[]
GLOBAL  COM_lc_names_free_index%     ' pointer to a free space in COM_lc_names[]
GLOBAL  COM_build_trace_code
GLOBAL  COM_with_temp_str_name$
GLOBAL  COM_open_WITH_statement
GLOBAL  COM_FOREACH_enumerator       ' temp variable used in (for each ...) constructions
GLOBAL  Use_COM                      ' COM is used in project, so emit COM functions.
GLOBAL  Use_BCX_COM_CreateObject
GLOBAL  Use_BCX_COM_GetObject
GLOBAL  Use_BCX_COM_DispatchObject
GLOBAL  Use_BCX_COM_GetProperty
GLOBAL  Use_BCX_COM_SetProperty
GLOBAL  Use_BCX_COM_InvokeMethod
GLOBAL  Use_BCX_COM_SafeArray
GLOBAL  Use_BCX_COM_UsesConversion
GLOBAL  Use_COM_Collections          ' for unicode support
GLOBAL  Use_UNICODE                  ' for unicode support
GLOBAL  Use_MULTITHREADED_SW         ' for multithreaded applications
GLOBAL  Use_SafeArrays

'*************************************************************************
'           END GLOBAL VARIABLES FOR LATE BINDING COM SUPPORT
'*************************************************************************

SET VarConst[2][8] AS CHAR
   "",
   "const "
END SET

SET VarStorage[6][18] AS CHAR
   "static ",
   "extern ",
   "",
   "static volatile ",
   "extern volatile ",
   "volatile "
END SET


'*************************************************************************
' For information on reserved words, currently how to translate
' Additional information may be added in the future.
'*************************************************************************
' Current information on reserved word, table is in alpabetical order
' Wayne Halsdorf
'*************************************************************************

ENUM
   eWI_CPPWord       = 0x0001
   eWI_ReplaceWord   = 0x0002
   eWI_NoFixup       = 0x0004
   eWI_Directive     = 0x0008
   eWI_Transform     = 0x0010
   eWI_Position1     = 0x0020
   eWI_Reserve10     = 0x0040
   eWI_Reserve09     = 0x0080
   eWI_Reserve08     = 0x0100
   eWI_Reserve07     = 0x0200
   eWI_Reserve06     = 0x0400
   eWI_Reserve05     = 0x0800
   eWI_Reserve04     = 0x1000
   eWI_Reserve03     = 0x2000
   eWI_Reserve02     = 0x4000
   eWI_Reserve01     = 0x8000
END ENUM

TYPE tagTokenSubFunctions
   iTRAN_FLAG        AS INT    ' Where translations are legal
   pszFunctionName   AS PCHAR  ' BCX word
   pszFunctionXName  AS PCHAR  ' if eWI_ReplaceWord set directly replace with this
   iWordInfo         AS INT    ' See ENUM above
   iCOM              AS INT    ' if can be used in directly with COM
END TYPE

GLOBAL iRIndex[97][2] AS INT    'Low to High Lookup table for BCXWords[] - Reduces lookup size

SET BCXWords[] AS tagTokenSubFunctions
   {1,"#include"               ,"#include"                      ,8,comvt_BAD},
   {1,"$accelerator"           ,""                              ,8,comvt_BAD},
   {1,"$asm"                   ,""                              ,8,comvt_BAD},
   {1,"$bcx_resource"          ,""                              ,8,comvt_BAD},
   {1,"$bcxstrsize"            ,""                              ,8,comvt_BAD},
   {1,"$bcxversion"            ,""                              ,8,comvt_BAD},
   {1,"$case_off"              ,""                              ,8,comvt_BAD},
   {1,"$case_on"               ,""                              ,8,comvt_BAD},
   {1,"$catch"                 ,""                              ,8,comvt_BAD},
   {1,"$ccode"                 ,""                              ,8,comvt_BAD},
   {1,"$class"                 ,""                              ,8,comvt_BAD},
   {1,"$com_off"               ,""                              ,8,comvt_BAD},
   {1,"$com_on"                ,""                              ,8,comvt_BAD},
   {1,"$com_trace"             ,""                              ,8,comvt_BAD},
   {1,"$comment"               ,""                              ,8,comvt_BAD},
   {1,"$compiler"              ,""                              ,8,comvt_BAD},
   {1,"$cpp"                   ,""                              ,8,comvt_BAD},
   {1,"$cpphdr"                ,""                              ,8,comvt_BAD},
   {1,"$cproto"                ,""                              ,8,comvt_BAD},
   {1,"$debug"                 ,""                              ,8,comvt_BAD},
   {1,"$define"                ,""                              ,8,comvt_BAD},
   {1,"$dll"                   ,""                              ,8,comvt_BAD},
   {1,"$else"                  ,"~else"                         ,2,comvt_BAD},
   {1,"$elseif"                ,"~elseif"                       ,2,comvt_BAD},
   {1,"$endif"                 ,""                              ,0,comvt_BAD},
   {1,"$endnamespace"          ,""                              ,8,comvt_BAD},
   {1,"$endtry"                ,""                              ,8,comvt_BAD},
   {1,"$filetest"              ,""                              ,8,comvt_BAD},
   {1,"$fill"                  ,""                              ,8,comvt_BAD},
   {1,"$fsstatic"              ,""                              ,8,comvt_BAD},
   {1,"$genfree"               ,""                              ,8,comvt_BAD},
   {1,"$header"                ,""                              ,8,comvt_BAD},
   {1,"$hscroll"               ,"~hscroll"                      ,2,comvt_BAD},
   {1,"$if"                    ,""                              ,0,comvt_BAD},
   {1,"$ifdef"                 ,""                              ,0,comvt_BAD},
   {1,"$ifndef"                ,""                              ,0,comvt_BAD},
   {1,"$include"               ,""                              ,8,comvt_BAD},
   {1,"$interface"             ,""                              ,8,comvt_BAD},
   {1,"$iprint_off"            ,""                              ,8,comvt_BAD},
   {1,"$iprint_on"             ,""                              ,8,comvt_BAD},
   {1,"$lcc$"                  ,"$LCC$"                         ,2,comvt_BAD},
   {1,"$leanandmean"           ,""                              ,8,comvt_BAD},
   {1,"$liberror"              ,""                              ,8,comvt_BAD},
   {1,"$library"               ,""                              ,8,comvt_BAD},
   {1,"$linker"                ,""                              ,8,comvt_BAD},
   {1,"$mt"                    ,""                              ,8,comvt_BAD},
   {1,"$multi"                 ,""                              ,8,comvt_BAD},
   {1,"$namespace"             ,""                              ,8,comvt_BAD},
   {1,"$nodllmain"             ,""                              ,8,comvt_BAD},
   {1,"$noini"                 ,""                              ,8,comvt_BAD},
   {1,"$noio"                  ,""                              ,8,comvt_BAD},
   {1,"$nolibrary"             ,""                              ,8,comvt_BAD},
   {1,"$nomain"                ,""                              ,8,comvt_BAD},
   {1,"$nowin"                 ,""                              ,8,comvt_BAD},
   {1,"$onentry"               ,""                              ,8,comvt_BAD},
   {1,"$onexit"                ,""                              ,8,comvt_BAD},
   {1,"$optimizer"             ,""                              ,8,comvt_BAD},
   {1,"$pack"                  ,""                              ,8,comvt_BAD},
   {1,"$pp"                    ,""                              ,8,comvt_BAD},
   {1,"$prj"                   ,""                              ,8,comvt_BAD},
   {1,"$prjuse"                ,""                              ,8,comvt_BAD},
   {1,"$project"               ,""                              ,8,comvt_BAD},
   {1,"$rems"                  ,""                              ,8,comvt_BAD},
   {1,"$resource"              ,""                              ,8,comvt_BAD},
   {1,"$source"                ,""                              ,8,comvt_BAD},
   {1,"$stdcall"               ,""                              ,8,comvt_BAD},
   {1,"$test"                  ,""                              ,8,comvt_BAD},
   {1,"$throw"                 ,""                              ,8,comvt_BAD},
   {1,"$trace"                 ,""                              ,8,comvt_BAD},
   {1,"$try"                   ,""                              ,8,comvt_BAD},
   {1,"$typedef"               ,""                              ,8,comvt_BAD},
   {1,"$usenamespace"          ,""                              ,8,comvt_BAD},
   {1,"$vscroll"               ,"~vscroll"                      ,2,comvt_BAD},
   {1,"$warnings"              ,""                              ,8,comvt_BAD},
   {1,"$warnings_off"          ,""                              ,8,comvt_BAD},
   {1,"$zap"                   ,""                              ,8,comvt_BAD},
   {1,"_asm"                   ,"_asm"                          ,2,comvt_BAD},
   {1,"_bool"                  ,"_Bool"                         ,2,comvt_BAD},
   {1,"abs"                    ,"fabs"                          ,2,comvt_R8 },
   {1,"acos"                   ,"acos"                          ,2,comvt_R8 },
   {1,"acosh"                  ,""                              ,0,comvt_R8 },
   {1,"acosl"                  ,"acosl"                         ,2,comvt_BAD},
   {1,"addressof"              ,""                              ,0,comvt_BAD},
   {1,"alias"                  ,"alias"                         ,2,comvt_BAD},
   {1,"and"                    ,""                              ,0,comvt_BAD},
   {1,"andalso"                ,""                              ,0,comvt_BAD},
   {1,"ansitowide"             ,""                              ,0,comvt_BAD},
   {1,"appactivate"            ,""                              ,0,comvt_BAD},
   {1,"append"                 ,""                              ,0,comvt_BAD},
   {1,"appexename$"            ,""                              ,0,comvt_BAD},
   {1,"appexepath$"            ,""                              ,0,comvt_BAD},
   {1,"argc"                   ,"argc"                          ,2,comvt_BAD},
   {1,"argv"                   ,"argv"                          ,2,comvt_BAD},
   {1,"argv$"                  ,"argv$"                         ,2,comvt_BAD},
   {1,"arraygetelement"        ,""                              ,0,comvt_BAD},
   {1,"arrayputelement"        ,""                              ,0,comvt_BAD},
   {1,"as"                     ,""                              ,0,comvt_BAD},
   {3,"asc"                    ,""                              ,0,comvt_BAD},
   {1,"ascending"              ,""                              ,0,comvt_BAD},
   {1,"asin"                   ,"asin"                          ,2,comvt_R8 },
   {1,"asinh"                  ,""                              ,0,comvt_R8 },
   {1,"asinl"                  ,"asinl"                         ,2,comvt_BAD},
   {1,"asm"                    ,""                              ,1,comvt_BAD},
   {1,"atan"                   ,"atan"                          ,2,comvt_R8 },
   {1,"atanh"                  ,""                              ,0,comvt_R8 },
   {1,"atanl"                  ,"atanl"                         ,2,comvt_R8 },
   {1,"atn"                    ,"atan"                          ,2,comvt_R8 },
   {1,"atnl"                   ,"atanl"                         ,2,comvt_R8 },
   {1,"auto"                   ,"auto"                          ,2,comvt_BAD},
   {3,"band"                   ,""                              ,0,comvt_BAD},
   {1,"base"                   ,"base"                          ,2,comvt_BAD},
   {1,"bcopy"                  ,""                              ,0,comvt_BAD},
   {1,"bcx_addtab"             ,"BCX_AddTab"                    ,2,comvt_BAD},
   {1,"bcx_arc"                ,""                              ,0,comvt_BAD},
   {1,"bcx_bitmap"             ,""                              ,0,comvt_BAD},
   {1,"bcx_blackrect"          ,""                              ,0,comvt_BAD},
   {1,"bcx_bmpbutton"          ,""                              ,0,comvt_BAD},
   {1,"bcx_bmpheight"          ,""                              ,0,comvt_BAD},
   {1,"bcx_bmpwidth"           ,""                              ,0,comvt_BAD},
   {1,"bcx_button"             ,""                              ,0,comvt_BAD},
   {1,"bcx_checkbox"           ,""                              ,0,comvt_BAD},
   {1,"bcx_circle"             ,""                              ,0,comvt_BAD},
   {1,"bcx_classname$"         ,"BCX_ClassName$"                ,2,comvt_BAD},
   {1,"bcx_colordlg"           ,""                              ,0,comvt_BAD},
   {1,"bcx_combobox"           ,""                              ,0,comvt_BAD},
   {1,"bcx_console"            ,""                              ,0,comvt_BAD},
   {1,"bcx_control"            ,""                              ,0,comvt_BAD},
   {1,"bcx_cursor"             ,""                              ,0,comvt_BAD},
   {1,"bcx_datepick"           ,""                              ,0,comvt_BAD},
   {1,"bcx_dialog"             ,""                              ,0,comvt_BAD},
   {1,"bcx_dispatchobject"     ,""                              ,0,comvt_BAD},
   {1,"bcx_edit"               ,""                              ,0,comvt_BAD},
   {1,"bcx_ellipse"            ,""                              ,0,comvt_BAD},
   {1,"bcx_floodfill"          ,""                              ,0,comvt_BAD},
   {1,"bcx_font"               ,""                              ,0,comvt_BAD},
   {1,"bcx_fontdlg"            ,""                              ,0,comvt_BAD},
   {1,"bcx_form"               ,""                              ,0,comvt_BAD},
   {1,"bcx_framewnd"           ,""                              ,0,comvt_BAD},
   {1,"bcx_get"                ,""                              ,0,comvt_BAD},
   {1,"bcx_get_com_error_code" ,""                              ,0,comvt_BAD},
   {1,"bcx_get_com_error_desc$","BCX_GET_COM_ERROR_DESC()"      ,2,comvt_BAD},
   {1,"bcx_get_com_status"     ,"BCX_GET_COM_STATUS"            ,2,comvt_BAD},
   {1,"bcx_get_com_success"    ,"BCX_GET_COM_SUCCESS()"         ,2,comvt_BAD},
   {1,"bcx_get_text$"          ,""                              ,0,comvt_BAD},
   {1,"bcx_get_updown"         ,""                              ,0,comvt_BAD},
   {1,"bcx_getpixel"           ,""                              ,0,comvt_BAD},
   {1,"bcx_grayrect"           ,""                              ,0,comvt_BAD},
   {1,"bcx_group"              ,""                              ,0,comvt_BAD},
   {1,"bcx_hinstance"          ,"BCX_hInstance"                 ,2,comvt_BAD},
   {1,"bcx_icon"               ,""                              ,0,comvt_BAD},
   {1,"bcx_initgui"            ,""                              ,0,comvt_BAD},
   {1,"bcx_input"              ,""                              ,0,comvt_BAD},
   {1,"bcx_label"              ,""                              ,0,comvt_BAD},
   {1,"bcx_line"               ,""                              ,0,comvt_BAD},
   {1,"bcx_lineto"             ,""                              ,0,comvt_BAD},
   {1,"bcx_listbox"            ,""                              ,0,comvt_BAD},
   {1,"bcx_listview"           ,""                              ,0,comvt_BAD},
   {1,"bcx_loadbmp"            ,""                              ,0,comvt_BAD},
   {1,"bcx_loadimage"          ,""                              ,0,comvt_BAD},
   {1,"bcx_mdi_msgpump"        ,""                              ,0,comvt_BAD},
   {1,"bcx_mdialog"            ,""                              ,0,comvt_BAD},
   {1,"bcx_mdichild"           ,"BCX_MDICHILD"                  ,2,comvt_BAD},
   {1,"bcx_mdiclass"           ,"BCX_MDICLASS"                  ,2,comvt_BAD},
   {1,"bcx_mdiclient"          ,"BCX_MDICLIENT"                 ,2,comvt_BAD},
   {1,"bcx_msgpump"            ,""                              ,0,comvt_BAD},
   {1,"bcx_ole_height"         ,""                              ,0,comvt_BAD},
   {1,"bcx_ole_width"          ,""                              ,0,comvt_BAD},
   {1,"bcx_olepicture"         ,""                              ,0,comvt_BAD},
   {1,"bcx_polybezier"         ,""                              ,0,comvt_BAD},
   {1,"bcx_polygon"            ,""                              ,0,comvt_BAD},
   {1,"bcx_polyline"           ,""                              ,0,comvt_BAD},
   {1,"bcx_popconsolesize"     ,""                              ,0,comvt_BAD},
   {1,"bcx_preset"             ,""                              ,0,comvt_BAD},
   {1,"bcx_print"              ,""                              ,0,comvt_BAD},
   {1,"bcx_progressbar"        ,""                              ,0,comvt_BAD},
   {1,"bcx_pset"               ,""                              ,0,comvt_BAD},
   {1,"bcx_pushconsolesize"    ,""                              ,0,comvt_BAD},
   {1,"bcx_put"                ,""                              ,0,comvt_BAD},
   {1,"bcx_radio"              ,""                              ,0,comvt_BAD},
   {1,"bcx_rectangle"          ,""                              ,0,comvt_BAD},
   {1,"bcx_regwnd"             ,""                              ,0,comvt_BAD},
   {1,"bcx_remtab"             ,"BCX_RemTab"                    ,2,comvt_BAD},
   {1,"bcx_resource"           ,""                              ,0,comvt_BAD},
   {1,"bcx_richedit"           ,""                              ,0,comvt_BAD},
   {1,"bcx_roundrect"          ,""                              ,0,comvt_BAD},
   {1,"bcx_scalex"             ,"BCX_ScaleX"                    ,2,comvt_BAD},
   {1,"bcx_scaley"             ,"BCX_ScaleY"                    ,2,comvt_BAD},
   {1,"bcx_set_edit_color"     ,""                              ,0,comvt_BAD},
   {1,"bcx_set_font"           ,""                              ,0,comvt_BAD},
   {1,"bcx_set_form_color"     ,""                              ,0,comvt_BAD},
   {1,"bcx_set_label_color"    ,""                              ,0,comvt_BAD},
   {1,"bcx_set_text"           ,""                              ,0,comvt_BAD},
   {1,"bcx_setbkgrdbrush"      ,""                              ,0,comvt_BAD},
   {1,"bcx_setclassstyle"      ,""                              ,0,comvt_BAD},
   {1,"bcx_setcolor"           ,""                              ,0,comvt_BAD},
   {1,"bcx_setconsolesize"     ,""                              ,0,comvt_BAD},
   {1,"bcx_setcursor"          ,""                              ,0,comvt_BAD},
   {1,"bcx_seticon"            ,""                              ,0,comvt_BAD},
   {1,"bcx_seticonsm"          ,""                              ,0,comvt_BAD},
   {1,"bcx_setmetric"          ,""                              ,0,comvt_BAD},
   {1,"bcx_setsplitpos"        ,""                              ,0,comvt_BAD},
   {1,"bcx_show_com_errors"    ,"BCX_SHOW_COM_ERRORS"           ,2,comvt_BAD},
   {1,"bcx_slider"             ,""                              ,0,comvt_BAD},
   {1,"bcx_splitter"           ,""                              ,0,comvt_BAD},
   {1,"bcx_status"             ,""                              ,0,comvt_BAD},
   {1,"bcx_stricmp"            ,""                              ,0,comvt_BAD},
   {1,"bcx_tab"                ,""                              ,0,comvt_BAD},
   {1,"bcx_tabselect"          ,""                              ,0,comvt_BAD},
   {1,"bcx_thread"             ,""                              ,0,comvt_BAD},
   {1,"bcx_threadend"          ,""                              ,0,comvt_BAD},
   {1,"bcx_threadkill"         ,""                              ,0,comvt_BAD},
   {1,"bcx_threadresume"       ,""                              ,0,comvt_BAD},
   {1,"bcx_threadsuspend"      ,""                              ,0,comvt_BAD},
   {1,"bcx_threadwait"         ,""                              ,0,comvt_BAD},
   {1,"bcx_tile"               ,""                              ,0,comvt_BAD},
   {1,"bcx_toolbar"            ,""                              ,0,comvt_BAD},
   {1,"bcx_tooltip"            ,""                              ,0,comvt_BAD},
   {1,"bcx_treeview"           ,""                              ,0,comvt_BAD},
   {1,"bcx_updown"             ,""                              ,0,comvt_BAD},
   {1,"bcx_version$"           ,""                              ,0,comvt_BAD},
   {1,"bcx_whiterect"          ,""                              ,0,comvt_BAD},
   {1,"bcx_wnd"                ,""                              ,0,comvt_BAD},
   {1,"bcx_wndclass"           ,""                              ,0,comvt_BAD},
   {1,"bcxfont"                ,"BcxFont"                       ,2,comvt_BAD},
   {1,"bcxlib"                 ,"BCXLIB"                        ,2,comvt_BAD},
   {1,"bcxpath$"               ,""                              ,0,comvt_BAD},
   {1,"bcxsplitpath$"          ,""                              ,0,comvt_BAD},
   {1,"bcxstrsize"             ,"BCXSTRSIZE"                    ,0,comvt_BAD},
   {1,"begin"                  ,""                              ,0,comvt_BAD},
   {1,"bel$"                   ,""                              ,0,comvt_BAD},
   {1,"bff$"                   ,""                              ,0,comvt_BAD},
   {1,"bin$"                   ,""                              ,0,comvt_BAD},
   {1,"bin2dec"                ,""                              ,0,comvt_I4 },
   {1,"binary"                 ,""                              ,0,comvt_BAD},
   {3,"bnot"                   ,""                              ,0,comvt_BAD},
   {1,"bool"                   ,""                              ,0,comvt_BAD},
   {1,"bool$"                  ,""                              ,0,comvt_BAD},
   {1,"boolean"                ,""                              ,0,comvt_BAD},
   {3,"bor"                    ,""                              ,0,comvt_BAD},
   {1,"bs$"                    ,""                              ,0,comvt_BAD},
   {1,"byref"                  ,""                              ,0,comvt_BAD},
   {1,"byte"                   ,"BYTE"                          ,2,comvt_BAD},
   {1,"c_declare"              ,""                              ,0,comvt_BAD},
   {1,"call"                   ,""                              ,0,comvt_BAD},
   {1,"callback"               ,""                              ,0,comvt_BAD},
   {1,"callwindowproc"         ,""                              ,0,comvt_BAD},
   {1,"case"                   ,""                              ,0,comvt_BAD},
   {1,"catch"                  ,"catch"                         ,3,comvt_BAD},
   {1,"cbctl"                  ,"LOWORD(wParam)"                ,2,comvt_BAD},
   {1,"cbctlmsg"               ,"HIWORD(wParam)"                ,2,comvt_BAD},
   {1,"cbhndl"                 ,"hWnd"                          ,2,comvt_BAD},
   {1,"cbhwnd"                 ,"hWnd"                          ,2,comvt_BAD},
   {1,"cblparam"               ,"lParam"                        ,2,comvt_BAD},
   {1,"cbmsg"                  ,"Msg"                           ,2,comvt_BAD},
   {1,"cbool"                  ,""                              ,0,comvt_BAD},
   {1,"cbwparam"               ,"wParam"                        ,2,comvt_BAD},
   {1,"cdbl"                   ,""                              ,0,comvt_BAD},
   {1,"center"                 ,""                              ,0,comvt_BAD},
   {1,"char"                   ,"char"                          ,2,comvt_BAD},
   {1,"chdir"                  ,"_chdir"                        ,2,comvt_BAD},
   {1,"chdrive"                ,"_chdir"                        ,2,comvt_BAD},
   {1,"chr$"                   ,""                              ,0,comvt_BAD},
   {1,"cint"                   ,""                              ,0,comvt_BAD},
   {1,"class"                  ,"class"                         ,3,comvt_BAD},
   {1,"cldbl"                  ,""                              ,0,comvt_BAD},
   {1,"clear"                  ,""                              ,0,comvt_BAD},
   {1,"clipboard_getbitmap"    ,""                              ,0,comvt_BAD},
   {1,"clipboard_gettext"      ,""                              ,0,comvt_BAD},
   {1,"clipboard_gettextsize"  ,""                              ,0,comvt_BAD},
   {1,"clipboard_reset"        ,""                              ,0,comvt_BAD},
   {1,"clipboard_setbitmap"    ,""                              ,0,comvt_BAD},
   {1,"clipboard_settext"      ,""                              ,0,comvt_BAD},
   {1,"clng"                   ,""                              ,0,comvt_BAD},
   {1,"close"                  ,""                              ,0,comvt_BAD},
   {1,"close#"                 ,"close"                         ,2,comvt_BAD},
   {1,"closedialog"            ,""                              ,0,comvt_BAD},
   {1,"cls"                    ,""                              ,0,comvt_BAD},
   {1,"color"                  ,""                              ,0,comvt_BAD},
   {1,"color_bg"               ,""                              ,0,comvt_BAD},
   {1,"color_fg"               ,""                              ,0,comvt_BAD},
   {1,"colorref"               ,"COLORREF"                      ,2,comvt_BAD},
   {1,"com"                    ,"COM"                           ,0,comvt_BAD},
   {1,"comboboxloadfile"       ,""                              ,0,comvt_BAD},
   {1,"command$"               ,""                              ,0,comvt_BAD},
   {1,"concat"                 ,"strcat"                        ,2,comvt_BAD},
   {1,"const"                  ,"const"                         ,2,comvt_BAD},
   {1,"const_cast"             ,"const_cast"                    ,3,comvt_BAD},
   {1,"constructor"            ,""                              ,1,comvt_BAD},
   {1,"containedin"            ,""                              ,0,comvt_BAD},
   {1,"control"                ,"HWND"                          ,2,comvt_BAD},
   {1,"conwin"                 ,"GetConsoleWindow()"            ,2,comvt_BAD},
   {1,"copyfile"               ,"copyfile"                      ,2,comvt_BAD},
   {1,"cos"                    ,"cos"                           ,2,comvt_R8 },
   {1,"cosh"                   ,"cosh"                          ,2,comvt_R8 },
   {1,"cosl"                   ,"cosl"                          ,2,comvt_BAD},
   {1,"cpad$"                  ,""                              ,0,comvt_BAD},
   {1,"cr$"                    ,""                              ,0,comvt_BAD},
   {1,"createobject"           ,""                              ,0,comvt_BAD},
   {1,"createregint"           ,""                              ,0,comvt_BAD},
   {1,"createregstring"        ,""                              ,0,comvt_BAD},
   {1,"crlf$"                  ,""                              ,0,comvt_BAD},
   {1,"csng"                   ,""                              ,0,comvt_BAD},
   {1,"csrlin"                 ,""                              ,0,comvt_BAD},
   {1,"curdir$"                ,""                              ,0,comvt_BAD},
   {1,"currency"               ,"CURRENCY"                      ,2,comvt_BAD},
   {1,"cursorx"                ,""                              ,0,comvt_BAD},
   {1,"cursory"                ,""                              ,0,comvt_BAD},
   {1,"cvd"                    ,""                              ,0,comvt_BAD},
   {1,"cvi"                    ,""                              ,0,comvt_BAD},
   {1,"cvl"                    ,""                              ,0,comvt_BAD},
   {1,"cvld"                   ,""                              ,0,comvt_BAD},
   {1,"cvs"                    ,""                              ,0,comvt_BAD},
   {1,"data"                   ,""                              ,0,comvt_BAD},
   {1,"data$"                  ,"DATA$"                         ,2,comvt_BAD},
   {1,"date$"                  ,""                              ,0,comvt_BAD},
   {1,"ddq$"                   ,""                              ,0,comvt_BAD},
   {1,"declare"                ,""                              ,16,comvt_BAD},
   {1,"decr"                   ,"decr"                          ,2,comvt_BAD},
   {1,"del$"                   ,""                              ,0,comvt_BAD},
   {1,"delay"                  ,"delay"                         ,2,comvt_BAD},
   {1,"delete"                 ,"delete"                        ,3,comvt_BAD},
   {1,"deleteregkey"           ,""                              ,0,comvt_BAD},
   {1,"descending"             ,""                              ,0,comvt_BAD},
   {1,"destroysafearray"       ,"DestroySafeArray"              ,0,comvt_BAD},
   {1,"destructor"             ,""                              ,1,comvt_BAD},
   {1,"dialog"                 ,""                              ,0,comvt_BAD},
   {1,"dialogbox"              ,"DialogBox"                     ,2,comvt_BAD},
   {1,"dim"                    ,"dim"                           ,2,comvt_BAD},
   {1,"diskfree"               ,"DiskFree"                      ,0,comvt_BAD},
   {1,"disksize"               ,"DiskSize"                      ,0,comvt_BAD},
   {1,"diskused"               ,"DiskUsed"                      ,0,comvt_BAD},
   {1,"do"                     ,"do"                            ,2,comvt_BAD},
   {1,"doevents"               ,""                              ,0,comvt_BAD},
   {1,"double"                 ,"double"                        ,2,comvt_BAD},
   {1,"download"               ,""                              ,0,comvt_BAD},
   {1,"dpi"                    ,"dpi"                           ,2,comvt_BAD},
   {1,"dq$"                    ,""                              ,0,comvt_BAD},
   {1,"drawtransbmp"           ,""                              ,0,comvt_BAD},
   {1,"dsplit"                 ,""                              ,0,comvt_BAD},
   {1,"dwl_dlgproc"            ,"DWLP_DLGPROC"                  ,2,comvt_BAD},
   {1,"dwl_msgresult"          ,"DWLP_MSGRESULT"                ,2,comvt_BAD},
   {1,"dwl_user"               ,"DWLP_USER"                     ,2,comvt_BAD},
   {1,"dword"                  ,"DWORD"                         ,2,comvt_BAD},
   {1,"dynamic"                ,"dynamic"                       ,2,comvt_BAD},
   {1,"dynamic_cast"           ,"dynamic_cast"                  ,3,comvt_BAD},
   {1,"editloadfile"           ,""                              ,0,comvt_BAD},
   {1,"ejectpage"              ,"ejectpage"                     ,2,comvt_BAD},
   {1,"else"                   ,"else"                          ,2,comvt_BAD},
   {1,"elseif"                 ,""                              ,0,comvt_BAD},
   {1,"enc$"                   ,""                              ,0,comvt_BAD},
   {1,"end"                    ,""                              ,0,comvt_BAD},
   {1,"enddraw"                ,""                              ,0,comvt_BAD},
   {1,"endif"                  ,"endif"                         ,2,comvt_BAD},
   {1,"endmodal"               ,""                              ,0,comvt_BAD},
   {1,"enum"                   ,""                              ,0,comvt_BAD},
   {1,"environ$"               ,""                              ,0,comvt_BAD},
   {1,"eof"                    ,""                              ,0,comvt_BAD},
   {1,"eof$"                   ,""                              ,0,comvt_BAD},
   {1,"equalto"                ,""                              ,0,comvt_BAD},
   {1,"esc$"                   ,""                              ,0,comvt_BAD},
   {1,"events"                 ,"events"                        ,0,comvt_BAD},
   {1,"exist"                  ,""                              ,0,comvt_BAD},
   {1,"exit"                   ,"exit"                          ,2,comvt_BAD},
   {1,"exp"                    ,""                              ,0,comvt_R8 },
   {1,"explicit"               ,"explicit"                      ,3,comvt_BAD},
   {1,"export"                 ,"export"                        ,2,comvt_BAD},
   {1,"extern"                 ,"extern"                        ,2,comvt_BAD},
   {1,"extract$"               ,""                              ,0,comvt_BAD},
   {1,"fallthrough"            ,"fallthrough"                   ,2,comvt_BAD},
   {1,"false"                  ,""                              ,0,comvt_BAD},
   {1,"farproc"                ,"FARPROC"                       ,2,comvt_BAD},
   {1,"ff$"                    ,""                              ,0,comvt_BAD},
   {1,"file"                   ,"FILE"                          ,2,comvt_BAD},
   {1,"filelocked"             ,""                              ,0,comvt_BAD},
   {1,"fillarray"              ,""                              ,0,comvt_BAD},
   {1,"findfirst$"             ,""                              ,0,comvt_BAD},
   {1,"findfirstinstance"      ,""                              ,0,comvt_BAD},
   {1,"findintype"             ,""                              ,0,comvt_BAD},
   {1,"findnext$"              ,""                              ,0,comvt_BAD},
   {1,"finput"                 ,"finput"                        ,2,comvt_BAD},
   {1,"fint"                   ,""                              ,0,comvt_INT},
   {1,"fix"                    ,""                              ,0,comvt_R4 },
   {1,"flush"                  ,"fflush"                        ,2,comvt_BAD},
   {1,"for"                    ,""                              ,0,comvt_BAD},
   {1,"formload"               ,"FormLoad"                      ,2,comvt_BAD},
   {1,"fprint"                 ,"fprint"                        ,2,comvt_BAD},
   {1,"frac"                   ,""                              ,0,comvt_R8 },
   {1,"fracl"                  ,""                              ,0,comvt_BAD},
   {1,"free"                   ,"free"                          ,2,comvt_BAD},
   {1,"freefile"               ,""                              ,0,comvt_BAD},
   {1,"freeglobals"            ,"FreeGlobals"                   ,2,comvt_BAD},
   {1,"freelibrary"            ,"FreeLibrary"                   ,2,comvt_BAD},
   {1,"friend"                 ,""                              ,1,comvt_BAD},
   {1,"from"                   ,"from"                          ,2,comvt_BAD},
   {1,"funcname$"              ,"__func__$"                     ,2,comvt_BAD},
   {1,"function"               ,""                              ,0,comvt_BAD},
   {1,"fwrite"                 ,"fwrite"                        ,2,comvt_BAD},
   {1,"gcl_hbrbackground"      ,"GCLP_HBRBACKGROUND"            ,2,comvt_BAD},
   {1,"gcl_hcursor"            ,"GCLP_HCURSOR"                  ,2,comvt_BAD},
   {1,"gcl_hicon"              ,"GCLP_HICON"                    ,2,comvt_BAD},
   {1,"gcl_hiconsm"            ,"GCLP_HICONSM"                  ,2,comvt_BAD},
   {1,"gcl_hmodule"            ,"GCLP_HMODULE"                  ,2,comvt_BAD},
   {1,"gcl_menuname"           ,"GCLP_MENUNAME"                 ,2,comvt_BAD},
   {1,"gcl_wndproc"            ,"GCLP_WNDPROC"                  ,2,comvt_BAD},
   {1,"get$"                   ,"~get"                          ,2,comvt_BAD},
   {1,"getattr"                ,""                              ,0,comvt_BAD},
   {1,"getbmp"                 ,""                              ,0,comvt_BAD},
   {1,"getbvalue"              ,"GetBValue"                     ,2,comvt_BAD},
   {1,"getc"                   ,"getc"                          ,2,comvt_BAD},
   {1,"getch"                  ,"_getch"                        ,2,comvt_BAD},
   {1,"getdimension"           ,""                              ,0,comvt_BAD},
   {1,"getdrive"               ,""                              ,0,comvt_BAD},
   {1,"getfilename$"           ,""                              ,0,comvt_BAD},
   {1,"getgvalue"              ,"GetGValue"                     ,2,comvt_BAD},
   {1,"getobject"              ,""                              ,0,comvt_BAD},
   {1,"getprocaddress"         ,""                              ,0,comvt_BAD},
   {1,"getresource"            ,""                              ,0,comvt_BAD},
   {1,"getrvalue"              ,"GetRValue"                     ,2,comvt_BAD},
   {1,"getspecialfolder"       ,""                              ,0,comvt_BAD},
   {1,"getspecialfolder$"      ,""                              ,0,comvt_BAD},
   {1,"getspecialfolderex$"    ,""                              ,0,comvt_BAD},
   {1,"gettextsize"            ,""                              ,0,comvt_BAD},
   {1,"getwindowlong"          ,"GetWindowLongPtr"              ,2,comvt_BAD},
   {1,"global"                 ,"global"                        ,2,comvt_BAD},
   {1,"gosub"                  ,"gosub"                         ,2,comvt_BAD},
   {1,"goto"                   ,"goto"                          ,2,comvt_BAD},
   {1,"gui"                    ,"gui"                           ,2,comvt_BAD},
   {1,"gwl_hinstance"          ,"GWLP_HINSTANCE"                ,2,comvt_BAD},
   {1,"gwl_hwndparent"         ,"GWLP_HWNDPARENT"               ,2,comvt_BAD},
   {1,"gwl_id"                 ,"GWLP_ID"                       ,2,comvt_BAD},
   {1,"gwl_userdata"           ,"GWLP_USERDATA"                 ,2,comvt_BAD},
   {1,"gwl_wndproc"            ,"GWLP_WNDPROC"                  ,2,comvt_BAD},
   {1,"hex$"                   ,""                              ,0,comvt_BAD},
   {1,"hex2dec"                ,""                              ,0,comvt_I4 },
   {1,"hibyte"                 ,"HIBYTE"                        ,2,comvt_BAD},
   {1,"hide"                   ,""                              ,0,comvt_BAD},
   {1,"hiword"                 ,"HIWORD"                        ,2,comvt_BAD},
   {1,"hypot"                  ,"hypot"                         ,2,comvt_R8 },
   {1,"hypotl"                 ,"hypotl"                        ,2,comvt_R8 },
   {1,"iabs"                   ,"abs"                           ,2,comvt_BAD},
   {1,"icompare"               ,""                              ,0,comvt_BAD},
   {1,"icon"                   ,"icon"                          ,2,comvt_BAD},
   {1,"if"                     ,"if"                            ,16,comvt_BAD},
   {1,"iif"                    ,""                              ,0,comvt_R8 },
   {1,"iif$"                   ,""                              ,0,comvt_BAD},
   {1,"imod"                   ,""                              ,0,comvt_BAD},
   {1,"impfunction"            ,"impfunction"                   ,3,comvt_BAD},
   {1,"in"                     ,"in"                            ,0,comvt_BAD},
   {1,"inchr"                  ,""                              ,0,comvt_R4 },
   {1,"incr"                   ,"incr"                          ,2,comvt_BAD},
   {1,"infobox"                ,""                              ,0,comvt_BAD},
   {1,"initsafearray"          ,"InitSafeArray"                 ,0,comvt_BAD},
   {1,"inkey"                  ,""                              ,0,comvt_BAD},
   {1,"inkey$"                 ,""                              ,0,comvt_BAD},
   {1,"inline"                 ,""                              ,1,comvt_BAD},
   {1,"inp"                    ,""                              ,0,comvt_BAD},
   {1,"input"                  ,""                              ,0,comvt_BAD},
   {1,"inputbox$"              ,""                              ,0,comvt_BAD},
   {1,"inputbuffer$"           ,"InputBuffer$"                  ,0,comvt_BAD},
   {1,"ins$"                   ,""                              ,0,comvt_BAD},
   {1,"instat"                 ,"_kbhit()"                      ,2,comvt_BAD},
   {1,"instr"                  ,""                              ,0,comvt_R4 },
   {1,"instrrev"               ,""                              ,0,comvt_R4 },
   {1,"int"                    ,"int"                           ,2,comvt_BAD},
   {1,"integer"                ,"int"                           ,2,comvt_BAD},
   {1,"iremove"                ,""                              ,16,comvt_BAD},
   {1,"iremove$"               ,""                              ,0,comvt_BAD},
   {1,"ireplace"               ,""                              ,16,comvt_BAD},
   {1,"ireplace$"              ,""                              ,0,comvt_BAD},
   {1,"is"                     ,"is"                            ,2,comvt_BAD},
   {1,"isobject"               ,"ISOBJECT"                      ,2,comvt_BAD},
   {1,"isodate"                ,""                              ,0,comvt_BAD},
   {1,"isptr"                  ,""                              ,0,comvt_BAD},
   {1,"ispunct"                ,"ispunct"                       ,2,comvt_BAD},
   {1,"iswxdigit"              ,"_iswxdigit"                    ,2,comvt_BAD},
   {1,"iterate"                ,"continue"                      ,2,comvt_BAD},
   {1,"join$"                  ,""                              ,0,comvt_BAD},
   {1,"keypress"               ,""                              ,0,comvt_BAD},
   {1,"kill"                   ,"kill"                          ,2,comvt_BAD},
   {1,"labs"                   ,"labs"                          ,2,comvt_BAD},
   {3,"lcase$"                 ,""                              ,0,comvt_BAD},
   {1,"lccpath$"               ,""                              ,0,comvt_BAD},
   {1,"ldouble"                ,""                              ,0,comvt_BAD},
   {1,"left$"                  ,""                              ,0,comvt_BAD},
   {1,"leftstr"                ,""                              ,0,comvt_BAD},
   {1,"len"                    ,"(int)strlen"                   ,2,comvt_R4 },
   {1,"lf$"                    ,""                              ,0,comvt_BAD},
   {1,"lib"                    ,"lib"                           ,2,comvt_BAD},
   {1,"libmain"                ,"dllmain"                       ,2,comvt_BAD},
   {1,"like"                   ,""                              ,0,comvt_BAD},
   {1,"line"                   ,""                              ,0,comvt_BAD},
   {1,"listboxloadfile"        ,""                              ,0,comvt_BAD},
   {1,"llabs"                  ,"llabs"                         ,2,comvt_BAD},
   {1,"load_dll"               ,"LoadLibrary"                   ,2,comvt_BAD},
   {1,"loadfile$"              ,""                              ,0,comvt_BAD},
   {1,"loadlibrary"            ,"LoadLibrary"                   ,2,comvt_BAD},
   {1,"lobyte"                 ,"LOBYTE"                        ,2,comvt_BAD},
   {1,"loc"                    ,""                              ,0,comvt_BAD},
   {1,"local"                  ,""                              ,0,comvt_BAD},
   {1,"locate"                 ,""                              ,0,comvt_BAD},
   {1,"lof"                    ,""                              ,0,comvt_R8 },
   {1,"log"                    ,"log"                           ,2,comvt_R8 },
   {1,"log10"                  ,"log10"                         ,2,comvt_R8 },
   {1,"log10l"                 ,"log10l"                        ,2,comvt_BAD},
   {1,"logl"                   ,"logl"                          ,2,comvt_BAD},
   {1,"long"                   ,"long"                          ,2,comvt_BAD},
   {1,"longest"                ,""                              ,0,comvt_BAD},
   {1,"longlong"               ,"LONGLONG"                      ,2,comvt_BAD},
   {1,"loop"                   ,"loop"                          ,2,comvt_BAD},
   {1,"loword"                 ,"LOWORD"                        ,2,comvt_BAD},
   {1,"lpad$"                  ,""                              ,0,comvt_BAD},
   {1,"lpbyte"                 ,"LPBYTE"                        ,2,comvt_BAD},
   {1,"lprint"                 ,""                              ,0,comvt_BAD},
   {1,"lpstr"                  ,"LPSTR"                         ,2,comvt_BAD},
   {1,"ltrim$"                 ,""                              ,0,comvt_BAD},
   {1,"macro"                  ,"const"                         ,2,comvt_BAD},
   {1,"main"                   ,"main"                          ,2,comvt_BAD},
   {1,"makeintresource"        ,"MAKEINTRESOURCE"               ,2,comvt_BAD},
   {1,"makelong"               ,"MAKELONG"                      ,2,comvt_BAD},
   {1,"makeword"               ,"MAKEWORD"                      ,2,comvt_BAD},
   {1,"max"                    ,""                              ,0,comvt_R8 },
   {3,"mcase$"                 ,""                              ,0,comvt_BAD},
   {1,"mdigui"                 ,"mdigui"                        ,2,comvt_BAD},
   {1,"me"                     ,""                              ,0,comvt_BAD},
   {1,"memicmp"                ,"_memicmp"                      ,2,comvt_BAD},
   {1,"memsize"                ,"_msize"                        ,0,comvt_BAD},
   {1,"mid$"                   ,""                              ,0,comvt_BAD},
   {1,"min"                    ,""                              ,0,comvt_R8 },
   {1,"mkd$"                   ,""                              ,0,comvt_BAD},
   {1,"mkdir"                  ,"_mkdir"                        ,2,comvt_BAD},
   {1,"mki$"                   ,""                              ,0,comvt_BAD},
   {1,"mkl$"                   ,""                              ,0,comvt_BAD},
   {1,"mkld$"                  ,""                              ,0,comvt_BAD},
   {1,"mks$"                   ,""                              ,0,comvt_BAD},
   {1,"mod"                    ,"fmod"                          ,2,comvt_BAD},
   {1,"modstyle"               ,""                              ,0,comvt_BAD},
   {1,"msgbox"                 ,""                              ,0,comvt_BAD},
   {1,"name"                   ,"name"                          ,2,comvt_BAD},
   {1,"namespace"              ,"namespace"                     ,3,comvt_BAD},
   {1,"nest"                   ,"nest"                          ,2,comvt_BAD},
   {1,"new"                    ,""                              ,1,comvt_BAD},
   {1,"next"                   ,"next"                          ,34,comvt_BAD},
   {1,"nextlinelen"            ,""                              ,0,comvt_BAD},
   {1,"nosort"                 ,"WS_CHILD|WS_VISIBLE|WS_VSCROLL",2,comvt_BAD},
   {1,"not"                    ,""                              ,0,comvt_BAD},
   {1,"notequalto"             ,""                              ,0,comvt_BAD},
   {1,"nothing"                ,""                              ,0,comvt_BAD},
   {1,"now$"                   ,""                              ,0,comvt_BAD},
   {1,"nul$"                   ,""                              ,0,comvt_BAD},
   {1,"null"                   ,"NULL"                          ,2,comvt_BAD},
   {1,"object"                 ,""                              ,0,comvt_BAD},
   {1,"oct$"                   ,""                              ,0,comvt_BAD},
   {1,"on"                     ,"on"                            ,0,comvt_BAD},
   {1,"open"                   ,""                              ,0,comvt_BAD},
   {1,"operator"               ,"operator"                      ,3,comvt_BAD},
   {1,"option"                 ,"option"                        ,2,comvt_BAD},
   {1,"optional"               ,"optional"                      ,2,comvt_BAD},
   {1,"or"                     ,""                              ,0,comvt_BAD},
   {1,"orelse"                 ,""                              ,0,comvt_BAD},
   {1,"osversion"              ,""                              ,0,comvt_BAD},
   {1,"outp"                   ,""                              ,0,comvt_BAD},
   {1,"output"                 ,""                              ,0,comvt_BAD},
   {1,"outpw"                  ,""                              ,0,comvt_BAD},
   {1,"overloaded"             ,""                              ,0,comvt_BAD},
   {1,"panel"                  ,""                              ,0,comvt_BAD},
   {1,"pause"                  ,""                              ,0,comvt_BAD},
   {1,"pchar"                  ,"PCHAR"                         ,2,comvt_BAD},
   {1,"peek$"                  ,""                              ,0,comvt_BAD},
   {1,"pellespath$"            ,""                              ,0,comvt_BAD},
   {1,"pixels"                 ,"pixels"                        ,2,comvt_BAD},
   {1,"playwav"                ,""                              ,0,comvt_BAD},
   {1,"poke"                   ,"memmove"                       ,2,comvt_BAD},
   {1,"popcolors"              ,""                              ,0,comvt_BAD},
   {1,"pos"                    ,""                              ,0,comvt_R4 },
   {1,"pow"                    ,"pow"                           ,2,comvt_R8 },
   {1,"powl"                   ,"powl"                          ,2,comvt_BAD},
   {1,"pptype"                 ,"pptype"                        ,2,comvt_BAD},
   {1,"prepend"                ,"prepend"                       ,2,comvt_BAD},
   {1,"preserve"               ,"PRESERVE"                      ,2,comvt_BAD},
   {1,"print"                  ,""                              ,0,comvt_BAD},
   {1,"print#"                 ,"fprint"                        ,2,comvt_BAD},
   {1,"printer"                ,""                              ,0,comvt_BAD},
   {1,"private"                ,""                              ,1,comvt_BAD},
   {1,"program"                ,"program"                       ,2,comvt_BAD},
   {1,"property"               ,"property"                      ,3,comvt_BAD},
   {1,"protected"              ,""                              ,1,comvt_BAD},
   {1,"ptr"                    ,""                              ,0,comvt_BAD},
   {1,"public"                 ,""                              ,1,comvt_BAD},
   {1,"pushcolors"             ,""                              ,0,comvt_BAD},
   {1,"put$"                   ,"~put"                          ,2,comvt_BAD},
   {1,"qbcolor"                ,""                              ,0,comvt_BAD},
   {1,"qsort"                  ,"qsort"                         ,2,comvt_BAD},
   {1,"qsortidx"               ,"qsortidx"                      ,2,comvt_BAD},
   {1,"randomize"              ,""                              ,0,comvt_BAD},
   {1,"raw"                    ,"raw"                           ,2,comvt_BAD},
   {1,"read"                   ,""                              ,0,comvt_BAD},
   {1,"read$"                  ,""                              ,0,comvt_BAD},
   {1,"rec"                    ,""                              ,0,comvt_BAD},
   {1,"reccount"               ,""                              ,0,comvt_BAD},
   {1,"reclen"                 ,"reclen"                        ,2,comvt_BAD},
   {1,"record"                 ,"record"                        ,2,comvt_BAD},
   {1,"redim"                  ,"redim"                         ,2,comvt_BAD},
   {1,"refresh"                ,""                              ,0,comvt_BAD},
   {1,"regexist"               ,""                              ,0,comvt_BAD},
   {1,"regint"                 ,""                              ,0,comvt_BAD},
   {1,"register"               ,"register"                      ,2,comvt_BAD},
   {1,"regstring$"             ,""                              ,0,comvt_BAD},
   {1,"reinterpret_cast"       ,"reinterpret_cast"              ,3,comvt_BAD},
   {1,"release"                ,""                              ,0,comvt_BAD},
   {1,"rem"                    ,"rem"                           ,0,comvt_BAD},
   {1,"remain$"                ,""                              ,0,comvt_BAD},
   {1,"remove"                 ,"remove"                        ,18,comvt_BAD},
   {1,"remove$"                ,""                              ,0,comvt_BAD},
   {1,"rename"                 ,"rename"                        ,2,comvt_BAD},
   {1,"repeat"                 ,"repeat"                        ,0,comvt_BAD},
   {1,"repeat$"                ,""                              ,0,comvt_BAD},
   {1,"replace"                ,"replace"                       ,18,comvt_BAD},
   {1,"replace$"               ,""                              ,0,comvt_BAD},
   {1,"resume"                 ,""                              ,0,comvt_BAD},
   {1,"retain$"                ,""                              ,0,comvt_BAD},
   {1,"return"                 ,"return"                        ,2,comvt_BAD},
   {1,"reverse$"               ,""                              ,0,comvt_BAD},
   {1,"rewind"                 ,""                              ,0,comvt_BAD},
   {1,"rgb"                    ,"RGB"                           ,2,comvt_BAD},
   {1,"right$"                 ,""                              ,0,comvt_BAD},
   {1,"rightstr"               ,""                              ,0,comvt_BAD},
   {1,"rmdir"                  ,"_rmdir"                         ,2,comvt_BAD},
   {1,"rnd"                    ,""                              ,0,comvt_R4 },
   {1,"round"                  ,""                              ,0,comvt_R8 },
   {1,"rpad$"                  ,""                              ,0,comvt_BAD},
   {1,"rtrim$"                 ,""                              ,0,comvt_BAD},
   {1,"run"                    ,""                              ,0,comvt_BAD},
   {1,"savebmp"                ,""                              ,0,comvt_BAD},
   {1,"scanerror"              ,"ScanError"                     ,2,comvt_BAD},   ' For access to input Error Code
   {1,"screen"                 ,""                              ,0,comvt_BAD},
   {1,"searchpath$"            ,""                              ,0,comvt_BAD},
   {1,"seek"                   ,"seek"                          ,2,comvt_BAD},
   {1,"select"                 ,"select"                        ,2,comvt_BAD},
   {1,"sendmessage"            ,""                              ,0,comvt_BAD},
   {1,"set"                    ,""                              ,0,comvt_BAD},
   {1,"set_bcx_bitmap"         ,""                              ,0,comvt_BAD},
   {1,"set_bcx_bitmap2"        ,""                              ,0,comvt_BAD},
   {1,"set_bcx_bmpbutton"      ,""                              ,0,comvt_BAD},
   {1,"set_bcx_icon"           ,""                              ,0,comvt_BAD},
   {1,"setattr"                ,""                              ,0,comvt_BAD},
   {1,"setdimension"           ,""                              ,0,comvt_BAD},
   {1,"seteof"                 ,"SetEof"                        ,2,comvt_BAD},
   {1,"setmode"                ,"_setmode"                      ,2,comvt_BAD},
   {1,"setwindowlong"          ,"SetWindowLongPtr"              ,2,comvt_BAD},
   {1,"setwindowrtftext"       ,""                              ,0,comvt_BAD},
   {1,"sgn"                    ,""                              ,0,comvt_R4 },
   {1,"shared"                 ,"shared"                        ,2,comvt_BAD},
   {1,"shell"                  ,"shell"                         ,2,comvt_BAD},
   {1,"shl"                    ,""                              ,0,comvt_BAD},
   {1,"short"                  ,"short"                         ,2,comvt_BAD},
   {1,"show"                   ,""                              ,0,comvt_BAD},
   {1,"showmodal"              ,""                              ,0,comvt_BAD},
   {1,"shr"                    ,""                              ,0,comvt_BAD},
   {1,"sin"                    ,"sin"                           ,2,comvt_R8 },
   {1,"single"                 ,"float"                         ,2,comvt_BAD},
   {1,"sinh"                   ,"sinh"                          ,2,comvt_R8 },
   {1,"sinl"                   ,"sinl"                          ,2,comvt_BAD},
   {1,"size_t"                 ,"size_t"                        ,2,comvt_R4 },
   {1,"sizeof"                 ,"sizeof"                        ,2,comvt_R4 },
   {1,"sleep"                  ,""                              ,0,comvt_BAD},
   {1,"sndmsg"                 ,""                              ,0,comvt_BAD},
   {1,"sound"                  ,""                              ,0,comvt_BAD},
   {1,"space$"                 ,""                              ,0,comvt_BAD},
   {1,"spc$"                   ,""                              ,0,comvt_BAD},
   {1,"split"                  ,""                              ,0,comvt_BAD},
   {1,"splitbarbg"             ,"SplitBarBG"                    ,2,comvt_BAD},
   {1,"splitbarfg"             ,"SplitBarFG"                    ,2,comvt_BAD},
   {1,"sprint"                 ,"sprint"                        ,2,comvt_BAD},
   {1,"sqr"                    ,"sqrt"                          ,2,comvt_R8 },
   {1,"sqrl"                   ,"sqrtl"                         ,2,comvt_BAD},
   {1,"sqrt"                   ,"sqrt"                          ,2,comvt_R8 },
   {1,"sqrtl"                  ,"sqrtl"                         ,2,comvt_BAD},
   {1,"startdraw"              ,""                              ,0,comvt_BAD},
   {1,"static"                 ,"static"                        ,2,comvt_BAD},
   {1,"static_cast"            ,"static_cast"                   ,3,comvt_BAD},
   {1,"stdcall"                ,""                              ,0,comvt_BAD},
   {1,"step"                   ,""                              ,0,comvt_BAD},
   {1,"str$"                   ,""                              ,0,comvt_BAD},
   {1,"str2variant"            ,""                              ,0,comvt_BAD},
   {1,"strarray"               ,"LPSTR*"                        ,2,comvt_BAD},
   {1,"strim$"                 ,""                              ,0,comvt_BAD},
   {1,"string"                 ,"string"                        ,2,comvt_BAD},
   {1,"string$"                ,""                              ,0,comvt_BAD},
   {1,"strl$"                  ,""                              ,0,comvt_BAD},
   {1,"strptr"                 ,""                              ,0,comvt_BAD},
   {1,"strtoken$"              ,""                              ,0,comvt_BAD},
   {1,"struct"                 ,"struct"                        ,0,comvt_BAD},
   {1,"sub"                    ,"sub"                           ,0,comvt_BAD},
   {1,"swap"                   ,""                              ,0,comvt_BAD},
   {1,"sysdir$"                ,""                              ,0,comvt_BAD},
   {1,"sysstr"                 ,""                              ,0,comvt_BAD},
   {1,"tab$"                   ,""                              ,0,comvt_BAD},
   {1,"tally"                  ,""                              ,0,comvt_R4 },
   {1,"tan"                    ,"tan"                           ,2,comvt_R8 },
   {1,"tanh"                   ,"tanh"                          ,2,comvt_R8 },
   {1,"tanl"                   ,"tanl"                          ,2,comvt_BAD},
   {1,"tempdir$"               ,""                              ,0,comvt_BAD},
   {1,"tempfilename$"          ,""                              ,0,comvt_BAD},
   {1,"template"               ,"template"                      ,2,comvt_BAD},
   {1,"textmode"               ,""                              ,0,comvt_BAD},
   {1,"then"                   ,""                              ,0,comvt_BAD},
   {1,"this"                   ,"this"                          ,3,comvt_BAD},
   {1,"throw"                  ,"throw"                         ,3,comvt_BAD},
   {1,"time$"                  ,""                              ,0,comvt_BAD},
   {1,"timer"                  ,""                              ,0,comvt_R4 },
   {1,"to"                     ,"to"                            ,0,comvt_BAD},
   {1,"trim$"                  ,""                              ,0,comvt_BAD},
   {1,"true"                   ,""                              ,0,comvt_BAD},
   {1,"try"                    ,"try"                           ,3,comvt_BAD},
   {1,"type"                   ,"type"                          ,2,comvt_BAD},
   {1,"typeid"                 ,"typeid$"                       ,3,comvt_BAD},
   {1,"typename"               ,""                              ,1,comvt_BAD},
   {1,"ubound"                 ,""                              ,0,comvt_BAD},
   {3,"ucase$"                 ,""                              ,0,comvt_BAD},
   {1,"uint"                   ,"UINT"                          ,2,comvt_BAD},
   {1,"ulong"                  ,"ULONG"                         ,2,comvt_BAD},
   {1,"ulonglong"              ,"ULONGLONG"                     ,2,comvt_BAD},
   {1,"uncom"                  ,"UNCOM"                         ,0,comvt_BAD},
   {1,"union"                  ,"union"                         ,2,comvt_BAD},
   {1,"until"                  ,""                              ,0,comvt_BAD},
   {1,"unwrap$"                ,""                              ,0,comvt_BAD},
   {1,"ushort"                 ,"USHORT"                        ,2,comvt_BAD},
   {1,"using"                  ,"using"                         ,3,comvt_BAD},
   {1,"using$"                 ,""                              ,0,comvt_BAD},
   {1,"val"                    ,""                              ,0,comvt_R8 },
   {1,"vall"                   ,""                              ,0,comvt_BAD},
   {1,"variant"                ,"VARIANT"                       ,2,comvt_BAD},
   {1,"variant2str"            ,""                              ,0,comvt_BAD},
   {1,"vbs_addcode"            ,""                              ,0,comvt_BAD},
   {1,"vbs_error$"             ,""                              ,0,comvt_BAD},
   {1,"vbs_eval_num"           ,""                              ,0,comvt_BAD},
   {1,"vbs_eval_num#"          ,""                              ,0,comvt_BAD},
   {1,"vbs_eval_str$"          ,""                              ,0,comvt_BAD},
   {1,"vbs_reset"              ,""                              ,0,comvt_BAD},
   {1,"vbs_run_script"         ,""                              ,0,comvt_BAD},
   {1,"vbs_start"              ,""                              ,0,comvt_BAD},
   {1,"vbs_stop"               ,""                              ,0,comvt_BAD},
   {1,"vchr$"                  ,""                              ,0,comvt_BAD},
   {1,"vector"                 ,""                              ,0,comvt_BAD},
   {1,"verify"                 ,""                              ,0,comvt_BAD},
   {1,"virtual"                ,""                              ,1,comvt_BAD},
   {1,"vt$"                    ,""                              ,0,comvt_BAD},
   {1,"wend"                   ,"wend"                          ,2,comvt_BAD},
   {1,"while"                  ,""                              ,0,comvt_BAD},
   {1,"widetoansi$"            ,""                              ,0,comvt_BAD},
   {1,"winbool"                ,"winbool"                       ,2,comvt_BAD},
   {1,"windir$"                ,""                              ,0,comvt_BAD},
   {1,"winmain"                ,""                              ,0,comvt_BAD},
   {1,"with"                   ,""                              ,0,comvt_BAD},
   {1,"wndproc"                ,""                              ,0,comvt_BAD},
   {1,"word"                   ,"WORD"                          ,2,comvt_BAD},
   {1,"wrap$"                  ,""                              ,0,comvt_BAD},
   {1,"write"                  ,"write"                         ,2,comvt_BAD},
   {3,"xor"                    ,""                              ,0,comvt_BAD},
   {1,"zzzz"                   ,"zzzz"                          ,0,comvt_BAD}
END SET

'*************************************************************************
'                              CODE BEGINS
'*************************************************************************

MACRO cMaxSrcLen = 0x100000    ' = 1 megabyte

FUNCTION MAIN(ARGC AS INT, ARGV AS PCHAR PTR)
   GLOBAL CurLine$  * cMaxSrcLen
   GLOBAL GTmpStr$  * cMaxSrcLen
   GLOBAL Src$      * cMaxSrcLen
   GLOBAL AbortSrc$ * cMaxSrcLen
   GLOBAL WarnMsg$  * 32767
   GLOBAL RmLibs$   * 32767  ' List of libraries to remove
   GLOBAL Version$
   GLOBAL Copyright$
   GLOBAL IF_Stmt_Buffer$ * cMaxSrcLen   '  "??" support
   '*******************************************************
   Version$ = VERSION$ + SPC$ + ENC$(ISODATE$,40,41)
   REPLACE "-" WITH "/" IN Version$
   '*******************************************************
   Copyright$ = "BCX BASIC to C/C++ Translator (c) 1999-" + RIGHT$(DATE$,4) + " by Kevin Diggins"
   '*******************************************************
   CALL InitReservedWordsLookup
   '*******************************************************
   DebugModeOff           =  TRUE
   '*******************************************************
   CmdLineConst$          =  ""
   CmdLineFileOut$        =  ""
   ExitNdx                =  0
   Gen_Header             =  FALSE
   HFile$                 =  ""
   InMain                 =  TRUE
   InNameSpace            =  0
   InsertComments         =  FALSE
   NoRT                   =  FALSE
   OkayToSend             =  TRUE
   OptimizerEnabled       =  TRUE
   OptimizerFirstSetting  =  TRUE
   Project_List$          =  ""
   Project_Main$          =  ""
   ProtoCnt               =  0        ' Prototypes counter
   Quiet                  =  FALSE
   StartNdx               =  0
   TestState              =  FALSE
   TranslateSlash         =  TRUE     ' Change "\" to "\\"
   Use_ExitCode           =  FALSE
   Use_LeanAndMean        =  FALSE
   Use_Project            =  FALSE
   Use_SingleFile         =  TRUE
   Use_StartupCode        =  FALSE
   WinHeaders             =  TRUE     ' Include Win specific headers (*.h)
   '**************************************************************************
   '                            Some Helper strings
   '**************************************************************************
   GLOBAL BKSLASH1$  :  BKSLASH1$ = CHR$(92)                      ' \
   GLOBAL BKSLASH2$  :  BKSLASH2$ = CHR$(92,92)                   ' \\
   GLOBAL BKSLASH4$  :  BKSLASH4$ = CHR$(92,92,92,92)             ' \\\\
   GLOBAL QUOTQUOT$  :  QUOTQUOT$ = CHR$(34,34,34)                ' """
   GLOBAL GFORMAT$   :  GFORMAT$  = VCHR$(6,34,37,115,37,115,34)  '  "%s%s"
   '**************************************************************************
   PPFlag = FALSE           ' Initialize User-Defined PreProcessor
   PPProc = NULL
   PPDLL_HANDLE = NULL
   '**************************************************************************
   IF INSTR(COMMAND$,"-v") OR INSTR(COMMAND$,"-V") THEN
      PRINT : PRINT Copyright$
      CALL Display_Version_and_Compiler
      END
   END IF
   '**************************************************************************
   '      Checks whether Bc.exe was started in Explorer or File Manager.
   '**************************************************************************
   IF CURSORX = 1 AND CURSORY = 1 AND ISNULL(COMMAND$) THEN
      HIDE (CONWIN)
      Copyright$ = Copyright$ + CRLF$ + CRLF$ + CPAD$("Version " + VERSION$, 90)
      MSGBOX (Copyright$ + CRLF$ + CRLF$ + SPACE$(12) + LTRIM$(Compiler_Used$()))
      END
   END IF
   '**************************************************************************
   IF ISNULL(COMMAND$) THEN
      PRINT : PRINT Copyright$
      CALL  Display_Version_and_Compiler
      PRINT
      PRINT " Usage: BC infile [.bas] [options]"
      PRINT " [-b]   Build using user-defined bat file .. ex -b:c:\\bat\\pw.bat"
      PRINT " [-cpp] Generate C++ compatible code with .cpp extension"
      PRINT " [-d]   DEFINE a constant ... ex. BC MyFile -D:MyConst[=SomeValue]"
      PRINT " [-e]   Write ERRORS to BCX.ERR file"
      PRINT " [-f]   Output FILENAME... ex. BC MyFile -f:C:\\MyFiles\\MyFile.c"
      PRINT " [-i]   Send Warnings and Errors to INFOBOX"
      PRINT " [-k]   KILL the generated BCX generated 'C' file"
      PRINT " [-m]   Enable eMbedded BCX code in the C translation"
      PRINT " [-n]   Enable NO RUNTIME Code Generation"
      PRINT " [-o]   OUTPUT a copy of the generated C file to STDOUT"
      PRINT " [-q]   QUIET - No output to screen during translation"
      PRINT " [-r]   Update BCX Path variable in the Windows REGISTRY"
      PRINT " [-s]   Show STATUS of translation by line number"
      PRINT " [-u]   Turn UNICODE Support ON"
      PRINT " [-v]   Show BCX version and build information"
      PRINT " [-w]   Enable BCX WARNINGS during translation and all compiler warnings."
      PRINT " [-x]   EXCLUDE Win32 Headers from the resulting C file"
      PRINT " [-z]   ZAP (remove DEFAULT headers and libraries from the resulting C file"

      CALL FREEGLOBALS
      END                '     <<<- Nothing to translate, so we END
   END IF
   '****************************************************************************************************
   IF COMMAND$ ?? "-r" THEN
      CREATEREGSTRING (HKEY_LOCAL_MACHINE, "Software\\Bcx-32\\Bcx\\Settings", "Path", APPEXEPATH$)
      CREATEREGSTRING (HKEY_CURRENT_USER,  "Software\\Bcx-32\\Bcx\\Settings", "Path", APPEXEPATH$)
      PRINT "      BCX Path set to ", BCXPATH$
      END
   END IF
   '****************************************************************************************************
   '                       Detect and setup any other command line switches
   '****************************************************************************************************

   FOR INT i = 2 TO ARGC-1
      GTmpStr$ = LCASE$(ARGV$[i])

      IF INSTR(GTmpStr$, "-b") THEN
         IF cMaxOnExit = XitCount THEN
            CALL Abort("Maximum $OnExit exceeded.")
         END IF
         INCR XitCount
         Xit$[XitCount]= MID$(ARGV$[i], 4) + SPC$ + ENC$(EXTRACT$(COMMAND$(1), "."))
      END IF

      IF GTmpStr$ = "-cpp" THEN UseCpp      = TRUE
      IF GTmpStr$ = "-c"   THEN UseCpp      = TRUE
      IF GTmpStr$ = "-e"   THEN ErrFile     = TRUE
      IF GTmpStr$ = "-h"   THEN Gen_Header  = TRUE
      IF GTmpStr$ = "-i"   THEN InfoBoxWarn = TRUE
      IF GTmpStr$ = "-q"   THEN Quiet       = TRUE
      IF GTmpStr$ = "-k"   THEN KillCFile   = TRUE
      IF GTmpStr$ = "-m"   THEN SrcFlag     = TRUE
      IF GTmpStr$ = "-n"   THEN NoRT        = TRUE
      IF GTmpStr$ = "-o"   THEN ReDirect    = TRUE
      IF GTmpStr$ = "-s"   THEN ShowStatus  = TRUE
      IF GTmpStr$ = "-u"   THEN Use_UNICODE = TRUE
      IF GTmpStr$ = "-z"   THEN ZapFlag     = TRUE
      IF GTmpStr$ = "-w"   THEN TestState   = TRUE : WarningFlag = TRUE
      IF GTmpStr$ = "-x"   THEN WinHeaders  = FALSE

      IF iMatchLft(GTmpStr$, "-f:") THEN CmdLineFileOut$ = MID$(ARGV$[i], 4)
      IF iMatchLft(GTmpStr$, "-d:") THEN CmdLineConst$ = CmdLineConst$ + MID$(ARGV$[i], 4) + CHR$(1)
   NEXT

   '****************************************************************************
   '                           [ Announce Program ]
   '****************************************************************************

   IF ShowStatus THEN CLS

   IF NOT Quiet THEN
      IF BCX_COLORS THEN PUSHCOLORS
      IF BCX_COLORS THEN COLOR 11,0
      PRINT : PRINT Copyright$
      CALL  Display_Version_and_Compiler
      IF BCX_COLORS THEN POPCOLORS
   END IF

   '****************************************************************************

   IF INCHR(COMMAND$(1),".") THEN
      Cmd$ = COMMAND$(1)                         ' Allow ANY extension
   ELSE
      Cmd$ = EXTRACT$(COMMAND$(1),".") + ".bas"  ' Assume implicit .bas
   END IF

   Cmd$ = FINDFIRST$(Cmd$)                       ' Retain the spelling

   IF INCHR(Cmd$,"*") OR INCHR(Cmd$,"?") THEN Cmd$ = FINDFIRST$(Cmd$)

   FileIn$ = Cmd$

   IF ISNULL(CmdLineFileOut$) THEN
      FileOut$ = LEFT$(Cmd$, INSTRREV(Cmd$,".",0)-1) + ".out"
   ELSE
      FileOut$ = CmdLineFileOut$
   END IF

   FileErr$ = LEFT$(Cmd$, INSTRREV(Cmd$,".",0)-1) + ".err"

   IF EXIST(FileErr$) THEN
      SHELL "DEL " + FileErr$
   END IF

   '*******************************************************

   IF DebugModeOff THEN
      GTmpStr$ = TEMPDIR$
      cppFile$ = TEMPFILENAME$(GTmpStr$,"ccode")
      prcFile$ = TEMPFILENAME$(GTmpStr$,"prc")
      udtFile$ = TEMPFILENAME$(GTmpStr$,"udt")
      datFile$ = TEMPFILENAME$(GTmpStr$,"dat")
      UsrFile$ = TEMPFILENAME$(GTmpStr$,"cst")     ' User's MACRO's
      SysFile$ = TEMPFILENAME$(GTmpStr$,"syscst")  ' System MACRO's
      ovrFile$ = TEMPFILENAME$(GTmpStr$,"ovr")
      hdrFile$ = TEMPFILENAME$(GTmpStr$,"hdr")
      setFile$ = TEMPFILENAME$(GTmpStr$,"set")
      resFile$ = TEMPFILENAME$(GTmpStr$,"res")
      enuFile$ = TEMPFILENAME$(GTmpStr$,"enu")
      defFile$ = TEMPFILENAME$(GTmpStr$,"def")
   ELSE
      GTmpStr$ = APPEXEPATH$
      cppFile$ = GTmpStr$ + "ccode_debug.txt"
      prcFile$ = GTmpStr$ + "prc_debug.txt"
      udtFile$ = GTmpStr$ + "udt_debug.txt"
      datFile$ = GTmpStr$ + "dat_debug.txt"
      UsrFile$ = GTmpStr$ + "cst_debug.txt"
      SysFile$ = GTmpStr$ + "syscst_debug.txt"
      ovrFile$ = GTmpStr$ + "ovr_debug.txt"
      hdrFile$ = GTmpStr$ + "hdr_debug.txt"
      setFile$ = GTmpStr$ + "set_debug.txt"
      resFile$ = GTmpStr$ + "res_debug.txt"
      enuFile$ = GTmpStr$ + "enu_debug.txt"
      defFile$ = GTmpStr$ + "def_debug.txt"
   END IF
   '**************************************************************************
   GLOBAL Building_BCX
   IF LCASE$(FileIn$) = "bc.bas" THEN Building_BCX = TRUE
   '**************************************************************************

   OPEN FileIn$  FOR INPUT  AS SourceFile
   OPEN FileOut$ FOR OUTPUT AS FP2        ' <<<<<<<<   THE FINAL C/C++ FILE

   '**************************************************************************
   Outfile = FP2          ' Outfile = FP3 when in a SUB or FUNCTION
   '**************************************************************************

   OPEN cppFile$ FOR OUTPUT AS FP_CCODE   ' Temp file FOR CCODE
   OPEN SysFile$ FOR OUTPUT AS FP_SYSCST  ' Temp File FOR SYSTEM CONSTs
   OPEN prcFile$ FOR OUTPUT AS FP3        ' Temp File FOR User's Functions
   OPEN udtFile$ FOR OUTPUT AS FP_UDT     ' Temp File FOR User's Def Types
   OPEN datFile$ FOR OUTPUT AS FP_DAT     ' Temp File FOR User's Data statements
   OPEN UsrFile$ FOR OUTPUT AS FP_CST     ' Temp File FOR User's MACRO
   OPEN hdrFile$ FOR OUTPUT AS FP_HDR     ' Temp File FOR User's .h files
   OPEN resFile$ FOR OUTPUT AS FP_RES     ' Temp File FOR User's .rc files
   OPEN enuFile$ FOR OUTPUT AS FP_ENU     ' Temp File FOR User's GLOBAL ENUMs
   OPEN ovrFile$ FOR OUTPUT AS FP_OVR     ' Temp File FOR User's OVERLOADED subs & functions
   OPEN setFile$ FOR OUTPUT AS FP_SET     ' Temp File FOR User's SET Vars
   OPEN defFile$ FOR OUTPUT AS FP_DEF     ' Temp File FOR User's $DEFINE statements

   '*************************************************************************
   CALL ExportStringConst
   FileNdx = 1
   FileNames$[FileNdx] = FileIn$          ' Store the current module filename
   LineNum[FileNdx] = 0
   '**************************************************************************
   IF NoRT = TRUE THEN CALL EnableProject

   CALL BeginMain
   CALL ClearIfThenStacks

   IF UseCpp = TRUE THEN
      DIM RAW iTmp
      Docpp("", &iTmp)         ' Treats -c switch as $CPP directive
   END IF

   '*****************************************************************
   '                          The Main LOOP
   '*****************************************************************
   ReadSrcLine:
   '*****************************************************************
   DO WHILE NOT EOF(SourceFile) OR SplitCnt
      IF SplitCnt = 0 THEN            ' Process separated lines before
         LINE INPUT SourceFile, Src$  ' getting next line from file.
         INCR LineNum[FileNdx]
         '*************************************************************
         Src$ = LTRIM$(Src$)
         IF ISNULL(Src$) THEN ITERATE
         '*************************************************************
         '            Change BASIC remarks to C/C++ remarks
         '*************************************************************
         IF InFunction THEN          ' Only output comments that exist
            IF InsertComments THEN   ' in a Sub, Function, Main/Winmain
               IF *Src$ = c_SglQt THEN
                  FPRINT Outfile, Scoot$, "//",(PCHAR)(Src+1)
                  Src$ = ""
                  ITERATE
               END IF
               IF iMatchLft(Src$,"rem ") THEN
                  FPRINT Outfile, Scoot$, "//",(PCHAR)(Src+3)
                  Src$ = ""
                  ITERATE
               END IF
            END IF
         END IF
         '***************************************************
         CALL StripCode(Src$)                                    ' Remove spaces, tabs, comments
         IF ISNULL(Src$) THEN ITERATE                            ' Skip over blank lines
         IF JoinLines(Src$) THEN ITERATE                         ' Join continuation lines " _"
         IF INCHR(Src$,"[") THEN CALL BracketHandler(Src$,0)     ' Fix Brackets
         '***************************************************    '
         CALL Early_Transforms                                    ' Special Replacement heuristics
         '***************************************************    '
         IF PPFlag THEN                                          ' PreProcess the line  ($PP detected)
            GLOBAL ppret AS LONG
            ppret = (LONG) PPProc(Src$)                          ' Error in $PP returns error message in Src$
            IF ppret = 0 THEN
               CALL Abort(Src$)
            END IF
         END IF
         '***************************************************
         IF ISFALSE MacroCheck() THEN
            IF SplitLines(Src$) THEN                             ' Split statements separated by
               Src$ = LTRIM$(SplitStk$[++SplitCur])              ' colons and single line if/then
            END IF
         END IF
      ELSE
         Src$ = LTRIM$(SplitStk$[++SplitCur])
      END IF

      IF SplitCur = SplitCnt THEN SplitCur = SplitCnt = 0

      '*********************************************************************
      ' After translation, tokens displayed when an error occurs may
      ' not resemble the original tokens that are copied to AbortSrc$.
      '*********************************************************************

      AbortSrc$ = Src$

      '*********************************************************************
      ' No testing on inline c
      ' If you're using inline c then you should know what you are doing
      '*********************************************************************
      IF *Src = ASC("!") THEN   'Test for inline C
         IF InFunction OR InClass OR InNameSpace OR InTypeDef THEN
            FPRINT Outfile, MID$(Src$,2)
         ELSE
            IF InMain THEN
               FPRINT FP2, MID$(Src$,2)
            ELSE
               FPRINT FP_CST, MID$(Src$,2)
            END IF
         END IF
         ITERATE
      END IF

      CALL CheckParQuotes

      IF (TraceFlag AND InFunction) OR (SrcFlag) OR (ShowStatus) THEN
         CALL ActivityFlags
      END IF

      IF ISNULL(Src$) THEN ITERATE

      '**************************************************************
      CALL Translate(Src$)     '       Okay, let's translate!
      '**************************************************************
   LOOP

   FLUSH (Outfile)            '*************************************
   IF FPtrNdx THEN            '  Pop out the $Include File Handles
      CALL PopFileIO          '  and close them in sequence until
      GOTO ReadSrcLine        '  we end up back in the main file
   END IF                     '*************************************

   '****************************************************************
   '        END OF MAIN LOOP -- All Source code has been read
   '****************************************************************
   '        Everything below must not process more than once
   '****************************************************************

   CALL EmitCompilerDefines

   IF FirstTime(TestForBcxIni) THEN
      TestForBcxIni = TRUE
      szFile$ = CURDIR$ + "\\bcx.ini"

      IF NOT EXIST(szFile$) THEN
         szFile$ = APPEXEPATH$ + "bcx.ini"
      END IF

      IF EXIST(szFile$) THEN
         CALL PushFileIO
         OPEN szFile$ FOR INPUT AS SourceFile

         IF FileNdx = MAXFILES-1 THEN
            CALL Abort("Maximum Include Files exceeded.")
         END IF

         FileNames$[++FileNdx] = szFile$
         LineNum[FileNdx] = 0
         GOTO ReadSrcLine
      END IF
   END IF

   '***************************************************************
   '      Check for unbalanced LOOPS and IF-THEN errors
   '***************************************************************

   IF LoopTypeCnt THEN
      CALL LoopErrorMsg
   END IF

   IF Indent THEN
      CALL Abort("Possible missing END IF before END of program")
   END IF

   '***************************************************************

   IF Use_VBS THEN
      CALL Emit_VBSCRIPT_Support     ' Writes to FP_HDR
   END IF

   IF ZapFlag = FALSE THEN
      IF Use_Project = FALSE THEN
         DIM STATIC Pass_1
         IF FirstTime(Pass_1) THEN
            INCR Pass_1
            AddLibrary("kernel32.lib")
            AddLibrary("user32.lib")
            AddLibrary("gdi32.lib")
            AddLibrary("comctl32.lib")
            AddLibrary("advapi32.lib")
            AddLibrary("winspool.lib")
            AddLibrary("shell32.lib")
            AddLibrary("ole32.lib")
            AddLibrary("oleaut32.lib")
            AddLibrary("uuid.lib")
            AddLibrary("odbc32.lib")
            AddLibrary("odbccp32.lib")
            AddLibrary("winmm.lib")
            AddLibrary("comdlg32.lib")
            AddLibrary("imagehlp.lib")
            AddLibrary("version.lib")
            AddLibrary("wininet.lib")
            AddLibrary("urlmon.lib")
         END IF
      END IF ' Use_Project = FALSE
   END IF 'ZapFlag

   '***************************************************************
   IF Use_GenFree AND GlobalDynaCnt THEN
      CALL MakeFreeGlobals                 ' Writes to Outfile
   END IF

   CALL EmitLibs                          ' Writes to FP_HDR
   CALL ExportInternalConst               ' Writes to FP_CST
   CALL EmitEpilog                        ' Writes to Outfile
   CALL CloseAll                          ' Close all files
   CALL AssembleParts                     ' Build final C/C++
   CALL CreateUserResourceFile            ' Build User's .RC file

   '***************************************************************
   IF ShowStatus THEN CLS
   '***************************************************************

   IF NOT Quiet THEN

      INCR LinesRead, LineNum[1]
      Elapsed! = (float)clock()/(float)CLOCKS_PER_SEC

      IF BCX_COLORS THEN COLOR 11,0
      PRINT "[Lines In:"             ;
      IF BCX_COLORS THEN COLOR 14,0
      PRINT   LinesRead              ;
      IF BCX_COLORS THEN COLOR 11,0
      PRINT  "] [Lines Out:"         ;
      IF BCX_COLORS THEN COLOR 14,0
      PRINT    LinesWritten          ;
      IF BCX_COLORS THEN COLOR 11,0
      PRINT  "] "                    ;
      PRINT "[Statements:"           ;
      IF BCX_COLORS THEN COLOR 14,0
      PRINT  Statements              ;
      IF BCX_COLORS THEN COLOR 11,0
      PRINT "] [Time: "              ;
      IF BCX_COLORS THEN COLOR 14,0
      PRINT  USING$("#.##",Elapsed!) ;
      IF BCX_COLORS THEN COLOR 11,0
      PRINT " Sec's]"

      GTmp$ = "BCX translated [" + REMOVE$(MCASE$(FileIn$),SPC$)
      GTmp$ = GTmp$ + "] to ["   + REMOVE$(MCASE$(FileOut$),SPC$) + "]"

      IF UseCpp THEN
         CONCAT (GTmp$, " for a C++ Compiler")
      ELSE
         CONCAT (GTmp$, " for a C Compiler")
      END IF

      IF Use_Project THEN
         CONCAT (GTmp$, " with No Runtime")
      END IF

      IF BCX_COLORS THEN COLOR 10,0
      PRINT GTmp$
      PRINT
      IF BCX_COLORS THEN POPCOLORS
   END IF

   IF Use_Project AND Gen_Header THEN
      CALL Project_Support
   END IF

   IF WarnMsg$ <> "" THEN
      IF InfoBoxWarn THEN
         INFOBOX("Warnings! :" , WarnMsg$, _
         GetSystemMetrics(SM_CXSCREEN)/4,  _
         GetSystemMetrics(SM_CYSCREEN)/4)
      ELSE
         PRINT "Warnings! :", CRLF$, WarnMsg$
      END IF
   END IF

   '**********************************************
   ' Final time to make some tweaks to the
   ' C/C++ output file before ending - MrBcx
   '**********************************************
   CALL Final_Transforms                             ' This revised order of calls
   CALL PostProcess                                  ' fixes 0xf bug in "::" lines
   '**********************************************

   IF KillCFile THEN KILL FileOut$ ' -kill switch?
   CALL KillFiles
   CALL FREEGLOBALS

   FUNCTION = EXIT_SUCCESS
END FUNCTION  ' Function main

'************************************************************************************
'                        End of BCX Translator Main Function
'************************************************************************************

SUB Early_Transforms
   '***************************************************
   IF INSTR(Src$, QUOTQUOT$) THEN
      Use_DQ = TRUE
      REPLACE QUOTQUOT$ WITH " DQ$ " IN Src$
   END IF
   '**************************************************************
   ' RESTORE SELECT CASE BAND - Improved in 786 MrBcx
   '**************************************************************
   IF iMatchNQ(Src$,"band") THEN
      IF LIKE(Src$, "*select*case*band*") THEN
         DIM RAW TmpSrc$
         TmpSrc$ = TRIM$(STRIM$(Src$))
         IF LIKE(TmpSrc$, "select case band*") THEN
            IREPLACE " band " WITH SPC$ IN Src$
            CONCAT(Src$, SPC$ + "&&")
         END IF
      END IF
   END IF
   '**************************************************************
   ' Improve processing of "DIM AS CONST" brackets - 782 MrBcx
   '**************************************************************
   IF iMatchNQ (Src$, "const") THEN
      IF LIKE(Src$, "*dim*as*const*") THEN
         FastLexer(Src$, SPC$, "=&()[]{}',+-*/<>?;.|:^")
         IF Stk$[1] ?? "dim" AND _
            Stk$[2] ?? "as"  AND _
            Stk$[3] ?? "const" THEN
            REPLACE " [" WITH "[" IN Src$
            REPLACE " ]" WITH "]" IN Src$
         END IF
      END IF
   END IF
   '*********************************************************************
   '    Transform METHOD, PROPERTY, PROPSET, and PROPGET - 787 MrBcx
   '*********************************************************************
   IF UseCpp THEN
      IF iMatchNQ(Src$, "propget")  THEN IREPLACE "propget"  WITH "FUNCTION" IN Src$
      IF iMatchNQ(Src$, "propset")  THEN IREPLACE "propset"  WITH "SUB"      IN Src$
      IF iMatchNQ(Src$, "property") THEN
         DIM szTmp$
         szTmp$ = SPC$ + Src$ + SPC$
         IF INSTR(szTmp$, " property ", 0, 1) THEN
            IREPLACE "property" WITH "SUB"  IN Src$
         END IF
      END IF
      IF iMatchNQ(Src$, "method") THEN
         DIM szTmp$
         szTmp$ = SPC$ + Src$ + SPC$
         IF INSTR(szTmp$, " method ", 0, 1) OR INSTR(szTmp$, " method=", 0, 1) THEN
            IREPLACE "method" WITH "FUNCTION"  IN Src$
         END IF
      END IF
   END IF
   '*********************************************************************
   '                    Enable range-based FOR-NEXT loops
   '*********************************************************************
   IF UseCpp THEN
      IF iMatchNQ(Src$,"rbfor") OR iMatchNQ(Src$,"rbnext") OR iMatchNQ(Src$,"rbexit") THEN
         CALL RBForTransform
      END IF
   END IF
END SUB




SUB Final_Transforms
   DIM RAW Source$
   '**********************************************************************************
   DIM RAW Dll_Orig$                 '  C_EXPORT int __stdcall DllMain
   Dll_Orig$ = VCHR$(30,67,95,69,88,80,79,82,84,32,105,110,116,     _
   32,95,95,115,116,100,99,97,108,108,32,68,108,108,77,97,105,110)
   '**********************************************************************************
   DIM RAW Dll_Repl$                 ' __declspec(dllexport) BOOL WINAPI DllMain
   Dll_Repl$ = VCHR$(41,95,95,100,101,99,108,115,112,101,99,40,     _
   100,108,108,101,120,112,111,114,116,41,32,66,79,79,76,32,87,73,  _
   78,65,80,73,32,68,108,108,77,97,105,110)
   '**********************************************************************************
   DIM RAW QQF$, QQR$                        ' change "char*  = DQ$" to "char*  = DQ"
   QQF$ = VCHR$ (12,99,104,97,114,42,32,32,61,32,68,81,36)
   QQR$ = VCHR$ (11,99,104,97,114,42,32,32,61,32,68,81)
   '**********************************************************************************
   DIM RAW BandAid$ :  BandAid$ = CHR$(38,38,61,61)     ' Bugfix for SELECT CASE BAND
   '**********************************************************************************
   CALL StripExtraDefWndProcs
   '**********************************************************************************
   OPEN FileOut$          FOR INPUT  AS FP1
   OPEN "$Bcx$Temp$File$" FOR OUTPUT AS FP2
   '**********************************************************************************
   DO WHILE NOT EOF(FP1)
      LINE INPUT FP1, Source$
      REPLACE CHR$(15)  WITH  ":"       IN Source$  ' Fix recently detected mystery
      REPLACE QQF$      WITH  QQR$      IN Source$  ' Delete the $ from certain DQ$
      REPLACE Dll_Orig$ WITH  Dll_Repl$ IN Source$  ' Enforce MS DllMain definition
      '********************************************************************************
      IF UserBcxStrSize$ > "" AND LEFTSTR(Source$,"#define BCXSTRSIZE") THEN
         Source$ = "#define BCXSTRSIZE " + UserBcxStrSize$
      END IF
      '********************************************************************************
      IF iMatchNQ (Source$, "CXST") THEN
         IF LIKE(Source$,"*=*[BCXSTRSIZE];*") THEN
            CALL AllowLoadedStrings (Source$)
         END IF
      END IF
      '*************************************************************  Make ULEX happy
      REPLACE CHR$(61,45,32) WITH CHR$(32,61,32,45)   IN Source$   ' Before: =-[space]
      REPLACE CHR$(32,45,62) WITH CHR$(45,62)         IN Source$   ' Before: [space]->
      '********************************************************************************
      IF iMatchNQ(Source$, BandAid$) THEN                          ' MrBcx 786
         IF LIKE(Source$, "*if(*") THEN                            ' MrBcx 784
            REPLACE BandAid$ WITH " & " IN Source$                 ' Part 2/2 fixing
         END IF                                                    ' SELECT CASE BAND
      END IF                                                       '
      '********************************************************************************
      REPLACE CHR$ (70,73,76,69,32,32,32,42,32,32) WITH "FILE   *" IN Source$
      '********************************************************************************
      IF iMatchNQ (Source$, "( ") THEN REPLACE "( " WITH "(" IN Source$  ' Cosmetic
      '********************************************************************************
      FPRINT FP2, Source$
   LOOP
   CLOSE
   KILL FileOut$
   RENAME "$Bcx$Temp$File$", FileOut$
END SUB




SUB RBForTransform
   ' ********************************************************************
   '  777 -  James Fuller's pre-translation FOR-NEXT transform
   '                for C++11 Range Based FOR-NEXT loops
   '                 Keywords:  RBFOR,  RBEXIT,  RBNEXT
   '*********************************************************************
   DIM RAW Kopy$
   Kopy$ = TRIM$(Src$)
   IF LEFTSTR(Kopy$, "rbfor", 1) THEN
      IREPLACE "AUTO"     WITH "auto"     IN Src$
      IREPLACE "rbfor"    WITH "! for "   IN Src$
      CONCAT (Src$," { ")
   END IF
   IF LEFTSTR(Kopy$, "rbnext", 1) THEN
      Src$ = "}"
   END IF
   IF LEFTSTR(Kopy$, "rbexit", 1) THEN
      Src$ = "break"
   END IF
END SUB



SUB StripExtraDefWndProcs
   DIM RAW Source$
   DIM RAW CurrLin$
   DIM RAW PrevLin$
   '****************************************
   OPEN FileOut$          FOR INPUT  AS FP1
   OPEN "$Bcx$Temp$File$" FOR OUTPUT AS FP2
   '****************************************
   DO WHILE NOT EOF(FP1)
      LINE INPUT FP1, Source$
      CurrLin$ = LEFT$(LTRIM$(Source$),20)

      IF CurrLin$ <> "return DefWindowProc" THEN
         FPRINT FP2, Source$
         PrevLin$ = LEFT$(LTRIM$(Source$),7)  ' Warning:  Don't assume this = "return "
         ITERATE
      END IF

      IF CurrLin$ =  "return DefWindowProc" AND PrevLin$ <> "return " THEN
         FPRINT FP2, Source$
      END IF

      PrevLin$ = LEFT$(LTRIM$(Source$),7)    ' Warning:  Don't assume this = "return "
   LOOP

   CLOSE FP1
   CLOSE FP2
   KILL FileOut$
   RENAME "$Bcx$Temp$File$", FileOut$
END SUB


SUB AllowLoadedStrings(szSrc$)
   '********************************************************************************
   ' This allows static string initializations using DIM and DIM RAW.  This only
   ' works in SUBS and FUNCTIONS (including FUNCTION MAIN, if $NOMAIN is used).
   ' Example 1:  DIM A$ = "This is handy!"
   ' Example 2:  DIM RAW A$ = "This works too!"         (Updated) MrBcx Version 774
   '********************************************************************************
   MACRO CommaEq$ = ",="
   DIM RAW i, Varname$, Literal$, Target$
   Target$ = DQ$ + "[BCXSTRSIZE];"
   i = INSTR (szSrc$, Target$)
   IF i > 0 THEN
      Literal$ = MID$(szSrc$, 1 + INCHR(szSrc$,"="))
      REMOVE "[BCXSTRSIZE];" from Literal$
      Varname$ = EXTRACT$ (szSrc$,"=") : Varname$ = STRIM$(Varname$)
      szSrc$   = Varname$ + "[BCXSTRSIZE];  strcpy("
      Varname$ = TRIM$(MID$(Varname$,INCHR(Varname$,SPC$)))
      szSrc$  = szSrc$ + Varname$ + "," + Literal$ + ");"
      REPLACE CommaEq$ WITH "," IN szSrc$
      szSrc$ = SPACE$(3) + szSrc$
   END IF
END SUB


FUNCTION iMatch(Arg$ AS LPCTSTR, MatchStr$ AS LPCTSTR, mt)
   '****************************************************
   ' Case insensitive comparison - MatchStr$ to Arg$
   ' mt = 0, 1 or 2 Match left, whole word, right
   '****************************************************
   DIM RAW L1 AS INT
   DIM RAW L2 AS INT
   IF mt = 2 THEN
      L1 = LEN(Arg$)
      L2 = LEN(MatchStr$)
      IF L1 < L2 THEN FUNCTION = FALSE
      Arg = (Arg + L1) - L2
   END IF
   DO WHILE *MatchStr
      IF *Arg = 0 THEN FUNCTION = FALSE                             ' If we run out string, return no match
      IF (*Arg BOR 32) <> (*MatchStr BOR 32) THEN FUNCTION = FALSE  ' bit ORing with 32 produces lower case
      INCR Arg
      INCR MatchStr
   LOOP
   IF mt AND NOTNULL(Arg$) THEN
      FUNCTION = FALSE
   ELSE
      FUNCTION = TRUE
   END IF
END FUNCTION ' iMatch



FUNCTION iMatchNQ(Arg$, MatchStr$)
   '****************************************************
   ' Returns the position of the first occurrence
   ' of MatchStr$ in Arg$ that isn't in quotes.
   '****************************************************
   DIM RAW mi
   DIM RAW a AS PCHAR
   mi = 0
   a = Arg
   DO WHILE MatchStr[mi]
      IF *a = c_DblQt THEN
         mi = 0
         DO WHILE *(++a) <> c_DblQt
            IF *a = 0 THEN FUNCTION = 0
         LOOP
      END IF
      IF a[mi] = 0 THEN FUNCTION = 0                   ' If we run out string, return no match
      IF (a[mi] BOR 32) <> (MatchStr[mi] BOR 32) THEN  ' bit ORing with 32 produces lower case
         INCR a
         mi = (-1)
      END IF
      INCR mi
   LOOP
   FUNCTION = (INT)(a-Arg) + 1  ' We have a match
END FUNCTION  ' iMatchNQ




FUNCTION GetBracketPair(iStart AS INT, iEnd AS INT, iDir AS INT)
   DIM RAW i AS INT
   FOR i = iStart TO iEnd STEP iDir
      IF *Stk$[i] = ASC("[") AND *Stk$[i+1] = ASC("]") THEN
         FUNCTION = i
      END IF
   NEXT
   FUNCTION = 0
END FUNCTION ' GetBracketPairPos




FUNCTION GetAsPos(iStart AS INT, iEnd AS INT, iDir AS INT)
   DIM RAW i AS INT
   FOR i = iStart TO iEnd STEP iDir
      IF iMatchWrd(Stk$[i],"as") THEN
         FUNCTION = i
      END IF
   NEXT
   FUNCTION = 0
END FUNCTION  ' GetAsPos




SUB BuildStr(iStart, iEnd, szBuild$)
   DIM RAW i AS INT
   szBuild$ = ""
   FOR i = iStart TO iEnd
      CONCAT (szBuild$, Stk$[i])
   NEXT
END SUB ' BuildStr




SUB BuildCleanStr(iStart, iEnd, szBuild$)
   CALL BuildDelimStr(iStart, iEnd, szBuild$)
   szBuild$ = Clean$(szBuild$)
END SUB ' BuildCleanStr




SUB BuildDelimStr(iStart, iEnd, szBuild$)
   DIM RAW pszStk AS PCHAR
   DIM RAW i AS INT
   szBuild$ = ""
   FOR i = iStart TO iEnd
      pszStk = (PCHAR)&Stk$[i]
      IF NOTNULL(pszStk) THEN
         IF pszStk$ = "!" THEN
            CONCAT (szBuild$, " ! ")
         ELSE
            IF *pszStk$ = ASC("_") THEN
               CONCAT (szBuild$, SPC$)
               CONCAT (szBuild$, pszStk$)
            ELSE
               CONCAT (szBuild$, pszStk$)
               IF ispunct(*pszStk) THEN
                  IF ISNULL (pszStk+1) THEN ITERATE
               END IF
            END IF
            IF i < iEnd AND (ISFALSE ispunct(*Stk$[i+1]) OR NOTZERO Stk[i+1][1]) THEN
               IF *Stk$[2] <> ASC("=") THEN CONCAT (szBuild$, SPC$)
            END IF
         END IF
      END IF
   NEXT
END SUB ' BuildDelimStr




SUB WriteCleanTokens(iStart, iEnd)
   DIM RAW LTmp$
   CALL BuildCleanStr(iStart, iEnd, LTmp$)
   FPRINT Outfile, LTmp$
END SUB ' WriteCleanTokens




FUNCTION HasThisToken(sToken$)
   DIM RAW ThisToken = 0
   XFOR INT j = 1 WHILE j <= Ndx AND IAmNot(ThisToken) BY j++
      ThisToken = iMatchWrd(Stk$[j], sToken$)
   XNEXT
   FUNCTION = ThisToken
END FUNCTION

'==================================================
'                  Expand Macros
'==================================================


FUNCTION MacroCheck
   DIM RAW szMacroCheck$
   DIM RAW IsMacro = FALSE
   FastLexer(Src$," (","")
   szMacroCheck$ = LCASE$(Stk$[1])

   IF iMatchNQ ("handle_msg handle_cmd bcx_resource msghandler cmdhandler end", szMacroCheck$) THEN
      SELECT CASE szMacroCheck$
         CASE "handle_msg"     ' handle_msg handler
         CALL CheckParQuotes
         CALL ProcessMsgCracker
         IsMacro = TRUE

         CASE "handle_cmd"
         CALL CheckParQuotes
         CALL ProcessCmdHandler
         IsMacro = TRUE

         CASE "bcx_resource"
         Use_GenResFile = TRUE
         FPRINT FP_RES,  MID$(Src$,14)
         IsMacro = TRUE

         CASE "msghandler", "cmdhandler"
         CALL CheckParQuotes
         CALL ProcessMsgHandler
         IsMacro = TRUE

         CASE "end"
         IF ISTRUE (iMatchWrd(Stk$[2],"handler")) THEN
            CALL CheckParQuotes
            CALL ProcessMsgHandlerEnd
            IsMacro = TRUE
         END IF
      END SELECT
   END IF
   IF IsMacro = TRUE THEN Src$ = ""
   FUNCTION = IsMacro
END FUNCTION





SUB Process_ASC_Function (St_idx)
   DIM RAW i, j
   j = GetNumArgs(St_idx + 2, &i)
   IF *Stk$[St_idx + 2] = *DQ$ THEN
      IF j OR *Stk$[St_idx + 3] <> ASC(")") THEN
         Stk$[St_idx] = "asc"
         Use_Asc = Use_Proto = TRUE
      ELSE
         IF Stk$[St_idx + 2] = DDQ$ THEN
            Stk$[St_idx] = "0"
         ELSE
            Stk$[St_idx] = STR$(ASC(Stk$[St_idx + 2],1),TRUE)
         END IF
         Stk$[St_idx+1] = ""
         Stk$[St_idx+2] = ""
         Stk$[St_idx+3] = ""
         INCR TS_CompPtr
      END IF
   ELSE
      IF j > 0 THEN Stk$[i] = "+"
      Stk$[St_idx] = "(UCHAR)*"
   END IF
END SUB





SUB ActivityFlags
   '*******************************************
   IF ShowStatus THEN CALL DisplayStatus
   '*******************************************
   IF ISTRUE (TraceFlag AND InFunction) THEN
      IF ISFALSE(iMatchLft(Src$,"$trace")) THEN
         IF ISFALSE(iMatchLft(Src$,"end ")) AND ISZERO (iMatchNQ(Src$,"function")) THEN
            FPRINT Outfile, "// [", TRIM$(FileNames$[FileNdx]), " - ", TRIM$(STR$(LineNum[FileNdx])), "] ", Src$
            GTmp$ = TRIM$(FileNames$[FileNdx])
            GTmp$ = REPLACE$(GTmp$, BKSLASH1$, BKSLASH2$)
            GTmp$ = SPC$ + GTmp$ + " - " + STR$(LineNum[FileNdx]) + " \\n"
            GTmp$ = "printf(" + ENC$(GTmp$) + ");"
            FPRINT Outfile, GTmp$
         END IF
      END IF
   END IF
   '*****************************************
   IF SrcFlag THEN
      IF ISFALSE (iMatchLft(Src$,"$sourc")) AND *Src <> ASC("!") THEN
         FPRINT Outfile, "// [", TRIM$(FileNames$[FileNdx]), " - ", TRIM$(STR$(LineNum[FileNdx])), "] ", Src$
      END IF
   END IF
END SUB



SUB DisplayStatus
   LOCATE 5,1,0
   PRINT "Processing Module: ", TRIM$(FileNames$[FileNdx]), " - Line:", LineNum[FileNdx]
   LOCATE 6,1,0  : PRINT SPACE$(1000)
   IF BCX_COLORS THEN COLOR 10,0
   LOCATE 6,1,0  : PRINT STRIM$(AbortSrc$)
   IF BCX_COLORS THEN COLOR 13,0
   LOCATE 10,1,0 : PRINT "Press any key to cancel"
   SLEEP(100)
   IF INSTAT THEN
      CLOSE
      SLEEP(100)
      KILL "BC.out"
      KILL "BC.c"
      KILL "BC.cpp"
      POPCOLORS
      PRINT "Cancelled by user. Unfinished translation files removed."
      END
   END IF
   POPCOLORS
END SUB



FUNCTION GetVarTypeName$ (i)
   DIM RAW A$
   SELECT CASE i
      CASE vt_INTEGER    :    A$ = "int"
      CASE vt_STRVAR     :    A$ = "char *"
      CASE vt_STRLIT     :    A$ = "STRLIT"
      CASE vt_UNKNOWN    :    A$ = "UNKNOWN"
      CASE vt_SINGLE     :    A$ = "float"
      CASE vt_DOUBLE     :    A$ = "double"
      CASE vt_LDOUBLE    :    A$ = "LDOUBLE"
      CASE vt_DECFUNC    :    A$ = "DECFUNC"
      CASE vt_NUMBER     :    A$ = "NUMBER"
      CASE vt_FILEPTR    :    A$ = "FILE*"
      CASE vt_UDT        :    A$ = "struct"
      CASE vt_STRUCT     :    A$ = "struct"
      CASE vt_UNION      :    A$ = "union"
      CASE vt_LPSTR      :    A$ = "LPSTR"
      CASE vt_BSTR       :    A$ = "BSTR"
      CASE vt_BOOL       :    A$ = "BOOL"     ' When UseCpp THEN A$ = "bool" ELSE A$ = "BOOL"
      CASE vt_CHAR       :    A$ = "char"
      CASE vt_LPSTRPTR   :    A$ = "LPSTR *"
      CASE vt_CHARPTR    :    A$ = "char"     ' Default String - 2048
      CASE vt_PCHAR      :    A$ = "PCHAR"
      CASE vt_VOID       :    A$ = "void"
      CASE vt_LONG       :    A$ = "long"
      CASE vt_DWORD      :    A$ = "DWORD"
      CASE vt_FARPROC    :    A$ = "FARPROC"
      CASE vt_LPBYTE     :    A$ = "LPBYTE"
      CASE vt_LRESULT    :    A$ = "LRESULT"
      CASE vt_BYTE       :    A$ = "BYTE"
      CASE vt_SHORT      :    A$ = "short"
      CASE vt_USHORT     :    A$ = "USHORT"
      CASE vt_COLORREF   :    A$ = "COLORREF"
      CASE vt_UINT       :    A$ = "UINT"
      CASE vt_ULONG      :    A$ = "ULONG"
      CASE vt_ULONGLONG  :    A$ = "ULONGLONG"
      CASE vt_LLONG      :    A$ = "long long"
      CASE vt_HWND       :    A$ = "HWND"
      CASE vt_HANDLE     :    A$ = "HANDLE"
      CASE vt_HINSTANCE  :    A$ = "HINSTANCE"
      CASE vt_HDC        :    A$ = "HDC"
      CASE vt_SAFEARRAY  :    A$ = "SAFEARRAY"
      CASE vt_VARIANT    :    A$ = "VARIANT"
      CASE vt_WNDCLASSEX :    A$ = "WNDCLASSEX"
      CASE vt_HFONT      :    A$ = "HFONT"
      CASE vt_DOCINFO    :    A$ = "DOCINFO"
      CASE vt_LOGFONT    :    A$ = "LOGFONT"
      CASE vt_TEXTMETRIC :    A$ = "TEXTMETRIC"
      CASE vt_WINBOOL    :    A$ = "BOOL"
      CASE ELSE          :    A$ = ""  'Assume the programmer has a brain
   END SELECT
   FUNCTION = A$
END FUNCTION ' GetVarTypeName$




SUB LoopErrorMsg
   DIM RAW sError$
   IF LoopTypeCnt > 1 THEN
      sError$ = "Multiple loop errors, innermost starting at"
   ELSE
      sError$ = "Loop error starting at"
   END IF

   sError$ = sError$ + STR$(LoopType[LoopTypeCnt].iLoopLine) + SPC$

   SELECT CASE LoopType[LoopTypeCnt].iLoopType

      CASE lt_DOLOOP
      CONCAT ( sError$, "DO without LOOP" )

      CASE lt_DOWHILELOOP, lt_DOUNTILLOOP
      CONCAT ( sError$,"DO CONDITION without LOOP" )

      CASE lt_WHILEWEND
      CONCAT ( sError$, "WHILE without WEND" )

      CASE lt_FORNEXT
      CONCAT ( sError$, "FOR without NEXT" )

      CASE lt_SELECT
      CONCAT ( sError$, "SELECT without END SELECT" )

      CASE lt_FORXNEXT
      CONCAT ( sError$, "XFOR without XNEXT" )
   END SELECT
   CALL Abort(sError$)
END SUB




FUNCTION LoopTypeName$(iLoopType AS INT)
   '============================================
   '  Used to get loop type for Error Message
   '============================================
   DIM sLoopType$

   SELECT CASE iLoopType

      CASE lt_DOLOOP
      sLoopType$ = "DO"

      CASE  lt_DOWHILELOOP, lt_DOUNTILLOOP
      sLoopType$ = "DO CONDITION"

      CASE lt_WHILEWEND
      sLoopType$ = "WHILE"

      CASE lt_FORNEXT
      sLoopType$ = "FOR"

      CASE lt_SELECT
      sLoopType$ = "SELECT"

      CASE lt_FORXNEXT
      sLoopType$ = "XFOR"
   END SELECT
   FUNCTION = sLoopType$
END FUNCTION





SUB EmitCompilerDefines
   DIM STATIC BeenHere
   IF BeenHere THEN EXIT SUB
   BeenHere = TRUE
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, "//                  Compiler Defines"
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "#if defined (__cplusplus)"
   FPRINT FP_HDR, "  #define overloaded"
   FPRINT FP_HDR, "  #define C_EXPORT EXTERN_C __declspec(dllexport)"
   FPRINT FP_HDR, "  #define C_IMPORT EXTERN_C __declspec(dllimport)"
   FPRINT FP_HDR, "#else"
   FPRINT FP_HDR, "  #define C_EXPORT __declspec(dllexport)"
   FPRINT FP_HDR, "  #define C_IMPORT __declspec(dllimport)"
   FPRINT FP_HDR, "#endif"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, "//                   Microsoft VC++"
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "#ifndef DECLSPEC_UUID"
   FPRINT FP_HDR, "  #if (_MSC_VER >= 1100) && defined (__cplusplus)"
   FPRINT FP_HDR, "    #define DECLSPEC_UUID(x)  __declspec(uuid(x))"
   FPRINT FP_HDR, "  #else"
   FPRINT FP_HDR, "    #define DECLSPEC_UUID(x)"
   FPRINT FP_HDR, "  #endif"
   FPRINT FP_HDR, "#endif"
   FPRINT FP_HDR, "#if (_MSC_VER >= 1900)            // earlier versions untested"
   FPRINT FP_HDR, "   #include <intrin.h>"
   FPRINT FP_HDR, "      #ifndef _rdtsc"
   FPRINT FP_HDR, "         #define _rdtsc __rdtsc   // MSVC uses 2 underscores"
   FPRINT FP_HDR, "      #endif"
   IF WarningFlag = FALSE THEN
      FPRINT FP_HDR, "   #pragma warning(disable: 4018) // signed/unsigned mismatch warnings"
      FPRINT FP_HDR, "   #pragma warning(disable: 4100) // unreferenced argument warnings"
      FPRINT FP_HDR, "   #pragma warning(disable: 4244) // conversion from type1 to type2 warnings"
      FPRINT FP_HDR, "   #pragma warning(disable: 4267) // conversion from type1 to type2 warnings"
      FPRINT FP_HDR, "   #pragma warning(disable: 4305) // truncation from double to float warnings"
      FPRINT FP_HDR, "   #pragma warning(disable: 4800) // forcing value to bool warnings"
      FPRINT FP_HDR, "   #pragma warning(disable: 4838) // conversion from type1 to type2 warnings"
   END IF
   FPRINT FP_HDR, "#endif"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, "//                  GCC and CLANG"
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "#if defined (__GNUC__) || defined (__clang__)"
   FPRINT FP_HDR, "   #ifndef __BCPLUSPLUS__"
   FPRINT FP_HDR, "      #include <x86intrin.h>"
   FPRINT FP_HDR, "   #endif"
   IF WarningFlag = FALSE THEN
      FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wwrite-strings")
      FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wunused-parameter")
      FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wunknown-pragmas")
      FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wdangling-else")
      FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wdeprecated")
   END IF
   FPRINT FP_HDR, "#endif"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, "//                  Embarcadero C++"
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "#if defined (__BCPLUSPLUS__)"
   FPRINT FP_HDR, "      #if  defined (_clang__)"
   FPRINT FP_HDR, "            #include <mmintrin.h>"
   FPRINT FP_HDR, "      #endif"
   FPRINT FP_HDR, "      #define _kbhit kbhit"
   FPRINT FP_HDR, "      #ifndef _rdtsc"
   FPRINT FP_HDR, "        #define _rdtsc __rdtsc  // Uses 2 underscores"
   FPRINT FP_HDR, "      #endif"
   FPRINT FP_HDR, "#endif"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, "//                    Open Watcom"
   FPRINT FP_HDR, "// *************************************************"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "#if defined (__WATCOM_CPLUSPLUS__)"
   FPRINT FP_HDR, "  #define _fcloseall fcloseall"
   FPRINT FP_HDR, "#endif"

   IF ISFALSE UseCpp THEN
      FPRINT FP_HDR, ""
      FPRINT FP_HDR, "// *************************************************"
      FPRINT FP_HDR, "//                     Lcc-Win32"
      FPRINT FP_HDR, "// *************************************************"
      FPRINT FP_HDR, ""
      FPRINT FP_HDR, "#if defined(__LCC__)"
      FPRINT FP_HDR, "  #define _fseeki64  fseeki64"
      FPRINT FP_HDR, "  #define _stricmp   stricmp"
      FPRINT FP_HDR, "  #define _strnicmp  strnicmp"
      FPRINT FP_HDR, "  #define _itoa      itoa"
      FPRINT FP_HDR, "  #define _ltoa      ltoa"
      FPRINT FP_HDR, "  #include <intrinsics.h>"
      FPRINT FP_HDR, "  #include <malloc.h>  // for _msize"
      FPRINT FP_HDR, "  #if defined(__windows_h__)"
      FPRINT FP_HDR, "      #define COMPILE_MULTIMON_STUBS"
      FPRINT FP_HDR, "      #include <multimon.h>"
      FPRINT FP_HDR, "      #include <iehelper.h>"
      FPRINT FP_HDR, "      #include <exdisp.h>"
      FPRINT FP_HDR, "   #endif"
      FPRINT FP_HDR, "#endif"
   END IF

   IF ISFALSE UseCpp THEN
      FPRINT FP_HDR, ""
      FPRINT FP_HDR, "// *************************************************"
      FPRINT FP_HDR, "//                     Pelles C"
      FPRINT FP_HDR, "// *************************************************"
      FPRINT FP_HDR, ""
      FPRINT FP_HDR, "#if defined (__POCC__)"
      FPRINT FP_HDR, "   #include <intrin.h>"
      FPRINT FP_HDR, "   #pragma pack_stack(off)        // Pelle's fix for a v10 optimization bug"

      IF WarningFlag = FALSE THEN
         FPRINT FP_HDR, "   #pragma warn(disable: 2006)    // Non-portable conversion int to const char*"
         FPRINT FP_HDR, "   #pragma warn(disable: 2007)    // Non-portable inline code"
         FPRINT FP_HDR, "   #pragma warn(disable: 2115)    // Initialized but not used warnings"
         FPRINT FP_HDR, "   #pragma warn(disable: 2118)    // Unreferenced argument warnings"
         FPRINT FP_HDR, "   #pragma warn(disable: 2134)    // Possible infinite loop"
         FPRINT FP_HDR, "   #pragma warn(disable: 2154)    // Buggy unreachable code warning using sizeof"
         FPRINT FP_HDR, "   #pragma warn(disable: 2197)    // Unsigned long int not a std bit-field type"
         FPRINT FP_HDR, "   #pragma warn(disable: 2215)    // Conversion from type1 to type2 warnings"
         FPRINT FP_HDR, "   #pragma warn(disable: 2218)    // Unreferenced parameter"
         FPRINT FP_HDR, "   #pragma warn(disable: 2230)    // Incomplete struct declarations (vbs support)"
         FPRINT FP_HDR, "   #pragma warn(disable: 2235)    // Not all control paths return a value"
         FPRINT FP_HDR, "   #pragma warn(disable: 2241)    // Function marked for deprecation"
         FPRINT FP_HDR, "   #pragma warn(disable: 2248)    // Non-portable use of extension"
         FPRINT FP_HDR, "   #pragma warn(disable: 2251)    // Types with different signedness"
         FPRINT FP_HDR, "   #pragma warn(disable: 2804)    // Consider changing type to size_t warnings"
         FPRINT FP_HDR, "   #pragma warn(disable: 2805)    // Possible anti-aliasing violation warnings"
         FPRINT FP_HDR, "   #pragma warn(disable: 2810)    // Potential realloc warnings"
      END IF

      FPRINT FP_HDR, "#endif"
   END IF
END SUB 'EmitCompilerDefines



SUB MakeFreeGlobals
   Src$ = "SUB FreeGlobals"
   PassOne = TRUE
   INJECT(Src$)
   DO WHILE GlobalDynaCnt
      FPRINT Outfile, SPC$, SPC$, GlobalDynaStr$[GlobalDynaCnt]
      DECR GlobalDynaCnt
   LOOP
   Src$ = "END SUB"
   PassOne = TRUE
   INJECT(Src$)
END SUB ' MakeFreeGlobals



SUB ClearVARCODE(pv AS VARCODE PTR)
   pv->UseInLine       = UseInLine
   pv->IsExported      = FALSE
   pv->VarNo           = 0
   pv->Methd           = 0
   pv->IsPtrFlag       = 0
   pv->szFunctionName$ = ""
   pv->Header$         = ""
   pv->Proto$          = ""
   pv->Functype$       = ""
   pv->StaticOut$      = ""
   pv->Token$          = ""
   pv->AsToken$        = ""
END SUB



SUB ProcessSetCommand(GS)
   DIM RAW iThisToken, iFoundEqual, SetString, vt1
   DIM RAW szIsConst$,LTmp$,CVar$
   DIM RAW VarCode AS VARCODE
   DIM RAW SaveFP AS FILE
   DIM RAW ii AS INT
   DIM RAW L_DimType$
   DIM RAW IsPointer
   DIM RAW id
   DIM RAW iIsConst

   SetString = 0
   CALL ClearVARCODE(&VarCode)
   VarCode.IsPtrFlag = 0
   SaveFP = Outfile

   IF InNameSpace OR InClass THEN
      Outfile = FP_UDT     ' CPP context
   ELSEIF InFunction = FALSE THEN
      Outfile = FP_SET     ' Global context
   END IF

   IF INCHR(Src$,"$") AND TALLY(Src$,"[") >1 THEN
      Src$ = STRIM$(Src$)
      IREMOVE "as string" FROM Src$
      IREMOVE "as char"   FROM Src$
      CONCAT(Src$," AS char")
   END IF

   CONCAT(Src$,"=")
   PassOne = TRUE
   CALL XParse(Src$)
   CALL FixUps
   gszType$ = ""
   szIsConst$ = ""
   iThisToken = GetAsPosF(1, Ndx)
   IF iThisToken THEN
      Stk$[iThisToken++] = ""
      gszType$ = Stk$[iThisToken]
      IF iMatchWrd(gszType$, "const") THEN
         szIsConst$ = "const "
         Stk$[iThisToken++] = ""
         gszType$ = Stk$[iThisToken]
      END IF
      Stk$[iThisToken] = ""
   END IF

   IF ISNULL(gszType$) THEN
      GTmpStr$ = Stk$[2]
      SetString = DataType(GTmpStr$)
      VarCode.Methd% = mt_ProcessSetCommand
      VarCode.Token$ = GTmpStr$
      VarCode.VarNo% = SetString
      CALL GetVarCode(&VarCode, "set command")
      IF GS THEN
         FPRINT Outfile, Scoot$, REMOVE$(VarCode.StaticOut$,"static ");
      ELSE
         FPRINT Outfile, Scoot$, VarCode.StaticOut$;
      END IF

      LTmp$ = ""
      CVar$ = Clean$(Stk$[2])
      CALL ValidVar(CVar$)
      vt1 = DataType(Stk$[2])
      CALL BuildStr(3, Ndx, LTmp$)
      IF vt1 = vt_STRVAR AND NOTNULL(LTmp$) THEN
         CONCAT (LTmp$, "[BCXSTRSIZE]")
      END IF
      IF InFunction = FALSE THEN
         CALL AddGlobal(CVar$, vt1, 0,LTmp$,0,0,0,1)
      ELSE
         CALL AddLocal(CVar$, vt1, 0,LTmp$,0,0,1)
      END IF
   ELSE
      CVar$ = Clean$(Stk$[2])
      IF GS THEN
         FPRINT Outfile, Scoot$, szIsConst$, gszType$, SPC$, CVar$;
      ELSE
         FPRINT Outfile, Scoot$, "static ", szIsConst$, gszType$, SPC$, CVar$;
      END IF

      IF *szIsConst$ THEN iIsConst = 1 ELSE iIsConst = 0

      L_DimType$ = REMOVE$(gszType$,"*")
      CALL GetTypeInfo(gszType$, &IsPointer, &id, &vt1)

      IF vt1 = vt_STRVAR THEN
         CONCAT(L_DimType$, "[BCXSTRSIZE]")
      END IF

      IF InFunction = FALSE THEN
         CALL AddGlobal(CVar$, vt1, id, L_DimType$, IsPointer, 0, 0, 1,iIsConst)
      ELSE
         CALL AddLocal(CVar$, vt1, id, L_DimType$, IsPointer, 0, 1, iIsConst)
      END IF
   END IF

   iThisToken = 2
   iFoundEqual = FALSE
   DO
      INCR iThisToken
      IF *Stk$[iThisToken] = ASC("=") THEN iFoundEqual = TRUE
      IF SetString = vt_STRVAR AND iFoundEqual THEN
         FPRINT Outfile, "[BCXSTRSIZE]=";
      ELSE
         FPRINT Outfile, Stk$[iThisToken];
      END IF
      IF *Stk$[iThisToken] = ASC("=") THEN EXIT DO
      IF iThisToken = Ndx THEN EXIT DO
   LOOP

   FPRINT Outfile, ""
   FPRINT Outfile, "  {"

   DO WHILE NOT EOF(SourceFile)
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      CALL StripCode(Src$)
      IF JoinLines(Src$) THEN ITERATE
      PassOne = TRUE
      CALL XParse(Src$)
      PassOne = FALSE
      IF iMatchWrd(Src$,"endset") THEN EXIT DO
      CALL TokenSubstitutions(2)
      IF *Src$ THEN
         FPRINT Outfile, SPC$;
         FOR ii = 1 TO Ndx
            FPRINT Outfile, Clean$(Stk$[ii]);
         NEXT
         FPRINT Outfile, ""
      END IF
   LOOP
   FPRINT Outfile, "};"
   FPRINT Outfile, ""
   Src$ = ""
   Outfile = SaveFP
END SUB 'ProcessSetCommand




SUB EmitOptimize (Str1$, Str2$, Str3 = "" AS LPCTSTR)
   IF OptimizerEnabled THEN
      FPRINT Outfile, "#if defined (__POCC__) && !defined(__cplusplus)"
      FPRINT Outfile, "  #pragma optimize(",Str1$,")",Str3$
      FPRINT Outfile, "#elif !defined (__cplusplus)"
      FPRINT Outfile, "  #pragma optimize(",Str2$,")",Str3$
      FPRINT Outfile, "#endif"
   END IF
END SUB ' EmitOptimize





SUB EnableProject
   DIM STATIC iWasHere = FALSE
   IF FirstTime(iWasHere) THEN
      DIM RAW cHFn$
      INCR iWasHere
      Project_Main$ = TRIM$(REMOVE$(MID$(Src$,9),DQ$))
      Project_Main$ = EXTRACT$(Project_Main$, "'")     ' allow comments
      Project_Main$ = EXTRACT$(Project_Main$, ".")
      Use_Project   = TRUE
      IF INCHR(COMMAND$(1), "\") THEN ' has a path
         cHFn$ = MID$(COMMAND$(1), INSTRREV(COMMAND$(1), "\", 0) + 1)
      ELSE
         cHFn$ = COMMAND$(1)
      END IF
      IF INCHR(cHFn$, ".") THEN                        ' has an extension
         cHFn$ = MID$(cHFn$, 1, INSTRREV(cHFn$, ".", 0) -1 )
      END IF
      FPRINT FP_HDR, "#define __BCX_HEADER_",UCASE$(cHFn$),"__"
   END IF
END SUB ' EnableProject





FUNCTION SubVarType(TokenNum)
   DIM RAW iVarType, j = 0

   iVarType = CheckLocal(Stk$[TokenNum], &j)
   IF iVarType = vt_CHAR THEN
      IF *LocalVars[j].VarDim$ <> ASC("[") AND LocalVars[j].VarPntr = 0 THEN
         iVarType = vt_INTEGER
      END IF
   ELSE
      IF iVarType = vt_UNKNOWN THEN
         iVarType = CheckGlobal(Stk$[TokenNum], &j)
         IF iVarType = vt_CHAR THEN
            IF *GlobalVars[j].VarDim$ <> ASC("[") AND GlobalVars[j].VarPntr = 0 THEN
               iVarType = vt_INTEGER
            END IF
         END IF
      END IF
   END IF

   j = ASC(RIGHT$(Stk$[TokenNum],1))

   SELECT CASE iVarType

      CASE vt_STRVAR, vt_CHAR
      IF j <> ASC("$") THEN
         CONCAT (Stk$[TokenNum], "$")
      END IF

      CASE vt_INTEGER
      IF j <> ASC("%") THEN
         CONCAT (Stk$[TokenNum], "%")
      END IF

      CASE vt_SINGLE
      IF j <> ASC("!") THEN
         CONCAT (Stk$[TokenNum], "!")
      END IF

      CASE vt_DOUBLE
      IF j <> ASC("#") THEN
         CONCAT (Stk$[TokenNum], "#")
      END IF

      CASE vt_LDOUBLE
      IF j <> ASC("`") THEN
         CONCAT (Stk$[TokenNum], "`")
      END IF

   END SELECT
   FUNCTION = iVarType
END FUNCTION ' SubVarType



FUNCTION PrintWriteFormat$(DoWrite)
   DIM RAW Arg$
   DIM RAW Argcount
   DIM RAW Frmat$
   DIM RAW iThisToken
   DIM RAW iVarType
   DIM RAW LZZ$
   DIM RAW SuppressCRLF
   DIM RAW NextArgcount
   DIM RAW PWF_Cast$
   DIM RAW TmpClean$
   DIM RAW Stak[128] AS ARGTYPE

   SuppressCRLF  =  FALSE
   NextArgcount  =  1
   Argcount      =  0
   Frmat$        =  ""
   Arg$          =  ""
   LZZ$          =  ""

   IF Stk$[Ndx] = ";" THEN
      SuppressCRLF = TRUE
      DECR Ndx
   END IF

   IF Ndx = 1 THEN GOTO PrintWriteLabel

   Stak[1].ArgType = (-1)
   iThisToken = 2

   '********************************************************** MrBcx 786 -- PRINT bug fix
   FOR INT i = 1 TO Ndx
      IF Stk$[i] = "(int)strlen" THEN Stk$[i] =  "strlen"
   NEXT
   '***********************************************************
   FOR INT i = 2 TO Ndx                                             ' MrBcx 789
      IF IM_UDT_STRING (Stk$[i]) THEN CONCAT(Stk$[i],"$")           ' MrBcx 789
      IF IM_UDT_SINGLE (Stk$[i]) THEN CONCAT(Stk$[i],"!")           ' MrBcx 789
      IF IM_UDT_DOUBLE (Stk$[i]) THEN CONCAT(Stk$[i],"#")           ' MrBcx 789
   NEXT                                                             ' MrBcx 789
   '***********************************************************
   FOR INT i = 2 TO Ndx                                             ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_STRVAR THEN CONCAT(Stk$[i],"$")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_SINGLE THEN CONCAT(Stk$[i],"!")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_DOUBLE THEN CONCAT(Stk$[i],"#")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_LDOUBLE THEN CONCAT(Stk$[i],"#")  ' MrBcx 789
   NEXT                                                             ' MrBcx 789
   '***********************************************************

   DO WHILE iThisToken <= Ndx
      TmpClean$ = Clean$(Stk$[iThisToken])
      IF TmpClean$ <> "BCX_DynaCallA" AND TmpClean$ <> "BCX_DynaCallB" THEN
         iVarType = SubVarType(iThisToken)
         IF Stak[NextArgcount].ArgType = (-1) THEN
            IF iVarType = vt_CHAR OR iVarType = vt_STRVAR OR iVarType = vt_INTEGER OR _
               iVarType = vt_SINGLE OR iVarType = vt_DOUBLE OR iVarType = vt_LDOUBLE THEN
               Stak[NextArgcount].ArgType = iVarType
            END IF
         END IF

         IF *Stk$[iThisToken] = ASC("(") THEN
            DIM RAW iCnt = 0
            DO
               IF *Stk$[iThisToken] = ASC("(") THEN INCR iCnt
               IF *Stk$[iThisToken] = ASC(")") THEN DECR iCnt
               CONCAT (Arg$,Stk$[iThisToken])
               INCR iThisToken
            LOOP UNTIL iCnt <= 0 OR iThisToken >= Ndx
         END IF

         IF *Stk$[iThisToken] = ASC("[") THEN
            DIM RAW iCnt = 0
            DO
               IF *Stk$[iThisToken] = ASC("[") THEN INCR iCnt
               IF *Stk$[iThisToken] = ASC("]") THEN DECR iCnt
               CONCAT (Arg$,Stk$[iThisToken])
               INCR iThisToken
               IF *Stk$[iThisToken] = ASC("[") AND iCnt = 0 THEN ITERATE
            LOOP UNTIL iCnt <= 0 OR iThisToken >= Ndx
         END IF

         IF *Stk$[iThisToken] = ASC(";")    _
            OR *Stk$[iThisToken] = ASC(",") _
            OR *Stk$[iThisToken] = ASC("&") THEN
            INCR Argcount
            INCR NextArgcount
            Stak[Argcount].Arg$ = Arg$
            Stak[NextArgcount].ArgType = (-1)
            Arg$ = ""
            INCR iThisToken
         ELSE
            CONCAT (Arg$,Stk$[iThisToken])
            INCR iThisToken
         END IF
      ELSE
         CONCAT(Arg$,Stk$[iThisToken])
         INCR iThisToken
      END IF
   LOOP

   INCR Argcount
   INCR NextArgcount
   Stak[Argcount].Arg$ = Arg$
   Arg$ = ""

   FOR iThisToken = 1 TO Argcount

      iVarType = Stak[iThisToken].ArgType
      IF iVarType = (-1) THEN
         LZZ$ = EXTRACT$(Stak[iThisToken].Arg$,"(")
         iVarType = DataType(LZZ$)
      END IF

      IF iVarType = vt_INTEGER THEN
         DIM RAW A, indx : A = CheckLocal(LZZ$, &indx)

         IF A = vt_UNKNOWN THEN
            A = CheckGlobal(LZZ$, &indx)
            IF A <> vt_UNKNOWN THEN
               iVarType = GlobalVars[indx].VarType
            END IF
         ELSE
            iVarType = LocalVars[indx].VarType
         END IF

      END IF

      SELECT CASE iVarType

         CASE vt_STRLIT, vt_STRVAR, vt_CHAR
         IF DoWrite THEN
            Frmat$ = Frmat$ + "\\" + DQ$ + "%s" + "\\" + DQ$ + ","
         ELSE
            CONCAT (Frmat$,"%s")
         END IF
         IF LEFTSTR(LZZ$,"BCX_DynaCall") THEN
            Arg$ = Arg$ + ",(char*)" + Stak[iThisToken].Arg$
         ELSE
            Arg$ = Arg$ + "," + Stak[iThisToken].Arg$
         END IF

         CASE vt_INTEGER, vt_DECFUNC
         IF DoWrite THEN
            CONCAT (Frmat$,"%d,")
         ELSE
            CONCAT (Frmat$,"% d")
         END IF
         Arg$ = Arg$ + ",(int)" + Stak[iThisToken].Arg$

         CASE vt_LLONG
         IF DoWrite THEN
            CONCAT (Frmat$,"%lli,")
         ELSE
            CONCAT (Frmat$,"% lli")
         END IF
         Arg$ = Arg$ + ",(long long)" + Stak[iThisToken].Arg$

         CASE vt_ULONGLONG
         IF DoWrite THEN
            CONCAT (Frmat$,"%llu,")
         ELSE
            CONCAT (Frmat$,"% llu")
         END IF
         Arg$ = Arg$ + ",(unsigned long long)" + Stak[iThisToken].Arg$

         CASE vt_SINGLE
         IF DoWrite THEN
            CONCAT (Frmat$,"%.7G,")
         ELSE
            CONCAT (Frmat$,"% .7G")
         END IF
         Arg$ = Arg$ + ",(float)" + Stak[iThisToken].Arg$

         CASE vt_DOUBLE, vt_NUMBER
         IF DoWrite THEN
            CONCAT (Frmat$,"%.15G,")
         ELSE
            CONCAT (Frmat$,"% .15G")
         END IF
         Arg$ = Arg$ + ",(double)" + Stak[iThisToken].Arg$

         CASE vt_LDOUBLE
         IF DoWrite THEN
            CONCAT (Frmat$,"%.19LG,")
         ELSE
            CONCAT (Frmat$,"% .19LG")
         END IF
         Arg$ = Arg$ + ",(LDOUBLE)" + Stak[iThisToken].Arg$

         CASE ELSE

         IF ASC(Stak[iThisToken].Arg$) = ASC("(") THEN
            LZZ$ = ""
            CONCAT(Arg$,",")

            DO
               DIM RAW iParentheses = INCHR(Stak[iThisToken].Arg$,")")
               PWF_Cast$ = MID$(Stak[iThisToken].Arg$, 1, iParentheses++)
               Stak[iThisToken].Arg$ = TRIM$(MID$(Stak[iThisToken].Arg$,iParentheses))

               IREPLACE "char*"      WITH  "char *"             IN PWF_Cast$
               IREPLACE "lpstr"      WITH  "char *"             IN PWF_Cast$
               IREPLACE "integer"    WITH  "int"                IN PWF_Cast$
               IREPLACE "single"     WITH  "float"              IN PWF_Cast$
               IREPLACE "ldouble"    WITH  "LDOUBLE"            IN PWF_Cast$
               IREPLACE "ulonglong"  WITH  "unsigned long long" IN PWF_Cast$
               IREPLACE "longlong"   WITH  "long long"          IN PWF_Cast$
               IREPLACE "llong"      WITH  "long long"          IN PWF_Cast$
               IREPLACE "long long"  WITH  "long long"          IN PWF_Cast$

               IF ISNULL(LZZ$) THEN
                  IF iMatchNQ("(char *)(int)(float)(double)(LDOUBLE)(long long)(unsigned long long)", PWF_Cast$) THEN
                     LZZ$ = PWF_Cast$
                  ELSE
                     LZZ$ = "(double)"
                     PWF_Cast$ = LZZ$ + PWF_Cast$
                  END IF
                  RemoveAll(LZZ$,"()")
                  IREPLACE "char *"              WITH "%s"       IN  LZZ$
                  IREPLACE "int"                 WITH "% d"      IN  LZZ$
                  IREPLACE "float"               WITH "% .7G"    IN  LZZ$
                  IREPLACE "ldouble"             WITH "% .19LG"  IN  LZZ$
                  IREPLACE "double"              WITH "% .15G"   IN  LZZ$
                  IREPLACE "long long"           WITH "% lli"    IN  LZZ$
                  IREPLACE "unsigned long long"  WITH "% llu"    IN  LZZ$
               END IF

               CONCAT(Arg$,PWF_Cast$)
            LOOP WHILE ASC(Stak[iThisToken].Arg$) = c_LPar

            CONCAT(Arg$, Stak[iThisToken].Arg$)
            CONCAT (Frmat$,LZZ$)

            IF DoWrite THEN CONCAT (Frmat$, ",")
         ELSE
            IF DoWrite THEN
               CONCAT(Frmat$, "%G,")
            ELSE
               CONCAT (Frmat$, "% G")
               Arg$ = Arg$ + ",(float)" + Stak[iThisToken].Arg$
            END IF
         END IF

      END SELECT
   NEXT

   IF DoWrite THEN Frmat$ = LEFT$(Frmat$, LEN(Frmat$)-1)

   '*********************
   PrintWriteLabel:
   '*********************

   IF SuppressCRLF = FALSE THEN
      CONCAT (Frmat$, "\\n")
   END IF
   FUNCTION = "printf(" + ENC$(Frmat$) + Clean$(Arg$) + ");"
END FUNCTION ' PrintWriteFormat$





SUB InputBufferFlags
   ' *********************************************************************
   ' Called by
   '   "finput" - EmitFileInputCode - InputBufferFlags
   '   "input"  - EmitInputCode     - CommonInputCode  - InputBufferFlags
   ' *********************************************************************
   IF NOT Use_Inputbuffer THEN
      Use_Inputbuffer = TRUE
      Use_BcxTmpStr   = TRUE
      Use_Scan        = TRUE
      Use_Proto       = TRUE
      Use_Split       = TRUE
      Use_Replace     = TRUE
      Use_Remove      = TRUE
      Use_Mid         = TRUE
      Use_Left        = TRUE
      Use_Instr       = TRUE
      Use_Stristr     = TRUE
      Use_UCaseTbl    = TRUE
   END IF
END SUB ' InputBufferFlags




SUB CommonInputCode(Frmat$, Arg$)
   DIM RAW Argcount = 0
   DIM RAW iThisToken
   DIM RAW iVarType
   DIM RAW szParamToken$
   DIM LOCAL Stak$[128]

   CALL InputBufferFlags

   Arg$   = ""
   Frmat$ = ""
   iThisToken = 1

   DO WHILE iThisToken <= Ndx
      IF Stk$[iThisToken] = "," THEN
         INCR Argcount
         Stak$[Argcount]= Arg$
         Arg$ = ""
         INCR iThisToken
      ELSE
         CONCAT (Arg$, Stk$[iThisToken])
         INCR iThisToken
         IF iThisToken < Ndx THEN
            DIM RAW iCnt = TALLY(Arg$,"[")-TALLY(Arg$,"]")
            DO WHILE iCnt
               CONCAT (Arg$,Stk$[iThisToken])
               INCR iThisToken
               iCnt = TALLY(Arg$,"[")-TALLY(Arg$,"]")
            LOOP
         END IF
      END IF
   LOOP

   INCR Argcount
   Stak$[Argcount] = Arg$
   Arg$ = ""

   FOR iThisToken = 1 TO Argcount
      szParamToken$ = Stak$[iThisToken]
      iVarType = CheckType(szParamToken$)

      IF iVarType = vt_UDT OR iVarType = vt_STRUCT OR iVarType = vt_UNION THEN
         iVarType = DataType(szParamToken$)
      ELSE
         DIM RAW iCnt = INCHR(szParamToken$,"[")
         IF iCnt THEN *(--iCnt+szParamToken) = 0
         iVarType  = DataType(szParamToken$)
      END IF

      szParamToken$ = Clean$(Stak$[iThisToken])

      IF IM_UDT_STRING(szParamToken$) THEN iVarType = vt_STRVAR           ' MrBcx 789
      IF IM_UDT_SINGLE(szParamToken$) THEN iVarType = vt_SINGLE           ' MrBcx 789
      IF IM_UDT_DOUBLE(szParamToken$) THEN iVarType = vt_DOUBLE           ' MrBcx 789

      IF CheckType (szParamToken$) = vt_STRVAR THEN iVarType = vt_STRVAR  ' MrBcx 789
      IF CheckType (szParamToken$) = vt_SINGLE THEN iVarType = vt_SINGLE  ' MrBcx 789
      IF CheckType (szParamToken$) = vt_DOUBLE THEN iVarType = vt_DOUBLE  ' MrBcx 789
      IF CheckType (szParamToken$) = vt_LDOUBLE THEN iVarType = vt_LDOUBLE ' MrBcx 789

      SELECT CASE iVarType

         CASE vt_STRVAR
         CONCAT (Frmat$,"%s")
         Arg$ = Arg$ + "," + szParamToken$
         FPRINT Outfile, Scoot$, "*",TRIM$(szParamToken$),"=0, ";

         CASE vt_INTEGER
         CONCAT (Frmat$,"%d")
         Arg$ = Arg$ + ",&" + szParamToken$
         FPRINT Outfile, Scoot$, szParamToken$,"=0, ";

         CASE vt_SINGLE
         CONCAT (Frmat$,"%g")
         Arg$ = Arg$ + ",&" + szParamToken$
         FPRINT Outfile, Scoot$, szParamToken$,"=0, ";

         CASE vt_DOUBLE
         CONCAT (Frmat$,"%lG")
         Arg$ = Arg$ + ",&" + szParamToken$
         FPRINT Outfile, Scoot$, szParamToken$,"=0, ";

         CASE vt_LDOUBLE
         CONCAT (Frmat$,"%lG")
         Arg$ = Arg$ + ",&" + szParamToken$
         FPRINT Outfile, Scoot$, szParamToken$,"=0, ";

         CASE ELSE
         CONCAT (Frmat$,"%d")
         Arg$ = Arg$ + ",&" + szParamToken$
         FPRINT Outfile, Scoot$,szParamToken$,"=0, ";

      END SELECT
   NEXT
END SUB 'CommonInputCode





SUB EmitInputCode
   DIM RAW Frmat$, Arg$, szWrk$
   DIM RAW iThisToken = 2

   IF DataType(Stk$[iThisToken]) = vt_STRLIT THEN
      FPRINT Outfile, Scoot$,"printf(", Clean$(Stk$[iThisToken]), "), " ;
      iThisToken = 4
   END IF

   FOR INT i = 1 TO Ndx                                             ' MrBcx 789
      IF IM_UDT_STRING(Stk$[i]) THEN CONCAT(Stk$[i],"$")            ' MrBcx 789
      IF IM_UDT_SINGLE(Stk$[i]) THEN CONCAT(Stk$[i],"!")            ' MrBcx 789
      IF IM_UDT_DOUBLE(Stk$[i]) THEN CONCAT(Stk$[i],"#")            ' MrBcx 789

      IF CheckType (Stk$[i]) = vt_STRVAR THEN CONCAT(Stk$[i],"$")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_SINGLE THEN CONCAT(Stk$[i],"!")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_DOUBLE THEN CONCAT(Stk$[i],"#")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_LDOUBLE THEN CONCAT(Stk$[i],"#")  ' MrBcx 789
   NEXT                                                             ' MrBcx 789

   CALL BuildStr(iThisToken, Ndx, szWrk$)
   FastLexer(szWrk$, "", ",")
   CALL CommonInputCode(Frmat$, Arg$)

   Use_KBinput = Use_Scan = TRUE
   FPRINT Outfile, Scoot$, "KBinput(),";
   FPRINT Outfile, Scoot$, "ScanError=scan(InputBuffer,",ENC$(Frmat$),Arg$,");"
END SUB ' EmitInputCode





SUB EmitFileInputCode
   DIM RAW Arg$
   DIM RAW Frmat$
   DIM RAW szWrk$
   DIM RAW iThisToken
   DIM RAW FHandle$ = ""

   CALL InputBufferFlags

   iThisToken = 4                         ' Extract the file handle
   FOR INT j = 2 TO Ndx
      IF *Stk$[j] = ASC(",") THEN iThisToken = j+1 : EXIT FOR
      CONCAT (FHandle$, Stk$[j])
   NEXT

   FOR INT i = 1 TO Ndx                                             ' MrBcx 789
      IF IM_UDT_STRING(Stk$[i]) THEN CONCAT(Stk$[i],"$")            ' MrBcx 789
      IF IM_UDT_SINGLE(Stk$[i]) THEN CONCAT(Stk$[i],"!")            ' MrBcx 789
      IF IM_UDT_DOUBLE(Stk$[i]) THEN CONCAT(Stk$[i],"#")            ' MrBcx 789

      IF CheckType (Stk$[i]) = vt_STRVAR THEN CONCAT(Stk$[i],"$")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_SINGLE THEN CONCAT(Stk$[i],"!")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_DOUBLE THEN CONCAT(Stk$[i],"#")   ' MrBcx 789
      IF CheckType (Stk$[i]) = vt_LDOUBLE THEN CONCAT(Stk$[i],"#")  ' MrBcx 789
   NEXT                                                             ' MrBcx 789

   CALL BuildStr(iThisToken, Ndx, szWrk$) ' build the variable list
   FastLexer(szWrk$, "", ",")
   CALL CommonInputCode(Frmat$, Arg$)

   FPRINT Outfile, Scoot$, "fgets(InputBuffer, 0x100000,", FHandle$, ");"
   FPRINT Outfile, Scoot$, "if(InputBuffer[strlen(InputBuffer)-1] == 10)"
   FPRINT Outfile, Scoot$, "   InputBuffer[strlen(InputBuffer)-1] = 0;"
   FPRINT Outfile, Scoot$, "ScanError=scan(InputBuffer,",ENC$(Frmat$),Arg$,");"
   FPRINT Outfile, Scoot$, "*InputBuffer=0;"
END SUB ' EmitFileInputCode






SUB FinishingTouches
   IF Use_Project = FALSE THEN
      DIM  Accum= Use_BCXMDialog
      INCR Accum, Use_BCXDialog
      INCR Accum, Use_Form
      INCR Accum, Use_Button
      INCR Accum, Use_BmpButton
      INCR Accum, Use_Edit
      INCR Accum, Use_BCX_Input
      INCR Accum, Use_Label
      INCR Accum, Use_Group
      INCR Accum, Use_Checkbox
      INCR Accum, Use_Radio
      INCR Accum, Use_Combobox
      INCR Accum, Use_Listbox
      INCR Accum, Use_Treeview
      INCR Accum, Use_Blackrect
      INCR Accum, Use_Whiterect
      INCR Accum, Use_Grayrect
      INCR Accum, Use_Datepick
      INCR Accum, Use_Richedit
      INCR Accum, Use_Bitmap
      INCR Accum, Use_BCX_OlePicture
      INCR Accum, Use_Icon
      INCR Accum, Use_Listview
      INCR Accum, Use_BCX_Control
      INCR Accum, Use_ProgressBar
      INCR Accum, Use_BCX_Slider
      INCR Accum, Use_BCX_Splitter
      INCR Accum, Use_BCX_Tab
      INCR Accum, Use_BCX_Toolbar
      INCR Accum, Use_BCX_UpDown
      INCR Accum, Use_Set_BCX_Icon
      INCR Accum, Use_BCX_FrameWnd
      INCR Accum, Use_BCX_Wnd
      INCR Accum, Use_BCX_SetIcon
      INCR Accum, Use_BCX_SetIconSm
      INCR Accum, Use_BCX_SetCursor
      INCR Accum, Use_BCX_RegWnd
      INCR Accum, Use_BCX_InitGUI
      IF Accum THEN
         CALL AddBCX_hInstance
         CALL AddFontVariables
      END IF
   END IF
END SUB






SUB AssembleParts
   DIM RAW LTmp1$
   DIM P1$, P2$, P3$, P4$, P5$, P6$, P7$, P8$

   DoCountLines = TRUE

   CALL FinishingTouches

   IF EXIST("$WRK$.TXT") THEN KILL "$WRK$.TXT"
   RENAME FileOut$, "$WRK$.TXT"

   IF ISNULL(CmdLineFileOut$) THEN
      IF UseCpp THEN
         GTmpStr$ = EXTRACT$(FileOut$,".") + ".cpp"
         KILL GTmpStr$
         FileOut$ = GTmpStr$
      ELSE
         GTmpStr$ = EXTRACT$(FileOut$,".") + ".c"
         KILL GTmpStr$
         FileOut$ = GTmpStr$
      END IF
   END IF

   OPEN FileOut$ FOR OUTPUT AS FP_W
   CALL EmitProlog(FP_W)
   CALL Commandline_Defines(FP_W)
   CALL System_Defined_Constants(FP_W)
   CALL User_Defined_Constants(FP_W)
   CALL EmitUserDirectives(FP_W)
   CALL User_GLOBAL_ENUM_Blocks(FP_W)

   IF Use_Project = FALSE THEN
      IF Use_SingleFile = FALSE THEN
         OPEN HFile$ FOR OUTPUT AS FP_HeaderFile
      END IF
   END IF

   '*********************************************************************************************
   CALL StdProtos(FP_W)                       ' MrBcx 786 - I swapped the order to enable the
   CALL User_Defined_Types_And_Unions(FP_W)   ' use of BASIC runtime library inside a C++ CLASS.
   '*********************************************************************************************

   CALL SYSTEM_VARIABLES(FP_W)

   IF Use_COM THEN
      EmitCOMSupportTypes(FP_W)
   END IF

   CALL User_Global_Variables(FP_W)
   CALL User_Data_Statements(FP_W)
   CALL AddMacros(FP_W)
   CALL User_Prototypes(FP_W)
   CALL User_Global_Initialized_Arrays(FP_W)
   CALL User_Overloaded_SubsFunctions(FP_W)
   CALL User_GLOBAL_SET_Statements(FP_W)

   IF Use_SingleFile = FALSE THEN
      CLOSE FP_HeaderFile
   END IF

   IF Use_SingleFile AND Use_Project = FALSE THEN
      CALL RunTimeFunctions(FP_W)
   ELSE
      IF Use_Project = FALSE THEN
         CALL SetFlags      ' Write to Project$
      END IF
   END IF

   '***************************************************************
   DIM RAW bMain = (Use_Wingui + MakeDLL + NoMain) AS BOOL
   DIM RAW bMainOut = FALSE  AS BOOL
   '***************************************************************

   IF LOF(cppFile$) THEN
      FPRINT FP_W, ""
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, "//                   User's C code"
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, ""

      OPEN cppFile$ FOR INPUT AS FP_R

      DO WHILE NOT EOF(FP_R)
         LINE INPUT FP_R, LTmp1$
         FPRINT FP_W, LTmp1$
      LOOP

      CLOSE FP_R
   END IF


   IF EXIST(prcFile$) AND LOF(prcFile$)>2 THEN
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, "//            User's Subs and Functions"
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, ""

      '***************************************************
      IF UseCpp THEN
         P1$ = CHR$(99, 111, 117, 116, 60, 60)                   '   "cout<<"
         P2$ = CHR$(99, 111, 117, 116, 32, 60, 60, 32)           '   "cout << "
         P3$ = CHR$(99, 105, 110, 60, 60)                        '   "cin<<"
         P4$ = CHR$(99, 105, 110, 32, 60, 60, 32)                '   "cin << "
         P5$ = CHR$(60, 60, 115, 116, 100, 58, 58)               '   "<<std::"
         P6$ = CHR$(32, 60, 60, 32, 115, 116, 100, 58, 58)       '   " << std::"
         P7$ = CHR$(60, 60, 101, 110, 100, 108)                  '   "<<endl"
         P8$ = CHR$(32, 60, 60, 32, 101, 110, 100, 108)          '   " << endl"
      END IF
      '***************************************************

      OPEN prcFile$ FOR INPUT AS FP_R       ' translated subs and functions

      DO WHILE NOT EOF(FP_R)
         LINE INPUT FP_R, LTmp1$
         '***************************************************
         ' Simple patch to support Unicode Lexer (ULEX.exe)
         '***************************************************
         IF UseCpp THEN
            REPLACE P1$ WITH P2$ IN LTmp1$
            REPLACE P3$ WITH P4$ IN LTmp1$
            REPLACE P5$ WITH P6$ IN LTmp1$
            REPLACE P7$ WITH P8$ IN LTmp1$
         END IF
         '***************************************************
         FPRINT FP_W, LTmp1$
         IF bMainOut THEN ITERATE
         bMainOut = CheckForMain(LTmp1$, bMain)
      LOOP
      CLOSE FP_R
   END IF

   IF Use_Wingui = FALSE AND NoMain = FALSE THEN
      FPRINT FP_W, ""
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, "//                  ",BCX_STR_MAIN_PROG$
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, ""
   END IF

   OPEN "$WRK$.TXT" FOR INPUT AS FP_R

   DO WHILE NOT EOF(FP_R)
      LINE INPUT FP_R,LTmp1$
      IF iMatchNQ (LTmp1$, "int main") THEN
         IF bMain THEN
            ITERATE
         END IF
      END IF
      FPRINT FP_W,Scoot$, LTmp1$
      IF bMainOut THEN ITERATE
      bMainOut = CheckForMain(LTmp1$, bMain)
   LOOP

   CLOSE FP_R
   KILL "$WRK$.TXT"

   CLOSE FP_W
   DoCountLines = FALSE
END SUB ' AssembleParts





FUNCTION CheckForMain(ArgStr$, bMain AS BOOL)
   DIM RAW bMainOut = FALSE
   DIM RAW LTmp1$
   DIM RAW LZZ$

   IF iMatchNQ (ArgStr$, "main") THEN      ' MrBcx 786
      LZZ$ = LTRIM$(ArgStr$)
      Scoot$ = SPACE$(2)

      IF LEFTSTR(LZZ$,"int main") _
         OR LEFTSTR(LZZ$,"int WINAPI WinMain") _
         OR LEFTSTR(LZZ$,"__declspec(dllexport) BOOL WINAPI DllMain") _
         OR LIKE (LZZ$,"*__stdcall*DllMain*(HINSTANCE *,*") THEN

         IF bMain = FALSE THEN
            FPRINT FP_W, "{"        ' OPEN the main FUNCTION
         END IF

         IF bMain THEN
            LINE INPUT FP_R, LTmp1$
            FPRINT FP_W, LTmp1$
         END IF

         IF Use_Console THEN
            FPRINT FP_W, Scoot$, "hConsole=GetStdHandle(STD_OUTPUT_HANDLE);"
         END IF

         IF Use_StartupCode THEN
            FPRINT FP_W, Scoot$, "int BCX_SUCode=BCX_StartupCode_();  // execute user's startup code"
         END IF

         IF Use_ExitCode THEN
            FPRINT FP_W, Scoot$, "int BCX_EXCode=BCX_ExitCode_();     // Prepare for user's exit code"
         END IF

         IF Use_LCaseTbl THEN
            FPRINT FP_W, Scoot$, "LowCase=(unsigned char*)calloc(257,1), LowCase = MakeLCaseTbl();"
         END IF

         IF Use_UCaseTbl THEN
            FPRINT FP_W, Scoot$, "UprCase=(unsigned char*)calloc(257,1), UprCase = MakeUCaseTbl();"
         END IF

         IF DllCnt THEN
            DIM LOCAL szLoadLibHandle$
            DIM LOCAL LTmp$
            DIM LOCAL i

            FPRINT FP_W,Scoot$, ""
            FPRINT FP_W,Scoot$, "// **********[ DLL Declarations ]**********"
            FPRINT FP_W,Scoot$, ""

            '------------------------------------------------------------------------
            ' Emit LoadLibrary assignments
            ' HMODULE  H_DLLNAME = LoadLibrary("DLLNAME.DLL");
            ' Todo: Add a check for H_DLLNAME = NULL in case of failure to load the DLL.
            '------------------------------------------------------------------------

            IF Use_LoadLibraryError THEN
               FPRINT FP_W,Scoot$, "FILE   *FPLoadLibraryErrorLog;"
               DIM RAW Op$ :  Op$ = ENC$("w")
               IF UseFileTest THEN
                  FPRINT FP_W, Scoot$, "if((FPLoadLibraryErrorLog=fopen(",LibraryErrorLog$,",",Op$,"))==0)"
                  FPRINT FP_W, Scoot$, " {"
                  LTmp$ = ENC$("Can't open file %s\\n")
                  FPRINT FP_W, Scoot$, "fprintf(stderr,",LTmp$,",",LibraryErrorLog$,");exit(1);"
                  FPRINT FP_W, Scoot$, " }"
               ELSE
                  FPRINT FP_W, Scoot$, "FPLoadLibraryErrorLog=fopen(",ENC$(LibraryErrorLog$),",",Op$,");"
               END IF
            END IF

            LTmp$ = ENC$("[%s %s] Failed to load %s\\n")

            FOR i = 1 TO LoadLibsCnt
               szLoadLibHandle$ = "H_" + UCASE$(RemoveExtension$(Loadlibs$[i]))

               IF (INCHR(szLoadLibHandle$,"-")) OR (INCHR(szLoadLibHandle$,".")) THEN
                  szLoadLibHandle$ = REPLACE$(szLoadLibHandle$, "-.", "_")
                  szLoadLibHandle$ = REPLACE$(szLoadLibHandle$, "-",  "_")
               END IF

               FPRINT FP_W, Scoot$, "HMODULE  ",szLoadLibHandle$," = LoadLibrary(", ENC$(Loadlibs$[i]), ");"

               IF Use_LoadLibraryError THEN
                  FPRINT FP_W, Scoot$, "if(",szLoadLibHandle$,"==NULL) {"
                  FPRINT FP_W, Scoot$, "  fprintf(FPLoadLibraryErrorLog, ",LTmp$,",date(),timef(0,0),",ENC$(Loadlibs$[i]),");"
                  FPRINT FP_W, Scoot$, "  }"
               END IF
            NEXT

            LTmp$ = ENC$("[%s %s] Failed to find process %s\\n")

            FOR i = 1 TO DllCnt
               FPRINT FP_W, Scoot$, DllDecl$[i]    ' Emit the user's DLL Declarations
               IF Use_LoadLibraryError THEN
                  DIM RAW iEQ
                  DIM RAW szProcAddress$
                  iEQ = INCHR(DllDecl$[i],"=")-1
                  szProcAddress$ = LEFT$(DllDecl$[i],iEQ)
                  FPRINT FP_W, Scoot$, "if(",szProcAddress$,"==NULL) {"
                  FPRINT FP_W, Scoot$, "  fprintf(FPLoadLibraryErrorLog, ",LTmp$,",date(),timef(0,0),",ENC$(szProcAddress$),");"
                  FPRINT FP_W, Scoot$, "  }"
               END IF
            NEXT

            IF Use_LoadLibraryError THEN
               FPRINT FP_W, Scoot$, "fclose(FPLoadLibraryErrorLog);"
            END IF

            FPRINT FP_W,Scoot$, ""
            FPRINT FP_W,Scoot$, "// ****************************************"
            FPRINT FP_W,Scoot$, ""
         END IF
         bMainOut = TRUE
      END IF
   END IF
   FUNCTION = bMainOut
END FUNCTION  ' CheckForMain



FUNCTION RemoveExtension$(f$)
   DIM RAW i AS INT
   i = (INT) IIF((INT)INCHR(f$,"."),(INT)INSTRREV(f$,".",0)-1,LEN(f$))
   FUNCTION = LEFT$(f$,i)
END FUNCTION



FUNCTION CheckGlobal(szVariable$, BYREF varidx)
   DIM RAW iHasValue, iTokenLoc, szWork$, iBrack
   szWork$ = szVariable$
   RemoveAll(szWork$, "%$#!@`&*( )", 1)
   iBrack = INCHR(szWork$,"[")
   IF iBrack THEN *(--iBrack + szWork) = 0    ' This cleverly trims (everything) starting at the first "["
   iHasValue = HashNumber(szWork$)
   DO WHILE GlobalVarHash[iHasValue]
      iTokenLoc = GlobalVarHash[iHasValue]
      IF szWork$ = GlobalVars[iTokenLoc].VarName$ THEN
         varidx  = iTokenLoc
         FUNCTION = GlobalVars[iTokenLoc].VarType
      END IF
      INCR iHasValue
      iHasValue = IMOD(iHasValue,MaxGlobalVars)
   LOOP
   FUNCTION = vt_UNKNOWN
END FUNCTION ' CheckGlobal



FUNCTION CheckLocal(szVariable$, BYREF varidx)
   DIM RAW szWork$, iBrack, iTokenLoc
   IF LocalVarCnt THEN
      szWork$ = szVariable$
      RemoveAll(szWork$, "%$#!@`&*( )", 1)
      iBrack = INCHR(szWork$,"[")
      IF iBrack THEN *(--iBrack + szWork) = 0
      FOR iTokenLoc = LocalVarCnt TO 1 STEP -1
         IF szWork$ = LocalVars[iTokenLoc].VarName$ THEN
            varidx  = iTokenLoc
            FUNCTION = LocalVars[iTokenLoc].VarType
         END IF
      NEXT
   END IF
   FUNCTION = vt_UNKNOWN
END FUNCTION ' CheckLocal



FUNCTION CheckType(ParamStr$)
   DIM RAW Keyword$, varid, i
   Keyword$ = TRIM$(LCASE$(ParamStr$))
   i = FindWord (Keyword$, tTypes, WordsInTable(tTypes))
   IF i <> NOTFOUND THEN FUNCTION = tTypes[i].iType
   i = CheckLocal(ParamStr$, &varid)
   IF i = vt_UNKNOWN THEN
      i = CheckGlobal(ParamStr$, &varid)
      IF i = vt_UNKNOWN THEN
         i = DefsID(ParamStr$)
         IF i THEN i = TypeDefs[i].TypeofDef
      END IF
   END IF
   FUNCTION = i
END FUNCTION ' CheckType



SUB ExportStringConst
   DIM RAW FP_SAVE AS FILE
   FP_SAVE = FP_CST
   FP_CST  = FP_SYSCST
   Src$ = "MACRO BCXSTRSIZE=" + STR$ (BCXSTRINGS)
   PassOne = TRUE
   INJECT(Src$)
   FP_CST = FP_SAVE
END SUB



SUB ExportInternalConst
   IF Use_FillArray THEN
      DIM RAW FP_SAVE AS FILE
      FP_SAVE = FP_CST
      FP_CST = FP_SYSCST
      Src$="MACRO vt_INTEGER =  2"
      PassOne = TRUE
      INJECT(Src$)
      Src$="MACRO vt_SINGLE  =  3"
      PassOne = TRUE
      INJECT(Src$)
      Src$="MACRO vt_DOUBLE  =  4"
      PassOne = TRUE
      INJECT(Src$)
      Src$="MACRO vt_LDOUBLE =  5"
      PassOne = TRUE
      INJECT(Src$)
      FP_CST = FP_SAVE
   END IF
END SUB ' ExportInternalConst



FUNCTION RestrictedWords(ParamStr$)
   IF iMatchNQ("cmdlinecmdshowhinsthprevhwndlparammsgwparamvt_integervt_singlevt_doublevt_ldouble", ParamStr$) THEN
      IF ParamStr$ = "CmdLine"    THEN FUNCTION = 1
      IF ParamStr$ = "CmdShow"    THEN FUNCTION = 1
      IF ParamStr$ = "hInst"      THEN FUNCTION = 1
      IF ParamStr$ = "hPrev"      THEN FUNCTION = 1
      IF ParamStr$ = "hWnd"       THEN FUNCTION = 1
      IF ParamStr$ = "lParam"     THEN FUNCTION = 1
      IF ParamStr$ = "Msg"        THEN FUNCTION = 1
      IF ParamStr$ = "wParam"     THEN FUNCTION = 1
      IF ParamStr$ = "vt_INTEGER" THEN FUNCTION = 1
      IF ParamStr$ = "vt_SINGLE"  THEN FUNCTION = 1
      IF ParamStr$ = "vt_DOUBLE"  THEN FUNCTION = 1
      IF ParamStr$ = "vt_LDOUBLE" THEN FUNCTION = 1
   END IF
   FUNCTION = 0
END FUNCTION ' RestrictedWords



FUNCTION DataType(ParamStr$)
   DIM RAW Keyword$
   DIM RAW i

   IF ParamStr[0] = c_DblQt THEN
      FUNCTION = vt_STRLIT
   END IF

   IF INCHR(ParamStr$,"$") THEN
      FUNCTION = vt_STRVAR
   END IF

   IF IsNumber(ParamStr$) THEN
      FUNCTION = vt_NUMBER
   END IF

   i = DefsID(ParamStr$)
   IF i THEN
      FUNCTION = TypeDefs[i].TypeofDef
   END IF

   '****************
   '   Functions
   '****************

   Keyword$ = LCASE$(ParamStr$)
   i = FindWord(Keyword$, tBcxWords, WordsInTable(tBcxWords))
   IF i <> NOTFOUND THEN FUNCTION = tBcxWords[i].iType

   IF INCHR(ParamStr$,"%") THEN
      FUNCTION = vt_INTEGER
   END IF

   IF INCHR(ParamStr$,"!") THEN
      FUNCTION = vt_SINGLE
   END IF

   IF INCHR(ParamStr$,"#") THEN
      FUNCTION = vt_DOUBLE
   END IF

   IF INCHR(ParamStr$,"^") THEN
      FUNCTION = vt_DOUBLE
   END IF

   IF INCHR(ParamStr$,"`") THEN
      FUNCTION = vt_LDOUBLE
   END IF

   IF iMatchRgt(ParamStr$,"@") THEN
      FUNCTION = vt_FILEPTR
   END IF

   IF INCHR(ParamStr$,SPC$) THEN
      FUNCTION = vt_UDT
   END IF

   IF isalpha(*ParamStr$) THEN
      FUNCTION = vt_INTEGER
   END IF

   FUNCTION = vt_UNKNOWN
END FUNCTION ' DataType



SUB CloseAll
   IF PPDLL_HANDLE THEN
      FreeLibrary(PPDLL_HANDLE)
      PPDLL_HANDLE = NULL
      PPProc = NULL
   END IF
   CLOSE ' Flush and Close all open files
END SUB ' CloseAll



FUNCTION Clean$(ParmStr$)            ' Originally named 'Clean$'
   DIM RAW LTmp$
   IF INCHR(ParmStr$,"%") THEN
      IF TRIM$(ParmStr$) = "%" THEN FUNCTION = " % "
   END IF
   IF iMatchNQ(ParmStr$,"!=") THEN FUNCTION = ParmStr$
   LTmp$ = ParmStr$
   RemoveAll(LTmp$, VARTYPES$, 1)       ' 1 = ignore anything in quotes
   FUNCTION = LTmp$
END FUNCTION ' Clean$




SUB RemoveAll (ParamStr$, MatchChars$ AS LPCTSTR, qtflag=0)
   DIM RAW C   = ParamStr AS PCHAR
   DIM RAW pmc = NULL     AS PCHAR
   DO WHILE NOTNULL(ParamStr$)
      IF qtflag THEN                   ' qtflag = 1 means ignore anything in quotes
         IF *ParamStr = c_DblQt THEN
            *(C++) = *ParamStr
            DO WHILE *(++ParamStr) <> c_DblQt
               *(C++) = *ParamStr
               IF ISNULL(ParamStr$) THEN EXIT SUB
            LOOP
            *(C++) = *(ParamStr++)
            ITERATE
         END IF
      END IF
      pmc = (PCHAR)MatchChars
      DO WHILE *pmc
         IF *(pmc++) = *ParamStr THEN GOTO SKIP
      LOOP
      *(C++) = *ParamStr
      SKIP:
      INCR ParamStr
   LOOP
   *C = 0
END SUB




SUB WarningID (iWarning, WarnLvl=0)
   SELECT CASE iWarning
      CASE eExitingMoreThan1Loop
      CALL Warning("Exiting more than one loop", WarnLvl)
   END SELECT
END SUB




SUB Warning (ParmStr$, WarnLvl=0)
   LOCAL fErr AS FILE
   IF WarnLvl THEN
      WarnMsg$ = WarnMsg$ + " Line" + STR$(LineNum[FileNdx]) + _
      " in Module: " +  TRIM$(FileNames$[FileNdx]) + " - " + ParmStr$
   ELSE
      CONCAT (WarnMsg$, ParmStr$)
   END IF
   WarnMsg$ = WarnMsg$ + CRLF$ + CRLF$
   IF ErrFile THEN
      OPEN FileErr$ FOR APPEND AS fErr
      FPRINT fErr, "WARNING ",ParmStr$
      CLOSE fErr
   END IF
END SUB ' Warnings








FUNCTION HashNumber(HT$)
   DIM RAW TT = HT AS PCHAR
   DIM RAW i  =  0 AS ULONG
   DO WHILE *TT
      i <<= 1
      i = i XOR (*TT)
      INCR TT
   LOOP
   FUNCTION = IMOD(i,MaxGlobalVars)
END FUNCTION 'HashNumber





SUB AddLibrary (LibName$)
   DIM STATIC nTimes
   DIM LOCAL nLibNdx
   DIM LOCAL TempLibName$

   TempLibName$ = LCASE$(LibName$)

   IF NOT INCHR(TempLibName$,DQ$) AND NOT INCHR(TempLibName$,"<") THEN
      TempLibName$ = ENC$(TempLibName$, 60,62)
   END IF

   IF nTimes = 0 THEN
      FOR INT i = 0 TO MaxLib - 1
         Library$[i] = ""
      NEXT
      INCR nTimes
      Library$[0] = TempLibName$
      EXIT SUB
   END IF

   nLibNdx = 0
   DO WHILE NOTNULL(Library$[nLibNdx])
      IF Library$[nLibNdx] = TempLibName$ THEN EXIT SUB
      INCR nLibNdx
   LOOP

   IF nLibNdx < MaxLib - 1 THEN
      Library$[nLibNdx] = TempLibName$
   ELSE
      CALL Abort("Max libraries exceeded. Currently MaxLib set to" & STR$(MaxLib))
   END IF
END SUB ' AddLibrary





SUB RemoveLibrary (LibName$)
   IF NOT INSTR (RmLibs$, LibName$, 1, 1) THEN
      RmLibs$ = RmLibs$ + "," + LCASE$(LibName$)
   END IF
END SUB ' RemoveLibrary





SUB EmitLibs
   DIM STATIC IWasHere  ' Must remain static
   DIM STATIC nCount    ' Must remain static
   DIM LOCAL  LTmp$

   IF NOT FirstTime(IWasHere) THEN EXIT SUB
   INCR IWasHere
   IF ISNULL(Library$[0]) THEN EXIT SUB

   XFOR INT i = 0 WHILE i < MaxLib AND Library[i][0] BY i++
      LTmp$ = Library$[i]
      RemoveAll(LTmp$, "<>" + DQ$)
      IF INSTR(RmLibs$, LTmp$) THEN ITERATE ' skip libraries that have been removed
      IF nCount = 0 THEN
         INCR nCount
         FPRINT FP_HDR, ""
         FPRINT FP_HDR, "// *************************************************"
         FPRINT FP_HDR, "// Instruct Linker to Search Object/Import Libraries"
         FPRINT FP_HDR, "// *************************************************"
         FPRINT FP_HDR, ""
         FPRINT FP_HDR, "#if !defined(__GNUC__)"
         FPRINT FP_HDR, "   #if !(defined(__BCPLUSPLUS__) && defined(_WIN64))"
         IF ISFALSE UseCpp THEN
            FPRINT FP_HDR, "      #if !defined(__LCC__)"
         END IF
      END IF
      FPRINT FP_HDR, "    #pragma comment(lib,",ENC$(LTmp$), ")"
   XNEXT

   IF ISFALSE UseCpp THEN
      FPRINT FP_HDR, "  #else"
      '***************************************************************************************
      ' add lccwin32's default libraries to the remove library list, so they won't be emitted
      '***************************************************************************************
      CONCAT(RmLibs$, ",<libc.lib>,<kernel32.lib>,<comdlg32.lib>,<user32.lib>,")
      CONCAT(RmLibs$, "<gdi32.lib>,<advapi32.lib>,<comctl32.lib>,<crtdll.lib>")

      XFOR INT i = 0 WHILE i < MaxLib AND Library[i][0] BY i++
         IF INSTR(RmLibs$, Library$[i]) THEN ITERATE ' skip libraries that have been removed
         IF nCount = 0 THEN
            INCR nCount
            FPRINT FP_HDR, "  #if !defined(__LCC__)"
         END IF
         FPRINT FP_HDR, "    #pragma lib ",Library$[i]
      XNEXT
   END IF

   IF NOTZERO (nCount) THEN
      IF ISFALSE UseCpp THEN
         FPRINT FP_HDR, "     #endif"
      END IF
      FPRINT FP_HDR, "  #endif"
      FPRINT FP_HDR, "#endif"
   END IF
END SUB ' EmitLibs





SUB AddGlobal(GlobalName$, GlobalType, GlobalDef=0, GlobalDim$="", GlobalPtr=0, GlobalFS=0, GlobalExtn=0, iEmitted = 0, iConst = 0)
   DIM RAW FirstVar$
   DIM RAW SecondVar$
   DIM RAW Warn$
   DIM RAW GlobalNameHash
   DIM RAW ptGlobal AS VarInfo PTR
   DIM RAW s

   IF Use_Project = TRUE THEN
      IF GlobalExtn = 0 THEN
         GlobalExtn = 2
      END IF
   END IF

   IF RestrictedWords(GlobalName$) AND TestState THEN
      Warn$ = "Restricted Word " + GlobalName$ + " on Line"
      Warn$ = Warn$ + STR$(LineNum[FileNdx]) + " in Module: " + TRIM$(FileNames$[FileNdx])
      CALL Warning(Warn$)
   END IF

   GlobalNameHash = HashNumber(GlobalName$)

   DO WHILE GlobalVarHash[GlobalNameHash]
      s = GlobalVarHash[GlobalNameHash]
      ptGlobal = &GlobalVars[s]
      IF GlobalName$ = ptGlobal->VarName$ THEN
         IF InConditional = 0 OR (InConditional > 0 AND InIfDef$ = ptGlobal->VarCondDef$) THEN
            IF ptGlobal->VarType <> GlobalType OR _
               GlobalDim$ <> ptGlobal->VarDim$ OR _
               ptGlobal->VarDef <> GlobalDef THEN

               $FILL FirstVar$
               "Line" + STR$(LineNum[FileNdx]) + " in Module: "
               TRIM$(FileNames$[FileNdx]) + " : " + GlobalName$
               GlobalDim$ + " as " + GetVarTypeName$(GlobalType)
               SPC$ + TypeDefs[GlobalDef].VarName$
               $FILL

               $FILL SecondVar$
               "Line" + STR$(ptGlobal->VarLine) + " in Module: "
               ptGlobal->VarModule$ + " : " + GlobalName$
               ptGlobal->VarDim$ + " as " + GetVarTypeName$(ptGlobal->VarType)
               SPC$ + TypeDefs[ptGlobal->VarDef].VarName$
               $FILL

               Warn$ = "Two Variables " + FirstVar$ + " previously defined at " + SecondVar$
               CALL Warning(Warn$)
            END IF
            EXIT SUB
         END IF
      END IF
      GlobalNameHash = IMOD(GlobalNameHash + 1, MaxGlobalVars)
   LOOP

   INCR GlobalVarCnt

   IF GlobalVarCnt = MaxGlobalVars THEN
      CALL Abort("Maximum Global Variables reached.")
   END IF

   ptGlobal = &GlobalVars[GlobalVarCnt]
   ptGlobal->VarName$     =  GlobalName$
   ptGlobal->VarType      =  GlobalType
   ptGlobal->VarDef       =  GlobalDef
   ptGlobal->VarDim$      =  GlobalDim$
   ptGlobal->VarLine      =  LineNum[FileNdx]
   ptGlobal->VarPntr      =  GlobalPtr
   ptGlobal->VarSF        =  GlobalFS
   ptGlobal->VarEmitFlag  =  iEmitted
   ptGlobal->VarModule$   =  TRIM$(FileNames$[FileNdx])
   ptGlobal->VarExtn      =  GlobalExtn
   ptGlobal->VarCondLevel =  InConditional
   ptGlobal->VarConstant  =  iConst
   ptGlobal->VarCondDef$  =  InIfDef$
   GlobalVarHash[GlobalNameHash] = GlobalVarCnt
END SUB ' AddGlobal





SUB AddLocal(LocalName$, LocalType, LocalDef=0, LocalDim$="", LocalPtr=0, LocalFS=0, iEmitted=0, iConst=0)
   DIM RAW varid = 0
   DIM RAW FirstVar$
   DIM RAW SecondVar$
   DIM RAW Warn$
   DIM RAW s

   IF LocalVarCnt AND TestState THEN
      IF CheckGlobal(LocalName$, &varid) <> vt_UNKNOWN THEN

         IF LocalDef THEN

            $FILL FirstVar$
            "Line" + STR$(LineNum[FileNdx])
            " in Module: " + TRIM$(FileNames$[FileNdx])
            " : " + LocalName$ + LocalDim$ + " as "
            TypeDefs[LocalDef].VarName$
            $FILL

         ELSE

            $FILL FirstVar$
            "Line" + STR$(LineNum[FileNdx])
            " in Module: " + TRIM$(FileNames$[FileNdx])
            " : " + LocalName$ + LocalDim$ + " as "
            GetVarTypeName$(LocalType)
            $FILL

         END IF

         IF GlobalVars[varid].VarDef THEN

            $FILL SecondVar$
            "Line" + STR$(GlobalVars[varid].VarLine)
            " in Module: " + GlobalVars[varid].VarModule$
            " : " + LocalName$ + GlobalVars[varid].VarDim$
            " as " + TypeDefs[GlobalVars[varid].VarDef].VarName$
            $FILL

         ELSE

            $FILL SecondVar$
            "Line" + STR$(GlobalVars[varid].VarLine)
            " in Module: " + GlobalVars[varid].VarModule$
            " : " + LocalName$ + GlobalVars[varid].VarDim$
            " as " + GetVarTypeName$(GlobalVars[varid].VarType)
            $FILL

         END IF
         Warn$ = "Local Variable " + FirstVar$ + CRLF$ + "Has Same Name as Global " + SecondVar$
         CALL Warning(Warn$)
      END IF

      FOR s = 1 TO LocalVarCnt
         IF LocalName$ = LocalVars[s].VarName$ THEN
            IF LocalVars[s].VarType <> LocalType         _
               OR LocalDim$ <> LocalVars[s].VarDim$      _
               OR LocalVars[s].VarDef <> LocalDef THEN

               $FILL FirstVar$
               "Line" + STR$(LineNum[FileNdx])
               " in Module: " + TRIM$(FileNames$[FileNdx])
               " : " + LocalName$ + LocalDim$ + " as "
               GetVarTypeName$(LocalType) + SPC$
               TypeDefs[LocalDef].VarName$
               $FILL

               $FILL SecondVar$
               "Line" + STR$(LocalVars[s].VarLine) + " in Module: "
               LocalVars[s].VarModule$ + " : " + LocalName$
               LocalVars[s].VarDim$ + " as "
               GetVarTypeName$(LocalVars[s].VarType) + SPC$
               TypeDefs[LocalVars[s].VarDef].VarName$
               $FILL

               Warn$ = "Two Variables " + FirstVar$ + " previously defined at " + SecondVar$
               CALL Warning(Warn$)
            END IF
            EXIT SUB
         END IF
      NEXT
   END IF

   INCR LocalVarCnt

   IF LocalVarCnt = MaxLocalVars THEN
      Warn$ = "Maximum Local Variables reached."
      CALL Abort(Warn$)
   END IF

   LocalVars[LocalVarCnt].VarName$     =  LocalName$
   LocalVars[LocalVarCnt].VarType      =  LocalType
   LocalVars[LocalVarCnt].VarDef       =  LocalDef
   LocalVars[LocalVarCnt].VarDim$      =  LocalDim$
   LocalVars[LocalVarCnt].VarLine      =  LineNum[FileNdx]
   LocalVars[LocalVarCnt].VarPntr      =  LocalPtr
   LocalVars[LocalVarCnt].VarSF        =  LocalFS
   LocalVars[LocalVarCnt].VarEmitFlag  =  iEmitted
   LocalVars[LocalVarCnt].VarConstant  =  iConst
   LocalVars[LocalVarCnt].VarModule$   =  TRIM$(FileNames$[FileNdx])
END SUB ' AddLocal





FUNCTION IsNumber(szToken$)
   IF ISNULL(szToken) THEN FUNCTION = FALSE   ' Handle null arguments
   DIM RAW pszToken AS PCHAR
   pszToken = szToken
   DO WHILE *pszToken                         ' While NOT null terminator
      IF *pszToken>47 AND *pszToken<58 THEN   ' Test for 0123456789
         INCR pszToken                        ' bump our index
      ELSE
         FUNCTION = FALSE                     ' szToken$ is not a number
      END IF
   LOOP
   FUNCTION = TRUE                            ' szToken$ is a number
END FUNCTION ' IsNumber





FUNCTION IsNumberEx (a$)
   DIM i,HasDigit, HasE, HasMinus, HasPlus, HasDecimal, HasInvalid, HasL
   IF ISNULL(a$) THEN EXIT FUNCTION    ' Handle null argument
   i = HasDigit = HasE = HasMinus = HasPlus = HasDecimal = 0
   '***********************************************************
   ' Rules of scientific notation:
   '   The base is always 10
   '   The exponent is a non-zero integer
   '   The ABS value of the coefficient is >=1 and <10
   '   The coefficient carries the sign (+ or -)
   '   The mantissa carries the significant digits
   ' Rules for this function
   '   Can only have these characters: -+.0123456789eELl
   '   Must have at least 1 digit
   '   Only 1 "E" (case doesn't matter)
   '   No more than 2 plus signs
   '   No more than 2 minus signs
   '   No more than 1 decimal point
   '***********************************************************
   DO WHILE a[i]
      HasInvalid = 1        ' Assume every char is INVALID

      IF (a[i]>47 AND a[i]<59) THEN
         INCR HasDigit      ' 0123456789
         HasInvalid = 0
      END IF

      IF a[i]=43 THEN
         INCR HasPlus        '  +
         HasInvalid = 0
      END IF

      IF a[i]=45 THEN
         INCR HasMinus       '  -
         HasInvalid = 0
      END IF

      IF a[i]=46 THEN
         INCR HasDecimal     '  .
         HasInvalid = 0
      END IF

      IF (a[i]=69 OR a[i]=101) THEN
         INCR HasE           ' e or E
         HasInvalid = 0
      END IF

      IF HasInvalid THEN EXIT FUNCTION
      INCR i
   LOOP

   DECR i

   IF (a[i] = 76 OR a[i] = 108) THEN
      INCR HasL           ' l or L
   END IF

   FUNCTION = (ISTRUE (HasDigit)) AND (HasE <2) AND (HasL <2) AND (HasPlus <3) AND (HasMinus <3) AND (HasDecimal <2)
END FUNCTION ' IsNumberEx





SUB StripTabs
   DIM RAW pszSrc AS PCHAR
   DIM RAW iQuoteFlag
   pszSrc = Src
   iQuoteFlag = 0
   DO WHILE *pszSrc
      IF *pszSrc = c_DblQt THEN iQuoteFlag = iQuoteFlag XOR 1
      IF *pszSrc = 9 AND NOT iQuoteFlag THEN *pszSrc = 32
      INCR pszSrc
   LOOP
END SUB




SUB PushFileIO
   FPtr[++FPtrNdx] = SourceFile
END SUB





SUB PopFileIO
   IF FPtrNdx > 0 THEN
      CLOSE SourceFile
      INCR LinesRead, LineNum[FileNdx--]
      SourceFile = FPtr[FPtrNdx--]
   END IF
END SUB





FUNCTION Inset(Mane$, Match$)
   DIM RAW i, j
   i = (-1)
   j = (-1)
   DO WHILE Match[++i]
      DO WHILE Mane[++j]
         IF Match[i] = Mane[j] THEN FUNCTION = TRUE
      LOOP
      j = (-1)
   LOOP
   FUNCTION = FALSE
END FUNCTION





SUB CheckParQuotes
   DIM RAW CountR : CountR = 0             ' Round  bracket counter
   DIM RAW CountS : CountS = 0             ' Square bracket counter
   DIM RAW DoCount AS BOOL  : DoCount = TRUE
   DIM RAW pszSrc  AS PCHAR : pszSrc  = Src
   DO WHILE *pszSrc
      IF *pszSrc = c_DblQt THEN
         DoCount = NOT DoCount
      END IF
      IF DoCount THEN
         SELECT CASE *pszSrc
            CASE c_LPar  : INCR CountR
            CASE c_RPar  : DECR CountR
            CASE c_LtBkt : INCR CountS
            CASE c_RtBkt : DECR CountS
         END SELECT
      END IF
      INCR pszSrc
   LOOP
   IF NOT DoCount THEN CALL Abort ("Unmatched Quotes")
   IF CountS THEN CALL Abort ("Unmatched []")
   IF CountR THEN CALL Abort ("Unmatched ()")
END SUB





SUB ClearIfThenStacks
   DIM RAW i AS INT
   XFOR i = 0 WHILE i < cMaxSingleLineIFLines BY i++
      SrcStk$[i] = ""
   XNEXT
   SrcCnt = 0
END SUB





SUB AddExpressionToStack(szAssembledExpression$)
   IF SrcCnt = cMaxSingleLineIFLines-1 THEN
      CALL Abort("Single line conversion to multi-line stack exceeds limit.")
   END IF
   SrcStk$[++SrcCnt] = szAssembledExpression$        'Assemble our expression
END SUB





SUB Add2SplitLines(szSplitLine$)
   IF SplitCnt = cMaxSplitLines-1 THEN
      CALL Abort("Maximum line splitting exceeded.")
   END IF
   SplitStk$[++SplitCnt] = szSplitLine$
END SUB





FUNCTION IsQuoted(ParmStr$)
   IF NOT iMatchLft(LTRIM$(ParmStr$),DQ$) THEN FUNCTION = FALSE
   IF NOT iMatchRgt(RTRIM$(ParmStr$),DQ$) THEN FUNCTION = FALSE
   FUNCTION = TRUE
END FUNCTION





SUB PostProcess
   IF ReDirect = TRUE THEN
      DIM RAW LTmp1$
      OPEN FileOut$ FOR INPUT AS FP1
      DO WHILE NOT EOF(FP1)
         LINE INPUT FP1,LTmp1$
         PRINT LTmp1$
      LOOP
      CALL CloseAll
   END IF
   '**************************
   OutfileClone$ = FileOut$
   OutfileClone$ = EXTRACT$(OutfileClone$,".")

   FOR INT A = 1 TO EntryCnt
      Cmd$ = REMOVE$(Entry$[A],DQ$)
      REPLACE BKSLASH4$     WITH BKSLASH2$     IN Cmd$
      IREPLACE "$FILE$"     WITH OutfileClone$ IN Cmd$
      IREPLACE "$PELLES$\\" WITH PELLESPATH$   IN Cmd$
      IREPLACE "$PELLES$"   WITH PELLESPATH$   IN Cmd$
      IREPLACE "$LCC$\\"    WITH LCCPATH$      IN Cmd$
      IREPLACE "$LCC$"      WITH LCCPATH$      IN Cmd$
      IREPLACE "$BCX$\\"    WITH BCXPATH$      IN Cmd$
      IREPLACE "$BCX$"      WITH BCXPATH$      IN Cmd$
      PRINT "Shelling Out To:", Cmd$
      SHELL Cmd$
   NEXT

   IF NOTNULL(Compiler$) THEN
      Compiler$ = TRIM$(REMOVE$(Compiler$,DQ$))
      IF INCHR(Compiler$, SPC$) THEN
         Compiler$ = ENC$(EXTRACT$(Compiler$,SPC$)) + SPC$ + REMAIN$(Compiler$,SPC$)
      ELSE
         Compiler$ = ENC$(Compiler$)
      END IF
      REPLACE BKSLASH4$     WITH BKSLASH2$     IN Compiler$
      IREPLACE "$FILE$"     WITH OutfileClone$ IN Compiler$
      IREPLACE "$PELLES$\\" WITH PELLESPATH$   IN Compiler$
      IREPLACE "$PELLES$"   WITH PELLESPATH$   IN Compiler$
      IREPLACE "$LCC$\\"    WITH LCCPATH$      IN Compiler$
      IREPLACE "$LCC$"      WITH LCCPATH$      IN Compiler$
      REPLACE DDQ$          WITH DQ$           IN Compiler$
      PRINT "Shelling Out To:", Compiler$
      SHELL Compiler$
   END IF
   '**************************
   IF NOTNULL(ResCompiler$) THEN
      ResCompiler$ = ENC$(ResCompiler$)
      ResCompiler$ = ResCompiler$ + SPC$ + Res_File$
      IREPLACE "$PELLES$\\" WITH PELLESPATH$   IN ResCompiler$
      IREPLACE "$PELLES$"   WITH PELLESPATH$   IN ResCompiler$
      IREPLACE "$LCC$\\"    WITH LCCPATH$      IN ResCompiler$
      IREPLACE "$LCC$"      WITH LCCPATH$      IN ResCompiler$
      IREPLACE "$FILE$"     WITH OutfileClone$ IN ResCompiler$
      REPLACE BKSLASH4$     WITH BKSLASH2$     IN ResCompiler$
      REPLACE DDQ$          WITH DQ$           IN ResCompiler$
      PRINT "Shelling Out To:", ResCompiler$
      SHELL ResCompiler$
   END IF
   '**************************
   IF NOTNULL(Linker$) THEN
      Linker$ = TRIM$(REMOVE$(Linker$,DQ$))
      IF INCHR(Linker$, SPC$) THEN
         Linker$ = DQ$ + EXTRACT$(Linker$,SPC$) + DQ$ + SPC$ + REMAIN$(Linker$,SPC$)
      ELSE
         Linker$ = ENC$(Linker$)
      END IF
      IREPLACE "$PELLES$\\" WITH PELLESPATH$   IN Linker$
      IREPLACE "$PELLES$"   WITH PELLESPATH$   IN Linker$
      IREPLACE "$LCC$\\"    WITH LCCPATH$      IN Linker$
      IREPLACE "$LCC$"      WITH LCCPATH$      IN Linker$
      IREPLACE "$FILE$"     WITH OutfileClone$ IN Linker$
      REPLACE BKSLASH4$     WITH BKSLASH2$     IN Linker$
      REPLACE DDQ$   WITH DQ$  IN Linker$
      IF Use_Resource THEN
         ResFileOut$ = EXTRACT$(Res_File$,".") + ".res"
         Linker$ = Linker$ + SPC$ + ResFileOut$
      END IF
      PRINT "Shelling Out To:", Linker$
      SHELL Linker$
   END IF
   '**************************
   DIM szSave$
   szSave$ = FileOut$
   FileOut$ = EXTRACT$(FileOut$,".")

   FOR INT A = 1 TO XitCount
      Cmd$ = REMOVE$(Xit$[A],DQ$)
      IREPLACE "$FILE$" WITH OutfileClone$   IN Cmd$
      IREPLACE "$PELLES$\\" WITH PELLESPATH$ IN Cmd$
      IREPLACE "$PELLES$"   WITH PELLESPATH$ IN Cmd$
      IREPLACE "$LCC$\\"    WITH LCCPATH$    IN Cmd$
      IREPLACE "$LCC$"      WITH LCCPATH$    IN Cmd$
      IREPLACE "$BCX$\\"    WITH BCXPATH$    IN Cmd$
      IREPLACE "$BCX$"      WITH BCXPATH$    IN Cmd$
      REPLACE BKSLASH4$     WITH BKSLASH2$   IN Cmd$
      REPLACE DDQ$          WITH DQ$         IN Cmd$
      PRINT "Shelling Out To:", Cmd$
      SHELL Cmd$
   NEXT
   FileOut$  = szSave$
END SUB ' PostProcess





SUB INJECT (szLine$)
   CALL XParse(szLine$)
   CALL FixUps
   CALL EmitMain
END SUB





FUNCTION Convert2SimpleFunction(Tmp AS INT)
   DIM RAW iNextToken = (++Tmp + 1)
   DIM RAW iRetVal = 0
   IF Stk$[Tmp]= "(" AND Stk$[iNextToken]= ")" THEN
      Stk$[Tmp] = ""
      Stk$[iNextToken] = ""
      INCR iRetVal
   END IF
   FUNCTION = iRetVal
END FUNCTION



SUB XParse(ParamStr$)
   DIM RAW LTmp$     : LTmp$ = ""
   DIM RAW j, i      : j = i = 0
   DIM RAW InIF      : InIF = 0
   DIM RAW InXFOR    : InXFOR = 0
   DIM RAW Gapflag   : Gapflag = FALSE

   IF ISNULL(ParamStr$) THEN
      Ndx = 0
      EXIT SUB
   END IF

   FastLexer(ParamStr$, SPC$, "=&()[]{}',+-*/<>?;.|:^")

   '****************************************
   '              Pre Parse
   '****************************************

   DO WHILE ++i < 20
      Stk$[i+Ndx] = ""
   LOOP

   FOR INT ii = 1 TO Ndx
      IF *Stk$[ii] = ASC("&") AND *Stk$[ii+1] = ASC("&") THEN
         Stk$[ii] = "and"
         LShiftStk (ii+1)
      END IF
   NEXT

   IF iMatchWrd(Stk$[1],"end") THEN
      LTmp$ = ENC$(LCASE$(Stk$[2]),ASC(SPC$))
      IF iMatchNQ(" events , mdievents , mdichildevents ", LTmp$) THEN
         CONCAT(Stk$[1], LCASE$(Stk$[2]))
         IF iMatchWrd(Stk$[3], "main" ) THEN Use_MainEvent = TRUE
         Ndx = 1
         Src$ = Stk$[1]
         EXIT SUB
      END IF
      IF Stk$[2] <> "=" AND Ndx = 2 THEN
         IF iMatchWrd(Stk$[2],"dialog") THEN Stk$[2] = "function"
         Stk$[1] = "end" + LCASE$(Stk$[2])
         Ndx=1
         Src$ = Stk$[1]
         EXIT SUB
      END IF
   END IF

   IF iMatchWrd(Stk$[1],"end") AND iMatchWrd(Stk$[2],"prepend") THEN
      Stk$[1] = "endprepend"
      Src$ = Stk$[1]
      Ndx=1
      EXIT SUB
   END IF

   IF iMatchWrd(Stk$[1],"end") AND iMatchWrd(Stk$[2],"with") THEN
      Stk$[1] = "endwith"
      Src$ = Stk$[1]
      Ndx=1
      EXIT SUB
   END IF

   DIM RAW iP = 1

   IF iMatchWrd(Stk$[iP],"public") OR iMatchWrd(Stk$[iP],"private") THEN INCR iP

   IF (iMatchWrd(Stk$[iP],"function")  OR  _
      iMatchWrd(Stk$[iP],"catch")      OR  _
      iMatchWrd(Stk$[iP],"sub"))       AND _
      INCHR(ParamStr$,"*")             THEN

      XFOR INT ii = 2, INT jjj = 1 WHILE ii < Ndx-1 AND jjj BY ii++
         jjj = GetAsPosF(ii, Ndx-2)
         IF jjj THEN
            ii = jjj
            IF iMatchWrd(Stk$[ii+1],"const") THEN INCR ii
            DO WHILE Stk$[ii+2] = "*"
               Stk$[ii+2] = "PTR"
               INCR ii
            LOOP
         END IF
      XNEXT

      CALL BuildDelimStr(1,Ndx,Src$)
      FastLexer(Src$, SPC$, "=&()[]{}',+-*/<>?;.|:^")
      ParamStr$ = Src$
   END IF

   Gapflag = FALSE
   FOR i = 1 TO Ndx
      IF IsNumberEx(Stk$[i]) AND Stk[i][1] THEN
         Keyword1$ = RIGHT$(Stk$[i],1)
         IF *Keyword1$ = ASC("E") OR *Keyword1$ = ASC("e") THEN
            CONCAT(Stk$[i], Stk$[i+1]) : Stk$[i+1] = ""
            CONCAT(Stk$[i], Stk$[i+2]) : Stk$[i+2] = ""
            IF Stk$[i-1] = "-" THEN CONCAT(Stk$[i-1], Stk$[i]) : Stk$[i] = ""
            Gapflag = TRUE
         END IF
      END IF
   NEXT

   IF Gapflag = TRUE THEN CALL RemEmptyTokens

   FOR i = 1 TO Ndx
      Keyword1$ = LCASE$(Stk$[i])

      IF NOTZERO (Keyword1[1]) THEN
         SELECT CASE Keyword1$

            CASE "not"  : Stk$[i] = "!"
            CASE "is"   : Stk$[i] = "="
            CASE "xor"  : Stk$[i] = "xor"

            CASE "if", "iif", "iif$", "case", "elseif", "while"
            InIF = 1
            IF Keyword1$ = "case" AND iMatchWrd(Stk$[i+1],"else") THEN
               Stk$[i] = "caseelse" : Stk$[i+1] = "" : Gapflag = TRUE
            ELSE
               Stk$[i] = Keyword1$
            END IF

            CASE "$if", "$ifdef"   ' Tells "OR" to be Boolean in an $IF/$IFDEF statement
            InIF = 1

            CASE "$endif"          ' "OR" is free to change again
            InIF = 0

            CASE "xfor"
            InXFOR = 1

            CASE "until"
            InIF = InXFOR
            InXFOR = 0

            CASE "by"
            InIF = 0

            CASE "then"
            InIF = 0

            CASE "byval", "let"
            Stk$[i] = ""
            Gapflag = TRUE

            CASE "shl"
            Stk$[i] = "<<"

            CASE "shr"
            Stk$[i] = ">>"

            CASE "byref"
            IF NOT iMatchWrd(Stk$[1], "declare") AND NOT iMatchWrd(Stk$[1], "c_declare") THEN
               IF ByrefCnt = cMaxByref-1 THEN
                  CALL Abort("Maxium number of BYREFs reached.")
               END IF
               ByrefVars$[++ByrefCnt] = Stk$[i+1]
            END IF

            DIM RAW iDontHaveAs = TRUE

            FOR j = i TO Ndx
               IF iMatchWrd(Stk$[j],"as") THEN iDontHaveAs = FALSE
               IF Stk$[j+1] = "," OR Stk$[j+1] = ")" THEN
                  Stk$[j] = "PTR"
                  IF iDontHaveAs THEN
                     InsertTokens(j-1, 2, "as", VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(ByrefVars$[ByrefCnt],1)) ])
                  END IF
                  EXIT FOR
               END IF
               Stk$[j] = Stk$[j+1]
            NEXT

            CASE "and"
            IF InIF THEN
               Stk$[i] = "&&"
            ELSE
               Stk$[i] = "&"
            END IF

            CASE "or"
            IF InIF THEN
               Stk$[i] = "||"
            ELSE
               Stk$[i] = "|"
            END IF

            CASE "procedure"
            Stk$[i] = "sub"

            CASE ELSE
            IF PassOne THEN
               IF Keyword1$ = ENC$(CHR$(92)) THEN
                  IF *Stk$[i+1] <> c_DblQt THEN
                     Stk$[i] = "chr$"
                     InsertTokens(i, 3, "(", "92", ")")
                     INCR i,3
                  ELSE
                     CONCAT(Stk$[i],Stk$[i+1])
                     Stk$[i+1] = ""
                     Gapflag = TRUE
                  END IF
               ELSE
                  IF TranslateSlash THEN
                     REPLACE BKSLASH1$ WITH BKSLASH2$ IN Stk$[i]
                  END IF
               END IF
            END IF
         END SELECT

      ELSE

         SELECT CASE ASC(Keyword1$)

            '**************
            CASE ASC("&")                                            ' Connect AddressOf operator
            '**************

            IF INCHR("+&,(=", Stk$[i-1]) AND *Stk$[i+1] <> ASC(".") THEN
               Stk$[i+1] = " &" + Stk$[i+1]
               Stk$[i] = ""
               Gapflag=TRUE
            END IF

            '**************
            CASE ASC ("?")                                           ' Multiple contexts
            '**************

            '***********************************************************************************
            IF Stk$[1] ?? "IF" THEN EXIT SELECT                      ' Found an "??" operator
            '***********************************************************************************

            IF Use_GUINoMain OR Use_MDIGUINoMain OR Use_Wingui THEN  ' Added in 752
               Stk$[i] = "msgbox"                                    ' ? is translated to MsgBox
               IF ISNULL(Stk$[i+1]) THEN
                  Stk$[i+1] = ENC$("")                               ' Allow an empty msgbox
                  INCR Ndx
               END IF
            ELSE                                                     ' ? full console mode
               IF i = 1 OR (i > 1 AND Stk$[i-1] = ":") THEN
                  Stk$[i] = "print"                                  ' ? is a traditional PRINT convenience
               END IF
            END IF

            '**************
            CASE ASC ("-")
            '**************

            IF ASC(Stk$[i+1]) = ASC(">") THEN
               Stk$[i] = "->" + Stk$[i+2]
               Stk$[++i] = "" : Stk$[++i] = ""
               Gapflag = TRUE
            END IF

            '**************
            CASE ASC (".")
            '**************

            IF ASC(Stk$[i+1]) = 46 AND ASC(Stk$[i+2]) = 46 THEN   ' ...
               Stk$[i] = "..."
               Stk$[i+1] = ""
               Stk$[i+2] = ""
               Gapflag=TRUE
            END IF
            IF IsNumber(Stk$[i-1]) THEN
               Stk$[i] = Stk$[i-1] + "."
               Stk$[i-1] = "" : Gapflag=TRUE
            END IF
            IF NOT INCHR( ",)=<>*/+-^", Stk$[i+1]) THEN
               CONCAT(Stk$[i], Stk$[i+1])
               Stk$[++i] = ""
               Gapflag=TRUE
            END IF

         END SELECT
      END IF
   NEXT

   IF Gapflag = TRUE THEN CALL RemEmptyTokens

   ' *******************************************************************
   ' Special Case Handler: BYREF - BCX prepends * to BYREF'd Variables
   ' *******************************************************************

   IF PassOne = TRUE THEN
      DIM RAW lszTmp$ = ""
      IF InFunction THEN            ' Must be in a SUB or FUNCTION
         FOR i = 1 TO Ndx
            FOR j = 1 TO ByrefCnt
               IF iMatchLft(Stk$[i], " &") THEN lszTmp$ = Stk$[i] + 2 ELSE lszTmp$ = Stk$[i]
               IF Clean$(lszTmp$) = Clean$(ByrefVars[j]) THEN

                  IF i > 2 THEN
                     IF INCHR("+-^%*/|&<=>,", Stk$[i-2]) AND Stk$[i-1] = "*" THEN
                        Stk$[i-1] = ""
                        Gapflag = TRUE
                     END IF
                     IF iMatchLft(Stk$[i], " &") THEN
                        Stk$[i] = Stk$[i] + 2
                        EXIT FOR
                     END IF
                  ELSEIF i = 2 THEN
                     IF Stk$[i-1] = "*" THEN
                        Stk$[i-1] = ""
                        Gapflag = 1
                     END IF
                  END IF
                  Stk$[i] = "*" + Stk$[i]
                  IF Stk$[i-1] <> "(" OR Stk$[i+1] <> ")" THEN
                     Stk$[i] = ENC$(Stk$[i], ASC("("), ASC(")"))
                  END IF
                  EXIT FOR
               END IF

            NEXT
         NEXT
      END IF
      IF Gapflag = TRUE THEN CALL RemEmptyTokens
   END IF

   ' *******************************************************************
   ' Special Case Handler: DIM BLAHBLAH[22][33] AS STATIC INT
   ' *******************************************************************

   IF iMatchWrd(Stk$[1],"dim") THEN
      IF iMatchWrd(Stk$[Ndx-1],"static") THEN
         Stk$[1] = "static"
         Stk$[Ndx-1] = Stk$[Ndx]
         DECR Ndx
      END IF
   END IF

   ' ***********************************
   ' Used in special case handlers.
   ' ***********************************
   Keyword1$ = LCASE$(Stk$[1])

   ' ***************************************************************************
   ' Special Case Handler: In the contexts of UDT,s this handler transforms:
   ' FUNCTION Foo (a as integer) AS INT         to:
   ' DIM FUNCTION Foo (a as integer) AS INT
   ' Change "as string" to "as char *" for UDTs and Declarations
   ' ***************************************************************************

   IF InTypeDef AND NOT InClass THEN
      DIM RAW lsz$ = ""
      lsz$ =  ENC$(Keyword1$,ASC(SPC$))
      IF iMatchNQ(" end dim declare type union ", lsz$) = 0 THEN
         DIM RAW iCnt = 0
         DIM RAW iFnd = 0
         IF ConstMacroCnt THEN
            XFOR iCnt = 0 WHILE iCnt < ConstMacroCnt BY iCnt++
               IF Stk$[1] = ConstMacro$[iCnt] THEN iFnd = TRUE
            XNEXT
         END IF
         IF iFnd = FALSE THEN InsertTokens(0, 1, "dim")
      END IF
   END IF

   '******************************

   IF NOT InTypeDef AND NOT InPPType THEN
      DIM RAW lsz$ = ""
      DIM RAW Res = 0
      DIM RAW Storage$ = " dim local global raw static shared dynamic auto register extern "

      lsz$ = ENC$(Keyword1$,ASC(SPC$))

      IF iMatchNQ(Storage$, lsz$) THEN
         Res = 1
      END IF

      lsz$ =  ENC$(LCASE$(Stk$[2]),ASC(SPC$))

      IF iMatchNQ(Storage$, lsz$) THEN
         Res = 2
      END IF

      IF Res > 0 THEN
         i = Ndx
         DO WHILE i > 1 AND Stk$[i] <> ")"
            IF iMatchWrd(Stk$[i], "as") THEN
               IF iMatchWrd(Stk$[i+1], "function") THEN
                  IF i+1 = Ndx THEN Stk$[i] = ""  ' remove "as"
                  Stk$[i+1] = ""
                  InsertTokens(Res, 1, "function")
               ELSEIF iMatchWrd(Stk$[i+1], "sub") THEN
                  IF i+1 = Ndx THEN Stk$[i] = ""  ' remove "as"
                  Stk$[i+1] = ""
                  InsertTokens(Res, 1, "sub")
               END IF
               CALL RemEmptyTokens
               EXIT DO
            END IF
            DECR i
         LOOP
      END IF
   END IF

   IF InTypeDef OR iMatchWrd(Stk$[1], "declare") OR iMatchWrd(Stk$[1], "c_declare") THEN
      IF iMatchWrd(Stk$[2],"sub") OR iMatchWrd(Stk$[2],"function") THEN
         FOR INT mm = 2 TO Ndx
            IF iMatchLft(Stk$[mm],"as") AND iMatchWrd(Stk$[mm+1],"string") THEN
               IF *Stk$[mm+2] <> ASC("*") THEN Stk$[mm+1] = "char *"
            END IF
         NEXT
      END IF
   END IF
END SUB 'XParse





SUB FuncSubTemplate(Tmp AS INT)
   DIM RAW iConc = ++Tmp AS INT
   IF Stk$[++Tmp] <> "<" THEN EXIT SUB
   XFOR INT i = Tmp, INT notfnd = TRUE WHILE notfnd = TRUE AND i<= Ndx BY i++
      IF Stk$[i] = "(" THEN
         notfnd = FALSE
      ELSE
         IF Stk$[i] = "," THEN Stk$[i] = CHR$(18)
         CONCAT(Stk$[iConc], Stk$[i])
         Stk$[i] = ""
      END IF
   XNEXT
   CALL RemEmptyTokens
END SUB





SUB TokenSubstitutions(iSubLoc AS INT)
   '********************************
   ' Start Doing Text Substitutions
   '********************************
   DIM RAW A AS INT
   DIM RAW a AS INT
   DIM RAW i AS INT
   DIM RAW j AS INT
   DIM RAW Tmp AS INT
   DIM RAW Keyword$
   '                                          ' TS_CompPtr is a GLOBAL flag for empty tokens in Stk$[]
   DIM RAW CompToken                          ' flag that STRUCT, UDT, OR UNION can be handled
   DIM RAW NoTrans                            ' flag don't substitute tokens in DATA statements
   DIM RAW tpBCX AS tagTokenSubFunctions PTR  ' points to structure holding information
   '                                          ' about any word in the BCXWords dictionary

   '******************************************************************************************
   ' Following block added in 4.13 --  Dim XXX as string * 12345
   ' Works in  UDT, GLOBALS, LOCALS, and RAW
   '******************************************************************************************

   i = GetAsPosF(1, Ndx)
   IF i THEN
      IF iMatchWrd(Stk$[i+1],"string") THEN
         IF Stk$[i+2] = "*" THEN
            Stk$[i]   = "["
            Stk$[i+1] = Stk$[i+3]
            Stk$[i+2] = "]"
            Stk$[i+3] = "as"
            INCR Ndx
            Stk$[Ndx] = "char"
         END IF
      END IF
   END IF

   '******************************************************************************************
   '                                  Check for needed transforms
   '******************************************************************************************

   IF InFunction = FALSE THEN
      FOR i = 1 TO Ndx
         IF iMatchWrd(Stk$[i],"global") THEN Stk$[i] = "dim"
      NEXT
   END IF

   A = FALSE
   IF iMatchWrd(Stk$[1],"pptype") = 0 THEN
      FOR Tmp = 1 TO Ndx
         IF *Stk$[Tmp] = ASC("0") AND NOT _
            iMatchWrd(MID$(Stk$[Tmp],2,1),"b") AND NOT _
            iMatchWrd(MID$(Stk$[Tmp],2,1),"x") AND NOT _
            iMatchWrd(MID$(Stk$[Tmp],2,1),".") AND NOT _
            iMatchWrd(MID$(Stk$[Tmp],2,1),"l") THEN
            Stk$[Tmp] = LTRIM$(Stk$[Tmp],48)   'allow leading zero's in numbers
            IF ISNULL(Stk$[Tmp]) THEN Stk$[Tmp] = "0"
         END IF

         IF iMatchWrd(Stk$[Tmp],"xor") THEN
            Stk$[Tmp] = "^"
         ELSE

            SELECT CASE Stk$[Tmp]
               CASE "="
               IF *Stk$[Tmp+1]= ASC(">") THEN
                  Stk$[Tmp] = ">"
                  Stk$[Tmp+1]= "="
               END IF
               IF *Stk$[Tmp+1]= ASC("<") THEN
                  Stk$[Tmp] = "<"
                  Stk$[Tmp+1] = "="
               END IF
               CASE "<"
               IF *Stk$[Tmp+1]= ASC(">") THEN
                  Stk$[Tmp]  = "!="
                  Stk$[Tmp+1] = ""
                  A = TRUE
               END IF
               CASE ">"
               IF *Stk$[Tmp+1]= ASC("<") THEN
                  Stk$[Tmp]  = "!="
                  Stk$[Tmp+1] = ""
                  A = TRUE
               END IF
               CASE "!"
               IF *Stk$[Tmp+1]= ASC("=") THEN
                  Stk$[Tmp]  = "!="
                  Stk$[Tmp+1] = ""
                  A = TRUE
               END IF
            END SELECT

         END IF
      NEXT
   END IF

   IF A = TRUE THEN CALL RemEmptyTokens

   '*************************************************************************
   ' Needed when recursively calling parse() after <> has already translated
   ' to != Otherwise, on pass 2, it emits as !== which is NOT desired.
   '*************************************************************************

   CompToken = 0

   FOR Tmp = 1 TO Ndx
      A = CheckLocal(Stk$[Tmp], &i)
      IF A = vt_UNKNOWN THEN A = CheckGlobal(Stk$[Tmp], &i)
      IF A = vt_STRUCT OR A = vt_UDT OR A = vt_UNION THEN
         CompToken = 1
      END IF
      IF iMatchWrd(Stk$[Tmp],"int") AND Stk$[Tmp+1] = "(" THEN
         Stk$[Tmp] = "fint"
      ELSEIF iMatchWrd(Stk$[Tmp],"integer") THEN
         Stk$[Tmp] = "int"
      ELSE
         IF iMatchWrd(Stk$[Tmp],"fint") AND Stk$[Tmp+1]= ")" THEN
            Stk$[Tmp] = "int"
         END IF
      END IF
   NEXT

   '*****************************
   TS_CompPtr  = 0
   NoTrans = 0

   FOR Tmp = 1 TO Ndx
      IF NoTrans = 1 THEN EXIT FOR
      Keyword$ = LCASE$(Stk$[Tmp])
      tpBCX = GetWordInfo(Keyword$)
      IF tpBCX THEN

         IF (UseCpp = FALSE) AND (Keyword$ <> "new") AND (tpBCX->iWordInfo BAND eWI_CPPWord) THEN
            CALL Abort(ENC$(Keyword$,ASC("'")) + " can only be used with C++.")
         END IF

         IF (tpBCX->iTRAN_FLAG BAND iSubLoc) <> iSubLoc THEN
            ITERATE
         END IF
         IF (tpBCX->iWordInfo BAND eWI_ReplaceWord) THEN ' just substitute
            IF (tpBCX->iWordInfo BAND eWI_Position1) = 0 THEN
               Stk$[Tmp] = tpBCX->pszFunctionXName$
               ITERATE
            ELSEIF Tmp = 1 THEN
               Stk$[Tmp] = tpBCX->pszFunctionXName$
               ITERATE
            END IF
         END IF
      END IF

      '*********************************************************************************
      ' This is where we can modify the input stream of tokens that have been parsed.
      ' We can do simple text substitutions, add missing arguments, add casting, set
      ' conditionals, and practically anything else that might be needed.
      '*********************************************************************************

      a = INCHR("abcdefghijklmnopqrstuvwxyz$", Keyword$)

      SELECT CASE a
         CASE 1
         SELECT CASE Keyword$

            CASE "acosh"
            Stk$[Tmp] = "acosh"
            Use_Acosh = Use_Proto = TRUE

            CASE "addressof"
            Stk$[Tmp+1] = "&" + Stk$[Tmp+1]
            Stk$[Tmp] = ""
            INCR TS_CompPtr

            CASE "appactivate"
            Stk$[Tmp] = "AppActivate"
            Use_AppActivate = Use_BcxTmpStr = Use_Instr = Use_Stristr = TRUE
            Use_Lcase = Use_Left = Use_UCaseTbl = TRUE

            CASE "appexename$"
            Stk$[Tmp] = "AppExeName$()"
            Use_AppExeName = Use_BcxTmpStr = TRUE

            CASE "appexepath$"
            Stk$[Tmp] = "AppExePath$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_AppExePath = Use_BcxTmpStr = TRUE

            CASE "ansitowide", "ansitowide$", "a2w$", "a2w"
            Stk$[Tmp] = "AnsiToWide"
            Use_AnsiToWide = Use_BcxTmpStr = TRUE

            CASE "andalso"                  ' AND can be Boolean or bitwise
            Stk$[Tmp] = " &&"               ' but ANDALSO is ALWAYS boolean

            CASE "asc"
            CALL Process_ASC_Function (Tmp)

            CASE "asciiz"
            Stk$[Tmp] = "string"

            CASE "arrayputelement"
            'INPUT:
            ' ArrayPutElement(psA,lComVariant,2,0,iCol)
            ' TRANSFORMS TO:
            ' BEGINBLOCK
            ' RAW indicies[2] = {0,iCol} AS long
            ' SafeArrayPutElement(psA,indicies, (void *)&lComVariant)
            ' ENDBLOCK
            DIM RAW sTmp$
            CALL Add2SplitLines("BEGINBLOCK")   ' EMITS {
            sTmp$ = "DIM RAW lIndex["+Stk$[Tmp+6]+ "] = {"
            FOR i = Tmp+8 TO Ndx-1
               CONCAT (sTmp$, Stk$[i])
            NEXT
            CALL Add2SplitLines(sTmp$ + "} AS long")
            Stk$[Tmp] = "SafeArrayPutElement"
            sTmp$ = ""
            FOR i = 1 TO Tmp+3
               CONCAT (sTmp$, Stk$[i])
            NEXT
            CALL Add2SplitLines(sTmp$ + "lIndex,(void *)&"+Stk$[Tmp+4]+ ")")
            CALL Add2SplitLines("ENDBLOCK")      ' EMITS }
            Ndx = 0

            CASE "arraygetelement"
            DIM RAW sTmp$
            CALL Add2SplitLines("BEGINBLOCK")
            sTmp$ = "DIM RAW lIndex["+Stk$[Tmp+6]+ "] = {"
            FOR i = Tmp+8 TO Ndx-1
               sTmp$ = sTmp$ + Clean$(Stk$[i])
            NEXT
            CALL Add2SplitLines(sTmp$ + "} AS long")
            Stk$[Tmp] = "SafeArrayGetElement"
            sTmp$ = ""
            FOR i = 1 TO Tmp+3
               sTmp$ = sTmp$ + Clean$(Stk$[i])
            NEXT
            CALL Add2SplitLines(sTmp$ + "lIndex,(void *)&" + Clean$(Stk$[Tmp+4]) + ")")
            CALL Add2SplitLines("ENDBLOCK")
            Ndx = 0

            CASE "asinh"
            Stk$[Tmp] = "asinh"
            Use_Asinh = Use_Proto = TRUE

            CASE "atanh"
            Stk$[Tmp] = "atanh"
            Use_Atanh = Use_Proto = TRUE

            CASE "auto"
            IF iMatchWrd(Stk$[Tmp+1],"local") THEN
               Stk$[Tmp] = "dim" : Stk$[Tmp+1] = "raw"
            ELSE
               Stk$[Tmp] = "auto"
            END IF


            CASE  "acode$", "acode"
            Stk$[Tmp] = "$$WideToAnsi$"
            Use_WideToAnsi = Use_BcxTmpStr = TRUE

         END SELECT

         CASE  2
         SELECT CASE Keyword$

            CASE "bcopy"
            Stk$[1] = ""
            FOR i = Tmp+1 TO Ndx
               IF iMatchWrd(Stk$[i],"to") THEN EXIT FOR
               CONCAT(Stk$[1], Stk$[i]) 'Source
               CONCAT(Stk$[1], CHR$(1))
            NEXT
            Stk$[2] = ""
            FOR i = i+1 TO Ndx
               CONCAT(Stk$[2], Stk$[i]) 'Destination
               CONCAT(Stk$[2], CHR$(1))
            NEXT

            '*****************************************************************************
            ' 7.6.6 Ian Casey requested the following casts in memmove to support UNICODE
            ' Tested and working with all compilers - MrBcx
            '*****************************************************************************

            $FILL Src$
            "memmove" + CHR$(1)          + "((char*)" + CHR$(1) + "&"      + CHR$(1)
            Stk$[2]   + ",(const char*)" + CHR$(1)    + "&"     + CHR$(1)
            Stk$[1]   + "," + CHR$(1)    + "sizeof"   + CHR$(1) + "("      + CHR$(1)
            Stk$[2]   + ")" + CHR$(1)    + ")"
            $FILL

            ' End of 7.6.6 change
            '*****************************************************************************
            REMOVE "&*" FROM Src$
            CALL FastLexer(Src$,CHR$(1),"",-1)

            CASE "begin"
            IF iMatchWrd(Stk$[Tmp+1],"events") OR iMatchWrd(Stk$[Tmp+1],"mdievents") OR iMatchWrd(Stk$[Tmp+1],"mdichildevents") THEN
               IF Indent THEN
                  CALL Abort("Possible missing END IF before start of BEGIN")
               END IF
               IF Ndx = 3 THEN
                  Src$ = "FUNCTION|"+Stk$[Tmp+2]+ "(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK "
               ELSE
                  Src$ = "FUNCTION|WndProc(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK"
               END IF
               FastLexer(Src$,"|", ",()")
               Use_Wingui = TRUE
               EXIT SUB
            END IF

            CASE "bel$"
            Stk$[Tmp] = "BEL$"
            Use_BEL = Use_BcxTmpStr = TRUE

            CASE "bs$"
            Stk$[Tmp] = "BS$"
            Use_BS = Use_BcxTmpStr = TRUE

            CASE "bcxstrsize"
            Stk$[Tmp] = "BCXSTRSIZE"

            CASE "bcx_dynacall"
            Stk$[Tmp] = "BCX_DynaCallA"
            Use_DynacallCommon = Use_DynacallA = TRUE

            ' *******************************************************************
            ' Special Case Handler: Maintain case sensitivity for this structure
            ' *******************************************************************

            CASE "bcx_font"
            Stk$[Tmp]   = UCASE$(Stk$[Tmp])
            DIM RAW temp$
            DIM RAW iNextToken = Tmp + 1
            Stk$[iNextToken] = Clean$(Stk$[iNextToken])
            temp$ = UCASE$(Stk$[iNextToken])

            SELECT CASE temp$
               CASE ".NAME"         : Stk$[iNextToken] = ".lf.lfFaceName$"
               CASE ".BOLD"         : Stk$[iNextToken] = ".lf.lfWeight"
               CASE ".UNDERLINE"    : Stk$[iNextToken] = ".lf.lfUnderline"
               CASE ".STRIKEOUT"    : Stk$[iNextToken] = ".lf.lfStrikeOut"
               CASE ".ITALIC"       : Stk$[iNextToken] = ".lf.lfItalic"
               CASE ".CHARSET"      : Stk$[iNextToken] = ".lf.lfCharSet"
               CASE ".SIZE", ".RGB" : Stk$[iNextToken] = temp$
            END SELECT

            CASE "bcx_setcursor"
            Stk$[Tmp] = "BCX_SetCursor"
            Use_BCX_SetCursor = Use_BCX_InitGUI = TRUE
            CALL AddGUIGlobals

            CASE "bcx_msgpump"
            Stk$[Tmp] = "BCX_MsgPump"
            Use_BCX_MsgPump = TRUE
            CALL AddGUIGlobals

            CASE "bcx_wnd"
            Stk$[Tmp] = "BCX_Wnd"
            Use_BCX_Wnd = Use_BCX_InitGUI = Use_BCX_SetMetric = Use_BCX_RegWnd = TRUE
            CALL AddGUIGlobals

            CASE "bcx_framewnd"
            Stk$[Tmp] = "BCX_FrameWnd"
            Use_BCX_FrameWnd = Use_BCX_RegWnd = Use_BCX_InitGUI = Use_BCX_SetMetric = TRUE
            CALL AddGUIGlobals

            CASE "bcx_setbkgrdbrush"
            Stk$[Tmp] = "BCX_SetBkGrdBrush"
            Use_BCX_SetBkGrdBrush = Use_BCX_InitGUI = TRUE
            CALL AddGUIGlobals

            CASE "bcx_setclassstyle"
            Stk$[Tmp] = "BCX_SetClassStyle"
            Use_BCX_SetClassStyle = Use_BCX_InitGUI = TRUE
            CALL AddGUIGlobals

            CASE "bcx_seticon"
            Stk$[Tmp] = "BCX_SetIcon"
            Use_BCX_SetIcon = Use_BCX_InitGUI = TRUE
            CALL AddGUIGlobals

            CASE "bcx_seticonsm"
            Stk$[Tmp] = "BCX_SetIconSm"
            Use_BCX_SetIconSm = Use_BCX_InitGUI = TRUE
            CALL AddGUIGlobals

            CASE "bcx_setmetric"
            Stk$[Tmp] = "BCX_SetMetric"
            Use_BCX_SetMetric = Use_BCX_InitGUI = TRUE
            CALL AddGUIGlobals

            CASE "bcx_initgui"
            Stk$[Tmp] = "BCX_InitGUI"
            Use_BCX_InitGUI = TRUE
            CALL AddGUIGlobals

            CASE "bcx_regwnd"
            Stk$[Tmp] = "BCX_RegWnd"
            Use_BCX_RegWnd = Use_BCX_InitGUI = Use_BCX_SetMetric = TRUE
            CALL AddGUIGlobals

            CASE "bcx_mdi_msgpump"
            Stk$[Tmp] = "BCX_MDI_MsgPump"
            Use_BCX_MDI_MsgPump = TRUE
            CALL AddGUIGlobals

            CASE "bcx_bcx_wndclass"
            Stk$[Tmp] = "BCX_WndClass"
            CALL AddGUIGlobals

            CASE "bcxsplitpath$"
            Stk$[Tmp] = "$$BcxSplitPath$"
            Use_BcxSplitPath = Use_BcxTmpStr = TRUE
            Use_SysMacros = Use_Proto = TRUE

            CASE "bcxpath$"
            Stk$[Tmp] = "BcxPath$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_BCX_Path = Use_RegString = TRUE
            Use_BcxTmpStr = TRUE

            CASE "bcx_arc"
            Stk$[Tmp] = "BCX_Arc"
            Use_BCX_Arc = Use_Proto = TRUE

            CASE "bcx_bitmap"
            Stk$[Tmp] = "BCX_Bitmap"
            Use_Bitmap = Use_Proto = TRUE

            CASE "bcx_olepicture"
            Stk$[Tmp] = "BCX_OlePicture"
            Use_BCX_OlePicture = Use_GetResource = Use_Proto = TRUE

            CASE "bcx_ole_width"
            Stk$[Tmp] = "BCX_OLE_WIDTH"
            Use_SysMacros = TRUE

            CASE "bcx_ole_height"
            Stk$[Tmp] = "BCX_OLE_HEIGHT"
            Use_SysMacros = TRUE

            CASE "bcx_blackrect"
            Stk$[Tmp] = "BCX_BlackRect"
            Use_Blackrect = Use_Proto = TRUE

            CASE "bcx_button"
            Stk$[Tmp] = "BCX_Button"
            Use_Button = Use_GetTextSize = Use_Proto = TRUE

            CASE "bcx_bmpbutton"
            Stk$[Tmp] = "BCX_BmpButton"
            Use_BmpButton = Use_Proto = TRUE

            CASE "bcx_bmpwidth"
            Stk$[Tmp] = "BCX_BmpWidth"
            Use_BCX_BmpWidth = Use_Proto = TRUE

            CASE "bcx_bmpheight"
            Stk$[Tmp] = "BCX_BmpHeight"
            Use_BCX_BmpHeight = Use_Proto = TRUE

            CASE "bcx_checkbox"
            Stk$[Tmp] = "BCX_Checkbox"
            Use_Checkbox = Use_GetTextSize = Use_Proto = TRUE

            CASE "bcx_combobox"
            Stk$[Tmp] = "BCX_Combobox"
            Use_Combobox = Use_Proto = TRUE

            CASE "bcx_console"
            Stk$[Tmp] = "hConsole"
            Use_Console = Use_Proto = TRUE

            CASE "bcx_com_error"
            Stk$[Tmp] = "COM_BCX_ERROR"
            ComSwitchON = Use_COM = TRUE

            CASE "bcx_control"
            Stk$[Tmp] = "BCX_Control"
            Use_BCX_Control = Use_Proto = TRUE

            CASE "bcx_colordlg"
            Stk$[Tmp] = "BCX_ColorDlg"
            IF NOT INCHR(Src$,"(") THEN Stk$[Tmp] = Stk$[Tmp] + "()"
            Use_BCX_Colordlg = Use_Hook = Use_BcxTmpStr = Use_Proto = TRUE

            CASE "bcx_cursor"
            Stk$[Tmp] = "BCX_Cursor"
            Use_BCX_Cursor = Use_SysMacros = TRUE

            CASE "bcx_datepick"
            Stk$[Tmp] = "BCX_DatePick"
            Use_Datepick = Use_Proto = TRUE

            CASE "bcx_edit"
            Stk$[Tmp] = "BCX_Edit"
            Use_Edit = Use_Proto = TRUE

            CASE "bcx_circle"
            Stk$[Tmp] = "BCX_Circle"
            Use_BCX_Circle = Use_Proto = TRUE

            CASE "bcx_ellipse"
            Stk$[Tmp] = "BCX_Ellipse"
            Use_BCX_Ellipse = Use_Proto = TRUE

            CASE "bcx_mdialog"
            IF InWinMain AND NOT Use_BCXMDialog THEN
               FPRINT Outfile, Scoot$, "BCX_hInstance    =  hInst;"
               iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eBCX_hInstance)
            END IF
            Stk$[Tmp] = "BCX_MDialog"
            Stk$[Tmp+1] = "((DLGPROC)"
            Use_BCXDialogCommon = Use_BCXMDialog = Use_Proto = TRUE

            CASE "bcx_dialog"
            Stk$[Tmp] = "BCX_Dialog"
            Stk$[Tmp+1] = "((DLGPROC)"
            Use_BCXDialogCommon = Use_BCXDialog = Use_Proto = TRUE

            CASE "bcx_form"
            Stk$[Tmp] = "BCX_Form"
            Use_Form = Use_Proto = Use_MainEvent = TRUE

            IF NOT Use_BCX_Class_Info THEN
               Use_BCX_Class_Info = TRUE
               iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eClassName)
            END IF

            CASE "bcx_fontdlg"
            Stk$[Tmp] = "BCX_FontDlg"
            IF Tmp = Ndx THEN CONCAT(Stk$[Tmp],"()")
            Use_BCX_Fontdlg = TRUE
            Use_Hook = Use_BcxTmpStr = Use_Proto = TRUE

            CASE "bcx_floodfill"
            Stk$[Tmp] = "BCX_FloodFill"
            Use_BCX_Floodfill = Use_Proto = TRUE

            CASE "bcx_get"
            Stk$[Tmp] = "BCX_Get"
            Use_BCX_Get = Use_Proto = TRUE

            CASE "bcx_get_text$"
            Stk$[Tmp] = "$$BCX_Get_Text$"
            Use_GetText = Use_BcxTmpStr = TRUE

            CASE "bcx_getpixel"
            Stk$[Tmp] = "BCX_Getpixel"
            Use_BCX_Getpixel = Use_BcxTmpStr = TRUE

            CASE "bcx_grayrect"
            Stk$[Tmp] = "BCX_GrayRect"
            Use_Grayrect = Use_Proto = TRUE

            CASE "bcx_group"
            Stk$[Tmp] = "BCX_Group"
            Use_Group = Use_Proto = TRUE

            CASE "bcx_icon"
            Stk$[Tmp] = "BCX_Icon"
            Use_Icon = Use_GetResource = Use_Proto = TRUE

            CASE "bcx_input"
            Stk$[Tmp] = "BCX_Input"
            Use_BCX_Input = Use_Proto = TRUE

            CASE "bcx_label"
            Stk$[Tmp] = "BCX_Label"
            Use_Label = Use_GetTextSize = Use_Proto = TRUE

            CASE "bcx_line"
            Stk$[Tmp] = "BCX_Line"
            Use_BCX_Line = Use_Proto = TRUE

            CASE "bcx_lineto"
            Stk$[Tmp] = "BCX_Lineto"
            Use_BCX_Lineto = Use_Proto = TRUE

            CASE "bcx_listbox"
            Stk$[Tmp] = "BCX_Listbox"
            Use_Listbox = Use_Proto = TRUE

            CASE "bcx_listview"
            Stk$[Tmp] = "BCX_ListView"
            Use_Listview = Use_Proto = TRUE

            CASE  "bcx_loadbmp"
            Stk$[Tmp] = "BCX_LoadBMP"
            Use_BCX_LoadBMP = Use_Proto = TRUE

            CASE  "bcx_loadimage"
            Stk$[Tmp] = "BCX_LoadImage"
            Use_BCX_LoadImage = Use_GetResource = Use_Proto = TRUE

            CASE "bcx_print"
            Stk$[Tmp] = "BCX_Print"
            Use_BCX_Print = Use_Proto = TRUE

            CASE "bcx_polygon"
            Stk$[Tmp] = "BCX_Polygon"
            Use_BCX_Polygon = Use_Proto = TRUE

            CASE "bcx_polybezier"
            Stk$[Tmp] = "BCX_PolyBezier"
            Use_BCX_PolyBezier = Use_Proto = TRUE

            CASE "bcx_polyline"
            Stk$[Tmp] = "BCX_Polyline"
            Use_BCX_Polyline = Use_Proto = TRUE

            CASE "bcx_preset"
            Stk$[Tmp] = "BCX_Preset"
            Use_BCX_Preset = Use_Proto = TRUE

            CASE "bcx_pset"
            Stk$[Tmp] = "BCX_Pset"
            Use_BCX_Pset = Use_Proto = TRUE

            CASE "bcx_progressbar"
            Stk$[Tmp] = "BCX_ProgressBar"
            Use_ProgressBar = Use_Proto = TRUE

            CASE "bcx_put"
            Stk$[Tmp] = "BCX_Put"
            Use_BCX_Put = Use_Proto = TRUE

            CASE "bcx_radio"
            Stk$[Tmp] = "BCX_Radio"
            Use_Radio = Use_GetTextSize = Use_Proto = TRUE

            CASE "bcx_rectangle"
            Stk$[Tmp] = "BCX_Rectangle"
            Use_BCX_Rectangle = Use_BcxTmpStr = TRUE

            CASE "bcx_resize"
            Stk$[Tmp] = "BCX_RESIZE"
            Use_BCX_Resize = Use_SysMacros = TRUE

            CASE "bcx_richedit"
            Stk$[Tmp] = "BCX_RichEdit"
            Use_Richedit = Use_Proto = TRUE

            CASE "bcx_roundrect"
            Stk$[Tmp] = "BCX_Roundrect"
            Use_BCX_Roundrect = Use_Proto = TRUE

            CASE "bcx_slider"
            Stk$[Tmp] = "BCX_Slider"
            Use_BCX_Slider = Use_Label = Use_GetTextSize = Use_Proto = TRUE

            CASE "bcx_splitter"
            Stk$[Tmp] = "BCX_Splitter"
            Use_BCX_Splitter = Use_Proto = Use_Modstyle = TRUE

            CASE "bcx_setsplitpos"
            Stk$[Tmp] = "BCX_SetSplitPos"
            Use_BCX_Splitter = Use_Proto = Use_Modstyle = TRUE

            CASE "bcx_tab"
            Stk$[Tmp] = "BCX_Tab"
            Use_BCX_Tab = Use_Proto = TRUE

            CASE "bcx_toolbar"
            Stk$[Tmp] = "BCX_Toolbar"
            Use_BCX_Toolbar = Use_Proto = TRUE

            CASE "bcx_updown"
            Stk$[Tmp] = "BCX_UpDown"
            Use_BCX_UpDown = Use_Proto = TRUE

            CASE "bcx_version$"
            Stk$[Tmp] = ENC$(Version$)

            CASE "bcx_get_updown"
            Stk$[Tmp] = "BCX_Get_UpDown"
            Use_BCX_Get_UpDown = Use_Proto = Use_BcxTmpStr = TRUE

            CASE "bcx_set_form_color"
            Use_SetFormColor = Use_Proto = TRUE
            Stk$[Tmp] = "BCX_Set_Form_Color"
            IF Stk$[Tmp+1] <> "(" THEN
               InsertTokens(Tmp,1,"(")
               Stk$[++Ndx] = ")"
            END IF

            CASE "bcx_setclientsize"
            Use_Setclientsize = Use_Proto = TRUE
            Stk$[Tmp] = "BCX_SetClientSize"
            IF Stk$[Tmp+1] <> "(" THEN
               InsertTokens(Tmp,1,"(")
               Stk$[++Ndx] = ")"
            END IF

            CASE "bcx_set_font"
            Stk$[Tmp] = "BCX_Set_Font"
            Use_SetFont = Use_Proto = TRUE
            IF Stk$[Tmp+1] <> "(" THEN
               InsertTokens(Tmp,1,"(")
               Stk$[++Ndx] = ")"
            END IF

            CASE "bcx_setcolor"
            Stk$[Tmp] = "Set_Color"
            DIM RAW iPCnt = GetNumArgs(Tmp+2)

            IF iPCnt = 1 THEN
               InsertTokens(Ndx-1, 4, ",", "(HDC)wParam", ",", "(HWND)lParam")
            ELSEIF iPCnt = 2 THEN
               InsertTokens(Ndx-1, 2, ",", "(HWND)lParam")
            END IF
            Use_SetColor = Use_Proto = TRUE

            CASE "bcx_set_text"
            Stk$[Tmp] = "BCX_Set_Text"
            Use_SetText = Use_Proto = TRUE
            IF Stk$[Tmp+1] <> "(" THEN
               InsertTokens(Tmp,1,"(")
               Stk$[++Ndx] = ")"
            END IF

            CASE "bcx_status"
            Stk$[Tmp] = "BCX_Status"
            Use_Status = Use_Proto = TRUE

            CASE "bcx_stricmp"
            Stk$[Tmp] = "bcx_stricmp"
            Use_Bcx_stricmp = TRUE

            CASE "bcx_setconsolesize"
            Stk$[Tmp] = "BCX_SetConsoleSize"
            Use_Consolesize = Use_Console = Use_Proto = TRUE

            CASE "bcx_pushconsolesize"
            IF Stk$[Tmp+1] <> "(" THEN Stk$[Tmp] = "BCX_PushConsoleSize()"
            Use_Consolesize = Use_Console = Use_Proto = TRUE

            CASE "bcx_popconsolesize"
            IF Stk$[Tmp+1] <> "(" THEN Stk$[Tmp] = "BCX_PopConsoleSize()"
            Use_Consolesize = Use_Console = Use_Proto = TRUE

            CASE "bcx_tabselect"
            Stk$[Tmp] = "BCX_TabSelect(hWnd, lParam)"
            Use_BCX_Tab = Use_Proto = TRUE

            CASE "bcx_tile"
            Use_BCX_Tile = Use_Proto = TRUE
            Stk$[Tmp] = "BCX_Tile"
            IF Stk$[Tmp+1] <> "(" THEN
               InsertTokens(Tmp,1,"(")
               Stk$[++Ndx] = ")"
            END IF

            CASE "bcx_thread", "bcx_threadwait", "bcx_threadsuspend","bcx_threadresume","bcx_threadkill","bcx_threadend"
            Stk$[Tmp] = UCASE$(Stk$[Tmp])
            Use_Threads = Use_SysMacros = TRUE

            CASE "bcx_tooltip"
            Stk$[Tmp] = "Bcx_ToolTip"
            Use_BCX_ToolTip = Use_Proto = TRUE
            CALL AddGlobal("BCX_hWnd_ToolTip", vt_HWND)


            CASE "bcx_treeview"
            Stk$[Tmp] = "BCX_Treeview"
            Use_Treeview = Use_Proto = TRUE


            CASE "bcx_whiterect"
            Stk$[Tmp] = "BCX_WhiteRect"
            Use_Whiterect = Use_Proto = TRUE

            CASE "bcx_dispatchobject"
            ' x = DispatchObject(unknown,tf)
            ' BCX_DispatchObject (unknown, &x, tf)
            Use_BcxTmpStr = TRUE

            ComSwitchON = Use_COM      = TRUE
            Use_BCX_COM_CreateObject   = TRUE
            Use_BCX_COM_DispatchObject = TRUE
            Use_BCX_COM_GetObject      = TRUE
            Use_BCX_COM_GetProperty    = TRUE
            Use_BCX_COM_InvokeMethod   = TRUE
            Use_BCX_COM_SafeArray      = TRUE
            Use_BCX_COM_SetProperty    = TRUE
            Use_BCX_COM_UsesConversion = TRUE

            DIM szObj$ = "&"
            DIM szUnknown$ = ""
            DIM szRelease$ = ""
            DIM RAW iTobj AS INT

            iTobj = 1
            DO WHILE Stk$[iTobj] <> "="
               CONCAT(szObj$, Stk$[iTobj])
               INCR iTobj
            LOOP
            iTobj = Tmp+2
            DO WHILE Stk$[iTobj] <> "," AND Stk$[iTobj] <> ")"
               CONCAT(szUnknown$, Stk$[iTobj])
               INCR iTobj
            LOOP
            IF Stk$[iTobj] = ")" THEN
               szRelease$ = "TRUE"
            ELSE
               szRelease$ = Stk$[iTobj+1]
            END IF

            Stk$[1] = "BCX_DispatchObject"
            Stk$[2] = "("
            Stk$[3] = szUnknown$
            Stk$[4] = ","
            Stk$[5] = szObj$
            Stk$[6] = ","
            Stk$[7] = szRelease$
            Stk$[8] = ")"
            Ndx = 8

            CASE "bff$"
            Stk$[Tmp] = "$$BFF$"
            Use_Bff = Use_BcxTmpStr = TRUE

            CASE "bin$"
            Stk$[Tmp] = "$$Bin$"
            Use_Bin = Use_BcxTmpStr = TRUE

            CASE "bin2dec"
            Stk$[Tmp] = "Bin2Dec"
            Use_Bin2dec = Use_Proto = TRUE

            CASE "bool$"
            Stk$[Tmp] = "$$BoolStr$"
            Use_Boolstr = Use_BcxTmpStr = TRUE

            CASE "bool"
            Stk$[Tmp] = "BOOL"

            CASE "boolean"
            Stk$[Tmp] = "BOOLEAN"

            CASE "band"
            IF *Stk$[Tmp+1] = ASC("=") THEN
               Stk$[Tmp+1] = "&="
               Stk$[Tmp] = ""
               INCR TS_CompPtr
            ELSE
               Stk$[Tmp] = " & "
            END IF

            CASE "bnot"
            Stk$[Tmp] = " BNOT "
            Use_Bnot  = Use_SysMacros = TRUE

            CASE "bor"
            IF *Stk$[Tmp+1] = ASC("=") THEN
               Stk$[Tmp+1] = "|="
               Stk$[Tmp] = ""
               INCR TS_CompPtr
            ELSE
               Stk$[Tmp] = "|"
            END IF

         END SELECT

         CASE 3
         SELECT CASE Keyword$

            CASE "case"
            DIM RAW nBrace
            DIM RAW CntMarker

            nBrace = 0
            CntMarker = 2
            j = 0
            FOR i = 2 TO Ndx
               IF INCHR("([",Stk$[i]) THEN INCR nBrace
               IF INCHR(")]",Stk$[i]) THEN DECR nBrace
               IF Stk$[i] = ","  THEN
                  IF nBrace=0 THEN CntMarker = i + 1
               END IF
               IF iMatchWrd(Stk$[i],"to") THEN
                  j = 1
                  Stk$[i] = "&&" + CHR$(1) + "<="
                  Stk$[CntMarker] = ">=" + CHR$(1) + Stk$[CntMarker]
               END IF
            NEXT

            IF j=1 THEN
               Src$ = ""
               FOR i = 1 TO Ndx
                  Src$ = Src$ + Stk$[i] + CHR$(1)
               NEXT
               CALL FastLexer(Src$,CHR$(1),"",-1)
            END IF

            CASE "cast"
            Stk$[Tmp] = " CAST "
            Use_Cast = Use_SysMacros = TRUE



            CASE "callback"
            IF Tmp = 1 THEN
               IF Ndx > 5 THEN Warning("Extra Callback code truncated",1)
               Src$ = "FUNCTION|" + Stk$[3] + "(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK"
               FastLexer(Src$,"|",",()")
               CallBackFlag = TRUE
            END IF

            CASE "callwindowproc"
            '*****************************
            '    CallWindowProc HELPER
            '*****************************
            Stk$[Tmp] = "CallWindowProc"
            IF Stk$[Tmp+3] <> "WNDPROC" THEN InsertTokens(Tmp+1,3,"(","WNDPROC",")")


            CASE "com"
            Stk$[Tmp] = "COM"
            ComSwitchON = Use_COM = TRUE
            Use_BCX_COM_CreateObject   = TRUE
            Use_BCX_COM_DispatchObject = TRUE
            Use_BCX_COM_GetObject      = TRUE
            Use_BCX_COM_GetProperty    = TRUE
            Use_BCX_COM_InvokeMethod   = TRUE
            Use_BCX_COM_SafeArray      = TRUE
            Use_BCX_COM_SetProperty    = TRUE
            Use_BCX_COM_UsesConversion = TRUE


            CASE "createobject"
            ComSwitchON = Use_BCX_COM_UsesConversion = Use_BCX_COM_CreateObject = Use_COM = TRUE
            IF Stk$[2] = "[" THEN
               ' object from an array of objects
               ' SET oObj [ iii ] = createobject ("Excel.Application")
               ' BCX_CreateObject ("Excel.Application", & oTmp[iii]);
               DIM RAW iii
               iii = 2
               DO WHILE Stk$[iii] <> "="
                  CONCAT(Stk$[1],Stk$[iii])
                  *Stk$[iii] = 0
                  INCR TS_CompPtr
                  INCR iii
               LOOP
               CALL RemEmptyTokens
            END IF
            Stk$[3] = Stk$[5]
            sprintf(Stk[5],"&%s", Stk[1])
            Stk$[1] = "BCX_CreateObject"
            Stk$[2] = "("
            Stk$[4] = ","


            CASE "containedin"
            Stk$[Tmp] = "containedin"
            Use_ContainedIn = Use_Bcx_stricmp = TRUE

            CASE "cr$"
            Stk$[Tmp] = "CR$"
            Use_CR = Use_BcxTmpStr = TRUE

            CASE "close"
            DIM RAW iNextToken = Tmp+1
            IF *Stk$[iNextToken] = ASC("#") THEN
               Stk$[iNextToken] = MID$(Stk$[iNextToken],2)
            END IF

            CASE "closedialog"
            Ndx = 1
            IF ModDialogEvt THEN
               Stk$[Ndx] = "EndDialog(hWnd,0)"
            ELSE
               Stk$[Ndx] = "DestroyWindow(hWnd)"
            END IF

            CASE "cvd"
            Stk$[Tmp] ="CVD"
            Use_Cvd = Use_Proto = TRUE

            CASE "cvi"
            Stk$[Tmp] ="CVI"
            Use_Cvi = Use_Proto = TRUE

            CASE "cvl"
            Stk$[Tmp] ="CVL"
            Use_Cvl = Use_Proto = TRUE

            CASE "cvld"
            Stk$[Tmp] ="CVLD"
            Use_Cvld = Use_Proto = TRUE

            CASE "cvs"
            Stk$[Tmp] ="CVS"
            Use_Cvs = Use_Proto = TRUE

            CASE "chr$"
            Stk$[Tmp] = "$$chr$"
            Use_Chr = Use_BcxTmpStr = TRUE

            CASE "crlf$"
            Stk$[Tmp] = "CRLF$"
            Use_Crlf = Use_BcxTmpStr = TRUE

            CASE "createregstring"
            Stk$[Tmp] = "CreateRegString"
            Use_CreateRegString = Use_BcxTmpStr = TRUE

            CASE "createregint"
            Stk$[Tmp] = "CreateRegInt"
            Use_CreateRegInt = Use_BcxTmpStr = TRUE

            CASE "cdbl"
            Stk$[Tmp] = "CDBL"
            Use_Cdbl = Use_SysMacros = TRUE

            CASE "center"
            Stk$[Tmp] = "Center"
            Use_Center = Use_Proto = TRUE
            IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
               CALL InsertOptionalParens(Tmp+1)           'Allow unparenthesized expressions
            END IF

            CASE "cint"
            Stk$[Tmp] = "Cint"
            Use_Cint = Use_Proto = TRUE

            CASE "cldbl"
            Stk$[Tmp] = "CLDBL"
            Use_Cldbl = Use_SysMacros = TRUE

            CASE "clng"
            Stk$[Tmp] = "CLNG"
            Use_Clng = Use_Proto = TRUE

            CASE "clipboard_gettext","clipboard_gettext$"
            Stk$[Tmp] = "Clipboard_GetText$()"
            TS_CompPtr += Convert2SimpleFunction(Tmp)
            Use_Clip_Gettext = Use_BcxTmpStr = TRUE

            CASE "clipboard_getbitmap"
            Stk$[Tmp] = "Clipboard_GetBitmap()"
            TS_CompPtr += Convert2SimpleFunction(Tmp)
            Use_Clip_Getbitmap = TRUE

            CASE "clipboard_gettextsize"
            Stk$[Tmp] = "Clipboard_GetTextSize()"
            TS_CompPtr += Convert2SimpleFunction(Tmp)
            Use_Clip_Gettextsize = Use_Proto = TRUE

            CASE "clipboard_settext"
            Stk$[Tmp] = "Clipboard_SetText"
            Use_Clip_Settext = TRUE

            CASE "clipboard_setbitmap"
            Stk$[Tmp] = "Clipboard_SetBitmap"
            Use_Clip_Setbitmap = TRUE

            CASE "clipboard_reset"
            Stk$[Tmp] = "Clipboard_Reset"
            Use_Clip_Reset = Use_SysMacros = TRUE

            CASE "cls"
            Stk$[Tmp] = "cls"
            Use_Cls = TRUE
            Use_Locate = Use_Console = Use_Proto = Use_Cursor = TRUE

            CASE "color", "color_fg", "color_bg"
            Stk$[Tmp] = LCASE$(Stk$[Tmp])
            Use_Color = Use_Console = Use_Proto = TRUE

            CASE "command$"
            Use_Command = Use_BcxTmpStr = TRUE
            Stk$[Tmp] = "command$(-1)"
            IF Stk$ [Tmp+1] = "(" THEN
               Stk$ [Tmp]= "command$"
            END IF

            CASE "comboboxloadfile"
            Stk$[Tmp] = "ComboBoxLoadFile"
            Use_ComboBoxLoadFile = TRUE
            Use_BcxTmpStr = TRUE
            Use_Proto   = TRUE
            Use_Trim    = TRUE


            CASE "cbool"
            Stk$[Tmp] = "CBOOL"
            Use_Cbool = Use_SysMacros = TRUE
            DIM LOCAL iii, t, expos = 0
            DIM RAW fp AS functionParse : memset (&fp,0,SIZEOF(functionParse))  ' MrBcx 789
            IF SepFuncArgs(Tmp+1, &fp, TRUE) = 0 THEN
               CALL Abort("No argument specified in CBOOL")
            END IF

            FOR iii = fp.CommaPos[0] TO fp.CommaPos[1]
               t = INCHR("!<>=", Stk$[iii])
               IF t THEN
                  IF t < 4 THEN
                     IF Stk$[iii+1] = "=" THEN
                        Stk$[iii] = Stk$[iii] + Stk$[iii+1]
                        Stk$[iii+1] = ""
                        INCR TS_CompPtr
                     ELSEIF t = 1 AND Stk$[iii] <> "!=" THEN
                        ITERATE
                     END IF
                  ELSE
                     IF Stk$[iii+1] <> "=" THEN Stk$[iii] = "=="
                  END IF
                  expos = iii
                  EXIT FOR
               END IF
            NEXT

            t = DataType(Stk$[expos-1])
            IF t = vt_STRLIT OR t = vt_STRVAR THEN
               IF expos THEN
                  CONCAT(Stk$[Tmp+1],"strcmp(")
                  Stk$[fp.CommaPos[1]] = ")" + Stk$[expos] + "0)"
                  Stk$[expos] = ","
                  Src$ = ""
                  FOR iii = 1 TO Ndx
                     CONCAT(Src$, Stk$[iii])
                     CONCAT(Src$, SPC$)
                  NEXT
                  FastLexer(Src$,SPC$,"(),")
               END IF
            END IF

            CASE "csng"
            Stk$[Tmp] = "CSNG"
            Use_Csng = Use_SysMacros = TRUE

            CASE "cpad$"
            Stk$[Tmp] = "cpad$"
            Use_Cpad = Use_Join = Use_BcxTmpStr = TRUE


            CASE "cursorx"
            Stk$[Tmp] = "Pos()"
            Use_Pos  = Use_Proto = TRUE

            CASE "csrlin","cursory"
            Stk$[Tmp]  = "Csrlin()"
            Use_Csrlin = Use_Proto  = TRUE

            CASE "curdir$"
            Stk$[Tmp] = "curdir$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Curdir = Use_BcxTmpStr = TRUE

            CASE "c_declare"
            CallType$ = "__cdecl "
            Stk$[Tmp] = "declare"
            IF iMatchWrd(Stk$[4], "lib") THEN
               NoTypeDeclare = FALSE
            ELSE
               NoTypeDeclare = TRUE
            END IF

         END SELECT

         CASE 4
         SELECT CASE Keyword$

            CASE "datacount"
            Stk$[Tmp] = "DATACOUNT"
            Use_Datacount = Use_SysMacros = TRUE

            CASE "declare"
            CallType$ = "__stdcall "
            Stk$[Tmp] = "declare"
            IF NOT iMatchWrd(Stk$[4], "lib") THEN
               NoTypeDeclare = TRUE
            ELSE
               NoTypeDeclare = FALSE
            END IF

            CASE "dq$"
            Stk$[Tmp] = "DQ$"
            Use_DQ = Use_BcxTmpStr = TRUE

            CASE "ddq$"
            Stk$[Tmp] = "DDQ$"
            Use_DDQ = Use_BcxTmpStr = TRUE

            CASE "data"
            NoTrans = 1

            CASE "date$"
            IF Stk$[Tmp+1] <> "(" THEN
               Stk$[Tmp] = "date$()"
            ELSE
               Stk$[Tmp] = "date$"
            END IF
            Use_Date = Use_BcxTmpStr = TRUE

            CASE "del$"
            Stk$[Tmp] = "del$"
            Use_Del = Use_BcxTmpStr = Use_Proto = TRUE

            CASE "deleteregkey"
            Stk$[Tmp] = "DeleteRegKey"
            Use_DeleteRegKey = Use_BcxTmpStr = TRUE

            CASE "diskfree"
            Stk$[Tmp] = "(ULONGLONG) DiskFree"
            Use_Diskfree = Use_Proto = TRUE

            CASE "diskused"
            Stk$[Tmp] = "(ULONGLONG) DiskUsed"
            Use_Diskused = Use_Proto = TRUE

            CASE "disksize"
            Stk$[Tmp] = "(ULONGLONG) DiskSize"
            Use_Disksize = Use_Proto = TRUE

            CASE "dialog"
            IF iMatchWrd(Stk$[1],"begin") THEN
               IF Ndx = 4 AND iMatchWrd(Stk$[3],"as") THEN
                  InDialogEvt = TRUE
               ELSEIF Ndx = 5 AND iMatchWrd(Stk$[4],"as") THEN
                  'BEGIN MODAL DIALOG AS DialogOne
                  'function 'Stk$[Ndx]' (hWnd AS HWND, Msg AS UINT, wParam AS WPARAM, lParam AS LPARAM) AS INT_PTR CALLBACK
                  'INT_PTR CALLBACK DialogOne (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
                  ModDialogEvt = TRUE
               ELSE
                  CALL Abort("Malformed Begin Dialog")
               END IF
               Src$ = "function " + Stk$[Ndx] + "(hWnd AS HWND,Msg AS UINT,wParam AS WPARAM,lParam AS LPARAM) AS INT_PTR CALLBACK"
               FastLexer(Src$, SPC$, "(),")
            END IF

            CASE "destroysafearray"
            Stk$[Tmp] = "DestroySafeArray"
            Use_SafeArrays = TRUE

            CASE "doevents"
            Stk$[Tmp] = "DoEvents()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Doevents = Use_Proto = TRUE

            CASE "drawtransbmp"
            Stk$[Tmp] = "DrawTransBMP"
            Use_DrawTransBMP = Use_Proto = TRUE

            CASE "download"
            Stk$[Tmp] = "Download"
            Use_Download = Use_Proto = TRUE

            CASE "dsplit"
            Stk$[Tmp] = "DSplit"
            Use_BcxTmpStr = TRUE
            Use_UCaseTbl = TRUE
            Use_Stristr = TRUE
            Use_Proto  = TRUE
            Use_DSplit = TRUE
            Use_Remove = TRUE
            Use_Mid    = TRUE
            Use_Left   = TRUE
            Use_Instr  = TRUE
            Use_Replace = TRUE

         END SELECT

         CASE  5
         SELECT CASE Keyword$

            CASE "enddraw"
            Stk$[Tmp] = "EndDraw"
            Use_Draw = TRUE

            CASE "endmodal"
            Stk$[Tmp] = "EndModal"
            Use_Show = Use_SysMacros = Use_ShowModal = Use_EndModal = TRUE

            CASE "editloadfile"
            Stk$[Tmp] = "EditLoadFile"
            Use_BcxTmpStr = TRUE
            Use_SysMacros = TRUE
            Use_Elf     = TRUE
            Use_Exist   = TRUE
            Use_Get     = TRUE
            Use_Lof     = TRUE
            Use_Proto   = TRUE
            Use_Join    = TRUE


            CASE "enc$"
            Stk$[Tmp] = "$$enc$"
            Use_Enclose = Use_BcxTmpStr = TRUE

            CASE "extract$"
            Stk$[Tmp] = "$$extract$"
            Use_Extract = Use_BcxTmpStr = TRUE

            CASE "eof$"
            Stk$[Tmp] = "EF$"
            Use_EF = Use_BcxTmpStr = TRUE

            CASE "eof"
            Stk$[Tmp] = "EoF"
            Use_Eof = Use_BcxTmpStr = TRUE
            DIM RAW Tmp2 = Tmp + 2
            IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
               Stk$[Tmp2] = "FP" + Stk$[Tmp2]
            END IF

            CASE "equalto"
            Stk$[Tmp] = " EqualTo "
            Use_EqualTo = Use_SysMacros = TRUE


            CASE "esc$"
            Stk$[Tmp] = "ESC$"
            Use_ESC = Use_BcxTmpStr = TRUE

            CASE "enum"
            DIM RAW iNamedEnum = 0
            IF Tmp = 3 THEN
               iNamedEnum = iMatchWrd(Stk$[Tmp-1],"as")
            ELSE
               IF Ndx = 3 THEN
                  iNamedEnum = iMatchWrd(Stk$[Tmp+1],"as")
               END IF
            END IF
            IF Ndx = 1 OR iNamedEnum THEN
               Use_EnumFile = TRUE
               DIM RAW szNameOfEnum$
               '******************************************************
               '     We're dealing with a ENUM - END ENUM block
               '******************************************************
               DIM RAW EnumFlag = FALSE
               FPRINT FP_ENU, ""
               IF iNamedEnum THEN
                  IF Tmp = 3 THEN
                     szNameOfEnum$ = Stk$[Tmp-2]
                     FPRINT FP_ENU, "typedef enum _",szNameOfEnum$
                  ELSE
                     szNameOfEnum$ = Stk$[Tmp+2]
                     FPRINT FP_ENU, "typedef enum _",szNameOfEnum$
                  END IF
                  szNameOfEnum$ = SPC$ + szNameOfEnum$
               ELSE
                  szNameOfEnum$ = ""
                  FPRINT FP_ENU, "enum"
               END IF
               FPRINT FP_ENU, "  {"
               Src$ = ""
               DO WHILE NOT iMatchLft(Src$,"end ")

                  IF EOF(SourceFile) THEN
                     CALL Abort ("Unbalanced ENUM")
                  END IF

                  LINE INPUT SourceFile,Src$
                  INCR LineNum[FileNdx]
                  CALL StripCode(Src$)
                  IF iMatchLft(Src$,"$comme") THEN
                     DIM RAW ccc
                     CALL Docomment(Src$, &ccc)
                     ITERATE
                  END IF
                  Src$ = TRIM$(Src$)
                  IF ISNULL(Src$) THEN ITERATE ' line starts with comment
                  IF LEFTSTR(Src$ + SPC$, "end ", TRUE) THEN
                     EXIT DO
                  ELSE
                     IF EnumFlag = FALSE THEN
                        EnumFlag = TRUE
                     ELSE
                        FPRINT FP_ENU, ","
                     END IF
                  END IF
                  FPRINT FP_ENU, "    ",RTRIM$(Src$);
               LOOP
               Src$ = ""
               Ndx = 0
               FPRINT FP_ENU, ""
               FPRINT FP_ENU, "  }",szNameOfEnum$,";\n"
               EXIT SUB
            END IF
            DIM RAW iEquallLoc = Tmp+2
            IF Stk$[iEquallLoc] = "=" THEN
               'enum ONE=3
               'enum ONE{ONE=3};
               Stk$[Tmp] = "enum "
               CALL InsertTokens(iEquallLoc-1,2,"{",Stk$[Tmp+1])
               Stk$[++Ndx] = "}"
               EXIT SUB
            END IF

            '*************************************************************
            '  We're dealing with a smaller, single line ENUM statement
            '*************************************************************

            Stk$[1] = "enum {"
            FOR j = 2 TO Ndx
               CONCAT (Stk$[1], Stk$[j])
            NEXT
            CONCAT (Stk$[1], "}")
            Ndx = 1


            CASE "environ$"
            Stk$[Tmp] = "Environ$"
            Use_Environ = Use_BcxTmpStr = TRUE

            CASE "exist"
            Stk$[Tmp] = "Exist"
            Use_Exist = Use_Proto = Use_BcxTmpStr = TRUE

            CASE "exp"
            Stk$[Tmp] = "Exp"
            Use_Exp = Use_Proto = TRUE

         END SELECT


         CASE  6
         SELECT CASE Keyword$

            CASE "ff$"
            Stk$[Tmp] = "FF$"
            Use_FF = Use_BcxTmpStr = TRUE

            CASE "function"
            IF Stk$[Tmp+1] = "=" THEN
               IF Stk$[Tmp+2] = DDQ$ THEN Stk$[Tmp+2] = "NUL$"
               Stk$[Tmp] = "functionreturn"
            ELSE
               Stk$[Tmp] = "function"
               IF UseCpp OR UseCpphdr THEN CALL FuncSubTemplate(Tmp)
            END IF

            CASE "false"
            Stk$[Tmp] = "FALSE"

            CASE "findintype"
            'Convert this :FindInType(char *Token, Type.member, int c)
            'To this      :FindInType(char *Token, Stptr + offsetof(Type,member), sizeof(Type), int c)

            Stk$[Tmp] = "FindInType"
            Use_FindInType = Use_Proto = Use_Bcx_stricmp = TRUE

            DIM RAW StMem$, StName$, VarName$
            DIM RAW fp AS functionParse :  memset (&fp,0,SIZEOF(functionParse)) ' MrBcx 789
            CALL SepFuncArgs(Tmp, &fp, TRUE)

            StMem$   = REMAIN$(Clean$(GetArg$(2, &fp)),".")
            VarName$ = EXTRACT$(Clean$(GetArg$(2, &fp)),".")

            FOR j = fp.CommaPos[1] + 1 TO fp.CommaPos[2] - 1
               Stk$[j] = ""
               INCR TS_CompPtr
            NEXT

            IF CheckLocal(VarName$,&i) <> vt_UNKNOWN THEN
               StName$ = TypeDefs[LocalVars[i].VarDef].VarName$
            ELSEIF CheckGlobal(VarName$,&i) <> vt_UNKNOWN THEN
               StName$ = TypeDefs[GlobalVars[i].VarDef].VarName$
            END IF

            j = fp.CommaPos[1] + 1
            Stk$[j] =  "(char*)" + VarName$ + " + offsetof(" + StName$ + "," + StMem$ + "), sizeof(" + StName$ + ")"

            CASE "fillarray"
            Stk$[Tmp] = "fillarray"
            Use_FillArray = TRUE
            Use_Proto = TRUE

            CASE "findfirst$"
            Stk$[Tmp] = "findfirst$"
            Use_Findfirst = Use_BcxTmpStr = TRUE

            CASE "findfirstinstance"
            Stk$[Tmp] = "FindFirstInstance"
            Use_FirstInstance = TRUE

            CASE "findnext$"
            Stk$[Tmp] = "findnext$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Findnext = Use_BcxTmpStr = TRUE

            CASE "fint"
            Stk$[Tmp] = "FINT"
            Use_Fint = Use_SysMacros = TRUE

            CASE "fix"
            Stk$[Tmp] = "FIX"
            Use_Fix = Use_SysMacros = TRUE

            CASE "filelocked"
            Stk$[Tmp] = "FileLocked"
            Use_FileLocked = Use_Proto = TRUE

            CASE "frac"
            Stk$[Tmp] = "FRAC"
            Use_Fix = Use_Frac = Use_SysMacros = TRUE

            CASE "fracl"
            Stk$[Tmp] = "FRACL"
            Use_Fix = Use_Fracl = Use_SysMacros = TRUE

            CASE "freefile"
            Stk$[Tmp] = "FreeFile()"
            Use_Freefile = Use_Proto = TRUE

            CASE "function"
            IF Stk$[2] ?? "main" THEN NoMain = TRUE

         END SELECT

         CASE  7
         SELECT CASE Keyword$

            CASE "getdimension"
            Stk$[Tmp] = "GetDimension"
            Use_GetDimension = Use_Proto = TRUE


            CASE "getobject"
            ' COM version of getobject uses only one param,
            ' while Windows API has three params:  Ndx > 6.

            IF Ndx < 7 THEN
               ComSwitchON                = TRUE
               Use_COM = TRUE
               Use_BCX_COM_CreateObject   = TRUE
               Use_BCX_COM_DispatchObject = TRUE
               Use_BCX_COM_GetObject      = TRUE
               Use_BCX_COM_GetProperty    = TRUE
               Use_BCX_COM_InvokeMethod   = TRUE
               Use_BCX_COM_SafeArray      = TRUE
               Use_BCX_COM_SetProperty    = TRUE
               Use_BCX_COM_UsesConversion = TRUE

               Stk$[3] = Stk$[5]
               sprintf(Stk[5],"&%s", Stk[1])
               Stk$[1] = "BCX_GetObject"
               Stk$[2] = "("
               Stk$[4] = ","
            END IF

            CASE "getprocaddress"
            DIM LOCAL GlobalName$, s, GlobalNameHash, tempA$
            GlobalName$ = Stk$[Tmp-2]
            GlobalNameHash = HashNumber(GlobalName$)

            DO WHILE GlobalVarHash[GlobalNameHash]
               s = GlobalVarHash[GlobalNameHash]
               DIM RAW ptGlobal AS VarInfo PTR
               ptGlobal = &GlobalVars[s]
               IF GlobalName$ = ptGlobal->VarName$ THEN
                  tempA$ = TypeDefs[ptGlobal->VarDef].VarName$
                  IF ptGlobal->VarPntr THEN
                     CONCAT(tempA$, " *")
                  END IF
               END IF
               GlobalNameHash = IMOD(GlobalNameHash + 1,MaxGlobalVars)
            LOOP

            IF tempA$ = "" THEN
               DIM LOCAL LocalName$
               LocalName$ = Stk$[Tmp-2]
               IF LocalVarCnt THEN
                  FOR INT yy = 1 TO LocalVarCnt
                     IF LocalName$ = LocalVars[yy].VarName$ THEN
                        tempA$ = TypeDefs[LocalVars[yy].VarDef].VarName$
                        IF LocalVars[yy].VarPntr THEN
                           CONCAT(tempA$," *")
                        END IF
                        EXIT FOR
                     END IF
                  NEXT
               END IF
            END IF

            IF tempA$ <> "" THEN
               Stk$[Tmp] = "(" + tempA$ + ")GetProcAddress"
            ELSE
               Stk$[Tmp] = "GetProcAddress"
            END IF

            CASE "getattr"
            Stk$[Tmp] = "GETATTR"
            Use_Getattr = Use_SysMacros = TRUE

            CASE "gettextsize"
            Stk$[Tmp] = "GetTextSize"
            Use_GetTextSize = Use_Proto = TRUE

            CASE "getbmp"
            Stk$[Tmp] = "GetBmp"
            Use_GetBmp = Use_Proto = Use_BcxTmpStr = TRUE

            CASE "getdrive"
            Stk$[Tmp] = "_getdrive()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Getdrive = Use_Proto = TRUE

            CASE "getfilename$"
            Stk$[Tmp] = "$$GetFileName$"
            Use_Getfilename = Use_Hook = TRUE

            CASE "getresource"
            Stk$[Tmp] = "GetResource"
            Use_GetResource = Use_Proto = TRUE

            CASE "getspecialfolder$", "getspecialfolder"
            Stk$[Tmp] = "$$GetSpecialFolder$"
            Use_GetSpecialFolder = TRUE
            Use_Proto = Use_BcxTmpStr  = TRUE

            CASE "getspecialfolderex$"
            Stk$[Tmp] = "GetSpecialFolderEx$"
            Use_GetSpecialFolderex = TRUE
            Use_Proto = Use_BcxTmpStr  = TRUE
            Use_WideToAnsi = TRUE

         END SELECT

         CASE  8
         SELECT CASE Keyword$

            CASE "hex$"
            Stk$[Tmp] = "hex$"
            Use_Hex = Use_BcxTmpStr = TRUE

            CASE "hex2dec"
            Stk$[Tmp] = "Hex2Dec"
            Use_Hex2Dec = Use_Proto = TRUE

            CASE "hide"
            Stk$[Tmp] = "Hide"
            Use_Hide = Use_SysMacros = TRUE
            IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
               CALL InsertOptionalParens(Tmp+1)     'Allow unparenthesized expressions
            END IF

         END SELECT

         CASE  9
         SELECT CASE Keyword$

            CASE "icompare"
            Stk$[Tmp] = "bcx_stricmp"
            Use_Bcx_stricmp = TRUE

            CASE "instr"
            Stk$[Tmp] = "instr"
            Use_Instr = Use_Proto = TRUE
            Use_Stristr = Use_UCaseTbl = TRUE

            CASE "inchr"
            Stk$[Tmp] = "inchr"
            Use_Inchr = Use_Proto = TRUE

            CASE "imod"
            Stk$[Tmp] = "imod"
            Use_Imod = Use_SysMacros = TRUE

            CASE "iif"
            Stk$[Tmp] = "iif"
            Use_Iif = Use_Proto = TRUE
            FOR i = Tmp+1 TO Ndx
               IF Stk$[i] = "=" THEN
                  IF Stk$[i-1] <> "<" AND Stk$[i-1] <> ">" THEN
                     Stk$[i] = "=="
                  END IF
               END IF
            NEXT

            CASE "iif$"
            Stk$[Tmp] = "sziif$"
            Use_sziif = Use_Proto = TRUE
            FOR i = Tmp+1 TO Ndx
               IF Stk$[i] = "=" THEN
                  IF Stk$[i-1] <> "<" AND Stk$[i-1] <> ">" THEN
                     Stk$[i] = "=="
                  END IF
               END IF
            NEXT

            CASE "initsafearray"
            Stk$[Tmp] = "InitSafeArray"
            Use_SafeArrays = TRUE
            Stk$[Tmp+2] = "&"+Stk$[Tmp+2]


            CASE "inkey"
            Use_BcxTmpStr = Use_Proto = Use_InkeyD = TRUE
            Stk$[Tmp] = "inkeyd()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)

            CASE "inkey$"
            Use_BcxTmpStr = Use_Proto = Use_Inkey = TRUE
            Stk$[Tmp] = "inkey$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)

            CASE "inline"
            IF Tmp = 1 THEN
               Stk$[1] = ""
               UseInLine = TRUE
               CALL RemEmptyTokens
               DECR Tmp
            END IF

            CASE "inputbox$"
            Stk$[Tmp] = "InputBox$"
            Use_BoxCommon = Use_Inputbox = Use_BcxTmpStr = TRUE

            CASE "infobox"
            Stk$[Tmp] = "InfoBox"
            Use_BoxCommon = Use_Infobox = Use_BcxTmpStr = TRUE

            CASE "ins$"
            Stk$[Tmp] = "ins$"
            Use_Ins = Use_Proto = Use_BcxTmpStr = TRUE

            CASE "instrrev"
            Stk$[Tmp] = "InstrRev"
            Use_Instrrev = Use_Proto = TRUE

            CASE "isodate$"
            IF Stk$[Tmp+1] <> "(" THEN
               Stk$[Tmp] = "isodate$()"
            ELSE
               Stk$[Tmp] = "isodate$"
            END IF
            Use_IsoDate = Use_BcxTmpStr = TRUE

            CASE "isptr"
            Stk$[Tmp] = "IsPtr"
            Use_Isptr = Use_SysMacros = TRUE

            CASE "istrue"
            Stk$[Tmp] = "ISTRUE"
            Use_Istrue = Use_SysMacros = TRUE

            CASE "isfalse"
            Stk$[Tmp] = "ISFALSE"
            Use_Isfalse = Use_SysMacros = TRUE

            CASE "iszero"
            Stk$[Tmp] = "ISZERO"
            Use_Iszero = Use_SysMacros = TRUE

            CASE "isnull"
            Stk$[Tmp] = "ISNULL"
            Use_Isnull = Use_SysMacros = TRUE

            CASE "issystem"
            Stk$[Tmp] = "issystem"
            Use_Issystem = Use_BcxTmpStr = TRUE

            CASE "ishidden"
            Stk$[Tmp] = "ishidden"
            Use_Ishidden = Use_BcxTmpStr = TRUE

            CASE "isreadonly"
            Stk$[Tmp] = "isreadonly"
            Use_Isreadonly = Use_BcxTmpStr = TRUE

            CASE "isfile"
            Stk$[Tmp] = "isfile"
            Use_Isfile = Use_BcxTmpStr = TRUE

            CASE "isfolder"
            Stk$[Tmp] = "isfolder"
            Use_Isfolder = Use_BcxTmpStr = TRUE

            CASE "ireplace$"
            Stk$[Tmp] = "iReplace$"
            Use_iReplace = Use_Stristr = Use_BcxTmpStr = TRUE
            Use_UCaseTbl = TRUE

            CASE "iremove$"
            Stk$[Tmp] = "IRemoveStr$"
            Use_IRemove = Use_BcxTmpStr = TRUE
            Use_Stristr = Use_UCaseTbl = TRUE

         END SELECT

         CASE  10
         SELECT CASE Keyword$
            CASE "join$"
            Stk$[Tmp] = "$$join$"
            Use_Join = Use_BcxTmpStr = TRUE
         END SELECT

         CASE  11
         SELECT CASE Keyword$
            CASE "keypress"
            Stk$[Tmp] = "keypress()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Keypress = Use_Proto = TRUE
         END SELECT

         CASE  12
         SELECT CASE Keyword$
            CASE "local"
            DIM RAW iNextWrd = Tmp + 1
            IF iMatchWrd(Stk$[iNextWrd],"dynamic") THEN
               Stk$[Tmp] = "dim"
            END IF

            CASE "lccpath$"
            Stk$[Tmp] = "LccPath$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)

            Use_LccPath = Use_RegString = Use_Instrrev = TRUE
            Use_Left = Use_BcxTmpStr = TRUE

            CASE "loadfile$"
            Stk$[Tmp] = "$$LoadFile$"
            Use_LoadFile = Use_Get = Use_BcxTmpStr = TRUE
            Use_SysMacros = Use_Exist = Use_Lof = TRUE

            CASE "listboxloadfile"
            Stk$[Tmp] = "ListBoxLoadFile"
            Use_ListBoxLoadFile = TRUE
            Use_GetTextSize     = TRUE
            Use_Proto   = TRUE
            Use_Trim    = TRUE
            Use_String  = TRUE
            Use_BcxTmpStr     = TRUE

            CASE "lf$"
            Stk$[Tmp] = "LF$"
            Use_LF = Use_BcxTmpStr = TRUE

            CASE "line"
            IF iMatchWrd(Stk$[Tmp+1],"input") THEN
               Stk$[Tmp] = "lineinput"
               j = Tmp + 4
               Stk$[Tmp+1] = ""      ' Extract the file handle
               INCR TS_CompPtr
               FOR i = Tmp+2 TO Ndx
                  IF *Stk$[i] = ASC(",") THEN j=i+1 : EXIT FOR
                  Stk$[Tmp+1] = Stk$[Tmp+1] + Stk$[i]
                  Stk$[i] = ""
               NEXT j

               FOR i = j TO Ndx
                  Stk$[Tmp+2]= Stk$[Tmp+2] + Stk$[i]
               NEXT
            END IF

            CASE "lcase$"
            IF iSubLoc = 2 THEN
               IF Stk$[Tmp+1] = "(" THEN
                  Abort( "'lcase' can only be used as a Function Pointer when in a SET")
               END IF
               Stk$[Tmp] = "lcase"
            ELSE
               Stk$[Tmp] = "$$lcase$"
            END IF
            Use_Lcase = Use_BcxTmpStr = TRUE

            CASE "ldouble"
            Stk$[Tmp] = "LDOUBLE"
            Use_Ldouble = Use_BcxTmpStr = TRUE

            CASE "left$"
            Stk$[Tmp] = "$$left$"
            Use_Left = Use_BcxTmpStr = TRUE

            CASE "leftstr"
            Stk$[Tmp] = "LeftStr"
            Use_LeftStr = Use_Left = Use_Lcase = Use_BcxTmpStr = TRUE

            CASE "lprint"
            Stk$[Tmp] = "lprint"
            IF Tmp = Ndx THEN
               INCR Ndx
               Stk$[Ndx] = ENC$ ("")  ' Allow LPRINT with no args
            END IF

            CASE "lpad$"
            Stk$[Tmp] = "$$lpad$"
            Use_Lpad = Use_BcxTmpStr = TRUE

            CASE "ltrim$"
            Stk$[Tmp] = "$$ltrim$"
            Use_Ltrim = Use_BcxTmpStr = TRUE

            CASE "lof"
            Stk$[Tmp] = "lof"
            DIM RAW Tmp2 = Tmp + 2
            IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
               Stk$[Tmp2] = "FP" + Stk$[Tmp2]
            END IF
            Use_Lof = Use_Proto = TRUE

            CASE "like"
            Stk$[Tmp] = "like"
            Use_Like  = Use_Proto = TRUE

            CASE "loc"
            DIM RAW Tmp2 = Tmp + 2
            IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
               Stk$[Tmp2] = "FP" + Stk$[Tmp2]
            END IF
            Stk$[Tmp] = "loc(" + Stk$[Tmp2] + "," + Stk$[Tmp2] + "len)"
            Stk$[Tmp + 1] = ""
            Stk$[Tmp2] = ""
            Stk$[Tmp + 3] = ""
            INCR TS_CompPtr
            Use_Loc = TRUE

            CASE "locate"
            Stk$[Tmp] = "locate"
            Use_Locate = Use_Console = Use_Proto = Use_Cursor = TRUE

            CASE "longestline"
            Stk$[Tmp] = "LongestLine"
            Use_Longestline = Use_Eof = Use_Proto = TRUE

         END SELECT

         CASE  13
         SELECT CASE Keyword$

            ' *********************************************************
            ' Special Case Handler: Substitute "Me." with "Me->"
            ' *********************************************************

            CASE "me"
            Stk$[Tmp] = "Me"
            DIM RAW Tmp1 = Tmp + 1
            IF *Stk$[Tmp1] = ASC(".") THEN
               IF InFunction THEN Stk$[Tmp1] = "->" + MID$(Stk$[Tmp1],2)
            END IF

            CASE "mkd$"
            IF Tmp > 2 THEN
               IF INCHR(Stk$[Tmp-2],"$") AND *Stk$[Tmp-1] = ASC("=") THEN
                  Stk$[1] = "memcpy(" + Stk$[1]
                  Stk$[Tmp-1] = ","
                  Stk$[++Ndx] = ",9)"
               END IF
            END IF
            Stk$[Tmp] ="MKD"
            Use_Mkd = Use_BcxTmpStr = TRUE

            CASE "mki$"
            IF Tmp > 2 THEN
               IF INCHR(Stk$[Tmp-2],"$") AND *Stk$[Tmp-1] = ASC("=") THEN
                  Stk$[1] = "memcpy(" + Stk$[1]
                  Stk$[Tmp-1] = ","
                  Stk$[++Ndx] = ",3)"
               END IF
            END IF
            Stk$[Tmp] ="MKI"
            Use_Mki = Use_BcxTmpStr = TRUE

            CASE "mkl$"
            IF Tmp > 2 THEN
               IF INCHR(Stk$[Tmp-2],"$") AND *Stk$[Tmp-1] = ASC("=") THEN
                  Stk$[1] = "memcpy(" + Stk$[1]
                  Stk$[Tmp-1] = ","
                  Stk$[++Ndx] = ",5)"
               END IF
            END IF
            Stk$[Tmp] ="MKL"
            Use_Mkl = Use_BcxTmpStr = TRUE

            CASE "mkld$"
            IF Tmp > 2 THEN
               IF INCHR(Stk$[Tmp-2],"$") AND *Stk$[Tmp-1] = ASC("=") THEN
                  Stk$[1] = "memcpy(" + Stk$[1]
                  Stk$[Tmp-1] = ","
                  Stk$[++Ndx] = ",11)"
               END IF
            END IF
            Stk$[Tmp] ="MKLD"
            Use_Mkld = Use_BcxTmpStr = TRUE

            CASE "mks$"
            IF Tmp > 2 THEN
               IF INCHR(Stk$[Tmp-2],"$") AND *Stk$[Tmp-1] = ASC("=") THEN
                  Stk$[1] = "memcpy(" + Stk$[1]
                  Stk$[Tmp-1] = ","
                  Stk$[++Ndx] = ",5)"
               END IF
            END IF
            Stk$[Tmp] ="MKS"
            Use_Mks = Use_BcxTmpStr = TRUE

            CASE "mid$"
            IF Tmp > 1 THEN
               Stk$[Tmp] = "$$mid$"
               Use_Mid = Use_BcxTmpStr = TRUE
            ELSE
               Stk$[Tmp] = "midstr"
               Use_Midstr = TRUE
            END IF

            CASE "min"
            Stk$[Tmp] = "MIN"
            Use_Min = Use_Proto = TRUE

            CASE "max"
            Stk$[Tmp] = "MAX"
            Use_Max = Use_Proto = TRUE

            CASE "mcase$"
            IF iSubLoc = 2 THEN
               IF Stk$[Tmp+1] = "(" THEN
                  Abort( "'mcase' can only be used as a Function Pointer when in a SET")
               END IF
               Stk$[Tmp] = "mcase"
            ELSE
               Stk$[Tmp] = "$$mcase$"
            END IF
            Use_Mcase = Use_BcxTmpStr = TRUE

            CASE "mkpath"
            Stk$[Tmp] = "MkPath"
            Use_Mkpath = Use_Chr = Use_Instr = Use_Mid =TRUE
            Use_Join = Use_Split = Use_Replace = Use_UCaseTbl = TRUE
            Use_Proto = Use_Remove = Use_BcxTmpStr = Use_Stristr = TRUE

            CASE "modstyle"
            Stk$[Tmp] = "ModStyle"
            Use_Modstyle = Use_Proto = TRUE

            CASE "msgbox"
            DIM RAW Tmm1 = Tmp - 1
            IF Stk$[Tmm1]= "=" OR iMatchWrd(Stk$[Tmm1], "if") OR iMatchWrd(Stk$[Tmm1], "elseif") THEN
               Stk$[Tmp] = "MsgBox"
               Use_Msgbox = Use_Proto = TRUE
            END IF
         END SELECT

         CASE  14
         SELECT CASE Keyword$

            CASE "new"
            IF iMatchWrd(Stk$[Tmp-1],"binary") THEN EXIT SELECT
            UseCpp = TRUE
            Stk$[Tmp] = "new "

            CASE "nextlinelen"
            Stk$[Tmp] = "NextLineLen"
            Use_Nextlinelen = Use_Proto = TRUE

            ' For compatibility with VB code, See CreateObject for more details what I'm doin' here

            CASE "nothing"
            ComSwitchON = Use_COM = TRUE

            ' Next line should be called only if NOT inside (IF...END IF)
            ' BCX_Remove_COM_Object(Stk$[1]) '  disabled until I figure out is it called from (IF...END IF)

            DIM RAW sObj$
            DIM RAW ii = 2
            sObj$ = "&" + Stk$[1]
            DO WHILE Stk$[ii] <> "="
               CONCAT(sObj$, Stk$[ii])
               INCR ii
            LOOP

            Stk$[1] = "BCX_SetNothing"
            Stk$[2] = "("
            Stk$[3] = sObj$
            Stk$[4] = ")"
            Ndx = 4

            CASE "notzero"
            Stk$[Tmp] = "NOTZERO"
            Use_Notzero = Use_SysMacros = TRUE

            CASE "notnull"
            Stk$[Tmp] = "NOTNULL"
            Use_Notnull = Use_SysMacros = TRUE

            CASE "notequalto"
            Stk$[Tmp] = " NotEqualTo "
            Use_NotEqualTo = Use_SysMacros = TRUE

            CASE "nul$"
            Stk$[Tmp] = "NUL$"
            Use_NUL = Use_BcxTmpStr = TRUE

            CASE "now$"
            IF Stk$[Tmp+1]<> "(" THEN
               Stk$[Tmp] = "now$()"
            ELSE
               Stk$[Tmp] = "now$"
            END IF
            Use_Now = Use_BcxTmpStr = TRUE
         END SELECT

         CASE  15
         SELECT CASE Keyword$

            CASE "object"
            ComSwitchON = Use_COM = Use_BcxTmpStr = TRUE
            Stk$[Tmp] = "OBJECT"

            CASE "open"
            FOR A = Tmp+1 TO Ndx
               IF *Stk$[A] = ASC("#") THEN
                  Stk$[A] = MID$(Stk$[A],2)
                  EXIT FOR
               END IF
            NEXT

            CASE "oct$"
            Stk$[Tmp] = "oct$"
            Use_Oct = Use_BcxTmpStr = TRUE

            CASE "or", "orelse"                  ' OR can be Boolean or bitwise
            Stk$[Tmp] = " || "                   ' but ORELSE is ALWAYS Boolean


            CASE "osversion"
            Stk$[Tmp] = "OSVersion()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            CALL EmitOSVersionEnum
            Use_OSVersion = Use_Proto = TRUE

         END SELECT

         CASE  16
         SELECT CASE Keyword$

            CASE "pellespath$"
            Stk$[Tmp] = "PellesPath$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_PellesPath = Use_RegString = Use_Instrrev = TRUE
            Use_Left = Use_BcxTmpStr = TRUE

            CASE "printer"
            DIM RAW Tmp1 = Tmp+1
            IF *Stk$[Tmp1] THEN
               IF iMatchWrd(Stk$[Tmp1],"open")      THEN Stk$[Tmp] = "printeropen"
               IF iMatchWrd(Stk$[Tmp1],"ejectpage") THEN Stk$[Tmp] = "ejectpage"
               IF iMatchWrd(Stk$[Tmp1],"close")     THEN Stk$[Tmp] = "printerclose"

               IF iMatchWrd(Stk$[Tmp],"printer")    THEN
                  CALL Abort ("Unknown word '" + Stk$[Tmp1] + "' with printer")
               END IF

               LShiftStk(Tmp1)
            ELSE
               Ndx = 0
            END IF
            Use_Printer = Use_Proto = TRUE
            iEmitVarGroup = iEmitVarGroup BOR ePrinterGroup
            Use_Mid = Use_Left = TRUE
            Use_Extract = Use_Str = Use_BcxTmpStr = TRUE

            CASE "print"
            IF *Stk$[Tmp+1] = ASC("#") THEN
               Stk$[Tmp] = "fprint"
               Stk$[Tmp+1] = MID$(Stk$[Tmp+1],2)
            END IF

            CASE "ptr"
            TS_CompPtr  = 1
            CONCAT(Stk$[Tmp-1], "*")
            Stk$[Tmp] = ""
            IF Tmp = Ndx THEN
               DECR Ndx
               DO WHILE TALLY(Stk$[Ndx],"*") = LEN(Stk$[Ndx])
                  CONCAT(Stk$[Ndx-1], Stk$[Ndx])
                  Stk$[Ndx] = ""
                  DECR Ndx
               LOOP
            ELSE
               i = Tmp-1
               DO WHILE TALLY(Stk$[i],"*") = LEN(Stk$[i])
                  CONCAT(Stk$[i-1],Stk$[i])
                  Stk$[i--] = ""
               LOOP
            END IF

            CASE "panel"
            Stk$[Tmp] = "panel"
            Use_Panel = Use_Console = Use_Proto = Use_Cursor = TRUE

            CASE "pause"
            Stk$[Tmp] = "Pause()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Pause = Use_Proto = TRUE

            CASE "peek$"
            Stk$[Tmp] = "$$peekstr$"
            Use_PeekStr = Use_BcxTmpStr = TRUE

            CASE "playwav"
            Stk$[Tmp] = "PlayWav"
            Use_PlayWav = Use_GetResource = Use_Proto = TRUE

            CASE "pos"
            Stk$[Tmp] = "Pos()"
            Use_Pos   = Use_Proto = TRUE

            CASE "pushcolors"
            Stk$[Tmp]  = "PushColors()"
            Use_PushPopColors = Use_Color = Use_Console = Use_Proto = TRUE

            CASE "popcolors"
            Stk$[Tmp]  = "PopColors()"
            Use_PushPopColors = Use_Color = Use_Console = Use_Proto = TRUE


            CASE "private"
            IF iMatchWrd(Stk$[Tmp+1],"const") THEN
               Stk$[Tmp] = "enum "
               Stk$[Tmp+1]= Stk$[Tmp+2] + "{"
               INCR Ndx
               Stk$[Ndx]= "}"
            ELSE
               Stk$[1] = "private"
            END IF
         END SELECT

         CASE  17
         SELECT CASE Keyword$
            CASE "qbcolor"
            Stk$[Tmp] = "qbcolor"
            Use_QBColor = Use_Proto = TRUE
         END SELECT

         CASE  18
         SELECT CASE Keyword$

            CASE "read"
            Stk$[Tmp] = "READNUM"
            Use_Readnum = Use_SysMacros = Use_Proto = TRUE

            CASE "read$"
            Stk$[Tmp] = "READ$"
            Use_Read = Use_SysMacros = Use_Proto = TRUE

            CASE "rewind"
            Stk$[Tmp] = "rewind"
            DIM RAW Tmp2 = Tmp + 2
            IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
               Stk$[Tmp2] = "FP" + Stk$[Tmp2]
            END IF

            CASE "remove$"
            Stk$[Tmp] = "$$RemoveStr$"
            Use_Remove = Use_BcxTmpStr = TRUE

            CASE "replace$"
            Stk$[Tmp] = "$$replace$"
            Use_Replace = Use_BcxTmpStr = TRUE

            CASE "right$"
            Stk$[Tmp] = "$$right$"
            Use_Right = Use_BcxTmpStr = TRUE

            CASE "rightstr"
            Stk$[Tmp] = "RightStr"
            Use_RightStr = Use_Right = Use_Lcase = Use_BcxTmpStr = TRUE


            CASE "randomize"
            Stk$[Tmp] = "randomize"
            Use_Randomize = TRUE
            Use_Rnd   = TRUE
            Use_Proto = TRUE
            IF Ndx = 1 THEN
               Use_Timer = TRUE
               Stk$[1] ="randomize(timer())"
            END IF
            IF Ndx = 2 AND Stk$[2] ?? "timer" THEN
               Use_Timer = TRUE
               Ndx = 1
               Stk$[1] ="randomize(timer())"
            END IF
            IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
               CALL InsertOptionalParens(Tmp+1)  'Allow unparenthesized expressions
            END IF

            CASE "rec"
            DIM RAW Tmp2 = Tmp + 2
            IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
               Stk$[Tmp2] = "FP" + Stk$[Tmp2]
            END IF
            Stk$[Tmp] = "rec(" + Stk$[Tmp2] + "," + Stk$[Tmp2] + "len)"
            Stk$[Tmp + 1] = ""
            Stk$[Tmp2] = ""
            Stk$[Tmp + 3] = ""
            INCR TS_CompPtr
            Use_Rec = Use_Proto = TRUE

            CASE "reccount"
            DIM RAW length$
            DIM RAW Tmp2 = Tmp + 2
            IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
               Stk$[Tmp2] = "FP" + Stk$[Tmp2]
            END IF

            Stk$[Tmp] = "reccount"
            length$ = Stk$[Tmp2] + "len)"

            FOR i = Tmp+1 TO Ndx
               IF *Stk$[i] = ASC(")") THEN
                  Stk$[i] = ""
                  INCR TS_CompPtr
                  EXIT FOR
               END IF
               Stk$[Tmp] = Stk$[Tmp] + Stk$[i]
               Stk$[i] = ""
               INCR TS_CompPtr
            NEXT

            Stk$[Tmp] = Stk$[Tmp] + "," + length$
            Use_RecCount = Use_Proto = TRUE

            CASE "refresh"
            Stk$[Tmp] = "Refresh"
            Use_Refresh = Use_SysMacros = TRUE

            CASE "regstring$"
            Stk$[Tmp] = "$$RegString$"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_RegString = Use_BcxTmpStr = TRUE

            CASE "regexist"
            Stk$[Tmp] = "RegExist"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_RegExist = Use_BcxTmpStr = TRUE

            CASE "regint"
            Stk$[Tmp] = "RegInt"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_RegInt = Use_BcxTmpStr = TRUE

            CASE "remain$"
            Stk$[Tmp] = "$$remain$"
            Use_Remain = Use_BcxTmpStr = TRUE

            CASE "retain$"
            Stk$[Tmp] = "$$Retain$"
            Use_Retain = Use_BcxTmpStr = TRUE

            CASE "repeat$"
            Stk$[Tmp] = "$$repeat$"
            Use_Repeat = Use_BcxTmpStr = TRUE

            CASE "reverse$"
            Stk$[Tmp] = "$$reverse$"
            Use_Reverse = Use_BcxTmpStr = TRUE

            CASE "rnd"
            Stk$[Tmp] = "rnd()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Rnd = Use_Proto = TRUE

            CASE "rnd2"
            Stk$[Tmp] = "rnd2"
            Use_Rnd2 = Use_Proto = TRUE

            CASE "round"
            Stk$[Tmp] = "Round"
            Use_Round = Use_Proto = TRUE

            CASE "rpad$"
            Stk$[Tmp] = "$$rpad$"
            Use_Rpad = Use_BcxTmpStr = TRUE

            CASE "rtrim$"
            Stk$[Tmp] = "$$rtrim$"
            Use_Rtrim = Use_BcxTmpStr = TRUE

            CASE "run"
            Stk$[Tmp] = "Run"
            Use_Run = Use_Proto = TRUE
         END SELECT

         CASE  19
         SELECT CASE Keyword$

            CASE "setdimension"
            Stk$[Tmp] = "SetDimension"
            Use_SetDimension = Use_Proto = TRUE

            CASE "spc$"
            Stk$[Tmp] = "SPC$"
            Use_SPC = Use_BcxTmpStr = TRUE

            CASE "startdraw"
            Stk$[Tmp] = "StartDraw"
            Use_Draw = TRUE

            CASE "str$"
            Stk$[Tmp] = "$$str$"
            Use_Str = Use_BcxTmpStr = TRUE

            CASE "strl$"
            Stk$[Tmp] = "$$strl$"
            Use_Strl = Use_BcxTmpStr = TRUE

            CASE "str2variant"
            'INPUT:
            ' str2variant(string,variant)
            'TRANSFORMS TO
            ' COM_AS2WS(sBuf)
            ' lComVariant.vt = VT_BSTR
            ' lComVariant.bstrVal = SysAllocString(COM_LPWSTR_temp)
            CALL Add2SplitLines("COM_AS2WS(" + Stk$[Tmp+2] + ")" )
            CALL Add2SplitLines(Stk$[Tmp+4] + ".vt = VT_BSTR")
            CALL Add2SplitLines(Stk$[Tmp+4] + ".bstrVal = SysAllocString(COM_LPWSTR_temp)")
            Ndx = 0


            CASE "searchpath$"
            Stk$[Tmp] = "$$SEARCHPATH$"
            Use_SearchPath = Use_BcxTmpStr  = TRUE

            CASE "sendmessage", "sndmsg"
            '*****************************
            '    SendMessage HELPER
            '*****************************
            IF NOT iMatchWrd(Stk$[1],"const") THEN
               Stk$[Tmp] = "SendMessage"
               Comma = i = 0
               A = Tmp+1

               DO

                  IF A > Ndx THEN
                     CALL Abort("Malformed SendMessage")
                  END IF

                  INCR A
                  IF INCHR("([{",Stk$[A]) THEN INCR i
                  IF INCHR(")]}",Stk$[A]) THEN DECR i
                  IF NOTZERO(i) THEN ITERATE

                  IF *Stk$[A] = ASC(",") THEN
                     IF Comma = 0 THEN
                        IF ISFALSE(iMatchWrd(Stk$[A+2],"UINT")) THEN
                           InsertTokens(A,3,"(","UINT",")")
                        END IF
                     ELSEIF Comma = 1 THEN
                        IF ISFALSE(iMatchWrd(Stk$[A+2],"WPARAM")) THEN
                           InsertTokens(A,3,"(","WPARAM",")")
                        END IF
                     ELSEIF Comma = 2 THEN
                        IF ISFALSE(iMatchWrd(Stk$[A+2],"LPARAM")) THEN
                           InsertTokens(A,3,"(","LPARAM",")")
                        END IF
                        EXIT DO
                     END IF
                     INCR Comma
                  END IF    'Is a comma
               LOOP
            END IF

            CASE "savebmp"
            Stk$[Tmp] = "SaveBmp"
            Use_SaveBmp = Use_Proto = Use_BcxTmpStr = TRUE

            CASE "set_bcx_bitmap"
            Stk$[Tmp] = "Set_BCX_Bitmap"
            Use_Set_BCX_Bitmap = Use_BcxTmpStr = TRUE

            CASE "set_bcx_bitmap2"
            Stk$[Tmp] = "Set_BCX_Bitmap2"
            Use_Set_BCX_Bitmap2 = Use_BcxTmpStr = TRUE

            CASE "set_bcx_bmpbutton"
            Stk$[Tmp] = "Set_BCX_BmpButton"
            Use_Set_BCX_BmpButton = Use_BcxTmpStr = TRUE

            CASE "set_bcx_icon"
            Stk$[Tmp] = "Set_BCX_Icon"
            Use_Proto = TRUE
            Use_Set_BCX_Icon = Use_GetResource = TRUE

            CASE "screen"
            Stk$[Tmp] = "Screen"
            Use_Screen = Use_Proto = TRUE

            CASE "setattr"
            Stk$[Tmp] = "SETATTR"
            Use_Setattr = Use_SysMacros = TRUE

            CASE "setwindowrtftext"
            Stk$[Tmp] = "SetWindowRTFText"
            Use_Richedit = Use_BcxTmpStr = TRUE

            CASE "sgn"
            Stk$[Tmp] = "sgn"
            Use_Sgn = Use_Proto = TRUE

            CASE "show"
            Stk$[Tmp] = "Show"
            Use_Show = Use_SysMacros = TRUE
            IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
               CALL InsertOptionalParens(Tmp+1)  'Allow unparenthesized expressions
            END IF

            CASE "sleep"
            Stk$[Tmp] = "Sleep"
            IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
               CALL InsertOptionalParens(Tmp+1)  'Allow unparenthesized expressions
            END IF

            CASE "showmodal"
            Stk$[Tmp] = "ShowModal"
            Use_Show = Use_SysMacros = Use_ShowModal = Use_EndModal = TRUE

            CASE "space$"
            Stk$[Tmp] = "$$space$"
            Use_Space = Use_BcxTmpStr = TRUE

            CASE "sound"
            Stk$[Tmp] = "Sound"
            Use_Sound = Use_Round = Use_Str = Use_BcxTmpStr = TRUE ' Use_Abs = TRUE

            CASE "split"
            Stk$[Tmp] = "Split"
            Use_Proto = TRUE
            Use_BcxTmpStr   = TRUE
            Use_UCaseTbl = TRUE
            Use_Stristr = TRUE
            Use_Split = TRUE
            Use_Remove= TRUE
            Use_Mid   = TRUE
            Use_Left  = TRUE
            Use_Instr = TRUE
            Use_Replace = TRUE

            CASE "strim$"
            Stk$[Tmp] = "$$strim$"
            Use_Strim = Use_BcxTmpStr = TRUE

            CASE "string$"
            Stk$[Tmp] = "$$stringx$"
            Use_String = Use_BcxTmpStr = TRUE

            CASE "strptr"
            Stk$[Tmp] = "STRPTR"
            Use_Strptr = Use_SysMacros = TRUE

            CASE "strtoken$"
            Stk$[Tmp] = "StrToken$"
            Use_Strtoken = Use_BcxTmpStr = Use_Mid = Use_Left = Use_Extract = TRUE
            Use_Instr =Use_Instrrev = Use_Stristr = Use_Tally = Use_Remove = TRUE
            Use_UCaseTbl = TRUE

            CASE "sub"
            IF Stk$[2] ?? "main" THEN
               NoMain = TRUE
               Stk$[1]="function"
            END IF

            CASE "swap"
            Stk$[Tmp] = "swap"
            Use_Swap = Use_Proto = TRUE

            CASE "sysdir$"
            Stk$[Tmp] = "$$sysdir$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Sysdir = Use_BcxTmpStr = TRUE

            CASE "sysstr"
            Stk$[Tmp] = "SysStr"
            Use_SysStr = Use_Proto = TRUE

         END SELECT

         CASE  20
         SELECT CASE Keyword$

            CASE "tab$"
            Stk$[Tmp] = "TAB$"
            Use_TAB = Use_BcxTmpStr = TRUE

            CASE "true"
            Stk$[Tmp] = "TRUE"

            CASE "trim$"
            Stk$[Tmp] = "$$trim$"
            Use_Trim = Use_BcxTmpStr = TRUE

            CASE "tally"
            Stk$[Tmp] = "tally"
            Use_Tally = Use_UCaseTbl = Use_Stristr = Use_Proto = TRUE

            CASE "tempdir$"
            Stk$[Tmp] = "$$tempdir$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Tempdir = Use_BcxTmpStr = TRUE

            CASE "tempfilename$"
            Stk$[Tmp] = "$$TempFileName$"
            Use_TempFileName = Use_BcxTmpStr = TRUE

            CASE "textmode"
            Stk$[Tmp] = "TextMode"
            Use_Textmode = Use_Proto = TRUE

            CASE "time$"
            IF Stk$[Tmp+1] <> "("  THEN
               Stk$[Tmp] = "$$timef$()"
            ELSE
               Stk$[Tmp] = "$$timef$"
            END IF
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Time = Use_BcxTmpStr = TRUE

            CASE "timer"
            Stk$[Tmp] = "timer()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Timer = Use_Proto = TRUE

         END SELECT

         CASE  21
         SELECT CASE Keyword$

            CASE "ucase$"
            IF iSubLoc = 2 THEN
               IF Stk$[Tmp+1] = "(" THEN
                  Abort( "'ucase' can only be used as a Function Pointer when in a SET")
               END IF
               Stk$[Tmp] = "ucase"
            ELSE
               Stk$[Tmp] = "$$ucase$"
            END IF
            Use_Ucase = Use_BcxTmpStr = TRUE

            CASE "unwrap$"
            Stk$[Tmp] = "$$unwrap$"
            Use_Unwrap = Use_BcxTmpStr = Use_Left = Use_Right = TRUE

            CASE "ubound"
            Stk$[Tmp] = "ubound"
            Use_Ubound = Use_SysMacros = TRUE

            CASE  "ucode$", "ucode"
            Stk$[Tmp] = "$$AnsiToWide$"
            Use_AnsiToWide = Use_BcxTmpStr = TRUE

            CASE "uncom"
            Stk$[Tmp] = "UNCOM"
            ComSwitchON = TRUE
            Use_COM = TRUE
            Use_BCX_COM_CreateObject   = TRUE
            Use_BCX_COM_DispatchObject = TRUE
            Use_BCX_COM_GetObject      = TRUE
            Use_BCX_COM_GetProperty    = TRUE
            Use_BCX_COM_InvokeMethod   = TRUE
            Use_BCX_COM_SafeArray      = TRUE
            Use_BCX_COM_SetProperty    = TRUE
            Use_BCX_COM_UsesConversion = TRUE

            CASE "using$"
            Stk$[Tmp] = "$$Using$"
            Use_Using = Use_Instr = Use_Stristr = Use_Replace = Use_BcxTmpStr = Use_UCaseTbl = Use_LCaseTbl = TRUE

         END SELECT

         CASE  22
         SELECT CASE Keyword$

            CASE "val"
            Stk$[Tmp] = "VAL"
            Use_Val = Use_SysMacros = TRUE

            CASE "vall"
            Stk$[Tmp] = "VALL"
            Use_Vall = Use_SysMacros = TRUE

            CASE "variant2str"
            'INPUT:
            ' variant2str(variant, string)
            'TRANSFORMS TO
            ' BEGINBLOCK
            ' RAW sBuf[wlen(variant.bstrVal)+2] AS char
            ' wstrcpy(sBuf, lComVariant.bstrVal)
            ' COM_WS2AS(sBuf)
            ' string = COM_psz_tmp$
            ' ENDBLOCK
            CALL Add2SplitLines("BEGINBLOCK")
            CALL Add2SplitLines("DIM RAW sBuf[wlen(" + Stk$[Tmp+2] + ".bstrVal)+2] AS char")
            CALL Add2SplitLines("wstrcpy(sBuf," + Stk$[Tmp+2] + ".bstrVal)")
            CALL Add2SplitLines("COM_WS2AS(sBuf)")
            CALL Add2SplitLines(Stk$[Tmp+4] + " = COM_psz_tmp$")
            CALL Add2SplitLines("ENDBLOCK")
            Ndx = 0
            Use_BCX_COM_UsesConversion = TRUE

            CASE "varptr"
            Stk$[Tmp] = ""
            INCR TS_CompPtr

            CASE "vchr$"
            Stk$[Tmp] = "$$vchr$"
            Use_VChr = Use_BcxTmpStr = TRUE

            CASE "vt$"
            Stk$[Tmp] = "VT$"
            Use_VT = Use_BcxTmpStr = TRUE

            CASE "virtual"
            IF Tmp = 1 THEN
               Stk$[Tmp] = "dim"
               IsVirtual = TRUE

               DIM RAW ii = Ndx
               DO WHILE Stk$[ii] <> ")"
                  DECR ii
               LOOP
               INCR ii
               IF iMatchWrd(Stk$[Ndx],"stdcall") THEN
                  DIM RAW iNdx = Ndx-1
                  IF iMatchWrd(Stk$[iNdx],"as") THEN DECR iNdx
                  IF ii <= iNdx THEN
                     CALL BuildDelimStr(ii, iNdx, szVirtual$)
                  ELSE
                     szVirtual$ = ""
                  END IF
               ELSE
                  IF ii <= Ndx THEN
                     CALL BuildDelimStr(ii, Ndx, szVirtual$)
                  ELSE
                     szVirtual$ = ""
                  END IF
               END IF
            END IF

            CASE "vector"
            IF Stk$[Tmp+1] = "<" THEN
               Stk$[Tmp] = "vector"
               HasVector = TRUE
            END IF

            CASE "verify"
            Stk$[Tmp] = "Verify"
            Use_Verify = Use_Mid = Use_BcxTmpStr = TRUE

            CASE "vbs_addcode","vbs_run_script","vbs_eval_str$"
            Stk$[Tmp] = UCASE$(Stk$[Tmp])
            Use_VBS = Use_BcxTmpStr = TRUE

            CASE "vbs_eval_num","vbs_eval_num#"
            Stk$[Tmp] = "VBS_EVAL_NUM#"
            Use_VBS = Use_BcxTmpStr = TRUE

            CASE "vbs_start","vbs_stop","vbs_reset","vbs_error$"
            Use_VBS = Use_BcxTmpStr = TRUE
            Stk$[Tmp] = UCASE$(Stk$[Tmp]) + "()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)

         END SELECT

         CASE  23
         SELECT CASE Keyword$

            CASE "wrap$"
            Stk$[Tmp] = "$$wrap$"
            Use_Wrap = Use_BcxTmpStr = TRUE

            CASE "widetoansi$", "widetoansi", "w2a$", "w2a"
            Stk$[Tmp] = "$$WideToAnsi$"
            Use_WideToAnsi = Use_BcxTmpStr = TRUE


            CASE "windir$"
            Stk$[Tmp] = "$$windir$()"
            TS_CompPtr  += Convert2SimpleFunction(Tmp)
            Use_Windir = Use_BcxTmpStr = TRUE

            CASE "wndproc"
            IF Tmp = 2 AND Ndx < 6 THEN
               Src$ = "FUNCTION|WndProc(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|CALLBACK|LRESULT"
               FastLexer(Src$,"|",",()")
               Use_Wingui = TRUE
               CallBackFlag= TRUE
            END IF

            CASE "winmain"
            Use_Wingui = InWinMain = TRUE
            IF Tmp = 2 AND Ndx < 6 THEN
               Src$ = "FUNCTION|WinMain(hInst|AS|HINSTANCE,hPrev|AS|HINSTANCE,CmdLine|AS|LPSTR,CmdShow|AS|int)AS|int WINAPI"
               FastLexer(Src$,"|",",()")
            ELSE
               Stk$[Tmp] = "WinMain"
            END IF

         END SELECT

         CASE  26
         SELECT CASE Keyword$

            CASE "zstring"
            IF iMatchWrd(Stk$[Tmp+1], "ptr") THEN
               Stk$[Tmp] = "char"
               INCR Tmp
               INCR TS_CompPtr
               Stk$[Tmp-1] = Stk$[Tmp-1] + "*"
               Stk$[Tmp] = ""
               INCR TS_CompPtr
               IF Tmp = Ndx THEN
                  DECR Ndx
                  DO WHILE TALLY(Stk$[Ndx],"*") = LEN(Stk$[Ndx])
                     CONCAT(Stk$[Ndx-1], Stk$[Ndx])
                     Stk$[Ndx] = ""
                     DECR Ndx
                  LOOP
               ELSE
                  i = Tmp-1
                  DO WHILE TALLY(Stk$[i],"*") = LEN(Stk$[i])
                     CONCAT(Stk$[i-1], Stk$[i])
                     Stk$[i] = ""
                     DECR i
                     INCR TS_CompPtr
                  LOOP
               END IF
            END IF
            Stk$[Tmp] = "string"
         END SELECT

         CASE 27
         SELECT CASE Keyword$
            CASE "$ifndef"
            Stk$[Tmp] = "~ifndef"
            INCR InConditional

            CASE "$ifdef"
            Stk$[Tmp] = "~ifdef"
            INCR InConditional

            CASE "$if"
            Stk$[Tmp] = "~if"
            INCR InConditional

            CASE "$endif"
            Stk$[Tmp] = "~endif"
            DECR InConditional
            IF InConditional < 0 THEN       'simple check to see if conditionals are balanced
               Abort("Too many $ENDIFs")
            END IF
         END SELECT
      END SELECT
   NEXT

   IF TS_CompPtr THEN CALL RemEmptyTokens

   '************************************************************
   ' Moved the WITH/END WITH handling here from the Emit sub
   ' The ill formed variables would cause conflict with the new
   ' AsmUnKnown structs function.
   '************************************************************
   IF PrependCnt THEN
      i = PrependCnt
      DO WHILE i
         IF NOT iMatchWrd(Stk$[1],"with") AND NOT iMatchWrd(Stk$[1],"prepend") AND NOT iMatchWrd(Stk$[1],"endwith") AND NOT iMatchWrd(Stk$[1],"endprepend") THEN
            CALL InsertTokens(0,1,PrependVar$[i])
         END IF
         DECR i
      LOOP
   END IF

   IF WithCnt THEN
      i = Ndx
      DO WHILE i
         IF LEFTSTR(Stk$[i],"->") OR (*Stk$[i] = ASC(".") AND NOT IsNumber(Stk$[i]+1)) THEN
            IF WithVar$[WithCnt] = "Me" AND *Stk$[i] = ASC(".") THEN
               IF InFunction THEN Stk$[i] = "->" + MID$(Stk$[i],2)
            END IF
            Stk$[i] = WithVar$[WithCnt] + Stk$[i]
         END IF
         DECR i
      LOOP
   END IF
   IF PrependCnt THEN
      CALL BuildDelimStr(1,Ndx, Src$)
      CALL XParse(Src$)
   END IF


   '************************************************************
   ' handle programming style global and locals using same name
   '************************************************************

   IF CompToken = 1 THEN

      Keyword$ = LCASE$(Stk$[1])

      SELECT CASE Keyword$
         CASE "dim"         :  CompToken = 0
         CASE "local"       :  CompToken = 0
         CASE "global"      :  CompToken = 0
         CASE "static"      :  CompToken = 0
         CASE "shared"      :  CompToken = 0
         CASE "raw"         :  CompToken = 0
         CASE "dynamic"     :  CompToken = 0
         CASE "free"        :  CompToken = 0
         CASE "redim"       :  CompToken = 0
         CASE "sub"         :  CompToken = 0
         CASE "function"    :  CompToken = 0
         CASE "overloaded"  :  CompToken = 0
         CASE "callback"    :  CompToken = 0
         CASE "public"      :  CompToken = 0
         CASE "declare"     :  CompToken = 0
         CASE "c_declare"   :  CompToken = 0
         CASE "auto"        :  CompToken = 0
         CASE "register"    :  CompToken = 0
         CASE "extern"      :  CompToken = 0
         CASE ELSE          :  CALL AsmUnknownStructs(1)
      END SELECT

   END IF
END SUB ' TokenSubstitutions


SUB LShiftStk (ToCell)
   DIM RAW i
   DECR Ndx                                ' Adjust Ndx
   FOR i = ToCell TO Ndx                   ' Shift contents left, From Ndx ending at ToCell
      Stk$[i] = Stk$[i+1]
   NEXT
   Stk$[Ndx+1] = ""                        ' Erase Stk$ [FromCell]
END SUB


SUB RShiftStk (FromCell)
   DIM RAW i
   INCR Ndx                                ' Bump Ndx by 1
   FOR i = Ndx TO FromCell STEP -1         ' Shift contents right, starting at FromCell
      Stk$[i] = Stk$[i-1]
   NEXT
   Stk$[FromCell] = ""                     ' Erase Stk$ [FromCell]
END SUB


SUB InsertOptionalParens (StartCell)
   CALL RShiftStk (StartCell)              ' Allow unparenthesized expressions
   Stk$[StartCell] = "("                   ' Only use this SUB for simple instances
   INCR Ndx
   Stk$[Ndx] = ")"
END SUB


SUB JoinStrings(iThisToken, inif)         ' NOTE: This is a recursive SUB
   DIM RAW sj       = iThisToken
   DIM RAW DoJoin   = 0
   DIM RAW InBrace  = 0
   DIM RAW OnlyPara = 0
   DIM RAW j        = 0
   DIM RAW vt       = 0
   DIM RAW szToken$ = ""


   DO WHILE iThisToken <= Ndx
      szToken$ = Stk$[iThisToken]

      IF NOT j AND NOT OnlyPara AND NOT InBrace THEN
         vt = DataType(szToken$)
         IF vt = vt_INTEGER THEN vt = GetNextVarType(iThisToken)
         IF vt = vt_STRVAR OR vt = vt_STRLIT THEN
            sj = iThisToken
            INCR iThisToken
            ITERATE
         END IF
      END IF

      szToken$ = LCASE$(szToken$)

      SELECT CASE szToken$

         CASE "&"
         IF OnlyPara THEN EXIT SELECT
         vt = DataType(Stk$[iThisToken+1])
         IF vt = vt_INTEGER THEN vt = GetNextVarType(iThisToken+1)
         IF vt <> vt_STRVAR AND vt <> vt_STRLIT THEN
            vt = DataType(Stk$[iThisToken-1])
            IF vt = vt_INTEGER THEN vt = GetPrevVarType(iThisToken-1, 1)
         END IF
         IF vt = vt_STRVAR OR vt = vt_STRLIT THEN
            INCR j
            Stk$[iThisToken] = ","
            szToken$ = ""
         END IF

         CASE "["
         INCR InBrace

         CASE "]"
         DECR InBrace

         CASE "("
         IF Stk$[iThisToken+1] <> "*" THEN
            CALL JoinStrings(iThisToken+1, inif)
            DIM RAW iBuildHere = iThisToken-1
            DO WHILE Stk$[iThisToken] <> ")"
               Stk$[iBuildHere] = Stk$[iBuildHere] + Stk$[iThisToken] + SPC$
               Stk$[iThisToken] = ""
               INCR iThisToken
            LOOP
            CONCAT(Stk$[iBuildHere], Stk$[iThisToken])
            Stk$[iThisToken] = ""
         END IF

         CASE ")"
         IF j THEN
            Stk$[sj] = "join$(" + STR$(j+1,TRUE) + "," + Stk$[sj]
            j = sj
            DO WHILE ++j < iThisToken
               CONCAT(Stk$[sj], Stk$[j])
               Stk$[j] = ""
            LOOP
            CONCAT(Stk$[sj], ")")
         END IF
         EXIT SUB

         CASE "||"
         Stk$[iThisToken] = "or"
         DoJoin = TRUE

         CASE "&&"
         Stk$[iThisToken] = "and"
         DoJoin = TRUE

         CASE "then", "for", "xfor"
         DoJoin = TRUE

         CASE "="
         IF NOT inif THEN
            OnlyPara = TRUE
         ELSE
            DoJoin = TRUE
         END IF

         CASE "if", "elseif", "while"
         inif = TRUE
         sj = iThisToken + 1

         CASE "sprint", "lprint", "fprint", "fprintf", "print", "print#"
         OnlyPara = TRUE

         CASE ELSE
         IF LEFTSTR(Stk$[iThisToken],"].") OR LEFTSTR(Stk$[iThisToken],"]->") THEN
            DECR InBrace
         END IF

      END SELECT

      IF (DoJoin OR INCHR(",+-*/^;:<>~|&", szToken$)) AND NOT OnlyPara AND NOT InBrace THEN
         DoJoin = 0
         IF j THEN
            Stk$[sj] = "join$(" + STR$(j+1,1) + "," + Stk$[sj]
            j = sj

            DO WHILE ++j < iThisToken
               CONCAT(Stk$[sj], Stk$[j])
               Stk$[j] = ""
            LOOP

            CONCAT(Stk$[sj], ")")
         END IF

         j = 0
         sj = iThisToken + 1
      END IF
      INCR iThisToken
   LOOP

   IF j THEN
      Stk$[sj] = "join$(" + STR$(j+1,1) + "," + TRIM$(Stk$[sj])
      j = sj
      DO WHILE ++j <= iThisToken
         CONCAT(Stk$[sj], TRIM$(Stk$[j]))
         Stk$[j] = ""
      LOOP
      CONCAT(Stk$[sj], ")")
   END IF

END SUB ' JoinStrings



SUB Transforms
   DIM RAW a
   DIM RAW i
   DIM RAW Keyword$
   DIM RAW LTmp$
   DIM RAW tpBCX AS tagTokenSubFunctions PTR

   Keyword$ = LCASE$(Stk$[1])
   tpBCX = GetWordInfo(Keyword$)

   IF tpBCX THEN
      IF (tpBCX->iWordInfo BAND eWI_Transform) = 0 THEN
         EXIT SUB
      END IF
   ELSE
      EXIT SUB
   END IF

   LTmp$  = ""
   a = INCHR("abcdefghijklmnopqrstuvwxyz$", Keyword$)
   SELECT CASE a
      CASE 4

      '**************************************************************************
      ' The following code introduces the following DLL declarations to BCX
      '**************************************************************************
      '  DECLARE FUNCTION Foo LIB "FOO.DLL" ALIAS "FooA" (A$)
      '                     OR
      '  DECLARE FUNCTION Foo LIB "FOO.DLL" (A$) - Alias will default to "FOO"
      '  [5.08.1102] Foo = (BCXFPROTx)GetProcAddress(H_FOO, "FooA");
      '**************************************************************************

      IF Keyword$ = "declare" AND iMatchWrd(Stk$[4],"lib") THEN
         DIM RAW szAlias$, kk, idx=-1

         REMOVE DQ$ FROM Stk$[5]
         FOR kk = 1 TO LoadLibsCnt
            IF Stk$[5] = Loadlibs$[kk] THEN
               idx = kk
               EXIT FOR
            END IF
         NEXT
         IF idx < 0 THEN

            IF cMaxLoadlibs = ++LoadLibsCnt THEN
               CALL Abort("Maximum number of LIBs that can be loaded exceeded.")
            END IF

            Loadlibs$[LoadLibsCnt] = Stk$[5]
         END IF

         IF iMatchWrd(Stk$[6],"alias") THEN
            szAlias$ = Stk$[7]
            Stk$[6] = ""
            Stk$[7] = ""
         ELSE
            szAlias$ = ENC$(UCASE$(Stk$[3]))
         END IF

         INCR DllCnt

         IF DllCnt >= cMaxDLLDecl THEN
            CALL Abort("Maximum number of declarations exceeded.")
         END IF

         DIM mod_name$ : mod_name$ = UCASE$(RemoveExtension$(Stk$[5]))

         IF INCHR(mod_name$,"-") OR INCHR(mod_name$,".") THEN
            mod_name$ = REPLACE$ (mod_name$, "-.", "_")
            mod_name$ = REPLACE$ (mod_name$, "-",  "_")
         END IF

         $FILL DllDecl$[DllCnt]
         Clean$(Stk$[3])   + "=(BCXFPROT"
         STR$(DllCnt,TRUE) + ")GetProcAddress(H_"
         mod_name$ + ", "  + szAlias$ + ");"
         $FILL

         Stk$[4] = ""  :  Stk$[5] = ""
      END IF
      EXIT SUB


      CASE 9

      IF Keyword$ = "iremove" THEN
         '***********************************************************
         '  Translate   IREMOVE UCASE$("aaa") FROM LTRIM$(RTRIM$(A$))
         '  into   A$ = IREMOVE$(LTRIM$(RTRIM$(A$)),UCASE$("aaa"))
         '***********************************************************
         DIM RAW Mat$, Fat$

         FOR i = 2 TO Ndx
            IF iMatchWrd(Stk$[i],"from") THEN
               Stk$[i] = ""
               EXIT FOR
            END IF
         NEXT

         CALL BuildStr(2, i, Mat$)      ' build match string
         CALL BuildStr(i, Ndx, Fat$)    ' build fat source
         LTmp$ = "=iremove$(" + Fat$ + "," + Mat$ + ")"
         FastLexer(Fat$," ()","")
         LTmp$ = Stk$[Ndx] + LTmp$
         CALL XParse(LTmp$)
         CALL TokenSubstitutions(1)
         CALL EmitMain
         Ndx = 0
         EXIT SUB
      END IF

      IF Keyword$ = "ireplace" THEN
         '**********************************************************
         '  IREPLACE "this" WITH "that" IN A$ is transformed into
         '  A$ = ireplace$ (A$, "this", "that")
         '  BCX 3.73 introduces CASE INSENSITIVE REPLACE
         '**********************************************************

         IF Ndx < 6 THEN
            CALL Abort("Problem with IREPLACE statement")
         END IF

         DIM RAW W, I, VV$, RR$, WW$

         FOR W = 2 TO Ndx
            IF iMatchWrd(Stk$[W],"with") THEN
               Stk$[W]= ""
               EXIT FOR
            END IF
         NEXT

         FOR I = 2 TO Ndx
            IF iMatchWrd(Stk$[I],"in") THEN
               Stk$[I]= ""
               EXIT FOR
            END IF
         NEXT

         CALL BuildStr(I+1, Ndx, VV$)
         CALL BuildStr(2, W, RR$)
         CALL BuildStr(W+1, I, WW$)
         LTmp$ = "=ireplace$(" + VV$ + "," + RR$ + "," + WW$ + ")"
         FastLexer(VV$," ()","")
         LTmp$ = Stk$[Ndx] + LTmp$
         CALL XParse(LTmp$)
         CALL TokenSubstitutions(1)
         CALL EmitMain
         Ndx = 0
      END IF
      EXIT SUB

      CASE 18
      IF Keyword$ = "remove" THEN
         '***********************************************************
         '  Translate   REMOVE UCASE$("aaa") FROM LTRIM$(RTRIM$(A$))
         '  into   A$ = REMOVE$(LTRIM$(RTRIM$(A$)),UCASE$("aaa"))
         '***********************************************************
         DIM RAW Mat$, Fat$

         XFOR i = 2 WHILE i <= Ndx AND NOT iMatchWrd(Stk$[i],"from") BY i++
         XNEXT

         IF i > Ndx THEN
            CALL Abort("Malformed REMOVE statement.")
         END IF

         CALL BuildStr(2, i-1, Mat$)     ' build match string
         CALL BuildStr(i+1, Ndx, Fat$)   ' build fat source
         LTmp$ = "=remove$(" + Fat$ + "," + Mat$ + ")"

         FastLexer(Fat$," ()","")
         LTmp$ = Stk$[Ndx] + LTmp$
         CALL XParse(LTmp$)
         CALL TokenSubstitutions(1)
         CALL EmitMain
         Ndx = 0
         EXIT SUB
      END IF

      IF Keyword$ = "replace" THEN
         '*******************************************************
         '  REPLACE "this" WITH "that" IN A$ is transformed into
         '  A$ = replace$ (A$, "this", "that")
         '  BCX 2.93 allows expressions and arrays to be used
         '*******************************************************

         IF Ndx < 6 THEN
            CALL Abort("Problem with REPLACE statement")
         END IF

         DIM RAW W, I, VV$, RR$, WW$

         FOR W = 2 TO Ndx
            IF iMatchWrd(Stk$[W],"with") THEN
               Stk$[W]= ""
               EXIT FOR
            END IF
         NEXT

         FOR I = 2 TO Ndx
            IF iMatchWrd(Stk$[I],"in") THEN
               Stk$[I] = ""
               EXIT FOR
            END IF
         NEXT

         IF I < W OR W = 0 THEN
            CALL Abort("Malformed REPLACE statement")
         END IF

         CALL BuildStr(I+1, Ndx, VV$)
         CALL BuildStr(2, W, RR$)
         CALL BuildStr(W+1, I, WW$)

         LTmp$ = VV$ + "=replace$(" + VV$ + "," + RR$ + "," + WW$ + ")"
         CALL XParse(LTmp$)
         CALL TokenSubstitutions(1)
         CALL EmitMain
         Ndx = 0
      END IF
      EXIT SUB
   END SELECT
END SUB ' Transforms



FUNCTION LocateJoiner(iStart AS INT)
   DO WHILE iStart < Ndx
      IF Stk$[iStart] = "&" OR (Stk$[iStart] = "+" AND Stk$[iStart+1] <> "+") THEN FUNCTION = iStart
      '  ^^^  DO NOT OPTIMIZE THE ABOVE LINE WITH POINTERS.  There's no benefit.  ~ MrBcx ~    ^^^
      INCR iStart
   LOOP
   FUNCTION = 0
END FUNCTION ' LocateJoiner



FUNCTION GetNextVarType(iLoc AS INT) AS INT
   DIM RAW vt1 AS INT
   DIM RAW cvt1 AS INT
   DIM RAW Tmp AS INT
   DIM RAW k AS INT

   cvt1 = CheckType(Stk$[iLoc])
   IF cvt1 = 0 THEN
      vt1 = DataType(Stk$[iLoc])
   ELSE
      IF cvt1 = vt_UDT OR cvt1 = vt_STRUCT THEN
         IF *Stk$[iLoc+1] = ASC("[") THEN
            XFOR Tmp = iLoc+2, k = 1 WHILE Tmp <= Ndx AND k BY Tmp++
               IF *Stk$[Tmp] = ASC("[") THEN INCR k
               IF *Stk$[Tmp] = ASC("]") THEN DECR k
            XNEXT
            vt1 = DataType(Stk$[Tmp])
         ELSE
            vt1 = DataType(Stk$[iLoc+1])
         END IF
      ELSE
         IF cvt1 = vt_CHAR THEN
            DIM RAW i, varid
            DIM RAW vi AS VarInfo PTR
            vi = NULL
            i = CheckLocal(Stk$[iLoc], &varid)
            IF i THEN vi = &LocalVars[varid]
            IF i = vt_UNKNOWN THEN
               i = CheckGlobal(Stk$[iLoc], &varid)
               IF i THEN vi = &GlobalVars[varid]
            END IF
            IF vi THEN
               IF *(vi->VarDim$) THEN
                  cvt1 = vt_STRVAR
               ELSE
                  cvt1 = DataType(Stk$[iLoc])
               END IF
            ELSE
               cvt1 = DataType(Stk$[iLoc])
            END IF
         END IF
         vt1 = cvt1
      END IF
   END IF

   FUNCTION = vt1
END FUNCTION  ' GetNextVarType



FUNCTION GetPrevVarType(iLoc AS INT, iEarly AS INT) AS INT
   DIM RAW vt AS INT
   DIM RAW Tmp AS INT
   DIM RAW k AS INT

   IF Stk$[iLoc] = ")" OR Stk$[iLoc] = "]" THEN
      XFOR Tmp = iLoc-1, k = 1 WHILE Tmp >= iEarly AND k BY Tmp--
         IF *Stk$[Tmp] = ASC(")") THEN INCR k
         IF *Stk$[Tmp] = ASC("]") THEN INCR k
         IF *Stk$[Tmp] = ASC("(") THEN DECR k
         IF *Stk$[Tmp] = ASC("[") THEN DECR k
      XNEXT
      vt = DataType(Stk$[Tmp])
   ELSE
      vt = DataType(Stk$[iLoc])
      IF vt = vt_INTEGER THEN vt = CheckType(Stk$[iLoc])
      IF vt = vt_CHAR THEN
         DIM RAW i, varid
         DIM RAW vi AS VarInfo PTR
         vi = NULL
         i = CheckLocal(Stk$[iLoc], &varid)
         IF i THEN vi = &LocalVars[varid]
         IF i = vt_UNKNOWN THEN
            i = CheckGlobal(Stk$[iLoc], &varid)
            IF i THEN vi = &GlobalVars[varid]
         END IF
         IF vi THEN
            IF *(vi->VarDim$) THEN vt = vt_STRVAR
         END IF
      END IF
   END IF

   FUNCTION = vt
END FUNCTION  ' GetPrevVarType




FUNCTION JoinStrTest(iStart AS INT, iEarly AS INT)
   DIM RAW Plus2Amp, vtLeft, vtRight, iJoiner, iDoJoin
   iDoJoin = 0
   Plus2Amp = iMatchNQ(Stk$[iStart++], "&")

   iJoiner = LocateJoiner(iStart)
   IF iJoiner = 0 THEN FUNCTION = iDoJoin
   vtLeft = GetPrevVarType(iJoiner-1, iEarly)
   vtRight = GetNextVarType(iJoiner+1)

   SELECT CASE vtLeft
      CASE vt_STRVAR, vt_STRLIT, vt_LPSTR, vt_LPSTRPTR, vt_PCHAR
      vtLeft = 1
      CASE ELSE
      vtLeft = 0
   END SELECT

   SELECT CASE vtRight
      CASE vt_STRVAR, vt_STRLIT, vt_LPSTR, vt_LPSTRPTR, vt_PCHAR
      vtRight = 1
      CASE ELSE
      vtRight = 0
   END SELECT

   IF vtLeft AND vtRight THEN
      Stk$[iJoiner] = "&"
      Plus2Amp = TRUE
      iEarly = iJoiner+1
   END IF

   iStart = iJoiner+1

   IF iStart < Ndx THEN
      iDoJoin = JoinStrTest(iStart, iEarly) BOR Plus2Amp
   ELSE
      iDoJoin = Plus2Amp
   END IF

   FUNCTION = iDoJoin
END FUNCTION ' JoinStrTest



SUB FixUps
   DIM RAW A
   DIM RAW B
   DIM RAW i
   DIM RAW j
   DIM RAW CommaCnt
   DIM RAW AmpCnt
   DIM RAW LTmp$  = ""
   DIM RAW LStk1$ = ""
   DIM RAW LStk2$ = ""
   DIM RAW Var1$  = ""

   PassOne = FALSE

   '***********************************************************
   ' Join strings using Join(Numberofstrings, string1, string2, ...)
   '***********************************************************
   IF NOT iMatchWrd(Stk$[1],"function")  THEN
      IF JoinStrTest(1,1) THEN
         DIM RAW k, Tmp
         j = 0
         k = 0
         AmpCnt = 0

         XFOR Tmp = 1 WHILE Tmp < Ndx AND (j = 0 OR k = 0) BY Tmp++
            IF Stk$[Tmp] = "&" THEN
               A = GetNextVarType(Tmp+1)
               IF A = vt_STRVAR OR A = vt_STRLIT THEN
                  INCR AmpCnt
                  IF ISZERO(k) THEN k = Tmp
               END IF
            ELSE
               A = CheckLocal(Stk$[Tmp], &i)
               IF A = vt_UNKNOWN THEN A = CheckGlobal(Stk$[Tmp], &i)
               IF A = vt_STRUCT OR A = vt_UDT OR A = vt_UNION THEN
                  j = 1
               END IF
            END IF
         XNEXT

         IF AmpCnt > 1 THEN
            Use_Join = Use_BcxTmpStr = TRUE
         END IF

         IF k THEN
            IF j THEN CALL AsmUnknownStructs(0)
            CALL JoinStrings(1, 0)
            CALL BuildDelimStr(1, Ndx, Src$)
            CALL XParse(Src$)
         END IF
      END IF
   END IF

   '***********************************************************
   ' Moved here by Mike H. Was being applied too early.
   ' causing lines with multiple statements to not receive the
   ' conversion. i.e. sp->lpVtbl->Release(sp) : sp = NULL
   '***********************************************************

   IF UseCpp THEN
      IF iMatchNQ(Src$,"->lpVtbl") THEN

         FOR INT tt= 1 TO Ndx
            IF iMatchRgt(Stk$[tt],"->lpVtbl") THEN
               Stk$[tt] = EXTRACT$(Stk$[tt],"->lpVtbl")
               IF (Stk$[tt+3] = Stk$[tt-1] OR Stk$[tt+3] = Stk$[tt]) AND Stk$[tt+3] <> ")" THEN
                  Stk$[tt+3] = ""
                  IF Stk$[tt+4] = "," THEN Stk$[tt+4] = ""
               END IF
            END IF
         NEXT

         CALL RemEmptyTokens
      END IF
   END IF

   '********************************************************************
   '  At this point we have a fresh set of Stk$[] values, totaling Ndx
   '                Start handling some unique situations
   '********************************************************************

   IF HasThisToken("^") THEN      '[ Exponent Operator Handler ]
      DIM RAW lp = 0
      DIM RAW rp = 0
      DIM RAW Insert1
      DIM RAW Insert2

      FOR i = 1 TO Ndx
         IF Stk$[i] = "^" THEN
            IF Stk$[i+1] = "-" THEN
               InsertTokens(i,1,"(")
               B = i + 3
               IF *Stk$[B] = ASC("(") THEN
                  lp=0
                  rp=0
                  DO
                     IF *Stk$[B] = ASC("(") THEN INCR lp
                     IF *Stk$[B] = ASC(")") THEN INCR rp
                     INCR B
                  LOOP UNTIL lp = rp
                  InsertTokens(B,1,")")
               ELSE
                  B = i + 4
                  IF INCHR("[",Stk$[B]) THEN
                     DO
                        INCR B
                     LOOP UNTIL INCHR("]",Stk$[B])
                     INCR Ndx
                     InsertTokens(B,1,")")
                  ELSE
                     IF INCHR("(",Stk$[B]) THEN
                        DO
                           INCR B
                        LOOP UNTIL INCHR(")",Stk$[B])
                        InsertTokens(B,1,")")
                     ELSE
                        InsertTokens(B,1,")")
                     END IF
                  END IF
               END IF
            END IF
            Insert1 = i - 1
            B = 0

            DO WHILE Stk$[Insert1] <> "="
               IF *Stk$[Insert1] = ASC("]") THEN INCR B
               IF *Stk$[Insert1] = ASC(")") THEN INCR B
               IF *Stk$[Insert1] = ASC("[") THEN DECR B
               IF *Stk$[Insert1] = ASC("(") THEN DECR B
               IF B = 0 THEN EXIT DO
               DECR Insert1
            LOOP

            IF *Stk$[Insert1] = ASC("[") THEN DECR Insert1
            IF *Stk$[Insert1] = ASC("=") THEN INCR Insert1

            IF *Stk$[Insert1] = ASC("(") THEN
               B = DataType(Stk$[Insert1-1])        ' check if it's a function
               IF B = vt_INTEGER OR B = vt_SINGLE OR B = vt_DOUBLE  THEN
                  IF ISFALSE(iMatchWrd(Stk$[Insert1-1], "print")) THEN DECR Insert1
               END IF
            END IF

            DECR Insert1
            Stk$[i] = ","
            Insert2 = i + 1

            B = DataType(Stk$[Insert2])

            IF B = vt_INTEGER OR B = vt_SINGLE OR B = vt_DOUBLE THEN
               IF *Stk$[Insert2 + 1] = ASC("(") OR *Stk$[Insert2 + 1] = ASC("[") THEN INCR Insert2
            END IF

            B = 0

            DO WHILE Insert2 <= Ndx
               IF *Stk$[Insert2] = ASC("[") THEN INCR B
               IF *Stk$[Insert2] = ASC("(") THEN INCR B
               IF *Stk$[Insert2] = ASC("]") THEN DECR B
               IF *Stk$[Insert2] = ASC(")") THEN DECR B
               IF ISZERO(B) THEN EXIT DO
               INCR Insert2
            LOOP

            'Insert the tokens in reverse order
            InsertTokens(Insert2, 1, ")")
            InsertTokens(Insert1, 2, "pow","(")
         END IF
      NEXT
   END IF

   '******************************

   CALL TokenSubstitutions(1)

   IF Ndx = 0 THEN EXIT SUB

   '******************************
   IF Ndx = 3 AND ISZERO(WithCnt) THEN
      IF *Stk$[2] = ASC("+") AND *Stk$[3] = ASC("+") THEN
         FPRINT Outfile, Scoot$, Clean$(Stk$[1]),"++;"
         Ndx = 0
         INCR Statements
         EXIT SUB
      END IF
      IF *Stk$[2] = ASC("-") AND *Stk$[3] = ASC("-") THEN
         FPRINT Outfile, Scoot$, Clean$(Stk$[1]),"--;"
         Ndx = 0
         INCR Statements
         EXIT SUB
      END IF
      IF *Stk$[1] = ASC("+") AND *Stk$[2] = ASC("+") THEN
         FPRINT Outfile, Scoot$, "++",Clean$(Stk$[3]),";"
         Ndx = 0
         INCR Statements
         EXIT SUB
      END IF
      IF *Stk$[1] = ASC("-") AND *Stk$[2] = ASC("-") THEN
         FPRINT Outfile, Scoot$, "--",Clean$(Stk$[3]),";"
         Ndx = 0
         INCR Statements
         EXIT SUB
      END IF
   END IF

   '******************************
   IsCallBack = 0
   IF iMatchWrd(Stk$[Ndx],"callback") THEN
      IsCallBack = 1
      Stk$[Ndx--] = ""
   END IF
   '******************************

   CALL Transforms

   IF Ndx = 0 THEN EXIT SUB

   '********************************************************************
   '          Modification to allow 2 names as function types
   '********************************************************************

   IF iMatchWrd(Stk$[1],"function") OR iMatchWrd(Stk$[1],"impfunction") THEN
      IF iMatchWrd(Stk$[Ndx-2],"as") AND Stk$[Ndx] <> ")" THEN
         IF ISFALSE(iMatchWrd(Stk$[Ndx],"export")) AND _
            ISFALSE(iMatchWrd(Stk$[Ndx],"stdcall")) THEN
            Stk$[Ndx-1] = Stk$[Ndx-1] + SPC$ + Stk$[Ndx]
            DECR Ndx
         END IF
      END IF
   END IF

   '********************************************************************
   'Modification to allow 2 names as argument types in sub or function
   '********************************************************************
   DIM RAW iP = 1

   IF iMatchLft(Stk$[1],"public") OR iMatchLft(Stk$[1],"private") THEN INCR iP

   IF iMatchWrd(Stk$[iP],"function") OR iMatchWrd(Stk$[iP],"sub") THEN
      DIM RAW offset
      DIM RAW LastBrk = Ndx - 2

      FOR i = Ndx TO 3 STEP -1
         IF *Stk$[i] = ASC(")") THEN
            LastBrk = i
            EXIT FOR
         END IF
      NEXT

      XFOR i = 3, INT jjj = 1 WHILE i <= LastBrk AND jjj BY i++
         offset = 2
         jjj = GetAsPosF(i, LastBrk)
         IF jjj THEN
            i = jjj
            IF (i < LastBrk) AND Stk$[i + offset] <> "=" THEN
               IF iMatchWrd(Stk$[i+1],"function") THEN offset = 3
               IF ISFALSE(INCHR(Stk$[i + offset],")")) AND _
                  ISFALSE(INCHR(Stk$[i + offset],",")) THEN
                  IF NOTZERO(LEN(Stk$[i + offset])) AND _
                     ISFALSE(iMatchWrd(Stk$[i + 3],"as")) THEN
                     Stk$[i+offset-1] = Stk$[i+offset-1] + SPC$ + Stk$[i+offset]
                     Stk$[i + offset] = ""
                  END IF
               END IF
            END IF
         END IF
      XNEXT

   END IF
   '***********************************************************
   '                      DynaCall Handler
   '***********************************************************
   IF ISFALSE(iMatchWrd(Stk$[1],"declare")) THEN
      FOR i = 1 TO Ndx
         IF iMatchWrd(Stk$[i],"lib") THEN
            IF Stk$[i-1] = "(" AND (DataType(Stk$[i+1]) = vt_STRLIT OR DataType(Stk$[i+1]) = vt_STRVAR) THEN
               j = GetNumArgs(i+2)
               LTmp$ = "BCX_DynaCallB"
               IF ISFALSE(iMatchWrd(Stk$[1],"print")) THEN  'print does its own casting
                  IF DataType(Stk$[i-2]) = vt_STRVAR OR DataType(Stk$[1]) = vt_STRVAR THEN
                     LTmp$ = "(char*)" + LTmp$
                  END IF
               END IF
               Var1$ = RIGHT$(Stk$[i-2], 1)
               IF INCHR (VARTYPES$, Var1$) THEN
                  CONCAT (LTmp$, Var1$)
                  Stk$[i] = ENC$(LEFT$(Stk$[i-2], LEN(Stk$[i-2]) - 1))
               ELSE
                  Stk$[i] = ENC$(Stk$[i-2])
               END IF
               Stk$[i-2] = LTmp$
               FOR B = Ndx+3 TO i+3 STEP -1
                  Stk$[B] = Stk$[B-3]
               NEXT
               Stk$[i+2] = Stk$[i+1]
               Stk$[i+1] = ","
               Stk$[i+3] = ","
               Stk$[i+4] = STR$(j,1)
               Stk$[i+5] = IIF$(j, ",", ")")
               INCR Ndx, 3
               Use_DynacallCommon = Use_Dynacall = Use_BcxTmpStr = TRUE
            END IF
         END IF
      NEXT
   END IF

   '*****************************************************
   LStk1$ = LCASE$(Stk$[1])   ' Performance Optimizer
   LStk2$ = LCASE$(Stk$[2])   ' Performance Optimizer
   '*****************************************************


   '*****************************************************
   ' We're looking for a OPEN "name" AS BINARY ... clause
   '*****************************************************

   IF LStk1$ = "open" THEN

      FOR A = 2 TO Ndx
         IF iMatchWrd(Stk$[A],"binary") THEN
            EXIT FOR
         END IF
      NEXT

      IF A = Ndx THEN EXIT SUB  ' This is not a "BINARY" clause OPEN statement

      IF A < Ndx THEN
         INCR A
         Var1$ = LCASE$(Stk$[A])

         IF Var1$ = "new" THEN
            Stk$[A-1]= "binarynew"
            LShiftStk(A)
            EXIT SUB
         END IF

         IF Var1$ = "append" THEN
            Stk$[A-1]= "binaryappend"
            LShiftStk(A)
            EXIT SUB
         END IF

         IF Var1$ = "input" THEN
            Stk$[A-1]= "binaryinput"
            LShiftStk(A)
            EXIT SUB
         END IF

         IF Var1$ = "output" THEN
            Stk$[A-1]= "binaryoutput"
            LShiftStk(A)
            EXIT SUB
         END IF
      END IF
   END IF

   '******************************

   IF LStk1$ = "option" THEN
      IF LStk2$ = "base" THEN
         OptionBase = IVAL (Stk$[3])
         Ndx = 0
         EXIT SUB
      END IF
   END IF

   '******************************

   IF LStk1$   = "dim"  THEN
      LTmp$ = ENC$(LStk2$, ASC(SPC$))
      IF iMatchNQ (" shared , dynamic , raw , local , auto , register , static ", LTmp$) THEN
         Stk$[1]  = LStk2$
         LStk1$ = LStk2$
         LShiftStk(2)
      END IF
      EXIT SUB
   END IF

   '******************************

   IF LStk1$ = "public" THEN
      IF LStk2$ = "function" OR LStk2$ = "sub" THEN
         IF InClass THEN
            CONCAT(LStk1$,LStk2$)
            Stk$[1] = LStk1$
         ELSE
            Stk$[1]  = LStk2$
         END IF
         LShiftStk(2)
      END IF
      EXIT SUB
   END IF

   '******************************

   ' creates a static function for use in $PROJECTs
   IF LStk1$ = "private" THEN
      IF LStk2$ = "function" OR LStk2$ = "sub" THEN
         IF InClass THEN
            CONCAT(LStk1$,LStk2$)
            Stk$[1] = LStk1$
         ELSE
            Use_Static = TRUE
            Stk$[1]  = LStk2$
         END IF
         LShiftStk(2)
      END IF
      EXIT SUB
   END IF

   '******************************

   IF LStk1$ = "onexit" THEN
      IF LStk2$ = "sub" THEN
         Use_ExitCode = Use_Proto = TRUE

         IF cMaxExitSub = ++ExitNdx THEN
            CALL Abort("Maximum number of exit calls exceeded.")
         END IF

         ExitSub$[ExitNdx] = Stk$[3]
         Stk$[1]  = LStk2$
         LStk1$ = LStk2$
         LShiftStk(2)
      END IF
      EXIT SUB
   END IF

   '******************************

   IF LStk1$ = "onstart" THEN
      IF LStk2$ = "sub" THEN
         Use_StartupCode = Use_Proto = TRUE

         IF cMaxStartSub = ++StartNdx THEN
            CALL Abort("Maximum number of startup calls exceeded.")
         END IF

         StartSub$[StartNdx] = Stk$[3]
         Stk$[1]  = LStk2$
         LStk1$ = LStk2$
         LShiftStk(2)
         EXIT SUB
      END IF
      CALL Abort("ONSTART syntax error, can only be used with a SUB.")
   END IF

   '******************************

   IF LStk1$ = "overloaded" THEN
      IF LStk2$ = "function" THEN
         Stk$[1] = "overloadedfunction"
         LStk1$ = "overloadedfunction"
         LShiftStk(2)
         IF Stk$[2] <> "=" THEN
            OkayToSend = TRUE
         END IF
         EXIT SUB
      END IF

      IF LStk2$ = "sub" THEN
         Stk$[1]= "overloadedsub"
         LShiftStk(2)
         EXIT SUB
      END IF
   END IF

   '******************************

   IF LStk1$ = "function" THEN
      IF iMatchWrd(Stk$[3],"optional") THEN
         Stk$[1]= "optfunction"
         LStk1$ = "optfunction"
         LShiftStk(3)
         IF Stk$[2] <> "=" THEN
            OkayToSend = TRUE
         END IF
         EXIT SUB
      END IF
   END IF

   IF UseCpp = FALSE THEN          ' C++ doesn't need the OPTIONAL keyword
      IF LStk1$ = "function" THEN  ' Bcx 772 detects OPTIONAL without keyword
         IF Stk$[2] <> "=" THEN
            FOR INT ij = 3 TO Ndx
               IF Stk$[ij] = "=" THEN
                  Stk$[1]= "optfunction"
                  LStk1$ = "optfunction"
                  EXIT SUB
               END IF
            NEXT
         END IF
      END IF
   END IF

   '******************************

   IF LStk1$ = "sub" THEN
      IF iMatchWrd(Stk$[3],"optional") THEN
         LStk1$ = "optsub"
         Stk$[1]= "optsub"
         LShiftStk(3)
         EXIT SUB
      END IF
   END IF

   IF UseCpp = FALSE THEN       ' C++ doesn't need the OPTIONAL keyword
      IF LStk1$ = "sub" THEN    ' Bcx 772 detects OPTIONAL without keyword
         FOR INT ij = 2 TO Ndx
            IF Stk$[ij] = "=" THEN
               Stk$[1]= "optsub"
               LStk1$ = "optsub"
               EXIT SUB
            END IF
         NEXT
      END IF
   END IF

   '******************************

   IF LStk1$ = "end" THEN
      IF Stk$[2] <> "=" THEN
         Stk$[1]= LStk1$ + LStk2$
         IF Ndx = 2 THEN
            Ndx = 1
            EXIT SUB
         ELSE
            IF iMatchWrd(Stk$[3],"as") THEN
               Stk$[2] = ""
               CALL RemEmptyTokens
               EXIT SUB
            END IF
         END IF
      END IF
   END IF

   '******************************

   IF LStk1$ = "function" THEN
      IF Stk$[2] <> "=" THEN
         OkayToSend = TRUE
      END IF
   END IF

   '******************************

   IF LStk1$ = "midstr"  THEN

      IF INCHR(Stk$[3],DQ$) THEN
         CALL Abort ("MID$ statement string argument cannot be a literal")
      END IF

      CommaCnt = 0

      FOR i = 1 TO Ndx
         IF *Stk$[i] = ASC(",") THEN
            INCR CommaCnt
         ELSEIF Stk$[i]= "=" THEN
            IF CommaCnt < 2 THEN
               Stk$[i] = "-1,"
            ELSE
               Stk$[i]= ""
            END IF
            Stk$[i-1]= ","
            INCR Ndx
            Stk$[Ndx]= ")"
            EXIT FOR
         END IF
      NEXT
   END IF

   '******************************

   IF LStk1$ = "endevents" OR LStk1$ = "endmdievents" OR LStk1$ = "endmdichildevents" THEN
      DIM RAW szError$

      IF Use_Vscroll OR Use_Hscroll THEN
         Use_Max = Use_Min = TRUE
         '========================================================================
         Src$ = "GLOBAL BCX_siX AS SCROLLINFO"      : CALL INJECT (Src$)
         Src$ = "GLOBAL BCX_siY AS SCROLLINFO"      : CALL INJECT (Src$)
         Src$ = "GLOBAL BCX_DynaScroll AS INT"      : CALL INJECT (Src$)

         FPRINT Outfile, "static  int BCX_ViewWidth  =", Use_Hscroll, ";"
         FPRINT Outfile, "static  int BCX_ViewHeight =", Use_Vscroll, ";"
         FPRINT Outfile, "static  int BCX_SmallChangeX;"
         FPRINT Outfile, "static  int BCX_SmallChangeY;"
         FPRINT Outfile, "static  int BCX_LargeChangeX;"
         FPRINT Outfile, "static  int BCX_LargeChangeY;"
         FPRINT Outfile, "static  int BCX_ScrollInit;"
         FPRINT Outfile, ""
         FPRINT Outfile, "  if(!BCX_ScrollInit)"
         FPRINT Outfile, "   {"
         FPRINT Outfile, "     BCX_siY.cbSize=sizeof(BCX_siY);"
         FPRINT Outfile, "     BCX_siX.cbSize=sizeof(BCX_siX);"
         FPRINT Outfile, "     BCX_siY.fMask=SIF_ALL;"
         FPRINT Outfile, "     BCX_siX.fMask=SIF_ALL;"
         FPRINT Outfile, "     BCX_siX.nMax=BCX_ViewWidth;"
         FPRINT Outfile, "     BCX_siY.nMax=BCX_ViewHeight;"
         FPRINT Outfile, "     BCX_SmallChangeX=1;"
         FPRINT Outfile, "     BCX_LargeChangeX=20;"
         FPRINT Outfile, "     BCX_SmallChangeY=1;"
         FPRINT Outfile, "     BCX_LargeChangeY=20;"
         FPRINT Outfile, "     BCX_siY.nPage=1;"
         FPRINT Outfile, "     BCX_siX.nPage=1;"
         FPRINT Outfile, "     SetScrollInfo(hWnd,SB_VERT,&BCX_siY,TRUE);"
         FPRINT Outfile, "     SetScrollInfo(hWnd,SB_HORZ,&BCX_siX,TRUE);"
         FPRINT Outfile, "     BCX_DynaScroll=TRUE;"
         FPRINT Outfile, "     BCX_ScrollInit=TRUE;"
         FPRINT Outfile, "   }"
         FPRINT Outfile, " if(Msg==WM_HSCROLL||Msg==WM_VSCROLL||Msg==WM_SIZE)"
         FPRINT Outfile, "   {"
         FPRINT Outfile, "     BCX_Scroll(hWnd,Msg,wParam,lParam,BCX_LargeChangeX,"
         FPRINT Outfile, "     BCX_LargeChangeY,BCX_SmallChangeX,BCX_SmallChangeY,"
         FPRINT Outfile, "     BCX_ViewWidth,BCX_ViewHeight,BCX_DynaScroll);"
         FPRINT Outfile, "   }"
      END IF

      IF ISFALSE(Use_BCX_Class_Info) THEN
         Use_BCX_Class_Info = TRUE
         iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eClassName)
      END IF

      IF LStk1$ <> "endmdichildevents" AND Use_MainEvent THEN
         Use_MainEvent = FALSE
         FPRINT Outfile, "  if(Msg==WM_DESTROY)"
         FPRINT Outfile, "    {"
         FPRINT Outfile, "       OleUninitialize();"
         FPRINT Outfile, "       CoUninitialize();"
         FPRINT Outfile, "       PostQuitMessage(0);"
         FPRINT Outfile, "       return EXIT_SUCCESS;"
         FPRINT Outfile, "    }"
      END IF

      IF LStk1$ = "endevents" THEN
         FPRINT Outfile, " return DefWindowProc(hWnd,Msg,wParam,lParam); // endevents"
      ELSEIF LStk1$ = "endmdievents" THEN
         FPRINT Outfile, " return DefFrameProc(hWnd,BCX_hwndMDIClient,Msg,wParam,lParam);"
      ELSEIF LStk1$ = "endmdichildevents" THEN
         FPRINT Outfile, " return DefMDIChildProc(hWnd,Msg,wParam,lParam);"
      END IF

      FPRINT Outfile, "}\n\n"
      sprintf(szError, "Too many unindents for END %s", UCASE$(LStk1+3))
      CALL BumpDown(szError$)

      IF Indent THEN
         CALL Abort("Possible missing END IF before END " + UCASE$(MID$(LStk1$,4)))
      END IF

      Ndx = 0
      InFunction = FALSE
      EXIT SUB
   END IF

   '******************************

   IF Stk$[2]= ":" THEN
      IF Ndx = 2 THEN
         LTmp$ = ENC$(LStk1$,ASC(SPC$))
         IF iMatchNQ(" public , private , protected ", LTmp$) = 0 THEN
            Stk$[1]= UCASE$(Stk$[1]) + ":"    'preserve the GOTO labels
            Ndx = 1
         END IF
         EXIT SUB
      END IF
   END IF

   '******************************
   IF iMatchWrd(Stk$[3],"createwindow") THEN    'HELPER
      Comma = 0
      FOR A = 4 TO Ndx
         IF Stk$[A]= "," THEN INCR Comma
         IF Stk$[A]= "," THEN
            IF Comma = 8 THEN
               Stk$[A]= ",(HMENU)(UINT_PTR)"
               INCR Comma
            END IF
         END IF
      NEXT
   END IF

   '******************************

   IF iMatchWrd(Stk$[3],"createwindowex") THEN    'HELPER
      Comma = 0
      FOR A = 4 TO Ndx
         IF Stk$[A]= "," THEN INCR Comma
         IF Stk$[A]= "," THEN
            IF Comma = 9 THEN
               Stk$[A]= ",(HMENU)(UINT_PTR)"
               INCR Comma
            END IF
         END IF
      NEXT
   END IF

   '******************************

   IF *Stk$[Ndx]= ASC("*") THEN
      CONCAT(Stk$[Ndx-1],"*")
      DECR Ndx
   END IF

   '******************************

   IF iMatchWrd(Stk$[3],"setwindowlong") OR iMatchWrd(Stk$[3],"setwindowlongptr") THEN    'HELPER
      Comma = 0
      Stk$[3]= "(WNDPROC)(LONG_PTR)SetWindowLongPtr"
      FOR A = 4 TO Ndx
         IF Stk$[A]= "," THEN INCR Comma
         IF Stk$[A]= "," THEN
            IF Comma = 2 THEN
               Stk$[A]= ",(LONG_PTR)"
               INCR Comma
            END IF
         END IF
      NEXT
      EXIT SUB
   END IF

   IF TestState = TRUE THEN
      IF LastCmd = 0 THEN
         IF *Stk$[1] = ASC("*") THEN
            GTmp$ = Clean$(Stk$[2])
         ELSE
            GTmp$ = Clean$(Stk$[1])
         END IF
         IF LEFTSTR(GTmp$,"*") THEN GTmp$ = MID$(GTmp$,2)
         i = INCHR(GTmp$,".")
         IF i = 0 THEN i = iMatchNQ (GTmp$,"->")
         IF i > 0 THEN
            IF WithCnt THEN
               GTmp$ = WithVar$[WithCnt]
            ELSE
               GTmp$ = LEFT$(GTmp$, i - 1)
            END IF
         END IF
         IF INCHR(GTmp$,"[") THEN GTmp$ = EXTRACT$(GTmp$,"[")
         IF CheckLocal(GTmp$, &j) = vt_UNKNOWN THEN
            IF CheckGlobal(GTmp$, &j) = vt_UNKNOWN THEN
               GTmp$ = LCASE$(GTmp$)
               IF Stk$[2] = "=" AND GTmp$ <> "functionreturn" AND GTmp$ <> "bcx_retstr" AND GTmp$ <> "end" AND iMatchNQ(Src$,"->") = 0 THEN
                  Warning("Assignment before Declaration in Line " + STR$(LineNum[FileNdx]) + " in Module: " + TRIM$(FileNames$[FileNdx]) + ": " + Src$)
               END IF
            END IF
         END IF
      END IF
   END IF
END SUB ' FixUps



SUB FuncSubDecs1(s$, iStart AS INT, iEnd AS INT, ptVar AS VARCODE PTR)
   '*****************
   DIM RAW iBrktPairLoc, iEmpty
   '*****************
   IF iMatchRgt(Stk$[iStart], s$) THEN
      IF DataType(Stk$[iStart+1]) = vt_STRVAR THEN
         Abort("Invalid " + s$ + " name")
      END IF
   END IF

   XFOR iEmpty = FALSE, iBrktPairLoc = GetBrkPairPosF(iStart, iEnd) WHILE iBrktPairLoc _
      BY iBrktPairLoc = GetBrkPairPosF(iBrktPairLoc, iEnd)
      DIM RAW iVarLoc = iBrktPairLoc - 1
      IF iMatchWrd(Stk$[iBrktPairLoc+2],"as") THEN
         Stk$[iBrktPairLoc+3] = Stk$[iBrktPairLoc+3] + "*"
         Stk$[iBrktPairLoc++] = "" : Stk$[iBrktPairLoc] = ""
         iEmpty = TRUE
      ELSEIF Stk$[iBrktPairLoc+2] = "[" THEN
         DO WHILE iBrktPairLoc <= iEnd
            IF iMatchWrd(Stk$[iBrktPairLoc],"as") THEN EXIT DO
            IF iMatchRgt(Stk$[iVarLoc],"]") AND INCHR(",)=", Stk$[iBrktPairLoc]) THEN EXIT DO
            CONCAT(Stk$[iVarLoc],Stk$[iBrktPairLoc])
            Stk$[iBrktPairLoc++] = ""
            iEmpty = TRUE
         LOOP
      ELSE
         DIM RAW iDataType = DataType(Stk$[iVarLoc])
         Stk$[iVarLoc] = Clean$(Stk$[iVarLoc])
         IF iDataType = vt_STRVAR THEN
            CALL InsertTokens(iBrktPairLoc+1, 5, "[", "BCXSTRSIZE", "]", "as", "char")
            iEnd += 5
         ELSE
            Stk$[iBrktPairLoc++] = "as"
            Stk$[iBrktPairLoc] = GetVarTypeName$(iDataType)+ "*"
         END IF
      END IF
   XNEXT

   IF iMatchWrd(Stk$[iEnd],"export") THEN
      DECR Ndx
      ptVar->IsExported = TRUE
      IF UseStdCall THEN
         CallType$ = "__stdcall "
      ELSE
         CallType$ = "__cdecl "
      END IF
   END IF

   IF iEmpty THEN
      CALL RemEmptyTokens
   END IF
END SUB ' FuncSubDecs1



SUB RemEmptyTokens
   DIM RAW i, j
   FOR i = 1 TO Ndx
      IF ISNULL(Stk$[i]) THEN
         j = i
         DO WHILE ISNULL(Stk$[j]) AND (j < Ndx)
            INCR j
         LOOP
         IF ISNULL(Stk$[j]) THEN EXIT FOR
         Stk$[i] = Stk$[j]
         Stk$[j] = ""
      END IF
   NEXT i
   Ndx = i-1
END SUB



SUB FuncSubDecs2(s$, methd, VarCode AS VARCODE PTR, iFirstToken AS INT, iLastToken AS INT PTR)
   IF iMatchRgt(Stk$[iFirstToken], s$) THEN
      IF iMatchWrd(Stk$[*iLastToken-1],"as") THEN
         CALL Abort("Attempted type assignment to " + s$)
      END IF
      VarCode->IsPtrFlag = 0
      CurrentFuncType = vt_VOID
   ELSE
      IF iMatchWrd(Stk$[(*iLastToken)-1],"as") THEN
         CurrentFuncType  = CheckType(Stk$[*iLastToken])
         VarCode->Token$   = Stk$[iFirstToken+1]
         VarCode->AsToken$ = Stk$[*iLastToken]
         VarCode->IsPtrFlag = TALLY(Stk$[*iLastToken],"*")
         Stk$[(*iLastToken)--] = ""
         Stk$[(*iLastToken)--] = ""
      ELSE
         ' Check if Constructor/Destructor
         IF ConstructDestructTest(1) THEN
            CurrentFuncType = vt_CONSTRDESTR
         ELSE
            CurrentFuncType = DataType(Stk$[iFirstToken+1])
         END IF
         VarCode->Token$ = Stk$[iFirstToken+1]
         VarCode->IsPtrFlag = TALLY(Stk$[iFirstToken+1],"*")
         VarCode->AsToken$ = ""
      END IF
   END IF
   VarCode->Proto$    = " ("
   VarCode->Header$   = " ("
   VarCode->Functype$ = ""
   VarCode->Methd%    = methd
   VarCode->VarNo%    = CurrentFuncType
   CALL GetVarCode(VarCode,"FuncSubDecs2")
END SUB ' FuncSubDecs2



SUB FuncSubDecs3(varcode AS VARCODE PTR, iLast AS INT, iExtended AS INT)

   IF *Stk$[iLast-1] = ASC(".") THEN                    ' Allow Functions | Subs WITH one OR
      Stk$[iLast-1] = "..."
      'varcode->Header$ = varcode->Header$  +  "..."    ' more "." TO produce the "..." needed
   END IF

   varcode->Header$ = RTRIM$(varcode->Header$)
   CONCAT(varcode->Header$, ")")

   IF UseCpp = FALSE THEN
      REPLACE "()" WITH "(void)" IN varcode->Header$
   END IF

   IF iExtended THEN
      varcode->Header$ = varcode->Functype$ + "(*" + varcode->Token$ + ")" + varcode->Header$
   ELSE
      varcode->Header$ = varcode->Functype$ + varcode->Token$ + varcode->Header$
   END IF

   IF varcode->Methd% = 2 THEN
      varcode->Proto$ = RTRIM$(varcode->Proto$)
      IF iMatchRgt(varcode->Proto$, ",")  THEN
         MID$(varcode->Proto$, LEN(varcode->Proto$)) = ")"
      ELSE
         CONCAT(varcode->Proto$, ")")
      END IF

      REPLACE "()" WITH "(void)" IN varcode->Proto$
      IF iExtended THEN
         varcode->Proto$ = varcode->Functype$ + "(*)" + varcode->Proto$
      ELSE
         varcode->Proto$ = varcode->Functype$ + varcode->Token$ + varcode->Proto$ + ";"
      END IF
   END IF

   IF varcode->UseInLine THEN
      varcode->Header$ = "inline " + varcode->Header$
      varcode->Proto$  = "inline " + varcode->Proto$
   END IF
   UseInLine = FALSE

   IF varcode->IsExported THEN
      varcode->Proto$  = "C_EXPORT " + varcode->Proto$
      varcode->Header$ = "C_EXPORT " + varcode->Header$
   END IF
END SUB ' FuncSubDecs3



SUB AddTypeDefs(sTypeDefName$, TDef)
   INCR TypeDefsCnt

   IF TypeDefsCnt = MaxTypes THEN
      CALL Abort("Exceeded TYPE Limits.")
   END IF

   TypeDefs[TypeDefsCnt].VarName$ = sTypeDefName$
   TypeDefs[TypeDefsCnt].TypeofDef = TDef
   TypeDefs[TypeDefsCnt].EleCnt = 0
END SUB ' AddTypeDefs



FUNCTION DefsID(ParmStr$)
   IF TypeDefsCnt > 0 THEN
      FOR INT i = 1 TO TypeDefsCnt
         IF ParmStr$ = TypeDefs[i].VarName$ THEN
            FUNCTION = i
         END IF
      NEXT
   END IF
   FUNCTION = 0
END FUNCTION ' DefsID



SUB GetTypeInfo(szArg$, BYREF IsPointer, BYREF UdtIdx, BYREF vtCode)
   DIM RAW Var1$
   IsPointer = TALLY(szArg$, "*")
   Var1$     = TRIM$(REMOVE$(szArg$, "*"))

   IF RIGHTSTR (Var1$,"_CLASS") THEN Var1$ = LEFT$(Var1$,LEN(Var1$)-6)
   vtCode = CheckType(Var1$)

   IF vtCode = vt_UNKNOWN THEN
      CALL AddTypeDefs(Var1$, vt_UDT)    ' Assume its a WinApi type
      vtCode = vt_UDT
   END IF
   UdtIdx = 0
   IF vtCode = vt_STRUCT OR vtCode = vt_UNION OR vtCode = vt_UDT THEN
      UdtIdx = DefsID(Var1$)
   END IF
END SUB ' GetTypeInfo



SUB AddTypedefElement(WorkingTypeDefsCnt, ElType, EName$, EType$, EPtr = 0)
   DIM RAW TD AS UserTypeDefs PTR
   TD = &(TypeDefs[WorkingTypeDefsCnt])

   IF TD->EleCnt = MaxElements THEN
      CALL Abort("Exceeded TYPE Element Limits.")
   END IF

   TD->Elements[TD->EleCnt].ElementType    = ElType
   TD->Elements[TD->EleCnt].ElementDynaPtr = EPtr
   IF ElType = vt_STRUCT OR ElType = vt_UNION OR ElType = vt_UDT THEN
      TD->Elements[TD->EleCnt].ElementID = DefsID(EType$)
   ELSE
      TD->Elements[TD->EleCnt].ElementID = 0
   END IF
   TD->Elements[TD->EleCnt].ElementName$ = EName$
   TD->EleCnt = 1 + TD->EleCnt
END SUB ' AddTypedefElement



FUNCTION GetElement$(StartStk, BYREF vt, BYREF dms, id)
   DIM RAW BC = 0, i, LZZ$

   FOR i = StartStk+1 TO Ndx
      IF *Stk$[i] = ASC("[") THEN
         INCR BC
      ELSEIF *Stk$[i] = ASC("]") THEN
         DECR BC
      ELSE
         IF BC = 0 THEN
            IF iMatchLft(Stk$[i], "->") OR *Stk$[i] = ASC(".") THEN
               LZZ$ = Stk$[i]                        ' MrBcx  786
               RemoveAll(LZZ$, "%$#!@`.->( *)", 1)   ' MrBcx  786
               vt = GetElementInfo(&id, &dms, LZZ$)
               IF vt <> vt_STRUCT AND vt <> vt_UNION THEN EXIT FOR
            END IF
         END IF
      END IF
   NEXT

   IF vt = vt_UDT OR vt = vt_UNION OR vt = vt_STRUCT THEN
      LZZ$ = TypeDefs[id].VarName$
   ELSE
      LZZ$ = GetVarTypeName$(vt)
   END IF
   FUNCTION = LZZ$
END FUNCTION



FUNCTION GetElementInfo(BYREF DefID, BYREF EPtr, Elename$)
   DIM RAW id
   id = DefID
   FOR INT i = 0 TO TypeDefs[id].EleCnt - 1
      IF Elename$ = TypeDefs[id].Elements[i].ElementName$ THEN
         DefID = TypeDefs[id].Elements[i].ElementID
         EPtr  = TypeDefs[id].Elements[i].ElementDynaPtr
         FUNCTION = TypeDefs[id].Elements[i].ElementType
      END IF
   NEXT
   FUNCTION = 0
END FUNCTION



SUB HandleNonsense
   ' tolerate nonsense like >> DIM A% as DOUBLE << by removing the sigil
   FOR INT i = 1 TO Ndx
      IF iMatchWrd(Stk$[i],"as") THEN Stk$[i - 1] = Clean$(Stk$[i - 1])
      IF OptionBase THEN   ' This was the easiest way I could see to do this!
         IF *Stk$[i] = ASC("[") THEN Stk$[i+1] = STR$(OptionBase,TRUE) + "+" + Stk$[i+1]
      END IF
   NEXT
END SUB ' HandleNonsense



SUB ValidVar(v$)
   DIM RAW LZZ$

   IF ISFALSE(isalpha(*v$)) AND *v$ <> ASC("_")  THEN
      IF ISFALSE(iMatchLft(v$, "(*")) AND v$ <> "&" THEN  ' Allow byref format (*A).xxx
         CALL Abort("Invalid String Variable Name")
      END IF
   END IF

   IF RestrictedWords(v$) AND TestState THEN
      LZZ$ = "Variable " + v$ + " on line"
      LZZ$ = LZZ$ + STR$(LineNum[FileNdx]) + " in Module: " + TRIM$(FileNames$[FileNdx]) + " is a Restricted Word"
      CALL Warning(LZZ$)
   END IF
END SUB ' ValidVar



SUB PointerFix
   CONCAT(Stk$[Ndx-1],Stk$[Ndx])
   Stk$[Ndx] = ""
   DECR Ndx
   DO WHILE TALLY(Stk$[Ndx],"*") = LEN(Stk$[Ndx])
      CONCAT(Stk$[Ndx-1],Stk$[Ndx])
      Stk$[Ndx] = ""
      DECR Ndx
   LOOP
END SUB ' PointerFix



SUB DimDynaString(SVar$, DG, s)
   DIM RAW DS$

   DS$ = "if (" + SVar$ + ") { free(" + SVar$ + "); " + SVar$ + " = NULL; }"
   IF InFunction AND (IsLocal OR IsDim OR IsRaw OR IsAuto OR IsRegister) AND DG = 0 THEN

      IF cMaxDynaStr = ++LocalDynaCnt THEN
         CALL Abort("Maximum number of local dynamic allocations exceeded.")
      END IF

      DynaStr$[LocalDynaCnt] = DS$

      IF IsAuto THEN
         FPRINT Outfile, Scoot$, "char *",SVar$,";"
      ELSEIF IsRegister THEN
         FPRINT Outfile, Scoot$, "char *",SVar$,";"
      ELSE
         FPRINT Outfile, Scoot$, "char *",SVar$,";"
      END IF
      CALL AddLocal(SVar$, vt_CHAR, 0, "", 1)
   ELSE
      IF Use_GenFree THEN
         CALL AddDynamicGlobal(DS$)
      END IF
      IF DG = 2 THEN
         CALL AddGlobal(SVar$, vt_CHAR, 0,"",1,0,1)
      ELSE
         IF s THEN
            CALL AddGlobal(SVar$, vt_CHAR, 0,"",1,0,2)
         ELSE
            CALL AddGlobal(SVar$, vt_CHAR, 0,"",1)
         END IF
      END IF
   END IF
   IF DG <> 2 THEN
      FPRINT Outfile, Scoot$, SVar$ , "=(char*)calloc(";
      Stk$[++Ndx] = ",1);"
      CALL WriteCleanTokens(4,Ndx)
   END IF
END SUB ' DimDynaString



SUB AddDynamicGlobal(szGlobalStr AS PCHAR)
   INCR GlobalDynaCnt
   IF cMaxGlobalDyna = GlobalDynaCnt THEN
      CALL Abort("Maximum number of global dynamic arrays exceeded.")
   END IF
   GlobalDynaStr$[GlobalDynaCnt] = szGlobalStr$
END SUB



FUNCTION SubFuncTest
   IF iMatchWrd(Stk$[2],"function") OR iMatchWrd(Stk$[2],"sub") THEN
      FUNCTION = 1
   END IF
   FUNCTION = 0
END FUNCTION ' SubFuncTest



FUNCTION ConstructDestructTest(iTokenLoc AS INT)
   IF iMatchWrd(Stk$[iTokenLoc],"constructor") OR iMatchWrd(Stk$[iTokenLoc],"destructor") THEN
      FUNCTION = 1
   END IF
   FUNCTION = 0
END FUNCTION ' ConstructDestructTest



FUNCTION DimSubFunc(iMeth)
   GLOBAL SFPOINTER
   DIM RAW bOppFound AS BOOL
   DIM RAW Funptr = 0
   DIM RAW i
   DIM RAW id
   DIM RAW iEqualLoc
   DIM RAW LTmp$ =  ""
   DIM RAW StartPoint = 3
   DIM RAW szInit$
   DIM RAW szIsConst$
   DIM RAW szStatic$
   DIM RAW szV$
   DIM RAW szWrk$
   DIM RAW vt
   DIM RAW w
   DIM RAW FP AS functionParse  : memset (&FP,0,SIZEOF(functionParse))   ' MrBcx 789


   IF iMatchWrd(Stk$[Ndx],"stdcall") THEN
      CallType$ = "__stdcall "
      Stk$[Ndx--] = ""
      IsStdFunc = TRUE
   ELSE
      IF InClass OR InPPType THEN
         CallType$ = ""
      ELSE
         CallType$ = "__cdecl "    ' Default calling convention
      END IF
      IsStdFunc = FALSE
   END IF

   IF iMatchWrd(Stk$[3],"operator") THEN
      XFOR i = 4,bOppFound = FALSE WHILE NOT bOppFound BY i++
         IF Stk$[i] = "(" THEN
            IF Stk$[i+1] <> ")" AND Stk$[i+2] <> "(" THEN bOppFound = TRUE
            IF Stk$[i+1] = ")" AND i > 4 THEN bOppFound = TRUE
         END IF
         IF NOT bOppFound THEN
            CONCAT(Stk$[3],Stk$[i])
            Stk$[i] = ""
         END IF
      XNEXT
   END IF

   szWrk$ = Clean$(Stk$[Ndx])

   IF *szWrk$ THEN
      GetTypeInfo(szWrk$, &w, &id, &vt)
      IF vt = vt_WINBOOL THEN
         IREPLACE "WINBOOL" WITH "BOOL" IN Stk$[Ndx]
      END IF
   END IF

   '------------------------------------------------------
   '  Find start of function body (...)
   '------------------------------------------------------

   CALL SepFuncArgs(3, &FP, TRUE)

   StartPoint = IMAX(FP.CommaPos[0], 3)

   IF NOT InTypeDef AND NOT InClass AND NOT InPPType THEN
      SFPOINTER = TRUE
      '------------------------------------------------------
      '  Get intialized data  " = xxx" or "= {xxx,xxx}"
      '------------------------------------------------------
      IF FP.NumArgs = 0 THEN
         i = IMIN(FP.CommaPos[1]+1, Ndx)
      ELSE
         i = IMIN(FP.CommaPos[FP.NumArgs]+1, Ndx)
      END IF

      IF Stk$[i] = "=" THEN
         Stk$[i++] = ""
         DO WHILE NOT iMatchWrd(Stk$[i], "as") AND i <= Ndx
            CONCAT(LTmp$, Stk$[i])
            Stk$[i++] = ""
         LOOP
         RemoveAll(LTmp$, "{}", 1)
         IF LTmp$ <> "" THEN CALL RemEmptyTokens
      END IF
      '------------------------------------------------------

      FPRINT FP_UDT, Scoot$, MakeDecProto$(&FP),";"

      SFPOINTER = FALSE

      Ndx = StartPoint
      Stk$[2] = ""

      IF LTmp$ <> "" THEN
         Stk$[Ndx++] = "="
         Stk$[Ndx++] = "{"
         Stk$[Ndx++] = Clean$(LTmp$)
         Stk$[Ndx++] = "}"
      END IF

      Stk$[Ndx++] = "as"
      Stk$[Ndx] = Clean$(Stk$[3]) + "_TYPE" + STRING$(Funptr, ASC("*"))

      CALL RemEmptyTokens
      FUNCTION = FALSE

   ELSE    ' C++
      szV$       = ""
      szWrk$     = ""
      szStatic$  = ""
      szIsConst$ = ""
      szInit$    = ""
      iEqualLoc  = Ndx

      IF IsVirtual THEN
         szV$ = "virtual "
         IsVirtual = FALSE
      ELSE
         szV$ = ""
      END IF

      DO WHILE Stk$[iEqualLoc] <> "=" AND iEqualLoc
         IF Stk$[iEqualLoc] = ")" THEN EXIT DO
         DECR iEqualLoc
      LOOP

      IF Stk$[iEqualLoc] = "=" THEN
         szInit$ = Stk$[iEqualLoc++]
         CONCAT(szInit$,Stk$[iEqualLoc++])
      END IF

      IF iMatchWrd(Stk$[Ndx], "const") THEN
         szIsConst$ = "const"
      ELSE
         szIsConst$ = ""
      END IF

      szStatic$ = ""
      IF iMatchWrd(Stk$[1], "static") THEN szStatic$ = "static "

      szWrk$ = MakeDecProto$(&FP)

      IF iMeth THEN
         szWrk$ = TRIM$(MID$(szWrk$,INCHR(szWrk$,SPC$)))
      END IF

      IF szVirtual$ = szInit$ THEN
         szInit$ = ""
      END IF

      FPRINT FP_UDT, Scoot$, szV$,szStatic$,szWrk$,szVirtual$,szInit$,szIsConst$,";"
      szVirtual$ = ""
   END IF

   FUNCTION = TRUE
END FUNCTION ' DimSubFunc



SUB InBlockReSet
   LocalVarCnt = LocalInBlock[InBlock]
   DECR InBlock
   IF InBlock < 0 THEN
      Abort("Too many END BLOCKS")
   END IF
END SUB



SUB InBlockSet
   INCR InBlock

   IF InBlock = cMaxLocalInBlocks THEN
      CALL Abort("Too many nested BEGINBLOCK/ENDBLOCKs")
   END IF

   LocalInBlock[InBlock] = LocalVarCnt
END SUB



FUNCTION IsValidName(szArg$)
   IF isalpha(*szArg) OR *szArg = ASC("_") THEN FUNCTION = TRUE
   FUNCTION = FALSE
END FUNCTION



SUB AddSpace(i AS INT)
   IF IsValidName(Stk$[i]) AND IsValidName(Stk$[i+1]) THEN
      CONCAT(Stk$[i],SPC$)
   END IF
END SUB



SUB EmitOld(FuncRetnFlag AS INT PTR)
   '********************************
   DIM LOCAL strtest, varid, vi AS VarInfo PTR, vr$, brcnt, LTmp$
   DIM LOCAL eo_H, eo_I, eo_J, eo_K
   DIM LOCAL HasStorage
   DIM RAW Arg$
   DIM RAW EqlSgnPos

   IF Ndx = 0 THEN EXIT SUB

   '**********************************************************************
   ' "="   We MUST be processing an assignment statement if we get here!
   '       or perhaps calling a SUB without using the CALL keyword
   '**********************************************************************

   FOR INT i = 1 TO Ndx                                    ' MrBcx 790  This loop supports UDT arrays
      IF IM_UDT_STRING (Stk$[i]) THEN CONCAT(Stk$[i],"$")  ' MrBcx 790
      IF IM_UDT_SINGLE (Stk$[i]) THEN CONCAT(Stk$[i],"!")  ' MrBcx 790
      IF IM_UDT_DOUBLE (Stk$[i]) THEN CONCAT(Stk$[i],"#")  ' MrBcx 790
   NEXT                                                    ' MrBcx 790

   FOR EqlSgnPos = 1 TO Ndx
      IF *Stk$[EqlSgnPos] = ASC("=") THEN
         '********************************
         IF NOT(*Stk$[EqlSgnPos-1] = ASC("<") OR _   ' This IF block restored from 759.
            *Stk$[EqlSgnPos-1] = ASC(">")     OR _   ' 760 through 781 had a flaw that
            *Stk$[EqlSgnPos-1] = ASC("+")     OR _   ' revealed itself in a very old
            *Stk$[EqlSgnPos-1] = ASC("-")     OR _   ' SEMI-OOP demo.
            *Stk$[EqlSgnPos-1] = ASC("/")     OR _   ' I renamed the variable "B" to the
            *Stk$[EqlSgnPos-1] = ASC("*"))    THEN   ' more useful "EqlSgnPos" (MrBcx-782)
            EXIT FOR
         END IF
         '********************************
      END IF
   NEXT

   '*************************************************************************
   'There's no "=" so we're either calling a SUB or this is a FUNCTION RETURN
   '*************************************************************************

   IF EqlSgnPos-1 = Ndx THEN
      CALL BuildCleanStr(1, Ndx, LTmp$)
      CONCAT(LTmp$, ";")
      IF *FuncRetnFlag = 2 THEN
         FPRINT Outfile, LTmp$
      ELSE
         FPRINT Outfile, Scoot$, LTmp$
      END IF
      IF *FuncRetnFlag = 2 THEN
         *FuncRetnFlag = 0
         Stk$[1] = ""
         EXIT SUB
      END IF
      EXIT SUB
   END IF

   '*************************************************************************
   '      It can only be one thing now -- a normal assignment statement
   '*************************************************************************

   FOR eo_I = 2 TO EqlSgnPos-1
      CONCAT(Stk$[1], Stk$[eo_I])    ' If present, build the Array Variable
   NEXT

   eo_H = INCHR(Stk$[1], "*")
   IF eo_H THEN
      IF NOT (INCHR(Stk$[1], "$") AND eo_H > 1) THEN 'Exclude strings BYREF
         RemoveAll(Stk$[1], "$")
         GOTO ProcessNumeric
      END IF
   END IF

   '*************************************************************************
   '                    ' Process a string expression
   '*************************************************************************

   strtest = DataType(Stk$[1])

   IF *Stk$[1] <> ASC("(") THEN         ' MrBcx 789   This overcomes the
      IF strtest = vt_UNKNOWN THEN      ' MrBcx 789   _StrName = "Fubar" bug
         CONCAT (Stk$[1], "$")          ' MrBcx 789
         strtest = vt_STRVAR            ' MrBcx 789
      END IF                            ' MrBcx 789
   END IF                               ' MrBcx 789

   IF strtest = vt_INTEGER THEN
      brcnt = TALLY(Stk$[1], "[")
      vr$ = EXTRACT$(Stk$[1], "[")
      strtest = CheckLocal(vr$, &varid)

      IF strtest = vt_UNKNOWN THEN
         strtest = CheckGlobal(vr$, &varid)
         vi = &(GlobalVars[varid])
      ELSE
         vi = &(LocalVars[varid])
      END IF

      IF strtest = vt_CHAR THEN
         strtest = vt_STRVAR
      END IF

      IF strtest = vt_STRVAR THEN
         IF NOTZERO (vi->VarPntr) THEN
            ' string pointer
            GOTO ProcessNumeric
         END IF
         IF TALLY(vi->VarDim,"[") = brcnt THEN
            ' the character within string
            GOTO ProcessNumeric
         END IF
         IF TALLY(vi->VarDim,"[") <> brcnt + 1 THEN
            ' string pointer
            GOTO ProcessNumeric
         END IF
      END IF
   END IF

   '*************************************************************************
   '       NOTE: Do not relocate this UDT-CHECK block         - MrBcx 789
   '*************************************************************************

   IF strtest = vt_UNKNOWN THEN
      IF IM_UDT_STRING (Stk$[1]) THEN
         CONCAT(Stk$[1],"$")
         strtest = vt_STRVAR
      END IF
   END IF

   IF strtest = vt_UNKNOWN THEN
      IF IM_UDT_SINGLE (Stk$[1]) THEN
         CONCAT(Stk$[1],"!")
         strtest = vt_SINGLE
      END IF
   END IF

   IF strtest = vt_UNKNOWN THEN
      IF IM_UDT_DOUBLE (Stk$[1]) THEN
         CONCAT(Stk$[1],"#")
         strtest = vt_DOUBLE
      END IF
   END IF

   '****************************************************************************
   IF strtest = vt_STRVAR THEN

      IF EqlSgnPos + 1 = Ndx THEN
         IF Stk$[Ndx] = DDQ$ THEN
            FPRINT Outfile, Scoot$, "*", Clean$(Stk$[1]), "=0;"
            GOTO StringExit
         END IF
      END IF

      ' [ Speedup No. 1 ] *****************************************************

      IF Ndx = 3 THEN
         Stk$[1] = Clean$(Stk$[1])
         Stk$[3] = Clean$(Stk$[3])
         IF Stk$[1] = "BCX_RetStr" THEN
            FPRINT Outfile, Scoot$, "BCX_RetStr = BCX_TmpStr(strlen(", Stk$[3], "));"
         END IF
         FPRINT Outfile, Scoot$, "strcpy(", Stk$[1], ",", Stk$[3], ");"
         GOTO StringExit
      END IF

      '***********************
      Arg$  = ""
      LTmp$ = ""
      eo_J = eo_K = 0
      '***********************

      IF iMatchLft(Stk$[3],"$$") THEN HasStorage = TRUE

      Var$ = Clean$(Stk$[1])

      IF Clean$(Stk$[EqlSgnPos+1]) = Var$ THEN
         eo_K = TRUE
      END IF

      FOR eo_H = EqlSgnPos+1 TO Ndx
         IF Stk$[eo_H]= "&" AND Stk$[eo_H-1] <> "," AND Stk$[eo_H-1] <> "(" THEN
            INCR eo_J
            CONCAT(Arg$, LTmp$)
            LTmp$ = ","
         ELSE
            CONCAT(LTmp$, Clean$(Stk$[eo_H]))
         END IF
      NEXT

      IF NOTNULL (LTmp$) AND LTmp$ <> "," THEN
         CONCAT(Arg$,LTmp$)
      END IF

      '*************************************************************************
      '               String Assignment Construction Rules
      '*************************************************************************
      '           IF eo_J = 0 & K = ANY       THEN use strcpy
      '           IF eo_J = 1 & K = TRUE      THEN use strcat
      '           Everything else             THEN use join
      '*************************************************************************

      RemoveAll(Var$, SPC$)

      IF eo_J = 0 THEN
         IF Var$ = "BCX_RetStr" THEN
            IF HasStorage THEN
               FPRINT Outfile, Scoot$, "BCX_RetStr=", Arg$, ";"
               GOTO StringExit
            ELSE
               FPRINT Outfile, Scoot$, "BCX_RetStr = BCX_TmpStr(strlen(" , Arg$ , "));"
            END IF
         END IF
         FPRINT Outfile, Scoot$, "strcpy(", Var$ , "," , Arg$, ");"
         GOTO StringExit
      END IF

      ' If we make it here then we should have 2 or more expressions

      IF eo_K = TRUE AND eo_J = 1 THEN
         FPRINT Outfile, Scoot$, "strcat(", Arg$ , ");"
         GOTO StringExit
      END IF

      ' STR$ has an opt argument.  FALSE is the default and TRUE means
      ' omit the space on the result, eliminating the need for LTRIM$

      LTmp$ = STR$(++eo_J,1)
      Use_Join = Use_BcxTmpStr = TRUE

      IF Var$ = "BCX_RetStr" THEN
         FPRINT Outfile, Scoot$, "BCX_RetStr=join(" , LTmp$ , "," , Arg$, ");"
      ELSE
         FPRINT Outfile, Scoot$, "strcpy(",Var$, ", join(" , LTmp$ , "," , Arg$, "));"
      END IF

      StringExit:
      EXIT SUB
      '***********************

   ELSE

      '***********************
      ProcessNumeric:
      '***********************
      FOR eo_I = 2 TO EqlSgnPos
         Stk$[eo_I] = ""
      NEXT

      Stk$[EqlSgnPos] = "="    'This is necessary

      ' change x = x ? c to x ?= c

      IF Stk$[EqlSgnPos+1] = Stk$[1] AND Ndx = 5 THEN
         IF Inset(Stk$[EqlSgnPos+2], "+-*/") AND Stk$[EqlSgnPos+3] <> ">" THEN
            Stk$[EqlSgnPos] = Stk$[EqlSgnPos+2] + Stk$[EqlSgnPos]
            Stk$[EqlSgnPos+1] = ""
            Stk$[EqlSgnPos+2] = ""
         END IF
      END IF

      FOR eo_H = 2 TO Ndx
         IF isdigit(*Stk$[eo_H]) AND iMatchRgt(Stk$[eo_H],"E") THEN
            CONCAT(Stk$[eo_H],Stk$[eo_H+1])
            IF *Stk$[eo_H+1] = ASC("-") THEN
               CONCAT(Stk$[eo_H],Stk$[eo_H+2])
               Stk$[eo_H+2] = ""
            END IF
            Stk$[eo_H+1] = ""
         END IF
      NEXT

      FPRINT Outfile, Scoot$, Clean$(Stk$[1]);

      FOR eo_H = 2 TO Ndx
         IF *Stk$[eo_H] = ASC("!") THEN
            FPRINT Outfile, "!";

            IF *Stk$[eo_H-1] <> ASC("=") THEN
               FPRINT Outfile, "=";
            END IF

         ELSE
            FPRINT Outfile, Clean$(Stk$[eo_H]);
         END IF
         IF eo_H < Ndx THEN
            IF ISFALSE(ispunct(*Stk$[eo_H+1])) THEN FPRINT Outfile, "";
         END IF
      NEXT
      FPRINT Outfile, ";"
   END IF
END SUB ' EmitOld



SUB Display_Version_and_Compiler
   IF BCX_COLORS THEN COLOR 10,0
   PRINT "Version ", VERSION$, Compiler_Used$()
   POPCOLORS
END SUB



FUNCTION Compiler_Used$
   DIM RAW Buff$ =  " Built with "
   $IFDEF __BCPLUSPLUS__
      CONCAT(Buff$, "Embarcadero C++")
   $ELSEIF __BORLANDC__
      CONCAT(Buff$, "Embarcadero C++")
   $ELSEIF __POCC__
      CONCAT(Buff$, "Pelles C")
   $ELSEIF __LCC__
      CONCAT(Buff$, "LCC-Win32")
   $ELSEIF __WATCOM_CPLUSPLUS__
      CONCAT(Buff$, "Open Watcom C++")
   $ELSEIF __clang__ AND __MINGW64__
      CONCAT(Buff$, "LLVM-MinGW32 C++")
   $ELSEIF __MINGW64__
      CONCAT(Buff$, "MinGW64 C++")
   $ELSEIF __MINGW32__
      CONCAT(Buff$, "MinGW32 C++")
   $ELSEIF __DMC__
      CONCAT(Buff$, "Digital Mars C/C++")
   $ELSEIF __clang__
      CONCAT(Buff$, "LLVM-CLANG")
   $ELSEIF _MSC_VER
      CONCAT(Buff$, "MS Visual C++")
   $ELSE
      CONCAT(Buff$, "Unknown Compiler")
   $ENDIF
   $IFDEF _WIN64
      CONCAT(Buff$, " for 64-bit Windows Systems")
   $ELSE
      CONCAT(Buff$, " for 32-bit Windows Systems")
   $ENDIF
   FUNCTION = Buff$
END SUB




SUB KillFiles
   IF DebugModeOff THEN
      KILL hdrFile$
      KILL enuFile$
      KILL SysFile$
      KILL UsrFile$
      KILL udtFile$
      KILL setFile$
      KILL cppFile$
      KILL prcFile$
      KILL ovrFile$
      KILL datFile$
      KILL resFile$
   END IF
END SUB



SUB Abort(AbortStr$)
   DIM LOCAL i AS INT
   DIM LOCAL j AS INT
   DIM LOCAL k AS INT
   DIM LOCAL t$
   DIM LOCAL varnum
   DIM LOCAL frmt$

   WarnMsg$ = ""

   IF LEFTSTR(AbortSrc$, "$BCXVERSION") THEN
      CONCAT(WarnMsg$, AbortStr$)
   ELSE
      WarnMsg$ = WarnMsg$ + AbortStr$ + " at line" + STR$(LineNum[FileNdx])
      WarnMsg$ = WarnMsg$ + " in Module: " + TRIM$(FileNames$[FileNdx]) + CRLF$
      WarnMsg$ = WarnMsg$ + "Original line" + CRLF$
      WarnMsg$ = WarnMsg$ +  AbortSrc$ + CRLF$
      WarnMsg$ = WarnMsg$ + "==============" + CRLF$
      WarnMsg$ = WarnMsg$ + "Current Tokens" + CRLF$
      WarnMsg$ = WarnMsg$ + "==============" + CRLF$

      FOR k = 1 TO Ndx
         j = LEN(Stk$[k])

         IF j < 40 THEN
            j = 40 - j
         ELSE
            j = 8 - IMOD(j,8)
         END IF

         frmt$ = LPAD$(STR$(k),3)

         WarnMsg$ = WarnMsg$ + frmt$ + SPC$ + Stk$[k] + STRING$(j,32) + CRLF$

         t$ = Clean$(Stk$[k])
         i = CheckLocal(t$, &varnum)

         IF i <> vt_UNKNOWN THEN
            WarnMsg$ = TRIM$(WarnMsg$)
            WarnMsg$ = WarnMsg$ + " is a LOCAL defined at line" + STR$(LocalVars[varnum].VarLine)
            WarnMsg$ = WarnMsg$ + " in Module: " + LocalVars[varnum].VarModule$ + CRLF$
         ELSE
            i = CheckGlobal(t$, &varnum)
            IF i <> vt_UNKNOWN THEN
               WarnMsg$ = TRIM$(WarnMsg$)
               WarnMsg$ = WarnMsg$ + " is a GLOBAL defined at line" + STR$(GlobalVars[varnum].VarLine)
               WarnMsg$ = WarnMsg$ + " in Module: " + GlobalVars[varnum].VarModule$
               WarnMsg$ = WarnMsg$ + SPC$ + Stk$[k] + GlobalVars[varnum].VarDim$ + " as "
               IF GlobalVars[varnum].VarDef THEN
                  WarnMsg$ = WarnMsg$ + TRIM$(TypeDefs[GlobalVars[varnum].VarDef].VarName$) + CRLF$
               ELSE
                  WarnMsg$ = WarnMsg$ + TRIM$(GetVarTypeName$(GlobalVars[varnum].VarType)) + CRLF$
               END IF
            ELSE
               IF *Stk$[k] = c_DblQt THEN
                  WarnMsg$ = TRIM$(WarnMsg$)
                  WarnMsg$ = WarnMsg$ + " is a string literal" + CRLF$
               END IF
            END IF
         END IF
      NEXT

      WarnMsg$ = WarnMsg$ + "===============" + CRLF$
      WarnMsg$ = WarnMsg$ + "Original Tokens" + CRLF$
      WarnMsg$ = WarnMsg$ + "===============" + CRLF$

      CALL XParse(AbortSrc$)

      FOR k = 1 TO Ndx
         j = LEN(Stk$[k])
         IF j < 40 THEN
            j = 40 - j
         ELSE
            j = 8 - IMOD(j,8)
         END IF

         frmt$ = LPAD$(STR$(k),3)

         WarnMsg$ = WarnMsg$ + frmt$ + SPC$ + Stk$[k] + STRING$(j,32) + CRLF$

         t$ = Clean$(Stk$[k])
         i = CheckLocal(t$, &varnum)

         IF i <> vt_UNKNOWN THEN
            WarnMsg$ = TRIM$(WarnMsg$)
            WarnMsg$ = WarnMsg$ + " is a LOCAL defined at line" + STR$(LocalVars[varnum].VarLine)
            WarnMsg$ = WarnMsg$ + " in Module: " + LocalVars[varnum].VarModule$ + CRLF$
         ELSE
            i = CheckGlobal(t$, &varnum)
            IF i <> vt_UNKNOWN THEN
               WarnMsg$ = TRIM$(WarnMsg$)
               WarnMsg$ = WarnMsg$ + " is a GLOBAL defined at line" + STR$(GlobalVars[varnum].VarLine)
               WarnMsg$ = WarnMsg$ + " in Module: " + GlobalVars[varnum].VarModule$
               WarnMsg$ = WarnMsg$ + SPC$ + Stk$[k] + GlobalVars[varnum].VarDim$ + " as "
               IF GlobalVars[varnum].VarDef THEN
                  WarnMsg$ = WarnMsg$ + TypeDefs[GlobalVars[varnum].VarDef].VarName$ + CRLF$
               ELSE
                  WarnMsg$ = WarnMsg$ + GetVarTypeName$(GlobalVars[varnum].VarType) + CRLF$
               END IF
            ELSE
               IF *Stk$[k] = c_DblQt THEN
                  WarnMsg$ = TRIM$(WarnMsg$)
                  WarnMsg$ = WarnMsg$ + "is a string literal" + CRLF$
               END IF
            END IF
         END IF
      NEXT
   END IF

   CONCAT(WarnMsg$, CRLF$)

   CALL CloseAll

   CALL KillFiles
   KILL "$WRK$.TXT"

   KILL FileOut$
   KILL "$t$e$m$p"

   IF ErrFile THEN
      OPEN FileErr$ FOR APPEND AS fpErr
      FPRINT fpErr, AbortStr$ , " at line" , LineNum[FileNdx] , " in Module: ", TRIM$(FileNames$[FileNdx]) 'LinesRead
      CLOSE fpErr
   END IF

   IF InfoBoxWarn THEN
      INFOBOX("Warnings! :" , WarnMsg$, GetSystemMetrics(SM_CXSCREEN)/4, GetSystemMetrics(SM_CYSCREEN)/4)
   ELSE
      PRINT "Error!", CRLF$, FileIn$, CRLF$, WarnMsg$
   END IF
   CALL FREEGLOBALS
   END = 1
END SUB ' Abort



SUB BumpDown(szErr$)
   DECR Indent, 2
   IF Indent < 0 THEN
      IF ISNULL(szErr$) THEN
         CALL Abort("Unknown Error")
      ELSE
         CALL Abort(szErr$)
      END IF
   END IF
   Scoot$ = SPACE$(Indent)
END SUB ' BumpDown



SUB BumpUp
   IF Indent < 0 THEN Indent = 0
   INCR Indent, 2
   Scoot$ = SPACE$(Indent)
END SUB ' BumpUp



FUNCTION BracketHandler(Source$, l) AS PCHAR
   DIM RAW s AS PCHAR
   s = Source$

   SELECT CASE l
      CASE 0
      DO
         IF *s = 0 THEN EXIT DO
         IF *s = c_DblQt THEN
            INCR s
            DO WHILE *s <> c_DblQt
               IF *s = 0 THEN EXIT DO
               INCR s
            LOOP
         END IF

         IF *s = c_LtBkt THEN
            INCR s
            s = BracketHandler(s,1)
         END IF
         IF *s = c_LPar THEN
            INCR s
            s = BracketHandler(s,2)
         END IF
         INCR s
      LOOP

      CASE 1
      DO WHILE *s <> c_RtBkt
         IF *s = c_DblQt THEN
            INCR s
            DO WHILE *s <> c_DblQt
               IF *s = 0 THEN EXIT DO
               INCR s
            LOOP
         END IF

         IF *s = c_LtBkt THEN
            INCR s
            s = BracketHandler(s, 1)
         END IF

         IF *s = c_LPar THEN
            INCR s
            s = BracketHandler(s, 2)
         END IF
         IF *s = 0 THEN EXIT DO
         IF *s = c_Comma THEN *s = 1
         INCR s
      LOOP

      CASE 2
      DO WHILE *s <> c_RPar
         IF *s = c_DblQt THEN
            INCR s
            DO WHILE *s <> c_DblQt
               IF *s = 0 THEN EXIT DO
               INCR s
            LOOP
         END IF

         IF *s = c_LtBkt THEN
            INCR s
            s = BracketHandler(s, 1)
         END IF

         IF *s = c_LPar THEN
            INCR s
            s = BracketHandler(s, 2)
         END IF
         IF *s = 0 THEN EXIT DO
         INCR s
      LOOP
   END SELECT

   IF l = 0 THEN
      REPLACE CHR$(1) WITH "][" IN Source$
      FUNCTION = Source
   END IF

   FUNCTION = s
END FUNCTION ' BracketHandler



SUB PushSelectState(SelState$)
   INCR StateIdx
   IF cMaxNestedSelects = StateIdx THEN
      CALL Abort("Maximum nested SELECT/END SELECT reached.")
   END IF
   SelectState[StateIdx].CaseStk$= SelState$
END SUB ' PushSelectState



SUB PopSelectState(SelState$)
   SelState$ = SelectState[--StateIdx].CaseStk$
END SUB ' PopSelectState



SUB EmitEpilog
   IF Use_Wingui + MakeDLL + NoMain + EndOfProgram = 0 THEN
      FPRINT Outfile, "return EXIT_SUCCESS;   // End of main program"
      FPRINT Outfile, "}"
      FLUSH(Outfile)
   END IF
END SUB ' EmitEpilog



SUB EmitProlog(FP_WRITE AS FILE)
   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, "//      Made with BCX BASIC To C/C++ Translator"
   FPRINT FP_WRITE, "//            Version ", VERSION$
   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, "//    Translated for compiling with a ";

   IF UseCpp THEN
      FPRINT FP_WRITE, "C++ Compiler"
   ELSE
      FPRINT FP_WRITE, "C Compiler"
   END IF

   FPRINT FP_WRITE, "// *************************************************"

   IF UseCpp THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "#ifndef __cplusplus"
      FPRINT FP_WRITE, "  #error A C++ compiler is required"
      FPRINT FP_WRITE, "#endif"
      FPRINT FP_WRITE, ""
   END IF

   FPRINT FP_WRITE, "#define _CRT_SECURE_NO_DEPRECATE"

   IF Use_LeanAndMean = TRUE THEN
      FPRINT FP_WRITE, "#define  WIN32_LEAN_AND_MEAN"
   END IF

   IF Use_MULTITHREADED_SW THEN
      FPRINT FP_WRITE, "#define __BCX_MULTITHREADED__"
   END IF

   IF Use_COM OR Use_VBS THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "#ifndef _WIN32_DCOM"
      FPRINT FP_WRITE, "  #define _WIN32_DCOM"
      FPRINT FP_WRITE, "#endif"
   END IF

   IF Use_UNICODE THEN
      ' this should be emitted before any other windows header
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "#ifndef UNICODE"
      FPRINT FP_WRITE, "  #define UNICODE"
      FPRINT FP_WRITE, "#endif"
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "#ifndef _UNICODE"
      FPRINT FP_WRITE, "  #define _UNICODE"
      FPRINT FP_WRITE, "#endif"
      FPRINT FP_WRITE, ""
   END IF

   IF UseCpp AND UseCpphdr THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "#if defined(__cplusplus)"
      IF UseIO THEN
         FPRINT FP_WRITE, "  #include <iostream>"
      END IF
      FPRINT FP_WRITE, "  #include <fstream>"
      FPRINT FP_WRITE, "  #include <sstream>"
      FPRINT FP_WRITE, "  #include <iomanip>"
      FPRINT FP_WRITE, "  typedef std::string stdstr;"
      FPRINT FP_WRITE, "#endif"
      FPRINT FP_WRITE, ""
   END IF

   IF LOF(defFile$) > 7 THEN            ' Why 7? ... #define
      OPEN defFile$ FOR INPUT AS FP99
      DO WHILE NOT EOF(FP99)
         LINE INPUT FP99, Src$
         FPRINT FP_WRITE, Src$
      LOOP
      CLOSE FP99
      FPRINT FP_WRITE, ""
   END IF

   IF ZapFlag = FALSE THEN

      IF WinHeaders = TRUE OR Use_Project = TRUE THEN
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "#include <windows.h>    // WinApi"
         FPRINT FP_WRITE, "#include <windowsx.h>   // WinApi"
         FPRINT FP_WRITE, "#include <commctrl.h>   // WinApi"
         FPRINT FP_WRITE, "#include <commdlg.h>    // WinApi"
         FPRINT FP_WRITE, "#include <direct.h>     // WinApi"
         FPRINT FP_WRITE, "#include <mmsystem.h>   // WinApi"
         FPRINT FP_WRITE, "#include <oaidl.h>      // WinApi"
         FPRINT FP_WRITE, "#include <objbase.h>    // WinApi"
         FPRINT FP_WRITE, "#include <ocidl.h>      // WinApi"
         FPRINT FP_WRITE, "#include <ole2.h>       // WinApi"
         FPRINT FP_WRITE, "#include <oleauto.h>    // WinApi"
         FPRINT FP_WRITE, "#include <olectl.h>     // WinApi"
         FPRINT FP_WRITE, "#include <richedit.h>   // WinApi"
         FPRINT FP_WRITE, "#include <shellapi.h>   // WinApi"
         FPRINT FP_WRITE, "#include <shlobj.h>     // WinApi"
         FPRINT FP_WRITE, "#include <urlmon.h>     // WinApi"
         FPRINT FP_WRITE, "#include <wchar.h>      // WinApi"
         FPRINT FP_WRITE, "#include <wctype.h>     // WinApi"
         FPRINT FP_WRITE, "#include <tchar.h>      // WinApi"
         FPRINT FP_WRITE, "#include <unknwn.h>     // WinApi"
         FPRINT FP_WRITE, "#include <wininet.h>    // WinApi"
         FPRINT FP_WRITE, "#include <winsock.h>    // WinApi"
         FPRINT FP_WRITE, "#include <winuser.h>    // WinApi"
      END IF

      FPRINT FP_WRITE, "#include <stdbool.h>    // ISO StdLib"
      FPRINT FP_WRITE, "#include <ctype.h>      // ISO StdLib"
      FPRINT FP_WRITE, "#include <math.h>       // ISO StdLib"
      FPRINT FP_WRITE, "#include <setjmp.h>     // ISO StdLib"
      FPRINT FP_WRITE, "#include <stdarg.h>     // ISO StdLib"
      FPRINT FP_WRITE, "#include <stddef.h>     // ISO StdLib"
      FPRINT FP_WRITE, "#include <stdio.h>      // ISO StdLib"
      FPRINT FP_WRITE, "#include <stdlib.h>     // ISO StdLib"
      FPRINT FP_WRITE, "#include <string.h>     // ISO StdLib"
      FPRINT FP_WRITE, "#include <time.h>       // ISO StdLib"
      FPRINT FP_WRITE, "#include <process.h>    // ISO StdLib"
      FPRINT FP_WRITE, "#include <inttypes.h>   // ISO StdLib"
      FPRINT FP_WRITE, "#include <fcntl.h>      // POSIX"
      FPRINT FP_WRITE, "#include <io.h>         // WinNT POSIX subset"
      FPRINT FP_WRITE, "#include <conio.h>      // Primitive i/o"
   END IF

   FPRINT FP_WRITE, ""
END SUB ' EmitProlog



SUB Commandline_Defines(FP_WRITE AS FILE)
   IF CmdLineConst$ <> "" THEN
      DIM RAW Ftmp AS FILE
      DIM RAW LTmp1$

      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// ***************************************************"
      FPRINT FP_WRITE, "//                 Command line Defines"
      FPRINT FP_WRITE, "// ***************************************************"
      FPRINT FP_WRITE, ""

      Ftmp   = FP_CST     ' Save FILE Ptr to SourceFile
      FP_CST = FP_WRITE   ' Direct output to HeaderFile

      FOR INT i = 1 TO TALLY(CmdLineConst$, CHR$(1))
         LTmp1$ = STRTOKEN$(CmdLineConst$, CHR$(1), i)
         IF ISNULL(LTmp1$) THEN EXIT FOR
         LTmp1$ = "MACRO " + LTmp1$ ' CmdLineConst$
         INJECT(LTmp1$)
      NEXT

      FP_CST = Ftmp    ' Restore Ptr to SourceFile

      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// ***************************************************"
      FPRINT FP_WRITE, "//              End of Command Line Defines"
      FPRINT FP_WRITE, "// ***************************************************"
      FPRINT FP_WRITE, ""
   END IF
END SUB ' Commandline_Defines



SUB EmitUserDirectives(FP_WRITE AS FILE)
   IF EXIST(hdrFile$) THEN
      DIM RAW LTmp1$
      DIM RAW LFP1 AS FILE
      OPEN hdrFile$ FOR INPUT AS LFP1     ' user specified .h directives
      DO WHILE NOT EOF(LFP1)
         LINE INPUT LFP1, LTmp1$
         FPRINT FP_WRITE, LTmp1$
      LOOP
      CLOSE LFP1
   END IF
END SUB ' EmitUserDirectives



SUB User_GLOBAL_ENUM_Blocks(FP_WRITE AS FILE)
   DIM RAW LTmp1$
   DIM RAW LFP1 AS FILE

   IF EXIST(enuFile$) AND LOF(enuFile$) > 2 THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//           User's GLOBAL Enumerations"
      FPRINT FP_WRITE, "// *************************************************"
      OPEN enuFile$ FOR INPUT AS LFP1      ' user's GLOBAL enum blocks
      DO WHILE NOT EOF(LFP1)
         LINE INPUT LFP1, LTmp1$
         FPRINT FP_WRITE, LTmp1$
      LOOP
      CLOSE LFP1
   END IF
END SUB ' User_GLOBAL_ENUM_Blocks



SUB System_Defined_Constants(FP_WRITE AS FILE)
   DIM RAW LTmp1$
   DIM RAW LFP1 AS FILE

   IF EXIST(SysFile$) AND LOF(SysFile$) > 2 THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//            System Defined Constants"
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, ""
      OPEN SysFile$ FOR INPUT AS LFP1     'SysFile$    ' System translated CONSTants
      DO WHILE NOT EOF(LFP1)
         LINE INPUT LFP1, LTmp1$
         LTmp1$ = TRIM$(LTmp1$)
         IF LTmp1$ > "" THEN FPRINT FP_WRITE, LTmp1$
      LOOP
      CLOSE LFP1
   END IF
END SUB ' System_Defined_Constants



SUB User_Defined_Constants(FP_WRITE AS FILE)
   DIM RAW LTmp1$
   DIM RAW LFP1 AS FILE

   IF EXIST(UsrFile$) AND LOF(UsrFile$)>2 THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//             User Defined Constants"
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, ""
      OPEN UsrFile$ FOR INPUT AS LFP1     'UsrConstFile$      ' user translated CONSTants
      DO WHILE NOT EOF(LFP1)
         LINE INPUT LFP1, LTmp1$
         FPRINT FP_WRITE, LTRIM$(LTmp1$)
      LOOP
      CLOSE LFP1
   END IF
END SUB ' User_Defined_Constants



SUB User_Defined_Types_And_Unions(FP_WRITE AS FILE)
   DIM RAW LTmp1$
   DIM RAW LFP1 AS FILE

   IF EXIST(udtFile$) AND LOF(udtFile$) > 2 THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//          User Defined Types And Unions"
      FPRINT FP_WRITE, "// *************************************************"

      OPEN udtFile$ FOR INPUT AS LFP1       '  translated User Defined Types
      DO WHILE NOT EOF(LFP1)
         LINE INPUT LFP1, LTmp1$
         FPRINT FP_WRITE, LTmp1$
      LOOP
      CLOSE LFP1
   END IF
END SUB ' User_Defined_Types_And_Unions



SUB BeginMain
   FPRINT Outfile, "int main(int argc, char *argv[])"
   '*****************************************************************************
   '         int main is conditionally removed later IN SUB AssembleParts
   '*****************************************************************************
   FLUSH (Outfile)
END SUB ' BeginMain



SUB User_Data_Statements(FP_WRITE AS FILE)
   DIM RAW LTmp1$
   DIM RAW LFP1 AS FILE
   '********************************
   ' Read In The Data Statement File
   '********************************
   IF LOF(datFile$) > 0 THEN
      OPEN datFile$ FOR INPUT AS LFP1
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//              User's Data Statements"
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "char * DATA[] ="
      FPRINT FP_WRITE, "{"
      DO WHILE NOT EOF(LFP1)
         LINE INPUT LFP1, LTmp1$
         FPRINT FP_WRITE, LTmp1$ ;
         IF NOT EOF(LFP1) THEN FPRINT FP_WRITE, ","
      LOOP
      CLOSE LFP1
      FPRINT FP_WRITE, "\n};"
   END IF
END SUB ' User_Data_Statements



SUB User_Global_Variables(FP_WRITE AS FILE)
   DIM RAW i, VarName$,  Storage$, VarDim$, A, P$

   IF GlobalVarCnt OR DllCnt THEN
      FPRINT FP_W, ""
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, "//            ",BCX_STR_USR_VARS$
      FPRINT FP_W, "// *************************************************"
      FPRINT FP_W, ""
   END IF

   '*************************************
   ' Declare the DLL Variables
   '*************************************

   IF DllCnt THEN
      FOR INT iii = 1 TO DllCnt
         FPRINT FP_W, "static BCXFPROT", LTRIM$(STR$(iii)), SPC$, EXTRACT$(DllDecl$[iii],"="), ";"
      NEXT
   END IF

   '*************************************
   ' Declare the simple Variables
   '*************************************

   FOR i = 1 TO GlobalVarCnt
      IF GlobalVars[i].VarEmitFlag THEN ITERATE
      IF "" = GlobalVars[i].VarDim$ AND GlobalVars[i].VarCondLevel = 0 THEN
         P$ = ""
         IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr,42)
         A = GlobalVars[i].VarType
         IF GlobalVars[i].VarSF THEN
            VarName$ = "(*" + GlobalVars[i].VarName$ + ")"
         ELSE
            VarName$ = GlobalVars[i].VarName$
         END IF
         Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]
         VarDim$ = GlobalVars[i].VarDim$
         CALL PrintGlobal(FP_WRITE, A, i, Storage$, P$, VarName$, VarDim$)
      END IF
   NEXT

   '   Next, we declare the Arrays

   FOR i = 1 TO GlobalVarCnt
      IF GlobalVars[i].VarEmitFlag THEN ITERATE
      IF "" <> GlobalVars[i].VarDim$ AND GlobalVars[i].VarCondLevel = 0 THEN
         IF INCHR(GlobalVars[i].VarDim,"{") = 0 THEN     ' do uninitialized global arrays
            P$ = ""
            IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr, 42)
            A = GlobalVars[i].VarType
            IF GlobalVars[i].VarSF THEN
               VarName$ = "(*" + GlobalVars[i].VarName$ + EXTRACT$(GlobalVars[i].VarDim,"(") + ")"
               VarDim$ = MID$(GlobalVars[i].VarDim, INCHR(GlobalVars[i].VarDim,"("))
            ELSE
               VarName$ = GlobalVars[i].VarName$
               VarDim$ = GlobalVars[i].VarDim$
            END IF
            Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]
            CALL PrintGlobal(FP_WRITE, A, i, Storage$, P$, VarName$, VarDim$)
         END IF
      END IF
   NEXT

   DIM RAW LastDef$ = ""
   DIM RAW LastLevel = 1

   FOR i = 1 TO GlobalVarCnt
      IF GlobalVars[i].VarEmitFlag THEN ITERATE
      IF GlobalVars[i].VarCondLevel THEN
         IF ISNULL(LastDef$) THEN
            LastDef$ = GlobalVars[i].VarCondDef$
            LastLevel = GlobalVars[i].VarCondLevel
            FPRINT Outfile, LastDef$
         END IF
         IF LastDef$ <> GlobalVars[i].VarCondDef$ THEN
            IF GlobalVars[i].VarCondDef$ = "#else" THEN
               DO WHILE LastLevel > GlobalVars[i].VarCondLevel
                  FPRINT Outfile, "#endif"
                  DECR LastLevel
               LOOP
               FPRINT Outfile, "#else"
               LastDef$ = GlobalVars[i].VarCondDef$
            ELSE
               DO WHILE LastLevel => GlobalVars[i].VarCondLevel
                  FPRINT Outfile, "#endif"
                  DECR LastLevel
               LOOP
               LastDef$ = GlobalVars[i].VarCondDef$
               LastLevel = GlobalVars[i].VarCondLevel
               FPRINT Outfile, LastDef$
            END IF
         END IF
         P$ = ""
         IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr, 42)
         A = GlobalVars[i].VarType
         IF GlobalVars[i].VarSF THEN
            VarName$ = "(*" + GlobalVars[i].VarName$ + ")"
         ELSE
            VarName$ = GlobalVars[i].VarName$
         END IF
         VarDim$ = GlobalVars[i].VarDim
         Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]
         CALL PrintGlobal(FP_WRITE,A, i, Storage$, P$, VarName$, VarDim$)

      END IF
   NEXT

   IF *LastDef$ THEN
      DO WHILE LastLevel
         FPRINT FP_WRITE, "#endif"
         DECR LastLevel
      LOOP
   END IF
END SUB ' User_Global_Variables



SUB SYSTEM_VARIABLES(FP_WRITE AS FILE)
   IF Use_Console      OR _
      Use_Findfirst    OR _
      Use_Findnext     OR _
      Use_GoSub        OR _
      Use_BcxTmpStr    OR _
      Use_Crlf         OR _
      Use_Inputbox     OR _
      Use_Infobox      OR _
      Use_Inputbuffer  OR _
      Use_BCX_Splitter OR _
      Use_Dynacall     OR _
      Use_DynacallA    OR _
      Use_LCaseTbl     OR _
      Use_UCaseTbl     THEN

      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//                " + BCX_STR_SYS_VARS$
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, ""
   END IF


   IF Use_BCX_Splitter THEN
      FPRINT FP_WRITE, "static COLORREF SplitBarFG=RGB(0,0,255);"
      FPRINT FP_WRITE, "static COLORREF SplitBarBG=RGB(212,212,212);"
      FPRINT FP_WRITE, "#define SPLITBAR_SIZE 2"
      FPRINT FP_WRITE, "#define MIN_PANESIZE 4"
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "typedef struct _SPLITTERINFO{"
      FPRINT FP_WRITE, "  int   swsStyle;"
      FPRINT FP_WRITE, "  int   splittype;"
      FPRINT FP_WRITE, "  HCURSOR  hCursor;"
      FPRINT FP_WRITE, "  HWND  hwPane1;"
      FPRINT FP_WRITE, "  HWND  hwPane2;"
      FPRINT FP_WRITE, "  BOOL  fMovingBar;"
      FPRINT FP_WRITE, "  int   percent;"
      FPRINT FP_WRITE, "}SPLITTERINFO, *LPSPLITTERINFO;"
      FPRINT FP_WRITE, ""
   END IF

   IF Use_Ldouble THEN
      FPRINT FP_WRITE, "#define LDOUBLE long double"
   END IF

   IF Use_Idxqsort THEN
      FPRINT FP_WRITE, "char*** pppStr;"
   END IF

   IF Use_Idxqsort OR Use_IdxqsortSt OR Use_PtrqsortSt THEN
      FPRINT FP_WRITE, "int     Key;"
   END IF

   IF Use_IdxqsortSt THEN
      FPRINT FP_WRITE, "char*   cmp1;"
      FPRINT FP_WRITE, "int     StructSize;"
   END IF

   IF Use_PtrqsortSt THEN
      FPRINT FP_WRITE, "int     OffSet;"
   END IF

   IF Use_Sound THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "#define SNDQUE 10000"
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "typedef struct _soundtype {"
      FPRINT FP_WRITE, "  FLOAT  Freq;"
      FPRINT FP_WRITE, "  INT    Dura;"
      FPRINT FP_WRITE, "  INT    Vol;"
      FPRINT FP_WRITE, "  INT    Voice;"
      FPRINT FP_WRITE, "  FLOAT  Tempo;"
      FPRINT FP_WRITE, "  INT    sndTid;"
      FPRINT FP_WRITE, "} soundtype, *LPSOUNDTYPE;"
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "static soundtype  SndPmtr[SNDQUE+1];"
      FPRINT FP_WRITE, "static UINT       gTenter;"
      FPRINT FP_WRITE, "static UINT       gTwait;"
      FPRINT FP_WRITE, "static UINT       gTexit;"
      FPRINT FP_WRITE, "static UINT       gTarray;"
      FPRINT FP_WRITE, "static BOOL       gTsig;"
      FPRINT FP_WRITE, "static HANDLE     gSThread=NULL;"
      FPRINT FP_WRITE, ""
   END IF

   IF Use_BCX_Fontdlg THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "typedef struct _BCX_FONT_TYPE {"
      FPRINT FP_WRITE, "  LOGFONT lf;"
      FPRINT FP_WRITE, "  int  SIZE;"
      FPRINT FP_WRITE, "  int  RGB;"
      FPRINT FP_WRITE, "} BCX_FONT_TYPE;"
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "BCX_FONT_TYPE BCX_FONT;"
      FPRINT FP_WRITE, ""
   END IF

   '************************************************************************

   IF Use_NUL THEN
      FPRINT FP_WRITE, "static char    NUL [1]= {0};       // Null"
   END IF

   IF Use_BEL THEN
      FPRINT FP_WRITE, "static char    BEL [2]= {7,0};     // Bell"
   END IF

   IF Use_BS THEN
      FPRINT FP_WRITE, "static char    BS  [2]= {8,0};     // Back Space"
   END IF

   IF Use_TAB THEN
      FPRINT FP_WRITE, "static char    TAB [2]= {9,0};     // Horz Tab"
   END IF

   IF Use_LF THEN
      FPRINT FP_WRITE, "static char    LF  [2]= {10,0};    // Line Feed"
   END IF

   IF Use_VT THEN
      FPRINT FP_WRITE, "static char    VT  [2]= {11,0};    // Vert Tab"
   END IF

   IF Use_FF THEN
      FPRINT FP_WRITE, "static char    FF  [2]= {12,0};    // Form Feed"
   END IF

   IF Use_CR THEN
      FPRINT FP_WRITE, "static char    CR  [2]= {13,0};    // Carr Rtn"
   END IF

   IF Use_EF THEN
      FPRINT FP_WRITE, "static char    EF  [2]= {26,0};    // End-of-File"
   END IF

   IF Use_ESC THEN
      FPRINT FP_WRITE, "static char    ESC [2]= {27,0};    // Escape"
   END IF

   IF Use_SPC THEN
      FPRINT FP_WRITE, "static char    SPC [2]= {32,0};    // Space"
   END IF

   IF Use_DQ THEN
      FPRINT FP_WRITE, "static char    DQ  [2]= {34,0};    // Double-Quote"
   END IF

   IF Use_DDQ THEN
      FPRINT FP_WRITE, "static char    DDQ [3]= {34,34,0}; // Double-Double-Quote"
   END IF

   IF Use_Crlf THEN
      FPRINT FP_WRITE, "static char    CRLF[3]= {13,10,0}; // Carr Rtn & Line Feed"
   END IF

   '****************************************************************************

   IF Use_Inputbox THEN
      FPRINT FP_WRITE, "char   BCX_INPUTBOX_VAL[BCXSTRSIZE];"
   END IF

   IF Use_Cursor THEN
      FPRINT FP_WRITE, "static COORD   cursor;            // holds coordinates of cursor"
   END IF

   IF Use_Console THEN
      FPRINT FP_WRITE, "static HANDLE  hConsole;          // handle of console window"
      FPRINT FP_WRITE, "static int     color_fg = 7;      // forground color set to default"
      FPRINT FP_WRITE, "static int     color_bg = 0;      // background color set to default"
   END IF

   IF Use_Consolesize THEN
      FPRINT FP_WRITE, "static int     BcxSaveConX;"
      FPRINT FP_WRITE, "static int     BcxSaveConY;"
   END IF

   IF Use_PushPopColors THEN
      FPRINT FP_WRITE, "static int     color_pshpop;      // Push / Pop Color storage"
   END IF


   IF Use_Scan THEN
      FPRINT FP_WRITE, "static int     ScanError;         // holds last error from scan function"
   END IF


   IF Use_Inputbuffer THEN
      FPRINT FP_WRITE, "static char    InputBuffer[1048577];"   ' 1MB + 1 byte
   END IF


   IF Use_Hook THEN
      FPRINT FP_WRITE, "static HHOOK   CmDlgHook;"
   END IF


   IF Use_GoSub THEN
      FPRINT FP_WRITE, "static jmp_buf GosubStack[32];"
      FPRINT FP_WRITE, "static int     GosubNdx;"
   END IF


   IF Use_LCaseTbl THEN
      FPRINT FP_WRITE, "static unsigned char*  LowCase;"
   END IF

   IF Use_UCaseTbl THEN
      FPRINT FP_WRITE, "static unsigned char*  UprCase;"
   END IF

   IF Use_Findfirst OR Use_Findnext THEN
      FPRINT FP_WRITE, "static HANDLE  fffn_FileHandle;"
      FPRINT FP_WRITE, "static WIN32_FIND_DATA fffn_FindData;"
   END IF

   IF Use_DynacallCommon THEN
      FPRINT FP_WRITE, "static  HINSTANCE BCX_DllStore[256];"
   END IF

   FPRINT FP_WRITE, ""
END SUB ' SYSTEM_VARIABLES



SUB PreParse(Arg$)
   '********************************************
   ' Stk$[) AND Ndx must be declared GLOBAL
   ' and are re-initialized WITH each invocation
   '*********************************************
   DIM RAW Anyword$ = ""
   DIM RAW szChar$  = ""
   DIM RAW Strlit$  = ""
   DIM RAW Arglen AS INT
   DIM RAW Counter AS INT
   DIM RAW TT AS INT
   DIM RAW Tmp AS INT
   DIM RAW A AS INT
   DIM RAW j AS INT

   Ndx = 0
   Arg$ = LTRIM$(Arg$)
   IF ISNULL(Arg$) THEN
      Ndx = 0
      EXIT SUB
   END IF
   '********************
   FOR Tmp = 0 TO 31
      Stk$[Tmp] = ""
   NEXT
   '********************
   Arglen = LEN(Arg$)
   Counter = 0


   DO WHILE Counter <= Arglen

      IF Ndx => cMaxStk THEN
         CALL Abort("Overflowed Parse Stack")
      END IF

      INCR Counter
      szChar[0] = Arg[Counter-1]              'This eliminates using MID$
      szChar[1] = 0                           'Remember to null terminate

      TT = ASC(szChar$)
      '***************************************
      SELECT CASE TT
         '***************************************
         CASE c_DblQt   'Identify string literals
         '***************************************
         Strlit$ = szChar$
         szChar$ = ""
         DO
            IF szChar$ = DQ$ THEN EXIT DO
            INCR Counter
            IF Counter = Arglen THEN
               szChar[0] = Arg[Counter-1]        'This eliminates using MID$
               szChar[1] = 0                     'Remember to null terminate
               CONCAT (Strlit$,szChar$)
               EXIT DO
            END IF
            szChar[0] = Arg[Counter-1]           'This eliminates using MID$
            szChar[1] = 0                        'Remember to null terminate
            CONCAT (Strlit$,szChar$)
         LOOP
         INCR Ndx
         Stk$[Ndx] = Strlit$
         '***************
         CASE 32 ' SPACE
         '***************
         IF *Anyword$ THEN
            INCR Ndx
            Stk$[Ndx] = Anyword$
            Anyword$ = ""
         END IF
         ' *****************************************************************
         '    =   &  (  )  [  ]  '  ,  +  -  *  /  ?  <  >  ;   |  :  ^
         CASE 61,38,40,41,91,93,39,44,43,45,42,47,63,60,62,59,124,58,94
         '******************************************************************
         IF *Anyword$ THEN
            INCR Ndx
            Stk$[Ndx] = Anyword$
            Anyword$  = ""
         END IF
         INCR Ndx
         Stk$[Ndx]= szChar$
         '*****************
         CASE ELSE
         '*****************
         A = LEN(Anyword$)
         Anyword[A]   = Arg[Counter-1]
         Anyword[A+1] = 0
         '*****************
      END SELECT
      '*****************
   LOOP
   IF *Anyword$ THEN
      INCR Ndx
      Stk$[Ndx]= Anyword$
   END IF
   FOR j = 1 TO Ndx
      Anyword$ = LCASE$(Stk$[j])
      SELECT CASE Anyword$
         CASE "bor"
         Stk$[j] = "|"
         CASE "band"
         Stk$[j] = "&"
      END SELECT
   NEXT
END SUB ' PreParse



FUNCTION GetNumArgs (Strt, NdxPos AS INT PTR=NULL)
   DIM RAW CountR = 0  '() counter
   DIM RAW CountS = 0  '[] counter
   DIM RAW i           'loop counter
   DIM RAW j = 0       'comma counter
   DIM RAW k = 1       'function end flag

   FOR i = Strt TO Ndx
      SELECT CASE *Stk$[i]

         CASE ASC("(")
         INCR CountR
         INCR k

         CASE ASC(")")
         DECR CountR
         DECR k
         IF k = 0 THEN EXIT SELECT, FOR

         CASE ASC("[")
         INCR CountS

         CASE ASC("]")
         DECR CountS

         CASE ASC(",")
         IF CountR = 0 AND CountS = 0 THEN
            INCR j
            IF NdxPos THEN *NdxPos = i
         END IF

      END SELECT
   NEXT
   FUNCTION = j   'No. of commas = No. of args
END FUNCTION ' GetNumArgs



SUB GetVarCode(varcode AS VARCODE PTR, szWhere AS PCHAR)
   UNREFERENCED_PARAMETER(szWhere)
   DIM RAW CB$, PT$, PTH$, VAR$, vn, RF$, bRemoveSplat AS BOOL

   IF varcode->Methd% = mt_ConsDesNoParam OR varcode->Methd% = mt_FuncSubDecC_DecNoParam OR varcode->Methd% = mt_OverLoadNoParam THEN
      CONCAT(varcode->Proto$, varcode->Token$)
      CONCAT(varcode->Header$, varcode->Token$)
      EXIT SUB
   END IF

   IF varcode->Methd% = mt_OptsNoParam THEN
      CONCAT(varcode->Proto$, varcode->Token$)
      IF varcode->Token$ = "," OR InClass OR varcode->Token$ = "..." THEN
         CONCAT(varcode->Header$, varcode->Token$)
      END IF
      EXIT SUB
   END IF

   IF IsCallBack THEN
      CB$ = "CALLBACK "
   ELSE
      CB$ = ""
   END IF

   IF varcode->Methd = mt_ConsDesAParam THEN
      DIM RAW iSplat = INCHR(varcode->AsToken$, "*")
      DIM RAW iLT = INCHR(varcode->AsToken$, "<")
      DIM RAW iGT = INCHR(varcode->AsToken$, ">")
      IF iSplat > iLT AND iSplat < iGT THEN
         bRemoveSplat = FALSE
      ELSE
         bRemoveSplat =TRUE
      END IF
   ELSE
      bRemoveSplat = TRUE
   END IF

   IF ((INCHR(varcode->Token$,"*") OR INCHR(varcode->AsToken$,"*")) AND bRemoveSplat) OR varcode->IsPtrFlag THEN
      RemoveAll(varcode->Token$, "*")
      RemoveAll(varcode->AsToken$, "*")
      PT$  = STRING$(varcode->IsPtrFlag, ASC("*")) + SPC$
      PTH$ = PT$
   ELSE
      PTH$ = SPC$
      PT$ = ""
   END IF

   IF INCHR(varcode->Token$,"&") THEN
      RF$ = " &"
   ELSE
      RF$ = ""
   END IF

   vn = varcode->VarNo%
   VAR$ = GetVarTypeName$(vn)

   DIM RAW pszHead$
   DIM RAW pszProto$

   pszHead$ = Clean$(varcode->Token$)
   pszProto$ = pszHead$

   IF INCHR(pszProto$,"[") THEN
      pszProto$ = MID$(pszProto$,INCHR(pszProto$, "["))
   ELSE
      pszProto$ = ""
   END IF

   SELECT CASE vn
      '************************************************************************
      CASE vt_STRVAR
      '************************************************************************

      SELECT CASE varcode->Methd%

         CASE mt_ProcessSetCommand
         varcode->StaticOut$ = "static char   " + pszHead$

         CASE mt_FuncSubDecC_Dec
         varcode->Functype$ = "char * " + CB$

         CASE mt_FuncSubDecC_DecAParam
         IF NOT INCHR(varcode->Token$, "[") THEN
            varcode->Header$ = varcode->Header$  +  "char *" + pszHead$
            varcode->Proto$  = varcode->Proto$   +  "char *"
         ELSE
            varcode->Header$ = varcode->Header$  +  "char " + REMOVE$(pszHead$, "*")
            varcode->Proto$  = varcode->Proto$   +  "char[][BCXSTRSIZE]"
         END IF

         CASE mt_Opts
         varcode->Functype$ = "char *"

         CASE mt_ConsDesAParam
         varcode->Header$ = varcode->Header$  + "char * "  +  pszHead$
         varcode->Proto$  = varcode->Proto$   + "char * "  +  pszHead$

         CASE mt_OptsAParam
         varcode->Header$ = varcode->Header$  + "char * "  +  pszHead$
         varcode->Proto$  = varcode->Proto$   + "char * "

         CASE mt_OverLoad
         varcode->Functype$ = "char *"

         CASE mt_OverLoadAParam
         varcode->Header$ = varcode->Header$ + "char *" + pszHead$

      END SELECT

      '************************************************************************
      CASE vt_BOOL, vt_BYTE, vt_COLORREF, vt_DOUBLE, vt_DWORD, vt_FARPROC, vt_HDC, _
      vt_HANDLE, vt_HINSTANCE, vt_HWND, vt_INTEGER, vt_PCHAR, vt_LONG, vt_LPBYTE, vt_LRESULT, _
      vt_SHORT, vt_SINGLE, vt_UINT, vt_ULONG, vt_USHORT, vt_SAFEARRAY, vt_VARIANT, vt_VOID, vt_LDOUBLE, _
      vt_DWORD, vt_WORD, vt_WINBOOL, vt_BSTR
      '************************************************************************

      SELECT CASE varcode->Methd%

         CASE mt_ProcessSetCommand
         varcode->StaticOut$ = "static " + VAR$ + SPC$ + pszHead$

         CASE mt_FuncSubDecC_Dec
         varcode->Functype$ = VAR$ + PTH$ + CB$

         CASE mt_FuncSubDecC_DecAParam
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + RF$ + PT$

         CASE mt_Opts
         varcode->Functype$ = VAR$ + PTH$

         CASE mt_OptsAParam
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + RF$ + PT$

         CASE mt_ConsDesAParam
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + PTH$ + pszHead$

         CASE mt_OverLoad
         varcode->Functype$ = VAR$ + SPC$

         CASE mt_OverLoadAParam
         varcode->Header$ = varcode->Header$ + VAR$ + PTH$ + pszHead$

      END SELECT

      '************************************************************************
      CASE vt_FILEPTR
      '************************************************************************

      SELECT CASE varcode->Methd%

         CASE mt_FuncSubDecC_Dec
         varcode->Functype$ = VAR$ + PTH$ + CB$

         CASE mt_FuncSubDecC_DecAParam
         varcode->Header$ = varcode->Header$   +  VAR$ + PTH$ + pszHead$
         IF INCHR(varcode->Token$,"[") THEN
            varcode->Proto$  = varcode->Proto$ +  VAR$ + PT$ + SPC$ + pszHead$
         ELSE
            varcode->Proto$  = varcode->Proto$ +  VAR$ + PT$
         END IF

         CASE mt_Opts
         varcode->Functype$ = VAR$ + PTH$

         CASE mt_OptsAParam                     ' y
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + PT$

         CASE mt_ConsDesAParam
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + PTH$  +  pszHead$

         CASE mt_OverLoad
         varcode->Functype$ = VAR$ + SPC$

         CASE mt_OverLoadAParam
         varcode->Header$ = varcode->Header$ + VAR$ + PTH$ + pszHead$

      END SELECT

      '************************************************************************
      CASE vt_CHAR
      '************************************************************************

      SELECT CASE varcode->Methd%

         CASE mt_FuncSubDecC_Dec
         varcode->Functype$ = VAR$ + PTH$ + CB$

         CASE mt_FuncSubDecC_DecAParam
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + PT$ + SPC$ + pszProto$

         CASE mt_Opts
         varcode->Functype$ = VAR$ + PTH$

         CASE mt_OptsAParam
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + PT$ + SPC$ + pszProto$

         CASE mt_ConsDesAParam
         varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
         varcode->Proto$  = varcode->Proto$   +  VAR$ + PTH$  + SPC$ + pszProto$

         CASE mt_OverLoad
         varcode->Functype$ = VAR$ + SPC$

         CASE mt_OverLoadAParam
         varcode->Header$ = varcode->Header$ + VAR$ + PTH$ + pszHead$

      END SELECT

      '************************************************************************
      CASE vt_UDT, vt_STRUCT, vt_UNION
      '************************************************************************

      SELECT CASE varcode->Methd%

         CASE mt_ProcessSetCommand
         IF vn = vt_UNION THEN
            varcode->StaticOut$ = "static union  " + pszHead$
         ELSE
            varcode->StaticOut$ = "static struct _" + pszHead$ + SPC$
         END IF

         CASE mt_FuncSubDecC_Dec
         varcode->Functype$ = varcode->AsToken$ + PTH$ + CB$

         CASE mt_FuncSubDecC_DecAParam
         varcode->Header$ = varcode->Header$  +  varcode->AsToken$ + PTH$ +  pszHead$
         varcode->Proto$  = varcode->Proto$   +  varcode->AsToken$ + RF$ + PT$

         CASE mt_Opts
         varcode->Functype$ = varcode->AsToken$ + PTH$

         CASE mt_OptsAParam
         varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$
         varcode->Proto$ = varcode->Proto$   + Clean$(varcode->AsToken$) + RF$ + PT$

         CASE mt_ConsDesAParam
         varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$
         varcode->Proto$ = varcode->Proto$   + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$

         CASE mt_OverLoad
         varcode->Functype$ = VAR$ + SPC$

         CASE mt_OverLoadAParam
         varcode->Header$ = varcode->Header$ + varcode->AsToken$ + PTH$ + pszHead$

      END SELECT

      CASE vt_CONSTRDESTR
      SELECT CASE varcode->Methd%
         CASE mt_ConsDes
         varcode->Functype$ = VAR$ + PTH$ + CB$
      END SELECT

      '************************************************************************
      CASE ELSE
      '************************************************************************

      SELECT CASE varcode->Methd%

         CASE mt_FuncSubDecC_Dec
         varcode->Functype$ = varcode->AsToken$ + PTH$ + CB$

         CASE mt_FuncSubDecC_DecAParam
         varcode->Header$ = varcode->Header$  +  varcode->AsToken$ + PTH$ +  pszHead$
         varcode->Proto$ = varcode->Proto$    +  varcode->AsToken$ + RF$ + PT$

         CASE mt_Opts
         varcode->Functype$ = varcode->AsToken$ + PTH$

         CASE mt_OptsAParam
         varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$
         varcode->Proto$  = varcode->Proto$  + Clean$(varcode->AsToken$) + RF$ + PT$

         CASE mt_ConsDesAParam
         varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + SPC$ + pszHead$
         varcode->Proto$  = varcode->Proto$  + Clean$(varcode->AsToken$) + SPC$ + pszHead$

      END SELECT
   END SELECT
END SUB ' GetVarCode




SUB User_Global_Initialized_Arrays(FP_WRITE AS FILE)
   DIM STATIC Banner_Printed    ' Must remain static
   DIM RAW Banner$
   DIM RAW P$, i, A
   DIM RAW VarName$
   DIM RAW VarDim$
   DIM RAW Storage$
   DIM RAW VAR$

   IF Banner_Printed = FALSE THEN
      $FILL Banner$
      ""                                                     & LF$
      "// *************************************************" & LF$
      "//            User's Global Initialized Arrays"       & LF$
      "// *************************************************" & LF$
      $FILL
      Banner_Printed = TRUE
      FPRINT FP_WRITE, Banner$
   END IF


   FOR i = 1 TO GlobalVarCnt
      IF GlobalVars[i].VarEmitFlag THEN ITERATE
      IF "" <> GlobalVars[i].VarDim$ AND GlobalVars[i].VarCondLevel = 0 THEN
         IF INCHR(GlobalVars[i].VarDim,"{") THEN

            P$ = ""
            IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr, 42)

            A = GlobalVars[i].VarType

            IF GlobalVars[i].VarSF THEN
               VarName$ = "(*" + GlobalVars[i].VarName$ + EXTRACT$(GlobalVars[i].VarDim,"(") + ")"
               VarDim$ = MID$(GlobalVars[i].VarDim, INCHR(GlobalVars[i].VarDim,"("))
            ELSE
               VarName$ = GlobalVars[i].VarName$
               VarDim$ = GlobalVars[i].VarDim
            END IF

            Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]

            SELECT CASE A
               ' handle exceptions

               CASE vt_STRVAR
               FPRINT FP_WRITE, Storage$, "char    ", VarName$, VarDim$, ";"

               CASE vt_FILEPTR
               REMOVE "@" FROM GlobalVars[i].VarName$
               FPRINT FP_WRITE, Storage$, "FILE    *", VarName$, VarDim$, ";"

               CASE vt_LPSTR
               FPRINT FP_WRITE, Storage$, "LPSTR   ", P$, VarName$, VarDim$, ";"

               CASE vt_UDT, vt_STRUCT, vt_UNION
               VAR$ = TypeDefs[GlobalVars[i].VarDef].VarName$
               VAR$ = RPAD$(VAR$, 7)
               FPRINT FP_WRITE, Storage$, VAR$, SPC$, P$, VarName$, VarDim$, ";"

               ' handle normal

               CASE vt_VarMin TO vt_VarMax
               VAR$ = GetVarTypeName$(GlobalVars[i].VarType)
               VAR$ = RPAD$(VAR$, 7)
               FPRINT FP_WRITE, Storage$, VAR$, SPC$, P$, VarName$, VarDim$, ";"
            END SELECT
         END IF
      END IF
   NEXT
END SUB ' User_Global_Initialized_Arrays



SUB User_Overloaded_SubsFunctions(FP_WRITE AS FILE)
   DIM RAW LZZ$
   DIM RAW FP_OVR_IN AS FILE

   IF Use_Overloaded THEN
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//        User's Overloaded Subs/Functions          "
      FPRINT FP_WRITE, "// *************************************************"

      OPEN ovrFile$ FOR INPUT AS FP_OVR_IN

      DO WHILE NOT EOF(FP_OVR_IN)
         LINE INPUT FP_OVR_IN,LZZ$
         IF iMatchNQ (LZZ$, "overloaded") THEN
            FPRINT FP_WRITE, "\n"
         END IF
         FPRINT FP_WRITE,LZZ$
      LOOP

      CLOSE FP_OVR_IN
      FPRINT FP_WRITE, "\n\n"
   END IF
END SUB ' User_Overloaded_SubsFunctions



SUB User_GLOBAL_SET_Statements(FP_WRITE AS FILE)
   DIM RAW LTmp1$
   DIM RAW LFP1 AS FILE

   IF LOF(setFile$) > 0 THEN
      OPEN setFile$ FOR INPUT AS LFP1
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//              User's GLOBAL SET Statements"
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, ""
      DO WHILE NOT EOF(LFP1)
         LINE INPUT LFP1, LTmp1$
         FPRINT FP_WRITE, LTmp1$
      LOOP
      FPRINT FP_WRITE, ""
      CLOSE LFP1
   END IF
END SUB ' User_GLOBAL_SET_Statements



SUB User_Prototypes(FP_WRITE AS FILE)
   DIM RAW LastDef$
   DIM RAW LastLevel
   DIM RAW A

   IF ProtoCnt THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//               ",BCX_STR_USR_PROTOS$
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, ""

      LastDef$ = ""
      LastLevel = 1

      FOR A = 1 TO ProtoCnt
         IF ISNULL(LastDef$) THEN
            LastDef$ = ProtoType[A].Condition$
            LastLevel = ProtoType[A].CondLevel
            IF Use_SingleFile = FALSE THEN
               IF LastDef$ <> "" THEN FPRINT FP_HeaderFile, LastDef$
            END IF
            IF LastDef$ <> "" THEN FPRINT FP_WRITE, LastDef$
         END IF

         IF LastDef$ <> ProtoType[A].Condition$ THEN
            IF ProtoType[A].Condition$ = "#else" THEN
               DO WHILE LastLevel > ProtoType[A].CondLevel
                  IF Use_SingleFile = FALSE THEN
                     FPRINT FP_HeaderFile, "#endif"
                  END IF
                  FPRINT FP_WRITE, "#endif"
                  DECR LastLevel
               LOOP
               IF Use_SingleFile = FALSE THEN
                  FPRINT FP_HeaderFile, "#else"
               END IF
               FPRINT FP_WRITE, "#else"
               LastDef$ = ProtoType[A].Condition$
               LastLevel = ProtoType[A].CondLevel

            ELSE

               DO WHILE LastLevel > ProtoType[A].CondLevel
                  IF Use_SingleFile = FALSE THEN
                     FPRINT FP_HeaderFile, "#endif"
                  END IF
                  FPRINT FP_WRITE, "#endif"
                  DECR LastLevel
               LOOP
               LastDef$ = ProtoType[A].Condition$
               LastLevel = ProtoType[A].CondLevel
               IF Use_SingleFile = FALSE THEN
                  IF LastDef$ <> "" THEN FPRINT FP_HeaderFile, LastDef$
               END IF
               IF LastDef$ <> "" THEN FPRINT FP_WRITE, LastDef$
            END IF
         END IF

         IF UseStdCall AND UseCpp THEN
            IF LEFTSTR(ProtoType[A].Prototype$, "C_EXPORT ") THEN
               EmitExportDef(ProtoType[A].Prototype$)
            END IF
         END IF

         DIM RAW T$
         T$ = EXTRACT$(ProtoType[A].Prototype$, SPC$)
         T$ = RPAD$(T$, 7) + SPC$
         ProtoType[A].Prototype$ = T$ + REMAIN$(ProtoType[A].Prototype$, SPC$)

         REPLACE "char*  ,"   WITH "char*,"   IN ProtoType[A].Prototype$
         REPLACE "char    * " WITH "char*   " IN ProtoType[A].Prototype$

         IF Use_SingleFile = FALSE THEN
            FPRINT FP_HeaderFile, ProtoType[A].Prototype$
         END IF

         FPRINT FP_WRITE, ProtoType[A].Prototype$

      NEXT 'A 'ProtoCnt

      IF fpdef THEN CLOSE fpdef

      IF *LastDef$ THEN
         DO WHILE LastLevel > 0
            IF Use_SingleFile = FALSE THEN
               FPRINT FP_HeaderFile, "#endif"
            END IF
            FPRINT FP_WRITE, "#endif"
            DECR LastLevel
         LOOP
      END IF
   END IF
END SUB ' User_Prototypes




SUB EmitOSVersionEnum
   DIM STATIC BeenHereDoneThat
   IF BeenHereDoneThat = TRUE THEN EXIT SUB
   BeenHereDoneThat = TRUE
   FPRINT FP_ENU, ""
   FPRINT FP_ENU, "enum"
   FPRINT FP_ENU, "  {"
   FPRINT FP_ENU, "  OSUnknown = -2,"
   FPRINT FP_ENU, "  OSError = -1,"
   FPRINT FP_ENU, "  OS_3x,"
   FPRINT FP_ENU, "  OS_95,"
   FPRINT FP_ENU, "  OS_98,"
   FPRINT FP_ENU, "  OS_ME,"
   FPRINT FP_ENU, "  OS_NT3,"
   FPRINT FP_ENU, "  OS_2000,"
   FPRINT FP_ENU, "  OS_XP,"
   FPRINT FP_ENU, "  OS_XP_Pro_x64,"
   FPRINT FP_ENU, "  OS_Server_2003,"
   FPRINT FP_ENU, "  OS_Home_Server,"
   FPRINT FP_ENU, "  OS_Server_2003_R2,"
   FPRINT FP_ENU, "  OS_Vista,"
   FPRINT FP_ENU, "  OS_Server_2008,"
   FPRINT FP_ENU, "  OS_Server_2008_R2,"
   FPRINT FP_ENU, "  OS_Win_7,"
   FPRINT FP_ENU, "  OS_Server_2012,"
   FPRINT FP_ENU, "  OS_Win_8,"
   FPRINT FP_ENU, "  OS_Win_81,"
   FPRINT FP_ENU, "  OS_Server_2012_R2,"
   FPRINT FP_ENU, "  OS_Win_10,"
   FPRINT FP_ENU, "  OS_Server_2016,"
   FPRINT FP_ENU, "  OS_Win_11"
   FPRINT FP_ENU, "  };"
   FPRINT FP_ENU, ""
END SUB



SUB AddMacros(FP_WRITE AS FILE)

   IF Use_SysMacros OR Use_Wingui THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, "//               " + $BCX_STR_STD_MACROS
      FPRINT FP_WRITE, "// *************************************************"
      FPRINT FP_WRITE, ""
   END IF

   DIM  Accum= Use_Form
   INCR Accum, Use_Button
   INCR Accum, Use_BmpButton
   INCR Accum, Use_Edit
   INCR Accum, Use_BCX_Input
   INCR Accum, Use_Label
   INCR Accum, Use_Group
   INCR Accum, Use_Checkbox
   INCR Accum, Use_Radio
   INCR Accum, Use_Combobox
   INCR Accum, Use_Listbox
   INCR Accum, Use_Treeview
   INCR Accum, Use_Blackrect
   INCR Accum, Use_Whiterect
   INCR Accum, Use_Grayrect
   INCR Accum, Use_Datepick
   INCR Accum, Use_Listview
   INCR Accum, Use_BCX_Control
   INCR Accum, Use_BCX_Slider
   INCR Accum, Use_BCX_Tab
   INCR Accum, Use_BCX_Toolbar
   INCR Accum, Use_BCX_UpDown
   INCR Accum, Use_BCX_FrameWnd
   INCR Accum, Use_BCX_Wnd

   IF Accum THEN
      IF NOT Use_Project THEN
         FPRINT FP_WRITE, "#define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))"
         FPRINT FP_WRITE, "#define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)"
      ELSE
         FPRINT FP_WRITE, "#ifndef __BCXFONT_DEFINED__"
         FPRINT FP_WRITE, "  #define __BCXFONT_DEFINED__"
         FPRINT FP_WRITE, "  #define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))"
         FPRINT FP_WRITE, "  #define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)"
         FPRINT FP_WRITE, "#endif"
      END IF
   END IF


   IF Use_SysMacros THEN
      IF Use_Clip_Reset THEN
         FPRINT FP_WRITE, "#define Clipboard_Reset OpenClipboard(NULL),EmptyClipboard(),CloseClipboard();"
      END IF

      IF Use_Cast THEN
         FPRINT FP_WRITE, "#define CAST(to_type,old_obj) (*((to_type*)(&(old_obj))))"
      END IF

      IF Use_Read THEN
         FPRINT FP_WRITE, "#define READ(a) DATA[(a)-1]"
      END IF

      IF Use_Readnum THEN
         FPRINT FP_WRITE, "#define READNUM(a) (double)atof((DATA[(a)-1]))"
      END IF

      IF Use_EqualTo THEN
         FPRINT FP_WRITE, "#define EqualTo =="
      END IF

      IF Use_NotEqualTo THEN
         FPRINT FP_WRITE, "#define NotEqualTo !="
      END IF

      IF Use_BcxSplitPath THEN
         FPRINT FP_WRITE, "#define FDRV   2"
         FPRINT FP_WRITE, "#define FPATH  4"
         FPRINT FP_WRITE, "#define FNAME  8"
         FPRINT FP_WRITE, "#define FEXT  16"
      END IF

      IF Use_Cbool THEN
         FPRINT FP_WRITE, "#define CBOOL(A)((A)!=0)?1:0"
      END IF

      IF Use_Istrue THEN
         FPRINT FP_WRITE, "#define ISTRUE 0!="
      END IF

      IF Use_Notzero THEN
         FPRINT FP_WRITE, "#define NOTZERO 0!="
      END IF

      IF Use_Notnull THEN
         FPRINT FP_WRITE, "#define NOTNULL(A)(*(A)!= 0)"
      END IF

      IF Use_Isnull THEN
         FPRINT FP_WRITE, "#define ISNULL(A)(*(A)== 0)"
      END IF

      IF Use_Isfalse THEN
         FPRINT FP_WRITE, "#define ISFALSE 0=="
      END IF

      IF Use_Iszero THEN
         FPRINT FP_WRITE, "#define ISZERO 0=="
      END IF

      IF Use_Isptr THEN
         FPRINT FP_WRITE, "#define IsPtr(a)((DWORD_PTR)(a))"
      END IF

      IF Use_Bnot THEN
         FPRINT FP_WRITE, "#define BNOT ~(int)"
      END IF

      IF Use_Datacount THEN
         FPRINT FP_WRITE, "#define DATACOUNT (int)(sizeof((DATA))/sizeof((DATA[0])))"
      END IF

      IF Use_Ubound THEN
         FPRINT FP_WRITE, "#define ubound(T)(int)(sizeof((T))/sizeof((T[0]))-1)"
      END IF

      IF Use_Clear THEN
         FPRINT FP_WRITE, "#define Clear(arg)memset(&arg,0,sizeof(arg))"
      END IF

      IF Use_Imod THEN
         FPRINT FP_WRITE, "#define imod(a,b)((a)%(b))"
      END IF

      IF Use_BCX_OlePicture THEN
         FPRINT FP_WRITE, "#define BCX_OLE_WIDTH(H)  LOWORD(PtrToUlong(GetWindowLongPtr(H,GWLP_USERDATA)))"
         FPRINT FP_WRITE, "#define BCX_OLE_HEIGHT(H) HIWORD(PtrToUlong(GetWindowLongPtr(H,GWLP_USERDATA)))"
      END IF

      IF Use_BCX_Resize THEN
         FPRINT FP_WRITE, "#define BCX_RESIZE(hwnd,cx,cy) SetWindowPos (hwnd,NULL,0,0,(cx),(cy),SWP_NOMOVE|SWP_NOREPOSITION|SWP_NOZORDER|SWP_FRAMECHANGED)"
      END IF

      IF Use_BCX_Cursor THEN
         FPRINT FP_WRITE, "#define BCX_Cursor(x)SetCursor(LoadCursor(NULL,x))"
      END IF

      IF Use_Refresh THEN
         FPRINT FP_WRITE, "#define Refresh(A) RedrawWindow(A,NULL,NULL,RDW_ERASE|RDW_INVALIDATE|RDW_ALLCHILDREN|RDW_UPDATENOW);"
      END IF

      IF Use_ShowModal THEN
         FPRINT FP_WRITE, "#define ShowModal(Window)EnableWindow(GetWindow(Window,GW_OWNER),FALSE);Show(Window);"
      END IF

      IF Use_EndModal THEN
         FPRINT FP_WRITE, "#define EndModal(Window)EnableWindow(GetWindow(Window,GW_OWNER),TRUE);DestroyWindow(Window);"
      END IF

      IF Use_Show THEN
         FPRINT FP_WRITE, "#define Show(Window)RedrawWindow(Window,0,0,0);ShowWindow(Window,SW_SHOW);"
      END IF

      IF Use_Hide THEN
         FPRINT FP_WRITE, "#define Hide(Window)ShowWindow(Window,SW_HIDE)"
      END IF

      IF Use_Get THEN
         FPRINT FP_WRITE, "#define GET(A,B,C)fread((B),1,(C),(A))"
      END IF

      IF Use_Put THEN
         FPRINT FP_WRITE, "#define PUT(A,B,C)fwrite((B),1,(C),(A))"
      END IF

      IF Use_Seteof THEN
         FPRINT FP_WRITE, "#define SetEof(A) SetEndOfFile((HANDLE)_get_osfhandle(_fileno((A))))"
      END IF

      IF Use_Strptr THEN
         FPRINT FP_WRITE, "#define STRPTR(A)(char*)&((A))"
      END IF

      IF Use_Val THEN
         FPRINT FP_WRITE, "#define VAL(a)(double)atof((a))"
      END IF

      IF Use_Vall THEN
         FPRINT FP_WRITE, "#if defined(__LCC__)||defined(__POCC__)||defined(__MINGW32__)||defined(__MINGW64__)"
         FPRINT FP_WRITE, "  #define VALL(a) (long double)strtold((a),(char**)NULL)"
         FPRINT FP_WRITE, "#elif defined(__BCPLUSPLUS__)"
         FPRINT FP_WRITE, "  #define VALL(a) (long double)_strtold((a),(char**)NULL)"
         FPRINT FP_WRITE, "#else"
         FPRINT FP_WRITE, "  #define VALL(a) (long double)strtod((a),(char**)NULL)"
         FPRINT FP_WRITE, "#endif"
      END IF

      IF Use_Getattr THEN
         FPRINT FP_WRITE, "#define GETATTR(a)(DWORD)GetFileAttributes((a))"
      END IF

      IF Use_Setattr THEN
         FPRINT FP_WRITE, "#define SETATTR(a,b)(DWORD)SetFileAttributes((a),(b))"
      END IF

      IF Use_Fint THEN
         FPRINT FP_WRITE, "#define FINT(a)floor((a))"
      END IF

      IF Use_Frac THEN
         FPRINT FP_WRITE, "#define FRAC(a)(double)(((a))-FIX((a)))"
         Use_Fix = TRUE
      END IF

      IF Use_Fracl THEN
         FPRINT FP_WRITE, "#define FRACL(a)(long double)((a)-FIX((a)))"
         Use_Fix = TRUE
      END IF

      IF Use_Fix THEN
         FPRINT FP_WRITE, "#define FIX(a)(int)((a))"
      END IF

      IF Use_Csng THEN
         FPRINT FP_WRITE, "#define CSNG(a)(float)((a))"
      END IF

      IF Use_Cdbl THEN
         FPRINT FP_WRITE, "#define CDBL(a)(double)((a))"
      END IF

      IF Use_Cldbl THEN
         FPRINT FP_WRITE, "#define CLDBL(a)(long double)((a))"
      END IF

      IF Use_Threads THEN
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "#define BCX_THREAD(a)        (HANDLE)_beginthreadex(0,0,(unsigned int (__stdcall *)(void *))a,0,0,(unsigned int *)&BCX_Thread_ID)"
         FPRINT FP_WRITE, "#define BCX_THREADWAIT(a)    while(WaitForSingleObject(((void *)a),0)==WAIT_TIMEOUT){}CloseHandle(((void *)a))"
         FPRINT FP_WRITE, "#define BCX_THREADSUSPEND(a) SuspendThread((void *)a)"
         FPRINT FP_WRITE, "#define BCX_THREADRESUME(a)  ResumeThread((void *)a)"
         FPRINT FP_WRITE, "#define BCX_THREADKILL(a)    TerminateThread((void *)a,0); CloseHandle((void *)a)"
         FPRINT FP_WRITE, "#define BCX_THREADEND        _endthreadex(0)"
         FPRINT FP_WRITE, "DWORD   BCX_Thread_ID = 0;"
         FPRINT FP_WRITE, ""
      END IF

      IF Use_LineinputKB THEN
         FPRINT FP_WRITE, "#define mIsDynaString(v)(sizeof((v))==4||sizeof((v))==8)?1:0"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "#define mLineInputKB(p,v)\\"
         FPRINT FP_WRITE, "{\\"
         FPRINT FP_WRITE, "  printf(", ENC$("%s"), ",(p));\\"
         FPRINT FP_WRITE, "  if(mIsDynaString(v))\\"
         FPRINT FP_WRITE, "     fgets((v), _msize((v)), stdin);\\"
         FPRINT FP_WRITE, "   else \\"
         FPRINT FP_WRITE, "     fgets((v), sizeof((v)), stdin);\\"
         FPRINT FP_WRITE, "  (v)[strlen((v))-1]=0;\\"
         FPRINT FP_WRITE, "}"
         FPRINT FP_WRITE, ""
      END IF
   END IF
END SUB ' AddMacros



SUB EmitMDI_MsgPump
   IF LEN(Accelerator$) THEN
      FPRINT Outfile, "  if(!BCX_hwndMDIClient)"
      FPRINT Outfile, "    {"
      FPRINT Outfile, "      return FALSE;"
      FPRINT Outfile, "    }"
      FPRINT Outfile, "  while((GetMessage(&Msg,NULL,0,0)))"
      FPRINT Outfile, "    {"
      FPRINT Outfile, "      HWND hActiveWindow=GetActiveWindow();"
      FPRINT Outfile, "      if((!TranslateMDISysAccel(BCX_hwndMDIClient,&Msg)))"
      FPRINT Outfile, "        {"
      FPRINT Outfile, "          if((!TranslateAccelerator(hActiveWindow,",Accelerator$, ",&Msg)))"
      FPRINT Outfile, "            {"
      FPRINT Outfile, "              TranslateMessage(&Msg);"
      FPRINT Outfile, "              DispatchMessage(&Msg);"
      FPRINT Outfile, "            }"
      FPRINT Outfile, "        }"
      FPRINT Outfile, "    }"
      FPRINT Outfile, "  return Msg.wParam;"
      FPRINT Outfile, "}\n"
   ELSE
      FPRINT Outfile, " if(!BCX_hwndMDIClient)"
      FPRINT Outfile, " {"
      FPRINT Outfile, "   return FALSE;"
      FPRINT Outfile, " }"
      FPRINT Outfile, " while((GetMessage(&Msg,NULL,0,0)))"
      FPRINT Outfile, "   {"
      FPRINT Outfile, "   if((!TranslateMDISysAccel(BCX_hwndMDIClient,&Msg)))"
      FPRINT Outfile, "     {"
      FPRINT Outfile, "       TranslateMessage(&Msg);"
      FPRINT Outfile, "       DispatchMessage(&Msg);"
      FPRINT Outfile, "     }"
      FPRINT Outfile, "   }"
      FPRINT Outfile, "return Msg.wParam;"
      FPRINT Outfile, "}\n"
   END IF
END SUB ' EmitMDI_MsgPump



SUB EmitGUI_MsgPump
   IF LEN(Accelerator$) THEN
      FPRINT Outfile, " while(GetMessage(&Msg,NULL,0,0))"
      FPRINT Outfile, "   {"
      FPRINT Outfile, "    HWND hActiveWindow = GetActiveWindow();"
      FPRINT Outfile, "    if(!TranslateAccelerator(hActiveWindow,",Accelerator$,",&Msg) &&"
      FPRINT Outfile, "       !IsDialogMessage(hActiveWindow,&Msg) || !IsWindow(hActiveWindow))"
      FPRINT Outfile, "      {"
      FPRINT Outfile, "        TranslateMessage(&Msg);"
      FPRINT Outfile, "        DispatchMessage(&Msg);"
      FPRINT Outfile, "      }"
      FPRINT Outfile, "   }"
      FPRINT Outfile, " return Msg.wParam;"
      FPRINT Outfile, "}\n"
   ELSE
      FPRINT Outfile, " while(GetMessage(&Msg,NULL,0,0))"
      FPRINT Outfile, "   {"
      FPRINT Outfile, "    HWND hActiveWindow = GetActiveWindow();"
      FPRINT Outfile, "    if(!IsWindow(hActiveWindow) || !IsDialogMessage(hActiveWindow,&Msg))"
      FPRINT Outfile, "      {"
      FPRINT Outfile, "        TranslateMessage(&Msg);"
      FPRINT Outfile, "        DispatchMessage(&Msg);"
      FPRINT Outfile, "      }"
      FPRINT Outfile, "    }"
      FPRINT Outfile, " return Msg.wParam;"
      FPRINT Outfile, "}\n"
   END IF
END SUB



SUB EmitWinGUIMain(classname$, metric$, icon$)
   FPRINT Outfile, ""
   FPRINT Outfile, "int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrev,LPSTR CmdLine,int CmdShow) {"
   FPRINT Outfile, "  MSG  Msg;"
   FPRINT Outfile, "  strcpy(BCX_ClassName," ; classname$; ");"
   FPRINT Outfile, "  BCX_SetMetric(";ENC$( metric$ );");"
   FPRINT Outfile, "  BCX_InitGUI();"
   FPRINT Outfile, "  BCX_hInstance       =  hInst;"
   FPRINT Outfile, "  BCX_WndClass.hIcon  = " ; icon$
   FPRINT Outfile, "  BCX_RegWnd(BCX_ClassName, WndProc);"
   FPRINT Outfile, ""
   FPRINT Outfile, "  // ******************************************"
   FPRINT Outfile, "                    FormLoad();"
   FPRINT Outfile, "  // ******************************************"
END SUB



SUB EmitMDICode(FP_WRITE AS FILE)
   FPRINT FP_WRITE, "HWND BCX_MDICHILD (LPCTSTR title, LPCTSTR MdiClassName,int x,int y,int cx,int cy,DWORD style,LPARAM lParam) {"
   FPRINT FP_WRITE, "  HWND  hwndChild;"
   FPRINT FP_WRITE, "  char rgch";"[BCXSTRSIZE]= {0};"
   FPRINT FP_WRITE, "  static int cUntitled=1;"
   FPRINT FP_WRITE, "  if(title[0]==0)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      sprintf(rgch," , ENC$("%s%i") , "," , ENC$("Untitled") , ",cUntitled++);"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      strcpy(rgch,title);"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "  //  Create the MDI child window"
   FPRINT FP_WRITE, "  hwndChild = CreateMDIWindow(MdiClassName, rgch, style, x, y,"
   FPRINT FP_WRITE, "              cx, cy, BCX_hwndMDIClient, BCX_hInstance, lParam);"
   FPRINT FP_WRITE, "  return hwndChild;"
   FPRINT FP_WRITE, "}\n\n"

   FPRINT FP_WRITE, "void BCX_MDICLASS (WNDPROC MCWP, PCHAR ClassName) {"
   FPRINT FP_WRITE, "  WNDCLASS wc= {0};"
   FPRINT FP_WRITE, "  wc.style=0;"
   FPRINT FP_WRITE, "  wc.lpfnWndProc=(WNDPROC)MCWP;"
   FPRINT FP_WRITE, "  wc.cbClsExtra=0;"
   FPRINT FP_WRITE, "  wc.cbWndExtra=20;"
   FPRINT FP_WRITE, "  wc.hInstance=BCX_hInstance;"
   FPRINT FP_WRITE, "  wc.hIcon= " , GUIIcon$
   FPRINT FP_WRITE, "  wc.hCursor=LoadCursor(NULL,IDC_ARROW);"
   FPRINT FP_WRITE, "  wc.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);"
   FPRINT FP_WRITE, "  wc.lpszMenuName=NULL;"
   FPRINT FP_WRITE, "  wc.lpszClassName=ClassName;"
   FPRINT FP_WRITE, "  RegisterClass((LPWNDCLASS)&wc);"
   FPRINT FP_WRITE, "}\n\n"


   FPRINT FP_WRITE, "HWND BCX_MDICLIENT (HWND hwndparent, int icount) {"
   FPRINT FP_WRITE, "  CLIENTCREATESTRUCT ccs={0,1};"
   FPRINT FP_WRITE, "  //  Find window menu where children will be listed"
   FPRINT FP_WRITE, "  ccs.hWindowMenu=GetSubMenu(GetMenu(hwndparent),icount-1);"
   FPRINT FP_WRITE, "  //  Create the MDI client filling the client area"
   FPRINT FP_WRITE, "  BCX_hwndMDIClient=CreateWindow(", ENC$("MDICLIENT"), ",NULL,WS_CHILD|WS_CLIPCHILDREN|WS_VISIBLE|WS_VSCROLL|WS_HSCROLL,"
   FPRINT FP_WRITE, "                                 0,0,0,0,hwndparent,(HMENU)(UINT_PTR)NULL,BCX_hInstance,(PVOID)&ccs);"
   FPRINT FP_WRITE, "  return BCX_hwndMDIClient;"
   FPRINT FP_WRITE, "}\n\n"
END SUB      ' EmitMDICode



FUNCTION JoinLines(Arg$)
   Arg$ = RTRIM$(Arg$)
   IF   iMatchRgt(Arg$, " _") _
      OR iMatchRgt(Arg$, ",_") _
      OR iMatchRgt(Arg$, ";_") _
      OR iMatchRgt(Arg$, ":_") _
      OR iMatchRgt(Arg$, ")_") _
      OR iMatchRgt(Arg$, "]_") _
      OR iMatchRgt(Arg$, "}_") _
      OR iMatchRgt(Arg$, ">_") _
      OR iMatchRgt(Arg$, "$_") _
      THEN
      Arg[LEN(Arg)-1] = 0
      CONCAT(CurLine$, Arg$)
      FUNCTION = TRUE
   END IF

   IF NOTNULL(CurLine$) THEN
      Arg$ = CurLine$ + Arg$
      CurLine$ = ""
   END IF
   UmQt = FALSE
   FUNCTION = FALSE
END FUNCTION



SUB StripCode(Arg$)
   DIM RAW p AS PCHAR
   DIM RAW p2 = Arg AS PCHAR
   DIM RAW asmFlag = 0
   DIM RAW eStr = 0
   DIM RAW sub_$

   DO WHILE (*p2 >8 AND *p2 < 13) OR *p2 = 32      'Trim leading space
      INCR p2
   LOOP

   IF *p2 = ASC("!") THEN asmFlag = NOT UmQt    'Handle "!" Asm lines
   p = p2
   DO WHILE *p
      IF *p = 9 THEN *p = 32
      IF *p = c_DblQt THEN ' ignore anything in string literal
         IF *(p-1) = 69 THEN ' we're in an extended string: E"\qABCD\n"
            *(p-1) = 1 ' chr$(1) will be deleted
            eStr = TRUE
         END IF
         DO WHILE *(++p) <> c_DblQt
            IF *p = 92 AND eStr THEN ' look for a \0, \t, \n, \r, \q, \\
               *p = 2
               SELECT CASE *(p+1)
                  CASE 48  ' 0
                  *(p+1) = 3
                  CASE 116 ' t
                  *(p+1) = 4
                  CASE 110 ' n
                  *(p+1) = 5
                  CASE 114 ' r
                  *(p+1) = 6
                  CASE 113 ' q
                  *(p+1) = 7
                  CASE 92 ' \
                  *(p+1) = 8
               END SELECT
               INCR p
            END IF
            IF *p = 0 THEN
               UmQt = NOT UmQt
               EXIT DO
            END IF
         LOOP
      END IF

      ' If we're in a quoted continuation line then ignore comments

      IF NOT UmQt AND NOT asmFlag THEN
         IF (*p BOR 32) = ASC("r") THEN   'Remove REM's
            IF _
               (*(p+1) BOR 32) = ASC("e") AND _
               (*(p+2) BOR 32) = ASC("m") AND _
               (*(p+3) = 32 OR *(p+3) = 0) THEN
               IF p = p2 OR *(p-1) = ASC(":") OR *(p-1) = 32 THEN
                  *p = 0
                  EXIT DO
               END IF
            END IF
         END IF
         ' check for single quote comment marker and // C++ style comments
         IF *p = ASC("'") OR (*p = ASC("/") AND *(p+1) = ASC("/")) THEN
            *p = 0
            EXIT DO
         END IF
      END IF
      INCR p
   LOOP

   DO WHILE p2 < p
      'Trim trailing space
      DO WHILE (*(p-1) >8 AND *(p-1) < 13) OR *(p-1) = 32
         *(--p) = 0
      LOOP

      IF UmQt OR asmFlag THEN EXIT DO

      'Strip dangling colons
      IF *(p-1) = ASC(":") AND *(p-2) = 32 THEN
         DECR p
      ELSE
         EXIT DO
      END IF
   LOOP

   IF eStr THEN
      REMOVE CHR$(1) FROM p2$      ' E
      REMOVE CHR$(2) FROM p2$     ' \ first backslash
      sub_$ = ENC$ ( "+CHR$(0)+" )
      REPLACE CHR$(3) WITH sub_$ IN p2$  ' 0
      sub_$ = ENC$ ( "+CHR$(9)+" )
      REPLACE CHR$(4) WITH sub_$ IN p2$  ' t
      sub_$ = ENC$ ( "+CHR$(10)+" )
      REPLACE CHR$(5) WITH sub_$ IN p2$  ' n
      sub_$ = ENC$ ( "+CHR$(13)+" )
      REPLACE CHR$(6) WITH sub_$ IN p2$  ' r
      sub_$ = ENC$ ( "+CHR$(34)+" )
      REPLACE CHR$(7) WITH sub_$ IN p2$  ' q
      sub_$ = ENC$ ( "+CHR$(92)+" )
      REPLACE CHR$(8) WITH sub_$ IN p2$  ' \
      REMOVE CHR$ (c_DblQt, c_DblQt, 43) FROM  p2$
      REMOVE CHR$ (43, c_DblQt, c_DblQt) FROM  p2$
   END IF
   Arg$ = p2$
END SUB



SUB ProcSingleLineIf(BYREF ifFlag)
   DIM RAW Tmp$, ifp, NdIfs
   DIM STATIC EFlag

   IF ifFlag = 0 THEN EFlag = 0

   REDO:

   IF SplitCnt = cMaxSplitLines THEN
      CALL Abort("Stack Overflow - Too many statements on one line")
   END IF

   Tmp$ = SplitStk$[SplitCnt] + SPC$

   IF iMatchLft(Tmp$, "if ") THEN
      ifp = iMatchNQ(Tmp$, " then ")
      IF ifp THEN

         IF SplitCnt = cMaxSplitLines-1 THEN
            CALL Abort("Stack Overflow - Too many statements on one line")
         END IF

         SplitStk$[SplitCnt++] = LEFT$(Tmp$,ifp+4)
         SplitStk$[SplitCnt] = LTRIM$(Tmp+ifp+4)
         EFlag = IMAX(0,EFlag-1)
         INCR (ifFlag)
         GOTO REDO
      END IF

   ELSE
      IF (ifFlag) THEN
         IF iMatchLft(Tmp$, "else ") THEN   '"else xxx"
            LftLse:
            IF ++EFlag > 1 THEN
               NdIfs = IMAX(1,(ifFlag)-1) : (ifFlag) = 1 : EFlag = 0
               IF iMatchWrd(SplitStk$[SplitCnt-1],"else") THEN DECR SplitCnt

               IF SplitCnt = cMaxSplitLines-1 THEN
                  CALL Abort("Stack Overflow - Too many statements on one line")
               END IF

               REPEAT NdIfs
                  SplitStk$[SplitCnt++] = "END IF"
               END REPEAT
            END IF

            IF SplitCnt = cMaxSplitLines-1 THEN
               CALL Abort("Stack Overflow - Too many statements on one line")
            END IF

            SplitStk$[SplitCnt++] = "ELSE"
            SplitStk$[SplitCnt] = TRIM$(Tmp+4)
            GOTO REDO
         ELSE
            ifp = iMatchNQ(Tmp$, " else ")
            IF ifp THEN                      '"xxx else xxx"

               IF SplitCnt = cMaxSplitLines-1 THEN
                  CALL Abort("Stack Overflow - Too many statements on one line")
               END IF

               SplitStk$[SplitCnt++] = RTRIM$(LEFT$(Tmp$, ifp-1))
               Tmp$ = MID$(Tmp$, ifp+1)
               GOTO LftLse
            END IF
         END IF
      END IF
   END IF         'process "if/then/else"
END SUB



FUNCTION SplitLines(Arg$)
   DIM RAW p  = Arg AS PCHAR
   DIM RAW st = Arg AS PCHAR
   DIM i, IfFlag, SpcolonFlag, ParaCnt

   IF *p = ASC("!") OR *p = ASC("$") THEN FUNCTION = 0

   DO WHILE *p
      IF *p = 32 THEN SpcolonFlag = 1
      IF *p = c_DblQt THEN ' ignore anything in string literal
         DO WHILE *(++p) <> c_DblQt
            IF *p = 0 THEN FUNCTION = SplitCnt
         LOOP
      END IF

      IF *p = c_LPar THEN INCR ParaCnt
      IF *p = c_RPar THEN DECR ParaCnt

      IF *p = ASC(":") THEN
         IF *(p+1) = ASC(":") THEN
            *p = 15
            *(p+1) = 15
         ELSE
            IF NOTNULL((p+1)) OR ISTRUE(SpcolonFlag) THEN

               DO WHILE *st = 32
                  INCR st
               LOOP         'Forward past leading spaces

               INCR SplitCnt

               IF SplitCnt = cMaxSplitLines THEN
                  CALL Abort("Stack Overflow - Too many statements on one line")
               END IF

               DO WHILE st < p                         'Copy new string
                  SplitStk[SplitCnt][i++] = *(st++)
               LOOP

               DO WHILE SplitStk[SplitCnt][i-1] = 32   'Trim trailing spaces
                  DECR i
               LOOP
               SplitStk[SplitCnt][i] = 0            'Add a string terminator
               IF ParaCnt = 0 THEN
                  i=0
                  INCR st   'advance to next start position
                  ProcSingleLineIf(&IfFlag)
               ELSE
                  DECR SplitCnt
               END IF
            END IF         'if NOT End of line
         END IF
      END IF           'if :
      INCR p
   LOOP

   'Add the last string
   IF SplitCnt > 0 THEN
      DO WHILE *st = 32
         INCR st
      LOOP  'Forward past leading spaces
      INCR SplitCnt

      IF SplitCnt = cMaxSplitLines THEN
         CALL Abort("Stack Overflow - Too many statements on one line")
      END IF

      DO WHILE *st
         SplitStk[SplitCnt][i++] = *(st++)
      LOOP
      SplitStk[SplitCnt][i] = 0
      ProcSingleLineIf(&IfFlag)
      'Process single line if/thens that don't contain colon separated statements
   ELSE
      IF iMatchLft(Arg$,"if ") AND NOT iMatchRgt(Arg$," then") THEN
         CALL Add2SplitLines(Arg$)
         ProcSingleLineIf(&IfFlag)
      END IF
   END IF

   'If we processed single line "if/then" then close it up
   IF IfFlag THEN
      DO WHILE IfFlag
         CALL Add2SplitLines("END IF")
         DECR IfFlag
      LOOP
   END IF

   FUNCTION = SplitCnt
END FUNCTION ' SplitLines



FUNCTION SpecialCaseHandler(Param$)
   DIM RAW i, j, k, iSrcStkIndex
   DIM RAW lsz$
   '******************************************************************************
   ' The following 783 transform helps overcome a parsing issue involving spaces
   ' in and around dimensional brackets, as in the following exaggerated example:
   '
   '                  DIM AS INTEGER TheArray [  1  +  1  ,  1  +  4  ]
   '
   ' which enters this function in Param$ as:       TheArray [  1+1  ][  1+4  ]
   ' The ver. 783 transform corrects this to the following:
   '                                                TheArray [1+1][1+4]
   '******************************************************************************
   DIM RAW Arg$                            ' MrBcx  783
   Arg$ = Param$                           ' MrBcx  783

   IF INCHR(Param$,"[") OR INCHR(Param$,"]") THEN       ' Avoid unneeded REPLACE's
      REPEAT 2                             ' MrBcx  783 - Requires 2 passes to get
         REPLACE "[ " WITH "[" IN Arg$     ' MrBcx  783 - correct translations.
         REPLACE " [" WITH "[" IN Arg$     ' MrBcx  783 - The reason evades me.
         REPLACE "] " WITH "]" IN Arg$     ' MrBcx  783
         REPLACE " ]" WITH "]" IN Arg$     ' MrBcx  783
      END REPEAT                           ' MrBcx  783
   END IF
   '******************************************************************************

   IF iMatchNQ(Arg$," sub ") OR iMatchNQ(Arg$," function ") THEN FUNCTION = FALSE

   '******************************************************************************
   ' Handle Multiple Dim's, Locals, Globals, Shared etc.
   ' Example: DIM a, b!, c$, d$*1000, q[100] AS DWORD
   ' Forward propagation of a type
   ' DIM AS INT a, b[10], c, d[20]
   '******************************************************************************
   lsz$ =  SPC$ + EXTRACT$(Arg$, SPC$) + SPC$

   IF iMatchNQ(" dim , local , global , raw , static , shared , dynamic , auto , register , extern ", lsz$) THEN
      CALL FastLexer(Arg$, SPC$, ",&(){}=")
      IF iMatchWrd("as",Stk$[3]) THEN
         lsz$ =  SPC$ + LCASE$(Stk$[2]) + SPC$
         IF iMatchNQ(" local , raw , static , shared , dynamic , auto , register ", lsz$) THEN
            Stk$[1] = Stk$[2]
            LShiftStk(2)
         END IF
      END IF

      '******************************************************************************
      ' Begin forward propagation of a type
      '******************************************************************************

      IF iMatchWrd("as",Stk$[2]) THEN
         DIM RAW szWrk$
         DIM RAW FirstComma, Ignore, b, EqualAt
         DIM RAW Tmp$[8]
         DIM iFUNC
         CALL BuildDelimStr(1, Ndx, szWrk$)
         CALL FastLexer(szWrk$,SPC$,",&(){}=")

         XFOR i = 3, Ignore = 0, FirstComma = 0, EqualAt = 0 WHILE i <= Ndx AND FirstComma = 0 BY i++
            IF *Stk$[i] = ASC("=") AND Ignore = 0 THEN EqualAt = i
            IF *Stk$[i] = ASC("{") THEN INCR Ignore
            IF *Stk$[i] = ASC("(") THEN INCR Ignore : IF iFUNC = 0 THEN iFUNC = i
            IF *Stk$[i] = ASC(")") THEN DECR Ignore
            IF *Stk$[i] = ASC("}") THEN DECR Ignore
            IF *Stk$[i] = ASC(",") AND  Ignore = 0 THEN FirstComma = i
         XNEXT

         IF FirstComma = 0 THEN FirstComma = Ndx+1
         IF iFUNC THEN i = iFUNC
         IF i > EqualAt AND EqualAt THEN i = EqualAt
         b = 0
         DO
            DECR i
            IF *Stk$[i] = ASC("}") THEN INCR b
            IF *Stk$[i] = ASC(")") THEN INCR b
            IF *Stk$[i] = ASC("(") THEN DECR b
            IF *Stk$[i] = ASC("{") THEN DECR b
         LOOP WHILE b

         IF *Stk$[i] = ASC("=") THEN DECR i
         IF *Stk$[i] = ASC("(") THEN DECR i
         IF *Stk$[i] = ASC("{") THEN DECR i
         IF *Stk$[i] = ASC(",") THEN DECR i

         DIM RAW iVecCheck
         XFOR j = 0, k = 2, iVecCheck = 0 WHILE k < i BY j++,k++
            IF INCHR(Stk$[k], CHR$(15)) THEN iVecCheck = 1
            IF iVecCheck THEN REPLACE "<" WITH CHR$(16) IN Stk$[k]
            IF iVecCheck THEN REPLACE "," WITH CHR$(18) IN Stk$[k]
            IF iVecCheck THEN REPLACE ">" WITH CHR$(17) IN Stk$[k]
            Tmp$[j] = Stk$[k] : Stk$[k] = ""
         XNEXT

         k = Ndx
         Tmp$[0] = SPC$ + Tmp$[0]

         InsertTokens(Ndx, j, Tmp$[0], Tmp$[1], Tmp$[2], Tmp$[3], Tmp$[4], Tmp$[5], Tmp$[6], Tmp$[7])
         Ignore = 0

         DO WHILE k >= FirstComma
            IF *Stk$[k] = ASC("}") THEN INCR Ignore
            IF *Stk$[k] = ASC(")") THEN INCR Ignore
            IF *Stk$[k] = ASC("(") THEN DECR Ignore
            IF *Stk$[k] = ASC("{") THEN DECR Ignore
            IF *Stk$[k] = ASC(",") AND NOT Ignore THEN
               InsertTokens(k-1, j ,Tmp$[0] ,Tmp$[1] ,Tmp$[2] ,Tmp$[3] ,Tmp$[4] ,Tmp$[5] ,Tmp$[6] ,Tmp$[7])
            END IF
            DECR k
         LOOP

         CALL RemEmptyTokens
         CALL BuildDelimStr(1, Ndx, Arg$)
         CALL FastLexer(Arg$,SPC$,",(){}=")
      ELSE

         XFOR i = 1, INT t = 1, INT iVecCheck = 0 WHILE i < Ndx AND t BY i++
            t = GetAsPosF(i, Ndx)
            IF t THEN
               INCR t
               XFOR iVecCheck = 0 WHILE t <= Ndx BY t++
                  IF *Stk$[t] = ASC(",") AND iVecCheck = 0 THEN EXIT XFOR
                  IF INCHR(Stk$[t], CHR$(15)) THEN iVecCheck = 1
                  IF iVecCheck THEN REPLACE "<" WITH CHR$(16) IN Stk$[t]
                  IF iVecCheck THEN REPLACE "," WITH CHR$(18) IN Stk$[t]
                  IF iVecCheck THEN REPLACE ">" WITH CHR$(17) IN Stk$[t]
               XNEXT
            END IF
         XNEXT

      END IF                   ' End forward propagation of a type

      '******************************************************************************

      ' tolerate nonsense like >> DIM A% as DOUBLE << by removing the sigil

      XFOR i = 1, INT t = 1 WHILE i < Ndx AND t BY i++
         t = GetAsPosF(i, Ndx)
         IF t THEN
            i = t
            Stk$[i-1] = Clean$(Stk$[i-1])
         END IF
      XNEXT

      Stk$[2] = SPC$ + Stk$[2] + SPC$
      IF iMatchNQ (" raw , local , dynamic , register , static , shared , auto ", Stk$[2]) THEN
         Stk$[1] = Stk$[1] + Stk$[2]
         Stk$[2] = ""
      END IF
      INCR SrcCnt
      j=0
      FOR i = 1 TO Ndx
         IF *Stk$[i] = ASC("(") THEN INCR j
         IF *Stk$[i] = ASC("{") THEN INCR j
         IF *Stk$[i] = ASC(")") THEN DECR j
         IF *Stk$[i] = ASC("}") THEN DECR j
         IF *Stk$[i] = ASC(",") AND NOT j THEN
            Stk$[i]  = Stk$[1]
            INCR SrcCnt
         END IF

         IF SrcCnt = cMaxSingleLineIFLines THEN
            CALL Abort("Single line conversion to multi-line exceeds limit.")
         END IF

         SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
      NEXT
      GOTO ProcessNew
   END IF

   IF InDialogEvt OR ModDialogEvt THEN
      IF iMatchNQ(Arg$,"WM_INITDIALOG") THEN
         CALL AddExpressionToStack(Arg$)
         CALL AddExpressionToStack("SetDialogScale(hWnd,0)")
         GOTO ProcessNew
      END IF
   END IF

   SELECT CASE TRUE

      '******************************
      CASE iMatchLft(Arg$,"on ")     ' on expression gosub | goto | call  label1,label2,Sub...
      '******************************
      DIM RAW Target = 0
      j = 0
      CALL FastLexer(Arg$,SPC$,",")

      FOR i = 1 TO Ndx
         IF iMatchLft(Stk$[i],"gosub") OR _
            iMatchLft(Stk$[i],"goto")  OR _
            iMatchLft(Stk$[i],"call")  THEN
            Target = i+1
            EXIT FOR
         END IF
      NEXT

      IF Target = 0 THEN
         CALL Abort("Malformed ON/GOSUB,GOTO,CALL.")
      END IF

      CALL AddExpressionToStack("select case ")        'Assemble our expression
      FOR i = 2 TO Target - 2
         SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + SPC$ + Stk$[i]
      NEXT

      FOR i = Target TO Ndx
         IF *Stk$[i] = ASC(",") THEN ITERATE
         INCR j
         CALL AddExpressionToStack("case" + STR$(j))
         CALL AddExpressionToStack(Stk$[Target-1] + SPC$ + Stk$[i])
      NEXT
      CALL AddExpressionToStack("end select")

      GOTO ProcessNew

      '******************************
      CASE iMatchLft(Arg$,"loop ")
      '******************************
      CALL FastLexer(Arg$,SPC$,",()")

      IF iMatchLft(Stk$[2],"until") THEN
         CALL AddExpressionToStack("if ")
         FOR i = 3 TO Ndx
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
         NEXT
         SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + " then"
         CALL AddExpressionToStack("exit do")
         CALL AddExpressionToStack("end if")
         CALL AddExpressionToStack("loop")
         iLoopCond = 1
         GOTO ProcessNew

      ELSEIF iMatchLft(Stk$[2],"while") THEN
         CALL AddExpressionToStack("if NOT (")
         FOR i = 3 TO Ndx
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
         NEXT
         SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + ") then"
         CALL AddExpressionToStack("exit do")
         CALL AddExpressionToStack("end if")
         CALL AddExpressionToStack("loop")
         iLoopCond = 1
         GOTO ProcessNew
      ELSE
         IF Ndx > 1 THEN
            Abort("UNKNOWN Word " + Stk$[2] + " After LOOP")
         END IF
      END IF

      '******************************
      CASE iMatchLft(Arg$,"do ")
      '******************************
      CALL FastLexer(Arg$,SPC$,",()")

      IF iMatchLft(Stk$[2],"until") THEN
         CALL AddExpressionToStack("do")
         CALL AddExpressionToStack("if ")
         FOR i = 3 TO Ndx
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
         NEXT
         SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + "then"
         CALL AddExpressionToStack("exit do")
         CALL AddExpressionToStack("end if")
         iDoWhile = lt_DOUNTILLOOP
         GOTO ProcessNew
      ELSEIF iMatchLft(Stk$[2],"while") THEN
         CALL AddExpressionToStack("while ")
         iDoWhile = lt_DOWHILELOOP
         FOR i = 3 TO Ndx
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
         NEXT
         GOTO ProcessNew

      ELSE
         IF Ndx > 1 THEN
            Abort("UNKNOWN Word " + Stk$[2] + " After DO")
         END IF
      END IF
   END SELECT

   FUNCTION = FALSE

   ProcessNew:

   Ndx = iSrcStkIndex = 0
   DO WHILE SrcCnt
      Arg$ = SrcStk$[++iSrcStkIndex]
      SrcStk$[iSrcStkIndex] = ""
      DECR SrcCnt
      PassOne = TRUE
      CALL XParse(Arg$)
      PassOne = FALSE
      CALL FixUps
      IF Ndx THEN CALL EmitMain
   LOOP
   FUNCTION = TRUE
END FUNCTION ' SpecialCaseHandler




SUB FastLexer (Arg$ AS LPCTSTR, delim1$ AS LPCTSTR, delim2$ AS LPCTSTR, TokQuote = 1)
   '*************************************************************
   'delim1$ = delimiters to remove
   'delim2$ = delimiters to keep
   'Stk$ and Ndx are Global
   'As long as Ndx is honored Stk does not need to be initialized
   '*************************************************************
   DIM RAW pd1 AS PCHAR
   DIM RAW pd2 AS PCHAR
   DIM RAW cnt1, cnt2
   cnt1 = cnt2 = 0
   Ndx  = 1

   DO WHILE Arg[cnt1]

      IF Arg[cnt1] = c_DblQt THEN    'quotes - string literals

         IF cnt2 AND TokQuote THEN
            Stk[Ndx++][cnt2]=0
            cnt2=0
         END IF

         Stk[Ndx][cnt2] = c_DblQt

         DO WHILE Arg[++cnt1] <> c_DblQt
            Stk[Ndx][++cnt2] = Arg[cnt1]
            IF Arg[cnt1] = 0 THEN EXIT SUB
         LOOP

         Stk[Ndx][++cnt2] = Arg[cnt1]

         IF TokQuote THEN
            Stk[Ndx++][++cnt2]=0
            cnt2=0
            GOTO again
         END IF

      END IF

      pd1 = (char*)delim1

      DO WHILE *pd1
         IF *(pd1++) = Arg[cnt1] THEN
            IF cnt2 THEN
               Stk[Ndx++][cnt2]=0
               cnt2=0
            END IF
            GOTO again
         END IF
      LOOP

      pd2 = (char*)delim2

      DO WHILE *pd2
         IF *(pd2++) = Arg[cnt1] THEN
            IF cnt2 THEN Stk[Ndx++][cnt2]=0
            Stk[Ndx][0] = Arg[cnt1]
            Stk[Ndx++][1]=0
            cnt2 = 0
            GOTO again
         END IF
      LOOP

      Stk[Ndx][cnt2++]=Arg[cnt1]

      again:

      INCR cnt1
   LOOP
   Stk[Ndx][cnt2]=0
   IF cnt2 = 0 THEN DECR Ndx
END SUB ' FastLexer



SUB InsertTokens(PosAfter, NumTokens, ...)
   DIM RAW ap AS va_list, i
   FOR i = Ndx TO PosAfter+1 STEP -1
      Stk$[i+NumTokens] = Stk$[i]
   NEXT

   va_start(ap,NumTokens)
   FOR i = PosAfter+1 TO PosAfter+NumTokens
      Stk$[i] = va_arg(ap, char*)
   NEXT
   va_end(ap)
   INCR Ndx,NumTokens
   Stk$[Ndx+1] = ""
END SUB ' InsertTokens



SUB AppendTokens(NumTokens, ...)
   DIM RAW ap AS va_list
   va_start(ap,NumTokens)
   FOR INT i = Ndx+1 TO Ndx+NumTokens
      Stk$[i] = va_arg(ap, char*)
   NEXT
   va_end(ap)
   INCR Ndx,NumTokens
   Stk$[Ndx+1] = ""
END SUB ' AppendTokens



SUB EmitExportDef(fs$)
   DIM STATIC BeenHere
   DIM STATIC fname$, Private_FunctionName$
   DIM RAW i, st=1, sz=0
   fname$ = EXTRACT$(FileIn$,".") + ".def"

   IF NOT BeenHere THEN
      OPEN fname$ FOR OUTPUT AS fpdef
      _splitpath(FileIn$, NULL, NULL, fname$, NULL)
      FPRINT fpdef, "LIBRARY ", ENC$(fname$)
      FPRINT fpdef, "EXPORTS"
      BeenHere = TRUE
   END IF

   FastLexer(fs$, "", "(,)")

   DO WHILE *Stk$[st] <> ASC("(")
      INCR st
   LOOP

   FOR i = st+1 TO Ndx
      IF *Stk$[i] = ASC(")") THEN EXIT FOR
      IF *Stk$[i] <> ASC(",") THEN
         IF INCHR(Stk$[i],"*") THEN INCR sz,4 : ITERATE

         IF iMatchNQ(Stk$[i],"longlong") OR _
            iMatchNQ(Stk$[i],"double")   OR _
            iMatchNQ(Stk$[i],"long long") THEN
            INCR sz,8
            ITERATE
         END IF
         IF NOT INCHR(Stk$[i],"void") THEN INCR sz,4
      END IF
   NEXT
   Stk$[1] = TRIM$(Stk$[1])
   Private_FunctionName$ = MID$(Stk$[1],INSTRREV(Stk$[1],SPC$) + 1)
   FPRINT fpdef, Private_FunctionName$," = _",Private_FunctionName$,"@",LTRIM$(STR$(sz))
END SUB ' EmitExportDef




FUNCTION GetArg$(ArgNum, fp AS functionParse PTR)
   DIM RAW RetArg$  = ""
   DIM RAW ArgEnd   = fp->CommaPos[ArgNum] - 1
   DIM RAW ArgStart = fp->CommaPos[ArgNum - 1] + 1

   IF ArgNum >= fp->NumArgs THEN ArgEnd = Ndx

   FOR ArgStart = ArgStart TO ArgEnd
      CONCAT(RetArg$, Stk$[ArgStart])
   NEXT

   FUNCTION = RetArg$
END FUNCTION ' GetArg



FUNCTION SepFuncArgs(Strt, fp AS functionParse PTR, functionflag AS INT)
   DIM RAW CountR = 0   ' () [] counter
   DIM RAW i = Strt     ' loop counter

   IF functionflag THEN
      DO WHILE i <= Ndx
         IF *Stk$[i] = ASC("(") THEN EXIT DO
         INCR i
      LOOP
      Strt = i + 1

      fp->NumArgs = 0 'comma counter
      fp->CommaPos[0] = i 'Strt-1
      IF Strt > Ndx THEN
         FUNCTION = 0
      END IF
   ELSE
      Strt = 2
      fp->CommaPos[0] = 1
   END IF

   IF *Stk$[Strt] = ASC(")") THEN
      fp->CommaPos[1] = Strt
      FUNCTION = 0
   END IF
   fp->NumArgs = 1

   FOR i = Strt TO Ndx
      IF *Stk$[i] = ASC("(") OR *Stk$[i] = ASC("[") THEN
         INCR CountR
      ELSEIF *Stk$[i] = ASC(")") OR *Stk$[i] = ASC("]") THEN
         IF CountR = 0 THEN
            fp->CommaPos[fp->NumArgs] = i
            EXIT FOR
         END IF
         DECR CountR
      ELSEIF *Stk$[i] = ASC(",") AND CountR = 0 THEN
         fp->CommaPos[fp->NumArgs] = i
         INCR fp->NumArgs

         IF fp->NumArgs = cCommaPos THEN
            CALL Abort("Number of arguments exceeds 127")
         END IF

      END IF
   NEXT
   IF functionflag = 0 THEN fp->CommaPos[fp->NumArgs] = Ndx

   FUNCTION = fp->NumArgs 'Number of commas + 1 = Number of arguments
END FUNCTION ' SepFuncArgs



FUNCTION MakeDecProto                  _
   (fp AS functionParse PTR,           _
   iStart=2 AS INT,                    _
   iEnd=Ndx AS INT,                    _
   iNoTypeDef = FALSE AS INT) AS LPSTR

   LOCAL OptFlag
   LOCAL pointer

   DIM STATIC Proto$      ' Must remain static
   DIM STATIC SubFunPtr   ' Must remain static
   DIM STATIC FunType$    ' Must remain static

   DIM RAW i, ii
   DIM RAW AsType$
   DIM RAW OptValue$
   DIM RAW AsArrys$
   DIM RAW FoundAs
   DIM RAW fpp AS functionParse : memset (&fpp,0,SIZEOF(functionParse))  ' MrBcx 789

   IF SubFunPtr THEN GOTO argparse

   Proto$   = ""
   FunType$ = ""
   '------------------------
   'Determine function type
   '------------------------
   ' constructor/destructor
   IF ConstructDestructTest(1) THEN
      FunType$ = ""
   ELSE
      IF iMatchWrd(Stk$[iStart], "sub") THEN
         FunType$ = "void"
      ELSEIF *Stk$[iEnd] = ASC(")") THEN
         'check for type identifier suffix
         'if unknown, then integer will default
         FunType$ = VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(Stk$[iStart+1],1)) ]
      ELSE
         FOR i = iEnd TO fp->CommaPos[fp->NumArgs]+1 STEP -1
            IF iMatchWrd(Stk$[i], "ptr") OR *Stk$[i] = ASC("*") THEN
               INCR pointer
            ELSEIF iMatchWrd(Stk$[i], "as") THEN
               EXIT FOR
            ELSE
               IF Stk$[i] <> "" THEN FunType$ = Stk$[i] + SPC$ + FunType$
            END IF
         NEXT
         FunType$ = TRIM$(FunType$)
      END IF
   END IF

   IF ISNULL(FunType$) THEN
      Proto$ = Stk$[iStart] + "("
   ELSE
      IF InTypeDef THEN
         DIM RAW L_Var$
         DIM RAW w
         DIM RAW id
         DIM RAW vt

         Proto$ = FunType$ + "  " + STRING$(pointer, ASC("*")) + " ("
         Proto$ = Proto$ + CallType$ + "*" + Clean$(Stk$[iStart+1]) + ")("

         L_Var$ = FunType$ + STRING$(pointer, ASC("*"))
         GetTypeInfo(L_Var$, &w, &id, &vt)
         AddTypedefElement(BaseTypeDefsCnt[InTypeDef],vt, Clean$(Stk$[iStart+1]), FunType$)
      ELSEIF SFPOINTER THEN
         IF iNoTypeDef THEN
            Proto$ = FunType$ + " (" + CallType$ + "*" + Clean$(Stk$[iStart+1]) + ")("
         ELSE
            Proto$ = "typedef " + FunType$ + " (" + CallType$
            Proto$ = Proto$ + "*" + Clean$(Stk$[iStart+1]) + "_TYPE)("
         END IF
      ELSEIF NOT NoTypeDeclare AND NOT InClass AND NOT InPPType THEN
         Proto$ = "typedef " + FunType$ + " (" + CallType$
         Proto$ = Proto$ + "*BCXFPROT" + LTRIM$(STR$(DllCnt)) + ")("
      ELSE
         IF UseCProto OR InClass OR InPPType THEN
            UseCProto = FALSE
            Proto$ = FunType$ + "  " + STRING$(pointer, ASC("*")) + SPC$
            Proto$ = Proto$ + CallType$ + Clean$(Stk$[iStart+1]) + "("
         ELSE
            Proto$ = "C_IMPORT " + FunType$ + "  " + STRING$(pointer, ASC("*"))
            Proto$ = Proto$ + SPC$ + CallType$ + Clean$(Stk$[iStart+1]) + "("
         END IF
      END IF
   END IF

   '-----------------------------------------------------
   argparse:
   '-----------------------------------------------------
   'Determine argument types
   '-----------------------------------------------------
   IF fp->NumArgs = 0 THEN
      IF FunType$ <> ""  THEN
         CONCAT(Proto$, "void)")
      ELSE
         CONCAT(Proto$, ")")
      END IF
   ELSE
      FOR ii = 0 TO fp->NumArgs - 1

         OptValue$ = ""
         AsType$   = ""
         AsArrys$  = ""
         pointer   = 0
         FoundAs   = 0

         DIM RAW FirstToken  = fp->CommaPos[ii] + 1
         DIM RAW LastToken   = fp->CommaPos[ii+1] - 1
         DIM RAW NumOfTokens = (LastToken - FirstToken) + 1

         i = INCHR(Stk$[FirstToken], "[")
         IF i THEN
            AsArrys$ = MID$(Stk$[FirstToken], i)
            Stk[FirstToken][i-1] = 0
         END IF

         IF NumOfTokens = 1 THEN
            '--------------------------------------------------------
            ' The bracket handling should be handled better.
            ' currently using the preprocessing of FunSubDecs1
            ' which converts A![] to *A! and A$[] to *A$[][2048]
            ' and A[] as xxx to A as xxx*
            '--------------------------------------------------------
            AsType$ = VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(Stk$[FirstToken],1)) ]
            IF *AsArrys$ THEN
               REMOVE "*" FROM AsType$
            ELSE
               pointer = TALLY(Stk$[FirstToken], "*")
            END IF
            '--------------------------------------------------------
            FoundAs = TRUE
         ELSE

            FOR i = LastToken TO FirstToken STEP -1
               IF iMatchWrd(Stk$[i], "ptr") OR *Stk$[i] = ASC("*") THEN
                  INCR pointer

               ELSEIF iMatchWrd(Stk$[i], "sub") THEN
                  SepFuncArgs(fp->CommaPos[ii]+2, &fpp, TRUE)
                  CONCAT(Proto$, "void (*)(")
                  SubFunPtr = FoundAs = TRUE
                  MakeDecProto(&fpp)
                  SubFunPtr = FALSE
                  EXIT FOR

               ELSEIF iMatchWrd(Stk$[i], "function") THEN
                  SepFuncArgs(fp->CommaPos[ii]+2, &fpp, TRUE)
                  IF ISNULL(AsType$) THEN
                     AsType$ = VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(Stk$[FirstToken],1)) ]
                  END IF
                  Proto$ = Proto$ + RTRIM$(AsType$) + STRING$(pointer,ASC("*")) + " (*)("
                  pointer = 0
                  AsType$ = ""
                  SubFunPtr = FoundAs = TRUE
                  MakeDecProto(&fpp)
                  SubFunPtr = FALSE
                  EXIT FOR

               ELSEIF iMatchWrd(Stk$[i], "as") THEN

                  IF ISNULL(AsType$) THEN
                     CALL Abort("No type specified for argument" + STR$(ii+1))
                  END IF

                  FoundAs = TRUE
                  EXIT FOR

               ELSEIF *Stk$[i] = ASC("=") THEN
                  OptFlag = FoundAs = TRUE
                  OptValue$ = " =" + AsType$
                  AsType$ = ""
                  IF i = FirstToken + 1 THEN
                     AsType$ = VarTypeLookup$[ INCHR(VARTYPES$,RIGHT$(Stk$[FirstToken],1)) ]
                     IF *AsArrys$ THEN
                        REMOVE "*" FROM AsType$
                     ELSE
                        pointer = TALLY(Stk$[FirstToken], "*")
                     END IF
                     EXIT FOR
                  END IF
               ELSE
                  IF *Stk$[i] <> ASC(".") THEN
                     AsType$ = Stk$[i] + SPC$ + AsType$
                  ELSE
                     IF *Stk$[i-1] = ASC(".") THEN

                        IF OptFlag THEN
                           CALL Abort("Default value not allowed when using variable arguments")
                        END IF

                        IF ii <> (fp->NumArgs-1) THEN
                           CALL Abort("Variable argument must be the last parameter")
                        END IF

                        IF fp->NumArgs = 1 THEN
                           CALL Abort("Variable argument must be preceded by at least one other parameter")
                        END IF

                        FoundAs = TRUE
                     END IF
                     AsType$ = Stk$[i] + AsType$
                  END IF
               END IF
            NEXT i
         END IF

         IF NOT FoundAs THEN
            CALL Abort("Malformed argument type in parameter" + STR$(ii + 1))
         END IF

         IF ii <> fp->NumArgs AND OptFlag AND ISNULL(OptValue$) THEN
            CALL Warning("No default value specified for parameter" + STR$(ii + 1), 1)
         END IF

         Proto$ = Proto$ + RTRIM$(AsType$) + AsArrys$ + STRING$(pointer,ASC("*")) + OptValue$ + Stk$[fp->CommaPos[ii+1]]
      NEXT ii
      '-----------------------------------------------------
   END IF

   FUNCTION = Proto
END SUB ' MakeDecProto



SUB AsmUnknownStructs(CompArrays)
   DIM InBrace, InStruct, i
   DIM LTmp$

   FOR i = 2 TO Ndx
      ' --------------------------------
      ' Complete arrays
      ' --------------------------------
      IF CompArrays THEN
         IF *Stk$[i] = ASC("[") THEN
            LTmp$ = Stk$[i-1] : Stk$[i-1] = ""
            DO
               CONCAT(LTmp$, Stk$[i])
               IF *Stk$[i] = ASC("]") THEN DECR InBrace
               IF *Stk$[i] = ASC("[") THEN INCR InBrace
               Stk$[i] = ""
               INCR i
            LOOP WHILE InBrace AND i <= Ndx
            Stk$[--i] = LTmp$
         END IF
      END IF
      ' --------------------------------
      ' Complete unknown struct members
      ' --------------------------------
      IF LEN(Stk$[i]) > 1 AND NOT IsNumber(Stk$[i]+1) THEN
         IF *Stk$[i] = ASC(".") OR iMatchLft(Stk$[i], "->") THEN
            IF InStruct = 0 THEN
               Stk$[i] = Stk$[i-1] + Stk$[i]
               Stk$[i-1] = ""
               InStruct = i
            ELSE
               CONCAT(Stk$[InStruct], Stk$[i])
               Stk$[i] = ""
            END IF
            ITERATE
         END IF
      END IF

      IF NOTNULL(Stk$[i]) AND InStruct THEN
         InStruct = 0
      END IF
   NEXT

   CALL RemEmptyTokens
END SUB ' AsmUnknownStructs



SUB CheckForASC
   DIM RAW Tmp
   DIM RAW iEmp
   iEmp = 0
   FOR Tmp = 1 TO Ndx
      IF iMatchWrd(Stk$[Tmp], "asc") THEN
         iEmp = 1
         CALL Process_ASC_Function (Tmp)
      END IF
   NEXT
   IF iEmp THEN CALL RemEmptyTokens
END SUB ' CheckForASC




SUB Make_Stricmp_Map
   '******************************************************************
   ' This supports the BCX 757 "??" operator (case-insensitivity)
   ' For each IF statement, BCX will emit one or more strcmp calls.
   ' This sub helps identify which of those needs to be changed to
   ' bcx_stricmp.  It does that by building a map of which strcmp
   ' is affected by the ?? operator.  The map will contain values
   ' 1 (insensitive) or 2 (normal) that are used in: SUB EmitIfCond
   '*******************************************************************
   GLOBAL  MSMap[128]  ' 128 strcmp/bcx_stricmp's per IF statement
   DIM RAW MSM_Ndx     ' seems unlikely to ever be exceeded
   DIM RAW i

   MSM_Ndx = 0         '
   FOR i = 0 TO 127    ' zero things out each invocation
      MSMap[i] = 0     '
   NEXT

   FOR i = 1 TO Ndx
      IF (*Stk$[i] = ASC("?") AND *Stk$[i+1] = ASC("?") AND *Stk$[i+2] = ASC("=") ) OR _
         (*Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC("?") AND *Stk$[i+2] = ASC("?") ) OR _
         (*Stk$[i] = ASC("?") AND *Stk$[i+1] = ASC("=") AND *Stk$[i+2] = ASC("?") ) THEN
         CALL Abort("Combining string operators '?' and '=' is ambiguous")
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF *Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC("=") THEN
         Stk$[i] = "=="
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF *Stk$[i] = ASC("?") AND *Stk$[i+1] = ASC("?") THEN
         Stk$[i] = "??"
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF (*Stk$[i] = ASC("<")  AND  Stk$[i+1] = "??" AND *Stk$[i+2] = ASC(">"))  OR _
         (*Stk$[i] =  ASC("<") AND *Stk$[i+1] = ASC(">") AND  Stk$[i+2] = "??")  OR _
         (*Stk$[i] =  ASC(">") AND  Stk$[i+1] = "??" AND *Stk$[i+2] = ASC("<"))  THEN
         Stk$[i] = "!??"
         LShiftStk (i+1)
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF (*Stk$[i] = ASC("!") AND Stk$[i+1] = "??") OR (Stk$[i] = "??" AND *Stk$[i+1] = ASC("!")) THEN
         Stk$[i] = "!??"
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF (Stk$[i] = "??" AND *Stk$[i+1] = ASC(">")) OR (*Stk$[i] = ASC(">") AND Stk$[i+1] = "??") THEN
         Stk$[i] = ">??"
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF (Stk$[i] = "??" AND *Stk$[i+1] = ASC("<")) OR (*Stk$[i] = ASC("<") AND Stk$[i+1] = "??") THEN
         Stk$[i] = "<??"
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF (*Stk$[i] = ASC("<") AND *Stk$[i+1] = ASC("=")) OR (*Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC("<") ) THEN
         Stk$[i] = "<="
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF (*Stk$[i] = ASC(">") AND *Stk$[i+1] = ASC("=")) OR (*Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC(">")) THEN
         Stk$[i] = ">="
         LShiftStk (i+1)
      END IF
   NEXT

   FOR i = 1 TO Ndx
      IF (*Stk$[i] = ASC("!") AND *Stk$[i+1] = ASC("=")) THEN
         Stk$[i] = "!="
         LShiftStk (i+1)
      END IF
   NEXT

   '***********************************************
   '       Here is where we build the map
   '        One "IF" statement at a time
   '***********************************************

   FOR i = 1 TO Ndx
      SELECT CASE Stk$[i]

         CASE "??"
         Stk$[i] = "="
         MSMap [++MSM_Ndx] = 1   ' SUB EmitIfCond will emit bcx_stricmp's

         CASE "<??"
         Stk$[i] = "<"
         MSMap [++MSM_Ndx] = 1   '                 Ditto

         CASE ">??"
         Stk$[i] = ">"
         MSMap [++MSM_Ndx] = 1   '                 Ditto

         CASE "!??"
         Stk$[i] = "!="
         MSMap [++MSM_Ndx] = 1   '                 Ditto

         CASE "=", "<", ">", "<=", ">=", "!=", "!"
         MSMap [++MSM_Ndx] = 2                      ' SUB EmitIfCond will RETAIN the strcmp's

      END SELECT
   NEXT
END SUB


FUNCTION Im_A_String_Var(A$)
   DIM RAW idx
   IF CheckLocal  (A$,&idx) = vt_CHAR   THEN FUNCTION = TRUE
   IF CheckGlobal (A$,&idx) = vt_CHAR   THEN FUNCTION = TRUE
   IF CheckLocal  (A$,&idx) = vt_STRVAR THEN FUNCTION = TRUE
   IF CheckGlobal (A$,&idx) = vt_STRVAR THEN FUNCTION = TRUE
   FUNCTION = FALSE
END FUNCTION



SUB EmitIfCond (CondType$, iOutputMethod, ArgOut = "" AS LPCTSTR)
   '*************************************************************************************
   ' Speedup/Optimize for statements like --->  if a$    = ""  THEN
   '               AND                    --->  if a$[1] = ""  THEN
   '               AND                    --->  while x = ASC("x")
   '*************************************************************************************
   DIM IsWhile
   DIM RAW A, B, TestString, ParCnt, Tmp
   DIM RAW szTest$
   DIM RAW szOut$
   '*************************************************************************************
   ' The code below allows a char[] array to be treated like a STRVAR in an IF statement.
   '*************************************************************************************
   IF Im_A_String_Var (Stk$[2]) THEN
      DIM ii
      IF *Stk$[3] <> ASC("[") THEN ii = TRUE
      IF ii = TRUE AND INCHR(Stk$[2],"$") = FALSE THEN
         CONCAT(Stk$[2],"$")
      END IF
   END IF
   '*************************************************************************************
   szOut$ = ArgOut$

   CALL CheckForASC

   IF iOutputMethod = eStringPart OR iOutputMethod = eStringFull THEN szOut$ = ""

   TestString = DataType(Stk$[2])

   IF TestString = vt_STRVAR OR TestString = vt_CHAR THEN
      IF Stk$[4] = DDQ$ THEN
         Stk$[2] = Clean$(Stk$[2]) + "[0]"
         Stk$[4] = "0"
      ELSE
         IF Stk$[3] = "[" AND Stk$[7] = DDQ$ THEN
            Stk$[2] = Clean$(Stk$[2])
            CONCAT (Stk$[5],"[0]")
            Stk$[7] = "0"
         END IF
      END IF
   END IF

   IF CondType$ = "while" THEN IsWhile = TRUE

   '********************   If Handler, ElseIf Handler, & While Handler   *********************
   '
   '   At this stage, an IF statement has been lexed and is ready to be parsed from Stk$[]
   '******************************************************************************************
   IF_Stmt_Buffer$ = ""               'GLOBAL 1MB string
   CALL  Make_Stricmp_Map
   '******************************************************************************************

   IF iOutputMethod = eFull THEN
      IF_Stmt_Buffer$ = Scoot$ + CondType$ + "("
   END IF

   IF iOutputMethod = eStringFull THEN
      szOut$ = CondType$ + "("
   END IF

   Tmp = 2
   DO WHILE Stk$[Tmp] = "(" OR Stk$[Tmp] = "!"  ' <<-- DO NOT OPTIMIZE THIS LINE WITH POINTERS - MrBcx
      IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
         CONCAT(IF_Stmt_Buffer$, Stk$[Tmp])
      ELSE
         CONCAT(szOut$, Stk$[Tmp])
      END IF
      INCR Tmp
   LOOP

   TestString = FALSE

   A = DataType(Stk$[Tmp])
   IF A = vt_STRLIT OR A = vt_STRVAR THEN
      IF Stk$[Tmp + 1] <> ")" AND ISFALSE (iMatchWrd(Stk$[Tmp+1], "then")) THEN
         TestString  = TRUE
         IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
            CONCAT(IF_Stmt_Buffer$, "strcmp(")
         ELSE
            CONCAT(szOut$, Stk$[Tmp])
         END IF
      END IF
   END IF

   szTest$ = ""
   ParCnt  = 0

   DO
      IF TestString THEN
         SELECT CASE Stk$[Tmp]

            CASE "="
            Stk$[Tmp] = ","
            szTest$   = ")==0"
            ParCnt    =  0

            CASE "!="
            Stk$[Tmp] = ","
            szTest$   = ")!=0"
            ParCnt    = 0

            CASE ">"
            IF Stk$[Tmp + 1] = "=" THEN
               Stk$[Tmp] = ","
               szTest$   = ")>=0"
               Stk$[Tmp + 1] = ""
            ELSE
               Stk$[Tmp] = ","
               szTest$   = ")==1"
            END IF
            ParCnt = 0

            CASE "<"
            IF Stk$[Tmp + 1] = "=" THEN
               Stk$[Tmp] = ","
               szTest$   = ")<=0"
               Stk$[Tmp + 1] = ""
            ELSE
               Stk$[Tmp] = ","
               szTest$   = ")==-1"
            END IF
            ParCnt = 0

            '************************************************
            CASE ">="
            Stk$[Tmp] = ","
            szTest$   = ")>=0"
            ParCnt = 0

            CASE "<="
            Stk$[Tmp] = ","
            szTest$   = ")<=0"
            ParCnt = 0
            '************************************************

            CASE "("
            INCR ParCnt

            CASE ")"
            DECR ParCnt
         END SELECT

         IF Stk$[Tmp] = ")" AND szTest$ <> "" AND ParCnt < 0 THEN
            IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
               IF_Stmt_Buffer$ = IF_Stmt_Buffer$ +  szTest$ +  Stk$[Tmp]
            ELSE
               CONCAT(szOut$, szTest$)
               CONCAT(szOut$, Stk$[Tmp])
            END IF
            szTest$ = ""
         ELSE
            IF Stk$[Tmp] = "||" OR Stk$[Tmp] = "&&" THEN
               Stk$[Tmp] = szTest$ + SPC$ + Stk$[Tmp] + SPC$
               szTest$ = ""
               B = 1

               DO WHILE Stk$[Tmp + B] = "("
                  CONCAT (Stk$[Tmp],"(")
                  Stk$[Tmp + B] = ""
                  INCR B
               LOOP

               A = DataType(Stk$[Tmp+B])      ' look ahead
               IF (A = vt_STRLIT OR A = vt_STRVAR) AND Stk$[Tmp+B+1] <> ")" THEN
                  CONCAT (Stk$[Tmp]," strcmp(")
               ELSE
                  IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                     CONCAT(IF_Stmt_Buffer$, Clean$(Stk$[Tmp]))
                  ELSE
                     CONCAT(szOut$, Clean$(Stk$[Tmp]))
                  END IF
                  TestString = FALSE
                  GOTO NxtToken
               END IF
            END IF
            IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
               CONCAT(IF_Stmt_Buffer$, Clean$(Stk$[Tmp]))
            ELSE
               CONCAT(szOut$, Clean$(Stk$[Tmp]))
            END IF
         END IF
      ELSE  'Not TestString
         IF Stk$[Tmp] = "||" OR Stk$[Tmp] = "&&" THEN
            B = 1
            DO WHILE Stk$[Tmp + B] = "("
               CONCAT (Stk$[Tmp], "(")
               Stk$[Tmp + B] = ""
               INCR B
            LOOP

            A = DataType(Stk$[Tmp+B])                ' look ahead
            IF (A = vt_STRLIT OR A = vt_STRVAR) AND Stk$[Tmp+B+1] <> ")" THEN
               CONCAT (Stk$[Tmp]," strcmp(")
               TestString  = TRUE
               szTest$     = ""
               ParCnt      = 0
               IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                  CONCAT(IF_Stmt_Buffer$, Clean$(Stk$[Tmp]))
               ELSE
                  CONCAT(szOut$, Clean$(Stk$[Tmp]))
               END IF
               GOTO NxtToken
            END IF
         END IF

         IF Stk$[Tmp] = "!" THEN
            IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
               CONCAT(IF_Stmt_Buffer$, Stk$[Tmp])
            ELSE
               CONCAT(szOut$, Stk$[Tmp])
            END IF
         ELSE
            IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
               CONCAT(IF_Stmt_Buffer$, Clean$(Stk$[Tmp]))
            ELSE
               CONCAT(szOut$, Clean$(Stk$[Tmp]))
            END IF
            IF NOT ispunct(*Stk$[Tmp]) THEN
               IF Tmp < Ndx AND NOT ispunct(*Stk$[Tmp+1]) THEN
                  IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                     CONCAT(IF_Stmt_Buffer$, SPC$)
                  ELSE
                     CONCAT(szOut$, SPC$)
                  END IF
               END IF
            END IF
         END IF
         IF Stk$[Tmp] = "=" THEN
            IF Stk$[Tmp-1] <> "<" AND Stk$[Tmp-1] <> ">" THEN
               IF Stk$[Tmp+1] <> ">" AND Stk$[Tmp+1] <> "<" THEN
                  IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                     CONCAT(IF_Stmt_Buffer$, "=")
                  ELSE
                     CONCAT(szOut$, "=")
                  END IF
               END IF
            END IF
         END IF
      END IF

      NxtToken:

      INCR Tmp
      IF NOT IsWhile THEN
         IF iMatchWrd(Stk$[Tmp], "then") THEN
            EXIT DO
         ELSEIF Tmp > Ndx THEN
            Abort("If Without THEN")
         END IF
      END IF
   LOOP UNTIL Tmp > Ndx


   SELECT CASE iOutputMethod
      CASE   eFull
      IF_Stmt_Buffer$ = IF_Stmt_Buffer$ +szTest$ +  ")"

      CALL BumpUp
      CONCAT(IF_Stmt_Buffer$, "{")
      CALL BumpUp

      CASE ePart
      CONCAT(IF_Stmt_Buffer$, szTest$)

      CASE eStringPart
      CONCAT(szOut$, szTest$)
      CASE eStringFull
      CONCAT(szOut$, szTest$)
      CONCAT(szOut$, ")")
   END SELECT

   '***************************************************************************************

   FastLexer(IF_Stmt_Buffer$, "", " =&()[]{}',+-*/<>?;.|:^")

   FOR INT ii = 1 TO Ndx
      IF *Stk$[ii] = ASC("=") AND *Stk$[ii+1] = ASC("=") THEN
         Stk$[ii] = "=="
         LShiftStk(ii+1)
      END IF
   NEXT

   FOR INT ii = 1 TO Ndx
      IF *Stk$[ii] = ASC(">") AND *Stk$[ii+1] = ASC("=") THEN
         Stk$[ii] = ">="
         LShiftStk(ii+1)
      END IF
   NEXT

   FOR INT ii = 1 TO Ndx
      IF Stk$[ii] = "<=" AND *Stk$[ii+1] = ASC("=") THEN
         Stk$[ii] = "<="
         LShiftStk(ii+1)
      END IF
   NEXT

   FOR INT ii = 1 TO Ndx
      IF *Stk$[ii] = ASC("!") AND *Stk$[ii+1] = ASC("=") THEN
         Stk$[ii] = "!="
         LShiftStk(ii+1)
      END IF
   NEXT

   FOR INT ii = 1 TO Ndx
      IF *Stk$[ii] = ASC("&") AND *Stk$[ii+1] = ASC("&") THEN
         Stk$[ii] = "&&"
         LShiftStk(ii+1)
      END IF
   NEXT

   FOR INT ii = 1 TO Ndx
      IF *Stk$[ii] = ASC("|") AND *Stk$[ii+1] = ASC("|") THEN
         Stk$[ii] = "||"
         LShiftStk(ii+1)
      END IF
   NEXT

   '******************
   DIM LOCAL Map_Idx
   '******************

   FOR INT ii = 1  TO Ndx
      IF Stk$[ii] = "strcmp" THEN
         IF MSMap[++Map_Idx] = 1 THEN
            Stk$[ii] = "bcx_stricmp"
            Use_Bcx_stricmp = TRUE
         END IF
      END IF
   NEXT

   IF_Stmt_Buffer$ = ""

   FOR INT ii = 1  TO Ndx
      CONCAT(IF_Stmt_Buffer$, Stk$[ii])
   NEXT

   IF IgnoreStrCase = TRUE THEN
      REPLACE "strcmp" WITH "bcx_stricmp" IN IF_Stmt_Buffer$
      Use_Bcx_stricmp = TRUE
   END IF

   '******************************************************************************************
   '         These replacements improve the code formatting inside the c/c++ file
   '******************************************************************************************
   REPLACE " ) {"           WITH  ") {"        IN IF_Stmt_Buffer$

   IF iMatchNQ (IF_Stmt_Buffer$, "cmp") THEN
      REPLACE "||  strcmp"  WITH  "|| strcmp"  IN IF_Stmt_Buffer$
      REPLACE "&&  strcmp"  WITH  "&& strcmp"  IN IF_Stmt_Buffer$
      REPLACE "||  stricmp" WITH  "|| stricmp" IN IF_Stmt_Buffer$
      REPLACE "&&  stricmp" WITH  "&& stricmp" IN IF_Stmt_Buffer$
      REPLACE "( strcmp"    WITH  "(strcmp"    IN IF_Stmt_Buffer$
      REPLACE "( stricmp"   WITH  "(stricmp"   IN IF_Stmt_Buffer$
   END IF

   IF ISFALSE iMatchNQ (IF_Stmt_Buffer$," || ") THEN
      REPLACE "|| " WITH  " || " IN IF_Stmt_Buffer$
   END IF

   IF ISFALSE iMatchNQ (IF_Stmt_Buffer$," && ") THEN
      REPLACE "&& " WITH  " && " IN IF_Stmt_Buffer$
   END IF
   '******************************************************************************************

   IF iOutputMethod = ePart THEN
      FPRINT Outfile, IF_Stmt_Buffer$;
   ELSE
      FPRINT Outfile, IF_Stmt_Buffer$
   END IF

END SUB ' EmitIfCond




SUB PrintGlobal(FP_WRITE AS FILE, A, idx, Storage$, P$, VarName$, VarDim$)
   DIM RAW L_Var$

   SELECT CASE A
      ' handle exceptions
      CASE vt_FILEPTR
      REMOVE "@" FROM VarName$
      FPRINT FP_WRITE, Storage$; "FILE    *"; P$; VarName$; VarDim$; ";"

      CASE vt_UDT, vt_STRUCT, vt_UNION
      L_Var$ = TypeDefs[GlobalVars[idx].VarDef].VarName$
      L_Var$ = RPAD$(L_Var$, 7)
      FPRINT FP_WRITE, Storage$; L_Var$; SPC$; P$; VarName$; VarDim$; ";"

      CASE vt_LPSTR
      FPRINT FP_WRITE, Storage$; "LPSTR  "; P$; VarName$; VarDim$; ";"

      CASE vt_STRVAR
      IF ISNULL(VarDim$) THEN VarDim$ = "[BCXSTRSIZE]"
      FPRINT FP_WRITE, Storage$; "char    "; P$; VarName$; VarDim$; ";"

      ' handle normal

      CASE vt_VarMin TO vt_VarMax
      L_Var$ = GetVarTypeName$(GlobalVars[idx].VarType)
      L_Var$ = RPAD$(L_Var$, 7)
      FPRINT FP_WRITE, Storage$; L_Var$; SPC$; P$; VarName$; VarDim$; ";"

   END SELECT
END SUB



SUB ReDirectFPrint(TgtFile AS FILE, pat$, ...)
   'Used primarily to bump LinesWritten
   DIM RAW ap AS va_list

   IF DoCountLines AND TgtFile = FP_W THEN
      INCR LinesWritten
   END IF

   va_start(ap, pat$)
   vfprintf(TgtFile, pat$, ap)
   va_end(ap)
END SUB



SUB InitReservedWordsLookup
   DIM RAW MaxReservedWords AS INT
   DIM RAW sL$ = ""
   DIM RAW iC AS INT
   DIM RAW iD AS INT

   MaxReservedWords = WordsInTable(BCXWords) ' How many reserved words

   FOR iC = 0 TO 96
      iRIndex[iC][0] = MaxReservedWords-1
      iRIndex[iC][1] = 0
   NEXT

   FOR iC = 0 TO MaxReservedWords-1

      IF sL$ > BCXWords[iC].pszFunctionName$ THEN
         CALL Abort ("Error in BCXWords[], Names out of order" + _
         CRLF$ + sL$ + " comes after " + BCXWords[iC].pszFunctionName$ + _
         CRLF$ + "Correct and recompile")
      END IF

      sL$ = BCXWords[iC].pszFunctionName$

      iD = ASC(sL$)-32
      IF iD < 0 THEN iD = 0
      IF iD > 96 THEN iD = 96
      IF iRIndex[iD][0] > iC THEN iRIndex[iD][0] = iC
      IF iRIndex[iD][1] < iC THEN iRIndex[iD][1] = iC
   NEXT

   FOR iC = 0 TO 96
      IF iRIndex[iC][0] > iRIndex[iC][1] THEN iRIndex[iC][0] = iRIndex[iC][1]
      iRIndex[iC][1]++
   NEXT

   DIM RAW iChk AS INT
   DIM RAW iSize AS INT
   iSize = WordsInTable(tBcxWords)-2
   FOR iChk = 0 TO iSize
      IF tBcxWords[iChk].pszWord$ > tBcxWords[iChk+1].pszWord$ THEN
         CALL Abort("Error in SET tBcxWords: " + tBcxWords[iChk].pszWord$ + _
         " comes after " + tBcxWords[iChk+1].pszWord$ )
      END IF
   NEXT

   iSize = WordsInTable(tTypes)-2
   FOR iChk = 0 TO iSize
      IF tTypes[iChk].pszWord$ > tTypes[iChk+1].pszWord$ THEN
         CALL Abort("Error in SET tTypes: " + tTypes[iChk].pszWord$ + _
         " comes after " + tTypes[iChk+1].pszWord$)
      END IF
   NEXT

   iSize = WordsInTable(atEmitWords)-2
   FOR iChk = 0 TO iSize
      IF atEmitWords[iChk].pszWord$ > atEmitWords[iChk+1].pszWord$ THEN
         CALL Abort("Error in SET atEmitWords: " + atEmitWords[iChk].pszWord$ + _
         " comes after " + atEmitWords[iChk+1].pszWord$)
      END IF
   NEXT

   iSize = WordsInTable(tDirectives)-2
   FOR iChk = 0 TO iSize
      IF tDirectives[iChk].pszWord$ > tDirectives[iChk+1].pszWord$ THEN
         CALL Abort("Error in SET tDirectives: " + tDirectives[iChk].pszWord$ + _
         " comes after " + tDirectives[iChk+1].pszWord$)
      END IF
   NEXT

   iSize = WordsInTable(atVARIANTVALUENAMES)-3
   FOR iChk = 0 TO iSize
      IF atVARIANTVALUENAMES[iChk].sNAME$ > atVARIANTVALUENAMES[iChk+1].sNAME$ THEN
         CALL Abort("Error in SET atVARIANTVALUENAMES: " + atVARIANTVALUENAMES[iChk].sNAME$ + _
         " comes after " + atVARIANTVALUENAMES[iChk+1].sNAME$)
      END IF
   NEXT

   iSize = WordsInTable(ptVCasts)-3
   FOR iChk = 0 TO iSize
      IF ptVCasts[iChk].pszCAST$ > ptVCasts[iChk+1].pszCAST$ THEN
         CALL Abort("Error in SET ptVCasts: " + ptVCasts[iChk].pszCAST$ + _
         " comes after " + ptVCasts[iChk+1].pszCAST$)
      END IF
   NEXT

   iSize = WordsInTable(ptCCasts)-3
   FOR iChk = 0 TO iSize
      IF ptCCasts[iChk].pszCAST$ > ptCCasts[iChk+1].pszCAST$ THEN
         CALL Abort("Error in SET ptCCasts: " + ptCCasts[iChk].pszCAST$ + _
         " comes after " + ptCCasts[iChk+1].pszCAST$)
      END IF
   NEXT
END SUB ' InitReservedWordsLookup




FUNCTION GetWordInfo(sWord$) AS tagTokenSubFunctions PTR
   DIM RAW iH
   DIM RAW iL
   DIM RAW iM
   DIM RAW iV

   iM = ASC(sWord$)-32
   IF iM < 0 THEN iM = 0
   IF iM > 96 THEN iM = 96
   iL = iRIndex[iM][0]
   iH = iRIndex[iM][1]

   DO
      'middle = low + ((high - low) / 2)
      iM = (iH + iL)>>1
      iV = strcmp(BCXWords[iM].pszFunctionName, sWord)
      SELECT CASE iV
         CASE -1
         IF iL <> iH THEN
            IF iL = iM THEN
               INCR iL
            ELSE
               iL = iM
            END IF
         END IF
         CASE 0
         FUNCTION = &BCXWords[iM]
         CASE 1
         IF iL <> iH THEN
            iH = iM
         END IF
      END SELECT
   LOOP UNTIL iL = iH
   FUNCTION = NULL
END FUNCTION ' GetWordInfo



FUNCTION FindWord(sWord$, tWordList AS tagWords PTR, iWordsInTable AS INT) AS INT
   DIM RAW iH AS INT
   DIM RAW iL AS INT
   DIM RAW iM AS INT
   DIM RAW iV AS INT
   iL = 0
   iH = iWordsInTable ' How many reserved words
   DO WHILE iL <> iH
      iM = (iH + iL)>>1
      iV = strcmp(tWordList[iM].pszWord, sWord)
      SELECT CASE iV
         CASE -1
         IF iL = iM THEN FUNCTION = (-1)
         iL = iM
         CASE 0
         FUNCTION = iM
         CASE 1
         IF iL = iM THEN FUNCTION = (-1)
         iH = iM
      END SELECT
   LOOP
   FUNCTION = (-1)
END FUNCTION ' FindWord



SUB FixAnyArrays(Arg$)
   DIM RAW iMakeNewArg AS INT
   DIM RAW iAttach AS INT
   iMakeNewArg = 0
   FOR INT i = 1 TO Ndx
      IF iMatchWrd(Stk$[i], "as") THEN
         INCR i
         iAttach = 0
         IF iMatchWrd(Stk$[i], "vector") THEN
            INCR i
            IF *Stk$[i] = ASC("<") THEN
               iAttach = i-1
            END IF
         ELSE
            IF iMatchWrd(Stk$[i+1], "vector") THEN
               INCR i,2
               IF *Stk$[i] = ASC("<") THEN
                  iAttach = i-1
               END IF
            END IF
         END IF
         IF iAttach > 0 THEN
            iMakeNewArg = 1
            FOR INT j = iAttach+1 TO Ndx
               IF Stk$[j] = "<" THEN
                  CONCAT(Stk$[iAttach], CHR$(16))
                  Stk$[j] = ""
                  XFOR INT k = j+1, INT iV = 1 WHILE k<= Ndx AND iV > 0 BY k++
                     SELECT CASE Stk$[k]
                        CASE ">"
                        DECR iV
                        CONCAT(Stk$[iAttach], CHR$(17))
                        Stk$[k] = ""
                        CASE "<"
                        INCR iV
                        CONCAT(Stk$[iAttach], CHR$(16))
                        Stk$[k] = ""
                        CASE ","
                        CONCAT(Stk$[iAttach], CHR$(18))
                        Stk$[k] = ""
                        CASE ELSE
                        CONCAT(Stk$[iAttach], Stk$[k])
                        Stk$[k] = ""
                     END SELECT
                  XNEXT
               END IF
            NEXT
         END IF
      END IF
   NEXT
   IF iMakeNewArg THEN
      DIM RAW szNewArg$
      szNewArg$ = ""
      CALL RemEmptyTokens
      FOR INT i = 1 TO Ndx
         CONCAT(szNewArg$, Stk$[i])
         CONCAT(szNewArg$, SPC$)
      NEXT
      Arg$ = szNewArg$
   END IF
END SUB ' FixAnyArrays



SUB Translate(Arg$)
   DIM RAW ptW AS tagTokenSubFunctions PTR
   DIM RAW szWord$  = ""
   DIM RAW Scratch$ = ""
   DIM RAW iEmitID
   DIM RAW iDoFixup

   ' Handle SET
   IF iMatchLft(Arg$, "set ") THEN
      IF ComSwitchON = TRUE THEN
         IF INCHR(Arg$, "=") THEN
            Use_COM = Use_BcxTmpStr = TRUE
         ELSE
            CALL ProcessSetCommand(0)
            EXIT SUB
         END IF
      ELSE
         CALL ProcessSetCommand(0)
         EXIT SUB
      END IF
   END IF

   IF iMatchLft(Arg$,"sharedset ") THEN
      CALL ProcessSetCommand(1)
      EXIT SUB
   END IF

   PassOne = TRUE
   CALL XParse(Arg$)
   PassOne = FALSE

   IF Ndx = 0 THEN EXIT SUB

   '*************************************************************************************
   ' 775  MrBcx -- I discovered that SUB/FUNCTION arguments, declared using the ! and #
   ' sigils for single and double precisions, were being translated as integers which
   ' would result in type conflicts when attempting to compile.  This bug was introduced
   ' in BCX 650 ( circa 2010 ) and has existed ever since.  How was this never noticed?
   ' The code below seems to adequately overcome those problems.
   '*************************************************************************************
   GLOBAL TransformSigil
   LOCAL  ArgsFound

   IF UseCpp = FALSE THEN      ' This "fix" would break some C++ code
      TransformSigil = FALSE
      IF iMatchWrd(Stk$[1]    ,"SUB")                            _
         OR (iMatchWrd(Stk$[1],"FUNCTION") AND Stk$[2] <> "=" )  _
         OR iMatchWrd(Stk$[1],"DECLARE")                         _
         OR iMatchWrd(Stk$[1],"C_DECLARE")                       _
         OR iMatchWrd(Stk$[1],"PUBLIC")                          _
         OR iMatchWrd(Stk$[1],"PRIVATE") THEN
         FOR INT zz = 1 TO Ndx
            IF Stk$[zz]="(" THEN ArgsFound = TRUE
            IF ArgsFound THEN
               IF RIGHTSTR(Stk$[zz],"#")  THEN
                  REPLACE "#" WITH " AS DOUBLE " IN Stk$[zz]
                  TransformSigil = TRUE
               END IF
            END IF
            IF ArgsFound THEN
               IF RIGHTSTR(Stk$[zz],"!")  THEN
                  REPLACE "!" WITH " AS SINGLE " IN Stk$[zz]
                  TransformSigil = TRUE
               END IF
            END IF
            IF ArgsFound THEN
               IF TransformSigil THEN
                  FOR INT yy = 1 TO Ndx
                     IF Stk$[yy]  = "["  AND Stk$[zz+1] = "]" THEN
                        Stk$[yy]   = "*"
                        Stk$[yy+1] = ""
                     END IF
                  NEXT
               END IF
            END IF
         NEXT
      END IF

      IF TransformSigil THEN
         Scratch$ = ""
         FOR INT zz = 1 TO Ndx
            CONCAT(Scratch$, Stk$[zz])
            CONCAT(Scratch$, SPC$)
         NEXT
         REPLACE "DOUBLE  as double" WITH "DOUBLE" IN Scratch$ ' <-  BYREF causes this
         REPLACE "SINGLE  as single" WITH "SINGLE" IN Scratch$ ' <-  BYREF causes this
         CALL FastLexer(Scratch$, SPC$, "=&()[]{}',+-*/<>?;.|:^") ' Rebuild Stk$[]
      END IF
   END IF
   '********************************************************************************
   '    Try to stop users from using the word 'DATA' in ways that are not allowed.
   '********************************************************************************
   FOR INT i = 1 TO Ndx
      IF Stk$[i] ?? "data" AND Stk$[i+1] ?? "as" THEN
         CALL Abort("DATA is a reserved word ")
      END IF
   NEXT
   '********************************************************************************

   IF UseCpp OR UseCpphdr THEN CALL FixAnyArrays(Arg$)

   IF ComSwitchON = TRUE THEN
      DIM RAW i, j
      XFOR i = 1, j = COM_open_WITH_statement WHILE i<= Ndx AND j = 0 BY i++
         IF IsVariableComObject(Stk$[i]) THEN j = 1
      XNEXT
      IF j THEN
         IF Find_COM_statement(Src$) = TRUE THEN EXIT SUB
      END IF
   END IF

   IF SpecialCaseHandler(Arg$) THEN EXIT SUB

   iDoFixup = TRUE
   szWord$ = LCASE$(Stk$[1])
   ptW = GetWordInfo(szWord$)
   IF ptW THEN
      IF (ptW->iWordInfo BAND eWI_Directive) THEN
         iEmitID = FindWord(szWord$, tDirectives, WordsInTable(tDirectives))
         IF iEmitID <> NOTFOUND THEN
            DIM FuncRetnFlag
            IF tDirectives[iEmitID].Emitter(szWord$, &FuncRetnFlag) = 0 THEN EXIT SUB
         END IF
      END IF
      IF (ptW->iWordInfo BAND eWI_NoFixup) THEN
         iDoFixup = FALSE
      END IF
   END IF

   IF iDoFixup THEN
      CALL FixUps
      PassOne = FALSE
   END IF

   IF Ndx THEN
      CALL EmitMain
      IF iEmitVarGroup THEN CALL EmitBCXVariables
   END IF
END SUB



SUB FixVector
   DIM RAW Tmp, j, k
   FOR Tmp = 2 TO Ndx
      IF iMatchWrd(Stk$[Tmp],"as") THEN
         IF Stk$[Tmp+1] = "vector" THEN
            INCR Tmp
            k = Tmp
            j = 0
            DO
               CONCAT(Stk$[k],Stk$[++Tmp])
               IF Stk$[Tmp] = ">" THEN INCR j
               Stk$[Tmp] = ""
            LOOP UNTIL j
         END IF
      END IF
   NEXT
   CALL RemEmptyTokens
END SUB



SUB EmitMain
   DIM RAW EmitAgain = TRUE
   DIM RAW FuncRetnFlag = 0
   DIM RAW iEmitID
   DIM RAW Lookup$
   IF HasVector THEN CALL FixVector : HasVector = FALSE
   Lookup$ = LCASE$(Stk$[1])

   IF SelectState[StateIdx].NoBreak AND NOT iMatchLft(Lookup$,"case") AND NOT iMatchWrd(Lookup$,"endselect") THEN
      SelectState[StateIdx].NoBreak = 0
   END IF

   FOR INT i = 1 TO Ndx
      IF INCHR(Stk$[i],CHR$(15)) THEN REPLACE CHR$(15) WITH ":" IN Stk$[i]
      IF INCHR(Stk$[i],CHR$(16)) THEN REPLACE CHR$(16) WITH "<" IN Stk$[i]
      IF INCHR(Stk$[i],CHR$(17)) THEN REPLACE CHR$(17) WITH ">" IN Stk$[i]
      IF INCHR(Stk$[i],CHR$(18)) THEN REPLACE CHR$(18) WITH "," IN Stk$[i]
   NEXT

   IF iMatchRgt(Stk$[1], ":") THEN    'This Must Be A Label
      FPRINT Outfile, ""
      FPRINT Outfile, UCASE$(Stk$[1]),";"
      EXIT SUB
   END IF

   DO WHILE EmitAgain AND Ndx > 0
      INCR Statements
      IF CurrentFuncType = vt_STRVAR AND InFunction AND OkayToSend THEN
         FPRINT Outfile, Scoot$, "char *BCX_RetStr= {0};"
         OkayToSend = FALSE
      END IF
      Lookup$ = LCASE$(Stk$[1])
      iEmitID = FindWord(Lookup$, atEmitWords, WordsInTable(atEmitWords))
      IF iEmitID = NOTFOUND THEN
         EmitOld(&FuncRetnFlag)
         EmitAgain = FALSE
      ELSE
         EmitAgain = atEmitWords[iEmitID].Emitter(Lookup$, &FuncRetnFlag)
      END IF
   LOOP

   IF FuncRetnFlag = 1 THEN
      IF NOTZERO (LocalDynaCnt) THEN
         FOR INT j = 1 TO LocalDynaCnt
            FPRINT Outfile, Scoot$, DynaStr$[j]
         NEXT
      END IF
      '******************************************************************
      FPRINT Outfile, Scoot$, "return BCX_RetStr;"  ' $ FUNCTION Return
      '******************************************************************
   END IF
   ExitSubFunc = FALSE
   IF iMatchWrd(Stk$[1], "exit") THEN
      IF iMatchWrd(Stk$[2], "sub") OR iMatchWrd(Stk$[2], "function") THEN
         ExitSubFunc = TRUE
      END IF
   END IF
END SUB ' EmitMain



FUNCTION Emit_FolderDriveProcs(Lookup$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(FuncRetnFlag)
   ' "chdir", "_chdir", "rmdir", "_rmdir", "mkdir", "_mkdir"
   FPRINT Outfile, Scoot$, Lookup$;" (";
   Stk$[++Ndx] = ");"
   CALL WriteCleanTokens(2,Ndx)
   FUNCTION = 0
END FUNCTION ' Emit_FolderDriveProcs



FUNCTION Emit_FunctionReturn(Lookup$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(Lookup$)
   DIM LTmp$
   IF SelectState[StateIdx].CaseFlag THEN SelectState[StateIdx].NoBreak = TRUE

   FOR INT iA = 3 TO Ndx
      LTmp$ = LTmp$ + Stk$[iA] + SPC$
   NEXT

   IF CurrentFuncType = vt_STRVAR THEN
      LTmp$ = "BCX_RetStr$ = " + LTmp$
      *FuncRetnFlag = 1    '1 = return a string
      Use_BcxTmpStr = TRUE
   ELSE
      *FuncRetnFlag = 2    '2 = return a number
   END IF

   IF *FuncRetnFlag = 2 THEN
      '*********************************
      '    Clean up dynamic strings
      '*********************************
      IF NOTZERO (LocalDynaCnt) THEN
         FOR INT j = 1 TO LocalDynaCnt
            FPRINT Outfile, Scoot$, DynaStr$[j]
         NEXT
      END IF
      '*********************************
      ' Clean up dynamic strings arrays
      '*********************************
      IF NOTZERO (LocalDynArrCnt) THEN
         FOR INT i = 1 TO LocalDynArrCnt
            FPRINT Outfile, Scoot$, LocalDynArrName$[i]
         NEXT
      END IF
      '*********************************
      FPRINT Outfile, Scoot$, "return ";
      LastCmd = 2
   END IF
   CALL XParse(LTmp$)
   CALL FixUps
   LastCmd = 0
   FUNCTION = 1
END FUNCTION ' Emit_FunctionReturn




FUNCTION Emit_GUIProcs(sWord$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(FuncRetnFlag)
   SELECT CASE sWord$
      CASE "gui", "mdigui"

      IF Ndx < 2 THEN
         CALL Abort("Not Enough Parameters with " + UCASE$(sWord$) + " Statement!")
      END IF

      IF iMatchWrd(Stk$[2],"nomain") THEN

         Use_Wingui    = TRUE
         NoMain        = TRUE
         Use_GUINoMain = TRUE

         IF iMatchWrd(Stk$[4], "pixels") THEN
            GUIMetric$ = "pixels"
         END IF

         IF iMatchWrd(Stk$[4],"dpi") THEN
            GUIMetric$ = "dpi"
         END IF

         IF iMatchWrd(Stk$[4], "icon") AND Stk$[6] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[6] + "));"
         ELSEIF iMatchWrd(Stk$[6],"icon") AND Stk$[8] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[8] + "));"
         ELSE
            GUIIcon$ = " LoadIcon(NULL,IDI_WINLOGO);"
         END IF

         IF sWord$ = "mdigui" THEN
            Use_Mdigui       = TRUE
            CALL EmitMDICode(Outfile)
            Use_MDIGUINoMain = TRUE
            Use_GUINoMain    = FALSE
         END IF

      ELSE '  Old GUI code before GUI NOMAIN

         Use_Wingui = TRUE

         DIM classname$ = ""
         DIM metric$    = ""

         classname$ = Stk$[2]

         IF iMatchWrd(Stk$[4], "pixels") THEN
            metric$ = "pixels"
            GUIMetric$ = "pixels"
         END IF

         IF iMatchWrd(Stk$[4], "dpi") THEN
            metric$ = "dpi"
            GUIMetric$ = "dpi"
         END IF

         IF iMatchWrd(Stk$[4],"icon") AND Stk$[6] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[6] + "));"
         ELSEIF iMatchWrd(Stk$[6],"icon") AND Stk$[8] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[8] + "));"
         ELSE
            GUIIcon$ = " LoadIcon(NULL,IDI_WINLOGO);"
         END IF

         Use_BCX_SetMetric = Use_BCX_InitGUI = Use_BCX_RegWnd = TRUE
         EmitWinGUIMain(classname$, metric$, GUIIcon$)

         IF sWord$ = "mdigui" THEN
            Use_Mdigui = TRUE
            CALL EmitMDI_MsgPump
            CALL EmitMDICode(Outfile)
         ELSE
            CALL EmitGUI_MsgPump
         END IF ' sWord$ = "mdigui"

      END IF

      CALL AddGUIGlobals
      IF NOT Use_BCX_Class_Info THEN
         Use_BCX_Class_Info = TRUE
         iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eClassName)
      END IF


      CASE "insertmenu"  'HELPER
      DIM RAW L_Comma
      L_Comma = 0
      FPRINT Outfile, Scoot$, "InsertMenu";

      FOR INT A = 2 TO Ndx
         IF Stk$[A] = "," THEN INCR L_Comma
         IF Stk$[A] = "," THEN
            IF L_Comma = 3 THEN
               Stk$[A] = ",(UINT_PTR)"
            END IF
         END IF
         FPRINT Outfile, Clean$(Stk$[A]);
      NEXT
      FPRINT Outfile, ";"


      CASE "bcx_set_edit_color"  'These statements must appear in the EVENTS LOOP
      Use_SetColor = Use_Proto = TRUE

      IF Stk$[2] = "(" THEN
         LShiftStk(2)
         DECR Ndx
      END IF

      GTmpStr$ = ""

      DIM RAW iii
      FOR iii = 2 TO Ndx
         IF Stk$[iii] = "," THEN EXIT FOR
         CONCAT(GTmpStr$,Stk$[iii])
      NEXT

      FPRINT Outfile, Scoot$, "if((HWND)lParam=="; GTmpStr$ ;" && Msg==WM_CTLCOLOREDIT)"
      FPRINT Outfile, Scoot$, "return Set_Color(" ;
      Stk$[++Ndx] = ",(HDC)(UINT_PTR)wParam,(HWND)lParam);"
      CALL WriteCleanTokens(iii+1,Ndx)

      CASE "bcx_set_font"

      Use_SetFont = TRUE
      Use_Proto = TRUE

      IF Stk$[2] = "(" THEN
         LShiftStk(2)
         DECR Ndx
      END IF

      FPRINT Outfile, Scoot$, "SendMessage(";
      DIM RAW i
      i = 2

      DO
         FPRINT Outfile, Clean$(Stk$[i]);
         INCR i
         IF Stk$[i] = "," THEN EXIT DO

         IF i > Ndx THEN
            CALL Abort ("Malformed BCX_SET_FONT")
         END IF

      LOOP

      INCR i
      FPRINT Outfile, ",(UINT_PTR)WM_SETFONT," ;
      FPRINT Outfile, "(WPARAM)BCX_Set_Font(" ;
      Stk$[++Ndx] = "),1);"
      CALL WriteCleanTokens(i,Ndx)

      CASE "bcx_set_label_color" ' These statements must appear in the EVENTS LOOP

      Use_SetColor = Use_Proto = TRUE

      IF Stk$[2] = "(" THEN
         LShiftStk(2)
         DECR Ndx
      END IF

      GTmpStr$ = ""
      DIM RAW i
      FOR i = 2 TO Ndx
         IF Stk$[i] = "," THEN EXIT FOR
         CONCAT(GTmpStr$,Stk$[i])
      NEXT

      FPRINT Outfile, Scoot$, "if((HWND)lParam=="; GTmpStr$ ;" && Msg==WM_CTLCOLORSTATIC)"
      FPRINT Outfile, Scoot$, "return Set_Color(" ;
      Stk$[++Ndx] = ",(HDC)(UINT_PTR)wParam,(HWND)lParam);"
      CALL WriteCleanTokens(i+1,Ndx)

      CASE "msgbox"          ' MsgBox Msg$,Title$,button
      DIM RAW i, j, k
      j = 0
      k = 0

      FOR i = 2 TO Ndx
         IF Stk$[i] = "[" THEN
            INCR j
         ELSEIF Stk$[i] = "]" THEN
            DECR j
         ELSEIF Stk$[i] = "(" THEN
            INCR j
         ELSEIF Stk$[i] = ")" THEN
            DECR j
         END IF
         IF j = 0 AND Stk$[i] = "," THEN INCR k
      NEXT

      IF k = 0 THEN
         INCR Ndx
         Stk$[Ndx]= ","
         INCR Ndx
         Stk$[Ndx]= DDQ$
         k = 1
      END IF

      IF k = 1 THEN
         INCR Ndx
         Stk$[Ndx]= ","
         INCR Ndx
         Stk$[Ndx]= "0"
      END IF

      FPRINT Outfile, Scoot$, "MessageBox (GetActiveWindow(),";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)

      CASE "~vscroll"
      Use_Vscroll = IVAL (Stk$[2])
      IF Use_Vscroll = 0 THEN Use_Vscroll = TRUE

      CASE "~hscroll"
      Use_Hscroll = IVAL (Stk$[2])
      IF Use_Hscroll = 0 THEN Use_Hscroll = TRUE

   END SELECT

   FUNCTION = 0
END FUNCTION ' Emit_GUIProcs



FUNCTION Emit_FileIO(sWord$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(FuncRetnFlag)
   SELECT CASE sWord$

      CASE "close"               'CLOSE handle
      IF Ndx = 1 THEN
         FPRINT Outfile, Scoot$, "_fcloseall();"
         EXIT SELECT
      END IF

      IF DataType(Stk$[2]) = vt_NUMBER THEN
         Stk$[2]= "FP" + Stk$[2]
      END IF

      IF Stk$[2] = "(" THEN  LShiftStk(2) : DECR Ndx ' 7.63  Eliminate superflous ()

      DIM RAW i
      IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
         IF CheckGlobal(Stk$[2], &i) = vt_UNKNOWN THEN
            CALL AddGlobal(Stk$[2], vt_FILEPTR)
         END IF
      END IF

      szFileHandle$ = ""
      FOR INT j = 2 TO Ndx
         CONCAT(szFileHandle$, Stk$[j])
      NEXT

      IF UseFileTest THEN
         FPRINT Outfile, Scoot$, "if(",szFileHandle$,")"
         FPRINT Outfile, Scoot$, " {"
         FPRINT Outfile, Scoot$, "   fclose(";szFileHandle$;");"
         FPRINT Outfile, Scoot$, "   ";szFileHandle$;"=NULL;"
         FPRINT Outfile, Scoot$, " }"
      ELSE
         FPRINT Outfile, Scoot$, "fclose(";szFileHandle$;");"
      END IF

      '*************************************************************************
      CASE "open"    'OPEN filename$ FOR INPUT | OUTPUT | APPEND AS handle
      '*************************************************************************
      DIM RAW Keyword$, LTmp$, Op$, HaveFOR, HaveAS

      HaveFOR = FALSE
      HaveAS = FALSE
      Op$ = ""
      FOR INT iA = 1 TO Ndx
         Keyword$ = LCASE$(Stk$[iA])

         SELECT CASE Keyword$
            CASE "open"
            Stk$[iA] = ""

            CASE "for"
            Stk$[iA] = ""
            CALL BuildCleanStr(2, iA-1, Filnam$)
            HaveFOR = TRUE

            CASE "as"
            Stk$[iA] = ""
            IF DataType(Stk$[iA + 1]) = vt_NUMBER THEN
               Stk$[iA + 1] = "FP" + Stk$[iA + 1]
            END IF
            HaveAS = TRUE

            DIM RAW i
            IF CheckLocal(Stk$[iA + 1], &i) = vt_UNKNOWN THEN
               IF CheckGlobal(Stk$[iA + 1], &i) = vt_UNKNOWN THEN
                  CALL AddGlobal(Stk$[iA + 1], vt_FILEPTR)
               END IF
            END IF

            Var$ = ""
            FOR INT j = iA+1 TO Ndx
               IF iMatchWrd(Stk$[j], "reclen") THEN EXIT FOR
               CONCAT (Var$,Stk$[j])
               Stk$[j] = ""
            NEXT
            szFileHandle$ = Var$ + "@"

            CASE "input"
            Op$ = ENC$("r")
            Stk$[iA] = ""

            CASE "output"
            Op$ = ENC$("w")
            Stk$[iA] = ""

            CASE "append"
            Op$ = ENC$("a")
            Stk$[iA] = ""

            CASE "binary"
            Op$ = ENC$("rb+")
            Stk$[iA] = ""

            CASE "binaryappend"
            Op$ = ENC$("ab+")
            Stk$[iA] = ""

            CASE "binarynew"
            Op$ = ENC$("wb+")
            Stk$[iA] = ""

            CASE "binaryinput"
            Op$ = ENC$("rb")
            Stk$[iA] = ""

            CASE "binaryoutput"
            Op$ = ENC$("rb+")
            Stk$[iA] = ""

            CASE "reclen"
            IF Stk$[iA+1] = "=" THEN
               FOR INT j = iA+2 TO Ndx
                  Stk$[j-1] = Stk$[j]
               NEXT
               DECR Ndx
            END IF

            Var$ = EXTRACT$(Clean$(szFileHandle$), "[") + "len"

            DIM RAW i, j, LZZ$

            IF CheckLocal(Var$, &i) = vt_UNKNOWN THEN
               CALL AddGlobal(Var$, vt_INTEGER)
            ELSE
               IF CheckLocal(Var$, &i) = vt_UNKNOWN THEN
                  CALL AddLocal(Var$, vt_INTEGER)
                  Var$ = "int " + Var$
               END IF
            END IF

            i = CheckType(Stk$[iA+1])
            LZZ$ = LCASE$(Stk$[iA+1])
            j = FindWord(LZZ$, tTypes, WordsInTable(tTypes))
            IF i = vt_STRUCT OR i = vt_UNION OR j = vt_BOOL OR j = vt_BYTE OR _
               j = vt_CHAR OR j = vt_COLORREF OR j = vt_DOUBLE OR j = vt_DWORD OR _
               j = vt_SINGLE OR j = vt_INTEGER OR j = vt_LDOUBLE OR j = vt_LLONG OR _
               j = vt_LONG OR j = vt_SHORT OR j = vt_UINT OR j = vt_ULONG OR _
               j = vt_ULONGLONG OR j = vt_USHORT OR j = vt_VARIANT OR j = vt_WINBOOL THEN
               FPRINT Outfile, Scoot$, Var$;" = sizeof(";Stk$[iA+1];");"
            ELSE
               FPRINT Outfile, Scoot$, Var$;" = ";Clean$(Stk$[iA+1]);";"
            END IF
            Stk$[iA] = ""
            Stk$[iA + 1] = ""
         END SELECT
      NEXT

      IF ISNULL(Op$)    THEN CALL Abort("Syntax Error: Missing FOR in OPEN statement")
      IF IDont(HaveFOR) THEN CALL Abort("Syntax Error: Missing FOR in OPEN statement")
      IF IDont(HaveAS)  THEN CALL Abort("Syntax Error: Missing AS  in OPEN statement")

      IF UseFileTest THEN
         FPRINT Outfile, Scoot$, "if((";Clean$(szFileHandle$);"=fopen(";Filnam$;",";Op$;"))==0)"
         FPRINT Outfile, Scoot$, " {"
         LTmp$ = ENC$("Can't open file %s\\n")
         FPRINT Outfile, Scoot$, "fprintf(stderr,";LTmp$;",";Filnam$;");exit(1);"
         FPRINT Outfile, Scoot$, " }"
      ELSE
         FPRINT Outfile, Scoot$, Clean$(szFileHandle$);"=fopen(";Filnam$;",";Op$;");"
      END IF

      '*************************************************************************
      ' Statement  RECORD [#] filenumber,recordnumber [,location in record]
      ' Definition:          Position the file pointer anywhere in a file.
      ' filenumber           Filenumber from  1 to 99
      ' record number        RECORD number to point to. Default first record
      ' location in record   Optional location in RECORD. Default is Zero
      ' RECORD fp1, 6[, 10]
      '*************************************************************************

      CASE "record"

      DIM LOCAL numargs
      DIM RAW ffp AS functionParse : memset (&ffp,0,SIZEOF(functionParse))  ' MrBcx 789

      IF DataType(Stk$[2]) = vt_NUMBER THEN
         Stk$[2]= "FP" + Stk$[2]
      END IF

      IF Ndx > 1 THEN numargs = SepFuncArgs(1, &ffp, FALSE)
      IF numargs < 1 THEN Abort("Missing required arguments to RECORD")
      IF numargs > 4 THEN Abort("Too many arguments to RECORD")

      IF numargs = 3 THEN
         FPRINT Outfile, Scoot$, "_fseeki64 (",GetArg$(1,&ffp),",(",GetArg$(2,&ffp),"-1)*",Stk$[2],"len+",GetArg$(3, &ffp),",SEEK_SET);"
      ELSEIF numargs = 2 THEN
         FPRINT Outfile, Scoot$, "_fseeki64 (",GetArg$(1,&ffp),",(",GetArg$(2,&ffp),"-1)*",Stk$[2],"len,SEEK_SET);"
      ELSE
         FPRINT Outfile, Scoot$, "_fseeki64 (",GetArg$(1,&ffp),",0,SEEK_SET);"
      END IF
   END SELECT

   FUNCTION = 0
END FUNCTION ' Emit_FileIO



FUNCTION Emit_FileManagementProcs(sWord$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(FuncRetnFlag)
   SELECT CASE sWord$

      CASE "copyfile"
      FPRINT Outfile, Scoot$, "CopyFile (";
      DIM RAW szUS$
      szUS$ = UCASE$(Stk$[Ndx])
      SELECT CASE Stk$[Ndx]

         CASE "1", "0"
         Stk$[++Ndx] = ");"
         CASE "TRUE", "FALSE"
         IF UseCpp THEN
            Stk$[Ndx] = LCASE$(Stk$[Ndx]) + ");"
         ELSE
            Stk$[Ndx] = szUS$ + ");"
         END IF

         CASE ELSE
         IF UseCpp THEN
            Stk$[++Ndx] = ",false);"
         ELSE
            Stk$[++Ndx] = ",FALSE);"
         END IF
      END SELECT
      CALL WriteCleanTokens(2,Ndx)


      '***********************
      CASE "kill"
      '***********************
      FPRINT Outfile, Scoot$, "DeleteFile (";
      IF Ndx >= 2 AND Stk$[2] <> "(" THEN
         CALL InsertOptionalParens(2)
      END IF
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)

      '***********************
      CASE "rename"
      '***********************
      FPRINT Outfile, Scoot$, "MoveFile (";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_FileManagementProcs




FUNCTION Emit_FileIOProcs(sWord$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(FuncRetnFlag)
   DIM RAW L_Handle$
   DIM RAW Var1$
   DIM RAW Var2$
   DIM RAW CVar$

   SELECT CASE sWord$
      '*************************************************************************************************
      CASE "lineinput"                           ' LINEINPUT fp1,A$        <<< File version
      '                                          ' LINEINPUT "prompt", A$  <<< Keyboard version 4.21
      '*************************************************************************************************
      DIM RAW i = DataType(Stk$[2])              ' Test for keyboard version of LINE INPUT
      '*************************************************************************************************
      IF i = vt_STRLIT OR i = vt_STRVAR THEN
         IF i <> vt_STRLIT THEN Stk$[2] = Clean$(Stk$[2])
         DIM RAW sC_Stk3$
         sC_Stk3$ = Clean$(Stk$[3])
         '****************************************  7.54 LINE INPUT allows static and dynamic strings
         Use_LineinputKB = Use_SysMacros = TRUE
         FPRINT Outfile, Scoot$, "mLineInputKB (", Stk$[2], ", " , sC_Stk3$, ");"
         EXIT SELECT
      END IF

      '**************************************************************************************************
      '                        Okay, we're dealing with the file form of LINE INPUT
      '**************************************************************************************************

      Use_NamePathFromFP = Use_BcxTmpStr = TRUE               ' MrBcx - 786  Requested by Robert Wishlaw

      REMOVE "#" FROM Stk$[2]

      IF IsNumber(Stk$[2]) = vt_NUMBER THEN
         Stk$[2]= "FP" + Stk$[2]
      END IF

      L_Handle$ = EXTRACT$(Stk$[2], "[")

      IF CheckLocal(L_Handle$, &i) = vt_UNKNOWN THEN
         IF CheckGlobal(L_Handle$, &i) = vt_UNKNOWN THEN
            CALL AddGlobal(L_Handle$, vt_FILEPTR)
         END IF
      END IF

      Var1$ = Clean$(Stk$[3])
      Var2$ = ""
      CVar$ = Var1$

      '********************************************************************
      DIM Optional_Limit$ = ""
      Optional_Limit$ = MID$ (Var1$, INSTRREV(Var1$,","))
      REMOVE Optional_Limit$ from Var1$
      REMOVE Optional_Limit$ from CVar$
      Optional_Limit$ = MID$(Optional_Limit$,2)
      '********************************************************************

      IF INCHR(Var1$, "[") AND INCHR(Var1$, "]") THEN
         IF iMatchNQ(Var1$, "[++") THEN
            REMOVE "++" from CVar$
         END IF
         IF iMatchNQ(Var1$, "[--") THEN
            REMOVE "--" from CVar$
         END IF
         IF iMatchNQ(Var1$, "++]") THEN
            REMOVE "++" from CVar$
            Var2$ = MID$(Var1$,INCHR(Var1$,"[")+1)
            Var2$ = EXTRACT$(Var2$,"]")
            Var1$ = CVar$
         END IF
         IF iMatchNQ(Var1$, "--]") THEN
            REMOVE "--" from CVar$
            Var2$ = MID$(Var1$,INCHR(Var1$,"[")+1)
            Var2$ = EXTRACT$(Var2$,"]")
            Var1$ = CVar$
         END IF
      END IF

      FPRINT Outfile, Scoot$, Var1$ ; "[0]=0;"
      '*******************************************************************************
      REMOVE "--" FROM Var1$   '773 MrBcx - without this, a receiving array variable
      REMOVE "++" FROM Var1$   '773 MrBcx - index is twice incremented or decremented
      '*******************************************************************************

      IF Optional_Limit$ > "" THEN
         FPRINT Outfile, Scoot$, "fgets(" ; Var1$ ; ",";Optional_Limit$ ;","; Clean$(Stk$[2]) ; ");"
      ELSE
         FPRINT Outfile, Scoot$, "fgets(" ; Var1$ ; ",";BCXSTRSIZE;","; Clean$(Stk$[2]) ; ");"
      END IF

      FPRINT Outfile, Scoot$,"  if(feof(", Clean$(Stk$[2]), ") || (", Var1$, "[strlen(", Var1$, ")-1]==10))"
      FPRINT Outfile, Scoot$,"    {"
      FPRINT Outfile, Scoot$,"     ", Var1$, "[strcspn(", Var1$, "," , ENC$("\\r\\n"), ")] = 0;"
      FPRINT Outfile, Scoot$,"    }"
      FPRINT Outfile, Scoot$,"   else"
      FPRINT Outfile, Scoot$,"    {"
      FPRINT Outfile, Scoot$,"      printf(", ENC$("%s%d while reading file: %s\\n"), "," , _
      ENC$("Error! - LINE INPUT truncation detected at PROGRAM line: "), ",__LINE__-7, NamePathFromFP("; Clean$(Stk$[2]); "));"
      FPRINT Outfile, Scoot$,"      printf(", ENC$("%s\\n"), ",", ENC$("The actual truncated line of text:"), ");"
      FPRINT Outfile, Scoot$,"      printf(", ENC$("%s"), ",", Var1$, ");"
      FPRINT Outfile, Scoot$,"      exit(1);"
      FPRINT Outfile, Scoot$,"    }"

      IF Var2$ <> "" THEN
         FPRINT Outfile, Var2$; ";"
      END IF
      '*******************************************************************************
      CASE "finput"
      '*******************************************************************************
      CALL EmitFileInputCode
      EXIT FUNCTION
      '*******************************************************************************
      CASE "~get"
      '*******************************************************************************
      DIM RAW i
      Use_Get = TRUE
      Use_SysMacros = TRUE
      IF DataType(Stk$[2])= vt_NUMBER THEN
         Stk$[2]= "FP" + Stk$[2]
      END IF
      IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
         IF CheckGlobal(Stk$[2], &i) = vt_UNKNOWN THEN
            CALL AddGlobal(Stk$[2], vt_FILEPTR)
         END IF
      END IF
      FPRINT Outfile, Scoot$, "GET(";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)
      EXIT FUNCTION
      '*******************************************************************************
      CASE "~put"
      '*******************************************************************************
      DIM RAW i
      Use_Put = TRUE
      Use_SysMacros = TRUE
      IF DataType(Stk$[2]) = vt_NUMBER THEN
         Stk$[2]= "FP" + Stk$[2]
      END IF
      IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
         IF CheckGlobal(Stk$[2], &i) = vt_UNKNOWN THEN
            CALL AddGlobal(Stk$[2], vt_FILEPTR)
         END IF
      END IF
      FPRINT Outfile, Scoot$, "PUT(";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)
      EXIT FUNCTION
      '*******************************************************************************
      CASE "seek"
      '*******************************************************************************
      DIM RAW i
      IF DataType(Stk$[2])= vt_NUMBER THEN
         Stk$[2]= "FP" + Stk$[2]
      END IF
      IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
         CALL AddGlobal(Stk$[2], vt_FILEPTR)
      END IF
      FPRINT Outfile, Scoot$, "_fseeki64 (";
      Stk$[++Ndx] = ",0);"
      CALL WriteCleanTokens(2,Ndx)
      EXIT FUNCTION
      '*******************************************************************************
      CASE "seteof"
      '*******************************************************************************
      Use_Proto = Use_Seteof = TRUE
      DIM RAW i
      IF Stk$[2] = "(" THEN Stk$[2] = Stk$[3] ' Allow SETEOF (FP1) -and-  SETEOF FP1
      IF DataType(Stk$[2])= vt_NUMBER THEN
         Stk$[2]= "FP" + Stk$[2]
      END IF
      IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
         CALL AddGlobal(Stk$[2], vt_FILEPTR)
      END IF
      FPRINT Outfile, Scoot$, "SetEof("; Stk$[2]; ");"
      EXIT FUNCTION
      '*******************************************************************************
      CASE "fprint"
      '*******************************************************************************
      DIM STATIC i
      DIM STATIC LZZ$
      DIM STATIC j
      IF IsNumber(Stk$[2]) THEN
         Stk$[2] = "FP" + Stk$[2]
      END IF
      IF iMatchWrd(Stk$[2], "stderr") THEN
         L_Handle$ = "stderr"
      ELSE
         IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
            IF CheckGlobal(Stk$[2], &i) = vt_UNKNOWN THEN
               CALL AddGlobal(Stk$[2], vt_FILEPTR)
            END IF
         END IF
         L_Handle$ = ""
         FOR j = 2 TO Ndx
            IF *Stk$[j] = ASC(",") OR *Stk$[j] = ASC(";") THEN
               Stk$[j] = ""
               EXIT FOR
            END IF
            CONCAT(L_Handle$, Stk$[j])
            Stk$[j] = ""
         NEXT i
         CONCAT(L_Handle$, "@")
      END IF
      Stk$[2] = ""  'get rid of handle
      Stk$[3] = ""  'get rid of the Comma
      LZZ$ = "f" + PrintWriteFormat$(0)
      LZZ$ = LEFT$(LZZ$,8) + REMOVE$(L_Handle$,"@") + "," + MID$(LZZ$,9)
      FPRINT Outfile, Scoot$, LZZ$
      EXIT FUNCTION
      '*******************************************************************************
      CASE "fwrite"    'write handle,{list}
      '*******************************************************************************
      DIM RAW LZZ$
      DIM RAW i
      IF DataType(Stk$[2]) = vt_NUMBER THEN
         Stk$[2] = "FP" + Stk$[2]
      END IF
      IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
         CALL AddGlobal(Stk$[2], vt_FILEPTR)
      END IF
      L_Handle$ = ""
      FOR INT j = 2 TO Ndx
         IF iMatchWrd(Stk$[j], ",") OR iMatchWrd(Stk$[j], ";") THEN
            Stk$[j] = ""              'get rid of the Comma
            EXIT FOR
         END IF
         CONCAT(L_Handle$, Stk$[j])
         Stk$[j] = ""                 'get rid of handle
      NEXT j
      CONCAT(L_Handle$, "@")
      LZZ$ = "f" + PrintWriteFormat$(1)
      LZZ$ = LEFT$(LZZ$,8)  +  Clean$(L_Handle$)  +  ","  +  MID$(LZZ$,9)
      FPRINT Outfile, Scoot$, LZZ$
      EXIT FUNCTION
      '*******************************************************************************
      CASE ELSE
      '*******************************************************************************
      CALL EmitOld(FuncRetnFlag)
   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_FileIOProcs



FUNCTION Emit_StringProcs(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "midstr"    ' alias for MID$ statement (not the MID$ function)
      Src$ = ""
      FOR INT A = 1 TO Ndx
         CONCAT(Src$,Clean$(Stk$[A]))
      NEXT
      FPRINT Outfile, Scoot$, TRIM$(Src$), ";"

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_StringProcs



FUNCTION Emit_MathProcs(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "incr"
      DIM j
      FPRINT Outfile, Scoot$;          ' <<--- Scoot$; to suppress CRLF
      FOR INT i = 2 TO Ndx
         IF *Stk$[i] = ASC(",") THEN
            FPRINT Outfile, "+=(";
            j = TRUE
         ELSE
            FPRINT Outfile, Clean$(Stk$[i]);
         END IF
      NEXT
      FPRINT Outfile, IIF$(j,");","++;")

      CASE "decr"
      DIM j
      FPRINT Outfile, Scoot$;          ' <<--- Scoot$; to suppress CRLF
      FOR INT i = 2 TO Ndx
         IF *Stk$[i] = ASC(",") THEN
            FPRINT Outfile, "-=(";
            j = TRUE
         ELSE
            FPRINT Outfile, Clean$(Stk$[i]);
         END IF
      NEXT
      FPRINT Outfile, IIF$(j,");","--;")

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)
   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_MathProcs



FUNCTION Emit_ConsoleOnlyProcs(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "print"
      FPRINT Outfile, Scoot$, PrintWriteFormat$(0)

      CASE "locate"
      IF NoMain = TRUE OR MakeDLL = TRUE THEN
         Use_Console = TRUE
      END IF

      FPRINT Outfile, Scoot$, "locate (";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)

      CASE "panel"
      IF NoMain = TRUE OR MakeDLL = TRUE THEN
         Use_Console = TRUE
      END IF

      FPRINT Outfile, Scoot$, "panel (";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)

      CASE "cls"
      IF NoMain = TRUE OR MakeDLL = TRUE THEN
         Use_Console = TRUE
      END IF

      FPRINT Outfile, Scoot$, "cls();"

      CASE "color"
      IF NoMain = TRUE OR MakeDLL = TRUE THEN
         Use_Console = TRUE
      END IF

      FPRINT Outfile, Scoot$, "color (";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)

      CASE "textmode"
      DIM RAW LTmp$
      CALL BuildCleanStr(2, Ndx, LTmp$)                 ' Allow size to be an expression
      FPRINT Outfile, Scoot$, "TextMode(";LTmp$;");"

      CASE "delay"
      DIM RAW LTmp$
      CALL BuildCleanStr(2, Ndx, LTmp$)                 ' Allow size to be an expression
      FPRINT Outfile, Scoot$, "Sleep(1000*";LTmp$;");"

      CASE "write"
      FPRINT Outfile, Scoot$, PrintWriteFormat$(1)

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)
   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_ConsoleOnlyProcs




FUNCTION ValidExitStatement
   DIM RightTerm$
   RightTerm$ = LCASE$(Stk$[2])
   SELECT CASE RightTerm$
      CASE "sub","function","for","xfor","do","while","select","nest","loop","repeat"
      FUNCTION = TRUE
   END SELECT
   FUNCTION = FALSE
END FUNCTION






FUNCTION Emit_ControlFlow(sWord$, FuncRetnFlag AS PINT)
   DIM STATIC iFallThrough AS INT

   SELECT CASE sWord$

      CASE "exit"
      IF ValidExitStatement() = FALSE THEN
         CALL Abort("Expected to find EXIT: sub|function|for|xfor|do|while|select|nest|loop|repeat")
      END IF

      IF SelectState[StateIdx].CaseFlag THEN SelectState[StateIdx].NoBreak = TRUE

      DIM szL_Stk2$
      DIM iLoops1
      DIM iLoops2

      FOR iLoops1 = 2 TO Ndx
         IF *Stk$[iLoops1] = ASC(",") THEN ITERATE
         szL_Stk2$ = LCASE$(Stk$[iLoops1])

         SELECT CASE szL_Stk2$
            CASE "sub"
            IF COM_lc_names_index > 0 THEN         ' cleaning local COM objects if user forgot to
               CALL BCX_FreeLocalCOMObjects(FALSE)  ' call xxx = Nothing for each declared object
            END IF
            IF NOTZERO (LocalDynaCnt) THEN  ' Clean up dynamic strings
               FOR INT j = 1 TO LocalDynaCnt
                  FPRINT Outfile, Scoot$, DynaStr$[j]
               NEXT
            END IF
            IF NOTZERO (LocalDynArrCnt) THEN   ' Clean up dynamic strings arrays
               FOR INT i = 1 TO LocalDynArrCnt
                  FPRINT Outfile, Scoot$, LocalDynArrName$[i]
               NEXT
            END IF
            FPRINT Outfile, Scoot$, "return;"


            CASE "function"
            IF NOTZERO(LocalDynaCnt) THEN ' Clean up dynamic strings
               FOR INT j = 1 TO LocalDynaCnt
                  FPRINT Outfile, Scoot$, DynaStr$[j]
               NEXT
            END IF
            IF NOTZERO(LocalDynArrCnt) THEN ' Clean up dynamic strings arrays
               FOR INT i = 1 TO LocalDynArrCnt
                  FPRINT Outfile, Scoot$, LocalDynArrName$[i]
               NEXT
            END IF
            FPRINT Outfile, Scoot$, "return 0;"


            CASE "for"
            DIM STATIC LszTmp$
            DIM STATIC i

            XFOR i = LoopTypeCnt-iLoops2 _
               UNTIL LoopType[i].iLoopType = lt_FORNEXT OR i = 0 BY i--
            XNEXT

            IF i THEN
               IF i <> LoopTypeCnt-iLoops2 THEN
                  IF TestState THEN CALL WarningID(eExitingMoreThan1Loop, 1)
               END IF
               iLoops2 = LoopTypeCnt - i + 1
               IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
            ELSE
               LszTmp$ = "No FOR to exit from. Inner most loop is "
               CONCAT(LszTmp$, LoopTypeName$(LoopType[LoopTypeCnt].iLoopType))
               CALL Abort(LszTmp$)
            END IF

            CASE "xfor"
            DIM STATIC LszTmp$
            DIM STATIC i

            XFOR i = LoopTypeCnt-iLoops2 _
               UNTIL LoopType[i].iLoopType = lt_FORXNEXT OR i = 0 BY i--
            XNEXT

            IF i THEN
               IF i <> LoopTypeCnt-iLoops2 THEN
                  IF TestState THEN CALL WarningID(eExitingMoreThan1Loop, 1)
               END IF
               iLoops2 = LoopTypeCnt - i + 1
               IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
            ELSE
               LszTmp$ = "No XFOR to exit from. Inner most loop is "
               CONCAT(LszTmp$, LoopTypeName$(LoopType[LoopTypeCnt].iLoopType))
               CALL Abort(LszTmp$)
            END IF

            CASE "do"
            DIM STATIC LszTmp$
            DIM STATIC i

            XFOR i = LoopTypeCnt-iLoops2 _
               UNTIL LoopType[i].iLoopType = lt_DOLOOP OR _
               LoopType[i].iLoopType = lt_DOUNTILLOOP  OR _
               LoopType[i].iLoopType = lt_DOWHILELOOP  OR i = 0 BY i--
            XNEXT

            IF i THEN
               IF i <> LoopTypeCnt-iLoops2 THEN
                  IF TestState THEN CALL WarningID(eExitingMoreThan1Loop, 1)
               END IF
               iLoops2 = LoopTypeCnt - i + 1
               IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
            ELSE
               LszTmp$ = "No DO to exit from. Inner most loop is "
               CONCAT(LszTmp$, LoopTypeName$(LoopType[LoopTypeCnt].iLoopType))
               CALL Abort(LszTmp$)
            END IF

            CASE "while"
            DIM STATIC LszTmp$
            DIM STATIC i

            XFOR i = LoopTypeCnt-iLoops2 _
               UNTIL LoopType[i].iLoopType = lt_WHILEWEND OR i = 0 BY i--
            XNEXT

            IF i THEN
               IF i <> LoopTypeCnt-iLoops2 THEN
                  IF TestState THEN CALL WarningID(eExitingMoreThan1Loop, 1)
               END IF
               iLoops2 = LoopTypeCnt - i + 1
               IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
            ELSE
               LszTmp$ = "No WHILE to exit from. Inner most loop is "
               CONCAT(LszTmp$, LoopTypeName$(LoopType[LoopTypeCnt].iLoopType))
               CALL Abort(LszTmp$)
            END IF

            CASE "select"
            DIM STATIC LszTmp$
            DIM STATIC i

            XFOR i = LoopTypeCnt-iLoops2 _
               UNTIL LoopType[i].iLoopType = lt_SELECT OR i = 0 BY i--
            XNEXT

            IF i THEN
               IF i <> LoopTypeCnt-iLoops2 THEN
                  IF TestState THEN CALL WarningID(eExitingMoreThan1Loop, 1)
               END IF
               iLoops2 = LoopTypeCnt - i + 1
               IF iLoops1 = Ndx THEN CALL DoGoto(i, 1) : SelectState[StateIdx].CaseFlag++
            ELSE
               LszTmp$ = "No SELECT to exit from. Inner most loop is "
               CONCAT(LszTmp$,LoopTypeName$(LoopType[LoopTypeCnt].iLoopType))
               CALL Abort(LszTmp$)
            END IF

            CASE "nest"
            DIM STATIC LszTmp$
            DIM STATIC i
            IF LoopTypeCnt = 0 THEN
               CALL Abort("Too many end loops")
            END IF

            XFOR i = LoopTypeCnt-iLoops2 _
               UNTIL LoopType[i].iLoopType <> LoopType[LoopTypeCnt-iLoops2].iLoopType BY i--
            XNEXT

            LszTmp$ = "Exiting from nested control loops. Outer to inner control loops are "
            CONCAT (LszTmp$, LoopTypeName$(LoopType[LoopTypeCnt].iLoopType))

            IF TestState THEN CALL Warning(LszTmp$, 1)
            INCR i
            iLoops2 = LoopTypeCnt - i + 1
            IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)

            CASE ELSE
            DIM STATIC LszTmp$
            LszTmp$ = "Exiting from a misnamed or unnamed control loop.  Expected: EXIT "
            CONCAT(LszTmp$, LoopTypeName$(LoopType[LoopTypeCnt].iLoopType))

            IF TestState THEN CALL Warning(LszTmp$, 1)
            IF iLoops1 = Ndx THEN CALL DoGoto(LoopTypeCnt-iLoops2, 1)
            INCR iLoops2
         END SELECT
      NEXT

      CASE "repeat"
      DIM LTmp$

      FOR INT i = 2 TO Ndx
         CONCAT(LTmp$, Stk$[i])
      NEXT
      LTmp$ = Clean$(LTmp$)
      CALL BumpUp
      IF INCHR(Stk$[2],"-") THEN
         IF LEFTSTR(LTmp$,"-") THEN LTmp$ = MID$(LTmp$,2)
         FPRINT Outfile, Scoot$, "{int BCX_REPEAT;"
         FPRINT Outfile, Scoot$, "for(BCX_REPEAT=";LTmp$;";BCX_REPEAT>=1;BCX_REPEAT--)"
         FPRINT Outfile, Scoot$, "{"
      ELSE
         FPRINT Outfile, Scoot$, "{int BCX_REPEAT;"
         FPRINT Outfile, Scoot$, "for(BCX_REPEAT=1;BCX_REPEAT<=";LTmp$;";BCX_REPEAT++)"
         FPRINT Outfile, Scoot$, "{"
      END IF
      CALL BumpUp

      CASE "endrepeat"
      CALL BumpDown("Too many unindents in REPEAT/END REPEAT")
      FPRINT Outfile, Scoot$, "}"
      FPRINT Outfile, Scoot$, "}"
      CALL BumpDown("Too many unindents in REPEAT/END REPEAT")

      CASE "while"
      CALL EmitIfCond("while", eFull)
      IF iDoWhile THEN
         LoopType[++LoopTypeCnt].iLoopType = iDoWhile
      ELSE
         LoopType[++LoopTypeCnt].iLoopType = lt_WHILEWEND
      END IF
      LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
      LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
      iDoWhile = 0
      LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
      CALL InBlockSet

      CASE "wend", "endwhile"
      CALL InBlockReSet
      IF LoopTypeCnt = 0 THEN
         CALL Abort("Too many end loops")
      END IF
      IF LoopType[LoopTypeCnt].iLoopType <> lt_WHILEWEND THEN
         DIM RAW sErr$
         sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with WEND"
         CALL Abort(sErr$)
      END IF
      CALL BumpDown("Error in Emit_ControlFlow() CASE wend, endwhile")
      FPRINT Outfile, Scoot$, "}"
      IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
         FPRINT Outfile, LoopType[LoopTypeCnt].szUseNeedLabel$
      END IF
      DECR LoopTypeCnt
      CALL BumpDown("Unbalanced LOOP")

      CASE "prepend"
      MACRO cPrependVarSize = 8
      GLOBAL PrependVar$[cPrependVarSize]
      GLOBAL PrependCnt
      INCR PrependCnt

      IF PrependCnt = cPrependVarSize THEN
         CALL Abort("Prepend depth exceeded")
      END IF

      CALL BuildDelimStr(2, Ndx, PrependVar$[PrependCnt])

      CASE "endprepend"
      DECR PrependCnt

      IF PrependCnt < 0 THEN
         CALL Abort("Too many END PREPENDs.")
      END IF

      CASE "with"
      MACRO cWithVarSize = 8
      GLOBAL WithVar$[cWithVarSize]
      GLOBAL WithCnt

      INCR WithCnt

      IF WithCnt = cWithVarSize THEN
         CALL Abort("[With] depth exceeded")
      END IF

      CALL BuildStr(2, Ndx, WithVar$[WithCnt])

      CASE "endwith"
      IF COM_open_WITH_statement THEN
         IF COM_open_WITH_statement > 1 THEN
            FPRINT Outfile, Scoot$, "COM_dispatch_storage_index--;"
            FPRINT Outfile, Scoot$, "COM_dispatch_at_offset = COM_dispatch_storage[COM_dispatch_storage_index];"
         ELSE
            FPRINT Outfile, Scoot$, "COM_dispatch_at_offset = 0;"
            FPRINT Outfile, Scoot$, "COM_dispatch_storage_index = 0;"
         END IF
         FPRINT Outfile, Scoot$, "COM_reset_disp_chain(&";COM_with_temp_str_name$;");"
         DECR COM_open_WITH_statement
      ELSE
         DECR WithCnt
      END IF

      CASE "goto"
      IF SelectState[StateIdx].CaseFlag THEN SelectState[StateIdx].NoBreak = TRUE
      FPRINT Outfile, Scoot$, "goto ";UCASE$(Stk$[2]);";"

      CASE "gosub"
      Use_GoSub = TRUE
      FPRINT Outfile, Scoot$, "if (setjmp(GosubStack[GosubNdx++])==0)";
      FPRINT Outfile, " goto ";UCASE$(Stk$[2]);";"

      CASE "return"
      Use_GoSub = TRUE
      FPRINT Outfile, Scoot$, "longjmp (GosubStack [--GosubNdx],1 );"
      FPRINT Outfile, ""

      CASE "fallthrough"
      iFallThrough = TRUE

      CASE "case"
      IF SelectState[StateIdx].iStartCase = 0 THEN
         CALL InBlockReSet
      END IF
      SelectState[StateIdx].iStartCase = 0
      CALL InBlockSet
      FOR INT i = 2 TO Ndx
         IF  Stk$[i] = "!=" THEN Stk$[i]   = "<>"
         IF *Stk$[i] = ASC("%")  THEN Stk$[i]   = " % "
         IF *Stk$[i] = ASC("!")  AND  *Stk$[i+1] = ASC("=") THEN Stk$[i] = "<>" : Stk$[i+1] = ""
         IF *Stk$[i] = ASC("<")  AND  *Stk$[i+1] = ASC(">") THEN Stk$[i] = "<>" : Stk$[i+1] = ""
         IF *Stk$[i] = ASC("=")  AND  *Stk$[i+1] = ASC("<") THEN Stk$[i] = "<=" : Stk$[i+1] = ""
         IF *Stk$[i] = ASC("<")  AND  *Stk$[i+1] = ASC("=") THEN Stk$[i] = "<=" : Stk$[i+1] = ""
         IF *Stk$[i] = ASC("=")  AND  *Stk$[i+1] = ASC(">") THEN Stk$[i] = ">=" : Stk$[i+1] = ""
         IF *Stk$[i] = ASC(">")  AND  *Stk$[i+1] = ASC("=") THEN Stk$[i] = ">=" : Stk$[i+1] = ""
         IF isalpha(*Stk$[i]) THEN
            CONCAT(Stk$[i],SPC$)
         END IF
      NEXT

      GTmpStr$ = ""
      Test = FALSE

      IF DataType(CaseVar$) = vt_STRVAR THEN Test = TRUE

      '************************************************************************************
      ' 766 MrBcx added the following to allow "Var AS STRING" in SELECT CASE statements
      '***********************************************************************************
      DIM ss,idx
      IF CheckLocal  (CaseVar$,&idx) = vt_CHAR   THEN ss = TRUE
      IF CheckGlobal (CaseVar$,&idx) = vt_CHAR   THEN ss = TRUE
      IF CheckLocal  (CaseVar$,&idx) = vt_STRVAR THEN ss = TRUE
      IF CheckGlobal (CaseVar$,&idx) = vt_STRVAR THEN ss = TRUE
      IF ss = TRUE THEN CONCAT(CaseVar$,"$")
      '************************************************************************************

      DIM i
      FOR INT A = 2 TO Ndx
         IF INCHR("([",Stk$[A]) THEN INCR i
         IF INCHR(")]",Stk$[A]) THEN DECR i
         IF i THEN
            CONCAT(GTmpStr$, Stk$[A])
            ITERATE
         END IF

         IF Stk$[A] = "," THEN   ' comma
            IF NOT INCHR("<>=",Stk$[A+1]) THEN
               GTmpStr$ = GTmpStr$ + " or " + CaseVar$ + "="
            ELSE
               GTmpStr$ = GTmpStr$ + " or " + CaseVar$
            END IF
            Stk$[A] = ""
            ITERATE
         END IF

         IF Stk$[A] = "&&" THEN
            GTmpStr$ = GTmpStr$ + " and " + CaseVar$
            Stk$[A]= ""
         ELSEIF Stk$[A] = "||" THEN
            GTmpStr$ = GTmpStr$ + " or "  + CaseVar$
            Stk$[A]= ""
         ELSE
            CONCAT(GTmpStr$, Stk$[A])
         END IF
      NEXT
      DIM szDrop$
      IF SelectState[StateIdx].CaseFlag = 0 THEN SelectState[StateIdx].NoBreak = 0
      IF SelectState[StateIdx].CaseFlag THEN
         DIM LszTmp$
         IF iFallThrough = FALSE THEN
            SelectState[StateIdx].CaseFlag--
            IF SelectState[StateIdx].NoBreak = 0 THEN
               IF SelectState[StateIdx].NoBreak = 0 THEN
                  SelectState[StateIdx].CaseFlag++
                  sprintf(LszTmp, "goto L%i;",SelectState[StateIdx].iJumpTo)
                  FPRINT Outfile, Scoot$, LszTmp$
               END IF
            END IF
         ELSE
            sprintf(szDrop,"L%i",LabelGenerator)
            sprintf(LszTmp, "goto L%i;",LabelGenerator++)
            CONCAT(szDrop$,":")
            FPRINT Outfile, Scoot$, LszTmp$
            SelectState[StateIdx].CaseFlag--
         END IF
         CALL BumpDown("Unbalanced SELECT")
         FPRINT Outfile, Scoot$, "}"
         CALL BumpDown("Unbalanced SELECT")
      END IF

      SelectState[StateIdx].CaseFlag++

      IF iMatchLft(CaseVar$," BAND ") THEN
         SelectState[StateIdx].NoBreak = 1
         Src$ = "IF " + GTmpStr$ + CaseVar$ + " Then "
      ELSE
         IF INCHR("<>=",GTmpStr$) AND NOT IsQuoted(GTmpStr$) THEN
            Src$ = "IF " + CaseVar$ + GTmpStr$ + " Then "
         ELSE
            Src$ = "IF " + CaseVar$ + " = " + GTmpStr$ + " Then "
         END IF
      END IF

      INJECT(Src$)
      IF iFallThrough THEN INJECT(szDrop$)
      iFallThrough = FALSE

      CASE "select"
      LoopType[++LoopTypeCnt].iLoopType = lt_SELECT
      LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
      CALL DoGoto(LoopTypeCnt, 0)
      LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
      CALL BuildStr(3, Ndx, CaseVar$)
      CALL PushSelectState(CaseVar$)
      SelectState[StateIdx].iStartCase = 1
      SelectState[StateIdx].CaseFlag = 0
      SelectState[StateIdx].iJumpTo = LoopType[LoopTypeCnt].iJumpTo
      iFallThrough = FALSE

      CASE "caseelse"
      IF SelectState[StateIdx].iStartCase = 0 THEN
         CALL InBlockReSet
      END IF

      CALL InBlockSet
      SelectState[StateIdx].iStartCase = 0
      SelectState[StateIdx].CaseElseFlag = TRUE
      IF SelectState[StateIdx].CaseFlag THEN
         CALL BumpDown("Unbalanced SELECT")
         FPRINT Outfile, Scoot$, "}"
         CALL BumpDown("Unbalanced SELECT")
         FPRINT Outfile, Scoot$, "else"
         CALL BumpUp
         FPRINT Outfile, Scoot$, "{"
         CALL BumpUp
      END IF

      CASE "endselect"
      IF SelectState[StateIdx].iStartCase = 0 THEN
         CALL InBlockReSet
      END IF

      IF LoopTypeCnt = 0 THEN
         Abort("Too many end loops")
      END IF

      IF LoopType[LoopTypeCnt--].iLoopType <> lt_SELECT THEN
         DIM STATIC sErr$

         sErr$ = LoopTypeName$(LoopType[LoopTypeCnt+1].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt+1].iLoopLine) + " closed with END SELECT"
         Abort(sErr$)
      END IF

      IF SelectState[StateIdx].CaseFlag = 0 THEN
         IF SelectState[StateIdx].CaseElseFlag = 0 THEN
            CALL Abort("Missing case statement before select end")
         ELSE
            CALL Abort("Missing case statement before case else")
         END IF
      END IF

      CALL BumpDown("Unbalanced SELECT")
      FPRINT Outfile, Scoot$, "}"
      CALL BumpDown("Unbalanced SELECT")

      IF SelectState[StateIdx].CaseFlag > 1 THEN
         DIM STATIC LszTmp$
         sprintf(LszTmp, "L%i:;", SelectState[StateIdx].iJumpTo)
         FPRINT Outfile, LszTmp$
      END IF

      SelectState[StateIdx].NoBreak = SelectState[StateIdx].CaseElseFlag = 0
      CALL PopSelectState(CaseVar$)

      CASE "for"
      IF iMatchWrd(Stk$[2], "each") THEN  ' "each" becomes reserved keyword
         ' beginning of for each - collections support
         DIM RAW foreachlocal$
         DIM RAW temp_parms$
         DIM RAW ComVar$

         ComVar$ = Stk$[3]
         Use_COM_Collections = Use_COM = ComSwitchON = TRUE
         FPRINT Outfile, Scoot$, " VariantClear(&COM_ack_var);"
         FPRINT Outfile, Scoot$, " COM_enum_var = NULL;"
         FPRINT Outfile, Scoot$, " COM_long_coll = 0;"
         IF NOT IsVariableComObject(ComVar$) THEN FPRINT Outfile, Scoot$, "OBJECT ", ComVar$, ";"
         FPRINT Outfile, Scoot$, "ZeroMemory((PVOID)&", ComVar$, ",sizeof(OBJECT));"
         LoopLocalVar[LoopLocalCnt++] = 0
         COM_FOREACH_enumerator = TRUE
         foreachlocal$ = MID$(Src$, INSTR(Src$, " in ", 1, 1) + 3)
         IF NOT IsVariableComObject(ComVar$) THEN Add_COM_Local_Variable(ComVar$)

         IF INCHR(foreachlocal$, ".") THEN
            BCX_COM_Parse_GetProperty("COM_ack_var", foreachlocal$)
            temp_parms$ = TRIM$(EXTRACT$(foreachlocal$, "."))
         ELSE
            temp_parms$ = TRIM$(foreachlocal$)
         END IF

         COM_FOREACH_enumerator = FALSE

         FPRINT Outfile, Scoot$, "COM_GetEnum_iface = TRUE;"
         FPRINT Outfile, Scoot$, "COM_invoke(&", temp_parms$,", L", DDQ$, ","
         FPRINT Outfile, Scoot$, "DISPATCH_PROPERTYGET|DISPATCH_METHOD, &COM_ack_var);"
         FPRINT Outfile, Scoot$, "COM_reset_disp_chain(&", temp_parms$ , ");"
         FPRINT Outfile, Scoot$, "COM_GetEnum_iface = FALSE;\n"

         FPRINT Outfile, Scoot$,"for(;;) { // for each construction ..."
         CALL BumpUp
         FPRINT Outfile, Scoot$, "if (FAILED(COM_last_HR)) {"
         FPRINT Outfile, Scoot$, "  COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Get object enumerator: No Collections!"),"));"
         FPRINT Outfile, Scoot$, "  break;"
         FPRINT Outfile, Scoot$, "} "

         FPRINT Outfile, Scoot$, "if (COM_ack_var.vt != VT_DISPATCH && COM_ack_var.vt != VT_UNKNOWN) {"
         FPRINT Outfile, Scoot$, "  COM_last_HR = E_NOINTERFACE;"
         FPRINT Outfile, Scoot$, "  COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Enum interface not available! Collections unavailable!"),"));"
         FPRINT Outfile, Scoot$, "  VariantClear(&COM_ack_var);"
         FPRINT Outfile, Scoot$, "  break;"
         FPRINT Outfile, Scoot$, "} "

         FPRINT Outfile, Scoot$, "if (COM_ack_var.vt == VT_DISPATCH) {"

         CALL BumpUp

         FPRINT Outfile, Scoot$, "  #ifdef __cplusplus"
         FPRINT Outfile, Scoot$, "  COM_last_HR = COM_ack_var.pdispVal"
         FPRINT Outfile, Scoot$, "  ->QueryInterface(IID_IEnumVARIANT, (void **)&COM_enum_var);"
         FPRINT Outfile, Scoot$, "  #else"
         FPRINT Outfile, Scoot$, "   COM_last_HR = COM_ack_var.pdispVal->lpVtbl"
         FPRINT Outfile, Scoot$, "   ->QueryInterface(COM_ack_var.pdispVal,"
         FPRINT Outfile, Scoot$, "   &IID_IEnumVARIANT, (void **)&COM_enum_var);"
         FPRINT Outfile, Scoot$, "#endif\n"
         FPRINT Outfile, Scoot$, "if (FAILED(COM_last_HR)) {"
         FPRINT Outfile, Scoot$, "   COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface: Get enum variant: No Collections!"),"));"
         FPRINT Outfile, Scoot$, "   VariantClear(&COM_ack_var);"
         FPRINT Outfile, Scoot$, "   break;"
         FPRINT Outfile, Scoot$, "} "

         CALL BumpDown("")

         FPRINT Outfile, Scoot$, "} else if (COM_ack_var.vt == VT_UNKNOWN) {"

         CALL BumpUp

         FPRINT Outfile, Scoot$, "  #ifdef __cplusplus"
         FPRINT Outfile, Scoot$, "    COM_last_HR = COM_ack_var.punkVal"
         FPRINT Outfile, Scoot$,"     ->QueryInterface(IID_IEnumVARIANT, (void **)&COM_enum_var);"
         FPRINT Outfile, Scoot$, "  #else"
         FPRINT Outfile, Scoot$, "    COM_last_HR = COM_ack_var.punkVal->lpVtbl"
         FPRINT Outfile, Scoot$, "    ->QueryInterface(COM_ack_var.punkVal, "
         FPRINT Outfile, Scoot$, "    &IID_IEnumVARIANT, (void **)&COM_enum_var);"
         FPRINT Outfile, Scoot$, "#endif\n"
         FPRINT Outfile, Scoot$, "if (FAILED(COM_last_HR)) {"
         FPRINT Outfile, Scoot$, "  COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface: Get enum variant: No Collections!"),"));"
         FPRINT Outfile, Scoot$, "  VariantClear(&COM_ack_var);"
         FPRINT Outfile, Scoot$, "  break;"
         FPRINT Outfile, Scoot$, "} "

         CALL BumpDown("")

         FPRINT Outfile, Scoot$, "} "
         FPRINT Outfile, Scoot$, "VariantClear(&COM_ack_var);"
         FPRINT Outfile, Scoot$, "break;"
         FPRINT Outfile, Scoot$, "}\n"

         FPRINT Outfile, Scoot$, "  while(COM_enum_var) {"
         FPRINT Outfile, Scoot$, "    BCX_SetNothing(&";ComVar$;");"
         FPRINT Outfile, Scoot$, "    #ifdef __cplusplus"
         FPRINT Outfile, Scoot$, "      COM_last_HR = COM_enum_var"
         FPRINT Outfile, Scoot$, "     ->Next(1, &";ComVar$;".pObjects[0], &COM_long_coll);"
         FPRINT Outfile, Scoot$, "    #else"
         FPRINT Outfile, Scoot$, "      COM_last_HR = COM_enum_var->lpVtbl"
         FPRINT Outfile, Scoot$, "     ->Next(COM_enum_var, 1, &";ComVar$;".pObjects[0], &COM_long_coll);"
         FPRINT Outfile, Scoot$, "    #endif"
         FPRINT Outfile, Scoot$, "    if (FAILED(COM_last_HR)) {"
         FPRINT Outfile, Scoot$, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Enumeration failed! No Collections!"),"));"
         FPRINT Outfile, Scoot$, "    #ifdef __cplusplus"
         FPRINT Outfile, Scoot$, "       if(COM_enum_var) COM_enum_var->Release();"
         FPRINT Outfile, Scoot$, "    #else"
         FPRINT Outfile, Scoot$, "       if(COM_enum_var) COM_enum_var->lpVtbl"
         FPRINT Outfile, Scoot$, "       ->Release(COM_enum_var);"
         FPRINT Outfile, Scoot$, "    #endif"
         FPRINT Outfile, Scoot$, "    COM_enum_var = NULL;"
         FPRINT Outfile, Scoot$, "    break;"
         FPRINT Outfile, Scoot$, "  } "

         FPRINT Outfile, Scoot$, "  if (";ComVar$;".pObjects[0].vt != VT_DISPATCH)"
         FPRINT Outfile, Scoot$, "    {"
         FPRINT Outfile, Scoot$, "      VariantClear(&";ComVar$;".pObjects[0]);"
         FPRINT Outfile, Scoot$, "      COM_long_coll = 0;"
         FPRINT Outfile, Scoot$, "    }"
         FPRINT Outfile, Scoot$, "  else"
         FPRINT Outfile, Scoot$, "    { "
         FPRINT Outfile, Scoot$, "      ", ComVar$, ".pStatus = TRUE;"
         FPRINT Outfile, Scoot$, "      ", ComVar$, ".ipointer = 0;"
         FPRINT Outfile, Scoot$, "      COM_objects_cnt++;"
         FPRINT Outfile, Scoot$, "    }"

         FPRINT Outfile, Scoot$, "  if (0 == COM_long_coll) {"
         FPRINT Outfile, Scoot$, "  #ifdef __cplusplus"
         FPRINT Outfile, Scoot$, "     if(COM_enum_var) COM_enum_var->Release();"
         FPRINT Outfile, Scoot$, "  #else"
         FPRINT Outfile, Scoot$, "     if(COM_enum_var) COM_enum_var->lpVtbl"
         FPRINT Outfile, Scoot$, "     ->Release(COM_enum_var);"
         FPRINT Outfile, Scoot$, "  #endif"
         FPRINT Outfile, Scoot$, "  BCX_SetNothing(&"; ComVar$; ");"
         FPRINT Outfile, Scoot$, "  COM_enum_var = NULL;"
         FPRINT Outfile, Scoot$, "  break;"
         FPRINT Outfile, Scoot$, "  }"
         CALL BumpUp

      ELSE ' this is a "Normal" For - Next Loop

         DIM FFlg
         DIM For1
         DIM For2
         DIM For3
         DIM For4
         DIM Reg$
         DIM xxx$
         DIM yyy$
         DIM zzz$
         DIM qqq$

         '******************************************************
         FOR INT i = Ndx TO 1 STEP -1
            IF iMatchWrd(Stk$[i],"step") THEN
               FFlg = TRUE
               EXIT FOR
            END IF
         NEXT

         IF NOT FFlg THEN
            INCR Ndx
            Stk$[Ndx] = "step"
            INCR Ndx
            Stk$[Ndx] = "1"
         END IF
         '******************************************************
         Test = FALSE

         FOR INT i = 1 TO Ndx
            IF *Stk$[i] = ASC("=") THEN Test = TRUE
         NEXT

         IF Test = FALSE THEN Abort("Missing =")
         '******************************************************
         Test = FALSE

         FOR INT i = 1 TO Ndx
            IF iMatchWrd(Stk$[i],"to") THEN Test = TRUE
         NEXT

         IF Test = FALSE THEN Abort("Missing TO")
         '******************************************************

         Reg$ = LCASE$(Stk$[2])

         SELECT CASE Reg$
            CASE "int","fint"
            Reg$ = SPC$
            LoopLocalVar[LoopLocalCnt++] = 1
            FPRINT Outfile, Scoot$, "  {int ";

            CASE "long"
            Reg$ = SPC$
            LoopLocalVar[LoopLocalCnt++] = 1
            FPRINT Outfile, Scoot$, "  {long ";

            CASE "single", "float"
            Reg$ = SPC$
            LoopLocalVar[LoopLocalCnt++] = 1
            FPRINT Outfile, Scoot$, "  {float ";

            CASE "size_t"
            Reg$ = SPC$
            LoopLocalVar[LoopLocalCnt++] = 1
            FPRINT Outfile, Scoot$, "  {size_t ";

            CASE "double"
            Reg$ = SPC$
            LoopLocalVar[LoopLocalCnt++] = 1
            FPRINT Outfile, Scoot$, "  {double ";

            CASE "ldouble"
            Reg$ = SPC$
            LoopLocalVar[LoopLocalCnt++] = 1
            FPRINT Outfile, Scoot$, "  {LDOUBLE ";

            CASE ELSE
            Reg$ = ""
            LoopLocalVar[LoopLocalCnt++] = 0
         END SELECT

         IF *Reg$ THEN
            FOR INT j = 3 TO Ndx
               Stk$[j-1] = Stk$[j]
            NEXT
            DECR Ndx
         END IF

         '******************************************************
         ' Every statement now conforms to the following:
         ' FOR xxx = yyy TO zzz STEP qqq
         '******************************************************

         FOR INT i = 2 TO Ndx
            IF Stk$[i] = "=" THEN
               For1 = i-1       'xxx spans from Stk$[2] to Stk$[For1]
               EXIT FOR
            END IF
         NEXT

         FOR INT i = For1 + 2 TO Ndx
            IF iMatchWrd(Stk$[i],"to") THEN
               For2 = i-1       'yyy spans from Stk$[For1+2] to Stk$[For2]
               EXIT FOR
            END IF
         NEXT

         FOR INT i = For2 + 2 TO Ndx
            IF iMatchWrd(Stk$[i],"step") THEN
               For3 = i-1       'zzz spans from Stk$[For2+2] to Stk$[For3]
               EXIT FOR
            END IF
         NEXT

         For4 = For3 + 2        'qqq spans from Stk$[For4] to Stk$[Ndx]

         CALL BuildCleanStr(2, For1, xxx$)
         CALL BuildCleanStr(For1+2, For2, yyy$)
         CALL BuildCleanStr(For2+2, For3, zzz$)
         CALL BuildCleanStr(For4, Ndx, qqq$)

         IF Reg$ = SPC$ THEN FPRINT Outfile, xxx$, ";"
         Reg$ = ""

         IF IsNumberEx (qqq$) THEN
            IF LEFTSTR(qqq$,"-") THEN
               FPRINT Outfile, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; ", xxx$, ">=" , zzz$, "; " , xxx$, "+=" , qqq$, ")"
            ELSE
               FPRINT Outfile, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; ", xxx$, "<=" , zzz$, "; " , xxx$, "+=" , qqq$, ")"
            END IF
         ELSE
            FPRINT Outfile, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; (", qqq$, ">=0 ? ", xxx$, "<=" , zzz$, " : ", xxx$, ">=", zzz$, "); " , xxx$, "+=" , qqq$, ")"
         END IF

         CALL BumpUp
         FPRINT Outfile, Scoot$, "{"
         CALL BumpUp
      END IF

      LoopType[++LoopTypeCnt].iLoopType = lt_FORNEXT
      LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
      LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
      LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]

      CALL InBlockSet

      CASE "next"
      CALL InBlockReSet

      IF LoopTypeCnt = 0 THEN
         CALL Abort("Too many end loops")
      END IF

      IF LoopType[LoopTypeCnt].iLoopType <> lt_FORNEXT THEN
         DIM RAW sErr$
         sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with NEXT"
         CALL Abort(sErr$)
      END IF

      CALL BumpDown("Unbalanced FOR/NEXT")
      FPRINT Outfile, Scoot$, "}"
      IF LoopLocalVar[--LoopLocalCnt] THEN FPRINT Outfile, Scoot$, "}"

      IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
         FPRINT Outfile, LoopType[LoopTypeCnt].szUseNeedLabel$
      END IF

      DECR LoopTypeCnt
      IF LoopLocalCnt < 0 THEN Abort ("Next without For")
      CALL BumpDown("Unbalanced FOR/NEXT")

      CASE "beginblock"
      CALL InBlockSet
      FPRINT Outfile, Scoot$, "{"
      CALL BumpUp

      CASE "endblock"
      CALL InBlockReSet
      CALL BumpDown("Unbalanced BLOCK/END BLOCK")
      FPRINT Outfile, Scoot$, "}"

      CASE "call"
      DIM STATIC LTmp$
      BuildCleanStr(2, Ndx, LTmp$)
      IF NOT iMatchRgt(LTmp$,")") THEN
         CONCAT(LTmp$,  "()")
      END IF
      CONCAT(LTmp$, ";")
      FPRINT Outfile, Scoot$, LTmp$

      CASE "continue"
      FPRINT Outfile, Scoot$, "continue;"

      CASE "end"
      IF Ndx = 1 THEN
         InsertTokens(1,2,"=","0")
      END IF

      IF Stk$[2] = "=" THEN
         IF Use_Wingui = FALSE THEN
            FPRINT Outfile, Scoot$, "fflush(stdout);"
         END IF
         FPRINT Outfile, Scoot$, "ExitProcess(";
         Stk$[++Ndx] = ");"
         CALL WriteCleanTokens(3,Ndx)
         EXIT SELECT
      END IF

      IF iMatchWrd(Stk$[2],"if") THEN
         CALL BumpDown("Unbalanced IF/END IF")
         FPRINT Outfile, Scoot$, "}"
         CALL BumpDown("Unbalanced IF/END IF")
         EXIT SELECT
      END IF

      CASE "endif"
      CALL BumpDown("Extra unindents at ENDIF")
      FPRINT Outfile, Scoot$, "}"
      CALL BumpDown("Extra unindents at ENDIF")

      CASE "endprogram"               'Force END of main- allow inclusions outside of main
      FPRINT Outfile, ""
      FPRINT Outfile, "return EXIT_SUCCESS;    // End of main program"
      FPRINT Outfile, "}\n\n"
      EndOfProgram = 1

      CASE "if"
      CALL EmitIfCond("if", eFull)

      CASE "else"
      CALL BumpDown("Unbalanced IF/END IF")
      FPRINT Outfile, Scoot$, "}"
      CALL BumpDown("Unbalanced IF/END IF")
      FPRINT Outfile, Scoot$, "else"
      CALL BumpUp
      FPRINT Outfile, Scoot$, "{"
      CALL BumpUp

      CASE "elseif"
      CALL BumpDown("Unbalanced IF/END IF")
      FPRINT Outfile, Scoot$, "}"
      CALL BumpDown("Unbalanced IF/END IF")
      CALL EmitIfCond("else if", eFull)

      CASE "xfor"    ' XFOR ... WHILE/UNTIL ... BY ...
      DIM iBy
      DIM iUntil
      DIM iWhile
      DIM STATIC Ndx2
      DIM STATIC iPB
      DIM STATIC iLast
      DIM STATIC Stak$[128]
      DIM STATIC sClose$
      DIM STATIC lszType$

      ' Basic syntax check
      FOR INT ii = 2 TO Ndx
         IF iMatchWrd(Stk$[ii],"while") THEN iWhile = ii
         IF iMatchWrd(Stk$[ii],"until") THEN iUntil = ii
         IF iMatchWrd(Stk$[ii],"by") THEN iBy = ii
      NEXT

      IF iWhile = 0 AND iUntil = 0 THEN CALL Abort("Missing WHILE or UNTIL in XFOR")
      IF iWhile AND iUntil THEN CALL Abort("Can't have both WHILE and UNTIL in XFOR")
      IF iBy = 0 THEN CALL Abort("Missing BY in XFOR")

      iLast = iWhile + iUntil
      lszType$ = ""
      IF iLast > 2 THEN   ' Have initializers
         DIM RAW i = 2
         DIM RAW j = 3
         DO
            DO WHILE Stk$[j] <> "="
               INCR j
            LOOP
            IF j - i > 1 THEN
               IF lszType$ <> "" THEN CONCAT(lszType$, ": RAW ")
               CONCAT(lszType$, Stk$[j-1])
               CONCAT(lszType$, " AS")
               DO WHILE i < j-1
                  CONCAT(lszType$, SPC$)
                  CONCAT(lszType$, Stk$[i])
                  Stk$[i++] = ""
               LOOP
            END IF
            i = j + 1

            iPB = 0
            DO WHILE i <= iLast
               IF *Stk$[i] = ASC("(") THEN INCR iPB
               IF *Stk$[i] = ASC(")") THEN DECR iPB
               IF *Stk$[i] = ASC("[") THEN INCR iPB
               IF *Stk$[i] = ASC("]") THEN DECR iPB
               IF iPB = 0 AND Stk$[i] = "," THEN EXIT DO
               INCR i
            LOOP
            INCR i
            j = i + 1
         LOOP UNTIL i >= iLast
      END IF
      Stak$[1] = "for("
      sClose$ = ";"

      DIM RAW jj = 2
      DIM RAW ii = 2

      DO WHILE ii <= Ndx
         IF Stk$[ii] <> "" THEN
            IF iMatchWrd(Stk$[ii],"while") THEN Stk$[ii] = ";" : iLast = jj
            IF iMatchWrd(Stk$[ii],"until") THEN Stk$[ii] = ";!(" : sClose$ = ");" : iLast = jj
            IF iMatchWrd(Stk$[ii],"by")    THEN Stk$[ii] = sClose$ : iBy = jj
            Stak$[jj] = Stk$[ii]
            INCR jj
         END IF
         INCR ii
      LOOP
      Ndx2 = jj-1
      IF NOTNULL(lszType$) THEN
         CALL BumpUp
         FPRINT Outfile, Scoot$, "{"
         CALL InBlockSet
         lszType$ = "RAW " + lszType$
         LoopLocalVar[LoopLocalCnt++] = 1
         ii = iMatchNQ (lszType$, ": RAW ")
         DO WHILE ii
            Src$ = LEFT$(lszType$,ii-1)
            lszType$ = MID$(lszType$,ii+2)
            PassOne = TRUE
            INJECT(Src$)
            ii = iMatchNQ (lszType$, ": RAW ")
         LOOP
         Src$ = lszType$
         PassOne = TRUE
         INJECT(Src$)
      ELSE
         LoopLocalVar[LoopLocalCnt++] = 0
      END IF

      Stk$[1] = "while"
      FOR INT k = iLast+1 TO iBy-1
         Stk$[k-iLast+1] = Stak$[k]
      NEXT

      Ndx = iBy-iLast
      Stk$[Ndx+1] = ""

      FPRINT Outfile, Scoot$;         ' <<--- Scoot$; to suppress CRLF
      FOR INT k = 1 TO Ndx2
         IF k <= iLast OR k >= iBy THEN
            FPRINT Outfile, Stak$[k];
         END IF
         IF k = iLast THEN
            CALL EmitIfCond("while", ePart)
         END IF
      NEXT

      FPRINT Outfile, ")"
      CALL BumpUp
      FPRINT Outfile, Scoot$, "{"
      CALL BumpUp
      LoopType[++LoopTypeCnt].iLoopType = lt_FORXNEXT
      LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
      LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
      LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
      CALL InBlockSet

      CASE "xnext"
      CALL InBlockReSet

      IF LoopTypeCnt = 0 THEN
         Abort("Too many end loops")
      END IF

      IF LoopType[LoopTypeCnt].iLoopType <> lt_FORXNEXT THEN
         DIM RAW sErr$
         sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with NEXT"
         Abort(sErr$)
      END IF

      CALL BumpDown("Unbalanced XFOR/XNEXT")
      FPRINT Outfile, Scoot$, "}"

      IF NOTZERO(LoopLocalVar[--LoopLocalCnt]) THEN
         CALL InBlockReSet
         FPRINT Outfile, Scoot$, "}"
         CALL BumpDown("Unbalanced XFOR/XNEXT")
      END IF

      IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
         FPRINT Outfile, LoopType[LoopTypeCnt].szUseNeedLabel$
      END IF

      DECR LoopTypeCnt
      IF LoopLocalCnt < 0 THEN Abort ("XNEXT without XFOR")
      CALL BumpDown("Unbalanced XFOR/XNEXT")

      CASE "do"
      CALL InBlockSet

      IF iDoWhile THEN
         LoopType[++LoopTypeCnt].iLoopType = iDoWhile
      ELSE
         LoopType[++LoopTypeCnt].iLoopType = lt_DOLOOP
      END IF
      LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
      LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
      iDoWhile = 0

      LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
      FPRINT Outfile, Scoot$, "for(;;)"
      CALL BumpUp
      FPRINT Outfile, Scoot$, "{"
      CALL BumpUp

      CASE "loop"
      CALL InBlockReSet

      IF LoopTypeCnt = 0 THEN
         Abort("Too many end loops")
      END IF

      IF iLoopCond THEN
         IF LoopType[LoopTypeCnt].iLoopType <> lt_DOLOOP THEN
            DIM RAW sErr$
            sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with LOOP CONDITION"
            CALL Abort(sErr$)
         END IF
      END IF

      iLoopCond = 0

      CALL BumpDown("Unbalanced DO/LOOP")
      FPRINT Outfile, Scoot$, "}"

      IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
         FPRINT Outfile, LoopType[LoopTypeCnt].szUseNeedLabel$
      END IF

      DECR LoopTypeCnt
      CALL BumpDown("Unbalanced DO/LOOP")

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)
   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_ControlFlow


FUNCTION Emit_KeyboardProcs(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "input"
      CALL EmitInputCode

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_KeyboardProcs



FUNCTION Emit_ArrayProcs(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "qsortidx"          'qsortidx idx, size_of_array, A$, key
      DIM i
      DIM LTmp$, Stptr$, StMem$, StName$
      Use_BcxTmpStr = TRUE
      Var$ = Clean$(Stk$[2])             'index array
      BuildCleanStr(4, Ndx-4, LTmp$)     'allow size to be an expression

      FPRINT Outfile, Scoot$, "Key = ",Stk[Ndx],";"

      IF Var$ <> "0" THEN
         FPRINT Outfile, Scoot$, "int iDx;"
         FPRINT Outfile, Scoot$, "for(iDx=0; iDx<",LTmp$,"; iDx+=1) ";
         FPRINT Outfile, Var$,"[iDx]=iDx;"
      END IF

      IF NOT INCHR(Stk$[Ndx-2],".") THEN   'Check if this is a struct sort
         Use_Idxqsort = Use_Bcx_stricmp = TRUE
         FPRINT Outfile, Scoot$, "pppStr = ",Clean$(Stk[Ndx-2]),";"
         FPRINT Outfile, Scoot$, "qsort(";Var$;",";LTmp$;",sizeof(int),IdxCompare);"
      ELSE
         StMem$ = REMAIN$(Clean$(Stk$[Ndx-2]),".")
         Stptr$ = EXTRACT$(Stk$[Ndx-2],".")

         IF CheckLocal(Stptr,&i) <> vt_UNKNOWN THEN
            StName$ = TypeDefs[LocalVars[i].VarDef].VarName$
         ELSE
            IF CheckGlobal(Stptr,&i) <> vt_UNKNOWN THEN
               StName$ = TypeDefs[GlobalVars[i].VarDef].VarName$
            END IF
         END IF

         IF Var$ <> "0" THEN
            Use_IdxqsortSt = Use_Bcx_stricmp = TRUE
            FPRINT Outfile, Scoot$, "cmp1 =(char*)(",Stptr$ ,") + offsetof(",StName$,",",StMem$,");"
            FPRINT Outfile, Scoot$, "StructSize = sizeof(",StName$,");"
            FPRINT Outfile, Scoot$, "qsort(",Var$;",",LTmp$,",sizeof(int),IdxCompareSt);"
         ELSE
            Use_PtrqsortSt = Use_Bcx_stricmp = TRUE
            FPRINT Outfile, Scoot$, "OffSet = offsetof(",StName$,",",StMem$,");"
            FPRINT Outfile, Scoot$, "qsort(",Stptr$;",",LTmp$,",sizeof(",StName$,"),PtrCompareSt);"
         END IF
      END IF


      CASE "qsort"    'qsort [dynamic] A$,size_of_array[,ascending|descending][,NATURAL]
      DIM RAW QST=0
      DIM RAW order=0
      DIM RAW LTmp$
      DIM RAW vt
      DIM RAW iAlphaNumeric = FALSE

      Use_BcxTmpStr = TRUE

      IF iMatchWrd(Stk$[Ndx], "sensitive") THEN
         Use_Strqsorts = TRUE
         DECR Ndx,2
      END IF

      IF iMatchWrd(Stk$[2],"dynamic") THEN
         QST = TRUE
         LShiftStk(2)
      END IF

      IF iMatchWrd(Stk$[Ndx], "natural") THEN
         iAlphaNumeric = Use_AlphaNumeric = TRUE
         DECR Ndx,2
      END IF

      IF iMatchWrd(Stk$[Ndx],"ascending")  THEN
         order = 2
         DECR Ndx,2
      END IF

      IF iMatchWrd(Stk$[Ndx], "descending") THEN
         order = 1
         DECR Ndx,2
      END IF

      IF order = 0 THEN order = 2      ' default to ascending
      CALL BuildStr(4, Ndx, LTmp$)     ' allow size to be an expression
      Var$ = Clean$(Stk$[2])
      vt = DataType(Stk$[2])

      IF vt <> vt_STRVAR AND vt <> vt_INTEGER AND vt <> vt_SINGLE AND vt <> vt_DOUBLE THEN
         vt = CheckType(Stk$[2])
      END IF

      FPRINT Outfile, Scoot$, "qsort(";Var$;",";Clean$(LTmp$);

      SELECT CASE vt

         CASE vt_STRVAR
         IF NOT QST THEN
            IF order = 1 THEN
               IF iAlphaNumeric THEN
                  FPRINT Outfile, ",sizeof(";Var$;"[0]),AlphaNumericD);"
                  Use_AlphaNumericD = TRUE
               ELSE
                  IF Use_Strqsorts = TRUE THEN
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),StrCompareDs);"
                     Use_Strqsortds = TRUE
                     Use_Strqsorts = FALSE
                  ELSE
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),StrCompareD);"
                     Use_Strqsortd = Use_Bcx_stricmp = TRUE
                  END IF
               END IF
            ELSE
               IF iAlphaNumeric THEN
                  FPRINT Outfile, ",sizeof(";Var$;"[0]),AlphaNumericA);"
                  Use_AlphaNumericA = TRUE
               ELSE
                  IF Use_Strqsorts = TRUE THEN
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),StrCompareAs);"
                     Use_Strqsortas = TRUE
                     Use_Strqsorts = FALSE
                  ELSE
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),StrCompareA);"
                     Use_Strqsorta = Use_Bcx_stricmp = TRUE
                  END IF
               END IF
            END IF
         ELSE
            IF order = 1 THEN
               IF iAlphaNumeric THEN
                  FPRINT Outfile, ",sizeof(";Var$;"[0]),DynAlphaNumericD);"
                  Use_DynAlphaNumericD = TRUE
               ELSE
                  IF Use_Strqsorts = TRUE THEN
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),DynStrCompareDs);"
                     Use_DynStrqsortds = TRUE
                     Use_Strqsorts = FALSE
                  ELSE
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),DynStrCompareD);"
                     Use_DynStrqsortd = Use_Bcx_stricmp = TRUE
                  END IF
               END IF
            ELSE
               IF iAlphaNumeric THEN
                  FPRINT Outfile, ",sizeof(";Var$;"[0]),DynAlphaNumericA);"
                  Use_DynAlphaNumericA = TRUE
               ELSE
                  IF Use_Strqsorts = TRUE THEN
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),DynStrCompareAs);"
                     Use_DynStrqsortas = TRUE
                     Use_Strqsorts = FALSE
                  ELSE
                     FPRINT Outfile, ",sizeof(";Var$;"[0]),DynStrCompareA);"
                     Use_DynStrqsorta = Use_Bcx_stricmp = TRUE
                  END IF
               END IF
            END IF
         END IF

         CASE vt_INTEGER
         IF order = 1 THEN
            FPRINT Outfile, ",sizeof(int),NumCompareDint);"
            Use_Numqsortdint = TRUE
         ELSE
            FPRINT Outfile, ",sizeof(int),NumCompareAint);"
            Use_Numqsortaint = TRUE
         END IF

         CASE vt_SINGLE
         IF order = 1 THEN
            FPRINT Outfile, ",sizeof(float),NumCompareDfloat);"
            Use_Numqsortdfloat = TRUE
         ELSE
            FPRINT Outfile, ",sizeof(float),NumCompareAfloat);"
            Use_Numqsortafloat = TRUE
         END IF

         CASE vt_DOUBLE
         IF order = 1 THEN
            FPRINT Outfile, ",sizeof(double),NumCompareDdouble);"
            Use_Numqsortddouble = TRUE
         ELSE
            FPRINT Outfile, ",sizeof(double),NumCompareAdouble);"
            Use_Numqsortadouble = TRUE
         END IF

         CASE ELSE
         IF order = 1 THEN
            FPRINT Outfile, ",sizeof(int),NumCompareDint);"
            Use_Numqsortdint = TRUE
         ELSE
            FPRINT Outfile, ",sizeof(int),NumCompareAint);"
            Use_Numqsortaint = TRUE
         END IF
      END SELECT

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_ArrayProcs



FUNCTION Emit_template(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$
      CASE "template"
      'template <typename Container, typename ValueType, int nPropType> class property
      DIM RAW LTmp$
      UsingTemplate = TRUE
      CALL BuildDelimStr(1, Ndx, LTmp$)
      FPRINT FP_UDT, LTmp$
      Outfile = FP_UDT

      CASE "endtemplate"
      UsingTemplate = FALSE
   END SELECT
   *FuncRetnFlag = 0
   FUNCTION = 0
END FUNCTION



SUB AddProto(szProto$)
   IF UsingTemplate = FALSE THEN
      INCR ProtoCnt

      IF ProtoCnt = cMAXProtoType THEN
         CALL Abort("Maximum Prototypes Exceeded.")
      END IF

      ProtoType[ProtoCnt].Prototype$ = szProto$
   END IF
END SUB ' AddProto



FUNCTION Emit_OtherProcs(sWord$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(FuncRetnFlag)
   SELECT CASE sWord$

      CASE "extern"

      DIM RAW IsVolatile
      DIM RAW IsSubOrFuncPtr
      DIM RAW CVar$
      DIM RAW IsPointer, id, vt
      DIM RAW L_DimType$

      IsSubOrFuncPtr = SubFuncTest()
      CALL HandleNonsense
      IsVolatile = iMatchWrd(Stk$[2],"volatile")
      CVar$ = Clean$(Stk$[2+IsVolatile])
      CALL ValidVar(CVar$)

      IF Stk$[Ndx] = "*" THEN CALL PointerFix
      IF Stk$[Ndx] = "&" THEN Stk$[Ndx--] = "" : CONCAT(Stk$[Ndx], "&")

      IF Stk$[3+IsVolatile] = "*" THEN

         IF IsVolatile THEN
            CALL Abort("volatile dynamic strings not supported")
         END IF

         CALL DimDynaString(CVar$, 2, 0)
         EXIT SELECT
      END IF

      IF IsSubOrFuncPtr THEN

         IF IsVolatile THEN
            CALL Abort("volatile SUB/FUNCTION pointers not supported")
         END IF

         IF DimSubFunc(0) THEN EXIT SELECT
      END IF

      Var$ = Clean$(Stk$[2+IsVolatile])
      CALL ValidVar(Var$)

      IsPointer = 0
      L_DimType$  = ""

      IF iMatchWrd(Stk$[Ndx-1],"as") THEN
         GetTypeInfo(Stk$[Ndx], &IsPointer, &id, &vt)
         Stk$[Ndx] = REMOVE$(Stk$[Ndx],"*")
         CALL BuildStr(3+IsVolatile, Ndx-2, L_DimType$)
      ELSE
         CALL BuildStr(3+IsVolatile, Ndx, L_DimType$)
         vt = DataType(Stk$[2+IsVolatile])
         id = 0
      END IF

      IF vt = vt_STRVAR THEN
         CONCAT (L_DimType$, "[BCXSTRSIZE]")
      END IF

      IF IsVolatile THEN
         CALL AddGlobal(Var$, vt, id, L_DimType$, IsPointer,0,4)
      ELSE
         CALL AddGlobal(Var$, vt, id, L_DimType$, IsPointer,0,1)
      END IF

      CASE "run"
      FPRINT Outfile, Scoot$, "Run (";
      Stk$[++Ndx] = ");"
      CALL WriteCleanTokens(2,Ndx)

      CASE "shell"
      DIM RAW LZZ$
      CALL BuildDelimStr(2, Ndx, LZZ$)
      IF ISNULL(LZZ$) THEN LZZ$ = DDQ$
      FPRINT Outfile, Scoot$, "system(" ; Clean$(LZZ$) ; ");"

      CASE "redim"
      ' EXAMPLES
      ' REDIM b$ * 14
      ' REDIM PRESERVE b$ * 20
      ' REDIM a$[10]
      ' REDIM PRESERVE a$[20]
      DIM RAW vt1     = 0
      DIM RAW IsSplat = 0
      DIM RAW BC      = 0
      DIM RAW VI AS VarInfo PTR
      DIM RAW vt, id, dms, A, i
      DIM RAW IsPreserve, StartPoint,LastPoint
      DIM RAW CVar$, LZZ$,SOF$

      CALL HandleNonsense

      IsPreserve  = iMatchWrd(Stk$[2], "preserve")
      StartPoint  = 2 + IsPreserve

      vt1     = DataType(Stk$[StartPoint])
      CVar$   = Clean$(Stk$[StartPoint])
      IsSplat = iMatchWrd(Stk$[StartPoint + 1], "*")

      CALL ValidVar(CVar$)

      LastPoint = GetAsPosB(Ndx, 1) - 1
      IF LastPoint < 1 THEN LastPoint = Ndx
      DIM RAW SP = 0

      DO WHILE LastPoint > StartPoint
         IF Stk$[LastPoint] = "[" THEN
            DECR BC
         ELSEIF Stk$[LastPoint] = "]" THEN
            INCR BC
            IF BC = 1 THEN DECR LastPoint : ITERATE
         END IF
         IF BC = 0 THEN
            INCR SP
            IF Stk$[LastPoint-1] <> "]" THEN EXIT DO
            LZZ$ = "," + LZZ$
         ELSE
            LZZ$ = Stk$[LastPoint] + LZZ$
         END IF
         DECR LastPoint
      LOOP

      'get info
      vt = CheckLocal(CVar$, &id)
      IF vt = vt_UNKNOWN THEN
         vt = CheckGlobal(CVar$, &id)
         IF vt = vt_UNKNOWN THEN
            Abort("Can not REDIM " + CVar$ + " not previously dimensioned")
         END IF
         VI = &GlobalVars[id]
      ELSE
         VI = &LocalVars[id]
      END IF
      dms = VI->VarPntr

      IF vt = vt_STRUCT OR vt = vt_UDT OR vt = vt_UNION THEN  'added vt_UNION 4.40

         SOF$ = GetElement$(StartPoint, &vt, &dms, VI->VarDef)

         i = Ndx
         Ndx = LastPoint-1
         CALL AsmUnknownStructs(1)
         Ndx = i
         CALL RemEmptyTokens

         CVar$   = Clean$(Stk$[StartPoint])
         IsSplat = iMatchWrd(Stk$[StartPoint + 1], "*")

      ELSE
         SOF$ = GetVarTypeName$(vt)
      END IF

      IF iMatchWrd(Stk$[Ndx-1], "as") THEN
         IF SOF$ <> Stk$[Ndx] AND NOT iMatchWrd(Stk$[Ndx], "string") THEN
            CALL Abort("Can not change types for variable " + CVar$ + _
            " previously defined as " + SOF$ + " on line" + STR$(VI->VarLine))
         END IF

         IF iMatchWrd(Stk$[Ndx], "string") THEN
            DECR Ndx
            CALL AppendTokens(3, "[", "BCXSTRSIZE", "]")
         ELSE
            DECR Ndx,2
         END IF

      ELSE
         IF (vt = vt_CHAR AND vt1 = vt_STRVAR AND IsSplat = 0) OR vt = vt_CHARPTR THEN
            CALL AppendTokens(3, "[", "BCXSTRSIZE", "]")
         END IF
      END IF

      IF Stk$[3 + IsPreserve] = "[" THEN
         IF IsPreserve THEN
            StartPoint = 4
         ELSE
            FPRINT Outfile, Scoot$, "if (";CVar$ + ") { DestroyArr((void **)";CVar$ + ",";STR$(dms) + ", 1); ";CVar$ + "=NULL; }"
            StartPoint = 3
         END IF

         Use_DynamicA = Use_BcxTmpStr =TRUE
         A = 0
         LZZ$ = ""

         FOR i = StartPoint TO Ndx
            IF *Stk$[i] = ASC("[") THEN
               INCR A
               INCR i
               BC = 1

               DO WHILE BC > 0
                  IF *Stk$[i] = ASC("[") THEN
                     INCR BC
                     CONCAT(LZZ$, Stk$[i])
                  ELSE
                     IF *Stk$[i] = ASC("]") THEN
                        DECR BC
                        IF BC = 0 AND i < Ndx THEN
                           CONCAT(LZZ$, ",")
                        END IF
                        IF BC THEN
                           CONCAT(LZZ$, Stk$[i])
                        END IF
                     ELSE
                        CONCAT(LZZ$, Stk$[i])
                     END IF
                  END IF
                  INCR i
               LOOP
               DECR i
            END IF
         NEXT

         LZZ$ = Clean$(LZZ$)

         IF vt = vt_STRLIT OR vt = vt_DECFUNC OR vt = vt_NUMBER OR (vt = vt_VOID AND INCHR(Stk$[Ndx],"*") = 0) THEN
            CALL Abort(Stk$[Ndx] + " is not a valid type")
         END IF

         IF vt = vt_STRVAR THEN
            SOF$ = "char"
            INCR A
            CONCAT(LZZ$,",")
            CONCAT(LZZ$,"BCXSTRSIZE")
         END IF

         IF A <> dms THEN
            CALL Abort("Mismatch in dimensions for " + CVar$ + ", originally " + STR$(dms) + " found " + STR$(A))
         END IF

         REPLACE "," WITH ", (size_t)" IN LZZ$

         FPRINT Outfile,Scoot$, "{"
         FPRINT Outfile,Scoot$, "size_t dimensions[";TRIM$(STR$(dms));"] = {";"(size_t)";LZZ$;"};"
         FPRINT Outfile,Scoot$, CVar$ ; "= ("; SOF$ ;STRING$(dms,42);")CreateArr ("; CVar$ ; ", sizeof(";SOF$;"), "; STR$(IsPreserve,1);", ";STR$(dms,1);", dimensions);"
         FPRINT Outfile,Scoot$, "}"

         EXIT SELECT
      END IF

      IF Stk$[3]= "*" OR (IsPreserve AND Stk$[4]= "*") THEN       ' DIM MySTRING$ * NumBytes
         IF IsPreserve THEN
            FPRINT Outfile, Scoot$, CVar$ ; "=(char*)realloc(";CVar$;",";
            i = 5
         ELSE
            FPRINT Outfile, Scoot$, "free(" ; CVar$ ; ");"
            FPRINT Outfile, Scoot$, CVar$ ; "=(char*)calloc(";
            i = 4
         END IF

         IF IsPreserve THEN
            Stk$[++Ndx] = ");"
         ELSE
            Stk$[++Ndx] = ",1);"
         END IF

         CALL WriteCleanTokens(i,Ndx)

         EXIT SELECT
      END IF

      CALL Abort("Invalid REDIM statement")

      CASE "data"

      FOR INT A = 2 TO Ndx
         IF INCHR(Stk$[A],DQ$) = 0 AND Stk$[A] <> "," THEN
            Stk$[A] = ENC$(Stk$[A])  ' Allow unquoted text
         END IF
         FPRINT FP_DAT, Stk$[A];
      NEXT

      FPRINT FP_DAT, ""

      CASE "declare"
      DIM RAW TempProto$
      DIM RAW Varcode AS VARCODE
      DIM RAW FP AS functionParse  :  memset (&FP,0,SIZEOF(functionParse))  ' MrBcx 789

      Varcode.IsExported = FALSE
      Varcode.UseInLine = UseInLine
      CALL FuncSubDecs1("sub", 1, Ndx, &Varcode) 'convert [] to pointer * and $[] to [][2048]

      CALL SepFuncArgs(3, &FP, TRUE)
      TempProto$ = MakeDecProto$(&FP)

      IF NOT NoTypeDeclare THEN
         FPRINT FP_UDT, TempProto$, ";"
      ELSE
         CALL AddProto(TempProto$ + ";")
      END IF

      CASE "clear"
      Use_Clear = Use_SysMacros = TRUE

      FPRINT Outfile, Scoot$, "Clear";
      '--------------------------------------------------------------------
      '   IF Stk$[2] <> "(" THEN FPRINT Outfile, "("; : Stk$[++Ndx] = ");"
      '   CALL WriteCleanTokens(2,Ndx)
      '   FPRINT Outfile, ";"
      '--------------------------------------------------------------------
      '                                               MrBcx  7.8.2
      '--------------------------------------------------------------------
      IF Stk$[2] <> "(" THEN  ' Earlier versions output the final ";" late
         FPRINT Outfile, "(";
      END IF

      FOR INT i = 2 TO Ndx
         FPRINT Outfile, Clean$(Stk$[i]);
      NEXT

      IF Stk$[Ndx] <> ")" THEN FPRINT Outfile, ")";
      FPRINT Outfile, ";"

      CASE "const"
      DIM STATIC i
      DIM STATIC Buffer$ :  Buffer$ = ""

      IF InClass THEN
         FOR i = 1 TO Ndx
            IF IsValidName(Stk$[i]) AND IsValidName(Stk$[i+1]) THEN CONCAT(Stk$[i],SPC$)
            CONCAT(Buffer$,Stk$[i])
         NEXT
         FPRINT FP_UDT, Scoot$, Buffer$;";"
      ELSE
         Stk$[1] = ""
         IF Stk$[3] = "(" THEN

            IF cMaxConstMacros = ConstMacroCnt THEN
               CALL Abort("Max Const Macros exceeded.")
            END IF

            ConstMacro$[ConstMacroCnt++] = Stk$[2]
         END IF
         FOR i = 2 TO Ndx
            IF *Stk$[i] = ASC("=") THEN
               INCR i
               EXIT FOR
            ELSE
               IF IsNumber(Stk$[i]) THEN CONCAT(Stk$[1], SPC$)
               CONCAT(Stk$[1], Stk$[i])
            END IF
         NEXT
         Stk$[1] = "#define " + Clean$(Stk$[1]) + SPC$

         FOR i = i TO Ndx
            IF NOT IsQuoted(Stk$[i]) THEN REMOVE "$" FROM Stk$[i]
            IF (IsValidName(Stk$[i]) AND IsValidName(Stk$[i+1])) OR IsNumber(Stk$[i+1]) THEN CONCAT(Stk$[i],SPC$)
            CONCAT(Buffer$,Stk$[i])
         NEXT

         Buffer$ = Stk$[1] + Buffer$
         REPLACE "( " WITH "(" IN Buffer$

         IF InConditional THEN
            IF InFunction THEN
               FPRINT Outfile, Buffer$
            ELSE
               IF ConstLastDef$ <> "FP_CST" THEN
                  FPRINT FP_CST, InIfDef$,"// FP_CST"
                  ConstLastDef$ = "FP_CST"
               END IF
               FPRINT FP_CST, Buffer$
            END IF
         ELSE
            FPRINT FP_CST, Buffer$
         END IF
      END IF

      CASE "auto"
      CALL DimVar(ImAuto)

      CASE "dim"
      CALL DimVar(ImDim)

      CASE "local"
      CALL DimVar(ImLocal)

      CASE "privatedim"
      CALL DimVar(ImCPPPrvDim)

      CASE "raw"
      CALL DimVar(ImRaw)

      CASE "register"
      CALL DimVar(ImRegister)

      CASE "static"
      CALL DimVar(ImStatic)

      CASE "swap"
      DIM RAW VI1 AS VarInfo PTR
      DIM RAW VI2 AS VarInfo PTR
      DIM RAW indx AS INT
      DIM RAW A, i, j

      Use_BcxTmpStr = TRUE
      FPRINT Outfile, Scoot$, "swap ((byte*)&";

      FOR i = 2 TO Ndx
         IF *Stk$[i] = ASC(",") THEN EXIT FOR
         FPRINT Outfile, Clean$(Stk$[i]);
      NEXT

      A = CheckLocal(Stk$[2], &indx)
      IF A = vt_UNKNOWN THEN
         A = CheckGlobal(Stk$[2], &indx)
         IF A = vt_UNKNOWN THEN
            CALL Abort("Variable '" + Stk$[2] + "' in swap statement unknown")
         END IF
         VI1 = &GlobalVars[indx]
      ELSE
         VI1 = &LocalVars[indx]
      END IF

      IF RIGHTSTR (Stk$[i-1],"]") THEN
         IF VI1->VarType = vt_CHAR AND VI1->VarPntr = 1 THEN FPRINT Outfile, "[0]";
      END IF

      FPRINT Outfile, ",(byte*)&";

      INCR i

      FOR j = i TO Ndx
         FPRINT Outfile, Clean$(Stk$[j]);
      NEXT

      A = CheckLocal(Stk$[i], &indx)
      IF A = vt_UNKNOWN THEN
         A = CheckGlobal(Stk$[i], &indx)
         IF A = vt_UNKNOWN THEN
            CALL Abort("Variable '"+Stk$[i] + "' in swap statement unknown")
         END IF
         VI2 = &GlobalVars[indx]
      ELSE
         VI2 = &LocalVars[indx]
      END IF

      IF RIGHTSTR (Stk$[j-1],"]") THEN
         IF VI2->VarType = vt_CHAR AND VI2->VarPntr = 1 THEN FPRINT Outfile, "[0]";
      END IF

      IF VI1->VarType <> VI2->VarType THEN
         Warning("Possible size error in swap statement")
      END IF

      IF VI2->VarType = vt_STRVAR OR VI2->VarType = vt_CHAR THEN
         FPRINT Outfile, ",strlen(";
      ELSE
         FPRINT Outfile, ",sizeof(";
      END IF

      Stk$[++Ndx] = "));"
      CALL WriteCleanTokens(i,Ndx)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_OtherProcs



FUNCTION Emit_PrinterProcs(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "ejectpage"
      FPRINT Outfile, Scoot$,"EjectPage();"

      CASE "printerclose"
      FPRINT Outfile, Scoot$, "PrinterClose();"

      CASE "printeropen"
      IF Ndx = 1 THEN
         FPRINT Outfile, Scoot$, "PrinterOpen();"
      ELSE
         DIM RAW szPrinterParameters$
         CALL BuildStr(2, Ndx, szPrinterParameters$)
         FPRINT Outfile, Scoot$, "PrinterOpen(";szPrinterParameters$;");"
      END IF

      CASE "lprint", "sprint"  'LPRINT & FPRINT  handle,{list}
      DIM RAW IsLprint = FALSE
      DIM RAW IsSprint = FALSE

      IF iMatchWrd(Stk$[1],"lprint") THEN
         Use_Proto = IsLprint = IsSprint = TRUE
         Stk$[1] = "sprint"
         InsertTokens(1, 2, "BcxPtr_Buffer",",")
      END IF

      IF iMatchWrd(Stk$[1],"sprint") THEN
         IsSprint = TRUE
      END IF

      IF IsNumber(Stk$[2]) THEN
         Stk$[2] = "FP" + Stk$[2]
      END IF

      IF IsSprint THEN
         szFileHandle$ = Clean$(Stk$[2])
      ELSE
         IF iMatchWrd(Stk$[2], "stderr") THEN
            szFileHandle$ = "stderr"
         ELSE
            DIM STATIC i
            IF CheckLocal(Stk$[2], &i) = vt_UNKNOWN THEN
               IF CheckGlobal(Stk$[2], &i) = vt_UNKNOWN THEN
                  CALL AddGlobal(Stk$[2], vt_FILEPTR)
               END IF
            END IF

            szFileHandle$ = ""

            FOR INT iii = 2 TO Ndx
               IF *Stk$[iii] = ASC(",") OR *Stk$[iii] = ASC(";") THEN
                  Stk$[iii] = ""
                  EXIT FOR
               END IF
               CONCAT(szFileHandle$, Stk$[iii])
               Stk$[iii] = ""
            NEXT

            CONCAT(szFileHandle$, "@")
         END IF
      END IF

      Stk$[2] = ""  'get rid of handle
      Stk$[3] = ""  'get rid of the Comma

      DIM STATIC LZZ$

      IF IsSprint THEN
         LZZ$ = "s" + PrintWriteFormat$(0)
         REMOVE "\\n" FROM LZZ$
      ELSE
         LZZ$ = "f" + PrintWriteFormat$(0)
      END IF

      LZZ$ = LEFT$(LZZ$,8) + REMOVE$(szFileHandle$,"@") + "," + MID$(LZZ$,9)

      IF IsLprint THEN
         FPRINT Outfile, Scoot$,LZZ$
         FPRINT Outfile, Scoot$,"PrinterWrite(BcxPtr_Buffer);"
         IF NOT Use_Printer THEN
            SrcTmp$ = "printer"
            CALL INJECT (SrcTmp$)   ' Force printer globals declarations
         END IF
      ELSE
         FPRINT Outfile, Scoot$, LZZ$
      END IF

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)
   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_PrinterProcs



FUNCTION Emit_Dynamic(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "dynamic"
      DIM RAW w = 0
      DIM RAW SOF$
      DIM RAW LZZ$
      DIM RAW CVar$
      DIM RAW vt, id, dms

      CALL HandleNonsense
      CVar$ = Clean$(Stk$[2])
      CALL ValidVar(CVar$)

      IF Stk$[Ndx] = "*" THEN CALL PointerFix
      IF Stk$[Ndx] = "&" THEN Stk$[Ndx--] = "" : CONCAT(Stk$[Ndx], "&")

      IF iMatchWrd(Stk$[Ndx-1], "as") THEN
         SOF$ = Stk$[Ndx]
         GetTypeInfo(SOF$, &w, &id, &vt)

         IF vt = vt_STRLIT OR vt = vt_DECFUNC OR vt = vt_NUMBER OR _
            (vt = vt_VOID AND INCHR(Stk$[Ndx], "*") = 0) THEN
            CALL Abort(SOF$ + " is not a valid type")
         END IF
         IF vt = vt_FILEPTR AND INCHR(SOF$, "*") = 0 THEN SOF$ = SOF$ + "*"
         DECR Ndx,2
      ELSE
         vt = DataType(Stk$[2])
         id = 0
         SOF$ = GetVarTypeName$(vt)
      END IF

      Use_DynamicA = Use_BcxTmpStr = TRUE

      CALL BuildStr(3, Ndx, LZZ$)

      dms = TALLY(LZZ$,"][") + 1

      IF dms > 1 THEN REPLACE "][" WITH "," IN LZZ$

      LZZ$ = Clean$(LZZ$)

      RemoveAll(LZZ$,"[]")

      IF vt = vt_STRVAR THEN
         vt = vt_CHAR
         SOF$ = "char"
         IF InTypeDef THEN
            IF Stk$[3] <> "[" THEN
               DECR dms
            ELSE
               vt = vt_CHARPTR
            END IF
         END IF

         INCR dms

         CONCAT(LZZ$,",")
         CONCAT(LZZ$,"BCXSTRSIZE")
      END IF

      IF InTypeDef THEN
         IF vt = vt_STRUCT THEN
            FPRINT Outfile, Scoot$,"struct _", SOF$, "  ", STRING$(dms,42), CVar$, ";"
         ELSE
            FPRINT Outfile, Scoot$,SOF$, "  ", STRING$(dms,42), CVar$, ";"
         END IF
         CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef], vt, CVar$, SOF$, dms)
      ELSEIF InFunction <> FALSE THEN
         INCR LocalDynArrCnt

         IF cMaxLocalDynArr = LocalDynArrCnt THEN
            CALL Abort("Maximum number of Local Dynamic Arrays exceeded.")
         END IF

         LocalDynArrName$ [LocalDynArrCnt] = "if (" + CVar$ + ") { DestroyArr((void **)" + CVar$ + "," + STR$(dms) + ", 1); " +  CVar$ + "=NULL; }"
         FPRINT Outfile, Scoot$,SOF$;"  ";STRING$(dms,42);CVar$;"=0;"
         CALL AddLocal(CVar$, vt, id,"",dms)
      ELSE
         IF Use_GenFree THEN
            CALL AddDynamicGlobal("if (" + CVar$ + ") { DestroyArr((void **)" + CVar$ + "," + STR$(dms) + ", 1); " +  CVar$ + "=NULL; }")
         END IF
         CALL AddGlobal(CVar$, vt, id,"",dms)
      END IF

      IF NOT InTypeDef THEN

         REPLACE "," WITH ", (size_t)" IN LZZ$

         FPRINT Outfile,Scoot$,"{"
         FPRINT Outfile,Scoot$,"size_t dimensions[";TRIM$(STR$(dms));"] = {";"(size_t)";LZZ$;"};"
         FPRINT Outfile,Scoot$,CVar$ ; "= ("; SOF$ ;STRING$(dms,42);")CreateArr ("; CVar$ ; ",sizeof(";SOF$;"),0,";STR$(dms,1);", dimensions);"
         FPRINT Outfile,Scoot$,"}"
      END IF


      CASE "free"
      DIM RAW VI AS VarInfo PTR
      DIM RAW A, vt, id, dms
      DIM RAW CVar$
      DIM LOCAL IsDynVar

      A = 2
      IF iMatchWrd(Stk$[2], "dynamic") THEN
         IsDynVar = TRUE
         A = 3
      END IF

      IF Stk$[A] = "(" THEN
         INCR A
         DECR Ndx
      END IF

      CVar$ = Clean$(Stk$[A])
      vt = CheckLocal(CVar$, &id)

      IF vt = vt_UNKNOWN THEN
         vt = CheckGlobal(CVar$, &id)
         IF vt = vt_UNKNOWN THEN
            Abort("Can not REDIM " + CVar$ + " not previously dimensioned")
         END IF
         VI = &GlobalVars[id]
      ELSE
         VI = &LocalVars[id]
         IF IsDynVar THEN
            Warning("Local dynamic variables are automatically freed.", 1)
         END IF
      END IF

      CALL BuildStr(A, Ndx, CVar$)

      CVar$ = TRIM$(Clean$(CVar$))

      IF vt = vt_STRUCT OR vt = vt_UNION THEN
         GetElement$(2, &vt, &dms, VI->VarDef)
         IF vt <> vt_UNKNOWN AND dms > 0 THEN
            Use_BcxTmpStr = Use_DynamicA = TRUE
            FPRINT Outfile, Scoot$,"if (",  CVar$;
            FPRINT Outfile, ") { DestroyArr((void **)", CVar$, ",", dms, ", 1); ";
            FPRINT Outfile, CVar$ ; "=NULL; }"
            EXIT SELECT
         END IF
      END IF

      IF VI->VarPntr > 1 THEN
         Use_BcxTmpStr = Use_DynamicA = TRUE
         FPRINT Outfile, Scoot$,"if ("  ; CVar$ ;
         FPRINT Outfile, ") { DestroyArr((void **)";CVar$;",";STR$(VI->VarPntr);", 1); ";
         FPRINT Outfile, CVar$ ; "=NULL; }"
      ELSE
         FPRINT Outfile, Scoot$,"free(", CVar$, "), ";
         FPRINT Outfile, CVar$, "=NULL;"
      END IF

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_Dynamic




SUB DimVar(iType)
   '*******************************
   ' DIM A$ * blah blah blah
   ' DIM a%[1000]  (integer)
   ' DIM a![1000]  (single)
   ' DIM a#[1000]  (double)
   ' DIM a~[1000]  (long double)
   ' DIM A$[1000]  (string)
   ' DIM r             AS DATA_TYPE
   ' DIM r[1][2]...[n] AS DATA_TYPE
   ' DIM DYNAMIC A$[1000]
   ' DIM volatile a
   ' DIM a AS LPCTSTR
   '********************************
   DIM RAW w  = 0
   DIM RAW id = 0
   DIM RAW vt = 0
   DIM RAW IsALocalVar    = FALSE
   DIM RAW NotInitialized = TRUE
   DIM STATIC UseStatic$
   DIM STATIC IsVolatile
   DIM STATIC sVolatile$
   DIM STATIC Ok2Initialize
   DIM STATIC szVarName$
   DIM STATIC VarType
   DIM STATIC IsSubOrFuncPtr
   DIM STATIC IsConsOrDestPtr
   DIM STATIC IsPointer
   DIM STATIC LTmp$
   DIM STATIC L_DimType$
   DIM STATIC szVarTypeName$
   DIM STATIC szMemsetName$
   DIM STATIC szVarDecName$

   IF Stk[Ndx][0] = ASC(":") THEN
      CONCAT(Stk$[Ndx - 1], Stk$[Ndx])
      DECR Ndx
   END IF

   IsDim = IsLocal = IsRaw = IsRegister = IsStatic = FALSE

   IF iType = ImDim      THEN IsDim      = TRUE
   IF iType = ImLocal    THEN IsLocal    = TRUE
   IF iType = ImRaw      THEN IsDim      = IsRaw
   IF iType = ImRegister THEN IsRegister = TRUE
   IF iType = ImStatic   THEN IsStatic   = TRUE

   IsVolatile = iMatchWrd(Stk$[2],"volatile")
   IF IsVolatile THEN

      IF IsRegister THEN
         CALL Abort("Register volatile not supported")
      END IF

      sVolatile$ = "volatile "
   ELSE
      sVolatile$ = ""
   END IF

   IsSubOrFuncPtr = SubFuncTest()
   IsConsOrDestPtr = ConstructDestructTest(2)

   CALL HandleNonsense
   IF Stk$[Ndx] = "*" THEN CALL PointerFix
   IF Stk$[Ndx] = "&" THEN Stk$[Ndx--] = "" : CONCAT(Stk$[Ndx], "&")

   '*************************************************************************
   IF IsSubOrFuncPtr THEN

      IF IsVolatile THEN
         CALL Abort("volatile SUB/FUNCTION pointers not supported")
      END IF

      IF DimSubFunc(0) THEN EXIT SUB
   END IF

   IF IsConsOrDestPtr THEN

      IF IsVolatile THEN
         CALL Abort("volatile SUB/FUNCTION pointers not supported")
      END IF

      IF DimSubFunc(2) THEN EXIT SUB
   END IF

   IF InFunction OR InTypeDef OR InBlock OR InNameSpace OR InClass OR InPPType THEN
      IsALocalVar = TRUE
   END IF

   IF InTypeDef OR IsVolatile THEN
      Ok2Initialize = FALSE
   ELSE
      IF UseCpphdr THEN
         IF NOTZERO (iType BAND (ImDim BOR ImLocal)) THEN
            Ok2Initialize = TRUE
         ELSE
            Ok2Initialize = FALSE
         END IF
      ELSE
         IF NOTZERO (iType BAND (ImDim BOR ImLocal BOR ImAuto)) THEN
            Ok2Initialize = TRUE
         ELSE
            Ok2Initialize = FALSE
         END IF
      END IF
   END IF

   IF InTypeDef OR InNameSpace  THEN
      UseStatic$ = ""
      IsStatic = FALSE
   ELSE
      IF NOTZERO (iType BAND ImStatic) THEN
         IsStatic = TRUE
         UseStatic$ = "static "
      ELSE
         UseStatic$ = ""
         IsStatic = FALSE
      END IF
   END IF

   szVarName$ = Clean$(Stk$[2+IsVolatile])

   CALL ValidVar(szVarName$)
   VarType = DataType(Stk$[2+IsVolatile])

   IF Stk$[3+IsVolatile] = "*" THEN       ' DIM MySTRING$ * NumBytes

      IF IsVolatile THEN
         CALL Abort("volatile dynamic strings not supported")
      END IF

      CALL DimDynaString(szVarName$, 0, 0)
      EXIT SUB
   END IF

   DIM RAW iASoffset = GetAsPosB(Ndx, 2) ' AS offset

   IF iASoffset THEN
      DIM RAW sConst$  = ""
      DIM RAW iIsConst = 0

      IF iASoffset = Ndx-2 THEN
         IF iMatchWrd(Stk$[Ndx-1],"const") THEN
            sConst$ = "const "
            iIsConst = 1
         END IF
      END IF

      IsPointer = TALLY(Stk$[Ndx],"*")

      CALL BuildStr(2+IsVolatile, iASoffset-1, LTmp$)
      CALL BuildStr(3+IsVolatile, iASoffset-1, L_DimType$)

      IF NOTZERO(INCHR(LTmp$, "=")) THEN
         NotInitialized = FALSE
      END IF

      szVarTypeName$ = REMOVE$(Stk$[Ndx],"*")
      GetTypeInfo(szVarTypeName$, &w, &id, &vt)

      IF vt = vt_WINBOOL THEN
         IREPLACE "WINBOOL" WITH "BOOL" IN Stk$[Ndx]
      END IF

      IF vt = vt_STRVAR THEN
         Stk$[Ndx] = "char"
         szVarTypeName$ = Stk$[Ndx]
         CONCAT(L_DimType$, "[BCXSTRSIZE]")
         CONCAT(LTmp$, "[BCXSTRSIZE]")
      END IF

      Stk$[Ndx] = RPAD$(Stk$[Ndx],7)

      IF vt = vt_FILEPTR THEN
         CONCAT(Stk$[Ndx], "*")
      END IF

      IF IsALocalVar THEN
         SELECT CASE iType

            CASE ImDim, ImLocal, ImRaw
            IF vt = vt_STRUCT THEN
               FPRINT Outfile, Scoot$, UseStatic$;sVolatile$;sConst$;"struct _" ; Stk$[Ndx]; "  ";
            ELSE
               FPRINT Outfile, Scoot$, UseStatic$;sVolatile$;sConst$;Stk$[Ndx];"  ";
            END IF
            IF InTypeDef AND NOT InBlock THEN
               IF vt = vt_UDT THEN
                  IF ComSwitchON THEN
                     IF TypeDefs[id].VarName$ = "OBJECT" THEN
                        CALL Abort("Use of Object type in UDTs is Illegal!")
                     END IF
                  END IF
               END IF
               CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef], vt, szVarName$, szVarTypeName$)
            END IF

            CASE ImStatic
            FPRINT Outfile, Scoot$,UseStatic$;sVolatile$;sConst$;Stk$[Ndx];"  ";

            CASE ImAuto
            FPRINT Outfile, Scoot$,SPC$;sVolatile$;sConst$;SPC$;Stk$[Ndx];"  ";

            CASE ImRegister
            FPRINT Outfile, Scoot$,SPC$;sConst$;Stk$[Ndx];"  ";

            CASE ImCPPPrvDim
            FPRINT Outfile, Scoot$,"private: ";Stk$[Ndx];"  ";

         END SELECT

         IF iType <> ImCPPPrvDim THEN
            IF NOT InTypeDef THEN
               IF vt = vt_UDT THEN
                  IF ComSwitchON THEN
                     IF TypeDefs[id].VarName$ = "OBJECT" THEN
                        Add_COM_Global_Variable(szVarName$)
                        Use_COM = Use_BcxTmpStr = TRUE
                     END IF
                  END IF
               END IF
               CALL AddLocal(szVarName$, vt, id, L_DimType$, IsPointer,0,0,iIsConst)
            END IF
         END IF

         IF Ok2Initialize THEN
            szMemsetName$ = Clean$(EXTRACT$(LTmp$,"["))

            IF IsPointer THEN
               IF NotInitialized THEN
                  FPRINT Outfile,Clean$(LTmp$); "= {0};"
               ELSE
                  FPRINT Outfile, Clean$(LTmp$); ";"
               END IF
            ELSE
               SELECT CASE vt
                  CASE vt_BOOL, vt_BYTE, vt_DWORD, vt_INTEGER, vt_LONG, vt_SHORT, vt_UINT, vt_ULONG, vt_USHORT, vt_DWORD, vt_WORD, _
                  vt_DOUBLE, vt_SINGLE, vt_LDOUBLE, vt_PCHAR, vt_LPBYTE
                  IF NotInitialized THEN
                     FPRINT Outfile,Clean$(LTmp$); "= {0};"
                  ELSE
                     FPRINT Outfile, Clean$(LTmp$); ";"
                  END IF
                  CASE ELSE
                  IF NotInitialized THEN
                     FPRINT Outfile,Clean$(LTmp$); "= {0};"
                  ELSE
                     FPRINT Outfile, Clean$(LTmp$); ";"
                  END IF
               END SELECT
            END IF
         ELSE
            FPRINT Outfile, Clean$(LTmp$); ";"
         END IF
      ELSE
         IF IsVolatile THEN
            CALL AddGlobal(szVarName$, vt, id, L_DimType$,IsPointer,0,3,0,iIsConst)
         ELSE
            IF vt = vt_UDT THEN
               IF ComSwitchON THEN
                  IF TypeDefs[id].VarName$ = "OBJECT" THEN
                     Add_COM_Global_Variable(szVarName$)
                     Use_COM = Use_BcxTmpStr = TRUE
                  END IF
               END IF
            END IF
            IF iType = ImRaw THEN
               CALL AddGlobal(szVarName$, vt, id, L_DimType$,IsPointer,0,2,0,iIsConst)
            ELSE
               CALL AddGlobal(szVarName$, vt, id, L_DimType$,IsPointer,0,0,0,iIsConst)
            END IF
         END IF
      END IF
      EXIT SUB
   END IF

   ' Dimensioned without AS
   CALL BuildStr(3+IsVolatile, Ndx, LTmp$)

   IF NOTZERO(INCHR(LTmp$, "=")) THEN
      NotInitialized = FALSE
   END IF

   IF IsALocalVar THEN LTmp$ = LTRIM$(Clean$(LTmp$))
   IF VarType = vt_STRVAR THEN CONCAT (LTmp$, "[BCXSTRSIZE]")

   IF IsALocalVar THEN
      IF VarType = vt_STRVAR THEN
         szVarDecName$ = "char"
      ELSE
         szVarDecName$ = GetVarTypeName$(VarType)
      END IF
      szVarDecName$ = RPAD$(szVarDecName$, 7)

      IF UseCpphdr THEN
         DIM RAW Ok2UseMemset
         Ok2UseMemset = Ok2Initialize
         SELECT CASE iType

            CASE ImDim, ImLocal, ImRaw, ImStatic
            IF (ImDim BOR ImLocal) AND Ok2UseMemset THEN    ' 789 MrBcx changed OR to BOR
               FPRINT Outfile,Scoot$,szVarDecName$;SPC$;szVarName$;LTmp$;"= {0};"
               Ok2UseMemset=FALSE
            ELSE
               FPRINT Outfile,Scoot$,UseStatic$;sVolatile$;szVarDecName$;SPC$;szVarName$;LTmp$;";"
            END IF

            CASE ImRegister
            IF IsVolatile THEN Abort("Register volatile not supported")
            FPRINT Outfile,Scoot$,SPC$;szVarDecName$;SPC$;szVarName$;LTmp$;";"

            CASE ImCPPPrvDim
            FPRINT Outfile,Scoot$,"private: ";szVarDecName$;SPC$;szVarName$;LTmp$;";"

         END SELECT

         IF Ok2UseMemset THEN
            szMemsetName$ = Clean$(EXTRACT$(szVarName$,"["))
            FPRINT Outfile,Scoot$,"memset(&";szMemsetName$;",0,sizeof(";szMemsetName$;"));"
         END IF

      ELSE

         SELECT CASE iType

            CASE ImDim, ImLocal, ImStatic, ImRaw
            IF NotInitialized AND Ok2Initialize THEN
               FPRINT Outfile, Scoot$,UseStatic$;sVolatile$;szVarDecName$;SPC$;szVarName$;LTmp$;"= {0};"
            ELSE
               FPRINT Outfile, Scoot$,UseStatic$;sVolatile$;szVarDecName$;SPC$;szVarName$;LTmp$;";"
            END IF

            CASE ImAuto
            IF NotInitialized AND Ok2Initialize THEN
               FPRINT Outfile, Scoot$,"auto ";sVolatile$;szVarDecName$;SPC$;szVarName$;LTmp$;"= {0};"
            ELSE
               FPRINT Outfile, Scoot$,"auto ";sVolatile$;szVarDecName$;SPC$;szVarName$;LTmp$;";"
            END IF

            CASE ImRegister
            IF IsVolatile THEN Abort("Register volatile not supported")
            IF NotInitialized AND Ok2Initialize THEN
               FPRINT Outfile, Scoot$,SPC$;szVarDecName$;SPC$;szVarName$;LTmp$;"= {0};"
            ELSE
               FPRINT Outfile, Scoot$,SPC$;szVarDecName$;SPC$;szVarName$;LTmp$;";"
            END IF

            CASE ImCPPPrvDim
            IF NotInitialized AND Ok2Initialize THEN
               FPRINT Outfile, Scoot$,"private: ";szVarDecName$;SPC$;szVarName$;LTmp$;"= {0};"
            ELSE
               FPRINT Outfile, Scoot$,"private: ";szVarDecName$;SPC$;szVarName$;LTmp$;";"
            END IF

         END SELECT
      END IF

      IF iType <> ImCPPPrvDim THEN
         IF InTypeDef THEN
            IF VarType = vt_UDT THEN
               IF ComSwitchON THEN
                  IF TypeDefs[id].VarName$ = "OBJECT" THEN
                     Abort("Use of Object type in UDTs is Illegal!")
                  END IF
               END IF
            END IF
            CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef], VarType, szVarName$, szVarTypeName$)
         ELSE
            CALL AddLocal(szVarName$, VarType, 0, LTmp$)
         END IF
      END IF
      EXIT SUB
   END IF

   '************************************************************************
   ' if we get here, we're creating with a GLOBAL variable
   '************************************************************************
   DIM STATIC iGlobalExtn

   IF IsVolatile THEN
      iGlobalExtn = 3
   ELSE
      IF VarType = vt_UDT THEN
         IF ComSwitchON THEN
            IF TypeDefs[id].VarName$ = "OBJECT" THEN
               Add_COM_Global_Variable(szVarName$)
               Use_COM = Use_BcxTmpStr = TRUE
            END IF
         END IF
      END IF
      iGlobalExtn = 0
   END IF
   CALL AddGlobal(szVarName$, VarType, 0,LTmp$,0,0,iGlobalExtn)
END SUB ' DimVar



FUNCTION Emit_CPP(sWord$, FuncRetnFlag AS PINT)
   UseCpp = TRUE

   SELECT CASE sWord$

      CASE "catch"
      DIM RAW VarCode AS VARCODE
      VarCode.IsExported = FALSE
      VarCode.UseInLine = UseInLine
      CALL InBlockReSet
      GTmpStr$ = ""

      IF Ndx > 1 THEN
         DIM RAW A
         CALL FuncSubDecs1("sub", 1, Ndx, &VarCode)
         CALL FuncSubDecs2("sub", mt_Opts, &VarCode, 1, &Ndx)
         VarCode.Methd% = mt_FuncSubDecC_DecAParam
         A = 3

         DO WHILE A < Ndx
            CALL GetParameter(&A,&VarCode, mt_OptsAParam, mt_OptsNoParam, 1)
            INCR A
         LOOP

         VarCode.Methd% = mt_FuncSubDecC_DecAParam
         VarCode.Token$ = Stk$[1]
         FuncSubDecs3(&VarCode, Ndx, 0)
         GTmpStr$ = VarCode.Header$
      ELSE
         GTmpStr$ = "catch (LPCTSTR str)"
      END IF

      FPRINT Outfile, Scoot$,"}"
      CALL BumpDown("Extra unindents and/or missing indents before CATCH")
      CALL InBlockSet
      FPRINT Outfile, Scoot$,GTmpStr$
      CALL BumpUp
      FPRINT Outfile, Scoot$,"{"

      CASE "delete"
      DIM RAW LTmp$
      CALL BuildCleanStr(2, Ndx, LTmp$)
      FPRINT Outfile, Scoot$,"delete ";LTmp$;";"

      CASE "class"
      IF InClass OR InTypeDef OR InFunction OR InPPType OR ISNULL(Stk$[2]) THEN
         CALL Abort("Syntax Error")
      END IF

      InClassName$ = Stk$[2]
      IF UsingTemplate = FALSE THEN FPRINT FP_UDT, ""

      IF NOTNULL(InIfDef$) AND InIfDef$ <> "FP3" THEN
         FPRINT FP_UDT, InIfDef$
      END IF

      FPRINT FP_UDT, "class ";
      Outfile = FP_UDT
      FOR INT i = 2 TO Ndx
         IF iMatchWrd(Stk$[i+1], "inherits") THEN
            CONCAT(Stk$[i],":")
            Stk$[i+1] = "public"
         END IF
         IF Stk$[i] = "using" THEN
            FPRINT FP_UDT, " : ";
            ITERATE
         END IF
         IF Stk$[i] = "::" THEN
            FPRINT FP_UDT, " : ";
         ELSE
            IF iMatchWrd(Stk$[i], "private") THEN Stk$[i] = "private"
            IF iMatchWrd(Stk$[i], "public") THEN Stk$[i] = "public"
            AddSpace(i)
            FPRINT FP_UDT, Stk$[i];
         END IF
      NEXT
      CALL BumpUp
      FPRINT FP_UDT, "\n";Scoot$,"{"
      INCR InClass
      InClassPP$ = ""
      IF UsingTemplate = TRUE THEN WasAClass = TRUE
      ' Add loop control test

      CASE "endclass"
      IF InClass <> 1 THEN
         CALL Abort("Syntax Error")
      END IF

      CALL BumpDown("Extra unindents and/or missing indents before END CLASS")
      FPRINT FP_UDT, Scoot$, "};"
      FPRINT FP_UDT, ""
      CALL BumpDown("Extra unindents and/or missing indents before END CLASS")
      DECR InClass
      Outfile = FP2
      InClassName$ = ""
      InClassPP$ = ""
      ' Add loop control test

      CASE "namespace"
      Outfile = FP_UDT
      FPRINT Outfile, Scoot$, "namespace ";Stk$[2]
      CALL BumpUp
      FPRINT Outfile, Scoot$, "{"
      INCR InNameSpace

      CASE "endnamespace"
      FPRINT FP_UDT, Scoot$,"};\n"
      CALL BumpDown("Extra unindents and/or missing indents before END NAMESPACE")
      DECR InNameSpace

      CASE "throw"
      DIM RAW LTmp$
      IF Ndx = 1 THEN
         LTmp$ = ENC$("An Exception has occured!")
      ELSE
         CALL BuildDelimStr(2, Ndx, LTmp$)
      END IF
      FPRINT Outfile, Scoot$,"throw ";LTmp$;";"

      CASE "try"
      FPRINT Outfile, Scoot$,"try"
      CALL BumpUp
      FPRINT Outfile, Scoot$,"{"
      CALL InBlockSet
      ' Add loop control test

      CASE "endtry"
      FPRINT Outfile, Scoot$,"}"
      CALL BumpDown("Unbalanced TRY/END TRY")
      CALL InBlockReSet

      CASE "friend"

      CASE "inline"

      CASE "mutable"

      CASE "private"
      IF Stk$[2] = ":" THEN
         IF InClassPP[0] THEN FPRINT FP_UDT, "" : CALL BumpDown("Error in Emit_CPP() CASE private")
         FPRINT FP_UDT, Scoot$,"private:"
         CALL BumpUp
         InClassPP$ = "private"
         FUNCTION = 0
      END IF

      CASE "public"
      IF Stk$[2] = ":" THEN
         IF InClassPP[0] THEN FPRINT FP_UDT, "" : CALL BumpDown("Error in Emit_CPP() CASE public")
         FPRINT FP_UDT, Scoot$,"public:"
         CALL BumpUp
         InClassPP$ = "public"
         FUNCTION = 0
      END IF

      CASE "property"
      DIM RAW LTmp$
      CALL BuildDelimStr(1, Ndx-1, LTmp$)
      FPRINT FP_UDT, Scoot$,LTmp$;SPC$;Stk$[Ndx];";"
      FUNCTION = 0

      CASE "protected"
      IF Stk$[2] = ":" THEN
         IF InClassPP[0] THEN FPRINT FP_UDT, "" : CALL BumpDown("Error in Emit_CPP() CASE protected")
         FPRINT FP_UDT, Scoot$,"protected:"
         CALL BumpUp
         InClassPP$ = "protected"
         FUNCTION = 0
      END IF

      CASE "typename"

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT

   FUNCTION = 0
END FUNCTION ' Emit_CPP



FUNCTION Emit_DialogBox(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "dialogbox" 'HELPER
      DIM RAW L_Comma = 0
      FPRINT Outfile, Scoot$,"DialogBox";

      FOR INT A = 2 TO Ndx
         IF Stk$[A] = "," THEN INCR L_Comma

         IF L_Comma = 3 THEN
            IF Stk$[A] = "," THEN Stk$[A] = ",(DLGPROC)"
         END IF

         FPRINT Outfile, Clean$(Stk$[A]);
      NEXT

      FPRINT Outfile, ";"

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_DialogBox



FUNCTION Emit_Conditional_Operator_Repair$(szArg$)  ' Used by Emit_ConditionalCompilation()
   IF NOT (Inset(szArg$,"=!<>|&")) THEN FUNCTION = szArg$
   GTmp$ = TRIM$(szArg$)
   REPLACE   "= ="   WITH  "=="  IN GTmp$
   REPLACE   "! ="   WITH  "!="  IN GTmp$
   REPLACE   "< ="   WITH  "<="  IN GTmp$
   REPLACE   "> ="   WITH  ">="  IN GTmp$
   REPLACE   "| |"   WITH  "||"  IN GTmp$
   REPLACE   "& &"   WITH  "&&"  IN GTmp$
   FUNCTION = GTmp$
END FUNCTION



FUNCTION Emit_ConditionalCompilation(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "~ifndef"
      InIfDef$ = "#ifndef "
      FOR INT i = 2 TO Ndx
         InIfDef$ = InIfDef$ + Stk$[i] + SPC$
      NEXT
      InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)
      IF InFunction OR InMain THEN
         FPRINT Outfile, InIfDef$
      ELSE
         FPRINT FP_CST, InIfDef$
      END IF

      CASE "~ifdef"
      InIfDef$ = "#if defined "
      FOR INT i = 2 TO Ndx
         InIfDef$ = InIfDef$ + Stk$[i] + SPC$
      NEXT
      InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)
      ConstLastDef$ = InIfDef$

      IF InFunction THEN
         FPRINT Outfile, InIfDef$
         InIfDef$ = "FP3"
      ELSE
         IF InMain THEN
            FPRINT Outfile, InIfDef$
         END IF
      END IF

      CASE "~if"
      InIfDef$ = "#if "
      FOR INT i = 2 TO Ndx
         InIfDef$ = InIfDef$ + Stk$[i] + SPC$
      NEXT
      InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)
      ConstLastDef$ = InIfDef$
      IF InFunction THEN
         FPRINT Outfile, InIfDef$
         InIfDef$ = "FP3"
      ELSE
         IF InMain THEN
            FPRINT Outfile, InIfDef$
         END IF
      END IF

      CASE "~else"
      InIfDef$ = "#else"
      ConstLastDef$ = InIfDef$
      IF InFunction OR InMain THEN
         FPRINT Outfile, InIfDef$
      ELSE
         FPRINT FP_CST, InIfDef$
      END IF

      CASE "~elseif"
      InIfDef$ = "#elif defined "
      FOR INT i = 2 TO Ndx
         InIfDef$ = InIfDef$ + Stk$[i] + SPC$
      NEXT
      InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)
      ConstLastDef$ = InIfDef$
      IF InFunction OR InMain THEN
         FPRINT Outfile, InIfDef$
      ELSE
         FPRINT FP_CST, InIfDef$
      END IF

      CASE "~endif"
      IF InIfDef$ = "FP3" THEN
         FPRINT FP3, "#endif"
      ELSE
         FPRINT Outfile, "#endif"
      END IF

      IF ConstLastDef$ = "FP_CST" THEN
         FPRINT FP_CST, "#endif"
      END IF

      InIfDef$ = "#endif"

      IF InConditional = 0 THEN
         InIfDef$ = ""
         ConstLastDef$ = ""
      END IF

      CASE "~pragmaoptimizeon"
      FPRINT Outfile, "#ifdef __POCC__"
      FPRINT Outfile, "#pragma optimize(time)"
      FPRINT Outfile, "#endif"

      FPRINT Outfile, "#ifdef __LCC__"
      FPRINT Outfile, "#pragma optimize(1)"
      FPRINT Outfile, "#endif"

      CASE "~pragmaoptimizeoff"
      FPRINT Outfile, "#ifdef __POCC__"
      FPRINT Outfile, "#pragma optimize(none)"
      FPRINT Outfile, "#endif"

      FPRINT Outfile, "#ifdef __LCC__"
      FPRINT Outfile, "#pragma optimize(0)"
      FPRINT Outfile, "#endif"

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_ConditionalCompilation




FUNCTION Emit_Shared_Global(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "shared", "global"
      DIM STATIC wxy
      DIM STATIC SOF$
      DIM STATIC IsShared
      DIM STATIC IsVolatile
      DIM STATIC IsSubOrFuncPtr
      DIM STATIC CVar$
      DIM STATIC id, vt, dms, IsPointer
      DIM STATIC LZZ$

      wxy = 0
      IsSubOrFuncPtr = SubFuncTest()
      CALL HandleNonsense
      IsVolatile = iMatchWrd(Stk$[2],"volatile")
      CVar$ = Clean$(Stk$[2+IsVolatile])
      CALL ValidVar(CVar$)

      IsShared = iMatchWrd(Stk$[1],"shared")

      IF Stk$[Ndx] = "*" THEN CALL PointerFix
      IF Stk$[Ndx] = "&" THEN Stk$[Ndx--] = "" : CONCAT(Stk$[Ndx], "&")

      IF Stk$[3+IsVolatile] = "*" THEN
         IF IsVolatile THEN Abort("volatile dynamic strings not supported")
         CALL DimDynaString(CVar$, 1, IsShared)
         EXIT SELECT
      END IF

      IF IsSubOrFuncPtr THEN
         IF IsVolatile THEN Abort("volatile SUB/FUNCTION pointers not supported")
         CALL DimSubFunc(0)
         EXIT SELECT
      END IF

      IF iMatchWrd(Stk$[2],"dynamic") THEN
         CVar$ = Clean$(Stk$[3])

         CALL ValidVar(CVar$)
         IF iMatchWrd(Stk$[Ndx-1],"as") THEN
            SOF$ = Stk$[Ndx]
            GetTypeInfo(SOF$, &wxy, &id, &vt)
            IF vt = vt_STRLIT OR vt = vt_DECFUNC OR vt = vt_NUMBER OR (vt = vt_VOID AND INCHR(Stk$[Ndx],"*") = 0) THEN
               Abort(Stk$[Ndx] + " is not a valid type")
            END IF
            DECR Ndx,2
         ELSE
            vt = DataType(Stk$[3])
            id = 0
            SOF$ = GetVarTypeName$(vt)
         END IF

         Use_DynamicA = Use_BcxTmpStr = TRUE

         CALL BuildStr(4, Ndx, LZZ$)
         dms = TALLY(LZZ$,"][") + 1

         IF dms > 1 THEN REPLACE "][" WITH "," IN LZZ$

         LZZ$ = Clean$(LZZ$)
         RemoveAll(LZZ$,"[]")

         IF vt = vt_STRVAR THEN
            vt = vt_CHAR
            SOF$ = "char"
            INCR dms
            CONCAT(LZZ$,",")
            CONCAT(LZZ$,"BCXSTRSIZE")
         END IF

         IF Use_GenFree THEN
            CALL AddDynamicGlobal("if (" + CVar$ + ") {DestroyArr((void **)" + CVar$ + "," + STR$(dms) + ", 1); " +  CVar$ + "=NULL;}")
         END IF

         CALL AddGlobal(CVar$, vt, id,"",dms)

         REPLACE "," WITH ", (size_t)" IN LZZ$

         FPRINT Outfile,Scoot$, "{"
         FPRINT Outfile,Scoot$, "size_t dimensions[";TRIM$(STR$(dms));"] = {";"(size_t)";LZZ$;"};"  '783 Bug Fix - Reported by MH
         FPRINT Outfile,Scoot$, CVar$ ; "= ("; SOF$ ;STRING$(dms,42);")CreateArr ("; CVar$ ; ", sizeof(";SOF$;"), 0,"; STR$(dms,1);", dimensions);"
         FPRINT Outfile,Scoot$, "}"
         EXIT SELECT
      END IF

      IsPointer = 0

      Var$ = Clean$(Stk$[2+IsVolatile])
      CALL ValidVar(Var$)

      IF iMatchWrd(Stk$[Ndx-1],"as") THEN
         IF INCHR(Stk$[Ndx],"*") THEN
            IsPointer = TALLY(Stk$[Ndx],"*")
            Stk$[Ndx] = REMOVE$(Stk$[Ndx],"*")
         END IF
         CALL BuildStr(3+IsVolatile, Ndx-2, DimType$)
         GetTypeInfo(Stk$[Ndx], &wxy, &id, &vt)
      ELSE
         CALL BuildStr(3+IsVolatile, Ndx, DimType$)
         vt = DataType(Stk$[2+IsVolatile])
         id = 0
      END IF

      IF vt = vt_STRVAR THEN
         CONCAT (DimType$, "[BCXSTRSIZE]")
      END IF
      'global object in sub/func
      IF vt = vt_UDT THEN
         IF ComSwitchON THEN
            IF TypeDefs[id].VarName$ = "OBJECT" THEN
               Add_COM_Global_Variable(CVar$)
               Use_COM = Use_BcxTmpStr = TRUE
            END IF
         END IF
      END IF

      wxy = 0
      IF IsShared THEN wxy = 2
      IF IsVolatile THEN wxy = wxy + 3
      CALL AddGlobal(Var$, vt, id, DimType$, IsPointer,0,wxy)

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_Shared_Global



FUNCTION Emit_EndFuncSub(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "endfunction", "endsub"

      IF LoopTypeCnt THEN
         CALL LoopErrorMsg
      END IF

      IF COM_lc_names_index > 0 THEN
         ' cleaning local COM objects if user forgot to
         ' call xxx = Nothing for each declared object
         CALL BCX_FreeLocalCOMObjects(TRUE)
      END IF

      IF iMatchWrd(Stk$[1],"endfunction") THEN
         InWinMain = FALSE
         LocalDynaCnt = 0
         LocalDynArrCnt = 0

         IF InDialogEvt THEN
            FPRINT Outfile, Scoot$, "if(Msg==WM_CLOSE) DestroyWindow(hWnd);"
            FPRINT Outfile, Scoot$, "return EXIT_SUCCESS;"
            InDialogEvt = FALSE
         END IF

         IF ModDialogEvt THEN
            FPRINT Outfile, Scoot$, "if(Msg==WM_CLOSE) EndDialog(hWnd,0);"
            FPRINT Outfile, Scoot$, "return EXIT_SUCCESS;"
            ModDialogEvt = FALSE
         END IF

         IF CallBackFlag THEN
            FPRINT Outfile, Scoot$, "return DefWindowProc(hWnd, Msg, wParam, lParam);"
            CallBackFlag = FALSE
         END IF
      END IF

      IF iMatchWrd(Stk$[1],"endsub") THEN
         ' Clean up dynamic strings
         IF NOTZERO (LocalDynaCnt) THEN

            FOR INT j = 1 TO LocalDynaCnt
               FPRINT Outfile, Scoot$, DynaStr$[j]
            NEXT

            LocalDynaCnt = 0
         END IF
         ' Clean up dynamic strings arrays
         IF NOTZERO(LocalDynArrCnt) THEN

            FOR INT i = 1 TO LocalDynArrCnt
               FPRINT Outfile, Scoot$,LocalDynArrName$[i]
            NEXT

            LocalDynArrCnt = 0
         END IF
      END IF

      IF ForceMainToFunc = TRUE AND NoMain = FALSE THEN
         FPRINT Outfile, Scoot$,"return EXIT_SUCCESS;"
         ForceMainToFunc = FALSE
      END IF

      CALL BumpDown("Unbalance statements occurred before END")

      IF InNameSpace OR InClass OR InPPType THEN
         FPRINT FP_UDT, Scoot$,"}\n"

         DIM RAW iIndentsUsed AS INT, szErr$

         iIndentsUsed = 0
         szErr$ = ""
         IF InNameSpace THEN
            iIndentsUsed += (InNameSpace * 2)
            szErr$ = " Namespace,"
         END IF
         IF InClass THEN
            iIndentsUsed += ((InClass+1) * 2)
            CONCAT(szErr$," Class Module,")
         END IF
         IF InPPType THEN
            iIndentsUsed += (InPPType * 2)
            CONCAT(szErr$," PPType,")
         END IF
         IF Indent > iIndentsUsed THEN
            szErr$ = LEFT$(szErr$,LEN(szErr$)-1)
            szErr$ = "Possible missing (" + USING$("##",(Indent-iIndentsUsed)* 0.5) + ") END statements in" + szErr$ + " SUB/FUNCTION"
            CALL Abort(szErr$)
         END IF
      ELSE
         FPRINT Outfile, Scoot$,"}\n\n"
         IF Indent > 0 THEN
            DIM RAW szErr$
            szErr$ = "Possible missing (" + USING$("##",Indent* 0.5) + ") END statements in SUB/FUNCTION"
            CALL Abort(szErr$)
         END IF
      END IF

      InFunction = Use_Static = FALSE

      IF Outfile = FP3 THEN
         InIfDef$ = "FP3"
      END IF

      IF NOT (InNameSpace OR InClass) THEN
         Outfile = FP2
      END IF
      ByrefCnt = 0

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_EndFuncSub



FUNCTION Emit_Type(sWord$, FuncRetnFlag AS PINT)
   UNREFERENCED_PARAMETER(FuncRetnFlag)
   SELECT CASE sWord$
      CASE "type"
      DIM STATIC i, j
      IF InTypeDef = 0 THEN
         SaveOutfileNum = Outfile
      END IF
      Outfile = FP_UDT
      IF Ndx > 2 THEN
         IF InTypeDef THEN
            CALL Abort("Single line TYPE within type/union not supported")
         END IF

         i = GetAsPosB(Ndx,1)

         IF i = 0 THEN
            CALL Abort("Missing AS TYPE")
         END IF
         FPRINT Outfile, Scoot$,"typedef ";
         j = i-1
         INCR i

         DO WHILE i <= Ndx
            FPRINT Outfile, Stk$[i];SPC$;
            INCR i
         LOOP

         FOR i = 2 TO j
            FPRINT Outfile, Stk$[i];
         NEXT
         FPRINT Outfile, ";"
         Outfile = SaveOutfileNum
      ELSE
         INCR InTypeDef

         IF cMaxBaseTypeDefs = InTypeDef THEN
            CALL Abort("Maximum number of nested TypeDefs exceeded.")
         END IF

         TypeDefName$[InTypeDef] = Stk$[2]
         CALL AddTypeDefs(TypeDefName$[InTypeDef], vt_STRUCT)
         BaseTypeDefsCnt[InTypeDef] = TypeDefsCnt
         IF InClass OR InTypeDef > 1 THEN
            FPRINT Outfile, Scoot$,"struct"
            FPRINT Outfile, Scoot$,"{"
            CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef-1], vt_STRUCT,TypeDefName$[InTypeDef],TypeDefName$[InTypeDef])
         ELSE
            FPRINT Outfile, ""
            FPRINT Outfile, "typedef struct _";TypeDefName$[InTypeDef]
            FPRINT Outfile, "{"
         END IF
         CALL BumpUp
      END IF

      CASE "endtype"
      CALL BumpDown("Unbalanced TYPE/END TYPE")
      IF InClass THEN
         FPRINT Outfile, Scoot$,"} ";TypeDefName$[InTypeDef];";"
         FPRINT Outfile, ""
      ELSE
         DIM RAW szTDNames$ = ""
         IF Ndx > 1 THEN
            DIM STATIC i, j
            i = GetAsPosB(Ndx,1)

            IF i = 0 THEN
               CALL Abort("Missing AS after END TYPE")
            END IF

            szTDNames$ = ", "
            FOR INT ii = i+1 TO Ndx
               j = INCHR(Stk$[ii],"*")
               IF j THEN Stk$[ii] = MID$(Stk$[ii],j)+LEFT$(Stk$[ii], j - 1)
               CONCAT(szTDNames$, Stk$[ii])
            NEXT
         END IF
         IF InTypeDef = 1 THEN
            FPRINT Outfile, "}";TypeDefName$[InTypeDef];", *LP";UCASE$(TypeDefName$[InTypeDef]);", *";UCASE$(TypeDefName$[InTypeDef]);"_PTR"; szTDNames$; ";"
            FPRINT Outfile, ""
            Outfile = SaveOutfileNum
            FPRINT FP_CST, Scoot$,"#define ",UCASE$(TypeDefName$[InTypeDef]),"_CLASS struct _",UCASE$(TypeDefName$[InTypeDef]),"*"
         ELSE
            FPRINT Outfile, Scoot$,"} ";TypeDefName$[InTypeDef];szTDNames$;";"
            FPRINT Outfile, ""
         END IF
      END IF
      DECR InTypeDef
   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_Type



FUNCTION Emit_Union(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$
      CASE "union"

      IF InTypeDef = 0 THEN
         SaveOutfileNum = Outfile
      END IF

      Outfile = FP_UDT

      INCR InTypeDef

      IF cMaxBaseTypeDefs = InTypeDef THEN
         CALL Abort("Maximum number of nested TypeDefs exceeded.")
      END IF

      TypeDefName$[InTypeDef] = Stk$[2]
      CALL AddTypeDefs(TypeDefName$[InTypeDef], vt_UNION)
      BaseTypeDefsCnt[InTypeDef] = TypeDefsCnt
      FPRINT Outfile, ""

      IF InTypeDef = 1 THEN
         FPRINT Outfile, "typedef union "
         FPRINT Outfile, "{"
      ELSE
         FPRINT Outfile, Scoot$,"union"
         FPRINT Outfile, Scoot$,"{"
         CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef-1], vt_UNION,TypeDefName$[InTypeDef],TypeDefName$[InTypeDef])
      END IF
      CALL BumpUp

      CASE "endunion"
      CALL BumpDown("Unbalanced UNION/END UNION")
      IF InTypeDef = 1 THEN
         FPRINT Outfile, "} ";TypeDefName$[InTypeDef];", *LP";UCASE$(TypeDefName$[InTypeDef]);", *";UCASE$(TypeDefName$[InTypeDef]);"_PTR"; ";"
         Outfile = SaveOutfileNum
      ELSE
         FPRINT Outfile, Scoot$,"} ";TypeDefName$[InTypeDef];";"
      END IF
      FPRINT Outfile, ""
      DECR InTypeDef

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_Union




FUNCTION Emit_PPType(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "pptype"
      Outfile = FP_UDT

      IF InClass OR InTypeDef OR InFunction OR InPPType OR ISNULL(Stk$[2]) THEN
         CALL Abort("Syntax Error")
      END IF

      FPRINT FP_UDT, ""

      IF InIfDef$ <> "FP3" AND NOTNULL(InIfDef$) THEN
         FPRINT FP_UDT, InIfDef$
      END IF

      FPRINT FP_UDT, "struct ";
      FOR INT i = 2 TO Ndx
         IF iMatchWrd(Stk$[i], "using") THEN Stk$[i] = ": "
         AddSpace(i)
         FPRINT FP_UDT, Stk$[i];
      NEXT
      CALL BumpUp
      FPRINT FP_UDT, "\n";Scoot$,"{"
      INCR InPPType

      CASE "endpptype"

      IF InPPType <> 1 THEN
         CALL Abort("Syntax Error")
      END IF

      CALL BumpDown("Extra unindents and/or missing indents before END PPTYPE")
      FPRINT FP_UDT, Scoot$,"};"
      DECR InPPType

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_PPType



SUB GetParameterASHelper(iEQPos AS INT, iASPos AS INT, iOptOk AS INT, iLoc AS INT)
   DIM STATIC iLast

   IF iOptOk = 0 THEN
      CALL Abort("Optional variables not supported without OPTIONAL")
   END IF

   IF iASPos = 0 THEN
      iLast = iLoc
   ELSE
      IF iASPos < iEQPos THEN
         iLast = iLoc
      ELSE
         iLast = iASPos-1
      END IF
   END IF
   FOR INT i = iEQPos+1 TO iLast
      CONCAT(Stk$[iEQPos],SPC$)
      CONCAT(Stk$[iEQPos],Stk$[i])
      Stk$[i] = ""
   NEXT
END SUB ' GetParameterASHelper



SUB GetParameter(piStart AS PINT,ptVar AS VARCODE PTR, iAParam AS INT, iNoParam AS INT, iOptOk AS INT)
   DIM RAW iASPos = 0
   DIM RAW iEQPos = 0
   DIM RAW iNd
   DIM RAW iLoc = *piStart
   IF ISNULL(Stk$[iLoc]) THEN EXIT SUB

   ptVar->Token$ = Clean$(Stk$[iLoc])

   DO
      IF Stk$[iLoc+1] = "(" THEN
         ' function as parameter type
         DIM STATIC iEndPoint
         DIM STATIC LTmp$
         DIM STATIC iStartPoint
         DIM RAW FP AS functionParse :  memset (&FP,0,SIZEOF(functionParse))  ' MrBcx 789

         CallType$ = ""
         CALL SepFuncArgs(iLoc-1, &FP, TRUE)
         iStartPoint = IMAX(FP.CommaPos[0], iLoc)
         SFPOINTER = TRUE
         '------------------------------------------------------
         '  Get intialized data  " = xxx" or "= {xxx,xxx}"
         '------------------------------------------------------
         IF FP.NumArgs = 0 THEN
            iEndPoint = IMIN(FP.CommaPos[1]+1, Ndx)
         ELSE
            iEndPoint = IMIN(FP.CommaPos[FP.NumArgs]+1, Ndx)
         END IF

         IF Stk$[iEndPoint] = "=" THEN
            Stk$[iEndPoint++] = ""
            DO WHILE NOT iMatchWrd(Stk$[iEndPoint], "as") AND iEndPoint <= Ndx
               CONCAT(LTmp$, Stk$[iEndPoint])
               Stk$[iEndPoint++] = ""
            LOOP
            RemoveAll(LTmp$, "{}", 1)
            IF NOTNULL(LTmp$) THEN CALL RemEmptyTokens
         END IF
         '------------------------------------------------------
         DIM STATIC L_FuncName$
         DIM STATIC OldiEndPoint
         IF iMatchWrd(Stk$[iEndPoint], "as") THEN
            INCR iEndPoint
            IF iMatchWrd(Stk$[iEndPoint], "function") THEN
               LShiftStk(iEndPoint)
            END IF
            DO WHILE *Stk$[iEndPoint] <> ASC(",") AND *Stk$[iEndPoint] <> ASC(")")
               IF ISNULL(Stk$[iEndPoint]) THEN
                  LShiftStk(iEndPoint)
               ELSE
                  INCR iEndPoint
               END IF
            LOOP
         END IF
         OldiEndPoint = iEndPoint

         DIM STATIC tVar AS VARCODE
         tVar.IsExported = FALSE
         tVar.UseInLine = UseInLine

         *piStart = iStartPoint-1
         CALL InsertTokens((*piStart)-1, 1, "function")
         CALL FuncSubDecs1("sub", iStartPoint-1, iEndPoint, &tVar)
         CALL FuncSubDecs2("sub", mt_FuncSubDecC_Dec, &tVar, *piStart, &OldiEndPoint)
         tVar.Functype$ = LTRIM$(tVar.Functype$)
         L_FuncName$ = Clean$(Stk$[iStartPoint])
         *piStart = iStartPoint+2
         DO WHILE *piStart < OldiEndPoint
            CALL GetParameter(piStart,&tVar, mt_FuncSubDecC_DecAParam, mt_FuncSubDecC_DecNoParam, 0)
            (*piStart)++
         LOOP

         tVar.Methd% = mt_FuncSubDecC_DecAParam
         tVar.Token$ = L_FuncName$
         FuncSubDecs3(&tVar, OldiEndPoint, 1)
         CONCAT(ptVar->Header$,tVar.Header$)
         CONCAT(ptVar->Proto$,tVar.Proto$)
         *piStart = iEndPoint
         IF Stk$[(*piStart)+1] = "," THEN
            CONCAT(ptVar->Header$,",")
            CONCAT(ptVar->Proto$,",")
            (*piStart)++
         END IF
         SFPOINTER = FALSE
         EXIT SUB
      END IF
      IF Stk$[iLoc] = "," OR Stk$[iLoc] = ")" THEN EXIT DO
      IF iMatchWrd(Stk$[iLoc], "as") THEN iASPos = iLoc
      IF iMatchWrd(Stk$[iLoc], "=") THEN iEQPos = iLoc
      INCR iLoc
   LOOP
   DECR iLoc
   IF Stk$[iLoc] <> "..." THEN
      DIM RAW iIsConst = 0
      IF iEQPos THEN CALL GetParameterASHelper(iEQPos, iASPos, iOptOk, iLoc)
      IF iASPos THEN
         DIM RAW iLast = iLoc
         DIM RAW iAfterAs1 = iASPos+1
         DIM RAW iAfterAs2 = iASPos+2
         IF iASPos < iEQPos THEN iLast = iEQPos-1
         IF iAfterAs1 <> iLast THEN
            IF iMatchWrd(Stk$[iAfterAs1], "const") THEN
               iIsConst = 1
               CONCAT(Stk$[iAfterAs1],SPC$)
               CONCAT(Stk$[iAfterAs1],Stk$[iAfterAs2])
               Stk$[iAfterAs2] = ""
            END IF

            XFOR INT i = iAfterAs2 WHILE i <= iLast BY i++
               IF iMatchWrd(Stk$[i],"ptr") THEN Stk$[i] = "*"
               CONCAT(Stk$[iAfterAs1],Stk$[i])
               Stk$[i] = ""
            XNEXT

         END IF
         ptVar->AsToken$ = Stk$[iAfterAs1]
         CALL GetTypeInfo(ptVar->AsToken$, &(ptVar->IsPtrFlag), &iNd, &(ptVar->VarNo))
      ELSE
         DIM RAW iPtrCnt = TALLY(Stk$[*piStart],"*")
         ptVar->AsToken$ = VarTypeLookup$[INCHR(VARTYPES$, RIGHT$(Stk$[*piStart],1))]+STRING$(iPtrCnt,ASC("*"))
         REMOVE "*" FROM Stk$[*piStart]
         CALL GetTypeInfo(ptVar->AsToken$, &(ptVar->IsPtrFlag), &iNd, &(ptVar->VarNo))
      END IF
      ptVar->Methd% = iAParam
      CALL GetVarCode(ptVar,"GetParameter 1")

      IF iEQPos THEN
         ptVar->Methd% = iNoParam
         ptVar->Token$ = Stk$[iEQPos]
         CALL GetVarCode(ptVar,"GetParameter 2")
      END IF

      CALL AddLocal(ptVar->Token$,ptVar->VarNo,0,"",ptVar->IsPtrFlag,0,0,iIsConst)
   ELSE
      ptVar->Methd% = iNoParam
      ptVar->Token$ = Stk$[iLoc]
      CALL GetVarCode(ptVar, "GetParameter 3")
   END IF

   INCR iLoc
   IF Stk$[iLoc] = "," THEN
      ptVar->Methd% = iNoParam
      ptVar->Token$ = Stk$[iLoc]
      CALL GetVarCode(ptVar, "GetParameter 4")
   END IF

   *piStart = iLoc
END SUB ' GetParameter



FUNCTION Emit_OptFuncSub(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$

      CASE "optfunction", "optsub"  ', "optdeclare"
      DIM RAW IOptLoc AS INT
      DIM RAW VarCode AS VARCODE
      VarCode.IsExported = FALSE
      VarCode.UseInLine = UseInLine

      CALL FuncSubDecs1("optsub", 1, Ndx, &VarCode)

      InFunction = TRUE
      LocalVarCnt = 0

      IF InNameSpace THEN
         Outfile = FP2
      ELSE
         IF UsingTemplate = FALSE THEN
            Outfile = FP3
         END IF
      END IF

      CALL FuncSubDecs2("optsub", mt_Opts, &VarCode, 1, &Ndx)

      FunctionName$ = Clean$(Stk$[2])

      IOptLoc = 4

      DO WHILE IOptLoc < Ndx
         CALL GetParameter(&IOptLoc,&VarCode, mt_OptsAParam, mt_OptsNoParam, 1)
         INCR IOptLoc
      LOOP

      VarCode.Methd% = mt_FuncSubDecC_DecAParam
      VarCode.Token$ = FunctionName$
      FuncSubDecs3(&VarCode, Ndx, 0)

      IF Use_Static THEN
         VarCode.Header$ = "static " + VarCode.Header$
         VarCode.Proto$ = "static " + VarCode.Proto$
      END IF

      CALL AddProto(VarCode.Proto$)

      IF InIfDef$ = "FP3" THEN
         ProtoType[ProtoCnt].Condition$ = ""
      ELSE
         ProtoType[ProtoCnt].Condition$ = InIfDef$
      END IF
      ProtoType[ProtoCnt].CondLevel  = InConditional

      FPRINT Outfile, VarCode.Header$   ' 775 MrBcx - Do not change these two
      FPRINT Outfile, Scoot$,"{"        ' lines. You will break c++ parsing!
      CALL BumpUp

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_OptFuncSub



FUNCTION Emit_OverLoadFuncSub(sWord$, FuncRetnFlag AS PINT)
   DIM STATIC VarCode AS VARCODE

   VarCode.IsExported = FALSE
   VarCode.UseInLine = UseInLine

   SELECT CASE sWord$

      CASE "overloadedfunction", "overloadedsub"
      DIM STATIC LTmp$
      DIM STATIC A
      Use_Overloaded = TRUE
      CALL FuncSubDecs1("overloadedsub", 1, Ndx, &VarCode)
      IF sWord$ = "overloadedfunction" THEN
         InFunction = eFunctionType
      ELSE
         InFunction = eSubType
      END IF
      InMain = FALSE
      LocalVarCnt = 0

      IF UsingTemplate = FALSE THEN
         Outfile = FP_OVR    '<<----- writing TO BCX.OVR
      END IF

      CALL FuncSubDecs2("overloadedsub", mt_OverLoad, &VarCode, 1, &Ndx)

      FunctionName$ = Clean$(Stk$[2])
      LTmp$ = " overloaded " + FunctionName$
      FunctionName$ = LTmp$

      A = 4
      DO WHILE A < Ndx
         CALL GetParameter(&A,&VarCode, mt_OverLoadAParam, mt_OverLoadNoParam, 0)
         INCR A
      LOOP

      VarCode.Methd% = mt_FuncSubDecC_Dec
      VarCode.Token$ = FunctionName$
      FuncSubDecs3(&VarCode, Ndx, 0)

      IF Use_Static THEN
         VarCode.Header$ = "static " + VarCode.Header$
      END IF

      FPRINT Outfile, VarCode.Header$   ' 775 MrBcx - Do not change these two
      FPRINT Outfile, Scoot$,"{"        ' lines. You will break c++ parsing!

      CALL BumpUp

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_OverLoadFuncSub



FUNCTION ClassProto(szProto AS PCHAR)
   DIM STATIC iReturn
   DIM STATIC iCnt
   XFOR iReturn = 0, iCnt = 0 WHILE iCnt < iClassCnt AND iReturn=0 BY iCnt++
      IF szProto$ = ClassNames$[iCnt] THEN iReturn = 1
   XNEXT
   FUNCTION = iReturn
END FUNCTION



FUNCTION Emit_ConDes(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$
      CASE "constructor", "destructor"

      IF InFunction THEN
         CALL Abort("Syntax Error: already in function")
      END IF

      DIM RAW A
      DIM RAW CTOR_USE$
      DIM RAW New_Ndx = Ndx
      DIM RAW iCPPFunSub
      DIM RAW VarCode AS VARCODE
      VarCode.IsExported = FALSE
      VarCode.UseInLine = UseInLine
      iCPPFunSub = 0

      FOR INT ct = 1 TO Ndx
         IF Stk$[ct] = "using" THEN
            iCPPFunSub = 1
            New_Ndx = ct-1
            CALL BuildDelimStr(ct+1, Ndx, CTOR_USE$)
            EXIT FOR
         END IF
      NEXT
      Ndx = New_Ndx

      CALL FuncSubDecs1("sub", 1, Ndx, &VarCode)
      IsStdFunc = FALSE

      InMain = FALSE
      LocalVarCnt = 0

      IF InNameSpace OR InClass OR InPPType THEN
         InFunction = FALSE
         Outfile = FP_UDT
      ELSE
         InFunction = TRUE
         IF UsingTemplate = FALSE THEN
            Outfile = FP3
         END IF
      END IF

      CALL FuncSubDecs2("sub", mt_ConsDes, &VarCode, 1, &Ndx)
      ' to compensate previous substitution errors not fixed

      VarCode.Functype$ = LTRIM$(VarCode.Functype$)
      FunctionName$ = Clean$(Stk$[2])

      A = 4
      DO WHILE A < Ndx
         CALL GetParameter(&A,&VarCode, mt_ConsDesAParam, mt_ConsDesNoParam, 1)
         INCR A
      LOOP

      IF (sWord$ = "constructor") OR (ISTRUE(INCHR(FunctionName$, "~"))) THEN
         VarCode.Token$ = FunctionName$
      ELSE
         VarCode.Token$ = "~" + FunctionName$
      END IF

      VarCode.Methd% = mt_FuncSubDecC_DecAParam
      FuncSubDecs3(&VarCode, Ndx, 0)

      IF Use_Static THEN
         VarCode.Header$ = "static " + VarCode.Header$
         VarCode.Proto$  = "static " + VarCode.Proto$
      END IF

      IF iMatchNQ (VarCode.Proto$,"::") = 0 AND IAmNot(InNameSpace) AND IAmNot(InClass) AND IAmNot(InPPType) THEN
         iCPPFunSub = 0
         CALL AddProto(VarCode.Proto$)
         IF InIfDef$ = "FP3" THEN
            IF ProtoCnt > 1 THEN
               ProtoType[ProtoCnt].Condition$ = ProtoType[ProtoCnt-1].Condition$
            ELSE
               ProtoType[ProtoCnt].Condition$ = ""
            END IF
         ELSE
            ProtoType[ProtoCnt].Condition$ = InIfDef$
         END IF

         ProtoType[ProtoCnt].CondLevel  = InConditional

         IF *InIfDef$ THEN
            IF InIfDef$ <> "FP3" THEN
               FPRINT Outfile, InIfDef$
            END IF
         END IF
      END IF

      IF iCPPFunSub = 1 THEN
         FPRINT Outfile, Scoot$,VarCode.Header$;": ";CTOR_USE$
      ELSE
         FPRINT Outfile, Scoot$,VarCode.Header$  ' 775 MrBcx - Do not change these two
      END IF
      FPRINT Outfile, Scoot$,"{"                 ' lines. You will break c++ parsing!
      CALL BumpUp

      CASE "endconstructor"
      CALL BumpDown("Unbalanced CONSTRUCTOR/END CONSTRUCTOR")
      FPRINT Outfile, Scoot$,"}"
      InFunction = FALSE

      CASE "enddestructor"
      CALL BumpDown("Unbalanced DESTRUCTOR/END DESTRUCTOR")
      FPRINT Outfile, Scoot$,"}"
      InFunction = FALSE

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_ConDes




FUNCTION Emit_Implied(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$
      'IMPFUNCTION module() = 0 AS virtual double
      CASE "impfunction"
      DIM RAW A
      DIM RAW szImp$
      DIM RAW VarCode AS VARCODE
      VarCode.IsExported = FALSE
      VarCode.UseInLine = UseInLine

      CALL FuncSubDecs1("sub", 1, Ndx, &VarCode)
      IsStdFunc = FALSE
      InMain = FALSE
      LocalVarCnt = 0
      CALL FuncSubDecs2("sub", mt_FuncSubDecC_Dec, &VarCode, 1, &Ndx)
      szImp$ = ""
      DO
         szImp$ = Stk$[Ndx]+ szImp$
      LOOP WHILE Stk$[Ndx--] <> "="

      ' to compensate previous substitution errors not fixed

      VarCode.Functype$ = LTRIM$(VarCode.Functype$)
      FunctionName$ = Clean$(Stk$[2])
      A = 4
      DO WHILE A < Ndx
         CALL GetParameter(&A,&VarCode, mt_OptsAParam, mt_OptsNoParam, 1)
         INCR A
      LOOP

      VarCode.Methd% = mt_FuncSubDecC_DecAParam
      VarCode.Token$ = FunctionName$
      FuncSubDecs3(&VarCode, Ndx, 0)
      FPRINT FP_UDT, Scoot$,VarCode.Header$;szImp$;";"

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)
   END SELECT
   FUNCTION = 0
END FUNCTION




FUNCTION Emit_FuncSub(sWord$, FuncRetnFlag AS PINT)
   SELECT CASE sWord$
      CASE _
      "function",_
      "sub",_
      "publicfunction",_
      "publicsub",_
      "privatefunction",_
      "privatesub"

      IF InFunction THEN
         CALL Abort("Syntax Error: already in function")
      END IF

      DIM STATIC A
      DIM STATIC CTOR_USE$
      DIM STATIC iCPPFunSub
      DIM STATIC VarCode AS VARCODE

      DIM RAW New_Ndx = Ndx
      VarCode.IsExported = FALSE
      VarCode.UseInLine = UseInLine

      SELECT CASE sWord$
         CASE "publicfunction", "publicsub"
         Stk$[1] = MID$(Stk$[1],6)
         CASE "privatefunction", "privatesub"
         Stk$[1] = MID$(Stk$[1],7)
      END SELECT

      iCPPFunSub = 0
      FOR INT ct = 1 TO Ndx
         IF iMatchWrd(Stk$[ct], "using") THEN
            iCPPFunSub = 1
            New_Ndx = ct-1
            CALL BuildDelimStr(ct+1, Ndx, CTOR_USE$)
            EXIT FOR
         END IF
      NEXT
      Ndx = New_Ndx

      IF Stk$[2] = "main" THEN
         NoMain = TRUE
         Stk$[1] = "function"
         Stk$[2] = "main%"
         ForceMainToFunc = TRUE
      END IF

      CALL FuncSubDecs1("sub", 1, Ndx, &VarCode)

      IsStdFunc = FALSE

      IF iMatchWrd(Stk$[Ndx],"stdcall") THEN
         CallType$ = "__stdcall "
         DECR Ndx
         IsStdFunc = TRUE
      END IF

      InMain = FALSE
      LocalVarCnt = 0

      ' IF InNameSpace OR InClass OR InPPType THEN  ' 786 MrBcx - This important change correctly emits this in CLASSES:
      IF InNameSpace OR InPPType THEN               '                   char *BCX_RetStr= {0};
         InFunction = FALSE                         ' allowing normal BCX strings functions to be used in C++ CLASSES
         Outfile = FP2
      ELSE
         IF iMatchNQ (sWord$, "function") THEN
            InFunction = eFunctionType
         ELSE
            InFunction = eSubType
         END IF
         IF UsingTemplate = FALSE THEN
            Outfile = FP3
         END IF
      END IF

      CALL FuncSubDecs2("sub", mt_FuncSubDecC_Dec, &VarCode, 1, &Ndx)

      VarCode.Functype$ = LTRIM$(VarCode.Functype$)

      IF iMatchRgt(Stk$[2],"operator") THEN
         CONCAT(VarCode.Functype$,Stk$[2])
         CONCAT(VarCode.Functype$,SPC$)
         FunctionName$ = ""
         DIM RAW bOppFound AS BOOL

         XFOR A = 3,bOppFound = FALSE WHILE NOT bOppFound BY A++
            IF *Stk$[A] = ASC("(") THEN
               IF *Stk$[A+1] <> ASC(")") AND *Stk$[A+2] <> ASC("(") THEN bOppFound = TRUE
               IF *Stk$[A+1] = ASC(")") AND A > 3 THEN bOppFound = TRUE
            END IF
            IF NOT bOppFound THEN
               CONCAT(VarCode.Functype$,Stk$[A])
            END IF
         XNEXT

      ELSE

         FunctionName$ = Clean$(Stk$[2])
         IF VarCode.IsExported OR IsStdFunc THEN
            FunctionName$ = CallType$ + FunctionName$
         END IF
         A = 4
      END IF

      DO WHILE A < Ndx
         IF UseCpp THEN
            CALL GetParameter(&A,&VarCode, mt_OptsAParam, mt_OptsNoParam, 1)
         ELSE
            CALL GetParameter(&A,&VarCode, mt_FuncSubDecC_DecAParam, mt_FuncSubDecC_DecNoParam, 0)
         END IF
         INCR A
      LOOP

      VarCode.Methd% = mt_FuncSubDecC_DecAParam
      VarCode.Token$ = FunctionName$
      FuncSubDecs3(&VarCode, Ndx, 0)

      IF iMatchWrd(Stk$[Ndx], "const") THEN
         CONCAT(VarCode.Header$," const")
      END IF

      IF iMatchLft(VarCode.Header$,"main(")  THEN
         VarCode.Header$ = "int main(int argc, LPCTSTR argv[])"
         VarCode.Proto$  = "int main(int argc, LPCTSTR argv[]);"
         CurrentFuncType = vt_INTEGER
      END IF

      IF Use_Static THEN
         VarCode.Header$ = "static " + VarCode.Header$
         VarCode.Proto$  = "static " + VarCode.Proto$
      END IF

      IF IAmNot(InNameSpace) AND IAmNot(InClass) AND IAmNot(InPPType) THEN
         DIM RAW iClassFunction
         DIM RAW tmp$

         tmp$ = EXTRACT$(VarCode.Proto$,"(")
         IF iMatchNQ (tmp$,"::") > 0 THEN
            tmp$ = EXTRACT$(tmp,"::")
            iClassFunction = ClassProto(tmp$)
            IF iClassFunction = 0 THEN

               IF cMaxClassNames = iClassCnt THEN
                  CALL Abort("Maximum cMaxClassNames =" + STR$(cMaxClassNames) + " reached")
               END IF

               ClassNames$[iClassCnt] = tmp$
               INCR iClassCnt
            END IF
            iClassFunction = 1
         ELSE
            iClassFunction = 0
         END IF
         IF iClassFunction = 0 THEN
            CALL AddProto(VarCode.Proto$)
            IF InIfDef$ = "FP3" THEN
               IF ProtoCnt > 1 THEN
                  ProtoType[ProtoCnt].Condition$ = ProtoType[ProtoCnt-1].Condition$
               ELSE
                  ProtoType[ProtoCnt].Condition$ = ""
               END IF
            ELSE
               ProtoType[ProtoCnt].Condition$ = InIfDef$
            END IF

            ProtoType[ProtoCnt].CondLevel  = InConditional
            IF NOTNULL (InIfDef$) THEN
               IF InIfDef$ <> "FP3" THEN
                  FPRINT Outfile, InIfDef$
               END IF
            END IF
         END IF
      END IF

      IF InNameSpace OR InClass OR InPPType THEN
         DIM RAW szCPP_SF1$ = ""
         IF iMatchWrd(Stk$[2], InClassName$) AND InClass THEN
            VarCode.Header$ = REMAIN$(VarCode.Header$,SPC$)
         END IF
         FPRINT FP_UDT, Scoot$,szCPP_SF1$;VarCode.Header$;
         IF iCPPFunSub = 1 THEN
            FPRINT FP_UDT, " : ";CTOR_USE$
         ELSE
            FPRINT FP_UDT, ""
         END IF
         Outfile = FP_UDT
      ELSE
         FPRINT Outfile, VarCode.Header$
      END IF

      FPRINT Outfile, Scoot$,"{"
      CALL BumpUp

      CASE ELSE
      CALL EmitOld(FuncRetnFlag)

   END SELECT
   FUNCTION = 0
END FUNCTION ' Emit_FuncSub


'*******************************************************************
'   Global variable emitter for variables used by BCX functions.
'*******************************************************************


SUB EmitBCXVariables
   DO WHILE iEmitVarGroup
      SELECT CASE 1

         CASE (iEmitVarGroup BAND 1)
         CALL EmitPrinterVariables
         iEmitVarGroup = iEmitVarGroup XOR ePrinterGroup

         CASE ((iEmitVarGroup >> 1) BAND 1)

         CALL AddFontVariables
         iEmitVarGroup = iEmitVarGroup XOR eFontGroup

         CASE ((iEmitVarGroup >> 2) BAND 1)

         CALL AddClassName
         iEmitVarGroup = iEmitVarGroup XOR eClassName

         CASE ((iEmitVarGroup >> 3) BAND 1)

         CALL AddBCX_hInstance
         iEmitVarGroup = iEmitVarGroup XOR eBCX_hInstance

         CASE ELSE
         CALL Abort("Unknown variable grouping was selected (Add to SUB EmitBCXVariables).")
      END SELECT
   LOOP
   ' iEmitVarGroup is zero when it gets here
END SUB ' EmitBCXVariables



SUB AddBCX_hInstance
   DIM STATIC IWasHere = 0
   IF FirstTime(IWasHere) THEN
      CALL AddGlobal("BCX_hInstance", vt_HINSTANCE)
      INCR IWasHere
   END IF
END SUB ' AddBCX_hInstance



SUB AddClassName
   DIM STATIC IWasHere = 0
   IF FirstTime(IWasHere) THEN
      CALL AddGlobal("BCX_ClassName", vt_STRVAR)
      INCR IWasHere
   END IF
END SUB ' AddClassName



SUB EmitPrinterVariables
   DIM STATIC IWasHere = 0
   IF FirstTime(IWasHere) THEN
      CALL AddGlobal("BcxPtr_hDC"       , vt_HDC)
      CALL AddGlobal("BcxPtr_FontMetrix", vt_LONG)
      CALL AddGlobal("BcxPtr_LineCtr"   , vt_LONG)
      CALL AddGlobal("BcxPtr_PrinterOn" , vt_LONG)
      CALL AddGlobal("BcxPtr_hFont"     , vt_HFONT)
      CALL AddGlobal("BcxPtr_hFontOld"  , vt_HFONT)
      CALL AddGlobal("BcxPtr_di"        , vt_DOCINFO)
      CALL AddGlobal("BcxPtr_Lf"        , vt_LOGFONT)
      CALL AddGlobal("BcxPtr_tm"        , vt_TEXTMETRIC)
      CALL AddGlobal("BcxPtr_Text"      , vt_STRVAR)
      CALL AddGlobal("BcxPtr_Buffer"    , vt_STRVAR)
      INCR IWasHere
   END IF
END SUB ' EmitPrinterVariables



SUB AddFontVariables
   DIM STATIC IWasHere = 0
   IF FirstTime(IWasHere) THEN
      CALL AddGlobal("BcxFont"   , vt_HFONT)
      CALL AddGlobal("BCX_ScaleX", vt_SINGLE)
      CALL AddGlobal("BCX_ScaleY", vt_SINGLE)
      INCR IWasHere
   END IF
END SUB ' AddFontVariables



SUB AddGUIGlobals
   DIM STATIC IWasHere = 0
   IF FirstTime(IWasHere) THEN
      CALL AddFontVariables
      CALL AddBCX_hInstance
      CALL AddGlobal("BCX_hwndMDIClient", vt_HWND      )
      CALL AddGlobal("BCX_WndClass"     , vt_WNDCLASSEX)
      CALL AddGlobal("BCX_GUI_Init"     , vt_WINBOOL   )
      CALL AddGlobal("BCX_ClassName"    ,vt_STRVAR    )
      INCR IWasHere
   END IF
END SUB ' AddGUIGlobals



SUB ProcessMsgCracker
   ' HANDLE_MSG WM_SIZE INLINE SendMessage(hWnd, WM_XXXX, 0, 0 ) : EXIT FUNCTION
   DIM RAW msg_$
   DIM RAW proc_$
   DIM RAW ret_$
   DIM RAW tmp_$[16]
   DIM RAW tmpNdx AS INT
   DIM RAW i AS INT
   DIM RAW j AS INT

   i = j = tmpNdx = 0
   FastLexer(Src$, SPC$, ":")
   IF iMatchWrd(Stk$[3], "inline") THEN
      tmp_$[++tmpNdx] = "IF Msg = " + Stk$[2] + " THEN"
      IF Stk$[Ndx] <> ":" THEN Stk$[++Ndx] = ":"
      XFOR i = 4, j = 4 WHILE i <= Ndx BY i++
         IF Stk$[i] = ":" THEN
            CALL BuildDelimStr(j, i-1, tmp_$[++tmpNdx])
            j = i+1
         END IF
      XNEXT
      tmp_$[++tmpNdx] = "END IF"
      FOR i = 1 TO tmpNdx
         CALL INJECT(tmp_$[i])
      NEXT
   ELSE
      'handle_msg(WM_SIZE, form1_onSize)
      FastLexer(Src$, " ,()","")
      msg_$  = Stk$[2]
      proc_$ = Stk$[3]
      ret_$  = Stk$[4]
      IF NOTNULL(ret_$) THEN ret_$ = "," + ret_$
      Src$ = "IF Msg = " + msg_$ + " THEN"
      INJECT(Src$)
      IF LEN(TRIM$(ret_$)) > 0 THEN
         Src$ = "  FUNCTION=" + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ")"
      ELSE
         Src$ = "  " + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ")"
      END IF
      INJECT(Src$)
      Src$ = "END IF"
      INJECT(Src$)
   END IF
   Src$ = ""
END SUB ' ProcessMsgCracker



SUB ProcessCmdHandler
   DIM RAW id_$
   DIM RAW proc_$
   DIM RAW ret_$
   DIM RAW tmp_$[16]
   DIM RAW tmpNdx  AS INT
   DIM RAW i AS INT
   DIM RAW j AS INT
   tmpNdx = 0
   FastLexer(Src$, SPC$, ":")
   IF iMatchWrd(Stk$[3], "inline") THEN
      ' handle_cmd IDM_NEW INLINE SendMessage(hWnd, WM_XXXX, 0, 0) : EXIT FUNCTION:
      tmp_$[++tmpNdx] = "IF Msg = WM_COMMAND AND CBCTL = " + Stk$[2] + " THEN "
      IF Stk$[Ndx] <> ":" THEN Stk$[++Ndx] = ":"
      XFOR i = 4, j = 4 WHILE i <= Ndx BY i++
         IF Stk$[i] = ":" THEN
            CALL BuildDelimStr(j, i-1, tmp_$[++tmpNdx])
            j = i+1
         END IF
      XNEXT
      tmp_$[++tmpNdx] = "END IF"
      FOR i = 1 TO tmpNdx
         CALL INJECT(tmp_$[i])
      NEXT
   ELSE
      ' handle_cmd(IDM_NEW, procedure, retval)
      FastLexer(Src$, " ,()","")
      id_$ = Stk$[2]
      proc_$ = Stk$[3]
      ret_$ = Stk$[4]
      IF NOTNULL(ret_$) THEN ret_$ = "," + ret_$
      Src$ = "IF Msg = WM_COMMAND AND CBCTL = " + id_$ + " THEN"
      INJECT(Src$)
      IF LEN(TRIM$(ret_$)) > 0 THEN
         Src$ = "  FUNCTION=" + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ")"
         INJECT(Src$)
      ELSE
         Src$ = "  " + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ") "
         INJECT(Src$)
      END IF
      Src$ = "END IF"
      INJECT(Src$)
   END IF
   Src$ = ""
END SUB ' ProcessCmdHandler



SUB ProcessMsgHandler
   'MSGHANDLER procedure or CMDHANDLER procedure
   FastLexer(Src$, ", ()","")
   Src$ = "FUNCTION " + Stk$[2] + " OPTIONAL (hWnd AS HWND, wParam AS WPARAM, lParam AS LPARAM, LReturn AS LONG=0) AS LONG"
   INJECT(Src$)
   Src$ = ""
END SUB ' ProcessMsgHandler



SUB ProcessMsgHandlerEnd
   Src$ = "FUNCTION = LReturn"
   INJECT(Src$)
   Src$ = "END FUNCTION"
   INJECT(Src$)
   Src$ = ""
END SUB ' ProcessMsgHandlerEnd

'==================================================================================
'                               End Expand Macros
'                   Begin  Directives - tDirectives[].Emitter()
'==================================================================================

FUNCTION Doinclude(szWord$, iFLAG AS PINT)
   *iFLAG = 0

   SELECT CASE szWord$

      CASE "#include"
      FPRINT FP_HDR,  "#include"; Src + 8

      CASE "$include"
      DIM RAW orgfileName$
      IREPLACE "$BCX$" WITH BCXPATH$ IN Src$
      szFile$ = TRIM$(REMOVE$(MID$(Src$,9),DQ$))
      IF *szFile = ASC("<") THEN
         szFile$ = MID$(szFile$, 2, LEN(szFile$)-2)
         szFile$ = ENVIRON$("BCXLIB") + szFile$
      END IF
      orgfileName$ = szFile$
      IF NOT EXIST(szFile$) THEN
         szFile$ = BcxSplitPath$(szFile$, FNAME|FEXT)
         szFile$ = BcxSplitPath$(FileNames$[FileNdx], FDRV|FPATH) + szFile$
      END IF
      IF NOT EXIST(szFile$) THEN Abort("Unable to locate " + orgfileName$)
      CALL PushFileIO
      OPEN szFile$ FOR INPUT AS SourceFile

      IF FileNdx = MAXFILES-1 THEN
         CALL Abort("Maximum Include Files exceeded.")
      END IF

      FileNames$[++FileNdx] = szFile$
      LineNum[FileNdx] = 0

   END SELECT
   FUNCTION = 0
END FUNCTION




SUB CreateUserResourceFile
   IF Use_Resource AND NOT Use_GenResFile THEN
      IF NOTNULL(UserResFile$) THEN Res_File$ = UserResFile$
   END IF

   IF Use_GenResFile THEN
      CombineRes = FALSE

      IF EXIST(UserResFile$) THEN CombineRes = TRUE 'don't overwrite rc file
      GTmpStr$ = EXTRACT$(UCASE$(FileOut$),".") + "__.rc"
      Res_File$ = GTmpStr$

      OPEN resFile$ FOR INPUT  AS ResIn
      OPEN GTmpStr$   FOR OUTPUT AS ResOut

      FPRINT ResOut, "//  BCX Generated Resource File"
      FPRINT ResOut, "//  Date: ",DATE$, " Time: ",TIME$
      FPRINT ResOut, ""
      FPRINT ResOut, "#include <windows.h>"
      FPRINT ResOut, ""

      IF CombineRes THEN
         OPEN UserResFile$ FOR INPUT AS UserResIn
         FPRINT ResOut, "// User's *.rc file listing"
         FPRINT ResOut, ""
         DO WHILE NOT EOF(UserResIn)
            LINE INPUT UserResIn,GTmp$     ' Read from user's resource file
            IF INSTR(GTmp$,"windows.h",0,1) > 0 THEN
               GTmp$ = ""
            END IF
            FPRINT ResOut, GTmp$           ' Write to final *.rc file
         LOOP
      END IF

      FPRINT ResOut, ""
      FPRINT ResOut, "// BCX generated *.rc file listing"
      FPRINT ResOut, ""

      DO WHILE NOT EOF(ResIn)
         LINE INPUT ResIn,GTmp$       ' Read from temp$
         IF INSTR(GTmp$,"include",0,1) > 0 THEN
            FPRINT ResOut, ""
         END IF
         FPRINT ResOut, GTmp$          ' Write to final *.rc file
      LOOP

      CLOSE ResOut
      CLOSE ResIn

      IF CombineRes THEN
         CLOSE UserResIn
      END IF

   END IF

   IF EXIST(resFile$) THEN
      KILL resFile$
   END IF
END SUB




SUB DoGoto(i AS INT, iSend AS INT)
   DIM STATIC LszTmp$
   sprintf(LoopType[i].szUseNeedLabel,"L%i:;",LoopType[i].iJumpTo)
   IF iSend THEN
      sprintf(LszTmp, "goto L%i;",LoopType[i].iJumpTo)
      FPRINT Outfile, Scoot$,LszTmp$
   END IF
END SUB



FUNCTION Doaccelerator(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Accelerator$ = REMOVE$(Stk$[2],DQ$)
   FUNCTION = 0
END FUNCTION



FUNCTION Doasm(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   DIM RAW LTmp$ = ""
   *iFLAG = 0

   CALL EmitOptimize("none","0","  // No Optimizations in ASM block")

   DO
      IF EOF(SourceFile) THEN Abort ("Unbalanced $Asm")
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      IF SrcFlag THEN
         FPRINT Outfile, "// ",Src$
      END IF
      CALL StripTabs
      Src$ = TRIM$(Src$)

      DIM meta_asm_loop
      DIM meta_asm_comment_present AS BOOL
      DIM Src_Len AS INT
      Src_Len = LEN(Src$)
      meta_asm_comment_present = FALSE

      FOR meta_asm_loop = 0 TO Src_Len
         '******************************************
         '   Extracts both the Basic Single Quote
         '   and the Assembly Semicolon
         '******************************************
         IF Src[meta_asm_loop] = c_SglQt OR Src[meta_asm_loop] = 59 THEN
            LTmp$ = RIGHT$(Src$,Src_Len - meta_asm_loop - 1)
            Src[meta_asm_loop] = 0
            meta_asm_comment_present = TRUE
            EXIT FOR
         END IF
      NEXT

      Src$ = TRIM$(Src$)
      IF iMatchLft(Src$,"$asm") THEN EXIT DO
      REPLACE "$" WITH "0x" IN Src$
      IREPLACE "&h" WITH "0x" IN Src$
      IF NOTNULL(Src$) THEN
         Src$ = "_asm(" + ENC$(Src$) + CHR$(1)
         IF meta_asm_comment_present THEN
            Src$ = Src$ + TAB$ + "//" + LTmp$
         END IF
         SrcTmp$ = Src$
         FPRINT Outfile, "#if !defined(__POCC__) && !defined (__cplusplus)"
         REPLACE CHR$(1) WITH ")" IN Src$
         FPRINT Outfile, Src$
         FPRINT Outfile, "#else"
         REPLACE "_asm(" WITH "__asm{" IN SrcTmp$
         REPLACE CHR$(1) WITH "}" IN SrcTmp$
         FPRINT Outfile, REMOVE$(SrcTmp$,DQ$)
         FPRINT Outfile, "#endif"
      END IF
   LOOP

   CALL EmitOptimize("","1","  // Restoring Optimizer state")
   FUNCTION = 0
END FUNCTION



FUNCTION Dobcx_resource(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Use_GenResFile = TRUE

   DO
      IF EOF(SourceFile) THEN Abort ("Unbalanced $BCX_RESOURCE")
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      CALL StripCode(Src$)
      IF iMatchLft(LTRIM$(Src$),"$bcx_r") THEN EXIT DO
      FPRINT FP_RES,  Src$
   LOOP

   FUNCTION = 0
END FUNCTION



FUNCTION Dobcxversion(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Src$ = TRIM$(MID$(Src$,12))
   REMOVE DQ$ FROM Src$
   IF LCASE$(VERSION$) < LCASE$(Src$) THEN
      Abort (CRLF$ + "Your Translator needs updating." + CRLF$ + _
      "This program " + ENC$(FileNames$[FileNdx])              + _
      " requires BCX Version: " + Src$ + " or later." + CRLF$ + CRLF$)
   ELSE
      IF BCX_COLORS THEN COLOR 11,0
      PRINT "Program requires BCX Version ", Src$, " or newer."
      IF BCX_COLORS THEN COLOR 10,0
      PRINT "Detected BCX ", BCX_VERSION$, " [OKAY]"
   END IF
   FUNCTION = 0
END FUNCTION



FUNCTION Docatch(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Src$ = TRIM$(MID$(Src$,8))
   IF ISNULL(Src$) THEN Src$ = "char *str"
   FPRINT Outfile, "}"
   FPRINT Outfile, "catch (";Src$;")" ' catch (char *str)
   FPRINT Outfile, "{"
   FUNCTION = 0
END FUNCTION



FUNCTION Doccode(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   DIM RAW FP_TMP AS FILE
   DIM RAW szWhere$
   *iFLAG = 0
   IF Ndx > 1 THEN
      szWhere$ = LCASE$(Stk$[2])
   ELSE
      szWhere$ = "default"
   END IF
   SELECT CASE szWhere$
      CASE "set"
      FP_TMP = FP_SET  ' Temp File FOR Storing GLOBAL SET Vars
      CASE "header"
      FP_TMP = FP_HDR  ' Temp File FOR Storing User's .H files
      CASE "const"
      FP_TMP = FP_CST  ' Temp File FOR Storing User's MACRO
      CASE "udt"
      FP_TMP = FP_UDT  ' Temp File FOR Storing User's Def Types
      CASE "enum"
      FP_TMP = FP_ENU  ' Temp File FOR Storing User's global enums
      CASE "funcsub"
      FP_TMP = FP_CCODE ' Temp File FOR Storing User's C code
      CASE ELSE
      IF InFunction THEN
         FP_TMP = FP3
      ELSE
         IF InClass OR InNameSpace OR InPPType THEN
            FP_TMP = FP_UDT  ' Temp File FOR Storing User's Def Types
         ELSE
            FP_TMP = FP2
         END IF
      END IF
   END SELECT

   DO
      IF EOF(SourceFile) THEN Abort ("Unbalanced $Ccode")
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      CALL StripTabs
      IF iMatchLft(LTRIM$(Src$) ,"$ccode") THEN
         IF SrcFlag THEN 'comments seem to interfere with C line continuations '\'
            FPRINT FP_TMP, "// [", TRIM$(FileNames$[FileNdx]), " - ", _
            TRIM$(STR$(LineNum[FileNdx])), "] End of $CCODE Block"
         END IF
         EXIT DO
      END IF
      FPRINT FP_TMP, RTRIM$(Src$)
   LOOP

   FUNCTION = 0
END FUNCTION



FUNCTION Doclass(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0

   IF UseCpp = FALSE THEN
      CALL Abort("'Class' can only be used with C++")
   END IF

   Src$ = REMAIN$(Src$, SPC$)
   FPRINT FP_UDT, "class ";Src$;"\n  {"

   DO
      IF EOF(SourceFile) THEN Abort ("$Class Without $EndClass")
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      IF iMatchLft(LTRIM$(Src$),"$endclass") THEN
         EXIT DO
      END IF
      FPRINT FP_UDT, Src$
   LOOP

   Src$ = MID$(Src$, INSTR(Src$,"$endclass",1,1)+9)
   Src$ = TRIM$(Src$)
   FPRINT FP_UDT, "} ", Src$, ";"
   FUNCTION = 0
END FUNCTION



FUNCTION Docom_op(szWord$, iFLAG AS PINT)
   *iFLAG = 0

   SELECT CASE szWord$

      CASE "$com_off"
      Use_COM = FALSE
      ComSwitchON = FALSE

      CASE "$com_on"
      Use_COM = Use_BcxTmpStr = TRUE
      ComSwitchON = TRUE

      CASE "$com_trace"
      COM_build_trace_code = TRUE
      PRINT "COM trace code added to translated C file!"
      PRINT "Trace informations will be sent to file: c:\\com_trace.txt"

   END SELECT
   FUNCTION = 0
END FUNCTION



FUNCTION Docomment(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   DIM STATIC TmpFile AS FILE
   IF IAm(InClass) OR IAm(InPPType) THEN
      TmpFile = FP_UDT
   ELSE
      TmpFile = Outfile
   END IF
   DO
      IF EOF(SourceFile) THEN Abort ("Unbalanced $Comment")
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      CALL StripTabs
      IF iMatchLft(LTRIM$(Src$),"$comment") THEN EXIT DO
      FPRINT TmpFile, "// ";Src$
   LOOP
   FUNCTION = 0
END FUNCTION



FUNCTION Dofillstring (szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0

   DIM STATIC TheVariable$
   IREMOVE "$fill" FROM Src$
   Src$ = TRIM$(Src$)

   IF ISFALSE INCHR(Src$,"$") THEN                    ' It doesn't LOOK like a string, so make it easy on BCX
      IF ISFALSE INCHR(Src$,"[") THEN                 ' It looks like a one-dimensional string
         CONCAT(Src$, "$")                            ' ... so we'll append a dollar sign
      ELSE
         DIM RAW i = INCHR(Src$,"[")                  ' It is a member of a string array
         Src$ = MID$(Src$,1,i-1) + "$" + MID$(Src$,i) '... so APPEND a $ sign TO its name
      END IF
   END IF

   INJECT (Src$ + " = " + ENC$(""))                 ' 777 MrBcx -- Start with an empty variable
   TheVariable$ = Src$ + " = " + Src$ + " & "       ' This is what precedes the [string expressions]

   DO
      IF EOF(SourceFile) THEN Abort ("Unbalanced $FILL")
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      CALL StripTabs
      Src$ = LTRIM$(Src$)
      IF LEFTSTR(Src$,"'") OR LEFTSTR(Src$,"rem",TRUE) THEN Src$ = ""
      IF LEFTSTR(Src$,"$fill",TRUE) THEN EXIT DO
      REPLACE BKSLASH2$ WITH BKSLASH4$ IN Src$           ' escape the \ character (like in RTF file data)
      REPLACE BKSLASH1$ WITH BKSLASH2$ IN Src$           '                      ditto
      IF NOTNULL(Src$) THEN INJECT (TheVariable$ + Src$) ' Inject each expression into BCX's translate stream
   LOOP
   Src$ = ""
   FUNCTION = 0
END FUNCTION


FUNCTION DoWarnings(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   WarningFlag = TRUE
   FUNCTION = 0
END FUNCTION


FUNCTION DoZap(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   ZapFlag = TRUE
   FUNCTION = 0
END FUNCTION


FUNCTION Docompiler(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Src$ = REMAIN$(Src$,SPC$)
   Compiler$ = TRIM$(Src$)
   FUNCTION = 0
END FUNCTION


FUNCTION DoBcxStrSize (szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   ' We change: #define BCXSTRSIZE 2048 in SUB Final_Transforms
   UserBcxStrSize$ = TRIM$(REMAIN$(Src$,SPC$))
   FUNCTION = 0
END FUNCTION


FUNCTION Docpp(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   UNREFERENCED_PARAMETER(iFLAG)
   UseCpp = TRUE
   FUNCTION = 0
END FUNCTION


FUNCTION Docpphdr(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   UseCpphdr = TRUE
   UseIO = TRUE
   FUNCTION = 0
END FUNCTION


FUNCTION Docproto(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   FastLexer(Src$, SPC$, "!")

   IF iMatchWrd(Stk$[2], "!") THEN
      CALL AddProto(REMAIN$(Src$, "!"))
      ProtoType[ProtoCnt].Condition$ = ""
      ProtoType[ProtoCnt].CondLevel  = 0
   ELSE
      DIM RAW i = iMatchNQ(Src$, "function")
      IF i = 0 THEN
         i = iMatchNQ(Src$, "sub")
      END IF
      IF i THEN
         Src$ = "c_declare " + MID$(Src$, i)
      ELSE
         i = iMatchNQ(Src$, "$cproto")
         Src$ = "c_declare function " + MID$(Src$, i+7)
      END IF
      PassOne = TRUE
      CALL INJECT(Src$)
      PassOne = FALSE
      UseCProto = TRUE
      *iFLAG = 2
   END IF
   FUNCTION = *iFLAG
END FUNCTION



FUNCTION Dodebug(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   InDebug = 1 XOR InDebug
   IF InDebug THEN
      Src$ = "$IF _DEBUG_"
   ELSE
      Src$ = "$ENDIF"
   END IF
   PassOne = TRUE
   CALL XParse(Src$)
   PassOne = FALSE
   UseCProto = TRUE
   *iFLAG = 2
   FUNCTION = 2
END FUNCTION



FUNCTION Dodefine(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   UNREFERENCED_PARAMETER(iFLAG)
   DIM LOCAL Tmp$ = "#define"
   FOR INT i = 2 TO Ndx
      CONCAT(Tmp$, SPC$)
      CONCAT(Tmp$, Stk$[i])
      Stk$[i] = ""
   NEXT
   REPLACE " ) = "    WITH ") "       IN Tmp$  ' Important to remove this equals sign
   REPLACE " ( "      WITH " ("       IN Tmp$  ' Cosmetic
   REPLACE " , "      WITH ","        IN Tmp$  ' Cosmetic
   REPLACE " CONST "  WITH " const "  IN Tmp$  ' ************************************
   REPLACE " INT "    WITH " int "    IN Tmp$  ' Counteract helpful syntax editors
   REPLACE " LONG "   WITH " long "   IN Tmp$  ' This is obviously an incomplete list
   REPLACE " DOUBLE " WITH " double " IN Tmp$  ' but hopefully covers the common ones
   REPLACE " FLOAT "  WITH " float "  IN Tmp$  ' ************************************
   FPRINT FP_DEF, Tmp$                         ' Operation reduced to one disk-write
   Ndx = 0
   FUNCTION = 0
END FUNCTION



FUNCTION Dodll(szWord$, iFLAG AS PINT)
   *iFLAG = 0
   SELECT CASE szWord$
      CASE "$dll"
      MakeDLL = TRUE
      Ndx = 0
      IF iMatchWrd(Stk$[2], "stdcall") THEN
         UseStdCall = TRUE
      END IF

      IF NoDllMain = FALSE THEN
         FPRINT Outfile, ""
         FPRINT Outfile, "__declspec(dllexport) BOOL WINAPI DllMain (HINSTANCE hInst, DWORD Reason, PVOID Reserved)"
         FPRINT Outfile, "{"
         FPRINT Outfile, "  switch (Reason)"
         FPRINT Outfile, "  {"
         FPRINT Outfile, "    case DLL_PROCESS_ATTACH:"
         FPRINT Outfile, "      BCX_hInstance = hInst;"
         FPRINT Outfile, "      break;"
         FPRINT Outfile, "    case DLL_PROCESS_DETACH:"
         FPRINT Outfile, "      break;"
         FPRINT Outfile, "    case DLL_THREAD_ATTACH:"
         FPRINT Outfile, "      break;"
         FPRINT Outfile, "    case DLL_THREAD_DETACH:"
         FPRINT Outfile, "      break;"
         FPRINT Outfile, "   }"
         FPRINT Outfile, " return TRUE;"
         FPRINT Outfile, "}\n\n"
         CALL AddBCX_hInstance
      END IF

      CASE "$nodllmain"
      NoDllMain = TRUE
   END SELECT
   FUNCTION = 0
END FUNCTION



FUNCTION DoNameSpace(szWord$, iFLAG AS PINT)
   *iFLAG = 0
   SELECT CASE szWord$

      CASE "$endnamespace"
      DECR InNameSpace
      CALL BumpDown("Unbalanced $NAMESPACE/$END$NAMESPACE")
      FPRINT Outfile, Scoot$,"}"

      CASE "$namespace" ' $namespace/$endnamespace

      IF UseCpp = FALSE THEN
         CALL Abort("'Namespace' can only be used with C++")
      END IF

      FPRINT Outfile, Scoot$,"namespace ";Stk$[2]
      FPRINT Outfile, Scoot$,"{"
      INCR InNameSpace
      CALL BumpUp

      CASE "$usenamespace" ' $usenamespace = using namespace std; etc.

      IF UseCpp = FALSE THEN
         CALL Abort("'Usenamespace' can only be used with C++")
      END IF

      Src$ = REMAIN$(Src$, SPC$)
      IF RIGHTSTR (TRIM$(Src$),";") THEN
         FPRINT Outfile, "using namespace ", Src$, ";"
      ELSE
         FPRINT Outfile, "using namespace ", Src$
      END IF

   END SELECT
   FUNCTION = 0
END FUNCTION



FUNCTION DoTry(szWord$, iFLAG AS PINT)
   *iFLAG = 0
   SELECT CASE szWord$

      CASE "$endtr"
      FPRINT Outfile, "}"

      CASE "$try"
      FPRINT Outfile, "try {"

   END SELECT
   FUNCTION = 0
END FUNCTION



FUNCTION Dofiletest(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   IF iMatchWrd(Stk$[2],"ON") THEN
      UseFileTest = TRUE
   ELSEIF iMatchWrd(Stk$[2],"OFF") THEN
      UseFileTest = FALSE
   ELSE
      Abort("Unrecognized argument '"+Stk$[2] + "' to $FILETEST")
   END IF
   FUNCTION = 0
END FUNCTION



FUNCTION Dofsstatic(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Use_Static = NOT Use_Static
   FUNCTION = 0
END FUNCTION



FUNCTION Dogenfree(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Use_GenFree = TRUE
   FUNCTION = 0
END FUNCTION



FUNCTION Doheader(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   FPRINT FP_HDR,  "// *************************************************\n"

   DO
      IF EOF(SourceFile) THEN Abort ("Unbalanced $Header")
      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      CALL StripTabs
      Src$ = TRIM$(Src$)
      IF iMatchLft(Src$,"$heade") THEN EXIT DO
      FPRINT FP_HDR,  Src$
   LOOP

   FPRINT FP_HDR,  ""
   FUNCTION = 0
END FUNCTION



FUNCTION Dointerface(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0

   IF UseCpp = FALSE THEN
      CALL Abort("'Interface' can only be used with C++")
   END IF

   Src$ = REMAIN$(Src$, SPC$)
   FPRINT FP_UDT, "interface ";Src$;"\n  {"

   DO
      IF EOF(SourceFile) THEN
         CALL Abort ("$Interface Without $EndInterface")
      END IF

      LINE INPUT SourceFile,Src$
      INCR LineNum[FileNdx]
      IF iMatchLft(LTRIM$(Src$),"$endinterface") THEN EXIT DO
      FPRINT FP_UDT, Src$
   LOOP

   Src$ = REMAIN$(Src$, SPC$)
   Src$ = TRIM$(Src$)
   FPRINT FP_UDT, "} ";Src$;";"
   FUNCTION = 0
END FUNCTION



FUNCTION Doiprint_offon(szWord$, iFLAG AS PINT)
   *iFLAG = 0
   SELECT CASE szWord$

      CASE "$iprint_on"
      TranslateSlash = TRUE

      CASE "$iprint_off"
      TranslateSlash = FALSE

   END SELECT
   FUNCTION = 0
END FUNCTION


FUNCTION DoCase_offon(szWord$, iFLAG AS PINT)
   *iFLAG = 0
   SELECT CASE szWord$

      CASE "$case_on"
      IgnoreStrCase = FALSE  ' Use strcmp (default)

      CASE "$case_off"
      IgnoreStrCase = TRUE   ' Use bcx_stricmp

   END SELECT
   FUNCTION = 0
END FUNCTION



FUNCTION Doleanandmean(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Use_LeanAndMean = TRUE
   FUNCTION = 0
END FUNCTION



FUNCTION Doliberror(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Use_BcxTmpStr = Use_Date = Use_Time = Use_LoadLibraryError = TRUE

   IF *Stk$[2] <> c_DblQt THEN
      CALL Abort("$LIBERROR requires as string literal")
   END IF

   LibraryErrorLog$ = Stk$[2]
   FUNCTION = 0
END FUNCTION



FUNCTION Dolibrary(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   REPLACE BKSLASH1$ WITH BKSLASH2$ IN Src$
   Src$ = IREMOVE$(Src$,"$library")
   Src$ = TRIM$(Src$)
   AddLibrary(Src$)
   FUNCTION = 0
END FUNCTION



FUNCTION Dolinker(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Src$ = REMAIN$(Src$,SPC$)
   Linker$ = Src$
   FUNCTION = 0
END FUNCTION



FUNCTION Domultithread(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Use_MULTITHREADED_SW = TRUE
   FUNCTION = 0
END FUNCTION



FUNCTION Donoini(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   TestForBcxIni = TRUE
   FUNCTION = 0
END FUNCTION



FUNCTION Donoio(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   UseIO = FALSE
   FUNCTION = 0
END FUNCTION



FUNCTION Doremovelib (szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   REPLACE BKSLASH1$ WITH BKSLASH2$ IN Src$
   Src$ = IREMOVE$(Src$,"$nolibrary")
   RemoveLibrary(Src$)
   FUNCTION = 0
END FUNCTION



FUNCTION Donomain(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   NoMain = TRUE
   FUNCTION = 0
END FUNCTION



FUNCTION Donowin(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   WinHeaders = FALSE
   FUNCTION = 0
END FUNCTION



FUNCTION Doonentry(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   PassOne = TRUE
   CALL XParse(Src$)
   PassOne = FALSE
   INCR EntryCnt

   IF cMaxOnEntry = EntryCnt THEN
      CALL Abort("Maximum $OnEnty exceeded.")
   END IF

   Entry$[EntryCnt] = Stk$[2]
   FUNCTION = 0
END FUNCTION


FUNCTION Doonexit(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   INCR XitCount

   IF cMaxOnExit = XitCount THEN
      CALL Abort("Maximum $OnExit exceeded.")
   END IF

   Xit$[XitCount]= Stk$[2]
   FUNCTION = 0
END FUNCTION



FUNCTION Dooptimizer(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   DIM RAW szState$
   *iFLAG = 2
   szState$ = LCASE$(Stk$[2])
   Src$ = ""

   IF szState$ = "on" THEN
      IF OptimizerFirstSetting = TRUE THEN
         OptimizerFirstSetting = FALSE
         Src$ = "~pragmaoptimizeon"
         OptimizerEnabled = TRUE
      ELSE
         IF OptimizerEnabled = FALSE THEN
            OptimizerEnabled = TRUE
            Src$ = "~pragmaoptimizeon"
         END IF
      END IF

   ELSEIF szState$ = "off" THEN
      IF OptimizerFirstSetting = TRUE THEN
         OptimizerFirstSetting = FALSE
         Src$ = "~pragmaoptimizeoff"
         OptimizerEnabled = FALSE
      ELSE
         IF OptimizerEnabled = TRUE THEN
            OptimizerEnabled = FALSE
            Src$ = "~pragmaoptimizeoff"
         END IF
      END IF
   ELSE
      Abort("Error in $OPTIMIZER MetaStatement: " + Src$ )
   END IF
   CALL XParse(Src$)
   FUNCTION = 2
END FUNCTION


FUNCTION Dopack(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   DIM RAW iLoc = 2
   *iFLAG = 0
   FastLexer(Src$, "","()")
   IF Stk$[iLoc] = "(" THEN INCR iLoc
   FPRINT FP_UDT, "#pragma pack (";Stk$[iLoc];")"
   FUNCTION = 0
END FUNCTION



FUNCTION Dopp(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   PPFlag = NOT PPFlag
   IF PPFlag THEN
      IF PPDLL_HANDLE = NULL THEN
         PPDLL_HANDLE = LOADLIBRARY( "BCXPP.DLL")
         IF NOT PPDLL_HANDLE THEN ' failed to load preprocessor dll
            Abort ("Failed to Open BCX Preprocessor DLL!")
         ELSE
            PRINT "BCXPP.DLL Successfully Loaded"
         END IF
         '****************************************************************************
         ' This conditional mutes GCC's FARPROC/CPP_FARPROC warning.     - MrBcx 790
         ' It is completely safe and obviously supports a very specific purpose: $PP
         '****************************************************************************
       ! #if defined (__GNUC__) 
       ! #pragma GCC diagnostic ignored "-Wcast-function-type"

         PPProc = (CPP_FARPROC) GetProcAddress (PPDLL_HANDLE,"ProcessLine");

       ! #pragma GCC diagnostic pop
       
       ! #else
       
         PPProc = (CPP_FARPROC) GetProcAddress (PPDLL_HANDLE,"ProcessLine");
       ! #endif
         '****************************************************************************

         IF NOT PPProc THEN
            Abort ("'FUNCTION ProcessLine' missing in BCX Preprocessor DLL!")
         END IF
      END IF
   END IF
   FUNCTION = 0
END FUNCTION




FUNCTION Doprj(szWord$, iFLAG AS PINT)
   *iFLAG = 0

   SELECT CASE szWord$
      CASE "$prj"
      Project$ = UCASE$(EXTRACT$(COMMAND$(1),".")) + ".USE"
      HFile$   = UCASE$(EXTRACT$(COMMAND$(1),".")) + ".H"
      Use_SingleFile = FALSE
      Use_BcxTmpStr = TRUE

      CASE "$prjuse"
      Use_BcxTmpStr = TRUE
      PreParse(Src$)
      CALL SetUsed

   END SELECT
   FUNCTION = 0
END FUNCTION



FUNCTION Doproject(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   CALL EnableProject
   FUNCTION = 0
END FUNCTION



FUNCTION Dorems(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   InsertComments = ~InsertComments
   Src$ = ""
   Ndx = 0
   FUNCTION = 0
END FUNCTION



FUNCTION Doresource(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   Use_Resource = TRUE
   ResCompiler$ = Stk$[2]
   UserResFile$ = REMOVE$(Stk$[3], DQ$)
   FUNCTION = 0
END FUNCTION



FUNCTION Dosource(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   SrcFlag = NOT SrcFlag
   FUNCTION = 0
END FUNCTION



FUNCTION Dostdcall(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   UseStdCall = TRUE
   FUNCTION = 0
END FUNCTION



FUNCTION Dotest(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   TestState = NOT TestState
   FUNCTION = 0
END FUNCTION



FUNCTION Dothrow(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   DIM RAW LTmp$
   *iFLAG = 0
   LTmp$ = MID$(Src$,8)
   IF ISNULL(LTmp$) THEN LTmp$ = ENC$("An Exception has occured!")
   FPRINT Outfile, Scoot$,"throw ";LTmp$;";"
   FUNCTION = 0
END FUNCTION



FUNCTION Dotrace(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   TraceFlag = NOT TraceFlag
   FUNCTION = 0
END FUNCTION



FUNCTION Dotypedef(szWord$, iFLAG AS PINT)
   UNREFERENCED_PARAMETER(szWord$)
   *iFLAG = 0
   FPRINT FP_UDT, ""
   FPRINT FP_UDT, "typedef ";REMAIN$(Src$,SPC$),";"
   FUNCTION = 0
END FUNCTION


FUNCTION IMAX (a,b) AS INT
   IF a>b THEN
      FUNCTION = a
   ELSE
      FUNCTION = b
   END IF
END FUNCTION


FUNCTION IMIN (a,b) AS INT
   IF a<b THEN
      FUNCTION = a
   ELSE
      FUNCTION = b
   END IF
END FUNCTION
'***********************************************************************************************
'                                         End of Directives
'                                     Begin Standard Prototypes
'***********************************************************************************************

SUB StdProtos(FP_WRITE AS FILE)
   IF Use_Project = FALSE THEN

      IF Use_BcxTmpStr OR Use_Console OR Use_Proto THEN
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, "//               " + $BCX_STR_STD_PROTOS
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, ""
      END IF

      IF Use_GUINoMain OR Use_MDIGUINoMain OR Use_Wingui THEN

         IF Use_BCX_FrameWnd THEN
            FPRINT FP_WRITE, "HWND    BCX_FrameWnd (LPCTSTR, WNDPROC, LPCTSTR, HMENU=NULL, int=0, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=0, int=0);"
         END IF

         IF Use_BCX_Wnd THEN
            FPRINT FP_WRITE, "HWND    BCX_Wnd (LPCTSTR, WNDPROC, LPCTSTR, HWND=0, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=0, int=0, int=0);"
         END IF

         IF Use_BCX_SetBkGrdBrush THEN
            FPRINT FP_WRITE, "void    BCX_SetBkGrdBrush (HWND, HBRUSH);"
         END IF

         IF Use_BCX_SetClassStyle THEN
            FPRINT FP_WRITE, "void    BCX_SetClassStyle (HWND, long);"
         END IF

         IF Use_BCX_SetIcon THEN
            FPRINT FP_WRITE, "void    BCX_SetIcon (HWND, int);"
         END IF

         IF Use_BCX_SetIconSm THEN
            FPRINT FP_WRITE, "void    BCX_SetIconSm (HWND, int);"
         END IF

         IF Use_BCX_SetCursor THEN
            FPRINT FP_WRITE, "void    BCX_SetCursor (HWND, LPCTSTR);"
         END IF

         IF Use_BCX_SetMetric THEN
            FPRINT FP_WRITE, "void    BCX_SetMetric (LPCTSTR);"
         END IF

         IF Use_GUINoMain THEN
            IF Use_BCX_MsgPump THEN
               FPRINT FP_WRITE, "int     BCX_MsgPump (HACCEL=0);"
            END IF
         ELSEIF Use_MDIGUINoMain THEN
            IF Use_BCX_MDI_MsgPump THEN
               FPRINT FP_WRITE, "int     BCX_MDI_MsgPump (HACCEL=0);"
            END IF
         END IF

         IF Use_BCX_RegWnd THEN
            FPRINT FP_WRITE, "void    BCX_RegWnd (LPCTSTR, WNDPROC);"
         END IF
         IF Use_BCX_InitGUI THEN
            FPRINT FP_WRITE, "void    BCX_InitGUI (void);"
         END IF
      END IF

      IF Use_Clng THEN
         FPRINT FP_WRITE, "long    CLNG (double);"
      END IF

      IF Use_Cint THEN
         FPRINT FP_WRITE, "int     Cint (double);"
      END IF

      IF Use_StartupCode THEN
         FPRINT FP_WRITE, "int     BCX_StartupCode_ (void);"
      END IF

      IF Use_ExitCode THEN
         FPRINT FP_WRITE, "int     BCX_ExitCode_ (void);"
      END IF

      IF Use_Eof THEN
         FPRINT FP_WRITE, "int     EoF (FILE*);"
      END IF

      IF Use_NamePathFromFP = TRUE THEN
         FPRINT FP_WRITE, "char      *NamePathFromFP (FILE*);"
      END IF

      IF Use_Longestline THEN
         FPRINT FP_WRITE, "UINT    LongestLine(LPCTSTR);"
      END IF

      IF Use_Nextlinelen THEN
         FPRINT FP_WRITE, "UINT    NextLineLen (FILE*);"
      END IF

      IF Use_AppActivate THEN
         FPRINT FP_WRITE, "int     AppActivate (LPCTSTR);"
      END IF

      IF Use_BoxCommon THEN
         FPRINT FP_WRITE, "LPWORD  lpwAlign (LPWORD);"
      END IF

      IF Use_Inputbox THEN
         FPRINT FP_WRITE, "char*   InputBox (LPCTSTR, LPCTSTR, LPCTSTR, int=0);"
         FPRINT FP_WRITE, "LRESULT CreatePrompter (LPCTSTR, LPCTSTR, LPCTSTR, int);"
         FPRINT FP_WRITE, "LRESULT CALLBACK Prompter (HWND, UINT, WPARAM, LPARAM);"
      END IF

      IF Use_VBS THEN
         FPRINT FP_WRITE, "HRESULT VBS_RUN_SCRIPT (LPCTSTR);"
         FPRINT FP_WRITE, "HRESULT VBS_ADDCODE    (LPCTSTR);"
         FPRINT FP_WRITE, "double  VBS_EVAL_NUM   (LPCTSTR);"
         FPRINT FP_WRITE, "char*   VBS_EVAL_STR   (LPCTSTR);"
         FPRINT FP_WRITE, "BOOL    VBS_START      (void);"
         FPRINT FP_WRITE, "void    VBS_STOP       (void);"
         FPRINT FP_WRITE, "void    VBS_RESET      (void);"
         FPRINT FP_WRITE, "char*   VBS_ERROR      (void);"
      END IF

      IF Use_Infobox THEN
         FPRINT FP_WRITE, "void    InfoBox (LPCTSTR, LPCTSTR, int=170, int=165);"
         FPRINT FP_WRITE, "LRESULT CALLBACK CB_InfoBox (HWND, UINT, WPARAM, LPARAM);"
      END IF

      IF Use_Mdigui THEN
         FPRINT FP_WRITE, "HWND    BCX_MDICHILD (LPCTSTR, LPCTSTR, int = CW_USEDEFAULT, int = CW_USEDEFAULT, int = CW_USEDEFAULT, int = CW_USEDEFAULT, DWORD = 0, LPARAM = 0);"
         FPRINT FP_WRITE, "void    BCX_MDICLASS (WNDPROC, PCHAR);"
         FPRINT FP_WRITE, "HWND    BCX_MDICLIENT (HWND, int);"
      END IF

      IF Use_BCX_Colordlg THEN
         FPRINT FP_WRITE, "int     BCX_ColorDlg (COLORREF=RGB(128, 128, 128), HWND=0);"
      END IF

      IF Use_BCXMDialog THEN
         FPRINT FP_WRITE, "INT_PTR BCX_MDialog (DLGPROC, LPCTSTR, HWND, int=0, int=0, int=250, int=150, int=0, int=0, LPCTSTR =0, int=0);"
      END IF

      IF Use_BCXDialog THEN
         FPRINT FP_WRITE, "HWND    BCX_Dialog (DLGPROC, LPCTSTR, HWND, int=0, int=0, int=250, int=150, int=0, int=0, LPCTSTR =0, int=0);"
      END IF

      IF Use_BCXDialogCommon THEN
         FPRINT FP_WRITE, "void    SetDialogScale (HWND, BOOL);"
      END IF

      IF Use_SetDimension THEN
         FPRINT FP_WRITE, "void    SetDimension (LPCTSTR , int, HWND, BOOL=FALSE);"
      END IF

      IF Use_GetDimension THEN
         FPRINT FP_WRITE, "int     GetDimension (LPCTSTR ,HWND, BOOL=FALSE);"
      END IF

      IF Use_Form THEN
         FPRINT FP_WRITE, "HWND    BCX_Form (LPCTSTR, int=0, int=0, int=250, int=150, int=-1, int=0);"
      END IF

      IF Use_Setclientsize THEN
         FPRINT FP_WRITE,"void     BCX_SetClientSize (HWND, int, int, float=1.0f, float=1.0f);"
      END  IF

      IF Use_Edit THEN
         FPRINT FP_WRITE, "HWND    BCX_Edit (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
      END IF

      IF Use_BCX_Input THEN
         FPRINT FP_WRITE, "HWND    BCX_Input (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
      END IF

      IF Use_Button THEN
         FPRINT FP_WRITE, "HWND    BCX_Button (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);"
      END IF

      IF Use_BmpButton THEN
         FPRINT FP_WRITE, "HWND    BCX_BmpButton (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);"
      END IF

      IF Use_Label THEN
         FPRINT FP_WRITE, "HWND    BCX_Label (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_Group THEN
         FPRINT FP_WRITE, "HWND    BCX_Group (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
      END IF

      IF Use_Checkbox THEN
         FPRINT FP_WRITE, "HWND    BCX_Checkbox (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_Radio THEN
         FPRINT FP_WRITE, "HWND    BCX_Radio (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_Combobox THEN
         FPRINT FP_WRITE, "HWND    BCX_Combobox (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
      END IF

      IF Use_Listbox THEN
         FPRINT FP_WRITE, "HWND    BCX_Listbox (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
      END IF

      IF Use_Blackrect THEN
         FPRINT FP_WRITE, "HWND    BCX_BlackRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
      END IF

      IF Use_Whiterect THEN
         FPRINT FP_WRITE, "HWND    BCX_WhiteRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
      END IF

      IF Use_Grayrect THEN
         FPRINT FP_WRITE, "HWND    BCX_GrayRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
      END IF

      IF Use_Datepick THEN
         FPRINT FP_WRITE, "HWND    BCX_DatePick (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
      END IF

      IF Use_Richedit THEN
         FPRINT FP_WRITE, "HWND    BCX_RichEdit (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
         FPRINT FP_WRITE, "void    SetWindowRTFText (HWND, LPCTSTR);"
      END IF

      IF Use_Status THEN
         FPRINT FP_WRITE, "HWND    BCX_Status (LPCTSTR, HWND, int=200, int=1, int* =0);"
      END IF

      IF Use_BCX_OlePicture THEN
         FPRINT FP_WRITE, "HWND    BCX_OlePicture (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_Bitmap THEN
         FPRINT FP_WRITE, "HWND    BCX_Bitmap (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_Icon THEN
         FPRINT FP_WRITE, "HWND    BCX_Icon (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_Listview THEN
         FPRINT FP_WRITE, "HWND    BCX_ListView (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1, int=15);"
      END IF

      IF Use_Treeview THEN
         FPRINT FP_WRITE, "HWND    BCX_Treeview (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
      END IF

      IF Use_BCX_Control THEN
         FPRINT FP_WRITE, "HWND    BCX_Control (LPCTSTR, HWND, LPCTSTR, int, int, int, int, int, int=0, int=0);"
      END IF

      IF Use_ProgressBar THEN
         FPRINT FP_WRITE, "HWND    BCX_ProgressBar (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);"
      END IF

      IF Use_BCX_Slider THEN
         FPRINT FP_WRITE, "HWND    BCX_Slider (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0, int=0);"
      END IF

      IF Use_BCX_Splitter THEN
         FPRINT FP_WRITE, "void    DrawXorBar (HWND, RECT *);"
         FPRINT FP_WRITE, "int     BCX_SetSplitPos (HWND, int=50, int=0);"
         FPRINT FP_WRITE, "LRESULT CALLBACK SplitterWndProc (HWND, UINT, WPARAM, LPARAM);"
         FPRINT FP_WRITE, "HWND    BCX_Splitter (HWND, int, int=0, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_BCX_Toolbar THEN
         FPRINT FP_WRITE, "HWND    BCX_Toolbar (HWND, int, int, LPCTSTR =0, int* =0, void* =0, int* =0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_BCX_Tab THEN
         FPRINT FP_WRITE, "HWND    BCX_Tab (HWND, int, int, HWND *, char[][BCXSTRSIZE], int, int, int, int, HIMAGELIST=NULL, int=0, int=0);"
         FPRINT FP_WRITE, "HWND    BCX_AddTab (HWND, int, LPCTSTR, int=-1, int=0);"
         FPRINT FP_WRITE, "void    BCX_RemTab (HWND, int);"
         FPRINT FP_WRITE, "int     BCX_TabSelect (HWND, LPARAM);"
         FPRINT FP_WRITE, "LRESULT CALLBACK TabPageWndProc (HWND, UINT, WPARAM, LPARAM);"
         FPRINT FP_WRITE, "LRESULT CALLBACK TabCallback (HWND, UINT, WPARAM, LPARAM);"
         FPRINT FP_WRITE, "LRESULT CALLBACK TabSizeCallback (HWND, UINT, WPARAM, LPARAM);"
      END IF

      IF Use_Draw THEN
         FPRINT FP_WRITE, "HDC     StartDraw (HWND);"
         FPRINT FP_WRITE, "HBITMAP EndDraw (HWND, HDC);"
      END IF

      IF Use_BCX_UpDown THEN
         FPRINT FP_WRITE, "HWND    BCX_UpDown (HWND, int, int, int, int, int, int, int=0);"
      END IF

      IF Use_BCX_Get_UpDown THEN
         FPRINT FP_WRITE, "int     BCX_Get_UpDown (HWND);"
      END IF

      IF Use_BCX_Print THEN
         FPRINT FP_WRITE, "int     BCX_Print (HWND, int, int, LPCTSTR, HDC=0);"
      END IF

      IF Use_SetFormColor THEN
         FPRINT FP_WRITE, "void    BCX_Set_Form_Color (HWND, COLORREF);"
      END IF

      IF Use_BCX_Tile THEN
         FPRINT FP_WRITE, "void    BCX_Tile (HWND, HBITMAP);"
      END IF

      IF Use_GetText THEN
         FPRINT FP_WRITE, "char*   BCX_Get_Text (HWND);"
      END IF

      IF Use_GetResource THEN
         FPRINT FP_WRITE, "PVOID   GetResource (int, char*, DWORD*);"
      END IF

      IF Use_SetText THEN
         FPRINT FP_WRITE, "int     BCX_Set_Text (HWND, LPCTSTR);"
      END IF

      IF Use_Elf THEN
         FPRINT FP_WRITE, "void    EditLoadFile (HWND, LPCTSTR);"
      END IF

      IF Use_ListBoxLoadFile THEN
         FPRINT FP_WRITE, "void    ListBoxLoadFile (HWND, LPCTSTR, int=0, int=0);"
      END IF

      IF Use_ComboBoxLoadFile THEN
         FPRINT FP_WRITE, "void    ComboBoxLoadFile (HWND, LPCTSTR);"
      END IF

      IF Use_SetFont THEN
         FPRINT FP_WRITE, "HFONT   BCX_Set_Font (LPCTSTR, float, int=0, int=0, int=0, int=0, int=0);"
      END IF

      IF Use_BCX_Preset THEN
         FPRINT FP_WRITE, "int     BCX_Preset (HWND, int, int, HDC=0);"
      END IF

      IF Use_BCX_Line THEN
         FPRINT FP_WRITE, "int     BCX_Line (HWND, int, int, int, int, int=0, HDC=0);"
      END IF

      IF Use_BCX_Lineto THEN
         FPRINT FP_WRITE, "int     BCX_Lineto (HWND, int, int, int=0, HDC=0);"
      END IF

      IF Use_BCX_Polygon THEN
         FPRINT FP_WRITE, "int     BCX_Polygon (HWND, const POINT *, int, int=0, HDC=0);"
      END IF

      IF Use_BCX_PolyBezier THEN
         FPRINT FP_WRITE, "int     BCX_PolyBezier (HWND, const POINT *, int, int=0, HDC=0);"
      END IF

      IF Use_BCX_Polyline THEN
         FPRINT FP_WRITE, "int     BCX_Polyline (HWND, const POINT*, int, int=0, HDC=0);"
      END IF

      IF Use_BCX_Circle THEN
         FPRINT FP_WRITE, "int     BCX_Circle (HWND, int, int, int, int=0, int=0, HDC=0);"
      END IF

      IF Use_BCX_Ellipse THEN
         FPRINT FP_WRITE, "int     BCX_Ellipse (HWND, int, int, int, int, int=0, int=0, HDC=0);"
      END IF

      IF Use_BCX_Rectangle THEN
         FPRINT FP_WRITE, "int     BCX_Rectangle (HWND, int, int, int, int, int=0, int=0, HDC=0);"
      END IF

      IF Use_BCX_Roundrect THEN
         FPRINT FP_WRITE, "int     BCX_Roundrect(HWND, int, int, int, int, int, int, int=0, int=0, HDC=0);"
      END IF

      IF Use_BCX_Arc THEN
         FPRINT FP_WRITE, "int     BCX_Arc (HWND, int, int, int, int, int, int, int, int, int=0, HDC=0);"
      END IF

      IF Use_Set_BCX_Bitmap THEN
         FPRINT FP_WRITE, "void    Set_BCX_Bitmap (HWND, LPCTSTR, int=0, int=0, int=0);"
      END IF

      IF Use_Set_BCX_Bitmap2 THEN
         FPRINT FP_WRITE, "HBITMAP Set_BCX_Bitmap2 (HWND, HBITMAP, int=1);"
      END IF

      IF Use_Set_BCX_BmpButton THEN
         FPRINT FP_WRITE, "void    Set_BCX_BmpButton (HWND, LPCTSTR, int=0);"
      END IF

      IF Use_Set_BCX_Icon THEN
         FPRINT FP_WRITE, "void    Set_BCX_Icon (HWND, LPCTSTR, int=0, int=0, int=0);"
      END IF

      IF Use_BCX_Fontdlg THEN
         FPRINT FP_WRITE, "int     BCX_FontDlg (BOOL=0, HWND=0);"
      END IF

      IF Use_BCX_Pset THEN
         FPRINT FP_WRITE, "COLORREF BCX_Pset (HWND, int, int, int=0, HDC=0);"
      END IF

      IF Use_BCX_Floodfill THEN
         FPRINT FP_WRITE, "int BCX_FloodFill (HWND, int, int, int, int, HDC=0, int=0);"
      END IF

      IF Use_BCX_Getpixel THEN
         FPRINT FP_WRITE, "COLORREF BCX_Getpixel (HWND, int, int, HDC=0);"
      END IF

      IF Use_BCX_Get THEN
         FPRINT FP_WRITE, "HBITMAP BCX_Get (HWND, int, int, int, int, int=SRCCOPY, HDC=0);"
      END IF

      IF Use_BCX_Put THEN
         FPRINT FP_WRITE, "void    BCX_Put (HWND, HBITMAP, int, int, int, int, int=SRCCOPY, HDC=0);"
      END IF

      IF Use_BCX_LoadBMP THEN
         FPRINT FP_WRITE, "HBITMAP BCX_LoadBMP (LPCTSTR, int=0, int=0);"
      END IF

      IF Use_BCX_LoadImage THEN
         FPRINT FP_WRITE, "HBITMAP BCX_LoadImage (LPCTSTR, int=0);"
      END IF

      IF Use_DrawTransBMP THEN
         FPRINT FP_WRITE, "void    DrawTransBMP (HWND, HBITMAP, COLORREF, int, int, HDC=0);"
      END IF

      IF Use_BCX_BmpWidth THEN
         FPRINT FP_WRITE, "int     BCX_BmpWidth (HBITMAP);"
      END IF

      IF Use_BCX_ToolTip THEN
         FPRINT FP_WRITE, "LRESULT Bcx_ToolTip (LPCTSTR, HWND, int=0);"
         FPRINT FP_WRITE, "HWND    BCX_CreateToolTip (HWND, int);"
      END IF


      IF Use_BCX_BmpHeight THEN
         FPRINT FP_WRITE, "int     BCX_BmpHeight (HBITMAP);"
      END IF

      IF Use_QBColor THEN
         FPRINT FP_WRITE, "COLORREF qbcolor (int);"
      END IF

      IF Use_SetColor THEN
         FPRINT FP_WRITE, "LRESULT Set_Color (int, int, HDC, HWND);"
      END IF

      IF Use_PlayWav THEN
         FPRINT FP_WRITE, "void    PlayWav (LPCTSTR, int=0,  int=SND_SYNC);"
      END IF

      IF Use_SaveBmp THEN
         FPRINT FP_WRITE, "void    SaveBmp (PVOID, LPTSTR);"
      END IF

      IF Use_GetBmp THEN
         FPRINT FP_WRITE, "HDC     GetBmp (int, int, int, int, HWND);"
      END IF

      IF Use_Center THEN
         FPRINT FP_WRITE, "void    Center (HWND, HWND=0, HWND=0);"
      END IF

      IF Use_Cls THEN
         FPRINT FP_WRITE, "void    cls (void);"
      END IF

      IF Use_Color THEN
         FPRINT FP_WRITE, "void    color (int, int=0);"
      END IF

      IF Use_PushPopColors THEN
         FPRINT FP_WRITE, "void    PushColors (void);"
         FPRINT FP_WRITE, "void    PopColors  (void);"
      END IF

      IF Use_Consolesize THEN
         FPRINT FP_WRITE, "void    BCX_SetConsoleSize  (int= 80,int= 25);"
         FPRINT FP_WRITE, "void    BCX_PushConsoleSize (void);"
         FPRINT FP_WRITE, "void    BCX_PopConsoleSize  (void);"
      END IF

      IF Use_Panel THEN
         FPRINT FP_WRITE, "void    panel (int, int, int, int, int, int, int, int);"
      END IF

      IF Use_Locate THEN
         FPRINT FP_WRITE, "void    locate (int, int, int=1, int=12);"
      END IF

      IF Use_Pos THEN
         FPRINT FP_WRITE, "int     Pos (void);"
      END IF

      IF Use_Csrlin THEN
         FPRINT FP_WRITE, "int     Csrlin (void);"
      END IF

      IF Use_Run THEN
         FPRINT FP_WRITE, "int     Run (LPCTSTR, int =1, int =0);"
      END IF

      IF Use_Doevents THEN
         FPRINT FP_WRITE, "void    DoEvents (void);"
      END IF

      IF Use_Randomize THEN
         FPRINT FP_WRITE, "void    randomize (unsigned int);"
      END IF

      IF Use_Midstr THEN
         FPRINT FP_WRITE, "void    midstr (char*, int, int, char *);"
      END IF

      IF Use_Swap THEN
         FPRINT FP_WRITE, "void    swap (byte*, byte*, int);"
      END IF

      IF Use_BcxTmpStr THEN
         FPRINT FP_WRITE, "char*   BCX_TmpStr (size_t);"
      END IF


      IF Use_sziif THEN
         FPRINT FP_WRITE, "char*   sziif (int, LPCTSTR, LPCTSTR);"   ' 766 changed cond to int
      END IF

      IF Use_Using THEN
         FPRINT FP_WRITE, "char*   Using (LPCTSTR, long double);"
      END IF

      IF Use_TempFileName THEN
         FPRINT FP_WRITE, "char*   TempFileName (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_AppExePath THEN
         FPRINT FP_WRITE, "char*   AppExePath (void);"
      END IF

      IF Use_AppExeName THEN
         FPRINT FP_WRITE, "char*   AppExeName (void);"
      END IF

      IF Use_Chr THEN
         FPRINT FP_WRITE, "char*   chr (unsigned char,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0);"
      END IF

      IF Use_VChr THEN
         FPRINT FP_WRITE, "char*   vchr (int,...);"
      END IF

      IF Use_Lcase THEN
         FPRINT FP_WRITE, "char*   lcase (LPCTSTR);"
      END IF

      IF Use_Ucase THEN
         FPRINT FP_WRITE, "char*   ucase (LPCTSTR);"
      END IF

      IF Use_Mid THEN
         FPRINT FP_WRITE, "char*   mid (LPCTSTR, int, int=-1);"
      END IF

      IF Use_Ltrim THEN
         FPRINT FP_WRITE, "char*   ltrim (LPCTSTR, char=32);"
      END IF

      IF Use_Rtrim THEN
         FPRINT FP_WRITE, "char*   rtrim (LPCTSTR, char=32);"
      END IF

      IF Use_Trim THEN
         FPRINT FP_WRITE, "char*   trim (LPCTSTR);"
      END IF

      IF Use_Strim THEN
         FPRINT FP_WRITE, "char*   strim (LPCTSTR);"
      END IF

      IF Use_Left THEN
         FPRINT FP_WRITE, "char*   left (LPCTSTR, int);"
      END IF

      IF Use_Right THEN
         FPRINT FP_WRITE, "char*   right (LPCTSTR, int);"
      END IF

      IF Use_Cpad THEN
         FPRINT FP_WRITE, "char*   cpad (LPCTSTR, int, int=32);"
      END IF

      IF Use_Rpad THEN
         FPRINT FP_WRITE, "char*   rpad (LPCTSTR, int, int=32);"
      END IF

      IF Use_Lpad THEN
         FPRINT FP_WRITE, "char*   lpad (LPCTSTR, int, int=32);"
      END IF

      IF Use_String THEN
         FPRINT FP_WRITE, "char*   stringx (int, int);"
      END IF

      IF Use_Repeat THEN
         FPRINT FP_WRITE, "char*   repeat (int, LPCTSTR);"
      END IF

      IF Use_Extract THEN
         FPRINT FP_WRITE, "char*   extract (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_Remain THEN
         FPRINT FP_WRITE, "char*   remain (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_Reverse THEN
         FPRINT FP_WRITE, "char*   reverse (LPCTSTR);"
      END IF

      IF Use_Command THEN
         FPRINT FP_WRITE, "char*   command (int=-1);"
      END IF

      IF Use_Mcase THEN
         FPRINT FP_WRITE, "char*   mcase (LPCTSTR);"
      END IF

      IF Use_Replace THEN
         FPRINT FP_WRITE, "char*   replace (LPCTSTR, LPCTSTR, LPCTSTR);"
      END IF

      IF Use_iReplace THEN
         FPRINT FP_WRITE, "char*   iReplace (LPCTSTR, LPCTSTR, LPCTSTR);"
      END IF

      IF Use_Space THEN
         FPRINT FP_WRITE, "char*   space (int a);"
      END IF

      IF Use_Str THEN
         FPRINT FP_WRITE, "char*   str (double, int=0);"
      END IF

      IF Use_Strl THEN
         FPRINT FP_WRITE, "char*   strl (long double, int=0);"
      END IF

      IF Use_Mkpath THEN
         FPRINT FP_WRITE, "void    MkPath (LPCTSTR);"
      END IF

      IF Use_Findfirst THEN
         FPRINT FP_WRITE, "char*   findfirst (LPCTSTR);"
      END IF

      IF Use_Findnext THEN
         FPRINT FP_WRITE, "char*   findnext (void);"
      END IF

      IF Use_Issystem THEN
         FPRINT FP_WRITE, "int     issystem (LPCTSTR);"
      END IF

      IF Use_Ishidden THEN
         FPRINT FP_WRITE, "int     ishidden (LPCTSTR);"
      END IF

      IF Use_Isreadonly THEN
         FPRINT FP_WRITE, "int     isreadonly (LPCTSTR);"
      END IF

      IF Use_Isfile THEN
         FPRINT FP_WRITE, "int     isfile (LPCTSTR);"
      END IF

      IF Use_Isfolder THEN
         FPRINT FP_WRITE, "int     isfolder (LPCTSTR);"
      END IF
      IF Use_Curdir THEN
         FPRINT FP_WRITE, "char*   curdir (void);"
      END IF

      IF Use_Windir THEN
         FPRINT FP_WRITE, "char*   windir (void);"
      END IF

      IF Use_GetSpecialFolder THEN
         FPRINT FP_WRITE, "char*   GetSpecialFolder (int, int=0, HWND=NULL);"
      END IF

      IF Use_GetSpecialFolderex THEN
         FPRINT FP_WRITE, "char*   GetSpecialFolderEx (const GUID, DWORD = 0);"
      END IF

      IF Use_Sysdir THEN
         FPRINT FP_WRITE, "char*   sysdir (void);"
      END IF

      IF Use_Tempdir THEN
         FPRINT FP_WRITE, "char*   tempdir (void);"
      END IF

      IF Use_Environ THEN
         FPRINT FP_WRITE, "char*   Environ (LPCTSTR);"
      END IF

      IF Use_Boolstr THEN
         FPRINT FP_WRITE, "char*   BoolStr (int);"
      END IF

      IF Use_Hex THEN
         FPRINT FP_WRITE, "char*   hex (int);"
      END IF

      IF Use_Bin THEN
         FPRINT FP_WRITE, "char*   Bin (int);"
      END IF

      IF Use_Oct THEN
         FPRINT FP_WRITE, "char*   oct (int);"
      END IF

      IF Use_Date THEN
         FPRINT FP_WRITE, "char*   date (int=0);"
      END IF

      IF Use_IsoDate THEN
         FPRINT FP_WRITE, "char*   isodate (int=0);"
      END IF

      IF Use_Now THEN
         FPRINT FP_WRITE, "char*   now (int=0);"
      END IF

      IF Use_SearchPath THEN
         FPRINT FP_WRITE, "char*   SEARCHPATH (LPCTSTR);"
      END IF

      IF Use_BcxSplitPath THEN
         FPRINT FP_WRITE, "char*   BcxSplitPath (LPCTSTR, int);"
      END IF

      IF Use_BCX_Path THEN
         FPRINT FP_WRITE, "char*   BcxPath (void);"
      END IF

      IF Use_LccPath THEN
         FPRINT FP_WRITE, "char*   LccPath (void);"
      END IF

      IF Use_PellesPath THEN
         FPRINT FP_WRITE, "char*   PellesPath (void);"
      END IF

      IF Use_Strtoken THEN
         FPRINT FP_WRITE, "char*   StrToken (LPCTSTR, LPCTSTR, int);"
      END IF

      IF Use_RegExist THEN
         FPRINT FP_WRITE, "long    RegExist (HKEY, PCHAR, PCHAR);"
      END IF

      IF Use_RegString THEN
         FPRINT FP_WRITE, "char*   RegString (HKEY, LPCTSTR, LPCTSTR);"
      END IF

      IF Use_CreateRegString THEN
         FPRINT FP_WRITE, "void    CreateRegString (HKEY, LPCTSTR, LPCTSTR, LPCTSTR);"
      END IF

      IF Use_DeleteRegKey THEN
         FPRINT FP_WRITE, "void    DeleteRegKey (HKEY, LPCTSTR);"
      END IF

      IF Use_CreateRegInt THEN
         FPRINT FP_WRITE, "void    CreateRegInt (HKEY, LPCTSTR, LPCTSTR, int);"
      END IF

      IF Use_RegInt THEN
         FPRINT FP_WRITE, "int     RegInt (HKEY, LPCTSTR, LPCTSTR);"
      END IF

      IF Use_FileLocked THEN
         FPRINT FP_WRITE, "int     FileLocked (LPCTSTR);"
      END IF

      IF Use_Bff THEN
         FPRINT FP_WRITE, "char*   BFF (LPCTSTR, int=0, LPCTSTR =0);"
         FPRINT FP_WRITE, "int     CALLBACK BFFCallBack (HWND,  UINT,  LPARAM,  LPARAM);"
      END IF

      IF Use_FillArray THEN
         FPRINT FP_WRITE, "int     fillarray (LPCTSTR, int, int, void *);"
      END IF

      IF Use_Remove THEN
         FPRINT FP_WRITE, "char*   RemoveStr (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_IRemove THEN
         FPRINT FP_WRITE, "char*   IRemoveStr (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_Hook THEN
         FPRINT FP_WRITE, "LRESULT CALLBACK SBProc (int, WPARAM, LPARAM);"
      END IF

      IF Use_Getfilename THEN
         FPRINT FP_WRITE, "char*   GetFileName (LPCTSTR,LPCTSTR, int=0, HWND=0, DWORD=0, LPCTSTR =0, LPCTSTR =0, int* =0);"
      END IF

      IF Use_GetTextSize THEN
         FPRINT FP_WRITE, "SIZE*   GetTextSize (LPCTSTR, HWND=0, HFONT=0);"
      END IF

      IF Use_Time THEN
         FPRINT FP_WRITE, "char*   timef (int=0, int=0);"
      END IF

      IF Use_Join THEN
         FPRINT FP_WRITE, "char*   join (int, ... );"
      END IF

      IF Use_Enclose THEN
         FPRINT FP_WRITE, "char*   enc (LPCTSTR, int=0, int=0);"
      END IF

      IF Use_Wrap THEN
         FPRINT FP_WRITE, "char*   wrap (LPCTSTR, LPCTSTR=",ENC$(""),", LPCTSTR=",ENC$(""),");"
      END IF

      IF Use_Unwrap THEN
         FPRINT FP_WRITE, "char*   unwrap (LPCTSTR, LPCTSTR=",ENC$(""),", LPCTSTR=",ENC$(""),");"
      END IF

      IF Use_Freefile THEN
         FPRINT FP_WRITE, "FILE*   FreeFile (void);"
      END IF

      IF Use_PeekStr THEN
         FPRINT FP_WRITE, "char*   peekstr (PVOID, int);"
      END IF

      IF Use_Asc THEN
         FPRINT FP_WRITE, "int     asc (LPCTSTR, int=0);"
      END IF

      IF Use_Instrrev THEN
         FPRINT FP_WRITE, "int     InstrRev (LPCTSTR, LPCTSTR, int=0, int=0);"
      END IF

      IF Use_FirstInstance THEN
         FPRINT FP_WRITE, "BOOL    FindFirstInstance (LPCTSTR);"
      END IF

      IF Use_Bcx_stricmp THEN
         FPRINT FP_WRITE, "int     bcx_stricmp (LPCTSTR cs, LPCTSTR ct);"
      END IF

      IF Use_Instr THEN
         FPRINT FP_WRITE, "int     instr (LPCTSTR, LPCTSTR, int=0, int=0);"
      END IF

      IF Use_Stristr THEN
         FPRINT FP_WRITE, "char*   _stristr_(LPCTSTR, LPCTSTR);"
      END IF

      IF Use_Verify THEN
         FPRINT FP_WRITE, "int     Verify (LPCTSTR,  LPCTSTR);"
         FPRINT FP_WRITE, "int     VerifyInstr (LPCTSTR, LPCTSTR, int=0);"
      END IF

      IF Use_Retain THEN
         FPRINT FP_WRITE, "char*   Retain (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_LoadFile THEN
         FPRINT FP_WRITE, "char*   LoadFile (LPCTSTR);"
      END IF

      IF Use_Inchr THEN
         FPRINT FP_WRITE, "int     inchr (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_Idxqsort THEN
         FPRINT FP_WRITE, "int     IdxCompare (const void *, const void *);"
      END IF

      IF Use_IdxqsortSt THEN
         FPRINT FP_WRITE, "int     IdxCompareSt (const void *, const void *);"
      END IF

      IF Use_PtrqsortSt THEN
         FPRINT FP_WRITE, "int     PtrCompareSt (const void *, const void *);"
      END IF

      IF Use_Strqsortas THEN
         FPRINT FP_WRITE, "int     StrCompareAs (const void *, const void *);"
      END IF

      IF Use_Strqsorta THEN
         FPRINT FP_WRITE, "int     StrCompareA (const void *, const void *);"
      END IF

      IF Use_Strqsortds THEN
         FPRINT FP_WRITE, "int     StrCompareDs (const void *, const void *);"
      END IF

      IF Use_Strqsortd THEN
         FPRINT FP_WRITE, "int     StrCompareD (const void *, const void *);"
      END IF

      IF Use_DynStrqsortas THEN
         FPRINT FP_WRITE, "int     DynStrCompareAs (const void *, const void *);"
      END IF

      IF Use_DynStrqsorta THEN
         FPRINT FP_WRITE, "int     DynStrCompareA (const void *, const void *);"
      END IF

      IF Use_DynStrqsortds THEN
         FPRINT FP_WRITE, "int     DynStrCompareDs (const void *, const void *);"
      END IF

      IF Use_DynStrqsortd THEN
         FPRINT FP_WRITE, "int     DynStrCompareD (const void *, const void *);"
      END IF

      IF Use_DynAlphaNumericA THEN
         FPRINT FP_WRITE, "int     DynAlphaNumericA (const void *, const void *);"
      END IF

      IF Use_DynAlphaNumericD THEN
         FPRINT FP_WRITE, "int     DynAlphaNumericD (const void *, const void *);"
      END IF

      IF Use_AlphaNumericA THEN
         FPRINT FP_WRITE, "int     AlphaNumericA (const void *, const void *);"
      END IF

      IF Use_AlphaNumericD THEN
         FPRINT FP_WRITE, "int     AlphaNumericD (const void *, const void *);"
      END IF

      IF Use_AlphaNumeric THEN
         FPRINT FP_WRITE, "int     AlphaNumeric (const void *, const void *);"
      END IF

      IF Use_Numqsortaint THEN
         FPRINT FP_WRITE, "int     NumCompareAint (const void *,const void *);"
      END IF

      IF Use_Numqsortdint THEN
         FPRINT FP_WRITE, "int     NumCompareDint (const void *,const void *);"
      END IF

      IF Use_Numqsortafloat THEN
         FPRINT FP_WRITE, "int     NumCompareAfloat (const void *,const void *);"
      END IF

      IF Use_Numqsortdfloat THEN
         FPRINT FP_WRITE, "int     NumCompareDfloat (const void *,const void *);"
      END IF

      IF Use_Numqsortadouble THEN
         FPRINT FP_WRITE, "int     NumCompareAdouble (const void *,const void *);"
      END IF

      IF Use_Numqsortddouble THEN
         FPRINT FP_WRITE, "int     NumCompareDdouble (const void *,const void *);"
      END IF

      IF Use_Msgbox THEN
         FPRINT FP_WRITE, "int     MsgBox (LPCTSTR,LPCTSTR,int);"
      END IF

      IF Use_Like THEN
         FPRINT FP_WRITE, "int     like (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_LeftStr THEN
         FPRINT FP_WRITE, "int     LeftStr  (LPCTSTR, LPCTSTR, int = 0);"
      END IF

      IF Use_RightStr THEN
         FPRINT FP_WRITE, "int     RightStr (LPCTSTR, LPCTSTR, int = 0);"
      END IF

      IF Use_Textmode THEN
         FPRINT FP_WRITE, "int     TextMode (int);"
      END IF

      IF Use_Tally THEN
         FPRINT FP_WRITE, "int     tally (LPCTSTR, LPCTSTR, int = 0);"
      END IF

      IF Use_Diskfree THEN
         FPRINT FP_WRITE, "ULONGLONG  DiskFree (LPCTSTR);"
      END IF

      IF Use_Diskused THEN
         FPRINT FP_WRITE, "ULONGLONG  DiskUsed (LPCTSTR);"
      END IF

      IF Use_Disksize THEN
         FPRINT FP_WRITE, "ULONGLONG  DiskSize (LPCTSTR);"
      END IF

      IF Use_Hex2Dec THEN
         FPRINT FP_WRITE, "ULONGLONG  Hex2Dec (LPCTSTR);"
      END IF

      IF Use_Inkey THEN
         FPRINT FP_WRITE, "char*   inkey (void);"
      END IF

      IF Use_InkeyD THEN
         FPRINT FP_WRITE, "int     inkeyd (void);"
      END IF

      IF Use_Bin2dec THEN
         FPRINT FP_WRITE, "int     Bin2Dec (LPCTSTR);"
      END IF

      IF Use_Download THEN
         FPRINT FP_WRITE, "int     Download (LPCTSTR, LPCTSTR);"
      END IF

      IF Use_Exist THEN
         FPRINT FP_WRITE, "BOOL    Exist   (LPCTSTR);"
         FPRINT FP_WRITE, "BOOL    Exist_A (LPCTSTR);"
         FPRINT FP_WRITE, "BOOL    Exist_B (LPCTSTR);"
      END IF

      IF Use_Ins THEN
         FPRINT FP_WRITE, "char*   ins (LPCTSTR, int, LPCTSTR);"
      END IF

      IF Use_Del THEN
         FPRINT FP_WRITE, "char*   del (LPCTSTR, int, int);"
      END IF

      IF Use_Screen THEN
         FPRINT FP_WRITE, "int     Screen (int, int, int = 0);"
      END IF

      IF Use_Pause THEN
         FPRINT FP_WRITE, "void    Pause (void);"
      END IF

      IF Use_Clip_Gettext THEN
         FPRINT FP_WRITE, "char*   Clipboard_GetText (void);"
      END IF

      IF Use_Clip_Gettextsize THEN
         FPRINT FP_WRITE, "int     Clipboard_GetTextSize (void);"
      END IF

      IF  Use_Clip_Settext THEN
         FPRINT FP_WRITE, "void    Clipboard_SetText (LPCTSTR);"
      END IF

      IF Use_Clip_Getbitmap THEN
         FPRINT FP_WRITE, "HBITMAP Clipboard_GetBitmap (void);"
      END IF

      IF  Use_Clip_Setbitmap THEN
         FPRINT FP_WRITE, "void    Clipboard_SetBitmap (HBITMAP);"
      END IF

      IF Use_Keypress THEN
         FPRINT FP_WRITE, "int     keypress (void);"
      END IF

      IF Use_Lof THEN
         FPRINT FP_WRITE, "unsigned long long int  lof (LPCTSTR);"
      END IF

      IF Use_Sgn THEN
         FPRINT FP_WRITE, "double  sgn (double);"
      END IF

      IF Use_Round THEN
         FPRINT FP_WRITE, "double  Round (double, int);"
      END IF

      IF Use_Rnd THEN
         FPRINT FP_WRITE, "float   rnd (void);"
      END IF

      IF Use_Rnd2 THEN
         FPRINT FP_WRITE, "int     rnd2 (int, int);"
      END IF

      IF Use_Exp THEN
         FPRINT FP_WRITE, "double  Exp (double);"
      END IF

      IF Use_Max THEN
         FPRINT FP_WRITE, "double  MAX (double, double);"
      END IF

      IF Use_Min THEN
         FPRINT FP_WRITE, "double  MIN (double, double);"
      END IF

      IF Use_Modstyle THEN
         FPRINT FP_WRITE, "BOOL    ModStyle (HWND, DWORD = 0, DWORD = 0, BOOL = 0);"
      END IF

      IF Use_Timer THEN
         FPRINT FP_WRITE, "float   timer (void);"
      END IF

      IF Use_Iif THEN
         FPRINT FP_WRITE, "double  iif (int, double, double);"  ' 766 Changed cond to int
      END IF

      IF Use_Loc THEN
         FPRINT FP_WRITE, "int     loc (FILE *fp, int fplen);"
      END IF

      IF Use_Rec THEN
         FPRINT FP_WRITE, "int     rec (FILE *fp, int fplen);"
      END IF

      IF Use_RecCount THEN
         FPRINT FP_WRITE, "int     reccount (FILE *fp, int fplen);"
      END IF

      IF Use_Scan THEN
         FPRINT FP_WRITE, "int     scan (LPCTSTR input, LPCTSTR format, ... );"
      END IF

      IF Use_KBinput THEN
         FPRINT FP_WRITE, "void    KBinput (void);"
      END IF

      IF Use_Split THEN
         FPRINT FP_WRITE, "int     Split (char[][BCXSTRSIZE], LPCTSTR, LPCTSTR, int = 0);"
      END IF

      IF Use_DSplit THEN
         FPRINT FP_WRITE, "int     DSplit (LPSTR *, LPCTSTR, LPCTSTR, int = 0);"
      END IF

      IF Use_SysStr THEN
         FPRINT FP_WRITE, "BSTR    SysStr (LPCTSTR szIn, int = 0, int = 0);"
      END IF

      IF Use_LCaseTbl THEN
         FPRINT FP_WRITE, "unsigned char*  MakeLCaseTbl (void);"
      END IF

      IF Use_UCaseTbl THEN
         FPRINT FP_WRITE, "unsigned char*  MakeUCaseTbl (void);"
      END IF

      IF Use_Cvi THEN
         FPRINT FP_WRITE, "short   CVI (LPCTSTR);"
      END IF

      IF Use_Mki THEN
         FPRINT FP_WRITE, "char*   MKI (short);"
      END IF

      IF Use_Cvl THEN
         FPRINT FP_WRITE, "long    CVL (LPCTSTR);"
      END IF

      IF Use_Mkl THEN
         FPRINT FP_WRITE, "char*   MKL (int);"
      END IF

      IF Use_Cvs THEN
         FPRINT FP_WRITE, "float   CVS (LPCTSTR);"
      END IF

      IF Use_Mks THEN
         FPRINT FP_WRITE, "char*   MKS (float);"
      END IF

      IF Use_Cvd THEN
         FPRINT FP_WRITE, "double  CVD (LPCTSTR);"
      END IF

      IF Use_Cvld THEN
         FPRINT FP_WRITE, "long double  CVLD (LPCTSTR);"
      END IF

      IF Use_Mkd THEN
         FPRINT FP_WRITE, "char*   MKD (double);"
      END IF

      IF Use_Mkld THEN
         FPRINT FP_WRITE, "char*   MKLD (long double);"
      END IF

      IF Use_OSVersion THEN
         FPRINT FP_WRITE, "int     OSVersion (void);"
      END IF

      IF Use_Sound THEN
         FPRINT FP_WRITE, "int     Sound (float, int = 0, int = 127, int = 0, float = 1);"
         FPRINT FP_WRITE, "int     PlaySnd (void);"
      END IF

      IF Use_Hscroll OR Use_Vscroll THEN
         FPRINT FP_WRITE, "void    BCX_Scroll (HWND, int, int, int, int, int, int, int, int, int, int);"
      END IF

      IF Use_DynacallCommon THEN
         FPRINT FP_WRITE, "HINSTANCE BCX_LoadDll (LPCTSTR);"
         FPRINT FP_WRITE, "void      BCX_UnloadDll (void);"
         FPRINT FP_WRITE, "typedef   int (CALLBACK *DYNACALL1)(void);"
         IF Use_Dynacall THEN
            FPRINT FP_WRITE, "int     BCX_DynaCallB (LPCTSTR, LPCTSTR, int, ...);"
         END IF
         IF Use_DynacallA THEN
            FPRINT FP_WRITE, "int     BCX_DynaCallA (LPCTSTR, LPCTSTR, int, int *);"
         END IF
      END IF

      IF Use_DynamicA THEN
         FPRINT FP_WRITE, "void*   CreateArr (void*, int, int, int, size_t *);"
         FPRINT FP_WRITE, "void    DestroyArr (void**, int, int);"
      END IF

      IF Use_ContainedIn THEN
         FPRINT FP_WRITE, "int     containedin (char*, char **, int = 0);"
      END IF

      IF Use_FindInType THEN
         FPRINT FP_WRITE, "int     FindInType (LPCTSTR, LPCTSTR, int, int, int, int = 0, int*  = 0);"
      END IF

      IF Use_Printer THEN
         FPRINT FP_WRITE, "int     PrinterOpen  (LPCTSTR =" , ENC$("Courier New") , ", int = 12, int = DEFAULT_CHARSET);"
         FPRINT FP_WRITE, "void    PrinterWrite (LPCTSTR, int = 80, int =  60);"
         FPRINT FP_WRITE, "void    EjectPage    (void);"
         FPRINT FP_WRITE, "void    PrinterClose (void);"
      END IF

      IF Use_COM THEN
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, "//          Late binding COM support section"
         FPRINT FP_WRITE, "//  (c) Ljubisa Knezevic 2004-2009, ljube@blic.net"
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "#define COM_MSGBOX(a,b,c)MessageBox(GetActiveWindow(),(a),(b),(c))"
         FPRINT FP_WRITE, "#define COM_PROPS DISPATCH_PROPERTYGET|DISPATCH_METHOD"
         FPRINT FP_WRITE, "#define COM_PARAMS COM_param_list.pParams"
         FPRINT FP_WRITE, ""
      END IF

      IF Use_WideToAnsi THEN
         FPRINT FP_WRITE, "//<---UNICODE AWARE"
         FPRINT FP_WRITE, "char*   WideToAnsi (BSTR, UINT = CP_ACP, DWORD = 0);"
         FPRINT FP_WRITE, "//>---UNICODE AWARE"
         FPRINT FP_WRITE, ""
      END IF

      IF Use_AnsiToWide THEN
         FPRINT FP_WRITE, "//<---UNICODE AWARE"
         FPRINT FP_WRITE, "LPOLESTR AnsiToWide (LPCSTR, UINT = CP_ACP, DWORD = MB_PRECOMPOSED);"
         FPRINT FP_WRITE, "//>---UNICODE AWARE"
         FPRINT FP_WRITE, ""
      END IF

      IF Use_SafeArrays THEN
         FPRINT FP_WRITE, "HRESULT InitSafeArray    (SAFEARRAY** ppsa, VARTYPE vtype, UINT ndim, ...);"
         FPRINT FP_WRITE, "HRESULT DestroySafeArray (SAFEARRAY* psA);"
         FPRINT FP_WRITE, ""
      END IF

      IF Use_BCX_COM_UsesConversion THEN
         FPRINT FP_WRITE, "HRESULT  COM_AS2WS (LPCSTR  ansi_string, UINT code_page = CP_ACP);"
         FPRINT FP_WRITE, "HRESULT  COM_WS2AS (LPCWSTR wide_string, UINT code_page = CP_ACP);"
         FPRINT FP_WRITE, ""
      END IF


      IF Use_COM THEN
         FPRINT FP_WRITE, "#define COM_STACK_SIZE ", COM_STACK_SIZE
         FPRINT FP_WRITE, "#ifndef CON_VARBOOL2BOOL"
         FPRINT FP_WRITE, "  #define CON_VARBOOL2BOOL(b) ((BOOL)(b ? TRUE : FALSE))"
         FPRINT FP_WRITE, "#endif"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "typedef struct _OBJECT {"
         FPRINT FP_WRITE, "  IUnknown*  p_unknown;"
         FPRINT FP_WRITE, "  VARIANT    pObjects[COM_STACK_SIZE];"
         FPRINT FP_WRITE, "  BOOL       pStatus;"
         FPRINT FP_WRITE, "  int        ipointer;"
         FPRINT FP_WRITE, "}OBJECT, *LPOBJECT;"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "typedef struct _PARAM_VARARRAY {"
         FPRINT FP_WRITE, "  VARIANT  pParams[COM_STACK_SIZE];"
         FPRINT FP_WRITE, "}PARAM_VARARRAY, *LPPARAM_VARARRAY;"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, "//       COM functions used internally by BCX"
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "void     COM_ole_initialize            (void);"
         FPRINT FP_WRITE, "void     COM_ole_uninitialize          (void);"
         FPRINT FP_WRITE, "void     COM_HR_ErrMsg                 (HRESULT hr, TCHAR *extra_info);"
         FPRINT FP_WRITE, "DISPID   COM_get_dispatch_ID           (IDispatch *lpDispatch, LPOLESTR comsegment);"
         FPRINT FP_WRITE, "void     COM_get_next_dispatch         (OBJECT *object, LPOLESTR comsegment);"
         FPRINT FP_WRITE, "void     COM_invoke                    (OBJECT *object, LPOLESTR comsegment, WORD wFlags, VARIANT *pvResult);"
         FPRINT FP_WRITE, "void     COM_build_except_info         (HRESULT hr, EXCEPINFO *pexcep = NULL, UINT uiArgErr = 0);"
         FPRINT FP_WRITE, "void     COM_clean_plist               (void);"
         FPRINT FP_WRITE, "void     COM_reset_disp_chain          (OBJECT *object);"
         FPRINT FP_WRITE, "void     COM_create_safearray          (void);"

         IF COM_build_trace_code    THEN
            FPRINT FP_WRITE, "static char COM_trace_line[BCXSTRSIZE];"
         END IF

         FPRINT FP_WRITE, "void     COM_trace_dump_DISPPARAMS     (DISPPARAMS* dp);"
         FPRINT FP_WRITE, "void     COM_trace_add_line            (LPCTSTR dp);"
         FPRINT FP_WRITE, "void     COM_trace_dump_indicators     (OBJECT *object);"
         FPRINT FP_WRITE, "void     COM_trace_dump_flags          (WORD wFlags);"
         FPRINT FP_WRITE, "void     COM_FREE_TEMP_ANSI_STRING     (void);"
         FPRINT FP_WRITE, "void     COM_FREE_TEMP_WIDE_STRING     (void);"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, "//       Public COM support functions"
         FPRINT FP_WRITE, "// *************************************************"
         FPRINT FP_WRITE, ""
         FPRINT FP_WRITE, "OBJECT   COM                    (LPCTSTR);"
         FPRINT FP_WRITE, "void     UNCOM                  (OBJECT);"
         FPRINT FP_WRITE, "void     BCX_SHOW_COM_ERRORS    (BOOL);"
         FPRINT FP_WRITE, "void     BCX_SetNothing         (OBJECT*);"
         FPRINT FP_WRITE, "BOOL     BCX_GET_COM_SUCCESS    (void);"
         FPRINT FP_WRITE, "BOOL     BCX_GET_COM_STATUS     (OBJECT*);"
         FPRINT FP_WRITE, "char*    BCX_GET_COM_ERROR_DESC (void);"
         FPRINT FP_WRITE, "int      ISOBJECT               (OBJECT);"
         FPRINT FP_WRITE, "HRESULT  BCX_GET_COM_ERROR_CODE (void);"

         IF Use_BCX_COM_CreateObject THEN
            FPRINT FP_WRITE, "void     BCX_CreateObject       (TCHAR *objname, OBJECT *obj);"
         END IF

         IF Use_BCX_COM_GetObject THEN
            FPRINT FP_WRITE, "void     BCX_GetObject          (TCHAR *objname, OBJECT *obj);"
            FPRINT FP_WRITE, "void     BCX_GetObjectMon       (LPCOLESTR objname, OBJECT *obj);"
         END IF

         IF Use_BCX_COM_DispatchObject THEN
            FPRINT FP_WRITE, "void     BCX_DispatchObject     (IUnknown *iobj, OBJECT *obj, BOOL b_release = TRUE);"
         END IF

      END IF
   END IF ' IF Use_Project = FALSE
END SUB ' StdProtos


' *********************************************************************
'                                  BCX Runtime Code Library Starts Here
'                               Late binding COM support Runtime Functions
' *********************************************************************



SUB EmitCOMSupportTypes(FP_WRITE AS FILE)
   ' *********************************************************************
   ' Sub: EmitCOMSupportTypes (part of BCX COM parser)
   ' This sub emits standard typedefs and global variables
   ' used by BCX late binding COM interface.
   ' *********************************************************************
   DIM RAW prefix$ = "static "
   IF Use_Project THEN prefix$ = ""

   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, "//    Global vars used by late binding COM support"
   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE,prefix$ + "PARAM_VARARRAY  COM_param_list;"
   FPRINT FP_WRITE,prefix$ + "_TCHAR          COM_last_ErrMsg[4096];"
   FPRINT FP_WRITE,prefix$ + "_TCHAR          COM_ErrMsg[64];"
   FPRINT FP_WRITE,prefix$ + "int             COM_plist_index = 0;"
   FPRINT FP_WRITE,prefix$ + "VARIANT         COM_vt_result;"
   FPRINT FP_WRITE,prefix$ + "HRESULT         COM_last_HR;"
   FPRINT FP_WRITE,prefix$ + "BOOL            COM_ole_initd = FALSE;"
   FPRINT FP_WRITE,prefix$ + "int             COM_objects_cnt = 0;"
   FPRINT FP_WRITE,prefix$ + "int             COM_reset_chain = 0;"
   FPRINT FP_WRITE,prefix$ + "BOOL            COM_BCX_ERROR = FALSE;"
   FPRINT FP_WRITE,prefix$ + "BOOL            COM_bSHOW_ERROR = FALSE;"
   FPRINT FP_WRITE,prefix$ + "SAFEARRAY *     COM_PTR_safearray = NULL;"
   FPRINT FP_WRITE,prefix$ + "LPOLESTR        COM_LPWSTR_temp = NULL;"
   FPRINT FP_WRITE,prefix$ + "char*           COM_psz_tmp = NULL;"
   FPRINT FP_WRITE,prefix$ + "ULONG           COM_wstr_size = 0;"
   FPRINT FP_WRITE,prefix$ + "ULONG           COM_zstr_size = 0;"
   FPRINT FP_WRITE,prefix$ + "BOOL            COM_GetEnum_iface = FALSE;"

   ' <WITH - END WITH>
   FPRINT FP_WRITE,prefix$ + "int             COM_dispatch_storage[",COM_Max_Withs,"];"
   FPRINT FP_WRITE,prefix$ + "int             COM_dispatch_storage_index = 0;"
   FPRINT FP_WRITE,prefix$ + "int             COM_dispatch_at_offset = 0;" 'for nested (with/end with)
   ' </WITH - END WITH>

   IF Use_COM_Collections THEN
      FPRINT FP_WRITE,prefix$ + "VARIANT         COM_ack_var;"
      FPRINT FP_WRITE,prefix$ + "IEnumVARIANT*   COM_enum_var = NULL;"
      FPRINT FP_WRITE,prefix$ + "ULONG           COM_long_coll = 0;"
   END IF
END SUB 'EmitCOMSupportTypes





SUB Emit_BCX_COM_StandardSet (FP_WRITE AS FILE)
   ' *********************************************************************
   ' Code emission for BCX late binding COM interface.
   ' *********************************************************************
   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, "//              COM Runtime Functions"
   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE, "OBJECT COM (LPCTSTR szProgID_) {"
   FPRINT FP_WRITE, "  static OBJECT oProxy;"
   FPRINT FP_WRITE, "  BCX_CreateObject ((char*)szProgID_, &oProxy);"
   FPRINT FP_WRITE, "  return oProxy;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void UNCOM (OBJECT oObj_) {"
   FPRINT FP_WRITE, "  static OBJECT oProxy;"
   FPRINT FP_WRITE, "  oProxy = oObj_;"
   FPRINT FP_WRITE, "  BCX_SetNothing (&oProxy);"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "int ISOBJECT (OBJECT Obj) {"
   FPRINT FP_WRITE, "  if(Obj.pStatus)"
   FPRINT FP_WRITE, "      return TRUE;"
   FPRINT FP_WRITE, " else"
   FPRINT FP_WRITE, "     return FALSE;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "HRESULT BCX_GET_COM_ERROR_CODE (void) {"
   FPRINT FP_WRITE, "  return COM_last_HR;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "_TCHAR* BCX_GET_COM_ERROR_DESC (void) {"
   FPRINT FP_WRITE, "  return COM_last_ErrMsg;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "BOOL BCX_GET_COM_SUCCESS (void) {"
   FPRINT FP_WRITE, "  return (!COM_BCX_ERROR);"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void BCX_SHOW_COM_ERRORS (BOOL Show_err) {"
   FPRINT FP_WRITE, "  COM_bSHOW_ERROR = Show_err;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "BOOL BCX_GET_COM_STATUS(OBJECT *object) {"
   FPRINT FP_WRITE, "  if(object)"
   FPRINT FP_WRITE, "    return object->pStatus;"
   FPRINT FP_WRITE, "  return 0;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void  COM_clean_plist (void) {"
   FPRINT FP_WRITE, "  int total_parms = COM_plist_index;"
   FPRINT FP_WRITE, "  if (COM_plist_index > 0)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    do"
   FPRINT FP_WRITE, "    {"

   IF COM_build_trace_code THEN
      FPRINT FP_WRITE, "  sprintf(COM_trace_line, ", ENC$("+++ clear parameter list. Clear variant at index %d. Variant type = %d"), ",COM_plist_index-1,"
      FPRINT FP_WRITE, "          COM_PARAMS[COM_plist_index-1].vt);"
      FPRINT FP_WRITE, "  COM_add_trace_line (COM_trace_line);"
   END IF

   ' it appears that VariantClear can't clear a variant that has a vt = VT_ARRAY | VT_VARIANT

   FPRINT FP_WRITE, "      COM_last_HR = VariantClear (&COM_PARAMS[COM_plist_index-1]);"
   FPRINT FP_WRITE, "      if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "      {"
   FPRINT FP_WRITE, "        wsprintf (COM_ErrMsg, _T(", ENC$("\\nVariant type = %d, at index %d, total params = %d.") ,"),"
   FPRINT FP_WRITE, "                  COM_PARAMS[COM_plist_index-1].vt, COM_plist_index-1, total_parms);"
   FPRINT FP_WRITE, "        COM_HR_ErrMsg (COM_last_HR, _T(", ENC$("Error while cleaning parameter list." ),"));"
   FPRINT FP_WRITE, "      }"
   FPRINT FP_WRITE, "      COM_plist_index--;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    while (COM_plist_index > 0);"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void  COM_reset_disp_chain (OBJECT *object) {"
   FPRINT FP_WRITE, "  if (object->ipointer>COM_dispatch_at_offset)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    do"
   FPRINT FP_WRITE, "    {"

   IF COM_build_trace_code THEN
      FPRINT FP_WRITE, "  sprintf(COM_trace_line, ", ENC$("Dispath release at index %d. Variant Type = %d")
      FPRINT FP_WRITE, "  ,object->ipointer,object->pObjects[object->ipointer].vt);"
      FPRINT FP_WRITE, "  COM_add_trace_line (COM_trace_line);"
   END IF

   FPRINT FP_WRITE, "      VariantClear (&object->pObjects[object->ipointer]);"
   FPRINT FP_WRITE, "      object->ipointer--;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    while (object->ipointer > COM_dispatch_at_offset);"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void  COM_ole_uninitialize (void) {"
   FPRINT FP_WRITE, "  if (COM_objects_cnt)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    _TCHAR ermm[BCXSTRSIZE];"
   FPRINT FP_WRITE, "    wsprintf (ermm,_T(", ENC$("Check SET Nothing statement!\\nUnreleased objects: %d"), "),COM_objects_cnt);"
   FPRINT FP_WRITE, "    COM_MSGBOX (ermm, _T(", ENC$("Memory leaks detected!"), "),MB_OK|MB_ICONWARNING|MB_TASKMODAL);"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  COM_FREE_TEMP_WIDE_STRING();"
   FPRINT FP_WRITE, "  COM_FREE_TEMP_ANSI_STRING();"
   FPRINT FP_WRITE, "  CoUninitialize();"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void  COM_get_next_dispatch (OBJECT *object, LPOLESTR comsegment) {"
   FPRINT FP_WRITE, "  if (!object->pStatus) return;"
   FPRINT FP_WRITE, "  if (0 == object->ipointer) COM_BCX_ERROR = FALSE;"
   FPRINT FP_WRITE, "  if (COM_BCX_ERROR) return;"
   FPRINT FP_WRITE, "  COM_reset_chain++;"
   FPRINT FP_WRITE, "  COM_invoke (object, comsegment,COM_PROPS,&object->pObjects[object->ipointer+1]);"
   FPRINT FP_WRITE, "  COM_reset_chain--;"
   FPRINT FP_WRITE, "  if (!COM_BCX_ERROR)"
   FPRINT FP_WRITE, "     object->ipointer++;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void COM_HR_ErrMsg (HRESULT hr, _TCHAR *extra_info) {"
   FPRINT FP_WRITE, "  COM_BCX_ERROR = TRUE;"
   FPRINT FP_WRITE, "  PVOID pMsgBuf;"
   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE, "  FormatMessage (FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,"
   FPRINT FP_WRITE, "  NULL, hr, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR)&pMsgBuf, 0, NULL);"
   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE, "  wsprintf(COM_last_ErrMsg, _T(", ENC$("COM error code %d (0x%X)\\n%s\\n%s\\nmember: %s"),"),"
   FPRINT FP_WRITE, "  hr, hr, extra_info, pMsgBuf, COM_ErrMsg);"

   IF COM_build_trace_code  THEN
      FPRINT FP_WRITE, ""
      FPRINT FP_WRITE, "  COM_trace_add_line(", ENC$(">>> COM ERROR DUMP >>> COM ERROR DUM >>> COM ERROR DUMP >>>"),");"
      FPRINT FP_WRITE, "  COM_trace_add_line(COM_last_ErrMsg);"
      FPRINT FP_WRITE, "  COM_trace_add_line(", ENC$("<<< COM ERROR DUMP <<< COM ERROR DUM <<< COM ERROR DUMP <<<"),");"
      FPRINT FP_WRITE, ""
   END IF

   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE, "  memset(&COM_ErrMsg,0,sizeof(COM_ErrMsg));"
   FPRINT FP_WRITE, "  if (COM_bSHOW_ERROR)"
   FPRINT FP_WRITE, "      COM_MSGBOX(COM_last_ErrMsg,_T(",ENC$("COM Parser Error Report:"),"),"
   FPRINT FP_WRITE, "      MB_OK|MB_ICONERROR|MB_SYSTEMMODAL);"
   FPRINT FP_WRITE, "  LocalFree(pMsgBuf);"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void BCX_SetNothing (OBJECT *obj) {"
   FPRINT FP_WRITE, "  if (!obj->pStatus) return;"

   IF COM_build_trace_code THEN
      FPRINT FP_WRITE, "  COM_trace_add_line (", ENC$("Called BCX_SetNothing"), ");"
   END IF

   FPRINT FP_WRITE, "  COM_objects_cnt--;"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    if (obj->p_unknown) obj->p_unknown->Release();"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    if (obj->p_unknown) obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (obj->ipointer)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_reset_disp_chain (obj);"
   FPRINT FP_WRITE, "    obj->ipointer = 0;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  COM_last_HR = VariantClear (&obj->pObjects[0]);"
   FPRINT FP_WRITE, "  if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    lstrcpy(COM_ErrMsg, _T(", ENC$("BCX_SetNothing Failed!"),"));"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR, _T(", ENC$("Release of IDispatch objs failed!" ),"));"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  obj->pStatus = FALSE;"
   FPRINT FP_WRITE, "  Sleep(100);"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void COM_ole_initialize (void) {"
   FPRINT FP_WRITE, "  if (COM_ole_initd) return;"

   IF COM_build_trace_code  THEN
      FPRINT FP_WRITE, "DeleteFile (", ENC$("c:\\com_trace.txt"),");"
   END IF

   FPRINT FP_WRITE, "  #ifdef __BCX_MULTITHREADED__"
   FPRINT FP_WRITE, "    COM_last_HR = CoInitializeEx (NULL, COINIT_MULTITHREADED);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = CoInitializeEx (NULL, COINIT_APARTMENTTHREADED);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (SUCCEEDED (COM_last_HR))"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_ole_initd = TRUE;"
   FPRINT FP_WRITE, "    VariantInit (&COM_vt_result);"

   ' Next line atexit ANSI C function causes COM_ole_uninitialize to call when program exits

   FPRINT FP_WRITE, "    atexit (COM_ole_uninitialize);"
   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE, "    COM_dispatch_storage[0] = 0;"
   FPRINT FP_WRITE, "    COM_dispatch_storage_index = 0;"
   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE, "    if (COM_LPWSTR_temp) CoTaskMemFree((void*)COM_LPWSTR_temp);"
   FPRINT FP_WRITE, "    COM_LPWSTR_temp = (LPOLESTR)CoTaskMemAlloc (BCXSTRSIZE);"
   FPRINT FP_WRITE, "    if (NULL == COM_LPWSTR_temp)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_wstr_size = 0;"
   FPRINT FP_WRITE, "      COM_last_HR =  E_OUTOFMEMORY;"
   FPRINT FP_WRITE, "      COM_HR_ErrMsg (COM_last_HR,_T("
   FPRINT FP_WRITE, "     ",ENC$("CoInitializeEx: Memory allocation failure!"), "));"
   FPRINT FP_WRITE, "      return;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    COM_wstr_size = BCXSTRSIZE;"
   FPRINT FP_WRITE, "    if (COM_psz_tmp) free(COM_psz_tmp);"
   FPRINT FP_WRITE, "    COM_psz_tmp = (char*)calloc(BCXSTRSIZE, sizeof(char));"
   FPRINT FP_WRITE, "    if (NULL == COM_psz_tmp)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_last_HR =  E_OUTOFMEMORY;"
   FPRINT FP_WRITE, "      COM_HR_ErrMsg (COM_last_HR,_T("
   FPRINT FP_WRITE, "     ",ENC$("CoInitializeEx: Memory allocation failure!"), "));"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    COM_zstr_size = BCXSTRSIZE;"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CoInitializeEx Failed!"), "));"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void COM_build_except_info (HRESULT hr, EXCEPINFO *pexcep, UINT uiArgErr) {"
   FPRINT FP_WRITE, "  SCODE oleSCODE;"
   FPRINT FP_WRITE, "  static _TCHAR lv_message[BCXSTRSIZE];"
   FPRINT FP_WRITE, "  oleSCODE = GetScode(hr);"
   FPRINT FP_WRITE, "  for (;;)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    if (oleSCODE==DISP_E_PARAMNOTFOUND)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      wsprintf (lv_message, _T(", ENC$("\\nArgument not found, argument %d."),"), uiArgErr);"
   FPRINT FP_WRITE, "      _tcscat(COM_last_ErrMsg, lv_message);"
   FPRINT FP_WRITE, "      break;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    if (oleSCODE==DISP_E_TYPEMISMATCH)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      wsprintf (lv_message, _T(", ENC$("\\nType mismatch, argument %d."),"), uiArgErr);"
   FPRINT FP_WRITE, "      _tcscat (COM_last_ErrMsg, lv_message);"
   FPRINT FP_WRITE, "      break;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    if (oleSCODE==DISP_E_BADVARTYPE)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      _tcscat(COM_last_ErrMsg, _T(", ENC$("\\nOne or more invalid VARIANT arguments."), "));"
   FPRINT FP_WRITE, "      break;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    if (oleSCODE==E_INVALIDARG)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      _tcscat(COM_last_ErrMsg, _T(", ENC$("\\nOne of the arguments is invalid."),"));"
   FPRINT FP_WRITE, "      break;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    break;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if (pexcep)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    wsprintf(lv_message, _T(", ENC$("\\nCOM Error %X:"),"), pexcep->wCode);"
   FPRINT FP_WRITE, "    if (pexcep->bstrDescription)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      _TCHAR err_desc[512];"
   FPRINT FP_WRITE, "      #ifndef UNICODE"
   FPRINT FP_WRITE, "        COM_last_HR = COM_WS2AS (pexcep->bstrDescription);"
   FPRINT FP_WRITE, "        if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "          COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Get Error Desc: W2A failure!"),"));"
   FPRINT FP_WRITE, "        else"
   FPRINT FP_WRITE, "          wsprintf(err_desc, _T(", ENC$("\\nException desc: %s"), "), COM_psz_tmp);"
   FPRINT FP_WRITE, "      #else"
   FPRINT FP_WRITE, "          wsprintf(err_desc, _T(", ENC$("\\nException desc: %s"), "), pexcep->bstrDescription);"
   FPRINT FP_WRITE, "      #endif"
   FPRINT FP_WRITE, "      _tcscat(lv_message, err_desc);"
   FPRINT FP_WRITE, "      SysFreeString(pexcep->bstrDescription);"
   FPRINT FP_WRITE, "      pexcep->bstrDescription = NULL;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    if (pexcep->bstrSource)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      _TCHAR err_desc[512];"
   FPRINT FP_WRITE, "      #ifndef UNICODE"
   FPRINT FP_WRITE, "        COM_last_HR = COM_WS2AS (pexcep->bstrSource);"
   FPRINT FP_WRITE, "        if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "            COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Get Error Source Failed! W2A failure!"),"));"
   FPRINT FP_WRITE, "        else"
   FPRINT FP_WRITE, "            wsprintf(err_desc, _T(", ENC$("\\nException source: %s"), "), COM_psz_tmp);"
   FPRINT FP_WRITE, "      #else"
   FPRINT FP_WRITE, "            wsprintf(err_desc, _T(", ENC$("\\nException source: %s"), "), pexcep->bstrSource);"
   FPRINT FP_WRITE, "      #endif"
   FPRINT FP_WRITE, "      _tcscat (lv_message, err_desc);"
   FPRINT FP_WRITE, "      SysFreeString (pexcep->bstrSource);"
   FPRINT FP_WRITE, "      pexcep->bstrSource = NULL;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    if (pexcep->bstrHelpFile)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      _TCHAR err_desc[512];"
   FPRINT FP_WRITE, "      #ifndef UNICODE"
   FPRINT FP_WRITE, "        COM_last_HR = COM_WS2AS (pexcep->bstrHelpFile);"
   FPRINT FP_WRITE, "        if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "        COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Help File failed: W2A failure!"),"));"
   FPRINT FP_WRITE, "        else"
   FPRINT FP_WRITE, "        wsprintf(err_desc, _T("
   FPRINT FP_WRITE, "        ", ENC$("\\nHelp file: %s | topic: %lu"), "), COM_psz_tmp, pexcep->dwHelpContext);"
   FPRINT FP_WRITE, "      #else"
   FPRINT FP_WRITE, "        wsprintf(err_desc, _T("
   FPRINT FP_WRITE, "        ", ENC$("\\nHelp file: %s | topic: %lu"), "), pexcep->bstrHelpFile, pexcep->dwHelpContext);"
   FPRINT FP_WRITE, "      #endif"
   FPRINT FP_WRITE, "      _tcscat(lv_message, err_desc);"
   FPRINT FP_WRITE, "      SysFreeString (pexcep->bstrHelpFile);"
   FPRINT FP_WRITE, "      pexcep->bstrHelpFile = NULL;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    _tcscat (COM_last_ErrMsg ,lv_message);"
   FPRINT FP_WRITE, "  }"

   IF COM_build_trace_code  THEN
      FPRINT FP_WRITE, "  COM_trace_add_line(", ENC$(">>> COM EXCEPTION DUMP >>> COM EXCEPTION DUMP >>>"),");"
      FPRINT FP_WRITE, "  COM_trace_add_line(COM_last_ErrMsg);"
      FPRINT FP_WRITE, "  COM_trace_add_line(", ENC$("<<< COM EXCEPTION DUMP <<< COM EXCEPTION DUMP <<<"),");"
   END IF

   FPRINT FP_WRITE, "  if (COM_bSHOW_ERROR)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_MSGBOX(COM_last_ErrMsg, _T(", ENC$("COM Parser Exception Info:"), "),"
   FPRINT FP_WRITE, "    MB_OK|MB_ICONERROR|MB_SYSTEMMODAL);"

   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "DISPID COM_get_dispatch_ID (IDispatch* lpDispatch, LPOLESTR comsegment) {"
   FPRINT FP_WRITE, "  static DISPID D_ID;"
   FPRINT FP_WRITE, "  D_ID = 0;"
   FPRINT FP_WRITE, "  if (!lpDispatch) return -1;"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    COM_last_HR = lpDispatch->GetIDsOfNames"
   FPRINT FP_WRITE, "                 (IID_NULL, &comsegment, 1, LOCALE_SYSTEM_DEFAULT, &D_ID);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = lpDispatch->lpVtbl->GetIDsOfNames"
   FPRINT FP_WRITE, "                 (lpDispatch, &IID_NULL, &comsegment, 1, LOCALE_SYSTEM_DEFAULT, &D_ID);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Unrecognized member name" ),"));"
   FPRINT FP_WRITE, "    return -1;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  return D_ID;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void COM_invoke (OBJECT *object, LPOLESTR comsegment, WORD wFlags, VARIANT *pvResult) {"
   FPRINT FP_WRITE, "  if (!object->pStatus) return;"
   FPRINT FP_WRITE, "  if (COM_BCX_ERROR) return;"
   FPRINT FP_WRITE, "  DISPID lv_DID;"
   FPRINT FP_WRITE, "  EXCEPINFO exception;"
   FPRINT FP_WRITE, "  UINT argerr = 0;"
   FPRINT FP_WRITE, "  DISPPARAMS dp = {NULL, NULL, 0, 0 };"
   FPRINT FP_WRITE, "  WORD invoke_flags = 0;"
   FPRINT FP_WRITE, "  DISPID setdispid = DISPID_PROPERTYPUT;"

   IF COM_build_trace_code THEN
      FPRINT FP_WRITE, "  char extra_error_info[BCXSTRSIZE];"
   END IF

   FPRINT FP_WRITE, "  if (COM_GetEnum_iface)"
   FPRINT FP_WRITE, "    lv_DID = DISPID_NEWENUM;"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    lv_DID = COM_get_dispatch_ID (object->pObjects[object->ipointer].pdispVal, comsegment);"
   FPRINT FP_WRITE, "    if (-1 == lv_DID) goto cleanInProp;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  memset (&exception, 0, sizeof(EXCEPINFO));"
   FPRINT FP_WRITE, "  if (COM_plist_index>0)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    setdispid = DISPID_PROPERTYPUT;"
   FPRINT FP_WRITE, "    dp.rgvarg = (VARIANTARG*)COM_PARAMS;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if (wFlags & DISPATCH_PROPERTYPUT)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    dp.rgdispidNamedArgs = &setdispid;"
   FPRINT FP_WRITE, "    dp.cNamedArgs = 1;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  dp.cArgs = COM_plist_index;"
   FPRINT FP_WRITE, "  invoke_flags = wFlags;"
   FPRINT FP_WRITE, "  if (wFlags & DISPATCH_PROPERTYGET)"
   FPRINT FP_WRITE, "    if (pvResult) VariantInit(pvResult);"

   IF COM_build_trace_code  THEN
      FPRINT FP_WRITE, "  COM_trace_dump_DISPPARAMS(&dp);"
      FPRINT FP_WRITE, "  COM_trace_dump_flags(wFlags);"
      FPRINT FP_WRITE, "  COM_trace_dump_indicators(object);"
   END IF

   FPRINT FP_WRITE, "  if (VT_DISPATCH!=object->pObjects[object->ipointer].vt||NULL==object->pObjects[object->ipointer].pdispVal)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "     COM_last_HR = E_NOINTERFACE;"
   FPRINT FP_WRITE, "     COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("COM_invoke::Invalid IDispatch interface."), "));"
   FPRINT FP_WRITE, "     goto cleanInProp;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "    #ifdef __cplusplus"
   FPRINT FP_WRITE, "    COM_last_HR = object->pObjects[object->ipointer].pdispVal"
   FPRINT FP_WRITE, "      ->Invoke (lv_DID, IID_NULL, LOCALE_SYSTEM_DEFAULT, "
   FPRINT FP_WRITE, "        invoke_flags, &dp, pvResult, &exception, &argerr);"
   FPRINT FP_WRITE, "    #else"
   FPRINT FP_WRITE, "    COM_last_HR = object->pObjects[object->ipointer].pdispVal->lpVtbl"
   FPRINT FP_WRITE, "      ->Invoke(object->pObjects[object->ipointer].pdispVal, lv_DID, &IID_NULL, "
   FPRINT FP_WRITE, "        LOCALE_SYSTEM_DEFAULT, invoke_flags , &dp, pvResult, &exception, &argerr);"
   FPRINT FP_WRITE, "    #endif"
   FPRINT FP_WRITE, "  if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "  {"

   IF COM_build_trace_code  THEN
      FPRINT FP_WRITE, "  COM_trace_add_line(", ENC$("Invoke FAILED!"),");"
   END IF

   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("COM_invoke::Invoke failed." ),"));"
   FPRINT FP_WRITE, "    COM_build_except_info (COM_last_HR, &exception, argerr);"
   FPRINT FP_WRITE, "  }"

   IF COM_build_trace_code  THEN
      FPRINT FP_WRITE, "  else "
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    COM_add_trace_line (", ENC$("Invoke SUCEEDED!"),");"
      FPRINT FP_WRITE, "    if(wFlags & DISPATCH_PROPERTYGET)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      sprintf (extra_error_info,", ENC$("result Variant type = %d"),",pvResult->vt);"
      FPRINT FP_WRITE, "      COM_add_trace_line (extra_error_info);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
   END IF

   FPRINT FP_WRITE, "cleanInProp:"
   FPRINT FP_WRITE, "  if (V_ISARRAY(&COM_PARAMS[0]))"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    if ((VT_ARRAY|VT_VARIANT)==COM_PARAMS[0].vt)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_last_HR = SafeArrayDestroy(V_ARRAY(&COM_PARAMS[0]));"
   FPRINT FP_WRITE, "      if (FAILED (COM_last_HR) )"
   FPRINT FP_WRITE, "      {"
   FPRINT FP_WRITE, "        lstrcpy(COM_ErrMsg, _T(", ENC$("SafeArrayDestroy failed"),"));"
   FPRINT FP_WRITE, "        COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Error wiping param list." ),"));"
   FPRINT FP_WRITE, "      }"
   FPRINT FP_WRITE, "      ZeroMemory((PVOID)&COM_PARAMS[0],sizeof(VARIANT));"
   FPRINT FP_WRITE, "      COM_PTR_safearray = NULL;"
   FPRINT FP_WRITE, "      COM_plist_index = 0;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if (COM_plist_index)  COM_clean_plist();"
   FPRINT FP_WRITE, "  if (0 == COM_reset_chain)  COM_reset_disp_chain(object);"
   FPRINT FP_WRITE, "}\n\n"
END SUB ' Emit_BCX_COM_StandardSet



SUB Emit_BCX_COM_GetObject(FP_WRITE AS FILE)
   ' TCHAR is used to support UNICODE versions of programs
   FPRINT FP_WRITE, "void BCX_GetObject (_TCHAR *objname, OBJECT *obj) {"
   FPRINT FP_WRITE, "  if (!COM_ole_initd) COM_ole_initialize();"
   FPRINT FP_WRITE, "  CLSID clsid;"
   FPRINT FP_WRITE, "  #ifndef UNICODE"
   FPRINT FP_WRITE, "    COM_last_HR = COM_AS2WS (objname);"
   FPRINT FP_WRITE, "    if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! A2W failure!"),"));"
   FPRINT FP_WRITE, "      return;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    COM_last_HR = COM_WS2AS (COM_LPWSTR_temp);"
   FPRINT FP_WRITE, "    if (FAILED (COM_last_HR))"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! W2A failure!"),"));"
   FPRINT FP_WRITE, "      return;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    sprintf (COM_ErrMsg,", ENC$("%s, WideName(%s)"), ", objname, COM_psz_tmp);"
   FPRINT FP_WRITE, "    COM_last_HR = CLSIDFromProgID((LPCOLESTR)COM_LPWSTR_temp, (LPCLSID)&clsid);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = COM_WS2AS ((LPCWSTR)objname);"
   FPRINT FP_WRITE, "    lstrcpy (COM_ErrMsg, COM_psz_tmp);"
   FPRINT FP_WRITE, "    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)objname, (LPCLSID)&clsid);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (FAILED (COM_last_HR))"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "  #ifndef UNICODE"
   FPRINT FP_WRITE, "    BCX_GetObjectMon ((LPCOLESTR)COM_LPWSTR_temp, obj);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    BCX_GetObjectMon ((LPCOLESTR)objname, obj);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    COM_last_HR = GetActiveObject((REFCLSID)clsid, NULL, (IUnknown**)&obj->p_unknown);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = GetActiveObject((REFCLSID)&clsid, NULL, (IUnknown**)&obj->p_unknown);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (FAILED (COM_last_HR) )"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetActiveObject failed!"), "));"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    VariantInit (&obj->pObjects[0]);"
   FPRINT FP_WRITE, "    #ifdef __cplusplus"
   FPRINT FP_WRITE, "      COM_last_HR = obj->p_unknown"
   FPRINT FP_WRITE, "      ->QueryInterface(IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "    #else"
   FPRINT FP_WRITE, "      COM_last_HR = obj->p_unknown->lpVtbl"
   FPRINT FP_WRITE, "      ->QueryInterface(obj->p_unknown, &IID_IDispatch, (void **)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "    #endif"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if (FAILED (COM_last_HR))"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface::IID_IDispatch  failed!"),"));"
   FPRINT FP_WRITE, "    if (obj->p_unknown)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "    #ifdef __cplusplus"
   FPRINT FP_WRITE, "      obj->p_unknown->Release();"
   FPRINT FP_WRITE, "    #else"
   FPRINT FP_WRITE, "      obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
   FPRINT FP_WRITE, "    #endif"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    obj->pObjects[0].vt = VT_DISPATCH;"
   FPRINT FP_WRITE, "    obj->pStatus = TRUE;"
   FPRINT FP_WRITE, "    obj->ipointer = 0;"
   FPRINT FP_WRITE, "    COM_objects_cnt++;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void BCX_GetObjectMon (LPCOLESTR objname, OBJECT *obj) {"
   FPRINT FP_WRITE, "  IBindCtx* vBindCtx = NULL;"                  ' Bind context to be used
   FPRINT FP_WRITE, "  IMoniker* vMoniker = NULL;"                  ' Receives moniker built from display name
   FPRINT FP_WRITE, "  ULONG vChEaten = 0;"                         ' Receives number of characters consumed
   FPRINT FP_WRITE, "  COM_last_HR = CreateBindCtx(0, &vBindCtx);"  ' Receives the pointer to the bind context
   FPRINT FP_WRITE, "  if (COM_last_HR != S_OK)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetObject: CreateBindCtx failed!"),"));"
   FPRINT FP_WRITE, "    return;"                                   ' no interfaces, so it may return.
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  COM_last_HR = MkParseDisplayName(vBindCtx, objname, &vChEaten, &vMoniker);"
   FPRINT FP_WRITE, "  if (COM_last_HR != S_OK)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetObject: Receive Moniker failed!"),"));"
   FPRINT FP_WRITE, "    goto CleanGetObjectMon;"                   ' clean all and then exit.
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  VariantInit(&obj->pObjects[0]);"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    COM_last_HR = vMoniker->BindToObject(vBindCtx, NULL, IID_IDispatch, "
   FPRINT FP_WRITE, "                                        (void **)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = vMoniker->lpVtbl->BindToObject(vMoniker, vBindCtx, NULL, &IID_IDispatch,"
   FPRINT FP_WRITE, "                                                (void **)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (COM_last_HR != S_OK)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetObject: Moniker BindToObject failed!"),"));"
   FPRINT FP_WRITE, "    goto CleanGetObjectMon;"                   ' clean all and then exit.
   FPRINT FP_WRITE, "  }"                                           ' we have IDispatch, set the flags then object is ready to use
   FPRINT FP_WRITE, "  obj->p_unknown = NULL;"                      ' doesn't get IUnknown this way
   FPRINT FP_WRITE, "  obj->pObjects[0].vt = VT_DISPATCH;"
   FPRINT FP_WRITE, "  obj->pStatus = TRUE;"
   FPRINT FP_WRITE, "  obj->ipointer = 0;"
   FPRINT FP_WRITE, "  COM_objects_cnt++;"
   FPRINT FP_WRITE, "CleanGetObjectMon:"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    if (vMoniker) vMoniker->Release();"
   FPRINT FP_WRITE, "    if (vBindCtx) vBindCtx->Release();"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    if (vMoniker) vMoniker->lpVtbl->Release (vMoniker);"
   FPRINT FP_WRITE, "    if (vBindCtx) vBindCtx->lpVtbl->Release (vBindCtx);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "}\n\n"
END SUB ' Emit_BCX_COM_GetObject



SUB Emit_BCX_COM_DispatchObject(FP_WRITE AS FILE)
   FPRINT FP_WRITE, "void BCX_DispatchObject(IUnknown *iobj, OBJECT *obj, BOOL b_release) {"
   FPRINT FP_WRITE, "  if (!obj) return;"
   FPRINT FP_WRITE, "  static ULONG inc_inf_ussage=0;"
   FPRINT FP_WRITE, "  if (!COM_ole_initd) COM_ole_initialize();"
   FPRINT FP_WRITE, "  obj->p_unknown = iobj;"

   ' Now, we are going to increment IUnknown usage, so that parameter iobj can be released.

   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    inc_inf_ussage = obj->p_unknown->AddRef();"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    inc_inf_ussage = obj->p_unknown->lpVtbl->AddRef(obj->p_unknown);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  VariantInit(&obj->pObjects[0]);"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    COM_last_HR = obj->p_unknown"
   FPRINT FP_WRITE, "    ->QueryInterface(IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = obj->p_unknown->lpVtbl"
   FPRINT FP_WRITE, "    ->QueryInterface(obj->p_unknown, &IID_IDispatch,"
   FPRINT FP_WRITE, "     (void**)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (FAILED (COM_last_HR) )"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface::IID_IDispatch  failed!"),"));"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "      obj->p_unknown->Release();"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "      obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if (b_release)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "     iobj->Release();"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "     iobj->lpVtbl->Release(obj->p_unknown);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  obj->pObjects[0].vt = VT_DISPATCH;"
   FPRINT FP_WRITE, "  obj->pStatus = TRUE;"
   FPRINT FP_WRITE, "  obj->ipointer = 0;"
   FPRINT FP_WRITE, "  COM_objects_cnt++;"
   FPRINT FP_WRITE, "}\n\n"
END SUB ' Emit_BCX_COM_DispatchObject



SUB Emit_BCX_COM_GetProperty(FP_WRITE AS FILE)
   UNREFERENCED_PARAMETER(FP_WRITE)
END SUB ' Emit_BCX_COM_GetProperty



SUB Emit_BCX_COM_SetProperty(FP_WRITE AS FILE)
   UNREFERENCED_PARAMETER(FP_WRITE)
END SUB ' Emit_BCX_COM_SetProperty



SUB Emit_BCX_COM_InvokeMethod(FP_WRITE AS FILE)
   UNREFERENCED_PARAMETER(FP_WRITE)
END SUB ' Emit_BCX_COM_InvokeMethod



SUB Emit_BCX_COM_SafeArray(FP_WRITE AS FILE)
   FPRINT FP_WRITE, "void COM_create_safearray(void) {"
   FPRINT FP_WRITE, "  long lv_param_incr = 0;"
   FPRINT FP_WRITE, "  long lv_param_incr_rev = 0;"
   FPRINT FP_WRITE, "  HRESULT hr = NO_ERROR;"
   FPRINT FP_WRITE, "  COM_PTR_safearray = "
   FPRINT FP_WRITE, "  SafeArrayCreateVector (VT_VARIANT,0,COM_plist_index);"
   FPRINT FP_WRITE, "  if (COM_PTR_safearray == NULL)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_clean_plist();"
   FPRINT FP_WRITE, "    COM_last_HR = E_OUTOFMEMORY;"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("SafeArrayCreate failed."), "));"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  for (lv_param_incr = COM_plist_index-1; lv_param_incr>=0; lv_param_incr-=1)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    hr = SafeArrayPutElement (COM_PTR_safearray,"
   FPRINT FP_WRITE, "    &lv_param_incr, &COM_PARAMS[lv_param_incr_rev]);"
   FPRINT FP_WRITE, "    if (FAILED(hr))"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      wsprintf(COM_ErrMsg, _T(", ENC$("Param Index = %d."), "),lv_param_incr);"
   FPRINT FP_WRITE, "      if (COM_PTR_safearray) SafeArrayDestroy (COM_PTR_safearray);"
   FPRINT FP_WRITE, "      COM_PTR_safearray = NULL;"
   FPRINT FP_WRITE, "      COM_clean_plist();"
   FPRINT FP_WRITE, "      COM_last_HR = hr;"
   FPRINT FP_WRITE, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("SafeArrayPutElement failed!"),"));"
   FPRINT FP_WRITE, "      return;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    lv_param_incr_rev++;"
   FPRINT FP_WRITE, "  }"

   IF COM_build_trace_code THEN
      FPRINT FP_WRITE, "  COM_add_trace_line(", ENC$("SafeArray created. Cleaning temp variants...") , ");"
   END IF

   FPRINT FP_WRITE, "  COM_clean_plist();"
   FPRINT FP_WRITE, "  if(COM_PTR_safearray)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "     VariantInit (&COM_PARAMS[0]);"
   FPRINT FP_WRITE, "     COM_PARAMS[0].vt = VT_ARRAY|VT_VARIANT;"
   FPRINT FP_WRITE, "     V_ARRAY (&COM_PARAMS[0]) = COM_PTR_safearray;"
   FPRINT FP_WRITE, "     COM_plist_index = 1;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
END SUB ' Emit_BCX_COM_SafeArray



SUB Emit_BCX_COM_UsesConversion(FP_WRITE AS FILE)
   FPRINT FP_WRITE, "HRESULT COM_WS2AS(LPCWSTR wide_string, UINT code_page) {"
   FPRINT FP_WRITE, "  if (wide_string==NULL) return (HRESULT) NO_ERROR;"
   FPRINT FP_WRITE, "  ULONG bytes_copied=0;"
   FPRINT FP_WRITE, "  ULONG temp_ansi_len = (ULONG)WideCharToMultiByte ("
   FPRINT FP_WRITE, "  code_page,0,wide_string,-1,COM_psz_tmp,0,NULL,NULL);"
   FPRINT FP_WRITE, "  if (temp_ansi_len == 0) return (HRESULT) NO_ERROR;"
   FPRINT FP_WRITE, "  if (COM_zstr_size < temp_ansi_len)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    if (COM_psz_tmp) free(COM_psz_tmp);"
   FPRINT FP_WRITE, "    COM_psz_tmp = (char*)calloc(temp_ansi_len+1,sizeof(char));"
   FPRINT FP_WRITE, "    if (NULL == COM_psz_tmp)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_zstr_size = 0;"
   FPRINT FP_WRITE, "      return E_OUTOFMEMORY;"
   FPRINT FP_WRITE, "    } "
   FPRINT FP_WRITE, "    COM_zstr_size = temp_ansi_len;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if ((bytes_copied = WideCharToMultiByte(code_page, 0, wide_string, -1,"
   FPRINT FP_WRITE, "       COM_psz_tmp, temp_ansi_len,NULL, NULL))==0)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    return HRESULT_FROM_WIN32 (GetLastError());"
   FPRINT FP_WRITE, "  } "
   FPRINT FP_WRITE, "  COM_psz_tmp [bytes_copied] = '\\0';"
   FPRINT FP_WRITE, "  return (HRESULT)NO_ERROR;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "HRESULT COM_AS2WS(LPCSTR ansi_string, UINT code_page) {"
   FPRINT FP_WRITE, "  if (!*ansi_string) return (HRESULT)NO_ERROR;"
   FPRINT FP_WRITE, "  ULONG ansi_str_len = (ULONG)strlen (ansi_string);"
   FPRINT FP_WRITE, "  if (!ansi_str_len) return (HRESULT)NO_ERROR;"
   FPRINT FP_WRITE, "  ULONG wide_str_len = (ansi_str_len * 2);"
   FPRINT FP_WRITE, "  if (COM_wstr_size < wide_str_len)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    if (COM_LPWSTR_temp)"
   FPRINT FP_WRITE, "       CoTaskMemFree((void*)COM_LPWSTR_temp);"
   FPRINT FP_WRITE, "    COM_LPWSTR_temp = (LPOLESTR)CoTaskMemAlloc (wide_str_len);"
   FPRINT FP_WRITE, "    if (NULL == COM_LPWSTR_temp)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_wstr_size = 0;"
   FPRINT FP_WRITE, "      return E_OUTOFMEMORY;"
   FPRINT FP_WRITE, "    } "
   FPRINT FP_WRITE, "    COM_wstr_size = wide_str_len;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if (MultiByteToWideChar (code_page, MB_PRECOMPOSED, ansi_string, "
   FPRINT FP_WRITE, "      ansi_str_len, COM_LPWSTR_temp, wide_str_len)==0)"
   FPRINT FP_WRITE, "         return HRESULT_FROM_WIN32(GetLastError());"
   FPRINT FP_WRITE, "  COM_LPWSTR_temp[ansi_str_len] = L'\\0';"
   FPRINT FP_WRITE, "  return (HRESULT)NO_ERROR;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void COM_FREE_TEMP_WIDE_STRING(void) {"
   FPRINT FP_WRITE, "  if (COM_LPWSTR_temp)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    CoTaskMemFree ((void*)COM_LPWSTR_temp);"
   FPRINT FP_WRITE, "    COM_LPWSTR_temp = NULL;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void COM_FREE_TEMP_ANSI_STRING (void) {"
   FPRINT FP_WRITE, "  if (COM_psz_tmp)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    free (COM_psz_tmp);"
   FPRINT FP_WRITE, "    COM_psz_tmp = NULL;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}"
END SUB ' Emit_BCX_COM_UsesConversion



SUB Emit_BCX_COM_TraceCalls(FP_WRITE AS FILE)
   FPRINT FP_WRITE, "void bcx_com_trace_dump_DISPPARAMS(DISPPARAMS* dp) {"
   FPRINT FP_WRITE, "  COM_add_trace_line(", ENC$("   --- BEGIN DUMP OF DISPPARAMS  ---"), ");"
   FPRINT FP_WRITE, "  if (!dp)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_add_trace_line(", ENC$("*** bcx_com_trace_dump_DISPPARAMS failed!"), ");"
   FPRINT FP_WRITE, "    COM_add_trace_line(", ENC$("*** NULL argument received for DISPPARAMS* dp"), ");"
   FPRINT FP_WRITE, "    COM_add_trace_line(", ENC$("   --- END DUMP OF DISPPARAMS ---"), ");"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.rgvarg = %lu  // pointer to array of arguments."), ", dp->rgvarg);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.rgdispidNamedArgs = %lu // pointer to array of Dispatch IDs of named arguments."), ", dp->rgdispidNamedArgs);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.cArgs = %d // Number of arguments."), ", dp->cArgs);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.cNamedArgs = %d  // Number of named arguments"), ", dp->cNamedArgs);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  COM_add_trace_line(", ENC$("   --- END DUMP OF DISPPARAMS ---"), ");"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void bcx_com_trace_dump_indicators(OBJECT *object) {"
   FPRINT FP_WRITE, "  COM_add_trace_line(", ENC$("*** start dump of global vars ***"),");"
   FPRINT FP_WRITE, "  if (object->pStatus)"
   FPRINT FP_WRITE, "     strcpy(COM_trace_line, ", ENC$("   Object status - Initialized"), ");"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "     strcpy(COM_trace_line, ", ENC$("   Object status - UnInitialized"), ");"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("   dispatch chain index = %d"), ", object->ipointer);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("   Count of params = %d"), ", COM_plist_index);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("   COM_ole_initd = %d"), ", COM_ole_initd);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("   COM_objects_cnt = %d"), ", COM_objects_cnt);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("   don't reset dispatch chain afer invoke = %d"), ", COM_reset_chain);"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "  COM_add_trace_line(", ENC$("*** end dump of global vars ***"),");"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void bcx_com_trace_dump_flags(WORD wFlags) {"
   FPRINT FP_WRITE, "  wsprintf(COM_trace_line, ", ENC$("calling invoke with flags: "), ");"
   FPRINT FP_WRITE, "  if(wFlags & DISPATCH_PROPERTYPUT) strcat(COM_trace_line,", ENC$("| DISPATCH_PROPERTYPUT "), ");"
   FPRINT FP_WRITE, "  if(wFlags & DISPATCH_PROPERTYGET) strcat(COM_trace_line,", ENC$("| DISPATCH_PROPERTYGET "), ");"
   FPRINT FP_WRITE, "  if(wFlags & DISPATCH_PROPERTYPUTREF) strcat(COM_trace_line,", ENC$("| DISPATCH_PROPERTYPUTREF "), ");"
   FPRINT FP_WRITE, "  if(wFlags & DISPATCH_METHOD) strcat(COM_trace_line,", ENC$("| DISPATCH_METHOD "), ");"
   FPRINT FP_WRITE, "  COM_add_trace_line(COM_trace_line);"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "void COM_add_trace_line(LPCTSTR trcline) {"
   FPRINT FP_WRITE, "  static FILE *com_trc_file;"
   FPRINT FP_WRITE, "  if((com_trc_file=fopen(", ENC$("c:\\com_trace.txt"),",",ENC$("a"),"))==0)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    fprintf(stderr,", ENC$("Can't open file c:\\com_trace.txt\\n"),");"
   FPRINT FP_WRITE, "    exit(1);"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  fprintf(com_trc_file,", ENC$("%s\\n"),", trcline);"
   FPRINT FP_WRITE, "  if (com_trc_file)"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    fflush(com_trc_file);"
   FPRINT FP_WRITE, "    fclose(com_trc_file);"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
END SUB ' Emit_BCX_COM_TraceCalls



SUB Emit_BCX_SAFEARRAY(FP_WRITE AS FILE)
   FPRINT FP_WRITE, "HRESULT InitSafeArray (SAFEARRAY **ppsa, VARTYPE vtype, UINT ndim, ...) {"
   FPRINT FP_WRITE, "  int iCNT;"
   FPRINT FP_WRITE, "  int iDIM;"
   FPRINT FP_WRITE, "  va_list  marker;"
   FPRINT FP_WRITE, "  SAFEARRAYBOUND  tArraySize[10];"
   FPRINT FP_WRITE, "  va_start(marker,ndim);"
   FPRINT FP_WRITE, "  iCNT = 0;"
   FPRINT FP_WRITE, "  iDIM = ndim;"
   FPRINT FP_WRITE, "  while(iDIM--)"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      tArraySize[iCNT].lLbound = va_arg(marker,long);"
   FPRINT FP_WRITE, "      tArraySize[iCNT].cElements = va_arg(marker,long);"
   FPRINT FP_WRITE, "      iCNT++;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "  *ppsa = SafeArrayCreate (vtype,ndim,tArraySize);"
   FPRINT FP_WRITE, "  if(*ppsa == NULL)"
   FPRINT FP_WRITE, "      return E_OUTOFMEMORY;"
   FPRINT FP_WRITE, "  return S_OK;"
   FPRINT FP_WRITE, "}\n\n"
   FPRINT FP_WRITE, "HRESULT DestroySafeArray(SAFEARRAY *psA) {"
   FPRINT FP_WRITE, "  return SafeArrayDestroy(psA);"
   FPRINT FP_WRITE, "}\n"
END SUB ' Emit_BCX_SAFEARRAY



SUB Emit_BCX_COM_CreateObject (FP_WRITE AS FILE)
   FPRINT FP_WRITE, "void BCX_CreateObject (_TCHAR *objname, OBJECT *obj) {"
   FPRINT FP_WRITE, "  if (!COM_ole_initd) COM_ole_initialize();"
   FPRINT FP_WRITE, "  CLSID clsid;"
   FPRINT FP_WRITE, "  #ifndef UNICODE"
   FPRINT FP_WRITE, "    COM_last_HR = COM_AS2WS(objname);"
   FPRINT FP_WRITE, "    if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! A2W failure!"),"));"
   FPRINT FP_WRITE, "      return;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    COM_last_HR = COM_WS2AS(COM_LPWSTR_temp);"
   FPRINT FP_WRITE, "    if (FAILED (COM_last_HR) )"
   FPRINT FP_WRITE, "    {"
   FPRINT FP_WRITE, "       COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! W2A failure!"),"));"
   FPRINT FP_WRITE, "      return;"
   FPRINT FP_WRITE, "    }"
   FPRINT FP_WRITE, "    sprintf(COM_ErrMsg,", ENC$("%s, WideName(%s)"), ", objname, COM_psz_tmp);"
   FPRINT FP_WRITE, "    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)COM_LPWSTR_temp, (LPCLSID)&clsid);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    lstrcpy(COM_ErrMsg, objname);"
   FPRINT FP_WRITE, "    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)objname, (LPCLSID)&clsid);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (FAILED (COM_last_HR) )"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CLSIDFromProgID failed!"),"));"
   FPRINT FP_WRITE, "    return;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    COM_last_HR = CoCreateInstance((REFCLSID)clsid, NULL,  "
   FPRINT FP_WRITE, "    CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown, (void **)&obj->p_unknown);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = CoCreateInstance ((REFCLSID)&clsid, NULL, "
   FPRINT FP_WRITE, "    CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER,&IID_IUnknown, (void **)&obj->p_unknown);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  if (FAILED (COM_last_HR) )"
   FPRINT FP_WRITE, "     COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CoCreateInstance failed!"),"));"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    VariantInit(&obj->pObjects[0]);"
   FPRINT FP_WRITE, "    obj->pObjects[0].vt = VT_DISPATCH;"
   FPRINT FP_WRITE, "  #ifdef __cplusplus"
   FPRINT FP_WRITE, "    COM_last_HR = obj->p_unknown"
   FPRINT FP_WRITE, "    ->QueryInterface(IID_IDispatch, (void **)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "  #else"
   FPRINT FP_WRITE, "    COM_last_HR = obj->p_unknown->lpVtbl"
   FPRINT FP_WRITE, "    ->QueryInterface(obj->p_unknown, &IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);"
   FPRINT FP_WRITE, "  #endif"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  if (FAILED(COM_last_HR))"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface::IID_IDispatch  failed!"),"));"
   FPRINT FP_WRITE, "    obj->pObjects[0].vt = VT_NULL;"
   FPRINT FP_WRITE, "    VariantClear(&obj->pObjects[0]);"
   FPRINT FP_WRITE, "    #ifdef __cplusplus"
   FPRINT FP_WRITE, "       obj->p_unknown->Release();"
   FPRINT FP_WRITE, "    #else"
   FPRINT FP_WRITE, "       obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
   FPRINT FP_WRITE, "    #endif"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "  else"
   FPRINT FP_WRITE, "  {"
   FPRINT FP_WRITE, "    obj->pStatus = TRUE;"
   FPRINT FP_WRITE, "    obj->ipointer = 0;"
   FPRINT FP_WRITE, "    COM_objects_cnt++;"
   FPRINT FP_WRITE, "  }"
   FPRINT FP_WRITE, "}\n\n"
END SUB ' Emit_BCX_COM_CreateObject



SUB Emit_VBSCRIPT_Support
   DIM STATIC nTimes = 0
   IF nTimes > 0 THEN EXIT SUB
   INCR nTimes
   Use_AnsiToWide = Use_WideToAnsi = TRUE
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// ****************************************"
   FPRINT FP_HDR, "// ***** ";$BCX_STR_VBS_STRUCTS;"  *****"
   FPRINT FP_HDR, "// ****************************************"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "const GUID IID_IScriptControl ="
   FPRINT FP_HDR, "{"
   FPRINT FP_HDR, "   0x0e59f1d3,0x1fbe,0x11d0,"
   FPRINT FP_HDR, "  {0x8f,0xf2,0x00,0xa0,0xd1,0x00,0x38,0xbc}"
   FPRINT FP_HDR, "};"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "enum ScriptControlStates"
   FPRINT FP_HDR, "{"
   FPRINT FP_HDR, "  SCRIPTSTATE_UNINITIALIZED0, SCRIPTSTATE_STARTED1, SCRIPTSTATE_CONNECTED2,"
   FPRINT FP_HDR, "  SCRIPTSTATE_DISCONNECTED3, SCRIPTSTATE_CLOSED4, SCRIPTSTATE_INITIALIZED5"
   FPRINT FP_HDR, "};"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "const GUID IID_IScriptError ="
   FPRINT FP_HDR, "{"
   FPRINT FP_HDR, "   0x70841C78, 0x67D, 0x11D0,"
   FPRINT FP_HDR, "  {0x95, 0xD8, 0x0, 0xA0, 0x24, 0x63, 0xAB, 0x28}"
   FPRINT FP_HDR, "};"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// *******************************************************************"
   FPRINT FP_HDR, "#undef  INTERFACE"
   FPRINT FP_HDR, "#define INTERFACE IScriptError"
   FPRINT FP_HDR, "// *******************************************************************"
   FPRINT FP_HDR, "DECLARE_INTERFACE_(IScriptError, IDispatch) {"
   FPRINT FP_HDR, "STDMETHOD (QueryInterface)(THIS_ REFIID riid, PVOID *ppvObj) PURE;"
   FPRINT FP_HDR, "STDMETHOD_(ULONG, AddRef)(THIS)  PURE;"
   FPRINT FP_HDR, "STDMETHOD_(ULONG, Release)(THIS) PURE;"
   FPRINT FP_HDR, "STDMETHOD (GetTypeInfoCount)(THIS_ UINT *pctinfo) PURE;"
   FPRINT FP_HDR, "STDMETHOD (GetTypeInfo)(THIS_ UINT itinfo, LCID lcid,"
   FPRINT FP_HDR, "ITypeInfo **pptinfo) PURE;"
   FPRINT FP_HDR, "STDMETHOD (GetIDsOfNames)(THIS_ REFIID riid, OLECHAR **rgszNames,"
   FPRINT FP_HDR, "           UINT cNames, LCID lcid, DISPID *rgdispid) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Invoke)(THIS_ DISPID dispidMember, REFIID riid, LCID lcid,"
   FPRINT FP_HDR, "           WORD wFlags, DISPPARAMS *pdispparams, VARIANT *pvarResult,"
   FPRINT FP_HDR, "           EXCEPINFO *pexcepinfo, UINT *puArgErr) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_Number)(THIS_ long *pNumber) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_Source)(THIS_ BSTR *pbstrSource) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_Description)(THIS_ BSTR *pbstrDescription) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_HelpFile)(THIS_ BSTR *pbstrHelpFile) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_HelpContext)(THIS_ long *pHelpContext) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_Text)(THIS_ BSTR *pbstrText) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_Line)(THIS_ long *pLine) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Get_Column)(THIS_ long *pColumn) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Clear)(THIS) PURE;};"
   FPRINT FP_HDR, ""
   FPRINT FP_HDR, "// *******************************************************************"
   FPRINT FP_HDR, "#undef  INTERFACE"
   FPRINT FP_HDR, "#define INTERFACE IScriptControl"
   FPRINT FP_HDR, "// *******************************************************************"
   FPRINT FP_HDR, "DECLARE_INTERFACE_(IScriptControl, IDispatch) {"
   FPRINT FP_HDR, "STDMETHOD (QueryInterface)(THIS_ REFIID riid, PVOID *ppvObj) PURE;"
   FPRINT FP_HDR, "STDMETHOD_(ULONG, AddRef)(THIS)  PURE;"
   FPRINT FP_HDR, "STDMETHOD_(ULONG, Release)(THIS) PURE;"
   FPRINT FP_HDR, "STDMETHOD (GetTypeInfoCount)(THIS_ UINT *pctinfo) PURE;"
   FPRINT FP_HDR, "STDMETHOD (GetTypeInfo)(THIS_ UINT itinfo, LCID lcid,"
   FPRINT FP_HDR, "ITypeInfo  **pptinfo) PURE;"
   FPRINT FP_HDR, "STDMETHOD (GetIDsOfNames)(THIS_ REFIID riid, OLECHAR **rgszNames,"
   FPRINT FP_HDR, "           UINT cNames, LCID lcid, DISPID *rgdispid) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Invoke)(THIS_ DISPID dispidMember, REFIID riid, LCID lcid,"
   FPRINT FP_HDR, "           WORD wFlags, DISPPARAMS *pdispparams, VARIANT *pvarResult,"
   FPRINT FP_HDR, "           EXCEPINFO *pexcepinfo, UINT *puArgErr) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_Language)(THIS_ BSTR* pbstrLanguage) PURE;"
   FPRINT FP_HDR, "STDMETHOD (put_Language)(THIS_ BSTR pbstrLanguage) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_State)(THIS_ enum ScriptControlStates* pssState) PURE;"
   FPRINT FP_HDR, "STDMETHOD (put_State)(THIS_ enum ScriptControlStates pssState ) PURE;"
   FPRINT FP_HDR, "STDMETHOD (put_SitehWnd)(THIS_ long phwnd) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_SitehWnd)(THIS_ long* phwnd) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_Timeout)(THIS_ long* plMilliseconds) PURE;"
   FPRINT FP_HDR, "STDMETHOD (put_Timeout)(THIS_ long plMilliseconds) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_AllowUI)(THIS_ VARIANT_BOOL* pfAllowUI) PURE;"
   FPRINT FP_HDR, "STDMETHOD (put_AllowUI)(THIS_ VARIANT_BOOL pfAllowUI) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_UseSafeSubset)(THIS_ VARIANT_BOOL* pfUseSafeSubset) PURE;"
   FPRINT FP_HDR, "STDMETHOD (put_UseSafeSubset)(THIS_ VARIANT_BOOL pfUseSafeSubset) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_Modules)(THIS_ interface"
   FPRINT FP_HDR, "           IScriptModuleCollection** ppmods) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_Error)(THIS_ interface IScriptError** ppse) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_CodeObject)(THIS_ IDispatch** ppdispObject) PURE;"
   FPRINT FP_HDR, "STDMETHOD (get_Procedures)(THIS_ interface"
   FPRINT FP_HDR, "           IScriptProcedureCollection** ppdispProcedures) PURE;"
   FPRINT FP_HDR, "STDMETHOD (_AboutBox)(THIS) PURE;"
   FPRINT FP_HDR, "STDMETHOD (AddObject)(THIS_ BSTR Name, IDispatch* Object,"
   FPRINT FP_HDR, "           VARIANT_BOOL AddMembers) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Reset)(THIS) PURE;"
   FPRINT FP_HDR, "STDMETHOD (AddCode)(THIS_ BSTR Code) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Eval)(THIS_ BSTR Expression, VARIANT* pvarResult) PURE;"
   FPRINT FP_HDR, "STDMETHOD (ExecuteStatement)(THIS_ BSTR Statement) PURE;"
   FPRINT FP_HDR, "STDMETHOD (Run)(THIS_ BSTR ProcedureName, SAFEARRAY** Parameters,"
   FPRINT FP_HDR, "           VARIANT* pvarResult) PURE;};"
   FPRINT FP_HDR, ""

   IF Use_Project   THEN
      FPRINT FP_HDR, "BOOL OLE_ERROR_S;"
      FPRINT FP_HDR, "IScriptControl *pSC;"
   ELSE
      FPRINT FP_HDR, "static BOOL OLE_ERROR_S;"
      FPRINT FP_HDR, "static IScriptControl *pSC;"
   END IF

   AddLibrary("ole32.lib")
   AddLibrary("oleaut32.lib")
END SUB 'Emit_VBSCRIPT_Support





SUB Add_COM_Global_Variable(p_name$)
   ' ************************************************************************************************************
   ' Sub: Add_COM_Global_Variable (part of BCX COM parser)
   ' This sub adds OBJECT variable to global space, which is cleaned on program end.
   ' If the Global nnn an Object or Dim nnn as Object is called otside Functions ans Subs,
   ' than nnn will be added to global COM names space. This is used so that object variables could be identifed.
   ' ************************************************************************************************************
   IF LEN(p_name$) > 64 THEN Abort("Length of object variable " + p_name$ + " is:" + STR$((INT)LEN(p_name$)) + ". Maximum allowed is 64 characters.")
   IF COM_gl_names_index = COM_Max_Gl_Objs THEN
      Abort("Max number of Global COM object variables reached:" + STR$(COM_Max_Gl_Objs) + CRLF$ + "Failed to reserve space for Object variable: " + p_name$)
      EXIT SUB
   END IF
   strcpy(COM_gl_names[COM_gl_names_free_index].name, p_name)
   COM_gl_names[COM_gl_names_free_index].initialized = TRUE
   INCR COM_gl_names_index
   COM_gl_names_free_index = COM_gl_names_index
END SUB ' Add_COM_Global_Variable




SUB Add_COM_Local_Variable(p_name$)
   ' ************************************************************************************************************
   ' Sub: Add_COM_Local_Variable (part of BCX COM parser)
   ' This sub adds OBJECT variable to local space, which is cleaned on exit or return from function/sub
   ' If the Dim nnn as Object is called inside Functions ans Subs, than nnn will be added to local
   ' COM object space. This is used so that object variables could be identifed.
   ' ************************************************************************************************************
   IF LEN(p_name$) > 64 THEN Abort("Length of object variable " + p_name$ + " is:" + STR$((INT)LEN(p_name$)) + ". Maximum allowed is 64 characters.")
   IF COM_lc_names_index = COM_Max_Lc_Objs THEN
      Abort("Max number of Local COM object variables reached:" + STR$(COM_Max_Lc_Objs) + CRLF$ + "Failed to reserve space for Object variable: " + p_name$)
      EXIT SUB
   END IF
   strcpy(COM_lc_names[COM_lc_names_free_index].name, p_name)
   COM_lc_names[COM_lc_names_free_index].initialized = TRUE
   INCR COM_lc_names_index
   COM_lc_names_free_index = COM_lc_names_index
END SUB ' Add_COM_Local_Variable




FUNCTION IsVariableComObject%(p_varname$)
   ' ************************************************************************************************************
   ' Function: IsVariableComObject (part of BCX COM parser)
   ' Checks whether variable is COM initialized as COM object or not.
   ' Return Values:
   ' Function returns index (base 1) of COM object in storage.
   ' If the name is found in local storage, it will return positive index.
   ' If the name is found in global storage, it will return index with negative preffix.
   ' Zero (0) indicates that the name is not found in COM names storage.
   ' ************************************************************************************************************
   DIM RAW sz_var_name$
   DIM RAW l_index AS INT

   sz_var_name$ = TRIM$(p_varname$)

   IF COM_lc_names_index > 0 THEN      ' First try to find it in local COM object space
      FOR l_index = 0 TO COM_lc_names_index-1
         IF COM_lc_names[l_index].initialized = TRUE THEN
            IF sz_var_name$ = COM_lc_names[l_index].name$ THEN
               FUNCTION = l_index + 1      ' If found, then return index of it
            END IF
         END IF
      NEXT
   END IF

   IF COM_gl_names_index > 0 THEN    ' Try to find it in global COM object space
      FOR l_index = 0 TO COM_gl_names_index-1
         IF COM_gl_names[l_index].initialized = TRUE THEN
            ' if it is found, then return negative index of it, indicating that it is a global variable
            IF sz_var_name$ = COM_gl_names[l_index].name$ THEN FUNCTION = (-1 * (l_index + 1))
         END IF
      NEXT
   END IF
   FUNCTION = 0 ' not found, so return 0
END FUNCTION   ' IsVariableComObject




SUB BCX_FreeLocalCOMObjects(p_remove AS BOOL)
   ' *********************************************************************
   ' Sub: BCX_FreeLocalCOMObjects (part of BCX COM parser)
   ' This sub is called when user forgot to call
   ' "Set ... = Nothing" for each created COM object.
   ' *********************************************************************
   DIM LOCAL j AS INT
   DIM LOCAL eraseOffset
   DO
      IF COM_lc_names[j].initialized = TRUE THEN
         'FPRINT Outfile, Scoot$,"if (",COM_lc_names[j].name$, ".pStatus) BCX_SetNothing(&",COM_lc_names[j].name$,");"
      ELSE
         ' If it comes here, than it means that at this index, object is already released.
         ' It will happen when user calls "Set ... = Nothing" for some COM objects but not for all.
         INCR eraseOffset
      END IF
      INCR j
   LOOP WHILE j < (COM_lc_names_index + eraseOffset)
   IF p_remove = TRUE THEN
      COM_lc_names_index = 0
      COM_lc_names_free_index = 0
   END IF
END SUB  'BCX_FreeLocalCOMObjects



FUNCTION Find_COM_statement(pp_Src$) AS BOOL
   ' *********************************************************************************
   ' Function: Find_COM_statement (part of BCX COM parser)
   ' The one and only ... *** Main  COM parser *** !!!
   '
   ' Return Values:
   ' Function returns TRUE indicating that COM statement is found in currently parsed
   ' BCX line, or FALSE if COM statement is NOT found in current BCX source line.
   ' *********************************************************************************
   DIM FOUND_OBJECT
   DIM FOUND_DOT
   DIM FOUND_EQU
   DIM RAW p_Src$
   DIM RAW word_left$
   DIM RAW prev_word_left$
   DIM RAW j AS INT

   p_Src$ = pp_Src$
   IF p_Src$ = "endwith" THEN FUNCTION = FALSE
   IF ISNULL(p_Src$) THEN FUNCTION = FALSE
   ProcessingCOM_Set = FALSE
   IF LEFTSTR(pp_Src$,"set ",TRUE) THEN
      ProcessingCOM_Set = TRUE
      pp_Src$ = TRIM$(MID$(pp_Src$,5))
      p_Src$ = pp_Src$
   END IF
   IF iMatchLft(p_Src$,"for ") THEN FUNCTION = FALSE
   ' handles with - end with constructions used in COM statements
   IF iMatchLft(p_Src$,"with ") THEN
      word_left$ = TRIM$(MID$(p_Src$,6))
      IF COM_open_WITH_statement THEN
         IF word_left[0] = 46 THEN ' Found "." this means that this is a nested (WITH - END WITH)
            INCR COM_open_WITH_statement
            p_Src$ = COM_with_temp_str_name$ + " = " + COM_with_temp_str_name$ + word_left$
         ELSE
            Abort ("Nested <WITH> statements, in open WITH block, are allowed only for interfaces of same COM object. For more info, see rules for using COM in BCX.")
         END IF
      ELSE ' first with block
         prev_word_left$ = TRIM$(EXTRACT$(word_left$, "."))
         IF IsVariableComObject(prev_word_left$) THEN
            INCR COM_open_WITH_statement
            COM_with_temp_str_name$ = prev_word_left$
            p_Src$ = word_left$
            IF INCHR(p_Src$,".") = 0 THEN
               pp_Src$ = ""
               FUNCTION = TRUE
            END IF
            ' fake that this is a COM get statement
            p_Src$ = prev_word_left$ + " = " + word_left$
         END IF
      END IF
   ELSE ' not found with
      IF COM_open_WITH_statement THEN                  ' but inside with block
         IF p_Src[0] = 46 THEN ' Found "."             ' found . as first character
            p_Src$ = COM_with_temp_str_name$ + p_Src$  ' pre-append object name
         END IF
      END IF
   END IF

   CALL FastLexer(p_Src$,"","'")
   DIM RAW i AS INT :  i = 2
   p_Src$ = Stk$[1]

   DO WHILE i <= Ndx
      IF *Stk$[i] = ASC("'") THEN EXIT DO
      CONCAT(p_Src$, Stk$[i])
      INCR i
   LOOP

   CALL FastLexer(p_Src$,"","= ",0)
   i = 1
   j = 0
   DO WHILE i < Ndx
      IF *Stk$[i] = 61 THEN
         j = i
      END IF
      INCR i
   LOOP
   IF j THEN
      i = 2
      p_Src$ = TRIM$(Stk$[1])
      DO WHILE i < j
         CONCAT(p_Src$, TRIM$(Stk$[i]))
         INCR i
      LOOP
      CONCAT(p_Src$, Stk$[j])
      DO WHILE ++j <= Ndx
         CONCAT(p_Src$, TRIM$(Stk$[j]))
      LOOP
   END IF

   CALL FastLexer(p_Src$,"","[]()=. ",0)

   DIM RAW szLeft$ = ""
   DIM RAW szRight$ = ""
   DIM RAW FOUND_SPACE

   FOUND_OBJECT = FALSE
   FOUND_EQU = FALSE
   FOUND_SPACE = FALSE
   FOUND_DOT = FALSE

   DIM RAW DO_COM = 0  ' Get = -1, Method = 0, Set = 1

   FOR i = 1 TO Ndx

      IF FOUND_OBJECT = FALSE THEN
         FOUND_OBJECT = IsVariableComObject(Stk$[i])
      END IF

      IF *Stk$[i] = 61 THEN
         FOUND_EQU = TRUE     ' check for =
         IF FOUND_OBJECT = FALSE THEN
            IF DO_COM = 0 THEN DO_COM = (-1) ELSE DO_COM = 1
         ELSE
            IF FOUND_DOT = FALSE THEN DO_COM = (-1) ELSE DO_COM = 1
         END IF
         ITERATE
      END IF

      IF *Stk$[i] = 46 AND FOUND_OBJECT <> FALSE THEN FOUND_DOT = TRUE
      IF FOUND_OBJECT AND *Stk$[i] = 32 THEN FOUND_SPACE = i : ITERATE
      IF FOUND_EQU OR FOUND_SPACE THEN
         CONCAT(szRight$, Stk$[i])
         IF Stk$[i] = "(" THEN
            DIM RAW iP AS INT
            iP = 1
            DO WHILE iP
               INCR i
               IF Stk$[i] = "(" THEN INCR iP
               IF Stk$[i] = ")" THEN DECR iP
               CONCAT(szRight$, TRIM$(Stk$[i]))
            LOOP
         END IF
      ELSE
         IF Stk$[i] = "(" THEN
            DIM RAW iP AS INT
            CONCAT(szLeft$, Stk$[i])
            iP = 1
            DO WHILE iP
               IF i = Ndx THEN Abort("Unbalance () in COM statement")
               INCR i
               IF Stk$[i] = "(" THEN INCR iP
               IF Stk$[i] = ")" THEN DECR iP
               CONCAT(szLeft$, TRIM$(Stk$[i]))
            LOOP
         ELSE
            CONCAT(szLeft$, Stk$[i])
         END IF
      END IF
   NEXT

   IF FOUND_OBJECT <> FALSE THEN
      IF FOUND_DOT THEN
         IF COM_build_trace_code THEN
            FPRINT Outfile, "COM_add_trace_line(", ENC$("  "),");"
            FPRINT Outfile, "COM_add_trace_line(", ENC$("***********************************************************"),");"
            FPRINT Outfile, "COM_add_trace_line(", ENC$("Source Line= "+BCX_PREPARE_COM_TRACE_LINE$(pp_Src$)),");"
         END IF

         SELECT CASE DO_COM
            CASE -1
            BCX_COM_Parse_GetProperty(szLeft$, szRight$)

            CASE 0
            BCX_COM_Parse_Method(szLeft$, szRight$)

            CASE 1
            BCX_COM_Parse_SetProperty(szLeft$, szRight$, FOUND_OBJECT)

         END SELECT
         pp_Src$ = ""
         FUNCTION = TRUE
      END IF
   END IF
   CALL XParse(pp_Src$)
   FUNCTION = FALSE
END FUNCTION ' Find_COM_statement






SUB BCX_COM_Parse_GetProperty(varname$, com_property$)
   ' ***************************************************************************
   ' Sub: BCX_COM_Parse_GetProperty (part of BCX COM parser)
   ' Called internally by main com parser function, Find_COM_statement.
   ' If the statment is a COM Get Property type, this function will be called.
   '
   ' Typical sample:
   ' b$ = excel.ActiveSheet.Cells(4,1).Value
   ' ***************************************************************************
   Use_BCX_COM_GetProperty = Use_BCX_COM_UsesConversion = Use_COM = TRUE

   DIM LOCAL com_method$
   DIM LOCAL j
   DIM LOCAL k
   DIM LOCAL ObjName$
   DIM LOCAL ComTok$
   DIM LOCAL ComTokPrev$
   DIM LOCAL temp_param$
   DIM LOCAL force_cast$
   DIM force_casting

   com_method$ = TRIM$(com_property$)

   IF com_method[0] = c_LPar THEN ' type casting
      force_cast$ = TRIM$(UCASE$(EXTRACT$(com_method+1,")")))
      com_method$ = TRIM$(REMAIN$(com_method,")"))
      force_casting = 1
   END IF

   CALL ParseCom(com_method$)
   j = 1
   ObjName$ = ComStk$[j++]
   ComTok$ = ComStk$[j++]

   DO
      ComTokPrev$ = ComTok$
      ComTok$ = ComStk$[j++]
      FPRINT Outfile, Scoot$,"lstrcpy(COM_ErrMsg, _T(", ENC$(BCX_PREPARE_COM_TRACE_LINE$(ComTokPrev$)),"));"

      IF INCHR(ComTokPrev$, "(") > 0 THEN
         temp_param$ = TRIM$(REMAIN$(ComTokPrev$,"("))
         k = BCX_COM_BUILD_PARAMETER_LIST(MID$(temp_param$,1,LEN(temp_param$)-1),1)
         FPRINT Outfile, Scoot$, "COM_plist_index =", k ,";"
         ComTokPrev$ = EXTRACT$(ComTokPrev$,"(")
      END IF

      IF ComTok$ > "" THEN
         IF COM_build_trace_code  THEN
            FPRINT Outfile, "    COM_add_trace_line(", ENC$(">>> Get next dispatch for:: "+ComTokPrev$), ");"
         END IF
         FPRINT Outfile, Scoot$, "COM_get_next_dispatch(&",ObjName$,", L",ENC$(REMOVE$(ComTokPrev$,SPC$)),");"

      ELSE
         IF COM_open_WITH_statement THEN
            IF COM_build_trace_code  THEN
               FPRINT Outfile, "    COM_add_trace_line(", ENC$("WITH construction >>> Get next dispatch for:: "+ComTokPrev$), ");"
            END IF
            FPRINT Outfile, Scoot$, "COM_get_next_dispatch(&",ObjName$,", L",ENC$(REMOVE$(ComTokPrev$,SPC$)),");"
            FPRINT Outfile, Scoot$, "COM_dispatch_at_offset = ", COM_with_temp_str_name$, ".ipointer;"
            FPRINT Outfile, Scoot$, "COM_dispatch_storage_index++;"
            FPRINT Outfile, Scoot$, "COM_dispatch_storage[COM_dispatch_storage_index] = COM_dispatch_at_offset;"
            EXIT SUB
         END IF

         IF COM_build_trace_code  THEN
            FPRINT Outfile, "    COM_add_trace_line(", ENC$(">>> COM_invoke for:: "+ComTokPrev$), ");"
         END IF

         IF COM_FOREACH_enumerator = TRUE THEN
            FPRINT Outfile, Scoot$, "COM_get_next_dispatch(&",ObjName$,", L",ENC$(REMOVE$(ComTokPrev$,SPC$)),");"
            EXIT SUB
         ELSE
            FPRINT Outfile, Scoot$, "COM_invoke(&",ObjName$,", L",ENC$(REMOVE$(ComTokPrev$,SPC$));
            FPRINT Outfile, ",COM_PROPS, &COM_vt_result);\n"
         END IF

         IF force_casting = 1 THEN
            FPRINT Outfile, Scoot$, "VariantChangeType(&COM_vt_result, &COM_vt_result,0,", force_cast$ ,");"
         END IF

         IF NOT *varname THEN EXIT DO

         DIM RAW Cleanvarname$
         Cleanvarname$ = TRIM$(Clean$(varname$))

         IF force_casting = 1 THEN
            IF force_cast$ = "VT_BSTR" THEN
               FPRINT Outfile, Scoot$, Cleanvarname$," = SysAllocString(COM_vt_result.bstrVal);"
            ELSE
               force_cast$ = REPLACE$(force_cast$,"VT_","V_")
               FPRINT Outfile, Scoot$, Cleanvarname$," = ", force_cast$,"(&COM_vt_result);"
            END IF
         ELSE
            DIM RAW VI AS VarInfo PTR
            DIM RAW vt, id
            DIM RAW tVI AS VarInfo

            IF INCHR(Cleanvarname$, ".") THEN
               DIM RAW sTAG$
               sTAG$ = LEFT$(Cleanvarname$,INCHR(Cleanvarname$,".")-1)
               vt = CheckLocal(sTAG$, &id)
               IF vt = vt_UNKNOWN THEN
                  vt = CheckGlobal(sTAG$, &id)
                  IF vt = vt_UNKNOWN THEN
                     Abort("Unknown structure " + sTAG$ + " not previously dimensioned")
                  END IF
               END IF
               tVI.VarPntr = 0
               tVI.VarType = 0
               'FPRINT Outfile, "// Structure ";sTAG$;vt  'DEBUG
               IF vt = vt_VARIANT THEN
                  DIM i
                  sTAG$ = MID$(Cleanvarname$,INCHR(Cleanvarname$,".")+1)
                  i = 0
                  DO WHILE atVARIANTVALUENAMES[i].sNAME
                     IF atVARIANTVALUENAMES[i].sNAME$ = sTAG$ THEN
                        tVI.VarType = atVARIANTVALUENAMES[i].iTYPE
                        tVI.VarPntr = atVARIANTVALUENAMES[i].iPTRS
                        vt = tVI.VarType
                        EXIT DO
                     END IF
                     INCR i
                  LOOP
               END IF
               VI = &tVI
            ELSE
               vt = CheckLocal(Cleanvarname$, &id)
               IF vt = vt_UNKNOWN THEN
                  vt = CheckGlobal(Cleanvarname$, &id)
                  IF vt = vt_UNKNOWN THEN
                     Abort("Unknown variable " + varname$ + " not previously dimensioned")
                  END IF
                  VI = &GlobalVars[id]
               ELSE
                  VI = &LocalVars[id]
               END IF
            END IF

            SELECT CASE vt
               CASE vt_VARIANT

               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "VariantCopy((VARIANT *)(&", Cleanvarname$, "),&COM_vt_result);"
               ELSE
                  FPRINT Outfile, Scoot$, "VariantCopy(&", Cleanvarname$, ",&COM_vt_result);"
               END IF

               CASE vt_DOUBLE ' double precision float variable
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_R8 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R8|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(", ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pdblVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_R8)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R8);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(", ENC$("Return variable for "+Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.dblVal;"
               END IF

               CASE vt_SINGLE ' single precision float variable
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_R4 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R4|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pfltVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_R4)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R4);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for "+Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.fltVal;"
               END IF

               CASE vt_INTEGER ' integer variable
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_INT | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_INT|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pintVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_INT)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "  VariantChangeType(&COM_vt_result,"
                  FPRINT Outfile, Scoot$, " &COM_vt_result,0, VT_INT);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.intVal;"
               END IF

               CASE vt_UINT
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_UI4 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI4|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.uintVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_INT)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "  VariantChangeType(&COM_vt_result,"
                  FPRINT Outfile, Scoot$, " &COM_vt_result,0, VT_INT);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.uintVal;"
               END IF

               CASE vt_LONG ' integer variable
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_I4 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I4|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.plVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_I4)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result, &COM_vt_result,0,VT_I4);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.lVal;"
               END IF

               CASE vt_ULONG
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_UI4 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI4|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pulVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_UI4)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI4);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.ulVal;"
               END IF

               CASE vt_LLONG
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_I8 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType (&COM_vt_result,&COM_vt_result,0,VT_I8|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pllVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_I8)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I8);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.llVal;"
               END IF

               CASE vt_ULONGLONG
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_UI8 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI8|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pullVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_UI8)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI8);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.ullVal;"
               END IF

               CASE vt_SHORT
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_I2 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I2|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.piVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_I2)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I2);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.iVal;"
               END IF

               CASE vt_USHORT
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_UI2 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI2|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.puiVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_UI2)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI2);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.uiVal;"
               END IF


               CASE vt_BYTE
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_UI1 | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI1|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pbVal;"
               ELSE
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != VT_UI1)"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI1);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$, "  COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$, "  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.bVal;"
               END IF

               CASE vt_BOOL
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, "if (COM_vt_result.vt != (VT_BOOL | VT_BYREF))"
                  FPRINT Outfile, Scoot$, "  {"
                  FPRINT Outfile, Scoot$, "     VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_BOOL|VT_BYREF);"
                  IF COM_build_trace_code THEN
                     FPRINT Outfile, Scoot$,"    COM_add_trace_line(";ENC$("Return variable for " + Cleanvarname$ + " was coerced");");"
                  END IF
                  FPRINT Outfile, Scoot$,"  }"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pboolVal;"
               ELSE
                  FPRINT Outfile, Scoot$, Cleanvarname$," = CON_VARBOOL2BOOL(COM_vt_result.boolVal);"
               END IF


               CASE vt_STRVAR, vt_CHAR     ' string variable
               FPRINT Outfile, Scoot$,"if(COM_vt_result.vt == VT_NULL){"
               FPRINT Outfile, Scoot$,"  *",Cleanvarname$,"=0;"
               FPRINT Outfile, Scoot$,"} else {"
               FPRINT Outfile, Scoot$,"COM_last_HR = VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_BSTR);\n"
               FPRINT Outfile, Scoot$,"if (FAILED(COM_last_HR)) {"
               FPRINT Outfile, Scoot$,"  COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("VariantChangeType (BSTR) Failed!"),"));"
               FPRINT Outfile, Scoot$,"} else {"
               FPRINT Outfile, Scoot$,"  #ifndef UNICODE"
               FPRINT Outfile, Scoot$,"  COM_last_HR = COM_WS2AS(COM_vt_result.bstrVal);"
               FPRINT Outfile, Scoot$,"  if (FAILED(COM_last_HR)) {"
               FPRINT Outfile, Scoot$,"    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("COM Get Property Failed! W2A failure!"),"));"
               FPRINT Outfile, Scoot$,"  } else {"
               FPRINT Outfile, Scoot$,"   strcpy(", Cleanvarname$,", COM_psz_tmp);"
               FPRINT Outfile, Scoot$,"  }"
               FPRINT Outfile, Scoot$,"  #else"
               FPRINT Outfile, Scoot$,"  lstrcpy(", Cleanvarname$,",COM_vt_result.bstrVal);"
               FPRINT Outfile, Scoot$,"  #endif"
               FPRINT Outfile, Scoot$,"}"
               FPRINT Outfile, Scoot$,"}"

               CASE vt_UDT
               IF ProcessingCOM_Set AND IsVariableComObject(Cleanvarname$) THEN
                  ProcessingCOM_Set = FALSE
                  FPRINT Outfile, Scoot$,"if (COM_vt_result.vt != VT_DISPATCH) {"
                  FPRINT Outfile, Scoot$,"    COM_last_HR = VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_DISPATCH);"
                  FPRINT Outfile, Scoot$,"}\n"
                  FPRINT Outfile, Scoot$,"if (FAILED(COM_last_HR)) {"
                  FPRINT Outfile, Scoot$,"  strcpy(COM_ErrMsg ,",ENC$(Cleanvarname$), ");"
                  FPRINT Outfile, Scoot$,"  COM_HR_ErrMsg (COM_last_HR, _T(";
                  FPRINT Outfile, Scoot$, ENC$("VariantChangeType failed. Expected IDispatch*"),"));"
                  FPRINT Outfile, Scoot$,"} else {"
                  FPRINT Outfile, Scoot$,"  VariantInit(&", Cleanvarname$,".pObjects[0]);"
                  FPRINT Outfile, Scoot$,"  COM_last_HR = VariantCopy(&",Cleanvarname$,".pObjects[0],&COM_vt_result);\n"
                  FPRINT Outfile, Scoot$,"  if (FAILED(COM_last_HR)) {"
                  FPRINT Outfile, Scoot$,"    strcpy(COM_ErrMsg ,",ENC$(Cleanvarname$), ");"
                  FPRINT Outfile, Scoot$,"    COM_HR_ErrMsg (COM_last_HR, _T(", ENC$("VariantCopy failed."), "));"
                  FPRINT Outfile, Scoot$,"  } else {"
                  FPRINT Outfile, Scoot$,"    COM_objects_cnt++;"
                  FPRINT Outfile, Scoot$,"    ", Cleanvarname$,".pStatus = TRUE;"
                  FPRINT Outfile, Scoot$,"    ", Cleanvarname$,".ipointer = 0;"
                  FPRINT Outfile, Scoot$,"  }  "
                  FPRINT Outfile, Scoot$,"} "
               ELSE
                  FPRINT Outfile, Scoot$,"if (COM_vt_result.vt == VT_BOOL) {" ' convert from VARIANT_BOOL to BOOL
                  FPRINT Outfile, Scoot$, Cleanvarname$," = CON_VARBOOL2BOOL(COM_vt_result.boolVal);"
                  FPRINT Outfile, Scoot$,"} else {"
                  FPRINT Outfile, Scoot$,"switch (COM_vt_result.vt)"
                  FPRINT Outfile, Scoot$,"  {"
                  FPRINT Outfile, Scoot$,"  case VT_R8:"
                  FPRINT Outfile, Scoot$,"      ";Cleanvarname$," = COM_vt_result.dblVal;"
                  FPRINT Outfile, Scoot$,"    break;"
                  FPRINT Outfile, Scoot$,"  case VT_R4:"
                  FPRINT Outfile, Scoot$,"      ";Cleanvarname$," = COM_vt_result.fltVal;"
                  FPRINT Outfile, Scoot$,"    break;"
                  FPRINT Outfile, Scoot$,"  default:"
                  FPRINT Outfile, Scoot$,"      ";Cleanvarname$," = (int)COM_vt_result.lVal;"
                  FPRINT Outfile, Scoot$,"    break;"
                  FPRINT Outfile, Scoot$,"  }"
                  FPRINT Outfile, Scoot$,"}"
               END IF

               CASE vt_BSTR
               IF VI->VarPntr THEN
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.pbstrVal;"
               ELSE
                  FPRINT Outfile, Scoot$, Cleanvarname$," = COM_vt_result.bstrVal;"
               END IF

               CASE ELSE
               IF ProcessingCOM_Set AND IsVariableComObject(Cleanvarname$) THEN
                  ProcessingCOM_Set = FALSE
                  FPRINT Outfile, Scoot$,"if (COM_vt_result.vt != VT_DISPATCH) {"
                  FPRINT Outfile, Scoot$,"    COM_last_HR = VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_DISPATCH);"
                  FPRINT Outfile, Scoot$,"}\n"
                  FPRINT Outfile, Scoot$,"if (FAILED(COM_last_HR)) {"
                  FPRINT Outfile, Scoot$,"  strcpy(COM_ErrMsg ,",ENC$(Cleanvarname$), ");"
                  FPRINT Outfile, Scoot$,"  COM_HR_ErrMsg (COM_last_HR, _T(";
                  FPRINT Outfile, Scoot$, ENC$("VariantChangeType failed. Expected IDispatch*"), "));"
                  FPRINT Outfile, Scoot$,"} else {"
                  FPRINT Outfile, Scoot$,"  VariantInit(&", Cleanvarname$,".pObjects[0]);"
                  FPRINT Outfile, Scoot$,"  COM_last_HR = VariantCopy(&",Cleanvarname$,".pObjects[0], &COM_vt_result);\n"
                  FPRINT Outfile, Scoot$,"  if (FAILED(COM_last_HR)) {"
                  FPRINT Outfile, Scoot$,"    strcpy(COM_ErrMsg ,",ENC$(Cleanvarname$), ");"
                  FPRINT Outfile, Scoot$,"    COM_HR_ErrMsg (COM_last_HR, _T(", ENC$("VariantCopy failed."), "));"
                  FPRINT Outfile, Scoot$,"  } else {"
                  FPRINT Outfile, Scoot$,"    bcx_ole_objects_count++;"
                  FPRINT Outfile, Scoot$,"    ", Cleanvarname$,".pStatus = TRUE;"
                  FPRINT Outfile, Scoot$,"    ", Cleanvarname$,".ipointer = 0;"
                  FPRINT Outfile, Scoot$,"  }  "
                  FPRINT Outfile, Scoot$,"} "
               ELSE
                  FPRINT Outfile, Scoot$,"if (COM_vt_result.vt == VT_BOOL) {"
                  FPRINT Outfile, Scoot$, Cleanvarname$," = CON_VARBOOL2BOOL(COM_vt_result.boolVal);"
                  FPRINT Outfile, Scoot$,"} else {"
                  FPRINT Outfile, Scoot$,"switch (COM_vt_result.vt)"
                  FPRINT Outfile, Scoot$,"  {"
                  FPRINT Outfile, Scoot$,"  case VT_R8:"
                  FPRINT Outfile, Scoot$,"      ";Cleanvarname$," = COM_vt_result.dblVal;"
                  FPRINT Outfile, Scoot$,"    break;"
                  FPRINT Outfile, Scoot$,"  case VT_R4:"
                  FPRINT Outfile, Scoot$,"      ";Cleanvarname$," = COM_vt_result.fltVal;"
                  FPRINT Outfile, Scoot$,"    break;"
                  FPRINT Outfile, Scoot$,"  default:"
                  FPRINT Outfile, Scoot$,"      ";Cleanvarname$," = (int)COM_vt_result.lVal;"
                  FPRINT Outfile, Scoot$,"    break;"
                  FPRINT Outfile, Scoot$,"  }"
                  FPRINT Outfile, Scoot$,"}"
               END IF
            END SELECT
         END IF
         FPRINT Outfile, Scoot$,"VariantClear(&COM_vt_result);"
         EXIT DO
      END IF
   LOOP
   FPRINT Outfile, Scoot$,"if (0 == COM_reset_chain) COM_reset_disp_chain(&",ObjName$,");"
END SUB ' BCX_COM_Parse_GetProperty




SUB BCX_COM_Parse_SetProperty(com_method$, pparms$, Obj_At_Index%)
   ' ************************************************************************************************************
   ' Sub: BCX_COM_Parse_SetProperty (part of BCX COM parser)
   ' Called internaly by main com parser function, Find_COM_statement.
   ' If the statment is a COM Set Property type, this function will be called.
   '
   ' Typical sample:
   ' (Property set)      -- app.language = "VBScript"
   ' (Property set)      -- app.visible = true
   ' ************************************************************************************************************
   Use_BCX_COM_SetProperty = Use_BCX_COM_UsesConversion = Use_COM = TRUE
   DIM LOCAL j
   DIM LOCAL k
   DIM LOCAL ObjName$
   DIM LOCAL ComTok$
   DIM LOCAL ComTokPrev$
   DIM LOCAL temp_param$
   DIM LOCAL parms$
   DIM LOCAL BuildSafeArray

   IF COM_build_trace_code  THEN
      FPRINT Outfile, "    COM_add_trace_line(", ENC$("BCX_COM_Parse_SetProperty(" + BCX_PREPARE_COM_TRACE_LINE$(com_method$) + " , " + BCX_PREPARE_COM_TRACE_LINE$(pparms$) + " , " + STR$(Obj_At_Index%) + ")"), ");"
   END IF

   parms$ = TRIM$(pparms$)
   IF NOTNULL(parms$) THEN
      IF MID$(UCASE$(parms$),1,6) = "ARRAY(" OR MID$(UCASE$(parms$),1,6) = "ARRAY " THEN
         parms$ = REMAIN$(parms$,"(")
         j = LEN(parms$) -1
         parms[j] = 0 ' strip closing brace )
         BuildSafeArray = 1
         Use_BCX_COM_SafeArray = TRUE
      END IF
   END IF

   CALL ParseCom(com_method$)
   j = 1
   ObjName$ = ComStk$[j++]
   ComTok$ = ComStk$[j++]

   DO
      ComTokPrev$ = ComTok$
      ComTok$ = ComStk$[j++]
      FPRINT Outfile, Scoot$,"lstrcpy(COM_ErrMsg, _T(", ENC$(BCX_PREPARE_COM_TRACE_LINE$(ComTokPrev$)),"));"
      IF ComTok$ > "" THEN
         IF INCHR(ComTokPrev$, "(") > 0 THEN
            temp_param$ = TRIM$(REMAIN$(ComTokPrev$,"("))
            k = BCX_COM_BUILD_PARAMETER_LIST(MID$(temp_param$,1,LEN(temp_param$)-1),1)
            FPRINT Outfile, Scoot$, "COM_plist_index =", k ,";"
            ComTokPrev$ = TRIM$(EXTRACT$(ComTokPrev$,"("))
         END IF

         IF COM_build_trace_code  THEN
            FPRINT Outfile, "    COM_add_trace_line(", ENC$(">>> Get next dispatch for:: "+ComTokPrev$), ");"
         END IF
         FPRINT Outfile, Scoot$, "COM_get_next_dispatch(&",ObjName$,", L",ENC$(REMOVE$(ComTokPrev$,SPC$)),");"
      ELSE
         IF COM_build_trace_code  THEN
            FPRINT Outfile, "COM_add_trace_line(", ENC$("Invoke helper for:: "+ComTokPrev$), ");"
         END IF

         k = BCX_COM_BUILD_PARAMETER_LIST(parms$,0)
         FPRINT Outfile, Scoot$, "COM_plist_index =", k,";"

         IF BuildSafeArray THEN
            FPRINT Outfile, Scoot$, "COM_create_safearray();"
         END IF

         DIM RAW sXX$
         sXX$ = "\"+CHR$(c_DblQt)
         REPLACE CHR$(c_DblQt) WITH sXX$ IN ComTokPrev$
         FPRINT Outfile, ""
         FPRINT Outfile, Scoot$,"if (!COM_BCX_ERROR)"
         FPRINT Outfile, Scoot$, "  COM_invoke(&",ObjName$,", L",ENC$(REMOVE$(ComTokPrev$,SPC$)),", DISPATCH_PROPERTYPUT, NULL);\n"
         EXIT DO
      END IF
   LOOP
END SUB ' BCX_COM_Parse_SetProperty



'*******************************************************************
' Function to break up parameter string into parameter token blocks
' Note: Limited support for functions and array values as parameters
' 2009-01-26 - Wayne Halsdorf
'*******************************************************************
FUNCTION GetParameterTokens(sP$)
   DIM RAW iWorkingOn AS INT
   DIM RAW iLastTokenPlus1 AS INT
   DIM RAW ParamTok$

   CALL FastLexer(sP$,"",",()[]")
   iLastTokenPlus1 = Ndx
   IF TALLY(sP$,"(") OR TALLY(sP$,"[") THEN
      FOR iWorkingOn = 1 TO Ndx
         Stk$[iWorkingOn] = TRIM$(Stk$[iWorkingOn])
      NEXT
      CALL RemEmptyTokens
      iWorkingOn = 1
      iLastTokenPlus1 = 0
      DO WHILE Stk[iWorkingOn][0]
         ParamTok$ = Stk$[iWorkingOn]
         IF ParamTok[0] <> c_Comma AND Stk[iWorkingOn+1][0] <> c_Comma THEN
            DO
               INCR iWorkingOn
               IF iWorkingOn > Ndx THEN EXIT DO
               ParamTok$ = ParamTok$ + Stk$[iWorkingOn]
               DO WHILE (TALLY(ParamTok$,"[")-TALLY(ParamTok$,"]")) <> 0 OR (TALLY(ParamTok$,"(")-TALLY(ParamTok$,")")) <> 0
                  INCR iWorkingOn
                  ParamTok$ = ParamTok$ + Stk$[iWorkingOn]
               LOOP
               IF Stk[iWorkingOn][0] = c_Comma THEN EXIT DO
            LOOP WHILE Stk[iWorkingOn][0]
         END IF
         INCR iWorkingOn
         Stk$[++iLastTokenPlus1] = ParamTok$
         IF iWorkingOn > Ndx THEN EXIT DO
      LOOP
      Ndx = iLastTokenPlus1
   END IF
   INCR iLastTokenPlus1
   Stk$[iLastTokenPlus1] = ""

   IF cMaxParamToken <= iLastTokenPlus1 THEN
      CALL Abort("Maximum nunber of com tokens exceeded.")
   END IF

   FOR iWorkingOn = 1 TO iLastTokenPlus1
      ParamToken$[iWorkingOn] = Stk$[iWorkingOn]
   NEXT
   FUNCTION = Ndx
END FUNCTION  ' GetParameterTokens




FUNCTION BCX_COM_BUILD_PARAMETER_LIST(parms$, i AS INT)
   ' ************************************************************************************************************
   ' Function: BCX_COM_BUILD_PARAMETER_LIST (part of BCX COM parser)
   ' Function calls BCX_COM_PREBUILD_PARAMETER_LIST which emmits code for COM methods invocation.
   ' Parameters are placed in reverse order, as requiered by COM standard.
   '
   ' Return Values:
   ' returns number of created parameters for next COM call.
   ' ************************************************************************************************************
   DIM RAW RetValue%
   RetValue = BCX_COM_PREBUILD_PARAMETER_LIST(parms$, i)
   FUNCTION = RetValue
END FUNCTION ' BCX_COM_BUILD_PARAMETER




FUNCTION ComParamType(sParam$, iRebuild AS INT PTR)
   '*******************************************************
   ' Function to return the parameter type used in COM
   ' Note: Limited support for functions as parameters
   ' 2008-01-26 --- Wayne Halsdorf
   '*******************************************************
   DIM RAW varidx AS INT
   DIM RAW k AS INT
   DIM RAW ptVI AS VarInfo PTR
   DIM RAW iBYREF_Flag AS INT

   *iRebuild = 0
   IF sParam[0] = c_LPar THEN
      FUNCTION = comvt_CAST
   END IF
   IF iMatchWrd(sParam$,"true") THEN
      FUNCTION = comvt_TRUE
   END IF
   IF iMatchWrd(sParam$,"false") THEN
      FUNCTION = comvt_FALSE
   END IF
   IF sParam[0] = c_DblQt THEN
      FUNCTION = comvt_BSTR
   END IF
   IF IsNumberEx(sParam$) THEN
      IF INCHR(sParam$,".") THEN
         FUNCTION = comvt_R8_LITERAL
      ELSE
         FUNCTION = comvt_I4_LITERAL
      END IF
   END IF
   IF iMatchNQ (sParam$, ":=") > 0 THEN ' this is named argument
      FUNCTION = comvt_NAMED_ARGUMENT
   END IF
   IF IsVariableComObject(TRIM$(Clean$(sParam$))) THEN
      FUNCTION = comvt_OBJECT
   END IF
   IF RIGHTSTR (sParam$,"#") THEN
      FUNCTION = comvt_R8
   END IF
   IF RIGHTSTR (sParam$,"!") THEN
      FUNCTION = comvt_R4
   END IF
   IF RIGHTSTR (sParam$,"$") THEN
      FUNCTION = comvt_STRVAR
   END IF
   IF RIGHTSTR (sParam$,"%") THEN
      FUNCTION = comvt_INT
   END IF
   ptVI = NULL
   k = CheckLocal(sParam$, &varidx)
   IF k <> vt_UNKNOWN THEN
      ptVI = &LocalVars[varidx]
   ELSE
      k = CheckGlobal(sParam$, &varidx)
      IF k <> vt_UNKNOWN THEN
         ptVI = &GlobalVars[varidx]
      END IF
   END IF

   IF ptVI <> NULL THEN

      iBYREF_Flag = 0

      IF ptVI->VarPntr = 1 THEN iBYREF_Flag = comvt_BYREF
      IF ptVI->VarPntr < 2 THEN

         SELECT CASE k
            CASE vt_VOID
            FUNCTION = comvt_VOID BOR iBYREF_Flag
            CASE vt_STRVAR
            FUNCTION = comvt_STRVAR BOR iBYREF_Flag
            CASE vt_DOUBLE
            FUNCTION = comvt_R8 BOR iBYREF_Flag
            CASE vt_SINGLE
            FUNCTION = comvt_R4 BOR iBYREF_Flag
            CASE vt_INTEGER
            FUNCTION = comvt_INT BOR iBYREF_Flag
            CASE vt_LLONG
            FUNCTION = comvt_I8 BOR iBYREF_Flag
            CASE vt_ULONGLONG
            FUNCTION = comvt_UI8 BOR iBYREF_Flag
            CASE vt_LONG
            FUNCTION = comvt_I4 BOR iBYREF_Flag
            CASE vt_ULONG
            FUNCTION = comvt_UI4 BOR iBYREF_Flag
            CASE vt_SHORT
            FUNCTION = comvt_I2 BOR iBYREF_Flag
            CASE vt_USHORT
            FUNCTION = comvt_UI2 BOR iBYREF_Flag
            CASE vt_CHAR
            FUNCTION = comvt_I1 BOR iBYREF_Flag
            CASE vt_BYTE
            FUNCTION = comvt_UI1 BOR iBYREF_Flag
            CASE vt_BOOL
            FUNCTION = comvt_BOOL BOR iBYREF_Flag
            CASE vt_UINT
            FUNCTION = comvt_UINT BOR iBYREF_Flag
            CASE vt_VARIANT
            FUNCTION = comvt_VARIANT BOR iBYREF_Flag
            CASE vt_UDT
            IF TypeDefs[ptVI->VarDef].VarName$ = "SAFEARRAY" THEN
               FUNCTION = comvt_SAFEARRAY BOR iBYREF_Flag
            END IF
         END SELECT
      END IF
   END IF
   IF INCHR(sParam$,"(") THEN
      DIM RAW Keyword$
      DIM RAW tpBCX AS tagTokenSubFunctions PTR
      *iRebuild = 1
      CALL XParse(sParam$)
      CALL TokenSubstitutions(1)
      Keyword$ = LCASE$(Stk$[1])
      tpBCX = GetWordInfo(Keyword$)
      IF tpBCX THEN
         IF tpBCX->iCOM <> comvt_BAD THEN
            FUNCTION = tpBCX->iCOM
         END IF
      END IF
   END IF
   *iRebuild = 0
   FUNCTION = comvt_DEFAULT
END FUNCTION ' ComParamType





SUB ConvertCast(szParam$, szVT$, szVAL$)
   '  Example:  szParam$ (VT_ARRAY|VT_BYREF|VT_XXXX)(C_CAST)
   DIM RAW i AS INT
   DIM RAW szWork$

   szVT$ = ""
   szVAL$ = ""
   szWork$ = EXTRACT$(szParam$,")")
   szWork$ = MID$(szWork$,2)
   IF LEFTSTR(szWork$,"VT_") THEN
      IF LEFTSTR(szWork$,"VT_ARRAY") THEN
         szVAL$ = "parray"
         szVT$ = "VT_ARRAY"
         REMOVE "VT_ARRAY" FROM szWork$
      END IF
      IF iMatchNQ (szWork$,"VT_BYREF") THEN
         szVAL$ = "p"+szVAL$
         IF NOTNULL(szVT$) THEN szVT$ = szVT$ + "|"
         szVT$ = szVT$ + "VT_BYREF"
         REMOVE "VT_BYREF" FROM szWork$
      END IF
      DO WHILE szWork[0] = 124
         szWork$ = MID$(szWork$,2)
      LOOP
      i = 0
      DO WHILE ptVCasts[i].pszCAST <> NULL
         IF LEFTSTR(szWork$, ptVCasts[i].pszCAST$) THEN
            szWork$ = REMAIN$(szParam$,")")
            IF *szWork$ = ASC("(") THEN szWork$ = REMAIN$(szWork$,")")
            szVAL$ = szVAL$ + "=" + szWork$ ' ASSUME VALID C CAST OR NO CAST
            IF NOTNULL(szVT$) THEN szVT$ = szVT$ + "|"
            szVT$ = szVT$ + ptVCasts[i].pszCAST$
            EXIT SUB
         END IF
         INCR i
      LOOP
      IF iMatchNQ (szVAL$,"array") THEN
         IF NOTNULL(szVT$) THEN szVT$ = szVT$ + "|"
         szVT$ = szVT$ + szWork$
         szWork$ = REMAIN$(szParam$,")")
         IF *szWork$ = ASC("(") THEN szWork$ = REMAIN$(szWork$,")")
         szVAL$ = szVAL$ + "=" + szWork$ ' ASSUME VALID C CAST OR NO CAST
         EXIT SUB
      END IF
      CALL Abort("Unknown cast. " + szWork$ + " See help file")
   END IF
   ' DEALING WITH C CAST
   IF INCHR(szWork$,"*") THEN szVAL$ = "p"
   REMOVE "*" FROM szWork$
   i = 0
   DO WHILE ptCCasts[i].pszCAST <> NULL
      IF szWork$ = ptCCasts[i].pszCAST$ THEN
         szWork$ = REMAIN$(szParam$,")")
         IF *szWork$ = ASC(")") THEN szWork$ = REMAIN$(szWork$,")")
         szVAL$ = szVAL$+ptCCasts[i].pszVAL$ + "=" + szWork$ ' ASSUME VALID C CAST OR NO CAST
         IF NOTNULL(szVT$) THEN szVT$ = szVT$ + "|"
         szVT$ = szVT$ + ptCCasts[i].pszCAST$
         EXIT SUB
      END IF
      INCR i
   LOOP
   CALL Abort("Unknown C cast. szParam$=" + szParam$ + " szVT$="+szVT$ + " szVAL$="+ szVAL$ + " See help file")
END SUB  ' ConvertCast



FUNCTION BCX_COM_PREBUILD_PARAMETER_LIST (parms$, IsIndex AS INT)
   DIM RAW sTMP$
   DIM RAW sCleanTemp$
   DIM RAW iTokens AS INT
   DIM RAW i AS INT
   DIM RAW j AS INT
   DIM RAW k AS INT
   DIM RAW iArrayFlag AS INT
   DIM RAW iByrefFlag AS INT
   DIM RAW P$
   DIM RAW P2$
   DIM RAW local_parm_copy$

   DIM RAW local_temp_str$
   DIM RAW ComParameterCnt AS INT
   DIM RAW iReturn AS INT
   IF NOT *parms THEN FUNCTION = 0  ' Handle null arguments
   ComParameterCnt = 0
   local_parm_copy$ = TRIM$(parms$)
   iTokens = GetParameterTokens(local_parm_copy$)
   i = 1
   DO WHILE i <= iTokens
      IF ParamToken[i][0] = c_Comma THEN
         INCR i
      ELSE
         INCR i,2
      END IF
      INCR ComParameterCnt
   LOOP
   iReturn = ComParameterCnt
   i = 1
   DO WHILE i <= iTokens
      P$ = ""
      P2$ = ";"
      iByrefFlag = 0
      iArrayFlag = 0
      IF ParamToken[i][0] = c_Comma THEN
         j = comvt_ERROR
         sCleanTemp$ = "DISP_E_PARAMNOTFOUND"
         INCR i
      ELSE
         j = ComParamType(ParamToken$[i], &k)
         IF k THEN
            sCleanTemp$ = ""
            FOR k = 1 TO Ndx
               sCleanTemp$ = sCleanTemp$ + Stk$[k]
            NEXT
            sCleanTemp$ = Clean$(sCleanTemp$)
         ELSE
            IF j = comvt_CAST THEN  ' Determine if C or VT cast
               CALL ConvertCast(ParamToken$[i], local_temp_str$, sCleanTemp$)
            ELSE
               sCleanTemp$ = Clean$(ParamToken$[i])
            END IF
         END IF
         iByrefFlag = j BAND comvt_BYREF
         IF iByrefFlag THEN P$ = "p" : P2$ = "|VT_BYREF;"
         iArrayFlag = j BAND comvt_ARRAY
         IF iArrayFlag THEN P$ = P$+"p" : P2$ = "|VT_ARRAY"+P2$
         j = j BAND comvt_TYPEMASK
         i += 2
      END IF

      ComParameterCnt--
      sTMP$ = TRIM$(STR$(ComParameterCnt))

      SELECT CASE j
         CASE comvt_EMPTY
         IF iArrayFlag THEN Abort("Invalid: Array of empty")
         IF iByrefFlag THEN Abort("Invalid: Pointer to empty")
         ' No value was specified. If an optional argument to an Automation method is left blank,
         ' do not pass a VARIANT of type VT_EMPTY. Instead, pass a VARIANT of type VT_ERROR with a
         ' value of DISP_E_PARAMNOTFOUND.
         ' BY_REF INVLAID
         ' VT_ARRAY INVALID

         CASE comvt_UI1
         'An unsigned 1-byte character is stored in bVal.
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_UI1";P2$
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].";P$;"bVal = ",sCleanTemp$,";"

         CASE comvt_UI2
         'An unsigned 2-byte integer value is stored in uiVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_UI2";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"uiVal = ",sCleanTemp$,";"

         CASE comvt_UI4
         'An unsigned 4-byte integer value is stored in ulVal.
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_UI4";P2$
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].";P$;"ulVal = ",sCleanTemp$,";"

         CASE comvt_UI8
         'An unsigned 8-byte integer value is stored in ullVal.
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_UI8";P2$
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].";P$;"ullVal = ",sCleanTemp$,";"

         CASE comvt_UINT
         'An unsigned integer value is stored in uintVal.
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_UINT";P2$
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].";P$;"uintVal = ",sCleanTemp$,";"

         CASE comvt_INT
         'An integer value is stored in intVal.
         IF IsIndex = 1 THEN
            ' if warning levels add to bcx issue warning "variable type int casted to long"
            FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_I4";P2$
            FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].lVal = ",sCleanTemp$,";"
         ELSE
            FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_INT";P2$
            FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"intVal = ",sCleanTemp$,";"
         END IF

         CASE comvt_I1
         'A 1-byte character value is stored in cVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_I1";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"cVal = ",sCleanTemp$,";"

         CASE comvt_I2
         'A 2-byte integer value is stored in iVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_I2";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"iVal = ",sCleanTemp$,";"


         CASE comvt_I4
         'A 4-byte integer value is stored in lVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_I4";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"lVal = ",sCleanTemp$,";"

         CASE comvt_I8
         'A 8-byte integer value is stored in llVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_I8";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"llval = ",sCleanTemp$,";"

         CASE comvt_R4
         'An IEEE 4-byte real value is stored in fltVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_R4";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"fltVal = ",sCleanTemp$,";"

         CASE comvt_R8
         'An 8-byte IEEE real value is stored in dblVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_R8";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"dblVal = ",sCleanTemp$,";"

         CASE comvt_CY
         'A currency value was specified. A currency number is stored as 64-bit (8-byte),
         'two's complement integer, scaled by 10,000 to give a fixed-point number
         'with 15 digits to the left of the decimal point and 4 digits to the right.
         'The value is in cyVal.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_CY";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"cyVal = ",sCleanTemp$,";"

         CASE comvt_BSTR
         'A string was passed; it is stored in bstrVal. This pointer must be obtained and
         'freed by the BSTR functions, which are described in Conversion and Manipulation Functions.
         REPLACE CHR$(92)       WITH CHR$(92,92) IN sCleanTemp$
         REPLACE CHR$(92,92,92) WITH CHR$(92,92) IN sCleanTemp$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_BSTR";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"bstrVal = SysAllocString(L",sCleanTemp$,");"

         CASE comvt_DECIMAL
         'Decimal variables are stored as 96-bit (12-byte) unsigned integers scaled by a
         'variable power of 10. VT_DECIMAL uses the entire 16 bytes of the Variant.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_BYREF|VT_DECIMAL;"
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"decVal = ",sCleanTemp$,";"

         CASE comvt_NULL
         IF iArrayFlag THEN Abort("Invalid: Array of NULLs")
         IF iByrefFlag THEN Abort("Invalid: Pointer to NULL")
         'A propagating null value was specified. (This should not be confused with the null pointer.)
         'The null value is used for tri-state logic, as with SQL.
         ' BY_REF INVALID
         ' VT_ARRAY INVALID

         CASE comvt_ERROR
         'An SCODE was specified. The type of the error is specified in scodee. Generally,
         'operations on error values should raise an exception or propagate the error to
         'the return value, as appropriate.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_ERROR";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"scode = ",sCleanTemp$,";"

         CASE comvt_BOOL
         'A 16 bit Boolean (True/False) value was specified.
         'A value of 0xFFFF (all bits 1) indicates True;
         'a value of 0 (all bits 0) indicates False. No other values are valid.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_BOOL";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"boolVal = ",sCleanTemp$,";"

         CASE comvt_TRUE
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_BOOL";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"boolVal = VARIANT_TRUE;"

         CASE comvt_FALSE
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_BOOL";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"boolVal = VARIANT_FALSE;"

         CASE comvt_DATE
         'A value denoting a date and time was specified. Dates are represented as
         'double-precision numbers, where midnight, January 1, 1900 is 2.0, January 2, 1900 is 3.0,
         'and so on. The value is passed in date.
         'This is the same numbering system used by most spreadsheet programs,
         'although some specify incorrectly that February 29, 1900 existed, and thus
         'set January 1, 1900 to 1.0. The date can be converted to and from an MS-DOS
         'representation using VariantTimeToDosDateTime, which is discussed in
         'Conversion and Manipulation Functions.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_DATE";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"date = ",sCleanTemp$,";"

         CASE comvt_DISPATCH
         'A pointer to an object was specified. The pointer is in pdispVal.
         'This object is known only to implement IDispatch. The object can be queried as to
         'whether it supports any other desired interface by calling QueryInterface on the object.
         'Objects that do not implement IDispatch should be passed using VT_UNKNOWN.
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_DISPATCH";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"pdispVal = ",sCleanTemp$,";"

         CASE comvt_VARIANT
         'IF NOT iByrefFlag AND NOT iArrayFlag THEN Abort("Invalid: VARIANTARGs must be passed by reference.")
         'A pointer to another VARIANTARG is passed in pvarVal. This referenced VARIANTARG,
         'pvarVal, cannot be another VT_VARIANT|VT_BYREF. This value can be used to support
         'languages that allow functions to change the types of variables passed by reference.
         IF NOT iByrefFlag AND NOT iArrayFlag THEN   ' assumes variant holds a safearray of variants
            FPRINT Outfile, Scoot$,"  COM_PARAMS[",sTMP$,"].vt = VT_VARIANT | VT_ARRAY;"
            FPRINT Outfile, Scoot$,"  COM_PARAMS[",sTMP$,"].pvarVal = ";sCleanTemp$;".pvarVal;"
         ELSE
            FPRINT Outfile, Scoot$, "  COM_PARAMS[",sTMP$,"].vt = VT_VARIANT";P2$
            FPRINT Outfile, Scoot$, "  COM_PARAMS[",sTMP$,"].";P$;"pvarVal = ",sCleanTemp$,";"
         END IF

         CASE comvt_UNKNOWN
         'A pointer to an object that implements the IUnknown interface is passed in punkVal.
         'BY_REF: A pointer to the IUnknown interface is passed in ppunkVal. The pointer to
         'the interface is stored in the location referred to by ppunkVal.
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_UNKNOWN";P2$
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].";P$;"punkVal = ",sCleanTemp$,";"

         CASE comvt_PVOID
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_PVOID";P2$
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].";P$;"byref = ",sCleanTemp$,";"

         CASE comvt_STRVAR
         FPRINT Outfile, Scoot$, "COM_last_HR = COM_AS2WS(",sCleanTemp$, ");"
         FPRINT Outfile, Scoot$, "if (FAILED(COM_last_HR)) {"
         FPRINT Outfile, Scoot$, "  COM_HR_ErrMsg (COM_last_HR, _T("
         FPRINT Outfile, Scoot$, SPC$, ENC$("Build ParamList Failed! A2W failure!"),"));"
         FPRINT Outfile, Scoot$, "} else {"
         FPRINT Outfile, Scoot$, "COM_PARAMS[",sTMP$,"].vt = VT_BSTR";P2$
         FPRINT Outfile, Scoot$, "  COM_PARAMS[",sTMP$,"].bstrVal = SysAllocString(COM_LPWSTR_temp);"
         FPRINT Outfile, Scoot$, "}"

         CASE comvt_R8_LITERAL
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_R8";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].dblVal = ",sCleanTemp$,";"

         CASE comvt_OBJECT
         FPRINT Outfile, Scoot$,"VariantCopy(&COM_PARAMS[",sTMP$,"], &",sCleanTemp$,".pObjects[0]);"

         CASE comvt_I4_LITERAL
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_I4";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].lVal = ",sCleanTemp$,";"

         CASE comvt_VOID
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_VOID;"
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].lVal = (void)",sCleanTemp$,";"


         CASE comvt_HRESULT

         CASE comvt_PTR

         CASE comvt_SAFEARRAY
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_SAFEARRAY";P2$
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].";P$;"parray = &",sCleanTemp$,";"

         '      CASE comvt_CARRAY

         '      CASE comvt_USERDEFINED

         '      CASE comvt_LPSTR

         '      CASE comvt_LPWSTR

         '      CASE comvt_RECORD

         '      CASE comvt_INT_PTR

         '      CASE comvt_UINT_PTR

         '      CASE comvt_FILETIME

         '      CASE comvt_BLOB

         '      CASE comvt_STREAM

         '      CASE comvt_STORAGE

         '      CASE comvt_STREAMED_OBJECT

         '      CASE comvt_STORED_OBJECT

         '      CASE comvt_BLOB_OBJECT

         '      CASE comvt_CF

         '      CASE comvt_CLSID

         '      CASE comvt_VERSIONED_STREAM

         '      CASE comvt_BSTR_BLOB

         CASE comvt_NAMED_ARGUMENT
         Abort ("Named arguments are NOT supported in this version! (" + ParamToken$[i] + ")")

         CASE comvt_CAST
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = ",local_temp_str$,";"
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].",sCleanTemp$,";"

         CASE comvt_DEFAULT
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].vt = VT_I4;"
         FPRINT Outfile, Scoot$,"COM_PARAMS[",sTMP$,"].lVal = (long)",sCleanTemp$,";"

      END SELECT
   LOOP
   FUNCTION = iReturn
END FUNCTION ' BCX_COM_BUILD_PARAMETER_LIST



SUB BCX_COM_Parse_Method(com_method$, pparms$)
   ' ************************************************************************************************************
   ' Sub: BCX_COM_Parse_Method (part of BCX COM parser)
   ' Called internally by main com parser function, Find_COM_statement.
   ' If the statment is a COM method (with or without parameters) this function will be called.
   '
   ' Typical samples of COM methods:
   ' (method with parms) -- app.activeworkbook.saveas "c:\temp.xls"
   ' (invoke method)     -- app.quit
   ' ************************************************************************************************************
   Use_BCX_COM_InvokeMethod = Use_BCX_COM_UsesConversion = Use_COM = TRUE
   DIM LOCAL j
   DIM LOCAL k
   DIM LOCAL ObjName$
   DIM LOCAL ComTok$
   DIM LOCAL ComToken$
   DIM LOCAL temp_param$
   DIM LOCAL BuildSafeArray
   DIM LOCAL parms$

   IF COM_build_trace_code  THEN
      FPRINT Outfile, "    COM_add_trace_line(";
      FPRINT Outfile, ENC$("BCX_COM_Parse_Method(" + BCX_PREPARE_COM_TRACE_LINE$(com_method$) + " , " + BCX_PREPARE_COM_TRACE_LINE$(parms$) + ")" ), ");"
   END IF

   parms$ = TRIM$(pparms$)
   IF parms$ > "" THEN
      IF MID$(UCASE$(parms$),1,6) = "ARRAY(" OR MID$(UCASE$(parms$),1,6) = "ARRAY " THEN
         parms$ = REMAIN$(parms$,"(")
         j = LEN(parms$) -1
         parms[j] = 0 ' strip closing brace )
         BuildSafeArray = 1
         Use_BCX_COM_SafeArray = TRUE
      END IF
   END IF
   CALL ParseCom(com_method$)

   j = 1 : ObjName$ = ComStk$[j++]

   DO
      ComTok$ = ComStk$[j++]
      ComToken$ = ComTok$
      FPRINT Outfile, Scoot$,"lstrcpy(COM_ErrMsg, _T(", ENC$(BCX_PREPARE_COM_TRACE_LINE$(ComTok$)),"));"
      IF INCHR(ComTok$, "(") > 0 THEN
         temp_param$ = TRIM$(REMAIN$(ComTok$,"("))
         k = BCX_COM_BUILD_PARAMETER_LIST(MID$(temp_param$,1,LEN(temp_param$)-1),0)
         FPRINT Outfile, Scoot$,"COM_plist_index =", k ,";"
         ComToken$ = EXTRACT$(ComTok$,"(")
      END IF
      IF COM_build_trace_code  THEN
         IF NOTNULL(ComStk$[j]) THEN
            FPRINT Outfile, "    COM_add_trace_line(", ENC$("Get next dispatch for "+BCX_PREPARE_COM_TRACE_LINE$(ComTok$)), ");"
         ELSE
            FPRINT Outfile, "COM_add_trace_line(", ENC$("Invoke helper for:: "+ComTok$), ");"
         END IF
      END IF
      IF ISNULL(ComStk$[j]) THEN
         IF LEN(TRIM$(parms$))>0 THEN
            k = BCX_COM_BUILD_PARAMETER_LIST(parms$,0)
            FPRINT Outfile, Scoot$,"COM_plist_index =", k ,";"
            IF BuildSafeArray THEN
               FPRINT Outfile, Scoot$,"COM_create_safearray();"
            END IF
         END IF
         FPRINT Outfile, Scoot$,"COM_invoke(&",ObjName$,", L",ENC$(REMOVE$(ComToken$,SPC$)),", DISPATCH_METHOD, NULL);\n"
         EXIT DO
      END IF
      FPRINT Outfile, Scoot$,"COM_get_next_dispatch(&",ObjName$,", L",ENC$(REMOVE$(ComToken$,SPC$)),");"
   LOOP
END SUB ' BCX_COM_Parse_Method



SUB ParseCom(sCom$)
   '**************************************************************
   ' Common parser for COM SUBs
   ' BCX_COM_Parse_GetProperty
   ' BCX_COM_Parse_SetProperty
   ' BCX_COM_Parse_Method
   '**************************************************************
   DIM RAW i AS INT
   DIM RAW j AS INT
   DIM RAW k AS INT
   DIM RAW ComTok$
   ComNdx = 0
   CALL FastLexer(sCom$,SPC$,"()")
   IF Ndx THEN
      i = 1
      ComStk$[++ComNdx] = STRTOKEN$(Stk$[i],"." , 1)' get the name of object
      j = 1
      DO
         INCR j
         ComTok$ = STRTOKEN$ (Stk$[i], "." , j)
         IF ComTok$ = RIGHT$(Stk$[i],LEN(ComTok$)) THEN
            IF i < Ndx THEN
               IF Stk$[i+1] = "(" THEN                     ' Parameter token
                  k = 0
                  DO
                     INCR i
                     ComTok$ = ComTok$ + Stk$[i]
                     IF Stk$[i] = "(" THEN INCR k
                     IF Stk$[i] = ")" THEN DECR k
                  LOOP WHILE k
               END IF
               INCR i
               j = 1
            END IF
         END IF
         IF ISNULL(ComTok$) THEN
            EXIT DO
         END IF
         CALL Add2ComStk(ComTok$)
      LOOP
      CALL Add2ComStk("")
      ComNdx--
   END IF
END SUB


SUB Add2ComStk(ComTok$)

   IF cMaxComStk = ++ComNdx THEN
      CALL Abort("Too many COM tokens.")
   END IF

   ComStk$[ComNdx] = ComTok$
END SUB



FUNCTION BCX_PREPARE_COM_TRACE_LINE$(p_Src$)
   ' ************************************************************************************************
   ' Function: BCX_PREPARE_COM_TRACE_LINE (part of BCX COM parser)
   ' This function is used only if $COM_TRACE option is used.
   ' Function prepares escape characters in string literals for emitting to resulting C/C++ files.
   '
   ' Return Values:
   ' Function returns altered string.
   ' ************************************************************************************************
   DIM pp_Src$
   pp_Src$ = TRIM$(p_Src$)
   pp_Src$ = REPLACE$(pp_Src$, BKSLASH1$, BKSLASH2$)
   pp_Src$ = REPLACE$(pp_Src$, CHR$(c_DblQt), "\" + CHR$(c_DblQt))
   pp_Src$ = REPLACE$(pp_Src$, "%", "%%")
   pp_Src$ = REPLACE$(pp_Src$, "'", "\'")
   FUNCTION = pp_Src$
END FUNCTION ' BCX_PREPARE_COM_TRACE_LINE

'***************************************************************************************************
'                             END OF LATE BINDING COM RUNTIME SUPPORT
'
'                          Begin Standard BCX Runtime Library Functions
'***************************************************************************************************


SUB RunTimeFunctions (FP_WRITE AS FILE)
   FPRINT FP_WRITE, ""
   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, "//                 ";$BCX_STR_RUNTIME
   FPRINT FP_WRITE, "// *************************************************"
   FPRINT FP_WRITE, ""

   IF Use_BcxTmpStr THEN
      FPRINT FP_WRITE, "char *BCX_TmpStr (size_t iBytes)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static int   StrCnt;"
      FPRINT FP_WRITE, "  static char *StrFunc[2048];"
      FPRINT FP_WRITE, "  StrCnt = (StrCnt + 1) & (2047);"
      FPRINT FP_WRITE, "  if (StrFunc[StrCnt])"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    free (StrFunc[StrCnt]);"
      FPRINT FP_WRITE, "    StrFunc[StrCnt] = NULL;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  StrFunc[StrCnt] = (char*)calloc(iBytes+1, sizeof(char));"
      FPRINT FP_WRITE, "  return StrFunc[StrCnt];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Left THEN
      FPRINT FP_WRITE, "char *left (LPCTSTR szSrc, int length)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  size_t tmplen = strlen(szSrc);"
      FPRINT FP_WRITE, "  if (length < 1) return BCX_TmpStr(1);"
      FPRINT FP_WRITE, "  if (length < (int)tmplen) tmplen = length;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(tmplen);"
      FPRINT FP_WRITE, "  return (char*)memcpy(strtmp, szSrc, tmplen);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Right THEN
      FPRINT FP_WRITE, "char *right (LPCTSTR szSrc, int length)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  size_t tmplen = strlen(szSrc);"
      FPRINT FP_WRITE, "  if (length < 1) return BCX_TmpStr(1);"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(tmplen);"
      FPRINT FP_WRITE, "  tmplen -= length;"
      FPRINT FP_WRITE, "  if (tmplen < 1) tmplen = 0;"
      FPRINT FP_WRITE, "  return strcpy (BCX_RetStr, &szSrc[tmplen]);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Cpad THEN
      FPRINT FP_WRITE, "char *cpad (LPCTSTR szStr, int i_Max, int c)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char  fill[2]= {0}; fill[0] = (char) c;"
      FPRINT FP_WRITE, "  char *szTmp = BCX_TmpStr(i_Max);"
      FPRINT FP_WRITE, "  size_t Half = (i_Max/2) + (strlen(szStr)/2);"
      FPRINT FP_WRITE, "  strcpy(szTmp, szStr);"
      FPRINT FP_WRITE, "  while(strlen(szTmp) < Half)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    strcpy(szTmp, join(2, fill, szTmp));"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  while((int)strlen(szTmp)<i_Max)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    strcat(szTmp, fill);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  szTmp[i_Max] = 0;"
      FPRINT FP_WRITE, "  return szTmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Rpad THEN
      FPRINT FP_WRITE, "char *rpad (LPCTSTR szStr, int L, int c)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp;"
      FPRINT FP_WRITE, "  int s = (int)strlen(szStr);"
      FPRINT FP_WRITE, "  if ((L-s) < 1) return (char*)szStr;"
      FPRINT FP_WRITE, "  strtmp = BCX_TmpStr(L);"
      FPRINT FP_WRITE, "  strcpy (strtmp, szStr);"
      FPRINT FP_WRITE, "  memset (&strtmp[s], c, (L-s));"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Lpad THEN
      FPRINT FP_WRITE, "char *lpad (LPCTSTR szStr, int L, int c)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp;"
      FPRINT FP_WRITE, "  L = L-(int)strlen(szStr);"
      FPRINT FP_WRITE, "  if (L<1) return (char*)szStr;"
      FPRINT FP_WRITE, "  strtmp = BCX_TmpStr(L);"
      FPRINT FP_WRITE, "  memset (strtmp, c, L);"
      FPRINT FP_WRITE, "  return strcat(strtmp, szStr);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Mid THEN
      FPRINT FP_WRITE, "char *mid (LPCTSTR szSrc, int start, int length)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp;"
      FPRINT FP_WRITE, "  int tmplen = (int)strlen(szSrc);"
      FPRINT FP_WRITE, "  if (start > tmplen||start < 1) return BCX_TmpStr(1);"
      FPRINT FP_WRITE, "  if (length < 0 || length > (tmplen-start) + 1)"
      FPRINT FP_WRITE, "    length = (tmplen-start) + 1;"
      FPRINT FP_WRITE, "  strtmp = BCX_TmpStr(length);"
      FPRINT FP_WRITE, "  return (char*)memcpy(strtmp, &szSrc[start - 1], length);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Trim THEN
      'Trims off:  CR, LF, SPACES, and horz and vert TABS
      FPRINT FP_WRITE, "char *trim (LPCTSTR szSrc)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (0 == szSrc[0]) return (char*)szSrc;"
      FPRINT FP_WRITE, "  while(*szSrc == 32 || (*szSrc >= 9 && *szSrc <= 13)) szSrc++;"
      FPRINT FP_WRITE, "  size_t i = strlen(szSrc);"
      FPRINT FP_WRITE, "  while(i > 0 && (szSrc[i-1] == 32 || (szSrc[i-1] >= 9 && szSrc[i-1] <= 13))) i--;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(i);"
      FPRINT FP_WRITE, "  return (char*)memcpy(strtmp, szSrc, i);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Ltrim THEN
      FPRINT FP_WRITE, "char *ltrim (LPCTSTR szSrc, char c)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (0 == szSrc[0]) return (char*) szSrc;"
      FPRINT FP_WRITE, "  while(*szSrc==32 || (*szSrc >= 9 && *szSrc <= 13) || *szSrc == c) szSrc++;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(strlen(szSrc));"
      FPRINT FP_WRITE, "  return strcpy(strtmp, szSrc);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Rtrim THEN
      FPRINT FP_WRITE, "char *rtrim (LPCTSTR szSrc, char c)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (0 == szSrc[0] ) return (char*)szSrc;"
      FPRINT FP_WRITE, "  size_t i = strlen(szSrc);"
      FPRINT FP_WRITE, "  while(i > 0 && (szSrc[i-1]==32 || (szSrc[i-1]>=9 && szSrc[i-1]<=13) || szSrc[i-1]==c)) i--;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(i);"
      FPRINT FP_WRITE, "  return (char*)memcpy(strtmp, szSrc, i);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Strim THEN
      FPRINT FP_WRITE, "char *strim (LPCTSTR szSrc)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (0 == szSrc[0]) return (char*) szSrc;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(strlen(szSrc));"
      FPRINT FP_WRITE, "  char *dst = strtmp;"
      FPRINT FP_WRITE, "  while (isspace((unsigned char)*szSrc)) szSrc++;"
      FPRINT FP_WRITE, "  do"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    while (*szSrc && !isspace((unsigned char)*szSrc)) *dst++ = *szSrc++;"
      FPRINT FP_WRITE, "    if (*szSrc)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      *dst++ = *szSrc++;"
      FPRINT FP_WRITE, "      while (isspace((unsigned char)*szSrc)) szSrc++;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  while (*szSrc);"
      FPRINT FP_WRITE, "  if (isspace((unsigned char)*(--dst))) *dst = 0;"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Command THEN
      FPRINT FP_WRITE, "char *command (int nArg)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int ii = 0;"
      FPRINT FP_WRITE, "  char *c = NULL, *retstr, *s = GetCommandLine();"
      FPRINT FP_WRITE, "  if (nArg < ii) // return entire commandline"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    while(*s && *s != 32)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if (*s == 34) while(*++s && *s != 34);"
      FPRINT FP_WRITE, "      s++;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    while(isspace((unsigned char)*s))s++;"
      FPRINT FP_WRITE, "    retstr = BCX_TmpStr(strlen(s)+1);"
      FPRINT FP_WRITE, "    strcpy(retstr, s);"
      FPRINT FP_WRITE, "    if (*(retstr + strlen(retstr)-1)==20) *retstr=0;"
      FPRINT FP_WRITE, "    return retstr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  while(ii <= nArg)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    while(isspace((unsigned char)*s)) s++; // skip whitespace"
      FPRINT FP_WRITE, "    c = s;"
      FPRINT FP_WRITE, "    if (*s == 34) {              // argument starts a quote"
      FPRINT FP_WRITE, "      while(*++s && *s != 34)    // skip until next quote"
      FPRINT FP_WRITE, "        ;                        // Do NOT remove this semicolon"
      FPRINT FP_WRITE, "      if (*s) s++;               // skip quote itself"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      while(*s && *s != 32) s++;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    ii++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (*c == 34)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    c++;                       // skip leading quote"
      FPRINT FP_WRITE, "    if (*(s-1) == 34) s--;     // skip any trailing quotes"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  retstr = BCX_TmpStr((int)(s - c) + 1);"
      FPRINT FP_WRITE, "  strncpy(retstr, c,(int)(s - c));"
      FPRINT FP_WRITE, "  retstr[s-c]=0;"
      FPRINT FP_WRITE, "  return retstr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Extract THEN
      FPRINT FP_WRITE, "char *extract (LPCTSTR strSrc, LPCTSTR strPattern)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  LPCTSTR szMatch;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(strlen(strSrc));"
      FPRINT FP_WRITE, "  if (*strPattern != 0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    szMatch = strstr(strSrc, strPattern);"
      FPRINT FP_WRITE, "    if (szMatch) return (char*)memcpy(strtmp, strSrc, szMatch-strSrc);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return strcpy(strtmp, strSrc);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Remain THEN
      FPRINT FP_WRITE, "char *remain (LPCTSTR strSrc, LPCTSTR strPattern)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  LPCTSTR p = strstr(strSrc, strPattern);"
      FPRINT FP_WRITE, "  if (p)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    p+=(strlen(strPattern));"
      FPRINT FP_WRITE, "    return (char*)p;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return (char*)strSrc;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Replace THEN
      FPRINT FP_WRITE, "char *replace (LPCTSTR szMain, LPCTSTR szFind, LPCTSTR szRepl)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  size_t LenPat, LenRep, iTmp, iChange;"
      FPRINT FP_WRITE, "  char *strtmp, *cp_p, *cp_q, *cp_r;"
      FPRINT FP_WRITE, "  if (!szFind || !*szFind) return (char*) szMain;"
      FPRINT FP_WRITE, "  LenRep = strlen(szRepl);"
      FPRINT FP_WRITE, "  LenPat = strlen(szFind);"
      FPRINT FP_WRITE, "  for (iTmp = 0, cp_p = (char*)szMain;"
      FPRINT FP_WRITE, "       (cp_q = strstr(cp_p, (char*)szFind))!=0;"
      FPRINT FP_WRITE, "       cp_p = cp_q + LenPat)"
      FPRINT FP_WRITE, "    iTmp += (int)(cp_q - cp_p) + LenRep;"
      FPRINT FP_WRITE, "  iTmp += strlen(cp_p);"
      FPRINT FP_WRITE, "  strtmp = BCX_TmpStr(iTmp);"
      FPRINT FP_WRITE, "  if (!strtmp) return NULL;"
      FPRINT FP_WRITE, "  for (cp_r = strtmp, cp_p=(char*)szMain;"
      FPRINT FP_WRITE, "       (cp_q=strstr(cp_p,(char*)szFind))!=0;"
      FPRINT FP_WRITE, "       cp_p = cp_q + LenPat)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    iChange = (int)(cp_q-cp_p);"
      FPRINT FP_WRITE, "    memcpy(cp_r, cp_p, iChange); cp_r += iChange;"
      FPRINT FP_WRITE, "    strcpy(cp_r, szRepl); cp_r += LenRep;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  strcpy(cp_r, cp_p);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_iReplace THEN
      FPRINT FP_WRITE, "char *iReplace (LPCTSTR szMain, LPCTSTR szFind, LPCTSTR szRepl)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  size_t LenPat, LenRep, tmpsz, iChange;"
      FPRINT FP_WRITE, "  char *strtmp, *cp_p, *cp_q, *cp_r;"
      FPRINT FP_WRITE, "  if (!szFind || !*szFind) return (char*)szMain;"
      FPRINT FP_WRITE, "  LenRep = strlen(szRepl);"
      FPRINT FP_WRITE, "  LenPat = strlen(szFind);"
      FPRINT FP_WRITE, "  for (tmpsz=0, cp_p = (char*)szMain;"
      FPRINT FP_WRITE, "       (cp_q =_stristr_(cp_p,(char*)szFind))!=0;"
      FPRINT FP_WRITE, "       cp_p = cp_q+LenPat)"
      FPRINT FP_WRITE, "    tmpsz += (int)(cp_q - cp_p) + LenRep;"
      FPRINT FP_WRITE, "  tmpsz += strlen(cp_p);"
      FPRINT FP_WRITE, "  strtmp = BCX_TmpStr(tmpsz);"
      FPRINT FP_WRITE, "  if (!strtmp) return NULL;"
      FPRINT FP_WRITE, "  for (cp_r = strtmp,cp_p=(char*)szMain;"
      FPRINT FP_WRITE, "       (cp_q =_stristr_(cp_p,(char*)szFind))!=0;"
      FPRINT FP_WRITE, "       cp_p = cp_q + LenPat)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    iChange = (int) (cp_q-cp_p);"
      FPRINT FP_WRITE, "    memcpy(cp_r,cp_p,iChange);"
      FPRINT FP_WRITE, "    cp_r += iChange;"
      FPRINT FP_WRITE, "    strcpy(cp_r,(char*)szRepl);"
      FPRINT FP_WRITE, "    cp_r += LenRep;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  strcpy(cp_r,cp_p);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Reverse THEN
      FPRINT FP_WRITE, "char *reverse (LPCTSTR szStr)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  size_t j = strlen(szStr);"
      FPRINT FP_WRITE, "  char *rstr = BCX_TmpStr(j);"
      FPRINT FP_WRITE, "  while(j)  rstr[--j] = *(szStr++);"
      FPRINT FP_WRITE, "  return rstr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Findfirst THEN
      FPRINT FP_WRITE, "char *findfirst (LPCTSTR szSrc)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(";"BCXSTRSIZE";");"
      FPRINT FP_WRITE, "  if (fffn_FileHandle) FindClose(fffn_FileHandle);"
      FPRINT FP_WRITE, "  fffn_FileHandle = FindFirstFile(szSrc, &fffn_FindData);"
      FPRINT FP_WRITE, "  if (fffn_FileHandle != INVALID_HANDLE_VALUE)"
      FPRINT FP_WRITE, "    strcpy(strtmp, fffn_FindData.cFileName);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    fffn_FileHandle = 0;"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Findnext THEN
      FPRINT FP_WRITE, "char *findnext (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(";"BCXSTRSIZE";");"
      FPRINT FP_WRITE, "  if (fffn_FileHandle)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    int Found = FindNextFile(fffn_FileHandle, &fffn_FindData);"
      FPRINT FP_WRITE, "    if (Found)"
      FPRINT FP_WRITE, "      strcpy(strtmp, fffn_FindData.cFileName);"
      FPRINT FP_WRITE, "    else"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      FindClose(fffn_FileHandle);"
      FPRINT FP_WRITE, "      fffn_FileHandle = 0;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Ucase THEN
      FPRINT FP_WRITE, "char *ucase (LPCTSTR szStr)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return CharUpperA(strcpy(BCX_TmpStr(strlen(szStr)), szStr));"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Lcase THEN
      FPRINT FP_WRITE, "char *lcase (LPCTSTR szStr)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return CharLowerA(strcpy(BCX_TmpStr(strlen(szStr)), szStr));"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Mcase THEN
      FPRINT FP_WRITE, "char *mcase (LPCTSTR szStr)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(strlen(szStr)+1);"
      FPRINT FP_WRITE, "  char *s = strtmp;"
      FPRINT FP_WRITE, "  CharLowerA(strcpy(strtmp, szStr));"
      FPRINT FP_WRITE, "  while(*s)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (islower(*s))"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      *s-=32;"
      FPRINT FP_WRITE, "      while(isalpha(*++s));"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    s++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Remove THEN
      FPRINT FP_WRITE, "char *RemoveStr (LPCTSTR szSrc, LPCTSTR RemoveMe)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp, *pp, *dd;"
      FPRINT FP_WRITE, "  int  tmplen;"
      FPRINT FP_WRITE, "  strtmp = dd = BCX_TmpStr(strlen(szSrc));"
      FPRINT FP_WRITE, "  if (!RemoveMe || !*RemoveMe) return strcpy(strtmp, szSrc);"
      FPRINT FP_WRITE, "  pp = strstr((char*)szSrc, (char*)RemoveMe); tmplen = (int)strlen(RemoveMe);"
      FPRINT FP_WRITE, "  while (pp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    memcpy (dd, (char*)szSrc, pp - szSrc);"
      FPRINT FP_WRITE, "    dd+= (pp - szSrc);"
      FPRINT FP_WRITE, "    szSrc = pp + tmplen;"
      FPRINT FP_WRITE, "    pp = strstr((char*)szSrc,(char*)RemoveMe);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  strcpy (dd, (char*)szSrc);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_IRemove THEN
      FPRINT FP_WRITE, "char *IRemoveStr (LPCTSTR szSrc, LPCTSTR RemoveMe)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp, *pp, *dd;"
      FPRINT FP_WRITE, "  int  tmplen;"
      FPRINT FP_WRITE, "  strtmp = dd = BCX_TmpStr(strlen(szSrc));"
      FPRINT FP_WRITE, "  if (!RemoveMe || !*RemoveMe) return strcpy(strtmp, szSrc);"
      FPRINT FP_WRITE, "  pp = _stristr_(szSrc, RemoveMe); tmplen = (int)strlen(RemoveMe);"
      FPRINT FP_WRITE, "  while(pp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    memcpy (dd, szSrc, pp - szSrc);"
      FPRINT FP_WRITE, "    dd+= (pp - szSrc);"
      FPRINT FP_WRITE, "    szSrc =  pp + tmplen;"
      FPRINT FP_WRITE, "    pp = _stristr_(szSrc, RemoveMe);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  strcpy (dd, szSrc);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Ins THEN
      FPRINT FP_WRITE, "char *ins (LPCTSTR szStr, int ii, LPCTSTR a)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int j = (int)strlen(szStr);"
      FPRINT FP_WRITE, "  if (ii<1 || ii > j+1) return (char*)szStr;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(j + strlen(a));"
      FPRINT FP_WRITE, "  memcpy (strtmp, szStr, --ii);"
      FPRINT FP_WRITE, "  strcpy(&strtmp[ii], a);"
      FPRINT FP_WRITE, "  return strcat(strtmp, &szStr[ii]);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Del THEN
      FPRINT FP_WRITE, "char *del (LPCTSTR szStr, int ii, int j)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  size_t ln = strlen(szStr);"
      FPRINT FP_WRITE, "  if (ii<1 || ii > ln) return (char*)szStr;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(ln);"
      FPRINT FP_WRITE, "  memcpy (strtmp, szStr, --ii);"
      FPRINT FP_WRITE, "  return strcat(strtmp, &szStr[ii+j]);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Str THEN
      FPRINT FP_WRITE, "char *str(double d_, int nospc)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(64);"
      FPRINT FP_WRITE, "  if (nospc)"
      FPRINT FP_WRITE, "    snprintf(strtmp, 64, ", ENC$("%.15G"), ", d_);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    snprintf(strtmp, 64, ", ENC$("% .15G"), ", d_);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Strl THEN
      FPRINT FP_WRITE, "char *strl(long double d, int nospc)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(64);"
      FPRINT FP_WRITE, "  if (nospc)"
      FPRINT FP_WRITE, "    snprintf (strtmp, 64, ", ENC$("%.19LG"), ", d);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    snprintf (strtmp, 64, ", ENC$("% .19LG"), ", d);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Curdir THEN
      FPRINT FP_WRITE, "char *curdir (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(";"BCXSTRSIZE";");"
      FPRINT FP_WRITE, "  GetCurrentDirectory (1024, strtmp);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Hex THEN
      FPRINT FP_WRITE, "char *hex (int a)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(32);"
      FPRINT FP_WRITE, "  sprintf(strtmp,";VCHR$(4,34,37,88,34);", a);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Tempdir THEN
      FPRINT FP_WRITE, "char *tempdir (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(";"BCXSTRSIZE";");"
      FPRINT FP_WRITE, "  GetTempPath (1024, strtmp);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Windir THEN
      FPRINT FP_WRITE, "char *windir (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(";"BCXSTRSIZE";");"
      FPRINT FP_WRITE, "  GetWindowsDirectory (strtmp, BCXSTRSIZE);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Sysdir THEN
      FPRINT FP_WRITE, "char *sysdir (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  GetSystemDirectory (strtmp, BCXSTRSIZE);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Repeat THEN
      FPRINT FP_WRITE, "char *repeat (int count, LPCTSTR a_)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr((count+1)*strlen(a_));"
      FPRINT FP_WRITE, "  while(count-- > 0) strtmp = strcat(strtmp, a_);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_String THEN
      FPRINT FP_WRITE, "char *stringx (int count_, int a_)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (count_<1) return BCX_TmpStr(1);"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(count_);"
      FPRINT FP_WRITE, "  return (char*)memset(strtmp, a_, count_);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Space THEN
      FPRINT FP_WRITE, "char *space (int count)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (count<1) return BCX_TmpStr(1);"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(count);"
      FPRINT FP_WRITE, "  return (char*)memset(strtmp, 32, count);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Time THEN
      '***************************************************
      DIM STATIC  T0$    '  "%H:%M:%S"
      DIM STATIC  T1$    '  "%H"
      DIM STATIC  T2$    '  "%M"
      DIM STATIC  T3$    '  "%S"
      DIM STATIC  T4$    '  "%p"
      DIM STATIC  T5$    '  "%Y"
      DIM STATIC  T6$    '  "%m"
      DIM STATIC  T7$    '  "%d"
      DIM STATIC  T8$    '  "%A"
      DIM STATIC  T9$    '  "%w"
      DIM STATIC  T10$   '  "%j"
      DIM STATIC  T11$   '  "%U"
      '***************************************************
      T0$  = VCHR$(10,34,37,72,58,37,77,58,37,83,34)
      T1$  = VCHR$(4,34,37, 72,34)
      T2$  = VCHR$(4,34,37, 77,34)
      T3$  = VCHR$(4,34,37, 83,34)
      T4$  = VCHR$(4,34,37,112,34)
      T5$  = VCHR$(4,34,37, 89,34)
      T6$  = VCHR$(4,34,37,109,34)
      T7$  = VCHR$(4,34,37,100,34)
      T8$  = VCHR$(4,34,37, 65,34)
      T9$  = VCHR$(4,34,37,119,34)
      T10$ = VCHR$(4,34,37,106,34)
      T11$ = VCHR$(4,34,37, 85,34)
      '***************************************************
      FPRINT FP_WRITE, "char *timef (int t, int u)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  time_t elapse_time;"
      FPRINT FP_WRITE, "  struct tm *tp;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(256);"
      FPRINT FP_WRITE, "  time (&elapse_time);"
      FPRINT FP_WRITE, "  if (u==0)"
      FPRINT FP_WRITE, "    tp = localtime(&elapse_time);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    tp = gmtime(&elapse_time);"
      FPRINT FP_WRITE, "  switch (t)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "  case 0:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T0$, ", tp); break;"
      FPRINT FP_WRITE, "  case 1:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T1$, ", tp); break;"
      FPRINT FP_WRITE, "  case 2:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T2$, ", tp); break;"
      FPRINT FP_WRITE, "  case 3:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T3$, ", tp); break;"
      FPRINT FP_WRITE, "  case 4:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T4$, ", tp); break;"
      FPRINT FP_WRITE, "  case 5:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T5$, ", tp); break;"
      FPRINT FP_WRITE, "  case 6:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T6$, ", tp); break;"
      FPRINT FP_WRITE, "  case 7:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T7$, ", tp); break;"
      FPRINT FP_WRITE, "  case 8:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T8$, ", tp); break;"
      FPRINT FP_WRITE, "  case 9:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T9$, ", tp); break;"
      FPRINT FP_WRITE, "  case 10:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T10$, ", tp); break;"
      FPRINT FP_WRITE, "  case 11:"
      FPRINT FP_WRITE, "    strftime(strtmp, 256, ", T11$, ", tp); break;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Wrap THEN
      FPRINT FP_WRITE, "char *wrap (LPCTSTR _a, LPCTSTR _b, LPCTSTR _c)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr;"
      FPRINT FP_WRITE, "  char  Qt[2] = {34, 0};"
      FPRINT FP_WRITE, "  BCX_RetStr = BCX_TmpStr (strlen(_a)+strlen(_b)+strlen(_c)+3);"
      FPRINT FP_WRITE, "  if (*_b==0 && *_c==0)"
      FPRINT FP_WRITE, "    sprintf(BCX_RetStr,", ENC$("%s%s%s"), ", Qt, _a, Qt);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    sprintf(BCX_RetStr,", ENC$("%s%s%s"), ", _b, _a, _c);"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Unwrap THEN
      FPRINT FP_WRITE, "char *unwrap (LPCTSTR _a, LPCTSTR _b, LPCTSTR _c)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr;"
      FPRINT FP_WRITE, "  char  Qt[2] = {34,0};"
      FPRINT FP_WRITE, "  BCX_RetStr = BCX_TmpStr(strlen(_a));"
      FPRINT FP_WRITE, "  strcpy(BCX_RetStr, _a);"
      FPRINT FP_WRITE, "  if (0 == *_b && 0 == *_c)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (strcmp(left(BCX_RetStr, 1), Qt)==0)"
      FPRINT FP_WRITE, "      BCX_RetStr = BCX_RetStr + 1;"
      FPRINT FP_WRITE, "    if (strcmp(right(BCX_RetStr, 1), Qt)==0)"
      FPRINT FP_WRITE, "      BCX_RetStr[strlen(BCX_RetStr)-1]=0;"
      FPRINT FP_WRITE, "    return BCX_RetStr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (strcmp(left(BCX_RetStr,  strlen(_b)), _b)==0)"
      FPRINT FP_WRITE, "    BCX_RetStr = BCX_RetStr + strlen(_b);"
      FPRINT FP_WRITE, "  if (strcmp(right(BCX_RetStr, strlen(_c)), _c)==0)"
      FPRINT FP_WRITE, "    BCX_RetStr[strlen(BCX_RetStr)-strlen(_c)]=0;"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Enclose THEN
      FPRINT FP_WRITE, "char *enc (LPCTSTR Arg_A, int L, int R)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  size_t tmplen = strlen(Arg_A);"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(tmplen+3);"
      FPRINT FP_WRITE, "  memcpy(BCX_RetStr+1, Arg_A, tmplen);"
      FPRINT FP_WRITE, "  *BCX_RetStr = (char)((L==0) ? 34 : L);"
      FPRINT FP_WRITE, "  BCX_RetStr[++tmplen] = (char)((R==0) ? *BCX_RetStr : R);"
      FPRINT FP_WRITE, "  BCX_RetStr[++tmplen] = 0;"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Chr THEN
      FPRINT FP_WRITE, "char *chr"
      FPRINT FP_WRITE, "("
      FPRINT FP_WRITE, "  unsigned char a_,unsigned char b_,"
      FPRINT FP_WRITE, "  unsigned char c_,unsigned char d_,"
      FPRINT FP_WRITE, "  unsigned char e_,unsigned char f_,"
      FPRINT FP_WRITE, "  unsigned char g_,unsigned char h_,"
      FPRINT FP_WRITE, "  unsigned char i_,unsigned char j_"
      FPRINT FP_WRITE, ")"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(11);"
      FPRINT FP_WRITE, "  strtmp[0]  = a_;"
      FPRINT FP_WRITE, "  strtmp[1]  = b_;"
      FPRINT FP_WRITE, "  strtmp[2]  = c_;"
      FPRINT FP_WRITE, "  strtmp[3]  = d_;"
      FPRINT FP_WRITE, "  strtmp[4]  = e_;"
      FPRINT FP_WRITE, "  strtmp[5]  = f_;"
      FPRINT FP_WRITE, "  strtmp[6]  = g_;"
      FPRINT FP_WRITE, "  strtmp[7]  = h_;"
      FPRINT FP_WRITE, "  strtmp[8]  = i_;"
      FPRINT FP_WRITE, "  strtmp[9]  = j_;"
      FPRINT FP_WRITE, "  strtmp[10] = 0;"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_VChr THEN
      FPRINT FP_WRITE, "char *vchr(int charcount, ...)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int c = 0, ii = charcount;"
      FPRINT FP_WRITE, "  char *s_ = BCX_TmpStr(charcount + 1);"
      FPRINT FP_WRITE, "  va_list marker;"
      FPRINT FP_WRITE, "  s_[ii] = 0;"
      FPRINT FP_WRITE, "  va_start(marker, charcount);"
      FPRINT FP_WRITE, "  while (ii-- > 0) s_[c++] = (char) va_arg(marker, int);"
      FPRINT FP_WRITE, "  va_end(marker);"
      FPRINT FP_WRITE, "  return s_;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Join THEN
      FPRINT FP_WRITE, "char *join(int n, ...)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int ii = n, tmplen = 0;"
      FPRINT FP_WRITE, "  char *s_;"
      FPRINT FP_WRITE, "  char *strtmp;"
      FPRINT FP_WRITE, "  va_list marker;"
      FPRINT FP_WRITE, "  va_start(marker, n); // Initialize variable arguments"
      FPRINT FP_WRITE, "  while(ii-- > 0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    s_ = va_arg(marker, char *);"
      FPRINT FP_WRITE, "    if (s_) tmplen += (int)strlen(s_);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  strtmp = BCX_TmpStr(tmplen);"
      FPRINT FP_WRITE, "  va_end(marker); // Reset variable arguments"
      FPRINT FP_WRITE, "  ii = n;"
      FPRINT FP_WRITE, "  va_start(marker, n); // Initialize variable arguments"
      FPRINT FP_WRITE, "  while(ii-- > 0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    s_ = va_arg(marker, char *);"
      FPRINT FP_WRITE, "    if (s_) strcat(strtmp, s_);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  va_end(marker); // Reset variable arguments"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Environ THEN
      FPRINT FP_WRITE, "char* Environ(LPCTSTR szStr)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(32768);"
      FPRINT FP_WRITE, "  GetEnvironmentVariable (szStr, strtmp, 32767);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Oct THEN
      FPRINT FP_WRITE, "char *oct (int a)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  sprintf(strtmp, ";VCHR$(4,34,37,111,34);", a);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Bin THEN
      FPRINT FP_WRITE, "char* Bin(int number)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  _itoa(number, strtmp, 2);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Clip_Gettext THEN
      FPRINT FP_WRITE, "char *Clipboard_GetText (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char   *BCX_RetStr = NULL;"
      FPRINT FP_WRITE, "  HGLOBAL hGlob = NULL;"
      FPRINT FP_WRITE, "  PTSTR   pGlob = NULL;"
      FPRINT FP_WRITE, "  PTSTR   pTxt  = NULL;"
      FPRINT FP_WRITE, "  if (!IsClipboardFormatAvailable(CF_TEXT))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr = BCX_TmpStr(1);"
      FPRINT FP_WRITE, "    return BCX_RetStr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if(!OpenClipboard(NULL))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    MessageBox (GetActiveWindow(),", ENC$("Cannot open clipboard!"), ",", ENC$("Error!"), ",0 );"
      FPRINT FP_WRITE, "    BCX_RetStr = BCX_TmpStr(1);"
      FPRINT FP_WRITE, "    return BCX_RetStr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  hGlob = GetClipboardData(CF_TEXT);"
      FPRINT FP_WRITE, "  if(hGlob)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    pGlob = (char*)GlobalLock(hGlob);"
      FPRINT FP_WRITE, "    if (pTxt)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      free(pTxt);"
      FPRINT FP_WRITE, "      pTxt = NULL;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "      pTxt = (char*)malloc(GlobalSize(hGlob));"
      FPRINT FP_WRITE, "      lstrcpy(pTxt,pGlob);"
      FPRINT FP_WRITE, "      GlobalUnlock(hGlob);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  CloseClipboard();"
      FPRINT FP_WRITE, "  BCX_RetStr = BCX_TmpStr(lstrlen(pTxt));"
      FPRINT FP_WRITE, "  strcpy(BCX_RetStr,pTxt);"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF



   IF Use_Inkey THEN
      FPRINT FP_WRITE, "char* inkey(void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(2);"
      FPRINT FP_WRITE, "  if (_kbhit())"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    int asccodereturn = _getch();"
      FPRINT FP_WRITE, "    strtmp[0] = asccodereturn;"
      FPRINT FP_WRITE, "    strtmp[1] = 0;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Date THEN
      FPRINT FP_WRITE, "char *date (int tz)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  time_t elapse_time;"
      FPRINT FP_WRITE, "  struct tm *tp;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(24);"
      FPRINT FP_WRITE, "  time(&elapse_time);"
      FPRINT FP_WRITE, "  if (tz == 0)"
      FPRINT FP_WRITE, "    tp = localtime(&elapse_time);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    tp = gmtime(&elapse_time);"
      FPRINT FP_WRITE, "  strftime(strtmp, 24, ",  ENC$("%m-%d-20%y"),  ", tp);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_IsoDate THEN
      FPRINT FP_WRITE, "char *isodate (int tz)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  time_t elapse_time;"
      FPRINT FP_WRITE, "  struct tm *tp;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(24);"
      FPRINT FP_WRITE, "  time(&elapse_time);"
      FPRINT FP_WRITE, "  if (tz == 0)"
      FPRINT FP_WRITE, "    tp = localtime(&elapse_time);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    tp = gmtime(&elapse_time);"
      FPRINT FP_WRITE, "  strftime(strtmp, 24, ", ENC$("20%y-%m-%d"), ", tp);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Now THEN
      FPRINT FP_WRITE, "char *now (int tz)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  time_t elapse_time;"
      FPRINT FP_WRITE, "  struct tm *tp;"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  time(&elapse_time);"
      FPRINT FP_WRITE, "  if (tz == 0)"
      FPRINT FP_WRITE, "    tp = localtime(&elapse_time);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    tp = gmtime(&elapse_time);"
      FPRINT FP_WRITE, "  strftime(strtmp, 256, ", ENC$("%m/%d/%y %I:%M:%S %p"), ", tp);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Getfilename THEN
      FPRINT FP_WRITE, "char *GetFileName(LPCTSTR Title,"
      FPRINT FP_WRITE, "                  LPCTSTR Filter,"
      FPRINT FP_WRITE, "                  int     Flag,"
      FPRINT FP_WRITE, "                  HWND    hWnd,"
      FPRINT FP_WRITE, "                  DWORD   Flags,"
      FPRINT FP_WRITE, "                  LPCTSTR InitDir,"
      FPRINT FP_WRITE, "                  LPCTSTR Initfname,"
      FPRINT FP_WRITE, "                  int    *ExtIdx)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  OPENFILENAME OpenFileStruct;"
      FPRINT FP_WRITE, "  char Extension[2048];"
      FPRINT FP_WRITE, "  int Counter = 0, TmpSize;"
      FPRINT FP_WRITE, "  static char *filename;"
      FPRINT FP_WRITE, "  static int BufSize;"
      FPRINT FP_WRITE, "  TmpSize = ((Flags & OFN_ALLOWMULTISELECT) ? 500000:MAX_PATH);"
      FPRINT FP_WRITE, "  if (TmpSize > BufSize)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BufSize  = TmpSize;"
      FPRINT FP_WRITE, "    filename = (char*)realloc(filename, BufSize);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  memset(filename, 0, BufSize);"
      FPRINT FP_WRITE, "  memset(Extension, 0, 2048);"
      FPRINT FP_WRITE, "  memset(&OpenFileStruct, 0, sizeof(OpenFileStruct));"
      FPRINT FP_WRITE, "  if (Initfname) strcpy(filename, Initfname);"
      FPRINT FP_WRITE, "  for(Counter = 0;Counter<=(int)strlen(Filter);Counter++)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (Filter[Counter]=='|')"
      FPRINT FP_WRITE, "      Extension[Counter]=0;"
      FPRINT FP_WRITE, "    else"
      FPRINT FP_WRITE, "      Extension[Counter]=Filter[Counter];"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  CmDlgHook = SetWindowsHookEx(WH_CBT, (HOOKPROC)SBProc, (HINSTANCE)NULL, GetCurrentThreadId());"
      FPRINT FP_WRITE, "  OpenFileStruct.lStructSize = sizeof(OpenFileStruct);"
      FPRINT FP_WRITE, "  OpenFileStruct.hwndOwner = hWnd;"
      FPRINT FP_WRITE, "  OpenFileStruct.hInstance = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpstrFilter = Extension;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpstrTitle = Title;"
      FPRINT FP_WRITE, "  OpenFileStruct.nMaxFile = BufSize;"
      FPRINT FP_WRITE, "  OpenFileStruct.nMaxFileTitle = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpstrFile = filename;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpstrFileTitle = NULL;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpstrCustomFilter = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.nMaxCustFilter = 0;"
      FPRINT FP_WRITE, "  if (ExtIdx) OpenFileStruct.nFilterIndex=*ExtIdx;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpstrInitialDir = InitDir;"
      FPRINT FP_WRITE, "  OpenFileStruct.nFileOffset = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.nFileExtension = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpstrDefExt = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.lCustData = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpfnHook = 0;"
      FPRINT FP_WRITE, "  OpenFileStruct.lpTemplateName = 0;"
      FPRINT FP_WRITE, "  if (!Flags)"
      FPRINT FP_WRITE, "    OpenFileStruct.Flags = OFN_HIDEREADONLY | OFN_CREATEPROMPT | OFN_EXPLORER;"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    OpenFileStruct.Flags = Flags | OFN_EXPLORER;"
      FPRINT FP_WRITE, "  if (!Flag)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (GetOpenFileName(&OpenFileStruct)==0)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      *filename = 0;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      int len = (int)strlen(filename);"
      FPRINT FP_WRITE, "      if (filename[len+1]==0) return filename;"
      FPRINT FP_WRITE, "      char *fname = filename+len;"
      FPRINT FP_WRITE, "      while(fname[1])"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        *fname =  ',';"
      FPRINT FP_WRITE, "        len = (int)strlen(++fname);"
      FPRINT FP_WRITE, "        fname+=len;"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (GetSaveFileName(&OpenFileStruct)==0) *filename = 0;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (ExtIdx) *ExtIdx = OpenFileStruct.nFilterIndex;"
      FPRINT FP_WRITE, "  return filename;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_AppExePath THEN
      FPRINT FP_WRITE, "char *AppExePath (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  int ii;"
      FPRINT FP_WRITE, "  ii = GetModuleFileName(GetModuleHandle(0), strtmp, BCXSTRSIZE);"
      FPRINT FP_WRITE, "  while(ii && strtmp[ii] != 0x5C)"
      FPRINT FP_WRITE, "    ii--;"
      FPRINT FP_WRITE, "  strtmp[ii+1] = 0;"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_AppExeName THEN
      FPRINT FP_WRITE, "char *AppExeName (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  int ii;"
      FPRINT FP_WRITE, "  ii = GetModuleFileName (GetModuleHandle(NULL), strtmp, BCXSTRSIZE);"
      FPRINT FP_WRITE, "  while(ii && strtmp[ii] != 0x5C)"
      FPRINT FP_WRITE, "    ii--;"
      FPRINT FP_WRITE, "  return &strtmp[ii+1];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_TempFileName THEN
      FPRINT FP_WRITE, "char *TempFileName (LPCTSTR szFolder, LPCTSTR szPrefix)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  GetTempFileName(szFolder, szPrefix, 0, strtmp);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Boolstr THEN
      FPRINT FP_WRITE, "char * BoolStr (int a)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(5);"
      FPRINT FP_WRITE, "  if (a) return strcpy(BCX_RetStr, ", ENC$("True"), ");"
      FPRINT FP_WRITE, "  return strcpy(BCX_RetStr, ", ENC$("False"), ");"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Using THEN
      FPRINT FP_WRITE, "char *Using (LPCTSTR szMask, long double Num)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int Spaces = 0;"
      FPRINT FP_WRITE, "  int CntDec = 0;"
      FPRINT FP_WRITE, "  int Decimals = 0;"
      FPRINT FP_WRITE, "  int Dollar = 0;"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(256);"
      FPRINT FP_WRITE, "  char  Buf_1 [256] = {0};"
      FPRINT FP_WRITE, "  LPCTSTR p = szMask;"
      FPRINT FP_WRITE, "  char *cp_r;"
      FPRINT FP_WRITE, "  int  len;"
      FPRINT FP_WRITE, "  while (*p)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*p == 36) Dollar++;"
      FPRINT FP_WRITE, "    if (*p == 32) Spaces++;"
      FPRINT FP_WRITE, "    if ((*p == 32 || *p == 35) && CntDec) Decimals++;"
      FPRINT FP_WRITE, "    if (*p == 46) CntDec = 1;"
      FPRINT FP_WRITE, "    if (*p == 94) // ^ used for sci notation"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      char    Tmp[64]= {0};"
      FPRINT FP_WRITE, "      sprintf(Tmp,", ENC$("%.15E"), ",(double)Num);"
      FPRINT FP_WRITE, "      while(instr(Tmp,", ENC$("0E"), "))"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        strcpy(Tmp,replace(Tmp,", ENC$("0E"), ",", ENC$("E"), "));"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      while(instr(Tmp,", ENC$("E+00"), "))"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        strcpy(Tmp,replace(Tmp,", ENC$("E+00"), ",", ENC$("E+0"), "));"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      while(instr(Tmp,", ENC$("E-0"), "))"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        strcpy(Tmp,replace(Tmp,", ENC$("E-00"), ",", ENC$("E-0"), "));"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      strcpy(BCX_RetStr,Tmp);"
      FPRINT FP_WRITE, "      return BCX_RetStr;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    p++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  sprintf(Buf_1, ", ENC$("%1.*Lf"), ", Decimals, Num);"
      FPRINT FP_WRITE, "  len = (int)strlen(Buf_1)-Decimals-(Decimals > 0 ? 1 : 0);"
      FPRINT FP_WRITE, "  cp_r = BCX_RetStr+Dollar+Spaces;"
      FPRINT FP_WRITE, "  p = Buf_1;"
      FPRINT FP_WRITE, "  while (*p)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    *cp_r++ = *p++;"
      FPRINT FP_WRITE, "    if (--len > 2 && *(p-1) != '-' && len % 3 == 0)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      *cp_r++ = ',';"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (Dollar && Num >= 0) BCX_RetStr[Spaces]=36;"
      FPRINT FP_WRITE, "  if (Dollar && Num <  0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr[Spaces+1]=36;"
      FPRINT FP_WRITE, "    BCX_RetStr[Spaces]=45;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (Spaces) memset(BCX_RetStr, 32, Spaces);"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_SearchPath THEN
      FPRINT FP_WRITE, "char *SEARCHPATH (LPCTSTR szFile)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(MAX_PATH+1);"
      FPRINT FP_WRITE, "  LPSTR lpbs = 0;"
      FPRINT FP_WRITE, "  SearchPath(0, szFile, 0, MAX_PATH, BCX_RetStr, &lpbs);"
      FPRINT FP_WRITE, "  if (lpbs) *lpbs = 0;"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Bcx_stricmp THEN                                             ' Locale-specific version
      FPRINT FP_WRITE, "int bcx_stricmp (LPCTSTR szOne, LPCTSTR szTwo)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char  c1 [BCXSTRSIZE];"
      FPRINT FP_WRITE, "  char  c2 [BCXSTRSIZE];"
      FPRINT FP_WRITE, "  strcpy(c1,szOne);"
      FPRINT FP_WRITE, "  strcpy(c2,szTwo);"
      FPRINT FP_WRITE, "  CharUpperA(c1);"
      FPRINT FP_WRITE, "  CharUpperA(c2);"
      FPRINT FP_WRITE, "  int counter=0;"
      FPRINT FP_WRITE, "  for(;;)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if(c1[counter]^c2[counter])"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if(c1[counter]>c2[counter])"
      FPRINT FP_WRITE, "        return  1;"
      FPRINT FP_WRITE, "      return -1;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    if(!c1[counter]) return 0;"
      FPRINT FP_WRITE, "    counter++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Stristr THEN
      FPRINT FP_WRITE, "char *_stristr_(LPCTSTR Haystack, LPCTSTR Needle)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int mi=(-1);"
      FPRINT FP_WRITE, "  while(Needle[++mi])"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (Haystack[mi]==0) return 0;"
      FPRINT FP_WRITE, "    if (UprCase[(unsigned char)Haystack[mi]]!=UprCase[(unsigned char)Needle[mi]])"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      Haystack++;"
      FPRINT FP_WRITE, "      mi=(-1);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return (char*)Haystack;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_sziif THEN
      FPRINT FP_WRITE, "char *sziif (int cond, LPCTSTR szOne, LPCTSTR szTwo)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (cond!=0) return (char*)szOne;"
      FPRINT FP_WRITE, "  return (char*)szTwo;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Retain THEN
      FPRINT FP_WRITE, "char *Retain (LPCTSTR Text, LPCTSTR ValidChars)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(strlen(Text));"
      FPRINT FP_WRITE, "  char *temp = BCX_RetStr;"
      FPRINT FP_WRITE, "  while(*Text)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (strchr(ValidChars, *Text)) *(temp++) = *Text;"
      FPRINT FP_WRITE, "    Text++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_LoadFile THEN
      FPRINT FP_WRITE, "char* LoadFile (LPCTSTR lfName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  FILE* Channel;"
      FPRINT FP_WRITE, "  char* BCX_RetStr;"
      FPRINT FP_WRITE, "  if (Exist(lfName))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr = BCX_TmpStr(lof(lfName)+1);"
      FPRINT FP_WRITE, "    if ((Channel = fopen(lfName, ", ENC$("rb"), "))!=0)"
      FPRINT FP_WRITE, "    GET(Channel, BCX_RetStr, lof(lfName));"
      FPRINT FP_WRITE, "    fclose(Channel);"
      FPRINT FP_WRITE, "    Channel = NULL;"
      FPRINT FP_WRITE, "    return BCX_RetStr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr = BCX_TmpStr(64);"
      FPRINT FP_WRITE, "    return strcpy(BCX_RetStr,", ENC$("File Not Found"), ");"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_PeekStr THEN
      FPRINT FP_WRITE, "char *peekstr (PVOID Src, int Count)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *Des = BCX_TmpStr(Count);"
      FPRINT FP_WRITE, "  memmove(Des, Src, Count);"
      FPRINT FP_WRITE, "  return Des;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Inputbox THEN
      FPRINT FP_WRITE, "char *InputBox (LPCTSTR Title, LPCTSTR Prompt, LPCTSTR Value, int iHide)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr;"
      FPRINT FP_WRITE, "  CreatePrompter(Title, Prompt, Value, iHide);"
      FPRINT FP_WRITE, "  BCX_RetStr = BCX_TmpStr(strlen(BCX_INPUTBOX_VAL));"
      FPRINT FP_WRITE, "  return strcpy(BCX_RetStr, BCX_INPUTBOX_VAL);"
      FPRINT FP_WRITE, "}\n\n"
      FPRINT FP_WRITE, "LRESULT CreatePrompter (LPCTSTR Title, LPCTSTR Prpt, LPCTSTR Value, int iHide)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  LPDLGITEMTEMPLATE lpdit;"
      FPRINT FP_WRITE, "  LPDLGTEMPLATE lpdt;"
      FPRINT FP_WRITE, "  HINSTANCE hInst;"
      FPRINT FP_WRITE, "  HGLOBAL hgbl;"
      FPRINT FP_WRITE, "  LRESULT ret;"
      FPRINT FP_WRITE, "  LPWORD lpw;"
      FPRINT FP_WRITE, "  LPWSTR lpwsz;"
      FPRINT FP_WRITE, "  DWORD MyStyle;"
      FPRINT FP_WRITE, "  int ID_CANCEL = 101;"
      FPRINT FP_WRITE, "  int ID_TEXT   = 102;"
      FPRINT FP_WRITE, "  int ID_EDIT   = 103;"
      FPRINT FP_WRITE, "  int ID_OK     = 104;"
      FPRINT FP_WRITE, "  hgbl = GlobalAlloc(GMEM_ZEROINIT, 32767);"
      FPRINT FP_WRITE, "  lpdt = (LPDLGTEMPLATE)GlobalLock(hgbl);\n"
      FPRINT FP_WRITE, "  MyStyle = WS_VISIBLE|DS_NOFAILCREATE|WS_BORDER|DS_CENTER|DS_SETFONT;"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  //  Create the InputBox Window"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  lpdt->style = MyStyle;"
      FPRINT FP_WRITE, "  lpdt->cdit = 4;"
      FPRINT FP_WRITE, "  lpdt->cx = 160;"
      FPRINT FP_WRITE, "  lpdt->cy =  70;"
      FPRINT FP_WRITE, "  lpw = (LPWORD)(lpdt+1);"
      FPRINT FP_WRITE, "  *lpw++ = 0;"
      FPRINT FP_WRITE, "  *lpw++ = 0;"
      FPRINT FP_WRITE, "  lpwsz = (LPWSTR)lpw;"
      FPRINT FP_WRITE, "  lpw+=MultiByteToWideChar(CP_ACP, 0, Title, -1, lpwsz, 1+strlen(Title)*2);"
      FPRINT FP_WRITE, "  *lpw++ = DEFAULT_PITCH;"
      FPRINT FP_WRITE, "  lpwsz = (LPWSTR)lpw;"
      FPRINT FP_WRITE, "  lpw+=MultiByteToWideChar(CP_ACP, 0, ",  ENC$("MS Sans Serif") , ", -1, lpwsz, 27);"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  //  Create the CANCEL button."
      FPRINT FP_WRITE, "  // ********************************\n"
      FPRINT FP_WRITE, "  lpw   = lpwAlign(lpw);"
      FPRINT FP_WRITE, "  lpdit = (LPDLGITEMTEMPLATE)lpw;"
      FPRINT FP_WRITE, "  lpdit->x  = 95;"
      FPRINT FP_WRITE, "  lpdit->y  = 31;"
      FPRINT FP_WRITE, "  lpdit->cx = 35;"
      FPRINT FP_WRITE, "  lpdit->cy = 12;"
      FPRINT FP_WRITE, "  lpdit->id=(SHORT)ID_CANCEL;"
      FPRINT FP_WRITE, "  lpdit->style = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON|WS_TABSTOP;"
      FPRINT FP_WRITE, "  lpw = (LPWORD)(lpdit+1);"
      FPRINT FP_WRITE, "  *lpw++ = 0xFFFF;"
      FPRINT FP_WRITE, "  *lpw++ = 0x0080;"
      FPRINT FP_WRITE, "  lpwsz  = (LPWSTR)lpw;"
      FPRINT FP_WRITE, "  lpw+=MultiByteToWideChar(CP_ACP, 0, " , ENC$("CANCEL"), ", -1, lpwsz, 13);"
      FPRINT FP_WRITE, "  *lpw++ = 0;"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  //  Create the OK button."
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  lpw   = lpwAlign(lpw);"
      FPRINT FP_WRITE, "  lpdit = (LPDLGITEMTEMPLATE)lpw;"
      FPRINT FP_WRITE, "  lpdit->x = 20;"
      FPRINT FP_WRITE, "  lpdit->y = 31;"
      FPRINT FP_WRITE, "  lpdit->cx= 35;"
      FPRINT FP_WRITE, "  lpdit->cy= 12;"
      FPRINT FP_WRITE, "  lpdit->id=(SHORT)ID_OK;"
      FPRINT FP_WRITE, "  lpdit->style = WS_CHILD|WS_VISIBLE|BS_DEFPUSHBUTTON|WS_TABSTOP;"
      FPRINT FP_WRITE, "  lpw    = (LPWORD)(lpdit+1);"
      FPRINT FP_WRITE, "  *lpw++ = 0xFFFF;"
      FPRINT FP_WRITE, "  *lpw++ = 0x0080;"
      FPRINT FP_WRITE, "  lpwsz  = (LPWSTR)lpw;"
      FPRINT FP_WRITE, "  lpw+=MultiByteToWideChar(CP_ACP, 0, ",  ENC$("OK"),  ", -1, lpwsz, 5);"
      FPRINT FP_WRITE, "  *lpw++ = 0;"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  //  Create the STATIC control"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  lpw   = lpwAlign(lpw);"
      FPRINT FP_WRITE, "  lpdit = (LPDLGITEMTEMPLATE)lpw;"
      FPRINT FP_WRITE, "  lpdit->x  =  10;"
      FPRINT FP_WRITE, "  lpdit->y  =   5;"
      FPRINT FP_WRITE, "  lpdit->cx = 140;"
      FPRINT FP_WRITE, "  lpdit->cy =  10;"
      FPRINT FP_WRITE, "  lpdit->id=(SHORT)ID_TEXT;"
      FPRINT FP_WRITE, "  lpdit->style = WS_CHILD|WS_VISIBLE|SS_LEFT;"
      FPRINT FP_WRITE, "  lpw=(LPWORD)(lpdit+1);"
      FPRINT FP_WRITE, "  *lpw++ = 0xFFFF;"
      FPRINT FP_WRITE, "  *lpw++ = 0x0082;"
      FPRINT FP_WRITE, "  lpwsz  = (LPWSTR)lpw;"
      FPRINT FP_WRITE, "  lpw+=MultiByteToWideChar(CP_ACP, 0, Prpt, -1, lpwsz, 1+strlen(Prpt)*2);"
      FPRINT FP_WRITE, "  *lpw++ = 0;     // no creation data"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  //  Create the EDIT control"
      FPRINT FP_WRITE, "  // ********************************"
      FPRINT FP_WRITE, "  lpw   = (LPWORD)lpwAlign(lpw);"
      FPRINT FP_WRITE, "  lpdit = (LPDLGITEMTEMPLATE)lpw;"
      FPRINT FP_WRITE, "  lpdit->x  =  10;"
      FPRINT FP_WRITE, "  lpdit->y  =  15;"
      FPRINT FP_WRITE, "  lpdit->cx = 130;"
      FPRINT FP_WRITE, "  lpdit->cy =  12;"
      FPRINT FP_WRITE, "  lpdit->id=(SHORT)ID_EDIT;"
      FPRINT FP_WRITE, "  if (iHide==0)"
      FPRINT FP_WRITE, "    lpdit->style = WS_CHILD|WS_TABSTOP|WS_VISIBLE|ES_AUTOHSCROLL|WS_BORDER;"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    lpdit->style = ES_PASSWORD|WS_CHILD|WS_TABSTOP|WS_VISIBLE|ES_AUTOHSCROLL|WS_BORDER;"
      FPRINT FP_WRITE, "  lpw    = (LPWORD)(lpdit+1);"
      FPRINT FP_WRITE, "  *lpw++ = 0xFFFF;"
      FPRINT FP_WRITE, "  *lpw++ = 0x0081;"
      FPRINT FP_WRITE, "  lpwsz  = (LPWSTR)lpw;"
      FPRINT FP_WRITE, "  lpw+=MultiByteToWideChar(CP_ACP, 0, Value, -1, lpwsz, 1+strlen(Value)*2);"
      FPRINT FP_WRITE, "  *lpw++ = 0;"
      FPRINT FP_WRITE, "  // ******************"
      FPRINT FP_WRITE, "  GlobalUnlock(hgbl);"
      FPRINT FP_WRITE, "  hInst = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(0, GWLP_HINSTANCE);"
      FPRINT FP_WRITE, "  ret = DialogBoxIndirect (hInst, (LPDLGTEMPLATE)hgbl, GetActiveWindow(), (DLGPROC)Prompter);"
      FPRINT FP_WRITE, "  GlobalFree(hgbl);"
      FPRINT FP_WRITE, "  return ret;"
      FPRINT FP_WRITE, "}\n\n"
      FPRINT FP_WRITE, "LRESULT CALLBACK Prompter (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int ID_CANCEL = 101;"
      FPRINT FP_WRITE, "  int ID_EDIT   = 103;"
      FPRINT FP_WRITE, "  int ID_OK     = 104;\n"
      FPRINT FP_WRITE, "  for(;;)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (Msg==WM_INITDIALOG)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      SetFocus(GetDlgItem(hWnd, ID_EDIT));"
      FPRINT FP_WRITE, "      return 0;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    if (Msg==WM_COMMAND)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if (LOWORD(wParam)==ID_OK)"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        GetDlgItemText(hWnd, ID_EDIT, BCX_INPUTBOX_VAL, BCXSTRSIZE);"
      FPRINT FP_WRITE, "        EndDialog(hWnd, 0);"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      if (LOWORD(wParam)==ID_CANCEL)"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        *BCX_INPUTBOX_VAL=0;"
      FPRINT FP_WRITE, "        SendMessage(hWnd, WM_CLOSE, 0, 0);"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      break;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    if (Msg==WM_CLOSE)"
      FPRINT FP_WRITE, "      EndDialog(hWnd, 0);"
      FPRINT FP_WRITE, "    break;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_GetSpecialFolder THEN
      FPRINT FP_WRITE, "char *GetSpecialFolder (int nFolder, int bCreate, HWND hWnd)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(MAX_PATH);"
      FPRINT FP_WRITE, "  if (!SHGetSpecialFolderPath(hWnd, BCX_RetStr, nFolder, bCreate))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr[0]=0;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_GetSpecialFolderex THEN
      FPRINT FP_WRITE    ,"char *GetSpecialFolderEx(const GUID KFID, DWORD KFFlag)"
      FPRINT FP_WRITE    ,"{"
      FPRINT FP_WRITE    ,"  PCHAR BCX_RetStr;"
      FPRINT FP_WRITE    ,"  CHAR  szBuffer[2048];"
      FPRINT FP_WRITE    ,"  static PWSTR pwsBuffer;"
      FPRINT FP_WRITE    ,"  if (NULL == pwsBuffer)"
      FPRINT FP_WRITE    ,"    {"
      FPRINT FP_WRITE    ,"      pwsBuffer = (PWSTR)calloc(2048, sizeof(char)+1);"
      FPRINT FP_WRITE    ,"    }"
      FPRINT FP_WRITE    ,"  #ifndef __cplusplus"
      FPRINT FP_WRITE    ,"     int rc = SHGetKnownFolderPath(&KFID, KFFlag, 0, &pwsBuffer);"
      FPRINT FP_WRITE    ,"  #else"
      FPRINT FP_WRITE    ,"     int rc = SHGetKnownFolderPath(KFID, KFFlag, 0, &pwsBuffer);"
      FPRINT FP_WRITE    ,"  #endif"
      FPRINT FP_WRITE    ,"  if (S_OK == rc)"
      FPRINT FP_WRITE    ,"    {"
      FPRINT FP_WRITE    ,"      strcpy(szBuffer, WideToAnsi(pwsBuffer));"
      FPRINT FP_WRITE    ,"      BCX_RetStr = BCX_TmpStr(strlen(szBuffer));"
      FPRINT FP_WRITE    ,"      strcpy(BCX_RetStr, szBuffer);"
      FPRINT FP_WRITE    ,"      return BCX_RetStr;"
      FPRINT FP_WRITE    ,"    }"
      FPRINT FP_WRITE    ,"  BCX_RetStr = 0;"
      FPRINT FP_WRITE    ,"  return BCX_RetStr;"
      FPRINT FP_WRITE    ,"}\n\n"
   END IF



   IF Use_GetText THEN
      FPRINT FP_WRITE, "char *BCX_Get_Text (HWND hWnd)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int tmpint;"
      FPRINT FP_WRITE, "  tmpint = 1 + GetWindowTextLength(hWnd);"
      FPRINT FP_WRITE, "  char *strtmp = BCX_TmpStr(tmpint);"
      FPRINT FP_WRITE, "  GetWindowText(hWnd,strtmp,tmpint);"
      FPRINT FP_WRITE, "  return strtmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Bff THEN
      FPRINT FP_WRITE, "char *BFF(LPCTSTR Instructions,int BIF_Flags,LPCTSTR InitPath)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  CoInitialize(NULL);"
      FPRINT FP_WRITE, "  BROWSEINFO tBFF = {0,0,0,0,0,NULL,0,0};"
      FPRINT FP_WRITE, "  LPITEMIDLIST lpIDList = {0};"
      FPRINT FP_WRITE, "  tBFF.hwndOwner = GetActiveWindow();"
      FPRINT FP_WRITE, "  tBFF.lpszTitle = Instructions;"
      FPRINT FP_WRITE, "  tBFF.ulFlags = BIF_Flags;"
      FPRINT FP_WRITE, "  if (InitPath)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    tBFF.lpfn = BFFCallBack;"
      FPRINT FP_WRITE, "    tBFF.lParam = (LPARAM)InitPath;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  lpIDList = SHBrowseForFolder(&tBFF);"
      FPRINT FP_WRITE, "  if (lpIDList != NULL)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    SHGetPathFromIDList((LPITEMIDLIST)lpIDList,BCX_RetStr);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  CoTaskMemFree(lpIDList);"
      FPRINT FP_WRITE, "  CoUninitialize();"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
      FPRINT FP_WRITE, "int CALLBACK BFFCallBack (HWND hWnd, UINT Msg, LPARAM wParam, LPARAM lParam)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (Msg == BFFM_INITIALIZED)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (GetFileAttributes((char*)lParam) != 0xffffffff)"
      FPRINT FP_WRITE, "      SendMessage(hWnd,(UINT_PTR)BFFM_SETSELECTION,(WPARAM)TRUE,(LPARAM)(char*)lParam);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_BcxSplitPath THEN
      FPRINT FP_WRITE, "char *BcxSplitPath (LPCTSTR FPath, int mask)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (!FPath) return BCX_TmpStr(1);"
      FPRINT FP_WRITE, "  char *BCX_RetStr = BCX_TmpStr(strlen(FPath));"
      FPRINT FP_WRITE, "  char tmp[MAX_PATH*4];"
      FPRINT FP_WRITE, "  _splitpath(FPath,tmp,&tmp[MAX_PATH],&tmp[MAX_PATH*2],&tmp[MAX_PATH*3]);"
      FPRINT FP_WRITE, "  if (mask & FDRV) strcat(BCX_RetStr,tmp);"
      FPRINT FP_WRITE, "  if (mask & FPATH)strcat(BCX_RetStr,&tmp[MAX_PATH]);"
      FPRINT FP_WRITE, "  if (mask & FNAME)strcat(BCX_RetStr,&tmp[MAX_PATH*2]);"
      FPRINT FP_WRITE, "  if (mask & FEXT) strcat(BCX_RetStr,&tmp[MAX_PATH*3]);"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_BCX_Path THEN
      FPRINT FP_WRITE, "char *BcxPath (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RegPath=BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  strcpy(BCX_RegPath,RegString"
      FPRINT FP_WRITE, "         (HKEY_LOCAL_MACHINE,", ENC$("Software\\\\Bcx-32\\\\Bcx\\\\Settings"), ",", ENC$("Path"), "));"
      FPRINT FP_WRITE, "  if (BCX_RegPath[0]==0)"
      FPRINT FP_WRITE, "    strcpy(BCX_RegPath,RegString"
      FPRINT FP_WRITE, "           (HKEY_CURRENT_USER,", ENC$("Software\\\\Bcx-32\\\\Bcx\\\\Settings"), ",", ENC$("Path"), "));"
      FPRINT FP_WRITE, "  if (BCX_RegPath[0]==0)"
      FPRINT FP_WRITE, "    return strcpy(BCX_RegPath,", ENC$("Not Found"), ");"
      FPRINT FP_WRITE, "  return BCX_RegPath;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_LccPath THEN
      FPRINT FP_WRITE, "char *LccPath (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr= {0};"
      FPRINT FP_WRITE, "  static char LCC_Reg     [BCXSTRSIZE];"
      FPRINT FP_WRITE, "  static char LCC_RegPath [BCXSTRSIZE];"
      FPRINT FP_WRITE, "  strcpy(LCC_Reg,",ENC$("Software\\\\lcc\\\\lcclnk\\\\"), ");"
      FPRINT FP_WRITE, "  strcpy(LCC_RegPath,(char*)RegString(HKEY_LOCAL_MACHINE,LCC_Reg,", ENC$("libpath"), "));"
      FPRINT FP_WRITE, "  if (LCC_RegPath[0]==0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    strcpy(LCC_RegPath,(char*)RegString(HKEY_CURRENT_USER,LCC_Reg,", ENC$("libpath"), "));"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (strcmp(LCC_RegPath,", DDQ$, ")!=0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr=BCX_TmpStr(256);"
      FPRINT FP_WRITE, "    return strcpy(BCX_RetStr,(char*)left(LCC_RegPath,InstrRev(LCC_RegPath,", ENC$("\\\\"), ")));"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr=BCX_TmpStr(strlen(LCC_RegPath));"
      FPRINT FP_WRITE, "    return strcpy(BCX_RetStr,LCC_RegPath);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_PellesPath THEN
      FPRINT FP_WRITE, "char *PellesPath (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr= {0};"
      FPRINT FP_WRITE, "  static char Pelles_Reg     [BCXSTRSIZE];"
      FPRINT FP_WRITE, "  static char Pelles_RegPath [BCXSTRSIZE];"
      FPRINT FP_WRITE, "  strcpy(Pelles_Reg,", ENC$("Software\\\\Pelle Orinius\\\\PellesC\\\\Directories\\\\"), ");"
      FPRINT FP_WRITE, "  strcpy(Pelles_RegPath,(char*)RegString(HKEY_LOCAL_MACHINE,Pelles_Reg,", ENC$("PathDirs"), "));"
      FPRINT FP_WRITE, "  if (Pelles_RegPath[0]==0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    strcpy(Pelles_RegPath,(char*)RegString(HKEY_CURRENT_USER,Pelles_Reg,", ENC$("PathDirs"), "));"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (strcmp(Pelles_RegPath,", DDQ$, ")!=0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr=BCX_TmpStr(256);"
      FPRINT FP_WRITE, "    return strcpy(BCX_RetStr,(char*)left(Pelles_RegPath,InstrRev(Pelles_RegPath,", ENC$("\\\\"), ")));"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr=BCX_TmpStr(strlen(Pelles_RegPath));"
      FPRINT FP_WRITE, "    return strcpy(BCX_RetStr,Pelles_RegPath);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_RegString THEN
      FPRINT FP_WRITE, "char *RegString (HKEY hKey, LPCTSTR RegPath, LPCTSTR SubKey)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *Result = BCX_TmpStr (BCXSTRSIZE);"
      FPRINT FP_WRITE, "  int BufferLen = BCXSTRSIZE;"
      FPRINT FP_WRITE, "  if (!RegOpenKeyEx(hKey,RegPath,0,KEY_QUERY_VALUE,&hKey))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    RegQueryValueEx(hKey,SubKey,0,0,(LPBYTE)Result,(LPDWORD)&BufferLen);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  RegCloseKey(hKey);"
      FPRINT FP_WRITE, "  return Result;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_CreateRegString THEN
      FPRINT FP_WRITE, "void CreateRegString (HKEY HK, LPCTSTR Key, LPCTSTR VarName, LPCTSTR Value)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  HKEY  hKey;"
      FPRINT FP_WRITE, "  char  Buff[100]= {0};"
      FPRINT FP_WRITE, "  DWORD  Result;"
      FPRINT FP_WRITE, "  RegCreateKeyEx(HK,Key,0,Buff,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,0,&hKey,&Result);"
      FPRINT FP_WRITE, "  RegSetValueEx(hKey,VarName,0,REG_SZ,(LPBYTE)Value,(DWORD)strlen(Value)+1);"
      FPRINT FP_WRITE, "  RegCloseKey(hKey);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Strtoken THEN
      FPRINT FP_WRITE, "char *StrToken (LPCTSTR Source, LPCTSTR TokenChar, int n)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr = NULL;"
      FPRINT FP_WRITE, "  char *RetVal = NULL;"
      FPRINT FP_WRITE, "  LPCTSTR Copy = NULL;"
      FPRINT FP_WRITE, "  int   Posn = 0;"
      FPRINT FP_WRITE, "  int   Find = 0;"
      FPRINT FP_WRITE, "  int LenSrc = (int)strlen(Source);"
      FPRINT FP_WRITE, "  Copy = Source;"
      FPRINT FP_WRITE, "  if (tally(Source,TokenChar)==0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr=BCX_TmpStr(1);"
      FPRINT FP_WRITE, "    return BCX_RetStr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (n==1)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr = BCX_TmpStr(LenSrc);"
      FPRINT FP_WRITE, "    strcpy(BCX_RetStr,(char*)extract(Source,TokenChar));"
      FPRINT FP_WRITE, "    return BCX_RetStr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (n>tally(Source,TokenChar)+1)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    BCX_RetStr=BCX_TmpStr(1);"
      FPRINT FP_WRITE, "    return BCX_RetStr;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  while(*Copy)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*Copy==TokenChar[0]) Find++;"
      FPRINT FP_WRITE, "    if (Find==n) break;"
      FPRINT FP_WRITE, "    Copy++;"
      FPRINT FP_WRITE, "    Posn++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (n==tally(Source,TokenChar)+1)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    Posn=LenSrc;"
      FPRINT FP_WRITE, "    Copy=Source+Posn;"
      FPRINT FP_WRITE, "    while(*Copy && Source[Posn]!=TokenChar[0])"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      Posn--;"
      FPRINT FP_WRITE, "      Copy--;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  RetVal = (char*)calloc(LenSrc+1,sizeof(char));"
      FPRINT FP_WRITE, "  strcpy(RetVal,(char*)mid(Source,1,Posn));"
      FPRINT FP_WRITE, "  strcpy(RetVal,(char*)mid(RetVal,InstrRev(RetVal,TokenChar)));"
      FPRINT FP_WRITE, "  BCX_RetStr=BCX_TmpStr(LenSrc);"
      FPRINT FP_WRITE, "  strcpy(BCX_RetStr,(char*)RemoveStr(RetVal,(char*)TokenChar));"
      FPRINT FP_WRITE, "  if (RetVal)free(RetVal);"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_WideToAnsi THEN
      FPRINT FP_WRITE, "//<---UNICODE AWARE"
      FPRINT FP_WRITE, "char* WideToAnsi (BSTR WideStr, UINT CodePage, DWORD dwFlags)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr;"
      FPRINT FP_WRITE, "  UINT uLen;"
      FPRINT FP_WRITE, "  uLen = WideCharToMultiByte(CodePage, dwFlags, WideStr,-1,0,0,0,0);"
      FPRINT FP_WRITE, "  BCX_RetStr = (char*)BCX_TmpStr(uLen);"
      FPRINT FP_WRITE, "  WideCharToMultiByte(CodePage, dwFlags, WideStr, -1, BCX_RetStr,uLen,0,0);"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}"
      FPRINT FP_WRITE, "//>---UNICODE AWARE\n"
   END IF


   IF Use_Mki THEN
      FPRINT FP_WRITE, "char *MKI (short cvt)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static char temp[3];"
      FPRINT FP_WRITE, "  return (char*)memmove(temp,&cvt,2);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Mkl THEN
      FPRINT FP_WRITE, "char *MKL (int cvt)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static char temp[5];"
      FPRINT FP_WRITE, "  return (char*) memmove(temp,&cvt,4);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Mks THEN
      FPRINT FP_WRITE, "char *MKS (float cvt)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static char temp[5];"
      FPRINT FP_WRITE, "  return (char*) memmove(temp,&cvt,4);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Mkd THEN
      FPRINT FP_WRITE, "char *MKD (double cvt)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static char temp[9];"
      FPRINT FP_WRITE, "  return (char*) memmove(temp,&cvt,8);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Mkld THEN
      FPRINT FP_WRITE, "char *MKLD (long double cvt)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static char temp[11];"
      FPRINT FP_WRITE, "  return (char*) memmove(temp,&cvt,10);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Cvi THEN
      FPRINT FP_WRITE, "short CVI (LPCTSTR s)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return ((short*)s)[0];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Cvl THEN
      FPRINT FP_WRITE, "long CVL (LPCTSTR s)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return ((long*)s)[0];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Cvs THEN
      FPRINT FP_WRITE, "float CVS (LPCTSTR s)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return ((float*)s)[0];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Cvd THEN
      FPRINT FP_WRITE, "double CVD (LPCTSTR s)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return ((double*)s)[0];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Cvld THEN
      FPRINT FP_WRITE, "long double CVLD (LPCTSTR s)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return ((long double*)s)[0];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Eof THEN
      FPRINT FP_WRITE, "int EoF (FILE* filstream)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int c, status = ((c = fgetc(filstream)) == EOF);"
      FPRINT FP_WRITE, "  ungetc(c, filstream);"
      FPRINT FP_WRITE, "  return status;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_NamePathFromFP = TRUE THEN
      FPRINT FP_WRITE, "char *NamePathFromFP (FILE *FP)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *BCX_RetStr= {0};"
      FPRINT FP_WRITE, "  char *szTmp= {0};"
      FPRINT FP_WRITE, "  szTmp = (char*)calloc(2048, 1);"
      FPRINT FP_WRITE, "  if(GetFinalPathNameByHandle((HANDLE)_get_osfhandle(_fileno(FP)),szTmp,2047,0))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    strcpy(szTmp, szTmp+4);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  BCX_RetStr = BCX_TmpStr(strlen(szTmp));"
      FPRINT FP_WRITE, "  strcpy(BCX_RetStr,szTmp);"
      FPRINT FP_WRITE, "  if (szTmp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    free(szTmp);"
      FPRINT FP_WRITE, "    szTmp = NULL;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return BCX_RetStr;"
      FPRINT FP_WRITE, "}"
   END IF


   IF Use_Longestline THEN
      FPRINT FP_WRITE, "UINT LongestLine(LPCTSTR FName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  UINT Longest = 0;"
      FPRINT FP_WRITE, "  int Counter = 0;"
      FPRINT FP_WRITE, "  BYTE OneByte[1] = {0};"
      FPRINT FP_WRITE, "  FILE *FP = NULL;"
      FPRINT FP_WRITE, "  if (0xffffffff == GetFileAttributes(FName))"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  FP = fopen(FName, ", ENC$("r"), ");"
      FPRINT FP_WRITE, "  if (FP == 0)   return 0;"
      FPRINT FP_WRITE, "  while (!EoF(FP))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    *OneByte = 0;"
      FPRINT FP_WRITE, "    Counter = 0;"
      FPRINT FP_WRITE, "    while (*OneByte != 10)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      fread(OneByte, 1, 1, FP);"
      FPRINT FP_WRITE, "      Counter++;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    Counter--;"
      FPRINT FP_WRITE, "    fseek(FP, -(Counter + 2), SEEK_CUR);"
      FPRINT FP_WRITE, "    if (Counter > Longest)"
      FPRINT FP_WRITE, "      Longest = Counter;"
      FPRINT FP_WRITE, "    fseek(FP, (Counter + 2), SEEK_CUR);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (FP)fclose(FP);"
      FPRINT FP_WRITE, "  return Longest;"
      FPRINT FP_WRITE, "}\n"
   END IF


   IF Use_Nextlinelen THEN
      FPRINT FP_WRITE, "UINT NextLineLen (FILE *FP)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int Counter=0;"
      FPRINT FP_WRITE, "  BYTE  OneByte[1]= {0};"
      FPRINT FP_WRITE, "  while(*OneByte!=10)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    fread (OneByte,1,1,FP);"
      FPRINT FP_WRITE, "    Counter++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  Counter--;"
      FPRINT FP_WRITE, "  fseek (FP,-(Counter+2),SEEK_CUR);"
      FPRINT FP_WRITE, "  return Counter;"
      FPRINT FP_WRITE, "}"
   END IF


   IF Use_AppActivate THEN
      FPRINT FP_WRITE, "int AppActivate (LPCTSTR Arg_Z)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int   CurThread;"
      FPRINT FP_WRITE, "  int   NewThread;"
      FPRINT FP_WRITE, "  int   Rc;"
      FPRINT FP_WRITE, "  int   ArgLen;"
      FPRINT FP_WRITE, "  char  Buffer[BCXSTRSIZE];"
      FPRINT FP_WRITE, "  HWND  hWnd;"
      FPRINT FP_WRITE, "  *Buffer = 0;"
      FPRINT FP_WRITE, "  ArgLen  = (int)strlen(Arg_Z);"
      FPRINT FP_WRITE, "  CurThread = GetCurrentThreadId();"
      FPRINT FP_WRITE, "  hWnd = GetForegroundWindow();"
      FPRINT FP_WRITE, "  for(Rc=0; Rc<=1000; Rc++)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    hWnd = GetNextWindow(hWnd, GW_HWNDNEXT);"
      FPRINT FP_WRITE, "    GetWindowText(hWnd, Buffer, 256);"
      FPRINT FP_WRITE, "    if (instr(left(lcase(Buffer), ArgLen), lcase(Arg_Z))) break;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (Rc==1001) return 0;"
      FPRINT FP_WRITE, "  NewThread = GetWindowThreadProcessId(hWnd, NULL);"
      FPRINT FP_WRITE, "  AttachThreadInput(CurThread, NewThread, TRUE);"
      FPRINT FP_WRITE, "  SetActiveWindow(hWnd);"
      FPRINT FP_WRITE, "  return TRUE;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Cint THEN
      FPRINT FP_WRITE, "int Cint (double Arg_A)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return (Arg_A >= 0 ? (int)(Arg_A + 0.5) : (int)(Arg_A - 0.5));"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Clng THEN
      FPRINT FP_WRITE, "long CLNG (double Arg_A)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  float   r = 0.5f;"
      FPRINT FP_WRITE, "  double  a = Arg_A-(long)Arg_A;"
      FPRINT FP_WRITE, "  if (Arg_A < 0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    r = -0.5;"
      FPRINT FP_WRITE, "    a = -a;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if (((long)Arg_A % 2) == 0 && a<= 0.5)"
      FPRINT FP_WRITE, "    return (long)Arg_A;"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    return (long)(Arg_A+r);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Isfolder THEN
      FPRINT FP_WRITE, "int isfolder (LPCTSTR FName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static HANDLE FileHandle;"
      FPRINT FP_WRITE, "  static WIN32_FIND_DATA Local_FindData;"
      FPRINT FP_WRITE, "  char Tmp[32767] = {0}; // Max path per MS"
      FPRINT FP_WRITE, "  if (FileHandle)"
      FPRINT FP_WRITE, "    FindClose(FileHandle);"
      FPRINT FP_WRITE, "  FileHandle = FindFirstFile(FName, &Local_FindData);"
      FPRINT FP_WRITE, "  if (FileHandle != INVALID_HANDLE_VALUE)"
      FPRINT FP_WRITE, "    strcpy(Tmp, Local_FindData.cFileName);"
      FPRINT FP_WRITE, "  if (0 != *Tmp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (GetFileAttributes(Tmp) & FILE_ATTRIBUTE_DIRECTORY)"
      FPRINT FP_WRITE, "      return TRUE;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return FALSE;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Isfile THEN
      FPRINT FP_WRITE, "int isfile (LPCTSTR FName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static HANDLE Local_FileHandle;"
      FPRINT FP_WRITE, "  static WIN32_FIND_DATA Local_FindData;"
      FPRINT FP_WRITE, "  char Tmp[32767] = {0}; // Max path per MS"
      FPRINT FP_WRITE, "  if (Local_FileHandle)"
      FPRINT FP_WRITE, "    FindClose(Local_FileHandle);"
      FPRINT FP_WRITE, "  Local_FileHandle = FindFirstFile(FName, &Local_FindData);"
      FPRINT FP_WRITE, "  if (Local_FileHandle != INVALID_HANDLE_VALUE)"
      FPRINT FP_WRITE, "    strcpy(Tmp, Local_FindData.cFileName);"
      FPRINT FP_WRITE, "  if (0 != *Tmp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (!(GetFileAttributes(Tmp) & FILE_ATTRIBUTE_DIRECTORY))"
      FPRINT FP_WRITE, "      return TRUE;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return FALSE;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Ishidden THEN
      FPRINT FP_WRITE, "int ishidden (LPCTSTR FName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static HANDLE Local_FileHandle;"
      FPRINT FP_WRITE, "  static WIN32_FIND_DATA Local_FindData;"
      FPRINT FP_WRITE, "  char Tmp[32767] = {0}; // Max path per MS"
      FPRINT FP_WRITE, "  if (Local_FileHandle)"
      FPRINT FP_WRITE, "    FindClose(Local_FileHandle);"
      FPRINT FP_WRITE, "  Local_FileHandle = FindFirstFile(FName, &Local_FindData);"
      FPRINT FP_WRITE, "  if (Local_FileHandle != INVALID_HANDLE_VALUE)"
      FPRINT FP_WRITE, "    strcpy(Tmp, Local_FindData.cFileName);"
      FPRINT FP_WRITE, "  if (0 != *Tmp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (GetFileAttributes(Tmp) & FILE_ATTRIBUTE_HIDDEN)"
      FPRINT FP_WRITE, "      return TRUE;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return FALSE;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Isreadonly THEN
      FPRINT FP_WRITE, "int isreadonly (LPCTSTR FName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static HANDLE Local_FileHandle;"
      FPRINT FP_WRITE, "  static WIN32_FIND_DATA Local_FindData;"
      FPRINT FP_WRITE, "  char Tmp[32767] = {0}; // Max path per MS"
      FPRINT FP_WRITE, "  if (Local_FileHandle)"
      FPRINT FP_WRITE, "    FindClose(Local_FileHandle);"
      FPRINT FP_WRITE, "  Local_FileHandle = FindFirstFile(FName, &Local_FindData);"
      FPRINT FP_WRITE, "  if (Local_FileHandle != INVALID_HANDLE_VALUE)"
      FPRINT FP_WRITE, "    strcpy(Tmp, Local_FindData.cFileName);"
      FPRINT FP_WRITE, "  if (0 != *Tmp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (GetFileAttributes(Tmp) & FILE_ATTRIBUTE_READONLY)"
      FPRINT FP_WRITE, "      return TRUE;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return FALSE;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Issystem THEN
      FPRINT FP_WRITE, "int issystem (LPCTSTR FName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static HANDLE Local_FileHandle;"
      FPRINT FP_WRITE, "  static WIN32_FIND_DATA Local_FindData;"
      FPRINT FP_WRITE, "  char Tmp[32767] = {0}; // Max path per MS"
      FPRINT FP_WRITE, "  if (Local_FileHandle)"
      FPRINT FP_WRITE, "    FindClose(Local_FileHandle);"
      FPRINT FP_WRITE, "  Local_FileHandle = FindFirstFile(FName, &Local_FindData);"
      FPRINT FP_WRITE, "  if (Local_FileHandle != INVALID_HANDLE_VALUE)"
      FPRINT FP_WRITE, "    strcpy(Tmp, Local_FindData.cFileName);"
      FPRINT FP_WRITE, "  if (0 != *Tmp)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (GetFileAttributes(Tmp) & FILE_ATTRIBUTE_SYSTEM)"
      FPRINT FP_WRITE, "      return TRUE;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return FALSE;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Pause THEN
      FPRINT FP_WRITE, "void Pause(void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  printf(", ENC$("\\n%s\\n"),  ",", ENC$("Press any key to continue . . ."), ");"
      FPRINT FP_WRITE, "  _getch();"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Clip_Gettextsize THEN
      FPRINT FP_WRITE, "int Clipboard_GetTextSize(void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  DWORD flag  = OpenClipboard(0);"
      FPRINT FP_WRITE, "  HANDLE txt  = GetClipboardData(CF_TEXT);"
      FPRINT FP_WRITE, "  DWORD cblen = GlobalSize(txt);"
      FPRINT FP_WRITE, "  if (flag)     CloseClipboard();"
      FPRINT FP_WRITE, "  if (0==txt)   return 0;"
      FPRINT FP_WRITE, "  return cblen;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Clip_Settext THEN
      FPRINT FP_WRITE, "void Clipboard_SetText (LPCTSTR Txt)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  HANDLE     hGlobMem= {0};"
      FPRINT FP_WRITE, "  HANDLE     pGlobMem= {0};"
      FPRINT FP_WRITE, "  hGlobMem = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE,1+lstrlen(Txt)*sizeof(TCHAR));"
      FPRINT FP_WRITE, "  pGlobMem = GlobalLock(hGlobMem);"
      FPRINT FP_WRITE, "  memmove (pGlobMem,Txt,lstrlen(Txt));"
      FPRINT FP_WRITE, "  GlobalUnlock (hGlobMem);"
      FPRINT FP_WRITE, "  if (!OpenClipboard(NULL))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    GlobalFree(hGlobMem);"
      FPRINT FP_WRITE, "    return;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  EmptyClipboard();"
      FPRINT FP_WRITE, "  SetClipboardData(CF_TEXT,hGlobMem);"
      FPRINT FP_WRITE, "  CloseClipboard();"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Clip_Setbitmap THEN
      FPRINT FP_WRITE, "void Clipboard_SetBitmap (HBITMAP hBmp)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if((hBmp==NULL))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    MessageBox (GetActiveWindow(),", ENC$("Cannot copy bitmap to clipboard"), ",", ENC$("Invalid bitmap"), ",0 );"
      FPRINT FP_WRITE, "    return;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  OpenClipboard(0);"
      FPRINT FP_WRITE, "  EmptyClipboard();"
      FPRINT FP_WRITE, "  SetClipboardData(CF_BITMAP,(HANDLE)hBmp);"
      FPRINT FP_WRITE, "  CloseClipboard();"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Clip_Getbitmap THEN
      FPRINT FP_WRITE, "HBITMAP Clipboard_GetBitmap (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static HBITMAP  hBmp;"
      FPRINT FP_WRITE, "  if(IsClipboardFormatAvailable(CF_BITMAP))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    OpenClipboard(0);"
      FPRINT FP_WRITE, "    hBmp = (HBITMAP)GetClipboardData(CF_BITMAP);"
      FPRINT FP_WRITE, "    CloseClipboard();"
      FPRINT FP_WRITE, "    if(hBmp==NULL )"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      MessageBox (GetActiveWindow(),", ENC$("Cannot retrieve bitmap from clipboard"), ",", ENC$("Invalid bitmap"), ",0 );"
      FPRINT FP_WRITE, "      return NULL;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return hBmp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Keypress THEN
      FPRINT FP_WRITE, "int keypress(void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int ch = 0;"
      FPRINT FP_WRITE, "  int ii = 0;"
      FPRINT FP_WRITE, "  INPUT_RECORD InputRecord;"
      FPRINT FP_WRITE, "  DWORD Count = 0, cks;"
      FPRINT FP_WRITE, "  WORD vkc, vsc;"
      FPRINT FP_WRITE, "  HANDLE hStdIn = GetStdHandle(STD_INPUT_HANDLE);"
      FPRINT FP_WRITE, "  DWORD OldConsoleMode;"
      FPRINT FP_WRITE, "  static char uchr[] ="
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    0x7E, 0x21, 0x40, 0x23, 0x24, 0x25, 0x5E,"
      FPRINT FP_WRITE, "    0x26, 0x2A, 0x28, 0x29, 0x5F, 0x2B, 0x7C,"
      FPRINT FP_WRITE, "    0x7B, 0x7D, 0x3A, 0x22, 0x3C, 0x3E, 0x3F,"
      FPRINT FP_WRITE, "    0x60, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,"
      FPRINT FP_WRITE, "    0x37, 0x38, 0x39, 0x30, 0x2D, 0x3D, 0x5C,"
      FPRINT FP_WRITE, "    0x5B, 0x5D, 0x3B, 0x27, 0x2C, 0x2E, 0x2F, 0x00"
      FPRINT FP_WRITE, "  };"
      FPRINT FP_WRITE, "  static char lchr[] ="
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    0x60, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,"
      FPRINT FP_WRITE, "    0x37, 0x38, 0x39, 0x30, 0x2D, 0x3D, 0x5C,"
      FPRINT FP_WRITE, "    0x5B, 0x5D, 0x3B, 0x27, 0x2C, 0x2E, 0x2F,"
      FPRINT FP_WRITE, "    0x7E, 0x21, 0x40, 0x23, 0x24, 0x25, 0x5E,"
      FPRINT FP_WRITE, "    0x26, 0x2A, 0x28, 0x29, 0x5F, 0x2B, 0x7C,"
      FPRINT FP_WRITE, "    0x7B, 0x7D, 0x3A, 0x22, 0x3C, 0x3E, 0x3F, 0x00"
      FPRINT FP_WRITE, "  };"
      FPRINT FP_WRITE, "  PeekConsoleInput(hStdIn, &InputRecord, 1, &Count);"
      FPRINT FP_WRITE, "  GetConsoleMode(hStdIn, &OldConsoleMode);"
      FPRINT FP_WRITE, "  SetConsoleMode(hStdIn, 0);"
      FPRINT FP_WRITE, "  do"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    ReadConsoleInput(hStdIn, &InputRecord, 1, &Count);"
      FPRINT FP_WRITE, "    SetConsoleMode(hStdIn, OldConsoleMode);"
      FPRINT FP_WRITE, "    if (Count && InputRecord.EventType == KEY_EVENT && InputRecord.Event.KeyEvent.bKeyDown)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      vkc = InputRecord.Event.KeyEvent.wVirtualKeyCode;"
      FPRINT FP_WRITE, "      vsc = InputRecord.Event.KeyEvent.wVirtualScanCode;"
      FPRINT FP_WRITE, "      ch = InputRecord.Event.KeyEvent.uChar.AsciiChar;"
      FPRINT FP_WRITE, "      cks = InputRecord.Event.KeyEvent.dwControlKeyState;"
      FPRINT FP_WRITE, "      FlushConsoleInputBuffer(hStdIn);"
      FPRINT FP_WRITE, "      if ((!ch && vsc > 58))"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        if ((cks & 3))"
      FPRINT FP_WRITE, "          return (1000 + vsc) * (-1);"
      FPRINT FP_WRITE, "        if ((cks & 12))"
      FPRINT FP_WRITE, "          return (2000 + vsc) * (-1);"
      FPRINT FP_WRITE, "        return vsc * (-1);"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      if (ch && (cks & 3))"
      FPRINT FP_WRITE, "        return vkc + 1000;"
      FPRINT FP_WRITE, "      if ((vsc == 15) && (cks & 16))"
      FPRINT FP_WRITE, "        return 15;"
      FPRINT FP_WRITE, "      if (vkc == 27)"
      FPRINT FP_WRITE, "        return 27;"
      FPRINT FP_WRITE, "      if (ch && (cks & 128))"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        for (ii = 0; ii <= (int)strlen(lchr); ii++)"
      FPRINT FP_WRITE, "        {"
      FPRINT FP_WRITE, "          if (uchr[ii] == ch)"
      FPRINT FP_WRITE, "          {"
      FPRINT FP_WRITE, "            ch = lchr[ii];"
      FPRINT FP_WRITE, "            break;"
      FPRINT FP_WRITE, "          }"
      FPRINT FP_WRITE, "        }"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      if (ch)"
      FPRINT FP_WRITE, "        return ch;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  while (TRUE);"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_InkeyD THEN
      FPRINT FP_WRITE, "int inkeyd(void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int ch = 0;"
      FPRINT FP_WRITE, "  int ii = 0;"
      FPRINT FP_WRITE, "  INPUT_RECORD InputRecord;"
      FPRINT FP_WRITE, "  DWORD Count = 0, cks;"
      FPRINT FP_WRITE, "  WORD vkc, vsc;"
      FPRINT FP_WRITE, "  HANDLE hStdIn = GetStdHandle(STD_INPUT_HANDLE);"
      FPRINT FP_WRITE, "  DWORD OldConsoleMode;"
      FPRINT FP_WRITE, "  static char uchr[] ="
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    0x7E, 0x21, 0x40, 0x23, 0x24, 0x25, 0x5E,"
      FPRINT FP_WRITE, "    0x26, 0x2A, 0x28, 0x29, 0x5F, 0x2B, 0x7C,"
      FPRINT FP_WRITE, "    0x7B, 0x7D, 0x3A, 0x22, 0x3C, 0x3E, 0x3F,"
      FPRINT FP_WRITE, "    0x60, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,"
      FPRINT FP_WRITE, "    0x37, 0x38, 0x39, 0x30, 0x2D, 0x3D, 0x5C,"
      FPRINT FP_WRITE, "    0x5B, 0x5D, 0x3B, 0x27, 0x2C, 0x2E, 0x2F, 0x00"
      FPRINT FP_WRITE, "  };"
      FPRINT FP_WRITE, "  static char lchr[] ="
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    0x60, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,"
      FPRINT FP_WRITE, "    0x37, 0x38, 0x39, 0x30, 0x2D, 0x3D, 0x5C,"
      FPRINT FP_WRITE, "    0x5B, 0x5D, 0x3B, 0x27, 0x2C, 0x2E, 0x2F,"
      FPRINT FP_WRITE, "    0x7E, 0x21, 0x40, 0x23, 0x24, 0x25, 0x5E,"
      FPRINT FP_WRITE, "    0x26, 0x2A, 0x28, 0x29, 0x5F, 0x2B, 0x7C,"
      FPRINT FP_WRITE, "    0x7B, 0x7D, 0x3A, 0x22, 0x3C, 0x3E, 0x3F, 0x00"
      FPRINT FP_WRITE, "  };"
      FPRINT FP_WRITE, "  PeekConsoleInput(hStdIn, &InputRecord, 1, &Count);"
      FPRINT FP_WRITE, "  GetConsoleMode(hStdIn, &OldConsoleMode);"
      FPRINT FP_WRITE, "  SetConsoleMode(hStdIn, 0);"
      FPRINT FP_WRITE, "  ReadConsoleInput(hStdIn, &InputRecord, 1, &Count);"
      FPRINT FP_WRITE, "  SetConsoleMode(hStdIn, OldConsoleMode);"
      FPRINT FP_WRITE, "  if (Count && InputRecord.EventType == KEY_EVENT && InputRecord.Event.KeyEvent.bKeyDown)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    vkc = InputRecord.Event.KeyEvent.wVirtualKeyCode;"
      FPRINT FP_WRITE, "    vsc = InputRecord.Event.KeyEvent.wVirtualScanCode;"
      FPRINT FP_WRITE, "    ch = InputRecord.Event.KeyEvent.uChar.AsciiChar;"
      FPRINT FP_WRITE, "    cks = InputRecord.Event.KeyEvent.dwControlKeyState;"
      FPRINT FP_WRITE, "    FlushConsoleInputBuffer(hStdIn);"
      FPRINT FP_WRITE, "    if (!ch && vsc > 58)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if (cks & 3)"
      FPRINT FP_WRITE, "        return (1000 + vsc) * (-1);"
      FPRINT FP_WRITE, "      if (cks & 12)"
      FPRINT FP_WRITE, "        return (2000 + vsc) * (-1);"
      FPRINT FP_WRITE, "      return vsc * (-1);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    if (ch && (cks & 3))"
      FPRINT FP_WRITE, "      return vkc + 1000;"
      FPRINT FP_WRITE, "    if ((vsc == 15) && (cks & 16))"
      FPRINT FP_WRITE, "      return 15;"
      FPRINT FP_WRITE, "    if (vkc == 27)"
      FPRINT FP_WRITE, "      return 27;"
      FPRINT FP_WRITE, "    if (ch && (cks & 128))"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      for (ii = 0; ii <= (int)strlen(lchr); ii++)"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        if (uchr[ii] == ch)"
      FPRINT FP_WRITE, "        {"
      FPRINT FP_WRITE, "          ch = lchr[ii];"
      FPRINT FP_WRITE, "          break;"
      FPRINT FP_WRITE, "        }"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    if (ch)"
      FPRINT FP_WRITE, "      return ch;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Hook THEN
      FPRINT FP_WRITE, "LRESULT CALLBACK SBProc (int Msg, WPARAM wParam, LPARAM lParam)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (Msg==HCBT_ACTIVATE)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    static RECT  rc1;"
      FPRINT FP_WRITE, "    HMONITOR     hMonitor = {0};"
      FPRINT FP_WRITE, "    MONITORINFO  MonitorInfo = {0};"
      FPRINT FP_WRITE, "    int          Width = {0};"
      FPRINT FP_WRITE, "    int          Height = {0};"
      FPRINT FP_WRITE, "    GetWindowRect((HWND)wParam, &rc1);"
      FPRINT FP_WRITE, "    Width = rc1.right-rc1.left;"
      FPRINT FP_WRITE, "    Height = rc1.bottom-rc1.top;"
      FPRINT FP_WRITE, "    if(GetSystemMetrics(SM_CMONITORS) == 1)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      hMonitor = MonitorFromRect(&rc1,MONITOR_DEFAULTTOPRIMARY);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      hMonitor = MonitorFromRect(&rc1,MONITOR_DEFAULTTONEAREST);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    MonitorInfo.cbSize = sizeof(MONITORINFO);"
      FPRINT FP_WRITE, "    GetMonitorInfo(hMonitor, &MonitorInfo);"
      FPRINT FP_WRITE, "    rc1.left = MonitorInfo.rcWork.left+((MonitorInfo.rcWork.right-MonitorInfo.rcWork.left-Width)/2);"
      FPRINT FP_WRITE, "    rc1.top = MonitorInfo.rcWork.top+((MonitorInfo.rcWork.bottom-MonitorInfo.rcWork.top-Height)/2);"
      FPRINT FP_WRITE, "    rc1.right = rc1.left+Width;"
      FPRINT FP_WRITE, "    rc1.bottom = rc1.top+Height;"
      FPRINT FP_WRITE, "    SetWindowPos((HWND)wParam, NULL, rc1.left, rc1.top, 0, 0, SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);"
      FPRINT FP_WRITE, "    UnhookWindowsHookEx(CmDlgHook);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Instr THEN
      FPRINT FP_WRITE, "int instr(LPCTSTR Haystack, LPCTSTR Needle, int offset, int sensflag)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  LPCTSTR s;"
      FPRINT FP_WRITE, "  if (!Haystack || !Needle || ! *Needle || offset > (int)strlen(Haystack)) return 0;"
      FPRINT FP_WRITE, "  if (sensflag)"
      FPRINT FP_WRITE, "    s = _stristr_(offset > 0 ? Haystack + offset-1 : Haystack, Needle);"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    s = strstr(offset > 0 ? Haystack + offset-1 : Haystack, Needle);"
      FPRINT FP_WRITE, "  return s ? (int)(s-Haystack)+1 : 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Instrrev THEN
      FPRINT FP_WRITE, "int InstrRev (LPCTSTR Haystack, LPCTSTR Needle, int offset, int sens)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int sl, pl, ox;"
      FPRINT FP_WRITE, "  int (*cmp)(LPCTSTR, LPCTSTR, size_t);"
      FPRINT FP_WRITE, "  if (!Haystack || !Needle)  return 0;"
      FPRINT FP_WRITE, "  sl  = (int)strlen(Haystack); pl  = (int)strlen(Needle);"
      FPRINT FP_WRITE, "  if (offset > sl || 0 == sl || 0 == pl || (ox = sl - pl) < 0)"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  if (offset <= 0)"
      FPRINT FP_WRITE, "    offset = ox ;"
      FPRINT FP_WRITE, "  else if (offset >= pl)"
      FPRINT FP_WRITE, "    offset = offset - pl ;"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  cmp = (sens ? _strnicmp : strncmp);"
      FPRINT FP_WRITE, "  do"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (cmp(Haystack + offset , Needle, pl) == 0)"
      FPRINT FP_WRITE, "      return offset+1;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  while (offset--);"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_LCaseTbl THEN
      FPRINT FP_WRITE, "unsigned char* MakeLCaseTbl (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static unsigned char tbl[257];"
      FPRINT FP_WRITE, "  int ii; for (ii = 0; ii < 256; ii++)"
      FPRINT FP_WRITE, "    tbl[ii] = (unsigned char) ii;"
      FPRINT FP_WRITE, "  tbl[0] = 1;"
      FPRINT FP_WRITE, "  tbl[256] = 0;"
      FPRINT FP_WRITE, "  CharLowerA((char *)tbl);"
      FPRINT FP_WRITE, "  tbl[0] = 0;"
      FPRINT FP_WRITE, "  return tbl;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_UCaseTbl THEN
      FPRINT FP_WRITE, "unsigned char* MakeUCaseTbl (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  static unsigned char tbl[257];"
      FPRINT FP_WRITE, "  int ii; for (ii = 0; ii < 256; ii++)"
      FPRINT FP_WRITE, "    tbl[ii] = (unsigned char) ii;"
      FPRINT FP_WRITE, "  tbl[0] = 1;"
      FPRINT FP_WRITE, "  tbl[256] = 0;"
      FPRINT FP_WRITE, "  CharUpperA((char *)tbl);"
      FPRINT FP_WRITE, "  tbl[0] = 0;"
      FPRINT FP_WRITE, "  return tbl;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Inchr THEN
      FPRINT FP_WRITE, "int inchr (LPCTSTR Haystack, LPCTSTR Needle)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  LPCTSTR Idx = Haystack;"
      FPRINT FP_WRITE, "  while(*Idx)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*Idx == *Needle) return (int)(Idx-Haystack)+1;"
      FPRINT FP_WRITE, "    Idx++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Asc THEN
      FPRINT FP_WRITE, "extern int asc (LPCTSTR z, int index)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return (unsigned char) z[index];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Sgn THEN
      FPRINT FP_WRITE, "double sgn (double a)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (a < 0) return -1;"
      FPRINT FP_WRITE, "  if (a > 0) return  1;"
      FPRINT FP_WRITE, "  return  0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Round THEN
      FPRINT FP_WRITE, "double Round (double n, int d)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return (floor((n)*pow(10.0f, (d))+0.5f)/pow(10.0f, (d)));"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Exist THEN
      FPRINT FP_WRITE, "BOOL Exist (LPCTSTR szFilePath)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (strchr(szFilePath, '*') || strchr(szFilePath, '?'))"
      FPRINT FP_WRITE, "  return Exist_A (szFilePath);"
      FPRINT FP_WRITE, "  return Exist_B (szFilePath);"
      FPRINT FP_WRITE, "}\n\n"

      FPRINT FP_WRITE, "BOOL Exist_A (LPCTSTR szFilePath)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  WIN32_FIND_DATA W32FindData;"
      FPRINT FP_WRITE, "  HANDLE rc;"
      FPRINT FP_WRITE, "  rc = FindFirstFile(szFilePath, &W32FindData);"
      FPRINT FP_WRITE, "  if (rc == INVALID_HANDLE_VALUE) return FALSE;"
      FPRINT FP_WRITE, "  FindClose(rc);"
      FPRINT FP_WRITE, "  return TRUE;"
      FPRINT FP_WRITE, "}\n\n"

      FPRINT FP_WRITE, "BOOL Exist_B (LPCTSTR szFilePath)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  DWORD ret;"
      FPRINT FP_WRITE, "  ret = GetFileAttributes(szFilePath);"
      FPRINT FP_WRITE, "  if (ret != 0xffffffff) return TRUE;"
      FPRINT FP_WRITE, "  return FALSE;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Diskfree THEN
      FPRINT FP_WRITE, "ULONGLONG DiskFree (LPCTSTR Drv)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  ULONGLONG  Capacity;"
      FPRINT FP_WRITE, "  ULONGLONG  TotalFree;"
      FPRINT FP_WRITE, "  GetDiskFreeSpaceExA(Drv, NULL, (PULARGE_INTEGER)&Capacity, (PULARGE_INTEGER)&TotalFree);"
      FPRINT FP_WRITE, "  return TotalFree;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Diskused THEN
      FPRINT FP_WRITE, "ULONGLONG DiskUsed (LPCTSTR Drv)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  ULONGLONG  Capacity;"
      FPRINT FP_WRITE, "  ULONGLONG  TotalFree;"
      FPRINT FP_WRITE, "  GetDiskFreeSpaceExA(Drv, NULL, (PULARGE_INTEGER)&Capacity, (PULARGE_INTEGER)&TotalFree);"
      FPRINT FP_WRITE, "  return Capacity-TotalFree;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Disksize THEN
      FPRINT FP_WRITE, "ULONGLONG DiskSize (LPCTSTR Drv)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  ULONGLONG  Capacity;"
      FPRINT FP_WRITE, "  ULONGLONG  TotalFree;"
      FPRINT FP_WRITE, "  GetDiskFreeSpaceExA(Drv, NULL, (PULARGE_INTEGER)&Capacity, (PULARGE_INTEGER)&TotalFree);"
      FPRINT FP_WRITE, "  return Capacity;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Tally THEN
      FPRINT FP_WRITE, "int tally (LPCTSTR Haystack, LPCTSTR Needle, int sensflag)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (!*Needle) return 0;"
      FPRINT FP_WRITE, "  if (!*Haystack) return 0;"
      FPRINT FP_WRITE, "  size_t mlen = strlen(Needle);"
      FPRINT FP_WRITE, "  int iCount = 0;"
      FPRINT FP_WRITE, "  LPCTSTR p = (0 == sensflag ? strstr(Haystack, Needle) : _stristr_(Haystack, Needle));"
      FPRINT FP_WRITE, "  while (p)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    iCount++;"
      FPRINT FP_WRITE, "    p+=mlen;"
      FPRINT FP_WRITE, "    p = (0 == sensflag ? strstr(p, Needle) : _stristr_(p, Needle));"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return iCount;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Timer THEN
      FPRINT FP_WRITE, "float timer (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return (GetTickCount() * 0.001f);"   ' Multiply executes faster than divide
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Rnd THEN
      FPRINT FP_WRITE, "float rnd (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return (float)rand()/RAND_MAX;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Rnd2 THEN
      FPRINT FP_WRITE, "int rnd2 (int _lower, int _upper)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return fmod(rand(),((_upper - _lower+1))) + _lower;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Exp THEN
      FPRINT FP_WRITE, "double Exp (double arg)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return pow(2.718281828459045, arg);"
      FPRINT FP_WRITE, "}\n\n"
   END IF



   IF Use_Randomize THEN
      FPRINT FP_WRITE, "void randomize (unsigned int seed)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  srand(seed);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Max THEN
      FPRINT FP_WRITE, "double MAX (double dbl_a, double dbl_b)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return  dbl_a > dbl_b ? dbl_a : dbl_b;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Min THEN
      FPRINT FP_WRITE, "double MIN (double dbl_a, double dbl_b)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return  dbl_a < dbl_b ? dbl_a : dbl_b;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Locate THEN
      FPRINT FP_WRITE, "void locate (int row, int col, int show, int shape)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  CONSOLE_CURSOR_INFO cci;"
      FPRINT FP_WRITE, "  memset (&cci, 0, sizeof(CONSOLE_CURSOR_INFO));"    ' MrBcx 789
      FPRINT FP_WRITE, "  cursor.X = (SHORT)col-1;"
      FPRINT FP_WRITE, "  cursor.Y = (SHORT)row-1;"
      FPRINT FP_WRITE, "  SetConsoleCursorPosition(hConsole, cursor);"
      FPRINT FP_WRITE, "  cci.bVisible = show;"
      FPRINT FP_WRITE, "  cci.dwSize   = shape;"
      FPRINT FP_WRITE, "  SetConsoleCursorInfo(hConsole, &cci);"
      FPRINT FP_WRITE, "}\n\n"
   END IF



   IF Use_Pos THEN
      FPRINT FP_WRITE, "int Pos (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  HANDLE  hStdOut;"
      FPRINT FP_WRITE, "  CONSOLE_SCREEN_BUFFER_INFO csbi;"
      FPRINT FP_WRITE, "  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));"  ' MrBcx 789
      FPRINT FP_WRITE, "  hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);"
      FPRINT FP_WRITE, "  GetConsoleScreenBufferInfo(hStdOut, &csbi);"
      FPRINT FP_WRITE, "  return csbi.dwCursorPosition.X+1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Csrlin THEN
      FPRINT FP_WRITE, "int Csrlin (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  HANDLE  hStdOut;"
      FPRINT FP_WRITE, "  CONSOLE_SCREEN_BUFFER_INFO csbi;"
      FPRINT FP_WRITE, "  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));"  ' MrBcx 789
      FPRINT FP_WRITE, "  hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);"
      FPRINT FP_WRITE, "  GetConsoleScreenBufferInfo(hStdOut, &csbi);"
      FPRINT FP_WRITE, "  return csbi.dwCursorPosition.Y+1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Cls THEN
      FPRINT FP_WRITE, "void cls (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  DWORD cCharsWritten;"
      FPRINT FP_WRITE, "  COORD coordScreen;"
      FPRINT FP_WRITE, "  CONSOLE_SCREEN_BUFFER_INFO csbi;"
      FPRINT FP_WRITE, "  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));"  ' MrBcx 789
      FPRINT FP_WRITE, "  memset (&coordScreen, 0, sizeof(COORD));"                ' MrBcx 789
      FPRINT FP_WRITE, "  DWORD dwConSize;"
      FPRINT FP_WRITE, "  WORD attr;"
      FPRINT FP_WRITE, "  cursor.X = 0;"
      FPRINT FP_WRITE, "  cursor.Y = 0;"
      FPRINT FP_WRITE, "  GetConsoleScreenBufferInfo(hConsole, &csbi);"
      FPRINT FP_WRITE, "  dwConSize = csbi.dwSize.X * csbi.dwSize.Y;"
      FPRINT FP_WRITE, "  FillConsoleOutputCharacter (hConsole, 32, dwConSize, coordScreen, &cCharsWritten);"
      FPRINT FP_WRITE, "  attr = (WORD)color_fg + (WORD)color_bg * 16;"
      FPRINT FP_WRITE, "  FillConsoleOutputAttribute (hConsole, attr, dwConSize, coordScreen, &cCharsWritten);"
      FPRINT FP_WRITE, "  locate(1, 1, 1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Color THEN
      FPRINT FP_WRITE, "void color(int fg, int bg)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (bg == (-1))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    SetConsoleTextAttribute(hConsole, (WORD)fg + (WORD)color_bg * 16);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    SetConsoleTextAttribute(hConsole, (WORD)fg + (WORD)bg * 16);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  color_fg = fg;"
      FPRINT FP_WRITE, "  if (bg!=(-1)) color_bg = bg;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_PushPopColors THEN
      FPRINT FP_WRITE, "void PushColors (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  CONSOLE_SCREEN_BUFFER_INFO csbi;"
      FPRINT FP_WRITE, "  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));"  ' MrBcx 789
      FPRINT FP_WRITE, "  if(0==GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &csbi))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    color_pshpop = 7;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    color_pshpop = csbi.wAttributes;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"

      FPRINT FP_WRITE, "void PopColors (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if(color_pshpop == 0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    color (7,0);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    SetConsoleTextAttribute (GetStdHandle (STD_OUTPUT_HANDLE),(WORD)color_pshpop);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Consolesize THEN
      FPRINT FP_WRITE, "void BCX_SetConsoleSize (int NewX,int NewY)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  COORD    Coords= {0};"
      FPRINT FP_WRITE, "  HANDLE   hconsole= {0};"
      FPRINT FP_WRITE, "  SMALL_RECT  ConsoleSize= {0};"
      FPRINT FP_WRITE, "  CONSOLE_SCREEN_BUFFER_INFO csbi;"
      FPRINT FP_WRITE, "  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));"  ' MrBcx 789
      FPRINT FP_WRITE, "  hconsole=GetStdHandle(STD_OUTPUT_HANDLE);"
      FPRINT FP_WRITE, "  GetConsoleScreenBufferInfo (hconsole, &csbi);"
      FPRINT FP_WRITE, "  if(csbi.dwSize.X>NewX )"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    Coords.X=csbi.dwSize.X;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    Coords.X=NewX;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  if(csbi.dwSize.Y>NewY )"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    Coords.Y=csbi.dwSize.Y;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    Coords.Y=NewY;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  ConsoleSize.Right=NewX-1;"
      FPRINT FP_WRITE, "  ConsoleSize.Bottom=NewY-1;"
      FPRINT FP_WRITE, "  SetConsoleScreenBufferSize (hconsole, Coords);"
      FPRINT FP_WRITE, "  SetConsoleWindowInfo (hconsole, TRUE, &ConsoleSize);"
      FPRINT FP_WRITE, "}\n\n"

      FPRINT FP_WRITE, "void BCX_PushConsoleSize (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  COORD    Coords= {0};"
      FPRINT FP_WRITE, "  HANDLE   hconsole= {0};"
      FPRINT FP_WRITE, "  CONSOLE_SCREEN_BUFFER_INFO  csbi= {0};"
      FPRINT FP_WRITE, "  SMALL_RECT  ConsoleSize= {0};"
      FPRINT FP_WRITE, "  hconsole=GetStdHandle(STD_OUTPUT_HANDLE);"
      FPRINT FP_WRITE, "  GetConsoleScreenBufferInfo (hconsole , &csbi);"
      FPRINT FP_WRITE, "  BcxSaveConX=1+csbi.srWindow.Right-csbi.srWindow.Left;"
      FPRINT FP_WRITE, "  BcxSaveConY=1+csbi.srWindow.Bottom-csbi.srWindow.Top;"
      FPRINT FP_WRITE, "}\n\n"

      FPRINT FP_WRITE, "void BCX_PopConsoleSize (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  BCX_SetConsoleSize (BcxSaveConX ,BcxSaveConY );"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Panel THEN
      FPRINT FP_WRITE, "void panel (int x1, int y1, int x2, int y2, int fg, int bg, int chr, int flg)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  DWORD ret;"
      FPRINT FP_WRITE, "  int attr = fg+bg*16, x, y;"
      FPRINT FP_WRITE, "  for(y = y1;y<=y2;y++)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    for(x = x1;x<=x2;x++)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      cursor.X = x - 1;"
      FPRINT FP_WRITE, "      cursor.Y = y - 1;"
      FPRINT FP_WRITE, "      if (flg) FillConsoleOutputCharacter(hConsole, chr,  1, cursor, &ret);"
      FPRINT FP_WRITE, "      FillConsoleOutputAttribute(hConsole, attr, 1, cursor, &ret);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Midstr THEN
      FPRINT FP_WRITE, "void midstr (char *szSrc, int st, int length, char *rep)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int srclen = (int)strlen(szSrc);"
      FPRINT FP_WRITE, "  if (st > srclen++ || st<1) return;"
      FPRINT FP_WRITE, "  int replen = (int)strlen(rep);"
      FPRINT FP_WRITE, "  if (replen < length || length==(-1)) length = replen;"
      FPRINT FP_WRITE, "  if ((st+length) > srclen) length = srclen-st;"
      FPRINT FP_WRITE, "  memcpy(&szSrc[st-1], rep, length);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Swap THEN
      FPRINT FP_WRITE, "void swap (byte* A_, byte* B_, int length)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  byte t;"
      FPRINT FP_WRITE, "  while(length--)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    t = *A_;"
      FPRINT FP_WRITE, "    *(A_++) = *B_;"
      FPRINT FP_WRITE, "    *(B_++) = t;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Like THEN
      FPRINT FP_WRITE, "int like (LPCTSTR Haystack, LPCTSTR Needle)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  while (*Needle)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*Needle == '#')"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if (! *Haystack) return false;"
      FPRINT FP_WRITE, "      if (! isdigit(*Haystack)) return false;"
      FPRINT FP_WRITE, "      ++Haystack;"
      FPRINT FP_WRITE, "      ++Needle;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else if (*Needle == '?')"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if (! *Haystack) return false;"
      FPRINT FP_WRITE, "      ++Haystack;"
      FPRINT FP_WRITE, "      ++Needle;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else if (*Needle == '*')"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if (like(Haystack, Needle + 1)) return true;"
      FPRINT FP_WRITE, "      if (*Haystack && like(Haystack + 1, Needle))"
      FPRINT FP_WRITE, "        return true;"
      FPRINT FP_WRITE, "      return false;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else if ((*Haystack++ | 32) != (*Needle++ | 32)) return false; // case-insensitive"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return !*Haystack && !*Needle;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Lof THEN
      FPRINT FP_WRITE, "unsigned long long int lof (LPCTSTR FName)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  WIN32_FILE_ATTRIBUTE_DATA fad;"
      FPRINT FP_WRITE, "  if (!GetFileAttributesEx(FName, GetFileExInfoStandard, &fad))"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  LARGE_INTEGER size;"
      FPRINT FP_WRITE, "  size.HighPart = fad.nFileSizeHigh;"
      FPRINT FP_WRITE, "  size.LowPart = fad.nFileSizeLow;"
      FPRINT FP_WRITE, "  return size.QuadPart;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Mkpath THEN
      FPRINT FP_WRITE, "void MkPath (LPCTSTR szPath_)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char Buf[64][BCXSTRSIZE]= {0};"
      FPRINT FP_WRITE, "  char Tmp[BCXSTRSIZE]= {0};"
      FPRINT FP_WRITE, "  int  Elements= {0};"
      FPRINT FP_WRITE, "  int  i;"
      FPRINT FP_WRITE, "  Elements = Split(Buf, szPath_, chr(92)) - 1;"
      FPRINT FP_WRITE, "  for(i = 0; i<=Elements; i+=1)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    strcpy(Tmp, join(3,Tmp,Buf[i],chr(92)));"
      FPRINT FP_WRITE, "    _mkdir (Tmp);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Screen THEN
      FPRINT FP_WRITE, "int Screen (int y, int x, int mode)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  HANDLE  hConsole_ = GetStdHandle(STD_OUTPUT_HANDLE);"
      FPRINT FP_WRITE, "  DWORD Slen;"
      FPRINT FP_WRITE, "  COORD Coord;"
      FPRINT FP_WRITE, "  WORD  Attr;"
      FPRINT FP_WRITE, "  char  Char[2];"
      FPRINT FP_WRITE, "  Coord.X = x-1;"
      FPRINT FP_WRITE, "  Coord.Y = y-1;"
      FPRINT FP_WRITE, "  ReadConsoleOutputCharacterA(hConsole_, Char, 1, Coord, &Slen);"
      FPRINT FP_WRITE, "  ReadConsoleOutputAttribute(hConsole_, &Attr, 1, Coord, &Slen);"
      FPRINT FP_WRITE, "  if (mode)"
      FPRINT FP_WRITE, "  return  Attr;"
      FPRINT FP_WRITE, "  return  Char[0];"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Iif THEN
      FPRINT FP_WRITE, "double iif (int cond, double tp, double fp)"    ' 766 Changed cond to int
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (cond!=0) return tp;"
      FPRINT FP_WRITE, "  return fp;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Doevents THEN
      FPRINT FP_WRITE, "void DoEvents (void)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  MSG Msg;"
      FPRINT FP_WRITE, "  while (PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE))"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    TranslateMessage(&Msg);"
      FPRINT FP_WRITE, "    DispatchMessage(&Msg);"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_DynamicA THEN
      FPRINT FP_WRITE, "void *CreateArr(void *dynavar, int elem_size, int update, int num_dims, size_t *args ) {"
      FPRINT FP_WRITE, "  size_t s, s1, s2;"
      FPRINT FP_WRITE, "  void **vp;"
      FPRINT FP_WRITE, "  size_t *marker;"
      FPRINT FP_WRITE, "  marker = args;"
      FPRINT FP_WRITE, "  s = *marker++;"
      FPRINT FP_WRITE, "  s2 = s + 2;"
      FPRINT FP_WRITE, "  if (num_dims == 1)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (update && dynavar)"
      FPRINT FP_WRITE, "      dynavar = realloc(dynavar, s2 * elem_size);"
      FPRINT FP_WRITE, "    else"
      FPRINT FP_WRITE, "      dynavar = calloc(s2, elem_size);"
      FPRINT FP_WRITE, "    return dynavar;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else if (update && dynavar)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    s1 = 0;"
      FPRINT FP_WRITE, "    vp = (void**)dynavar;"
      FPRINT FP_WRITE, "    while(*vp && s1 <= s)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      vp++;"
      FPRINT FP_WRITE, "      s1++;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    if (s1 > s)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      vp--;"
      FPRINT FP_WRITE, "      DestroyArr(vp, num_dims, 0);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    dynavar = realloc(dynavar, s2 * sizeof(int *));"
      FPRINT FP_WRITE, "    s1 = 0;"
      FPRINT FP_WRITE, "    vp = (void**)dynavar;"
      FPRINT FP_WRITE, "    while(*vp && s1 <= s)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      vp++;"
      FPRINT FP_WRITE, "      s1++;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    while(s1 < s2)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      *(((void **)vp)) = NULL;"
      FPRINT FP_WRITE, "      vp++;"
      FPRINT FP_WRITE, "      s1++;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  else"
      FPRINT FP_WRITE, "    dynavar = calloc(s2 * sizeof(int *), 1);"
      FPRINT FP_WRITE, "  vp = (void**)dynavar;"
      FPRINT FP_WRITE, "  if (--num_dims > 0)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    for(s1 = 0; s1 < s; s1++)"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      vp[s1] = CreateArr(vp[s1], elem_size, update, num_dims, marker);"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return dynavar;"
      FPRINT FP_WRITE, "}\n\n"

      FPRINT FP_WRITE, "void DestroyArr (void** dynavar,int num_dims, int top_free)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int ii = 0;"
      FPRINT FP_WRITE, "  static int s = 0;"
      FPRINT FP_WRITE, "  if (num_dims == 1)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    free(dynavar);"
      FPRINT FP_WRITE, "    dynavar = NULL;"
      FPRINT FP_WRITE, "    return;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  s++;"
      FPRINT FP_WRITE, "  num_dims--;"
      FPRINT FP_WRITE, "  while(dynavar[ii])"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    DestroyArr((void**)dynavar[ii], num_dims, top_free);"
      FPRINT FP_WRITE, "    if (num_dims > 1)"
      FPRINT FP_WRITE, "      free(dynavar[ii]);"
      FPRINT FP_WRITE, "    dynavar[ii++]=NULL;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  s--;"
      FPRINT FP_WRITE, "  if (0 == s && top_free)"
      FPRINT FP_WRITE, "    free(dynavar);"
      FPRINT FP_WRITE, "  dynavar = NULL;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Idxqsort THEN
      FPRINT FP_WRITE, "int IdxCompare (const void *one, const void *two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int *ptr1 = (int*)(one);"
      FPRINT FP_WRITE, "  int *ptr2 = (int*)(two);"
      FPRINT FP_WRITE, "  return bcx_stricmp (pppStr[Key][*ptr1], pppStr[Key][*ptr2]);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_IdxqsortSt THEN
      FPRINT FP_WRITE, "int IdxCompareSt (const void* one, const void* two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "#define compare1 cmp1+(StructSize * (*(UINT*)(one)))"
      FPRINT FP_WRITE, "#define compare2 cmp1+(StructSize * (*(UINT*)(two)))"

      FPRINT FP_WRITE, "  if (Key==0)"      'String
      FPRINT FP_WRITE, "    return  bcx_stricmp(compare1, compare2);"

      FPRINT FP_WRITE, "  if (Key==1)"      'INTEGER
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*(int*)(compare1) < *(int*)(compare2)) return -1;"
      FPRINT FP_WRITE, "    if (*(int*)(compare1) > *(int*)(compare2)) return 1;"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  }"

      FPRINT FP_WRITE, "  if (Key==2)"      'Double
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*(double*)(compare1) < *(double*)(compare2)) return -1;"
      FPRINT FP_WRITE, "    if (*(double*)(compare1) > *(double*)(compare2)) return 1;"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  }"

      FPRINT FP_WRITE, "  if (Key==3)"      'Unsigned integer
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*(UINT*)(compare1) < *(UINT*)(compare2)) return -1;"
      FPRINT FP_WRITE, "    if (*(UINT*)(compare1) > *(UINT*)(compare2)) return 1;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_PtrqsortSt THEN
      FPRINT FP_WRITE, "int PtrCompareSt (const void* one, const void* two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "#define pcompare1 ((char*)(one)+OffSet)"
      FPRINT FP_WRITE, "#define pcompare2 ((char*)(two)+OffSet)"

      FPRINT FP_WRITE, "  if (Key==0)"
      FPRINT FP_WRITE, "    return  bcx_stricmp(pcompare1, pcompare2);"

      FPRINT FP_WRITE, "  if (Key==1)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*(int*)(pcompare1) < *(int*)(pcompare2)) return -1;"
      FPRINT FP_WRITE, "    if (*(int*)(pcompare1) > *(int*)(pcompare2)) return 1;"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  }"

      FPRINT FP_WRITE, "  if (Key==2)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*(double*)(pcompare1) < *(double*)(pcompare2)) return -1;"
      FPRINT FP_WRITE, "    if (*(double*)(pcompare1) > *(double*)(pcompare2)) return 1;"
      FPRINT FP_WRITE, "    return 0;"
      FPRINT FP_WRITE, "  }"

      FPRINT FP_WRITE, "  if (Key==3)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (*(UINT*)(pcompare1) < *(UINT*)(pcompare2)) return -1;"
      FPRINT FP_WRITE, "    if (*(UINT*)(pcompare1) > *(UINT*)(pcompare2)) return 1;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Strqsortas THEN
      FPRINT FP_WRITE, "int StrCompareAs (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = (char*) arg1;"
      FPRINT FP_WRITE, "  char *v2 = (char*) arg2;"
      FPRINT FP_WRITE, "  return strcmp (v1, v2);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Strqsorta THEN
      FPRINT FP_WRITE, "int StrCompareA (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = (char*) arg1;"
      FPRINT FP_WRITE, "  char *v2 = (char*) arg2;"
      FPRINT FP_WRITE, "  return bcx_stricmp (v1,v2);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Strqsortds THEN
      FPRINT FP_WRITE, "int StrCompareDs (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = (char*) arg1;"
      FPRINT FP_WRITE, "  char *v2 = (char*) arg2;"
      FPRINT FP_WRITE, "  return strcmp (v2, v1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_Strqsortd THEN
      FPRINT FP_WRITE, "int StrCompareD (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = (char*) arg1;"
      FPRINT FP_WRITE, "  char *v2 = (char*) arg2;"
      FPRINT FP_WRITE, "  return bcx_stricmp (v2, v1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_DynStrqsortas THEN
      FPRINT FP_WRITE, "int DynStrCompareAs (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = *(char **) arg1;"
      FPRINT FP_WRITE, "  char *v2 = *(char **) arg2;"
      FPRINT FP_WRITE, "  return strcmp(v1, v2);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_DynStrqsorta THEN
      FPRINT FP_WRITE, "int DynStrCompareA (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = *(char **) arg1;"
      FPRINT FP_WRITE, "  char *v2 = *(char **) arg2;"
      FPRINT FP_WRITE, "  return bcx_stricmp(v1, v2);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_DynStrqsortds THEN
      FPRINT FP_WRITE, "int DynStrCompareDs (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = *(char **) arg1;"
      FPRINT FP_WRITE, "  char *v2 = *(char **) arg2;"
      FPRINT FP_WRITE, "  return strcmp(v2, v1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF

   IF Use_DynStrqsortd THEN
      FPRINT FP_WRITE, "int DynStrCompareD (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = *(char **) arg1;"
      FPRINT FP_WRITE, "  char *v2 = *(char **) arg2;"
      FPRINT FP_WRITE, "  return bcx_stricmp(v2, v1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_DynAlphaNumericA THEN
      FPRINT FP_WRITE, "int DynAlphaNumericA (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = *(char **) arg1;"
      FPRINT FP_WRITE, "  char *v2 = *(char **) arg2;"
      FPRINT FP_WRITE, "  return AlphaNumeric(v1, v2);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_DynAlphaNumericD THEN
      FPRINT FP_WRITE, "int DynAlphaNumericD (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *v1 = *(char **) arg1;"
      FPRINT FP_WRITE, "  char *v2 = *(char **) arg2;"
      FPRINT FP_WRITE, "  return AlphaNumeric(v2, v1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_AlphaNumericA THEN
      FPRINT FP_WRITE, "int AlphaNumericA (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return AlphaNumeric (arg1, arg2);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_AlphaNumericD THEN
      FPRINT FP_WRITE, "int AlphaNumericD (const void *arg1, const void *arg2)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  return AlphaNumeric (arg2, arg1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_AlphaNumeric THEN
      FPRINT FP_WRITE, "int AlphaNumeric(const void *s1p, const void *s2p)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  char *s1 = (char*)s1p;"
      FPRINT FP_WRITE, "  char *s2 = (char*)s2p;"
      FPRINT FP_WRITE, "  do"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    if (isdigit(s1[0]) && isdigit(s2[0]))"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      // Compare numbers as numbers"
      FPRINT FP_WRITE, "      int c1 = strspn(s1, ";ENC$("0123456789");");"
      FPRINT FP_WRITE, "      int c2 = strspn(s2, ";ENC$("0123456789");");"
      FPRINT FP_WRITE, "      if (c1 > c2)"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        return 1;"
      FPRINT FP_WRITE, "      }"
      FPRINT FP_WRITE, "      else if (c1 < c2)"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        return -1;"
      FPRINT FP_WRITE, "      };"
      FPRINT FP_WRITE, "      // the digit strings have equal length, so compare digit by digit"
      FPRINT FP_WRITE, "      while (c1--)"
      FPRINT FP_WRITE, "      {"
      FPRINT FP_WRITE, "        if (s1[0] > s2[0])"
      FPRINT FP_WRITE, "        {"
      FPRINT FP_WRITE, "          return 1;"
      FPRINT FP_WRITE, "        }"
      FPRINT FP_WRITE, "        else if (s1[0] < s2[0])"
      FPRINT FP_WRITE, "        {"
      FPRINT FP_WRITE, "          return -1;"
      FPRINT FP_WRITE, "        };"
      FPRINT FP_WRITE, "        s1++;"
      FPRINT FP_WRITE, "        s2++;"
      FPRINT FP_WRITE, "      };"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else if (s1[0] > s2[0])"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      return 1;"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    else if (s1[0] < s2[0])"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      return -1;"
      FPRINT FP_WRITE, "    };"
      FPRINT FP_WRITE, "    s1++;"
      FPRINT FP_WRITE, "    s2++;"
      FPRINT FP_WRITE, "  }"
      FPRINT FP_WRITE, "  while ((*s1!=0) || (*s2!=0));"
      FPRINT FP_WRITE, "  return 0;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Numqsortaint THEN
      FPRINT FP_WRITE, "int NumCompareAint (const void *one, const void *two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int *ptr1 = (int *)(one);"
      FPRINT FP_WRITE, "  int *ptr2 = (int *)(two);"
      FPRINT FP_WRITE, "  if (*ptr1 < *ptr2) return -1;"
      FPRINT FP_WRITE, "  else if (*ptr1 == *ptr2) return 0;"
      FPRINT FP_WRITE, "  else return 1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Numqsortdint THEN
      FPRINT FP_WRITE, "int NumCompareDint (const void *one, const void *two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  int *ptr1 = (int *)(one);"
      FPRINT FP_WRITE, "  int *ptr2 = (int *)(two);"
      FPRINT FP_WRITE, "  if (*ptr1 > *ptr2) return -1;"
      FPRINT FP_WRITE, "  else if (*ptr1 == *ptr2) return 0;"
      FPRINT FP_WRITE, "  else return 1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Numqsortafloat THEN
      FPRINT FP_WRITE, "int NumCompareAfloat (const void *one, const void *two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  float *ptr1 = (float *)(one);"
      FPRINT FP_WRITE, "  float *ptr2 = (float *)(two);"
      FPRINT FP_WRITE, "  if (*ptr1 < *ptr2) return -1;"
      FPRINT FP_WRITE, "  else if (*ptr1 == *ptr2) return 0;"
      FPRINT FP_WRITE, "  else return 1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Numqsortdfloat THEN
      FPRINT FP_WRITE, "int NumCompareDfloat (const void *one, const void *two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  float *ptr1 = (float *)(one);"
      FPRINT FP_WRITE, "  float *ptr2 = (float *)(two);"
      FPRINT FP_WRITE, "  if (*ptr1 > *ptr2) return -1;"
      FPRINT FP_WRITE, "  else if (*ptr1 == *ptr2) return 0;"
      FPRINT FP_WRITE, "  else return 1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Numqsortadouble THEN
      FPRINT FP_WRITE, "int NumCompareAdouble (const void *one, const void *two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  double *ptr1 = (double *)(one);"
      FPRINT FP_WRITE, "  double *ptr2 = (double *)(two);"
      FPRINT FP_WRITE, "  if (*ptr1 < *ptr2) return -1;"
      FPRINT FP_WRITE, "  else if (*ptr1 == *ptr2) return 0;"
      FPRINT FP_WRITE, "  else return 1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Numqsortddouble THEN
      FPRINT FP_WRITE, "int NumCompareDdouble (const void *one, const void *two)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  double *ptr1 = (double *)(one);"
      FPRINT FP_WRITE, "  double *ptr2 = (double *)(two);"
      FPRINT FP_WRITE, "  if (*ptr1 > *ptr2) return -1;"
      FPRINT FP_WRITE, "  else if (*ptr1 == *ptr2) return 0;"
      FPRINT FP_WRITE, "  else return 1;"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_FillArray THEN
      FPRINT FP_WRITE, "int fillarray(LPCTSTR input, int ArrayType, int MaxCnt, void *Array)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  if (MaxCnt < 1) return -1;"
      FPRINT FP_WRITE, "  int c = 0, cnt=(-1), cnt2;"
      FPRINT FP_WRITE, "  char A [BCXSTRSIZE];"
      FPRINT FP_WRITE, "  int    *intptr    = (int *)Array;"
      FPRINT FP_WRITE, "  float  *floatptr  = (float *)Array;"
      FPRINT FP_WRITE, "  double *doubleptr = (double *)Array;"
      FPRINT FP_WRITE, "  long double *ldoubleptr = (long double *)Array;"
      FPRINT FP_WRITE, "  for(;;)"
      FPRINT FP_WRITE, "  {"
      FPRINT FP_WRITE, "    cnt2 = 0;"
      FPRINT FP_WRITE, "    while(input[++cnt]!=',')"
      FPRINT FP_WRITE, "    {"
      FPRINT FP_WRITE, "      if (input[cnt]==0) break;"
      FPRINT FP_WRITE, "      A[cnt2++]=input[cnt];"
      FPRINT FP_WRITE, "    }"
      FPRINT FP_WRITE, "    A[cnt2]=0;"
      FPRINT FP_WRITE, "    if (cnt2==0||c==MaxCnt) break;"
      FPRINT FP_WRITE, "    if (ArrayType==2)"
      FPRINT FP_WRITE, "      intptr[c++] = atoi(A);"
      FPRINT FP_WRITE, "    else if (ArrayType==3)"
      FPRINT FP_WRITE, "      floatptr[c++] = atof(A);"
      FPRINT FP_WRITE, "    else if (ArrayType==4)"
      FPRINT FP_WRITE, "      doubleptr[c++] = atof(A);"
      FPRINT FP_WRITE, "    else if (ArrayType==5)"
      FPRINT FP_WRITE, "      ldoubleptr[c++] = atof(A);"
      FPRINT FP_WRITE, "    if (input[cnt]==0) break;"
      FPRINT FP_WRITE, "  } "
      FPRINT FP_WRITE, "  return (c-1);"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Loc THEN
      FPRINT FP_WRITE, "int loc(FILE *fp, int fplen)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  fpos_t t;"
      FPRINT FP_WRITE, "  fgetpos(fp, &t);"
      FPRINT FP_WRITE, "#if defined( __POCC__ )"
      FPRINT FP_WRITE, "  t.off %= fplen;"
      FPRINT FP_WRITE, "  return (int)t.off;"
      FPRINT FP_WRITE, "#else"
      FPRINT FP_WRITE, "  t %= fplen;"
      FPRINT FP_WRITE, "  return (int)t;"
      FPRINT FP_WRITE, "#endif"
      FPRINT FP_WRITE, "}\n\n"
   END IF


   IF Use_Rec THEN
      FPRINT FP_WRITE, "int rec(FILE *fp, int fplen)"
      FPRINT FP_WRITE, "{"
      FPRINT FP_WRITE, "  fpos_t t;"
      FPRINT FP_WRITE, "  fgetpos(fp, &t);"
      FPRINT FP_WRITE, "#if defined( __POCC__ )