  OPTION EXPLICIT
  OPTION DEFAULT NONE
  CPU 48
  
  CONST VER!=1.7
  
  'Using Catalex micro SDCard breakout board or Card Reader
  'on TFT display
  'If using TFT Display, use SPI2 version of Driver

  'PIC32MX170 28 Pin wiring
  'Pin 2  Chip Select can be any digital output pin
  '       SPI 1   SPI2
  'MOSI   Pin 3   Pin 24
  'MISO   Pin 14  Pin 6
  'SCLK   Pin 25  PIN 26
  '
  'PIC32MX170 44 Pin wiring
  'Pin 2  Chip Select can be any digital output pin
  '       SPI 1   SPI2
  'MOSI   Pin 20  Pin 11
  'MISO   Pin 41  Pin 23
  'SCLK   Pin 14  PIN 15
  
  PRINT "Test Harness for CFunction FAT32 FileSystem driver (c) Peter Carnegie 2015 Ver";Ver!
  PRINT "Simulates use of SDCard for Logging data"
  
  'Set Non-Zero to TRACE program
  DIM TRACE% = 0
  
  'Number of bytes to show in hex dumps
  CONST Length%=&H100
  
  'Useful loop variable
  DIM I%=0
  
  'Holds the address returned by Driver.Init
  DIM AddrOfRam%=0
  
  'We're using pin 2 for Chip Select
  CONST CSPin%=2
  
  'Used for holding filename
  'Use dd if=/dev/zero of=logfile.csv  bs=1M  count=10 to make a blank logfile
  DIM FileName$="/logfile.csv"
  
  'Used for byte I/O buffer
  DIM Buffer$=STRING$(255," ")
  
  'Offset in file of where to start Reading/Writing From/To
  DIM Offset%=0
  
  'Captures number of Bytes READ/WRITTEN
  DIM ByteCount%=0
  
  'Used to capture the return values from functions
  DIM Result%=-1
  
  'Used for calculating Number of Log Records
  DIM NumRecords%
  
  'Appended to each line in the file
  CONST CRLF$=CHR$(13)+CHR$(10)
  
  'Quote Character for CSV format
  CONST Quot$=CHR$(34)

  PRINT "CFunction Driver Version=";((File.Ver() * 1000) AND &HFFFFFC)/1000
  PRINT "Using SPI Port ";((File.Ver() * 1000) AND &H3)

  PRINT "Open the Driver"
  Result%=File.Driver.Open(CSPin%,AddrOfRam%)
  PError "Failed to OPEN the Driver. Please Power Cycle system",Result%,1

'  PRINT "Initialise the Driver"
'  Result%=File.Driver.Init(AddrOfRam%)
'  PError "Failed to Initialise DRIVER. Please Power Cycle system",Result%,1
'
'  PRINT "Initialise the disk"
'  Result%=File.Disk.Init(CSPin%)
'  PError "Failed to Initialise Disk. Please re-insert media and try again",Result%,1
'
'  PRINT "Mount the disk"
'  Result%=File.Mount.Disk()
'  PError "Failed to Mount Disk. Please re-insert media and try again",Result%,1
  
  'We want Automatic flush to disk after every write
  DIM Mode%=1
  
  PRINT "Open File ";FileName$
  Result%=File.Open(FileName$,Mode%)
  PError "Failed to Open file "+FileName$,Result%,1
  
  PRINT "Get Length of file ";FileName$
  Result%=File.Length(ByteCount%)
  PError "Failed to get length of "+FileName$,Result%,1
  PRINT "File ";FileName$;" is ";ByteCount%;" bytes in size"
  
  PRINT "Get Number of logging records already in file"
  Buffer$=STRING$(128," ")
  Offset%=0
  Result%=File.Seek(Offset%)
  PError "Failed to seek to position "+STR$(Offset%),Result%,0
  
  'Read the first 128 bytes
  Buffer$=STRING$(128," ")
  Result%=File.Read(Buffer$,ByteCount%)
  PError "Failed to Read file",Result%,0
  
  'Get number of existing log records
  IF INSTR(Buffer$,".0")>0 THEN
    NumRecords%=VAL(MID$(Buffer$,1,INSTR(Buffer$,".0")-1))
  ELSE
    NumRecords%=0
  ENDIF
  PRINT "Number of Existing Log Records :";NumRecords%
  
  'Update the number of records we've written out to disk
  'Increment the number of records because we're going to
  'append a new one
  NumRecords%=NumRecords%+1
  Buffer$=STR$(NumRecords%)+ ".0" +CRLF$
  
  'Now write it back out to disk
  Offset%=0
  Result%=File.Seek(Offset%)
  PError "Failed to seek to position "+STR$(Offset%),Result%,0
  
  PRINT "Write Updated Number of Records to disk"
  ByteCount%=0
  Result%=File.Write(Buffer$,ByteCount%)
  PError "Failed to write to file",Result%,0
  
'  PRINT "Flush data to secure it"
'  Result%=File.Flush()
'  PError "Flush to disk failed",Result%,0
  
  PRINT "Create Header entry if it doesn't exist"
  Offset%=512
  Result%=File.Seek(Offset%)
  PError "Failed to seek to position "+STR$(Offset%),Result%,0
  
  'Read the Header block
  Buffer$=STRING$(128," ")
  Result%=File.Read(Buffer$,ByteCount%)
  PError "Failed to Read file",Result%,0
  
  'Header exists ?
  IF INSTR(1,Buffer$,"Log File")<1 THEN
    
    PRINT "Creating File Header"
    
    Offset%=512
    PRINT "Seek to ";Offset%
    
    Result%=File.Seek(Offset%)
    PError "Failed to seek to position "+STR$(Offset%),Result%,0
    
    Buffer$="Log File Started at "+DATE$+" "+TIME$+CRLF$
    Result%=File.Write(Buffer$,ByteCount%)
    PError "Failed to write to file",Result%,0
    
'    Result%=File.Flush()
'    PError "Flush to disk failed",Result%,0
    
  ENDIF
  
  PRINT "Write a simulated Temperature entry to the Log file"
  Offset%=1024+(NumRecords% * 512)
  Result%=File.Seek(Offset%)
  PError "Failed to seek to position "+STR$(Offset%),Result%,0
  
  'Simulate temperature logging
  Buffer$=Quot$+DATE$+Quot$+","+Quot$+TIME$+Quot$+","+Quot$+STR$(20 + RND(1),2,2)+Quot$+CRLF$
  PRINT "Write New Log record out :";Buffer$;
  Result%=File.Write(Buffer$,ByteCount%)
  PError "Failed to write to file",Result%,0
  
'  PRINT "Flush log record to secure it"
'  Result%=File.Flush()
'  PError "Failed to Flush data to disk. Error Code:",Result%,0
  
  PRINT
  PRINT "Read and display our logging file"
  Buffer$=STRING$(128," ")
  Offset%=0
  Result%=File.Seek(Offset%)
  PError "Failed to seek to position "+STR$(Offset%),Result%,0
  
  'Get Number of Log records
  Buffer$=STRING$(128," ")
  Result%=File.Read(Buffer$,ByteCount%)
  PError "Failed to Read File ",Result%,0
  
  'Convert ascii decimal number to an Integer
  NumRecords%=VAL(MID$(Buffer$,1,INSTR(Buffer$,".0")-1))
  PRINT "Num Records   = ";STR$(NumRecords%)
  
  'Get Header
  Offset%=512
  Result%=File.Seek(Offset%)
  
  Buffer$=STRING$(128," ")
  Result%=File.Read(Buffer$,ByteCount%)
  PError "Failed to Read File ",Result%,0
  PRINT "Header        = ";Buffer$;
  
  'Seek to start of logging records
  Offset%=1024
  Result%=File.Seek(Offset%)
  PError "Failed to seek to position "+STR$(Offset%),Result%,0
  
  'Used to find position of chr$(0) in buffer$
  DIM Z%
  'Display each Log Record
  FOR I%=1 TO NumRecords%
    Offset%=1024 + I%*512
    Result%=File.Seek(Offset%)
    Buffer$=STRING$(128," ")
    Result%=File.Read(Buffer$,ByteCount%)
    PError "Failed to Read File ",Result%,0
    Z%=INSTR(1,Buffer$,CHR$(0))
    IF Z%>0 THEN
      PRINT "Record";STR$(I%,7);" = ";LEFT$(Buffer$,z%);
    ELSE
      PRINT "Record";STR$(I%,7);" = ";Buffer$;
    ENDIF
  NEXT I%
  PRINT
  
  PRINT "Dump 1st log record sector"
  'Seek to start of logging records
  Offset%=1024 + 512
  Result%=File.Seek(Offset%)
  PError "Failed to seek to position "+STR$(Offset%),Result%,0
  
  DIM MyBuf%(127)
  Result%=File.Read.Block(MyBuf%(),512)
  FOR I%=0 TO 127
    PRINT HEX$(MyBuf%(I%),16);"  ";
    IF (I%+1) MOD 4 = 0 THEN PRINT
  NEXT I%
  
  PRINT
  PRINT "Close File"
  Result%=File.Close()
  PError "Failed to Close File",Result%,0
  
  PRINT "Close Driver"
  Result%=File.Driver.Close()
  PError "Failed to Close Driver",Result%,0
  IF Result%<>0 THEN
    PRINT "Please issue CPU Restart command at MMBasic command prompt"
  ENDIF
  
END
  
'*************************************************
'
' Print Error Message if Code% is NON-Zero
' END if Hard% is NON-Zero
'
'
SUB PError(Msg$,Code%,Hard%)
  IF Code%=0 THEN EXIT SUB
  PRINT "Error : ";Msg$;". Error Code:";Code% AND &Hff
  IF Hard%<>0 THEN END
END SUB
  
SUB DoTrace(Msg$, Result%, Numbytes%)
END SUB
  
  
'***********************************************
'
' CUNCTION FAT Filesystem Driver
'
' (c) Copyright Peter Carnegie 2015
'
'   File.Driver.Init  Initialise the Driver
'   File.Driver.Open  Open the Driver, Init S/W, Init H/W, Mount disk
'   File.Driver.Close Close the Driver and release all resources
'   File.Disk.Init    Initialise the Disk Sub-System
'   File.Disk.Mount   Mount the disk into the filesystem
'   File.Open         Open File specifying Writing Mode
'   File.Close        Close File
'   File.Read         Read from File
'   File.Write        Write to File
'   File.Flush        Flush bytes to disk
'   File.Seek         Move READ/WRITE pointer to position
'   File.Ver          Return Driver Version
'   File.Length       Returns length of File in Bytes
'
'   The CFunction can of course be called directly from user code
'   These MMBasic wrapper functions just make things neater and tidier !
'
'
'***********************************************
  
  
'***********************************************
'
' Initialise the FAT FileSystem Device Driver
'
' Returns the address of the persistent driver memory
'
'
FUNCTION File.Driver.Init(Addr%) AS INTEGER
  
  'Get address of the CFunction Driver itself
  LOCAL AddrOfSDCard%=PEEK(CFUNADDR Driver.SDCard)
  
  LOCAL Result%=Driver.SDCard(0,AddrOfSDCard%,Addr%)
  
  File.Driver.Init=Result%
  
  IF TRACE%<>0 THEN
    PRINT "Persistent RAM starts at &H";HEX$(Addr%)
  ENDIF
  
  DoTrace("Initialise Driver")
  
END FUNCTION
  
  
'***********************************************
'
' Initialise the Disk
'
' Returns 0 if Successful
'
' CSPin% contains the pin to be used for Chip Select
'
'
FUNCTION File.Disk.Init(CSPin%) AS INTEGER
  
  LOCAL Result%=Driver.SDCard(1,CSPin%)
  File.Disk.Init=Result%
  
  DoTrace("Initialise Disk")
  
END FUNCTION
  
  
'***********************************************
'
' Mount the disk
'
' Returns 0 if succesful else non-zero
'
'
FUNCTION File.Mount.Disk() AS INTEGER
  
  LOCAL Result%=Driver.SDCard(2)
  File.Mount.Disk=Result%
  
  DoTrace("Mount Disk",Result%)
  
END FUNCTION
  
  
'***********************************************
' Driver Open
'
'   Initialises the Driver software framework
'   Initialises the driver h/w interface and sets up
'     the FAT32 filesystem
'   Mounts the disk into the filesystem
'
' File>Driver.Open may be called instead of calling the 
' individual driver calls if the disk is already 
' inserted into the SDCard holder
'
'
FUNCTION File.Driver.Open(CSPin%,Addr%) AS INTEGER

  'Get address of the CFunction Driver itself
  LOCAL AddrOfSDCard%=PEEK(CFUNADDR Driver.SDCard)
  
  LOCAL Result%=Driver.SDCard(11,AddrOfSDCard%,CSPin%,Addr%)
  File.Driver.Open=Result%
  
  DoTrace("Driver Open",Result%)
  
END FUNCTION
  
  
'***********************************************
'
' Open File
'
'   Path$ Name of file to be Opened
'   Mode% If set to 1, then automatically flush to disk
'         every File.Write
'
' Returns 0 if succesful else non-zero
'
'
FUNCTION File.Open(Path$, Mode%) AS INTEGER
  
  LOCAL Result%=Driver.SDCard(3,Path$,Mode%)
  File.Open=Result%
  
  DoTrace("Open File",Result%)
  
END FUNCTION
  
  
'***********************************************
'
' Read File - Sequential
'
' Returns 0 if succesful else non-zero
'   On Entry
'
'   On Exit
'     Buffer$ will contain the bytes read in from disk
'     NumBytes% will contain the number of bytes actually read
'     If NumBytes%=0 then End Of File has been reached
'
' Use File.Seek to position the write pointer
'
FUNCTION File.Read(Buffer$, NumBytes%) AS INTEGER
  
  LOCAL Result%=Driver.SDCard(4,Buffer$,NumBytes%)
  File.Read=Result%
  
  DoTrace("Read File",Result%)
  
END FUNCTION
  
  
'***********************************************
'
' Write File - Sequential
'
' Returns 0 if succesful else non-zero
'   On Entry
'     Buffer$ contains the bytes to be written
'
'   On Exit
'     NumBytes% will contain the number of bytes actually written
'
' Use File.Seek to position the write pointer
'
FUNCTION File.Write(Buffer$,NumBytes%) AS INTEGER
  
  NumBytes%=-1
  
  LOCAL Result%=Driver.SDCard(5,Buffer$,NumBytes%)
  File.Write=Result%
  
  DoTrace("Write File",Result%,NumBytes%)
  
END FUNCTION
  
  
'***********************************************
'
' Flush Data to disk
'
' Returns 0 if succesful else non-zero
'
'
FUNCTION File.Flush() AS INTEGER
  
  LOCAL Buffer$=""
  LOCAL Offset%=0
  LOCAL BytesWritten%=-1
  
  LOCAL Result%=Driver.SDCard(5,Buffer$,BytesWritten%)
  File.Flush=Result%
  
  DoTrace("Write File (Flush)",Result%,BytesWritten%)
  
END FUNCTION
  
  
'***********************************************
'
' Close File
'
' Returns 0 if succesful else non-zero
'   Flushes any unwritten bytes to the physical disk
'
'
FUNCTION File.Close() AS INTEGER
  
  LOCAL Result%=Driver.SDCard(6)
  File.Close=Result%
  
  DoTrace("Close File",Result%)
  
END FUNCTION
  
  
'***********************************************
'
' Drive Close
'
' Returns 0 if succesful else non-zero
'   Unconfigures SPI
'   Unconfigures CS pin
'   FREEs up persistent RAM
'
'
FUNCTION File.Driver.Close() AS INTEGER
  
  LOCAL Result%=0
  Result%=Driver.SDCard(7)
  File.Driver.Close=Result%
  
  DoTrace("Close Driver",Result%)
  
END FUNCTION
  
  
'***********************************************
'
' File Seek
'
' Returns 0 if succesful else non-zero
'   Moves Reading/Writing offset to Position%
'
'
FUNCTION File.Seek(Position%) AS INTEGER
  
  LOCAL Result%=Driver.SDCard(8,Position%)
  File.Seek=Result%
  
  DoTrace("File Seek ",Result%)
  
END FUNCTION
  
  
'***********************************************
'
' Driver Version
'
' Returns Driver Version as a FLOAT, eg 1.5
'
' The least significant digit indicates the SPI port in use
'
'
FUNCTION File.Ver() AS FLOAT
  
  LOCAL Result%=Driver.SDCard(9)
  File.Ver=Result% / 1000
  
END FUNCTION
  
  
'***********************************************
'
' Length of File
'
'   Returns Length of File in Length%
'   Returns 0 if OK, non-zero otherwise
'
'
FUNCTION File.Length(Length%) AS INTEGER
  
  LOCAL Result%=Driver.SDCard(10,Length%)
  File.Length=Result%
  
  DoTrace("File Length ",Result%)
  
END FUNCTION


'***********************************************
'
' Read NumBytes% bytes into an Integer Array
'
'   Returns 0 if OK, non-zero otherwise
'
'   
'
'
FUNCTION File.Read.Block(Buffer%(),NumBytes%) AS INTEGER
  
  'Declare a 128 byte block for file Read operations 
  LOCAL Buf$=STRING$(128,CHR$(0)) 
  
  'Returned by CFunction
  LOCAL NumBytesRead%
  
  'Declare temporary buffer to read in 512 bytes
  LOCAL SectorBuffer%(127)

  'Loop variables 
  LOCAL I%=0, J%=0, K%=0
  
  'CFunctions ALWAYS return a 64 bit result
  LOCAL Result%

  'Get 512 bytes from file into our local buffer
  FOR J%=0 TO 3
  
    'Go get 128 bytes 
    Result%=File.Read(Buf$,NumBytesRead%) 
    File.Read.Block=Result%
    
    IF Result%<>0 THEN EXIT FUNCTION
    'Check for EOF
    IF NumBytesRead%=0 THEN
      File.Read.Block=-1
      EXIT FUNCTION
    ENDIF

    'Copy 128 bytes from string into local 
    K%=1 
    FOR I%=(J% * 128) TO (J% * 128) + 127 
      POKE VAR SectorBuffer%(), I%, (ASC((MID$(Buf$,K%,1))))
      K%=K%+1
    NEXT I% 
    
  NEXT J%
  
  'Now copy results back to caller's buffer
  FOR I%=0 TO (NumBytes% >> 2)-1
    Buffer%(I%)=SectorBuffer%(I%)
  NEXT I%

  File.Read.Block=0
  
END FUNCTION
  

'******************************************************************************
'Created   : 2015-08-13 16:31:50 UTC
'Author    : Peter Carnegie
'Generator : CFuncGen Ver 2.1.5.0
'
CFUNCTION Driver.SDCard
	0000069B
	10c00006 00801021 00862021 a0450000 24420001 5444fffe a0450000 03e00008 
	00000000 
	2407ffff 24c6ffff 10c70008 00001021 80830000 80a20000 00621023 14400003 
	24840001 1000fff7 24a50001 03e00008 00000000 
	27bdffe0 afbf001c 3c029d00 8c42008c 8c420000 2c830002 1460001e 8c420060 
	8c430014 0083182b 1060001c 24030003 8c450000 14a3001e 000429c2 8c420018 
	3086007f 27a40010 00a22821 00063080 24070004 04110565 00000000 14400010 
	24030001 93a30013 00031e00 93a20012 00021400 00621825 93a20010 00621825 
	93a20011 00021200 00621825 10000004 7c63d800 10000002 24030001 24030001 
	00601021 8fbf001c 03e00008 27bd0020 1000ffff 00000000 
	3c029d00 8c42008c 8c420000 8c430060 2484fffe 8c650014 24a5fffe 0085282b 
	10a00005 00001021 8c650008 8c620020 70851802 00621021 03e00008 00000000 
	90830015 00031a00 90820014 00621825 00031c00 9082001b 00021200 9084001a 
	00441025 03e00008 00621025 
	27bdffe8 afbf0014 afb00010 00808021 3c029d00 8c42008c 8c420000 8c430060 
	ac800000 8c840008 24050001 1085000c 24020001 8c650014 0085282b 10a00009 
	8fbf0014 50800001 8c64001c ae04000c 0411FFD0 00000000 ae020010 00001021 
	8fbf0014 8fb00010 03e00008 27bd0018 
	27bdffe0 afbf001c afb20018 afb10014 afb00010 00808021 3c029d00 8c42008c 
	8c420000 8c520060 8c910000 26310001 3231ffff 12200027 24020003 8c830010 
	50600025 8fbf001c 3222000f 54400020 ae110000 24630001 ac830010 8c84000c 
	14800007 00111902 8e430010 0223182b 14600016 24020003 10000017 8fbf001c 
	8e420008 2442ffff 00621024 54400010 ae110000 0411FF75 00000000 00402021 
	2c430002 1460000b 24020001 8e430014 0083182b 10600007 24020003 ae04000c 
	0411FF98 00000000 ae020010 ae110000 00001021 8fbf001c 8fb20018 8fb10014 
	8fb00010 03e00008 27bd0020 
	27bdffe0 afbf001c afb20018 afb10014 afb00010 00808821 00a09021 0411FFA1 
	00000000 14400020 00408021 8e260000 30c6000f 02402021 8e250010 00063140 
	24070020 041104C9 00000000 0002802b 16000016 02001021 92420000 50400012 
	24100003 9242000b 30420008 14400008 02202021 02402021 8e250004 2406000b 
	0411FF32 00000000 10400007 02202021 0411FFA0 00000000 1040ffe4 00408021 
	10000002 02001021 02001021 8fbf001c 8fb20018 8fb10014 8fb00010 03e00008 
	27bd0020 
	27bdffe0 afbf001c afb20018 afb10014 afb00010 00a08021 3c029d00 8c42008c 
	8c520000 8c910004 02202021 24050020 2406000b 0411FF0B 00000000 8e090000 
	00002021 00001821 24080008 240a002f 2407002e 240b0008 01231021 80450000 
	30a200ff 24630001 2c460021 14c0001e 306300ff 504a001d 01231821 10470003 
	0088302b 14c00008 00000000 550b0017 01231821 54470015 01231821 01602021 
	1000ffed 2408000b 04a10005 2445ff9f 8e450048 00a21021 9042ff80 2445ff9f 
	30a500ff 2ca5001a 10a00003 02242821 2442ffe0 304200ff a0a20000 24840001 
	1000ffdd 308400ff 01231821 ae030000 2c420021 a222000b 00001021 8fbf001c 
	8fb20018 8fb10014 8fb00010 03e00008 27bd0020 
	27bdffe0 afbf001c afb10018 afb00014 00808021 afa60028 80c20000 24030020 
	14430006 00a08821 24c60001 afa60028 80c20000 5043fffd 24c60001 2403002f 
	54430004 ae000008 24c60001 afa60028 ae000008 8fa20028 90420000 2c420020 
	10400006 02002021 0411FF18 00000000 10000019 a2200000 02002021 27a50028 
	0411FF9A 00000000 14400013 02002021 02202821 0411FF64 00000000 1440000f 
	8fbf001c 8e030004 9063000b 5460000c 8fb10018 9222000b 30420010 10400005 
	02202021 0411FEF6 00000000 1000ffea ae020008 24020003 8fbf001c 8fb10018 
	8fb00014 03e00008 27bd0020 
	27bdffe0 afbf001c afb10018 afb00014 00808021 00a08821 240601fe 24070002 
	04110421 00000000 14400018 24030003 92040001 00042200 92020000 00822025 
	7c042620 2402aa55 14820010 24030002 02002021 02202821 24060052 24070002 
	04110411 00000000 14400008 24030001 92030001 00031a00 92020000 00621825 
	7c031e20 38634146 0003182b 00601021 8fbf001c 8fb10018 8fb00014 03e00008 
	27bd0020 
	27bdffb8 afbf0044 afb20040 afb1003c afb00038 00808821 3c029d00 8c42008c 
	8c500000 ae000060 8e04003c 04110364 00000000 30420001 1440006a 24030002 
	27a40010 00002821 0411FFC4 00000000 24030001 1443001a 00009021 27a40010 
	00002821 240601be 24070010 041103E5 00000000 1440005b 24030001 93a20014 
	10400058 24030006 93b2001b 00129600 93a2001a 00021400 02429025 93a20018 
	02429025 93a20019 00021200 02429025 27a40010 02402821 0411FFA8 00000000 
	24040003 10440047 24030001 14400045 24030006 27a40010 02402821 2406000d 
	24070024 041103C7 00000000 1440003d 24030001 93a2001a 00021200 93a30019 
	00431025 1440000c 93a30013 93a3002a 00031e00 93a20029 00021400 00621025 
	93a30027 00431025 93a30028 00031a00 00431025 93a30013 70431002 93a60012 
	00063200 93a30011 00c33025 02469021 ae320018 93a50010 ae250008 93a30015 
	00031a00 93a40014 00641825 ae230010 93a40017 00042200 93a70016 00872025 
	1480000b 00031902 93a70026 00073e00 93a40025 00042400 00e42025 93a70023 
	00872025 93a70024 00073a00 00872025 00862023 00822023 00832023 0085001b 
	00a001f4 00002812 24a50002 ae250014 3404fff7 00a4282b 10a00009 24040003 
	24030006 00601021 8fbf0044 8fb20040 8fb1003c 8fb00038 03e00008 27bd0048 
	ae240000 93a50032 00052e00 93a40031 00042400 00a42025 93a5002f 00852025 
	93a50030 00052a00 00852025 ae24001c 02439021 02421021 ae220020 ae200004 
	ae110060 1000ffe7 00001821 
	27bdffa0 afbf005c afb10058 afb00054 00803021 3c029d00 8c42008c 8c420000 
	8c510060 12200024 24100005 ae200004 27a20024 afa20014 27a40010 27a50030 
	0411FEF8 00000000 1440001b 00408021 93a20030 10400017 93a2003b 30420010 
	54400015 24100003 27a40030 0411FE15 00000000 ae22002c 93a3004f 00031e00 
	93a2004e 00021400 00621025 93a3004c 00431025 93a3004d 00031a00 00431025 
	ae220028 ae200024 24020001 10000002 ae220004 24100003 02001021 8fbf005c 
	8fb10058 8fb00054 03e00008 27bd0060 
	27bdffd0 afbf002c afb60028 afb50024 afb40020 afb3001c afb20018 afb10014 
	afb00010 0080a821 00c09821 3c029d00 8c42008c 8c420000 8c500060 acc00000 
	12000049 24020005 8e030004 30630001 10600045 24020004 8e120028 8e020024 
	02429023 0245102b 00a2900a 1240003e 00001021 0080a021 24160200 8e020024 
	304301ff 5460001e 8e060024 8e110008 2631ffff 00021a42 02238824 323100ff 
	5620000e 8e040030 54400003 8e040030 10000003 8e02002c 0411FD90 00000000 
	2c430002 50600004 ae020030 ae000004 10000025 24020001 8e040030 0411FDB5 
	00000000 14400004 00518821 ae000004 1000001d 24020001 ae110034 8e060024 
	30c601ff 02c61023 0052882b 0251100a 00408821 00002021 0295200b 8e050034 
	00403821 041102F0 00000000 50400004 8e020024 ae000004 1000000b 24020001 
	00511021 ae020024 02519023 8e620000 00511021 12400003 ae620000 1000ffc7 
	0291a021 00001021 8fbf002c 8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 
	8fb10014 8fb00010 03e00008 27bd0030 
	27bdffd0 afbf002c afb60028 afb50024 afb40020 afb3001c afb20018 afb10014 
	afb00010 00a09021 00c09821 0080a021 3c029d00 8c42008c 8c420000 8c500060 
	acc00000 12000077 24020005 8e030004 30640001 10800073 24020004 14a00011 
	30630040 5060000a 8e030004 00002021 00002821 04110306 00000000 50400004 
	8e030004 ae000004 10000066 24020001 2402ffbf 00621024 ae020004 10000061 
	00001021 54600006 8e030028 8e030024 2402fe00 00621024 ae020024 8e030028 
	8e020024 00621023 0052182b 10600004 24150200 10400053 00409021 24150200 
	2416ffbf 8e020024 304301ff 54600028 8e110024 8e110008 2631ffff 00021a42 
	02238824 323100ff 5620000e 8e040030 54400003 8e040030 10000003 8e02002c 
	0411FD12 00000000 2c430002 50600004 ae020030 ae000004 1000003a 24020001 
	8e040030 0411FD37 00000000 14400004 00512821 ae000004 10000032 24020001 
	ae050034 00002021 041102C9 00000000 50400004 8e020004 ae000004 10000029 
	24020001 34420040 ae020004 8e110024 323101ff 02b18823 0232102b 0242880a 
	02802021 02202821 041102B9 00000000 50400004 8e020024 ae000004 10000019 
	24020001 00511021 ae020024 8e620000 00511021 ae620000 8e020024 304201ff 
	5440000d 02519023 00002021 00002821 041102A7 00000000 50400004 8e020004 
	ae000004 10000007 24020001 00561024 ae020004 02519023 1640ffb2 0291a021 
	00001021 8fbf002c 8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014 
	8fb00010 03e00008 27bd0030 
	27bdffe0 afbf001c afb00018 3c029d00 8c42008c 8c500000 00002021 00002821 
	27a60010 0411FF63 00000000 ae000060 8fbf001c 8fb00018 03e00008 27bd0020 
	27bdffd8 afbf0024 afb30020 afb2001c afb10018 afb00014 3c029d00 8c42008c 
	8c420000 8c500060 1200004d 24020005 8e030004 30630001 10600049 24020004 
	8e020028 0044902b 0092100a 00409021 8e030024 ae000024 12400041 00001021 
	8e110008 10600012 00118a40 2463ffff 2642ffff 0051001b 022001f4 00001012 
	0071001b 022001f4 00002012 0044102b 54400008 8e04002c 00111023 00431824 
	ae030024 02439023 10000003 8e040030 8e04002c ae040030 0232102b 10400017 
	00119823 02519023 0411FC85 00000000 00402021 2c420002 54400006 ae000004 
	8e020014 0082102b 54400004 ae040030 ae000004 1000001a 24020001 8e020024 
	00511021 ae020024 02531021 00511821 0223182b 5460ffec 00409021 8e020024 
	00529021 ae120024 0411FC9B 00000000 54400004 8e040008 ae000004 10000008 
	24020001 2484ffff 8e030024 00031a42 00831824 00431021 ae020034 00001021 
	8fbf0024 8fb30020 8fb2001c 8fb10018 8fb00014 03e00008 27bd0028 
	00052840 0085001b 00a001f4 00001012 03e00008 2442ffff 
	27bdffe8 afbf0014 afb00010 3c029d00 8c43008c 8c700000 8c420010 3c03bf81 
	8c65f220 7ca5d800 3c030661 24630053 10a3000b 24040018 3c03bf81 8c64f220 
	7c84d800 3c030660 24630053 00832026 24030018 2405000b 00a4180b 00602021 
	24050008 0040f809 00003021 3c029d00 8c420010 3c03bf81 8c65f220 7ca5d800 
	3c030661 24630053 10a3000b 24040006 3c03bf81 8c64f220 7c84d800 3c030660 
	24630053 00832026 24030006 24050017 00a4180b 00602021 24050002 0040f809 
	00003021 3c029d00 8c420010 3c03bf81 8c65f220 7ca5d800 3c030661 24630053 
	10a3000b 2404001a 3c03bf81 8c64f220 7c84d800 3c030660 24630053 00832026 
	2403001a 2405000f 00a4180b 00602021 24050008 0040f809 00003021 3c02bf81 
	ac40f230 3c05aa99 24a56655 ac45f230 3c045566 348499aa ac44f230 3c03bf81 
	8c66f200 7c066b44 ac66f200 3c06bf81 8cc7fa90 24080004 7d071804 acc7fa90 
	3c06bf81 8cc7fb60 7d071804 acc7fb60 ac40f230 ac45f230 ac44f230 8c62f200 
	24040001 7c826b44 ac62f200 34038120 3c02bf80 ac435a00 3c029d00 8c420000 
	8c440000 3c050003 34a5d090 0411FF8E 00000000 3c03bf80 ac625a30 24020002 
	ae02003c 8fbf0014 8fb00010 03e00008 27bd0018 
	27bdffe8 afbf0014 afb00010 3c029d00 8c43008c 8c700000 8c420010 3c03bf81 
	8c65f220 7ca5d800 3c030661 24630053 10a3000b 24040018 3c03bf81 8c64f220 
	7c84d800 3c030660 24630053 00832026 24030018 2405000b 00a4180b 00602021 
	00002821 0040f809 00003021 3c029d00 8c420010 3c03bf81 8c65f220 7ca5d800 
	3c030661 24630053 10a3000b 24040006 3c03bf81 8c64f220 7c84d800 3c030660 
	24630053 00832026 24030006 24050017 00a4180b 00602021 00002821 0040f809 
	00003021 3c029d00 8c420010 3c03bf81 8c65f220 7ca5d800 3c030661 24630053 
	10a3000b 2404001a 3c03bf81 8c64f220 7c84d800 3c030660 24630053 00832026 
	2403001a 2405000f 00a4180b 00602021 00002821 0040f809 00003021 3c02bf81 
	ac40f230 3c05aa99 24a56655 ac45f230 3c045566 348499aa ac44f230 3c03bf81 
	8c66f200 7c066b44 ac66f200 3c06bf81 8cc7fb60 7c071804 acc7fb60 ac40f230 
	ac45f230 ac44f230 8c62f200 24040001 7c826b44 ac62f200 ae00003c 8fbf0014 
	8fb00010 03e00008 27bd0018 
	27bdffe8 afbf0014 3c029d00 8c420004 0040f809 24040064 8fbf0014 03e00008 
	27bd0018 
	308400ff 3c02bf80 ac445a20 3c03bf80 8c625a10 30420001 1040fffd 3c02bf80 
	8c425a20 03e00008 00000000 
	240300ff 3c02bf80 ac435a20 3c03bf80 8c625a10 30420001 1040fffd 3c02bf80 
	8c425a20 03e00008 304200ff 
	27bdffe0 afbf001c afb20018 afb10014 afb00010 309100ff 3c029d00 8c42008c 
	8c500000 7c111420 04410009 00a09021 24040077 00002821 0411FFF1 00000000 
	2c430002 1060002f 8fbf001c 3231007f 8e020058 8e030054 ac430000 0411FFDD 
	00000000 8e02005c 8e030054 ac430000 0411FFD8 00000000 02202021 0411FFCA 
	00000000 00122602 0411FFC7 00000000 7e443c00 0411FFC4 00000000 7e443a00 
	0411FFC1 00000000 324400ff 0411FFBE 00000000 24020040 12220006 24040095 
	3a310048 24020001 24030087 00402021 0071200a 0411FFB4 00000000 2410000a 
	0411FFBC 00000000 7c021c20 04610004 2610ffff 321000ff 1600fff9 00000000 
	8fbf001c 8fb20018 8fb10014 8fb00010 03e00008 27bd0020 
	27bdffd0 afbf002c afb40028 afb30024 afb20020 afb1001c afb00018 3c029d00 
	8c42008c 8c510000 0411FEB8 00000000 8e220058 8e230054 ac430000 2410000a 
	0411FF9E 00000000 2610ffff 321000ff 1600fffb 24040040 00002821 0411FFA2 
	00000000 24030001 1443005a 00009021 24040048 240501aa 0411FF9B 00000000 
	24030001 14430033 240400e9 27b40010 27b30014 02808021 0411FF88 00000000 
	a2020000 26100001 1613fffb 93a30012 24020001 14620047 00009021 93a30013 
	240200aa 54620044 a232004c 10000007 24102710 0411FF65 00000000 16000004 
	240400e9 10000039 00009021 240400e9 3c054000 0411FF7C 00000000 5440fff5 
	2610ffff 12000033 00009021 2404007a 00002821 0411FF74 00000000 5440002e 
	a232004c 0411FF65 00000000 a2820000 26940001 1674fffb 2402000c 93b20010 
	32520040 24030004 0072100a 10000021 00409021 00002821 0411FF63 00000000 
	2c420002 24030002 24120001 0062900b 240300e9 24130041 0062980b 10000005 
	24102710 0411FF39 00000000 52000011 00009021 02602021 00002821 0411FF52 
	00000000 5440fff7 2610ffff 52000009 00009021 24040050 24050200 0411FF4A 
	00000000 10000003 0002900b 10000002 a232004c a232004c 8e220058 8e230054 
	ac430000 0411FF35 00000000 3c029d00 8c420000 8c450000 00a02021 00052882 
	0411FE3C 00000000 3c03bf80 ac605a00 3c04bf80 ac825a30 34028120 ac625a00 
	2e420001 8fbf002c 8fb40028 8fb30024 8fb20020 8fb1001c 8fb00018 03e00008 
	27bd0030 
	27bdffd0 afbf002c afb50028 afb40024 afb30020 afb2001c afb10018 afb00014 
	00809021 00c09821 00e0a821 3c029d00 8c42008c 8c540000 9283004c 30630008 
	00051240 24040051 0043280a 0411FF15 00000000 14400029 24100001 34109c40 
	241100ff 0411FF04 00000000 14510005 2610ffff 1600fffb 00000000 1000001f 
	24100001 240300fe 1443001c 24100001 00138823 26310202 12600006 02358823 
	0411FEF5 00000000 2673ffff 1660fffc 00000000 12400009 02558021 0411FEEE 
	00000000 a2420000 26520001 1650fffb 00000000 10000004 00000000 26b5ffff 
	56a0ffff 26b5ffff 0411FEE3 00000000 2631ffff 1620fffc 00008021 8e820058 
	8e830054 ac430000 0411FEDB 00000000 02001021 8fbf002c 8fb50028 8fb40024 
	8fb30020 8fb2001c 8fb10018 8fb00014 03e00008 27bd0030 
	27bdffd8 afbf0024 afb30020 afb2001c afb10018 afb00014 00808021 3c029d00 
	8c42008c 10800012 8c510000 10a0004a 00009821 8e220044 10400047 00859021 
	92040000 26100001 0411FEB2 00000000 8e220044 2442ffff 1212003e ae220044 
	5440fff8 92040000 1000003b 00009821 50a00014 8e300044 9223004c 30630008 
	00051240 24040058 0043280a 0411FEB7 00000000 14400030 24130001 240400ff 
	0411FE9C 00000000 240400fe 0411FE99 00000000 24020200 ae220044 10000026 
	00009821 26100002 12000008 2610ffff 2412ffff 00002021 0411FE8E 00000000 
	2610ffff 1612fffc 00002021 0411FE94 00000000 3042001f 24030005 1443000e 
	24130001 10000005 24101388 0411FE78 00000000 10000002 2610ffff 241200ff 
	0411FE87 00000000 10520003 2e130001 1600fff6 24130001 8e220058 8e230054 
	ac430000 0411FE7E 00000000 10000003 02601021 00009821 02601021 8fbf0024 
	8fb30020 8fb2001c 8fb10018 8fb00014 03e00008 27bd0028 
	27bdffe0 afbf001c afb10018 afb00014 00808821 3c109d00 8e02003c 0040f809 
	24040064 8e03008c ac620000 00002021 00001821 24050019 00042080 00442021 
	ac800000 24630001 1465fffb 00602021 3c039d00 8c63008c 8c630000 24040064 
	ac640040 3c049d00 24841a6c 3c059d00 24a51ea0 00a4302b 10c00004 00a42023 
	00918821 10000003 ac710048 00918821 ac710048 8fbf001c 8fb10018 8fb00014 
	03e00008 27bd0020 
	27bdffe0 afbf001c afb20018 afb10014 afb00010 3c109d00 8e02008c 8c510000 
	ae240050 8e020028 0040f809 00809021 24030001 00431004 ae220054 8e020024 
	02402021 0040f809 24050006 ae220058 8e020024 02402021 0040f809 24050005 
	ae22005c 8e020010 02402021 24050008 0040f809 00003021 8e220058 8e230054 
	ac430000 0411FE77 00000000 8fbf001c 8fb20018 8fb10014 8fb00010 03e00008 
	27bd0020 
	27bdffe8 afbf0014 3c029d00 8c42008c 8c440000 0411FAFA 00000000 304200ff 
	8fbf0014 03e00008 27bd0018 
	27bdffc8 afbf0034 afb50030 afb4002c afb30028 afb20024 afb10020 afb0001c 
	00a08021 00c09021 8c820000 8c830004 24040009 14440003 00e08821 106000b8 
	24140642 2404000b 1444001a 00432025 14600018 2414ffff 3c029d00 8c42008c 
	8c420000 144000b1 2415ffff 8e040000 0411FF85 00000000 ae220000 ae200004 
	8e440000 0411FFAA 00000000 10400004 00000000 0040a021 100000a4 0000a821 
	0411FFCC 00000000 0040a021 1000009f 0000a821 1480000f 3c049d00 3c029d00 
	8c42008c 8c420000 2414ffff 14400097 2415ffff 8e040000 0411FF6B 00000000 
	ae420000 ae400004 0000a021 1000008f 0000a821 8c84008c 8c910000 2414ffff 
	1220008a 2415ffff 24040001 14440008 24040002 14600006 0000a821 8e040000 
	0411FF83 00000000 10000080 0040a021 14440007 24040003 14600005 0000a821 
	0411FFA4 00000000 10000078 0040a021 14440016 24040004 14600014 00000000 
	82020000 26040001 00821021 a0400001 82030001 24020020 14620005 24030020 
	24840001 80820000 5043fffe 24840001 0411FB23 00000000 8e430000 ae230038 
	305400ff 10000061 0000a821 1444000e 24040005 1460000c 27a60010 26040001 
	92050000 0411FB4A 00000000 8fa30010 a2030000 ae430000 ae400004 305400ff 
	10000052 0000a821 1444001d 24040006 1460001b 26130001 02602021 92050000 
	27a60010 0411FB9E 00000000 304200ff 10400004 8fa30010 0040a021 10000043 
	0000a821 ae430000 ae400004 8e230038 30630001 50600008 0040a021 02602021 
	00002821 27a60010 0411FB8D 00000000 304200ff 0040a021 10000034 0000a821 
	14440007 24040007 14600005 0000a821 0411FC16 00000000 1000002c 305400ff 
	54440014 24040008 54600012 24040008 0411FCF8 00000000 3c109d00 8e020010 
	8e240050 00002821 0040f809 00003021 8e03008c 8e020044 0040f809 8c640000 
	8e02008c ac400000 0000a021 10000017 0000a821 14440008 2404000a 14600006 
	0000a821 8e040000 0411FC08 00000000 1000000e 305400ff 1444000b 2414ffff 
	5460000a 2415ffff 8e220028 ae020000 ae000004 0000a021 10000004 0000a821 
	10000002 0000a821 2415ffff 02801021 02a01821 8fbf0034 8fb50030 8fb4002c 
	8fb30028 8fb20024 8fb10020 8fb0001c 03e00008 27bd0038 
	41909a80 808f418e 49454545 8f8e4949 4f929290 55554f99 9b9a9959 9f9e9d9c 
	554f4941 a7a6a5a5 abaaa9a8 afae21ac b3b2b1b0 b7b6b5b4 bbbab9b8 bfbebdbc 
	c3c2c1c0 c7c6c5c4 cbcac9c8 cfcecdcc d3d2d1d0 d7d6d5d4 dbdad9d8 dfdedddc 
	e3e2e1e0 e7e6e5e4 ebeae9e8 efeeedec f3f2f1f0 f7f6f5f4 fbfaf9f8 fffefdfc 
END CFUNCTION   'MIPS32 M4K
'
'******************************************************************************

