' Test Program for the MMB_Astro routines
' Author:  GerryL at the Backshed 
'
' This will check the routines in:
' 	1. "MMB_Astro.inc" or
'
' for specific dates/times and then compare the routine results to the U.S. Naval Observatory Multiyear Interactive Computer Almanac (MICA2.0)
' to produce a text file called "CompMICA.txt" that contins the differences between MICA 2.0 and the routines. 

 OPTION EXPLICIT
 OPTION DEFAULT NONE 
 'OPTION ESCAPE ON
 
 
 #INCLUDE "MMB_Astro.inc"
 
 
 
CONST SUN_MOON_RTS_TEST_SIZE = 10 ' 10 checks
CONST PLANET_RTS_SIZE = 5 ' only 5 checks
CONST PLANET_POS_SIZE = 6
CONST SUN_MOON_RTS = 3
CONST MOON_PHASES = 6
CONST SEASONS = 7
CONST PLANET_RTS_POS_TST = 15

'CONST cMINS_PER_DAY = 1440
CONST LUNAR_ECLIPSE_NOT_VISIBLE = -10000
CONST NO_CHECK_MAGNITUDE = -1000
CONST NO_ECLIPSE_OR_NOT_VISIBLE= -1000
'CONST cJAN1901_JD = 2415385.5

CONST MERCURY_TST = 0
CONST VENUS_TST = 1
CONST MARS_TST = 2
CONST JUPITER_TST = 3
CONST SATURN_TST = 4
CONST SUN_TST = 5
CONST MOON_TST = 6

CONST DERROR = 0
CONST TRANSITMIN = 1
CONST TRANSITALT = 2
CONST RISEMIN = 3
CONST RIZEAZ = 4
CONST SETMIN = 5
CONST SETAZ = 6
CONST CIVILTWIMIN = 7
CONST CIVILDUSKMIN = 8
CONST NAUTTWILMIN = 9
CONST NAUTDUSKMIN = 10
CONST ASTROTWILMIN = 11
CONST ASTRODUSKMIN = 12
CONST DAYLENGTH = 13
CONST SUNDISTANCE = 14
CONST MOONTRANSMIN = 15
CONST MOONTRANSALT = 16
CONST MOONRISEMIN = 17
CONST MOONRISEAZ = 18
CONST MOONSETMIN = 19
CONST MOONSETAZ = 20
CONST MOONDISTANCE = 21

CONST NewMoonJD = 1
CONST FirstQuarterJD = 2
CONST FullMoonJD = 3
CONST LastQuarterJD = 4
CONST EclipseDateJD = 5
CONST UmbraMag = 6
CONST PenumbraMag = 7
CONST AdditionalPhaseType = 8
CONST AdditionalDateJD = 9
CONST Time1 = 10
CONST Time2 = 11
CONST Time3 = 12
CONST Time4 = 13
CONST Time5 = 14
CONST Time6 = 15
CONST Time7 = 16

CONST MARCHJD = 1
CONST JUNEJD = 2
CONST SEPTEMBERJD = 3
CONST DECEMBERJD = 4
CONST JUNETOTALHRS = 5
CONST DECTOTALHRS = 6
CONST LEAPYEAR = 7

CONST RTSMAGNITUDE = 7
CONST RTSSIZE = 8
CONST RTSDISTANCE = 9


CONST IAZIMUTH = 1
CONST IALT = 2
CONST IDISTANCE = 3
CONST IRTASC = 4
CONST IDEC = 5
CONST IMAGNITUDE = 6
CONST ISIZE = 7
CONST IMOON_ILLUM = 8
CONST IMOON_POS_ANGLE = 9
CONST ILONG = 10
CONST ILAT = 11
CONST IEARTHLONG = 12
CONST IPLANETSUNDIST = 13
CONST IEARTHSUNDIST = 14

CONST m_dYear = 0
CONST m_dMonth = 1
CONST m_dDay = 2
CONST m_dHour = 3
CONST m_dMin = 4
CONST m_dSec = 5


DIM As String TestCmnds(9)
DIM As Float TempUmbraMag, TempPenumbraMag
DIM As String RetString 'whats returned



DIM As Float MicaSunMoonRTSData(SUN_MOON_RTS_TEST_SIZE, 21) 'SunMoonRTSData
DIM As Float SMRTSDataDelta(SUN_MOON_RTS_TEST_SIZE,21) ' diff between MICA and program, SunMoonRTSData
DIM As Float SunMoonRTSMaxErrors(21) ' SunMoonRTSData
DIM As Float MoonMicaPhaseData(SUN_MOON_RTS_TEST_SIZE,16) ' MoonPhaseData
DIM As Float MoonPhaseDeltas(SUN_MOON_RTS_TEST_SIZE,16) ' diff between MICA and program, MoonPhaseData
DIM As Float MoonPhaseMaxErrors(16) ' MoonPhaseData
DIM As Float MicaSeasonData(SUN_MOON_RTS_TEST_SIZE,7) 'Seasons
DIM As Float SeasonDeltas(SUN_MOON_RTS_TEST_SIZE,7) ' diff between MICA and program, Seasons
DIM As Float SeasonMaxErrors(7) ' Seasons
DIM As Float MicaPlanetRTS(PLANET_RTS_SIZE,5,9) ' five visible planets, PlanetRTSData
DIM As Float PlanetRTSDelta(PLANET_RTS_SIZE,5,9) ' five visible planets, PlanetRTSData
DIM As Float PlanetRTSMAXError(9) 'PlanetRTSData
DIM As Float MicaPlanetPOS(PLANET_RTS_SIZE,14) 'InstObjectPositionData
DIM As Float PlanetPOSDelta(PLANET_RTS_SIZE,14) 'InstObjectPositionData
DIM As Float PlanetPOSMAXError(14) 'InstObjectPositionData
DIM As Float MoonMaxErrorDistance = 0
DIM AS Integer FileOpen = 0

FUNCTION TestCalcJD(DateTime() As Float) As Float
    ' Calculate the Juian Day from year,month and day (can be fraction for hrs,mins secs)
    ' Only works between March 1 1900 and Feb 28 2100 (this is the Gregorian Calender)
    ' Refer AA Ch 7
    LOCAL AS Float dRet
	LOCAL AS Float dYear = DateTime(m_dYear)
    LOCAL As Float dDay = DateTime(m_dDay) + (DateTime(m_dHour) / 24) + (DateTime(m_dMin) / 1440) + (DateTime(m_dSec) / 86400)
    if DateTime(m_dMonth) < 3 Then
        INC dYear, -1 ' sub 1
        DateTime(m_dMonth) = DateTime(m_dMonth) + 12
    End If
    dRet = FIX(365.25 * (dYear + 4716)) + FIX(30.6001 * (DateTime(m_dMonth) + 1)) + dDay - 13 - 1524.5
   TestCalcJD = dRet
End Function



SUB OpenOutFile() 
	'CHDIR "C:\Users\gerar\Documents\Documents\gpl_data\" 'MMBasic Win Version\"
	OPEN "CompMICA.txt" FOR OUTPUT AS #1
	'OPEN "C:MMBAstroCompMICA.txt" FOR OUTPUT AS #1
	FileOpen = 1
END SUB

SUB CloseOutFile() 
    CLOSE #1
	FileOpen = 0
END SUB


SUB SetSunMoonRTSMICAData()
	MATH SET 0, SunMoonRTSMaxErrors()
     ' for 6th April 2023
    MicaSunMoonRTSData(0,dError) = 0
    MicaSunMoonRTSData(0,TransitMin) = 738 ' mins past 00hr
    MicaSunMoonRTSData(0,TransitAlt)=49
    MicaSunMoonRTSData(0,RiseMin) = 392
    MicaSunMoonRTSData(0,RizeAz) = 83
    MicaSunMoonRTSData(0,SetMin)=1085
    MicaSunMoonRTSData(0,SetAz) = 277
    MicaSunMoonRTSData(0,CivilTwiMin) = 367
    MicaSunMoonRTSData(0,CivilDuskMin) = 1110
    MicaSunMoonRTSData(0,NautTwilMin) = 337
    MicaSunMoonRTSData(0,NautDuskMin) = 1139
    MicaSunMoonRTSData(0,AstroTwilMin) = 308
    MicaSunMoonRTSData(0,AstroDuskMin) = 1168
    MicaSunMoonRTSData(0,DayLength) = 693
    MicaSunMoonRTSData(0,SunDistance) = 1.000435398 * 149.597871
    MicaSunMoonRTSData(0,MoonTransMin) = 0.0 ' no transit
    MicaSunMoonRTSData(0,MoonTransAlt) = 0.0
    MicaSunMoonRTSData(0,MoonRiseMin) = 18 * 60 + 12
    MicaSunMoonRTSData(0,MoonRiseAz) = 97
    MicaSunMoonRTSData(0,MoonSetMin) = 375
    MicaSunMoonRTSData(0,MoonSetAz) = 267
    MicaSunMoonRTSData(0,MoonDistance) = 390513.582 'Based on Rise as no transit
    ' for 20th June 2023
    MicaSunMoonRTSData(1,dError) = 0
    MicaSunMoonRTSData(1,TransitMin) = 737 ' mins past 00hr
    MicaSunMoonRTSData(1,TransitAlt) = 32
    MicaSunMoonRTSData(1,RiseMin) = 7*60+23
    MicaSunMoonRTSData(1,RizeAz) = 62
    MicaSunMoonRTSData(1,SetMin) = 17 * 60 + 12
    MicaSunMoonRTSData(1,SetAz) = 298
    MicaSunMoonRTSData(1,CivilTwiMin) = 6 * 60 + 55
    MicaSunMoonRTSData(1,CivilDuskMin) = 17 * 60 + 40
    MicaSunMoonRTSData(1,NautTwilMin) = 6 * 60 + 23
    MicaSunMoonRTSData(1,NautDuskMin) = 18 * 60 + 12
    MicaSunMoonRTSData(1,AstroTwilMin) = 5 * 60 + 52
    MicaSunMoonRTSData(1,AstroDuskMin) = 18 * 60 + 42
    MicaSunMoonRTSData(1,DayLength) = 0
    MicaSunMoonRTSData(1,SunDistance) = 1.016148789 * 149.597871
    MicaSunMoonRTSData(1,MoonTransMin) = 13 * 60 + 58
    MicaSunMoonRTSData(1,MoonTransAlt) = 28
    MicaSunMoonRTSData(1,MoonRiseMin) = 9 * 60 + 12
    MicaSunMoonRTSData(1,MoonRiseAz) = 56
    MicaSunMoonRTSData(1,MoonSetMin) = 18 * 60 + 47
    MicaSunMoonRTSData(1,MoonSetAz) = 303
    MicaSunMoonRTSData(1,MoonDistance) = 402290.304
    ' for 25th Dec 2023
    MicaSunMoonRTSData(2,dError) = 0
    MicaSunMoonRTSData(2,TransitMin) = 13 * 60 + 16 ' mins past 00hr
    MicaSunMoonRTSData(2,TransitAlt) = 79
    MicaSunMoonRTSData(2,RiseMin) = 6 * 60 + 01
    MicaSunMoonRTSData(2,RizeAz) = 120
    MicaSunMoonRTSData(2,SetMin) = 20 * 60 + 30
    MicaSunMoonRTSData(2,SetAz) = 240
    MicaSunMoonRTSData(2,CivilTwiMin) = 5 * 60 + 31
    MicaSunMoonRTSData(2,CivilDuskMin) = 21 * 60 + 0
    MicaSunMoonRTSData(2,NautTwilMin) = 4 * 60 + 55
    MicaSunMoonRTSData(2,NautDuskMin) = 21 * 60 + 36
    MicaSunMoonRTSData(2,AstroTwilMin) = 4 * 60 + 14
    MicaSunMoonRTSData(2,AstroDuskMin) = 22 * 60 + 17
    MicaSunMoonRTSData(2,DayLength) = 0
    MicaSunMoonRTSData(2,SunDistance) = 0.983541300 * 149.597871
    MicaSunMoonRTSData(2,MoonTransMin) = 23 * 60 + 58
    MicaSunMoonRTSData(2,MoonTransAlt) = 28
    MicaSunMoonRTSData(2,MoonRiseMin) = 19 * 60 + 8
    MicaSunMoonRTSData(2,MoonRiseAz) = 57
    MicaSunMoonRTSData(2,MoonSetMin) = 3 * 60 + 59
    MicaSunMoonRTSData(2,MoonSetAz) = 300
    MicaSunMoonRTSData(2,MoonDistance) = 386701.730
    ' for 20th Dec 2029
    MicaSunMoonRTSData(3,dError) = 0
    MicaSunMoonRTSData(3,TransitMin) = 13 * 60 + 13 ' mins past 00hr
    MicaSunMoonRTSData(3,TransitAlt) = 79
    MicaSunMoonRTSData(3,RiseMin) = 5 * 60 + 59
    MicaSunMoonRTSData(3,RizeAz) = 120
    MicaSunMoonRTSData(3,SetMin) = 20 * 60 + 28
    MicaSunMoonRTSData(3,SetAz) = 240
    MicaSunMoonRTSData(3,CivilTwiMin) = 5 * 60 + 29
    MicaSunMoonRTSData(3,CivilDuskMin) = 20 * 60 + 58
    MicaSunMoonRTSData(3,NautTwilMin) = 4 * 60 + 52
    MicaSunMoonRTSData(3,NautDuskMin) = 21 * 60 + 34
    MicaSunMoonRTSData(3,AstroTwilMin) = 4 * 60 + 12
    MicaSunMoonRTSData(3,AstroDuskMin) = 22 * 60 + 15
    MicaSunMoonRTSData(3,DayLength) = 0
    MicaSunMoonRTSData(3,SunDistance) = 0.983817785 * 149.597871
    MicaSunMoonRTSData(3,MoonTransMin) = 0 * 60 + 6
    MicaSunMoonRTSData(3,MoonTransAlt) = 31
    MicaSunMoonRTSData(3,MoonRiseMin) = 19 * 60 + 57
    MicaSunMoonRTSData(3,MoonRiseAz) = 61
    MicaSunMoonRTSData(3,MoonSetMin) = 5 * 60 + 05
    MicaSunMoonRTSData(3,MoonSetAz) = 299
    MicaSunMoonRTSData(3,MoonDistance) = 401697.721
    ' for 15th May 2033
    MicaSunMoonRTSData(4,dError) = 0
    MicaSunMoonRTSData(4,TransitMin) = 12 * 60 + 12 ' mins past 00hr
    MicaSunMoonRTSData(4,TransitAlt) = 36
    MicaSunMoonRTSData(4,RiseMin) = 7 * 60 + 3
    MicaSunMoonRTSData(4,RizeAz) = 67
    MicaSunMoonRTSData(4,SetMin) = 17 * 60 + 21
    MicaSunMoonRTSData(4,SetAz) = 293
    MicaSunMoonRTSData(4,CivilTwiMin) = 6 * 60 + 36
    MicaSunMoonRTSData(4,CivilDuskMin) = 17 * 60 + 48
    MicaSunMoonRTSData(4,NautTwilMin) = 6 * 60 + 5
    MicaSunMoonRTSData(4,NautDuskMin) = 18 * 60 + 19
    MicaSunMoonRTSData(4,AstroTwilMin) = 5 * 60 + 35
    MicaSunMoonRTSData(4,AstroDuskMin) = 18 * 60 + 49
    MicaSunMoonRTSData(4,DayLength) = 0
    MicaSunMoonRTSData(4,SunDistance) = 1.010790081 * 149.597871
    MicaSunMoonRTSData(4,MoonTransMin) = 0 * 60 + 23
    MicaSunMoonRTSData(4,MoonTransAlt) = 71
    MicaSunMoonRTSData(4,MoonRiseMin) = 18 * 60 + 9
    MicaSunMoonRTSData(4,MoonRiseAz) = 112
    MicaSunMoonRTSData(4,MoonSetMin) = 7 * 60 + 26
    MicaSunMoonRTSData(4,MoonSetAz) = 249
    MicaSunMoonRTSData(4,MoonDistance) = 395517.620
    ' for 30th July 2035
    MicaSunMoonRTSData(5,dError) = 0
    MicaSunMoonRTSData(5,TransitMin) = 12 * 60 + 22 ' mins past 00hr
    MicaSunMoonRTSData(5,TransitAlt) = 37
    MicaSunMoonRTSData(5,RiseMin) = 7 * 60 + 12
    MicaSunMoonRTSData(5,RizeAz) = 68
    MicaSunMoonRTSData(5,SetMin) = 17 * 60 + 33
    MicaSunMoonRTSData(5,SetAz) = 292
    MicaSunMoonRTSData(5,CivilTwiMin) = 6 * 60 + 45
    MicaSunMoonRTSData(5,CivilDuskMin) = 18 * 60 + 0
    MicaSunMoonRTSData(5,NautTwilMin) = 6 * 60 + 15
    MicaSunMoonRTSData(5,NautDuskMin) = 18 * 60 + 30
    MicaSunMoonRTSData(5,AstroTwilMin) = 5 * 60 + 45
    MicaSunMoonRTSData(5,AstroDuskMin) = 19 * 60 + 0
    MicaSunMoonRTSData(5,DayLength) = 0
    MicaSunMoonRTSData(5,SunDistance) = 1.015334009 * 149.597871
    MicaSunMoonRTSData(5,MoonTransMin) = 7 * 60 + 43
    MicaSunMoonRTSData(5,MoonTransAlt) = 39
    MicaSunMoonRTSData(5,MoonRiseMin) = 2 * 60 + 13
    MicaSunMoonRTSData(5,MoonRiseAz) = 72
    MicaSunMoonRTSData(5,MoonSetMin) = 13 * 60 + 10
    MicaSunMoonRTSData(5,MoonSetAz) = 289
    MicaSunMoonRTSData(5,MoonDistance) = 368099.927
    ' for 12th Sep 2015
    MicaSunMoonRTSData(6,dError) = 0
    MicaSunMoonRTSData(6,TransitMin) = 12 * 60 + 12 ' mins past 00hr
    MicaSunMoonRTSData(6,TransitAlt) = 51
    MicaSunMoonRTSData(6,RiseMin) = 6 * 60 + 21
    MicaSunMoonRTSData(6,RizeAz) = 85
    MicaSunMoonRTSData(6,SetMin) = 18 * 60 + 5
    MicaSunMoonRTSData(6,SetAz) = 275
    MicaSunMoonRTSData(6,CivilTwiMin) = 5 * 60 + 56
    MicaSunMoonRTSData(6,CivilDuskMin) = 18 * 60 + 30
    MicaSunMoonRTSData(6,NautTwilMin) = 5 * 60 + 26
    MicaSunMoonRTSData(6,NautDuskMin) = 18 * 60 + 59
    MicaSunMoonRTSData(6,AstroTwilMin) = 4 * 60 + 57
    MicaSunMoonRTSData(6,AstroDuskMin) = 19 * 60 + 28
    MicaSunMoonRTSData(6,DayLength) = 0
    MicaSunMoonRTSData(6,SunDistance) = 1.006627339 * 149.597871
    MicaSunMoonRTSData(6,MoonTransMin) = 11 * 60 + 20
    MicaSunMoonRTSData(6,MoonTransAlt) = 47
    MicaSunMoonRTSData(6,MoonRiseMin) = 5 * 60 + 33
    MicaSunMoonRTSData(6,MoonRiseAz) = 80
    MicaSunMoonRTSData(6,MoonSetMin) = 17 * 60 + 12
    MicaSunMoonRTSData(6,MoonSetAz) = 278
    MicaSunMoonRTSData(6,MoonDistance) = 404564.569
    ' for 21st Mar 2040 *** NO MOON SET ***
    MicaSunMoonRTSData(7,dError) = 0
    MicaSunMoonRTSData(7,TransitMin) = 13 * 60 + 23 ' mins past 00hr
    MicaSunMoonRTSData(7,TransitAlt) = 55
    MicaSunMoonRTSData(7,RiseMin) = 7 * 60 + 20
    MicaSunMoonRTSData(7,RizeAz) = 90
    MicaSunMoonRTSData(7,SetMin) = 19 * 60 + 25
    MicaSunMoonRTSData(7,SetAz) = 270
    MicaSunMoonRTSData(7,CivilTwiMin) = 6 * 60 + 55
    MicaSunMoonRTSData(7,CivilDuskMin) = 19 * 60 + 51
    MicaSunMoonRTSData(7,NautTwilMin) = 6 * 60 + 25
    MicaSunMoonRTSData(7,NautDuskMin) = 20 * 60 + 20
    MicaSunMoonRTSData(7,AstroTwilMin) = 5 * 60 + 56
    MicaSunMoonRTSData(7,AstroDuskMin) = 20 * 60 + 50
    MicaSunMoonRTSData(7,DayLength) = 0
    MicaSunMoonRTSData(7,SunDistance) = 0.996128410 * 149.597871
    MicaSunMoonRTSData(7,MoonTransMin) = 19 * 60 + 55
    MicaSunMoonRTSData(7,MoonTransAlt) = 29
    MicaSunMoonRTSData(7,MoonRiseMin) = 15 * 60 + 4
    MicaSunMoonRTSData(7,MoonRiseAz) = 58
    MicaSunMoonRTSData(7,MoonSetMin) = 0 * 60 + 0
    MicaSunMoonRTSData(7,MoonSetAz) = 0
    MicaSunMoonRTSData(7,MoonDistance) = 404283.285
    ' for 11th Oct 2045
    MicaSunMoonRTSData(8,dError) = 0
    MicaSunMoonRTSData(8,TransitMin) = 13 * 60 + 3 ' mins past 00hr
    MicaSunMoonRTSData(8,TransitAlt) = 62
    MicaSunMoonRTSData(8,RiseMin) = 6 * 60 + 39
    MicaSunMoonRTSData(8,RizeAz) = 99
    MicaSunMoonRTSData(8,SetMin) = 19 * 60 + 27
    MicaSunMoonRTSData(8,SetAz) = 261
    MicaSunMoonRTSData(8,CivilTwiMin) = 6 * 60 + 13
    MicaSunMoonRTSData(8,CivilDuskMin) = 19 * 60 + 53
    MicaSunMoonRTSData(8,NautTwilMin) = 5 * 60 + 43
    MicaSunMoonRTSData(8,NautDuskMin) = 20 * 60 + 23
    MicaSunMoonRTSData(8,AstroTwilMin) = 5 * 60 + 12
    MicaSunMoonRTSData(8,AstroDuskMin) = 20 * 60 + 54
    MicaSunMoonRTSData(8,DayLength) = 0
    MicaSunMoonRTSData(8,SunDistance) = 0.998450906 * 149.597871
    MicaSunMoonRTSData(8,MoonTransMin) = 13 * 60 + 30
    MicaSunMoonRTSData(8,MoonTransAlt) = 70
    MicaSunMoonRTSData(8,MoonRiseMin) = 6 * 60 + 39
    MicaSunMoonRTSData(8,MoonRiseAz) = 106
    MicaSunMoonRTSData(8,MoonSetMin) = 20 * 60 + 32
    MicaSunMoonRTSData(8,MoonSetAz) = 250
    MicaSunMoonRTSData(8,MoonDistance) = 368566.954
    ' for 31st Dec 2049
    MicaSunMoonRTSData(9,dError) = 0
    MicaSunMoonRTSData(9,TransitMin) = 13 * 60 + 19 ' mins past 00hr
    MicaSunMoonRTSData(9,TransitAlt) = 78
    MicaSunMoonRTSData(9,RiseMin) = 6 * 60 + 5
    MicaSunMoonRTSData(9,RizeAz) = 119
    MicaSunMoonRTSData(9,SetMin) = 20 * 60 + 32
    MicaSunMoonRTSData(9,SetAz) = 241
    MicaSunMoonRTSData(9,CivilTwiMin) = 5 * 60 + 36
    MicaSunMoonRTSData(9,CivilDuskMin) = 21 * 60 + 2
    MicaSunMoonRTSData(9,NautTwilMin) = 4 * 60 + 59
    MicaSunMoonRTSData(9,NautDuskMin) = 21 * 60 + 38
    MicaSunMoonRTSData(9,AstroTwilMin) = 4 * 60 + 19
    MicaSunMoonRTSData(9,AstroDuskMin) = 22 * 60 + 18
    MicaSunMoonRTSData(9,DayLength) = 0
    MicaSunMoonRTSData(9,SunDistance) = 0.983370858 * 149.597871
    MicaSunMoonRTSData(9,MoonTransMin) = 19 * 60 + 5
    MicaSunMoonRTSData(9,MoonTransAlt) = 47
    MicaSunMoonRTSData(9,MoonRiseMin) = 13 * 60 + 12
    MicaSunMoonRTSData(9,MoonRiseAz) = 82
    MicaSunMoonRTSData(9,MoonSetMin) = 0 * 60 + 16
    MicaSunMoonRTSData(9,MoonSetAz) = 275
    MicaSunMoonRTSData(9,MoonDistance) = 375766.885
END SUB

SUB SetSunMoonRTSMICADataTwo() 
	MATH SET 0, SunMoonRTSMaxErrors()
    ' for 6th April 2023
    MicaSunMoonRTSData(0,dError) = 0
    MicaSunMoonRTSData(0,TransitMin) = 13 * 60 + 37
    MicaSunMoonRTSData(0,TransitAlt) = 43
    MicaSunMoonRTSData(0,RiseMin) = 6 * 60 + 57
    MicaSunMoonRTSData(0,RizeAz) = 78
    MicaSunMoonRTSData(0,SetMin) = 20 * 60 + 19
    MicaSunMoonRTSData(0,SetAz) = 282
    MicaSunMoonRTSData(0,CivilTwiMin) = 6 * 60 + 21
    MicaSunMoonRTSData(0,CivilDuskMin) = 20 * 60 + 55
    MicaSunMoonRTSData(0,NautTwilMin) = 5 * 60 + 37
    MicaSunMoonRTSData(0,NautDuskMin) = 21 * 60 + 40
    MicaSunMoonRTSData(0,AstroTwilMin) = 4 * 60 + 48
    MicaSunMoonRTSData(0,AstroDuskMin) = 22 * 60 + 29
    MicaSunMoonRTSData(0,DayLength) = 802
    MicaSunMoonRTSData(0,SunDistance) = 1.000636754 * 149.597871
    MicaSunMoonRTSData(0,MoonTransMin) = 1 * 60 + 46
    MicaSunMoonRTSData(0,MoonTransAlt) = 30.0
    MicaSunMoonRTSData(0,MoonRiseMin) = 21 * 60 + 18
    MicaSunMoonRTSData(0,MoonRiseAz) = 108
    MicaSunMoonRTSData(0,MoonSetMin) = 7 * 60 + 17
    MicaSunMoonRTSData(0,MoonSetAz) = 258
    MicaSunMoonRTSData(0,MoonDistance) = 390654.032
     ' for 25th Dec 2023
    MicaSunMoonRTSData(1,dError) = 0
    MicaSunMoonRTSData(1,TransitMin) = 12 * 60 + 35 ' mins past 00hr
    MicaSunMoonRTSData(1,TransitAlt) = 13
    MicaSunMoonRTSData(1,RiseMin) = 8 * 60 + 50
    MicaSunMoonRTSData(1,RizeAz) = 130
    MicaSunMoonRTSData(1,SetMin) = 16 * 60 + 20
    MicaSunMoonRTSData(1,SetAz) = 230
    MicaSunMoonRTSData(1,CivilTwiMin) = 8 * 60 + 7
    MicaSunMoonRTSData(1,CivilDuskMin) = 17 * 60 + 3
    MicaSunMoonRTSData(1,NautTwilMin) = 7 * 60 + 22
    MicaSunMoonRTSData(1,NautDuskMin) = 17 * 60 + 49
    MicaSunMoonRTSData(1,AstroTwilMin) = 6 * 60 + 39
    MicaSunMoonRTSData(1,AstroDuskMin) = 18 * 60 + 31
    MicaSunMoonRTSData(1,DayLength) = 450
    MicaSunMoonRTSData(1,SunDistance) = 0.983507027 * 149.597871
    MicaSunMoonRTSData(1,MoonTransMin) = 23 * 60 + 57
    MicaSunMoonRTSData(1,MoonTransAlt) = 64
    MicaSunMoonRTSData(1,MoonRiseMin) = 14 * 60 + 40
    MicaSunMoonRTSData(1,MoonRiseAz) = 40
    MicaSunMoonRTSData(1,MoonSetMin) = 8 * 60 + 12
    MicaSunMoonRTSData(1,MoonSetAz) = 319
    MicaSunMoonRTSData(1,MoonDistance) = 389203.354
    ' for 20th Dec 2029
    MicaSunMoonRTSData(2,dError) = 0
    MicaSunMoonRTSData(2,TransitMin) = 12 * 60 + 33 ' mins past 00hr
    MicaSunMoonRTSData(2,TransitAlt) = 13
    MicaSunMoonRTSData(2,RiseMin) = 8 * 60 + 48
    MicaSunMoonRTSData(2,RizeAz) = 130
    MicaSunMoonRTSData(2,SetMin) = 16 * 60 + 18
    MicaSunMoonRTSData(2,SetAz) = 230
    MicaSunMoonRTSData(2,CivilTwiMin) = 8 * 60 + 5
    MicaSunMoonRTSData(2,CivilDuskMin) = 17 * 60 + 1
    MicaSunMoonRTSData(2,NautTwilMin) = 7 * 60 + 20
    MicaSunMoonRTSData(2,NautDuskMin) = 17 * 60 + 46
    MicaSunMoonRTSData(2,AstroTwilMin) = 6 * 60 + 37
    MicaSunMoonRTSData(2,AstroDuskMin) = 18 * 60 + 29
    MicaSunMoonRTSData(2,DayLength) = 0
    MicaSunMoonRTSData(2,SunDistance) = 0.983767253 * 149.597871
    MicaSunMoonRTSData(2,MoonTransMin) = 0 * 60 + 0
    MicaSunMoonRTSData(2,MoonTransAlt) = 60
    MicaSunMoonRTSData(2,MoonRiseMin) = 16 * 60 + 15
    MicaSunMoonRTSData(2,MoonRiseAz) = 49
    MicaSunMoonRTSData(2,MoonSetMin) = 8 * 60 + 40
    MicaSunMoonRTSData(2,MoonSetAz) = 311
    MicaSunMoonRTSData(2,MoonDistance) = 399913.793

    ' for 15th May 2033
    MicaSunMoonRTSData(3,dError) = 0
    MicaSunMoonRTSData(3,TransitMin) = 13 * 60 + 31 ' mins past 00hr
    MicaSunMoonRTSData(3,TransitAlt) = 56
    MicaSunMoonRTSData(3,RiseMin) = 5 * 60 + 34
    MicaSunMoonRTSData(3,RizeAz) = 56
    MicaSunMoonRTSData(3,SetMin) = 21 * 60 + 30
    MicaSunMoonRTSData(3,SetAz) = 305
    MicaSunMoonRTSData(3,CivilTwiMin) = 4 * 60 + 50
    MicaSunMoonRTSData(3,CivilDuskMin) = 22 * 60 + 15
    MicaSunMoonRTSData(3,NautTwilMin) = 3 * 60 + 46
    MicaSunMoonRTSData(3,NautDuskMin) = 23 * 60 + 19
    MicaSunMoonRTSData(3,AstroTwilMin) = 0 * 60 + 0
    MicaSunMoonRTSData(3,AstroDuskMin) = 0 * 60 + 0
    MicaSunMoonRTSData(3,DayLength) = 0
    MicaSunMoonRTSData(3,SunDistance) = 1.010942057 * 149.597871
    MicaSunMoonRTSData(3,MoonTransMin) = 2 * 60 + 17
    MicaSunMoonRTSData(3,MoonTransAlt) = 18
    MicaSunMoonRTSData(3,MoonRiseMin) = 22 * 60 + 47
    MicaSunMoonRTSData(3,MoonRiseAz) = 122
    MicaSunMoonRTSData(3,MoonSetMin) = 6 * 60 + 43
    MicaSunMoonRTSData(3,MoonSetAz) = 239
    MicaSunMoonRTSData(3,MoonDistance) = 393165.761
END SUB

SUB SetMoonPhaseMICAData() 
    MATH SET 0, MoonPhaseMaxErrors()
    ' for 6th May 2023
    MoonMicaPhaseData(0,dError) = 0
    MoonMicaPhaseData(0,NewMoonJD) = 2460084.1619 + 0.395833 ' add Time Zone so it is local
    MoonMicaPhaseData(0,FirstQuarterJD) = 2460092.1404 + 0.395833
    MoonMicaPhaseData(0,FullMoonJD) = 2460070.2319 + 0.395833
    MoonMicaPhaseData(0,LastQuarterJD) = 2460077.1029 + 0.395833
    MoonMicaPhaseData(0,AdditionalPhaseType) = 0
    MoonMicaPhaseData(0,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(0,EclipseDateJD) = 2460070.5 ' 0 Hr local date that the eclipse occurs so can check against date provided by program
    MoonMicaPhaseData(0,UmbraMag) = 0.0
    MoonMicaPhaseData(0,PenumbraMag) = 0.989
    MoonMicaPhaseData(0,Time1) = 0 * 60.0 + 42 ' pen contact in mins past 00hr
    MoonMicaPhaseData(0,Time2) = 2 * 60.0 + 52 ' max
    MoonMicaPhaseData(0,Time3) = 5 * 60.0 + 3
    MoonMicaPhaseData(0,Time4) = 0
    MoonMicaPhaseData(0,Time5) = 0
    MoonMicaPhaseData(0,Time6) = 0
    MoonMicaPhaseData(0,Time7) = 0
    '29-10-2023"//partial lunar, moon sets 
    MoonMicaPhaseData(1,dError) = 0
    MoonMicaPhaseData(1,NewMoonJD) = 2460232.2466 + 0.4375 ' add Time Zone so it is local
    MoonMicaPhaseData(1,FirstQuarterJD) = 2460239.6454 + 0.4375
    MoonMicaPhaseData(1,FullMoonJD) = 2460246.35 + 0.4375
    MoonMicaPhaseData(1,LastQuarterJD) = 2460224.0748 + 0.4375
    MoonMicaPhaseData(1,AdditionalPhaseType) = 0
    MoonMicaPhaseData(1,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(1,EclipseDateJD) = 2460246.5 ' 0 Hr but the local date
    MoonMicaPhaseData(1,UmbraMag) = 0.127
    MoonMicaPhaseData(1,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(1,Time1) = 4 * 60.0 + 30 ' pen contact in mins past 00hr ocal
    MoonMicaPhaseData(1,Time2) = 6 * 60.0 + 4 ' enters umbra
    MoonMicaPhaseData(1,Time3) = LUNAR_ECLIPSE_NOT_VISIBLE ' moon set so no more MICA data
    MoonMicaPhaseData(1,Time4) = LUNAR_ECLIPSE_NOT_VISIBLE
    MoonMicaPhaseData(1,Time5) = LUNAR_ECLIPSE_NOT_VISIBLE
    MoonMicaPhaseData(1,Time6) = 0
    MoonMicaPhaseData(1,Time7) = 0
    '25-03-2024 Partial lunar, moon rises
    MoonMicaPhaseData(2,dError) = 0
    MoonMicaPhaseData(2,NewMoonJD) = 2460379.8752 + 0.4375 ' add Time Zone so it is local
    MoonMicaPhaseData(2,FirstQuarterJD) = 2460386.6741 + 0.4375
    MoonMicaPhaseData(2,FullMoonJD) = 2460394.7918 + 0.4375
    MoonMicaPhaseData(2,LastQuarterJD) = 2460373.1413 + 0.4375
    MoonMicaPhaseData(2,AdditionalPhaseType) = 0
    MoonMicaPhaseData(2,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(2,EclipseDateJD) = 2460394.5 ' 0 Hr but the local date
    MoonMicaPhaseData(2,UmbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(2,PenumbraMag) = 0.982
    MoonMicaPhaseData(2,Time1) = LUNAR_ECLIPSE_NOT_VISIBLE 
    MoonMicaPhaseData(2,Time2) = LUNAR_ECLIPSE_NOT_VISIBLE 
    MoonMicaPhaseData(2,Time3) = 20 * 60.0 + 5 ' moon exits penumbra
    MoonMicaPhaseData(2,Time4) = 0
    MoonMicaPhaseData(2,Time5) = 0
    MoonMicaPhaseData(2,Time6) = 0
    MoonMicaPhaseData(2,Time7) = 0
    '07-09-2025, total eclipse
    MoonMicaPhaseData(3,dError) = 0
    MoonMicaPhaseData(3,NewMoonJD) = 2460940.3292 + 0.395833 ' add Time Zone so it is local
    MoonMicaPhaseData(3,FirstQuarterJD) = 2460948.4956 + 0.395833
    MoonMicaPhaseData(3,FullMoonJD) = 2460926.2561 + 0.395833
    MoonMicaPhaseData(3,LastQuarterJD) = 2460932.9395 + 0.395833
    MoonMicaPhaseData(3,AdditionalPhaseType) = 0
    MoonMicaPhaseData(3,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(3,EclipseDateJD) = 2460926.5 ' 0 Hr but the local date
    MoonMicaPhaseData(3,UmbraMag) = 1.368 
    MoonMicaPhaseData(3,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(3,Time1) = 0 * 60 + 57
    MoonMicaPhaseData(3,Time2) = 1 * 60 + 57
    MoonMicaPhaseData(3,Time3) = 3 * 60 + 0
    MoonMicaPhaseData(3,Time4) = 3 * 60 + 42
    MoonMicaPhaseData(3,Time5) = 4 * 60 + 23
    MoonMicaPhaseData(3,Time6) = 5 * 60 + 27
    MoonMicaPhaseData(3,Time7) = 6 * 60 + 26
   '03-03-2026, total eclipse 
    MoonMicaPhaseData(4,dError) = 0
    MoonMicaPhaseData(4,NewMoonJD) = 2461118.5579 + 0.4375 ' add Time Zone so it is local
    MoonMicaPhaseData(4,FirstQuarterJD) = 2461125.3039 + 0.4375
    MoonMicaPhaseData(4,FullMoonJD) = 2461102.9846 + 0.4375
    MoonMicaPhaseData(4,LastQuarterJD) = 2461110.9017 + 0.4375
    MoonMicaPhaseData(4,AdditionalPhaseType) = 0
    MoonMicaPhaseData(4,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(4,EclipseDateJD) = 2461102.5 ' 0 Hr but the local date
    MoonMicaPhaseData(4,UmbraMag) = 1.156
    MoonMicaPhaseData(4,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(4,Time1) = LUNAR_ECLIPSE_NOT_VISIBLE ' penumbra
    MoonMicaPhaseData(4,Time2) = 20 * 60 + 18
    MoonMicaPhaseData(4,Time3) = 21 * 60 + 34
    MoonMicaPhaseData(4,Time4) = 22 * 60 + 4
    MoonMicaPhaseData(4,Time5) = 22 * 60 + 33
    MoonMicaPhaseData(4,Time6) = 23 * 60 + 47
    MoonMicaPhaseData(4,Time7) = 0 * 60 + 54
    '01-01-2029" extra new moon and total eclipse
    MoonMicaPhaseData(5,dError) = 0
    MoonMicaPhaseData(5,NewMoonJD) = 2462151.2253 + 0.4375 ' add Time Zone so it is local 
    MoonMicaPhaseData(5,FirstQuarterJD) = 2462159.3077 + 0.4375 
    MoonMicaPhaseData(5,FullMoonJD) = 2462137.2003 + 0.4375
    MoonMicaPhaseData(5,LastQuarterJD) = 2462144.0599 + 0.4375
    MoonMicaPhaseData(5,AdditionalPhaseType) = 3
    MoonMicaPhaseData(5,AdditionalDateJD) = 2462166.7524 + 0.4375 
    MoonMicaPhaseData(5,EclipseDateJD) = 2462137.5 ' 0 Hr but the local date
    MoonMicaPhaseData(5,UmbraMag) = 1.252
    MoonMicaPhaseData(5,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(5,Time1) = 0 * 60 + 32 ' penumbra
    MoonMicaPhaseData(5,Time2) = 1 * 60 + 37
    MoonMicaPhaseData(5,Time3) = 2 * 60 + 46
    MoonMicaPhaseData(5,Time4) = 3 * 60 + 22
    MoonMicaPhaseData(5,Time5) = 3 * 60 + 58
    MoonMicaPhaseData(5,Time6) = 5 * 60 + 7
    MoonMicaPhaseData(5,Time7) = 6 * 60 + 12
    '26-05-2040 Total
    MoonMicaPhaseData(6,dError) = 0
    MoonMicaPhaseData(6,NewMoonJD) = 2466285.6442 + 0.395833 ' add Time Zone so it is local
    MoonMicaPhaseData(6,FirstQuarterJD) = 2466293.7919 + 0.395833
    MoonMicaPhaseData(6,FullMoonJD) = 2466300.9909 + 0.395833
    MoonMicaPhaseData(6,LastQuarterJD) = 2466278.3330 + 0.395833
    MoonMicaPhaseData(6,AdditionalPhaseType) = 0
    MoonMicaPhaseData(6,AdditionalDateJD) = 2415385.5 + 0.395833
    MoonMicaPhaseData(6,EclipseDateJD) = 2466300.5 ' 0 Hr but the local date
    MoonMicaPhaseData(6,UmbraMag) = 1.541
    MoonMicaPhaseData(6,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(6,Time1) = 18 * 60 + 33 ' penumbra
    MoonMicaPhaseData(6,Time2) = 19 * 60 + 29
    MoonMicaPhaseData(6,Time3) = 20 * 60 + 28
    MoonMicaPhaseData(6,Time4) = 21 * 60 + 15
    MoonMicaPhaseData(6,Time5) = 22 * 60 + 2
    MoonMicaPhaseData(6,Time6) = 23 * 60 + 1
    MoonMicaPhaseData(6,Time7) = 23 * 60 + 57
    '17-05-2049, Partial, additional New Moon
    MoonMicaPhaseData(7,dError) = 0
    MoonMicaPhaseData(7,NewMoonJD) = 2469563.5075 + 0.395833 ' add Time Zone so it is local
    MoonMicaPhaseData(7,FirstQuarterJD) = 2469571.5815 + 0.395833
    MoonMicaPhaseData(7,FullMoonJD) = 2469578.9677 + 0.395833
    MoonMicaPhaseData(7,LastQuarterJD) = 2469585.6207 + 0.395833
    MoonMicaPhaseData(7,AdditionalPhaseType) = 1
    MoonMicaPhaseData(7,AdditionalDateJD) = 2469593.0832 + 0.395833 
    MoonMicaPhaseData(7,EclipseDateJD) = 2469578.5 ' 0 Hr but the local date
    MoonMicaPhaseData(7,UmbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(7,PenumbraMag) = 0.789
    MoonMicaPhaseData(7,Time1) = 19 * 60 + 1 ' penumbra
    MoonMicaPhaseData(7,Time2) = 20 * 60 + 55
    MoonMicaPhaseData(7,Time3) = 22 * 60 + 49
    MoonMicaPhaseData(7,Time4) = 0 * 60 + 0
    MoonMicaPhaseData(7,Time5) = 0 * 60 + 0
    MoonMicaPhaseData(7,Time6) = 0 * 60 + 0
    MoonMicaPhaseData(7,Time7) = 0 * 60 + 0
    '11-10-2045, no eclipse
    MoonMicaPhaseData(8,dError) = 0
    MoonMicaPhaseData(8,NewMoonJD) = 2468263.9421 + 0.4375 ' add Time Zone so it is local
    MoonMicaPhaseData(8,FirstQuarterJD) = 2468271.2883 + 0.4375
    MoonMicaPhaseData(8,FullMoonJD) = 2468279.3965 + 0.4375
    MoonMicaPhaseData(8,LastQuarterJD) = 2468257.2718 + 0.4375
    MoonMicaPhaseData(8,AdditionalPhaseType) = 0
    MoonMicaPhaseData(8,AdditionalDateJD) = 2415385.5 + 0.4375
    MoonMicaPhaseData(8,EclipseDateJD) = cJAN1901_JD ' no eclipse
    MoonMicaPhaseData(8,UmbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(8,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(8,Time1) = 0 * 60 + 0 ' penumbra
    MoonMicaPhaseData(8,Time2) = 0 * 60 + 0
    MoonMicaPhaseData(8,Time3) = 0 * 60 + 0
    MoonMicaPhaseData(8,Time4) = 0 * 60 + 0
    MoonMicaPhaseData(8,Time5) = 0 * 60 + 0
    MoonMicaPhaseData(8,Time6) = 0 * 60 + 0
    MoonMicaPhaseData(8,Time7) = 0 * 60 + 0
    '31-12-2049, no eclipse, additional first qtr
    MoonMicaPhaseData(9,dError) = 0
    MoonMicaPhaseData(9,NewMoonJD) = 2469800.2441 + 0.4375 ' add Time Zone so it is local
    MoonMicaPhaseData(9,FirstQuarterJD) = 2469777.4858 + 0.4375
    MoonMicaPhaseData(9,FullMoonJD) = 2469784.8110 + 0.4375
    MoonMicaPhaseData(9,LastQuarterJD) = 2469792.9684 + 0.4375
    MoonMicaPhaseData(9,AdditionalPhaseType) = 2
    MoonMicaPhaseData(9,AdditionalDateJD) = 2469806.8698 + 0.4375
    MoonMicaPhaseData(9,EclipseDateJD) = cJAN1901_JD 'no eclipse
    MoonMicaPhaseData(9,UmbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(9,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(9,Time1) = 0 * 60 + 0 ' penumbra
    MoonMicaPhaseData(9,Time2) = 0 * 60 + 0
    MoonMicaPhaseData(9,Time3) = 0 * 60 + 0
    MoonMicaPhaseData(9,Time4) = 0 * 60 + 0
    MoonMicaPhaseData(9,Time5) = 0 * 60 + 0
    MoonMicaPhaseData(9,Time6) = 0 * 60 + 0
    MoonMicaPhaseData(9,Time7) = 0 * 60 + 0
END SUB

SUB SetMoonPhaseMICADataTwo() 
	MATH SET 0, MoonPhaseMaxErrors()
    ' for 6th Sep 2024, TZ= -6Hrs, partial lunar, moon rises
    MoonMicaPhaseData(0,dError) = 0
    MoonMicaPhaseData(0,NewMoonJD) = 2460556.5802 - 0.25 ' sub Time Zone so it is local
    MoonMicaPhaseData(0,FirstQuarterJD) = 2460564.7539 - 0.25
    MoonMicaPhaseData(0,FullMoonJD) = 2460571.6072 - 0.25
    MoonMicaPhaseData(0,LastQuarterJD) = 2460578.2846 - 0.25
    MoonMicaPhaseData(0,AdditionalPhaseType) = 0
    MoonMicaPhaseData(0,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(0,EclipseDateJD) = 2460570.5 ' 0 Hr local date that the eclipse occurs so can check against date provided by program
    MoonMicaPhaseData(0,UmbraMag) = 091
    MoonMicaPhaseData(0,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(0,Time1) = LUNAR_ECLIPSE_NOT_VISIBLE ' pen contact in mins past 00hr
    MoonMicaPhaseData(0,Time2) = 20 * 60 + 12 
    MoonMicaPhaseData(0,Time3) = 20 * 60 + 44 ' max
    MoonMicaPhaseData(0,Time4) = 21 * 60 + 17
    MoonMicaPhaseData(0,Time5) = 22 * 60 + 49
    MoonMicaPhaseData(0,Time6) = 0
    MoonMicaPhaseData(0,Time7) = 0
    '03-01-2028"//partial lunar, -7 hrs
    MoonMicaPhaseData(1,dError) = 0
    MoonMicaPhaseData(1,NewMoonJD) = 2461797.1336 - 0.29166666 ' sub Time Zone so it is local
    MoonMicaPhaseData(1,FirstQuarterJD) = 2461775.5697 - 0.29166666
    MoonMicaPhaseData(1,FullMoonJD) = 2461782.6687 - 0.29166666
    MoonMicaPhaseData(1,LastQuarterJD) = 2461789.3096 - 0.29166666
    MoonMicaPhaseData(1,AdditionalPhaseType) = 0
    MoonMicaPhaseData(1,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(1,EclipseDateJD) = 2461781.5 ' 0 Hr but the local date
    MoonMicaPhaseData(1,UmbraMag) = 072
    MoonMicaPhaseData(1,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(1,Time1) = 19 * 60 + 6 ' pen contact in mins past 00hr ocal
    MoonMicaPhaseData(1,Time2) = 20 * 60 + 44 ' enters umbra
    MoonMicaPhaseData(1,Time3) = 21 * 60 + 13 ' max
    MoonMicaPhaseData(1,Time4) = 21 * 60 + 42
    MoonMicaPhaseData(1,Time5) = 23 * 60 + 20
    MoonMicaPhaseData(1,Time6) = 0
    MoonMicaPhaseData(1,Time7) = 0
    '25-10-2033 total lunar, -6Hrs
    MoonMicaPhaseData(2,dError) = 0
    MoonMicaPhaseData(2,NewMoonJD) = 2463893.8113 - 0.25 ' sub Time Zone so it is local
    MoonMicaPhaseData(2,FirstQuarterJD) = 2463872.1893 - 0.25
    MoonMicaPhaseData(2,FullMoonJD) = 2463878.9569 - 0.25
    MoonMicaPhaseData(2,LastQuarterJD) = 2463885.6995 - 0.25
    MoonMicaPhaseData(2,AdditionalPhaseType) = 2
    MoonMicaPhaseData(2,AdditionalDateJD) = 2463901.6988 - 0.25
    MoonMicaPhaseData(2,EclipseDateJD) = 2463878.5 ' 0 Hr but the local date
    MoonMicaPhaseData(2,UmbraMag) = 1.356
    MoonMicaPhaseData(2,PenumbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(2,Time1) = 2 * 60 + 17
    MoonMicaPhaseData(2,Time2) = 3 * 60 + 14
    MoonMicaPhaseData(2,Time3) = 4 * 60 + 15 ' moon exits penumbra
    MoonMicaPhaseData(2,Time4) = 4 * 60 + 55
    MoonMicaPhaseData(2,Time5) = 5 * 60 + 35
    MoonMicaPhaseData(2,Time6) = 6 * 60 + 37
    MoonMicaPhaseData(2,Time7) = 7 * 60 + 33
    '07-03-2045, penumbra eclipse, -7 hrs & -6hrs
    MoonMicaPhaseData(3,dError) = 0
    MoonMicaPhaseData(3,NewMoonJD) = 2468058.2185 - 0.25 ' sub - 6hrs Time Zone so it is local
    MoonMicaPhaseData(3,FirstQuarterJD) = 2468065.5390 - 0.25 '- 6hrs
    MoonMicaPhaseData(3,FullMoonJD) = 2468042.8281 - 0.29166666 ' - 7hrs
    MoonMicaPhaseData(3,LastQuarterJD) = 2468050.0345 - 0.29166666 ' - 7hrs
    MoonMicaPhaseData(3,AdditionalPhaseType) = 0
    MoonMicaPhaseData(3,AdditionalDateJD) = 2415385.5
    MoonMicaPhaseData(3,EclipseDateJD) = 2468042.5 ' 0 Hr but the local date
    MoonMicaPhaseData(3,UmbraMag) = NO_CHECK_MAGNITUDE
    MoonMicaPhaseData(3,PenumbraMag) = 0.988
    MoonMicaPhaseData(3,Time1) = 22 * 60 + 38
    MoonMicaPhaseData(3,Time2) = 0 * 60 + 42
    MoonMicaPhaseData(3,Time3) = 2 * 60 + 46
    MoonMicaPhaseData(3,Time4) = 0
    MoonMicaPhaseData(3,Time5) = 0
    MoonMicaPhaseData(3,Time6) = 0
    MoonMicaPhaseData(3,Time7) = 0
END SUB

SUB SetSeasonMICAData() 
	MATH SET 0, SeasonMaxErrors()
    LOCAL AS Float sDateTime(5)
     ' for 01-01-2015
    sDateTime(m_dYear) = 2015
    sDateTime(m_dMonth) = 3
    sDateTime(m_dDay) = 20
    sDateTime(m_dHour) = 22
    sDateTime(m_dMin) = 45
    sDateTime(m_dSec) = 0
    MicaSeasonData(0,dError) = 0
    MicaSeasonData(0,MarchJD) = TestCalcJD(sDateTime()) + 0.4375
    sDateTime(m_dMonth) = 6
    sDateTime(m_dDay) = 21
    sDateTime(m_dHour) = 16
    sDateTime(m_dMin) = 38
    MicaSeasonData(0,JuneJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 9
    sDateTime(m_dDay) = 23
    sDateTime(m_dHour) = 8
    sDateTime(m_dMin) = 21
    MicaSeasonData(0,SeptemberJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 12
    sDateTime(m_dDay) = 22
    sDateTime(m_dHour) = 4
    sDateTime(m_dMin) = 48
    MicaSeasonData(0,DecemberJD) = TestCalcJD(sDateTime()) + 0.4375
    MicaSeasonData(0,JuneTotalHrs)= 9.8167
    MicaSeasonData(0,DecTotalHrs) = 14.5
    MicaSeasonData(0,LeapYear) = 0
    ' for 15-01-2023
    sDateTime(m_dYear) = 2023
    sDateTime(m_dMonth) = 3
    sDateTime(m_dDay) = 20
    sDateTime(m_dHour) = 21
    sDateTime(m_dMin) = 24
    sDateTime(m_dSec) = 0
    MicaSeasonData(1,dError) = 0
    MicaSeasonData(1,MarchJD) = TestCalcJD(sDateTime()) + 0.4375
    sDateTime(m_dMonth) = 6
    sDateTime(m_dDay) = 21
    sDateTime(m_dHour) = 14
    sDateTime(m_dMin) = 58
    MicaSeasonData(1,JuneJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 9
    sDateTime(m_dDay) = 23
    sDateTime(m_dHour) = 6
    sDateTime(m_dMin) = 50
    MicaSeasonData(1,SeptemberJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 12
    sDateTime(m_dDay) = 22
    sDateTime(m_dHour) = 3
    sDateTime(m_dMin) = 27
    MicaSeasonData(1,DecemberJD) = TestCalcJD(sDateTime()) + 0.4375
    MicaSeasonData(1,JuneTotalHrs) = 9.8167
    MicaSeasonData(1,DecTotalHrs) = 14.5
    MicaSeasonData(1,LeapYear) = 0
    ' for 08-05-2029
    sDateTime(m_dYear) = 2029
    sDateTime(m_dMonth) = 3
    sDateTime(m_dDay) = 20
    sDateTime(m_dHour) = 8
    sDateTime(m_dMin) = 2
    sDateTime(m_dSec) = 0
    MicaSeasonData(2,dError) = 0
    MicaSeasonData(2,MarchJD) = TestCalcJD(sDateTime()) + 0.4375
    sDateTime(m_dMonth) = 6
    sDateTime(m_dDay) = 21
    sDateTime(m_dHour) = 1
    sDateTime(m_dMin) = 48
    MicaSeasonData(2,JuneJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 9
    sDateTime(m_dDay) = 22
    sDateTime(m_dHour) = 17
    sDateTime(m_dMin) = 38
    MicaSeasonData(2,SeptemberJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 12
    sDateTime(m_dDay) = 21
    sDateTime(m_dHour) = 14
    sDateTime(m_dMin) = 14
    MicaSeasonData(2,DecemberJD) = TestCalcJD(sDateTime()) + 0.4375
    MicaSeasonData(2,JuneTotalHrs) = 9.8167
    MicaSeasonData(2,DecTotalHrs) = 14.48333
    MicaSeasonData(2,LeapYear) = 0
    ' for 15-09-2032, leap year
    sDateTime(m_dYear) = 2032
    sDateTime(m_dMonth) = 3
    sDateTime(m_dDay) = 20
    sDateTime(m_dHour) = 1
    sDateTime(m_dMin) = 22
    sDateTime(m_dSec) = 0
    MicaSeasonData(3,dError) = 0
    MicaSeasonData(3,MarchJD) = TestCalcJD(sDateTime()) + 0.4375
    sDateTime(m_dMonth) = 6
    sDateTime(m_dDay) = 20
    sDateTime(m_dHour) = 19
    sDateTime(m_dMin) = 9
    MicaSeasonData(3,JuneJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 9
    sDateTime(m_dDay) = 22
    sDateTime(m_dHour) = 11
    sDateTime(m_dMin) = 11
    MicaSeasonData(3,SeptemberJD)= TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 12
    sDateTime(m_dDay) = 21
    sDateTime(m_dHour) = 7
    sDateTime(m_dMin) = 56
    MicaSeasonData(3,DecemberJD) = TestCalcJD(sDateTime()) + 0.4375
    MicaSeasonData(3,JuneTotalHrs) = 9.8167
    MicaSeasonData(3,DecTotalHrs) = 14.5
    MicaSeasonData(3,LeapYear) = 1
    ' for 21-12-2048, leap year
    sDateTime(m_dYear) = 2048
    sDateTime(m_dMonth) = 3
    sDateTime(m_dDay) = 19
    sDateTime(m_dHour) = 22
    sDateTime(m_dMin) = 34
    sDateTime(m_dSec) = 0
    MicaSeasonData(4,dError) = 0
    MicaSeasonData(4,MarchJD) = TestCalcJD(sDateTime()) + 0.4375
    sDateTime(m_dMonth) = 6
    sDateTime(m_dDay) = 20
    sDateTime(m_dHour) = 15
    sDateTime(m_dMin) = 54
    MicaSeasonData(4,JuneJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 9
    sDateTime(m_dDay) = 22
    sDateTime(m_dHour) = 8
    sDateTime(m_dMin) = 0
    MicaSeasonData(4,SeptemberJD) = TestCalcJD(sDateTime()) + 0.395833
    sDateTime(m_dMonth) = 12
    sDateTime(m_dDay) = 21
    sDateTime(m_dHour) = 5
    sDateTime(m_dMin) = 2
    MicaSeasonData(4,DecemberJD) = TestCalcJD(sDateTime()) + 0.4375
    MicaSeasonData(4,JuneTotalHrs) = 9.8167
    MicaSeasonData(4,DecTotalHrs) = 14.5
    MicaSeasonData(4,LeapYear) = 1
END SUB

SUB SetSeasonMICADataTwo()
    MATH SET 0, SeasonMaxErrors()
    LOCAL AS Float sDateTime(5)
    ' for 01-01-2015
    sDateTime(m_dYear) =2015
    sDateTime(m_dMonth) =3
    sDateTime(m_dDay) =20
    sDateTime(m_dHour) =22
    sDateTime(m_dMin) =45
    sDateTime(m_dSec) = 0
    MicaSeasonData(0,dError) = 0
    MicaSeasonData(0,MarchJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =6
    sDateTime(m_dDay) =21
    sDateTime(m_dHour) =16
    sDateTime(m_dMin) =38
    MicaSeasonData(0,JuneJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =9
    sDateTime(m_dDay) =23
    sDateTime(m_dHour) =8
    sDateTime(m_dMin) =21
    MicaSeasonData(0,SeptemberJD) = TestCalcJD(sDateTime()) -0.25
    sDateTime(m_dMonth) =12
    sDateTime(m_dDay) =22
    sDateTime(m_dHour) =4
    sDateTime(m_dMin) =48
    MicaSeasonData(0,DecemberJD) = TestCalcJD(sDateTime()) - 0.291666 '- 7hrs
    MicaSeasonData(0,JuneTotalHrs) = 17.01667
    MicaSeasonData(0,DecTotalHrs) = 7.5
    MicaSeasonData(0,LeapYear) = 0
    ' for 15-01-2023
    sDateTime(m_dYear) =2023
    sDateTime(m_dMonth) =3
    sDateTime(m_dDay) =20
    sDateTime(m_dHour) =21
    sDateTime(m_dMin) =24
    sDateTime(m_dSec) =0
    MicaSeasonData(1,dError) = 0
    MicaSeasonData(1,MarchJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =6
    sDateTime(m_dDay) =21
    sDateTime(m_dHour) =14
    sDateTime(m_dMin) =58
    MicaSeasonData(1,JuneJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =9
    sDateTime(m_dDay) =23
    sDateTime(m_dHour) =6
    sDateTime(m_dMin) =50
    MicaSeasonData(1,SeptemberJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =12
    sDateTime(m_dDay) =22
    sDateTime(m_dHour) =3
    sDateTime(m_dMin) =27
    MicaSeasonData(1,DecemberJD) = TestCalcJD(sDateTime()) - 0.291666
    MicaSeasonData(1,JuneTotalHrs)= 17.01667
    MicaSeasonData(1,DecTotalHrs) = 7.5
    MicaSeasonData(1,LeapYear) = 0
    ' for 08-05-2029
    sDateTime(m_dYear) =2029
    sDateTime(m_dMonth) =3
    sDateTime(m_dDay) =20
    sDateTime(m_dHour) =8
    sDateTime(m_dMin) =2
    sDateTime(m_dSec) =0
    MicaSeasonData(2,dError) = 0
    MicaSeasonData(2,MarchJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =6
    sDateTime(m_dDay) =21
    sDateTime(m_dHour) =1
    sDateTime(m_dMin) =48
    MicaSeasonData(2,JuneJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =9
    sDateTime(m_dDay) =22
    sDateTime(m_dHour) =17
    sDateTime(m_dMin) =38
    MicaSeasonData(2,SeptemberJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =12
    sDateTime(m_dDay) =21
    sDateTime(m_dHour) =14
    sDateTime(m_dMin) =14
    MicaSeasonData(2,DecemberJD) = TestCalcJD(sDateTime()) - 0.291666
    MicaSeasonData(2,JuneTotalHrs) = 17.01667
    MicaSeasonData(2,DecTotalHrs) = 7.48333
    MicaSeasonData(2,LeapYear) = 0
    ' for 15-09-2032, leap year
    sDateTime(m_dYear) =2032
    sDateTime(m_dMonth) =3
    sDateTime(m_dDay) =20
    sDateTime(m_dHour) =1
    sDateTime(m_dMin) =22
    sDateTime(m_dSec) =0
    MicaSeasonData(3,dError) = 0
    MicaSeasonData(3,MarchJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =6
    sDateTime(m_dDay) =20
    sDateTime(m_dHour) =19
    sDateTime(m_dMin) =9
    MicaSeasonData(3,JuneJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =9
    sDateTime(m_dDay) =22
    sDateTime(m_dHour) =11
    sDateTime(m_dMin) =11
    MicaSeasonData(3,SeptemberJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =12
    sDateTime(m_dDay) =21
    sDateTime(m_dHour) =7
    sDateTime(m_dMin) =56
    MicaSeasonData(3,DecemberJD) = TestCalcJD(sDateTime()) - 0.291666
    MicaSeasonData(3,JuneTotalHrs) = 17.01667
    MicaSeasonData(3,DecTotalHrs) = 7.48333
    MicaSeasonData(3,LeapYear) = 1
    ' for 21-12-2048, leap year
    sDateTime(m_dYear) =2048
    sDateTime(m_dMonth) =3
    sDateTime(m_dDay) =19
    sDateTime(m_dHour) =22
    sDateTime(m_dMin) =34
    sDateTime(m_dSec) =0
    MicaSeasonData(4,dError) = 0
    MicaSeasonData(4,MarchJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =6
    sDateTime(m_dDay) =20
    sDateTime(m_dHour) =15
    sDateTime(m_dMin) =54
    MicaSeasonData(4,JuneJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =9
    sDateTime(m_dDay) =22
    sDateTime(m_dHour) =8
    sDateTime(m_dMin) =0
    MicaSeasonData(4,SeptemberJD) = TestCalcJD(sDateTime()) - 0.25
    sDateTime(m_dMonth) =12
    sDateTime(m_dDay) =21
    sDateTime(m_dHour) =5
    sDateTime(m_dMin) =2
    MicaSeasonData(4,DecemberJD) = TestCalcJD(sDateTime()) - 0.291666
    MicaSeasonData(4,JuneTotalHrs) = 17.0
    MicaSeasonData(4,DecTotalHrs) = 7.5
    MicaSeasonData(4,LeapYear) = 1
END SUB

SUB SetPlanetRTSMICAData() 
	MATH SET 0, PlanetRTSMAXError()
    '06-04-2015
    ' Mercury
    MicaPlanetRTS(0,0,TransitMin) = 12 * 60 + 5
    MicaPlanetRTS(0,0,TransitAlt) = 52
    MicaPlanetRTS(0,0,RiseMin) = 6 * 60 + 10
    MicaPlanetRTS(0,0,RizeAz) = 87
    MicaPlanetRTS(0,0,SetMin) = 17 * 60 + 58
    MicaPlanetRTS(0,0,SetAz) = 274
    MicaPlanetRTS(0,0,RTSMAGNITUDE) = -1.6
    MicaPlanetRTS(0,0,RTSSIZE) = 5
    MicaPlanetRTS(0,0,RTSDISTANCE) = 1.344566809 * 149.597871
    ' Venus
    MicaPlanetRTS(0,1,TransitMin) = 14 * 60 + 43
    MicaPlanetRTS(0,1,TransitAlt) = 35
    MicaPlanetRTS(0,1,RiseMin) = 9 * 60 + 37
    MicaPlanetRTS(0,1,RizeAz) = 66
    MicaPlanetRTS(0,1,SetMin) = 19 * 60 + 48
    MicaPlanetRTS(0,1,SetAz) = 294
    MicaPlanetRTS(0,1,RTSMAGNITUDE) = -4
    MicaPlanetRTS(0,1,RTSSIZE) = 14.2
    MicaPlanetRTS(0,1,RTSDISTANCE) = 1.173457517 * 149.597871
    ' Mars
    MicaPlanetRTS(0,2,TransitMin) = 13 * 60 + 27
    MicaPlanetRTS(0,2,TransitAlt) = 42
    MicaPlanetRTS(0,2,RiseMin) = 8 * 60 + 0
    MicaPlanetRTS(0,2,RizeAz) = 75
    MicaPlanetRTS(0,2,SetMin) = 18 * 60 + 53
    MicaPlanetRTS(0,2,SetAz) = 285
    MicaPlanetRTS(0,2,RTSMAGNITUDE) = 1.4
    MicaPlanetRTS(0,2,RTSSIZE) = 3.9
    MicaPlanetRTS(0,2,RTSDISTANCE) = 2.381858042 * 149.597871
    ' Jupiter
    MicaPlanetRTS(0,3,TransitMin) = 20 * 60 + 20
    MicaPlanetRTS(0,3,TransitAlt) = 37
    MicaPlanetRTS(0,3,RiseMin) = 15 * 60 + 9
    MicaPlanetRTS(0,3,RizeAz) = 68
    MicaPlanetRTS(0,3,SetMin) = 1 * 60 + 34
    MicaPlanetRTS(0,3,SetAz) = 292
    MicaPlanetRTS(0,3,RTSMAGNITUDE) = -2.3
    MicaPlanetRTS(0,3,RTSSIZE) = 40.8
    MicaPlanetRTS(0,3,RTSDISTANCE) = 4.831249136 * 149.597871
    ' Saturn
    MicaPlanetRTS(0,4,TransitMin) = 3 * 60 + 33
    MicaPlanetRTS(0,4,TransitAlt) = 74
    MicaPlanetRTS(0,4,RiseMin) = 20 * 60 + 32
    MicaPlanetRTS(0,4,RizeAz) = 114
    MicaPlanetRTS(0,4,SetMin) = 10 * 60 + 30
    MicaPlanetRTS(0,4,SetAz) = 246
    MicaPlanetRTS(0,4,RTSMAGNITUDE) = 0.3
    MicaPlanetRTS(0,4,RTSSIZE) = 17.9
    MicaPlanetRTS(0,4,RTSDISTANCE) = 9.284732574 * 149.597871
    '25-12-2033) ==========================
   ' Mercury
    MicaPlanetRTS(1,0,TransitMin) = 13 * 60 + 20
    MicaPlanetRTS(1,0,TransitAlt) = 80
    MicaPlanetRTS(1,0,RiseMin) = 6 * 60 + 0
    MicaPlanetRTS(1,0,RizeAz) = 121
    MicaPlanetRTS(1,0,SetMin) = 20 * 60 + 40
    MicaPlanetRTS(1,0,SetAz) = 239
    MicaPlanetRTS(1,0,RTSMAGNITUDE) = -1.3
    MicaPlanetRTS(1,0,RTSSIZE) = 4.7
    MicaPlanetRTS(1,0,RTSDISTANCE) = 1.442431079 * 149.597871
    ' Venus
    MicaPlanetRTS(1,1,TransitMin) = 13 * 60 + 5
    MicaPlanetRTS(1,1,TransitAlt) = 79
    MicaPlanetRTS(1,1,RiseMin) = 5 * 60 + 51
    MicaPlanetRTS(1,1,RizeAz) = 120
    MicaPlanetRTS(1,1,SetMin) = 20 * 60 + 20
    MicaPlanetRTS(1,1,SetAz) = 240
    MicaPlanetRTS(1,1,RTSMAGNITUDE) = -4
    MicaPlanetRTS(1,1,RTSSIZE) = 9.8
    MicaPlanetRTS(1,1,RTSDISTANCE) = 1.708376065 * 149.597871
    ' Mars
    MicaPlanetRTS(1,2,TransitMin) = 18 * 60 + 12
    MicaPlanetRTS(1,2,TransitAlt) = 61
    MicaPlanetRTS(1,2,RiseMin) = 11 * 60 + 53
    MicaPlanetRTS(1,2,RizeAz) = 98
    MicaPlanetRTS(1,2,SetMin) = 0 * 60 + 32
    MicaPlanetRTS(1,2,SetAz) = 262
    MicaPlanetRTS(1,2,RTSMAGNITUDE) = 0.6
    MicaPlanetRTS(1,2,RTSSIZE) = 6.9
    MicaPlanetRTS(1,2,RTSDISTANCE) = 1.359208542 * 149.597871
    ' Jupiter
    MicaPlanetRTS(1,3,TransitMin) = 17 * 60 + 23
    MicaPlanetRTS(1,3,TransitAlt) = 66
    MicaPlanetRTS(1,3,RiseMin) = 10 * 60 + 49
    MicaPlanetRTS(1,3,RizeAz) = 104
    MicaPlanetRTS(1,3,SetMin) = 23 * 60 + 56
    MicaPlanetRTS(1,3,SetAz) = 256
    MicaPlanetRTS(1,3,RTSMAGNITUDE) = -2.2
    MicaPlanetRTS(1,3,RTSSIZE) = 36.5
    MicaPlanetRTS(1,3,RTSDISTANCE) = 5.409038736 * 149.597871
    ' Saturn
    MicaPlanetRTS(1,4,TransitMin) = 2 * 60 + 24
    MicaPlanetRTS(1,4,TransitAlt) = 33
    MicaPlanetRTS(1,4,RiseMin) = 21 * 60 + 22
    MicaPlanetRTS(1,4,RizeAz) = 64
    MicaPlanetRTS(1,4,SetMin) = 7 * 60 + 22
    MicaPlanetRTS(1,4,SetAz) = 296
    MicaPlanetRTS(1,4,RTSMAGNITUDE) = -0.3
    MicaPlanetRTS(1,4,RTSSIZE) = 20.6
    MicaPlanetRTS(1,4,RTSDISTANCE) = 8.080079084 * 149.597871
    '15-05-2040) ==========================
   ' Mercury
    MicaPlanetRTS(2,0,TransitMin) = 13 * 60 + 18
    MicaPlanetRTS(2,0,TransitAlt) = 31
    MicaPlanetRTS(2,0,RiseMin) = 8 * 60 + 26
    MicaPlanetRTS(2,0,RizeAz) = 61
    MicaPlanetRTS(2,0,SetMin) = 18 * 60 + 10
    MicaPlanetRTS(2,0,SetAz) = 299
    MicaPlanetRTS(2,0,RTSMAGNITUDE) = -0.9
    MicaPlanetRTS(2,0,RTSSIZE) = 5.9
    MicaPlanetRTS(2,0,RTSDISTANCE) = 1.141891774 * 149.597871
    ' Venus
    MicaPlanetRTS(2,1,TransitMin) = 11 * 60 + 56
    MicaPlanetRTS(2,1,TransitAlt) = 38
    MicaPlanetRTS(2,1,RiseMin) = 6 * 60 + 42
    MicaPlanetRTS(2,1,RizeAz) = 69
    MicaPlanetRTS(2,1,SetMin) = 17 * 60 + 9
    MicaPlanetRTS(2,1,SetAz) = 291
    MicaPlanetRTS(2,1,RTSMAGNITUDE) = -3.9
    MicaPlanetRTS(2,1,RTSSIZE) = 9.7
    MicaPlanetRTS(2,1,RTSDISTANCE) = 1.726965330 * 149.597871
    ' Mars
    MicaPlanetRTS(2,2,TransitMin) = 17 * 60 + 19
    MicaPlanetRTS(2,2,TransitAlt) = 35
    MicaPlanetRTS(2,2,RiseMin) = 12 * 60 + 16
    MicaPlanetRTS(2,2,RizeAz) = 65
    MicaPlanetRTS(2,2,SetMin) = 22 * 60 + 22
    MicaPlanetRTS(2,2,SetAz) = 294
    MicaPlanetRTS(2,2,RTSMAGNITUDE) = 1.3
    MicaPlanetRTS(2,2,RTSSIZE) = 5.6
    MicaPlanetRTS(2,2,RTSDISTANCE) = 1.682016192 * 149.597871
    ' Jupiter
    MicaPlanetRTS(2,3,TransitMin) = 20 * 60 + 13
    MicaPlanetRTS(2,3,TransitAlt) = 51
    MicaPlanetRTS(2,3,RiseMin) = 14 * 60 + 24
    MicaPlanetRTS(2,3,RizeAz) = 85
    MicaPlanetRTS(2,3,SetMin) = 2 * 60 + 6
    MicaPlanetRTS(2,3,SetAz) = 275
    MicaPlanetRTS(2,3,RTSMAGNITUDE) = -2.2
    MicaPlanetRTS(2,3,RTSSIZE) = 40.2
    MicaPlanetRTS(2,3,RTSDISTANCE) = 4.915607044 * 149.597871
    ' Saturn
    MicaPlanetRTS(2,4,TransitMin) = 21 * 60 + 5
    MicaPlanetRTS(2,4,TransitAlt) = 55
    MicaPlanetRTS(2,4,RiseMin) = 15 * 60 + 4
    MicaPlanetRTS(2,4,RizeAz) = 90
    MicaPlanetRTS(2,4,SetMin) = 3 * 60 + 11
    MicaPlanetRTS(2,4,SetAz) = 270
    MicaPlanetRTS(2,4,RTSMAGNITUDE) = 0.7
    MicaPlanetRTS(2,4,RTSSIZE) = 18.7
    MicaPlanetRTS(2,4,RTSDISTANCE) = 8.899617891 * 149.597871
    '12-09-2045) ==========================
   ' Mercury
    MicaPlanetRTS(3,0,TransitMin) = 12 * 60 + 25
    MicaPlanetRTS(3,0,TransitAlt) = 51
    MicaPlanetRTS(3,0,RiseMin) = 6 * 60 + 34
    MicaPlanetRTS(3,0,RizeAz) = 85
    MicaPlanetRTS(3,0,SetMin) = 18 * 60 + 17
    MicaPlanetRTS(3,0,SetAz) = 275
    MicaPlanetRTS(3,0,RTSMAGNITUDE) = -1.6
    MicaPlanetRTS(3,0,RTSSIZE) = 4.8
    MicaPlanetRTS(3,0,RTSDISTANCE) = 1.387889833 * 149.597871
    ' Venus
    MicaPlanetRTS(3,1,TransitMin) = 14 * 60 + 50
    MicaPlanetRTS(3,1,TransitAlt) = 69
    MicaPlanetRTS(3,1,RiseMin) = 8 * 60 + 9
    MicaPlanetRTS(3,1,RizeAz) = 107
    MicaPlanetRTS(3,1,SetMin) = 21 * 60 + 32
    MicaPlanetRTS(3,1,SetAz) = 253
    MicaPlanetRTS(3,1,RTSMAGNITUDE) = -4.2
    MicaPlanetRTS(3,1,RTSSIZE) = 17.1
    MicaPlanetRTS(3,1,RTSDISTANCE) = 0.975484092 * 149.597871
    ' Mars
    MicaPlanetRTS(3,2,TransitMin) = 9 * 60 + 52
    MicaPlanetRTS(3,2,TransitAlt) = 37
    MicaPlanetRTS(3,2,RiseMin) = 4 * 60 + 42
    MicaPlanetRTS(3,2,RizeAz) = 68
    MicaPlanetRTS(3,2,SetMin) = 15 * 60 + 2
    MicaPlanetRTS(3,2,SetAz) = 292
    MicaPlanetRTS(3,2,RTSMAGNITUDE) = 1.7
    MicaPlanetRTS(3,2,RTSSIZE) = 4.1
    MicaPlanetRTS(3,2,RTSDISTANCE) = 2.299738892 * 149.597871
    ' Jupiter
    MicaPlanetRTS(3,3,TransitMin) = 23 * 60 + 20
    MicaPlanetRTS(3,3,TransitAlt) = 66
    MicaPlanetRTS(3,3,RiseMin) = 16 * 60 + 48
    MicaPlanetRTS(3,3,RizeAz) = 103
    MicaPlanetRTS(3,3,SetMin) = 5 * 60 + 56
    MicaPlanetRTS(3,3,SetAz) = 257
    MicaPlanetRTS(3,3,RTSMAGNITUDE) = -2.9
    MicaPlanetRTS(3,3,RTSSIZE) = 49.1
    MicaPlanetRTS(3,3,RTSDISTANCE) = 4.021097915 * 149.597871
    ' Saturn
    MicaPlanetRTS(3,4,TransitMin) = 17 * 60 + 7
    MicaPlanetRTS(3,4,TransitAlt) = 75
    MicaPlanetRTS(3,4,RiseMin) = 10 * 60 + 8
    MicaPlanetRTS(3,4,RizeAz) = 115
    MicaPlanetRTS(3,4,SetMin) = 0 * 60 + 10
    MicaPlanetRTS(3,4,SetAz) = 245
    MicaPlanetRTS(3,4,RTSMAGNITUDE) = 0.5
    MicaPlanetRTS(3,4,RTSSIZE) = 16.3
    MicaPlanetRTS(3,4,RTSDISTANCE) = 10.204912286 * 149.597871
    '11-10-2049) ==========================
   ' Mercury
    MicaPlanetRTS(4,0,TransitMin) = 12 * 60 + 26
    MicaPlanetRTS(4,0,TransitAlt) = 57
    MicaPlanetRTS(4,0,RiseMin) = 6 * 60 + 20
    MicaPlanetRTS(4,0,RizeAz) = 92
    MicaPlanetRTS(4,0,SetMin) = 18 * 60 + 34
    MicaPlanetRTS(4,0,SetAz) = 268
    MicaPlanetRTS(4,0,RTSMAGNITUDE) = -1.1
    MicaPlanetRTS(4,0,RTSSIZE) = 5.2
    MicaPlanetRTS(4,0,RTSDISTANCE) = 1.283872748 * 149.597871
    ' Venus
    MicaPlanetRTS(4,1,TransitMin) = 11 * 60 + 52
    MicaPlanetRTS(4,1,TransitAlt) = 53
    MicaPlanetRTS(4,1,RiseMin) = 5 * 60 + 55
    MicaPlanetRTS(4,1,RizeAz) = 88
    MicaPlanetRTS(4,1,SetMin) = 17 * 60 + 50
    MicaPlanetRTS(4,1,SetAz) = 272
    MicaPlanetRTS(4,1,RTSMAGNITUDE) = -3.9
    MicaPlanetRTS(4,1,RTSSIZE) = 10.6
    MicaPlanetRTS(4,1,RTSDISTANCE) = 1.574244881 * 149.597871
    ' Mars
    MicaPlanetRTS(4,2,TransitMin) = 11 * 60 + 41
    MicaPlanetRTS(4,2,TransitAlt) = 52
    MicaPlanetRTS(4,2,RiseMin) = 5 * 60 + 47
    MicaPlanetRTS(4,2,RizeAz) = 87
    MicaPlanetRTS(4,2,SetMin) = 17 * 60 + 36
    MicaPlanetRTS(4,2,SetAz) = 273
    MicaPlanetRTS(4,2,RTSMAGNITUDE) = 1.8
    MicaPlanetRTS(4,2,RTSSIZE) = 3.7
    MicaPlanetRTS(4,2,RTSDISTANCE) = 2.542329142 * 149.597871
    ' Jupiter
    MicaPlanetRTS(4,3,TransitMin) = 8 * 60 + 13
    MicaPlanetRTS(4,3,TransitAlt) = 35
    MicaPlanetRTS(4,3,RiseMin) = 3 * 60 + 9
    MicaPlanetRTS(4,3,RizeAz) = 66
    MicaPlanetRTS(4,3,SetMin) = 13 * 60 + 16
    MicaPlanetRTS(4,3,SetAz) = 294
    MicaPlanetRTS(4,3,RTSMAGNITUDE) = -2.1
    MicaPlanetRTS(4,3,RTSSIZE) = 36.8
    MicaPlanetRTS(4,3,RTSDISTANCE) = 5.358682125 * 149.597871
    ' Saturn
    MicaPlanetRTS(4,4,TransitMin) = 19 * 60 + 25
    MicaPlanetRTS(4,4,TransitAlt) = 77
    MicaPlanetRTS(4,4,RiseMin) = 12 * 60 + 18
    MicaPlanetRTS(4,4,RizeAz) = 117
    MicaPlanetRTS(4,4,SetMin) = 2 * 60 + 36
    MicaPlanetRTS(4,4,SetAz) = 243
    MicaPlanetRTS(4,4,RTSMAGNITUDE) = 0.5
    MicaPlanetRTS(4,4,RTSSIZE) = 16.8
    MicaPlanetRTS(4,4,RTSDISTANCE) = 9.901665136 * 149.597871
END SUB

SUB SetPlanetRTSMICADataTwo() 
   MATH SET 0, PlanetRTSMAXError()
    '06-04-2015
    ' Mercury
    MicaPlanetRTS(0,0,TransitMin) = 13 * 60 + 26
    MicaPlanetRTS(0,0,TransitAlt) = 41
    MicaPlanetRTS(0,0,RiseMin) = 7 * 60 + 1
    MicaPlanetRTS(0,0,RizeAz) = 83
    MicaPlanetRTS(0,0,SetMin) = 19 * 60 + 54
    MicaPlanetRTS(0,0,SetAz) = 278
    MicaPlanetRTS(0,0,RTSMAGNITUDE) = -1.6
    MicaPlanetRTS(0,0,RTSSIZE) = 5
    MicaPlanetRTS(0,0,RTSDISTANCE) = 1.344221373 * 149.597871
    ' Venus
    MicaPlanetRTS(0,1,TransitMin) = 16 * 60 + 3
    MicaPlanetRTS(0,1,TransitAlt) = 57
    MicaPlanetRTS(0,1,RiseMin) = 8 * 60 + 1
    MicaPlanetRTS(0,1,RizeAz) = 54
    MicaPlanetRTS(0,1,SetMin) = 0 * 60 + 3
    MicaPlanetRTS(0,1,SetAz) = 306
    MicaPlanetRTS(0,1,RTSMAGNITUDE) = -4
    MicaPlanetRTS(0,1,RTSSIZE) = 14.2
    MicaPlanetRTS(0,1,RTSDISTANCE) = 1.168823860 * 149.597871
    ' Mars
    MicaPlanetRTS(0,2,TransitMin) = 14 * 60 + 45
    MicaPlanetRTS(0,2,TransitAlt) = 50
    MicaPlanetRTS(0,2,RiseMin) = 7 * 60 + 29
    MicaPlanetRTS(0,2,RizeAz) = 67
    MicaPlanetRTS(0,2,SetMin) = 22 * 60 + 2
    MicaPlanetRTS(0,2,SetAz) = 293
    MicaPlanetRTS(0,2,RTSMAGNITUDE) = 1.4
    MicaPlanetRTS(0,2,RTSSIZE) = 3.9
    MicaPlanetRTS(0,2,RTSDISTANCE) = 2.384499089 * 149.597871
    ' Jupiter
    MicaPlanetRTS(0,3,TransitMin) = 21 * 60 + 36
    MicaPlanetRTS(0,3,TransitAlt) = 55
    MicaPlanetRTS(0,3,RiseMin) = 13 * 60 + 49
    MicaPlanetRTS(0,3,RizeAz) = 58
    MicaPlanetRTS(0,3,SetMin) = 5 * 60 + 27
    MicaPlanetRTS(0,3,SetAz) = 302
    MicaPlanetRTS(0,3,RTSMAGNITUDE) = -2.3
    MicaPlanetRTS(0,3,RTSSIZE) = 40.9
    MicaPlanetRTS(0,3,RTSDISTANCE) = 4.826999356 * 149.597871
    ' Saturn
    MicaPlanetRTS(0,4,TransitMin) = 4 * 60 + 49
    MicaPlanetRTS(0,4,TransitAlt) = 18
    MicaPlanetRTS(0,4,RiseMin) = 0 * 60 + 35
    MicaPlanetRTS(0,4,RizeAz) = 122
    MicaPlanetRTS(0,4,SetMin) = 9 * 60 + 3
    MicaPlanetRTS(0,4,SetAz) = 238
    MicaPlanetRTS(0,4,RTSMAGNITUDE) = 0.3
    MicaPlanetRTS(0,4,RTSSIZE) = 17.9
    MicaPlanetRTS(0,4,RTSDISTANCE) = 9.276046353 * 149.597871
    '25-12-2033) ==========================
   ' Mercury
    MicaPlanetRTS(1,0,TransitMin) = 12 * 60 + 41
    MicaPlanetRTS(1,0,TransitAlt) = 12
    MicaPlanetRTS(1,0,RiseMin) = 9 * 60 + 11
    MicaPlanetRTS(1,0,RizeAz) = 134
    MicaPlanetRTS(1,0,SetMin) = 16 * 60 + 11
    MicaPlanetRTS(1,0,SetAz) = 226
    MicaPlanetRTS(1,0,RTSMAGNITUDE) = -1.3
    MicaPlanetRTS(1,0,RTSSIZE) = 4.7
    MicaPlanetRTS(1,0,RTSDISTANCE) = 1.440589867 * 149.597871
    ' Venus
    MicaPlanetRTS(1,1,TransitMin) = 12 * 60 + 26
    MicaPlanetRTS(1,1,TransitAlt) = 13
    MicaPlanetRTS(1,1,RiseMin) = 8 * 60 + 45
    MicaPlanetRTS(1,1,RizeAz) = 131
    MicaPlanetRTS(1,1,SetMin) = 16 * 60 + 6
    MicaPlanetRTS(1,1,SetAz) = 229
    MicaPlanetRTS(1,1,RTSMAGNITUDE) = -4
    MicaPlanetRTS(1,1,RTSSIZE) = 9.8
    MicaPlanetRTS(1,1,RTSDISTANCE) = 1.708714401 * 149.597871
    ' Mars
    MicaPlanetRTS(1,2,TransitMin) = 17 * 60 + 30
    MicaPlanetRTS(1,2,TransitAlt) = 31
    MicaPlanetRTS(1,2,RiseMin) = 11 * 60 + 58
    MicaPlanetRTS(1,2,RizeAz) = 99
    MicaPlanetRTS(1,2,SetMin) = 23 * 60 + 4
    MicaPlanetRTS(1,2,SetAz) = 261
    MicaPlanetRTS(1,2,RTSMAGNITUDE) = 0.6
    MicaPlanetRTS(1,2,RTSSIZE) = 6.9
    MicaPlanetRTS(1,2,RTSDISTANCE) = 1.356939083 * 149.597871
    ' Jupiter
    MicaPlanetRTS(1,3,TransitMin) = 16 * 60 + 40
    MicaPlanetRTS(1,3,TransitAlt) = 25
    MicaPlanetRTS(1,3,RiseMin) = 11 * 60 + 38
    MicaPlanetRTS(1,3,RizeAz) = 108
    MicaPlanetRTS(1,3,SetMin) = 21 * 60 + 41
    MicaPlanetRTS(1,3,SetAz) = 252
    MicaPlanetRTS(1,3,RTSMAGNITUDE) = -2.2
    MicaPlanetRTS(1,3,RTSSIZE) = 36.5
    MicaPlanetRTS(1,3,RTSDISTANCE) = 5.418525814 * 149.597871
    ' Saturn
    MicaPlanetRTS(1,4,TransitMin) = 1 * 60 + 40
    MicaPlanetRTS(1,4,TransitAlt) = 58
    MicaPlanetRTS(1,4,RiseMin) = 17 * 60 + 22
    MicaPlanetRTS(1,4,RizeAz) = 51
    MicaPlanetRTS(1,4,SetMin) = 9 * 60 + 54
    MicaPlanetRTS(1,4,SetAz) = 309
    MicaPlanetRTS(1,4,RTSMAGNITUDE) = -0.3
    MicaPlanetRTS(1,4,RTSSIZE) = 20.6
    MicaPlanetRTS(1,4,RTSDISTANCE) = 8.077052014 * 149.597871
END SUB

SUB ResetPOSMAX() 
	MATH SET 0, PlanetPOSMAXError()
    MoonMaxErrorDistance = 0
END SUB



SUB SetPlanetPOSMICAData(nPlanet As Integer) 
   
     SELECT CASE nPlanet
    case MERCURY_TST
        '06-04-2015,12:30:00L, 03:00 UTC
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 349.88496
        MicaPlanetPOS(0,IALT) = 90 - 38.57245
        MicaPlanetPOS(0,IDISTANCE) = 1.344563234 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 0.7552812 ' hours
        MicaPlanetPOS(0,IDEC) = 3.349034 '  degrees
        MicaPlanetPOS(0,ILONG) = 359.41063
        MicaPlanetPOS(0,ILAT) = -5.28942
        MicaPlanetPOS(0,IMAGNITUDE) = -1.6
        MicaPlanetPOS(0,ISIZE) = 5
        MicaPlanetPOS(0,IEARTHLONG) = 195.79054 
        MicaPlanetPOS(0,IPLANETSUNDIST) = 0.355871500
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.00502594
       ' 25-12-2033,08:45:00, 24th 22:15 UTC
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 100.62432
        MicaPlanetPOS(1,IALT) = 90 - 59.11625
        MicaPlanetPOS(1,IDISTANCE) = 1.442913675 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 18.3057894
        MicaPlanetPOS(1,IDEC) = -25.003885
        MicaPlanetPOS(1,ILONG) = 275.29530
        MicaPlanetPOS(1,ILAT) = -5.13408
        MicaPlanetPOS(1,IMAGNITUDE) = -1.3
        MicaPlanetPOS(1,ISIZE) = 4.7
        MicaPlanetPOS(1,IEARTHLONG) = 92.94722
        MicaPlanetPOS(1,IPLANETSUNDIST) = 0.460860746
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983599267
        '15-05-2040,14:02:00, 4:32 UTC
        MicaPlanetPOS(2,dError) = 0
        MicaPlanetPOS(2,IAZIMUTH) = 348.43579
        MicaPlanetPOS(2,IALT) = 90 - 59.73387
        MicaPlanetPOS(2,IDISTANCE) = 1.141282407 * 149.597871
        MicaPlanetPOS(2,IRTASC) = 4.6084378
        MicaPlanetPOS(2,IDEC) = 24.060513
        MicaPlanetPOS(2,ILONG) = 129.27102
        MicaPlanetPOS(2,ILAT) = 6.91704
        MicaPlanetPOS(2,IMAGNITUDE) = -0.9
        MicaPlanetPOS(2,ISIZE) = 5.9
        MicaPlanetPOS(2,IEARTHLONG) = 234.41261
        MicaPlanetPOS(2,IPLANETSUNDIST) = 0.328923074
        MicaPlanetPOS(2,IEARTHSUNDIST) = 1.010913852
        '12-09-2045,22:16:00, 12:46 UTC
        MicaPlanetPOS(3,dError) = 0
        MicaPlanetPOS(3,IAZIMUTH) = 231.77939
        MicaPlanetPOS(3,IALT) = 90 - 136.83731
        MicaPlanetPOS(3,IDISTANCE) = 1.389020092 * 149.597871
        MicaPlanetPOS(3,IRTASC) = 11.6377408
        MicaPlanetPOS(3,IDEC) = 3.913997
        MicaPlanetPOS(3,ILONG) = 181.42264
        MicaPlanetPOS(3,ILAT) = 5.12051
        MicaPlanetPOS(3,IMAGNITUDE) = -1.5
        MicaPlanetPOS(3,ISIZE) = 4.8
        MicaPlanetPOS(3,IEARTHLONG) = 349.53523
        MicaPlanetPOS(3,IPLANETSUNDIST) = 0.389679217
        MicaPlanetPOS(3,IEARTHSUNDIST) = 1.006449770
        '11-10-2049,03:10:00, 10th 16:40 UTC
        MicaPlanetPOS(4,dError) = 0
        MicaPlanetPOS(4,IAZIMUTH) = 124.02938
        MicaPlanetPOS(4,IALT) = 90 - 127.45295
        MicaPlanetPOS(4,IDISTANCE) = 1.277384711 * 149.597871
        MicaPlanetPOS(4,IRTASC) = 12.4742109
        MicaPlanetPOS(4,IDEC) = -1.041941
        MicaPlanetPOS(4,ILONG) = 153.79759
        MicaPlanetPOS(4,ILAT) = 6.74877
        MicaPlanetPOS(4,IMAGNITUDE) = -1.1
        MicaPlanetPOS(4,ISIZE) = 5.3
        MicaPlanetPOS(4,IEARTHLONG) = 17.12733
        MicaPlanetPOS(4,IPLANETSUNDIST) = 0.353335305
        MicaPlanetPOS(4,IEARTHSUNDIST) = 0.998530746
    case VENUS_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 35.31162
        MicaPlanetPOS(0,IALT) = 90 - 63.02149
        MicaPlanetPOS(0,IDISTANCE) = 1.174033544 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 3.3880734 ' hours
        MicaPlanetPOS(0,IDEC) = 19.798238 '  degrees
        MicaPlanetPOS(0,ILONG) = 111.34696
        MicaPlanetPOS(0,ILAT) = 1.93428
        MicaPlanetPOS(0,IMAGNITUDE) = -4
        MicaPlanetPOS(0,ISIZE) = 14.2
        MicaPlanetPOS(0,IEARTHLONG) = 195.79054
        MicaPlanetPOS(0,IPLANETSUNDIST) = 0.718727155
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000502594
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 97.53299
        MicaPlanetPOS(1,IALT) = 90 - 56.86303
        MicaPlanetPOS(1,IDISTANCE) = 1.708315133 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 18.0716493
        MicaPlanetPOS(1,IDEC) = -23.696522
        MicaPlanetPOS(1,ILONG) = 267.23432
        MicaPlanetPOS(1,ILAT) = -0.62798
        MicaPlanetPOS(1,IMAGNITUDE) = -4
        MicaPlanetPOS(1,ISIZE) = 9.8
        MicaPlanetPOS(1,IEARTHLONG) = 92.94722
        MicaPlanetPOS(1,IPLANETSUNDIST) = 0.726841764
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983599267
        '15-05-2040,14:02:00
        MicaPlanetPOS(2,dError) = 0
        MicaPlanetPOS(2,IAZIMUTH) = 324.70208
        MicaPlanetPOS(2,IALT) = 90 - 60.00180
        MicaPlanetPOS(2,IDISTANCE) = 1.727051928 * 149.597871
        MicaPlanetPOS(2,IRTASC) = 3.2311941
        MicaPlanetPOS(2,IDEC) = 17.190310
        MicaPlanetPOS(2,ILONG) = 44.17286
        MicaPlanetPOS(2,ILAT) = -1.81996
        MicaPlanetPOS(2,IMAGNITUDE) = -3.9
        MicaPlanetPOS(2,ISIZE) = 9.7
        MicaPlanetPOS(2,IEARTHLONG) = 234.41261
        MicaPlanetPOS(2,IPLANETSUNDIST) = 0.723095923
        MicaPlanetPOS(2,IEARTHSUNDIST) = 1.010913852
        '12-09-2045,22:16:00
        MicaPlanetPOS(3,dError) = 0
        MicaPlanetPOS(3,IAZIMUTH) = 246.36515
        MicaPlanetPOS(3,IALT) = 90 - 98.96209
        MicaPlanetPOS(3,IDISTANCE) = 0.973222002 * 149.597871
        MicaPlanetPOS(3,IRTASC) = 14.0412312
        MicaPlanetPOS(3,IDEC) = -13.679240
        MicaPlanetPOS(3,ILONG) = 283.52389
        MicaPlanetPOS(3,ILAT) = -1.54080
        MicaPlanetPOS(3,IMAGNITUDE) = -4.2
        MicaPlanetPOS(3,ISIZE) = 17.1
        MicaPlanetPOS(3,IEARTHLONG) = 349.53523
        MicaPlanetPOS(3,IPLANETSUNDIST) = 0.727639683
        MicaPlanetPOS(3,IEARTHSUNDIST) = 1.006449770
        '11-10-2049,03:10:00
        MicaPlanetPOS(4,dError) = 0
        MicaPlanetPOS(4,IAZIMUTH) = 114.08011
        MicaPlanetPOS(4,IALT) = 90 - 123.68867
        MicaPlanetPOS(4,IDISTANCE) = 1.573030502 * 149.597871
        MicaPlanetPOS(4,IRTASC) = 11.9187469
        MicaPlanetPOS(4,IDEC) = 2.143810
        MicaPlanetPOS(4,ILONG) = 149.23436
        MicaPlanetPOS(4,ILAT) = 3.24083
        MicaPlanetPOS(4,IMAGNITUDE) = -3.9
        MicaPlanetPOS(4,ISIZE) = 10.6
        MicaPlanetPOS(4,IEARTHLONG) = 17.12733
        MicaPlanetPOS(4,IPLANETSUNDIST) = 0.718666307
        MicaPlanetPOS(4,IEARTHSUNDIST) = 0.998530746
     case MARS_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 18.31629
        MicaPlanetPOS(0,IALT) = 90 - 49.42387
        MicaPlanetPOS(0,IDISTANCE) = 2.381711057 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 2.1196675 ' hours
        MicaPlanetPOS(0,IDEC) = 12.792941 '  degrees
        MicaPlanetPOS(0,ILONG) = 46.02912
        MicaPlanetPOS(0,ILAT) = -0.11236
        MicaPlanetPOS(0,IMAGNITUDE) = 1.4
        MicaPlanetPOS(0,ISIZE) = 3.9
        MicaPlanetPOS(0,IEARTHLONG) = 195.79054
        MicaPlanetPOS(0,IPLANETSUNDIST) = 1.463464684
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000502594
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 130.92701
        MicaPlanetPOS(1,IALT) = 90 - 125.75114
        MicaPlanetPOS(1,IDISTANCE) = 1.356229311 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 23.1985561
        MicaPlanetPOS(1,IDEC) = -5.945171
        MicaPlanetPOS(1,ILONG) = 27.45407
        MicaPlanetPOS(1,ILAT) = -0.69214
        MicaPlanetPOS(1,IMAGNITUDE) = 0.6
        MicaPlanetPOS(1,ISIZE) = 6.9
        MicaPlanetPOS(1,IEARTHLONG) = 92.94722
        MicaPlanetPOS(1,IPLANETSUNDIST) = 1.426921723
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983599267
        '15-05-2040,14:02:00
        MicaPlanetPOS(2,dError) = 0
        MicaPlanetPOS(2,IAZIMUTH) = 48.32569
        MicaPlanetPOS(2,IALT) = 90 - 72.27123
        MicaPlanetPOS(2,IDISTANCE) = 1.680823535 * 149.597871
        MicaPlanetPOS(2,IRTASC) = 8.6258505
        MicaPlanetPOS(2,IDEC) = 20.280662
        MicaPlanetPOS(2,ILONG) = 161.17200
        MicaPlanetPOS(2,ILAT) = 1.71526
        MicaPlanetPOS(2,IMAGNITUDE) = 1.3
        MicaPlanetPOS(2,ISIZE) = 5.6
        MicaPlanetPOS(2,IEARTHLONG) = 234.41261
        MicaPlanetPOS(2,IPLANETSUNDIST) = 1.665476316
        MicaPlanetPOS(2,IEARTHSUNDIST) = 1.010913852
        '12-09-2045,22:16:00
        MicaPlanetPOS(3,dError) = 0
        MicaPlanetPOS(3,IAZIMUTH) = 160.15894
        MicaPlanetPOS(3,IALT) = 90 - 162.35666
        MicaPlanetPOS(3,IDISTANCE) = 2.297361816 * 149.597871
        MicaPlanetPOS(3,IRTASC) = 9.0507835
        MicaPlanetPOS(3,IDEC) = 18.011326
        MicaPlanetPOS(3,ILONG) = 110.17772
        MicaPlanetPOS(3,ILAT) = 1.61083
        MicaPlanetPOS(3,IMAGNITUDE) = 1.7
        MicaPlanetPOS(3,ISIZE) = 4.1
        MicaPlanetPOS(3,IEARTHLONG) = 349.53523
        MicaPlanetPOS(3,IPLANETSUNDIST) = 1.615068395
        MicaPlanetPOS(3,IEARTHSUNDIST) = 1.006449770
        '11-10-2049,03:10:00
        MicaPlanetPOS(4,dError) = 0
        MicaPlanetPOS(4,IAZIMUTH) = 111.41407
        MicaPlanetPOS(4,IALT) = 90 - 122.20137
        MicaPlanetPOS(4,IDISTANCE) = 2.543825128 * 149.597871
        MicaPlanetPOS(4,IRTASC) = 11.7477937
        MicaPlanetPOS(4,IDEC) = 2.860084
        MicaPlanetPOS(4,ILONG) = 161.43366
        MicaPlanetPOS(4,ILAT) = 1.71089
        MicaPlanetPOS(4,IMAGNITUDE) = 1.8
        MicaPlanetPOS(4,ISIZE) = 3.7
        MicaPlanetPOS(4,IEARTHLONG) = 17.12733
        MicaPlanetPOS(4,IPLANETSUNDIST) = 1.665476980
        MicaPlanetPOS(4,IEARTHSUNDIST) = 0.998530746
    case JUPITER_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 89.95177
        MicaPlanetPOS(0,IALT) = 90 - 122.63060
        MicaPlanetPOS(0,IDISTANCE) = 4.826625132 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 9.0232383 ' hours
        MicaPlanetPOS(0,IDEC) = 17.942545 '  degrees
        MicaPlanetPOS(0,ILONG) = 142.01467
        MicaPlanetPOS(0,ILAT) = 0.86398
        MicaPlanetPOS(0,IMAGNITUDE) = -2.3
        MicaPlanetPOS(0,ISIZE) = 40.8
        MicaPlanetPOS(0,IEARTHLONG) = 195.79054
        MicaPlanetPOS(0,IPLANETSUNDIST) = 5.349806678
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000502594
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 124.44869
        MicaPlanetPOS(1,IALT) = 90 - 113.82374
        MicaPlanetPOS(1,IDISTANCE) = 5.404212782 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 22.3843780
        MicaPlanetPOS(1,IDEC) = -11.230802
        MicaPlanetPOS(1,ILONG) = 342.82410
        MicaPlanetPOS(1,ILAT) = -1.15417
        MicaPlanetPOS(1,IMAGNITUDE) = -2.2
        MicaPlanetPOS(1,ISIZE) = 36.5
        MicaPlanetPOS(1,IEARTHLONG) = 92.94722
        MicaPlanetPOS(1,IPLANETSUNDIST) = 4.986364350
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983599267
        '15-05-2040,14:02:00
        MicaPlanetPOS(2,dError) = 0
        MicaPlanetPOS(2,IAZIMUTH) = 88.01660
        MicaPlanetPOS(2,IALT) = 90 - 95.08798
        MicaPlanetPOS(2,IDISTANCE) = 4.912040973 * 149.597871
        MicaPlanetPOS(2,IRTASC) = 11.5410538
        MicaPlanetPOS(2,IDEC) = 4.524804
        MicaPlanetPOS(2,ILONG) = 180.86291
        MicaPlanetPOS(2,ILAT) = 1.28526
        MicaPlanetPOS(2,IMAGNITUDE) = -2.2
        MicaPlanetPOS(2,ISIZE) = 40.1
        MicaPlanetPOS(2,IEARTHLONG) = 234.41261
        MicaPlanetPOS(2,IPLANETSUNDIST) = 5.444705785
        MicaPlanetPOS(2,IEARTHSUNDIST) = 1.010913852
        '12-09-2045,22:16:00
        MicaPlanetPOS(3,dError) = 0
        MicaPlanetPOS(3,IAZIMUTH) = 35.00059
        MicaPlanetPOS(3,IALT) = 90 - 28.10534
        MicaPlanetPOS(3,IDISTANCE) = 4.020924037 * 149.597871
        MicaPlanetPOS(3,IRTASC) = 22.5289636
        MicaPlanetPOS(3,IDEC) = -10.718582
        MicaPlanetPOS(3,ILONG) = 337.87744
        MicaPlanetPOS(3,ILAT) = -1.09666
        MicaPlanetPOS(3,IMAGNITUDE) = -2.9
        MicaPlanetPOS(3,ISIZE) = 49
        MicaPlanetPOS(3,IEARTHLONG) = 349.53523
        MicaPlanetPOS(3,IPLANETSUNDIST) = 5.001278958
        MicaPlanetPOS(3,IEARTHSUNDIST) = 1.006449770
        '11-10-2049,03:10:00
        MicaPlanetPOS(4,dError) = 0
        MicaPlanetPOS(4,IAZIMUTH) = 65.67986
        MicaPlanetPOS(4,IALT) = 90 - 90.32634
        MicaPlanetPOS(4,IDISTANCE) = 5.361869514 * 149.597871
        MicaPlanetPOS(4,IRTASC) = 8.2724499
        MicaPlanetPOS(4,IDEC) = 19.971819
        MicaPlanetPOS(4,ILONG) = 110.37446
        MicaPlanetPOS(4,ILAT) = 0.22147
        MicaPlanetPOS(4,IMAGNITUDE) = -2.1
        MicaPlanetPOS(4,ISIZE) = 36.8
        MicaPlanetPOS(4,IEARTHLONG) = 17.12733
        MicaPlanetPOS(4,IPLANETSUNDIST) = 5.211815813
        MicaPlanetPOS(4,IEARTHSUNDIST) = 0.998530746
     case SATURN_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 226.18015
        MicaPlanetPOS(0,IALT) = 90 - 111.18121
        MicaPlanetPOS(0,IDISTANCE) = 9.280118639 * 149.597871  
        MicaPlanetPOS(0,IRTASC) = 16.1974041 ' hours
        MicaPlanetPOS(0,IDEC) = -18.924885 '  degrees
        MicaPlanetPOS(0,ILONG) = 239.98320
        MicaPlanetPOS(0,ILAT) = 2.00265
        MicaPlanetPOS(0,IMAGNITUDE) = 0.3
        MicaPlanetPOS(0,ISIZE) = 17.9
        MicaPlanetPOS(0,IEARTHLONG) = 195.79054
        MicaPlanetPOS(0,IPLANETSUNDIST) = 9.970748106
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000502594
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 285.34746
        MicaPlanetPOS(1,IALT) = 90 - 106.54981
        MicaPlanetPOS(1,IDISTANCE) = 8.078941746 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 7.3679252
        MicaPlanetPOS(1,IDEC) = 21.767814
        MicaPlanetPOS(1,ILONG) = 106.84315
        MicaPlanetPOS(1,ILAT) = -0.29196
        MicaPlanetPOS(1,IMAGNITUDE) = -0.3
        MicaPlanetPOS(1,ISIZE) = 20.6
        MicaPlanetPOS(1,IEARTHLONG) = 92.94722
        MicaPlanetPOS(1,IPLANETSUNDIST) = 9.030274834
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983599267
        '15-05-2040,14:02:00
        MicaPlanetPOS(2,dError) = 0
        MicaPlanetPOS(2,IAZIMUTH) = 99.27157
        MicaPlanetPOS(2,IALT) = 90 - 103.30593
        MicaPlanetPOS(2,IDISTANCE) = 8.895949477 * 149.597871
        MicaPlanetPOS(2,IRTASC) = 12.4150641
        MicaPlanetPOS(2,IDEC) = 0.139770
        MicaPlanetPOS(2,ILONG) = 189.69012
        MicaPlanetPOS(2,ILAT) = 2.41431
        MicaPlanetPOS(2,IMAGNITUDE) = 0.7
        MicaPlanetPOS(2,ISIZE) = 18.7
        MicaPlanetPOS(2,IEARTHLONG) = 234.41261
        MicaPlanetPOS(2,IPLANETSUNDIST) = 9.585045085
        MicaPlanetPOS(2,IEARTHSUNDIST) = 1.010913852
        '12-09-2045,22:16:00
        MicaPlanetPOS(3,dError) = 0
        MicaPlanetPOS(3,IAZIMUTH) = 260.10895
        MicaPlanetPOS(3,IALT) = 90 - 68.86356
        MicaPlanetPOS(3,IDISTANCE) = 10.208394073 * 149.597871
        MicaPlanetPOS(3,IRTASC) = 16.3026776
        MicaPlanetPOS(3,IDEC) = -19.708635
        MicaPlanetPOS(3,ILONG) = 251.07800
        MicaPlanetPOS(3,ILAT) = 1.67892
        MicaPlanetPOS(3,IMAGNITUDE) = 0.5
        MicaPlanetPOS(3,ISIZE) = 16.3
        MicaPlanetPOS(3,IEARTHLONG) = 349.53523
        MicaPlanetPOS(3,IPLANETSUNDIST) = 10.011796905
        MicaPlanetPOS(3,IEARTHSUNDIST) = 1.006449770
        '11-10-2049,03:10:00
        MicaPlanetPOS(4,dError) = 0
        MicaPlanetPOS(4,IAZIMUTH) = 237.42574
        MicaPlanetPOS(4,IALT) = 90 - 96.66288
        MicaPlanetPOS(4,IDISTANCE) = 9.890498352 * 149.597871
        MicaPlanetPOS(4,IRTASC) = 19.5136669
        MicaPlanetPOS(4,IDEC) = -21.908845
        MicaPlanetPOS(4,ILONG) = 296.01115
        MicaPlanetPOS(4,ILAT) = -0.10885
        MicaPlanetPOS(4,IMAGNITUDE) = 0.5
        MicaPlanetPOS(4,ISIZE) = 16.8
        MicaPlanetPOS(4,IEARTHLONG) = 17.12733
        MicaPlanetPOS(4,IPLANETSUNDIST) = 9.995371646
        MicaPlanetPOS(4,IEARTHSUNDIST) = 0.998530746
    case SUN_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 355.63550
        MicaPlanetPOS(0,IALT) = 90 - 41.15151
        MicaPlanetPOS(0,IDISTANCE) = 1.000470439 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 0.9825839 ' hours
        MicaPlanetPOS(0,IDEC) = 6.294750 '  degrees
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 98.53058
        MicaPlanetPOS(1,IALT) = 90 - 59.16185
        MicaPlanetPOS(1,IDISTANCE) = 0.983577455 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 18.2483519
        MicaPlanetPOS(1,IDEC) = -23.386869
        '15-05-2040,14:02:00
        MicaPlanetPOS(2,dError) = 0
        MicaPlanetPOS(2,IAZIMUTH) = 329.71253
        MicaPlanetPOS(2,IALT) = 90 - 59.76239
        MicaPlanetPOS(2,IDISTANCE) = 1.010892304 * 149.597871
        MicaPlanetPOS(2,IRTASC) = 3.5076798
        MicaPlanetPOS(2,IDEC) = 19.006957
        '12-09-2045,22:16:00
        MicaPlanetPOS(3,dError) = 0
        MicaPlanetPOS(3,IAZIMUTH) = 227.58587
        MicaPlanetPOS(3,IALT) = 90 - 139.07678
        MicaPlanetPOS(3,IDISTANCE) = 1.006482006 * 149.597871
        MicaPlanetPOS(3,IRTASC) = 11.3977864
        MicaPlanetPOS(3,IDEC) = 3.894132
        '11-10-2049,03:10:00
        MicaPlanetPOS(4,dError) = 0
        MicaPlanetPOS(4,IAZIMUTH) = 137.97609
        MicaPlanetPOS(4,IALT) = 90 - 128.56512
        MicaPlanetPOS(4,IDISTANCE) = 0.998557374 * 149.597871
        MicaPlanetPOS(4,IRTASC) = 13.0956662
        MicaPlanetPOS(4,IDEC) = -6.988582
    case MOON_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 199.95517
        MicaPlanetPOS(0,IALT) = 90 - 132.93717
        MicaPlanetPOS(0,IDISTANCE) = 399002.480
        MicaPlanetPOS(0,IRTASC) = 14.1555024 ' hours
        MicaPlanetPOS(0,IDEC) = -10.186979 '  degrees
        MicaPlanetPOS(0,ILONG) = 214.03295
        MicaPlanetPOS(0,ILAT) = 2.16014
        MicaPlanetPOS(0,IMOON_ILLUM) = 0.976
        MicaPlanetPOS(0,IMOON_POS_ANGLE) = 103.00
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 110.52415
        MicaPlanetPOS(1,IALT) = 90 - 96.62256
        MicaPlanetPOS(1,IDISTANCE) = 381268.508
        MicaPlanetPOS(1,IRTASC) = 20.9026221
        MicaPlanetPOS(1,ILONG) = 311.49383
        MicaPlanetPOS(1,ILAT) = 4.17855
        MicaPlanetPOS(1,IDEC) = -12.728319
        MicaPlanetPOS(1,IMOON_ILLUM) = 0.113
        MicaPlanetPOS(1,IMOON_POS_ANGLE) = 248.98
        '15-05-2040,14:02:00
        MicaPlanetPOS(2,dError) = 0
        MicaPlanetPOS(2,IAZIMUTH) = 21.02287
        MicaPlanetPOS(2,IALT) = 90 - 64.94702
        MicaPlanetPOS(2,IDISTANCE) = 404787.115
        MicaPlanetPOS(2,IRTASC) = 6.7625682
        MicaPlanetPOS(2,IDEC) = 26.948669
        MicaPlanetPOS(2,ILONG) = 99.99710
        MicaPlanetPOS(2,ILAT) = 3.12921
        MicaPlanetPOS(2,IMOON_ILLUM) = 0.149
        MicaPlanetPOS(2,IMOON_POS_ANGLE) = 271.29
        '12-09-2045,22:16:00
        MicaPlanetPOS(3,dError) = 0
        MicaPlanetPOS(3,IAZIMUTH) = 234.96572
        MicaPlanetPOS(3,IALT) = 90 - 119.89743
        MicaPlanetPOS(3,IDISTANCE) = 364081.065
        MicaPlanetPOS(3,IRTASC) = 12.5099386
        MicaPlanetPOS(3,IDEC) = -7.157414
        MicaPlanetPOS(3,ILONG) = 190.64498
        MicaPlanetPOS(3,ILAT) = -3.89391
        MicaPlanetPOS(3,IMOON_ILLUM) = 0.030
        MicaPlanetPOS(3,IMOON_POS_ANGLE) = 303.55
        '11-10-2049,03:10:00
        MicaPlanetPOS(4,dError) = 0
        MicaPlanetPOS(4,IAZIMUTH) = 312.30312
        MicaPlanetPOS(4,IALT) = 90 - 57.29470
        MicaPlanetPOS(4,IDISTANCE) = 370842.464
        MicaPlanetPOS(4,IRTASC) = 0.6132847
        MicaPlanetPOS(4,IDEC) = 9.040858
        MicaPlanetPOS(4,ILONG) = 12.22109
        MicaPlanetPOS(4,ILAT) = 3.86958
        MicaPlanetPOS(4,IMOON_ILLUM) = 0.996
        MicaPlanetPOS(4,IMOON_POS_ANGLE) = 281.35
    END SELECT
END SUB

SUB SetPlanetPOSMICADataTwo(nPlanet As Integer) 
	SELECT CASE nPlanet
    case MERCURY_TST
        '06-04-2015,12:30:00, 18:30 UTC
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 161.81475
        MicaPlanetPOS(0,IALT) = 90 - 50.78878
        MicaPlanetPOS(0,IDISTANCE) = 1.344254651 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 0.8330295 ' hours
        MicaPlanetPOS(0,IDEC) = 3.925760 '  degrees
        MicaPlanetPOS(0,ILONG) = 2.50474
        MicaPlanetPOS(0,ILAT) = -5.03401
        MicaPlanetPOS(0,IMAGNITUDE) = -1.6
        MicaPlanetPOS(0,ISIZE) = 5
        MicaPlanetPOS(0,IEARTHLONG) = 196.42598
        MicaPlanetPOS(0,IPLANETSUNDIST) = 0.352220055
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000689637
        ' 25-12-2033,08:45:00, 15:45 UTC
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 128.97480
        MicaPlanetPOS(1,IALT) = 90 - 93.45908
        MicaPlanetPOS(1,IDISTANCE) = 1.441055304 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 18.3912763
        MicaPlanetPOS(1,IDEC) = -25.014627
        MicaPlanetPOS(1,ILONG) = 277.36334
        MicaPlanetPOS(1,ILAT) = -5.30251
        MicaPlanetPOS(1,IMAGNITUDE) = -1.3
        MicaPlanetPOS(1,ISIZE) = 4.7
        MicaPlanetPOS(1,IEARTHLONG) = 93.69021
        MicaPlanetPOS(1,IPLANETSUNDIST) = 0.459479626
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983560084
     case VENUS_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 108.28780
        MicaPlanetPOS(0,IALT) = 90 - 52.33678
        MicaPlanetPOS(0,IDISTANCE) = 1.169800150 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 3.4396918 ' hours
        MicaPlanetPOS(0,IDEC) = 20.019214 '  degrees
        MicaPlanetPOS(0,ILONG) = 112.39437
        MicaPlanetPOS(0,ILAT) = 1.98497
        MicaPlanetPOS(0,IMAGNITUDE) = -4
        MicaPlanetPOS(0,ISIZE) = 14.2
        MicaPlanetPOS(0,IEARTHLONG) = 196.42598
        MicaPlanetPOS(0,IPLANETSUNDIST) = 0.718697836
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000689637
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 131.31739
        MicaPlanetPOS(1,IALT) = 90 - 90.60682
        MicaPlanetPOS(1,IDISTANCE) = 1.708651294 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 18.1384701
        MicaPlanetPOS(1,IDEC) = -23.716857
        MicaPlanetPOS(1,ILONG) = 268.38927
        MicaPlanetPOS(1,ILAT) = -0.69515
        MicaPlanetPOS(1,IMAGNITUDE) = -4
        MicaPlanetPOS(1,ISIZE) = 9.8
        MicaPlanetPOS(1,IEARTHLONG) = 93.69021
        MicaPlanetPOS(1,IPLANETSUNDIST) = 0.726910881
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983560084
    case MARS_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 133.62229
        MicaPlanetPOS(0,IALT) = 90 - 48.46722
        MicaPlanetPOS(0,IDISTANCE) = 2.384149835 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 2.1501272 ' hours
        MicaPlanetPOS(0,IDEC) = 12.958709 '  degrees
        MicaPlanetPOS(0,ILONG) = 46.39398
        MicaPlanetPOS(0,ILAT) = -0.10060
        MicaPlanetPOS(0,IMAGNITUDE) = 1.4
        MicaPlanetPOS(0,ISIZE) = 3.9
        MicaPlanetPOS(0,IEARTHLONG) = 196.42598
        MicaPlanetPOS(0,IPLANETSUNDIST) = 1.464259448
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000689637
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 57.78510
        MicaPlanetPOS(1,IALT) = 90 - 118.24676
        MicaPlanetPOS(1,IDISTANCE) = 1.361838263 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 23.2302842
        MicaPlanetPOS(1,IDEC) = -5.729887
        MicaPlanetPOS(1,ILONG) = 27.88746
        MicaPlanetPOS(1,ILAT) = -0.67917
        MicaPlanetPOS(1,IMAGNITUDE) = 0.6
        MicaPlanetPOS(1,ISIZE) = 6.9
        MicaPlanetPOS(1,IEARTHLONG) = 93.69021
        MicaPlanetPOS(1,IPLANETSUNDIST) = 1.427668625
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983560084
    case JUPITER_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 41.26827
        MicaPlanetPOS(0,IALT) = 90 - 99.60268
        MicaPlanetPOS(0,IDISTANCE) = 4.835860936 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 9.0229009 ' hours
        MicaPlanetPOS(0,IDEC) = 17.942373 '  degrees
        MicaPlanetPOS(0,ILONG) = 142.06536
        MicaPlanetPOS(0,ILAT) = 0.86484
        MicaPlanetPOS(0,IMAGNITUDE) = -2.3
        MicaPlanetPOS(0,ISIZE) = 40.8
        MicaPlanetPOS(0,IEARTHLONG) = 196.42598
        MicaPlanetPOS(0,IPLANETSUNDIST) = 5.349995375
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000689637
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 72.83616
        MicaPlanetPOS(1,IALT) = 90 - 116.01783
        MicaPlanetPOS(1,IDISTANCE) = 5.414076387 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 22.3924520
        MicaPlanetPOS(1,IDEC) = -11.183730
        MicaPlanetPOS(1,ILONG) = 342.88999
        MicaPlanetPOS(1,ILAT) = -1.15487
        MicaPlanetPOS(1,IMAGNITUDE) = -2.2
        MicaPlanetPOS(1,ISIZE) = 36.5
        MicaPlanetPOS(1,IEARTHLONG) = 93.69021
        MicaPlanetPOS(1,IPLANETSUNDIST) = 4.986226220
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983560084
    case SATURN_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 278.91618
        MicaPlanetPOS(0,IALT) = 90 - 120.22678
        MicaPlanetPOS(0,IDISTANCE) = 9.272079049 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 16.1957839 ' hours
        MicaPlanetPOS(0,IDEC) = -18.919643 '  degrees
        MicaPlanetPOS(0,ILONG) = 240.00296
        MicaPlanetPOS(0,ILAT) = 2.00214
        MicaPlanetPOS(0,IMAGNITUDE) = 0.3
        MicaPlanetPOS(0,ISIZE) = 17.9
        MicaPlanetPOS(0,IEARTHLONG) = 196.42598
        MicaPlanetPOS(0,IPLANETSUNDIST) = 9.970855794
        MicaPlanetPOS(0,IEARTHSUNDIST) = 1.000689637
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 295.93436
        MicaPlanetPOS(1,IALT) = 90 - 81.92486
        MicaPlanetPOS(1,IDISTANCE) = 8.075808388 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 7.3638891
        MicaPlanetPOS(1,IDEC) = 21.776524
        MicaPlanetPOS(1,ILONG) = 106.87030
        MicaPlanetPOS(1,ILAT) = -0.29079
        MicaPlanetPOS(1,IMAGNITUDE) = -0.3
        MicaPlanetPOS(1,ISIZE) = 20.6
        MicaPlanetPOS(1,IEARTHLONG) = 93.69021
        MicaPlanetPOS(1,IPLANETSUNDIST) = 9.030331877
        MicaPlanetPOS(1,IEARTHSUNDIST) = 0.983560084
    case SUN_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 157.48902
        MicaPlanetPOS(0,IALT) = 90 - 48.82347
        MicaPlanetPOS(0,IDISTANCE) = 1.000689637 * 149.597871
        MicaPlanetPOS(0,IRTASC) = 1.0219775 ' hours
        MicaPlanetPOS(0,IDEC) = 6.535462 '  degrees
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 129.18920
        MicaPlanetPOS(1,IALT) = 90 - 91.42274
        MicaPlanetPOS(1,IDISTANCE) = 0.983560084 * 149.597871
        MicaPlanetPOS(1,IRTASC) = 18.3022490
        MicaPlanetPOS(1,IDEC) = -23.368758
    case MOON_TST
        '06-04-2015,12:30:00
        MicaPlanetPOS(0,dError) = 0
        MicaPlanetPOS(0,IAZIMUTH) = 304.65943
        MicaPlanetPOS(0,IALT) = 90 - 128.29374
        MicaPlanetPOS(0,IDISTANCE) = 397153.889
        MicaPlanetPOS(0,IRTASC) = 14.6693354 ' hours
        MicaPlanetPOS(0,IDEC) = -13.370995 '  degrees
        MicaPlanetPOS(0,ILONG) = 221.97007
        MicaPlanetPOS(0,ILAT) = 2.80743
        MicaPlanetPOS(0,IMOON_ILLUM) = 0.952
        MicaPlanetPOS(0,IMOON_POS_ANGLE) = 101.74
        ' 25-12-2033,08:45:00
        MicaPlanetPOS(1,dError) = 0
        MicaPlanetPOS(1,IAZIMUTH) = 84.07011
        MicaPlanetPOS(1,IALT) = 90 - 108.92596
        MicaPlanetPOS(1,IDISTANCE) = 379141.400
        MicaPlanetPOS(1,IRTASC) = 21.5386173
        MicaPlanetPOS(1,IDEC) = -11.658406
        MicaPlanetPOS(1,ILONG) = 321.32343
        MicaPlanetPOS(1,ILAT) = 3.64291
        MicaPlanetPOS(1,IMOON_ILLUM) = 0.161
        MicaPlanetPOS(1,IMOON_POS_ANGLE) = 248.20
    END SELECT
END SUB

SUB SetSunMoonTestCmnds() 
    TestCmnds(0) = "3,06-04-2023"
    TestCmnds(1) = "3,20-06-2023"
    TestCmnds(2) = "3,25-12-2023"
    TestCmnds(3) = "3,20-12-2029"
    TestCmnds(4) = "3,15-05-2033"
    TestCmnds(5) = "3,30-07-2035"
    TestCmnds(6) = "3,12-09-2015"
    TestCmnds(7) = "3,21-03-2040"
    TestCmnds(8) = "3,11-10-2045"
    TestCmnds(9) = "3,31-12-2049"
END SUB

SUB SetSunMoonTestCmndsTwo() 
    TestCmnds(0) = "3,06-04-2023"
    TestCmnds(1) = "3,25-12-2023"
    TestCmnds(2) = "3,20-12-2029"
    TestCmnds(3) = "3,15-05-2033"
END SUB


SUB SetMoonPhaseTestCmnds() 
    TestCmnds(0) = "6,06-05-2023" ' penumbra
    TestCmnds(1) = "6,29-10-2023" 'partial lunar
    TestCmnds(2) = "6,25-03-2024" ' partial
    TestCmnds(3) = "6,07-09-2025" ' total
    TestCmnds(4) = "6,03-03-2026"' total
    TestCmnds(5) = "6,01-01-2029" ' total
    TestCmnds(6) = "6,26-05-2040"' total
    TestCmnds(7) = "6,17-05-2049" ' partial
    TestCmnds(8) = "6,11-10-2045" ' nil
    TestCmnds(9) = "6,31-12-2049" ' nil
END SUB

SUB SetMoonPhaseTestCmndsTwo() 
    TestCmnds(0) = "6,06-09-2024" ' partial lunar
    TestCmnds(1) = "6,03-01-2028" 'partial lunar
    TestCmnds(2) = "6,25-10-2033" ' Full lunar
    TestCmnds(3) = "6,07-03-2045" ' penumbra
END SUB

SUB SetSeasonTestCmnds() 
    TestCmnds(0) = "7,01-01-2015"
    TestCmnds(1) = "7,15-01-2023"
    TestCmnds(2) = "7,08-05-2029"
    TestCmnds(3) = "7,15-09-2032"
    TestCmnds(4) = "7,01-12-2048"
END SUB

SUB SetPlanetRTSTestCmnds()
    TestCmnds(0) = "15,06-04-2015"
    TestCmnds(1) = "15,25-12-2033"
    TestCmnds(2) = "15,15-05-2040"
    TestCmnds(3) = "15,12-09-2045"
    TestCmnds(4) = "15,11-10-2049"
END SUB

SUB SetPlanetRTSTestCmndsTwo()
    TestCmnds(0) = "15,06-04-2015"
    TestCmnds(1) = "15,25-12-2033"
END SUB

SUB SetObjectPOSTestCmnds(nObject As Integer) 
    SELECT CASE nObject
    case MERCURY_TST
        TestCmnds(0) = "10,06-04-2015,12:30:00"
        TestCmnds(1) = "10,25-12-2033,08:45:00"
        TestCmnds(2) = "10,15-05-2040,14:02:00"
        TestCmnds(3) = "10,12-09-2045,22:16:00"
        TestCmnds(4) = "10,11-10-2049,03:10:00"
    case VENUS_TST
        TestCmnds(0) = "11,06-04-2015,12:30:00"
        TestCmnds(1) = "11,25-12-2033,08:45:00"
        TestCmnds(2) = "11,15-05-2040,14:02:00"
        TestCmnds(3) = "11,12-09-2045,22:16:00"
        TestCmnds(4) = "11,11-10-2049,03:10:00"
    case MARS_TST
        TestCmnds(0) = "12,06-04-2015,12:30:00"
        TestCmnds(1) = "12,25-12-2033,08:45:00"
        TestCmnds(2) = "12,15-05-2040,14:02:00"
        TestCmnds(3) = "12,12-09-2045,22:16:00"
        TestCmnds(4) = "12,11-10-2049,03:10:00"
    case JUPITER_TST
        TestCmnds(0) = "13,06-04-2015,12:30:00"
        TestCmnds(1) = "13,25-12-2033,08:45:00"
        TestCmnds(2) = "13,15-05-2040,14:02:00"
        TestCmnds(3) = "13,12-09-2045,22:16:00"
        TestCmnds(4) = "13,11-10-2049,03:10:00"
    case SATURN_TST
        TestCmnds(0) = "14,06-04-2015,12:30:00"
        TestCmnds(1) = "14,25-12-2033,08:45:00"
        TestCmnds(2) = "14,15-05-2040,14:02:00"
        TestCmnds(3) = "14,12-09-2045,22:16:00"
        TestCmnds(4) = "14,11-10-2049,03:10:00"
    case SUN_TST
        TestCmnds(0) = "8,06-04-2015,12:30:00"
        TestCmnds(1) = "8,25-12-2033,08:45:00"
        TestCmnds(2) = "8,15-05-2040,14:02:00"
        TestCmnds(3) = "8,12-09-2045,22:16:00"
        TestCmnds(4) = "8,11-10-2049,03:10:00"
    case MOON_TST
        TestCmnds(0) = "9,06-04-2015,12:30:00"
        TestCmnds(1) = "9,25-12-2033,08:45:00"
        TestCmnds(2) = "9,15-05-2040,14:02:00"
        TestCmnds(3) = "9,12-09-2045,22:16:00"
        TestCmnds(4) = "9,11-10-2049,03:10:00"
    END SELECT
END SUB

SUB SetObjectPOSTestCmndsTwo(nObject As Integer) 
    SELECT CASE nObject
    case MERCURY_TST
        TestCmnds(0) = "10,06-04-2015,12:30:00"
        TestCmnds(1) = "10,25-12-2033,08:45:00"
     case VENUS_TST
        TestCmnds(0) = "11,06-04-2015,12:30:00"
        TestCmnds(1) = "11,25-12-2033,08:45:00"
    case MARS_TST
        TestCmnds(0) = "12,06-04-2015,12:30:00"
        TestCmnds(1) = "12,25-12-2033,08:45:00"
    case JUPITER_TST
        TestCmnds(0) = "13,06-04-2015,12:30:00"
        TestCmnds(1) = "13,25-12-2033,08:45:00"
    case SATURN_TST
        TestCmnds(0) = "14,06-04-2015,12:30:00"
        TestCmnds(1) = "14,25-12-2033,08:45:00"
    case SUN_TST
        TestCmnds(0) = "8,06-04-2015,12:30:00"
        TestCmnds(1) = "8,25-12-2033,08:45:00"
    case MOON_TST
        TestCmnds(0) = "9,06-04-2015,12:30:00"
        TestCmnds(1) = "9,25-12-2033,08:45:00"
    END SELECT
END SUB

FUNCTION GetTestCmndStr(nIndex As Integer) AS String
    ' returns command 
	GetTestCmndStr = TestCmnds(nIndex)
END FUNCTION

FUNCTION GetYearlyCmnd(nIndex As Integer, nType As Integer) As String
    ' assumes same as index as
    SELECT CASE nType
    case SUN_MOON_RTS
        GetYearlyCmnd = "2," + MID$(TestCmnds(nIndex),3)
    case MOON_PHASES
       GetYearlyCmnd = "2," + MID$(TestCmnds(nIndex),3)
    case SEASONS
        GetYearlyCmnd = "2," + MID$(TestCmnds(nIndex),3)
    case PLANET_RTS_POS_TST
        GetYearlyCmnd = "2," + MID$(TestCmnds(nIndex),4)
    END SELECT
END FUNCTION   

FUNCTION ConvertHMString(csHM As String) As Integer
    ' convert "HH:MM" to mins
    ' assumes trimmed
	'? "ConvertHMS In ", csHM '################################################
	'? "Hrs = ", VAL(Left$(csHM,2)) * 60
	'? "Mins = ", VAL(MID$(csHM,4,2))
	ConvertHMString = VAL(Left$(csHM,2)) * 60 + VAL(MID$(csHM,4,2))
END FUNCTION

FUNCTION TrimSpace(sInStr As String) As String
	' will trim all chars <= to space
	LOCAL As Integer nCount = 1
	DO While ASC(Left$(sInStr,1)) <= 32 AND nCount <= LEN(sInStr)
		INC nCount
		'if nCount > LEN(sInStr) Then EXIT DO
		sInStr = MID$(sInStr,2)
	LOOP
	TrimSpace = sInStr
END FUNCTION

SUB ExtractSunMoonRTS(csRTS_SM As String, S_RTS_SM() As Float) 
	'fills parsed array with the data 
    LOCAL As Integer nCount=1 ' starts at error code
	LOCAL As String sField
    sField = FIELD$(csRTS_SM, nCount, ",")
    sField = TrimSpace(sField)
    DO WHILE sField <> ""
        If sField= "NIL" Then
           S_RTS_SM(nCount - 1) = 0
        Else 
            If (NOT(nCount AND 1) AND (nCount < 22)) OR nCount = 9 OR nCount = 11 OR nCount = 13 Then
                S_RTS_SM(nCount - 1) = ConvertHMString(sField)
           Else 
                S_RTS_SM(nCount - 1) = VAL(sField)
            End If
        End If
		INC nCount
		sField = FIELD$(csRTS_SM, nCount, ",")
        sField = TrimSpace(sField)
        if nCount = 23 Then EXIT DO 'failsafe
    LOOP 
END SUB

SUB ExtractDate(sInString As String, sDateTime() As Float)
	' fills date part of sDateTime from input string "DD-MM-YYYY"
	sDateTime(m_dDay) = VAL(Left$(sInString,2))
	sDateTime(m_dMonth) = VAL(MID$(sInString,4,2))
	sDateTime(m_dYear) = VAL(MID$(sInString,7,4))
END SUB

SUB ExtractTime(sInString As String, sDateTime() As Float)
	' fills time part of sDateTime from input string "HH:MM:SS" 
	sDateTime(m_dHour) = VAL(Left$(sInString,2))
	sDateTime(m_dMin) = VAL(MID$(sInString,4,2))
	sDateTime(m_dSec) = VAL(MID$(sInString,7,4))
END SUB


SUB ExtractMoonPhase(csMoonPhase As String,S_MoonPhase() As Float) 
	'fills parsed array with the data 
    LOCAL As Integer nCount=1' starts at error code
	LOCAL As String sField
	LOCAL AS Float sDateTime(5)
    S_MoonPhase(EclipseDateJD) = NO_ECLIPSE_OR_NOT_VISIBLE ' default it
    S_MoonPhase(Time1) = 0
    S_MoonPhase(Time2) = 0
    S_MoonPhase(Time2) = 0
    S_MoonPhase(Time4) = 0
    S_MoonPhase(Time5) = 0
    S_MoonPhase(Time6) = 0
    S_MoonPhase(Time7) = 0
    sField = FIELD$(csMoonPhase, nCount, ",")
    sField = TrimSpace(sField)
    DO WHILE sField <> ""
		
		SELECT CASE nCount
			Case 1 
				S_MoonPhase(dError)= VAL(sField)
			Case 2,4,6,8,11
				ExtractDate sField, sDateTime()
			Case 10
				S_MoonPhase(AdditionalPhaseType) = VAL(sField)
			Case 3,5,7,9,12	
				ExtractTime sField, sDateTime()
				sDateTime(m_dSec) = 0	 ' dont compare seconds
				SELECT CASE nCount
					case 3
						S_MoonPhase(NewMoonJD) = TestCalcJD(sDateTime())
					case 5
						S_MoonPhase(FirstQuarterJD) = TestCalcJD(sDateTime())
					case 7
						S_MoonPhase(FullMoonJD) = TestCalcJD(sDateTime())
					case 9
						S_MoonPhase(LastQuarterJD) = TestCalcJD(sDateTime())
					case 12
						S_MoonPhase(AdditionalDateJD) = TestCalcJD(sDateTime())
				END SELECT
			CASE 13
				If sField = "NIL" Then 
					S_MoonPhase(EclipseDateJD) = cJAN1901_JD
					EXIT SUB ' no Eclipse so do no more
				Else
					sDateTime(m_dHour) = 0
					sDateTime(m_dMin) = 0
					sDateTime(m_dSec) = 0
					ExtractDate sField,sDateTime()
					S_MoonPhase(EclipseDateJD) = TestCalcJD(sDateTime())
				End If
			Case 14  ' Umbra Mag
				S_MoonPhase(UmbraMag) = VAL(sField)
				TempUmbraMag = S_MoonPhase(UmbraMag) ' save for use in file
			Case 15  'Penumbra Mag
			   S_MoonPhase(PenumbraMag) =VAL(sField)
			   TempPenumbraMag = S_MoonPhase(PenumbraMag) ' save for use in file
			If S_MoonPhase(UmbraMag) < 0 AND S_MoonPhase(PenumbraMag) > 0 Then
				case 16
				   S_MoonPhase(Time1) = ConvertHMString(sField) ' first cont pen
				case 17
				   S_MoonPhase(Time2) = ConvertHMString(sField) ' max
				case 18
				   S_MoonPhase(Time3) = ConvertHMString(sField) ' last contact pen
			End If
			If S_MoonPhase(UmbraMag) > 0 AND S_MoonPhase(UmbraMag) < 1 Then ' partial umbra eclipse
				case 16
				   S_MoonPhase(Time1) = ConvertHMString(sField) ' first cont pen
				case 17
				   S_MoonPhase(Time2) = ConvertHMString(sField) ' first umbra cont
				case 18
				   S_MoonPhase(Time3) = ConvertHMString(sField) ' max
				case 19
				   S_MoonPhase(Time4) = ConvertHMString(sField) ' last umbra
				case 20
				   S_MoonPhase(Time5) = ConvertHMString(sField) ' last pen
			End If
			If S_MoonPhase(UmbraMag) > 1) Then ' full umbra eclipse
				case 16
				   S_MoonPhase(Time1) = ConvertHMString(sField) ' first cont pen
				case 17
				   S_MoonPhase(Time2) = ConvertHMString(sField) ' first umbra cont
				case 18
				   S_MoonPhase(Time3) = ConvertHMString(sField) ' start total umbra
				case 19
				   S_MoonPhase(Time4) = ConvertHMString(sField) ' max umbra
				case 20
				   S_MoonPhase(Time5) = ConvertHMString(sField) ' end total umbra
				case 21
				   S_MoonPhase(Time6) = ConvertHMString(sField) ' last umbra
				case 22
				   S_MoonPhase(Time7) = ConvertHMString(sField) ' last penumbra
			End If
		END SELECT
		INC nCount
        sField = FIELD$(csMoonPhase, nCount, ",")
		sField = TrimSpace(sField)
        If nCount = 23 Then EXIT DO 'failsafe
     LOOP
END SUB

SUB ExtractSeason(csSeasonsAs As String, S_Seasons() As Float)
    'fills parsed array with the data 
    LOCAL As Integer nCount=1' starts at error code
	LOCAL As String sField
	LOCAL AS Float sDateTime(5)
    sField = FIELD$(csSeasonsAs, nCount, ",")
    sField = TrimSpace(sField)
    DO WHILE sField <> ""
        If nCount = 0 Then S_Seasons(dError) = VAL(sField)
        If nCount > 0 AND nCount < 10 Then ' dates and hours X 4
            If NOT(nCount AND 1) Then ' even fields 
                ExtractDate sField,sDateTime()
           else ' odd
                ExtractTime sField, sDateTime()
                sDateTime(m_dSec) =0	 ' dont compare seconds
                SELECT CASE nCount
                case 3
                    S_Seasons(MarchJD) = TestCalcJD(sDateTime())
               case 5
                    S_Seasons(JuneJD) = TestCalcJD(sDateTime())
                case 7
                    S_Seasons(SeptemberJD) = TestCalcJD(sDateTime())
                case 9
                    S_Seasons(DecemberJD) = TestCalcJD(sDateTime())
                END SELECT
            End If ' nCount And 2
        End If ' end of seasons, < 10
        If nCount = 10 Then ' june hours
            ExtractTime sField, sDateTime()
            S_Seasons(JuneTotalHrs) = sDateTime(m_dHour) + sDateTime(m_dMin) / 60 + sDateTime(m_dSec) / 3600
        End If
        If nCount = 11 Then' dec hours
            ExtractTime sField, sDateTime()
            S_Seasons(DecTotalHrs) = sDateTime(m_dHour) + sDateTime(m_dMin) / 60 + sDateTime(m_dSec) / 3600
        End If
        If nCount = 12 Then
            If INSTR( 1, sField, "Y") Then 
				S_Seasons(LeapYear) = 1
            Else
                S_Seasons(LeapYear) = 0
			End If
        End If
        INC nCount
        sField = FIELD$(csSeasonsAs, nCount, ",")
		sField = TrimSpace(sField)
        If nCount = 13 Then EXIT DO 'failsafe
     LOOP
END SUB

SUB ExtractPlanetRTS(csPlanetRTS As String, nPlanet As Integer, S_Planet() As Float)
    ' just extract a single planet
	LOCAL As Integer nCount=1 ' starts at error code
	LOCAL As Integer nIndexCount = 2
	LOCAL As String sField
    ' extract relevant planet
    SELECT CASE nPlanet
    case MERCURY_TST
        nCount = 2 ' skip error, start transit, at correct location in string
    case VENUS_TST
        nCount = 11
    case MARS_TST
        nCount = 20
   case JUPITER_TST
        nCount = 29
    case SATURN_TST
        nCount = 38
	END SELECT
    S_Planet(dError) = 0
	sField = FIELD$(csPlanetRTS, nCount, ",")
    sField = TrimSpace(sField)
	DO WHILE sField <> ""
        SELECT  CASE nIndexCount
        case 2 
            S_Planet(TransitMin) =  ConvertHMString(sField)
        case 3
            S_Planet(TransitAlt) = VAL(sField)
        case 4
            S_Planet(RiseMin) = ConvertHMString(sField)
        case 5
            S_Planet(RizeAz) = VAL(sField)
        case 6
            S_Planet(SetMin) = ConvertHMString(sField)
        case 7
            S_Planet(SetAz) = VAL(sField)
        case 8
            S_Planet(RTSMAGNITUDE) = VAL(sField)
         case 9
            S_Planet(RTSSIZE) = VAL(sField)
        case 10
            S_Planet(RTSDISTANCE) = VAL(sField)
        END SELECT
		INC nCount
		INC nIndexCount
        sField = FIELD$(csPlanetRTS, nCount, ",")
		sField = TrimSpace(sField)
        If nCount = 11) Then EXIT DO'failsafe
	LOOP
END SUB

SUB ExtractPlanetPosition(csPlanetPos As String, nObject As Integer, S_Planet() As Float) 
    ' just extract a single planets/sun/moon position
    LOCAL As Integer nCount=2 ' skip error code
	LOCAL As String sField
    ' extract relevant planet
    S_Planet(dError) = 0
 	sField = FIELD$(csPlanetPos, nCount, ",")
    sField = TrimSpace(sField)
    DO WHILE sField <> ""
        SELECT CASE nCount
         case 2
            S_Planet(IAZIMUTH) = VAL(sField)
        case 3
            S_Planet(IALT) = VAL(sField)
        case 4
            S_Planet(IDISTANCE) = VAL(sField)
        case 5
            S_Planet(IRTASC) = VAL(sField)
         case 6
            S_Planet(IDEC) = VAL(sField) 
            'If (nObject < SUN_TST OR nObject = MOON_TST) Then ' do planets and moon
        case 7
            If nObject < SUN_TST Then ' planets only
                S_Planet(IMAGNITUDE) = VAL(sField)
            Else
                S_Planet(IMOON_ILLUM) = VAL(sField)
            End If
        case 8
            If nObject < SUN_TST Then
                S_Planet(ISIZE) = VAL(sField)
            Else
                S_Planet(IMOON_POS_ANGLE) = VAL(sField)
            End If
            ' End If 
        case 9
            S_Planet(ILONG) = VAL(sField)
        case 10
            S_Planet(ILAT) = VAL(sField)
         case 11
            S_Planet(IEARTHLONG) = VAL(sField)
       case 12
            S_Planet(IPLANETSUNDIST) = VAL(sField)
        case 13
            S_Planet(IEARTHSUNDIST) = VAL(sField)
        END SELECT
        INC nCount
        sField = FIELD$(csPlanetPos, nCount, ",")
		sField = TrimSpace(sField)
        If nCount = 15) Then EXIT DO'failsafe
	LOOP
END SUB


SUB SunMoonRTSCompMICA_To_Prog(InString As String, nIndex As Integer) 
    ' tests for each command
	LOCAL As Float SData(21)
	ExtractSunMoonRTS InString, SData() 
    If SData(dError) <> 0 Then
        PRINT #1, "Error In Returned data" ' flag error
	Else 
        SMRTSDataDelta(nIndex,TransitMin) = MicaSunMoonRTSData(nIndex,TransitMin) - SData(TransitMin)
        If ABS(SMRTSDataDelta(nIndex,TransitMin)) > ABS(SunMoonRTSMaxErrors(TransitMin)) Then SunMoonRTSMaxErrors(TransitMin) = SMRTSDataDelta(nIndex,TransitMin)
        SMRTSDataDelta(nIndex,TransitAlt) = MicaSunMoonRTSData(nIndex,TransitAlt) - SData(TransitAlt)
        If ABS(SMRTSDataDelta(nIndex,TransitAlt)) > ABS(SunMoonRTSMaxErrors(TransitAlt)) Then SunMoonRTSMaxErrors(TransitAlt) = SMRTSDataDelta(nIndex,TransitAlt)
        SMRTSDataDelta(nIndex,RiseMin) = MicaSunMoonRTSData(nIndex,RiseMin) - SData(RiseMin)
        If ABS(SMRTSDataDelta(nIndex,RiseMin)) > ABS(SunMoonRTSMaxErrors(RiseMin)) Then SunMoonRTSMaxErrors(RiseMin) = SMRTSDataDelta(nIndex,RiseMin)
        SMRTSDataDelta(nIndex,RizeAz) = MicaSunMoonRTSData(nIndex,RizeAz) - SData(RizeAz)
        If ABS(SMRTSDataDelta(nIndex,RizeAz)) > ABS(SunMoonRTSMaxErrors(RizeAz)) Then SunMoonRTSMaxErrors(RizeAz) = SMRTSDataDelta(nIndex,RizeAz)
        SMRTSDataDelta(nIndex,SetMin) = MicaSunMoonRTSData(nIndex,SetMin) - SData(SetMin)
        If ABS(SMRTSDataDelta(nIndex,SetMin)) > ABS(SunMoonRTSMaxErrors(SetMin)) Then SunMoonRTSMaxErrors(SetMin) = SMRTSDataDelta(nIndex,SetMin)
        SMRTSDataDelta(nIndex,SetAz) = MicaSunMoonRTSData(nIndex,SetAz) - SData(SetAz)
        If ABS(SMRTSDataDelta(nIndex,SetAz)) > ABS(SunMoonRTSMaxErrors(SetAz)) Then SunMoonRTSMaxErrors(SetAz) = SMRTSDataDelta(nIndex,SetAz)
        SMRTSDataDelta(nIndex,CivilTwiMin) = MicaSunMoonRTSData(nIndex,CivilTwiMin) - SData(CivilTwiMin)
        If ABS(SMRTSDataDelta(nIndex,CivilTwiMin)) > ABS(SunMoonRTSMaxErrors(CivilTwiMin)) Then SunMoonRTSMaxErrors(CivilTwiMin) = SMRTSDataDelta(nIndex,CivilTwiMin)
        SMRTSDataDelta(nIndex,CivilDuskMin) = MicaSunMoonRTSData(nIndex,CivilDuskMin) - SData(CivilDuskMin)
        If ABS(SMRTSDataDelta(nIndex,CivilDuskMin)) > ABS(SunMoonRTSMaxErrors(CivilDuskMin)) Then SunMoonRTSMaxErrors(CivilDuskMin) = SMRTSDataDelta(nIndex,CivilDuskMin)
        SMRTSDataDelta(nIndex,NautTwilMin) = MicaSunMoonRTSData(nIndex,NautTwilMin) - SData(NautTwilMin)
        If ABS(SMRTSDataDelta(nIndex,NautTwilMin)) > ABS(SunMoonRTSMaxErrors(NautTwilMin)) Then  SunMoonRTSMaxErrors(NautTwilMin) = SMRTSDataDelta(nIndex,NautTwilMin)
        SMRTSDataDelta(nIndex,NautDuskMin) = MicaSunMoonRTSData(nIndex,NautDuskMin) - SData(NautDuskMin)
        If ABS(SMRTSDataDelta(nIndex,NautDuskMin)) > ABS(SunMoonRTSMaxErrors(NautDuskMin)) Then SunMoonRTSMaxErrors(NautDuskMin) = SMRTSDataDelta(nIndex,NautDuskMin)
        SMRTSDataDelta(nIndex,AstroTwilMin) = MicaSunMoonRTSData(nIndex,AstroTwilMin) - SData(AstroTwilMin)
        If ABS(SMRTSDataDelta(nIndex,AstroTwilMin)) > ABS(SunMoonRTSMaxErrors(AstroTwilMin)) Then SunMoonRTSMaxErrors(AstroTwilMin) = SMRTSDataDelta(nIndex,AstroTwilMin)
        SMRTSDataDelta(nIndex,AstroDuskMin) = MicaSunMoonRTSData(nIndex,AstroDuskMin) - SData(AstroDuskMin)
        If ABS(SMRTSDataDelta(nIndex,AstroDuskMin)) > ABS(SunMoonRTSMaxErrors(AstroDuskMin)) Then SunMoonRTSMaxErrors(AstroDuskMin) = SMRTSDataDelta(nIndex,AstroDuskMin)
        SMRTSDataDelta(nIndex,SunDistance) = MicaSunMoonRTSData(nIndex,SunDistance) - SData(SunDistance)
        If ABS(SMRTSDataDelta(nIndex,SunDistance)) > ABS(SunMoonRTSMaxErrors(SunDistance)) Then SunMoonRTSMaxErrors(SunDistance) = SMRTSDataDelta(nIndex,SunDistance)
        SMRTSDataDelta(nIndex,MoonTransMin) = MicaSunMoonRTSData(nIndex,MoonTransMin) - SData(MoonTransMin)
        If ABS(SMRTSDataDelta(nIndex,MoonTransMin)) > ABS(SunMoonRTSMaxErrors(MoonTransMin)) Then SunMoonRTSMaxErrors(MoonTransMin) = SMRTSDataDelta(nIndex,MoonTransMin)
        SMRTSDataDelta(nIndex,MoonTransAlt) = MicaSunMoonRTSData(nIndex,MoonTransAlt) - SData(MoonTransAlt)
        If ABS(SMRTSDataDelta(nIndex,MoonTransAlt)) > ABS(SunMoonRTSMaxErrors(MoonTransAlt)) Then SunMoonRTSMaxErrors(MoonTransAlt) = SMRTSDataDelta(nIndex,MoonTransAlt)
        SMRTSDataDelta(nIndex,MoonRiseMin) = MicaSunMoonRTSData(nIndex,MoonRiseMin) - SData(MoonRiseMin)
        If ABS(SMRTSDataDelta(nIndex,MoonRiseMin)) > ABS(SunMoonRTSMaxErrors(MoonRiseMin)) Then SunMoonRTSMaxErrors(MoonRiseMin) = SMRTSDataDelta(nIndex,MoonRiseMin)
        SMRTSDataDelta(nIndex,MoonRiseAz) = MicaSunMoonRTSData(nIndex,MoonRiseAz) - SData(MoonRiseAz)
        If ABS(SMRTSDataDelta(nIndex,MoonRiseAz)) > ABS(SunMoonRTSMaxErrors(MoonRiseAz)) Then SunMoonRTSMaxErrors(MoonRiseAz) = SMRTSDataDelta(nIndex,MoonRiseAz)
        SMRTSDataDelta(nIndex,MoonSetMin) = MicaSunMoonRTSData(nIndex,MoonSetMin) - SData(MoonSetMin)
        If ABS(SMRTSDataDelta(nIndex,MoonSetMin)) > ABS(SunMoonRTSMaxErrors(MoonSetMin)) Then SunMoonRTSMaxErrors(MoonSetMin) = SMRTSDataDelta(nIndex,MoonSetMin)
        SMRTSDataDelta(nIndex,MoonSetAz) = MicaSunMoonRTSData(nIndex,MoonSetAz) - SData(MoonSetAz)
        If ABS(SMRTSDataDelta(nIndex,MoonSetAz)) > ABS(SunMoonRTSMaxErrors(MoonSetAz)) Then SunMoonRTSMaxErrors(MoonSetAz) = SMRTSDataDelta(nIndex,MoonSetAz)
        SMRTSDataDelta(nIndex,MoonDistance) = MicaSunMoonRTSData(nIndex,MoonDistance) - SData(MoonDistance)
        If ABS(SMRTSDataDelta(nIndex,MoonDistance)) > ABS(SunMoonRTSMaxErrors(MoonDistance)) Then SunMoonRTSMaxErrors(MoonDistance) = SMRTSDataDelta(nIndex,MoonDistance)
    End If
END SUB

SUB MoonPhaseCompMICA_To_Prog(InString As String, nIndex As Integer) 
    ' tests for each command
	LOCAL As Float SData(16)
	ExtractMoonPhase InString,SData() 
    If SData(dError) <> 0)) Then
       PRINT #1, "Error In Returned data" ' flag error
	Else 
        MoonPhaseDeltas(nIndex,NewMoonJD) = MoonMicaPhaseData(nIndex,NewMoonJD) - SData(NewMoonJD)
        If ABS(MoonPhaseDeltas(nIndex,NewMoonJD)) > ABS(MoonPhaseMaxErrors(NewMoonJD)) Then MoonPhaseMaxErrors(NewMoonJD) = MoonPhaseDeltas(nIndex,NewMoonJD)
        MoonPhaseDeltas(nIndex,FirstQuarterJD) = MoonMicaPhaseData(nIndex,FirstQuarterJD) - SData(FirstQuarterJD)
        If ABS(MoonPhaseDeltas(nIndex,FirstQuarterJD)) > ABS(MoonPhaseMaxErrors(FirstQuarterJD)) Then MoonPhaseMaxErrors(FirstQuarterJD) = MoonPhaseDeltas(nIndex,FirstQuarterJD)
        MoonPhaseDeltas(nIndex,FullMoonJD) = MoonMicaPhaseData(nIndex,FullMoonJD) - SData(FullMoonJD)
        If ABS(MoonPhaseDeltas(nIndex,FullMoonJD)) > ABS(MoonPhaseMaxErrors(FullMoonJD)) Then MoonPhaseMaxErrors(FullMoonJD) = MoonPhaseDeltas(nIndex,FullMoonJD)
        MoonPhaseDeltas(nIndex,LastQuarterJD) = MoonMicaPhaseData(nIndex,LastQuarterJD) - SData(LastQuarterJD)
        If ABS(MoonPhaseDeltas(nIndex,LastQuarterJD)) > ABS(MoonPhaseMaxErrors(LastQuarterJD)) Then MoonPhaseMaxErrors(LastQuarterJD) = MoonPhaseDeltas(nIndex,LastQuarterJD)
        If SData(AdditionalPhaseType) > 0.1) Then ' not zero
            MoonPhaseDeltas(nIndex,AdditionalPhaseType) = MoonMicaPhaseData(nIndex,AdditionalPhaseType) - SData(AdditionalPhaseType)
            If ABS(MoonPhaseDeltas(nIndex,AdditionalPhaseType)) > ABS(MoonPhaseMaxErrors(AdditionalPhaseType)) Then MoonPhaseMaxErrors(AdditionalPhaseType) = MoonPhaseDeltas(nIndex,AdditionalPhaseType)
            MoonPhaseDeltas(nIndex,AdditionalDateJD) = MoonMicaPhaseData(nIndex,AdditionalDateJD) - SData(AdditionalDateJD)
            If ABS(MoonPhaseDeltas(nIndex,AdditionalDateJD)) > ABS(MoonPhaseMaxErrors(AdditionalDateJD)) Then 
                'If (MoonPhaseMaxErrors(AdditionalDateJD) * cMINS_PER_DAY) < 20 Then MoonPhaseMaxErrors(AdditionalDateJD) = MoonPhaseDeltas(nIndex,AdditionalDateJD)
				MoonPhaseMaxErrors(AdditionalDateJD) = MoonPhaseDeltas(nIndex,AdditionalDateJD)
			End If
        else
            MoonPhaseDeltas(nIndex,AdditionalPhaseType) = 0
		End If
        If SData(EclipseDateJD) <> cJAN1901_JD Then MoonPhaseDeltas(nIndex,EclipseDateJD) = MoonMicaPhaseData(nIndex,EclipseDateJD) - SData(EclipseDateJD)
            If ABS(MoonPhaseDeltas(nIndex,EclipseDateJD)) > ABS(MoonPhaseMaxErrors(EclipseDateJD)) Then MoonPhaseMaxErrors(EclipseDateJD) = MoonPhaseDeltas(nIndex,EclipseDateJD)
            If MoonMicaPhaseData(nIndex,UmbraMag) = NO_CHECK_MAGNITUDE Then
                MoonPhaseDeltas(nIndex,UmbraMag) = 0
            Else
                MoonPhaseDeltas(nIndex,UmbraMag) = MoonMicaPhaseData(nIndex,UmbraMag) - SData(UmbraMag)
			End If
            If ABS(MoonPhaseDeltas(nIndex,UmbraMag)) > ABS(MoonPhaseMaxErrors(UmbraMag)) Then MoonPhaseMaxErrors(UmbraMag) = MoonPhaseDeltas(nIndex,UmbraMag)
            If MoonMicaPhaseData(nIndex,PenumbraMag) = NO_CHECK_MAGNITUDE Then
                MoonPhaseDeltas(nIndex,PenumbraMag) = 0
            Else
                MoonPhaseDeltas(nIndex,PenumbraMag) = MoonMicaPhaseData(nIndex,PenumbraMag) - SData(PenumbraMag)
			End If
            If ABS(MoonPhaseDeltas(nIndex,PenumbraMag)) > ABS(MoonPhaseMaxErrors(PenumbraMag)) Then MoonPhaseMaxErrors(PenumbraMag) = MoonPhaseDeltas(nIndex,PenumbraMag)
            If MoonMicaPhaseData(nIndex,Time1) = LUNAR_ECLIPSE_NOT_VISIBLE Then
                MoonPhaseDeltas(nIndex,Time1) = 0
			Else 
                MoonPhaseDeltas(nIndex,Time1) = MoonMicaPhaseData(nIndex,Time1) - SData(Time1)
				'? "Mica T1 = ", MoonMicaPhaseData(nIndex,Time1), " SData T1 = ",  SData(Time1)
                If ABS(MoonPhaseDeltas(nIndex,Time1)) > ABS(MoonPhaseMaxErrors(Time1)) Then MoonPhaseMaxErrors(Time1) = MoonPhaseDeltas(nIndex,Time1)
            End If
            If MoonMicaPhaseData(nIndex,Time2) = LUNAR_ECLIPSE_NOT_VISIBLE Then
                MoonPhaseDeltas(nIndex,Time2) = 0
            Else
                MoonPhaseDeltas(nIndex,Time2) = MoonMicaPhaseData(nIndex,Time2) - SData(Time2)
                If ABS(MoonPhaseDeltas(nIndex,Time2)) > ABS(MoonPhaseMaxErrors(Time2)) Then MoonPhaseMaxErrors(Time2) = MoonPhaseDeltas(nIndex,Time2)
            End If
            If MoonMicaPhaseData(nIndex,Time3) = LUNAR_ECLIPSE_NOT_VISIBLE Then
                MoonPhaseDeltas(nIndex,Time3) = 0
           Else 
                MoonPhaseDeltas(nIndex,Time3) = MoonMicaPhaseData(nIndex,Time3) - SData(Time3)
                If ABS(MoonPhaseDeltas(nIndex,Time3)) > ABS(MoonPhaseMaxErrors(Time3)) Then  MoonPhaseMaxErrors(Time3) = MoonPhaseDeltas(nIndex,Time3)
            End If
            If MoonMicaPhaseData(nIndex,Time4) = LUNAR_ECLIPSE_NOT_VISIBLE Then
                MoonPhaseDeltas(nIndex,Time4) = 0
            Else
                MoonPhaseDeltas(nIndex,Time4) = MoonMicaPhaseData(nIndex,Time4) - SData(Time4)
                If ABS(MoonPhaseDeltas(nIndex,Time4)) > ABS(MoonPhaseMaxErrors(Time4)) Then MoonPhaseMaxErrors(Time4) = MoonPhaseDeltas(nIndex,Time4)
            End If
            If MoonMicaPhaseData(nIndex,Time5) = LUNAR_ECLIPSE_NOT_VISIBLE Then
                MoonPhaseDeltas(nIndex,Time5) = 0
            Else 
                MoonPhaseDeltas(nIndex,Time5) = MoonMicaPhaseData(nIndex,Time5) - SData(Time5)
                If ABS(MoonPhaseDeltas(nIndex,Time5)) > ABS(MoonPhaseMaxErrors(Time5)) Then MoonPhaseMaxErrors(Time5) = MoonPhaseDeltas(nIndex,Time5)
            End If
            If MoonMicaPhaseData(nIndex,Time6) = LUNAR_ECLIPSE_NOT_VISIBLE Then
                MoonPhaseDeltas(nIndex,Time6) = 0
            Else
                MoonPhaseDeltas(nIndex,Time6) = MoonMicaPhaseData(nIndex,Time6) - SData(Time6)
                If ABS(MoonPhaseDeltas(nIndex,Time6)) > ABS(MoonPhaseMaxErrors(Time6)) Then MoonPhaseMaxErrors(Time6) = MoonPhaseDeltas(nIndex,Time6)
            End If
            If MoonMicaPhaseData(nIndex,Time7) = LUNAR_ECLIPSE_NOT_VISIBLE Then
                MoonPhaseDeltas(nIndex,Time7) = 0
            Else 
                MoonPhaseDeltas(nIndex,Time7) = MoonMicaPhaseData(nIndex,Time7) - SData(Time7)
				'? "MICA T7 = ", MoonMicaPhaseData(nIndex,Time7), "Ddata T7 = ", SData(Time7)
                If ABS(MoonPhaseDeltas(nIndex,Time7)) > ABS(MoonPhaseMaxErrors(Time7)) Then MoonPhaseMaxErrors(Time7) = MoonPhaseDeltas(nIndex,Time7)
            End If
       Else' if eclipse
            MoonPhaseDeltas(nIndex,EclipseDateJD) = cJAN1901_JD
    End If
END SUB

SUB SeasonCompMICA_To_Prog(InString As String, nIndex As Integer) 
    ' tests for each command
	LOCAL As Float SData(7)
    ExtractSeason InString, SData()
    If SData(dError) <> 0 Then
       PRINT #1, "Error In Returned data" ' flag error
    Else 
'	? "March MIca", MicaSeasonData(nIndex,MarchJD), "SD= ",SData(MarchJD)
        SeasonDeltas(nIndex,MarchJD) = MicaSeasonData(nIndex,MarchJD) - SData(MarchJD)
        If ABS(SeasonDeltas(nIndex,MarchJD)) > ABS(SeasonMaxErrors(MarchJD)) Then SeasonMaxErrors(MarchJD) = SeasonDeltas(nIndex,MarchJD)
        SeasonDeltas(nIndex,JuneJD) = MicaSeasonData(nIndex,JuneJD) - SData(JuneJD)
        If ABS(SeasonDeltas(nIndex,JuneJD)) > ABS(SeasonMaxErrors(JuneJD)) Then SeasonMaxErrors(JuneJD) = SeasonDeltas(nIndex,JuneJD)
        SeasonDeltas(nIndex,SeptemberJD) = MicaSeasonData(nIndex,SeptemberJD) - SData(SeptemberJD)
        If ABS(SeasonDeltas(nIndex,SeptemberJD)) > ABS(SeasonMaxErrors(SeptemberJD)) Then SeasonMaxErrors(SeptemberJD) = SeasonDeltas(nIndex,SeptemberJD)
        SeasonDeltas(nIndex,DecemberJD) = MicaSeasonData(nIndex,DecemberJD) - SData(DecemberJD)
        If ABS(SeasonDeltas(nIndex,DecemberJD)) > ABS(SeasonMaxErrors(DecemberJD)) Then SeasonMaxErrors(DecemberJD) = SeasonDeltas(nIndex,DecemberJD)
        SeasonDeltas(nIndex,JuneTotalHrs) = MicaSeasonData(nIndex,JuneTotalHrs) - SData(JuneTotalHrs)
        If ABS(SeasonDeltas(nIndex,JuneTotalHrs)) > ABS(SeasonMaxErrors(JuneTotalHrs)) Then SeasonMaxErrors(JuneTotalHrs) = SeasonDeltas(nIndex,JuneTotalHrs)
        SeasonDeltas(nIndex,DecTotalHrs) = MicaSeasonData(nIndex,DecTotalHrs) - SData(DecTotalHrs)
        If ABS(SeasonDeltas(nIndex,DecTotalHrs)) > ABS(SeasonMaxErrors(DecTotalHrs)) Then SeasonMaxErrors(DecTotalHrs) = SeasonDeltas(nIndex,DecTotalHrs)
        If MicaSeasonData(nIndex,LeapYear) = SData(LeapYear) Then
            SeasonDeltas(nIndex,LeapYear) = 1 ' are same
        else
            SeasonDeltas(nIndex,LeapYear) = 0
    End If
END SUB

SUB PlanetRTSCompMICA_To_Prog(InString As String, nIndex As Integer) 
    ' tests for each command
    LOCAL As Float SData(9)
	LOCAL As Integer i
	FOR i = 0 TO 4
        ExtractPlanetRTS InString, i, SData() 
        PlanetRTSDelta(nIndex,i,TransitMin) = MicaPlanetRTS(nIndex,i,TransitMin) - SData(TransitMin)
        If ABS(PlanetRTSDelta(nIndex,i,TransitMin)) > ABS(PlanetRTSMAXError(TransitMin)) Then PlanetRTSMAXError(TransitMin) = PlanetRTSDelta(nIndex,i,TransitMin)
        PlanetRTSDelta(nIndex,i,TransitAlt) = MicaPlanetRTS(nIndex,i,TransitAlt) - SData(TransitAlt)
        If ABS(PlanetRTSDelta(nIndex,i,TransitAlt)) > ABS(PlanetRTSMAXError(TransitAlt)) Then PlanetRTSMAXError(TransitAlt) = PlanetRTSDelta(nIndex,i,TransitAlt)
        PlanetRTSDelta(nIndex,i,RiseMin) = MicaPlanetRTS(nIndex,i,RiseMin) - SData(RiseMin)
        If ABS(PlanetRTSDelta(nIndex,i,RiseMin)) > ABS(PlanetRTSMAXError(RiseMin)) Then PlanetRTSMAXError(RiseMin) = PlanetRTSDelta(nIndex,i,RiseMin)
        PlanetRTSDelta(nIndex,i,RizeAz) = MicaPlanetRTS(nIndex,i,RizeAz) - SData(RizeAz)
        If ABS(PlanetRTSDelta(nIndex,i,RizeAz)) > ABS(PlanetRTSMAXError(RizeAz)) Then PlanetRTSMAXError(RizeAz) = PlanetRTSDelta(nIndex,i,RizeAz)
        PlanetRTSDelta(nIndex,i,SetMin) = MicaPlanetRTS(nIndex,i,SetMin) - SData(SetMin)
        If ABS(PlanetRTSDelta(nIndex,i,SetMin)) > ABS(PlanetRTSMAXError(SetMin)) Then PlanetRTSMAXError(SetMin) = PlanetRTSDelta(nIndex,i,SetMin)
        PlanetRTSDelta(nIndex,i,SetAz) = MicaPlanetRTS(nIndex,i,SetAz) - SData(SetAz)
        If ABS(PlanetRTSDelta(nIndex,i,SetAz)) > ABS(PlanetRTSMAXError(SetAz)) Then PlanetRTSMAXError(SetAz) = PlanetRTSDelta(nIndex,i,SetAz)
        PlanetRTSDelta(nIndex,i,RTSMAGNITUDE) = MicaPlanetRTS(nIndex,i,RTSMAGNITUDE) - SData(RTSMAGNITUDE)
        If ABS(PlanetRTSDelta(nIndex,i,RTSMAGNITUDE)) > ABS(PlanetRTSMAXError(RTSMAGNITUDE)) Then PlanetRTSMAXError(RTSMAGNITUDE) = PlanetRTSDelta(nIndex,i,RTSMAGNITUDE)
        PlanetRTSDelta(nIndex,i,RTSSIZE) = MicaPlanetRTS(nIndex,i,RTSSIZE) - SData(RTSSIZE)
        If ABS(PlanetRTSDelta(nIndex,i,RTSSIZE)) > ABS(PlanetRTSMAXError(RTSSIZE)) Then PlanetRTSMAXError(RTSSIZE) = PlanetRTSDelta(nIndex,i,RTSSIZE)
        PlanetRTSDelta(nIndex,i,RTSDISTANCE) = MicaPlanetRTS(nIndex,i,RTSDISTANCE) - SData(RTSDISTANCE)
        If ABS(PlanetRTSDelta(nIndex,i,RTSDISTANCE)) > ABS(PlanetRTSMAXError(RTSDISTANCE)) Then PlanetRTSMAXError(RTSDISTANCE) = PlanetRTSDelta(nIndex,i,RTSDISTANCE)
    NEXT i
END SUB

SUB PlanetPOSCompMICA_To_Prog(InString As String, nIndex As Integer, nObject As Integer) 
    ' tests for each command
    LOCAL As Float SData(14)
    ExtractPlanetPosition InString, nObject, SData() 
    If SData(dError) <> 0 Then
        PRINT #1, "Error In Returned data" ' flag error
    else 
        PlanetPOSDelta(nIndex,IAZIMUTH) = MicaPlanetPOS(nIndex,IAZIMUTH) - SData(IAZIMUTH)
        If ABS(PlanetPOSDelta(nIndex,IAZIMUTH)) > ABS(PlanetPOSMAXError(IAZIMUTH)) Then PlanetPOSMAXError(IAZIMUTH) = PlanetPOSDelta(nIndex,IAZIMUTH)
        PlanetPOSDelta(nIndex,IALT) = MicaPlanetPOS(nIndex,IALT) - SData(IALT)
        If ABS(PlanetPOSDelta(nIndex,IALT)) > ABS(PlanetPOSMAXError(IALT)) Then PlanetPOSMAXError(IALT) = PlanetPOSDelta(nIndex,IALT)
        PlanetPOSDelta(nIndex,IDISTANCE) = MicaPlanetPOS(nIndex,IDISTANCE) - SData(IDISTANCE)
       ' If nObject <> MOON_TST Then
       '     If ABS(PlanetPOSDelta(nIndex,IDISTANCE)) > ABS(PlanetPOSMAXError(IDISTANCE)) Then PlanetPOSMAXError(IDISTANCE) = PlanetPOSDelta(nIndex,IDISTANCE)
       ' Else ' must be moon
            If ABS(PlanetPOSDelta(nIndex,IDISTANCE)) > ABS(PlanetPOSMAXError(IDISTANCE)) Then PlanetPOSMAXError(IDISTANCE) = PlanetPOSDelta(nIndex,IDISTANCE)
      '  End If
        PlanetPOSDelta(nIndex,IRTASC) = MicaPlanetPOS(nIndex,IRTASC) - SData(IRTASC)
        If ABS(PlanetPOSDelta(nIndex,IRTASC)) > ABS(PlanetPOSMAXError(IRTASC)) Then PlanetPOSMAXError(IRTASC) = PlanetPOSDelta(nIndex,IRTASC)
       PlanetPOSDelta(nIndex,IDEC) = MicaPlanetPOS(nIndex,IDEC) - SData(IDEC)
        If ABS(PlanetPOSDelta(nIndex,IDEC)) > ABS(PlanetPOSMAXError(IDEC)) Then PlanetPOSMAXError(IDEC) = PlanetPOSDelta(nIndex,IDEC)
        If nObject < SUN_TST Then' planets
            PlanetPOSDelta(nIndex,ILONG) = MicaPlanetPOS(nIndex,ILONG) - SData(ILONG)
            If ABS(PlanetPOSDelta(nIndex,ILONG)) > ABS(PlanetPOSMAXError(ILONG)) Then PlanetPOSMAXError(ILONG) = PlanetPOSDelta(nIndex,ILONG)
            PlanetPOSDelta(nIndex,ILAT) = MicaPlanetPOS(nIndex,ILAT) - SData(ILAT)
            If ABS(PlanetPOSDelta(nIndex,ILAT)) > ABS(PlanetPOSMAXError(ILAT)) Then PlanetPOSMAXError(ILAT) = PlanetPOSDelta(nIndex,ILAT)
            PlanetPOSDelta(nIndex,IMAGNITUDE) = MicaPlanetPOS(nIndex,IMAGNITUDE) - SData(IMAGNITUDE)
            If ABS(PlanetPOSDelta(nIndex,IMAGNITUDE)) > ABS(PlanetPOSMAXError(IMAGNITUDE)) Then PlanetPOSMAXError(IMAGNITUDE) = PlanetPOSDelta(nIndex,IMAGNITUDE)
            PlanetPOSDelta(nIndex,ISIZE) = MicaPlanetPOS(nIndex,ISIZE) - SData(ISIZE)
            If ABS(PlanetPOSDelta(nIndex,ISIZE)) > ABS(PlanetPOSMAXError(ISIZE)) Then PlanetPOSMAXError(ISIZE) = PlanetPOSDelta(nIndex,ISIZE)
            PlanetPOSDelta(nIndex,IEARTHLONG) = MicaPlanetPOS(nIndex,IEARTHLONG) - SData(IEARTHLONG)
            If ABS(PlanetPOSDelta(nIndex,IEARTHLONG)) > ABS(PlanetPOSMAXError(IEARTHLONG)) Then PlanetPOSMAXError(IEARTHLONG) = PlanetPOSDelta(nIndex,IEARTHLONG)
            PlanetPOSDelta(nIndex,IPLANETSUNDIST) = MicaPlanetPOS(nIndex,IPLANETSUNDIST) - SData(IPLANETSUNDIST)
            If ABS(PlanetPOSDelta(nIndex,IPLANETSUNDIST)) > ABS(PlanetPOSMAXError(IPLANETSUNDIST)) Then PlanetPOSMAXError(IPLANETSUNDIST) = PlanetPOSDelta(nIndex,IPLANETSUNDIST)
            PlanetPOSDelta(nIndex,IEARTHSUNDIST) = MicaPlanetPOS(nIndex,IEARTHSUNDIST) - SData(IEARTHSUNDIST)
            If ABS(PlanetPOSDelta(nIndex,IEARTHSUNDIST)) > ABS(PlanetPOSMAXError(IEARTHSUNDIST)) Then PlanetPOSMAXError(IEARTHSUNDIST) = PlanetPOSDelta(nIndex,IEARTHSUNDIST)
        End If
        If nObject = MOON_TST Then
            PlanetPOSDelta(nIndex,IMOON_ILLUM) = MicaPlanetPOS(nIndex,IMOON_ILLUM) - SData(IMOON_ILLUM)
            If ABS(PlanetPOSDelta(nIndex,IMOON_ILLUM)) > ABS(PlanetPOSMAXError(IMOON_ILLUM)) Then PlanetPOSMAXError(IMOON_ILLUM) = PlanetPOSDelta(nIndex,IMOON_ILLUM)
            PlanetPOSDelta(nIndex,IMOON_POS_ANGLE) = MicaPlanetPOS(nIndex,IMOON_POS_ANGLE) - SData(IMOON_POS_ANGLE)
            If ABS(PlanetPOSDelta(nIndex,IMOON_POS_ANGLE)) > ABS(PlanetPOSMAXError(IMOON_POS_ANGLE)) Then PlanetPOSMAXError(IMOON_POS_ANGLE) = PlanetPOSDelta(nIndex,IMOON_POS_ANGLE)
        End If
    End If ' no error
END SUB


SUB TestWriteFile(csString As String) 
    If FileOpen Then PRINT #1, csString 
END SUB

SUB FileSunMoonRTSErrors(nIndex As Integer)
    If FileOpen Then
		PRINT #1, CHR$(9)+"=============  SUN & MOON RISE SET DIFFERENCE FROM MICA  ============="
        PRINT #1, CHR$(9)+"Command:  " + TestCmnds(nIndex)
		PRINT #1, CHR$(9)+"RETURN DATA:"
		PRINT #1, RetString
		PRINT #1, CHR$(9)+"Sun Transit:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,TransitMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,TransitAlt),"%03.0f Degrees")
		PRINT #1, CHR$(9)+"Sun Rise:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,RiseMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,RizeAz),"%03.0f Degrees")
		PRINT #1, CHR$(9)+"Sun Set:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,SetMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,SetAz),"%03.0f Degrees")
		PRINT #1, CHR$(9)+"Civil Twilight:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,CivilTwiMin),"  %02.0f Mins")
		PRINT #1, CHR$(9)+"Civil Dusk:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,CivilDuskMin),"  %02.0f Mins")
		PRINT #1, CHR$(9)+"Nautical Twilight:"+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,NautTwilMin),"  %02.0f Mins")
		PRINT #1, CHR$(9)+"Nautical Dusk:"+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,NautDuskMin),"  %02.0f Mins")
		PRINT #1, CHR$(9)+"Astronomical Twilight:"+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,AstroTwilMin),"  %02.0f Mins")
		PRINT #1, CHR$(9)+"Astronomical Dusk:"+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,AstroDuskMin),"  %02.0f Mins")
		PRINT #1, CHR$(9)+"Sun Distance:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,SunDistance),"  %4.3f Million KM")
		PRINT #1, CHR$(9)+"Moon Transit:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,MoonTransMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,MoonTransAlt),"%03.0f Degrees")
		PRINT #1, CHR$(9)+"Moon Rise:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,MoonRiseMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,MoonRiseAz),"%03.0f Degrees")
		PRINT #1, CHR$(9)+"Moon Set:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,MoonSetMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,MoonSetAz),"%03.0f Degrees")
		PRINT #1, CHR$(9)+"Moon Distance:"+CHR$(9)+CHR$(9)+FORMAT$(SMRTSDataDelta(nIndex,MoonDistance),"  %6.3f KM")
    End If
End Sub

SUB FileSunMoonMAXErrors(nIndex As Integer) 
    If FileOpen Then
		PRINT #1, CHR$(9)+CHR$(9)+"====================== MAX ERRORS ======================"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Sun Transit:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(TransitMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(TransitAlt),"%03.0f Degrees")CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Sun Rise:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(TransitMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(TransitMin),"%03.0f Degrees")CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Sun Set:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(SetMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(SetAz),"%03.0f Degrees")CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Civil TwLt:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(CivilTwiMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Civil Dusk:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(CivilDuskMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Nautical TwLt:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(NautTwilMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Nautical Dusk:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(NautDuskMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Astro TwLt:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(AstroTwilMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Astro Dusk:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(AstroDuskMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Sun Distance:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(SunDistance),"  %4.3f Million KM")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Moon Transit:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(MoonTransMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(MoonTransAlt),"%03.0f Degrees")CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Moon Rise:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(MoonRiseMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(MoonRiseAz),"%03.0f Degrees")CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Moon Set:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(MoonSetMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(MoonSetAz),"%03.0f Degrees")CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Moon Distance:"+CHR$(9)+CHR$(9)+FORMAT$(SunMoonRTSMaxErrors(MOONDISTANCE)," %6.3f KM")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
   End If
END SUB

SUB FileMoonPhaseErrors(nIndex As Integer) 
   If FileOpen Then
		PRINT #1, CHR$(10)+CHR$(9)+"=============  MOON PHASE & ECLIPSE DIFFERENCE FROM MICA  ============="
        PRINT #1, CHR$(9)+"Command:"+ CHR$(9)+CHR$(9)+TestCmnds(nIndex)
		PRINT #1, CHR$(9)+"RETURN DATA:"
		PRINT #1, CHR$(9)+RetString
		PRINT #1, CHR$(9)+"New Moon:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,NewMoonJD) * cMINS_PER_DAY,"  %03.0f Mins")
		PRINT #1, CHR$(9)+"First Qtr:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,FirstQuarterJD) * cMINS_PER_DAY,"  %03.0f Mins")
		PRINT #1, CHR$(9)+"Full Moon:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,FullMoonJD) * cMINS_PER_DAY,"  %03.0f Mins")
		PRINT #1, CHR$(9)+"Last Qtr:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,LastQuarterJD) * cMINS_PER_DAY,"  %03.0f Mins")
		SELECT CASE FIX(MoonMicaPhaseData(nIndex,AdditionalPhaseType))
            case 0
                PRINT #1,CHR$(9)+"NO Additional Phase"+CHR$(13)+CHR$(10)
             case 1
				PRINT #1,CHR$(9)+"Additional New Moon:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,AdditionalDateJD) * cMINS_PER_DAY,"  %03.0f Mins")
             case 2
				PRINT #1,CHR$(9)+"Additional First Qtr:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,AdditionalDateJD) * cMINS_PER_DAY,"  %03.0f Mins")
            case 3	
                PRINT #1,CHR$(9)+"Additional Full Moon:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,AdditionalDateJD) * cMINS_PER_DAY,"  %03.0f Mins")
            case 4
                PRINT #1,CHR$(9)+"Additional Last Qtr:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,AdditionalDateJD) * cMINS_PER_DAY,"  %03.0f Mins")
        END SELECT
        If MoonPhaseDeltas(nIndex,EclipseDateJD) = cJAN1901_JD Then
            PRINT #1,CHR$(9)+CHR$(9)+"NO ECLIPSE"
            EXIT SUB ' done
        End If
        If MoonMicaPhaseData(nIndex,EclipseDateJD) <> NO_ECLIPSE_OR_NOT_VISIBLE Then
			PRINT #1,CHR$(9)+"Eclipse Date:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,EclipseDateJD) * cMINS_PER_DAY,"  %03.0f Mins")
            If TempUmbraMag < 0 AND TempPenumbraMag > 0 Then
                PRINT #1, CHR$(9)+"Eclipe Type:"+CHR$(9)+CHR$(9)+" Penumbra"
                 If MoonMicaPhaseData(nIndex,Time1) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Penumbra First Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time1),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Penumbra First Contact:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time2) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Max Penumbra Eclipse:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time2),"  %02.0f Mins")
                Else 
					PRINT #1,CHR$(9)+"Max Penumbra Eclipse:"+CHR$(9)+" Moon not Visible"
               End If
                If MoonMicaPhaseData(nIndex,Time3) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Penumbra Last Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time3),"  %02.0f Mins")
                Else
					PRINT #1,CHR$(9)+"Penumbra Last Contact:"+CHR$(9)+" Moon not Visible"
                 End If
            End If ' end penumbra

            If TempUmbraMag > 0 AND TempUmbraMag < 1 Then
				PRINT #1,CHR$(9)+"Eclipe Type:"++CHR$(9)+CHR$(9)+" Partial Umbra"
                If MoonMicaPhaseData(nIndex,Time1) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Penumbra First Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time1),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Penumbra First Contact:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time2) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Penumbra First Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time2),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Umbra First Contact:"+CHR$(9)+" Moon not Visible"
               End If
                If MoonMicaPhaseData(nIndex,Time3) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Max Umbra Eclipse:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time3),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Max Umbra Eclipse:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time4) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Umbra Last Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time4),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Umbra Last Contact:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time5) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Umbra Last Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time5),"  %02.0f Mins")
				Else 
                    PRINT #1,CHR$(9)+"Penumbra Last Contact:"+CHR$(9)+" Moon not Visible"
                End If
            End If ' end umbra
            If TempUmbraMag > 1 Then
                PRINT #1,CHR$(9)+"Eclipe Type:"++CHR$(9)+CHR$(9)+" Full Umbra"
                If MoonMicaPhaseData(nIndex,Time1) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Penumbra First Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time1),"  %02.0f Mins")
                Else
                    PRINT #1,CHR$(9)+"Penumbra First Contact:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time2) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Umbra First Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time2),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Umbra First Contact:"+CHR$(9)+" Moon not Visible"
                 End If
                If MoonMicaPhaseData(nIndex,Time3)<> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Start Total Eclipse:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time3),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Start Total Eclipse:"+CHR$(9)+" Moon not Visible"
               End If
                If MoonMicaPhaseData(nIndex,Time4) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Max Total Eclipse:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time4),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Max Total Eclipse:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time5) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"End Total Eclipse:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time5),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"End Total Eclipse:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time6) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Umbra Last Contacte:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time6),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Umbra Last Contact:"+CHR$(9)+" Moon not Visible"
                End If
                If MoonMicaPhaseData(nIndex,Time7) <> LUNAR_ECLIPSE_NOT_VISIBLE Then
					PRINT #1,CHR$(9)+"Penumbra Last Contact:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,Time7),"  %02.0f Mins")
                Else 
                    PRINT #1,CHR$(9)+"Penumbra Last Contact:"+CHR$(9)+" Moon not Visible"
               End If
            End If ' end total eclipse
            If MoonMicaPhaseData(nIndex,UmbraMag) <> NO_CHECK_MAGNITUDE Then
				PRINT #1,CHR$(9)+"Umbra Magnitude:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,UmbraMag),"  %02.3f")
            Else
                PRINT #1,CHR$(9)+"Umbra Magnitude:"+CHR$(9)+"Umbra Magnitude not Checked"
            End If
            If MoonMicaPhaseData(nIndex,PenumbraMag) <> NO_CHECK_MAGNITUDE Then
				PRINT #1,CHR$(9)+"Penumbra Magnitude:"+CHR$(9)+FORMAT$(MoonPhaseDeltas(nIndex,PenumbraMag),"  %02.3f")
            Else
                PRINT #1,CHR$(9)"Penumbra Magnitude:"+CHR$(9)+"Umbra Eclipse so Magnitude not Checked"
            End If
        Else 
            PRINT #1,CHR$(9)+"No Eclipse or Eclipse not Visible so no MICA data to check against"
        End If
    End If'file open
END SUB

SUB FileMoonPhaseMAXErrors() 
    If FileOpen Then
        PRINT #1, CHR$(13)+CHR$(10)+CHR$(13)+CHR$(10)+CHR$(9)+CHR$(9)+"====================== MAX ERRORS ======================"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"New Moon:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(NewMoonJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"First Qtr:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(FirstQuarterJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Full Moon:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(FullMoonJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Last Qtr:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(LastQuarterJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Additional Phase:"+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(AdditionalDateJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Eclipse Date:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(EclipseDateJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Contact Time 1:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(Time1),"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Contact Time 2:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(Time2),"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Contact Time 3:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(Time3),"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Contact Time 4:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(Time4),"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Contact Time 5:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(Time5),"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Contact Time 6:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(Time6),"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Contact Time 7:"+CHR$(9)+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(Time7),"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Umbra Magnitude:"+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(UmbraMag),"  %02.3f")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Penumbra Magnitude:"+CHR$(9)+FORMAT$(MoonPhaseMaxErrors(PenumbraMag),"  %02.3f")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
    End If
End Sub


SUB FileSeasonErrors(nIndex As Integer)
    If FileOpen Then
        PRINT #1, CHR$(10)+CHR$(9)+"=============  SEASONS DIFFERENCE FROM MICA  ============="
        PRINT #1, CHR$(9)+"Command:"+ CHR$(9)+CHR$(9)+TestCmnds(nIndex)
		PRINT #1, CHR$(9)+"RETURN DATA:"
		PRINT #1, CHR$(9)+RetString
		PRINT #1, CHR$(9)+"March Equinox:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(SeasonDeltas(nIndex,MarchJD) * cMINS_PER_DAY,"  %02.0f Mins")
		PRINT #1, CHR$(9)+"June Solstices:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(SeasonDeltas(nIndex,JuneJD) * cMINS_PER_DAY,"  %02.0f Min")
		PRINT #1, CHR$(9)+"September Equinox:"+CHR$(9)+CHR$(9)+FORMAT$(SeasonDeltas(nIndex,SeptemberJD) * cMINS_PER_DAY,"  %02.0f Mins")
		PRINT #1, CHR$(9)+"December Solstices:"+CHR$(9)+CHR$(9)+FORMAT$(SeasonDeltas(nIndex,DecemberJD) * cMINS_PER_DAY,"  %02.0f Mins")
		PRINT #1, CHR$(9)+"June Total Daylight Hours:"+CHR$(9)+FORMAT$(SeasonDeltas(nIndex,JuneTotalHrs) * 60,"  %02.1f Mins")
		PRINT #1, CHR$(9)+"December Total Daylight Hours:"+CHR$(9)+FORMAT$(SeasonDeltas(nIndex,DecTotalHrs) * 60,"  %02.1f Mins")
        If SeasonDeltas(nIndex,LeapYear) Then
            PRINT #1, CHR$(9)+"Leap Year Correct"
        Else
            PRINT #1, CHR$(9)+"***************************** LEAP YEAR NOT CORRECT *****************************"
    End If
END SUB

SUB FileSeasonMAXErrors() 
    If FileOpen Then
        PRINT #1, CHR$(10)+CHR$(9)+CHR$(9)+"====================== MAX ERRORS ======================"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"March Equinox:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(SeasonMaxErrors(MarchJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"June Solstices:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(SeasonMaxErrors(JuneJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"September Equinox:"+CHR$(9)+CHR$(9)+FORMAT$(SeasonMaxErrors(SeptemberJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"December Solstices:"+CHR$(9)+CHR$(9)+FORMAT$(SeasonMaxErrors(DecemberJD) * cMINS_PER_DAY,"  %02.0f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"June Total Daylight Hours:"+CHR$(9)+FORMAT$(SeasonMaxErrors(JuneTotalHrs) * 60,"  %02.1f Mins")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"December Total Daylight Hours:"+CHR$(9)+FORMAT$(SeasonMaxErrors(DecTotalHrs) * 60,"  %02.1f Mins")+CHR$(9)+CHR$(9)+"*"
    End If
END SUB

SUB FilePlanetRTSErrors(nIndex As Integer)
	LOCAL As Integer i
    If FileOpen Then
        PRINT #1, CHR$(10)+CHR$(9)+"=============  PLANET RTS DIFFERENCE FROM MICA  ============="
        PRINT #1, CHR$(9)+"Command:"+ CHR$(9)+CHR$(9)+TestCmnds(nIndex)
		PRINT #1, CHR$(9)+"RETURN DATA:"
		PRINT #1, CHR$(9)+RetString
		FOR i = 0 TO 4
            SELECT CASE i
            case MERCURY_TST
                PRINT #1, CHR$(9)+"MERCURY"
            case VENUS_TST
                PRINT #1, CHR$(9)+"VENUS"
            case MARS_TST
               PRINT #1, CHR$(9)+"MARS"
            case JUPITER_TST
                PRINT #1, CHR$(9)+"JUPITER"
            case SATURN_TST
                PRINT #1, CHR$(9)+"SATURN"
            END SELECT ' end switch planeta name heading
			PRINT #1, CHR$(9)+"Transit:"+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,TransitMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,TransitAlt),"%03.0f Degrees")
			PRINT #1, CHR$(9)+"Rise:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,RiseMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,RizeAz),"%03.0fg Degrees")
			PRINT #1, CHR$(9)+"tSet:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,SetMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,SetAz),"%03.0f Degrees")
			PRINT #1, CHR$(9)+"Distance:"+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,RTSDISTANCE),"  %06.3f Million KM")
            if i < SUN_TST Then 
				PRINT #1, CHR$(9)+"Magnitude:"+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,RTSMAGNITUDE),"  %02.3f")
				PRINT #1, CHR$(9)+"Size:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSDelta(nIndex,i,RTSSIZE)," %03.1f Secs")
			End If
       NEXT i ' for
    End If ' file open
END SUB



SUB FilePlanetRTSMAXErrors() 
    If FileOpen Then
       PRINT #1, CHR$(10)+CHR$(9)+"====================== MAX ERRORS ======================"
	   PRINT #1, CHR$(9)+"*"+CHR$(9)+"Transit:"+CHR$(9)+FORMAT$(PlanetRTSMAXError(TransitMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSMAXError(TransitAlt),"%03.0f Degrees")+CHR$(9)+CHR$(9)+"*"
	   PRINT #1, CHR$(9)+"*"+CHR$(9)+"Rise:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSMAXError(RiseMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSMAXError(RizeAz),"%03.0f Degrees")+CHR$(9)+CHR$(9)+"*"
	   PRINT #1, CHR$(9)+"*"+CHR$(9)+"Set:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSMAXError(SetMin),"  %02.0f Mins")+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSMAXError(SetAz),"%03.0f Degrees")+CHR$(9)+CHR$(9)+"*"
	   PRINT #1, CHR$(9)+"*"+CHR$(9)+"Distance:"+CHR$(9)+FORMAT$(PlanetRTSMAXError(RTSDISTANCE),"  %06.3f Million KM")+CHR$(9)+CHR$(9)++CHR$(9)+CHR$(9)+"*"
	   PRINT #1, CHR$(9)+"*"+CHR$(9)+"Magnitude:"+CHR$(9)+FORMAT$(PlanetRTSMAXError(RTSMAGNITUDE),"  %02.3f")+CHR$(9)+CHR$(9)+CHR$(9)++CHR$(9)+CHR$(9)+"*"
	   PRINT #1, CHR$(9)+"*"+CHR$(9)+"Size:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetRTSMAXError(RTSSIZE)," %03.1f Secs")+CHR$(9)+CHR$(9)+CHR$(9)++CHR$(9)+CHR$(9)+"*"
    End If
END SUB

SUB FileObjectPOSErrors(nIndex As Integer, nObject As Integer) 
    If FileOpen Then
		PRINT #1, CHR$(10)+CHR$(9)+"=============  POSITION DIFFERENCE FROM MICA  ============="
        SELECT CASE nObject
        case MERCURY_TST
            PRINT #1, CHR$(9)+"============= MERCURY "
        case VENUS_TST
            PRINT #1, CHR$(9)+"============= VENUS "
        case MARS_TST
            PRINT #1, CHR$(9)+"============= MARS "
        case JUPITER_TST
            PRINT #1, CHR$(9)+"============= JUPITER "
        case SATURN_TST
            PRINT #1, CHR$(9)+"============= SATURN "
        case SUN_TST
            PRINT #1, CHR$(9)+"============= SUN "
        case MOON_TST
            PRINT #1, CHR$(9)+"============= MOON "
 		END SELECT
        PRINT #1, CHR$(9)+"Command:"+ CHR$(9)+CHR$(9)+TestCmnds(nIndex)
		PRINT #1, CHR$(9)+"RETURN DATA:"
		PRINT #1, CHR$(9)+RetString
		PRINT #1, CHR$(9)+"Azimuth:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IAZIMUTH),"  %03.2f Degrees ")+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IALT)," Altitude:  %03.2f Degrees")
        If nObject < MOON_TST Then 
			PRINT #1, CHR$(9)+"Distance:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IDISTANCE),"  %06.3f Million KM")
        Else
			PRINT #1, CHR$(9)+"Distance:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IDISTANCE),"  %06.3f KM")
        End If
		PRINT #1, CHR$(9)+"Rt Asc:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IRTASC) * 60,"  %03.2f Minutes ")+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IDEC)," Declination:  %03.2f Degrees")
        If nObject < SUN_TST Then ' planets
			PRINT #1, CHR$(9)+"Heliocentric Long:"+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,ILONG),"  %03.2f Degrees ")+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,ILAT)," Heliocentric Lat:  %03.2f Degrees")
			PRINT #1, CHR$(9)+"Magnitude:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IMAGNITUDE),"  %02.1f ")+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,ISIZE)," Size:  %03.1f Arc Seconds")
			PRINT #1, CHR$(9)+"Earth Heliocentic Long:"+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IEARTHLONG),"  %03.2f Degrees") ' lat essentially zero degrees so not included
			PRINT #1, CHR$(9)+"Planet-Sun Dist:"+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IPLANETSUNDIST),"  %02.6f AU")
			PRINT #1, CHR$(9)+"Earth-Sun Dist:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IEARTHSUNDIST),"  %02.6f AU")
        End If
        If nObject = MOON_TST Then
			PRINT #1, CHR$(9)+"Geocentric Long:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,ILONG),"  %03.2f Degrees ")+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,ILAT)," Geocentric ILAT:  %03.2f Degrees")
			PRINT #1, CHR$(9)+"Illumination Fraction:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IMOON_ILLUM),"  %02.3f  ")+CHR$(9)+FORMAT$(PlanetPOSDelta(nIndex,IMOON_POS_ANGLE)," Phase Angle:  %03.2f Degrees")
        End If
    End If
END SUB



SUB FilePlanetPOSMAXErrors() 
    If FileOpen Then
        PRINT #1, CHR$(10)+CHR$(9)+"====================== MAX ERRORS ======================"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Azimuth:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IAZIMUTH)," %03.2f Degrees")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Altitude:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IALT)," %03.2f Degrees")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Distance (Sun/Planets):"+CHR$(9)+FORMAT$(PlanetPOSMAXError(IDISTANCE),"  %02.3f Million KM")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Distance (Moon):"+CHR$(9)+FORMAT$(MoonMaxErrorDistance," %02.3f KM")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Rt Asc:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IRTASC) * 60," %03.2f Minutes")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Declination:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IDEC)," %03.2f Degrees")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Long:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(ILONG)," %03.2f Degrees")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Lat:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(ILAT)," %03.2f Degrees")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Magnitude:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IMAGNITUDE)," %02.1f")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Size:"+CHR$(9)+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(ISIZE)," %03.1f Arc Seconds")+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Illumination Fraction:"+CHR$(9)+FORMAT$(PlanetPOSMAXError(IMOON_ILLUM)," %02.3f")+CHR$(9)+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Phase Angle:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IMOON_POS_ANGLE)," %03.2f Degrees")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Earth Long:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IEARTHLONG)," %03.2f Degrees")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Planet-Sun Dist:"+CHR$(9)+FORMAT$(PlanetPOSMAXError(IPLANETSUNDIST)," %02.6f AU")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
		PRINT #1, CHR$(9)+"*"+CHR$(9)+"Earth-Sun Dist:"+CHR$(9)+CHR$(9)+FORMAT$(PlanetPOSMAXError(IEARTHSUNDIST)," %02.6f AU")+CHR$(9)+CHR$(9)+CHR$(9)+"*"
    End If
END SUB

'===================================================================================================================================

SUB CompToMICA
	LOCAL As Integer nIndex = 0
	
	Print ""
	PRINT "STARTING MICA 2.0 Compare"
	
	' =============================================================================================
	' Adelaide, Australia, Time Zone +9.5Hrs
	RetString = ManageCommand_F("1,-34.76639,138.5367,9.5,10.5,10,1,0,2,4,1,0,3")
	OpenOutFile
	TestWriteFile "==========================================================================================================="
	TestWriteFile "==========================================================================================================="
	TestWriteFile "	LOCATION: ADELAIDE, SOUTH AUSTRALIA, LAT = -34.76639  LONG = 138.5367, TIMEZONE = 9.5HRS"
	TestWriteFile "	DAYLIGHT SAVINGS STARTS: FIRST WEEK OCTOBER AT 2AM LOCAL, ENDS: FIRST WEEK APRIL AT 3AM LOCAL"
	TestWriteFile "==========================================================================================================="
	TestWriteFile "===========================================================================================================\n"
'If 0 Then	
	' Test Sun & Moon RTS
	SetSunMoonRTSMICAData ' set MICA data to test against
	SetSunMoonTestCmnds 
	For nIndex = 0 To 9
		RetString = GetYearlyCmnd(nIndex, SUN_MOON_RTS) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		SunMoonRTSCompMICA_To_Prog RetString, nIndex 
		FileSunMoonRTSErrors nIndex 'save in file
	Next nIndex
	FileSunMoonMAXErrors
	'====================================
	' Moon phases and lunar Eclipse
	'nIndex = 0
	SetMoonPhaseMICAData
	SetMoonPhaseTestCmnds
	For nIndex = 0 To 9
		RetString = GetYearlyCmnd(nIndex, MOON_PHASES) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		MoonPhaseCompMICA_To_Prog RetString, nIndex 
		FileMoonPhaseErrors nIndex ' save in file
	Next nIndex
	FileMoonPhaseMAXErrors
	'====================================
	' Seasons
	SetSeasonMICAData
	SetSeasonTestCmnds
	For nIndex = 0 To 4
		RetString = GetYearlyCmnd(nIndex, SEASONS) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		SeasonCompMICA_To_Prog RetString, nIndex 
		FileSeasonErrors nIndex 'save in file
	Next nIndex
	FileSeasonMAXErrors
	'================================
	' Planet RTS
	SetPlanetRTSMICAData
	SetPlanetRTSTestCmnds
	nIndex = 0
	For nIndex = 0 To 4
		RetString = GetYearlyCmnd(nIndex, PLANET_RTS_POS_TST) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		PlanetRTSCompMICA_To_Prog RetString, nIndex 
		FilePlanetRTSErrors nIndex ' save in file
	Next nIndex
	FilePlanetRTSMAXErrors
	'================================
	' Planet Position
	LOCAL As Integer nObject
	ResetPOSMAX
	For nObject = MERCURY_TST To 6
		SetPlanetPOSMICAData nObject
		SetObjectPOSTestCmnds nObject
		For nIndex = 0 To 4
			If nObject < SUN_TST Then
				RetString = GetYearlyCmnd(nIndex, PLANET_RTS_POS_TST) 'get command for specified date
			else
				RetString = GetYearlyCmnd(nIndex, SUN_MOON_RTS) ' cmnd is less than 2 digits
			End If
			RetString = ManageCommand_F(RetString) ' do yearly task
			RetString = GetTestCmndStr(nIndex)
			RetString = ManageCommand_F(RetString) 'actual command
			PlanetPOSCompMICA_To_Prog RetString, nIndex, nObject ' see if this date compares
			FileObjectPOSErrors nIndex, nObject ' save in file
		Next nIndex
	Next nObject 'outer loop
	FilePlanetPOSMAXErrors
	
'Else
	' ==================================================================================================================
	' LOCATION CHANGE to Devon Canada, DST starts 2 week of March and ends first week November, All changes at 2 am local, Time zone -7 Hrs
	RetString = ManageCommand_F("1,53.390,-113.75833,-7.0,-6.0,3,2,0,2,11,1,0,2")
	TestWriteFile "===========================================================================================================\n"
	TestWriteFile "===========================================================================================================\n"
	TestWriteFile "	LOCATION: DEVON, CANADA, LAT = 53.390  LONG = -113.75833, TIMEZONE = -7HRS\n"
	TestWriteFile "	DAYLIGHT SAVINGS STARTS: SECOND WEEK MARCH AT 2AM LOCAL, ENDS: FIRST WEEK NOVEMBER AT 2AM LOCAL \n"
	TestWriteFile "===========================================================================================================\n"
	TestWriteFile "===========================================================================================================\n\n"
	
	' Test Sun & Moon RTS
	SetSunMoonRTSMICADataTwo ' set MICA data to test against
	SetSunMoonTestCmndsTwo 
	For nIndex = 0 To 3
		RetString = GetYearlyCmnd(nIndex, SUN_MOON_RTS) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		SunMoonRTSCompMICA_To_Prog RetString, nIndex 
		FileSunMoonRTSErrors nIndex 'save in file
	Next nIndex
	FileSunMoonMAXErrors
	'================================
	' Moon phases and lunar Eclipse
	SetMoonPhaseMICADataTwo
	SetMoonPhaseTestCmndsTwo
	For nIndex = 0 To 3
		RetString = GetYearlyCmnd(nIndex, MOON_PHASES) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		MoonPhaseCompMICA_To_Prog RetString, nIndex 
		FileMoonPhaseErrors nIndex ' save in file
	Next nIndex
	FileMoonPhaseMAXErrors
	'====================================
	' Seasons
	SetSeasonMICADataTwo
	SetSeasonTestCmnds
	For nIndex = 0 To 4
		RetString = GetYearlyCmnd(nIndex, SEASONS) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		SeasonCompMICA_To_Prog RetString, nIndex 
		FileSeasonErrors nIndex 'save in file
	Next nIndex
	FileSeasonMAXErrors
	'================================
	' Planet RTS
	SetPlanetRTSMICADataTwo
	SetPlanetRTSTestCmndsTwo
	nIndex = 0
	For nIndex = 0 To 1
		RetString = GetYearlyCmnd(nIndex, PLANET_RTS_POS_TST) ' get command for specified date
		RetString = ManageCommand_F(RetString) ' do yearly task
		RetString = GetTestCmndStr(nIndex)
		RetString = ManageCommand_F(RetString) 'actual command
		PlanetRTSCompMICA_To_Prog RetString, nIndex 
		FilePlanetRTSErrors nIndex ' save in file
	Next nIndex
	FilePlanetRTSMAXErrors
	'================================
	' Planet Position
	ResetPOSMAX
	For nObject = MERCURY_TST To 6
		SetPlanetPOSMICADataTwo nObject
		SetObjectPOSTestCmndsTwo nObject
		For nIndex = 0 To 1
			If nObject < SUN_TST Then
				RetString = GetYearlyCmnd(nIndex, PLANET_RTS_POS_TST) 'get command for specified date
			else
				RetString = GetYearlyCmnd(nIndex, SUN_MOON_RTS) ' cmnd is less than 2 digits
			End If
			RetString = ManageCommand_F(RetString) ' do yearly task
			RetString = GetTestCmndStr(nIndex)
			RetString = ManageCommand_F(RetString) 'actual command
			PlanetPOSCompMICA_To_Prog RetString, nIndex, nObject ' see if this date compares
			FileObjectPOSErrors nIndex, nObject ' save in file
		Next nIndex
	Next nObject 'outer loop
	FilePlanetPOSMAXErrors
	
	CloseOutFile
	PRINT "END MICA 2.0 Compare"
END SUB

CLS
CompToMICA






