
 
  
' COMMANDS
CONST COMMAND_INITIALISE = 1
CONST COMMAND_YEARLY_TASK =2
CONST COMMAND_SUN_MOON_TRS = 3
CONST COMMAND_TO_UTC = 4
CONST COMMAND_FROM_UTC = 5
CONST COMMAND_MOON_PHASES = 6
CONST COMMAND_SEASONS = 7
CONST COMMAND_INSTANT_SUN = 8
CONST COMMAND_INSTANT_MOON = 9
CONST COMMAND_INSTANT_MERCURY = 10
CONST COMMAND_INSTANT_VENUS = 11
CONST COMMAND_INSTANT_MARS = 12
CONST COMMAND_INSTANT_JUPITER = 13
CONST COMMAND_INSTANT_SATURN = 14
CONST COMMAND_PLANET_TRS = 15

CONST COMMAND_HIGHEST_NUMBER = 15 ' above will get error

' Errors
CONST NO_ERROR ="0"
CONST ERROR_LAT_FIELD ="1"
CONST ERROR_LONG_FIELD ="2"
CONST ERROR_TIME_ZONE_FIELD ="3"
CONST ERROR_DST_TIME_ZONE_FIELD ="4"
CONST ERROR_DST_START_MONTH_FIELD ="5"
CONST ERROR_DST_START_WEEK_FIELD ="6"
CONST ERROR_DST_START_DAY_FIELD="7"
CONST ERROR_DST_START_HOUR_FIELD ="8"
CONST ERROR_DST_END_MONTH_FIELD ="9"
CONST ERROR_DST_END_WEEK_FIELD ="10"
CONST ERROR_DST_END_DAY_FIELD ="11"
CONST ERROR_DST_END_HOUR_FIELD ="12"
CONST ERROR_YEARLY_TASK_ONE ="13"
CONST ERROR_INITIALISE_NOT_COMPLETED ="14"
'CONST ERROR_DAILY_TASK_ONE ="15"
CONST ERROR_DATE_OUTSIDE_LIMIT ="16"
'CONST ERROR_TO_LOCAL_OUTSIDE_LIMIT =17
'CONST ERROR_SUN_INSTANT_OUTSIDE_LIMIT =18
CONST ERROR_COMMAND_NOT_KNOWN ="20"

' CONSTANTS	
CONST cTWO_PI = PI * 2.0  
CONST cHALF_PI =1.57079632679490
CONST cAU_MILLKM =149.597871 ' million km in one UA 
CONST cSEC_PER_DAY =86400
CONST cMINS_PER_DAY =1440
CONST HR_FRACTION_DAY =0.041666666666' 1/24
CONST HALF_MINUTE_AS_DAY =3.4722222222222E-4
CONST KM_IN_AU =149597871
CONST AU_TO_MILLION_KM =149.597871
CONST C_SPEED_PER_MILLION_KM_IN_DAY =25902 ' Distance (mill km)/ this number = time of light travel travel per day
CONST C_SPEED_PER_AU_IN_DAY =0.0057755183
'CONST cSECOND_DAY= 0.00001157407L ' seconds as a fraction of a day
CONST cFIVE_SECOND_DAY =5.787037E-5 ' 5 seconds as a fraction
CONST cTEN_SECONDS_AS_DAY =0.00011574
CONST cTWENTY_SEC_AS_DAY= 0.00023148
CONST cTHIRTY_SECONDS_AS_DAY =0.0003472
CONST cTHIRTY_SECONDS_AS_HOUR =0.0083333
CONST cMINUTE_AS_DAY =0.00069444
CONST cHR_AS_DAY =0.04166666667
CONST cFEB21000_JD =2488100.5
CONST cMAR1901_JD =2415445.5
CONST cJAN1901_JD =2415385.5
'CONST INCLUDE_DELTA_T true
'CONST SKIP_DELTA_T false
CONST CALC_ALLTD =1
CONST SKIP_CALC_ALLTD =0
CONST SKIP_INTERPOLATION_RISE_SET =0
CONST DO_INTERPOLATION_RISE_SET =1
CONST SKIP_SECONDS =0
CONST INCLUDE_SECONDS =1
CONST SKIP_TIME =0
CONST INCLUDE_TIME =1
CONST WHOLE_NUMBER =0
CONST INCLUDE_TENTHS =1
CONST INCLUDE_HUNDREDS =2
CONST DO_INTERPOLATION =1
CONST SET_NEAREST_MIN =1
CONST SKIP_NEAREST_MIN =0
CONST DAY_CORRECT =1
CONST NOT_CORRECT_DAY =0
CONST APPEND_COMMA =1
CONST SKIP_COMMA =0
CONST RETURN_M_AS_DAY =1
CONST CONVERT_M_TO_HRS =2
CONST CORRECT_DATE =0
CONST DAY_BEFORE =-1
CONST DAY_AFTER =1
CONST SOURCE_UTC =1 
CONST SOURCE_LOCAL =2
CONST UTC_TIME =1
CONST LOCAL_TIME =0
CONST MAX_FIX_ITERATIONS =4000 ' prevent getting lost on dodgy numbers when using FixP1ToZeroToP2
CONST NO_TRANSIT =-1000.0
CONST CALC_ALL_CALCULATIONS =1
CONST CALC_COORDS_ONLY =2
CONST CALC_DISTANCE_ONLY =3
CONST NO_ADDITIONAL_PHASE =0
CONST ADDTIONAL_NEW_MOON =1
CONST ADDTIONALFIRST_QTR =2
CONST ADDTIONAL_FULL_MOON =3
CONST ADDTIONAL_LAST_QTR =4


CONST SUN =1
CONST MOON =2
CONST MERCURY =3
CONST VENUS =4
CONST MARS =5
CONST JUPITER =6
CONST SATURN =7

CONST MAX_RISE_SET_ITERATIONS =5
CONST MIN_MOON_RISE_SET_ITERATION =2
CONST MAX_MOON_RISE_SET_ITERATION =8
CONST MAX_CHAR_INPUT_STRING_FIELD =40 ' max chars in a comma delim field on main input string
CONST CENTURY =1
CONST MILLENNIA =2
'CONST SKIP_CALC_ALLTD =0

' Input String Fields
' Command
CONST COMMAND_FIELD =1 ' first field in all input strings 
' Initialise String
CONST LAT_FIELD =2
CONST LONG_FIELD =3
CONST TIME_ZONE_FIELD =4
CONST DST_TIME_ZONE_FIELD =5
CONST DST_START_MONTH_FIELD =6
CONST DST_START_WEEK_FIELD =7
CONST DST_START_DAY_FIELD =8
CONST DST_START_HOUR_FIELD =9
CONST DST_END_MONTH_FIELD =10
CONST DST_END_WEEK_FIELD =11
CONST DST_END_DAY_FIELD =12
CONST DST_END_HOUR_FIELD =13
' Date Time fields
CONST DATE_FIELD =1
CONST TIME_FIELD =2
CONST DAILY_TASK_TWO_DATE_FIELD =1
CONST SEASONS_DATE_FIELD =1
CONST ECLIPSE_START_STRING =87 ' eclipse string starts 88 chars into the Moon phase string


' Steps that must be completed prior to some calls
CONST INITIALISED_FAILED =0
CONST INITIALISED_COMPLETED =1
CONST DAILY_TASKS_ONE_COMPLETED =2

CONST INDEX_M0_OFFSET =0
CONST INDEX_M1_OFFSET =1
CONST INDEX_M2_OFFSET =2
CONST NEVER_TRANSIT_RISE_SET_PLUS =-1
CONST NEVER_TRANSIT_RISE_SET_NEG =-2
CONST CALC_AZIMUTH_MODE_RISE =1
CONST CALC_AZIMUTH_MODE_SET =2

' WORKING ARRAY INDEXES
CONST DATE_CHECK_D =0 ' not used in functions but may be useful to user to see what time zone is being used for day after Daily Task One
CONST SITE_LATITUDE_DEG =1
CONST SITE_LONGTITUDE_DEG =2
' Times
CONST TIME_ZONE =3 'hrs from GMT not in DST, User Must Set
CONST DST_TIME_ZONE= 4 'hrs from GMT when in DST, User Must set
CONST IN_DST =5 ' 0 if not DST, 1 if DST
CONST CURR_TIME_ZONE =6 ' current GMT offset depending on DST
CONST DST_START_MONTH =7
CONST DST_START_DAY =8 ' Sunday is 0'
CONST DST_START_WEEK =9
CONST DST_START_HOUR =10 ' local
CONST DST_END_MONTH =11
CONST DST_END_DAY =12
CONST DST_END_HOUR =13 ' local
CONST DST_END_WEEK =14
CONST UTC_HOUR =15 ' time conversion
CONST UTC_MIN =16
CONST UTC_SEC =17
CONST UTC_YEAR =18
CONST UTC_MONTH =19
CONST UTC_DATE =20
CONST LOCAL_HOUR =21 ' time conversion
CONST LOCAL_MIN =22
CONST LOCAL_SEC =23
CONST LOCAL_YEAR =24
CONST LOCAL_MONTH =25
CONST LOCAL_DATE =26
CONST LOCAL_DAY =27
CONST EARTH_ORBIT_ECC =28
CONST EARTH_JDE_CALCULATED =29 'what the earth position was calculated at, can save repeating calcs
CONST DELTA_TIME_DAYS =30
CONST APPARENT_G_SIDEREAL_TIME_DEG =31
CONST MEAN_G_SIDEREAL_TIME_DEG =32
CONST NUTATION_LONG_SECS =33
CONST NUTATION_OBLIQ_SECS =34
CONST MEAN_OBLIQ_ECLIP_RAD =35
CONST TRUE_OBLIQ_ECLIP_RAD =36
CONST CALC_JD =37
CONST CALC_T =38 'based on century
CONST CALC_2T =39
CONST CALC_3T =40
CONST ECLIPTIC_LONG_RAD =41
CONST GEO_LONG_RAD =41
CONST ECLIPTIC_LAT_RAD =42
CONST GEO_LAT_RAD =42
CONST TEMP_RT_ASCENSION_RAD =43 ' Used in Transformation of coords
CONST TEMP_DECLIN_RAD =44 
CONST TEMP_HORIZ_AZ_RAD =45 ' note this will need Pi added to get it in correct direction
CONST TEMP_HORIZ_ALTITUDE_RAD =46
CONST CORR_OBLIQ_ECLIP_RAD =47
CONST UTC00HR_APP_G_SIDEREAL_TIME_DEG =48
CONST CALC_OBJECT_UPDATED_JDE =49
CONST INITIALISED_STEP =50 ' set to 1 if initialised else its zero
CONST DST_UTC_START_JD =51 ' times are UTC
CONST DST_UTC_END_JD =52
CONST OBJECT_INITIAL_M0 =53 ' Transit,Rise and Set
CONST OBJECT_INITIAL_M1 =54
CONST OBJECT_INITIAL_M2 =55
CONST INTERPOLATE_PERIOD_AS_DAY =56
CONST RISE_SET_M0 =57 ' these 3 M must be consecutive in array starting with RISE_SET_M0
CONST RISE_SET_M1 =58
CONST RISE_SET_M2 =59
CONST INTERPOLATE_N =60
CONST RISE_SET_CIRCUMPOLAR =61 ' -1.0 if not circumpolar, +1.0 if circumpolar
CONST RTASC_ONE_RAD =62
CONST DECLIN_ONE_RAD =63
CONST RTASC_TWO_RAD =64
CONST DECLIN_TWO_RAD= 65
CONST RTASC_THREE_RAD =66
CONST DECLIN_THREE_RAD =67
CONST RISE_SET_h0_RAD =68 ' little h
CONST TRANSIT_HR =69 ' these 3 must be consecutive in array, starting with TRANSIT_HR
CONST RISE_HR =70
CONST SET_HR =71
CONST TRS_TRANSIT_RHA_RAD =72
CONST TRS_TRANSIT_DEC_RAD =73
CONST TRS_RISE_RHA_RAD =74
CONST TRS_RISE_DEC_RAD =75
CONST TRS_SET_RHA_RAD =76
CONST TRS_SET_DEC_RAD =77
CONST TEMP_1 =78
CONST TEMP_2 =79
CONST TEMP_3 =80
CONST TEMP_4 =81
CONST TEMP_5 =82
CONST TEMP_6 =83
CONST TEMP_7 =84
CONST TEMP_8 =85
CONST TEMP_9 =86
CONST TEMP_10 =87
CONST TEMP_11= 88
CONST TEMP_12 =89
CONST TEMP_13 =90
CONST TEMP_14 =91
CONST TEMP_15 =92
CONST TEMP_16 =93
CONST TEMP_17 =94
CONST TEMP_18 =95
CONST TEMP_19 =96
CONST TEMP_20 =97
CONST TEMP_21 =98
CONST TEMP_22 =99
CONST PLANET_PHASE_ANGLE_I_DEG =100
CONST SUN_RT_ASCENSION_RAD =101 ' as above
CONST SUN_DECLIN_RAD =102
CONST SUN_DISTANCE_MKM =103
CONST SUN_APPARENT_LONG_RAD =104
CONST LAST_INDEX =105


' Moon
CONST MOON_GEO_LONG_DEG =TEMP_1
CONST MOON_GEO_LAT_DEG =TEMP_2
CONST MOON_DISTANCE_KM =TEMP_3
CONST MOON_PARALLAX_RAD =TEMP_4
CONST MOON_APPARENT_LONG_RAD =TEMP_5
CONST MOON_APPARENT_RASC_RAD =TEMP_6
'CONST PLANET_APPARENT_RASC_RAD =TEMP_6
CONST MOON_APPARENT_DEC_RAD =TEMP_7
'CONST PLANET_APPARENT_DEC_RAD =TEMP_7
CONST MOON_ILLUM_FRACTION =TEMP_8
CONST MOON_POSITION_ANGLE_DEG =TEMP_9

'Planet Position
CONST PLANET_DISTANCE =TEMP_1 
CONST CALC_PLAN_ECLIP_LONG_RAD =TEMP_2 'planets position
CONST CALC_PLAN_ECLIP_LAT_RAD =TEMP_3 'planets position
CONST CALC_PLAN_RAD_VEC_AU =TEMP_4 'planets position
CONST CALCTRS_OBJECT_DTC00_JD =TEMP_22
CONST CALC_PLAN_T1 =TEMP_6
CONST CALC_PLAN_T2 =TEMP_7
CONST CALC_PLAN_T3 =TEMP_8
CONST CALC_PLAN_T4 =TEMP_9
CONST CALC_PLAN_T5 =TEMP_10
CONST TRANSIT_DISTANCE =TEMP_11 ' used in moon & planet transit,rise,set
CONST CALC_EARTH_RAD_VEC_AU =TEMP_12 'earth position, used in planet position
CONST CALC_EARTH_ECLIP_LAT_RAD =TEMP_13 'earth position
CONST CALC_EARTH_ECLIP_LONG_RAD =TEMP_14 'earth position
CONST CALC_PLANET_X =TEMP_15
CONST CALC_PLANET_Y =TEMP_16
CONST CALC_PLANET_Z =TEMP_17
CONST CALC_PLAN_DISTANCE =TEMP_18 ' from earth
CONST STRING_OBJECT_DISTANCE =TEMP_19
' moon phases
CONST CALC_M =TEMP_1
CONST CALC_M_DASH =TEMP_2
CONST CALC_F =TEMP_3
CONST CALC_O =TEMP_4
CONST CALC_E =TEMP_5
CONST CALC_K =TEMP_6
CONST CALC_MOON_PHASE_JDE =TEMP_7 
CONST CALC_A1 =TEMP_8
CONST CALC_A2 =TEMP_9
CONST CALC_A3 =TEMP_10
CONST CALC_A4 =TEMP_11
CONST CALC_A5 =TEMP_12
CONST CALC_A6 =TEMP_13
CONST CALC_A7 =TEMP_14
CONST CALC_A8 =TEMP_15
CONST CALC_A9 =TEMP_16
CONST CALC_A10 =TEMP_17
CONST CALC_A11 =TEMP_18
CONST CALC_A12 =TEMP_19
CONST CALC_A13 =TEMP_20
CONST CALC_A14 =TEMP_21

CONST I_DAY_OF_MONTH = 0
CONST I_MONTH = 1
CONST I_YEAR = 2
CONST I_HOUR = 0
CONST I_MIN = 1
CONST I_SEC =2

'=========================================== GLOBAL VARIABLES ===================================================================
DIM  Float dWorking(LAST_INDEX) ' hangover from the C code but works
DIM  Float DateStruct(2) ' stores a date as Date of Month, Month and then Year, Note Day can be fraction
DIM  Float TimeStruct(2) ' stores a time as Hour, Min and Sec
DIM  Integer nGenCount ' counter used within a function
DIM  Float lf_DayFraction, lf_Day, lf_Hour
DIM  Float dJDE, CalcT, Calc2T, Calc3T, dL, dLDash, dOmega
DIM  Float dL0, dTrueLong, dHour 
DIM  Float dA,dB,dC,dD,dE,dF,dM, dV,dMDash, dT
DIM  Float dTransitDistanceJD, dInitialJD, dDayLength,dUTC00Hour
DIM  Float dL1, dB0, dB1, dR0, dR1, dT1, dT2, dT3, dT4
DIM  String TempString

'=========================================== GENERAL HELPERS ===================================================================

DIM FLOAT dTempHelpers

DIM  Integer nHelperCount
 ' used in some functions

FUNCTION FMOD_F(A as Float, B as Float) As Float
	' calculates the FMOD_F, as remainder of A /B, use as  FMOD_F(A,B)
	FMOD_F = A - (B * Fix(A / B))
END FUNCTION

FUNCTION DoubleFraction_F(dNumber as FLOAT) AS FLOAT
	' returns the fraction part of the number
	DoubleFraction_F = dNumber - FIX(dNumber)
END FUNCTION


FUNCTION Within0to360_F(dNumber AS float) AS Float
	' return within 0 to 360
	Within0to360_F = FixP1ToZeroToP2_F(dNumber, 360)
END FUNCTION

FUNCTION Within0ToPI_F(dNumber AS float) AS Float
	'return 0 to PI
	Within0ToPI_F = FixP1ToZeroToP2_F(dNumber, PI)
END FUNCTION

FUNCTION Within0To2PI_F(dNumber AS float) AS Float
	' returns within 0 to 2 * PI
	Within0To2PI_F = FixP1ToZeroToP2_F(dNumber, cTWO_PI)
END FUNCTION

FUNCTION FixP1ToZeroToP2_F(dNumber AS float, dLimit AS float) AS Float
	'returns fixed between 0 and less than dLimit, dLimit is allways positive, dNumber not impacted
	if dNumber >= 0 AND dNumber < dLimit Then
		FixP1ToZeroToP2_F = dNumber
		EXIT FUNCTION ' do nothing as OK
	End If 
	dTempHelpers = FMOD_F(dNumber, dLimit)
	if dNumber < 0.0 Then
		dTempHelpers = dLimit + dTempHelpers
	End If
	FixP1ToZeroToP2_F = dTempHelpers
END FUNCTION

' these will extract DMS from hour or degree
FUNCTION ExtractDegree_F(dDeg AS float) As Float
	ExtractDegree_F = FIX(dDeg)
END FUNCTION

FUNCTION ExtractMin_F(dDeg AS float) As Float
	ExtractMin_F = FIX(DoubleFraction_F(dDeg) * 60.0) ' mins
END FUNCTION

FUNCTION ExtractSecond_F(dDeg AS float) As Float
	dTempHelpers = DoubleFraction_F(DoubleFraction_F(dDeg) * 60.0)
	ExtractSecond_F = FIX((dTempHelpers * 60.0)) ' mins into secs
END FUNCTION

FUNCTION HourMinSecToString_F(inString As String, dHour As float, dMin As float, dSec As float, nIncludeSec As Integer, nAppendComma as Integer) as String
	' appends Hr, Min and Sec (if !nSkipSec) to a string 
	' assumes hour, min and sec between 0 to 60, i.e 2 digits
	' if nSkipSec == SKIP_SECONDS then skips doing seconds, else if INCLUDE_SECONDS does secs
	' if nAppendComma APPEND_COMMA then comma appended to last char, NO_APPEND_COMMA = no comma
	' string as HH:MM:[SS][,] 
	'  Returns a string 
	' check for nonsence first
	if ABS(dHour) >= 24 OR ABS(dMin) >= 60 OR ABS(dMin) >= 60 then
		HourMinSecToString_F = inString + "NIL,"
	Else
		HourMinSecToString_F = inString + format$(dHour,"%02g:") + format$(dMin,"%02g")
		if nIncludeSec then
			HourMinSecToString_F = HourMinSecToString_F + format$(dHour,":%02g") 
		end if
		if nAppendComma then
			HourMinSecToString_F = HourMinSecToString_F + ","
		endif
	End If
END FUNCTION
	
FUNCTION DateToString_F(inString As String, dYear As Float, dMonth As Float, dDate As Float,  nAppendComma As Integer) AS String
	' Appends the converted Date to a string as DD-MM-YYYY[,] i.e 10 chars (no append comma) or 11 chars if comma + 1 for size
	' assumes year 4 digits and month and Date are 2 digits
	' if nAppendComma APPEND_COMMA then comma appended to last char, NO_APPEND_COMMA = np comma
	'  Return String 
	DateToString_F = inString + format$(dDate,"%02g-") + format$(dMonth,"%02g-")+ format$(dYear,"%04g")
	if nAppendComma = APPEND_COMMA Then DateToString_F = DateToString_F + ","
END FUNCTION

FUNCTION GetHourFromFloatHour_F(fHour As float) As Float
	' can be used for degrees
	if fHour > 360 then
		GetHourFromFloatHour_F =  0
	else 
		GetHourFromFloatHour_F = FIX(fHour)
	end if
END FUNCTION

FUNCTION GetMinsFromFloatHour_F(fHour AS Float) AS Float
	if fHour > 24 then
		GetMinsFromFloatHour_F =  0
	else 
		GetMinsFromFloatHour_F = FIX(DoubleFraction_F(fHour) * 60.0)
	end if
END FUNCTION

FUNCTION GetSecsFromFloatHour_F(fHour As Float) AS Float
	if fHour > 24 then
		GetSecsFromFloatHour_F =  0
	else 
		dTempHelpers = DoubleFraction_F(DoubleFraction_F(fHour) * 60.0)
		GetSecsFromFloatHour_F =FIX((dTempHelpers * 60.0))
	end if
END FUNCTION

SUB TrimLeadingSpaces_S(inString As String)
	' trim all leading spaces from inString
	DO While Instr(" ", Left$(inString, 1))
		inString = Mid$(inString, 2)
	LOOP
END SUB


'=========================================== GENERAL ASTRO HELPERS ===================================================================
FUNCTION GetDayFromJD_F(JD As Float) As Float
	' AA Ch 7, pp 65.
	' calculates day from from Julian Day (at 0hr on date), Output is  Sunday = 0, Mon = 1, Tue = 2... Sat = 6 
	JD = JD + 1.5
	GetDayFromJD_F = JD MOD 7.0
END FUNCTION

SUB CalcDeltaTime_S(nYear As Integer)
	'DeltaT = TD - UT (i.e diff between TT time and UT1)
	' taken fron NASA https://eclipse.gsfc.nasa.gov/LEcat5/deltatpoly.html
	' only for years 1986 to 2150
	' Populates DELTA_TIME_DAYS
	' uses 1 Local
	Local Float lf_T
	dWorking(DELTA_TIME_DAYS) = 48.0 ' default about 1977
	lf_T = nYear - 1975
	if nYear >= 1961 AND nYear < 1986 Then
		dWorking(DELTA_TIME_DAYS) = 45.45 + (1.067 * lf_T) - (lf_T * lf_T) / 260 - (lf_T * lf_T * lf_T) / 718
		EXIT SUB ' done
	end if
	lf_T = nYear - 2000
	if nYear >= 1986 AND nYear < 2005 Then
		dWorking(DELTA_TIME_DAYS) = 63.86 + (0.3345 * lf_T) - (0.060374 * lf_T * lf_T) + (0.0017275 * lf_T * lf_T * lf_T)
		dWorking(DELTA_TIME_DAYS) = dWorking(DELTA_TIME_DAYS) + (0.000651814 * lf_T * lf_T * lf_T * lf_T) + (0.00002373599 * lf_T * lf_T * lf_T * lf_T * lf_T)
		EXIT SUB ' done
	end if
	if nYear >= 2005 AND nYear < 2050 Then
		dWorking(DELTA_TIME_DAYS) = 62.92 + (0.32217 * lf_T) + (0.005589 * lf_T * lf_T)
	else if nYear >= 2050 AND nYear <= 2150 Then
		dWorking(DELTA_TIME_DAYS) = -20.0 + 32.0 * ((nYear - 1820) / 100) * ((nYear - 1820) / 100) - 0.5628 * (2150 - nYear)
	end if
	dWorking(DELTA_TIME_DAYS) = dWorking(DELTA_TIME_DAYS) / cSEC_PER_DAY ' now in days offset
END SUB

FUNCTION IsLeapYear_F(Year As Integer) As Integer
	' AA Ch 7, pp62 (boxed area)
	' return true if leap year else return false
	' Only relevant in Gregorian Calender
	if (Year MOD 4) = 0 Then
		if (Year MOD 100) = 0 Then
			if (Year MOD 400) = 0 then
				IsLeapYear_F = 1
			Else
				IsLeapYear_F = 0
			End If
		Else
			IsLeapYear_F = 1
		End If	
	Else	
		IsLeapYear_F = 0
	End If
END FUNCTION
	
FUNCTION DaysInMonth_F(nYear As Integer, nMonth As Integer) As Integer
	' return number of days in the month
	' note indexing into an array is the simplest but may uses some library calls on converting double to integer on some compilers so dont use
	' dmonth 1 to 12
	' Uses 1 Local
	Local Integer nMonthDays(11) = (31,28,31,30,31,30,31,31,30,31,30,31)
	if nMonth = 2 Then
		if IsLeapYear_F(nYear) Then
			DaysInMonth_F = 29
		else
			DaysInMonth_F = 28
		End If
	Else
		if nMonth <= 12 Then
			DaysInMonth_F = nMonthDays(nMonth-1)
		Else
			DaysInMonth_F = 0 ' error
		End If	
	End If
END FUNCTION



SUB ExtractMMBasicDate_S(CmndStr As String)
	' Used to extract date from command string and then places in Date array
	' The Date is allways after first comma in a command, e.g. "Cmd,DD-MM-YYYY,HH:MM:SS"
	' Uses 1 Local
	LOCAL TempStr As String
	TempStr = MID$( CmndStr, INSTR(1, CmndStr, "," ) +1) ' now  DD-MM-YYYY
	TrimLeadingSpaces_S TempStr ' get rid of any spaces, now have "DD-MM-YYYY"
	DateStruct(I_DAY_OF_MONTH) = VAL( LEFT$(TempStr,2 ))
	DateStruct(I_MONTH) = VAL( MID$(TempStr,4,2 ))
	DateStruct(I_YEAR) = VAL( MID$(TempStr,7,4 ))
END SUB

SUB ExtractMMBasicTime_S(CmndStr As String)
	' Used to extract time from command string and then places in Date array
	' The time is allways after second comma in a command, e.g. "Cmd,DD-MM-YYYY,HH:MM:SS"
	' Uses 1 Local
	LOCAL TempStr As String
	CmndStr = MID$( CmndStr, INSTR(1, CmndStr, "," ) +1) ' now  DD-MM-YYYY,HH:MM:SS
	TempStr = MID$( CmndStr, INSTR(1, CmndStr, "," ) +1) ' now  HH:MM:SS
	TrimLeadingSpaces_S TempStr ' get rid of any spaces
	TimeStruct(I_HOUR) = VAL( LEFT$(TempStr,2 ))
	TimeStruct(I_MIN) = VAL( MID$(TempStr,4,2 ))
	TimeStruct(I_SEC) = VAL( MID$(TempStr,7,4 ))
END SUB
	
'===========================================  ASTRONOMICAL ROUTINES ===================================================================
' Move up to global variables later
' Used only within a routine


SUB CalcLongAndObliqNut_S
	' AA Ch 21
	' asummes CALC_JD has been calculated from specific UTC date and time.
	' Nutation in lontitude and obliquity are accurate to 0.5" and 0.1" respectively.
	' Calculates 
	' 1. Long Nutation, NUTATION_LONG_SECS
	' 2. Obliq. Nutation, 	NUTATION_OBLIQ_SECS
	' 3. In addition sets MEAN_OBLIQ_ECLIP_RAD and TRUE_OBLIQ_ECLIP_RAD
	dJDE = dWorking(CALC_JD) + dWorking(DELTA_TIME_DAYS)' now dynamic time
	CalcT = (dJDE - 2451545) / 36525
	Calc2T = CalcT * CalcT
	Calc3T = CalcT * Calc2T
	dL = 280.4665 + 36000.7698 * CalcT
	DlDash = 218.3165 + 481267.8813 * CalcT
	dOmega = RAD(125.04452 - (1934.136261 * CalcT))
	dWorking(NUTATION_LONG_SECS) = (-17.2 * SIN(dOmega)) - (1.32 * SIN(2 * RAD(dL))) - (0.23 * SIN(2 * RAD(DlDash))) + (0.21 * SIN(2 * dOmega))
	dWorking(NUTATION_OBLIQ_SECS) = 9.20 * COS(dOmega) + 0.570 * COS(2 * RAD(dL)) + 0.10 * COS(2 * RAD(DlDash)) - 0.09 * COS(2 * dOmega)
	dWorking(MEAN_OBLIQ_ECLIP_RAD) = 23.439291 - 0.0130041666 * CalcT + 1.63888E-7 * Calc2T + 5.03611E-7 * Calc3T
	dWorking(TRUE_OBLIQ_ECLIP_RAD) = dWorking(MEAN_OBLIQ_ECLIP_RAD) + dWorking(NUTATION_OBLIQ_SECS) / 3600
	dWorking(MEAN_OBLIQ_ECLIP_RAD) = RAD(dWorking(MEAN_OBLIQ_ECLIP_RAD))
	dWorking(TRUE_OBLIQ_ECLIP_RAD) = RAD(dWorking(TRUE_OBLIQ_ECLIP_RAD))
END SUB

SUB CalcJD_S(dYear AS Float, dMonth AS Float, dDay AS Float, bCalT AS Integer)
	' Calculate the Juian Day from year,month and day (day can be fraction for hrs,mins secs)
	' Only works between March 1 1900 and Feb 28 2100 
	' Refer AA Ch 7
	' if bCalT is CALC_ALLTD then calcs the T,2T and 3T
	' Sets  CALC_JD, [CALC_T,CALC_2T ,CALC_3T] 
	If dYear < 1901 OR dYear > 2100 Then
		' Error
		dWorking(CALC_JD) = cMAR1901_JD
	End If
	if dMonth < 3 Then
		dYear = dYear - 1
		dMonth = dMonth + 12
	End If
	dWorking(CALC_JD) = FIX(365.25 * (dYear + 4716)) + FIX(30.6001 * (dMonth + 1)) + (dDay - 13.0) - 1524.5
	if bCalT Then
		CalcAllTD_S dWorking(CALC_JD)
	End If
END SUB

FUNCTION CalcTCentury_F(JD As Float) As Float
	' calculates T value from JD in centries
	'AA Ch 21 (Equation 21.3)
	CalcTCentury_F = (JD - 2451545) / 36525
END FUNCTION

FUNCTION CalcTMillennia_F(JD As Float) As Float
	' calculates T value from JD in 1000 years
	' AA Ch 31 (Equation 31.1)
	CalcTMillennia_F =  (JD - 2451545) / 365250
END FUNCTION

SUB CalcAllTD_S(JD As Float)
	' Calculates CALC_T etc (century based)
	dWorking(CALC_T) = CalcTCentury_F(JD)
	dWorking(CALC_2T) = dWorking(CALC_T) * dWorking(CALC_T)
	dWorking(CALC_3T) = dWorking(CALC_2T) * dWorking(CALC_T)
END SUB

SUB CalcDateFromJD_S(dJD As Float)
	' AA Ch 7
	' extract Yr,Mth and Day (fraction) from JD and places in DateStruct, note Day can be fraction
	' Uses 5 Locals
	Local Float dZ, dF, dAlpha, dD, dE, dLocJD
	dLocJD = dJD + 0.5
	dZ = FIX(dLocJD)
	dF = DoubleFraction_F(dLocJD)
	if dLocJD > cFEB21000_JD OR dLocJD < cMAR1901_JD Then
		' Error outside limits
		DateStruct(I_YEAR)  = 1901
		DateStruct(I_MONTH) = 3
		DateStruct(I_DAY_OF_MONTH) = 1
		EXIT SUB ' error 
	End If
	if dZ < 2299161 Then
		dA = dZ
	Else 
		dAlpha = FIX((dZ - 1867216.25) / 36524.25)
		dA = dZ + 1 + dAlpha - FIX(dAlpha / 4)
	End If
	dB = dA + 1524
	dC = FIX((dB - 122.1) / 365.25)
	dD = FIX(365.25 * dC)
	dE = FIX((dB - dD) / 30.6001)
	DateStruct(I_DAY_OF_MONTH) = dB - dD - FIX(30.6001 * dE) + dF
	if dE < 14 Then
		DateStruct(I_MONTH) = dE - 1
	Else 
		if (dE < 16) Then
			DateStruct(I_MONTH) = dE - 13
		End If
	End If
	if DateStruct(I_MONTH) > 2 Then
		DateStruct(I_YEAR) = dC - 4716.0
	Else 
		if (DateStruct(I_MONTH) < 3) Then
			DateStruct(I_YEAR) = dC - 4715
		End If
	End If
END SUB

FUNCTION CalcMeanObliqofEclip_F() AS Float
	' AA Ch 21 (Equation 21.2)
	' return in degrees, dT in century
	CalcMeanObliqofEclip_F = 23.43929111111111 - ((46.815 * dWorking(CALC_T)) - (0.00059 * dWorking(CALC_2T)) + (0.001813 * dWorking(CALC_3T))) / 3600
END FUNCTION

SUB SideRealGreenWitch_S
	' CALC_JD Must be UTC and not TT time
	' Outputs MEAN_G_SIDEREAL_TIME_DEG & APPARENT_G_SIDEREAL_TIME_DEG
	' AA Ch 11
	' Calculates mean and apparant
	' Assumes CalcJD_S & CalcLongAndObliqNut_S has been called prior Within0to360_F
	dWorking(MEAN_G_SIDEREAL_TIME_DEG) = Within0to360_F(280.46061837 + (360.98564736629 * (dWorking(CALC_JD) - 2451545.0)) + (0.000387933 * dWorking(CALC_2T)) - (dWorking(CALC_3T) / 38710000))
	dWorking(APPARENT_G_SIDEREAL_TIME_DEG) = (dWorking(NUTATION_LONG_SECS) / 3600) * COS(dWorking(TRUE_OBLIQ_ECLIP_RAD))
	dWorking(APPARENT_G_SIDEREAL_TIME_DEG) = dWorking(APPARENT_G_SIDEREAL_TIME_DEG) + dWorking(MEAN_G_SIDEREAL_TIME_DEG)
END SUB
	
SUB EclipticToEquatorial_S
	' Convert ECLIPTIC_LONG_RAD & ECLIPTIC_LAT_RAD ==>> TEMP_RT_ASCENSION_RAD & TEMP_DECLIN_RAD 
	' AA Ch 12, (Equation 12.3, 12.4)
	' 1. CalcLongAndObliqNut_S done
	' 2.  Using Apparent (true) data
	' 3. All in radians
	dWorking(TEMP_RT_ASCENSION_RAD) = (SIN(dWorking(ECLIPTIC_LONG_RAD)) * COS(dWorking(TRUE_OBLIQ_ECLIP_RAD))) - (TAN(dWorking(ECLIPTIC_LAT_RAD)) * SIN(dWorking(TRUE_OBLIQ_ECLIP_RAD)))
	dWorking(TEMP_RT_ASCENSION_RAD) = ATAN2(dWorking(TEMP_RT_ASCENSION_RAD), COS(dWorking(ECLIPTIC_LONG_RAD)))
	dWorking(TEMP_RT_ASCENSION_RAD) = FixP1ToZeroToP2_F(dWorking(TEMP_RT_ASCENSION_RAD), cTWO_PI)
	dWorking(TEMP_DECLIN_RAD) = (SIN(dWorking(ECLIPTIC_LAT_RAD)) * COS(dWorking(TRUE_OBLIQ_ECLIP_RAD))) + (COS(dWorking(ECLIPTIC_LAT_RAD)) * SIN(dWorking(TRUE_OBLIQ_ECLIP_RAD)) * SIN(dWorking(ECLIPTIC_LONG_RAD)))
	dWorking(TEMP_DECLIN_RAD) = ASIN(dWorking(TEMP_DECLIN_RAD)) 
END SUB

SUB EquatorialToHorizontal_S
	' Convert GM Sidereal time, Site Lat, TEMP_RT_ASCENSION_RAD ==> TEMP_HORIZ_AZ_RAD and TEMP_HORIZ_ALTITUDE_RAD
	'AA Ch 12, (Equation 12.5, 12.6)
	' Uses 1 Local
	Local Float dHrAngle
	dHrAngle = Within0To2PI_F(RAD(dWorking(APPARENT_G_SIDEREAL_TIME_DEG) - (-dWorking(SITE_LONGTITUDE_DEG))) - dWorking(TEMP_RT_ASCENSION_RAD))
	dWorking(TEMP_HORIZ_AZ_RAD) = ATAN2(SIN(dHrAngle), ((COS(dHrAngle) * SIN(RAD(dWorking(SITE_LATITUDE_DEG)))) - (TAN(dWorking(TEMP_DECLIN_RAD)) * COS(RAD(dWorking(SITE_LATITUDE_DEG))))))
	dWorking(TEMP_HORIZ_AZ_RAD) = dWorking(TEMP_HORIZ_AZ_RAD) + PI
	dWorking(TEMP_HORIZ_ALTITUDE_RAD) = (SIN(RAD(dWorking(SITE_LATITUDE_DEG))) * SIN(dWorking(TEMP_DECLIN_RAD))) + (COS(RAD(dWorking(SITE_LATITUDE_DEG))) * COS(dWorking(TEMP_DECLIN_RAD)) * COS(dHrAngle))
	dWorking(TEMP_HORIZ_ALTITUDE_RAD) = (ASIN(dWorking(TEMP_HORIZ_ALTITUDE_RAD)))
END SUB
	
FUNCTION InterpolateRTASC_F() As Float
	' Interpolates RTASC_ONE_RAD,RTASC_TWO_RAD,RTASC_THREE_RAD
	' INTERPOLATE_N must be set
	' Value placed in INTERPOLATE_RTASC_RAD
	'AA Ch 3, (Equation 3.3)
	' Uses No Local
	dA = dWorking(RTASC_TWO_RAD) - dWorking(RTASC_ONE_RAD)
	dB = dWorking(RTASC_THREE_RAD) - dWorking(RTASC_TWO_RAD)
	dC = dB - dA
	InterpolateRTASC_F =  dWorking(RTASC_TWO_RAD) + ((dWorking(INTERPOLATE_N) / 2) * (dA + dB + dWorking(INTERPOLATE_N) * dC))

END FUNCTION

FUNCTION InterpolateDeclin_F() As Float
	' Interpolates DECLIN_ONE_RAD,DECLIN_TWO_RAD,DECLIN_THREE_RAD
	' INTERPOLATE_N must be set
	' Value placed in INTERPOLATE_DEC_RAD
	'AA Ch 3, (Equation 3.3)
	' Uses No Local
	dA = dWorking(DECLIN_TWO_RAD) - dWorking(DECLIN_ONE_RAD)
	dB = dWorking(DECLIN_THREE_RAD) - dWorking(DECLIN_TWO_RAD)
	dC = dWorking(DECLIN_ONE_RAD) + dWorking(DECLIN_THREE_RAD) - 2 * dWorking(DECLIN_TWO_RAD)
	InterpolateDeclin_F =  dWorking(DECLIN_TWO_RAD) + ((dWorking(INTERPOLATE_N) / 2) * (dA + dB + (dWorking(INTERPOLATE_N) * dC)))
END FUNCTION

SUB RefineMTime_S(MType AS Integer)
	' works out correct M value from approximate value by interpolating the Rt Asc and Declin for Transit,Rise,Set
	' Based on AA Ch 14
	' MType is offset into the three RISE_SET_M0 etc (M values) as same process is used for Transit, Rise and Set 
	' Uses 7 Local
	LOCAL Float dDeltaTime, HrAngleRad, dThetaDeg, UpdatedHoRad, dInterpolateRHA, dInterpolateDec, dMStart
	nGenCount = 0
	dMStart = dWorking(RISE_SET_M0 + MType)
	dDeltaTime = 1
	DO  ' loop till error is very small (correct option) or excesive error or not converging to a set small error
		' interpolate 
		if dWorking(INTERPOLATE_PERIOD_AS_DAY) = 1 Then
			dWorking(INTERPOLATE_N) = dWorking(RISE_SET_M0 + MType) + dWorking(DELTA_TIME_DAYS)
		Else
			dWorking(INTERPOLATE_N) = dWorking(RISE_SET_M0 + MType) - dMStart 
			dWorking(INTERPOLATE_N) = dWorking(INTERPOLATE_N) / dWorking(INTERPOLATE_PERIOD_AS_DAY)
			dWorking(INTERPOLATE_N) = dWorking(INTERPOLATE_N) + dWorking(DELTA_TIME_DAYS)
		END If
		dInterpolateRHA = InterpolateRTASC_F()
		dInterpolateDec = InterpolateDeclin_F() ' only need for transit az and elevation
		dThetaDeg = Within0to360_F(dWorking(UTC00HR_APP_G_SIDEREAL_TIME_DEG) + (360.985647 * dWorking(RISE_SET_M0 + MType)))
		HrAngleRad = dThetaDeg - (-dWorking(SITE_LONGTITUDE_DEG)) - DEG(dInterpolateRHA)
		if HrAngleRad > 180 Then HrAngleRad = HrAngleRad - 360
		if HrAngleRad < -180 Then HrAngleRad = HrAngleRad + 360
		If MType = 0 Then
			'? "int N= ", dWorking(INTERPOLATE_N), "1,2,3 RtAsc = ", DEG(dWorking(RTASC_ONE_RAD)),DEG(dWorking(RTASC_TWO_RAD)),DEG(dWorking(RTASC_THREE_RAD))
			'? " Int RtAsc = ", DEG(dInterpolateRHA)
			'? "SDTime =",dWorking(UTC00HR_APP_G_SIDEREAL_TIME_DEG), " Long = ",dWorking(SITE_LONGTITUDE_DEG)," Theta =",dThetaDeg," Hr Angle = ",HrAngleRad
			'? "Hr Angle Rad = ",RAD(HrAngleRad), " Neg Hr Angle = ",  -RAD(HrAngleRad), " M Type = ", MType
			'? "Neg Long = ", (-dWorking(SITE_LONGTITUDE_DEG))
		End If
		HrAngleRad = RAD(HrAngleRad) ' to radians
		if MType = INDEX_M0_OFFSET Then 
			' updated transit
			dDeltaTime = -HrAngleRad / cTWO_PI
			'If MType = 0 Then
			'? "Hr Angle Rad = ", HrAngleRad, " 2 Pi = ", cTWO_PI
			'? "Delta = ", dDeltaTime 
			'End If
		else ' Rise & Set
			UpdatedHoRad = (SIN(RAD(dWorking(SITE_LATITUDE_DEG))) * SIN(dInterpolateDec)) + (COS(RAD(dWorking(SITE_LATITUDE_DEG))) * COS(dInterpolateDec) * COS(HrAngleRad))
			UpdatedHoRad = ASIN(UpdatedHoRad)
			UpdatedHoRad = UpdatedHoRad - dWorking(RISE_SET_h0_RAD)
			dDeltaTime = UpdatedHoRad / (cTWO_PI * COS(dInterpolateDec) * COS(RAD(dWorking(SITE_LATITUDE_DEG))) * SIN(HrAngleRad))
		End If
		'? "Delta = ", dDeltaTime 
		if ABS(dDeltaTime) > 0.08 Then EXIT DO ' dont do any more cos error it very large (~2hrs)
		INC nGenCount
		if nGenCount > MAX_RISE_SET_ITERATIONS Then EXIT DO
		dWorking(RISE_SET_M0 + MType) = dWorking(RISE_SET_M0 + MType) + dDeltaTime
		if ABS(dDeltaTime) < cTWENTY_SEC_AS_DAY Then EXIT DO
		if MType = INDEX_M0_OFFSET Then dWorking(RISE_SET_M0) = FixP1ToZeroToP2_F(dWorking(RISE_SET_M0), 1) 'set 0 to 1 here
	LOOP 
	'save Transit, Rise and Set RtAsc and Declin values for later Az and El calculations
	SELECT CASE MType
	case INDEX_M0_OFFSET
		dWorking(TRS_TRANSIT_RHA_RAD) = dInterpolateRHA
		dWorking(TRS_TRANSIT_DEC_RAD) = dInterpolateDec
	case INDEX_M1_OFFSET
		dWorking(TRS_RISE_RHA_RAD) = dInterpolateRHA
		dWorking(TRS_RISE_DEC_RAD) = dInterpolateDec
	case INDEX_M2_OFFSET
		dWorking(TRS_SET_RHA_RAD) = dInterpolateRHA
		dWorking(TRS_SET_DEC_RAD) = dInterpolateDec
	END SELECT
END SUB

SUB RiseSetTransit_S(bDoInterpolation As Integer, Mode As Integer)
	' CALC_JD set to 0hrs UTC on required day
	' Calculates Local rise,set and transit times in the M values
	'  Based on AA Ch 14
	' If bDoInterpolation is True the do interpolation via RefineMTime_S
	' Mode will determine if M values are left as a day RETURN_M_AS_DAY or converted to local hours, CONVERT_M_TO_HRS
	' Uses 3 Local
	LOCAL Float dSecondMember, dH0, dJDEM
	SideRealGreenWitch_S '00Hrs UTC in APPARENT_G_SIDEREAL_TIME_DEG
	dWorking(UTC00HR_APP_G_SIDEREAL_TIME_DEG) = dWorking(APPARENT_G_SIDEREAL_TIME_DEG)
	dSecondMember = SIN(RAD(dWorking(SITE_LATITUDE_DEG))) * SIN(dWorking(DECLIN_TWO_RAD))
	if ABS(dSecondMember) > 1 Then
		dWorking(RISE_SET_CIRCUMPOLAR) = NEVER_TRANSIT_RISE_SET_PLUS
		EXIT SUB ' do no more cos it never rises or sets
	End If
	dH0 = (SIN(dWorking(RISE_SET_h0_RAD)) - dSecondMember) / (COS(RAD(dWorking(SITE_LATITUDE_DEG))) * COS(dWorking(DECLIN_TWO_RAD)))
	If ABS(dH0) > 1 Then
		dWorking(RISE_SET_CIRCUMPOLAR) = NEVER_TRANSIT_RISE_SET_PLUS
		EXIT SUB '  do no more cos it never occurs, this may be more relevant for twilight which may not occur on the day as rise/set
	End If
	dH0 = ACOS(dH0)
	dH0 = Within0ToPI_F(dH0)
	dWorking(RISE_SET_M0) = (dWorking(RTASC_TWO_RAD) + RAD(-dWorking(SITE_LONGTITUDE_DEG)) - RAD(dWorking(APPARENT_G_SIDEREAL_TIME_DEG))) / cTWO_PI
	dWorking(RISE_SET_M0) = FixP1ToZeroToP2_F(dWorking(RISE_SET_M0), 1)
	dWorking(RISE_SET_M1) = dWorking(RISE_SET_M0) - (dH0 / cTWO_PI)
	'dont fix 0 to 1 here as getting actual date required and not previous day, see AA footnote # 1, pp 100
	dWorking(RISE_SET_M2) = dWorking(RISE_SET_M0) + (dH0 / cTWO_PI)
	if bDoInterpolation = SKIP_INTERPOLATION_RISE_SET Then
		dWorking(RISE_SET_M0) = FixP1ToZeroToP2_F(dWorking(RISE_SET_M0), 1)
		dWorking(RISE_SET_M1) = FixP1ToZeroToP2_F(dWorking(RISE_SET_M1), 1)
		dWorking(RISE_SET_M2) = FixP1ToZeroToP2_F(dWorking(RISE_SET_M2), 1)
		EXIT SUB ' done
	End If
	' evaluate transit
	RefineMTime_S INDEX_M0_OFFSET
	' evaluate rise
	RefineMTime_S INDEX_M1_OFFSET
	' evaluate set
	RefineMTime_S INDEX_M2_OFFSET
	' no correct to local time
	dJDEM = dWorking(CALC_JD) + dWorking(RISE_SET_M0)
	MValueToLocalTime_S dJDEM, INDEX_M0_OFFSET, SET_NEAREST_MIN
	dJDEM = dWorking(CALC_JD) + dWorking(RISE_SET_M1)
	MValueToLocalTime_S dJDEM, INDEX_M1_OFFSET, SET_NEAREST_MIN
	dJDEM = dWorking(CALC_JD) + dWorking(RISE_SET_M2)
	MValueToLocalTime_S dJDEM, INDEX_M2_OFFSET, SET_NEAREST_MIN
END SUB

SUB MValueToLocalTime_S(dJDE As Float, MType As Integer, bNearestMin As Integer)
	' Converts the relevant M value (set by MType) to local hours
	' dJDE is the M value JDE (UTC), needed to ensure we have correct DST
	' if bNearestMin is True the will add 30 seconds so truncate will resolve to neares minute
	' Uses no Locals
	dWorking(TRANSIT_HR + MType) = dWorking(RISE_SET_M0 + MType) * 24
	' convert to local
	dWorking(TRANSIT_HR + MType) = FixP1ToZeroToP2_F(dWorking(TRANSIT_HR + MType), 24) 
	dWorking(TRANSIT_HR + MType) = dWorking(TRANSIT_HR + MType) + GetUTCJDTimeZone_F(dJDE) 
	dWorking(TRANSIT_HR + MType) = FixP1ToZeroToP2_F(dWorking(TRANSIT_HR + MType), 24)
	if bNearestMin = SET_NEAREST_MIN Then 	dWorking(TRANSIT_HR + MType) = dWorking(TRANSIT_HR + MType) + cTHIRTY_SECONDS_AS_HOUR ' ensures it will be to nearest min
END SUB

SUB  CalculateDSTStart_S(ln_Year As Float)
	' This function calculates and returns the Julian{//, bool bUTCTime) { days of the start of daylight savings.
	 'Occurs at DST_START_HOUR local on DST_START_DAY of DST_START_WEEK in DST_START_MONTH
	 'This is based on input of LOCAL times
	 'ln_Year is the year for the calculation
	 ' Saves in DST_UTC_START_JD 
	' Uses 5 Local
	LOCAL Float lf_start, ld_firstday, ld_Day, ld_Offset, ld_daysleft
	ld_firstday = 1 + dWorking(DST_START_HOUR) / 24
	CalcJD_S ln_Year, dWorking(DST_START_MONTH), ld_firstday, SKIP_CALC_ALLTD  'e.g. 1 st Oct of current year at 2am
	lf_start = dWorking(CALC_JD)
	CalcJD_S ln_Year, dWorking(DST_START_MONTH), 1, SKIP_CALC_ALLTD)
	ld_Day = dWorking(CALC_JD)
	ld_Day = GetDayFromJD_F(ld_Day) ' e.g. what day is 1st Oct
	ld_Offset = 0
	if ld_Day <> 0 Then ld_Offset = 7 - ld_Day
	lf_start = lf_start + ld_Offset 'this is the first sunday at correct time
	if dWorking(DST_START_WEEK) = 4 Then ' last Sunday of month could be 4th or 5 sunday
		CalcDateFromJD_S lf_start ' get date of this first sunday
		ld_daysleft = DaysInMonth_F(ln_Year, dWorking(DST_START_MONTH)) - DateStruct(I_DAY_OF_MONTH)
		if ld_daysleft < 28 Then
			lf_start = lf_start + 21
		else
			lf_start = lf_start + 28
		End If
	else 
		lf_start = lf_start + (dWorking(DST_START_WEEK) - 1) * 7
	End If
	' have start based on local date/time, convert to UTC
	dWorking(DST_UTC_START_JD) = lf_start - dWorking(TIME_ZONE) / 24
END SUB


SUB CalculateDSTEnd_S(ln_Year As Float)
	' This function calculates and returns the Julian days (since 1900) of the end of daylight savings.
	 'This is based on an input of LOCAL times 
	 ' saves in DST_UTC_END_JD
	' ln_Year is the year for the calculation
	' Uses 5 Local
	LOCAL Float lf_end, ld_firstday, ld_Day, ld_Offset, ld_daysleft
	ld_firstday = 1 + dWorking(DST_END_HOUR) / 24
	CalcJD_S ln_Year, dWorking(DST_END_MONTH), ld_firstday, SKIP_CALC_ALLTD 'e.g. 1 st of month of current year at end hour
	lf_end = dWorking(CALC_JD)
	CalcJD_S ln_Year, dWorking(DST_END_MONTH), 1, SKIP_CALC_ALLTD ' 1st day of month
	ld_Day = dWorking(CALC_JD)
	ld_Day = GetDayFromJD_F(ld_Day) ' e.g.  what day is 1st 
	ld_Offset = 0
	if ld_Day <> 0 Then ld_Offset = 7 - ld_Day 'not sunday
	lf_end = lf_end + ld_Offset ' this is the first sunday at correct time
	if dWorking(DST_END_WEEK) = 4 Then 'last Sunday of month could be 4th or 5 sunday
		CalcDateFromJD_S lf_end ' get date of this first sunday
		ld_daysleft = DaysInMonth_F(ln_Year, dWorking(DST_END_MONTH)) - DateStruct(I_DAY_OF_MONTH)
		if ld_daysleft < 28 Then
			lf_end = lf_end + 21
		else
			lf_end = lf_end + 28
		End If
	else 
		lf_end = lf_end + (dWorking(DST_END_WEEK) - 1) * 7
	End If
	dWorking(DST_UTC_END_JD) = lf_end - dWorking(DST_TIME_ZONE) / 24
END SUB

FUNCTION GetUTCJDTimeZone_F(dJDE As Float) As Float
	' return the time zone for as specific UTC based JD. 
	' if no DST then returns TIME_ZONE
	' *** WARNING this is based on the last SetTimeZone call ***
	' Uses 0 Local
	If dWorking(DST_TIME_ZONE) = dWorking(TIME_ZONE) Then ' no DST
		GetUTCJDTimeZone_F = dWorking(TIME_ZONE)
		EXIT FUNCTION
	End If
	If dWorking(SITE_LATITUDE_DEG) > 0 Then ' northern hemisphere
		If dJDE >= dWorking(DST_UTC_START_JD) AND dJDE < dWorking(DST_UTC_END_JD) Then
			dWorking(IN_DST) = 1
			dWorking(CURR_TIME_ZONE) = dWorking(DST_TIME_ZONE)
		Else 
			dWorking(IN_DST) = 0
			dWorking(CURR_TIME_ZONE) = dWorking(TIME_ZONE)
		End If
	' end northern hemispshere
	Else 
		 ' southern hemisphere
		If dJDE < dWorking(DST_UTC_START_JD) AND dJDE > dWorking(DST_UTC_END_JD) Then
			dWorking(IN_DST) = 0
			dWorking(CURR_TIME_ZONE) = dWorking(TIME_ZONE)
		Else
			dWorking(IN_DST) = 1
			dWorking(CURR_TIME_ZONE) = dWorking(DST_TIME_ZONE)
		End If ' end southern hemispshere
	End If
	GetUTCJDTimeZone_F = dWorking(CURR_TIME_ZONE)
END FUNCTION

SUB ConvertUTCToLocal_S(IncludeSeconds As Integer)
	' converts data in UTC variables to local variables taking into account DST
	 'if IgnoreSeconds = SKIP_SECONDS then seconds set to UTC seconds so second stays the same as input, else secs factored into calculation (may get error in rounding)
	 ' Uses 0 Local
	If IncludeSeconds = INCLUDE_SECONDS Then
		lf_DayFraction = dWorking(UTC_HOUR) / 24 + dWorking(UTC_MIN) / 1440 + dWorking(UTC_SEC) / 86400
	else
		lf_DayFraction = dWorking(UTC_HOUR) / 24 + dWorking(UTC_MIN) / 1440. + 0.000001 ' last number prevents 60 seconds & ensures DST correct for zero seconds
	End If
	lf_Day = dWorking(UTC_DATE) + lf_DayFraction
	CalcJD_S(dWorking, dWorking(UTC_YEAR), dWorking(UTC_MONTH), lf_Day, SKIP_CALC_ALLTD)
	dWorking(CALC_JD) = dWorking(CALC_JD) + GetUTCJDTimeZone_F(dWorking(CALC_JD)  / 24
	CalcDateFromJD_S dWorking(CALC_JD)
	dWorking(LOCAL_YEAR) = DateStruct(I_YEAR)
	dWorking(LOCAL_MONTH) = DateStruct(I_MONTH)
	dWorking(LOCAL_DATE) = FIX_F(DateStruct(I_DAY_OF_MONTH))
	lf_Hour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24 ' convert to hours
	dWorking(LOCAL_HOUR) = GetHourFromFloatHour_F(lf_Hour)
	dWorking(LOCAL_MIN) = GetMinsFromFloatHour_F(lf_Hour)
	If IncludeSeconds = INCLUDE_SECONDS Then
		dWorking(LOCAL_SEC) = GetSecsFromFloatHour_F(lf_Hour)
	else
		dWorking(LOCAL_SEC) = dWorking(UTC_SEC)
	End If
END SUB	
	
SUB ConvertLocalToUTC_S(IncludeTime As Integer, IncludeSeconds As Integer)
	' converts data in LOCAL Time variables to UTC variables taking into account DST
	' if IgnoreSeconds = SKIP_SECONDS then seconds set to Local seconds so secs remain consistant, else secs factored into calculation (may get error in rounding)
	' If IncludeTime is SKIP_TIME then the LOCAL time is not updated (used just for date change)
	' Does not require CURR_TIME_ZONE to be set
	' Uses 0 Local
	If IncludeTime = INCLUDE_TIME Then
		If IncludeSeconds= INCLUDE_SECONDS Then
			lf_DayFraction = dWorking(LOCAL_HOUR) / 24 + dWorking(LOCAL_MIN) / 1440 + dWorking(LOCAL_SEC) / 86400
		else
			lf_DayFraction = dWorking(LOCAL_HOUR) / 24 + dWorking(LOCAL_MIN) / 1440 + 0.000001 'last number prevents 60 seconds & ensures DST correct for zero seconds
		End If
		lf_Day = dWorking(LOCAL_DATE) + lf_DayFraction
	else
		lf_Day = dWorking(LOCAL_DATE)
	End If
	CalcJD_S dWorking(LOCAL_YEAR), dWorking(LOCAL_MONTH), lf_Day, SKIP_CALC_ALLTD
	dWorking(CALC_JD) = dWorking(CALC_JD) - GetUTCJDTimeZone_F(dWorking(CALC_JD))/24 
	CalcDateFromJD_S dWorking(CALC_JD)
	dWorking(UTC_DATE) = FIX(DateStruct(I_DAY_OF_MONTH))
	If IncludeTime = INCLUDE_TIME Then
		lf_Hour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24 'convert to hours
		dWorking(UTC_HOUR) = GetHourFromFloatHour_F(lf_Hour)
		dWorking(UTC_MIN) = GetMinsFromFloatHour_F(lf_Hour)
		If IncludeSeconds = INCLUDE_SECONDS Then
			dWorking(UTC_SEC) = GetSecsFromFloatHour_F(lf_Hour)
		else
			dWorking(UTC_SEC) = dWorking(LOCAL_SEC)
		End If
	End If ' time
	dWorking(UTC_MONTH) = DateStruct(I_MONTH)
	dWorking(UTC_YEAR) = DateStruct(I_YEAR)
END SUB

SUB CalcEarthOrbitEcc_S 
	' Assumes CALC_T has been undertaken
	' AA Ch 45, Eq 45.6
	dWorking(EARTH_ORBIT_ECC) = 1 - (0.002516 * dWorking(CALC_T)) - (0.0000074 * dWorking(CALC_2T))
END SUB


FUNCTION SunMeanLong_F() As Float
	'AA Eq 24.2, in degrees
	SunMeanLong_F = 280.46645 + 36000.76983 * dWorking(CALC_T) + 0.0003032 * dWorking(CALC_2T)
END FUNCTION

SUB CalcSolarCoords_S 
	' Calculates the Solar Coords for a specific JDE (Year,Month, Day can be fraction for hrs,mins secs)
	' Refer AA Ch 24
	' 	Assumes CalcJD based on UT has been called with CALC_ALLTD
	' Output to 
	' SUN_RT_ASCENSION_RAD 
	' SUN_DECLIN_RAD 
	' SUN_DISTANCE_MKM 
	' SUN_APPARENT_LONG_RAD 
	' Uses no Locals
	dL0 = SunMeanLong_F()
	dL0 = Within0to360_F(dL0)
	dM = 357.52910 + (35999.05030 * dWorking(CALC_T)) - (0.0001559 * dWorking(CALC_2T)) - (0.00000048 * dWorking(CALC_3T))
	dE = 0.016708617 - (0.000042037 * dWorking(CALC_T)) - (0.0000001236 * dWorking(CALC_2T))
	dC = (1.914600 - (0.004817 * dWorking(CALC_T)) - (0.000014 * dWorking(CALC_2T))) * SIN(RAD(dM)) 
	dC = dC + ((0.019993 - (0.000101 * dWorking(CALC_T))) * SIN(RAD(2 * dM))) + 0.000290 * SIN(RAD(3 * dM))
	dTrueLong = Within0to360_F(dL0 + dC)
	dV = dM + dC
	dWorking(SUN_DISTANCE_MKM) = (1.000001018 * (1 - (dE * dE)))
	dWorking(SUN_DISTANCE_MKM) = dWorking(SUN_DISTANCE_MKM) / (1 + (dE * COS(RAD(dV))))
	dWorking(SUN_DISTANCE_MKM) = dWorking(SUN_DISTANCE_MKM) * cAU_MILLKM 'in millions km
	dOmega = RAD(125.04 - (1934.136 * dWorking(CALC_T)))
	dWorking(SUN_APPARENT_LONG_RAD) = RAD(dTrueLong - 0.00569 - (0.00478 * SIN(dOmega)))
	dWorking(CORR_OBLIQ_ECLIP_RAD) = CalcMeanObliqofEclip_F()
	dWorking(CORR_OBLIQ_ECLIP_RAD) = RAD(dWorking(CORR_OBLIQ_ECLIP_RAD) + 0.00256 * COS(dOmega))
	'calc Rt Asc and Decl (apparent position)
	dWorking(SUN_RT_ASCENSION_RAD) = ATAN2(COS(dWorking(CORR_OBLIQ_ECLIP_RAD)) * SIN(dWorking(SUN_APPARENT_LONG_RAD)), COS(dWorking(SUN_APPARENT_LONG_RAD)))
	dWorking(SUN_RT_ASCENSION_RAD) = FixP1ToZeroToP2_F(dWorking(SUN_RT_ASCENSION_RAD), cTWO_PI)
	dWorking(SUN_DECLIN_RAD) = ASIN(SIN(dWorking(CORR_OBLIQ_ECLIP_RAD)) * SIN(dWorking(SUN_APPARENT_LONG_RAD)))
END SUB

FUNCTION SUN_Rise_Set_Transit_F(InString As String) As String
	' assumes LOCAL_DATE,LOCAL_MONTH,LOCAL_YEAR are set
	' output in input String as   Transit Time,Transit El,Rise Time,Rise Az,Set Time, Set Az, Civil Twilight, Civil Dusk,
	' Nautical Twilight, Nautical Dusk, Astronomical Twilight, Astronomical Dusk, Distance (millions km, XXX.XXX)
	' Appends data to input string
	' Uses no Locals
	dWorking(RISE_SET_h0_RAD) = RAD(-0.8333) 
	dWorking(INTERPOLATE_PERIOD_AS_DAY) = 1 ' 1 day
	CalcJD_S dWorking(LOCAL_YEAR), dWorking(LOCAL_MONTH), FIX(dWorking(LOCAL_DATE)), CALC_ALLTD
	dInitialJD = dWorking(CALC_JD)
	CreateIterationTable_S dWorking(INTERPOLATE_PERIOD_AS_DAY), SUN ' RTAsc and Declin over 3 days, sets dInitialJD to UTC 0
	RiseSetTransit_S DO_INTERPOLATION_RISE_SET, RETURN_M_AS_DAY ' dWorking(TRANSIT_HR) etc as local hrs
	dDayLength = dWorking(SET_HR) - dWorking(RISE_HR)
	' Transit
	dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(TRS_TRANSIT_RHA_RAD)
	dWorking(TEMP_DECLIN_RAD) = dWorking(TRS_TRANSIT_DEC_RAD)
	dWorking(CALC_JD) = dInitialJD + dWorking(RISE_SET_M0)
	dTransitDistanceJD = dWorking(CALC_JD)
	CalcAllTD_S dWorking(CALC_JD)
	SideRealGreenWitch_S
	EquatorialToHorizontal_S
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(TRANSIT_HR)), GetMinsFromFloatHour_F(dWorking(TRANSIT_HR)), 0, SKIP_SECONDS, APPEND_COMMA)
	dWorking(TEMP_HORIZ_ALTITUDE_RAD) = FIX(DEG(dWorking(TEMP_HORIZ_ALTITUDE_RAD)) + 0.5) ' round 
	InString = InString + format$(dWorking(TEMP_HORIZ_ALTITUDE_RAD),"%03g,")
	'Rise
	dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(TRS_RISE_RHA_RAD)
	dWorking(TEMP_DECLIN_RAD) = dWorking(TRS_RISE_DEC_RAD)
	dWorking(CALC_JD) = dInitialJD + dWorking(RISE_SET_M1)
	CalcAllTD_S dWorking(CALC_JD)
	SideRealGreenWitch_S
	EquatorialToHorizontal_S
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(RISE_HR)), GetMinsFromFloatHour_F(dWorking(RISE_HR)), 0.0, SKIP_SECONDS, APPEND_COMMA)
	dWorking(TEMP_HORIZ_AZ_RAD) = FIX(DEG(dWorking(TEMP_HORIZ_AZ_RAD)) + 0.5)
	InString = InString + format$(dWorking(TEMP_HORIZ_AZ_RAD),"%03g,")
	' Set
	dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(TRS_SET_RHA_RAD)
	dWorking(TEMP_DECLIN_RAD) = dWorking(TRS_SET_DEC_RAD)
	dWorking(CALC_JD) = dInitialJD + dWorking(RISE_SET_M2)
	CalcAllTD_S dWorking(CALC_JD)
	SideRealGreenWitch_S
	EquatorialToHorizontal_S
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(SET_HR)), GetMinsFromFloatHour_F(dWorking(SET_HR)), 0.0, SKIP_SECONDS, APPEND_COMMA)
	dWorking(TEMP_HORIZ_AZ_RAD) = FIX(DEG(dWorking(TEMP_HORIZ_AZ_RAD)) + 0.5) ' round 
	InString = InString + format$(dWorking(TEMP_HORIZ_AZ_RAD),"%03g,")
	' get Civil Twilight, -6 degrees, need to redo sun position on the original JD
	dWorking(CALC_JD) = dInitialJD
	dWorking(RISE_SET_h0_RAD) = RAD(-6)
	RiseSetTransit_S DO_INTERPOLATION_RISE_SET, RETURN_M_AS_DAY
	If dWorking(RISE_SET_CIRCUMPOLAR) < -0.5 Then 'Error if not 0.0
		dWorking(RISE_HR) = 99 ' will force it to "NIL"
		dWorking(SET_HR) = 99
	End If
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(RISE_HR)), GetMinsFromFloatHour_F(dWorking(RISE_HR)), 0, SKIP_SECONDS, APPEND_COMMA)
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(SET_HR)), GetMinsFromFloatHour_F(dWorking(SET_HR)), 0, SKIP_SECONDS, APPEND_COMMA)
	' get Nautical Twilight, -12 degrees
	dWorking(RISE_SET_h0_RAD) = RAD(-12)
	RiseSetTransit_S DO_INTERPOLATION_RISE_SET, RETURN_M_AS_DAY
	If dWorking(RISE_SET_CIRCUMPOLAR) < -0.5 Then 'Error if not 0.0
		dWorking(RISE_HR) = 99 ' will force it to "NIL"
		dWorking(SET_HR) = 99
	End If
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(RISE_HR)), GetMinsFromFloatHour_F(dWorking(RISE_HR)), 0, SKIP_SECONDS, APPEND_COMMA)
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(SET_HR)), GetMinsFromFloatHour_F(dWorking(SET_HR)), 0, SKIP_SECONDS, APPEND_COMMA)
	' get Astronomical Twilight, -18 degrees
	dWorking(RISE_SET_h0_RAD) = RAD(-18)
	RiseSetTransit_S DO_INTERPOLATION_RISE_SET, RETURN_M_AS_DAY
	If dWorking(RISE_SET_CIRCUMPOLAR) < -0.5 Then 'Error if not 0.0
		dWorking(RISE_HR) = 99 ' will force it to "NIL"
		dWorking(SET_HR) = 99
	End If
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(RISE_HR)), GetMinsFromFloatHour_F(dWorking(RISE_HR)), 0.0, SKIP_SECONDS, APPEND_COMMA)
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(SET_HR)), GetMinsFromFloatHour_F(dWorking(SET_HR)), 0.0, SKIP_SECONDS, APPEND_COMMA)
	' day length
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dDayLength), GetMinsFromFloatHour_F(dDayLength), GetSecsFromFloatHour_F(dDayLength), INCLUDE_SECONDS, APPEND_COMMA)
	' add sun distance
	dWorking(CALC_JD) = dTransitDistanceJD
	CalcAllTD_S dWorking(CALC_JD)
	CalcSolarCoords_S ' for transit distance
	InString = InString + format$(dWorking(SUN_DISTANCE_MKM),"%03.3g,")
	SUN_Rise_Set_Transit_F = InString
END FUNCTION

SUB CalcMoonPosition_S(nCalcType As Integer)
	' Calculates Moon position
	' 	AA Ch 45, all entries in the longtitude, distance and latitude tables are used.
	' assumes,
	' 1. JD calculated for that dynamic time
	' 2. CalcLongAndObliqNut done
	' Updated to Second Edition values (minor changes)
	' Uses 8 Locals
	LOCAL As Float d2E, dE1, dEr, dA1, dA2, dA3, dEb, dTemp
	dLDash = RAD(Within0to360_F(218.3164477 + (481267.88123421 * dWorking(CALC_T)) - (0.0015786 * dWorking(CALC_2T)) + (dWorking(CALC_3T) / 538841) - ((dWorking(CALC_2T) * dWorking(CALC_2T)) / 65194000)))
	dD = RAD(Within0to360_F(297.8501921 + 445267.1114034 * dWorking(CALC_T) - 0.0018819 * dWorking(CALC_2T) + dWorking(CALC_3T) / 545868 - ((dWorking(CALC_2T) * dWorking(CALC_2T)) / 113065000)))
	dM = RAD(Within0to360_F(357.5291092 + 35999.0502909 * dWorking(CALC_T) - 0.0001536 * dWorking(CALC_2T) + dWorking(CALC_3T) / 24490000))
	dMDash = RAD(Within0to360_F(134.9633964 + (477198.8675055 * dWorking(CALC_T)) + (0.0087414 * dWorking(CALC_2T)) + (dWorking(CALC_3T) / 69699) - ((dWorking(CALC_2T) * dWorking(CALC_2T)) / 14712000)))
	dF = RAD(Within0to360_F(93.2720950 + (483202.0175233 * dWorking(CALC_T)) - (0.0036539 * dWorking(CALC_2T)) - (dWorking(CALC_3T) / 3526000) + ((dWorking(CALC_2T) * dWorking(CALC_2T)) / 863310000)))
	CalcEarthOrbitEcc_S ' sets EARTH_ORBIT_ECC, simple calc
	d2E = dWorking(EARTH_ORBIT_ECC) * dWorking(EARTH_ORBIT_ECC)
	if nCalcType = CALC_ALL_CALCULATIONS OR nCalcType = CALC_COORDS_ONLY Then
		dE1 = 6288774 * SIN(dMDash)
		dE1 = dE1 + 1274027 * SIN((2 * dD) - dMDash)
		dE1 = dE1 + 658314 * SIN(2 * dD)
		dE1 = dE1 + 213618 * SIN(2 * dMDash)
		dE1 = dE1 + -185116 * dWorking(EARTH_ORBIT_ECC) * SIN(dM)
		dE1 = dE1 + -114332 * SIN(2 * dF)
		dE1 = dE1 + 58793 * SIN((2 * dD) - (2 * dMDash))
		dE1 = dE1 + 57066 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) - dM - dMDash)
		dE1 = dE1 + 53322 * SIN((2 * dD) + dMDash)
		dE1 = dE1 + 45758 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) - dM)
		dE1 = dE1 + -40923 * dWorking(EARTH_ORBIT_ECC) * SIN(dM - dMDash)
		dE1 = dE1 + -34720 * SIN(dD)
		dE1 = dE1 + -30383 * dWorking(EARTH_ORBIT_ECC) * SIN(dM + dMDash)
		dE1 = dE1 + 15327 * SIN((2 * dD) - (2 * dF))
		dE1 = dE1 + -12528 * SIN(dMDash + (2 * dF))
		dE1 = dE1 + 10980 * SIN(dMDash - (2 * dF))
		dE1 = dE1 + 10675 * SIN((4 * dD) - dMDash)
		dE1 = dE1 + 10034 * SIN(3 * dMDash)
		dE1 = dE1 + 8548 * SIN((4 * dD) - (2 * dMDash))
		dE1 = dE1 + -7888 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) + dM - dMDash)
		dE1 = dE1 + -6766 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) + dM)
		dE1 = dE1 + -5163 * SIN(dD - dMDash)
		dE1 = dE1 + 4987 * dWorking(EARTH_ORBIT_ECC) * SIN(dD + dM)
		dE1 = dE1 + 4036 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) - dM + dMDash)
		dE1 = dE1 + 3994 * SIN((2 * dD) + (2 * dMDash))
		dE1 = dE1 + 3861 * SIN(4 * dD)
		dE1 = dE1 + 3665 * SIN((2 * dD) - (3 * dMDash))
		dE1 = dE1 + -2689 * dWorking(EARTH_ORBIT_ECC) * SIN(dM - (2 * dMDash))
		dE1 = dE1 + -2602 * SIN((2 * dD) - dMDash + (2 * dF))
		dE1 = dE1 + 2390 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) - dM - (2 * dMDash))
		dE1 = dE1 + -2348 * SIN(dD + dMDash)
		dE1 = dE1 + 2236 * d2E * SIN((2 * dD) - (2 * dM))
		dE1 = dE1 + -2120 * dWorking(EARTH_ORBIT_ECC) * SIN(dM + (2 * dMDash))
		dE1 = dE1 + -2069 * d2E * SIN(2 * dM)
		dE1 = dE1 + 2048 * d2E * SIN((2 * dD) - (2 * dM) - dMDash)
		dE1 = dE1 + -1773 * SIN((2 * dD) + dMDash - (2 * dF))
		dE1 = dE1 + -1595 * SIN((2 * dD) + (2 * dF))
		dE1 = dE1 + 1215 * dWorking(EARTH_ORBIT_ECC) * SIN((4 * dD) - dM - dMDash)
		dE1 = dE1 + -1110 * SIN((2 * dMDash) + (2 * dF))
		dE1 = dE1 + -892 * SIN((3 * dD) - dMDash)
		dE1 = dE1 + -810 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) + dM + dMDash)
		dE1 = dE1 + 759 * dWorking(EARTH_ORBIT_ECC) * SIN((4 * dD) - dM - (2 * dMDash))
		dE1 = dE1 + -713 * d2E * SIN((2 * dM) - dMDash)
		dE1 = dE1 + -700 * d2E * SIN((2 * dD) + (2 * dM) - dMDash)
		dE1 = dE1 + 691 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) + dM - (2 * dMDash))
		dE1 = dE1 + 596 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) - dM - (2 * dF))
		dE1 = dE1 + 549 * SIN((4 * dD) + dMDash)
		dE1 = dE1 + 537 * SIN(4 * dMDash)
		dE1 = dE1 + 520 * dWorking(EARTH_ORBIT_ECC) * SIN((4 * dD) - dM)
		dE1 = dE1 + -487 * SIN(dD - (2 * dMDash))
		dE1 = dE1 + -399 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) + dM - (2 * dF))
		dE1 = dE1 + -381 * SIN((2 * dMDash) - (2 * dF))
		dE1 = dE1 + 351 * dWorking(EARTH_ORBIT_ECC) * SIN(dD + dM + dMDash)
		dE1 = dE1 + -340 * SIN((3 * dD) - (2 * dMDash))
		dE1 = dE1 + 330 * SIN((4 * dD) - (3 * dMDash))
		dE1 = dE1 + 327 * dWorking(EARTH_ORBIT_ECC) * SIN((2 * dD) - dM + (2 * dMDash))
		dE1 = dE1 + -323 * d2E * SIN((2 * dM) + dMDash)
		dE1 = dE1 + 299 * dWorking(EARTH_ORBIT_ECC) * SIN(dD + dM - dMDash)
		dE1 = dE1 + 294 * SIN((2 * dD) + (3 * dMDash))
		dA1 = RAD(Within0to360_F(119.75 + 131.849 * dWorking(CALC_T)))
		dA2 = RAD(Within0to360_F(53.09 + 479264.29 * dWorking(CALC_T)))
		dA3 = RAD(Within0to360_F(313.45 + 481266.484 * dWorking(CALC_T)))
		dE1 = dE1 + 3958 * SIN(dA1)
		dE1 = dE1 + 1962 * SIN(dLDash - dF)
		dE1 = dE1 + 318 * SIN(dA2)
		dWorking(MOON_GEO_LONG_DEG) = DEG(dLDash) + (dE1 / 1000000)
	End If
	if nCalcType = CALC_ALL_CALCULATIONS OR nCalcType = CALC_DISTANCE_ONLY Then
		dEr = -20905355 * COS(dMDash)
		dEr= dEr + -3699111 * COS(2 * dD - dMDash)
		dEr= dEr + -2955968 * COS(2 * dD)
		dEr= dEr + -569925 * COS(2 * dMDash)
		dEr= dEr + 48888 * dWorking(EARTH_ORBIT_ECC) * COS(dM)
		dEr= dEr + -3149 * COS(2 * dF)
		dEr= dEr + 246158 * COS(2 * dD - 2 * dMDash)
		dEr= dEr + -152138 * dWorking(EARTH_ORBIT_ECC) * COS(2 * dD - dM - dMDash)
		dEr= dEr + -170733 * COS(2 * dD + dMDash)
		dEr= dEr + -204586 * dWorking(EARTH_ORBIT_ECC) * COS(2 * dD - dM)
		dEr= dEr + -129620 * dWorking(EARTH_ORBIT_ECC) * COS(dM - dMDash)
		dEr= dEr + 108743 * COS(dD)
		dEr= dEr + 104755 * dWorking(EARTH_ORBIT_ECC) * COS(dM + dMDash)
		dEr= dEr + 10321 * COS(2 * dD - 2 * dF)
		dEr= dEr + 79661 * COS(dMDash - 2 * dF)
		dEr= dEr + -34782 * COS(4 * dD - dMDash)
		dEr= dEr + -23210 * COS(3 * dMDash)
		dEr= dEr + -21636 * COS(4 * dD - 2 * dMDash)
		dEr= dEr + 24208 * dWorking(EARTH_ORBIT_ECC) * COS(2 * dD + dM - dMDash)
		dEr= dEr + 30824 * dWorking(EARTH_ORBIT_ECC) * COS(2 * dD + dM)
		dEr= dEr + -8379 * COS(dD - dMDash)
		dEr= dEr + -16675 * dWorking(EARTH_ORBIT_ECC) * COS(dD + dM)
		dEr= dEr + -12831 * dWorking(EARTH_ORBIT_ECC) * COS(2 * dD - dM + dMDash)
		dEr= dEr + -10445 * COS(2 * dD + 2 * dMDash)
		dEr= dEr + -11650 * COS(4 * dD)
		dEr= dEr + 14403 * COS(2 * dD - 3 * dMDash)
		dEr= dEr + -7003 * dWorking(EARTH_ORBIT_ECC) * COS(dM - 2 * dMDash)
		dEr= dEr + 10056 * dWorking(EARTH_ORBIT_ECC) * COS(2 * dD - dM - 2 * dMDash)
		dEr= dEr + 6322 * COS(dD + dMDash)
		dEr= dEr + -9884 * d2E * COS(2 * dD - 2 * dM)
		dEr= dEr + 5751 * dWorking(EARTH_ORBIT_ECC) * COS(dM + 2 * dMDash)
		dEr= dEr + -4950 * d2E * COS(2 * dD - 2 * dM - dMDash)
		dEr= dEr + 4130 * COS(2 * dD + dMDash - 2 * dF)
		dEr= dEr + -3958 * dWorking(EARTH_ORBIT_ECC) * COS(4 * dD - dM - dMDash)
		dEr= dEr + 3258 * COS(3 * dD - dMDash)
		dEr= dEr + 2616 * dWorking(EARTH_ORBIT_ECC) * COS(2 * dD + dM + dMDash)
		dEr= dEr + -1897 * dWorking(EARTH_ORBIT_ECC) * COS(4 * dD - dM - 2 * dMDash)
		dEr= dEr + -2117 * d2E * COS(2 * dM - dMDash)
		dEr= dEr + 2354 * d2E * COS(2 * dD + 2 * dM - dMDash)
		dEr= dEr + -1423 * COS(4 * dD + dMDash)
		dEr= dEr + -1117 * COS(4 * dMDash)
		dEr= dEr + -1571 * dWorking(EARTH_ORBIT_ECC) * COS(4 * dD - dM)
		dEr= dEr + -1739 * COS(dD - 2 * dMDash)
		dEr= dEr + -4421 * COS(2 * dMDash - 2 * dF)
		dEr= dEr + 1165 * d2E * COS(2 * dM + dMDash)
		dEr= dEr + 8752 * COS(2 * dD - dMDash - 2 * dF)
		dWorking(MOON_DISTANCE_KM) = 385000.56 + (dEr / 1000) ' km's
	End If
	if nCalcType = CALC_ALL_CALCULATIONS OR nCalcType = CALC_COORDS_ONLY Then
		dEb = 5128122 * SIN(dF)
		dEb= dEb + 280602 * SIN(dMDash + dF)
		dEb= dEb + 277693 * SIN(dMDash - dF)
		dEb= dEb + 173237 * SIN(2 * dD - dF)
		dEb= dEb + 55413 * SIN(2 * dD - dMDash + dF)
		dEb= dEb + 46271 * SIN(2 * dD - dMDash - dF)
		dEb= dEb + 32573 * SIN(2 * dD + dF)
		dEb= dEb + 17198 * SIN(2 * dMDash + dF)
		dEb= dEb + 9266 * SIN(2 * dD + dMDash - dF)
		dEb= dEb + 8822 * SIN(2 * dMDash - dF)
		dEb= dEb + 8216 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD - dM - dF)
		dEb= dEb + 4324 * SIN(2 * dD - 2 * dMDash - dF)
		dEb= dEb + 4200 * SIN(2 * dD + dMDash + dF)
		dEb= dEb + -3359 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD + dM - dF)
		dEb= dEb + 2463 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD - dM - dMDash + dF)
		dEb= dEb + 2211 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD - dM + dF)
		dEb= dEb + 2065 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD - dM - dMDash - dF)
		dEb= dEb + -1870 * dWorking(EARTH_ORBIT_ECC) * SIN(dM - dMDash - dF)
		dEb= dEb + 1828 * SIN(4 * dD - dMDash - dF)
		dEb= dEb + -1794 * dWorking(EARTH_ORBIT_ECC) * SIN(dM + dF)
		dEb= dEb + -1749 * SIN(3 * dF)
		dEb= dEb + -1565 * dWorking(EARTH_ORBIT_ECC) * SIN(dM - dMDash + dF)
		dEb= dEb + -1491 * SIN(dD + dF)
		dEb= dEb + -1475 * dWorking(EARTH_ORBIT_ECC) * SIN(dM + dMDash + dF)
		dEb= dEb + -1410 * dWorking(EARTH_ORBIT_ECC) * SIN(dM + dMDash - dF)
		dEb= dEb + -1344 * dWorking(EARTH_ORBIT_ECC) * SIN(dM - dF)
		dEb= dEb + -1335 * SIN(dD - dF)
		dEb= dEb + 1107 * SIN(3 * dMDash + dF)
		dEb= dEb + 1021 * SIN(4 * dD - dF)
		dEb= dEb + 833 * SIN(4 * dD - dMDash + dF)
		dEb= dEb + 777 * SIN(dMDash - 3 * dF)
		dEb= dEb + 671 * SIN(4 * dD - 2 * dMDash + dF)
		dEb= dEb + 607 * SIN(2 * dD - 3 * dF)
		dEb= dEb + 596 * SIN(2 * dD + 2 * dMDash - dF)
		dEb= dEb + 491 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD - dM + dMDash - dF)
		dEb= dEb + -451 * SIN(2 * dD - 2 * dMDash + dF)
		dEb= dEb + 439 * SIN(3 * dMDash - dF)
		dEb= dEb + 422 * SIN(2 * dD + 2 * dMDash + dF)
		dEb= dEb + 421 * SIN(2 * dD - 3 * dMDash - dF)
		dEb= dEb + -366 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD + dM - dMDash + dF)
		dEb= dEb + -351 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD + dM + dF)
		dEb= dEb + 331 * SIN(4 * dD + dF)
		dEb= dEb + 315 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD - dM + dMDash + dF)
		dEb= dEb + 302 * d2E * SIN(2 * dD - 2 * dM - dF)
		dEb= dEb + -283 * SIN(dMDash + 3 * dF)
		dEb= dEb + -229 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD + dM + dMDash - dF)
		dEb= dEb + 223 * dWorking(EARTH_ORBIT_ECC) * SIN(dD + dM - dF)
		dEb= dEb + 223 * dWorking(EARTH_ORBIT_ECC) * SIN(dD + dM + dF)
		dEb= dEb + -220 * dWorking(EARTH_ORBIT_ECC) * SIN(dM - 2 * dMDash - dF)
		dEb= dEb + -220 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD + dM - dMDash - dF)
		dEb= dEb + -185 * SIN(dD + dMDash + dF)
		dEb= dEb + 181 * dWorking(EARTH_ORBIT_ECC) * SIN(2 * dD - dM - 2 * dMDash - dF)
		dEb= dEb + -177 * dWorking(EARTH_ORBIT_ECC) * SIN(dM + 2 * dMDash + dF)
		dEb= dEb + 176 * SIN(4 * dD - 2 * dMDash - dF)
		dEb= dEb + 166 * dWorking(EARTH_ORBIT_ECC) * SIN(4 * dD - dM - dMDash - dF)
		dEb= dEb + -164 * SIN(dD + dMDash - dF)
		dEb= dEb + 132 * SIN(4 * dD + dMDash - dF)
		dEb= dEb + -119 * SIN(dD - dMDash - dF)
		dEb= dEb + 115 * dWorking(EARTH_ORBIT_ECC) * SIN(4 * dD - dM - dF)
		dEb= dEb + 107 * d2E * SIN(2 * dD - 2 * dM + dF)
		dEb= dEb + -2235 * SIN(dLDash)
		dEb= dEb + 382 * SIN(dA3)
		dEb= dEb + 175 * SIN(dA1 - dF)
		dEb= dEb + 175 * SIN(dA1 + dF)
		dEb= dEb + 127 * SIN(dLDash - dMDash)
		dEb= dEb + -115 * SIN(dLDash + dMDash)
		dWorking(MOON_GEO_LAT_DEG) = dEb / 1000000
		if nCalcType = CALC_ALL_CALCULATIONS Then dWorking(MOON_PARALLAX_RAD) = ASIN(6378.14 / dWorking(MOON_DISTANCE_KM)) 'only do this if have Distance else leave MOON_PARALLAX_RAD as per last calc
		dWorking(MOON_APPARENT_LONG_RAD) = RAD(dWorking(MOON_GEO_LONG_DEG) + (dWorking(NUTATION_LONG_SECS) / 3600))
		dWorking(ECLIPTIC_LONG_RAD) = dWorking(MOON_APPARENT_LONG_RAD)
		dWorking(ECLIPTIC_LAT_RAD) = RAD(dWorking(MOON_GEO_LAT_DEG))
		EclipticToEquatorial_S 
		dWorking(MOON_APPARENT_RASC_RAD) = dWorking(TEMP_RT_ASCENSION_RAD)
		dWorking(MOON_APPARENT_DEC_RAD) = dWorking(TEMP_DECLIN_RAD)
		if nCalcType = CALC_ALL_CALCULATIONS Then
			' calc i in degrees as per AA 46.4
			dWorking(MOON_ILLUM_FRACTION) = PI - dD - 0.10976376 * SIN(dMDash) 
			dWorking(MOON_ILLUM_FRACTION) = dWorking(MOON_ILLUM_FRACTION) + 0.03665191429 * SIN(dM) 
			dWorking(MOON_ILLUM_FRACTION) = dWorking(MOON_ILLUM_FRACTION) + -0.02223549467 * SIN((2 * dD) - dMDash) 
			dWorking(MOON_ILLUM_FRACTION) = dWorking(MOON_ILLUM_FRACTION) + -0.0114842664 * SIN(2 * dD)  
			dWorking(MOON_ILLUM_FRACTION) = dWorking(MOON_ILLUM_FRACTION) + -0.003735005 * SIN(2 * dMDash)  
			dWorking(MOON_ILLUM_FRACTION) = dWorking(MOON_ILLUM_FRACTION) + -0.001919862177 * SIN(dD) 
			' calc k as per AA Ch 46, equation 46.1
			dWorking(MOON_ILLUM_FRACTION) = (1 + COS(dWorking(MOON_ILLUM_FRACTION))) / 2
			' calc position angle assuming sun position has been calculated
			CalcSolarCoords_S ' needed for position angle
			dWorking(MOON_POSITION_ANGLE_DEG) = COS(dWorking(SUN_DECLIN_RAD)) * SIN(dWorking(SUN_RT_ASCENSION_RAD) - dWorking(MOON_APPARENT_RASC_RAD))
			dTemp = SIN(dWorking(SUN_DECLIN_RAD)) * COS(dWorking(MOON_APPARENT_DEC_RAD))
			dTemp = dTemp - COS(dWorking(SUN_DECLIN_RAD)) * SIN(dWorking(MOON_APPARENT_DEC_RAD)) * COS(dWorking(SUN_RT_ASCENSION_RAD) - dWorking(MOON_APPARENT_RASC_RAD))
			dWorking(MOON_POSITION_ANGLE_DEG) = ATAN2(dWorking(MOON_POSITION_ANGLE_DEG), dTemp)
			if dWorking(MOON_POSITION_ANGLE_DEG) < 0 Then
				dWorking(MOON_POSITION_ANGLE_DEG) = dWorking(MOON_POSITION_ANGLE_DEG) + cTWO_PI
			End If
			dWorking(MOON_POSITION_ANGLE_DEG) = DEG(dWorking(MOON_POSITION_ANGLE_DEG))
		End If
	End If
END SUB

FUNCTION CorrectObjectCalcTRSDate_F( UpdatedDate As Float, Offset As Integer) AS Integer
	'Used for Moon and Planets to ensure the correct date is being calculated for transit, rise and set as these may occur 
	' on diffeent dates but want program to only calculate on requested date.
	'   is the calculated time of Transit,Rise or Set
	'Check DATE_CHECK_D (local) is the same as CalcDate
	' Offset is set to Transit, Rise or Set M offset value.
	' UpdatedDate is the JDE to evaluate, it is the calculated JDE for Transit or Rise orSet
	' return CORRECT_DATE if correct, DAY_BEFORE  if day Calc date is before input date or DAY_AFTER if Calc date is day after in date
	' Uses 0 Locals
	DateStruct(I_DAY_OF_MONTH) = UpdatedDate  + GetUTCJDTimeZone_F(UpdatedDate)/24.0 ' just using I_MONTH as a temp variable
	CalcDateFromJD_S DateStruct(I_DAY_OF_MONTH)
	' ? "Date Local JD = ", DateStruct(I_DAY_OF_MONTH), "Tgt= ",dWorking(DATE_CHECK_D)
		
	DateStruct(I_DAY_OF_MONTH) = FIX(DateStruct(I_DAY_OF_MONTH))
	dWorking(DATE_CHECK_D) = FIX(dWorking(DATE_CHECK_D))
'	? "Check Date = ", dWorking(DATE_CHECK_D), "Date Struct = ", DateStruct(I_DAY_OF_MONTH)
	if DateStruct(I_DAY_OF_MONTH) = dWorking(DATE_CHECK_D) Then
		CorrectObjectCalcTRSDate_F = CORRECT_DATE
	Else
		' not same date
		if ABS(DateStruct(I_DAY_OF_MONTH) - dWorking(DATE_CHECK_D)) > 2 Then 'month wrap around
			if DateStruct(I_DAY_OF_MONTH) > dWorking(DATE_CHECK_D) Then
				CorrectObjectCalcTRSDate_F = DAY_BEFORE
			Else
				CorrectObjectCalcTRSDate_F =  DAY_AFTER
			End If
		Else 
			if DateStruct(I_DAY_OF_MONTH) > dWorking(DATE_CHECK_D) Then
				CorrectObjectCalcTRSDate_F = DAY_AFTER
			Else
				CorrectObjectCalcTRSDate_F = DAY_BEFORE
			End If
		End If
	End If
END FUNCTION


SUB CalcPlanetPosition_S(Object As Integer)
	' assumes JD calculated
	' Object is the planet to calculate on
	' Uses 0 Locals
	EarthPosition_S' need this to be done first
	SELECT CASE Object
		case MERCURY
			MercuryPosition_S
		case VENUS:
			VenusPosition_S
		case MARS:
			MarsPosition_S
		case JUPITER:
			JupiterPosition_S
		case SATURN:
			SaturnPosition_S
	END SELECT		
END SUB

SUB CalcInitialObjectMValues_S(Object As Integer)
	' Finds approximate M values for Transit, Rise and Set
	' Object is the Moon or Planet to calculate on.
	' Uses 0 Locals
	CalcAllTD_S dWorking(CALC_JD)
	SideRealGreenWitch_S ' 00hr UTC 
	dWorking(UTC00HR_APP_G_SIDEREAL_TIME_DEG) = dWorking(APPARENT_G_SIDEREAL_TIME_DEG)
	If Object > MOON Then 'planet
		dWorking(RISE_SET_h0_RAD) = RAD(-0.5667)
	Else 
		CalcMoonPosition_S CALC_ALL_CALCULATIONS) ' need MOON_PARALLAX_RAD
		dWorking(RISE_SET_h0_RAD) = RAD((0.7275 * DEG(dWorking(MOON_PARALLAX_RAD))) - 0.5666666)
		dWorking(RTASC_TWO_RAD) = dWorking(MOON_APPARENT_RASC_RAD)
		dWorking(DECLIN_TWO_RAD) = dWorking(MOON_APPARENT_DEC_RAD)
		
	End If
	RiseSetTransit_S SKIP_INTERPOLATION_RISE_SET, RETURN_M_AS_DAY
END SUB

FUNCTION CheckObjectAlternateDay_F(Offset As Integer, Object As Integer)  As Integer
	' Used for Moon and Planets
	' enters with CALC_JD set to 00Hrs UTC
	' If CorrectObjectCalcTRSDate return DAY_CORRECT else return NOT_CORRECT_DAY
	' Uses 2 Locals
	LOCAL Float dSideRealTime, dJDE00UTC
	dJDE00UTC = dWorking(CALC_JD) ' save this 00UTC time for later as will get changed for CreateIterationTable
	dSideRealTime = dWorking(UTC00HR_APP_G_SIDEREAL_TIME_DEG)
	CalcInitialObjectMValues_S Object
	dWorking(OBJECT_INITIAL_M0 + Offset) = dWorking(RISE_SET_M0 + Offset)
	if Object = MOON Then dWorking(CALC_JD) = dWorking(CALC_JD) + dWorking(RISE_SET_M0 + Offset) ' moon only interpolated over 3 hours
	' create table for new date
	CreateIterationTable_S dWorking(INTERPOLATE_PERIOD_AS_DAY), Object ' RTAsc and Declin over INTERPOLATE_PERIOD_AS_DAY value
	RefineMTime_S  Offset
	' tidy up after
	dWorking(UTC00HR_APP_G_SIDEREAL_TIME_DEG) = dSideRealTime
	dWorking(APPARENT_G_SIDEREAL_TIME_DEG) = dSideRealTime
	SELECT CASE Offset
		case INDEX_M0_OFFSET
			dWorking(RISE_SET_M1) = dWorking(OBJECT_INITIAL_M1)
			dWorking(RISE_SET_M2) = dWorking(OBJECT_INITIAL_M2)
		case INDEX_M1_OFFSET
			dWorking(RISE_SET_M2) = dWorking(OBJECT_INITIAL_M2)
	END SELECT
	dWorking(CALC_OBJECT_UPDATED_JDE) = dJDE00UTC + dWorking(RISE_SET_M0 + Offset)
	If CorrectObjectCalcTRSDate_F(dWorking(CALC_OBJECT_UPDATED_JDE), Offset) = CORRECT_DATE Then
		CheckObjectAlternateDay_F =  DAY_CORRECT
	Else
		CheckObjectAlternateDay_F =  NOT_CORRECT_DAY
	End If
END FUNCTION

FUNCTION CalcObjectTRSonCorrectDay_F( InString As String, Offset As Integer, Object As Integer) As String
	' Enters with CALC_JD set to approx M time
	' ensure rise,set and transit are on correct day and re-evaluates if necessary then store data in returning string
	' Uses 2 Locals
	LOCAL Integer CalcDate
	LOCAL Float dTempTable(5)
	' First try
	'moon must be done over 3 hours so one table will no work for Rise, Transit and Set
	if Object = MOON Then CreateIterationTable_S dWorking(INTERPOLATE_PERIOD_AS_DAY), Object ' RTAsc and Declin over x hours around the M value
	RefineMTime_S Offset
	dWorking(CALC_OBJECT_UPDATED_JDE) = dWorking(CALCTRS_OBJECT_DTC00_JD) + dWorking(RISE_SET_M0 + Offset)
	'If Offset = 0 Then 
	'? "After Refine Time Transit JDE = ", dWorking(CALC_OBJECT_UPDATED_JDE), "Updated M0 = ", dWorking(RISE_SET_M0 + Offset), "Offset = ", Offset
	'End If
	CalcDate = CorrectObjectCalcTRSDate_F(dWorking(CALC_OBJECT_UPDATED_JDE), Offset)
	if CalcDate <> CORRECT_DATE Then
	'? "N"
		If CalcDate = DAY_BEFORE Then
			dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) + 1
			INC dWorking(CALC_OBJECT_UPDATED_JDE)
		Else 
			dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) - 1.0
			INC dWorking(CALC_OBJECT_UPDATED_JDE), -1
		End If
		' save original iteration table
		dTempTable(0) = dWorking(RTASC_ONE_RAD)
		dTempTable(1) = dWorking(DECLIN_ONE_RAD)
		dTempTable(2) = dWorking(RTASC_TWO_RAD)
		dTempTable(3) = dWorking(DECLIN_TWO_RAD)
		dTempTable(4) = dWorking(RTASC_THREE_RAD)
		dTempTable(5) = dWorking(DECLIN_THREE_RAD)
		if CheckObjectAlternateDay_F(Offset, Object) = NOT_CORRECT_DAY) Then ' no transit or rise or set
			dWorking(TRANSIT_HR + Offset) = 0
			InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(TRANSIT_HR + Offset)), GetMinsFromFloatHour_F(dWorking(TRANSIT_HR + Offset)), 0, SKIP_SECONDS, APPEND_COMMA)
			If Offset = INDEX_M0_OFFSET Then ' no transit so set distance to rise
				dWorking(RISE_SET_CIRCUMPOLAR) = NO_TRANSIT
			'	? "No Transit";
			Else
				dWorking(RISE_SET_CIRCUMPOLAR) = 0
			End If
			InString = InString + "NIL,"
		Else
			CalcDate = CORRECT_DATE
		End If
		' need to reset the iteration table back to correct date or will cause set error as wrong day
		if Offset < INDEX_M2_OFFSET Then
			' replace original iteration table
			dWorking(RTASC_ONE_RAD) = dTempTable(0)
			dWorking(DECLIN_ONE_RAD) = dTempTable(1)
			dWorking(RTASC_TWO_RAD) = dTempTable(2)
			dWorking(DECLIN_TWO_RAD) = dTempTable(3)
			dWorking(RTASC_THREE_RAD) = dTempTable(4)
			dWorking(DECLIN_THREE_RAD) = dTempTable(5)
		End If
	End If ' not correct date
	if CalcDate = CORRECT_DATE Then
		' all Good, Store in string 
		If Offset = 0 Then 
		'? "Correct Date ";
		End If
		MValueToLocalTime_S dWorking(CALC_OBJECT_UPDATED_JDE), Offset, SET_NEAREST_MIN
		SELECT CASE Offset
			case INDEX_M0_OFFSET
				if dWorking(RISE_SET_CIRCUMPOLAR) <> NO_TRANSIT Then dWorking(TRANSIT_DISTANCE) = dWorking(CALC_OBJECT_UPDATED_JDE) ' save JDE for later distance calc
				dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(TRS_TRANSIT_RHA_RAD)
				dWorking(TEMP_DECLIN_RAD) = dWorking(TRS_TRANSIT_DEC_RAD)
			case INDEX_M1_OFFSET
				if dWorking(RISE_SET_CIRCUMPOLAR) = NO_TRANSIT Then
					dWorking(TRANSIT_DISTANCE) = dWorking(CALC_OBJECT_UPDATED_JDE) ' save JDE for later distance calc
					dWorking(RISE_SET_CIRCUMPOLAR) = 0
				End If
				dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(TRS_RISE_RHA_RAD)
				dWorking(TEMP_DECLIN_RAD) = dWorking(TRS_RISE_DEC_RAD)
			case INDEX_M2_OFFSET
				dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(TRS_SET_RHA_RAD)
				dWorking(TEMP_DECLIN_RAD) = dWorking(TRS_SET_DEC_RAD)
		END SELECT
		dWorking(CALC_JD) = dWorking(CALC_OBJECT_UPDATED_JDE)
		CalcAllTD_S dWorking(CALC_JD)
		SideRealGreenWitch_S 
		EquatorialToHorizontal_S 
		InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dWorking(TRANSIT_HR + Offset)), GetMinsFromFloatHour_F(dWorking(TRANSIT_HR + Offset)), 0, SKIP_SECONDS, APPEND_COMMA)
		
		If Offset = INDEX_M0_OFFSET Then
			dWorking(TEMP_HORIZ_ALTITUDE_RAD) = FIX(DEG(dWorking(TEMP_HORIZ_ALTITUDE_RAD)) + 0.5) 'round 
			InString = InString + format$(dWorking(TEMP_HORIZ_ALTITUDE_RAD),"%03g,")
		Else 
			dWorking(TEMP_HORIZ_AZ_RAD) = FIX(DEG(dWorking(TEMP_HORIZ_AZ_RAD)) + 0.5) ' round 
			InString = InString + format$(dWorking(TEMP_HORIZ_AZ_RAD),"%03g,")
		End If
	End If
	'If Offset = 0 Then 
	'? InString
	'End If
	CalcObjectTRSonCorrectDay_F = InString
END FUNCTION

FUNCTION MOON_Rise_Set_Transit_F(InString As String) As String
	' uses Local date as the correct date to find rise, set, transit
	' get approx M times
	' Uses 0 Local
	CalcJD_S dWorking(LOCAL_YEAR), dWorking(LOCAL_MONTH), FIX(dWorking(LOCAL_DATE)), CALC_ALLTD 'SKIP_CALC_ALLTD) 'his will be at 00hr
	dUTC00Hour = dWorking(CALC_JD)
	dWorking(CALCTRS_OBJECT_DTC00_JD) = dUTC00Hour
	'CalcAllTD_S dWorking(CALC_JD)
	CalcLongAndObliqNut_S 
	dWorking(CALC_JD) = dUTC00Hour
	CalcInitialObjectMValues_S MOON
	dWorking(OBJECT_INITIAL_M0) = dWorking(RISE_SET_M0)
	dWorking(OBJECT_INITIAL_M1) = dWorking(RISE_SET_M1)
	dWorking(OBJECT_INITIAL_M2) = dWorking(RISE_SET_M2)
	'? "M0 to M2 = ",dWorking(RISE_SET_M0),dWorking(RISE_SET_M1),dWorking(RISE_SET_M2)
	'? "JD O Hr= ",dUTC00Hour
	dWorking(INTERPOLATE_PERIOD_AS_DAY) = cHR_AS_DAY
	' Transit
	dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) + dWorking(OBJECT_INITIAL_M0)
	'? "Transit table JD = ", dWorking(CALC_JD)
	'dWorking(TRANSIT_DISTANCE) = -1000.0L; flag transit
	InString = CalcObjectTRSonCorrectDay_F(InString, INDEX_M0_OFFSET, MOON)
	dWorking(CALCTRS_OBJECT_DTC00_JD) = dUTC00Hour ' reset just in case
	' Rise 
	dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) + dWorking(OBJECT_INITIAL_M1)
	'? "rise table JD = ", dWorking(CALC_JD)
	InString = CalcObjectTRSonCorrectDay_F(InString, INDEX_M1_OFFSET, MOON)
	dWorking(CALCTRS_OBJECT_DTC00_JD) = dUTC00Hour 'reset just in case
	' Set
	dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) + dWorking(OBJECT_INITIAL_M2)
	'? "set table JD = ", dWorking(CALC_JD)
	InString = CalcObjectTRSonCorrectDay_F(InString, INDEX_M2_OFFSET, MOON)
	' add moon distance at transit
	dWorking(CALC_JD) = dWorking(TRANSIT_DISTANCE)
	CalcAllTD_S dWorking(CALC_JD)
	CalcMoonPosition_S CALC_DISTANCE_ONLY
	InString = InString + format$(dWorking(MOON_DISTANCE_KM),"%06g")
	MOON_Rise_Set_Transit_F = InString
END FUNCTION

FUNCTION PlanetMagnitude_F(nObject As Integer) As Float
	' AA Ch40, last page (page 270 in Ed 1)
	' For Saturn PLANET_PHASE_ANGLE_I_DEG is substituted for Delta U
	' Uses 6 Locals
	LOCAL Float ld_I,ld_O,ld_SinB,ld_B,dLog5
	dLog5 = 5 * LOG(dWorking(CALC_PLAN_RAD_VEC_AU) * dWorking(CALC_PLAN_DISTANCE))/2.302585092994 'base10
	SELECT CASE nObject
		case MERCURY
			PlanetMagnitude_F = -0.42 + dLog5 + (0.038 * dWorking(PLANET_PHASE_ANGLE_I_DEG)) - (0.000273 * dWorking(PLANET_PHASE_ANGLE_I_DEG) * dWorking(PLANET_PHASE_ANGLE_I_DEG))
			PlanetMagnitude_F = PlanetMagnitude_F + (0.000002 * dWorking(PLANET_PHASE_ANGLE_I_DEG) * dWorking(PLANET_PHASE_ANGLE_I_DEG) * dWorking(PLANET_PHASE_ANGLE_I_DEG))
		case VENUS
			PlanetMagnitude_F = -4.4 + dLog5 + (0.0009 * dWorking(PLANET_PHASE_ANGLE_I_DEG)) + (0.000239 * dWorking(PLANET_PHASE_ANGLE_I_DEG) * dWorking(PLANET_PHASE_ANGLE_I_DEG))
			PlanetMagnitude_F =	PlanetMagnitude_F - (0.00000065 * dWorking(PLANET_PHASE_ANGLE_I_DEG) * dWorking(PLANET_PHASE_ANGLE_I_DEG) * dWorking(PLANET_PHASE_ANGLE_I_DEG))
		case MARS
			PlanetMagnitude_F = -1.52 + dLog5 + (0.016 * dWorking(PLANET_PHASE_ANGLE_I_DEG))
		case JUPITER:
			PlanetMagnitude_F = -9.4 + dLog5 + (0.005 * dWorking(PLANET_PHASE_ANGLE_I_DEG))
		case SATURN:
			 ld_I = 28.075216 - 0.012998 * dWorking(CALC_T) + 0.000004 * dWorking(CALC_2T)
			 ld_O = 169.508470 + 1.394681 * dWorking(CALC_T) + 0.000412 * dWorking(CALC_2T)
			 ld_SinB = SIN(RAD(ld_I)) * COS(dWorking(GEO_LAT_RAD)) * SIN(dWorking(GEO_LONG_RAD) - RAD(ld_O)) - COS(RAD(ld_I)) * SIN(dWorking(GEO_LAT_RAD))
			 ld_B = ABS(ASIN(ld_SinB))
			ld_SinB = SIN(ld_B)
			PlanetMagnitude_F = -8.88 + dLog5 + (0.044 * dWorking(PLANET_PHASE_ANGLE_I_DEG)) - (2.6 * ld_SinB) + 1.25 * ld_SinB * ld_SinB
		CASE ELSE
			PlanetMagnitude_F = 0
	END SELECT
END FUNCTION

FUNCTION PlanetSizeSecs_F(nObject As Integer) As Float
	' AA Ch53, note the values in AA are semidiamters so the constant values are multiplied by 2 to give diameter
	' Uses 0 Locals
	SELECT CASE nObject
		case MERCURY
			PlanetSizeSecs_F =  6.72 / dWorking(CALC_PLAN_DISTANCE)
		case VENUS
			PlanetSizeSecs_F = 16.68 / dWorking(CALC_PLAN_DISTANCE)
		case MARS:
			PlanetSizeSecs_F = 9.36 / dWorking(CALC_PLAN_DISTANCE)
		case JUPITER:
			PlanetSizeSecs_F = 196.88 / dWorking(CALC_PLAN_DISTANCE)
		case SATURN:
			PlanetSizeSecs_F =  165.46 / dWorking(CALC_PLAN_DISTANCE)
		CASE ELSE
			PlanetSizeSecs_F = 0
	END SELECT
END FUNCTION

FUNCTION PlanetTRS_F(InString As String, nObject As Integer) AS String
	'Visible Planet transit, rise and set
	' Uses 0 Locals
	dUTC00Hour = dWorking(CALC_JD)
	dWorking(CALCTRS_OBJECT_DTC00_JD) = dUTC00Hour
	CalcLongAndObliqNut_S 
	dWorking(CALC_JD) = dUTC00Hour
	dWorking(INTERPOLATE_PERIOD_AS_DAY) = 1 ' over +/- one day
	CreateIterationTable_S dWorking(INTERPOLATE_PERIOD_AS_DAY), nObject ' RTAsc and Declin over x hours
	CalcInitialObjectMValues_S nObject
	dWorking(OBJECT_INITIAL_M0) = dWorking(RISE_SET_M0)
	dWorking(OBJECT_INITIAL_M1) = dWorking(RISE_SET_M1)
	dWorking(OBJECT_INITIAL_M2) = dWorking(RISE_SET_M2)
	dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) + dWorking(OBJECT_INITIAL_M0)
	' Transit
	'dWorking(TRANSIT_DISTANCE) = -1000.0L; // flag if not transit
	InString = CalcObjectTRSonCorrectDay_F(InString, INDEX_M0_OFFSET, nObject)
	'? InString
	dWorking(CALCTRS_OBJECT_DTC00_JD) = dUTC00Hour ' reset just in case
	' Rise 
	dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) + dWorking(OBJECT_INITIAL_M1)
	InString = CalcObjectTRSonCorrectDay_F(InString, INDEX_M1_OFFSET, nObject)
	dWorking(CALCTRS_OBJECT_DTC00_JD) = dUTC00Hour 'reset just in case
	' Set
	dWorking(CALC_JD) = dWorking(CALCTRS_OBJECT_DTC00_JD) + dWorking(OBJECT_INITIAL_M2)
	InString = CalcObjectTRSonCorrectDay_F(InString, INDEX_M2_OFFSET, nObject)
	' add  distance, size and magnitude at transit
	CalcJD_S dWorking(LOCAL_YEAR), dWorking(LOCAL_MONTH), FIX(dWorking(LOCAL_DATE)), CALC_ALLTD
	dWorking(CALC_JD) = dWorking(CALC_JD) + (dWorking(TRANSIT_HR) - dWorking(CURR_TIME_ZONE)) / 24.0 ' UTC
	CalcPlanetPosition_S nObject
	InString = InString + format$(PlanetMagnitude_F(nObject),"%1.1f,")
	InString = InString + format$(PlanetSizeSecs_F(nObject),"%2.0f,")
	If nObject = SATURN Then 'last one so dont add comma
		InString = InString + format$(dWorking(CALC_PLAN_DISTANCE) * AU_TO_MILLION_KM,"%4.3f")
	Else
		InString = InString + format$(dWorking(CALC_PLAN_DISTANCE) * AU_TO_MILLION_KM,"%4.3f,")
	End If
	PlanetTRS_F = InString
END FUNCTION

SUB CalcMoonPhaseCommonValues_S 
	' Done for each phase
	' Moon Phases, Part of AA Ch 47 
	' Uses 0 Locals
	dT1 = dWorking(CALC_K) / 1236.85
	dT2 = dT1 * dT1
	dT3 = dT2 * dT1
	dT4 = dT3 * dT1
	dWorking(CALC_MOON_PHASE_JDE) = 2451550.09765 + 29.530588853 * dWorking(CALC_K) + 0.0001337 * dT2
	dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -1.50E-7 * dT3
	dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 7.3E-10 * dT4
	dWorking(CALC_M) = 2.5534 + 29.10535669 * dWorking(CALC_K) - 2.18E-5 * dT2 - 1.1E-7 * dT3
	dWorking(CALC_M_DASH) = 201.5643 + 385.81693528 * dWorking(CALC_K) + 1.07438E-2 * dT2 + 1.239E-5 * dT3 + 5.8E-8 * dT4
	dWorking(CALC_F) = 160.7108 + 390.67050274 * dWorking(CALC_K) - 1.6341E-3 * dT2 - 2.27E-6 * dT3 + 1.1E-8 * dT4
	dWorking(CALC_O) = 124.7746 - 1.5637558 * dWorking(CALC_K) + 1.6341E-3 * dT2 + 2.15E-6 * dT3
	dWorking(CALC_E) = 1.0 - 2.516E-3 * dT1 - 7.4E-6 * dT2
	dWorking(CALC_M) = RAD(Within0to360_F(dWorking(CALC_M)))
	dWorking(CALC_M_DASH) = RAD(Within0to360_F(dWorking(CALC_M_DASH)))
	dWorking(CALC_F) = RAD(Within0to360_F(dWorking(CALC_F)))
	dWorking(CALC_O) = RAD(Within0to360_F(dWorking(CALC_O)))
	dWorking(CALC_E) = Within0to360_F(dWorking(CALC_E)) 
	dWorking(CALC_A1) = RAD(Within0to360_F(299.77 + 0.107408 * dWorking(CALC_K) - 9.173E-3 * dT2))
	dWorking(CALC_A2) = RAD(Within0to360_F(251.88 + 1.6321E-2 * dWorking(CALC_K)))
	dWorking(CALC_A3) = RAD(Within0to360_F(251.83 + 26.651886 * dWorking(CALC_K)))
	dWorking(CALC_A4) = RAD(Within0to360_F(349.42 + 36.412478 * dWorking(CALC_K)))
	dWorking(CALC_A5) = RAD(Within0to360_F(84.66 + 18.206239 * dWorking(CALC_K)))
	dWorking(CALC_A6) = RAD(Within0to360_F(141.74 + 53.303771 * dWorking(CALC_K)))
	dWorking(CALC_A7) = RAD(Within0to360_F(207.14 + 2.453732 * dWorking(CALC_K)))
	dWorking(CALC_A8) = RAD(Within0to360_F(154.84 + 7.306860 * dWorking(CALC_K)))
	dWorking(CALC_A9) = RAD(Within0to360_F(34.52 + 27.261239 * dWorking(CALC_K)))
	dWorking(CALC_A10) = RAD(Within0to360_F(207.19 + 0.121824 * dWorking(CALC_K)))
	dWorking(CALC_A11) = RAD(Within0to360_F(291.34 + 1.844379 * dWorking(CALC_K)))
	dWorking(CALC_A12) = RAD(Within0to360_F(161.72 + 24.198154 * dWorking(CALC_K)))
	dWorking(CALC_A13) = RAD(Within0to360_F(239.56 + 25.513099 * dWorking(CALC_K)))
	dWorking(CALC_A14) = RAD(Within0to360_F(331.55 + 3.592518 * dWorking(CALC_K)))
END SUB

FUNCTION CalcSum2_F() As Float
	' Moon Phases, Part of AA Ch 47 
	' Uses 1 Locals
	LOCAL Float dSum
	dSum = 3.25E-4 * SIN(dWorking(CALC_A1)) + 5.6E-5 * SIN(dWorking(CALC_A8))
	dSum = dSum + 1.65E-4 * SIN(dWorking(CALC_A2)) + 4.7E-5 * SIN(dWorking(CALC_A9))
	dSum = dSum + 1.64E-4 * SIN(dWorking(CALC_A3)) + 4.2E-5 * SIN(dWorking(CALC_A10))
	dSum = dSum + 1.26E-4 * SIN(dWorking(CALC_A4)) + 4.0E-5 * SIN(dWorking(CALC_A11))
	dSum = dSum + 1.1E-4 * SIN(dWorking(CALC_A5)) + 3.7E-5 * SIN(dWorking(CALC_A12))
	dSum = dSum + 6.2E-5 * SIN(dWorking(CALC_A6)) + 3.5E-5 * SIN(dWorking(CALC_A13))
	dSum = dSum + 6.0E-5 * SIN(dWorking(CALC_A7)) + 2.3E-5 * SIN(dWorking(CALC_A14))
	CalcSum2_F = dSum
END FUNCTION

FUNCTION CalcFirstLastQtrSum1_F() As Float
	' Moon Phases, Part of AA Ch 47 
	' Uses 1 Local
	LOCAL Float dSum
	dSum = -0.62801 * SIN(dWorking(CALC_M_DASH)) + 0.17172 * dWorking(CALC_E) * SIN(dWorking(CALC_M)) - 1.183E-2 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M))
	dSum = dSum  + 8.62E-3 * SIN(2 * dWorking(CALC_M_DASH)) + 8.04E-3 * SIN(2 * dWorking(CALC_F))
	dSum = dSum  + 4.54E-3 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M)) + 2.04E-3 * dWorking(CALC_E) * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M))
	dSum = dSum  + -1.80E-3 * SIN(dWorking(CALC_M_DASH) - 2 * dWorking(CALC_F)) - 7.0E-4 * SIN(dWorking(CALC_M_DASH) + 2 * dWorking(CALC_F))
	dSum = dSum  + -4.0E-4 * SIN(3 * dWorking(CALC_M_DASH)) - 3.4E-4 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) - dWorking(CALC_M))
	dSum = dSum  + 3.2E-4 * dWorking(CALC_E) * SIN(dWorking(CALC_M) + 2 * dWorking(CALC_F)) + 3.2E-4 * dWorking(CALC_E) * SIN(dWorking(CALC_M) - 2 * dWorking(CALC_F))
	dSum = dSum  + -2.8E-4 * dWorking(CALC_E) * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) + 2 * dWorking(CALC_M)) + 2.7E-4 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) + dWorking(CALC_M))
	dSum = dSum  + -1.7E-4 * SIN(dWorking(CALC_O)) - 5.0E-5 * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M) - 2 * dWorking(CALC_F))
	dSum = dSum  + 4.0E-5 * SIN(2 * dWorking(CALC_M_DASH) + 2 * dWorking(CALC_F)) - 4.0E-5 * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M) + 2 * dWorking(CALC_F))
	dSum = dSum  + 4.0E-5 * SIN(dWorking(CALC_M_DASH) - 2 * dWorking(CALC_M)) + 3.0E-5 * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M) - 2 * dWorking(CALC_F))
	dSum = dSum  + 3.0E-5 * SIN(3 * dWorking(CALC_M)) + 2.0E-5 * SIN(2 * dWorking(CALC_M_DASH) - 2 * dWorking(CALC_F))
	dSum = dSum  + 2.0E-5 * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M) + 2 * dWorking(CALC_F)) - 2.0E-5 * SIN(3 * dWorking(CALC_M_DASH) + dWorking(CALC_M))
	CalcFirstLastQtrSum1_F = dSum
END FUNCTION

FUNCTION CalcFirstLastQtrW_F() As Float
	' Moon Phases, Part of AA Ch 47 
	' Uses 0 Local
	CalcFirstLastQtrW_F = 0.00306 - 0.00038 * dWorking(CALC_E) * COS(dWorking(CALC_M)) + 0.00026 * COS(dWorking(CALC_M_DASH)) - 0.00002 * COS(dWorking(CALC_M_DASH) - dWorking(CALC_M))
	CalcFirstLastQtrW_F = CalcFirstLastQtrW_F + 0.00002 * COS(dWorking(CALC_M_DASH) + dWorking(CALC_M)) + 0.00002 * COS(2 * dWorking(CALC_F))
END FUNCTION

FUNCTION MoonEclipseString_F(InString As String) AS String
	'From AA,CH52
	' Does this on Full moon, expects CALC_MOON_PHASE_JDE set to full moon time\
	' Magnitudes are the size of moon coverage by Umbra or Penumbra (1.0 is all)
	' For a total Eclipse (dUmbraMag > 1.0)
	' the return string is Umbra Mag, Penumbra Mag, Date of Eclipse, First Penumbra Contact Time, First Umbra Contact time, Start Total Contact Time,
	' Max of Eclipse Time, End Total Contact Time, Last Contact Umbra, Last Contact Penumbra.
	' 	If dUmbraMag < 1.0 but > 0.0 then Start Total Contact and Total Contact Time are omitted.
	' 	if dUmbraMag < 0 then First Umbra Contact time, Start Total Contact, Total Contact Time and End Total Contact Time are omitted
	' Note if the Eclipse Max is close to 0Hrs or 24Hr then a rollover could occur in times but will be obvious (e.g. Max = 23:59 then 
	' Last Umbra and Penumbra will be at low number hour indicating next day. In case of Max at 0Hr then First times will be in 23 hours or such high day hours)
	' If No Eclipse then Date is set to 00-00-00 and no other data added
	' If just Penumbra then Date set and Magnitudes set
	' Uses 18 Locals
	LOCAL Float F1, A1, dT1, dP, dQ, dW, dGamma, du, dPenumbraMag, dUmbraMag, dn, dH, dT
	LOCAL Float dUmbraPartial, dUmbraTotal, dPenumbraPartial, dTempJD, dHour
	If SIN(dWorking(CALC_F)) > 0.36 Then
		' no eclipse
		InString = InString + "NIL"
	Else 
		' possible eclipse
		dT1 = dWorking(CALC_K) / 1236.85
		F1 = dWorking(CALC_F) - RAD(0.02665 * SIN(dWorking(CALC_O)))
		A1 = RAD(299.77 + (0.107408 * dWorking(CALC_K)) - (0.009173 * dT1 * dT1))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.4065 * SIN(dWorking(CALC_M_DASH))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 0.1727  * dWorking(CALC_E) * SIN(dWorking(CALC_M))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 0.0161 * SIN(2 * dWorking(CALC_M_DASH))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0097 * SIN(2 * F1)
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 0.0073 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0050 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0023 * SIN(dWorking(CALC_M_DASH) - 2 * F1)
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 0.0021 * dWorking(CALC_E) * SIN(2 *  dWorking(CALC_M))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 0.0012 * SIN(dWorking(CALC_M_DASH) + 2 * F1)
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 0.0006 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) + dWorking(CALC_M))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0004 * SIN(3 * dWorking(CALC_M_DASH))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0003 * dWorking(CALC_E) * SIN(dWorking(CALC_M) + 2 * F1)
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + 0.0003 * SIN(A1)
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0002 * dWorking(CALC_E) * SIN(dWorking(CALC_M) - 2 * F1)
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0002 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) - dWorking(CALC_M))
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + -0.0002 * SIN(dWorking(CALC_O))
		dP = 0.207 * dWorking(CALC_E) * SIN(dWorking(CALC_M))
		dP = dP + 0.0024 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M))
		dP = dP + -0.0392  * SIN(dWorking(CALC_M_DASH))
		dP = dP + 0.0116 * SIN(2 * dWorking(CALC_M_DASH))
		dP = dP + -0.0073 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M))
		dP = dP + 0.0067 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M))
		dP = dP + 0.0118 * SIN(2 * F1)
		dQ = 5.2207
		dQ = dQ + -0.0048 * dWorking(CALC_E) * COS(dWorking(CALC_M))
		dQ = dQ + 0.002 * dWorking(CALC_E) * COS(2 * dWorking(CALC_M))
		dQ = dQ + -0.3299 * COS(dWorking(CALC_M_DASH))
		dQ = dQ + -0.006 * dWorking(CALC_E) * COS(dWorking(CALC_M_DASH) + dWorking(CALC_M))
		dQ = dQ + 0.0041 * dWorking(CALC_E) * COS(dWorking(CALC_M_DASH) - dWorking(CALC_M))
		dW = ABS(COS(F1))
		dGamma = (dP * COS(F1) + dQ * SIN(F1)) * (1.0 - 0.0048 * dW)
		du = 0.0059 + 0.0046 * dWorking(CALC_E) * COS(dWorking(CALC_M))
		du = du + -0.0182 * COS(dWorking(CALC_M_DASH))
		du = du + 0.0004 * COS(2.0 * dWorking(CALC_M_DASH))
		du = du + -0.0005 * COS(dWorking(CALC_M) + dWorking(CALC_M_DASH))
		dPenumbraMag = (1.5571 + du - ABS(dGamma)) / 0.5450
		dUmbraMag = (1.0157 - du - ABS(dGamma)) / 0.5450
		dWorking(CALC_MOON_PHASE_JDE) = dWorking(CALC_MOON_PHASE_JDE) + GetUTCJDTimeZone_F(dWorking(CALC_MOON_PHASE_JDE)) / 24 ' in local time
		CalcDateFromJD_S dWorking(CALC_MOON_PHASE_JDE)
		' only do is Penumbra eclipse
		if dPenumbraMag > 0 Then
			dP = 1.0128 - du
			dT = 0.4707 - du
			dn = 0.5458 + 0.04 * COS(dWorking(CALC_M_DASH))
			dGamma = dGamma * dGamma ' square dGamma here so only do once
			' note that ABS used in square roots to prevent negative number errors if something wrong
			dUmbraPartial = (60 / dn) * SQR(ABS((dP * dP) - dGamma))
			dUmbraTotal = (60 / dn) * SQR(ABS((dT * dT) - dGamma))
			dH = 1.5573 + du
			dPenumbraPartial = (60 / dn) * SQR(ABS((dH * dH) - dGamma))
			InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
			InString = InString + format$(dUmbraMag,"%1.3g,") 
			InString = InString + format$(dPenumbraMag,"%1.3g,")
			' 1st contact Penumbra
			dTempJD = dWorking(CALC_MOON_PHASE_JDE) - dPenumbraPartial / cMINS_PER_DAY
			dTempJD = dTempJD + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY ' correct to UTC and nearest minute
			CalcDateFromJD_S dTempJD
			dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
			InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
			' 1st contact Umbra
			if dUmbraMag > 0 Then
				dTempJD = dWorking(CALC_MOON_PHASE_JDE) - dUmbraPartial / cMINS_PER_DAY
				dTempJD = dTempJD + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY ' correct to UTC and nearest minute
				CalcDateFromJD_S dTempJD
				dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
				InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
				if dUmbraMag > 1 Then
					' Start Total Phase
					dTempJD = dWorking(CALC_MOON_PHASE_JDE) - dUmbraTotal / cMINS_PER_DAY
					dTempJD = dTempJD + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY 'correct to UTC and nearest minute
					CalcDateFromJD_S dTempJD
					dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
					InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
				End If
			End If
			' Max Total Phase
			dTempJD = dWorking(CALC_MOON_PHASE_JDE)
			dTempJD = dTempJD + (-dWorking(DELTA_TIME_DAYS) / cSEC_PER_DAY) + HALF_MINUTE_AS_DAY ' correct to UTC and nearest minute
			CalcDateFromJD_S dTempJD
			dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
			InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
			if dUmbraMag > 0 Then
				if dUmbraMag > 1 Then
					' End Total Phase
					dTempJD = dWorking(CALC_MOON_PHASE_JDE) + dUmbraTotal / cMINS_PER_DAY
					dTempJD = dTempJD + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY 'correct to UTC and nearest minute
					CalcDateFromJD_S dTempJD
					dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
					InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
				End If
				' End contact Umbra
				dTempJD = dWorking(CALC_MOON_PHASE_JDE) + dUmbraPartial / cMINS_PER_DAY
				dTempJD = dTempJD + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY ' correct to UTC and nearest minute
				CalcDateFromJD_S dTempJD
				dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
				InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
			End If
			' End contact Penumbra
			dTempJD = dWorking(CALC_MOON_PHASE_JDE) + dPenumbraPartial / cMINS_PER_DAY
			dTempJD = dTempJD + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY ' correct to UTC and nearest minute
			CalcDateFromJD_S dTempJD
			dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
			InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, SKIP_COMMA)
			MoonEclipseString_F = InString
			EXIT FUNCTION ' done
		' end of if penumbra
		Else 
			InString = InString + "NIL"
		End If ' No Penumbra
	End If ' possible eclipse
	MoonEclipseString_F = InString
END FUNCTION

FUNCTION GetMonthMoonPhaseStrings_F(InString As String) AS String
	'From AA,CH47
	' UTC_MONTH and UTC_YEAR are the times to calculate the phases, note the approx middle of the month is the time for calculation
	' Calc previous and requesed month to ensure all phases for the requested month are found
	' Uses 19 Locals
	LOCAL Integer nAddtionalPhaseType,bNewMoonDone, bFirstQtrDone, bFullMoonDone, bLastQtrDone, bEclipseDone, nindex
	LOCAL Float dCalcYear, dSum1, dSum2, dTargetMonth, dTargetYear,TempFullMoonJDE
	LOCAL Float dNewMoonJDE, dFirstQtrJDE, dFullMoonJDE, dLastQtrJDE, dAddtionalPhaseJDE
	LOCAL Float dMidMonthFrac(11)
	LOCAL String EclipseString
	nGenCount = 0
	nAddtionalPhaseType = NO_ADDITIONAL_PHASE ' reset
	bNewMoonDone = 0
	bFirstQtrDone = 0
	bFullMoonDone = 0
	bLastQtrDone = 0
	bEclipseDone = 0
	dMidMonthFrac(0) = 0.041 'mid jan
	dMidMonthFrac(1) = 0.123 ' mid feb
	dMidMonthFrac(2) = 0.203
	dMidMonthFrac(3) = 0.290
	dMidMonthFrac(4) = 0.373
	dMidMonthFrac(5) = 0.458
	dMidMonthFrac(6) = 0.540
	dMidMonthFrac(7) = 0.625
	dMidMonthFrac(8) = 0.710
	dMidMonthFrac(9) = 0.789
	dMidMonthFrac(10) = 0.874
	dMidMonthFrac(11) = 0.956
	' work around to create index into dMidMonthFrac in case can't convert double to int in CSUB
	dAddtionalPhaseJDE = cJAN1901_JD ' default it
	dNewMoonJDE = cJAN1901_JD 
	dFirstQtrJDE = cJAN1901_JD
	dFullMoonJDE = cJAN1901_JD 
	dLastQtrJDE = cJAN1901_JD
	dTargetMonth = dWorking(UTC_MONTH) ' save 
	dTargetYear = dWorking(UTC_YEAR)
	' set month to previous month
	INC dWorking(UTC_MONTH), -1
	if dWorking(UTC_MONTH) < 1 Then
		dWorking(UTC_MONTH) = 12.0
		INC dWorking(UTC_YEAR), -1
	End If
	DO WHILE nGenCount < 2
		If nGenCount = 1 Then
			dWorking(UTC_MONTH) = dTargetMonth
			dWorking(UTC_YEAR) = dTargetYear
		End If
		dCalcYear = dWorking(UTC_YEAR) + dMidMonthFrac(dWorking(UTC_MONTH)-1) ' the time we want to know phases in years
		dWorking(CALC_K) = (dCalcYear - 2000) * 12.3685
		' round
		If dWorking(CALC_K) >= 0 Then
			INC dWorking(CALC_K), 0.5
		Else
			INC dWorking(CALC_K), - 0.5
		End If
		dWorking(CALC_K) = FIX(dWorking(CALC_K))
		CalcDeltaTime_S dWorking(UTC_YEAR) ' seconds in day
		'New Moon
		CalcMoonPhaseCommonValues_S 
		dSum2 = CalcSum2_F()
		dSum1 = -0.4072 * SIN(dWorking(CALC_M_DASH)) + 0.17241 * dWorking(CALC_E) * SIN(dWorking(CALC_M)) + 1.608E-2 * SIN(2 * dWorking(CALC_M_DASH))
		dSum1 = dSum1 + 1.039E-2 * SIN(2 * dWorking(CALC_F)) + 7.39E-3 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M))
		dSum1 = dSum1 + -5.14E-3 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M)) + 2.08E-3 * dWorking(CALC_E) * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M))
		dSum1 = dSum1 + -1.11E-3 * SIN(dWorking(CALC_M_DASH) - 2 * dWorking(CALC_F)) - 5.7E-4 * SIN(dWorking(CALC_M_DASH) + 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 5.6E-4 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) + dWorking(CALC_M)) - 4.2E-4 * SIN(3 * dWorking(CALC_M_DASH))
		dSum1 = dSum1 + 4.2E-4 * dWorking(CALC_E) * SIN(dWorking(CALC_M) + 2 * dWorking(CALC_F)) + 3.8E-4 * SIN(dWorking(CALC_M) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + -2.4E-4 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) - dWorking(CALC_M)) - 1.7E-4 * SIN(dWorking(CALC_O))
		dSum1 = dSum1 + -7.0E-5 * SIN(dWorking(CALC_M_DASH) + 2 * dWorking(CALC_M)) + 4.0E-5 * SIN(2 * dWorking(CALC_M_DASH) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 4.0E-5 * SIN(3 * dWorking(CALC_M)) + 3.0E-5 * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 3.0E-5 * SIN(2 * dWorking(CALC_M_DASH) + 2 * dWorking(CALC_F)) - 3.0E-5 * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M) + 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 3.0E-5 * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M) + 2 * dWorking(CALC_F)) - 2.0E-5 * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + -2.0E-5 * SIN(3 * dWorking(CALC_M_DASH) + dWorking(CALC_M)) + 2.0E-5 * SIN(4 * dWorking(CALC_M_DASH))
		dSum1 = dWorking(CALC_MOON_PHASE_JDE) + dSum1 + dSum2
		dSum1 = dSum1 + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY  'now  UTC time, subtract delta and set to nearest min by adding 30 secs
		' ? "UTC JD = ",dSum1, " TZ = ",  GetUTCJDTimeZone_F(dSum1)
		dSum1 = dSum1 + GetUTCJDTimeZone_F(dSum1) / 24 ' in local time
		' ? "New Moon = ", dSum1
		CalcDateFromJD_S dSum1
		' ?  " Day = ", DateStruct(I_DAY_OF_MONTH)
		' ? "Target Month = ", dTargetMonth, " Struct Month = ", DateStruct(I_MONTH)
		If bNewMoonDone = 0 Then ' first
			if DateStruct(I_MONTH) = dTargetMonth Then
				bNewMoonDone = 1
				dNewMoonJDE = dSum1
		'		? "Saved New Moon = ", dSum1
			End If
		Else 
			if DateStruct(I_MONTH) = dTargetMonth Then ' second new moon for month
				nAddtionalPhaseType = ADDTIONAL_NEW_MOON
				dAddtionalPhaseJDE = dSum1
			End If
		End If
		' First Quarter
		INC dWorking(CALC_K), 0.25
		CalcMoonPhaseCommonValues_S
		dSum2 = CalcSum2_F()
		dSum1 = CalcFirstLastQtrSum1_F()
		dSum1 = dWorking(CALC_MOON_PHASE_JDE) + dSum1 + dSum2 + CalcFirstLastQtrW_F()
		dSum1 = dSum1 + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY 'now  UTC time, subtract delta and set to nearest min by adding 30 secs
		dSum1 = dSum1 + GetUTCJDTimeZone_F(dSum1) / 24 'in local time
		CalcDateFromJD_S dSum1
		If bFirstQtrDone = 0 Then ' first
			If DateStruct(I_MONTH) = dTargetMonth Then
				bFirstQtrDone = 1
				dFirstQtrJDE = dSum1
			End If
		Else 
			If DateStruct(I_MONTH) = dTargetMonth Then ' second First Quarter for month
				nAddtionalPhaseType = ADDTIONALFIRST_QTR
				dAddtionalPhaseJDE = dSum1
			End If
		End If
		'Full Moon
		INC dWorking(CALC_K), 0.25
		CalcMoonPhaseCommonValues_S 
		TempFullMoonJDE = dWorking(CALC_MOON_PHASE_JDE) ' save for eclipses
		dSum2 = CalcSum2_F()
		dSum1 = -0.40614 * SIN(dWorking(CALC_M_DASH)) + 0.17302 * dWorking(CALC_E) * SIN(dWorking(CALC_M)) + 1.614E-2 * SIN(2 * dWorking(CALC_M_DASH))
		dSum1 = dSum1 + 1.043E-2 * SIN(2 * dWorking(CALC_F)) + 7.34E-3 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M))
		dSum1 = dSum1 + -5.15E-3 * dWorking(CALC_E) * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M)) + 2.09E-3 * dWorking(CALC_E) * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M))
		dSum1 = dSum1 + -1.11E-3 * SIN(dWorking(CALC_M_DASH) - 2 * dWorking(CALC_F)) - 5.7E-4 * SIN(dWorking(CALC_M_DASH) + 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 5.6E-4 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) + dWorking(CALC_M)) - 4.2E-4 * SIN(3 * dWorking(CALC_M_DASH))
		dSum1 = dSum1 + 4.2E-4 * dWorking(CALC_E) * SIN(dWorking(CALC_M) + 2 * dWorking(CALC_F)) + 3.8E-4 * SIN(dWorking(CALC_M) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + -2.4E-4 * dWorking(CALC_E) * SIN(2 * dWorking(CALC_M_DASH) - dWorking(CALC_M)) - 1.7E-4 * SIN(dWorking(CALC_O))
		dSum1 = dSum1 + -7.0E-5 * SIN(dWorking(CALC_M_DASH) + 2 * dWorking(CALC_M)) + 4.0E-5 * SIN(2.0 * dWorking(CALC_M_DASH) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 4.0E-5 * SIN(3 * dWorking(CALC_M)) + 3.0E-5 * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 3.0E-5 * SIN(2 * dWorking(CALC_M_DASH) + 2 * dWorking(CALC_F)) - 3.0E-5 * SIN(dWorking(CALC_M_DASH) + dWorking(CALC_M) + 2 * dWorking(CALC_F))
		dSum1 = dSum1 + 3.0E-5 * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M) + 2 * dWorking(CALC_F)) - 2.0E-5 * SIN(dWorking(CALC_M_DASH) - dWorking(CALC_M) - 2 * dWorking(CALC_F))
		dSum1 = dSum1 + -2.0E-5 * SIN(3 * dWorking(CALC_M_DASH) + dWorking(CALC_M)) + 2.0E-5 * SIN(4 * dWorking(CALC_M_DASH))
		dSum1 = dWorking(CALC_MOON_PHASE_JDE) + dSum1 + dSum2
		dSum1 = dSum1 + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY 'now  UTC time, subtract delta and set to nearest min by adding 30 secs
		dSum1 = dSum1 + GetUTCJDTimeZone_F(dSum1) / 24 ' in local time
		CalcDateFromJD_S dSum1
		If bFullMoonDone = 0 Then ' first
			If DateStruct(I_MONTH) = dTargetMonth Then
				bFullMoonDone = 1
				dFullMoonJDE = dSum1
			End If
		Else 
			If DateStruct(I_MONTH) = dTargetMonth Then ' second full moon for month
				nAddtionalPhaseType = ADDTIONAL_FULL_MOON
				dAddtionalPhaseJDE = dSum1
			End If
		End If
		' have full moon here, check for eclipse
		' place exclipses data after last quarter but must calculate here, offsets by ECLIPSE_START_STRING
		If bFullMoonDone = 1 AND bEclipseDone = 0 Then
			If nAddtionalPhaseType = NO_ADDITIONAL_PHASE Then
				dWorking(CALC_MOON_PHASE_JDE) = TempFullMoonJDE 'set so can calc eclipse on full moon
				EclipseString = MoonEclipseString_F(EclipseString)
				If Len(EclipseString) > 5 Then ' must be a eclipse as its more than "NIL,"
					bEclipseDone = 1 'prevent checking for eclipse if found on first loop
				End If
			Else 'would have additional full moon if there is one on second loop
				If nAddtionalPhaseType = ADDTIONAL_FULL_MOON Then
					dWorking(CALC_MOON_PHASE_JDE) = dAddtionalPhaseJDE
					EclipseString = MoonEclipseString_F(EclipseString)
				End If
			End If
		End If
		' Last Quarter
		INC dWorking(CALC_K), 0.25
		CalcMoonPhaseCommonValues_S
		dSum2 = CalcSum2_F()
		dSum1 = CalcFirstLastQtrSum1_F()
		dSum1 = dWorking(CALC_MOON_PHASE_JDE) + dSum1 + dSum2 - CalcFirstLastQtrW_F()
		dSum1 = dSum1 + (-dWorking(DELTA_TIME_DAYS)) + HALF_MINUTE_AS_DAY 'now  UTC time, subtract delta and set to nearest min by adding 30 secs
		dSum1 = dSum1 + GetUTCJDTimeZone_F(dSum1) / 24 ' in local time
		CalcDateFromJD_S dSum1
		If bLastQtrDone = 0 Then ' first
			If DateStruct(I_MONTH) = dTargetMonth Then
				bLastQtrDone = 1
				dLastQtrJDE = dSum1
			End If
		Else 
			If DateStruct(I_MONTH) = dTargetMonth Then 'second new moon for month
				nAddtionalPhaseType = ADDTIONAL_LAST_QTR
				dAddtionalPhaseJDE = dSum1
			End If
		End If
		INC nGenCount
	LOOP ' while for 2 loops
	' store data in string
	'New Moon
	CalcDateFromJD_S dNewMoonJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' First Qtr
	CalcDateFromJD_S dFirstQtrJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' Full Moon
	CalcDateFromJD_S dFullMoonJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' Last Qtr
	CalcDateFromJD_S dLastQtrJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' now check for additional phases and append if so
		' first type
	SELECT CASE nAddtionalPhaseType
		case NO_ADDITIONAL_PHASE
			InString = InString + "0,"
		case ADDTIONAL_NEW_MOON
			InString = InString + "1,"
		case ADDTIONALFIRST_QTR
			InString = InString + "2,"
		case ADDTIONAL_FULL_MOON
			InString = InString + "3,"
		case ADDTIONAL_LAST_QTR
			InString = InString + "4,"
	END SELECT
	CalcDateFromJD_S dAddtionalPhaseJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	InString = InString + EclipseString
	GetMonthMoonPhaseStrings_F = InString
END FUNCTION

FUNCTION SubSumEquinoxSolstices_F(lf_T As Float, lf_W As Float) As Float
	' Part of AA, Ch26
	' sum of CalculateEquinoxSolstices
	' Uses 1 Locals
	LOCAL Float lS
	lS = 485.0 * COS(RAD(324.96 + 1934.136 * lf_T))
	lS= lS+ 203.0 * COS(RAD(337.23 + 32964.467 * lf_T))
	lS= lS+ 199.0 * COS(RAD(342.08 + 20.186 * lf_T))
	lS= lS+ 182.0 * COS(RAD(27.85 + 445267.112 * lf_T))
	lS= lS+ 156.0 * COS(RAD(73.14 + 45036.886 * lf_T))
	lS= lS+ 136.0 * COS(RAD(171.52 + 22518.443 * lf_T))
	lS= lS+ 77.0 * COS(RAD(222.54 + 65928.934 * lf_T))
	lS= lS+ 74.0 * COS(RAD(296.72 + 3034.906 * lf_T))
	lS= lS+ 70.0 * COS(RAD(243.58 + 9037.513 * lf_T))
	lS= lS+ 58.0 * COS(RAD(119.81 + 33718.147 * lf_T))
	lS= lS+ 52.0 * COS(RAD(297.17 + 150.678 * lf_T))
	lS= lS+ 50.0 * COS(RAD(21.02 + 2281.226 * lf_T))
	lS= lS+ 45.0 * COS(RAD(247.54 + 29929.562 * lf_T))
	lS= lS+ 44.0 * COS(RAD(325.15 + 31555.956 * lf_T))
	lS= lS+ 29.0 * COS(RAD(60.93 + 4443.417 * lf_T))
	lS= lS+ 18.0 * COS(RAD(155.12 + 67555.328 * lf_T))
	lS= lS+ 17.0 * COS(RAD(288.79 + 4562.452 * lf_T))
	lS= lS+ 16.0 * COS(RAD(198.04 + 62894.029 * lf_T))
	lS= lS+ 14.0 * COS(RAD(199.76 + 31436.921 * lf_T))
	lS= lS+ 12.0 * COS(RAD(95.39 + 14577.848 * lf_T))
	lS= lS+ 12.0 * COS(RAD(287.11 + 31931.756 * lf_T))
	lS= lS+ 12.0 * COS(RAD(320.81 + 34777.259 * lf_T))
	lS= lS+ 9.0 * COS(RAD(227.73 + 1222.114 * lf_T))
	lS= lS+ 8.0 * COS(RAD(15.45 + 16859.074 * lf_T))
	SubSumEquinoxSolstices_F = lS
END FUNCTION

FUNCTION CalculateEquinoxSolstices_F(InString As String) As String
	' AA, CH26 
	' Input Year is UTC_YEAR, string times are Local times
	' only from +1000 to + 3000 years, but day lengths restricted to 1901 to 2100
	' Uses 13 Locals
	LOCAL Float dS, dDelta, dW, MarE, JunS, SepE, dDecS, dY1, dY2, dY3, dY4, JDEJune, JDEDec
	dY1 = (dWorking(UTC_YEAR) - 2000) / 1000
	dY2 = dY1 * dY1
	dY3 = dY1 * dY2
	dY4 = dY1 * dY3
	MarE = 2451623.80984 + (365242.37404 * dY1) + (0.05169 * dY2) - (0.00411 * dY3) - (0.00057 * dY4)
	JunS = 2451716.56767 + (365241.62603 * dY1) + (0.00325 * dY1)+ (0.00888 * dY3) - (0.00030 * dY4)
	SepE = 2451810.21715 + 365242.01767 * dY1 - 0.11575 * dY2 + 0.00337 * dY3 + 0.00078 * dY4
	dDecS = 2451900.05952 + 365242.74049 * dY1 - 0.06223 * dY2 - 0.00823 * dY3 + 0.00032 * dY4
	' March
	dT = (MarE - 2451545) / 36525
	dW = RAD((35999.373 * dT) - 2.47)
	dDelta = 1 + 0.0334 * COS(dW) + 0.0007 * COS(2 * dW)
	dS = SubSumEquinoxSolstices_F(dT, dW)
	dJDE = MarE + ((0.00001 * dS) / dDelta)
	dJDE = dJDE - dWorking(DELTA_TIME_DAYS) 'convert from dynamic time
	' convert to local times depending on if date in or out of DST
	dJDE = dJDE + GetUTCJDTimeZone_F(dJDE) / 24
	CalcDateFromJD_S dJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' June
	dT = (JunS - 2451545.0) / 36525.0
	dW = RAD((35999.373 * dT) - 2.47)
	dDelta = 1 + (0.0334 * COS(dW)) + (0.0007 * COS(2 * dW))
	dS = SubSumEquinoxSolstices_F(dT, dW)
	dJDE = JunS + ((0.00001 * dS) / dDelta)
	JDEJune = FIX(dJDE) + 0.5 ' save UTC for total hrs, should be Midnight UTC
	dJDE = dJDE - dWorking(DELTA_TIME_DAYS) 'convert from dynamic time
	' convert to local times depending on if date in or out of DST
	dJDE = dJDE + GetUTCJDTimeZone_F(dJDE) / 24
	CalcDateFromJD_S dJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' Sep
	dT = (SepE - 2451545.0) / 36525
	dW = RAD((35999.373 * dT) - 2.47)
	dDelta = 1 + (0.0334 * COS(dW)) + (0.0007 * COS(2 * dW))
	dS = SubSumEquinoxSolstices_F(dT, dW)
	dJDE = SepE + ((0.00001 * dS) / dDelta)
	dJDE = dJDE - dWorking(DELTA_TIME_DAYS) 'convert from dynamic time
	' convert to local times depending on if date in or out of DST
	dJDE = dJDE + GetUTCJDTimeZone_F(dJDE) / 24
	CalcDateFromJD_S dJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' Dec
	dT = (dDecS - 2451545.0) / 36525
	dW = RAD((35999.373 * dT) - 2.47)
	dDelta = 1 + (0.0334 * COS(dW)) + (0.0007 * COS(2 * dW))
	dS = SubSumEquinoxSolstices_F(dT, dW)
	dJDE = dDecS + ((0.00001 * dS) / dDelta)
	JDEDec = FIX(dJDE) + 0.5 ' save UTC for total hrs, should be Midnight UTC
	dJDE = dJDE - dWorking(DELTA_TIME_DAYS) 'convert from dynamic time
	' convert to local times depending on if date in or out of DST
	dJDE = dJDE + GetUTCJDTimeZone_F(dJDE) / 24
	CalcDateFromJD_S dJDE
	InString = DateToString_F(InString, DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), APPEND_COMMA)
	' now hr, min,sec
	dHour = DoubleFraction_F(DateStruct(I_DAY_OF_MONTH)) * 24.0
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dHour), GetMinsFromFloatHour_F(dHour), 0, SKIP_SECONDS, APPEND_COMMA)
	' now calculate total hours of daylight from June and Dec Solstices
	' June calculate sunrise and sunset 
	dWorking(RISE_SET_h0_RAD) = RAD(-0.8333)
	dWorking(INTERPOLATE_PERIOD_AS_DAY) = 1
	'CalcJD_S(sDateJune.m_dYear, sDateJune.m_dMonth, FIX(sDateJune.m_dDay), CALC_ALLTD);
	dWorking(CALC_JD) = JDEJune 
	CreateIterationTable_S dWorking(INTERPOLATE_PERIOD_AS_DAY), SUN  'RTAsc and Declin over 3 days, sets dInitialJD to UTC 0
	RiseSetTransit_S DO_INTERPOLATION_RISE_SET, RETURN_M_AS_DAY 'dWorking(TRANSIT_HR) etc as local hrs
	dDayLength = dWorking(SET_HR) - dWorking(RISE_HR)
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dDayLength), GetMinsFromFloatHour_F(dDayLength), GetSecsFromFloatHour_F(dDayLength), INCLUDE_SECONDS, APPEND_COMMA)
	' Dec calculate sunrise and sunset 
	'CalcJD(dWorking, sDate.m_dYear, sDate.m_dMonth, FIX(sDate.m_dDay), CALC_ALLTD);
	dWorking(CALC_JD) = JDEDec 
	CreateIterationTable_S dWorking(INTERPOLATE_PERIOD_AS_DAY), SUN ' RTAsc and Declin over 3 days, sets dInitialJD to UTC 0
	RiseSetTransit_S DO_INTERPOLATION_RISE_SET, RETURN_M_AS_DAY ' dWorking(TRANSIT_HR) etc as local hrs
	dDayLength = dWorking(SET_HR) - dWorking(RISE_HR)
	InString = HourMinSecToString_F(InString, GetHourFromFloatHour_F(dDayLength), GetMinsFromFloatHour_F(dDayLength), GetSecsFromFloatHour_F(dDayLength), INCLUDE_SECONDS, APPEND_COMMA)
	' now add leap year
	If IsLeapYear_F(dWorking(UTC_YEAR)) Then
		InString = InString +"Y"
	Else
		InString = InString +"N"
	End If
	CalculateEquinoxSolstices_F = InString
END FUNCTION

SUB MercuryPosition_S
	' Ch 31, AA and Appendix II.
	'  Note: Not all of the table data is used
	' Approximate Error based on AA Ed 1, pp208 equation
	' Longitude:	Less than 15"
	' Latitude:	Less than 10"
	' Distance:	Less than 2,500km
	' Uses 0 Locals
	dT1 = CalcTMillennia_F(dWorking(CALC_JD))
	dL0 = 440250710.0
	dL0=dL0+ 40989415 * COS(1.48302034 + 26087.9031457 * dT1)
	dL0=dL0+ 5046294 * COS(4.4778549 + 52175.8062831 * dT1)
	dL0=dL0+ 855347 * COS(1.165203 + 78263.709425 * dT1)
	dL0=dL0+ 165590 * COS(4.119692 + 104351.612566 * dT1)
	dL0=dL0+ 34562 * COS(0.77931 + 130439.51571 * dT1)
	dL0=dL0+ 7583 * COS(3.7135 + 156527.418871 * dT1)
	dL0=dL0+ 3560 * COS(1.5125 + 1109.3786 * dT1)
	dL0=dL0+ 1803 * COS(4.1033 + 5661.3320 * dT1)
	dL0=dL0+ 1726 * COS(0.3583 + 182615.3220 * dT1)
	dL0=dL0+ 1590 * COS(2.9951 + 25028.5212 * dT1)
	dL0=dL0+ 1365 * COS(4.5992 + 27197.2817 * dT1)
	dL0=dL0+ 1017 * COS(0.8803 + 31749.2352 * dT1)
	dL0=dL0+ 714 * COS(1.541 + 24978.525 * dT1) 'terms 14, 11"
	dL1 = 2608814706223
	dL1=dL1+ 1126008 * COS(6.2170397 + 26087.9031416 * dT1)
	dL1=dL1+ 303471 * COS(3.055655 + 52175.806283 * dT1)
	dL1=dL1+ 80538 * COS(6.10455 + 78263.70942 * dT1)
	dL1=dL1+ 21245 * COS(2.83532 + 104351.61257 * dT1)
	dL1=dL1+ 5592 * COS(5.8268 + 130439.5157 * dT1) ' terms 6, 1"
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dL0 + dL1 * dT1
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dWorking(CALC_PLAN_ECLIP_LONG_RAD) / 100000000 ' now radians
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = FixP1ToZeroToP2_F(dWorking(CALC_PLAN_ECLIP_LONG_RAD), cTWO_PI)
	' now lat
	dB0 = 11737529 * COS(1.98357499 + 26087.90314157 * dT1)
	dB0=dB0+ 2388077 * COS(5.0373896 + 52175.8062831 * dT1)
	dB0=dB0+ 1222840 * COS(3.1415927)
	dB0=dB0+ 543252 * COS(1.796444 + 78263.709425 * dT1)
	dB0=dB0+ 129779 * COS(4.832325 + 104351.612566 * dT1)
	dB0=dB0+ 31867 * COS(1.58088 + 130439.51571 * dT1)
	dB0=dB0+ 7963 * COS(4.6097 + 156527.4188 * dT1)
	dB0=dB0+ 2014 * COS(1.3532 + 182615.3220 * dT1)
	dB0=dB0+ 514 * COS(4.378 + 208703.225 * dT1) ' terms 9, 6"
	dB1 = 429151 * COS(3.501698 + 26087.903142 * dT1)
	dB1 = dB1 + 146234 * COS(3.141593)
	dB1 = dB1 + 22675 * COS(0.01515 + 52175.80628 * dT1)
	dB1 = dB1 + 10895 * COS(0.48540 + 78263.70942 * dT1) ' terms 4, 2"
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dB0 + dB1 * dT1
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dWorking(CALC_PLAN_ECLIP_LAT_RAD) / 100000000 ' now radians
	' now Radius Vector
	dR0 = 39528272
	dR0=dR0+ 7834132 * COS(6.1923372 + 26087.9031416 * dT1)
	dR0=dR0+ 795526 * COS(2.959897 + 52175.806283 * dT1)
	dR0=dR0+ 121282 * COS(6.010642 + 78263.709425 * dT1)
	dR0=dR0+ 21922 * COS(2.77820 + 104351.61247 * dT1)
	dR0=dR0+ 4354 * COS(5.8289 + 130439.5157 * dT1)
	dR0=dR0+ 918 * COS(2.597 + 156527.419 * dT1)
	dR0=dR0+ 260 * COS(3.028 + 27197.282 * dT1) ' terms 9, 2400km
	dR0=dR0+ 202 * COS(5.647 + 182615.322 * dT1)
	dR0=dR0+ 201 * COS(5.592 + 31749.235 * dT1)
	dR0=dR0+ 142 * COS(6.253 + 24978.525 * dT1)
	dR0=dR0+ 100 * COS(3.734 + 21535.95 * dT1) ' terms 13, 1080km
	dR1 = 217348 * COS(4.656172 + 26087.903142 * dT1)
	dR1 = dR1 + 44142 * COS(1.42386 + 52175.80628 * dT1)
	dR1 = dR1 + 10094 * COS(4.47466 + 78263.70942 * dT1)
	dR1 = dR1 + 2433 * COS(1.2423 + 104351.6126 * dT1) ' terms 4, 340km
	dWorking(CALC_PLAN_RAD_VEC_AU) = dR0 + dR1 * dT1
	dWorking(CALC_PLAN_RAD_VEC_AU) = dWorking(CALC_PLAN_RAD_VEC_AU) / 100000000 ' now AU
	CalcPlanRtAscDeclin_S
END SUB

SUB VenusPosition_S  
	'Ch 31, AA and Appendix II.
	'  Note: Not all of the table data is used
	' Approximate Error based on AA Ed 1, pp208 equation
	' Longitude:	Less than 15"
	' Latitude:	Less than 10"
	' Distance:	Less than 4,000km
	' Uses 0 Locals
	dT1 = CalcTMillennia_F(dWorking(CALC_JD))
	dL0 = 317614667
	dL0 = dL0 +  1353968 * COS(5.5931332 + 10213.2855462 * dT1)
	dL0 = dL0 +  89892 * COS(5.30650 + 20426.57109 * dT1)
	dL0 = dL0 +  5477 * COS(4.4163 + 7860.4194 * dT1) ' 45"
	dL0 = dL0 +  3456 * COS(2.6996 + 11790.6291 * dT1)
	dL0 = dL0 +  2372 * COS(2.9938 + 3930.2097 * dT1)
	dL0 = dL0 +  1664 * COS(4.2502 + 1557.3435 * dT1)
	dL0 = dL0 +  1438 * COS(4.1575 + 9683.5946 * dT1)
	dL0 = dL0 +  1317 * COS(5.1867 + 26.2983 * dT1)
	dL0 = dL0 +  1201 * COS(6.1536 + 30639.8566 * dT1)
	dL0 = dL0 +  769 * COS(0.816 + 9437.763 * dT1) ' terms 11, 10"
	dL1 = 1021352943053
	dL1 = dL1 + 95708 * COS(2.46424 + 10213.28555 * dT1)
	dL1 = dL1 + 14445 * COS(0.51625 + 20426.57109 * dT1) ' 2.4"
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dL0 + dL1 * dT1
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dWorking(CALC_PLAN_ECLIP_LONG_RAD) / 100000000 ' now radians
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = FixP1ToZeroToP2_F(dWorking(CALC_PLAN_ECLIP_LONG_RAD), cTWO_PI)
	' now lat
	dB0 = 5923638 * COS(0.2670278 + 10213.2855462 * dT1)
	dB0 = dB0 + 40108 * COS(1.14737 + 20426.57109 * dT1)
	dB0 = dB0 + 32815 * COS(3.14159)
	dB0 = dB0 + 1011 * COS(1.0895 + 30639.8566 * dT1) 'terms 4, 8"
	dB1 = 513348 * COS(1.803643 + 10213.285546 * dT1)
	dB1 = dB1 + 4380 * COS(3.3862 + 20426.5711 * dT1) '0.6"
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dB0 + dB1 * dT1
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dWorking(CALC_PLAN_ECLIP_LAT_RAD) / 100000000 ' now radians
	'  Radius Vector
	dR0 = 72334821
	dR0 = dR0 +  489824 * COS(4.021518 + 10213.285546 * dT1)
	dR0 = dR0 +  1658 * COS(4.9021 + 20426.5711 * dT1)
	dR0 = dR0 +  1632 * COS(2.8455 + 7860.4194 * dT1)
	dR0 = dR0 +  1378 * COS(1.1285 + 11790.6291 * dT1)
	dR0 = dR0 +  498 * COS(2.587 + 9683.595 * dT1) ' terms 6, 3700km
	dR1 = 34551 * COS(0.89199 + 10213.28555 * dT1)
	dR1 = dR1 + 234 * COS(1.772 + 20426.571 * dT1) ' terms 2, 23km
	dWorking(CALC_PLAN_RAD_VEC_AU) = dR0 + dR1 * dT1
	dWorking(CALC_PLAN_RAD_VEC_AU) = dWorking(CALC_PLAN_RAD_VEC_AU) / 100000000 'now AU
	CalcPlanRtAscDeclin_S
END SUB

SUB MarsPosition_S 
	'Ch 31, AA and Appendix II.
	'  Note: Not all of the table data is used
	' Approximate Error based on AA Ed 1, pp208 equation
	' Longitude:	Less than 20"
	' Latitude:	Less than 10"
	' Distance:	Less than 13,000km
	' Uses 0 Locals
	dT1 = CalcTMillennia_F(dWorking(CALC_JD))
	dT2 = dT1 * dT1
	dL0 = 620347712
	dL0 = dL0 + 18656368 * COS(5.050371 + 3340.6124267 * dT1)
	dL0 = dL0 + 1108217 * COS(5.4009984 + 6681.2248534 * dT1)
	dL0 = dL0 + 91798 * COS(5.75479 + 10021.83728 * dT1)
	dL0 = dL0 + 27745 * COS(5.97050 + 3.52312 * dT1)
	dL0 = dL0 + 12316 * COS(0.84956 + 2810.92146 * dT1)
	dL0 = dL0 + 10610 * COS(2.93959 + 2281.2305 * dT1)
	dL0 = dL0 + 8927 * COS(4.1570 + 0.0173 * dT1)
	dL0 = dL0 + 8716 * COS(6.1101 + 13362.4497 * dT1)
	dL0 = dL0 + 7775 * COS(3.3397 + 5621.8429 * dT1) '10
	dL0 = dL0 + 6798 * COS(0.3646 + 398.149 * dT1) ' 93"
	dL0 = dL0 + 4161 * COS(0.2281 + 2942.4634 * dT1)
	dL0 = dL0 + 3575 * COS(1.6619 + 2544.3144 * dT1)
	dL0 = dL0 + 3075 * COS(0.8570 + 191.4483 * dT1)
	dL0 = dL0 + 2938 * COS(6.0789 + 0.0673 * dT1)
	dL0 = dL0 + 2628 * COS(0.6481 + 3337.0893 * dT1)
	dL0 = dL0 + 2580 * COS(0.0300 + 3344.1355 * dT1)
	dL0 = dL0 + 2389 * COS(5.0390 + 796.2980 * dT1)
	dL0 = dL0 + 1799 * COS(0.6563 + 529.6910 * dT1)
	dL0 = dL0 + 1546 * COS(2.9158 + 1751.5395 * dT1)
	dL0 = dL0 + 1528 * COS(1.1498 + 6151.5339 * dT1)
	dL0 = dL0 + 1286 * COS(3.0680 + 2146.1654 * dT1)
	dL0 = dL0 + 1264 * COS(3.6228 + 5092.1520 * dT1)
	dL0 = dL0 + 1025 * COS(3.6933 + 8962.4553 * dT1)
	dL0 = dL0 + 892 * COS(0.183 + 16703.062 * dT1) ' terms 25, 18"
	dL1 = 334085627474
	dL1 = dL1 + 1458227 * COS(3.6042605 + 3340.6124267 * dT1)
	dL1 = dL1 + 164901 * COS(3.926313 + 6681.224853 * dT1)
	dL1 = dL1 + 19963 * COS(4.26594 + 10021.83728 * dT1) 
	dL1 = dL1 + 3452 * COS(4.7321 + 3.5231 * dT1) 'terms 5, 1"
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dL0 + dL1 * dT1
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dWorking(CALC_PLAN_ECLIP_LONG_RAD) / 100000000 ' now radians
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = FixP1ToZeroToP2_F(dWorking(CALC_PLAN_ECLIP_LONG_RAD), cTWO_PI)
	dB0 = 3197135 * COS(3.7683204 + 3340.6124267 * dT1)
	dB0 = dB0 + 298033 * COS(4.106170 + 6681.224853 * dT1)
	dB0 = dB0 + 289105
	dB0 = dB0 + 31366 * COS(4.44651 + 10021.83728 * dT1)
	dB0 = dB0 + 3484 * COS(4.7881 + 13362.4497 * dT1)
	dB0 = dB0 + 443 * COS(5.026 + 3344.136 * dT1) 'terms 6, 5"
	dB1 = 350069 * COS(5.368478 + 3340.612427 * dT1)
	dB1 = dB1 + 14116 * COS(3.14159)
	dB1 = dB1 + 9671 * COS(5.4788 + 6681.2249 * dT1) ' terms 3, 2"
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dB0 + dB1 * dT1
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dWorking(CALC_PLAN_ECLIP_LAT_RAD) / 100000000 ' now radians
	'  Radius Vector
	dR0 = 153033488
	dR0 = dR0 +  14184953 * COS(3.47971284 + 3340.61242670 * dT1)
	dR0 = dR0 +  660776 * COS(3.817834 + 6681.224853 * dT1)
	dR0 = dR0 +  46179 * COS(4.15595 + 10021.83728 * dT1)
	dR0 = dR0 +  8110* COS(5.5596 + 2810.9215 * dT1)
	dR0 = dR0 +  7485 * COS(1.7724 + 5621.8429 * dT1)
	dR0 = dR0 +  5523 * COS(1.3644 + 2281.2305 * dT1)
	dR0 = dR0 +  3825 * COS(4.4941 + 13362.4497 * dT1)
	dR0 = dR0 +  2484 * COS(4.9255 + 2942.4634 * dT1)
	dR0 = dR0 +  2307 * COS(0.0908 + 2544.3144 * dT1)
	dR0 = dR0 +  1999 * COS(5.3606 + 3337.0893 * dT1)
	dR0 = dR0 +  1960 * COS(4.7425 + 3344.1355 * dT1)
	dR0 = dR0 +  1167 * COS(2.1126 + 5092.1520 * dT1)
	dR0 = dR0 +  1103 * COS(5.0091 + 398.1490 * dT1)
	dR0 = dR0 +  992 * COS(5.839 + 6151.534 * dT1) ' terms 15, 12,000km
	dR1 = 11074533 * COS(2.0325052 + 3340.6124267 * dT1)
	dR1 = dR1 + 103176 * COS(2.370718 + 6681.224853 * dT1)
	dR1 = dR1 + 12877
	dR1 = dR1 + 10816 * COS(2.70888 + 10021.83728 * dT1) ' terms 4, 1600km
	dWorking(CALC_PLAN_RAD_VEC_AU) = dR0 + dR1 * dT1
	dWorking(CALC_PLAN_RAD_VEC_AU) = dWorking(CALC_PLAN_RAD_VEC_AU) / 100000000 ' now AU
	CalcPlanRtAscDeclin_S
END SUB

SUB JupiterPosition_S
	'Ch 31, AA and Appendix II.
	'  Note: Not all of the table data is used
	' Approximate Error based on AA Ed 1, pp208 equation
	' Longitude:	Less than 25"
	' Latitude:	Less than 15"
	' Distance:	Less than 85,000km
	' Uses 0 Locals
	dT1 = CalcTMillennia_F(dWorking(CALC_JD))
	dT2 = dT1 * dT1
	dL0 = 59954691
	dL0 = dL0 + 9695899 * COS(5.0619179 + 529.6909651 * dT1)
	dL0 = dL0 + 573610 * COS(1.444062 + 7.113547 * dT1)
	dL0 = dL0 + 306389 * COS(5.417347 + 1059.38193 * dT1)
	dL0 = dL0 + 97178 * COS(4.14265 + 632.78374 * dT1)
	dL0 = dL0 + 72903 * COS(3.64043 + 522.57742 * dT1)
	dL0 = dL0 + 64264 * COS(3.41145 + 103.09277 * dT1)
	dL0 = dL0 + 39806 * COS(2.29377 + 419.48464 * dT1)
	dL0 = dL0 + 38858 * COS(1.27232 + 316.39187 * dT1)
	dL0 = dL0 + 27965 * COS(1.78455 + 536.80451 * dT1)
	dL0 = dL0 + 13590 * COS(5.77481 + 1589.0729 * dT1)
	dL0 = dL0 + 8769 * COS(3.6300 + 949.1756 * dT1)
	dL0 = dL0 + 8246 * COS(3.5823 + 206.1855 * dT1)
	dL0 = dL0 + 7368 * COS(5.0810 + 735.8765 * dT1)
	dL0 = dL0 + 6263 * COS(0.025 + 213.2991 * dT1)
	dL0 = dL0 + 6114 * COS(4.5132 + 1162.4747 * dT1)
	dL0 = dL0 + 5305 * COS(4.1863 + 1052.2684 * dT1)
	dL0 = dL0 + 5305 * COS(1.3067 + 14.2271 * dT1)
	dL0 = dL0 + 4905 * COS(1.3208 + 110.2063 * dT1)
	dL0 = dL0 + 4647 * COS(4.6996 + 3.9322 * dT1)
	dL0 = dL0 + 3045 * COS(4.3168 + 426.5982 * dT1) ' 21, 60"
	dL0 = dL0 + 2610 * COS(1.5667 + 846.0828 * dT1)
	dL0 = dL0 + 2028 * COS(1.0638 + 3.1814 * dT1)
	dL0 = dL0 + 1921 * COS(0.9717 + 639.8973 * dT1)
	dL0 = dL0 + 1765 * COS(2.1415 + 1066.4955 * dT1)
	dL0 = dL0 + 1723 * COS(3.8804 + 1265.5675 * dT1)
	dL0 = dL0 + 1633 * COS(3.582 + 515.4639 * dT1)
	dL0 = dL0 + 1432 * COS(4.2968 + 625.6702 * dT1)
	dL0 = dL0 + 973 * COS(4.098 + 95.979 * dT1) ' terms 29, 22"
	dL1 = 52993480757
	dL1 = dL1 + 489741 * COS(6.026475 + 529.690965 * dT1)
	dL1 = dL1 + 228919 * COS(4.220667 + 7.113547 * dT1)
	dL1 = dL1 + 27655 * COS(4.57266 + 1059.38193 * dT1)
	dL1 = dL1 + 20721 * COS(5.45939 + 522.57742 * dT1)
	dL1 = dL1 + 12106 * COS(0.16986 + 536.80451 * dT1) 'terms 6, 3"
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dL0 + dL1 * dT1
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dWorking(CALC_PLAN_ECLIP_LONG_RAD) / 100000000 ' now radians
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = FixP1ToZeroToP2_F(dWorking(CALC_PLAN_ECLIP_LONG_RAD), cTWO_PI)
	dB0 = 2268616 * COS(3.5585261 + 529.6909651 * dT1)
	dB0 = dB0 + 110090
	dB0 = dB0 + 109972 * COS(3.908093 + 1059.381930 * dT1)
	dB0 = dB0 + 8101 * COS(3.6051 + 522.5774 * dT1)
	dB0 = dB0 + 6438 * COS(0.3063 + 536.8045 * dT1)
	dB0 = dB0 + 6044 * COS(4.2588 + 1589.0729 * dT1)
	dB0 = dB0 + 1107 * COS(2.9853 + 1162.4747 * dT1) ' terms 7, 12"
	dB1 = 177352 * COS(5.701665 + 529.690965 * dT1)
	dB1 = dB1 + 3230 * COS(5.7794 + 1059.3819 * dT1) ' terms 2, 0.5"
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dB0 + dB1 * dT1
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dWorking(CALC_PLAN_ECLIP_LAT_RAD) / 100000000 ' now radians
	'  Radius Vector
	dR0 = 520887429
	dR0 = dR0 + 25209327 * COS(3.49108640 + 529.69096509 * dT1)
	dR0 = dR0 + 610600 * COS(3.841154 + 1059.381930 * dT1)
	dR0 = dR0 + 282029 * COS(2.574199 + 632.783739 * dT1)
	dR0 = dR0 + 187647 * COS(2.075904 + 522.577418 * dT1)
	dR0 = dR0 + 86793 * COS(0.71001 + 419.48464 * dT1)
	dR0 = dR0 + 72063 * COS(0.21466 + 536.80451 * dT1)
	dR0 = dR0 + 65517 * COS(5.97996 + 316.39187 * dT1)
	dR0 = dR0 + 30135 * COS(2.16132 + 949.17561 * dT1)
	dR0 = dR0 + 29135 * COS(1.67759 + 103.09277 * dT1)
	dR0 = dR0 + 23947 * COS(0.27458 + 7.11355 * dT1)
	dR0 = dR0 + 23453 * COS(3.54023 + 735.87651 * dT1)
	dR0 = dR0 + 22284 * COS(4.19363 + 1589.07290 * dT1)
	dR0 = dR0 + 13033 * COS(2.96043 + 1162.47470 * dT1)
	dR0 = dR0 + 12749 * COS(2.71550 + 1052.26838 * dT1)
	dR0 = dR0 + 9703 * COS(1.9067 + 206.1855 * dT1)
	dR0 = dR0 + 9161 * COS(4.4135 + 213.2991 * dT1)
	dR0 = dR0 + 7895 * COS(2.4791 + 426.5982 * dT1)
	dR0 = dR0 + 7058 * COS(2.1818 + 1265.5675 * dT1)
	dR0 = dR0 + 6138 * COS(6.2642 + 846.0828 * dT1) ' terms 20, 83000km
	dR1 = 1271802 * COS(2.6493751 + 529.6909651 * dT1)
	dR1 = dR1 + 61662 * COS(3.00076 + 1059.38193 * dT1)
	dR1 = dR1 + 53444 * COS(3.89718 + 522.57742 * dT1)
	dR1 = dR1 + 41390
	dR1 = dR1 + 31185 * COS(4.88277 + 536.80451 * dT1)
	dR1 = dR1 + 11847 * COS(2.41330 + 419.48464 * dT1)
	dR1 = dR1 + 9166 * COS(4.7598 + 7.1135 * dT1) 'terms 7, 1700km
	dR1 = dR1 + 3404 * COS(3.3469 + 1589.0729 * dT1) ' terms 8, 680km
	dWorking(CALC_PLAN_RAD_VEC_AU) = dR0 + dR1 * dT1
	dWorking(CALC_PLAN_RAD_VEC_AU) = dWorking(CALC_PLAN_RAD_VEC_AU) / 100000000 ' now AU
	CalcPlanRtAscDeclin_S
END SUB

SUB SaturnPosition_S
	'Ch 31, AA and Appendix II.
	'  Note: Not all of the table data is used
	' Approximate Error based on AA Ed 1, pp208 equation
	' Longitude:	Less than 30"
	' Latitude:	Less than 25"
	' Distance:	Less than 80,000km
	' Uses 0 Locals
	dT1 = CalcTMillennia_F(dWorking(CALC_JD))
	dT2 = dT1 * dT1
	dL0 = 87401354
	dL0 = dL0 + 11107660 * COS(3.9620509 + 213.29909544 * dT1)
	dL0 = dL0 + 1414151 * COS(4.5858152 + 7.1135470 * dT1)
	dL0 = dL0 + 398379 * COS(0.52112 + 206.185548 * dT1)
	dL0 = dL0 + 350769 * COS(3.303299 + 426.598191 * dT1)
	dL0 = dL0 + 206816 * COS(0.246584 + 103.092774 * dT1)
	dL0 = dL0 + 79271 * COS(3.84007 + 220.41264 * dT1)
	dL0 = dL0 + 23990 * COS(4.66977 + 110.20632 * dT1)
	dL0 = dL0 + 16574 * COS(0.43719 + 419.48464 * dT1)
	dL0 = dL0 + 15820 * COS(0.93809 + 632.78374 * dT1) 
	dL0 = dL0 + 15054 * COS(2.71670 + 639.89729 * dT1)
	dL0 = dL0 + 14907 * COS(5.76903 + 316.39187 * dT1)
	dL0 = dL0 + 14610 * COS(1.56519 + 3.93215 * dT1)
	dL0 = dL0 + 13160 * COS(4.44891 + 14.22709 * dT1)
	dL0 = dL0 + 13005 * COS(5.98119 + 11.04570 * dT1)
	dL0 = dL0 + 10725 * COS(3.1294 + 202.25340 * dT1)
	dL0 = dL0 + 6126 * COS(1.7633 + 277.0350 * dT1)
	dL0 = dL0 + 5863 * COS(0.2366 + 529.691 * dT1)
	dL0 = dL0 + 5228 * COS(4.2078 + 3.1814 * dT1)
	dL0 = dL0 + 5020 * COS(3.1779 + 433.7117 * dT1) 
	dL0 = dL0 + 4593 * COS(0.6198 + 199.0720 * dT1)
	dL0 = dL0 + 4006 * COS(2.2448 + 63.7359 * dT1)
	dL0 = dL0 + 3874 * COS(3.2228 + 138.5175 * dT1)
	dL0 = dL0 + 3269 * COS(0.7749 + 949.1756 * dT1)
	dL0 = dL0 + 2954 * COS(0.9828 + 95.9792 * dT1) 'terms 25, 60"
	dL0 = dL0 + 2461 * COS(2.0316 + 735.8765 * dT1)
	dL0 = dL0 + 1758 * COS(3.2658 + 522.5774 * dT1)
	dL0 = dL0 + 1640 * COS(5.505 + 846.0828 * dT1)
	dL0 = dL0 + 1581 * COS(4.3727 + 309.2783* dT1)
	dL0 = dL0 + 1391 * COS(4.0233 + 323.5054  * dT1)
	dL0 = dL0 + 1124 * COS(2.8373 + 415.5525 * dT1) 'terms 31, 26"
	dL1 = 21354295596
	dL1 = dL1 + 1296855 * COS(1.8282054 + 213.2990954 * dT1)
	dL1 = dL1 + 564348 * COS(2.885001 + 7.113547 * dT1)
	dL1 = dL1 + 107679 * COS(2.277699 + 206.185548 * dT1)
	dL1 = dL1 + 98323 * COS(1.08070 + 426.59819 * dT1)
	dL1 = dL1 + 40255 * COS(2.04128 + 220.41264 * dT1)
	dL1 = dL1 + 19942 * COS(1.27955 + 103.09277 * dT1)
	dL1 = dL1 + 10512 * COS(2.74880 + 14.22709 * dT1) ' terms 8, 3"
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dL0 + dL1 * dT1 
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dWorking(CALC_PLAN_ECLIP_LONG_RAD) / 100000000 ' now radians
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = FixP1ToZeroToP2_F(dWorking(CALC_PLAN_ECLIP_LONG_RAD), cTWO_PI)
	dB0 = 4330678 * COS(3.6028443 + 213.2990954 * dT1)
	dB0 = dB0 + 240348 * COS(2.852385 + 426.598191 * dT1)
	dB0 = dB0 + 84746
	dB0 = dB0 + 34116 * COS(0.57297 + 206.18555 * dT1)
	dB0 = dB0 + 30863 * COS(3.48442 + 220.41264 * dT1)
	dB0 = dB0 + 14734 * COS(2.11847 + 639.89729 * dT1)
	dB0 = dB0 + 9917 * COS(5.7900 + 419.4846 * dT1)
	dB0 = dB0 + 6994 * COS(4.7360 + 7.1135 * dT1)
	dB0 = dB0 + 4808 * COS(5.4331 + 316.399 * dT1) ' 9, 60"
	dB0 = dB0 + 4788 * COS(4.9651 + 110.2063 * dT1)
	dB0 = dB0 + 3432 * COS(2.7326 + 433.7117 * dT1)
	dB0 = dB0 + 1506 * COS(6.013 + 103.0928 * dT1) ' Terms 12, 22'
	dB1 = 397555 * COS(5.332900 + 213.299095 * dT1)
	dB1 = dB1 + 49479 * COS(3.14159)
	dB1 = dB1 + 18572 * COS(6.09919 + 426.59819 * dT1)
	dB1 = dB1 + 14801 * COS(2.30586 + 206.18555 * dT1)
	dB1 = dB1 + 9644 * COS(1.6967 + 220.4126 * dT1) 'terms 5, 2"
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dB0 + dB1 * dT1
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dWorking(CALC_PLAN_ECLIP_LAT_RAD) / 100000000 ' now radians
	'  Radius Vector
	dR0 = 955758136
	dR0 =dR0 + 52921382 * COS(2.39226220 + 213.29909544 * dT1)
	dR0 =dR0 + 1873680 * COS(5.2354961 + 206.1855484 * dT1)
	dR0 =dR0 + 1464664 * COS(1.6476305 + 426.5981909 * dT1)
	dR0 =dR0 + 821891 * COS(1.6476305 + 316.391870 * dT1)
	dR0 =dR0 + 547507 * COS(5.015326 + 103.092774 * dT1)
	dR0 =dR0 + 371684 * COS(2.271148 + 220.412642 * dT1)
	dR0 =dR0 + 361778 * COS(3.139043 + 7.113547 * dT1)
	dR0 =dR0 + 140618 * COS(5.704067 + 632.783739 * dT1)
	dR0 =dR0 + 108975 * COS(3.293136 + 110.206321 * dT1)
	dR0 =dR0 + 69007 * COS(5.94100 + 419.48464 * dT1)
	dR0 =dR0 + 61053 * COS(0.94038 + 639.89729 * dT1)
	dR0 =dR0 + 48913 * COS(1.55733 + 202.25340 * dT1)
	dR0 =dR0 + 34144 * COS(0.19519 + 277.03499 * dT1)
	dR0 =dR0 + 32402 * COS(5.47085 + 949.17561 * dT1)
	dR0 =dR0 + 20937 * COS(0.46349 + 735.87651 * dT1)
	dR0 =dR0 + 20839 * COS(1.52103 + 433.71174 * dT1)
	dR0 =dR0 + 20747 * COS(5.33256 + 199.0720 * dT1)
	dR0 =dR0 + 15298 * COS(3.05944 + 529.69097 * dT1)
	dR0 =dR0 + 14296 * COS(2.60434 + 323.50542 * dT1)
	dR0 =dR0 + 12884 * COS(1.64892 + 138.5175 * dT1)
	dR0 =dR0 + 11993 * COS(5.98051 + 846.08283 * dT1)
	dR0 =dR0 + 11380 * COS(1.73106 + 522.57742 * dT1)
	dR0 =dR0 + 9796 * COS(5.2048 + 1265.5675 * dT1)
	dR0 =dR0 + 7753 * COS(5.8519 + 95.9792 * dT1)
	dR0 =dR0 + 6771 * COS(3.0043 + 14.2271 * dT1)
	dR0 =dR0 + 6466 * COS(0.1773 + 1052.2684 * dT1)
	dR0 =dR0 + 5850 * COS(1.4552 + 415.5525 * dT1)
	dR0 =dR0 + 5307 * COS(0.5974 + 63.7359 * dT1)
	dR0 =dR0 + 4696 * COS(2.1492 + 227.5262 * dT1) ' terms 30, 77000km
	dR1 = 6182981 * COS(0.2584352 + 213.2990954 * dT1)
	dR1 =dR1 + 506578 * COS(0.711147 + 206.185548 * dT1)
	dR1 =dR1 + 341394 * COS(5.796358 + 426.598191 * dT1)
	dR1 =dR1 + 188491 * COS(0.472157 + 220.412642 * dT1)
	dR1 =dR1 + 186262 * COS(3.141593)
	dR1 =dR1 + 143891 * COS(1.407449 + 7.113547 * dT1)
	dR1 =dR1 + 49621 * COS(1.407449 + 103.09277 * dT1)
	dR1 =dR1 + 20928 * COS(5.09246 + 639.89729 * dT1)
	dR1 =dR1 + 19953 * COS(1.17560 + 419.48464 * dT1)
	dR1 =dR1 + 19953 * COS(1.60820 + 110.20632 * dT1)
	dR1 =dR1 + 13877 * COS(0.75886 + 199.072 * dT1)
	dR1 =dR1 + 12893 * COS(5.94330 + 433.71174 * dT1)
	dR1 =dR1 + 5397 * COS(1.2885 + 14.2271 * dT1) ' terms 13, 1400m
	dWorking(CALC_PLAN_RAD_VEC_AU) = dR0 + dR1 * dT1
	dWorking(CALC_PLAN_RAD_VEC_AU) = dWorking(CALC_PLAN_RAD_VEC_AU) / 100000000 ' now AU
	CalcPlanRtAscDeclin_S
END SUB

SUB CorrectForPrecession_S
	' calculate precession for correct date then update Long and Lat
	' 	AA Ch 20, equation 20.6 but note the second and third terms (dt squared and cubed) are ommitted as they add little correction 
	' when using the time frame limits of this program
	' 	*** WARNING****************************************************
	'    Overwrights CALC_PLAN_ECLIP_LAT_RAD and CALC_PLAN_ECLIP_LONG_RAD with modified data
	' 	***************************************************************
	' corrects from JD2000 to the actual date as per dWorking(CALC_JD)
	' Uses 6 Locals
	LOCAL Float CDash, BDash, ADash, dpRAD, dPiRAD, dnRAD
	dt = (dWorking(CALC_JD) - 2451545) / 36525
	dt2 = dt * dt
	dt3 = dt2 * dt
	dnRAD = RAD((47.0029 * dt) / 3600)
	dPiRAD = RAD(174.876384 - (869.8089 * dt) / 3600)
	dpRAD = RAD((5029.0966 * dt) / 3600)
	ADash = (COS(dnRAD) * COS(dWorking(CALC_PLAN_ECLIP_LAT_RAD)) * SIN(dPiRAD - dWorking(CALC_PLAN_ECLIP_LONG_RAD))) - (SIN(dnRAD) * SIN(dWorking(CALC_PLAN_ECLIP_LAT_RAD)))
	BDash = COS(dWorking(CALC_PLAN_ECLIP_LAT_RAD)) * COS(dPiRAD - dWorking(CALC_PLAN_ECLIP_LONG_RAD))
	CDash = (COS(dnRAD) * SIN(dWorking(CALC_PLAN_ECLIP_LAT_RAD))) + (SIN(dnRAD) * COS(dWorking(CALC_PLAN_ECLIP_LAT_RAD)) * SIN(dPiRAD - dWorking(CALC_PLAN_ECLIP_LONG_RAD)))
	dWorking(CALC_PLAN_ECLIP_LAT_RAD) = ASIN(CDash)
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = ATAN2(ADash, BDash)
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = -(dWorking(CALC_PLAN_ECLIP_LONG_RAD) - dPiRAD + dpRAD)
	dWorking(CALC_PLAN_ECLIP_LONG_RAD) = FixP1ToZeroToP2_F(dWorking(CALC_PLAN_ECLIP_LONG_RAD), cTWO_PI)
END SUB

SUB CalcPlanRtAscDeclin_S
	' works on the last planet position
	' Apparent Displacement (earths movement and speed of light not factored in here)
	' Assumes CalcLongAndObliqNut done for the specific time
	' Uses 3 Locals
	LOCAL Float DeltaLongAbb, DeltaLatAbb, dPi
	dWorking(CALC_PLANET_X) = dWorking(CALC_PLAN_RAD_VEC_AU) * COS(dWorking(CALC_PLAN_ECLIP_LAT_RAD)) * COS(dWorking(CALC_PLAN_ECLIP_LONG_RAD))
	dWorking(CALC_PLANET_X) = dWorking(CALC_PLANET_X) - dWorking(CALC_EARTH_RAD_VEC_AU) * COS(dWorking(CALC_EARTH_ECLIP_LAT_RAD)) * COS(dWorking(CALC_EARTH_ECLIP_LONG_RAD))
	dWorking(CALC_PLANET_Y) = dWorking(CALC_PLAN_RAD_VEC_AU) * COS(dWorking(CALC_PLAN_ECLIP_LAT_RAD)) * SIN(dWorking(CALC_PLAN_ECLIP_LONG_RAD))
	dWorking(CALC_PLANET_Y) = dWorking(CALC_PLANET_Y) - dWorking(CALC_EARTH_RAD_VEC_AU) * COS(dWorking(CALC_EARTH_ECLIP_LAT_RAD)) * SIN(dWorking(CALC_EARTH_ECLIP_LONG_RAD))
	dWorking(CALC_PLANET_Z) = dWorking(CALC_PLAN_RAD_VEC_AU) * SIN(dWorking(CALC_PLAN_ECLIP_LAT_RAD))
	dWorking(CALC_PLANET_Z) = dWorking(CALC_PLANET_Z) - dWorking(CALC_EARTH_RAD_VEC_AU) * SIN(dWorking(CALC_EARTH_ECLIP_LAT_RAD))
	dWorking(ECLIPTIC_LONG_RAD) = ATAN2(dWorking(CALC_PLANET_Y), dWorking(CALC_PLANET_X))
	If dWorking(ECLIPTIC_LONG_RAD) < 0 Then dWorking(ECLIPTIC_LONG_RAD) = dWorking(ECLIPTIC_LONG_RAD) + cTWO_PI
	' below this is actually Geo Long and lat
	dWorking(ECLIPTIC_LAT_RAD) = ATAN2(dWorking(CALC_PLANET_Z), SQR(dWorking(CALC_PLANET_X) * dWorking(CALC_PLANET_X) + dWorking(CALC_PLANET_Y) * dWorking(CALC_PLANET_Y)))
	dWorking(CALC_PLAN_DISTANCE) = SQR(dWorking(CALC_PLANET_X) * dWorking(CALC_PLANET_X) + dWorking(CALC_PLANET_Y) * dWorking(CALC_PLANET_Y) + 	dWorking(CALC_PLANET_Z) * dWorking(CALC_PLANET_Z))
	dWorking(PLANET_PHASE_ANGLE_I_DEG) = dWorking(CALC_PLAN_RAD_VEC_AU) - dWorking(CALC_EARTH_RAD_VEC_AU) * COS(dWorking(CALC_EARTH_ECLIP_LAT_RAD)) * COS(dWorking(CALC_PLAN_ECLIP_LONG_RAD) - dWorking(CALC_EARTH_ECLIP_LONG_RAD))
	dWorking(PLANET_PHASE_ANGLE_I_DEG) = dWorking(PLANET_PHASE_ANGLE_I_DEG) / dWorking(CALC_PLAN_DISTANCE)
	If dWorking(PLANET_PHASE_ANGLE_I_DEG) > 1 Then
		dWorking(PLANET_PHASE_ANGLE_I_DEG) = 1
	Else 
		If dWorking(PLANET_PHASE_ANGLE_I_DEG) < -1 Then 
			dWorking(PLANET_PHASE_ANGLE_I_DEG) = -1
		End If
	End If
	dWorking(PLANET_PHASE_ANGLE_I_DEG) = DEG(ACOS(dWorking(PLANET_PHASE_ANGLE_I_DEG)))
	dWorking(ECLIPTIC_LONG_RAD) = dWorking(ECLIPTIC_LONG_RAD) + RAD(dWorking(NUTATION_LONG_SECS) / 3600)
	' Adjust  for Abberation
	dE = (0.016708617 - 0.000042037 * dWorking(CALC_T) - 0.0000001236 * dWorking(CALC_2T))
	dPi = RAD(102.93735 + 1.71953 * dWorking(CALC_T) + 0.00046 * dWorking(CALC_2T))
	DeltaLongAbb = -20.49552 * COS(dWorking(CALC_PLAN_ECLIP_LONG_RAD) - dWorking(ECLIPTIC_LONG_RAD)) + dE * 20.49552 * COS(dPi - dWorking(ECLIPTIC_LONG_RAD))
	DeltaLongAbb = DeltaLongAbb / COS(dWorking(CALC_PLAN_ECLIP_LAT_RAD))
	dWorking(ECLIPTIC_LONG_RAD) = dWorking(ECLIPTIC_LONG_RAD) + RAD(DeltaLongAbb / 3600)
	DeltaLatAbb = -20.49552 * SIN(dWorking(CALC_PLAN_ECLIP_LAT_RAD)) * (SIN(dWorking(CALC_PLAN_ECLIP_LONG_RAD) - dWorking(ECLIPTIC_LONG_RAD)) 	- (dE * SIN(dPi - dWorking(ECLIPTIC_LONG_RAD))))
	dWorking(ECLIPTIC_LAT_RAD) = dWorking(ECLIPTIC_LAT_RAD) + RAD(DeltaLatAbb / 3600)
	EclipticToEquatorial_S 'now in TEMP_RT_ASCENSION_RAD & TEMP_DECLIN_RAD
END SUB

SUB EarthPosition_S
	'Ch 31, AA and Appendix II.
	' 	Call before ANY planet positions
	' 	dWorking(CALC_PLAN_T1) is as per equation 31.1
	'  assumes CalcMeanObliqofEclip has been done
	'  Note: Not all of the table data is used
	' Approximate Error based 0n AA Ed 1, pp208 equation
	' Longitude:	Less than 10"
	' Latitude:	Less than 1"
	' Distance:	Less than 3500km
	' Uses 0 Locals
	dWorking(EARTH_JDE_CALCULATED) = dWorking(CALC_JD)
	dT1 = CalcTMillennia_F(dWorking(CALC_JD))
	dT2 = dT1 * dT1
	dL0 = 175347046.0
	dL0 = dL0 + 3341656 * COS(4.6692568 + 6283.075850 * dT1)
	dL0 = dL0 + 34894 * COS(4.62610 + 12566.15170 * dT1)
	dL0 = dL0 + 3497 * COS(2.7441 + 5753.3849 * dT1) ' 29"
	dL0 = dL0 + 3418 * COS(2.8289 + 3.5231 * dT1)
	dL0 = dL0 + 3136 * COS(3.6277 + 77713.7715 * dT1)
	dL0 = dL0 + 2676 * COS(4.4181 + 7860.4194 * dT1)
	dL0 = dL0 + 2343 * COS(6.1352 + 3930.2097 * dT1)
	dL0 = dL0 + 1324 * COS(0.7425 + 11506.7698 * dT1)
	dL0 = dL0 + 1273 * COS(2.0371 + 529.6910 * dT1) ' 10, 16"
	dL0 = dL0 + 1199 * COS(1.1096 + 1577.3435 * dT1)
	dL0 = dL0 + 990 * COS(5.233 + 5884.927 * dT1)
	dL0 = dL0 + 902 * COS(2.045 + 26.298 * dT1)
	dL0 = dL0 + 857 * COS(3.508 + 398.149 * dT1)
	dL0 = dL0 + 780 * COS(1.179 + 5223.694 * dT1)
	dL0 = dL0 + 753 * COS(2.533 + 5507.553 * dT1)
	dL0 = dL0 + 505 * COS(4.583 + 18849.228 * dT1) '17 terms, 9"
	dL1 = 628331966747
	dL1 = dL1 + 206059 * COS(2.678235 + 6283.075850 * dT1)
	dL1 = dL1 + 4303 * COS(2.6351 + 12566.1517 * dT1) '0.7""
	dWorking(CALC_EARTH_ECLIP_LONG_RAD) = dL0 + dL1 * dT1
	dWorking(CALC_EARTH_ECLIP_LONG_RAD) = dWorking(CALC_EARTH_ECLIP_LONG_RAD) / 100000000 ' now radians
	dWorking(CALC_EARTH_ECLIP_LONG_RAD) = FixP1ToZeroToP2_F(dWorking(CALC_EARTH_ECLIP_LONG_RAD), cTWO_PI)
	' now lat
	dB0 = 280 * COS(3.199 + 84334.622 * dT1)
	dB0 = dB0 + 102 * COS(5.422 + 5507.553 * dT1) 'error 0.6"
	dWorking(CALC_EARTH_ECLIP_LAT_RAD) = dB0
	dWorking(CALC_EARTH_ECLIP_LAT_RAD) = dWorking(CALC_EARTH_ECLIP_LAT_RAD) / 100000000 ' now radians
	' now Radius Vector
	dR0 = 100013989
	dR0 = dR0 + 1670700 * COS(3.0984635 + 6283.075850 * dT1)
	dR0 = dR0 + 13956 * COS(3.05525 + 12566.15170 * dT1)
	dR0 = dR0 + 3084 * COS(5.1985 + 77713.7715 * dT1)
	dR0 = dR0 + 1628 * COS(1.1739 + 5753.3849 * dT1)
	dR0 = dR0 + 1576 * COS(2.8469 + 7860.4194 * dT1)
	dR0 = dR0 + 925 * COS(5.453 + 11506.770 * dT1)
	dR0 = dR0 + 542 * COS(4.564 + 3930.210 * dT1)
	dR0 = dR0 + 472 * COS(3.661 + 5884.927 * dT1)
	dR0 = dR0 + 346 * COS(0.964 + 5507.553 * dT1) ' Terms =10, ERROR 3274KM
	dR1 = 103019 * COS(1.107490 + 6283.075850 * dT1)
	dR1 = dR1 + 1721 * COS(1.0644 + 12566.1517 * dT1) ' 170km
	dWorking(CALC_EARTH_RAD_VEC_AU) = dR0 + dR1 * dT1
	dWorking(CALC_EARTH_RAD_VEC_AU) = dWorking(CALC_EARTH_RAD_VEC_AU) / 100000000 ' now AU
END SUB

SUB CreateIterationTable_S(dPeriod As Float, nCelestialBody As Integer)
	' enters with JD & CALC_T set to UTC correct day
	' dPeriod is the offset in JD's, i.e 1.0 = 1 day
	' Uses 3 Locals
	LOCAL Float dUTCEntryHr, dPlanetJD, dJDInitial
	dUTCEntryHr = dWorking(CALC_JD)
	dWorking(CALC_JD) = dWorking(CALC_JD) + dWorking(DELTA_TIME_DAYS) ' now TT
	dJDInitial = dWorking(CALC_JD) ' save for safe keeping
	' *********** do before ********
	dWorking(CALC_JD) = dJDInitial - dPeriod
	'? "JD Before = ", dWorking(CALC_JD)
	dPlanetJD = dWorking(CALC_JD)
	CalcDateFromJD_S dWorking(CALC_JD)
	CalcJD_S DateStruct(I_YEAR), DateStruct(I_MONTH), DateStruct(I_DAY_OF_MONTH), CALC_ALLTD 'UTC times
	CalcLongAndObliqNut_S
	SELECT CASE nCelestialBody
		case SUN
			CalcSolarCoords_S
			dWorking(RTASC_ONE_RAD) = dWorking(SUN_RT_ASCENSION_RAD)
			dWorking(DECLIN_ONE_RAD) = dWorking(SUN_DECLIN_RAD)
		case MOON
			CalcMoonPosition_S CALC_COORDS_ONLY
			dWorking(RTASC_ONE_RAD) = dWorking(MOON_APPARENT_RASC_RAD)
			dWorking(DECLIN_ONE_RAD) = dWorking(MOON_APPARENT_DEC_RAD)
		CASE ELSE ' planet
			CalcPlanetPosition_S nCelestialBody
			dWorking(RTASC_ONE_RAD) = dWorking(TEMP_RT_ASCENSION_RAD)
			dWorking(DECLIN_ONE_RAD) = dWorking(TEMP_DECLIN_RAD)
	END SELECT
	' *********** do After ********
	dWorking(CALC_JD) = dJDInitial + dPeriod
	'? "JD After = ", dWorking(CALC_JD)
	CalcDateFromJD_S dWorking(CALC_JD)
	CalcJD_S DateStruct(I_YEAR), DateStruct(I_MONTH), DateStruct(I_DAY_OF_MONTH), CALC_ALLTD 'UTC times
	CalcLongAndObliqNut_S
	SELECT CASE nCelestialBody
		case SUN
			CalcSolarCoords_S
			dWorking(RTASC_THREE_RAD) = dWorking(SUN_RT_ASCENSION_RAD)
			dWorking(DECLIN_THREE_RAD) = dWorking(SUN_DECLIN_RAD)
		case MOON
			CalcMoonPosition_S CALC_COORDS_ONLY
			dWorking(RTASC_THREE_RAD) = dWorking(MOON_APPARENT_RASC_RAD)
			dWorking(DECLIN_THREE_RAD) = dWorking(MOON_APPARENT_DEC_RAD)
		CASE ELSE ' planet
			CalcPlanetPosition_S nCelestialBody
			dWorking(RTASC_THREE_RAD) = dWorking(TEMP_RT_ASCENSION_RAD)
			dWorking(DECLIN_THREE_RAD) = dWorking(TEMP_DECLIN_RAD)
	END SELECT
	' *********** The Actual Time or Day Required ********
	dWorking(CALC_JD) = dJDInitial
	'? "JD Actual = ", dWorking(CALC_JD)
	CalcAllTD_S dWorking(CALC_JD)
	CalcLongAndObliqNut_S
	SELECT CASE nCelestialBody
		case SUN
			CalcSolarCoords_S
			dWorking(RTASC_TWO_RAD) = dWorking(SUN_RT_ASCENSION_RAD)
			dWorking(DECLIN_TWO_RAD) = dWorking(SUN_DECLIN_RAD)
		case MOON
			CalcMoonPosition_S CALC_COORDS_ONLY
			dWorking(RTASC_TWO_RAD) = dWorking(MOON_APPARENT_RASC_RAD)
			dWorking(DECLIN_TWO_RAD) = dWorking(MOON_APPARENT_DEC_RAD)
		CASE ELSE ' planet
			CalcPlanetPosition_S nCelestialBody
			dWorking(RTASC_TWO_RAD) = dWorking(TEMP_RT_ASCENSION_RAD)
			dWorking(DECLIN_TWO_RAD) = dWorking(TEMP_DECLIN_RAD)
	END SELECT
	dWorking(PLANET_DISTANCE) = dWorking(CALC_PLAN_DISTANCE)
	' exit with CALC_JD as on entry
	dWorking(CALC_JD) = dUTCEntryHr
	' need to ensure we have no wrap around on first and last Rt Asc
	if ABS(dWorking(RTASC_ONE_RAD) - dWorking(RTASC_TWO_RAD)) > PI Then ' start table has wrap around
		dWorking(RTASC_ONE_RAD) = dWorking(RTASC_ONE_RAD) - cTWO_PI
	END IF
	if ABS(dWorking(RTASC_THREE_RAD) - dWorking(RTASC_TWO_RAD)) > PI Then ' end table has wrap around
		dWorking(RTASC_THREE_RAD) = dWorking(RTASC_THREE_RAD) + cTWO_PI
	END IF
	'? "JD = ", dWorking(CALC_JD)
	'? DEG(dWorking(RTASC_ONE_RAD))
	'? DEG(dWorking(RTASC_TWO_RAD))
	'? DEG(dWorking(RTASC_THREE_RAD))
	'? DEG(dWorking(DECLIN_ONE_RAD))
	'? DEG(dWorking(DECLIN_TWO_RAD))
	'? DEG(dWorking(DECLIN_THREE_RAD))
	'? DEG(dWorking(DECLIN_TWO_RAD))
END SUB

FUNCTION YearlyTask_F(InString As String) AS String
	' called once per year that is being calculated
	' Sets up TIME_ZONE and calculates DELTA_TIME_DAYS
	' Input string is "Cmnd,DD-MM-YYYY"
	'If Ok then Error char is "0" else ERROR_YEARLY_TASK_ONE
	' Uses 0 Locals
	dWorking(EARTH_JDE_CALCULATED) = 0
	ExtractMMBasicDate_S InString
	If DateStruct(I_YEAR) < 1901 OR DateStruct(I_YEAR) > 2100 Then
		YearlyTask_F = ERROR_YEARLY_TASK_ONE
	Else
		CalculateDSTStart_S DateStruct(I_YEAR)
		CalculateDSTEnd_S DateStruct(I_YEAR)
		CalcDeltaTime_S DateStruct(I_YEAR)' do here for this year
		YearlyTask_F = NO_ERROR
		dWorking(INITIALISED_STEP) = DAILY_TASKS_ONE_COMPLETED
	End If
END FUNCTION

FUNCTION SunMoonTRS_F(InString As String) As String
	' In String = "Cmd,DD-MM-YYYY" 'local
	' Normally called any time past any Daylight Saving Change
	' calculates SUN & Moon Transit,Rise and set and places in sRetString 
	' Uses 0 Locals
	ExtractMMBasicDate_S InString
	dWorking(LOCAL_YEAR) = DateStruct(I_YEAR) ' these are the local times
	dWorking(LOCAL_MONTH) = DateStruct(I_MONTH)
	dWorking(LOCAL_DATE) = DateStruct(I_DAY_OF_MONTH)
	dWorking(DATE_CHECK_D) = DateStruct(I_DAY_OF_MONTH)
	'? "Date = ", dWorking(LOCAL_DATE), dWorking(LOCAL_MONTH), dWorking(LOCAL_YEAR) '###################################################
	TempString = "0," ' set to no error 
	'dWorking(RISE_SET_CIRCUMPOLAR) = 0.0;
	TempString = SUN_Rise_Set_Transit_F(TempString)
	SunMoonTRS_F = MOON_Rise_Set_Transit_F(TempString)
END FUNCTION

FUNCTION Initialise_F(InString As String) AS String
	' Returns 0 if good else error number
	' must be done before any calls
	' Input string is comma delimited as,
	' Lat,Long,Time Zone Hr,DST Time Zone Hr, DST Start Month, DST Start Week, DST Start Day, DST Start Hour, DST End Month, DST End Week, DST End Day, DST End Hour
	' South Lat is neg, West Long is neg, DST Day is 0 for Sunday, 1 for Monday etc. DST week starts from 1 (i.e first Sunday is week 1), Start and end hour 
	' are local hours.
	' Example for Adelaide with Time zone of 9.5, DST starts at 2am first  Sunday in October and ends 3am first Sunday in April
	' "-34.76639,138.5367,9.5,10.5,10,1,0,2,4,1,0,3"
	' Note if DST Time Zone is zero (or same as Time Zone then assume DST is not used at the location so all DST intialisation values are ignored
	' This means that if DST is not used then just the values up to DST Time Zone need to be included in string
	' Uses 0 Locals
	dWorking(SITE_LATITUDE_DEG) = VAL(FIELD$( InString,LAT_FIELD, ","))
	If ABS(dWorking(SITE_LATITUDE_DEG)) > 180 Then
		Initialise_F = ERROR_LAT_FIELD
		EXIT FUNCTION
	End If
	dWorking(SITE_LONGTITUDE_DEG) = VAL(FIELD$( InString,LONG_FIELD, ","))
	If ABS(dWorking(SITE_LONGTITUDE_DEG)) > 180 Then
		Initialise_F = ERROR_LONG_FIELD
		EXIT FUNCTION
	End If
	dWorking(TIME_ZONE) = VAL(FIELD$( InString,TIME_ZONE_FIELD, ","))
	If ABS(dWorking(TIME_ZONE)) > 12 Then
		Initialise_F =  ERROR_TIME_ZONE_FIELD
		EXIT FUNCTION
	End If	
	dWorking(DST_TIME_ZONE) = VAL(FIELD$( InString,DST_TIME_ZONE_FIELD, ","))
	If dWorking(DST_TIME_ZONE) = dWorking(TIME_ZONE) OR dWorking(DST_TIME_ZONE) = 0 Then 'No DST at Location
		dWorking(DST_TIME_ZONE) = dWorking(TIME_ZONE)
		Initialise_F =  NO_ERROR
		EXIT FUNCTION ' dont need to do any more as no DST
	End If	
	If ABS(dWorking(DST_TIME_ZONE)) > 13 Then
		Initialise_F =  ERROR_DST_TIME_ZONE_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_START_MONTH) = VAL(FIELD$( InString,DST_START_MONTH_FIELD, ","))
	If dWorking(DST_START_MONTH) < 1 OR dWorking(DST_START_MONTH) > 12 Then
		Initialise_F =  ERROR_DST_START_MONTH_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_START_WEEK) = VAL(FIELD$( InString,DST_START_WEEK_FIELD, ","))
	If dWorking(DST_START_WEEK) < 1 OR dWorking(DST_START_WEEK) > 5 Then
		Initialise_F =  ERROR_DST_START_WEEK_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_START_DAY) = VAL(FIELD$( InString,DST_START_DAY_FIELD, ","))
	If dWorking(DST_START_DAY) < 0 OR dWorking(DST_START_DAY) > 6 Then
		Initialise_F =  ERROR_DST_START_DAY_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_START_HOUR) = VAL(FIELD$( InString,DST_START_HOUR_FIELD, ","))
	If dWorking(DST_START_HOUR) < 0 OR dWorking(DST_START_HOUR) > 6 Then
		Initialise_F =  ERROR_DST_START_HOUR_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_END_MONTH) = VAL(FIELD$( InString,DST_END_MONTH_FIELD, ","))
	If dWorking(DST_END_MONTH) < 1 OR dWorking(DST_END_MONTH) > 12 Then
		Initialise_F =  ERROR_DST_END_MONTH_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_END_WEEK) = VAL(FIELD$( InString,DST_END_WEEK_FIELD, ","))
	If dWorking(DST_END_WEEK) < 1 OR dWorking(DST_END_WEEK) > 5 Then
		Initialise_F =  ERROR_DST_END_WEEK_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_END_DAY) = VAL(FIELD$( InString,DST_END_DAY_FIELD, ","))
	If dWorking(DST_END_DAY) < 0 OR dWorking(DST_END_DAY) > 6 Then
		Initialise_F =  ERROR_DST_END_DAY_FIELD
		EXIT FUNCTION
	End If
	dWorking(DST_END_HOUR) = VAL(FIELD$( InString,DST_END_HOUR_FIELD, ","))
	If dWorking(DST_END_HOUR) < 0 OR dWorking(DST_END_HOUR) > 6 Then
		Initialise_F =  ERROR_DST_END_HOUR_FIELD
		EXIT FUNCTION
	End If
	dWorking(INITIALISED_STEP) = INITIALISED_COMPLETED ' all OK
	Initialise_F =  NO_ERROR ' all good to get here
	'? "Lat = ", dWorking(SITE_LATITUDE_DEG) '##############################################################3
	'? "Long = ", dWorking(SITE_LONGTITUDE_DEG)
	'? "Time Zone = ", dWorking(TIME_ZONE)
	'? " DST Time Zone = ", dWorking(DST_TIME_ZONE)
END FUNCTION

SUB ExtractDateTime_S(InString As String, StoreUTC As Integer) 
	'In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 
	'  will store in LOCAL or UTC depending on StoreTo value of UTC_TIME (true) or LOCAL_TIME (false)
	' Uses 0 Locals
	ExtractMMBasicDate_S InString
	If StoreUTC = UTC_TIME Then
		dWorking(UTC_YEAR) = DateStruct(I_YEAR)
		dWorking(UTC_MONTH) = DateStruct(I_MONTH)
		dWorking(UTC_DATE) = DateStruct(I_DAY_OF_MONTH)
	Else
		dWorking(LOCAL_YEAR) = DateStruct(I_YEAR) ' these are the local times
		dWorking(LOCAL_MONTH) = DateStruct(I_MONTH)
		dWorking(LOCAL_DATE) = DateStruct(I_DAY_OF_MONTH)
	End If
	ExtractMMBasicTime_S InString
	If StoreUTC = UTC_TIME Then
		dWorking(UTC_HOUR) = TimeStruct(I_HOUR)
		dWorking(UTC_MIN) = TimeStruct(I_MIN)
		dWorking(UTC_SEC) = TimeStruct(I_SEC)
	Else
		dWorking(LOCAL_HOUR) = TimeStruct(I_HOUR)
		dWorking(LOCAL_MIN) = TimeStruct(I_MIN)
		dWorking(LOCAL_SEC) = TimeStruct(I_SEC)
	End If
END SUB

FUNCTION ToUTC_F(InString As String) As String
	'In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 
	' Local to UTC, factors in DST, Returna as "0,DD-MM-YYYY,HH:MM:SS"
	' Uses 0 Locals
	ExtractDateTime_S InString, LOCAL_TIME 'stored local 
	ConvertLocalToUTC_S INCLUDE_TIME, INCLUDE_SECONDS
	' now create return string with date and time
	ToUTC_F = "0," + FORMAT$(dWorking(UTC_DATE),"%2g-")+FORMAT$(dWorking(UTC_MONTH),"%2g-")+FORMAT$(dWorking(UTC_YEAR),"%4g,")
	ToUTC_F = ToLocal_F+FORMAT$(dWorking(UTC_HOUR),"%2g:")+FORMAT$(dWorking(UTC_MIN),"%2g:")+FORMAT$(dWorking(UTC_SEC),"%2g")
END FUNCTION

FUNCTION ToLocal_F(InString As String) As String
	'In String = "Cmd,DD-MM-YYYY,HH:MM:SS" is in UTC
	' UTC to Local, factors in DST, Returna as "0,DD-MM-YYYY,HH:MM:SS"
	' Uses 0 Locals
	ExtractDateTime_S InString, UTC_TIME ' //stored UTC
	ConvertUTCToLocal_S INCLUDE_SECONDS
	' now create return string with date and time
	ToLocal_F = "0," + FORMAT$(dWorking(LOCAL_DATE),"%2g-")+FORMAT$(dWorking(LOCAL_MONTH),"%2g-")+FORMAT$(dWorking(LOCAL_YEAR),"%4g,")
	ToLocal_F = ToLocal_F+FORMAT$(dWorking(LOCAL_HOUR),"%2g:")+FORMAT$(dWorking(LOCAL_MIN),"%2g:")+FORMAT$(dWorking(LOCAL_SEC),"%2g")
END FUNCTION

FUNCTION MoonPhases_F(InString As String) As String
	'In String = "Cmd,DD-MM-YYYY" 
	' Uses 1 Local
	LOCAL String OutString 
	ExtractMMBasicDate_S InString
	dWorking(UTC_YEAR) = DateStruct(I_YEAR) ' this is the local date but place in UTC locations as that is what GetMonthMoonPhaseStrings expects
	dWorking(UTC_MONTH) = DateStruct(I_MONTH)
	dWorking(UTC_DATE) = 1
	OutString = "0," 'set error
	MoonPhases_F = GetMonthMoonPhaseStrings_F(OutString)
END FUNCTION

FUNCTION Seasons_F(InString As String) As String
	'In String = "Cmd,DD-MM-YYYY" just needs year
	' Uses 1 Local
	LOCAL String OutString 
	dWorking(UTC_YEAR) =  DateStruct(I_YEAR) ' these are the local times but place in UTC locations as that is what CalculateEquinoxSolstices expects
	OutString = "0," 'set error
	Seasons_F = CalculateEquinoxSolstices_F(OutString)
END FUNCTION

FUNCTION ObjectInstPosition_F(InString As String, nObject As Integer) As String
	'In String = "Cmd,DD-MM-YYYY,HH:MM:SS" ,input time is Local
	' Uses 7 Local
	LOCAL String OutString 
	LOCAL Float dHorizParallaxRAD,dTempJD_UTC,dHrAngleRAD,dTanU,dPsin,dPcos
	ExtractDateTime_S InString, LOCAL_TIME 'store in LOCAL
	ConvertLocalToUTC_S INCLUDE_TIME, INCLUDE_SECONDS
	dWorking(UTC_DATE) = dWorking(UTC_DATE) + dWorking(UTC_HOUR) / 24 + dWorking(UTC_MIN) / cMINS_PER_DAY + dWorking(UTC_SEC) / cSEC_PER_DAY
	CalcJD_S dWorking(UTC_YEAR), dWorking(UTC_MONTH), dWorking(UTC_DATE), SKIP_CALC_ALLTD 'UTC times
	dTempJD_UTC = dWorking(CALC_JD)
	CalcLongAndObliqNut_S
	dWorking(CALC_JD) = dWorking(CALC_JD) + dWorking(DELTA_TIME_DAYS)' now TT
	CalcAllTD_S dWorking(CALC_JD)
	SELECT CASE nObject
	case SUN
		CalcSolarCoords_S 
		dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(SUN_RT_ASCENSION_RAD)
		dWorking(TEMP_DECLIN_RAD) = dWorking(SUN_DECLIN_RAD)
		dWorking(STRING_OBJECT_DISTANCE) = dWorking(SUN_DISTANCE_MKM)
		dHorizParallaxRAD = RAD((8.794 / (dWorking(SUN_DISTANCE_MKM)/cAU_MILLKM)) / 3600)
	case MOON
		CalcMoonPosition_S CALC_ALL_CALCULATIONS
		dWorking(TEMP_RT_ASCENSION_RAD) = dWorking(MOON_APPARENT_RASC_RAD)
		dWorking(TEMP_DECLIN_RAD) = dWorking(MOON_APPARENT_DEC_RAD)
		dWorking(STRING_OBJECT_DISTANCE) = dWorking(MOON_DISTANCE_KM)
		dHorizParallaxRAD = ASIN(6378.14 / dWorking(MOON_DISTANCE_KM))
	Case Else
		CalcPlanetPosition_S nObject
		dWorking(STRING_OBJECT_DISTANCE) = dWorking(CALC_PLAN_DISTANCE) * AU_TO_MILLION_KM
		dHorizParallaxRAD = RAD((8.794 / dWorking(CALC_PLAN_DISTANCE)) / 3600) ' in degrees
	END SELECT
	' reset CALC_JD back to UTC
	dWorking(CALC_JD) = dTempJD_UTC
	CalcAllTD_S dWorking(CALC_JD)
	SideRealGreenWitch_S 
	' factor in parallax , refer AA Ch39, using 39.6, 39.7
	' Assumes Height is zero 
	dHrAngleRAD = Within0To2PI_F(RAD(dWorking(APPARENT_G_SIDEREAL_TIME_DEG) - (-dWorking(SITE_LONGTITUDE_DEG))) - dWorking(TEMP_RT_ASCENSION_RAD))
	dA = COS(dWorking(TEMP_DECLIN_RAD)) * SIN(dHrAngleRAD)
	dTanU = ATN(0.99664719 * TAN(RAD(dWorking(SITE_LATITUDE_DEG))))
	dPsin = 0.99664719 * SIN(dTanU) ' Height is zero
	dPcos = COS(dTanU)
	dB = COS(dWorking(TEMP_DECLIN_RAD)) * COS(dHrAngleRAD) - dPcos * SIN(dHorizParallaxRAD)
	dC = SIN(dWorking(TEMP_DECLIN_RAD)) - dPsin * SIN(dHorizParallaxRAD)
	dWorking(TEMP_DECLIN_RAD) = ASIN(dC / SQR(dA * dA + dB * dB + dC * dC))
	dHrAngleRAD = ATAN2(dA, dB)
	dWorking(TEMP_RT_ASCENSION_RAD) = Within0To2PI_F(RAD(dWorking(APPARENT_G_SIDEREAL_TIME_DEG) - (-dWorking(SITE_LONGTITUDE_DEG))) - dHrAngleRAD)
	EquatorialToHorizontal_S 
	OutString = "0,"
	dWorking(TEMP_HORIZ_AZ_RAD) = DEG(dWorking(TEMP_HORIZ_AZ_RAD)) + 0.05 ' round
	OutString = OutString + FORMAT$(dWorking(TEMP_HORIZ_AZ_RAD),"%3.2f,") 
	dWorking(TEMP_HORIZ_ALTITUDE_RAD) = DEG(dWorking(TEMP_HORIZ_ALTITUDE_RAD)) + 0.05 ' round and to degrees 
	OutString = OutString + FORMAT$(dWorking(TEMP_HORIZ_ALTITUDE_RAD),"%3.2f,") 
	'if nObject = MOON Then
		OutString = OutString + FORMAT$(dWorking(STRING_OBJECT_DISTANCE),"%4.3f,") 
	'else
	'	OutString = OutString + FORMAT$(dWorking(STRING_OBJECT_DISTANCE),"%4.3f,") 'above is the same so why If??
	'End If
	dWorking(TEMP_RT_ASCENSION_RAD) = DEG(dWorking(TEMP_RT_ASCENSION_RAD)) / 15.0 ' in hours
	OutString = OutString + FORMAT$(dWorking(TEMP_RT_ASCENSION_RAD),"%3.2f,") 
	OutString = OutString + FORMAT$(DEG(dWorking(TEMP_DECLIN_RAD)),"%3.2f,") 'in degrees
	' now add Long and Lat
	SELECT CASE nObject
		CASE MOON
			OutString = OutString + FORMAT$(dWorking(MOON_ILLUM_FRACTION),"%1.3f,") 
			OutString = OutString + FORMAT$(dWorking(MOON_POSITION_ANGLE_DEG),"%3.2f,") 
			OutString = OutString + FORMAT$(dWorking(MOON_APPARENT_LONG_RAD),"%3.2f,") 'apparent geocentic long 
			OutString = OutString + FORMAT$(dWorking(MOON_GEO_LAT_DEG),"%3.2f") 'geocentic lat
		CASE Else ' planets
			OutString = OutString + FORMAT$(PlanetMagnitude_F(nObject),"%1.1f,") 
			OutString = OutString + FORMAT$(PlanetSizeSecs_F(nObject),"%2.1f,") 
			CorrectForPrecession_S
			OutString = OutString + FORMAT$(DEG(dWorking(CALC_PLAN_ECLIP_LONG_RAD)),"%3.2f,") 'heliocentic long 
			OutString = OutString + FORMAT$(DEG(dWorking(CALC_PLAN_ECLIP_LAT_RAD)),"%3.2f,") 'heliocentic lat
			' now add earth lat and long by placing in CALC_PLAN_ECLIP_LAT_RAD etc before correcting for precession
			dWorking(CALC_PLAN_ECLIP_LAT_RAD) = dWorking(CALC_EARTH_ECLIP_LAT_RAD)
			dWorking(CALC_PLAN_ECLIP_LONG_RAD) = dWorking(CALC_EARTH_ECLIP_LONG_RAD)
			CorrectForPrecession_S
			OutString = OutString + FORMAT$(DEG(dWorking(CALC_PLAN_ECLIP_LONG_RAD)),"%3.2f,") 'heliocentic long 
			' Note Latitude of earth is close to zero so can be ignored in the resolution of this program, user should just use zero
			'now add planet and earth distance from sun in AU
			OutString = OutString + FORMAT$(dWorking(CALC_PLAN_RAD_VEC_AU),"%2.6f,") 
			OutString = OutString + FORMAT$(dWorking(CALC_EARTH_RAD_VEC_AU),"%2.6f") 
	END SELECT
	ObjectInstPosition_F = OutString
END FUNCTION

FUNCTION ManageCommand_F(InString As String) As String
	' Main Interface to te Asto Routines
	' Refer to the Astronomical Routines PDF for details on command string and returned data string
	' All comma delimited InString start with command Number, additional fields depend on the command type
	' Except for initialise command the InString is Command Number,DD-MM-YYYY[,HH:MM:SS] where data in [] depends on command type
	' see below for InString
	' Uses 3 Locals
	LOCAL Integer nCmnd
	LOCAL String OutString 
	LOCAL Float dCalcJD
	' extract command
	nCmnd = VAL(FIELD$( InString,COMMAND_FIELD, ","))
	'? "COMMAND = ", nCmnd '#################################################3
	If nCmnd < 0 OR nCmnd > COMMAND_HIGHEST_NUMBER Then
		ManageCommand_F = ERROR_COMMAND_NOT_KNOWN
		EXIT FUNCTION ' can do no more
	End If
	SELECT CASE nCmnd
	case COMMAND_INITIALISE
		' InString = "Cmd,Lat,Long,Time Zone Hr,DST Time Zone Hr, DST Start Month, DST Start Week, DST Start Day, DST Start Hour, DST End Month, DST End Week, DST End Day, DST End Hour"
		dWorking(INITIALISED_STEP) = INITIALISED_FAILED ' set to error prior to call as routine will set to OK if all OK
		ManageCommand_F = Initialise_F(InString)
	case COMMAND_YEARLY_TASK
		' In String = "Cmd,DD-MM-YYYY, All Local,  Year to calc Delta Time and DST change over date & times
		If dWorking(INITIALISED_STEP) >= INITIALISED_COMPLETED Then
			ManageCommand_F = YearlyTask_F(InString)
		else
			ManageCommand_F = ERROR_INITIALISE_NOT_COMPLETED 'faulty init
		End If
	case COMMAND_SUN_MOON_TRS ' In String = "Cmd,DD-MM-YYYY" local date
		If dWorking(INITIALISED_STEP) >= DAILY_TASKS_ONE_COMPLETED Then
			ManageCommand_F = SunMoonTRS_F(InString)
		Else
			ManageCommand_F =  ERROR_YEARLY_TASK_ONE ' at least YearlyTask to be done
		End If
	case COMMAND_TO_UTC
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" local to UTC
		ManageCommand_F = ToUTC_F(InString)
	case COMMAND_FROM_UTC
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" UTC to local
		ManageCommand_F = ToLocal_F(InString)
	case COMMAND_MOON_PHASES
		' In String = "Cmd,DD-MM-YYYY" 'local date
		ManageCommand_F = MoonPhases_F(InString)
	case COMMAND_SEASONS
		' In String = "Cmd,DD-MM-YYYY" 'local date, only need year
		ManageCommand_F = Seasons_F(InString)
	case COMMAND_INSTANT_SUN
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 'local
		ManageCommand_F = ObjectInstPosition_F(InString, SUN)
	case COMMAND_INSTANT_MOON
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 'local
		ManageCommand_F = ObjectInstPosition_F(InString, MOON)
	case COMMAND_INSTANT_MERCURY
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 'local
		ManageCommand_F = ObjectInstPosition_F(InString, MERCURY)
	case COMMAND_INSTANT_VENUS
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 'local
		ManageCommand_F = ObjectInstPosition_F(InString, VENUS)
	case COMMAND_INSTANT_MARS
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 'local
		ManageCommand_F = ObjectInstPosition_F(InString, MARS)
	case COMMAND_INSTANT_JUPITER
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 'local
		ManageCommand_F = ObjectInstPosition_F(InString, JUPITER)
	case COMMAND_INSTANT_SATURN
		' In String = "Cmd,DD-MM-YYYY,HH:MM:SS" 'local
		ManageCommand_F = ObjectInstPosition_F(InString, SATURN)
	case COMMAND_PLANET_TRS
		' In String = "Cmd,DD-MM-YYYY
		ExtractMMBasicDate_S InString
		dWorking(LOCAL_YEAR) = DateStruct(I_YEAR) ' this is the local date 
		dWorking(LOCAL_MONTH) = DateStruct(I_MONTH)
		dWorking(LOCAL_DATE) = DateStruct(I_DAY_OF_MONTH)
		dWorking(DATE_CHECK_D) = DateStruct(I_DAY_OF_MONTH)
		CalcJD_S DateStruct(I_YEAR), DateStruct(I_MONTH), FIX(DateStruct(I_DAY_OF_MONTH)), CALC_ALLTD ' this will be at 00hr on correct date
		dCalcJD = dWorking(CALC_JD) ' safe keeping
		OutString = "0," 'set error
		OutString = PlanetTRS_F(OutString, MERCURY)
		dWorking(CALC_JD) = dCalcJD
		OutString = PlanetTRS_F(OutString, VENUS) 
		dWorking(CALC_JD) = dCalcJD
		OutString = PlanetTRS_F(OutString, MARS)
		dWorking(CALC_JD) = dCalcJD
		OutString = PlanetTRS_F(OutString, JUPITER)
		dWorking(CALC_JD) = dCalcJD
		OutString = PlanetTRS_F(OutString, SATURN)
		ManageCommand_F = OutString
	END SELECT
END FUNCTION
