Dim AlarmTimeArray$(20), AlarmDurationArray$(20), HolidayArray$(20)
SetPin 1, 8
SetPin 2, 8
Font Load "DIG.fnt" As #4

Main:
WatchDog OFF
' Get Weekday name
WeekDayName$=GetWeekDayName$(Date$)
' Get siren times for day
Open WeekDayName$ + ".dat" For input As #1
  For i=1 To 20
    Input #1, AlarmTimeArray$(i)
    Input #1, AlarmDurationArray$(i)
  Next
Close #1
Open "Holidays.dat" For input As #1
  For i=1 To 20
    Input #1, HolidayArray$(i)
  Next
Close #1
' Is it a holiday?
HolidayToday=0
For i=1 To 20
  If HolidayArray$(i)=Date$ Then HolidayToday=1
Next
Open "Offset.cfg" For input As #1
  Input #1, Temp$
Close #1
TimeOffset=Val(temp$)
Cls
Mode 3
WeekDayName$=GetWeekDayName$(Date$)
Font #2,4
Colour Green
Print @(20,350) WeekDayName$;" ";Left$(Date$,5)
Font #4,4
Colour White
ExitReason=0
Print @(30,150) Left$(Time$,2); @(280,150) Mid$(Time$,4,2)

Do While ExitReason=0
  T$=Time$
  If T$="00:00:10" Then ExitReason=1
  If T$="00:00:15" Then ExitReason=2
  For i=1 To 20
    If AlarmTimeArray$(i)=T$ Then
      AlarmDuration=Val(AlarmDurationArray$(i))
      ExitReason=3
    EndIf
  Next
  If Inkey$<>"" Then ExitReason=4
  S$=Right$(T$,2)
  Font #1
  Print @(0,0) T$
  Font #4,4
  If S$="00" Then Print @(30,150) Left$(T$,2); @(280,150) Mid$(T$,4,2)
  If Val(S$) Mod 2 =0 Then
    Line (240,170)-(260,190),White,BF
    Line (240,240)-(260,260),White,BF
  Else
    Line (240,170)-(260,260),Black,BF
  EndIf
  Pause 200
Loop

WatchDog 5000

If ExitReason=1 Then
  ' Do midnight stuff
  Pause 1000
  GoTo Main
EndIf

If ExitReason=2 Then
  ' Make adjustment to time, done at 00:00:15
  If TimeOffset<0 Then
    Pause 0-TimeOffset
    Time$="00:00:15"
  EndIf
  If TimeOffset>0 Then
    Pause 1000-TimeOffset
    Time$="00:00:16"
  EndIf
  Pause 1000 'delay so we dont repeat
EndIf

WatchDog 10000

If ExitReason=3 Then
  If HolidayToday=0 Then
    Colour Red
    Font #2,7
    Print @(20,0) "((O))"
    Pin(1)=1 ' Turn on button
    Pause 500
    Pin(1)=0  ' Turn off button
    Pause (AlarmDuration-.5)*1000
    Pin(2)=1 'Turn on Off button
    Pause 500
    Pin(2)=0 ' Turn off Off button
  EndIf
EndIf

WatchDog 20000

If ExitReason=4 Then
  Menu:
  Cls
  Font #2,2
  Colour Yellow
  Print "Setup Menu"
  Colour White
  Font #1,1
  Print @(0,40) "1. Time"
  Print "2. Date"
  Print "3. Public Holidays. Siren wont sound on public holidays."
  Print "4. Siren Times."
  Print "5. Time Offset. Fine adjustment to the clock accuracy."
  Print "6. Test Siren, will sound for 3 seconds."
  Print "Q. Exit Menu"
  Print @(0,155)"What do you want to do ";
  Input "( 1 - 6 or Q )"; k$

  WatchDog 300000

  If k$="Q" Or k$="q" Then GoTo Main

  If k$="1" Then
    Cls
    Font #2,2
    Colour Yellow
    Print "Set Time"
    Font #1
    Colour White
    Print @(0,100) "Please enter the current time using HH:MM:SS format."
    Print @(1,120) "24 Hour time. Just press ENTER to leave as is."
    Do
      Print @(0,150) "Time =        " @(40,150);
      Input NewTime$
      If CheckTime(NewTime$)=1 Or NewTime$="" Then Exit
      Print "Bad time format! Please try again."
    Loop
    If NewTime$<>"" Then Time$=NewTime$
  EndIf

  If k$="2" Then
    Cls
    Font #2,2
    Colour Yellow
    Print "Set Date"
    Colour White
    Font #1,1
    Print @(0,100) "Please enter the current date using DD-MM-YYYY format"
    Print @(1,120) "eg, 25-03-2015 for 25th March 2015."
    Print @(0,140) "Just press ENTER to leave as is."
    Do
      Print @(0,170) "Date =            " @(40,170);
      Input NewDate$
      If CheckDate(NewDate$)=1 Or NewDate$="" Then Exit
      Print "Bad date format! Please try again."
    Loop
    If NewDate$<>"" Then Date$=NewDate$
  EndIf

  If k$="3" Then
    HolidayMenu:
    Open "Holidays.dat" For input As #1
      For i=1 To 20
        Input #1, HolidayArray$(i)
      Next
    Close #1
    SetHolidaySubMenu1:
    Cls
    Font #2,2
    Colour Yellow
    Print "Set Holidays"
    Colour White
    Font #1,1
    Colour Cyan
    Print @(0,70)"     Date                      Date"
    Colour White
    For i=1 To 10
      Print @(0,i*15+70) i;". ";HolidayArray$(i);"          "
      Print @(150,i*15+70) i+10;". ";HolidayArray$(i+10);"          "
    Next
    Print
    Input "Which record to change ( 1 - 20 or Q to Quit )"; R$
    If R$="q" Or R$="Q" Then GoTo Menu
    If Val(R$)<1 Or Val(R$)>20 Then GoTo SetHolidaySubMenu1
    Do
      Print @(0,270) "Enter holiday date using DD-MM-YYYY, or 0 to delete,"
      Print @(0,290) "or ENTER to leave as is :          "; @(150,290);
      Input NewHoliday$
      If CheckDate(NewHoliday$)=1 Or NewHoliday$="" Or NewHoliday$="0" Then Exit
      Print "Bad date format! Please try again."
    Loop
    If NewHoliday$<>"" Then HolidayArray$(Val(R$))=NewHoliday$
    If NewHoliday$="0" Then HolidayArray$(Val(R$))=""
    Print "Saving"
    Open "Holidays.dat" For output As #1
      For i=1 To 20
        Print #1, HolidayArray$(i)
      Next
    Close #1
    Pause 500
    GoTo HolidayMenu
  EndIf

  If k$="4" Then
    SetAlarmSubMenu1:
    Cls
    Font #2,2
    Colour Yellow
    Print "Set Siren Times"
    Colour White
    Font #1,1
    Print @(0,50) "Choose a week day to change. Q to Quit."
    Print @(0,70) "1. Sunday"
    Print "2. Monday"
    Print "3. Tuesday"
    Print "4. Wednesday"
    Print "5. Thursday"
    Print "6. Friday"
    Print "7. Saturday"
    Input "( 1 - 7 or Q )"; W$
    If W$="q" Or W$="Q" Or W$="" Then GoTo Menu
    If Val(W$)<1 Or Val(W$)>7 Then GoTo SetAlarmSubMenu1
    If W$="1" Then W$="Sun"
    If W$="2" Then W$="Mon"
    If W$="3" Then W$="Tue"
    If W$="4" Then W$="Wed"
    If W$="5" Then W$="Thu"
    If W$="6" Then W$="Fri"
    If W$="7" Then W$="Sat"
    Open W$ + ".dat" For input As #1
      For i=1 To 20
        Input #1, AlarmTimeArray$(i)
        Input #1, AlarmDurationArray$(i)
      Next
    Close #1
    SetAlarmSubMenu2:
    Cls
    Font #2,2
    Colour Yellow
    Print "Set Siren Times"
    Colour White
    Font #1,1
    Colour Cyan
    Print @(0,50)"   Time      Duration        Time     Duration"
    Colour White
    For i=1 To 10
      Print @(0,i*15+70) i;". ";AlarmTimeArray$(i);"  ";AlarmDurationArray$(i)
      Print @(150,i*15+70) i+10;". ";AlarmTimeArray$(i+10);"  ";AlarmDurationArray$(i+10)
    Next
    Print
    Input "Which record to change ( 1 - 20 or Q )"; R$
    If R$="q" Or R$="Q" Then GoTo SetAlarmSubMenu1
    If Val(R$)<1 Or Val(R$)>20 Then GoTo SetAlarmSubMenu2
    Do
      Print @(0,270) "New Time using HH:MM:SS, or 0 to delete, "
      Print @(0,290) "or ENTER to leave as is :          "; @(150,290);
      Input NewTime$
      If CheckTime(NewTime$)=1 Or NewTime$="" Or NewTime$="0" Then Exit
      Print "Bad time format! Please try again."
    Loop
    If NewTime$<>"" Then AlarmTimeArray$(Val(R$))=NewTime$
    If NewTime$="0" Then
      AlarmTimeArray$(Val(R$))=""
      AlarmDurationArray$(Val(R$))=""
    Else
      Do
        Print @(0,310) "Siren duration in Seconds ( 1 - 5 ) :         "; @(220,310);
        Input NewDuration$
        If Val(NewDuration$)>0 Or Val(NewDuration$)<6 Then Exit
        Print "Need a value in range 1 to 5"
      Loop
      AlarmDurationArray$(Val(R$))=NewDuration$
    EndIf
    Print "Saving"
    Open W$+".dat" For output As #1
      For i=1 To 20
        Print #1, AlarmTimeArray$(i)
        Print #1, AlarmDurationArray$(i)
      Next
    Close #1
    Pause 500
    GoTo SetAlarmSubMenu2
  EndIf
  If k$="5" Then
    Cls
    Print "Just after midnite each day the clock will be adjusted by "; TimeOffset
    Print "milliseconds. Change this value if the clock is a little fast or slow."
    Print "To leave the offset as is, just hit ENTER."
    Print "Can only accept values from -999 to 999."
    Input "New offset is ";X$
    If X$<>"" Then
      TimeOffset=Val(X$)
      If TimeOffset<-999 Then TimeOffset=-999
      If TimeOffset>999 Then TimeOffset=999
      Open "Offset.cfg" For output As #1
        Print #1, TimeOffset
      Close #1
    EndIf
  EndIf
  If k$="6" Then
    Pin(1)=1 ' Turn on button
    Pause 500
    Pin(1)=0  ' Turn off button
    Pause 2500
    Pin(2)=1 'Turn on Off button
    Pause 500
    Pin(2)=0 ' Turn off Off button
  EndIf

  GoTo Menu

EndIf

GoTo Main

Function GetWeekDayName$(X$)
  DOW_Day=Val(Left$(X$,2))
  DOW_Month=Val(Mid$(X$,4,2))
  DOW_Year=Val(Right$(X$,4))
  a=(14-DOW_Month)/12
  a=Fix(a)
  y=DOW_Year-a
  y=Fix(y)
  m=DOW_Month+(12*a)-2
  m=Fix(m)
  d=((DOW_Day+y)+Fix(y/4)-Fix(y/100)+Fix(y/400)+Fix((31*m)/12))
  DOW=d Mod 7
  DOW=DOW+1
  If DOW=1 Then GetWeekDayName$="Sun"
  If DOW=2 Then GetWeekDayName$="Mon"
  If DOW=3 Then GetWeekDayName$="Tue"
  If DOW=4 Then GetWeekDayName$="Wed"
  If DOW=5 Then GetWeekDayName$="Thu"
  If DOW=6 Then GetWeekDayName$="Fri"
  If DOW=7 Then GetWeekDayName$="Sat"
End Function

Function CheckTime(X$)
  CheckTime=1
  If Len(X$)=8 Then
    If Val(Left$(X$,2))<0 Or Val(Left$(X$,2))>23 Then CheckTime=0
    If Mid$(X$,3,1)<>":" Or Mid$(X$,6,1)<>":" Then CheckTime=0
    If Val(Mid$(X$,4,2))<0 Or Val(Mid$(X$,4,2))>59 Then CheckTime=0
    If Val(Right$(X$,2))<0 Or Val(Right$(X$,2))>59 Then CheckTime=0
  Else
    CheckTime=0
  EndIf
End Function

Function CheckDate(X$)
  CheckDate=1
  If Len(X$)=10 Then
    CheckD=Val(Left$(X$,2))
    CheckM=Val(Mid$(X$,4,2))
    CheckY=Val(Right$(X$,4))
    MaxDays=31
    If CheckM=2 Then MaxDays=29
    If CheckM=9 Or CheckM=4 Or CheckM=6 Or CheckM=11 Then MaxDays=30
    If CheckD<1 Or CheckD>MaxDays Then CheckDate=0
    If CheckM<1 Or CheckM>12 Then CheckDate=0
    If CheckY<2015 Or CheckY>2100 Then CheckDate=0
    If Mid$(X$,3,1)<>"-" Or Mid$(X$,6,1)<>"-" Then CheckDate=0
  Else
    CheckDate=0
  EndIf
End Function
