' *** Reversi ***
  ' Byte Magazine 1979
  ' Modified by Ian Spencer
  ' for the H-112 in 1979
  ' and Colour Maximite in 2019
  ' and Picomite in 2022
  '
  Option base 0
  If MM.Device$="Colour Maximite" Then Mode 1
  Dim s(400)
  Dim d(8)
  '
  For a = 1 To 24
   Print
  Next a
  Print @(0,0) "*** Reversi v1.0 ***"
  Print : Print "Full Reversi Rules"
  Print "positions 4,4  4,5   5,4   5,5"
  Print "must be filled first"
  Print : Print "Computer plays White"
  Print "Black to move first"
  Pause 6000
  d(1)=1:d(2)=11:d(3)=10:d(4)=9:d(5)=-1
  d(6)=-11 : d(7)=-10 : d(8)=-9
Start:
  ' *** Initialize
  Initialize
L165:
  ' *** Display Board
  DispBoard
  If q<5 Then GoTo L260
  ' *** Check for Legal Play
  CkLegal
  If t=1 Then GoTo L260
  t3=t3+1
  If t3<2 Then GoTo L245
  Print :  Print "*** The Game is Over ***"
  n=0:j=0
  For z=12 To 89
    If s(z)<0 Then GoTo L216
    If s(z)<>1 Then GoTo L217
    j=j+1
    GoTo L217
L216:    n=n+1
L217:
  Next z
  Print "Black has" n "   White has" j " Pieces"
  Print : Print "Do you want to play again (y or n) ";
  Input i$
  If Left$(i$,1)="y" Then Restore : GoTo Start
  End
L245:
  Print
  If p=1 Then GoTo L250
  Print "Black has no play, loses turn"
  Pause 3000 : GoTo L375
L250:
  Print "White has no play, loses turn"
  Pause 3000 : GoTo L375
L260:
  GetPlay
  If m<>1 Then GoTo L320
  If q>4 Then GoTo L310
  ' *** Computer Plays
  ' *** First 4 Plays
  m=45
L302:
  If s(m)=2 Then GoTo L340
  m=m+1 : GoTo L302
L310:
  CkComputer
L320:
  ' *** Check Play
  If m<1 Then GoTo L360
  If m>100 Then GoTo L360
  If q>4 Then GoTo L350
  If s(m)<>2 Then GoTo L360
L340:
  s(m)=p
  GoTo L370
L350:
  MakePlay
  If t<>0 Then GoTo L373
L360:
  Print : Print "--- Illegal Play ---" : Pause 2000
  GoTo L165
L370:
  q=q+1
L373:
  t3=0
L375:
  p=-p
  y=m+200 : If s(y)<>64 Then GoTo L165
  AdjCorners
  GoTo L165

  ' *** Get a Play
Sub GetPlay
  If p=1 Then x=0 : y=0 : GoTo L435
  Print : Print "If you want the computer to play enter (0,0)"
  Print "Black";
  GoTo L425
L420:
  Print "White";
L425:
  Print "s turn Enter x,y ";
  Input x,y
L435:
  m=y*10+x+1
  If M=1 Then r=1
End Sub

  ' *** Check for Legal Play
Sub CkLegal
  t=1
  If r=1 Then GoTo L505
  y=Int(r/10) : x=y*10 :x=r-x-1
  Print : Print "** My move was " x "," y;
  Print
L505:
  m=1 : r=1
L515:
  If s(m)<>0 Then GoTo L550
  n=1
L525:
  j=d(n)
  y=m+j : s1=-p : If s(y)<>s1 Then GoTo L545
  k=m+j+j
L540:
  If s(k)=3 Then GoTo L545
  If s(k)=0 Then GoTo L545
  If s(k)=p Then Exit Sub
  k=k+j
  GoTo L540
L545:
  n=n+1
  If n<9 Then GoTo L525
L550:
  m=m+1
  If m<90 Then GoTo L515
  t=0
End Sub

  ' *** Make a Play
 Sub MakePlay
  t=0
  If s(m)=0 Then GoTo L615
  Exit Sub
L615:
  n=1
L620:
  j=d(n)
  y=m+j : s1=-p :If s(y)<>s1 Then GoTo L700
  k=m+j+j
L635:
  If s(k)=3 Then GoTo L700
  If s(k)=0 Then GoTo L700
  If s(k)=p Then GoTo L665
  k=k+j
  GoTo L635
L665:
  t=1
  l=m
L667:
  If l=k Then GoTo L700
  s(l)=p
  l=l+j
  GoTo L667
L700:
  n=n+1
  If n<9 Then GoTo L620
End Sub

  ' *** Check Computer's Play
Sub CkComputer
  Print : Print "*** Thinking ***"
  f=1999
  For z=12 To 89
    w=0
    y=z+100 : s(y)=s(z)
  Next z
  m=12
L780:
  If u<4 Then GoTo L795
  u=0
  Print ".";
L795:
  u=u+1
  MakePlay
  If t=0 Then GoTo L870
  CkOpReply
  If w=0 Then w=m
  If h>f Then GoTo L855
  If h<f Then GoTo L840
  ' *** Choose Random or Equal Plays
  z=random
  If z>0.7 Then GoTo L855
L840:
  f=h
  ' *** Found Better Move
  w=v
L855:
  For z=12 To 89
    y=z+100 : s(z)=s(y)
  Next z
L870:
  m=m+1
  If m<90 Then GoTo L780
  m=w
  Print
  r=m
End Sub

  ' *** Check Opponent's Replies
Sub CkOpReply
  h=-1999
  For z=12 To 89
    y=z+300 : s(y)=s(z)
  Next z
  p=-p
  v=m
  m=12
L935:
  MakePlay
  If t=0 Then GoTo L1000
  Evaluate
  If g<f Then GoTo L970
  ' *** Forget this play
  h=g
  GoTo L1010
L970:
  If g<h Then GoTo L985
  ' *** Found more harmfull reply
  h=g
L985:
  For z=12 To 89
    y=z+300 : s(z)=s(y)
  Next z
L1000:
  m=m+1
  If m<90 Then GoTo L935
L1010:
  m=v
  p=-p
End Sub

  ' *** Evaluate
Sub Evaluate
  g=0 : z=12
L1040:
  If s(z)=p Then GoTo L1060
  If s(z)=0 Then GoTo L1075
  y=z+200 : g=g-s(y)
  GoTo L1075
L1060:
  ' *** Forget this play
  y=z++200 : g=g+s(y)
  If g>f Then Exit Sub
L1075:
  z=z+1
  If z<90 Then GoTo L1040
End Sub


  ' *** Adjust Corner Values
Sub AdjCorners
  If m=12 Then s(213)=5 : s(222)=5 : s(223)=5
  If m=19 Then s(218)=5 : s(228)=5 : s(229)=5
  If m=82 Then s(272)=5 : s(273)=5 : s(283)=5
  If m=89 Then s(277)=5 : s(278)=5 : s(288)=5
End Sub

  ' *** Display the board
Sub DispBoard
  Print :Print
  Print "*** REVERSI v1.0 ***"
  Print
  Print "   1 2 3 4 5 6 7 8"
  For y=8 To 1 Step -1
    Print y;
    For x=1 To 8
      z=y*10+x+1
      If s(z)=1 Then GoTo L2040
      If s(z)<0 Then GoTo L2050
      Print " -";
      GoTo L2055
L2040:
      Print " W";
      GoTo L2055
L2050:
      Print " B";
L2055:
    Next x
    Print y
  Next y
  Print "   1 2 3 4 5 6 7 8"
End Sub

  ' *** Initialize
Sub Initialize
  For n=1 To 99
    s(n)=0
  Next n
  For n=1 To 10
    s(n)=3
    z=n+90 : s(z)=3
    z=n*10-9 : s(z)=3
    z=n*10 : s(z)=3
  Next n
  s(45)=2 : s(46)=2 :s(55)=2 : s(56)=2
  u=5 : q=1 : p=-1
  For n=211 To 290
    Read s(n)
  Next n
End Sub

  Data 0,64,-30,10,5,5,10,-30,64,0
  Data 0,-30,-40,2,2,2,2,-40,-30,0
  Data 0,10,2,5,1,1,5,2,10,0
  Data 0,5,2,1,1,1,1,2,5,0
  Data 0,5,2,1,1,1,1,2,5,0
  Data 0,10,2,5,1,1,5,2,10,0
  Data 0,-30,-40,2,2,2,2,-40,-30,0
  Data 0,64,-30,10,5,5,10,-30,64,0                                                                  