option explicit
option keyboard repeat 400,40
option base 0
option default float
option angle degrees

timer=0
mode 1,8
' Aux variables
dim f,i,v, x(2),y(2),z,vi(2),vo(2),tt
' Object data - distance X,Y,Z - Viewplane distance - Vertices and Faces arrays size
const dx=400,dy=300,dz=1000,vp=800,vs=5,fs=7
' Projection matrix
dim px(vs),py(vs)
' Vertices
dim vt(2,vs)=(0,250,0, 250,0,0, -250,0,0, 0,-250,0, 0,0,250, 0,0,-250)
' Faces
dim f1(fs)=(5,5,5,5,4,4,4,4)
dim f2(fs)=(2,3,1,0,3,1,0,2)
dim f3(fs)=(3,1,0,2,2,3,1,0)
' Faces colors
dim c(fs)=(rgb(yellow),rgb(cyan),rgb(green),rgb(magenta),rgb(red),rgb(blue),rgb(white),rgb(&H40,&H40,&H40))
' Rotation - Angles X,Y,Z - Rotation matrix
const ix=2,iy=1,iz=0.5
dim ax,ay,az, cx,sx, cy,sy, cz,sz, r(2,2)

' Main loop
cls
for i=1 to 720
  box 192,92,416,416,,0,0

  inc ax,ix
  inc ay,iy
  inc az,iz
  cx=cos(ax):sx=sin(ax)
  cy=cos(ay):sy=sin(ay)
  cz=cos(az):sz=sin(az)
  r(0,0)=cy*cz:r(0,1)=sx*sy*cz-sz*cx:r(0,2)=-sy*cx*cz-sx*sz
  r(1,0)=cy*sz:r(1,1)=cx*cz+sx*sy*sz:r(1,2)=sx*cz-sz*cx*sy
  r(2,0)=sy:r(2,1)=-sx*cy:r(2,2)=cx*cy

  for v=0 to vs
    math slice vt(),,v,vi()
    math v_mult r(),vi(),vo()
    z=vp/(dz+vo(2)):px(v)=vo(0)*z+dx:py(v)=vo(1)*z+dy
    if i=650 then
      pv(vo())
    end if
  next
  for f=0 to fs
    v=f1(f):x(0)=px(v):y(0)=py(v)
    v=f2(f):x(1)=px(v):y(1)=py(v)
    v=f3(f):x(2)=px(v):y(2)=py(v)
    math v_cross x(),y(),vo()
    if math(sum vo())>0 then
      polygon 3,x(),y(),c(f),c(f)
    end if
  next
next
tt=timer
' Execution statistics
page write 0
print
print "TOTAL AFTER "+str$(i-1)+" ITERATIONS: "+str$(tt,0,2)+" ms"
print "TIME PER ITERATION: "+str$(tt/720,0,2)+" ms"
print "FPS: "+str$(1000/(tt/720),0,2)

sub pv(vrt()) 
  tt=timer
  math v_print vrt()
  timer=tt
end sub

