'AUTO.BAS" - CHAIN FILES
  ' DISCLAIMER - USE AT OWN RISK
Dim current : Dim volts : Dim soc : Dim icerpm : Dim throt : Dim brake : Dim kph : Dim ICEkw : Dim BATTKW : Dim NettKW : Dim Dmax : Dim Cmax
Dim HVflags : Dim fuelflow : Dim VVTi : Dim Cload : Dim Drivecond : Dim MG1rpm : Dim MG2rpm : Dim MG1TQ : Dim ACP : Dim HVpi : Dim HVpo
Dim MG2TQ : Dim power : Dim PowReq : Dim DisReq : Dim HVVMF : Dim HVBatIT : Dim auxbat : Dim HVcharge : Dim HVLT : Dim HVIT : Dim HVTH : Dim HVHT
Dim HVdischarge : Dim HVDelta : Dim intaket1 : Dim ambient : Dim intaket3 : Dim targetpower : Dim trb : Dim rb : Dim HVBB : Dim HVAB
Dim mct : Dim EIPT : Dim TOWT  : Dim H3C8data3 : Dim H3C8data2 : Dim H520data0 : Dim H039data2 : Dim H039data1 : Dim test
Dim H03Adata0 : Dim H03Adata0 : Dim H03Adata3 : Dim H03Adata4 : Dim H03Adata5 : Dim Trpm : Dim TTQ : Dim TTQH : Dim Ky$
Dim TTQL : Dim flags : Dim flags1 : Dim flags2 :  Dim gastank : Dim fuelflowa : Dim fuelflowb : Dim fuelflowc : Dim Warningpage
Dim ICEt : Dim BatDegCl : Dim BatDegCh : Dim MG1t : Dim MG2t : Dim INV1t : Dim INV2t : Dim temper : Dim convt
Dim evMode : Dim ect : Dim dimmer : Dim K$ : Dim bmsvolts : Dim voltsbms : Dim cat1 : Dim cat2 : Dim Rpr : Dim Scw
Dim forcedev : Dim HVfan : Dim fanspeed : Dim period : Dim sw : Dim BMS : Dim ev$ : Dim R1 : Dim R2 : Dim R3 : Dim R4
Dim HVB1 : Dim HVB2 : Dim HVB3 : Dim HVB4 : Dim HVB5 : Dim HVB6 : Dim HVB7 : Dim HVB8 : Dim HVB9 : Dim Timer1
Dim HVB10 : Dim HVB11 : Dim HVB12 : Dim HVB13 : Dim HVB14 : Dim HVBT : DIM HVBL : DIM HVBH : DIM HVBD : Dim IR1 : Dim IR2 : Dim IR3 : Dim IR4
Dim IR5 : Dim IR6 : Dim IR7 : Dim IR8 : Dim IR9 : Dim IR10 : Dim IR11 : Dim IR12 : Dim IR13 : Dim IR14 : Dim IRT : Dim warn
Dim Vload : Dim Aload : Dim shift : Dim shift$ : Dim SocORIG : Dim CCLORIG : Dim DCLORIG : Dim AH : Dim AHT : Dim AHf : Dim running
Dim fl : Dim fl1 : Dim fl2 : Dim ok : Dim txData : Dim page : Dim looper : Dim ready : Dim tt : Dim stepper: Dim counter
Dim C1 : Dim C2 : Dim C3 : Dim C4 : Dim C5 : Dim C6 : Dim D1 : Dim stop : Dim n1 : Dim n2 : Dim n3 : Dim n4 : Dim log
ready = 0 : page = 0 : tt = 0 : looper = 0 : C1=0 : C2=0 : C3=0 : C4=0 : C5=0 : C6=0 : R1=0 : log=0 : running=0
fanspeed = 0 : stepper = 0 : Dim rxData(8) : Dim rxOk : Dim memy : Dim memx : Dim memz : Dim memw : Dim timermem


' START OF USER DEFINED SUBROUTINES BELOW:

Sub F9 ' DATA LOGGER
  GoSub Printheader : GoSub Drawboxes : GoSub Drawlabels_RHS : Font 2
  Font 1 : Print  @(20,260) "PRESS ESC TO END";
  Open "b:data1.csv" For append As #1 : Open "b:data2.csv" For append As #2
  Open "b:data3.csv" For append As #3 : Open "b:data4.csv" For append As #4
  Open "b:data5.csv" For append As #5
  Write #1, Date$, Time$
  Write #1,"TIME secs","current","AHT","Dmax ","Cmax","volts","soc %","Trpm NM","rpm","TTQ NM","Throt %","Brake %","kph","HVflags","VVTi","Cload %","HVch kW","HVdisch kW","HVVMF volts","auxbat","Drivecond"
  Write #2, Date$, Time$
  Write #2,"TIME secs","Delta %","MG1 rpm","MG2 rpm","MG1 NM","MG2 NM","Target NM","Power NM","Power Req","Discharge Req","TRB NM","RB NM","MCT NM","Gas %","Target rpm","Shift","Shift$","evMode","EV$","Dimmer"
  Write #3, Date$, Time$
  Write #3,"TIME secs","H3C8data2","H3C8data3","H520data0","H039data1","H039data2","H03Adata0","H03Adata3","H03Adata4","H03Adata5","TTQH","TTQL","flags","flags1","flags2","fuelflowa","fuelflowb","fuelflowc","fuelflow"
  Write #4, Date$, Time$
  Write #4,"TIME secs","ambient","ect","EIPT","MG1t","MG2t","INV1t","INV2t","temper","convt","HVBatIT","intaket1","intaket3","ICEt","BatDegCl","BatDegCh"
  Write #5, Date$, Time$
  Write #5,"TIME secs","HVAB volts","HVBB volts","Scw volts","Rpr %","Acp kW","HVlt Sec","HVit Sec","HVth Sec","HVht Sec","HVpi kW","HVpo kW","ICE kw","BATTkw","Nettkw"
  Timer=0 : timermem=0
End Sub

Sub UpdateF9  'DATA LOGGING
  If Timer => (timermem+500) Then
    Font 2 : Print @(273,385) " ";
    If page=9 Then Font 2 : Print @(20,200) "               ";
  EndIf
  If Timer => (timermem+1000) Then
    If page=9 Then Font 2 : Print @(20,200) "DATA LOG ACTIVE";: Print @(20,260) "PRESS ESC TO END";
    Font 2 : Print @(273,385) "*";
    Write #1,Timer/1000,current,AHT,Dmax,Cmax,volts,soc,Trpm,icerpm,TTQ,throt,brake,kph,HVflags,VVTi,Cload,HVcharge,HVdischarge,HVVMF,auxbat,Drivecond
    Write #2,Timer/1000,HVDelta,MG1rpm,MG2rpm,MG1TQ,MG2TQ,targetpower,power,PowReq,DisReq,trb,rb,mct,gastank,Trpm,shift,shift$,evMode,EV$,dimmer
    Write #3,Timer/1000,H3C8data2,H3C8data3,H520data0,H039data1,H039data2,H03Adata0,H03Adata3,H03Adata4,H03Adata5,TTQH,TTQL,flags,flags1,flags2,fuelflowa,fuelflowb,fuelflowc,fuelflow
    Write #4,Timer/1000,ambient,ect,EIPT,MG1t,MG2t,INV1t,INV2t,temper,convt,HVBatIT,intaket1,intaket3,ICEt,BatDegCl,BatDegCh
    Write #5,Timer/1000,HVAB,HVBB,Scw,Rpr,Acp,HVlt,HVit,HVth,HVht,HVpi,HVpo,ICEkw,battkw,nettkw
    timermem=Timer
  EndIf
End Sub

Sub pidrequest(header, mode, pid, more)
  Local txData(8) : Local txok : Local txId : txId = header
  txData(3) = 0 : txData(4) = 0 : txData(5) = 0 : txData(6) = 0 : txData(7) = 0
  txData(0) = &H2 : txData(1) = mode : txData(2) = pid
  CAN TX 0,txId,0,8,txData(0),txOk : Pause 10
  If more = 1 Then
    txData(0)=&H30 : txData(1)=0 : txData(2)=0 : CAN TX 0,txId,0,8,txData(0),txOk
  EndIf
End Sub

Sub filter2104 ' - &H7E0 - &H7E8
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxOk=1 Then
      If rxData(0)=&H3 And rxData(1)=&H61 And rxData(2)=&H4 Then
        Cload=rxdata(3)*0.3906
          If Cload=>99 Then Cload=99
        Exit Sub
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter0143 ' - &H7E0 - &H7E8
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxOk=1 Then
      If rxData(0)=&H4 And rxData(1)=&H41 And rxData(2)=&H43 Then
        Aload=(rxdata(3)*99.8438)+(0.39001465*rxData(4))
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter2143 ' - &H7E0 - &H7E8
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxOk=1 Then
      If rxData(0)=&H4 And rxData(1)=&H61 And rxData(2)=&H43 Then
        Vload=(rxdata(3)*100.3516)+(0.39199829*rxData(4))
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter213D ' - &H7E0 - &H7E8
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxOk=1 Then
      If rxData(0)=&H04 And rxData(1)=&H61 And rxData(2)=&H3D Then
        cat1=(rxdata(3)*25.6000)+(0.1*rxData(4))-40
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter213F ' - &H7E0 - &H7E8
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxOk=1 Then
      If rxData(0)=&H04 And rxData(1)=&H61 And rxData(2)=&H3F Then
        cat2=(rxdata(3)*25.6000)+(0.1*rxData(4))-40
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter21C3 '- &H7E2 - &H7EA
  Local rxData(8) : Local rxOk
  Local looper : looper = 0 : Local D2 : Local D3 : Local D4 : Local D5
  Local MEM : D2 = 0 : D3=0 : D4=0 : D5=0
  Do
    CAN RX 21,rxData(0),rxOk 'CHANNEL 21 - tx&H7E2 to rx&H7EA
    If rxOk = 1 Then
      If rxData(0)=&H10 And rxData(1)=&H27 And rxData(2)=&H61 And rxData(3)=&HC3 Then
        MG2TQ = (32*rxData(6))+(0.125*rxData(7))-500
        MG2rpm=((256*rxData(4))+rxData(5))-16383 : D2=1
      EndIf
      If rxData(0)=&H21 Then
        TRB=4.000*rxData(2) : RB=4.000*rxData(1) : MG1rpm=((rxData(3)*256)+rxData(4))-16383 : D3=1
        MG1TQ=(32*rxData(5))+(0.125*rxData(6))-500 : PowReq=(2560.000*rxData(7))+10.000*MEM
      EndIf
      If (rxData(0) = &H22) Then
        MEM=rxData(1) : MCT=(4.000*rxData(7))-512
      EndIf
      If (rxData(0) = &H23) Then
        INV1t=rxData(7)-50 : DisReq=rxData(4) : Drivecond=rxdata(6) : D4=1
        HVPI=rxData(3)-40800
        HVPO=rxData(2)*320
      EndIf
      If (rxData(0) = &H24) Then
        INV2t=rxData(1)-50 : MG1t=rxData(2)-50 : MG2t=rxData(3)-50
        Volts=rxData(4)*2.000 : current=((rxData(5)+(rxData(6)*2))-256)*-1 : BattKW=volts*current/1000
        Nettkw = icekw - battkw
        If log=0 Then
          AHf=Timer : Timer=0
        EndIf
        If log=1 Then
          AHf=Timer-timer1 : timer1=Timer
        EndIf
        If AHf=0 Then AHf=1000    'Prevents divide by zero overflow error
        AH=(current*-1)/(3600*(1000/AHf)) : AHT=AHT+AH
        If AHT=>100 Then AHT=0
      EndIf
    '  If D2=1 And D3=1 And D4=1 And D5=1 Then Exit Sub
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter21C4 '- &H7E2 - &H7EA
  Local rxData(8) : Local rxOk
  Local looper : looper=0
  Do
    CAN RX 21,rxData(0),rxOk 'CHANNEL 21 - tx&H7E2 to rx&H7EA
    If rxok = 1 Then
      If rxData(0)=&H10 And rxData(1)=&H11 And rxdata(2)=&H61 And rxdata(3)=&HC4 Then
        HVflags=rxData(5)
        HVBB=2*rxData(7)
      EndIf
      If rxData(0)=&H21 Then
        convt=(rxData(2)-50)
        HVAB=2*rxData(1)
      EndIf
      If rxData(0)=&H23 Then
        Scw=0.019608*rxData(1)
        Rpr=0.392*rxData(4)
        Acp=0.019608*rxdata(5)
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter21CD '- &H7E0 - &H7E8
  Local rxData(8) : Local rxOk
  Local looper : looper=0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxok = 1 Then
'     If rxData(0)=&H10 And rxData(1)=&H14 And rxdata(2)=&H61 Then
      If rxData(0)=&H21 Then EIPT=rxData(6)-40
      If rxData(0)=&H22 Then TOWT=rxData(1)-40
    EndIf
  looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub Filter21CE ' F5 - HV battery cell voltages @ &H7E3 - &H7EB
  Local rxData(8) : Local rxOk
  Local D2: Local D3 : Local D4 : Local D5 : Local D6 : Local looper
  D2=0 : D3=0 : D4=0 : D5=0 : D6=0 : looper = 0
  Do
    CAN RX 22,rxData(0),rxOk 'CHANNEL 24 - tx&H7E3 to rx&H7EB
    If rxok = 1 Then
      If D2=0 And rxData(0)=&H10 And rxData(1)=&H21 And rxData(2)=&H61 And rxData(3)=&HCE Then
        HVB1MEM = rxData(7)
      EndIf
      If (D3=0) And (rxData(0) = &H21) Then
        D3 = 1 : HVB1 = (2.56 * HVB1MEM) + (0.01 * rxData(1)) - 327.68
        HVB2 = (2.56 * rxData(2)) + (0.01 * rxData(3)) - 327.68
        HVB3 = (2.56 * rxData(4)) + (0.01 * rxData(5)) - 327.68
        HVB4 = (2.56 * rxData(6)) + (0.01 * rxData(7)) - 327.68
      EndIf
      If D4 = 0 And (rxData(0) = &H22) Then
        D4 = 1 : HVB5 = (2.56 * rxData(1)) + (0.01 * rxData(2)) - 327.68
        HVB6 = (2.56 * rxData(3)) + (0.01 * rxData(4)) - 327.68
        HVB7 = (2.56 * rxData(5)) + (0.01 * rxData(6)) - 327.68
        HVB8MEM = rxData(7)
      EndIf
      If D5 = 0 And (rxData(0) = &H23) Then
        If HVB8MEM > 0 Then HVB8 = (2.56*HVB8MEM)+(0.01*rxData(1))-327.68
        HVB9 = (2.56 * rxData(2)) + (0.01 * rxData(3)) - 327.68
        HVB10 = (2.56 * rxData(4)) + (0.01 * rxData(5)) - 327.68
        HVB11 = (2.56 * rxData(6)) + (0.01 * rxData(7)) - 327.68 : D5 = 1
      EndIf
      If D6 = 0 And (rxData(0) = &H24) Then
        D6 = 1 : HVB12 = (2.56 * rxData(1)) + (0.01 * rxData(2)) - 327.68
        HVB13 = (2.56 * rxData(3)) + (0.01 * rxData(4)) - 327.68
        HVB14 = (2.56 * rxData(5)) + (0.01 * rxData(6)) - 327.68
      EndIf
      HVBT = HVB1+HVB2+HVB3+HVB4+HVB5+HVB6+HVB7+HVB8+HVB9+HVB10+HVB11+HVB12+HVB13+HVB14
    EndIf
  '  If D2=1 And D3=1 And D4=1 And D5=1 And D6=1 Then Exit Sub
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub Filter21D0 '- HV battery cell internal resistances @ &H7E3 - &H7EB
  Local D3 : Local D4 : Local D5 : Local looper : D3=0 : D4=0 : D5=0 : looper=0
  Local rxData(8) : Local rxOk : Local rxId : Local rxType : Local rxLen : Local mem
  Do
    CAN RX 22,rxId,rxType,rxLen,rxData(0),rxOk 'CHANNEL 22 - tx&H7E3 to rx&H7EB
    If rxok=1 Then
      If rxData(0)=&H10 Then
        HVLT=(256*rxData(5))+rxData(6) : mem=rxData(7)
      EndIf
      If rxData(0) = &H21 Then
        HVIT=(256*mem)+rxData(1)
        HVTH=(256*rxData(2))+rxData(3)
        HVHT=(256*rxData(4))+rxData(5)
        HVBL=(2.56*rxData(6))+(0.01*rxData(7))-327.68
      EndIf
      If D3=0 And (rxData(0) = &H22) Then
        D3=1 : IR1 = 0.001 * rxData(5) : IR2 = 0.001 * rxData(6) : IR3 = 0.001 * rxData(7)
        HVBH=(2.56*rxData(2))+(0.01*rxData(3))-327.68 : HVBD=HVBH-HVBL
      EndIf
      If D4=0 And (rxData(0) = &H23) Then
        D4=1 : IR4 = 0.001 * rxData(1) : IR5 = 0.001 * rxData(2) : IR6 = 0.001 * rxData(3)
        IR7 = 0.001 * rxData(4) : IR8 = 0.001 * rxData(5) : IR9 = 0.001 * rxData(6)
        IR10 = 0.001 * rxData(7)
      EndIf
      If D5=0 And (rxData(0) = &H24) Then
        D5=1 : IR11 = 0.001 * rxData(1) : IR12 = 0.001 * rxData(2) : IR13 = 0.001 * rxData(3)
        IR14 = 0.001 * rxData(4)
      EndIf
      IRT = IR1+IR2+IR3+IR4+IR5+IR6+IR7+IR8+IR9+IR10+IR11+IR12+IR13+IR14
    EndIf
   ' If (D3=1) And (D4=1) And (D5=1) Then Exit Sub
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter21CF ' @ &H7E3 - &H7EB
  Local rxData(8) : Local rxOk
  Local D1: Local D2 : Local looper : looper = 0 : D1=0 : D2=0
  Do
    CAN RX 22,rxData(0),rxOk 'CHANNEL 22 - tx&H7E3 to rx&H7EB
    If rxok = 1 Then
      If D1=0 And rxData(0)=&H10 And rxData(1)=&H12 And rxData(2)=&H61 And rxData(3)=&HCF Then
        HVVMF = (0.200 * rxData(6)) -25.6 : auxbat = (0.200 * rxData(7)) - 25.6
        HVBatIT = ((0.288 * rxData(4)) + (0.001129 * rxData(5)) + 32)-50 : D1=1
      EndIf
      If (D2=0) And (rxData(0) = &H21) Then
        HVcharge=rxData(1)-64 : HVdischarge=rxData(2)-64
        HVDelta=0.010*rxData(3) : D2=1
      EndIf
    EndIf
  '  If (D1=1) And (D2=1) Then Exit Sub
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub F1
  If R1 = 0 Then R1 = 1 Else R1 = 0
  If page<>7 And page<>8 And page<>25 Then
    If R1 = 1 Then Font 1 : Print @(20,415) "EV MAN ";
    If R1 = 0 Then Font 1 : Print @(20,415) "EV AUTO";
  EndIf
End Sub

Sub F2
  ' If R2 = 0 Then R2 = 1 Else R2 = 0
  If Warningpage=1 Then Warningpage=0 Else Warningpage=1
  Font 1
  If page<>7 or page<>8 Then
    If Warningpage=1 Then Print @(15,380) "Warning ACTIVE"; Else Print @(15,380) "               ";
  EndIf
End Sub

Sub F3
  ' If R3 = 0 Then R3 = 1 Else R3 = 0   'Used for Enginer Kit
  page=page+1
  If page=1 then page=5
  If page=5 then F5()
  If page=6 then F6()
  If page=7 then page=13
  If page=13 then Gosub Gauge13
  If page=14 then PSD()
  If page=15 then GoSub BMSpluslabels
  If page=16 then Gosub Gauge16
  If page=17 then Gosub Gauge17
  If page=18 then Gosub Gauge18
  If page=19 then Temp()
  If page=>20 then page=5 : F5()
  If page<1 then page=1
End Sub

Sub F4
  If R4=0 Then R4=1 Else R4=0
  Pin(18) = R4
  If R4=1 Then
    Font 1
    GoSub SendORIG
      If page<>7 And page<>8 And page<>25 Then
        Print @(93,415) "ORIG";
      EndIf
  EndIf
  If R4=0 Then
    Font 1
    bmsvolts = 210
    GoSub SendPHEV
    Pause 500
    If page<>7 And page <> 8 And page<>25 Then
      Print @(93,415) "PHEV";
    EndIf
  EndIf
End Sub

Sub F5
  GoSub printheader : GoSub drawboxes : GoSub drawlabels_RHS
  Font 1,2 : Print @(10,95) "OEM NiMH CELL VOLTS"; : Font 1
  Print @(10,137)  "V1:"; @(130,137) "V2:"; @(10,157)  "V3:";
  Print @(130,157) "V4:"; @(10,177)  "V5:"; @(130,177) "V6:";
  Print @(10,197)  "V7:"; @(130,197) "V8:"; @(10,217)  "V9:";
  Print @(130,217) "V10:"; @(10,237)  "V11:"; @(130,237) "V12:"  ;
  Print @(10,257)  "V13:"; @(130,257) "V14:"; @(10, 277) "TOTAL:";
  Print @(10,297) "HIGHEST:"; @(10,317) "LOWEST:"; @(10,337) "DIFF:";
  Print @(10,357) "DELTASOC:";
End Sub

Sub F6
  GoSub printheader : GoSub drawboxes : GoSub drawlabels_RHS
  Font 1,2 : Print @(10,95) "OEM NiMH CELL OHMS"; : Font 1
  Print @(10,137)  "R1:"; @(130,137) "R2:"; @(10,157)  "R3:";
  Print @(130,157) "R4:"; @(10,177)  "R5:"; @(130,177) "R6:";
  Print @(10,197)  "R7:"; @(130,197) "R8:"; @(10,217)  "R9:";
  Print @(130,217) "R10:"; @(10,237)  "R11:"; @(130,237) "R12:";
  Print @(10,257)  "R13:"; @(130,257) "R14:"; @(10,277) "TOTAL:";
  Print @(10,297)  "HVBATTLOW:" 
  Print @(10,317)  "DCINHIBIT:"
  Print @(10,337)  "HVBATTHIGH:"
  Print @(10,357)  "HVTEMPHIGH:"
End Sub

Sub UpdateF4
  If R4=1 Then
    Font 1
    If page<>7 And page<>8 And page<>25 Then Print @(93,415) "ORIG";
  EndIf
  If R4=0 Then
    Font 1
    If page<>7 And page<>8 And page<>25 Then Print @(93,415) "PHEV";
  EndIf
End Sub

Sub updateF5
  Font 2
  Print @(35,130)  Format$(HVB1,"%5.2f") ; "v"; @(155,130) Format$(HVB2,"%5.2f") ; "v";
  Print @(35,150)  Format$(HVB3,"%5.2f") ; "v"; @(155,150) Format$(HVB4,"%5.2f") ; "v";
  Print @(35,170)  Format$(HVB5,"%5.2f") ; "v"; @(155,170) Format$(HVB6,"%5.2f") ; "v";
  Print @(35,190)  Format$(HVB7,"%5.2f") ; "v"; @(155,190) Format$(HVB8,"%5.2f") ; "v";
  Print @(35,210)  Format$(HVB9,"%5.2f") ; "v"; @(155,210) Format$(HVB10,"%5.2f"); "v";
  Print @(35,230)  Format$(HVB11,"%5.2f"); "v"; @(155,230) Format$(HVB12,"%5.2f"); "v";
  Print @(35,250)  Format$(HVB13,"%5.2f"); "v"; @(155,250) Format$(HVB14,"%5.2f"); "v";
  Print @(60,270)  Format$(HVBT,"%5.2f") ;  " v";
  Print @(60,290)  Format$(HVBH,"%5.2f") ;  " v";
  Print @(60,310)  Format$(HVBL,"%5.2f") ;  " v";
  Print @(60,330)  Format$(HVBD,"%5.2f") ;  " v";
  Print @(60,350)  Format$(HVDELTA,"%3.0f") ;  " %";
End Sub

Sub updateF6
  Font 2
  Print @(35,130)  "       "; @(35,130) Format$(IR1,"%g")  ; ""; @(155,130) "       "; @(155,130) Format$(IR2,"%g") ; "";
  Print @(35,150)  "       "; @(35,150) Format$(IR3,"%g")  ; ""; @(155,150) "       "; @(155,150) Format$(IR4,"%g") ; "";
  Print @(35,170)  "       "; @(35,170) Format$(IR5,"%g")  ; ""; @(155,170) "       "; @(155,170) Format$(IR6,"%g") ; "";
  Print @(35,190)  "       "; @(35,190) Format$(IR7,"%g")  ; ""; @(155,190) "       "; @(155,190) Format$(IR8,"%g") ; "";
  Print @(35,210)  "       "; @(35,210) Format$(IR9,"%g")  ; ""; @(155,210) "       "; @(155,210) Format$(IR10,"%g"); "";
  Print @(35,230)  "       "; @(35,230) Format$(IR11,"%g") ; ""; @(155,230) "       "; @(155,230) Format$(IR12,"%g"); "";
  Print @(35,250)  "       "; @(35,250) Format$(IR13,"%g") ; ""; @(155,250) "       "; @(155,250) Format$(IR14,"%g"); "";
  Print @(80,270)  "       "; @(80,270)  Format$(IRT,"%g") ; " ohms";
  Print @(80,290)  Format$(HVLT,"%4.0f") ;  " Sec";
  Print @(80,310)  Format$(HVIT,"%4.0f") ;  " Sec";
  Print @(80,330)  Format$(HVTH,"%4.0f") ;  " Sec";
  Print @(80,350)  Format$(HVHT,"%4.0f") ;  " Sec";
End Sub

Sub F10
  If HVfan = 0 Then HVfan = 1 Else HVfan = 0 : ' HVfan = 1 - MANUAL MODE = 0 - AUTO MODE
End Sub

Sub F11
  GoSub printheader : GoSub drawboxes : GoSub drawlabels_RHS
  Font 2 : Print @(10,90) "DTC CHECK";
  Font 1 : Print @(10,330) "Press Esc button to return";
  Local rxData(8) : Local rxOk : Local txData(8) : Local txOk : Local looper
  rxData(0) = 0: rxData(1) = 0 : rxData(2) = 0 : rxData(3) = 0
  rxData(4) = 0: rxdata(5) = 0 : rxData(6) = 0 : rxData(7) = 0 : looper = 0
Do
  txData(0) = &H2 : txData(1) = &H13 : txData(2) = &HB0
  CAN TX 0,&H7E0,0,8,txData(0),txOk : ' CHECK ICE ECU DTC
  If txOk = 1 Then CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
  If (rxOK = 1) Then
    If (rxData(0) = &H4) And (rxData(1) = &H53) Then
      Font 2 : Print @(10,110) "ICE ECU:     ";
      Print @(10,130) rxData(0) " "; rxData(1) " ";
      Print rxData(2) " "; rxData(3) " ";
      Print rxData(4) " "; rxData(5) " ";
      Print rxData(6) " "; rxData(7) " ";
      If rxData(2) = &h1 And rxData(3) = &Hc1 And rxData(4) = &H0 Then forcedev = 1
    EndIf
  EndIf
  rxData(0) = 0: rxData(1) = 0 : rxData(2) = 0 : rxData(3) = 0
  rxData(4) = 0: rxdata(5) = 0 : rxData(6) = 0 : rxData(7) = 0 : txData(2) = &HB0
  CAN TX 0,&H7E2,0,8,txData(0),txOk : ' CHECK HYBRID ECU DTC
  If txOk = 1 Then CAN RX 21,rxData(0),rxOk 'CHANNEL 21 - tx&H7E2 to rx&H7EA
  If (rxOK = 1) Then
    If (rxData(0) = &H4) And (rxdata(1) = &H53) Then
      Font 2 : Print @(10,150) "Hybrid ECU:  ";
      Print @(10,170) Hex$(rxData(0)) " "; Hex$(rxData(1)) " ";
      Print Hex$(rxData(2)) " "; Hex$(rxData(3)) " ";
      Print Hex$(rxData(4)) " "; Hex$(rxData(5)) " ";
      Print Hex$(rxData(6)) " "; Hex$(rxData(7)) " ";
      If rxData(2) = &h1 And rxData(3) = &Hc1 And rxData(4) = &H0 Then forcedev = 1
    EndIf
  EndIf
  rxData(0) = 0: rxData(1) = 0 : rxData(2) = 0 : rxData(3) = 0
  rxData(4) = 0: rxdata(5) = 0 : rxData(6) = 0 : rxData(7) = 0 : txData(2) = &H80
  CAN TX 0,&H7E2,0,8,txData(0),txOk : ' CHECK CRUISE CONTROL ECU DTC
  If txOk = 1 Then CAN RX 21,rxData(0),rxOk 'CHANNEL 21 - tx&H7E2 to rx&H7EA
  If (rxOK = 1) Then
    If (rxData(0) = &H4) And (rxData(1) = &H53) Then
      Font 2 : Print @(10,190) "Cruise ECU:  ";
      Print @(10,210) Hex$(rxData(0)) " "; Hex$(rxData(1)) " ";
      Print Hex$(rxData(2)) " "; Hex$(rxData(3)) " ";
      Print Hex$(rxData(4)) " "; Hex$(rxData(5)) " ";
      Print Hex$(rxData(6)) " "; Hex$(rxData(7)) " ";
      If rxData(2) = &h1 And rxData(3) = &Hc1 And rxData(4) = &H0 Then forcedev = 1
    EndIf
  EndIf
  rxData(0) = 0: rxData(1) = 0 : rxData(2) = 0 : rxData(3) = 0
  rxData(4) = 0: rxdata(5) = 0 : rxData(6) = 0 : rxData(7) = 0 : txData(2) = &H80
  CAN TX 0,&H7E3,0,8,txData(0),txOk : ' CHECK HV BATTERY ECU DTC
  If txOk = 1 Then CAN RX 22, rxData(0), rxOk 'CHANNEL 22 - tx&H7E3 to rx&H7EB
  If (rxOK = 1) Then
    If (rxData(0) = &H4) And (rxData(1) = &H53) Then
      Font 2 : Print @(10,230) "Battery ECU: ";
      Print @(10,250) Hex$(rxData(0)) " "; Hex$(rxData(1)) " ";
      Print Hex$(rxData(2)) " "; Hex$(rxData(3)) " ";
      Print Hex$(rxData(4)) " "; Hex$(rxData(5)) " ";
      Print Hex$(rxData(6)) " "; Hex$(rxData(7)) " ";
      If rxData(2) = &h1 And rxData(3) = &Hc1 And rxData(4) = &H0 Then forcedev = 1
    EndIf
  EndIf
  looper = looper + 1 : If looper > 10 Then Exit Sub
Loop
End Sub

Sub F12
    Local txData(8) : Local txOk : 'F12 - CLEAR DTC
    txData(0)=&H01 : txData(1)=&H04 : txData(2)=0 : txData(3)=0
    txData(4)=0 : txData(5)=0 : txData(6)=0 : txData(7)=0
    CAN TX 0,&H7E0,0,8,txData(0),txOk
    If txOk=0 Then Font 1 : Print @(40,330) "Could not Clear ICE ECU DTC"
    CAN TX 0,&H7E2,0,8,txData(0),txOk
    If txOk=0 Then Font 1 : Print @(40,340) "Could not Clear HV ECU DTC"
    CAN TX 0,&H7E3,0,8,txData(0),txOk
    If txOk=0 Then Font 1 : Print @(40,350) "Could not Clear bATTERY ECU DTC"
End Sub

Sub UpdateF10
    Local rxData(8) : Local rxOk : Local rxId : rxId = &H7EB : Local rxLen
    Local txData(8) : Local txOk : Local inLoop : inLoop=0 : Local rxType
    txData(0)=&H4 : txData(1)=&H30 : txData(2)=&H81 : txData(3)=6
    txData(4)=fanspeed : txData(5)=0 : txData(6)=0 : txData(7)=0
    If HVfan = 1 Then
      CAN TX 0,&H7E3,0,8,txData(0),txOk ' HV FAN MANUAL MODE
      If (txOk=1) Then
        Do
          CAN RX 22,rxId,rxType,rxLen,rxData(0),rxOk 'CHA22 - tx&H7E3 to &H7EB
          If (rxOK=1) And (Page<>7) And (Page<>8) And (Page<>25) Then
            If (rxData(0) = &H2) And (rxData(1) = &H70) Then
              Font 1 : Print @(120,65) "HV FAN";fanspeed : Exit Sub
            EndIf
          EndIf
          inLoop = inLoop + 1 : If inLoop > 10 Then Exit Sub
        Loop
      EndIf
    EndIf
    If HVfan = 0 Then
      If page<>7 And page<>8 And page<>25 Then Font 1 : Print @(120,65) "FAN AUTO";
      If (BatDegCh > 25) Then
        txData(4) = 6 : CAN TX 0,&H7E3,0,8,txData(0),txOk ' HV FAN AUTO MODE
        If txOk = 1 Then
          Do
            CAN RX 22,RxData(8),rxOk 'CHANNEL 22 - tx&H7E3 to rx&H7EB
            If (rxOK = 1) Then
              If (rxData(0) = &H2 And rxData(1) = &H70) Then Exit Sub
            EndIf
            inLoop = inLoop + 1 : If inLoop > 10 Then Exit Sub
          Loop
        EndIf
      EndIf
    EndIf
End Sub

Sub UpdateF1()
  Local rxData(8) : Local rxOk : Local loops
  If forcedev = 1 Then Exit Sub
  If R1=0 Then
    Do
      CAN RX 17,rxData(0),rxOk
      If rxOK=1 Then
        evMode = rxData(4)
        If (ForcedEV=0 And evMode<>64 And R1=0 And kph<45 And soc>40 And ready=1 And flags<>6) Then
          Pin(15) = 0 : Pause 10 : Pin(15) = 1 : Exit Sub
        EndIf
      EndIf
      loops = loops + 1 : If loops > 1 Then Exit Sub
    Loop
  EndIf
End Sub

Sub UpdateF2
  ' If (R2=1 And (volts < 236 And MG2TQ => 0 ))  Then Pin(16) = 0   ' switch on - Enginer Converter 1
  ' If (R2=1 And (volts > 240 Or MG2TQ < -100  ))  Then Pin(16) = 1    ' Switch off - Enginer Converter 1
  ' If (R2=0) Then Pin(16) = 1
End Sub

Sub UpdateF3
  If (R3 = 1 And (volts < 236 And MG2 => 0    )) Then Pin(17) = 0 : ' switch on - Enginer Converter 2
  If (R3 = 1 And (volts > 240 Or MG2TQ < -100 )) Then Pin(17) = 1 : ' Switch off - ENginer Converter 2
  If (R3 = 0) Then Pin(17) = 1
End Sub

Function getS12(hi, lo)
  If (hi >= &B1000) Then getS12 = (lo + ((hi - &B10000) * 256)) * -1
  If (hi <  &B1000) Then getS12 = ((hi * 256) + lo) * -1
End Function

Function getU16(hi, lo)
  getU16 = (hi*256) + lo
End Function

Sub getCanData
  Local rxData(8) : Local rxOk : BMS=0
  CAN RX 18,rxData(0),rxOk : If (rxOk=1) Then ect = rxData(1) / 2  ' H52C
  CAN RX 1,rxData(0),rxOk : ' H3C8 - ICE
  If (rxOk=1) Then
     icerpm = (getU16(rxData(2), rxData(3)))/8
     fuelflowa = rxData(4)
     flags = rxData(0) : temper = rxData(1) : H3C8data3 = rxData(3) : H3C8data2 = rxdata(2)
  EndIf
 ' CAN RX 2,rxData(0),rxOk : ' H03B - HV current/volts
 ' If (rxOk=1) Then
 '   current = (getS12(rxData(0),rxData(1)))/10 : ' volts=(getU16(rxData(2),rxData(3)))
 ' EndIf
  CAN RX 3,rxData(0),rxOk : If (rxOk=1) Then throt = (rxData(6)/2)
  If throt > 99 Then throt = 99
  CAN RX 4,rxData(0),rxOk : If (rxOk=1) Then brake = (rxData(4)*100)/128
  CAN RX 5,rxData(0),rxOk : If (rxOk=1) Then kph = (getU16(rxData(5), rxData(6))*10)/1024
  CAN RX 6,rxData(0),rxOk : If (rxOk=1) Then ICEkw = rxData(1) * 0.25
  CAN RX 7,rxData(0),rxOk
  If (rxOk=1) Then   'H520 fuel flow
    H520data0 = rxData(0)
    fuelflowb = rxData(1)
    fuelflowc = rxData(2)
    fuelflow = fuelflowa * fuelflowc * 0.001 * fuelflowb
  EndIf
  CAN RX 8,rxData(0),rxOk : ' H3CB - HV battery
  If (rxOk=1) Then
    Dmax = rxData(0) * -1 : Cmax = rxData(1) : soc = (getU16(rxData(2), rxData(3)))/2
    BatDegCl = rxData(5) : BatDegCh = rxData(4)
  EndIf
  CAN RX 9,rxData(0),rxOk : ' H555 - BMSplus
  If (rxOk=1) Then BMS=1 Else BMS=0
  SocORIG = rxData(0) : CCLORIG = rxData(1) : DCLORIG = rXData(2)
  BMS0 = rxData(3) : BMS1 = rxData(4) : BMS2 = rxData(5) : BMS3 = rxData(6) : BMS4 = rxData(7)
  CAN RX 10,rxData(0),rxOk : ' H03A - Actual power
  If (rxOk=1) Then
    Power = rxdata(1)*4
    If power > 900 Then power = power - 1028
    H03Adata0 = rxData(0) : H03Adata2 = rxData(2)
    H03Adata3 = rxdata(3) : H03Adata4 = rxdata(4) : H03Adata5 = rxdata(5)
  EndIf
  CAN RX 11,rxData(0),rxOk : ' H3CA - Target power
  If (rxOk=1) Then
    ' If rxData(1) =>256 Then targetPower = (((rxdata(1) + 256)) - 32)*2
    ' If rxData(1) < 256 Then
    targetPower = (rxData(1) - 32)*2
  EndIf
  CAN RX 12,rxData(0),rxOk :  If (rxOk=1) Then intaket1=rxData(0) : ambient=rxData(1) : intaket3=rxData(2) ' H3CF
  CAN RX 13,rxData(0),rxOk
  If (rxOk=1) Then
    ICEt=rxData(0) : H039data1=rxData(1) : H039data2=rxData(2)
  EndIf
  CAN RX 14,rxData(0),rxOk : If (rxOk=1) Then VVTi=rxData(1)
  CAN RX 15,rxData(0),rxOk : If (rxOk=1) Then gastank = ((rxData(1) / 44) * 100)  ' H5A4 - Gas Tank %
  CAN RX 16,rxData(0),rxOk : ' H348 - ICE
  If (rxOk=1) Then
    flags1=rxdata(0) : flags2=rxdata(1) : Trpm=rxdata(2)*25.6 : TTQH = rxdata(3) : TTQL = rxData(4) : TTQ=TTQH+TTQL/10
  EndIf
  CAN RX 23,rxData(0),rxOk : ' H540 - Shift lever
  If (rxOk=1) Then
    shift = rxData(1)
    If shift=128 Then shift$="P"
    If shift=16 Then shift$ ="D"
    If shift=0 Then shift$="B"
    If shift=64 Then shift$ ="R"
    If shift=32 Then shift$="N"
  EndIf
End Sub

Sub plot
    x = X + 1 : Line(x1,y1)-(x,y) : x1 = x : y1 = y
End Sub

Sub Plotn()
  Dim unit$
  d1 = 0 : p = 0 : pl$ = " "
  If pln=1 Then plotn=current : pl$="current" : plmax=120 : unit$="A": d1=1
  If pln=2 Then plotn=volts : pl$="Volts" : unit$="V" : plmax=300 : d1=1
  If pln=3 Then plotn=Dmax : pl$="DCL" : unitn$="A" : plmax=125 : d1=1
  If pln=4 Then plotn=Cmax : pl$="CCL" : unit$="A" : plmax=125 : d1=1
  If pln=5 Then plotn=icerpm : pl$="ICE RPM" : unit$="rpm" : plmax=5000 : d1=1
  If pln=6 Then plotn=brake : pl$="Brake position" : unit$="%" : plmax=100 : d1=1
  If pln=7 Then plotn=soc : pl$="SoC" : unit$="%" : plmax=100 : d1=1
  If pln=8 Then plotn=throt : pl$="Gas Pedal Pos" : unit$="%" : plmax=100 : d1=1
  If pln=9 Then plotn=ICEkw : pl$="ICE kW" : unit$="kW" : plmax=10 : d1=1
  If pln=10 Then plotn=kph : pl$="KPH" : unit$="kph" : plmax=120 : d1=1
  If pln=12 Then plotn=ECT : pl$="ECT" unit$ ="Deg.C": plmax=100 : d1=1
  If pln=13 Then plotn=BatDegCh : pl$="HV Bat. Deg. C" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=14 Then plotn=MG1t : unit$="C" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=15 Then plotn=MG2t : unit$="C" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=16 Then plotn=INV1t : unit$="C" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=17 Then plotn=INV2t : unit$="C" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=18 Then plotn=ICEtemp : pl$="ICE temperature" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=19 Then plotn=convt : pl$="Conv temperature" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=20 Then plotn=fuelflow : pl$="Fuel Flow" : plmax=20 : unit$="l/min" : d1=1
  If pln=21 Then plotn=VVTi : pl$="VVTI" : plmax=100 : unit$="Deg.C" : d1=1
  If pln=22 Then plotn=gastank : pl$="Gas Tank % " : plmax=100 : unit$="%" : d1=1
  If pln=23 Then plotn=targetpower : pl$="Target Power" : plmax=300 : unit$="NM" : d1=1
  If pln=24 Then plotn=power : pl$="Power" : plmax=300 : unit$="NM" : d1=1
  If pln=25 Then plotn=mg1tq : pl$="MG1TQ" : plmax=300 : unit$="NM" : d1=1
  If pln=26 Then plotn=mg2tq : pl$="MG2TQ" : plmax=300 : unit$="NM" : d1=1
  If pln=27 Then plotn=mg1rpm : pl$="MG1rpm" : plmax=13000 : unit$="rpm" : d1=1
  If pln=28 Then plotn=mg2rpm : pl$="MG2rpm" : plmax=7000 : unit$="rpm" : d1=1
  If pln=29 Then plotn=Cload : pl$="Cload%" : plmax=100 : unit$="%":d1=1
End Sub

Sub updateF7
    pln = pl1 : plotn() : plot1=plotn : unit1$=unit$ : pl1max=plmax : pln=pl2
    plotn() : plot2=plotn : unit2$=unit$ : pl2max=plmax
    y = plot1 / pl1max * -215 + 215 : x1=memx1 : y1=memy1 : plot()
    y = plot2 / pl2max * -215 + 215 : memx1=x1 : memy1=y1
    x1=memx2 : y1=memy2 : x  = x - 1 : plot() : memx2=x1 : memy2=y1 : Font 2
    Print @(10,390)   "        ";   @(10,390) Format$(plot1,"% .0f"); unit1$;
    Print @(10,360)   "          "; @(10,360) Format$(plot2,"% .0f"); Unit2$;
    If X => 258 Then
      BLIT 129,0,0,0,129,430 : Line (128,0)-(258,430),0,BF
      Print @(1,28) "   "; : X = 129 : memx1=129 : memx2=129
      Font 1,2 : Print @(2,5) " PLOT DISPLAY"; : Line(0,0)-(258,430),1,B
      Line(0,216)-(258,216),1 : ' X axis graph line
    EndIf
End Sub

Sub F7
  Dim pl1$ : Dim unit1$ : Dim pl1 : Dim pl1max : unit1$=" " : pl1=0 : pl1max=0
  Dim pl2$ : Dim unit2$ : Dim pl2 : Dim pl2max : unit2$=" " : pl2=0 : pl2max=0
  Dim plotn : Dim plot1 : Dim plot2 : plot1 = 0 : plot2 = 0 : Dim unit$ : unit$=" "
  Local d1 : d1=0 : Dim x1 : Dim y1 : x=0 : y=0 : x1=0 : y1=0 : Dim memx1 : Dim memx2
  Dim memy1 : Dim memy2 : memx1=0 : memx2=0 : memy1=0 : memy2=0
  Cls : GoSub drawlabels_RHS : Font 1,2 : Print @(5,5) "PLOT DISPLAY"; : pl1$=" " : pl2$=" "
  If page = 7 Then
    Cls : Font 1,2 : Print @(5,5) "PLOT DISPLAY";
    Do While d1 = 0
      Print @(20,40) "Enter plot time (minutes)"; : Input period
      If (period => 1) Or (period < 7000) Then d1=1
      Print @(20,40) "                              ";
    Loop
    Font 1 : d1=0 : Print @(20,60) " Period = " period "minutes";
    Print @(20,120) "1 - Current       2 - Volts    3 - DCL         4 - CCL,         5 - ICE rpm"
    Print @(20,140) "6 - Brake pedal%  7 - SoC      8 - gas pedal%  9 - ICE kW,     10 - KPH"
    Print @(20,160) "12 - ECT Deg.C.  13 - HV battery Deg.C. High  14 - MG1 Deg.C."
    Print @(20,180) "15 - MG2 Deg.C.  16 - Inverter 1 temperature  17 - Inverter 2 temperature"
    Print @(20,200) "18 - ICE Deg.C.  19 - Converter temperature   20 - Fuel flow l/min"
    Print @(20,220) "21 - VVTI        22 - Gas Tank %              23 - Taget Power NM"
    Print @(20,240) "24 - Power NM    25 - MG1 Torque NM           26 - MG2 Torque NM"
    Print @(20,260) "27 - MG1 rpm     28 - Mg2 rpm      29 - Calculated Load %"  ""
    Do While d1 = 0
      Print @(20,40) "Enter first plot parameter"; : Input pl1 : D1=1
      Print @(20,40) "                              ";
      Print @(20,80)  pl1 " - " pl1$ " Max/Min on graph +/-" pl1max " " Unit1$ ;
    Loop
    d1 = 0
    Do While d1 = 0
      Print @(20,40) "Enter second plot parameter"; : Input pl2 : D1=1
      Print @(20,40) "                              ";
      Print @(20,100) pl2 " - " pl2$ " Max/Min on graph +/-" pl2max " " Unit2$ ;
    Loop
  EndIf
  Cls : GoSub drawlabels_rhs : Font 1,2 : Print @(5,5) "PLOT DISPLAY"; : Line(0,0)-(258,430),1,B
  Line(0,216)-(258,216),1 : ' X axis graph line
  If page <> 7 Then period = 1 : pl1 = 1 : pl2 = 2
End Sub

Sub F8
  Cls : stop = 0 : Font 2 : n1=0 : n2=0 : n3=0 : n4=0
  Print @(0,0) "FG"; @(45,0) "FG1"; @(90,0) "FG2"; @(135,0) "RPM" @(192,0) "TNM"; @(255,0) "th"
  Print @(293,0) "LOD" @(336,0) "FFL" @(390,0) "HVF" : Font 2 : Print  @(386,370) "ECT: "
  Print @(360,390) "BRAKE: " @(400,410) "EV: " @(440,0) "oC"
End Sub

Sub UpdateF8
    Font 1,2,1 : Print @(0,20) "  " @(0,20) Hex$(flags);
    Print @(45,20) "  "; @(45,20) Hex$(flags1); @(90,20) "  "; @(90,20) Hex$(flags2);
    Print @(135,20) Format$(Trpm,"%04.0f"); @(212,20) Format$(TTQH+TTQL/10,"%03.0f");
    Print @(257,20) Format$(throt,"%02.0f"); @(289,20) Format$(Cload,"%03.0f")
    Print @(334,20) Format$(fuelflow,"%04.1f");
    Print @(410,20) "  " @(410,20) Hex$(HVflags);
    Print @(440,20) Format$(temper,"%02.0f") : Font 2 : Print @(340,370) Format$(temper,"%02.0f")
    Print @(440,370) Format$(ECT,"%03.0f") @(440,390) Format$(BRAKE,"%02.0f")
    Print @(440,410) Format$(EVmode,"%03.0f")
    If K$ = " " Then If stop=1 Then stop=0 Else stop=1
    Font 2 : Print @(10,330) "         " @(10,330) Bin$(HVflags)
    If (HVflags And &B00000001) = 1 Then Print @(10,350) "                     " @(10,350) "X1-ICE Warming Up Req"
    If (HVflags And &B00000010) = 2 Then  Print @(10,350) "                     " @(10,350) "X2-A/C Run Req"
    If (HVflags And &B00000100) = 4 Then  Print @(10,350) "                     " @(10,350) "X4-ICE Stop Inh. Req"
    If (HVflags And &B00001000) = 8 Then Print @(10,350) "                     " @(10,350) "X8-HCAC OBD Req"
    If (HVflags And &B00001111) = 0 Then Print @(10,350) "                      "
    If (HVflags And &B00010000) = 16 Then Print @(10,370) "                     " @(10,370) "1X-HV Bat. Cha. Req"
    If (HVflags And &B00100000) = 32 Then Print @(10,370) "                     " @(10,370) "2X-ICE Idling Req"
    If (HVflags And &B01000000) = 64 Then Print @(10,370) "                     " @(10,370) "4X-ICE Stop Req"
    If (HVflags And &B10000000) = 128 Then Print @(10,370) "                     " @(10,370) "8X-????????    "
    If (HVflags And &B11110000) = 0 Then Print @(10,370) "                     "
    If stop=0 Then
      n3=0
      If flags<>fl Then
        y=20 : Font 1,2,1 : Print @(0,y) "  "; @(0,y) Hex$(flags);
        Print @(45,y) "  "; @(45,y) Hex$(flags1); @(90,y) "  "; @(90,y) Hex$(flags2);
        Print @(135,y) Format$(Trpm,"%04.0f"); @(212,y) Format$(TTQH+TTQL/10,"%03.0f");
        Print @(257,y) Format$(throt,"%02.0f"); @(289,y) Format$(Cload,"%03.0f");
        Print @(334,y) Format$(fuelflow,"%04.1f"); @(410,y) Hex$(HVflags); @(440,y) Format$(temper,"%02.0f");
        BLIT 0,20,0,42,480,282 : n3=1
      EndIf
      If N3=0 Then
        If flags1<>fl1 Then
          y=20 : Font 1,2,1 : Print @(0,y) "  "; @(0,y) Hex$(flags);
          Print @(45,y) "  "; @(45,y) Hex$(flags1); @(90,y) "  "; @(90,y) Hex$(flags2);
          Print @(135,y) Format$(Trpm,"%04.0f"); @(212,y) Format$(TTQH+TTQL/10,"%03.0f");
          Print @(257,y) Format$(throt,"%02.0f"); @(289,y) Format$(Cload,"%03.0f");
          Print @(334,y) Format$(fuelflow,"%04.1f"); @(410,y) Hex$(HVflags); @(440,y) Format$(temper,"%02.0f");
          BLIT 0,20,0,42,480,282 : n3=1
        EndIf
      EndIf
      If n3=0 Then
        If flags2<>fl2 Then
          y=20 : Font 1,2,1 : Print @(0,y) "  "; @(0,y) Hex$(flags);
          Print @(45,y) "  "; @(45,y) Hex$(flags1); @(90,y) "  "; @(90,y) Hex$(flags2);
          Print @(135,y) Format$(Trpm,"%04.0f"); @(212,y) Format$(TTQH+TTQL/10,"%03.0f");
          Print @(257,y) Format$(throt,"%02.0f"); @(289,y) Format$(Cload,"%03.0f");
          Print @(334,y) Format$(fuelflow,"%04.1f"); @(410,y) Hex$(HVflags); @(440,y) Format$(temper,"%02.0f");
          BLIT 0,20,0,42,480,282 : n3=1
        EndIf
      EndIf
      fl = flags : fl1 = flags1 : fl2 = flags2
    EndIf
End Sub

Sub PSD
  GoSub printHeader : GoSub drawlabels_rhs : GoSub drawBoxes : Font 1
  Print @(20,147) "MG2:" @(20,167) "ICE=MG1:"
  Line(15,302)-(143,375),1,B : Font 1 : Print @(20,317) "MG2:"
  Print @(20,337) "ICE:" @(20,357) "MG1:" @(169,235) "ICE" @(110,220) "0 rpm"
  Print @(86,95) "7800 rpm"; @(142,260) "MG2" @(243,360) "MG1"
  Line(150,100)-(150,250) : Line(177,140)-(177,225) : Line(250,100)-(250,350)
  X = 140 : Do While sw=0
    Line(x,225)-(X+2,225) : X=X+5 : If x=>250 Then sw=1
  Loop
  Sw=0 : x=140 : Do While sw=0
    Line(x,100)-(X+2,100) : X=X+5 : If x=>250 Then sw=1
  Loop
End Sub

Sub updatePSD
  Local y1 : Local y2 : Local y3 : Local y4 : Font 2 : y1=memy1 : y2=memy2 : y3=memy3 : y4=memy4
  Line(151,y1)-(177,y2),0 : Line(177,y3)-(249,y4),0
  Print @(70,140) Format$(MG2tq,"%-4.0fNM"); : Font 2 : Print @(70,160) Format$(MG1tq,"%-4.0fNM"); : Font 1
' Font 2 : Print @(20,272)"KPH:" : Font 3 : Print @(70,260) Format$(kph,"%-3.0f");
  Font 2 : Print @(50,310) Format$(MG2rpm,"%-5.0f"); : Font 1 : Print "rpm"
  Font 2 : Print @(50,330) Format$(ICErpm,"%-5.0f"); : Font 1 : Print "rpm"
  Font 2 : Print @(50,350) Format$(MG1rpm,"%-5.0f"); : Font 1 : Print "rpm"
  y1=(((mg2rpm/7800)*-125)+225) : y2=(((ICErpm/7800)*-125)+225)
  Line(151,y1)-(177,y2) : y3=(((ICErpm/7800)*-125)+225) : y4=(((MG1rpm/7800)*-125)+225)
  Line(177,y3)-(249,y4) : X = 140 : sw=0
  Do While sw=0
    Line(x,225)-(X+2,225) : X=X+5 : If x=>250 Then sw=1
  Loop
  Line(177,140)-(177,225)
  memy1=y1 : memy2=y2 : memy3=y3 : memy4=y4
End Sub

Sub UpdateVGATemp
  Font 2 : Print @(150,90) Format$(convt,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,110) Format$(ICEt,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,130) Format$(MG1t,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,150) Format$(MG2t,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,170) Format$(INV1t,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,190) Format$(INV2t,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
 ' Print @(150,210) Format$(intaket1,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,210) Format$(ambient,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,230) Format$(intaket3,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,250) Format$(BatDegCl,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  Print @(150,270) Format$(HVBatIT,"% -2.0f"); : Font 1 : Print "o"; : Font 2 :  Print "C"
  ' Print @(150,310) Format$(Cat1,"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C"
  ' Print @(150,330) Format$(Cat2,"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C"
  Print @(150,290) Format$(EIPT,"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C"
  ' Print @(150,370) Format$(TOWT,"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C"
End Sub

Sub Temp
  GoSub Printheader : GoSub Drawboxes : GoSub Drawlabels_RHS : Font 2 : ' Print @(5,5) "Temperatures Page"
  Print @(10,90)  "CONVERTER:" ; @(10,110) "ENGINE:" @(10,130) "MG1:" ; @(10,150) "MG2:" ;
  Print @(10,170) "INVERTER 1:"; @(10,190) "INVERTER 2:";
  Print @(10,210) "AMBIENT:" ;
  Print @(10,230) "AIR INTAKE:"; @(10,250) "BATTERY LE:"; @(10,270) "HVbatIT:"
  ' Print @(10,310) "CATALYST 1:"; @(10,330) "CATALYST 2:";
  Print @(10,290) "INTAK PORT:";  ' @(10,370) "WATER OUTL:";
End Sub

Sub UpdateVGAtestp1 ' Message 039 - ICE and 03A - MG2
  Font 2
  Print @(123,110) Format$(ICEt,"%-2.0f") @(123,130) "          " @(123,130) Bin$(H039data2)
  Print @(123,150) Format$(VVTi,"%-2.0f") @(110,190) H03Adata0 @(110,210) Power @(110,230) H03Adata0
  Print @(110,250) H03Adata3 @(110,270) H03Adata4 @(110,290) H03Adata5
End Sub

Sub UpdateVGAtestp2
  Font 2 : Print @(160,110) "        " @(160,110) Flags1 @(160,130) "         "  @(160,130) flags2
  Print @(173,150) Format$(Trpm,"%-5.0f") @(173,170) Format$(TTQH,"%-5.0f") @(173,190) Format$(TTQL,"%-5.0f")
  Print @(173,210) Format$(Trpm*25.6,"%-5.0f") @(173,230) Format$(TTQH+TTQL/10,"%-4.0f")
End Sub

Sub UpdateVGAtestp3
  Font 2 : Print @(120,110) "           " : Print @(120,110) flags @(120,130) temper @(120,150) H3C8data2
  Print @(120,170) H3C8data3 @(120,190) fuelflowa @(133,210) Format$(H3C8data2*256/8,"%-4.0f")
End Sub

Sub UpdateVGAtestp4
  Font 2 : Print @(120,110) H520data0 @(120,130) fuelflowb @(120,150) fuelflowc
End Sub

Sub Testp1
  GoSub Printheader : GoSub Drawboxes : GoSub Drawlabels_RHS : Font 2
  Print @(10,90) "&H039 - ICE"; : Font 1 : Print @(10,110) "Data(0)ICE oC:" @(10,130) "Data(1)Flag:"
  Print @(10,150) "Data(2)VVTi:" : Font 2 : Print @(10,170) "&H03A - POWER";: Font 1
  Print @(10,190) "Data(0)0 or 1:" @(10,210) "Data(1)Power:" @(10,230) "Data(2):" @(10,250) "Data(3):" @(10,270) "Data(4):" @(10,290) "Data(5)Volts:";
End Sub

Sub Testp2
  GoSub Clearsubscreen : Font 2 : Print @(10,90) "H348-HV to ICE ECU" : Font 1
  Print @(10,110) "Data(0)Flags1:" @(10,130) "Data(1)Flags2:" @(10,150) "Data(2)Target RPM:";
  Print @(10,170) "Data(3)Target NM:" @(10,190) "Data(4)Target NM:" @(10,210) "Ta.RPM(Data(2)x256/10):" @(10,230) "Ta.NM(Data(3)+Data(4))/10:";
End Sub

Sub Testp3
  GoSub Clearsubscreen : Font 2 : Print @(10,90) "H3C8- ICE to HV ECU" : Font 1
  Print @(10,110) "Data(0)Flags:" @(10,130) "Data(1)Temperature:" @(10,150) "Data(2)ICE RPM:"
  Print @(10,170) "Data(3)??:" @(10,190) "Data(4)FFa:" @(10,210) "Data(2)(rawx256/8):"
End Sub

Sub Testp4
  GoSub Clearsubscreen : Font 2: Print @(10,90) "&H520 - FUEL " : Font 1 : Print @(10,110) "Data(0)168:" @(10,130) "Data(1)Fuelflowb:" @(10,150) "Data(2)Fuelflowc:"
End Sub

Sub Updatewarn
  If warningpage=1 and bms=1 Then
    If (R4=0 And SoC<=73 And warn=0 And SoC<>65) Then
      page=25 : warn=1 : GoSub warningVGA
    EndIf
    If R4=1 Then
      warn=0
      warningpage=0
    EndIf
  EndIf
  font 1
  If page=0 or page=5 or page=6 or page=9 or page=10 or page=11 or page=13 or page=14 or page=15 or page=16 or page=17 or page=18 or page=19 or page=20 or page=21 or page=22 or page=23 or page=25 then
    If Warningpage=1 Then Print @(15,380) "Warning ACTIVE"; Else Print @(15,380) "               ";
  EndIf
End Sub


'''''''''''''
' MAIN Starts here
  Pause 500
  Ky$ = Inkey$
  If Ky$ <> "t" Then
    Cls : LoadBMP "logo.bmp",30,30 : Pause 1000 : GoSub Chconfig : GoSub waitForCanData
  EndIf
  If Ky$="t" then test=1
  GoSub printHeader : GoSub drawlabels_rhs : GoSub drawBoxes : GoSub FindBMS : GoSub setrelays
  bmsvolts = 210 : GoSub inversebyte : ready = 1
  Open "b:AHTMEM.TXT" For input As #10 : Input #10, AHT : Close #10
  Open "b:AHTMEM.TXT" For output As #10
  F11() : pause 100 : Gosub clearsubscreen : GoSub drawlabels_lhs : page=0
  If ForcedEV=1 then
    F12() : pause 50 : F12() : pause 50 : F12() : Gosub Gauge13 : page=13
  Endif
Do
  K$ = Inkey$
  If (K$ = "q") Or (K$="Q")  Then CAN FREE : Cls : Font 2 : Print "        CANPORT CLOSED" : End
  If K$ = Chr$(146)  Then F2() ' Forced EV PHEV battery depleted warning
  If K$ = Chr$(147)  Then F3() ' Toggle page number to navigate through all screen pages
  If K$ = Chr$(145)  Then F1() ' F1 - AUTO EV BUTTON - Pressing F1 toggles between AUTO and MANUAL mode for the EV switch
  If K$ = Chr$(148)  Then F4() ' F4 - PHEV/ORIG BUTTON - Pressing F4 toggles between PHEV and ORIGINAL mode
  If K$ = Chr$(149)  Then page=5 : CHAIN "F5.BAS" ' Press F5 then get x14 HV Battery block voltage values
  If K$ = Chr$(150)  Then page=6 : CHAIN "F6.BAS" ' Press F6 then get x14 HV Battery block internal resistance values
  If K$ = Chr$(151)  Then F7() : page=7 ' graphical display
  If k$ = Chr$(152)  Then F8() : page=8 'HV flags
  If page=9 Then
      If K$ = Chr$(27) And log=1 Then GoSub Endlog
  EndIf
  If K$ = Chr$(153) And log=0 Then page=9 : F9() : log=1 ' DATA LOGGING
  If K$ = Chr$(153) And log=1 Then page=9 : GoSub clearsubscreen
  If K$ = Chr$(154) Then F10()  ' HV FAN AUTO/MANUAL BUTTON - Pressing F10 toggles beteen AUTO and MANUAL mode for HV battery fan
  If K$ = Chr$(155) Then page=11 : F11()  ' If press F11 - then DTC check screen
  If K$ = Chr$(156) Then page=11 : F11() : Pause 50 : F12() ' If press F12 - Clear DTCs
  If K$ = "0" Then fanspeed=0 :  If K$="1" Then fanspeed=1 : If K$="2" Then fanspeed=2 : If K$ = "3" Then fanspeed=3
  If K$ = "4" Then fanspeed=4 : If K$ = "5" Then fanspeed=5 : If K$ = "6" Then fanspeed=6
  If K$ = Chr$(128) Then GoSub bmsvoltsup : GoSub updateBMS ' Press the up arrow key and BMS end volts increases by 5 volts
  If K$ = Chr$(129) Then GoSub bmsvoltsdown : GoSub updateBMS  ' Press the down arrow key and BMS end volts decreases by 5 volts
  If K$ = "s" Then page=15 : GoSub BMSpluslabels ' BMSplus page
  If K$ = "t" Then page=19 : Temp() ' Temperatures page
  If k$ = "p" Then sw=0 : page=14 : PSD() 'Power Split Device
  B1=0 : If K$ = "z" And B1=0 And page<>20 And page<>21 And page<>22 Then page=20 : testp1() : B1=1
  If K$ = "z" And B1=0 And Page=20 Then page=21 : testp2() : B1=1 
  If k$ = "z" And B1=0 And page=21 Then page=22 : testp3() : B1=1
  If k$ = "z" And B1=0 And page=22 Then page=23 : testp4() : B1=1 
  If K$ = Chr$(27) Then
    page=0 : warn=0 : GoSub printHeader : GoSub drawboxes : GoSub drawlabels_lhs : GoSub drawlabels_rhs : UpdateF4()
    counter=counter+1
    If counter=>3 Then AHT=0
  EndIf

  getcandata() : UpdateF4()

  If (page<>8) And (page<>25) Then GoSub UpdateVGA_RHS

  If page=5 Then ' "F5" - HV battery cell voltages
    pidrequest(&H7E3,&H21,&HCE,1) : Filter21CE()
    pidrequest(&H7E3,&H21,&HD0,1) : Filter21D0()  'min/max battery block values
    pidrequest(&H7E3,&H21,&HCF,1) : filter21CF()  'DelatSOC                
    updateF5()
  EndIf

  If page=6 Then ' "F6" - HV battery cell internal resistances
    pidrequest(&H7E3,&H21,&HD0,1) : Filter21D0() : updateF6()
  EndIf

  If page=0 Then
   ' pidrequest(&H7E0,&H21,&H43,0) : filter2143() ' vehicle load
   ' pidrequest(&H7E0,&H1,&H43,0)  : filter0143() ' Absolute load
    pidrequest(&H7E3,&H21,&HCF,1) : filter21CF()  ' HV battery values
    pidrequest(&H7E2,&H21,&HC4,1) : filter21C4()  ' Converter temp & HV flags
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  ' Calculated load
    GoSub updateVGA_LHS
  EndIf

  If page=7 Then ' "F7" - graph page
     pidrequest(&H7E2,&H21,&HC4,1) : filter21C4()  'Converter temp & HV flags
     pidrequest(&H7E0,&H21,&H04,0) : filter2104()  'Calculated load
  '  pidrequest(&H7E0,&H21,&H43,0) : filter2143() 'vehicle load
  '  pidrequest(&H7E0,&H21,&H3D,0) : filter213D()   'cat1
  '  pidrequest(&H7E0,&H21,&H3F,0) : filter213F()   'cat2
    updateF7()
    Font 2 : If HVfan = 0 And (BatDegCh > 25) Then Font 2, ,1 : Print @(280,5) "     "; @(280,5) Format$(BatDegCh,"% g"); : Font 1, ,1 : Print "o"; : Font 2, ,1 : Print "C";
    If HVfan = 0 And (BatDegCh =< 25) Then Font 2 : Print @(280,5) "     "; @(280,5) Format$(BatDegCh,"% g") ; : Font 1 : Print "o"; : Font 2 : Print "C";
    If HVfan = 1 Then Font 2 : Print @(280,5) "     "; @(280,5) Format$(BatDegCh,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  EndIf

  If page=8 Then ' "F8" - HV flags
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  'Calculated load
 '  pidrequest(&H7E0,&H21,&H43,0) : filter2143() 'vehicle load
    pidrequest(&H7E2,&H21,&HC4,1) : filter21C4()  'CONVerter Temp & HV flags
    updateF8() 'Test ICE flags page
  EndIf

  If log=1 Then  ' "F9" - DATA LOGGER
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  'Calculated load
    pidrequest(&H7E0,&H21,&HCD,1) : filter21CD()  'Tank outlet water temp
    pidrequest(&H7E2,&H21,&HC4,1) : filter21C4()  'CONVerter Temp & HV flags
 '  pidrequest(&H7E3,&H21,&HCF,1) : filter21CF()  'HV battery values
 '  pidrequest(&H7E0,&H21,&H3D,0) : filter213D()   'cat1
 '  pidrequest(&H7E0,&H21,&H3F,0) : filter213F()   'cat2
    Updatef9() : UpdateF4()
  EndIf

  If page=13 Then 
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  ' Calculated load
    Gosub Updategauge13
  Endif

  If page=14 Then ' "P" - PSD page
  ' pidrequest(&H7E2,&H21,&HC4,1) : filter21C4() 'CONVerter Temp & HV flags
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  'Calculated load
    updatePSD()
  EndIf

  If page=19 Then ' "T" - Temperature page
    pidrequest(&H7E2,&H21,&HC4,1) : filter21C4()  'CONVerter Temp & HV flags
    pidrequest(&H7E0,&H21,&HCD,1) : filter21CD()  'Tank outlet water temp
  ' pidrequest(&H7E0,&H21,&H3D,0) : filter213D()   'cat1
  ' pidrequest(&H7E0,&H21,&H3F,0) : filter213F()   'cat2
    updateVGATemp()
  EndIf

  If page=15 Then GoSub UpdateBMSplus  ' "s" - BMSplusH555 page

  If page=16 Then 
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  ' Calculated load
    Gosub Updategauge16
  Endif

  If page=17 Then 
    pidrequest(&H7E3,&H21,&HCE,1) : Filter21CE()
    Gosub Updategauge17
  Endif

  pidrequest(&H7E2,&H21,&HC3,1) : filter21C3()  'MG1 and MG2

'  Font 2 : Print @(60,350) Format$(AHf,"%-6.0f")

  GoSub Firstscanready : GoSub Priusreadysignal : GoSub Updatestatus : GoSub updatehvfan : UpdateF4()

  If page=20 Then UpdateVGAtestp1()  ' "z" - Test page 1
  If page=21 Then UpdateVGAtestp2()  ' "z" - Test page 2
  If page=22 Then UpdateVGAtestp3()  ' "z" - Test page 3
  If page=23 Then UpdateVGAtestp4()  ' "z" - Test page 4

  If page=25 Then
    pidrequest(&H7E3,&H21,&HCF,1) : filter21CF()  ' HV battery values
    pidrequest(&H7E2,&H21,&HC4,1) : filter21C4()  ' Converter temp & HV flags
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  ' Calculated load
  EndIf

'  If ForcedEV=1 And ready=1 And SoC=65 Then Pin(15)=0 : Pause 10 : Pin(15)=1 : R1=1 : Pause 500  ' Exit EVmode if ForcedEV is true

  updateWarn()

  If HVfan=1 Then stepper=stepper + 1 : If stepper > 100 Then fanspeed=6 : stepper=0
  If (looper=3) Then GoSub updateBMS : updateF10() 'HV battery fan speed
  Font 2 : Print @(260,404) looper; : looper = looper + 1
  ' UpdateF2()
  UpdateF3() : UpdateF1() : UpdateF4()

  If looper => 10 Then
   looper=0 : counter=0
  EndIf

Loop

' END OF MAIN PROGRAM

' START OF NON USER DEFINED SUBROUTINES BELOW:

Chconfig:
  CAN CONFIG ok : CAN SETSPEED 500000, ok : CAN ADDTXCHNL 0,1,ok
  CAN ADDRXCHNL 1,&h3C8,0,1,ok : CAN ADDRXCHNL 2,&h03B,0,1,ok ' Passive PIDs
  CAN ADDRXCHNL 3,&h244,0,1,ok : CAN ADDRXCHNL 4,&h030,0,1,ok
  CAN ADDRXCHNL 5,&h0B4,0,1,ok : CAN ADDRXCHNL 6,&h038,0,1,ok
  CAN ADDRXCHNL 7,&h520,0,1,ok : CAN ADDRXCHNL 8,&h3CB,0,1,ok
  CAN ADDRXCHNL 9,&h555,0,1,ok : CAN ADDRXCHNL 10,&h03A,0,1,ok
  CAN ADDRXCHNL 11,&h3CA,0,1,ok : CAN ADDRXCHNL 12,&h3CF,0,1,ok
  CAN ADDRXCHNL 13,&h039,0,1,ok : CAN ADDRXCHNL 14,&h526,0,1,ok
  CAN ADDRXCHNL 15,&h5A4,0,1,ok : CAN ADDRXCHNL 16,&H348,0,1,ok
  CAN ADDRXCHNL 17,&H529,0,1,ok : CAN ADDRXCHNL 18,&h52C,0,1,ok
  CAN ADDRXCHNL 19,&H7E8,0,1,ok  'tx&H7E0 to rx&H7E8 F11 - GET DTC codes ' Active PIDs
  CAN ADDRXCHNL 20,&H7E9,0,10,ok 'tx&H7E1 to rx&H7E9
  CAN ADDRXCHNL 21,&H7EA,0,10,ok 'tx&H7E2 to rx&H7EA
  CAN ADDRXCHNL 22,&H7EB,0,10,ok 'tx&H7E3 to rx&H7EB
  CAN ADDRXCHNL 23,&H540,0,1,ok
  CAN ENABLE ok : Cls :  Font 2 : CAN PRINTCONFIG : Pause 3000
Return

Updatestatus:
  If evMode=0 And icerpm=0 And kph=0 And forcedev=0 Then ev$ = "          "
  If evMode=64 And forcedev=0 Then ev$="    EV    "
  If flags2=&H60 Or flags2=&H62 Or flags2=&H70 Then ev$=" ICErun   "
  If flags=&H06 Then ev$=" Warm up  "
  If icerpm<1000 And icerpm>100 Then ev$=" ICEspin  "
  If evMode=128 Then ev$=" EVdenied "
  If evMode<>64 And flags2=&H01 And forcedev=0 Then ev$=" STEALTH  "
  If forcedev=1 Then ev$="FORCED EV "
  If page<>7 And page<>8 And page<>25 Then Font 1 : Print @(190,380) "    " @(190,380) evMode @(152,408) "          " @(152,408) ev$
Return

Updatehvfan:
  If page<>7 And page<>8 And page<>25 Then
    Font 2 : If HVfan = 0 And (BatDegCh > 25) Then Font 2, ,1 : Print @(172,53) "     "; @(172,53) Format$(BatDegCh,"% g"); : Font 1, ,1 : Print "o"; : Font 2, ,1 : Print "C";
    If HVfan = 0 And (BatDegCh =< 25) Then Font 2 : Print @(172,53) "     "; @(172,53) Format$(BatDegCh,"% g") ; : Font 1 : Print "o"; : Font 2 : Print "C";
    If HVfan = 1 Then Font 2 : Print @(172,53) "     "; @(172,53) Format$(BatDegCh,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  EndIf
Return

UpdateBMS:
  Local inLoop : Font 1 
  If R4=0 Then GoSub SendPHEV
  If R4=1 Then GoSub SendORIG
  inLoop = 0
  Do
    If bms=1 Then
      If page<>7 And page<>8 And page<>25 Then
        If R4=1 Then Print @(16,28) "BMS MODE : ORIG @" bmsvolts ; : Print @(141,28)  " V "; : Exit Sub
        If R4=0 Then Print @(16,28) "BMS MODE : AUTO @" bmsvolts ; : Print @(141,28) " V "; : Exit Sub
      EndIf
    EndIf
  inLoop = inLoop + 1 : If inLoop > 5 Then Exit Sub
  Loop
Return

SendPHEV:  ' 195v - 235v
  Local txData(8) : Local txOk : GoSub inversebyte
  txData(0) = bmsvolts : txData(1) = voltsbms : ' Inverse of bmsvolts
  CAN TX 0,&H556,0,8,txData(0),txOk
  If txOk = 0 Then Print @(16,28)"Could not send PHEV 556 @"; bmsvolts;" V to BMS+"
Return

SendORIG:  ' 238v
  Local txData(3) : Local txOk : txData(0) = &HEE : txData(1) = &H11
  txData(2) = &H00 : CAN TX 0,&H556,0,3,txData(0),txOk : bmsvolts = 238 : GoSub inversebyte
  Print @(16,28) "BMS MODE: ORIGINAL" bmsvolts " V";
  If txOk = 0 Then Print @(16,28)"Could not send ORIG 556 @"; bmsvolts;" V to BMS+"
Return

bmsvoltsdown:
  bmsvolts = bmsvolts - 5
  If (bmsvolts < 195) Then bmsvolts = 195
  GoSub inversebyte
Return

bmsvoltsup:
  bmsvolts = bmsvolts + 5
  If (bmsvolts > 235) Then bmsvolts = 235
  GoSub inversebyte
Return

setrelays:
  ' R2 = 0
  R3 = 0 : SetPin 15,9 : SetPin 16,9 : SetPin 17,9 : SetPin 18,9 : Pin(15)=1
  Pin(16) = 1 : Pin(17) = 1 : Pin(18) = 1 : Pause 1000 : Pin(18) = R4
Return

Firstscanready:
  If running=1 And ready=0 Then
    Write #10, AHT : Close #10 : running=0
  EndIf
  If ready=1 Then
    running=1 : Exit Sub
  EndIf
  GoSub waitforCanData
  R1=0 : Cls : Run "autorun.bas"
Return

Priusreadysignal:
  Local rxData(8) : Local rxOk : Local inLoop : inLoop = 0
  Do
    CAN RX 6,rxData(0),rxOk : ' H038 Ready Signal
    If (rxOk = 1) And (rxData(0) = 192) Then
      If Page<>7 And Page<>8 And Page<>25 Then
        Font 1 : Print @(78,50) "READY"; : Print @(76,70) rxData(0)
      EndIf
      ready = 1 : Pin(18) = R4 : Exit Sub
    EndIf
    If (rxOk = 1) And rxData(0) < 192 Then
      Font 1 : Print @(78,50) "     "; : ready = 0
      Pin(15)=1 : Pin(16)=1 : Pin(17)=1 : Pin(18)=1 : Exit Sub
    EndIf
    inLoop = inLoop + 1 : If inLoop > 5 Then Exit Sub
  Loop
Return

waitForCanData:
  Local rxData(8) : Local rxOk
  Do
    CAN RX 1,rxData(0),rxOk : If rxOk=1 Then Exit Sub
  Loop
Return

findBMS:
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  If (BMS=0 And page<>7 And page<>8 And page<>25) Then Font 1 : Print @(16,28) "No BMS+ installation found";
  Do
    CAN RX 9,rxData(0),rxOk
    If (rxOk=1) And (page<>7) And (page<>8) And (page<>25) Then
      Print @(16,28) "BMS MODE : AUTO @" bmsvolts  @(141,28) " V           "; : Exit Sub
    EndIf
    looper = looper + 1
    If looper > 5 Then Exit Sub
  Loop
Return

clearsubscreen:   ' Clear portion of screen
  Font 2
  Print @(0, 90)  "                    "; @(0, 110) "                    ";  @(0, 130) "                    "; @(0, 150) "                    ";
  Print @(0, 170) "                    "; @(0, 190) "                    "; @(0, 210) "                    "; @(0, 230) "                    ";
  Print @(0, 250) "                    "; @(0, 270) "                    "; @(0, 290) "                    "; @(0, 310) "                    ";
  Print @(0, 330) "                    "; @(0, 350) "                    "; @(0, 370) "                    ";
Return

BMSpluslabels:
  GoSub PrintHeader : GoSub drawlabels_RHS : GoSub drawboxes : Font 1
  Print @(20,100) "The BMS+ modifies H3CB and H3CD"; @(20,120) "and message H555 data is below:"
  Print @(20,144) "H555-Data(0) Original DCL : "; : Print @(20,164) "H555-Data(1) Original CCL : "
  Print @(20,184) "H555-Data(2) Original SoC : "; : Print @(20,204) "H555-Data(3) Original Bth : "
  Print @(20,224) "H555-Data(4) Original Btl : "; : Print @(20,244) "H555-Data(5) Original DTC : "
  Print @(20,264) "H555-Data(6) Original DTC : "; : Print @(20,284) "H555-Data(7)    Allways 1 : "
  Print @(20,304) "Original Batt. Temp. High : "; : Print @(20,324) "Original Batt. Temp. Low  : ";
  Print @(97,344) "Original DTC : ";
Return

UpdateBMSplus:
  Local rxData(8) : Local rxOk
  CAN RX 9,rxData(0),rxOk
  If (rxOk=1) Then
    Font 2 : Print @(180,140) Format$(rxData(0),"% -4.0f") " A" @(180,160) Format$(rxData(1),"% -4.0f") " A" ;
    Print @(180,180) Format$(rxData(2)/2,"% -3.0f") " %" ;
    Print @(180,200) Format$(rxData(3),"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C";
    Print @(180,220) Format$(rxData(4),"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C";
    Print @(180,240) Format$(rxData(5),"% -2.0f") @(180,260) Format$(rxData(6),"% -2.0f");
    Print @(180,280) Format$(rxData(7),"% -2.0f") @(180,300) Format$(rxData(3),"% -2.0f");
    Font 1 : Print "o"; : Font 2 : Print "C" @(180,320) Format$(rxData(4),"% -2.0f");
    Font 1 : Print "o"; : Font 2 : Print "C"; @(195,340) Format$(rxData(5),"%02.0f") Format$(rxData(6),"%02.0f");
  EndIf
Return

drawBoxes:
  Mode 1,7 : Font 1 : Print @(35,400) "F1"; @(20,415) "EV AUTO";
  Line(15,395)-(66,428),1,B : Print @(100,400) "F4"; @(93,415) "   "; : Line(80,395)-(131,428),1,B
  Line(145,395)-(217,428),1,B : Line(15,45)-(66,77),1,B : Print @(32,50) "F12"; : Print @(20,65) "CLR DTC";
  Line(115,45)-(170,77),1,B : Print @(132,50) "F10  "; @(120,65) "FAN AUTO";
Return

printHeader:
  Cls : Font 2 : Print @(15,0) "DUINOMITE-CANVIEW V4/BMS+ PRIUS G2";
Return

drawlabels_rhs:
  Font 2 : Print @(280,35)  "Volts:"  @(293,70)  "Amps:" @(280,106) "A-MAX:" @(280,142) "A+MAX:";
  If page=14 Then Print @(294,182) "Load:" Else Print @(306,182) "RPM:"
  Print @(268,218) "BRAKE%:" @(292,256) "SOC%:" @(266,290) "THROT%:";
  Print @(268,328) "ICE KW:"
  If ((page=<7 or page=>9) and page<25 and page<>0) Then Print @(307,363) " AH: "; Else Print @(307,363) "KPH:"
  Print @(307,398) "ECT:";
Return

drawlabels_lhs:
  Font 2
 ' Print @(10,90) "DRq:"  @(150,90) "PRq:"
  Print @(10,90) "TPr:" @(10,110) "APr:"; @(10,130) "MG1:" @(10,150)  "MG2:"
  Print @(10,170) "TRB:" @(10,190) "RB :" @(10,210) "MCT:"
  Print @(10,230) "Cld:"   '@(10,230) "Ald:"
  Print @(10,250) "Fue:" @(10,270) "VVT:"
  Print @(10,290) "Gas:"
  Print @(10,310) "aux:";
  Print @(10,330) "Did:";
 ' Print @(10,350) "HVf:";
  Line(120,240)-(280,285),1,B : Print @(125,260) "AH:";
' Print @(140,250) "HVc:"  @(140,270) "HVd:" ' Print @(10,370) "HVVMF:";
Return

updateVGA_RHS:
  Font 3 : Print @(360,26) Format$(volts,"% -3.0f");
  Print @(360,62) Format$(current,"%+-5.0f");
  Print @(360,96)  Format$(Dmax,"% -4.0f"); : Print @(360,132) Format$(Cmax,"% -4.0f");
  If page=14 Then Print @(360,172) Format$(Cload,"% -2.0f"); Else Print @(360,172) Format$(icerpm,"% -5.0f");
  Print @(360,210) Format$(brake,"% -3.0f");
  Print @(360,246) Format$(soc,"% -3.0f"); : Print @(360,280) Format$(throt,"% -3.0f");
  Print @(360,316) Format$(ICEkw,"% -3.0f");
  If ((page=<7 or page=>9) and page<25 and page<>0) Then Print @(360,352) Format$(AHT,"%04.1f"); Else Print @(360,352) Format$(kph,"% -3.0f");
  Print @(360,390) Format$(ect,"% -3.0f"); : Font 2 : Print "o"; : Font 2 : Print "C";
  If page<>7 And page<>8 And page<>25 Then Font 2, ,1 : Print @(230,404) shift$
Return

updateVGA_LHS:
  Font 2 : ' Print @(60,90)  Format$(Disreq,"%-5.0fW") : Print @(200,90) Format$(PowReq,"%-5.0fW");
  Print @(60,90) Format$(targetPower,"%-4.0fNM") @(60,110) Format$(power,"%-4.0fNM");
  Print @(60,130) Format$(MG1TQ,"%-4.0fNM") @(60,150) Format$(MG2TQ,"%-4.0fNM");
  Print @(150,130) Format$(MG1rpm,"%-6.0frpm") @(150,150) Format$(MG2rpm,"%-6.0frpm");
  Print @(60,170) Format$(TRB,"%-4.0fNM") @(60,190) Format$(RB,"%-4.0fNM");
  Print @(60,210) Format$(MCT,"%-4.0fNM") @(60,230) Format$(Cload,"%-3.0f") "%";  ' Print @(60,230) Format$(Aload,"%-8.0f"); "%";
  Print @(60,250) Format$(fuelflow,"%-3.1f")
  Print @(60,270) Format$(VVTi,"%-3.0f"); @(60,290) Format$(gastank,"%-2.0f")"%"; @(150,290) Format$(TTQ,"%-4.0fNM");
  Print @(60,310) Format$(auxbat,"%-4.1fv");
  Print @(60,330) Format$(Drivecond,"%-2.0f");
  Font 3 : Print @(170,247) Format$(AHT,"%04.1f"); : Font 2
 ' @(190,250) Format$(HVcharge,"%-2.0fkW")
 ' Print @(190,270) Format$(HVdischarge,"%-2.0fkW"); @(90,370) Format$(HVVMF,"% -6.2fv"); ; ' HVDelta
Return

inversebyte:
  If bmsvolts = &HC3 Then voltsbms = &H3C   'PHEV mode 195v
  If bmsvolts = &HC8 Then voltsbms = &H8C   'PHEV mode 200v
  If bmsvolts = &HCD Then voltsbms = &HDC   'PHEV mode 205v
  If bmsvolts = &HD2 Then voltsbms = &H2D   'PHEV mode 210v
  If bmsvolts = &H7D Then voltsbms = &HD7   'PHEV mode 215v
  If bmsvolts = &HDC Then voltsbms = &HCD   'PHEV mode 220v
  If bmsvolts = &HE1 Then voltsbms = &H1E   'PHEV mode 225v
  If bmsvolts = &HE6 Then voltsbms = &H6E   'PHEV mode 230v
  If bmsvolts = &HEB Then voltsbms = &HBE   'PHEV mode 235v
  If bmsvolts = &HEE Then voltsbms = &HEE   'Original mode 238v
Return

Endlog:
  Close #1 : Close #2 : Close #3 : Close #4 : Close #5 : Font 2 : Print @(20,200) "               "; @(20,280)"END OF DATA LOG" : Pause 2000
  page=30 : log=0 : Font 2 : Print @(273,385) " ";
Return

WarningVGA:
  If warn=1 Then
    Cls : Font 2,2,1 : Print @(80,150) "!! WARNING !!"
    Font 2,1,0 : Print @(100,250) "PHEV battery pack depleted"
    Print @(100,300) "Press F4 and then ESC to exit"
  EndIf
Return

Gauge13:
  Gosub clearsubscreen
  Line(19,139)-(51,341),1,B : Line(59,139)-(91,341),1,B
  Line(99,139)-(131,341),1,B : Line(139,139)-(171,341),1,B
  Line(179,139)-(211,341),1,B : Line(219,139)-(251,341),1,B
  Font 1 : Print @(10,95) "GAUGE13";
Return

Gauge16:
  Gosub clearsubscreen
  Line(19,139)-(51,341),1,B : Line(59,139)-(91,341),1,B
  Line(99,139)-(131,341),1,B : Line(139,139)-(171,341),1,B
  Line(179,139)-(211,341),1,B : Line(219,139)-(251,341),1,B
  Font 1 : Print @(10,95) "GAUGE16";
Return

Gauge17:
  Gosub clearsubscreen
  Line(19,139)-(31,341),1,B : Line(34,139)-(46,341),1,B
  Line(49,139)-(61,341),1,B : Line(64,139)-(76,341),1,B
  Line(79,139)-(91,341),1,B : Line(94,139)-(106,341),1,B
  Line(109,139)-(121,341),1,B : Line(124,139)-(136,341),1,B
  Line(139,139)-(151,341),1,B : Line(154,139)-(166,341),1,B
  Line(169,139)-(181,341),1,B : Line(184,139)-(196,341),1,B
  Line(199,139)-(211,341),1,B : Line(214,139)-(226,341),1,B
  Font 1,2 : Print @(20,100) "OEM NiMH CELLS"; 
  Font 1 : Print @(235,276) "13.2v"; @(235,194) "17.3v";
  Print @(25,350) "1" @(113,350) "7" @(217,350) "14";  
  If test=1 then hvb1=10 : hvb2=10 : hvb3=10 : hvb4=10 : hvb5=10 : hvb6=10 : hvb7=10 : hvb8=10 : hvb9=10 : hvb10=10 : hvb11=10 : hvb12=10 : hvb13=10 : hvb14=10
Return

Gauge18:
  Gosub clearsubscreen
  Font 1,2 : Print @(10,95) "GAUGE18"; 
Return


Updategauge13:
  
  If test=1 then 
    throt=throt+1   : If throt=>100 then throt=0
    cload=cload+1   : If cload=>100 then cload=0
    battkw=battkw+1 : If battkw=>40 then battkw=-40
    icekw=icekw+1   : If icekw=>100 then icekw=0
    nettkw=nettkw+1 : If nettkw=>100 then nettkw=-100
    kph=kph+10      : If kph=>120 then kph=0   
  Endif

  Font 1 : Print @(20,360) "Throt"; "%"; @(60,360) "Load";"%"; 
  Print @(100,360) "Batt" ; "KW"; @(140,360) "ICE";"kw";
  Print @(180,360) "NETT"; "kw"; @(220,360) "kph";

  Font 1,2 : Print @(10,115) Format$(throt,"% -3.0f"); @(50,115) Format$(cload,"% -3.0f");
  Print @(90,115) Format$(battkw,"% -3.0f"); @(130,115) Format$(icekw,"% -3.0f");
  Print @(180,115) Format$(nettkw,"% -3.0f"); @(220,115) Format$(kph,"% -3.0f");

  Line(20,140)-(50,340),0,BF   : Line(60,140)-(90,340),0,BF   :  Line(100,140)-(130,340),0,BF
  Line(140,140)-(170,340),0,BF : Line(180,140)-(210,340),0,BF :  Line(220,140)-(250,340),0,BF

  Line(100,240)-(130,240) : Line(180,240)-(210,240)

  Line(20,340-(throt*2))-(50,340),1,BF 

  Line(60,340-(cload*2))-(90,340),1,BF

  If battkw>0 then Line(100,240-((battkw/40)*100))-(130,240),1,BF
  If battkw<0 then Line(100,240)-(130,240+((battkw/-40)*100)),1,BF 

  Line(140,340-(icekw/100*200))-(170,340),1,BF

  If nettkw>0 then Line(180,240-((nettkw/100)*100))-(210,240),1,BF
  If nettkw<0 then Line(180,240)-(210,240+((nettkw/-100)*100)),1,BF

  Line(220,340-((kph/120)*200))-(250,340),1,BF

Return


Updategauge16:
  
  If test=1 then 
    throt=throt+1     : If throt=>100 then throt=0
    cload=cload+1     : If cload=>100 then cload=0
    battkw=battkw+1   : If battkw=>40 then battkw=-40
    icekw=icekw+1     : If icekw=>100 then icekw=0
    mg1tq=mg1tq+10    : If mg1tq=>500 then mg1tq=-500
    mg1rpm=mg1rpm+100 : If mg1rpm=>13000 then mg1rpm=-13000
    mg2tq=mg2tq+10    : If mg2tq=>500 then mg2tq=-500
    mg2rpm=mg2rpm+100 : If mg2rpm=>8000 then mg2rpm=-8000
  Endif

  Font 1 : Print @(20,360) "Throt"; "%"; @(60,360) "Load";"%";
  Print @(100,360) "Batt" ; "KW"; @(140,360) "ICE";"kw";
  Print @(180,360) "MG1"; : ' Print @(180,360) "MG1"; "RPM";
  Print @(220,360) "MG2"; : ' Print @(220,360) "MG2";

  Font 1,2 : Print @(10,115) Format$(throt,"% -3.0f"); @(50,115) Format$(cload,"% -3.0f");
  Print @(90,115) Format$(battkw,"% -3.0f"); @(130,115) Format$(icekw,"% -3.0f");
  Font 1 : Print @(170,100) Format$(mg1tq,"% -4.0fNM"); @(170,115) Format$(mg1rpm,"% -6.0f");
  Print @(210,100) Format$(mg2tq,"% -4.0fNM"); @(210,115) Format$(mg2rpm,"% -6.0fRPM");

  Line(20,140)-(50,340),0,BF   : Line(60,140)-(90,340),0,BF   : Line(100,140)-(130,340),0,BF
  Line(140,140)-(170,340),0,BF : Line(180,140)-(195,340),0,BF : Line(195,140)-(210,340),0,BF
  Line(220,140)-(235,340),0,BF : Line(235,140)-(250,340),0,BF 

  Line(100,240)-(130,240) : Line(180,240)-(195,240) : Line(195,240)-(210,240)
  Line(220,240)-(235,240) : Line(235,240)-(250,240)

  Line(20,340-(throt*2))-(50,340),1,BF 

  Line(60,340-(cload*2))-(90,340),1,BF

  If battkw>0 then Line(100,240-((battkw/40)*100))-(130,240),1,BF
  If battkw<0 then Line(100,240)-(130,240+((battkw/-40)*100)),1,BF
  
  Line(140,340-(icekw/100*200))-(170,340),1,BF

  If mg1tq>0 then Line(180,240-((mg1tq/500)*100))-(195,240),1,BF
  If mg1tq<0 then Line(180,240)-(195,240+((mg1tq/-500)*100)),1,BF

  If mg1rpm>0 then Line(195,240-((mg1rpm/13000)*100))-(210,240),1,BF
  If mg1rpm<0 then Line(195,240)-(210,240+((mg1rpm/-13000)*100)),1,BF

  If mg2tq>0 then Line(220,240-((mg2tq/500)*100))-(235,240),1,BF
  If mg2tq<0 then Line(220,240)-(235,240+((mg2tq/-500)*100)),1,BF

  If mg2rpm>0 then Line(235,240-((mg2rpm/8000)*100))-(250,240),1,BF
  If mg2rpm<0 then Line(235,240)-(250,240+((mg2rpm/-8000)*100)),1,BF

Return


Updategauge17:
  
  If test=1 then 
    hvb1=hvb1+1   : If hvb1=>20 then hvb1=10 
    hvb2=hvb2+1   : If hvb2=>20 then hvb2=10
    hvb3=hvb3+1   : If hvb3=>20 then hvb3=10 
    hvb4=hvb4+1   : If hvb4=>20 then hvb4=10
    hvb5=hvb5+1   : If hvb5=>20 then hvb5=10
    hvb6=hvb6+1   : If hvb6=>20 then hvb6=10
    hvb7=hvb7+1   : If hvb7=>20 then hvb7=10
    hvb8=hvb8+1   : If hvb8=>20 then hvb8=10
    hvb9=hvb9+1   : If hvb9=>20 then hvb9=10
    hvb10=hvb10+1 : If hvb10=>20 then hvb10=10
    hvb11=hvb11+1 : If hvb11=>20 then hvb11=10
    hvb12=hvb12+1 : If hvb12=>20 then hvb12=10
    hvb13=hvb13+1 : If hvb13=>20 then hvb13=10
    hvb14=hvb14+1 : If hvb14=>20 then hvb14=10
  Endif

  Line(20,140)-(30,340),0,BF   : Line(35,140)-(45,340),0,BF   : Line(50,140)-(60,340),0,BF 
  Line(65,140)-(75,340),0,BF   : Line(80,140)-(90,340),0,BF   : Line(95,140)-(105,340),0,BF 
  Line(110,140)-(120,340),0,BF : Line(125,140)-(135,340),0,BF : Line(140,140)-(150,340),0,BF 
  Line(155,140)-(165,340),0,BF : Line(170,140)-(180,340),0,BF : Line(185,140)-(195,340),0,BF
  Line(200,140)-(210,340),0,BF : Line(215,140)-(225,340),0,BF

  Line(20,340-((hvb1-10)*20))-(30,340),1,BF    : Line(35,340-((hvb2-10)*20))-(45,340),1,BF 
  Line(50,340-((hvb3-10)*20))-(60,340),1,BF    : Line(65,340-((hvb4-10)*20))-(75,340),1,BF
  Line(80,340-((hvb5-10)*20))-(90,340),1,BF    : Line(95,340-((hvb6-10)*20))-(105,340),1,BF
  Line(110,340-((hvb7-10)*20))-(120,340),1,BF  : Line(125,340-((hvb8-10)*20))-(135,340),1,BF
  Line(140,340-((hvb9-10)*20))-(150,340),1,BF  : Line(155,340-((hvb10-10)*20))-(165,340),1,BF 
  Line(170,340-((hvb11-10)*20))-(180,340),1,BF : Line(185,340-((hvb12-10)*20))-(195,340),1,BF 
  Line(200,340-((hvb13-10)*20))-(210,340),1,BF : Line(215,340-((hvb14-10)*20))-(225,340),1,BF

  Line(15,276)-(230,276)-1   ' Lo volt line
  Line(15,194)-(230,194)-1   ' hi volt line

Return 
  
  