'F6.BAS

  ' DISCLAIMER - USE AT OWN RISK

' START OF USER DEFINED SUBROUTINES BELOW:

Sub UpdateF9  'DATA LOGGING
  If Timer => (timermem+500) Then
    Font 2 : Print @(273,385) " ";
    If page=9 Then Font 2 : Print @(20,200) "               ";
  EndIf
  If Timer => (timermem+1000) Then
    If page=9 Then Font 2 : Print @(20,200) "DATA LOG ACTIVE";: Print @(20,260) "PRESS ESC TO END";
    Font 2 : Print @(273,385) "*";
    Write #1,Timer/1000,current,AHT,Dmax,Cmax,volts,soc,Trpm,icerpm,TTQ,throt,brake,kph,HVflags,VVTi,Cload,HVcharge,HVdischarge,HVVMF,auxbat,Drivecond
    Write #2,Timer/1000,HVDelta,MG1rpm,MG2rpm,MG1TQ,MG2TQ,targetpower,power,PowReq,DisReq,trb,rb,mct,gastank,Trpm,shift,shift$,evMode,EV$,dimmer
    Write #3,Timer/1000,H3C8data2,H3C8data3,H520data0,H039data1,H039data2,H03Adata0,H03Adata3,H03Adata4,H03Adata5,TTQH,TTQL,flags,flags1,flags2,fuelflowa,fuelflowb,fuelflowc,fuelflow
    Write #4,Timer/1000,ambient,ect,EIPT,MG1t,MG2t,INV1t,INV2t,temper,convt,HVBatIT,intaket1,intaket3,ICEt,BatDegCl,BatDegCh
    Write #5,Timer/1000,HVAB,HVBB,Scw,Rpr,Acp,HVlt,HVit,HVth,HVht,HVpi,HVpo,ICEkw,battkw,nettkw
    timermem=Timer
  EndIf
End Sub

' -------------------- NON-STANDARD SUBS FOR CHAIN FILES-------------------------

Sub Filter21D0 '- HV battery cell internal resistances @ &H7E3 - &H7EB
  Local D3 : Local D4 : Local D5 : Local looper : D3=0 : D4=0 : D5=0 : looper=0
  Local rxData(8) : Local rxOk : Local rxId : Local rxType : Local rxLen : Local mem
  Do
    CAN RX 22,rxId,rxType,rxLen,rxData(0),rxOk 'CHANNEL 22 - tx&H7E3 to rx&H7EB
    If rxok=1 Then
      If rxData(0)=&H10 Then
        HVLT=(256*rxData(5))+rxData(6) : mem=rxData(7)
      EndIf
      If rxData(0) = &H21 Then
        HVIT=(256*mem)+rxData(1)
        HVTH=(256*rxData(2))+rxData(3)
        HVHT=(256*rxData(4))+rxData(5)
        HVBL=(2.56*rxData(6))+(0.01*rxData(7))-327.68
      EndIf
      If D3=0 And (rxData(0) = &H22) Then
        D3=1 : IR1 = 0.001 * rxData(5) : IR2 = 0.001 * rxData(6) : IR3 = 0.001 * rxData(7)
        HVBH=(2.56*rxData(2))+(0.01*rxData(3))-327.68 : HVBD=HVBH-HVBL
      EndIf
      If D4=0 And (rxData(0) = &H23) Then
        D4=1 : IR4 = 0.001 * rxData(1) : IR5 = 0.001 * rxData(2) : IR6 = 0.001 * rxData(3)
        IR7 = 0.001 * rxData(4) : IR8 = 0.001 * rxData(5) : IR9 = 0.001 * rxData(6)
        IR10 = 0.001 * rxData(7)
      EndIf
      If D5=0 And (rxData(0) = &H24) Then
        D5=1 : IR11 = 0.001 * rxData(1) : IR12 = 0.001 * rxData(2) : IR13 = 0.001 * rxData(3)
        IR14 = 0.001 * rxData(4)
      EndIf
      IRT = IR1+IR2+IR3+IR4+IR5+IR6+IR7+IR8+IR9+IR10+IR11+IR12+IR13+IR14
    EndIf
   ' If (D3=1) And (D4=1) And (D5=1) Then Exit Sub
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

'----------------------------------------------------------------------------------------

Sub filter2104 ' - &H7E0 - &H7E8
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxOk=1 Then
      If rxData(0)=&H3 And rxData(1)=&H61 And rxData(2)=&H4 Then
        Cload=rxdata(3)*0.3906
          If Cload=>99 Then Cload=99
        Exit Sub
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter21CD '- &H7E0 - &H7E8
  Local rxData(8) : Local rxOk
  Local looper : looper=0
  Do
    CAN RX 19,rxData(0),rxOk 'CHANNEL 19 - tx&H7E0 to rx&H7E8
    If rxok = 1 Then
'     If rxData(0)=&H10 And rxData(1)=&H14 And rxdata(2)=&H61 Then
      If rxData(0)=&H21 Then EIPT=rxData(6)-40
      If rxData(0)=&H22 Then TOWT=rxData(1)-40
    EndIf
  looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter21C4 '- &H7E2 - &H7EA - PERM
  Local rxData(8) : Local rxOk
  Local looper : looper=0
  Do
    CAN RX 21,rxData(0),rxOk 'CHANNEL 21 - tx&H7E2 to rx&H7EA
    If rxok = 1 Then
      If rxData(0)=&H10 And rxData(1)=&H11 And rxdata(2)=&H61 And rxdata(3)=&HC4 Then
        HVflags=rxData(5)
        HVBB=2*rxData(7)
      EndIf
      If rxData(0)=&H21 Then
        convt=(rxData(2)-50)
        HVAB=2*rxData(1)
      EndIf
      If rxData(0)=&H23 Then
        Scw=0.019608*rxData(1)
        Rpr=0.392*rxData(4)
        Acp=0.019608*rxdata(5)
      EndIf
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub filter21C3 '- &H7E2 - &H7EA
  Local rxData(8) : Local rxOk
  Local looper : looper = 0 : Local D2 : Local D3 : Local D4 : Local D5
  Local MEM : D2 = 0 : D3=0 : D4=0 : D5=0
  Do
    CAN RX 21,rxData(0),rxOk 'CHANNEL 21 - tx&H7E2 to rx&H7EA
    If rxOk = 1 Then
      If rxData(0)=&H10 And rxData(1)=&H27 And rxData(2)=&H61 And rxData(3)=&HC3 Then
        MG2TQ = (32*rxData(6))+(0.125*rxData(7))-500
        MG2rpm=((256*rxData(4))+rxData(5))-16383 : D2=1
      EndIf
      If rxData(0)=&H21 Then
        TRB=4.000*rxData(2) : RB=4.000*rxData(1) : MG1rpm=((rxData(3)*256)+rxData(4))-16383 : D3=1
        MG1TQ=(32*rxData(5))+(0.125*rxData(6))-500 : PowReq=(2560.000*rxData(7))+10.000*MEM
      EndIf
      If (rxData(0) = &H22) Then
        MEM=rxData(1) : MCT=(4.000*rxData(7))-512
      EndIf
      If (rxData(0) = &H23) Then
        INV1t=rxData(7)-50 : DisReq=rxData(4) : Drivecond=rxdata(6) : D4=1
        HVPI=rxData(3)-40800
        HVPO=rxData(2)*320
      EndIf
      If (rxData(0) = &H24) Then
        INV2t=rxData(1)-50 : MG1t=rxData(2)-50 : MG2t=rxData(3)-50
        Volts=rxData(4)*2.000 : current=((rxData(5)+(rxData(6)*2))-256)*-1 : BattKW=volts*current/1000
        Nettkw = icekw - battkw
        If log=0 Then
          AHf=Timer : Timer=0
        EndIf
        If log=1 Then
          AHf=Timer-timer1 : timer1=Timer
        EndIf
        If AHf=0 Then AHf=1000    'Prevents divide by zero overflow error
        AH=(current*-1)/(3600*(1000/AHf)) : AHT=AHT+AH
        If AHT=>100 Then AHT=0
      EndIf
    '  If D2=1 And D3=1 And D4=1 And D5=1 Then Exit Sub
    EndIf
    looper = looper + 1 : If looper > 6 Then Exit Sub
  Loop
End Sub

Sub pidrequest(header, mode, pid, more)
  Local txData(8) : Local txok : Local txId : txId = header
  txData(3) = 0 : txData(4) = 0 : txData(5) = 0 : txData(6) = 0 : txData(7) = 0
  txData(0) = &H2 : txData(1) = mode : txData(2) = pid
  CAN TX 0,txId,0,8,txData(0),txOk : Pause 10
  If more = 1 Then
    txData(0)=&H30 : txData(1)=0 : txData(2)=0 : CAN TX 0,txId,0,8,txData(0),txOk
  EndIf
End Sub

Sub F1
  If R1 = 0 Then R1 = 1 Else R1 = 0
  If page<>7 And page<>8 And page<>25 Then
    If R1 = 1 Then Font 1 : Print @(20,415) "EV MAN ";
    If R1 = 0 Then Font 1 : Print @(20,415) "EV AUTO";
  EndIf
End Sub

Sub F2
  ' If R2 = 0 Then R2 = 1 Else R2 = 0
  If Warningpage=1 Then Warningpage=0 Else Warningpage=1
  Font 1
  If page<>7 or page<>8 Then
    If Warningpage=1 Then Print @(15,380) "Warning ACTIVE"; Else Print @(15,380) "               ";
  EndIf
End Sub

Sub F3
  ' If R3 = 0 Then R3 = 1 Else R3 = 0   'Used for Enginer Kit
  page=page+1
  If page=1 then page=5
  If page=5 then CHAIN "F5.BAS"
'  If page=6 then F6()
  If page=7 then page=13
  If page=13 then Gosub Gauge13
  If page=14 then PSD()
  If page=15 then GoSub BMSpluslabels
  If page=16 then Gosub Gauge16
  If page=17 then Gosub Gauge17
  If page=18 then Gosub Gauge18
  If page=19 then Temp()
  If page=>20 then page=5 : F5()
  If page<1 then page=1
End Sub

Sub F4
  If R4=0 Then R4=1 Else R4=0
  Pin(18) = R4
  If R4=1 Then
    Font 1
    GoSub SendORIG
      If page<>7 And page<>8 And page<>25 Then
        Print @(93,415) "ORIG";
      EndIf
  EndIf
  If R4=0 Then
    Font 1
    bmsvolts = 210
    GoSub SendPHEV
    Pause 500
    If page<>7 And page <> 8 And page<>25 Then
      Print @(93,415) "PHEV";
    EndIf
  EndIf
End Sub

Sub F6
  GoSub printheader : GoSub drawboxes : GoSub drawlabels_RHS
  Font 1,2 : Print @(10,95) "OEM NiMH CELL OHMS"; : Font 1
  Print @(10,137)  "R1:"; @(130,137) "R2:"; @(10,157)  "R3:";
  Print @(130,157) "R4:"; @(10,177)  "R5:"; @(130,177) "R6:";
  Print @(10,197)  "R7:"; @(130,197) "R8:"; @(10,217)  "R9:";
  Print @(130,217) "R10:"; @(10,237)  "R11:"; @(130,237) "R12:";
  Print @(10,257)  "R13:"; @(130,257) "R14:"; @(10,277) "TOTAL:";
  Print @(10,297)  "HVBATTLOW:" 
  Print @(10,317)  "DCINHIBIT:"
  Print @(10,337)  "HVBATTHIGH:"
  Print @(10,357)  "HVTEMPHIGH:"
End Sub

Sub UpdateF4
  If R4=1 Then
    Font 1
    If page<>7 And page<>8 And page<>25 Then Print @(93,415) "ORIG";
  EndIf
  If R4=0 Then
    Font 1
    If page<>7 And page<>8 And page<>25 Then Print @(93,415) "PHEV";
  EndIf
End Sub

Sub updateF6
  Font 2
  Print @(35,130)  "       "; @(35,130) Format$(IR1,"%g")  ; ""; @(155,130) "       "; @(155,130) Format$(IR2,"%g") ; "";
  Print @(35,150)  "       "; @(35,150) Format$(IR3,"%g")  ; ""; @(155,150) "       "; @(155,150) Format$(IR4,"%g") ; "";
  Print @(35,170)  "       "; @(35,170) Format$(IR5,"%g")  ; ""; @(155,170) "       "; @(155,170) Format$(IR6,"%g") ; "";
  Print @(35,190)  "       "; @(35,190) Format$(IR7,"%g")  ; ""; @(155,190) "       "; @(155,190) Format$(IR8,"%g") ; "";
  Print @(35,210)  "       "; @(35,210) Format$(IR9,"%g")  ; ""; @(155,210) "       "; @(155,210) Format$(IR10,"%g"); "";
  Print @(35,230)  "       "; @(35,230) Format$(IR11,"%g") ; ""; @(155,230) "       "; @(155,230) Format$(IR12,"%g"); "";
  Print @(35,250)  "       "; @(35,250) Format$(IR13,"%g") ; ""; @(155,250) "       "; @(155,250) Format$(IR14,"%g"); "";
  Print @(80,270)  "       "; @(80,270)  Format$(IRT,"%g") ; " ohms";
  Print @(80,290)  Format$(HVLT,"%4.0f") ;  " Sec";
  Print @(80,310)  Format$(HVIT,"%4.0f") ;  " Sec";
  Print @(80,330)  Format$(HVTH,"%4.0f") ;  " Sec";
  Print @(80,350)  Format$(HVHT,"%4.0f") ;  " Sec";
End Sub

Sub F10
  If HVfan = 0 Then HVfan = 1 Else HVfan = 0 ' HVfan = 1 - MANUAL MODE = 0 - AUTO MODE
End Sub

Sub UpdateF10
    Local rxData(8) : Local rxOk : Local rxId : rxId = &H7EB : Local rxLen
    Local txData(8) : Local txOk : Local inLoop : inLoop=0 : Local rxType
    txData(0)=&H4 : txData(1)=&H30 : txData(2)=&H81 : txData(3)=6
    txData(4)=fanspeed : txData(5)=0 : txData(6)=0 : txData(7)=0
    If HVfan = 1 Then
      CAN TX 0,&H7E3,0,8,txData(0),txOk ' HV FAN MANUAL MODE
      If (txOk=1) Then
        Do
          CAN RX 22,rxId,rxType,rxLen,rxData(0),rxOk 'CHA22 - tx&H7E3 to &H7EB
          If (rxOK=1) And (Page<>7) And (Page<>8) And (Page<>25) Then
            If (rxData(0) = &H2) And (rxData(1) = &H70) Then
              Font 1 : Print @(120,65) "HV FAN";fanspeed : Exit Sub
            EndIf
          EndIf
          inLoop = inLoop + 1 : If inLoop > 10 Then Exit Sub
        Loop
      EndIf
    EndIf
    If HVfan = 0 Then
      If page<>7 And page<>8 And page<>25 Then Font 1 : Print @(120,65) "FAN AUTO";
      If (BatDegCh > 25) Then
        txData(4) = 6 : CAN TX 0,&H7E3,0,8,txData(0),txOk ' HV FAN AUTO MODE
        If txOk = 1 Then
          Do
            CAN RX 22,RxData(8),rxOk 'CHANNEL 22 - tx&H7E3 to rx&H7EB
            If (rxOK = 1) Then
              If (rxData(0) = &H2 And rxData(1) = &H70) Then Exit Sub
            EndIf
            inLoop = inLoop + 1 : If inLoop > 10 Then Exit Sub
          Loop
        EndIf
      EndIf
    EndIf
End Sub

Sub UpdateF1()
  Local rxData(8) : Local rxOk : Local loops
  If forcedev = 1 Then Exit Sub
  If R1=0 Then
    Do
      CAN RX 17,rxData(0),rxOk
      If rxOK=1 Then
        evMode = rxData(4)
        If (ForcedEV=0 And evMode<>64 And R1=0 And kph<45 And soc>40 And ready=1 And flags<>6) Then
          Pin(15) = 0 : Pause 10 : Pin(15) = 1 : Exit Sub
        EndIf
      EndIf
      loops = loops + 1 : If loops > 1 Then Exit Sub
    Loop
  EndIf
End Sub

Function getS12(hi, lo)
  If (hi >= &B1000) Then getS12 = (lo + ((hi - &B10000) * 256)) * -1
  If (hi <  &B1000) Then getS12 = ((hi * 256) + lo) * -1
End Function

Function getU16(hi, lo)
  getU16 = (hi*256) + lo
End Function

Sub getCanData
  Local rxData(8) : Local rxOk : BMS=0
  CAN RX 18,rxData(0),rxOk : If (rxOk=1) Then ect = rxData(1) / 2  ' H52C
  CAN RX 1,rxData(0),rxOk : ' H3C8 - ICE
  If (rxOk=1) Then
     icerpm = (getU16(rxData(2), rxData(3)))/8
     fuelflowa = rxData(4)
     flags = rxData(0) : temper = rxData(1) : H3C8data3 = rxData(3) : H3C8data2 = rxdata(2)
  EndIf
 ' CAN RX 2,rxData(0),rxOk : ' H03B - HV current/volts
 ' If (rxOk=1) Then
 '   current = (getS12(rxData(0),rxData(1)))/10 : ' volts=(getU16(rxData(2),rxData(3)))
 ' EndIf
  CAN RX 3,rxData(0),rxOk : If (rxOk=1) Then throt = (rxData(6)/2)
  If throt > 99 Then throt = 99
  CAN RX 4,rxData(0),rxOk : If (rxOk=1) Then brake = (rxData(4)*100)/128
  CAN RX 5,rxData(0),rxOk : If (rxOk=1) Then kph = (getU16(rxData(5), rxData(6))*10)/1024
  CAN RX 6,rxData(0),rxOk : If (rxOk=1) Then ICEkw = rxData(1) * 0.25
  CAN RX 7,rxData(0),rxOk
  If (rxOk=1) Then   'H520 fuel flow
    H520data0 = rxData(0)
    fuelflowb = rxData(1)
    fuelflowc = rxData(2)
    fuelflow = fuelflowa * fuelflowc * 0.001 * fuelflowb
  EndIf
  CAN RX 8,rxData(0),rxOk : ' H3CB - HV battery
  If (rxOk=1) Then
    Dmax = rxData(0) * -1 : Cmax = rxData(1) : soc = (getU16(rxData(2), rxData(3)))/2
    BatDegCl = rxData(5) : BatDegCh = rxData(4)
  EndIf
  CAN RX 9,rxData(0),rxOk : ' H555 - BMSplus
  If (rxOk=1) Then BMS=1 Else BMS=0
  SocORIG = rxData(0) : CCLORIG = rxData(1) : DCLORIG = rXData(2)
  BMS0 = rxData(3) : BMS1 = rxData(4) : BMS2 = rxData(5) : BMS3 = rxData(6) : BMS4 = rxData(7)
  CAN RX 10,rxData(0),rxOk : ' H03A - Actual power
  If (rxOk=1) Then
    Power = rxdata(1)*4
    If power > 900 Then power = power - 1028
    H03Adata0 = rxData(0) : H03Adata2 = rxData(2)
    H03Adata3 = rxdata(3) : H03Adata4 = rxdata(4) : H03Adata5 = rxdata(5)
  EndIf
  CAN RX 11,rxData(0),rxOk : ' H3CA - Target power
  If (rxOk=1) Then
    ' If rxData(1) =>256 Then targetPower = (((rxdata(1) + 256)) - 32)*2
    ' If rxData(1) < 256 Then
    targetPower = (rxData(1) - 32)*2
  EndIf
  CAN RX 12,rxData(0),rxOk :  If (rxOk=1) Then intaket1=rxData(0) : ambient=rxData(1) : intaket3=rxData(2) ' H3CF
  CAN RX 13,rxData(0),rxOk
  If (rxOk=1) Then
    ICEt=rxData(0) : H039data1=rxData(1) : H039data2=rxData(2)
  EndIf
  CAN RX 14,rxData(0),rxOk : If (rxOk=1) Then VVTi=rxData(1)
  CAN RX 15,rxData(0),rxOk : If (rxOk=1) Then gastank = ((rxData(1) / 44) * 100)  ' H5A4 - Gas Tank %
  CAN RX 16,rxData(0),rxOk : ' H348 - ICE
  If (rxOk=1) Then
    flags1=rxdata(0) : flags2=rxdata(1) : Trpm=rxdata(2)*25.6 : TTQH = rxdata(3) : TTQL = rxData(4) : TTQ=TTQH+TTQL/10
  EndIf
  CAN RX 23,rxData(0),rxOk : ' H540 - Shift lever
  If (rxOk=1) Then
    shift = rxData(1)
    If shift=128 Then shift$="P"
    If shift=16 Then shift$ ="D"
    If shift=0 Then shift$="B"
    If shift=64 Then shift$ ="R"
    If shift=32 Then shift$="N"
  EndIf
End Sub

Sub Updatewarn
  If warningpage=1 and bms=1 Then
    If (R4=0 And SoC<=73 And warn=0 And SoC<>65) Then
      page=25 : warn=1 : GoSub warningVGA
    EndIf
    If R4=1 Then
      warn=0
      warningpage=0
    EndIf
  EndIf
  font 1
  If page=0 or page=5 or page=6 or page=9 or page=10 or page=11 or page=13 or page=14 or page=15 or page=16 or page=17 or page=18 or page=19 or page=20 or page=21 or page=22 or page=23 or page=25 then
    If Warningpage=1 Then Print @(15,380) "Warning ACTIVE"; Else Print @(15,380) "               ";
  EndIf
End Sub


'''''''''''''
' MAIN Starts here
  page=6  ' CHAIN "F6"
  F6()
Do
  K$ = Inkey$
  If (K$ = "q") Or (K$="Q")  Then CAN FREE : Cls : Font 2 : Print "        CANPORT CLOSED" : End
  If K$ = Chr$(146)  Then F2() ' Forced EV PHEV battery depleted warning
  If K$ = Chr$(147)  Then F3() ' Toggle page number to navigate through all screen pages
  If K$ = Chr$(145)  Then F1() ' F1 - AUTO EV BUTTON - Pressing F1 toggles between AUTO and MANUAL mode for the EV switch
  If K$ = Chr$(148)  Then F4() ' F4 - PHEV/ORIG BUTTON - Pressing F4 toggles between PHEV and ORIGINAL mode
  If K$ = Chr$(149)  Then page=5 : CHAIN "F5.BAS" ' Press F5 then get x14 HV Battery block voltage values
 ' If K$ = Chr$(150)  Then page=6 : CHAIN "F6.BAS" ' Press F6 then get x14 HV Battery block internal resistance values
  If K$ = Chr$(151)  Then F7() : page=7 ' graphical display
  If k$ = Chr$(152)  Then F8() : page=8 'HV flags
  If page=9 Then
      If K$ = Chr$(27) And log=1 Then GoSub Endlog
  EndIf
  If K$ = Chr$(153) And log=0 Then page=9 : F9() : log=1 ' DATA LOGGING
  If K$ = Chr$(153) And log=1 Then page=9 : GoSub clearsubscreen
  If K$ = Chr$(154) Then F10()  ' HV FAN AUTO/MANUAL BUTTON - Pressing F10 toggles beteen AUTO and MANUAL mode for HV battery fan
  If K$ = Chr$(155) Then page=11 : F11()  ' If press F11 - then DTC check screen
  If K$ = Chr$(156) Then page=11 : F11() : Pause 50 : F12() ' If press F12 - Clear DTCs
  If K$ = "0" Then fanspeed=0 :  If K$="1" Then fanspeed=1 : If K$="2" Then fanspeed=2 : If K$ = "3" Then fanspeed=3
  If K$ = "4" Then fanspeed=4 : If K$ = "5" Then fanspeed=5 : If K$ = "6" Then fanspeed=6
  If K$ = Chr$(128) Then GoSub bmsvoltsup : GoSub updateBMS ' Press the up arrow key and BMS end volts increases by 5 volts
  If K$ = Chr$(129) Then GoSub bmsvoltsdown : GoSub updateBMS  ' Press the down arrow key and BMS end volts decreases by 5 volts
  If K$ = "s" Then page=15 : GoSub BMSpluslabels ' BMSplus page
  If K$ = "t" Then page=19 : Temp() ' Temperatures page
  If k$ = "p" Then sw=0 : page=14 : PSD() 'Power Split Device
  B1=0 : If K$ = "z" And B1=0 And page<>20 And page<>21 And page<>22 Then page=20 : testp1() : B1=1
  If K$ = "z" And B1=0 And Page=20 Then page=21 : testp2() : B1=1 
  If k$ = "z" And B1=0 And page=21 Then page=22 : testp3() : B1=1
  If k$ = "z" And B1=0 And page=22 Then page=23 : testp4() : B1=1 
  If K$ = Chr$(27) Then
    page=0 : warn=0 : GoSub printHeader : GoSub drawboxes : GoSub drawlabels_lhs : GoSub drawlabels_rhs : UpdateF4()
    counter=counter+1
    If counter=>3 Then AHT=0
  EndIf

  getcandata() : UpdateF4() : GoSub UpdateVGA_RHS

  If page=6 Then ' "F6" - HV battery cell internal resistances
    pidrequest(&H7E3,&H21,&HD0,1) : Filter21D0() : updateF6()
  EndIf

  If log=1 Then  ' "F9" - DATA LOGGER
    pidrequest(&H7E0,&H21,&H04,0) : filter2104()  'Calculated load
    pidrequest(&H7E0,&H21,&HCD,1) : filter21CD()  'Tank outlet water temp
    pidrequest(&H7E2,&H21,&HC4,1) : filter21C4()  'CONVerter Temp & HV flags
    Updatef9() : UpdateF4()
  EndIf

  pidrequest(&H7E2,&H21,&HC3,1) : filter21C3()  'MG1 and MG2

  GoSub Firstscanready : GoSub Priusreadysignal : GoSub Updatestatus : GoSub updatehvfan : UpdateF4() : UpdateF1()

  updateWarn()

  If HVfan=1 Then stepper=stepper + 1 : If stepper > 100 Then fanspeed=6 : stepper=0
  If (looper=3) Then GoSub updateBMS : updateF10() 'HV battery fan speed
  Font 2 : Print @(260,404) looper; : looper = looper + 1

  If looper => 10 Then
   looper=0 : counter=0
  EndIf

Loop

' END OF MAIN PROGRAM

' START OF NON USER DEFINED SUBROUTINES BELOW:

Updatestatus:
  If evMode=0 And icerpm=0 And kph=0 And forcedev=0 Then ev$ = "          "
  If evMode=64 And forcedev=0 Then ev$="    EV    "
  If flags2=&H60 Or flags2=&H62 Or flags2=&H70 Then ev$=" ICErun   "
  If flags=&H06 Then ev$=" Warm up  "
  If icerpm<1000 And icerpm>100 Then ev$=" ICEspin  "
  If evMode=128 Then ev$=" EVdenied "
  If evMode<>64 And flags2=&H01 And forcedev=0 Then ev$=" STEALTH  "
  If forcedev=1 Then ev$="FORCED EV "
  If page<>7 And page<>8 And page<>25 Then Font 1 : Print @(190,380) "    " @(190,380) evMode @(152,408) "          " @(152,408) ev$
Return

Updatehvfan:
  If page<>7 And page<>8 And page<>25 Then
    Font 2 : If HVfan = 0 And (BatDegCh > 25) Then Font 2, ,1 : Print @(172,53) "     "; @(172,53) Format$(BatDegCh,"% g"); : Font 1, ,1 : Print "o"; : Font 2, ,1 : Print "C";
    If HVfan = 0 And (BatDegCh =< 25) Then Font 2 : Print @(172,53) "     "; @(172,53) Format$(BatDegCh,"% g") ; : Font 1 : Print "o"; : Font 2 : Print "C";
    If HVfan = 1 Then Font 2 : Print @(172,53) "     "; @(172,53) Format$(BatDegCh,"% g"); : Font 1 : Print "o"; : Font 2 : Print "C";
  EndIf
Return

UpdateBMS:
  Local inLoop : Font 1 
  If R4=0 Then GoSub SendPHEV
  If R4=1 Then GoSub SendORIG
  inLoop = 0
  Do
    If bms=1 Then
      If page<>7 And page<>8 And page<>25 Then
        If R4=1 Then Print @(16,28) "BMS MODE : ORIG @" bmsvolts ; : Print @(141,28)  " V "; : Exit Sub
        If R4=0 Then Print @(16,28) "BMS MODE : AUTO @" bmsvolts ; : Print @(141,28) " V "; : Exit Sub
      EndIf
    EndIf
  inLoop = inLoop + 1 : If inLoop > 5 Then Exit Sub
  Loop
Return

SendPHEV:  ' 195v - 235v
  Local txData(8) : Local txOk : GoSub inversebyte
  txData(0) = bmsvolts : txData(1) = voltsbms : ' Inverse of bmsvolts
  CAN TX 0,&H556,0,8,txData(0),txOk
  If txOk = 0 Then Print @(16,28)"Could not send PHEV 556 @"; bmsvolts;" V to BMS+"
Return

SendORIG:  ' 238v
  Local txData(3) : Local txOk : txData(0) = &HEE : txData(1) = &H11
  txData(2) = &H00 : CAN TX 0,&H556,0,3,txData(0),txOk : bmsvolts = 238 : GoSub inversebyte
  Print @(16,28) "BMS MODE: ORIGINAL" bmsvolts " V";
  If txOk = 0 Then Print @(16,28)"Could not send ORIG 556 @"; bmsvolts;" V to BMS+"
Return

bmsvoltsdown:
  bmsvolts = bmsvolts - 5
  If (bmsvolts < 195) Then bmsvolts = 195
  GoSub inversebyte
Return

bmsvoltsup:
  bmsvolts = bmsvolts + 5
  If (bmsvolts > 235) Then bmsvolts = 235
  GoSub inversebyte
Return

setrelays:
  ' R2 = 0
  R3 = 0 : SetPin 15,9 : SetPin 16,9 : SetPin 17,9 : SetPin 18,9 : Pin(15)=1
  Pin(16) = 1 : Pin(17) = 1 : Pin(18) = 1 : Pause 1000 : Pin(18) = R4
Return

Firstscanready:
  If running=1 And ready=0 Then
    Write #10, AHT : Close #10 : running=0
  EndIf
  If ready=1 Then
    running=1 : Exit Sub
  EndIf
  GoSub waitforCanData
  R1=0 : Cls : Run "autorun.bas"
Return

Priusreadysignal:
  Local rxData(8) : Local rxOk : Local inLoop : inLoop = 0
  Do
    CAN RX 6,rxData(0),rxOk : ' H038 Ready Signal
    If (rxOk = 1) And (rxData(0) = 192) Then
      If Page<>7 And Page<>8 And Page<>25 Then
        Font 1 : Print @(78,50) "READY"; : Print @(76,70) rxData(0)
      EndIf
      ready = 1 : Pin(18) = R4 : Exit Sub
    EndIf
    If (rxOk = 1) And rxData(0) < 192 Then
      Font 1 : Print @(78,50) "     "; : ready = 0
      Pin(15)=1 : Pin(16)=1 : Pin(17)=1 : Pin(18)=1 : Exit Sub
    EndIf
    inLoop = inLoop + 1 : If inLoop > 5 Then Exit Sub
  Loop
Return

waitForCanData:
  Local rxData(8) : Local rxOk
  Do
    CAN RX 1,rxData(0),rxOk : If rxOk=1 Then Exit Sub
  Loop
Return

findBMS:
  Local rxData(8) : Local rxOk : Local looper : looper = 0
  If (BMS=0 And page<>7 And page<>8 And page<>25) Then Font 1 : Print @(16,28) "No BMS+ installation found";
  Do
    CAN RX 9,rxData(0),rxOk
    If (rxOk=1) And (page<>7) And (page<>8) And (page<>25) Then
      Print @(16,28) "BMS MODE : AUTO @" bmsvolts  @(141,28) " V           "; : Exit Sub
    EndIf
    looper = looper + 1
    If looper > 5 Then Exit Sub
  Loop
Return

clearsubscreen:   ' Clear portion of screen
  Font 2
  Print @(0, 90)  "                    "; @(0, 110) "                    ";  @(0, 130) "                    "; @(0, 150) "                    ";
  Print @(0, 170) "                    "; @(0, 190) "                    "; @(0, 210) "                    "; @(0, 230) "                    ";
  Print @(0, 250) "                    "; @(0, 270) "                    "; @(0, 290) "                    "; @(0, 310) "                    ";
  Print @(0, 330) "                    "; @(0, 350) "                    "; @(0, 370) "                    ";
Return

BMSpluslabels:
  GoSub PrintHeader : GoSub drawlabels_RHS : GoSub drawboxes : Font 1
  Print @(20,100) "The BMS+ modifies H3CB and H3CD"; @(20,120) "and message H555 data is below:"
  Print @(20,144) "H555-Data(0) Original DCL : "; : Print @(20,164) "H555-Data(1) Original CCL : "
  Print @(20,184) "H555-Data(2) Original SoC : "; : Print @(20,204) "H555-Data(3) Original Bth : "
  Print @(20,224) "H555-Data(4) Original Btl : "; : Print @(20,244) "H555-Data(5) Original DTC : "
  Print @(20,264) "H555-Data(6) Original DTC : "; : Print @(20,284) "H555-Data(7)    Allways 1 : "
  Print @(20,304) "Original Batt. Temp. High : "; : Print @(20,324) "Original Batt. Temp. Low  : ";
  Print @(97,344) "Original DTC : ";
Return

UpdateBMSplus:
  Local rxData(8) : Local rxOk
  CAN RX 9,rxData(0),rxOk
  If (rxOk=1) Then
    Font 2 : Print @(180,140) Format$(rxData(0),"% -4.0f") " A" @(180,160) Format$(rxData(1),"% -4.0f") " A" ;
    Print @(180,180) Format$(rxData(2)/2,"% -3.0f") " %" ;
    Print @(180,200) Format$(rxData(3),"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C";
    Print @(180,220) Format$(rxData(4),"% -2.0f"); : Font 1 : Print "o"; : Font 2 : Print "C";
    Print @(180,240) Format$(rxData(5),"% -2.0f") @(180,260) Format$(rxData(6),"% -2.0f");
    Print @(180,280) Format$(rxData(7),"% -2.0f") @(180,300) Format$(rxData(3),"% -2.0f");
    Font 1 : Print "o"; : Font 2 : Print "C" @(180,320) Format$(rxData(4),"% -2.0f");
    Font 1 : Print "o"; : Font 2 : Print "C"; @(195,340) Format$(rxData(5),"%02.0f") Format$(rxData(6),"%02.0f");
  EndIf
Return

drawBoxes:
  Mode 1,7 : Font 1 : Print @(35,400) "F1"; @(20,415) "EV AUTO";
  Line(15,395)-(66,428),1,B : Print @(100,400) "F4"; @(93,415) "   "; : Line(80,395)-(131,428),1,B
  Line(145,395)-(217,428),1,B : Line(15,45)-(66,77),1,B : Print @(32,50) "F12"; : Print @(20,65) "CLR DTC";
  Line(115,45)-(170,77),1,B : Print @(132,50) "F10  "; @(120,65) "FAN AUTO";
Return

printHeader:
  Cls : Font 2 : Print @(15,0) "DUINOMITE-CANVIEW V4/BMS+ PRIUS G2";
Return

drawlabels_rhs:
  Font 2 : Print @(280,35)  "Volts:"  @(293,70)  "Amps:" @(280,106) "A-MAX:" @(280,142) "A+MAX:";
  If page=14 Then Print @(294,182) "Load:" Else Print @(306,182) "RPM:"
  Print @(268,218) "BRAKE%:" @(292,256) "SOC%:" @(266,290) "THROT%:";
  Print @(268,328) "ICE KW:"
  If ((page=<7 or page=>9) and page<25 and page<>0) Then Print @(307,363) " AH: "; Else Print @(307,363) "KPH:"
  Print @(307,398) "ECT:";
Return

updateVGA_RHS:
  Font 3 : Print @(360,26) Format$(volts,"% -3.0f");
  Print @(360,62) Format$(current,"%+-5.0f");
  Print @(360,96)  Format$(Dmax,"% -4.0f"); : Print @(360,132) Format$(Cmax,"% -4.0f");
  If page=14 Then Print @(360,172) Format$(Cload,"% -2.0f"); Else Print @(360,172) Format$(icerpm,"% -5.0f");
  Print @(360,210) Format$(brake,"% -3.0f");
  Print @(360,246) Format$(soc,"% -3.0f"); : Print @(360,280) Format$(throt,"% -3.0f");
  Print @(360,316) Format$(ICEkw,"% -3.0f");
  If ((page=<7 or page=>9) and page<25 and page<>0) Then Print @(360,352) Format$(AHT,"%04.1f"); Else Print @(360,352) Format$(kph,"% -3.0f");
  Print @(360,390) Format$(ect,"% -3.0f"); : Font 2 : Print "o"; : Font 2 : Print "C";
  If page<>7 And page<>8 And page<>25 Then Font 2, ,1 : Print @(230,404) shift$
Return

inversebyte:
  If bmsvolts = &HC3 Then voltsbms = &H3C   'PHEV mode 195v
  If bmsvolts = &HC8 Then voltsbms = &H8C   'PHEV mode 200v
  If bmsvolts = &HCD Then voltsbms = &HDC   'PHEV mode 205v
  If bmsvolts = &HD2 Then voltsbms = &H2D   'PHEV mode 210v
  If bmsvolts = &H7D Then voltsbms = &HD7   'PHEV mode 215v
  If bmsvolts = &HDC Then voltsbms = &HCD   'PHEV mode 220v
  If bmsvolts = &HE1 Then voltsbms = &H1E   'PHEV mode 225v
  If bmsvolts = &HE6 Then voltsbms = &H6E   'PHEV mode 230v
  If bmsvolts = &HEB Then voltsbms = &HBE   'PHEV mode 235v
  If bmsvolts = &HEE Then voltsbms = &HEE   'Original mode 238v
Return

Endlog:
  Close #1 : Close #2 : Close #3 : Close #4 : Close #5 : Font 2 : Print @(20,200) "               "; @(20,280)"END OF DATA LOG" : Pause 2000
  page=30 : log=0 : Font 2 : Print @(273,385) " ";
Return

WarningVGA:
  If warn=1 Then
    Cls : Font 2,2,1 : Print @(80,150) "!! WARNING !!"
    Font 2,1,0 : Print @(100,250) "PHEV battery pack depleted"
    Print @(100,300) "Press F4 and then ESC to exit"
  EndIf
Return
