' File: Libx
' Requires >= 4.7b30 firmware
' Checks for DST on reset and updates RTC time/date if found
' Version 1.0b
'

Sub MM.STARTUP
BackLight 30
RTC GETTIME
Print "<EMBEDDED BASIC LAPTOP>"
End Sub


'Option explicit
'Dim CK_DST
Print "CHECKING FOR AUTO DST UPDATE ..."
'
CK_DST = DST_TODAY()
If CK_DST =  1 Then Print "TODAY IS DST - TIME HAS BEEN CHANGED!"
If CK_DST = -1 Then Print "NO TIME CHANGE"
Print
'End

Function DST_TODAY()
Local A$, B$, C$, D$
Local MONTH
'CHECK DST FILE (DSTDATES.DAT) IF TODAY IS DAYLIGHT SAVING TIME (SPRING FORWARD OR FALL BACK)
A$ = DST_DATE$()
'Print A$
If A$ = "-1" Then
DST_STATUS_F()
Print "DST NOT FOUND TODAY!"
DST_TODAY = -1
Exit Function
End If
B$ = DST_READ_S$()
'Print B$
If (B$ = "-1") Then
Print "DST STATUS FILE IS MISSING"
DST_TODAY = -1
Exit Function
End If
If (B$ = "TRUE") Then
Print "DST HAS ALREADY BEEN UPDATED TODAY"
DST_TODAY = -1
Exit Function
End If
' FALSE
MONTH = Val(Mid$(A$, 4, 2))
'Print MONTH
'MAR
If MONTH = 3  Then
C$ = DST_SPRING_FORWARD$() '+ 1 HR TO rtc
If C$ = "-1" Then
Print "TIME OUT OF RANGE FOR DST UPDATE"
DST_TODAY = -1
Exit Function
End If
DST_TODAY = 1
Exit Function
End If
' NOV
If MONTH = 11 Then
D$ = DST_FALL_BACK$()      '- 1 HR TO rtc
If D$ = "-1" Then
Print "TIME OUT OF RANGE FOR DST UPDATE"
DST_TODAY = -1
Exit Function
End If
DST_TODAY = 1
Exit Function
End If
' MONTH NOT MAR OR NOV
DST_STATUS_F()
DST_TODAY = -1
End Function


Function DST_DATE$()
'Reads DST date file and returns date$ if today is DST otherwise "-1"
Local DST_YR$
Local DST_MAR$
Local DST_NOV$
Local DST_KEY$
Local MON
Open "DSTDATES.DAT" For input As #1
RTC GETTIME
MON = Val(Mid$(Date$, 4, 2))
'Print mon
'MON = 3 'test
DST_KEY$ = Mid$(Date$,7, 4)
'DST_KEY$ = "2016" ' test
RESTART:
If Eof(#1) Then  DST_DATE = "-1" : Exit Function
Do While Not Eof(#1)
    Line Input #1, DST_YR$
  If DST_KEY$ = DST_YR$ Then
    Line Input #1, DST_MAR$
    Line Input #1, DST_NOV$
    Close #1
    If MON = 3 Then DST_DATE$  = DST_MAR$ : Exit Function
    If MON = 11 Then DST_DATE$ = DST_NOV$ : Exit Function
  Exit Do
  Else
  GoTo RESTART
  End If
Loop
DST_DATE$ = "-1"
End Function

Sub DST_STATUS_T()
Open "DST_STAT.DAT" For OUTPUT As #2
Print #2, "TRUE"
Close #2
End Sub

Sub DST_STATUS_F()
Open "DST_STAT.DAT" For OUTPUT As #2
Print #2, "FALSE"
Close #2
End Sub

Sub DST_LOG()
Open "DST_LOG.DAT" For APPEND As #2
Print #2, "DST UPDATE" + " " + Time$ + " " + Date$
Close #2
End Sub

Function DST_READ_S$()
' RETURNS "-1", "TRUE" "FALSE"
Local S$
Open "DST_STAT.DAT" For INPUT As #3
If MM.Errno <> 0 Or Eof(#3) Then DST_READ_S$ = "-1" : Close #3  : Exit Function
Line Input #3, S$
If S$ = "TRUE" Then
DST_READ_S$ = "TRUE"
Close #3
Exit Function
Else
DST_READ_S$ = "FALSE"
Close #3
Exit Function
End If
Close #3
End Function

Function DST_SPRING_FORWARD$()
Local RTC_HR, RTC_MIN, RTC_SEC, RTC_DAY, RTC_MON, RTC_YR
RTC GETTIME
RTC_HR  = Val(Left$(Time$, 2))    ' MILITARY TIME
RTC_MIN = Val(Mid$(Time$, 4, 2))
RTC_SEC = Val(Mid$(Time$, 7, 2))
RTC_DAY = Val(Left$(Date$, 2))
RTC_MON = Val(Mid$(Date$, 4, 2))
RTC_YR  = Val(Mid$(Date$, 7, 2))  ' 2 DIGITS FOR YEAR
If ((RTC_HR >= 0) And (RTC_HR =< 22)) Then
RTC_HR = RTC_HR + 1
Else
DST_SPRING_FORWARD$ = "-1"
Exit Function
End If
'RTC SETTIME RTC_YR, RTC_MON, RTC_DAY, RTC_HR, RTC_MIN, RTC_SEC
DST_SPRING_FORWARD$ = "1"
DST_STATUS_T() ' UPDATE DST STATUS FILE TO PREVENT FURTHER UPDATES TODAY
RTC GETTIME
DST_LOG()
GUI beep 1000
End Function

Function DST_FALL_BACK$()
Local RTC_HR, RTC_MIN, RTC_SEC, RTC_DAY, RTC_MON, RTC_YR
RTC GETTIME
RTC_HR  = Val(Left$(Time$, 2))    ' MILITARY TIME
RTC_MIN = Val(Mid$(Time$, 4, 2))
RTC_SEC = Val(Mid$(Time$, 7, 2))
RTC_DAY = Val(Left$(Date$, 2))
RTC_MON = Val(Mid$(Date$, 4, 2))
RTC_YR  = Val(Mid$(Date$, 7, 2))  ' 2 DIGITS FOR YEAR
If ((RTC_HR >= 2) And (RTC_HR =< 23)) Then
RTC_HR = RTC_HR - 1
Else
DST_FALL_BACK$ = "-1"
Exit Function
End If
'RTC SETTIME RTC_YR, RTC_MON, RTC_DAY, RTC_HR, RTC_MIN, RTC_SEC
DST_FALL_BACK$ = "1"
DST_STATUS_T() ' UPDATE DST STATUS FILE TO PREVENT FURTHER UPDATES TODAY
RTC GETTIME
DST_LOG()
GUI beep 1000
End Function
