'--------------------------------------------------
'UTLY1
'Displays GPS and RTC/system clock with GPS on Com2
'Does not automatically compensate for DST and time zone constants  
'Date: 9/9/15
'Revision: 1.0b
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' GPS CLOCK
' Geoff Graham, March 2014
'
' Demonstration of the Micromite
' This program will get the time from an EM-408 GPS module or Ublox NEO-6Mv2, add the timezone
' and daylight saving then display on a two line LCD.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' Configuration constants
TimeZone = -4.0        ' hours from GMT (+ or -) <------ -4 EDT -5 EST

' LCD printout ...
' WED 19-Aug-2015
' 3:23:47 PM

UseDST = 1            ' set to 1 to enable daylight saving time (DST) adjust <------
dms = 11              ' the month that DST starts <------
dhs = 2               ' the hour that DST starts
dme = 3               ' the month that DST ends <------
dhe = 2               ' the hour that DST ends

' global arrays
Dim md(12), arg$(20)
Data 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334
For i = 1 To 12: Read md(i): Next i

'LCD Init 23, 24, 25, 26, 17, 18             ' setup the LCD for display <------
Open "COM2:9600" As #1                       ' open the GPS serial interface <------
'pin 11 tx pin 13 rx - com2 mm+ e64


' this is the main program loop, it never exits
Do
  KeepSearching:
  Do
    GetGPSRecord                             ' get a GPS record
  Loop Until arg$(0) = "GPRMC"               ' we only want the RMC record
  If arg$(2) <> "A" Then                     ' "A" means valid record
    'LCD 1, C16, "Searching"
    'LCD 2, C16, "For Satellites"
    GoTo KeepSearching                       ' go back and keep looking
  EndIf

  ' the GPS has the valid time
  ' first extract the elements of the date/time from the GPS record <------- Military time at UTC
  year = Val(Right$(arg$(9), 2))             ' extract the date
  month = Val(Mid$(arg$(9), 3, 2))
  day = Val(Left$(arg$(9), 2))
  hour = Val(Left$(arg$(1), 2))              ' extract the time
  min = Val(Mid$(arg$(1), 3, 2))
  sec = Val(Mid$(arg$(1), 5, 2))

  ' convert the time to minutes since midnight 1st Jan 2014
  ' then add/subtract the timezone and if required add daylight saving
  ' this calculation takes just 15mS at 40MHz
  mins = GetMins(year, month, day, hour, min)
  mins = mins + TimeZone * 60                ' adjust for the timezone
  If UseDST Then                             ' if we observe daylight saving
    If mins < GetDST(year, dme, dhe) Or mins > GetDST(year, dms, dhs) Then
      mins = mins + 60                       ' adjust for AWST DST
    EndIf
  EndIf

  ' because we will display the time at the start of the next second
  ' we have to add 1 second to the current time
  sec = sec + 1
  If sec >= 60 Then sec = 0 : mins = mins + 1

  ' finally convert the minutes back into the current date/time
       Line1$ = GetDate$(mins) '<------
       Line2$ = GetTime$(mins) '<------
       GPS_MT$ = GetMT$(mins)
       GPS_Date$ = GetDate1$(mins)
  ' we now have the date/time for the next second ready for display
  ' we have to wait for the end of the data stream from the GPS
  ' then we wait for the start of the next second and only then update the LCD
  Do : Loop While Timer < 950                ' wait for the data to finish
  Do : Loop While Input$(200, #1) <> ""      ' clear the input buffer
  Do While Input$(1, #1) <> "$" : Loop       ' wait for a new second to start
  Timer = 0

  ' display the date and time for this second
    ' LCD 1, C16, Line1$ ' <------
    ' LCD 2, C16, Line2$ ' <------
  ' sound beeper/buzzer/sounder
     Dim TZ$ = ""
     If timezone = -4 Then TZ$ = "Eastern Daylight Saving Time" Else TZ$ = "Eastern Standard Time"
     Print "GPS date time acqired ... " ; : Print Line1$ ; : Print " " ; : Print line2$ ;
     Print " " ; : Print TZ$
     RTC Gettime
     Print "RTC date time acqired ...       " ; : Print Date$ ; : Print " " ; : Print Time$


     'Print GPS_MT$
     'Print GPS_Date$
     RTC_HR = Val(Left$(GPS_MT$, 2))
     RTC_MIN = Val(Mid$(GPS_MT$, 4, 2))
     RTC_SEC = Val(Mid$(GPS_MT$, 7, 2))
     RTC_DAY = Val(Left$(GPS_Date$, 2))
     RTC_MON = Val(Mid$(GPS_Date$, 4, 2))
     RTC_YR  = Val(Mid$(GPS_Date$, 7, 2))

     'Print rtc_hr
     'Print rtc_min
     'Print rtc_sec
     'Print rtc_day
     'Print rtc_mon
     'Print rtc_yr
     'RTC gettime

     ' RTC SETTIME rtc_yr, rtc_mon, rtc_day, rtc_hr, rtc_min, rtc_sec : GUI beep 100
     ' RTC gettime
     ' Print "RTC date time adjusted ..       " ; : Print Date$ ; : Print " " ; : Print Time$

     End
  ' convert time/date back to variables for RTC update
  ' update - RTC SETTIME
  ' update MM+ - RTC GETTIME
  ' Load "xxxx.bas",r
  '
Loop


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' subroutine to get a GPS record into the array arg$()
Sub GetGPSRecord
  Do
    Do While Input$(1, #1) <> "$" : Loop   ' wait for the start
    For i = 0 To 20
      arg$(i) = ""                         ' clear ready for data
      Do                                   ' loops until a specific exit
        x$ = Input$(1, #1)                 ' get the character
        If x$ = "," Then Exit Do           ' new data item, new field
        If x$ = "*" Then Exit Sub          ' end of record, so return with it
        arg$(i) = arg$(i) + x$             ' add to the data
      Loop                                 ' keep going
    Next i                                 ' increment the field
  Loop
End Sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' calculate the minutes since midnight 1st Jan 2014
Function GetMins(yr, mth, day, hr, min)
  GetMins = (yr - 14) * (365 * 24 * 60) + ((yr - 13) \ 4) * (24 * 60)
  GetMins = GetMins + (md(mth) * (24 * 60))
  GetMins = GetMins + ((day - 1) * (24 * 60))
  GetMins = GetMins + (hr * 60)
  GetMins = GetMins + min
  If (yr - 16) Mod 4 = 0 And mth > 2 Then GetMins = GetMins + (24 * 60)
End Function


' convert minutes back into the time (as a string)
Function GetTime$(minutes)
  Local hr, min, am$
  am$ = "AM"
  hr = (minutes \ 60) Mod 24
  If hr >= 12 Then am$ = "PM"
  If hr > 12 Then hr = hr - 12
  If hr = 0 Then hr = 12
  min = minutes Mod 60
  GetTime$ = Str$(hr) + ":"
  GetTime$ = GetTime$ + Right$("0" + Str$(min), 2) + ":"
  GetTime$ = GetTime$ + Right$("0" + Str$(sec), 2) + " " + am$
End Function

' convert minutes back into military time (as a string)
Function GetMT$(minutes)
  Local hr, min
  hr = (minutes \ 60) Mod 24
  min = minutes Mod 60
  GetMT$ = Str$(hr) + ":"
  GetMT$ = GetMT$ + Right$("0" + Str$(min), 2) + ":"
  GetMT$ = GetMT$ + Right$("0" + Str$(sec), 2)
End Function


' convert minutes back into the date (as a string)
Function GetDate$(minutes)
  Local yr, mth, day, mths$, days$
  mths$ = "  JanFebMarAprMayJunJulAugSepOctNovDec"
  days$ = "SunMonTueWedThuFriSat"
  For yr = 14 To 99
   If minutes < GetMins(yr + 1, 1, 1, 0, 0) Then Exit For
  Next yr
  For mth = 1 To 12
    If minutes < GetMins(yr, mth, 1, 0, 0) Then Exit For
  Next mth
  mth = mth - 1
  day = ((minutes - GetMins(yr, mth, 1, 0, 0)) \ (24 * 60)) +  1
  GetDate$ = Mid$(days$, ((((minutes \ (24 * 60)) + 3) Mod 7) * 3) + 1,3)+"  "
  GetDate$ = GetDate$ + Right$(" " + Str$(day), 2)
  GetDate$ = GetDate$ + "-" + Mid$(mths$,mth*3,3) + "-" + Str$(yr + 2000)
End Function

' convert minutes back into the date (as a string)

Function GetDate1$(minutes)
  Local yr, mon, day
  Local d$, m$
  For yr = 14 To 99
    If minutes < GetMins(yr + 1, 1, 1, 0, 0) Then Exit For
    Next yr
  For mon = 1 To 12
    If minutes < Getmins(yr, mon, 1, 0, 0) Then Exit For
  Next mon
  mon = mon - 1
  day = ((minutes - GetMins(yr, mon, 1, 0, 0)) \ (24 * 60)) +  1
  If day < 10 Then d$ = "0" + Str$(day) Else d$ = Str$(day)
  GetDate1$ = GetDate1$ + d$
  If mon < 10 Then m$  = "0" + Str$(mon) Else m$ = Str$(mon)
  GetDate1$ = GetDate1$ + "-" + m$ + "-" + Str$(yr)

End Function



' get the minutes that DST will start or end in a month
Function GetDST(yr, mth, hr)
  Local d, m
  m = GetMins(yr, mth, 1, hr, 0)
  d = ((m \ (24 * 60)) + 3) Mod 7
  GetDST =  m + (((7 - d) Mod 7) * 24 * 60)
End Function
