
'david mortimer may 2014
'pic32 programmer using MaxiMite
'-------
'set variables
'=======
  pgd = 22         'data i/o pin MaxiMite
  clk = 21         'clock
  mclr = 23        '/reset

'5 bit MTAP
MTAP_COMMAND$ = "00111" '07 TDI and TDO connected to MCHP Command Shift register (See Table 19-2)
MTAP_SW_MTAP$ = "00100" '04 Switch TAP controller to MCHP TAP controller
MTAP_SW_ETAP$ = "00101" '05 Switch TAP controller to EJTAG TAP controller
MTAP_IDCODE$ =  "00001" '01 Select Chip Identification Data register

'8 bit MCHP
MCHP_STATUS$ = "00000000" 'NOP 00 and return Status.
MCHP_ASSERT_RST$ = "11010001" 'D1" 'Requests the reset controller to assert device Reset.
MCHP_DE_ASSERT_RST$  = "11010000" ' D0" 'Removes the request for device Reset, which causes the reset
'controller to de-assert device Reset if there is no other source
'requesting Reset (i.e., MCLR).
MCHP_ERASE$ = "11111100" 'FC" 'Cause the Flash controller to perform a Chip Erase.
MCHP_FLASH_ENABLE$  = "11111110" 'FE" 'Enables fetches and loads to the Flash (from the processor).
MCHP_FLASH_DISABLE$ = "11111101" 'FD" 'Disables fetches and loads to the Flash (from the processor

'5 bit ETAP
ETAP_ADDRESS$ = "01000" '08" 'Select Address register.
ETAP_DATA$ = "01001" '09 'Select Data register.
ETAP_CONTROL$ = "01010" '0A" 'Select EJTAG Control register.
ETAP_EJTAGBOOT$ = "01100" '0C" 'Set EjtagBrk, ProbEn and ProbTrap to 1 as the reset value.
ETAP_FASTDATA$ = "01110" '0E" 'Selects the Data and Fastdata registers.

  Dim tdi, tms, tdo, indata$, outdata$, inchar$

  SetPin pgd, 8	'dout
  SetPin clk, 8	'dout
  SetPin mclr,8	'dout
  Cls

start:

  Print "1 - Enter prog set up mode"
  Print "2 - Check Status"
  Print "3 - Erase Chip"
  Print "4 - Enter ICSP mode"
  Print "5 - Read Device ID"
  Print "6 - Prog Chip"
  Print "7 - Read Memory"
  Print "8 - Quit"
  Print "Press <enter> to clear screen data":?

  Input "Enter Menu Selection "; inchar$: Cls
  If inchar$ = "1" Then GoTo setup
  If inchar$ = "5" Then GoTo check_device_id
  If inchar$ = "3" Then GoTo erase_chip
  If inchar$ = "4" Then GoTo icsp_mode
  If inchar$ = "7" Then GoTo read_memory
  If inchar$ = "6" Then GoTo prog_chip
  If inchar$ = "2" Then GoTo Check_Status""
  If inchar$ = "" Then GoTo start
  If inchar$ = "8" Then End
  GoTo start

setup:
  SetPin pgd, 8 'dout
  Pin(pgd) = 0
  Pin(clk) = 0
  Pin(mclr) = 0: Pause 100
  Pulse mclr, .01

  pgm$="01001101010000110100100001010000" 'PGM mode data sequence
  For x = 1 To 32
    Pin(pgd)=Val(Mid$(pgm$,x,1))
    Pulse clk , .01
  Next x

    Pin(mclr) = 1     'send reset pin high and hold.
    Pause 1
'========================================================= Set Mode
  Print "Set Mode "
  setmode ("011111")
  GoTo start

'===========

check_status:

Print "check device status ";

  SendCommand (MTAP_SW_MTAP$)
  SendCommand (MTAP_COMMAND$)
  Do
    xferdata(mchp_status$)
  Loop Until Mid$(outdata$,5,1) = "1" And Mid$(outdata$,6,1)="0"
  Print outdata$
  GoTo start
'==========

erase_chip:

Print "erase device "
  SendCommand (MTAP_SW_MTAP$)
  SendCommand (MTAP_COMMAND$)
  xferdata(mchp_erase$)
  Pause 10
  Do
  xferdata(mchp_status$)
  ? outdata$
  Loop Until Mid$(outdata$,5,1) = "1" And Mid$(outdata$,6,1)="0"
GoTo start

'==========

prog_chip:
'  to be implemented
GoTo start

'==========

check_device_id:
  sendcommand(mtap_idcode$)
  xferdata(hextobin$("00000000"))
  Print outdata$
  GoTo start
'========

read_memory:
XferInstruction ("3c04bf80")
XferInstruction ("3c081d00")
XferInstruction ("35080000")
XferInstruction ("8d090000")
XferInstruction ("ae690000")
sendcommand(etap_fastdata$)
xferfastdata(hextobin$("00000000")) 'Step 4: Read data from Fastdata register 0xFF200000.
Print outdata$
GoTo start

'===========

icsp_mode:
 SendCommand (MTAP_SW_MTAP$)
 SendCommand (MTAP_COMMAND$)
 XferData (MCHP_STATUS$):Print outdata$
 If Mid$(outdata$,1,1) <> "1" Then
  ? "device not blank": End
 EndIf
 XferData (MCHP_ASSERT_RST$)
 SendCommand (MTAP_SW_ETAP$)
 SendCommand (ETAP_EJTAGBOOT$)
 SendCommand (MTAP_SW_MTAP$)
 SendCommand (MTAP_COMMAND$)
 XferData (MCHP_DE_ASSERT_RST$)
 XferData (MCHP_FLASH_ENABLE$)
 sendcommand (MCHP_SW_ETAP$)
 Print "serial mode "
GoTo start

'=========
Sub setmode(st$)
  Local x
For x = 6 To 1 Step - 1
  Pin(pgd) = 0      'TDI
  Pulse clk, .01
   Pin(pgd) = Val(Mid$(st$,x,1)) 'TMS
   Pulse clk, .01
   Pulse clk, .01
   Pulse clk, .01
  Next x
End Sub

'========

Sub sendcommand(st$)
  Local x
  tdi = 0: tms = 1: GoSub clock: GoSub clock
  tdi = 0: tms = 0: GoSub clock: GoSub clock

For x = 5 To 2  Step - 1
  tdi = Val(Mid$(st$,x,1)): tms = 0: GoSub clock
Next x
  tdi = Val(Mid$(st$,1,1)): tms = 1: GoSub clock

  tdi = 0: tms = 1: GoSub clock
  tdi = 0: tms = 0: GoSub clock
End Sub

'========
Sub xferInstruction (st$)
  SendCommand (etap_control$)
  Do
    xferdata (hextobin$("0004c000"))
  Loop Until Mid$(outdata$,14,1) = "1"
  SendCommand (etap_data$)
  XferData (hextobin$(st$))
  sendcommand (etap_control$)
  xferdata (hextobin$("0000c000"))
End Sub

'================
Sub xferdata(st$)
Local x
  tdi = 0: tms = 1: GoSub clock
  tdi = 0: tms = 0: GoSub clock
  tdi = 0: tms = 0: GoSub clock
  outdata$ = Str$(tdo) 'read lsb of outdata
  For x = Len(st$) To 2 Step - 1
    tdi = Val(Mid$(st$,x,1)): tms = 0: GoSub clock
    outdata$ = Str$(tdo) +  outdata$
  Next x
  tdi = Val(Left$(st$,1)): tms = 1: GoSub clock
  tdi = 0: tms = 1: GoSub clock
  tdi = 0: tms = 0: GoSub clock
End Sub

'===========
Sub xferfastdata(st$)
Local x
  tdi = 0: tms = 1: GoSub clock
  tdi = 0: tms = 0: GoSub clock
  tdi = 0: tms = 0: GoSub clock
  tdi = 0: tms = 0: GoSub clock
  outdata$ = Str$(tdo) 'read lsb of outdata

  For x = Len(st$) To 2 Step - 1
    tdi = Val(Mid$(st$,x,1)): tms = 0: GoSub clock
    outdata$ = Str$(tdo) +  outdata$
  Next x
  tdi = Val(Left$(st$,1)): tms = 1: GoSub clock
  tdi = 0: tms = 1: GoSub clock
  tdi = 0: tms = 0: GoSub clock

End Sub
'========

  'create 4 phase clock and read data out on pgd line
clock:
  SetPin pgd,8'dout
  Pin(pgd)=tdi
  Pulse clk,.01
  Pin(pgd)=tms
  Pulse clk,.01
  SetPin pgd,2'din
  Pulse clk,.01
  Pin(clk)=1
  tdo=Pin(pgd)
  Pin(clk)=0
Return


'========
Function hextobin$(nibbles$)
Local bit,bin_count,dec_val,nibbles,byte$, n$,h$,z
For z = 1 To Len(nibbles$)
  n$=Mid$(nibbles$,z,1)
  byte$=""
  bin_count = 8
  dec_val = Instr(1,"0123456789abcdef",n$)-1
  For bit  = 1 To 4
    If dec_val >= bin_count  Then
      byte$ = Byte$ + "1"
      dec_val = dec_val - bin_count
    Else
      byte$ = byte$ + "0"
    EndIf
    bin_count =bin_count / 2
  Next bit
  h$ = h$ + byte$
Next z
  hextobin$ = h$
End Function

