'
'Programme an 8 bit PIC using a MaxiMite.
'data files stored on SD card.
'Programme commencment date/time 16/12/2014 2130Hrs
'Programme written by David Mortimer
'Able to programme F88 pic 23/01/2015
'Modified for numeric arrays 2/2/201
'
'
'=======================================================================
Mode 1
Dim HexLine$,dataLine$, Byte_count, mem_addr, nbytes, file_addr, words$
Dim himem, mem_data$, config1$,maxrom, configword
Dim MemData(2048),RomData(512),bin(14), ProgMode

'progmode = 1
progmode = 2

load_config$ = "00000"
load_mem_data$ = "00010"
read_mem$ = "00100"
inc_addr$ = "00110"
begin_erase_prog_cycle$ = "01000"
begin_prog_only_cycle$ = "11000"
bulk_erase_p_mem$ = "01001"
bulk_erase_d_mem$ = "01011"
chip_erase$ = "11111"
load_data_d_mem$ = "00011"
read_data_d_mem$ = " 00101"
end_pgm$ = "10111"

himem = 2047
maxrom = 255
reset = 21
pgc = 22
pgd = 23
pgm = 24
vpp = 25

SetPin pgc,8
SetPin pgd,8
SetPin pgm,8
SetPin reset,8
SetPin vpp,8
Cls

For x = 0 To 2047:memdata(x) = &H3fff:Next x
For x = 0 To 255:romdata(x) = &H00ff:Next x

'GoTo test
GoTo menu


Sub erasechip()
  outcommand(chip_erase$)
    Pause 2
End Sub

readconfig:
  Local x
  outcommand(load_config$)
  outdata(&H3fff)
  For x = 1 To 8
    SetPin(pgd),8
    outcommand(read_mem$)
    GoSub indata
    outcommand(inc_addr$)
    ? mem_data$ + " "
  Next x
  Input, zz
Return

writeconfig:
  Local x,y
  outcommand(load_config$): outdata(configword)
    For x = 1 To 7
      outcommand(inc_addr$)
    Next x
    outcommand(load_mem_data$): outdata(configword)
    If progmode = 2 Then
      outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
      outcommand(inc_addr$)
      outcommand(load_mem_data$): outdata(&H3fff)
      outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
    Else
      outcommand(begin_erase_prog$)
      Pause 10
    EndIf
  Return

Function hextodec(st$)
  Local x,y,hexbyte,char$
  hexbyte = 0
  For x = 1 To Len(st$)
    char$=Mid$(st$,x,1)
    y = Instr(1,"0123456789abcdef",char$)
    hexbyte = hexbyte Or (y-1)
    If x < Len(st$) Then hexbyte = hexbyte*16
  Next x
  hextodec = hexbyte
  End Function

Sub integertobin(int)
  Local x, integer  'bin(13)=MSB, bin(0) = LSB
  integer = int
  For x = 13 To 0 Step - 1
    bin(x) = integer Mod 2
    integer = integer\2
  Next x
End Sub

Function bintodec(bin$)
  Local count,x,bit$,dec
  count = 1
  dec = 0
  For x = Len(bin$) To 1 Step - 1
    bit$ = Mid$(bin$,x,1)
    If bit$ = "1" Then
      dec = dec + count
    EndIf
  count = count * 2
  Next x
  bintodec = dec
  End Function

Function hextobin$(nibbles$)
  Local bit,bin_count,dec_val,nibbles,byte$, n$,h$,z
  For z = 1 To Len(nibbles$)
    n$=Mid$(nibbles$,z,1)
  byte$=""
  bin_count = 8
  dec_val = Instr(1,"0123456789abcdef",n$)-1
  For bit  = 1 To 4
   If dec_val >= bin_count  Then
       byte$ = Byte$ + "1"
       dec_val = dec_val - bin_count
    Else
       byte$ = byte$ + "0"
    EndIf
    bin_count =bin_count / 2
  Next bit
    h$ = h$ + byte$
  Next z
    hextobin$ = h$
  End Function


Function swap_bytes$(b$)
  Local hi$, lo$
  If Len(b$)<>4 Then
    ? "String incorrect length"
    End
  EndIf
  hi$ = Left$(b$,2)
  lo$ = Right$(b$,2)
  swap_bytes$ = lo$ + hi$
  End Function


Function swap_nibbles$(n$)
  Local hi$, lo$
  If Len(n$)<>2 Then
    ? "String incorrect length"
  End
  EndIf
  hi$ = Left$(n$,1)
  lo$ = Right$(n$,1)
  swap_nibbles$ = lo$ + hi$
  End Function

Sub outcommand(c$)
  Local x
  SetPin pgd,8
  For x = 5 To 1 Step-1
    Pin(pgd) = Val(Mid$(c$,x,1))
    Pulse pgc, 0.1
  Next x
  Pin(pgd)=0
  Pulse pgc, 0.1
End Sub


Sub outdata(dat)
  Local x,y
  y = dat
  integertobin(y)
  Pin(pgd)=0
  Pulse pgc,0.1
  For x = 13 To 0 Step-1'0 To 13
    Pin(pgd)=bin(x)
    Pulse pgc,0.1
  Next x
  Pin(pgd)=0
  Pulse pgc,0.1
End Sub


indata: 'read in 14 bits mem data from target pic
  Local x, bit$
  bit$=""
  mem_data$ = ""
  Pulse pgc,0.1
  SetPin pgd,2 'input
  For x = 1 To 14
    Pin(pgc)=1
    If Pin(pgd) = 0 Then
      bit$ = "0"
    Else
     bit$ = "1"
    EndIf
    mem_data$ = bit$ + mem_data$
    Pin(pgc)=0
  Next x
  Pulse pgc,0.1
  Return

Sub lv_prog_mode
  SetPin pgd,8
  Pin(pgd)=0
  Pin(pgc)=0
  Pin(reset)=0
  Pin(pgm)=0
  Pin(pgm)=1
  Pin(reset)=1
End Sub

Sub hv_prog_mode
  SetPin pgd,8
  Pin(vpp)=0
  Pin(pgd)=0
  Pin(pgc)=0
  Pin(vpp)=1
End Sub

Function hextodec(st$)
  Local x, y, hexbyte, char$
  hexbyte = 0
  For x = 1 tp Len(st$)
    char$ = Mid$(st$,x,1)
    y = Instr(1,"0123456789abcd",char$
    hexbyte = hexbyte Or (y-1)
    If x < Len(st$) Then hexbyte = hexbyte * 16
  Next x
  hextodec = hexbyte
End Function

menu:
Cls
? "1 = LVP mode"
? "2 = run mode"
? "3 = read mem data"
? "4 = end"
? "5 = programme mode"
? "6 = erase pic"
? "7 = display "
? "8 = read config "
? "9 = write config "
? "10 = load hex file "
? "11 = show file data "
Input "enter number   ",keyin

If keyin = 1 Then: lv_prog_mode:EndIf
If keyin = 2 Then: Pin(pgm)=0: Pin(reset)=1: EndIf
If keyin = 3 Then
  Cls
  For y = 1 To himem
  SetPin(pgd),8
  outcommand(read_mem$)
  GoSub indata
  outcommand(inc_addr$)
  st$= Hex$(bintodec(mem_data$))
  If Len(st$)=2 Then: st$="00" + st$ : EndIf
  If Len(st$) = 3 Then: st$ = "0"  + st$:  EndIf
  If Len(st$) = 1 Then:st$ = "000"+st$:EndIf
  ? st$+" ";
  Next y

EndIf
If keyin = 4 Then: End: EndIf
If keyin = 5 Then: progchip(): EndIf
If keyin = 6 Then: erasechip: EndIf
If keyin = 7 Then: EndIf
If keyin = 8 Then: GoSub readconfig: EndIf
If keyin = 9 Then: GoSub writeconfig: EndIf
If keyin = 10 Then: readhexfile(): EndIf
If keyin = 11 Then: GoSub showmem: EndIf
GoTo menu


Sub readhexfile()
  ? "Initialising Hex File "
  Dim x,y,z,picaddress,hexfilenum
  For x = 0 To himem
    memdata(x) = &H3fff
  Next x
  For x = 0 To maxrom
    romdata(x) = &Hff
  Next x
  ? "Loading Hex File"
  picaddress = 0
  hexfilenum=1
'  Input "Enter HEX File ",hexfile$
hexfile$ = "hexfile.hex"
  Open hexfile$ For input As #hexfilenum
  Do While Not Eof(#hexfilenum)
    Line Input #hexfilenum,hexline$
    bytecount = hextodec(Mid$(hexline$,2,2))*2
    picaddress = hextodec(Mid$(hexline$,4,4))/2
    hexline$=Mid$(hexline$,10,Len(hexline$)-11)
    If picaddress < himem Then
      x=0: y=0
      If Len(hexline$) > 0 Then
        Do
          memdata(picaddress+y) = hextodec(swap_bytes$(Mid$(hexline$,x+1,4)))
         x=x+4: y=y+1
        Loop Until x >= bytecount
      EndIf
    EndIf
  If picaddress = &H2000 Then
    x=0:y=0
    If Len(hexline$) > 0 Then
      Do
      x=x+4: y=y+1
      Loop Until x >= bytecount
    EndIf
  EndIf
  If picaddress = &h2007 Then
    configword = hextodec(swap_bytes$(Mid$(hexline$,1,4)))
'    ? Hex$(configword):Input zz
  EndIf
If picaddress > &H20ff Then
  x=0: y=0
  If Len(hexline$)>0 Then
    Do
      romdata(picaddress - &H2100 + y) = hextodec(Mid$(hexline$,x+1,4))
      x=x+4: y=y+1
    Loop Until x>= bytecount
  EndIf
EndIf
Loop
  Close #1
  For x = 0 To 80
    z$ =Hex$(memdata(x))
    If Len(z$)=1 Then ? "000"+z$+" ";:EndIf
    If Len(z$)=2 Then ? "00"+z$+" ";:EndIf
    If Len(z$)=3 Then ? "0"+z$+" ";:EndIf
    If Len(z$)=4 Then ? z$+" ";:EndIf
  Next x
End Sub

Sub progchip()
Local x, y, z, block
  ? "Programming PIC "
  ? "Erasing Device "
  lv_prog_mode()
  erasechip()
  ? "Writing Programme "
  If Progmode = 1 Then
    lv_prog_mode()
    For x = 0 To himem
      If memdata(x) = &H3fff Then
        outcommand(inc_addr$)
      Else
        outcommand(load_mem_data$)
        outdata(memdata(x))
        outcommand(inc_addr$)
      EndIf
    Next x
  EndIf
  If progmode = 2 Then
    lv_prog_mode()
    outcommand(chip_erase$)
    lv_prog_mode()
    x=0
    Do While x <= himem
      block = &H3fff
      For y = 1 To 3
        If memdata(x) <> &H3fff Then
          outcommand(load_mem_data$)
          outdata(memdata(x))
        EndIf
      block = block And memdata(x)
      outcommand(inc_addr$)
      x=x+1
      Next y
      If memdata(x)<>&H3fff Then
        outcommand(load_mem_data$)
        outdata(memdata(x))
      EndIf
      block = (block And memdata(x))
      x=x+1
      If block <> &H3fff Then
        outcommand(begin_prog_only_cycle$)
        outcommand(end_pgm$)
      EndIf
      outcommand(inc_addr$)
    Loop
  EndIf
  ? "Programming EEprom data "
  lv_prog_mode()
  For x = 0 To maxrom
    outcommand(load_data_d_mem$)
    outdata(romdata(x))
    If progmode = 2 Then
      outcommand(begin_prog_only_cycle$)
      outcommand(end_pgm$)
    Else
      outcommand(begin_erase_prog_cycle$)
    EndIf
    outcommand(inc_addr$)
  Next x
  ? "Programming Config memory "
  lv_prog_mode()
  outcommand(load_config$): outdata(configword)
  For y = 1 To 7
    outcommand(inc_addr$)
  Next y
    outcommand(load_mem_data$): outdata(configword)
  If progmode = 2 Then
    outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
    outcommand(inc_addr$)
    outcommand(load_mem_data$): outdata(&H3fff)
    outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
  Else
    outcommand(begin_erase_prog_cycle$)
  EndIf
End Sub


  ? "Verifying Programme memory "
  lv_prog_mode()
  For x = 0 To himem
    If memdata(x) <> &H3fff Then

showmem:
  Local x,y
  For x = 0 To 80
'  ? Hex$((memdata(x)));
integertobin(memdata(x))
    For y = 1 To 14
    ? Bin(y);
    Next y:? " "
 Next x
   Pause 3000
Return


