'PicProg8.bas
'Programme an 8 bit PIC using a MaxiMite.
'data files stored on SD card.
'Programme commencment date/time 16/12/2014 2130Hrs
'Programme written by David Mortimer
'Able to programme F88 pic 23/01/2015
'Modified for numeric arrays 2/2/201
'Set up menu and config file working 11/2/2015
'Verify routine working 12/2/2015
'
'=======================================================================
Mode 1
Dim HexLine$,dataLine$, Byte_count, mem_addr, nbytes, words$
Dim himem, mem_data$, config1$,maxrom, configword
Dim MemData(2048),RomData(512),bin(14), ProgMode
Dim hexfile$,hexfilenum

load_config$ = "00000"
load_mem_data$ = "00010"
read_mem$ = "00100"
inc_addr$ = "00110"
begin_erase_prog_cycle$ = "01000"
begin_prog_only_cycle$ = "11000"
bulk_erase_p_mem$ = "01001"
bulk_erase_d_mem$ = "01011"
chip_erase$ = "11111"
load_data_d_mem$ = "00011"
read_data_d_mem$ = "00101"
end_pgm$ = "10111"

reset = 21 'MM programming pins
pgc = 22
pgd = 23
pgm = 24
vpp = 25

SetPin pgc,8
SetPin pgd,8
SetPin pgm,8
SetPin reset,8
SetPin vpp,8

Cls
GoTo menu

Sub erasechip()
  outcommand(chip_erase$)
    Pause 2
End Sub

readconfig:
  Local x
  outcommand(load_config$)
  outdata(&H3fff)
  For x = 1 To 8
    SetPin(pgd),8
    outcommand(read_mem$)
    GoSub indata
    outcommand(inc_addr$)
    Print (mem_data$) + " "
  Next x
  Input "Press Enter ", zz
Return

writeconfig:
  Local x,y
  outcommand(load_config$): outdata(configword)
    For x = 1 To 7
      outcommand(inc_addr$)
    Next x
    outcommand(load_mem_data$): outdata(configword)
    If progmode = 2 Then
      outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
      outcommand(inc_addr$)
      outcommand(load_mem_data$): outdata(&H3fff)
      outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
    Else
      outcommand(begin_erase_prog$)
      Pause 10
    EndIf
  Return

Function hextodec(st$)
  Local x,y,hexbyte,char$
  hexbyte = 0
  For x = 1 To Len(st$)
    char$=Mid$(st$,x,1)
    y = Instr(1,"0123456789abcdef",char$)
    hexbyte = hexbyte Or (y-1)
    If x < Len(st$) Then hexbyte = hexbyte*16
  Next x
  hextodec = hexbyte
  End Function

Sub integertobin(int)
  Local x, integer  'bin(13)=MSB, bin(0) = LSB
  integer = int
  For x = 13 To 0 Step - 1
    bin(x) = integer Mod 2
    integer = integer\2
  Next x
End Sub

Function bintodec(bin$)
  Local count,x,bit$,dec
  count = 1
  dec = 0
  For x = Len(bin$) To 1 Step - 1
    bit$ = Mid$(bin$,x,1)
    If bit$ = "1" Then
      dec = dec + count
    EndIf
  count = count * 2
  Next x
  bintodec = dec
  End Function

Function hextobin$(nibbles$)
  Local bit,bin_count,dec_val,nibbles,byte$, n$,h$,z
  For z = 1 To Len(nibbles$)
    n$=Mid$(nibbles$,z,1)
  byte$=""
  bin_count = 8
  dec_val = Instr(1,"0123456789abcdef",n$)-1
  For bit  = 1 To 4
   If dec_val >= bin_count  Then
       byte$ = Byte$ + "1"
       dec_val = dec_val - bin_count
    Else
       byte$ = byte$ + "0"
    EndIf
    bin_count =bin_count / 2
  Next bit
    h$ = h$ + byte$
  Next z
    hextobin$ = h$
  End Function


Function swap_bytes$(b$)
  Local hi$, lo$
  If Len(b$)<>4 Then
    Print "String incorrect length"
    End
  EndIf
  hi$ = Left$(b$,2)
  lo$ = Right$(b$,2)
  swap_bytes$ = lo$ + hi$
  End Function


Function swap_nibbles$(n$)
  Local hi$, lo$
  If Len(n$)<>2 Then
    Print "String incorrect length"
  End
  EndIf
  hi$ = Left$(n$,1)
  lo$ = Right$(n$,1)
  swap_nibbles$ = lo$ + hi$
  End Function

Sub outcommand(c$)
  Local x
  SetPin pgd,8
  For x = 5 To 1 Step-1
    Pin(pgd) = Val(Mid$(c$,x,1))
    Pulse pgc, 0.1
  Next x
  Pin(pgd)=0
  Pulse pgc, 0.1
End Sub

Sub outdata(dat)
  Local x,y
  integertobin(dat)
  Pin(pgd)=0
  Pulse pgc,0.1
  For x = 13 To 0 Step-1
    Pin(pgd)=bin(x)
    Pulse pgc,0.1
  Next x
  Pin(pgd)=0
  Pulse pgc,0.1
End Sub

indata: 'read in 14 bits mem data from target pic
  Local x, bit$
  bit$=""
  mem_data$ = ""
  Pulse pgc,0.1
  SetPin pgd,2 'input
  For x = 1 To 14
    Pin(pgc)=1
    If Pin(pgd) = 0 Then
      bit$ = "0"
    Else
     bit$ = "1"
    EndIf
    mem_data$ = bit$ + mem_data$
    Pin(pgc)=0
  Next x
  Pulse pgc,0.1
  Return

Sub lv_prog_mode
  SetPin pgd,8
  Pin(pgd)=0
  Pin(pgc)=0
  Pin(reset)=0
  Pin(pgm)=0
  Pin(pgm)=1
  Pin(reset)=1
End Sub

Sub hv_prog_mode
  SetPin pgd,8
  Pin(vpp)=0
  Pin(pgd)=0
  Pin(pgc)=0
  Pin(vpp)=1
End Sub

Function hextodec(st$)
  Local x, y, hexbyte, char$
  hexbyte = 0
  For x = 1 tp Len(st$)
    char$ = Mid$(st$,x,1)
    y = Instr(1,"0123456789abcd",char$
    hexbyte = hexbyte Or (y-1)
    If x < Len(st$) Then hexbyte = hexbyte * 16
  Next x
  hextodec = hexbyte
End Function

menu:
Cls
Print "99 = QUIT"
Print "1 = LVP mode"
Print "2 = run mode - Target PIC MCLR high"
Print "3 = read mem data"
Print "4 = Verify Programme "
Print "5 = programme mode"
Print "6 = erase pic"
Print "7 = set programming options"
Print "8 = read config "
Print "9 = write config "
Print "10 = load hex file "
Print "11 = show file data "
Print:Print
Input "enter number   ",keyin

If keyin = 99 Then: End: EndIf
If keyin = 1 Then: lv_prog_mode:EndIf
If keyin = 2 Then: Pin(pgm)=0: Pin(reset)=1: EndIf
If keyin = 3 Then
  Cls
  For y = 0 To himem
  SetPin(pgd),8
  outcommand(read_mem$)
  GoSub indata
  outcommand(inc_addr$)
  st$= Hex$(bintodec(mem_data$))
  If Len(st$)=2 Then: st$="00" + st$ : EndIf
  If Len(st$) = 3 Then: st$ = "0"  + st$:  EndIf
  If Len(st$) = 1 Then:st$ = "000"+st$:EndIf
  Print st$+" ";
  Next y
EndIf
If keyin = 4 Then: GoSub verify: Input zz: EndIf
If keyin = 5 Then: progchip(): EndIf
If keyin = 6 Then: erasechip: EndIf
If keyin = 7 Then: GoTo setup: EndIf
If keyin = 8 Then: GoSub readconfig: EndIf
If keyin = 9 Then: GoSub writeconfig: EndIf
If keyin = 10 Then: readhexfile(): EndIf
If keyin = 11 Then: GoSub showmem: EndIf
GoTo menu

setup:
  setup$= "setup.ini"
  Open setup$ For input As #2
  Input #2, configword
  Input #2, progmode
  Input #2, hexfile$
  Input #2, himem
  Input #2, maxrom
  Close #2

setuploop:
    Cls
    Print "options"
    Print "1 = config word  "; Hex$(configword)
    Print "2 = Prog Mode";progmode
    Print "3 = hex file "; hexfile$
    Print "4 = spare"
    Print "5 = Spare"
    Print "6 = Flash Memory 'HiMem' "; himem
    Print "7 = EEprom 'MaxRom'" ; maxrom
    Print "8 = Save Parameters"
    Print "9 = Menu"
    Print:Print:Print
    Input "select parameter ", select
  If select = 9 Then: GoTo menu:EndIf
  If select = 0 Then:GoTo setup: EndIf
  If select = 1 Then: Input configword$:configword = hextodec(configword$):EndIf
  If select = 2 Then: Input progmode:EndIf
  If select = 3 Then:Input hexfile$:EndIf
  If select = 6 Then: Input himem:EndIf
  If select = 7 Then: Input maxrom:EndIf
  If select = 8 Then
    Open setup$ For output As #2
    Print #2, configword
    Print #2, progmode
    Print #2, hexfile$
    Print #2, himem
    Print #2, maxrom
    Close #2
  EndIf
GoTo setuploop

Sub readhexfile()
  Print "Initialising Hex File "
  Dim x,y,z,picaddress,hexfilenum
  For x = 0 To himem
    memdata(x) = &H3fff
  Next x
  For x = 0 To maxrom
    romdata(x) = &Hff
  Next x
  Print "Loading Hex File"
  picaddress = 0
  hexfilenum=1
  Open hexfile$ For input As #hexfilenum
  Do While Not Eof(#hexfilenum)
    Line Input #hexfilenum,hexline$
    bytecount = hextodec(Mid$(hexline$,2,2))*2
    picaddress = hextodec(Mid$(hexline$,4,4))/2
    hexline$=Mid$(hexline$,10,Len(hexline$)-11)
    If picaddress < himem Then
      x=0: y=0
      If Len(hexline$) > 0 Then
        Do
          memdata(picaddress+y) = hextodec(swap_bytes$(Mid$(hexline$,x+1,4)))
         x=x+4: y=y+1
        Loop Until x >= bytecount
      EndIf
    EndIf
  If picaddress = &H2000 Then
    x=0:y=0
    If Len(hexline$) > 0 Then
      Do
      x=x+4: y=y+1
      Loop Until x >= bytecount
    EndIf
  EndIf
  If picaddress = &h2007 Then
    configword = hextodec(swap_bytes$(Mid$(hexline$,1,4)))
  EndIf
If picaddress > &H20ff Then
  x=0: y=0
  If Len(hexline$)>0 Then
    Do
      romdata(picaddress - &H2100 + y) = hextodec(Mid$(hexline$,x+1,4))
      x=x+4: y=y+1
    Loop Until x>= bytecount
  EndIf
EndIf
Loop
  Close #1
End Sub

Sub progchip()
Local x, y, z, block
  Cls
  Print "Programming PIC "
  Print "Erasing Device "
  lv_prog_mode()
  erasechip()
  Print "Writing Programme "
  If Progmode = 1 Then
    lv_prog_mode()
    For x = 0 To himem
      If memdata(x) = &H3fff Then
        outcommand(inc_addr$)
      Else
        outcommand(load_mem_data$)
        outdata(memdata(x))
        outcommand(inc_addr$)
      EndIf
    Next x
  EndIf
  If progmode = 2 Then
    lv_prog_mode()
    outcommand(chip_erase$)
    lv_prog_mode()
    x=0
    Do While x <= himem
      block = &H3fff
      For y = 1 To 3
        If memdata(x) <> &H3fff Then
          outcommand(load_mem_data$)
          outdata(memdata(x))
        EndIf
      block = block And memdata(x)
      outcommand(inc_addr$)
      x=x+1
      Next y
      If memdata(x)<>&H3fff Then
        outcommand(load_mem_data$)
        outdata(memdata(x))
      EndIf
      block = (block And memdata(x))
      x=x+1
      If block <> &H3fff Then
        outcommand(begin_prog_only_cycle$)
        outcommand(end_pgm$)
      EndIf
      outcommand(inc_addr$)
    Loop
  EndIf
  Print "Programming EEprom data "
  lv_prog_mode()
  For x = 0 To maxrom
    outcommand(load_data_d_mem$)
    outdata(romdata(x))
    If progmode = 2 Then
      outcommand(begin_prog_only_cycle$)
      Pause 10
      outcommand(end_pgm$)
    Else
      outcommand(begin_erase_prog_cycle$)
    EndIf
    outcommand(inc_addr$)
  Next x
  Print "Programming Config memory "
  lv_prog_mode()
  outcommand(load_config$): outdata(configword)
  For y = 1 To 7
    outcommand(inc_addr$)
  Next y
    outcommand(load_mem_data$): outdata(configword)
  If progmode = 2 Then
    outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
    outcommand(inc_addr$)
    outcommand(load_mem_data$): outdata(&H3fff)
    outcommand(begin_prog_only_cycle$): outcommand(end_pgm$)
  Else
    outcommand(begin_erase_prog_cycle$)
  EndIf
End Sub

verify:
  Print "Verifying Programme memory "
  Local x
  lv_prog_mode()
  For x = 0 To himem
    If memdata(x) = &H3fff Then
      outcommand(inc_addr$)
    Else
      outcommand(read_mem$)
      GoSub indata
      If bintodec(mem_data$) <> memdata(x) Then
      Cls:Print "Fail": Input "Press Enter "zz: GoTo menu
      EndIf
      outcommand(inc_addr$)
    EndIf
  Next x
  Print "Verifying EEprom data"
  lv_prog_mode()
  For x = 0 To maxrom
    outcommand(read_data_d_mem$)
    GoSub indata
    outcommand(inc_addr$)
  Next x
  Return

showmem:
  Local x,y
  For x = 0 To 80
integertobin(memdata(x))
    For y = 1 To 14
    Print Bin(y);
    Next y:Print " "
 Next x
   Pause 3000
Return


