;test programme to flash a led on port RB0
;
;
;
	 
	#include p16f88.inc		;all f88 variables
	list p=p16f88			;device select
;
;
	
	


	uSec10 equ h'23'
	ms1 equ h'24'
	sec1 equ h'25'
	ms10 equ h'26'
	



	__config _config1, _lvp_on & _boden_off & _mclr_on & _wdt_off & _intrc_io
org h'2100'
xyz:	de 1,2,3,4,5
	
	org 0				;reset vector
	goto start
	org 4				;interrupt vector
	goto interrupt
	org 6				;main programme start address

start:					;set up pic

	bcf status,irp
	bcf status,rp1
	bsf status,rp0			;bank 1
	clrf portb
	movlw h'ff'
	movwf trisa			;port A all inputs
	clrf trisb			;port B all outputs
	bsf ansel,0			;RA0 adc input
	bsf ansel,1			;RA1 adc input
	clrf adcon1
	bsf adcon1,7			;vref set to vdd vss
	movlw b'01100000'		;set oscillator to 4mhz
	movwf osccon
	bcf status,rp0			;bank 0
	
	movlw b'00000001'		;select an0
	movwf adcon0




	

main:
	bsf portb,0	;toggle RB0 at one second
	movlw 1
	call delaysec
	bcf portb,0
	movlw 1
	call delaysec
	goto main	


delay:
	return

delay10:				;10uSec per loop
	movwf usec10		;come in with uSx10 count in w reg
delay10a:
	nop
	nop
	nop
	nop
	nop
	nop
	decfsz usec10,f
	goto delay10a
	return

delayms:
	movwf ms1			;come in with mSec count in W reg
delaymsa:
	movlw 100			;set up for 100 x 10uSec = 1 mSec
	call delay10
	decfsz ms1,f
	goto delaymsa
	return

delayms10:				;come in with mSx10 count in W reg
	movwf ms10
delayms10a:
	movlw 10
	call delayms
	decfsz ms10,f
	goto delayms10a
	return

delaysec:
	movwf sec1			;come in with seconds count in W reg
delayseca:
	movlw 100			;10 mSec
	call delayms10			
	decfsz sec1,f
	goto delayseca
	return


interrupt:
	retfie

	end


