
; 	simple test programme

	#include p16f628a.inc
	list p=p16f628a
;
	uSec10 equ h'30'		;delay variables
	ms1 equ h'31'
	sec1 equ h'32'
	ms10 equ h'33'
	
	
	__config _config1, _boden_off & _mclre_off & _wdt_off & _lvp_on & _intosc_osc_clkout



;===================================================================
;Main pic set up routine
;===================================================================



	org 0				;restart vector
	goto  start

	org 4				;location of peripheral interrupt vector
	goto  interrupt		;interrupt routine at this label

	org 6				;where programme actually starts from
;==================================================================
;                end of reset and interrupt vectors
;==================================================================

start:
	
      clrf porta			;get rid of any leftover data
      clrf portb			;ditto
	movlw h'07'
	movwf cmcon			;switch comparators off and i/o on
	bcf status, rp1 	 	;bank 0  - shouldnt have to touch this one again
      bsf status,rp0  	  	;bank 1
      movlw h'07'			;port a i/ps 0,1,2
      movwf trisa 		;set up direction register port a
      movlw b'00000000'
      movwf trisb  		;inputs port b, 4,5,6 & 7 ops
;	bcf option_reg,intedg 	;set up for rb0 1 to 0 interrupt
;	bcf option_reg,psa	;wdt = 18msec
	bcf status,rp0          ;bank 0 - normal operation
;      bsf intcon,inte 		;enable rb0 interrupt
	bsf intcon,gie          ;enable all interrupts


main_loop:
	
	
	clrf portb		;switch port b pin 0 on
	movlw 1
	call delaysec		;pause 1 second


	decf portb,f		;switch port b pin 0 off
	movlw 1			;pause 1 second
	call delaysec
	goto main_loop		;loop to main_loop


;===================================================================
;	bank select routines

bank0:
	bcf status,irp
	bcf status,rp1
	bcf status,rp0
	return

bank1:
	bcf status,irp
	bcf status,rp1
	bsf status,rp0
	return

bank2:
	bsf status,irp
	bsf status,rp1
	bcf status,rp0
	return
bank3:
	bsf status,irp
	bsf status,rp1
	bsf status,rp0
	return

;==================================================================
;delay routines - set for 4MHz clock speed
;===================================================================


delay10:			;10uSec per loop
	movwf usec10		;come in with uSx10 count in w reg
delay10a:
	nop			;pad out to 10uSecs
	nop
	nop
	nop
	nop
	nop
	decfsz usec10,f
	goto delay10a		;loop count 10uSec loops
	return

delayms:
	movwf ms1		;come in with mSec count in W reg
delaymsa:
	movlw 100		;set up for 100 x 10uSec = 1 mSec
	call delay10
	decfsz ms1,f
	goto delaymsa
	return

delayms10:			;come in with mSx10 count in W reg
	movwf ms10
delayms10a:
	movlw 10
	call delayms
	decfsz ms10,f
	goto delayms10a
	return

delaysec:
	movwf sec1		;come in with seconds count in W reg
delayseca:
	movlw 100		;1000 mSec
	call delayms10			
	decfsz sec1,f
	goto delayseca
	return

;========================================================================
;	End of Main Loop Routines etc.
;	Beginning of interrupt routines
;========================================================================
interrupt:
	
	retfie		;just in case an interrupt occurs
	
	
	end	