'
' Copyright (c) 2020, Anton Staaf.  All rights reserved.
' Use of this source code is governed by a BSD-style license that can be
' found in the LICENSE file.
'

'
' The display routines map a 2D range onto the screen, making it easy to scale
' and translate points as needed.
'
sub display.initialize display() as float, to_range() as float, from_range() as float
    local float scale_x = (to_range(2) - to_range(0)) / (from_range(2) - from_range(0))
    local float scale_y = (to_range(3) - to_range(1)) / (from_range(3) - from_range(1))
    local float scale   = min(abs(scale_x), abs(scale_y))

    display(0) = scale * sgn(scale_x)
    display(1) = scale * sgn(scale_y)

    local float center_x = display(0) * (from_range(0) + from_range(2)) / 2
    local float center_y = display(1) * (from_range(1) + from_range(3)) / 2

    display(2) = ((to_range(0) + to_range(2)) / 2) - center_x
    display(3) = ((to_range(1) + to_range(3)) / 2) - center_y
end sub

function display.screen_x(display() as float, x as float) as float
    display.screen_x = x * display(0) + display(2)
end function

function display.screen_y(display() as float, y as float) as float
    display.screen_y = y * display(1) + display(3)
end function

