'
' Copyright (c) 2020, Anton Staaf.  All rights reserved.
' Use of this source code is governed by a BSD-style license that can be
' found in the LICENSE file.
'

function math.clamp(x as float, minimum as float, maximum as float) as float
    math.clamp = min(maximum, max(minimum, x))
end function

function math.wrap(x as float, minimum as float, maximum as float) as float
    local float a = (x - minimum) / (maximum - minimum)

    math.wrap = ((a - int(a)) * (maximum - minimum)) + minimum
end function

function math.lerp(a as float, b as float, t as float) as float
    math.lerp = a + (b - a) * t
end function

sub math.swap a as float, b as float
    local float t = a

    a = b
    b = t
end sub
