Function ToBCD%(d%)
  Local i% = d% Mod 100
  ToBCD% = ((i% \ 10) << 4) + (i% Mod 10)
End Function

Function FromBCD%(b%)
  FromBCD% = (b% >> 4) * 10 + (b% And 15)
End Function

Function D2$(i%)
  D2$ = Format$(i%,"%02g")
End Function

Function DOW%(y%,mo%,d%)
  ' 0 = Saturday
  Local i% = y% Mod 100
  DOW% = (i% + (i% \ 4) + mo% + d% - 1) Mod 7
End Function

Sub OpenI2C
  SetPin GP4,GP5,I2C
  I2C Open 1000,1000
End Sub

Sub SetRTCTime y%,mo%,d%,h%,mi%
  Local mib% = ToBCD%(mi%)
  Local hb% = ToBCD%(h%)
  Local db% = ToBCD%(d%)
  Local dwb% = ToBCD%(DOW%(y%,mo%,d%))
  Local mob% = ToBCD%(mo%)
  Local yb% = ToBCD%(y%)
  Dim data%(7) = (3,0,mib%,hb%,db%,dow%,mob%,yb%)
  OpenI2C
  I2C Write &H68, 0, 8, data%()
  I2C Close
End Sub

Sub GetRTCTime
  Local data%(6)
  OpenI2C
  I2C Write &H68, 0, 1, 3
  I2C Read &H68, 0, 7, data%()
  I2C Close
  mi% = FromBCD%(data%(1) And &b1111111)
  h% = FromBCD%(data%(2) And &b1111111)
  d% = FromBCD%(data%(3) And &b111111)
  mo% = FromBCD%(data%(5) And &b11111)
  y% = FromBCD%(data%(6))
  Time$ = D2$(h%) + ":" + D2$(mi%)
  Date$ = D2$(y% + 2000) + "-" + D2$(mo%) + "-" + D2$(d%)
End Sub

