Function _bcd%(d%)
  ' decimal to BCD
  Local i% = d% Mod 100
  _bcd% = ((i% \ 10) << 4) + (i% Mod 10)
End Function

Function _dec%(b%)
  ' BCD to decimal
  _dec% = (b% >> 4) * 10 + (b% And 15)
End Function

Function _fmt$(i%)
  _fmt$ = Format$(i%, "%02g")
End Function

Sub MM.Startup y%,mo%,d%,h%,mi% ' year, month, day, hour, minute
  Local dt%(7)
  SetPin GP4,GP5,I2C
  I2C Open 400,400
  If y% = 0 Then ' set Date$ and Time$ from PCF8523 RTC
    I2C Write &H68, 0, 1, 3
    I2C Read &H68, 0, 7, dt%()
    mi% = _dec%(dt%(1) And &b1111111)
    h% = _dec%(dt%(2) And &b1111111)
    d% = _dec%(dt%(3) And &b111111)
    mo% = _dec%(dt%(5) And &b11111)
    y% = _dec%(dt%(6))
    Time$ = _fmt$(h%) + ":" + _fmt$(mi%)
    Date$ = _fmt$(y% + 2000) + "-" + _fmt$(mo%) + "-" + _fmt$(d%)
  Else ' set date and time to PCF8523 RTC
    dt%(0) = 3
    dt%(1) = 9
    dt%(2) = _bcd%(mi%)
    dt%(3) = _bcd%(h%)
    dt%(4) = _bcd%(d%)
    Local i% = y% Mod 100
    dt%(5) = _bcd%((i% + (i% \ 4) + mo% + d% - 1) Mod 7) 'day of Week
    dt%(6) = _bcd%(mo%)
    dt%(7) = _bcd%(y%)
    I2C Write &H68, 0, 8, dt%()
  EndIf
  I2C Close
  SetPin GP4, OFF
  SetPin GP5, OFF
End Sub

Sub MM.Prompt
  Print Cwd$ ">";
End Sub
