Cls
memclear
'AP Only Version
'system variables 
ver = "ESP8266-McuAPO-V6.0"
node = "ESP_Batt Mon"
port = 5001
castip="192.168.4.255"

localip = ip()


'startup
timesetup(10,0)
baudrate 38400
serialflush
serialtimeout 1000
serialbranch [update]
udpbegin port
udpbranch [udp.receive]
print ver
print "ID=" & node
serialprintln "ESP:|ESP|start||" 
button "Exit", [quit]
wait

[udp.receive]
strin = udpread()
'serialprintln "debug:" & strin
if instr(strin,"Who are you?") > 0 then 
udpreply  "ID=" & node
return
end If
if instr(strin,"uMite?") > 0 then 
thisip=ip()
strin=udpremote()
gosub [parse]
remip=field
udpwrite remip,port,"uMite:|" & thisip & ":" & node
return
end if
if instr(strin,"bCast") > 0 then 
gosub [parse]
serialprint "udp.rec:" & strin
return
end if
if instr(strin,"Mcu") > 0 then 
gosub [parse]
GoSub [update2]
Return
end If
If instr(strin,node) > 0 then 
gosub [parse]
serialprint "udp.rec:" & strin
end if
Return

[update]
serialinput strin
[update2]
'serialprintln "debug:" & strin
if instr(strin,"udp.cast:") >0 then 
udpwrite castip,port,mid(strin,10)
serialprint chr$(4)
return
end if
if instr(strin,"udp.send:") >0 then 
udpwrite remip,port,mid(strin,10)
serialprint chr$(4)
return
end if
if instr(strin,"time:") >0 then gosub [gettime]
if instr(strin,"info:") >0 then gosub [getinfo]
if instr(strin,"quit:") >0 then goto [quit]
if instr(strin,"sleep:") >0 then goto [gotosleep]
if instr(strin,"wifion:") >0 then goto [wifi1]
if instr(strin,"wifioff:") >0 then goto [wifi0]
if instr(strin,"flush:") >0 then serialflush
if instr(strin,"reboot:") >0 then 
baudrate 9600
GoTo [reboot]
end if
Return


[getinfo]
serialprintln "ESP:|ESP|ver||" & ver
delay 100
serialprintln "ESP:|ESP|ip||" & ip()
delay 100
serialprintln "ESP:|ESP|flash||" & flashfree()
delay 100
serialprintln "ESP:|ESP|ram||" & ramfree()
delay 100
serialprintln "ESP:|ESP|myid||" & node
delay 100
serialprintln "ESP:|ESP|port||" & port
serialprint chr$(4)
return

[gettime]
y = time(year) 
if val(y) < 2016 then return
serialprintln "ESP:|ESP|ntp||" & time()
Return

[parse]
field = ""
delim = instr(strin,":")
this = delim - 1
rest = len(strin) - delim
field = left(strin,this)
strin = right(strin,rest)
return

[gotosleep]
sleep 3600
return

[wifi1]
'connect "TP"
serialprintln "ESP:|ESP|wifi||- Not implemended"
return

[wifi0]
wifioff
serialprintln "ESP:|ESP|wifi||- Off"
Return


[reboot]
cls
wprint "Rebooting Wifi ....."
delay 1000
reboot
Wait

[quit]
wprint "<a href='/'>Menu</a>"
wait
End