  'Battery Monitor for Micromite
  'M Ogden June 2017
  'http://www.codenquilts.com.au
  
  'Versions
  '1.2
  
  Option Explicit
  Option Default Integer
  Option autorun On
  const HalfVccRef=1.65
  const mvPerAmp=0.044
  const Vcal=4.68
  const zeroA=0.1
  const SWVer="1.20"
  'Variables
  dim BatVpin=26  'Battery Voltage
  dim BatApin=25  'Battery Current
  dim BatTpin=18  'Battery Temperature
  dim BatFpin=24  'Battery Fault
  
  Dim Flags(10)
  
  dim BatV as float
  dim BatA as float
  dim BatT as float
  dim TLoadAmps as float
  dim AvgLoadAmps as float
  dim float LoadAmpHrs,LoadAmpHrs1,LoadAmpHrs2,AmpHrs
  dim TChgAmps as float
  dim AvgChgAmps as float
  dim float ChgAmpHrs,ChgAmpHrs1,ChgAmpHrs2,expired,hrsleft
  dim Sample,ChgSample,BatF,msTimer,SOC,backup
  
  
  setpin(BatVpin),ain
  setpin(BatApin),ain
  setpin(BatFpin),din
  
  
  initWiFifile 1 'call initialise WiFi file transfer library, set comm port to use
  
  
  
  settick 250, ReadBatt,1
  settick 5000, Update,2
  settick 3600, SaveToFlash,3
  var restore
  if MM.WATCHDOG=1 then 'restart due to prog fail
    print "BMon "+swver+ " Restart-SW failure ........."
    timer=msTimer
  else                   'normal restart
    print "BMon "+swver+ " Normal Startup ........."
    timer=0
  end if
  
  If backup = 0 Then 'this is a completely fresh startup
    backup=1
    LoadAmpHrs2=0:LoadAmpHrs1=0:LoadAmpHrs=0:ChgAmpHrs2=0:ChgAmpHrs1=0:ChgAmpHrs=0:amphrs=18:soc=50
    var save LoadAmpHrs2,LoadAmpHrs1,LoadAmpHrs,ChgAmpHrs2,ChgAmpHrs1,ChgAmpHrs,AmpHrs,SOC,backup
  end if
  
  'Incorporate into main loop
  '*** Start User main program loop
  Do
    
    Watchdog 8000
    
    '***** mxWiFi Hook ****
    if userprocessflag=1 then
      StartTime = Timer
      UserProcess
      UserProcessFlag=0
      xbsend "udp.cast:|"+from$+"|"+chr$(4)+"|"
      Print "Processing elapsed time"; Timer-StartTime
    endif
    '***** End mxWiFi Hook ****
    
  loop
  '***** End main program loop
  
  'External command processing sub Routine if required
sub extCmd
  print "External Commands:- From:";from$;" Cmd:";cmd$;" Config:";cfg$;" Data:";strin$
  local temp$,ext$
  select case cmd$
      
    case "Log"
      
    case "uMsavetoflash"
      SavetoFlash
    case "uMusage"
      
    case "uMconfig"
      
  end Select
end sub
  
sub SaveToFlash
  msTimer=timer
  backup=1
  var save LoadAmpHrs2,LoadAmpHrs1,LoadAmpHrs,ChgAmpHrs2,ChgAmpHrs1,ChgAmpHrs,msTimer,AmpHrs,SOC
end sub
  
sub update
  batT=tempr(battpin)
  estsoc
  print str$(hrsleft,2,1);" ";str$(batT,2,1);" ";str$(batV,2,1);" ";str$(batA,2,2);" ";str$(loadAmphrs,2,2);" ";str$(ChgAmphrs,2,2);" ";str$(SOC)
  xbsend "udp.cast:||,"+str$(hrsleft,2,1)+","+str$(batT,2,1)+","+str$(batV,2,1)+","+str$(batA,2,2)+","+str$(loadAmphrs,2,2)+","+str$(ChgAmphrs,2,2)+","+str$(SOC)
end sub
  
sub EstSOC
  print bata
  if batA<=-0.3 then  'only calculate if load current > 300mA
    print batv
    if batv =<11.5 Then soc=10
    if batv =<11.6 Then soc=20
    if batv =<11.8 Then soc=30
    if batv =<11.96 Then soc=40
    if batv =>12.10 then soc=50
    if batv =>12.24 then soc=60
    if batv =>12.37then soc=70
    if batv =<12.5 Then soc=80
    if batv =<12.62 Then soc=90
    if batv =<12.75 Then soc=95
    if batv =>12.75then soc=98
  else  'charging
    if batv>13.5 and bata<amphrs/100 then
      soc=99
    elseif batv>13.5 and bata<((amphrs/100)*2) then
      soc=95
    elseif batv>13.5 and bata<((amphrs/100)*3) then
      soc=90
    else
      soc=50
    end if
  end if
end sub
  
sub ReadBatt
  'StartTime = Timer
  local msec
  local Etime as float
  local AmpSeconds as float
  local LbatA as float
  local CbatA as float
  if pin(batfpin)=0 then  'set Battery Current sense error
    flag(0)=1
    exit sub
  end if
  msec = timer  ''elapsed time in miliseconds
  Etime=msec/1000  'elapsed time in seconds
  expired=Etime/3600  'Expired period in Hrs
  HrsLeft=24-expired
  if etime=>86400 then  '24 hrs reached
    'save parameters
    LoadAmpHrs2=LoadAmpHrs1
    LoadAmpHrs1=LoadAmpHrs
    ChgAmpHrs2=ChgAmpHrs1
    ChgAmpHrs1=ChgAmpHrs
    ChgAmpHrs=0:LoadAmpHrs=0
    var save LoadAmpHrs2,LoadAmpHrs1,LoadAmpHrs,ChgAmpHrs2,ChgAmpHrs1,ChgAmpHrs
    timer=0
    exit sub
  end if
  sample=sample+1
  'read battery voltage and current sense
  BatV=ReadVoltage(batvpin,vCal,16) 'battery voltage
  BatA=ReadCurrent(batApin,HalfVccRef,mvPerAmp,zeroA,16) 'battery Load current
  'nb Charge discharge depends on way sensor is wired so may have to invert BatA for display
  if sgn(BatA)=0 then 'Zero current
    lbatA=0:cbatA=0
  elseif sgn(BatA)=-1 then 'Charging battery
    cbatA=0:lbatA=abs(BatA)
    bata=lbatA  'invert number
  else                    'discharge battery
    cbatA=BatA:lbatA=0
    batA=batA-(bata*2)  'invert number
  end if
  'load current
  TLoadAmps=TLoadamps+LbatA  'total load current
  AvgLoadAmps=TLoadAmps/sample 'calculate avg load current
  ampseconds=AvgLoadAmps*etime  'calculate avg load current/sec
  LoadAmpHrs=ampseconds/3600  'calculate load amphours
  'charge current
  TChgAmps=TChgamps+CbatA  'total Charge current
  AvgChgAmps=TChgAmps/sample 'calculate avg load current
  ampseconds=AvgChgAmps*etime  'calculate avg load current/sec
  ChgAmpHrs=ampseconds/3600  'calculate load amphours
end sub
  
  
Function ReadCurrent(InputPin,VoltageOffset as float,Cal as float,zA as float,Smoothing)as float
  Local Count
  Local Voltage as float
  Local AccVoltage as float
  For Count = 1 To Smoothing    'take mulpiple reads
    Voltage=Pin(InputPin)
    AccVoltage = AccVoltage+Voltage
  Next Count
  'print  ((AccVoltage/smoothing)-VoltageOffset)
  AccVoltage = ((AccVoltage/smoothing)-VoltageOffset)/cal '
  If abs(AccVoltage)<=zA Then accvoltage=0   'trap zero range numbers
  Readcurrent=AccVoltage
End Function
  
Function ReadVoltage(InputPin,Cal as float,Smoothing)as float
  Local Count
  Local Voltage as float
  Local AccVoltage as float
  For Count = 1 To Smoothing    'take mulpiple reads
    Voltage=Pin(InputPin)
    AccVoltage = AccVoltage+Voltage
  Next Count
  'print accVoltage/smoothing
  AccVoltage = (AccVoltage/smoothing)*cal '
  If AccVoltage<0 Then accvoltage=0
  ReadVoltage=AccVoltage  'trap negative numbers
End Function

