'PASM 0.12a

'** Ref info for development reminder only ** - This block to be removed
'PIO(PINCTRL no_side_set_pins [,no_set_pins] [,no_out_pins] [,IN base] [,side_set_base] [,set_base])
'PIO(EXECCTRL jmp_pin ,wrap_target, wrap
'PIO(SHIFTCTRL push_threshold [,pull_threshold] [,autopush] [,autopull])
'PIO INIT MACHINE pio, statemachine, clockspeed, PINCTRL register, EXECCTRL register,
' SHIFTCTRL register

Option explicit

'PASM requires an output array and somewhere to put the EXECCTRL register
Dim pio1%(7)  'output array - unused area is padded with nop statements (&hA042).
Dim integer PINCTRL(3),EXECCTRL(3),SHIFTCTRL(3),CLKDIV(3)  'global state machine registers


'Note:
'Delimiters between parts of the commands can be a single space or a single comma.
'Multiple delimiters are not supported and those instructions will not assemble correctly.
'Data to be assembled must finish with a null data string i.e. DATA ""

'Directives - .word <word> / .origin / .wrap target / .wrap
'Pseudoinstructions - .nop (assembles as mov y,y)

datablock:                   'marks the beginning of the data block
Data ".origin 0"             'origin will almost always be 0 to run from start of memory
Data "nop"
Data "nop"
Data ".wrap target"          'loop back here when .wrap is reached
Data "nop"                   'comments can be used in the data block if required
Data "nop"
Data ".wrap"                 'loop back to .wrap target
Data "nop"
Data ".word 999"             'just a data value
Data ""                      'use "" to mark last data statement in the block

initrp                       'initialise the state machine registers to default values
PASM "datablock",pio1%(),0   'assemble the prog - data block label, output array, state machine
fileman("s","testfile")      'save the file "testfile.PIO" to the SD card
End


'----------------- SUBROUTINES -------------------------
Sub PASM(data_block$, array%(), machine)
  'uses Function argn$, Sub store,
  Local info$="** RP2040 PIO ASSEMBLER - The Backshed Forum - Mixtel90"
  Local i,j,c$,d$,dv,jo,nf=1
  Local holdpc, pc, pm(31)   'program counter pointing to program memory

'  Restore data_block$        'get any labels and store in lbl$()
'  j=0
'  Do
'    Read d$
'    If d$="" Then Exit
'    If Right$(d$,1)=":" Then lbl$(j)=Left$(d$,Len(d$)-1)
'    Inc j
'  Loop

  Restore data_block$        'point to first DATA statement
'  execctrl(machine)=0

  Do                         'start to process the program
    Read d$                  'read the data statement
'    If lbl$(pc)>"" Then Read d$:holdpc=1
    If d$="" Then Exit
    d$=LCase$(d$)
    holdpc=0
    c$=argn$(d$,1)           'reset function and get first argument / command
    Select Case c$           'and do something with it
'.wrap-------------------
      Case ".wrap"
        c$=argn$(d$)
        If c$>"" Then '.wrap
          execctrl(machine)=execctrl(machine)+((pc)<<7)
        Else          '.wrap target
          execctrl(machine)=execctrl(machine)+((pc-1)<<12)
        EndIf
        holdpc=1
'.origin---------------
      Case ".origin"
        c$=argn$(d$)
        jo=Val(c$)           'this is the offset to be added to all jumps (normally 0)
        holdpc=1
'.word----------------
      Case ".word"
        c$=argn$(d$)
        pm(pc)=Val(c$)
'nop-------------------
      Case "nop"
        pm(pc)=&hA042        'use mov y,y as a nop
'jmp--------------------
      Case "jmp"
        pm(pc)=0
        c$=argn$(d$)         'get the first argument
          i=Instr("  !x x--!y y--x!=pin!os",Left$(c$,3))
        If i>0 And c$<>"0" Then  'this must be a conditional jump
          i=i/3
          pm(pc)=pm(pc)+((i)<<5)     'add the condition to av
'          i=chklabel(argn$(d$))       'get the destination argument
'          PM(pc)=pm(pc)+i+jo
          PM(pc)=pm(pc)+Val(c$)+jo      'and add it to av
        Else                 'no condition so must be a direct destination
'        i=chklabel(argn$(d$))       'get the destination argument
'          PM(pc)=pm(pc)+i+jo
          pm(pc)=pm(pc)+Val(c$)+jo   'so add it to av
        EndIf
'wait---------------------
      Case "wait"
        c$=argn$(d$)         'get polarity bit argument
        pm(pc)=(1<<13)+Val(c$)*128    'and add it
        c$=argn$(d$)         'get condition argument
        i=Instr("  gpipinirq",Left$(c$,3))
        i=i/3
        pm(pc)=pm(pc)+((i-1)<<5)     'add the condition to av
        c$=argn$(d$)          'get the index value
        pm(pc)=pm(pc)+Val(c$)        'add it to av
'in---------------------
      Case "in"
        pm(pc)=2<<13
        c$=argn$(d$)         'get source
        i=Instr("  pinx  y  nul      isrosr",Left$(c$,3))
        If i>0 Then
          i=i/3
          pm(pc)=pm(pc)+((i-1)<<5)   'and add it
        EndIf
        c$=argn$(d$)         'get the index value
        pm(pc)=pm(pc)+Val(c$)'add it to av
'out-----------------------
      Case "out"
        pm(pc)=3<<13
        c$=argn$(d$)         'get source
        i=Instr("   pinsx   y   nullpindpc  isr exec",Left$(c$,4))
        i=i/4                'will have a value of 1 for "pins"
        pm(pc)=pm(pc)+((i-1)<<5)      '"pins"= destination 0, so subtract 1
        c$=argn$(d$)         'get the index value
        i=Val(c$)
        If i>31 Then i=0     'trap 32 so we don't overwrite the destination bits
        pm(pc)=pm(pc)+i      'add it to av
'push----------------------
      Case "push"
        pm(pc)=(4<<13)+32    'iffull not set and block set by default so "block" does nothing
        If c$="iffull" Then pm(pc)=pm(pc)+64
        If c$="noblock" Then pm(pc)=pm(pc)-32
'pull--------------------
      Case "pull"
        pm(pc)=(4<<13)+128+32
        c$=argn$(d$)
        If c$="ifempty" Then pm(pc)=pm(pc)+64
        If c$="noblock" Then pm(pc)=pm(pc)-32
'mov----------------------
      Case "mov"
        pm(pc)=(5<<13)
        c$=argn$(d$)         'get destination argument
        i=Instr("  pinx  y     exepc isrosr",Left$(c$,3))  'destination
        i=i/3
        pm(pc)=pm(pc)+((i-1)<<5)     'and add it to av
        c$=argn$(d$)         'get condition or source argument
        If c$="!" Or c$="-" Then pm(pc)=pm(pc)+8:c$=argn$(d$) '! or - condition
        If c$="::" Then pm(pc)=pm(pc)+16:c$=argn$(d$)         ':: condition
        i=Instr("  pinx  y  nul   staisrosr",Left$(c$,3))  'source
        i=i/3
        pm(pc)=pm(pc)+(i-1)  'add source to av
'irq-----------------------------
      Case "irq"
        pm(pc)=(6<<13)
        i=Instr(d$,"rel")    'i is set if irq number to be calculated from state machine#
        If i>0 Then pm(pc)=pm(pc)+16 'set rel flag (MSB of irq index)
        c$=argn$(d$)         'get first argument
        Select Case c$
          Case "set","nowait"'set the irq without waiting
            c$=argn$(d$)     'get the irq number
            j=Val(c$)        'and save it
          Case "wait"
            pm(pc)=pm(pc)+32 'set the wait bit
            c$=argn$(d$)     'get the irq number
            j=Val(c$)        'and save it
          Case "clear"
            pm(pc)=pm(pc)+64 'set the clear bit. The wait bit is ignored
            c$=argn$(d$)     'get the irq number
            j=Val(c$)        'and save it
          Case Else
            j=pm(pc)+Val(c$) 'it must be just an irq number - save it
        End Select
        If i>0 Then          'it's rel irq
          pm(pc)=pm(pc)+((j+machine) Mod 4) 'add the rel index
        Else
          pm(pc)=pm(pc)+j    'it's not rel, so just add the index
        EndIf
'set----------------------
      Case "set"
        pm(pc)=7<<13
        c$=argn$(d$)
        Select Case c$
          Case "pins"
          Case "x":pm(pc)=pm(pc)+(1<<5)
          Case "y":pm(pc)=pm(pc)+(2<<5)
          Case "pindirs":pm(pc)=pm(pc)+(4<<5)
        End Select
        c$=argn$(d$)         'get the data
        pm(pc)=pm(pc)+Val(c$)'add it to av
      Case Else
        Print "PASM Error, Line"pc": Unrecognised opcode"
'---------------------
    End Select
    c$=argn$(d$)             'get next argument
    If pc>=0 Then
      If c$="side" Then      'look for "side" argument
        c$=argn$(d$)         'if we find it then find which side & install it
        If c$="0" Then pm(pc)=pm(pc)+(&b10<<11)
        If c$="1" Then pm(pc)=pm(pc)+(&b11<<11)
        c$=argn$(d$)
      EndIf
      If Left$(c$,1)="[" Then 'look for delay argument
        i=Instr(c$,"]")
        dv=Val(Mid$(c$,2,Len(c$)-2)) 'extract the value from between the brackets
        If dv<0 Or dv>32 Then Print "PASM Error, Line"pc": Illegal delay value"
        pm(pc)=pm(pc)+(dv<<8)                'and install it
      EndIf
    If holdpc=0 Then Inc pc  'loop back for the next program statement
  Loop

  For i=0 To pc-1            'pack the contents of pm() into 64-bit words
  store array%(),pm(i)
  Next
  For i=pc To 31             'pad out the 64 bit words with nop instructions
  store array%(),&hA042
  Next

End Sub


'return the next argument$ in d$ or null$ if none found
'delimited by a comma or a space
Function argn$(d$,r)
Local a$
  Static n=1
  If r=1 Then n=1            'if r is present and is -1 then reset (overkill)
  argn$=Field$(d$,n," , ")   'get argument from position n to delimiter
  If argn$="" Then n=1:Exit Function 'reset n if we got to end of d$ (null string)
  n=n+1
End Function


'pack the 16-bit instruction into 64-bit integers
Sub store(array%(),instruction%)
  Static integer word=0, element=0
  array%(element)=array%(element)+(instruction%<<word)
  word=word+16
  If word>50 Then element=element+1:word=0
End Sub


'convert a binary string to decimal
Function bin2dec(v$)
  Local i,n,p
  For i=1 To Len(v$)
    n=(2*p)+Val(Mid$(v$,i,1))
    p=n
  Next
  bin2dec=n
End Function


'Initialise RP2040 registers
Sub initRP
  Local i
  For i=0 To 3
    PINCTRL(i)=  &b00010100000000000000000000000000
    EXECCTRL(i)= &b00000000000000011111000000000000
    SHIFTCTRL(i)=&b00000000000011000000000000000000
  Next i
End Sub


'a simple file manager for *.PIO files on a SD card
'on entry mode$ is "D", "S" or "L" for directory, save or load
'f$ is the filename (ignored for the "D" command)
'pio1%, EXECCTRL(), SHIFTCTRL(), PINCTRL() and CLKDIV() are global
Sub fileman(mode$,f$)
  Local k$,i
  f$=Field$(f$,1,".")+".PIO"
  Select Case mode$
    Case "d","D"
      k$=Dir$("*.PIO",file)
      Do While k$<>""
        Print k$
        k$=Dir$()
      Loop
    Case "s","S"
      On error skip 9
      Open f$ For output As #1
      For i=0 To 7
        Print #1,Str$(pio1%(i))
      Next
      For i=0 To 3
        Print #1,Str$(EXECCTRL(i))
        Print #1,Str$(SHIFTCTRL(i))
        Print #1,Str$(PINCTRL(i))
        Print #1,Str$(CLKDIV(i))
      Next
      Close #1
    Case "l","L"
      Open f$ For input As #1
      For i=0 To 7
        Input #1,k$
        pio1%(i)=Val(k$)
      Next
      For i=0 To 3
        Input #1,k$
        EXECCTRL(i)=Val(k$)
        Input #1,k$
        SHIFTCTRL(i)=Val(k$)
        Input #1,k$
        PINCTRL(i)=Val(k$)
        Input #1.k$
        CLKDIV(i)=Val(k$)
      Next
      Close #1
  End Select
End Sub




'*** ==== Sample Data For Testing ==== ***
'this can be safely deleted

sample1:
Data "pull noblock side 0","mov x, osr","mov y, isr","jmp x!=y 5","jmp 6 side 1"
Data "nop","jmp y-- 3",""

sample2:
Data "set pindirs,0 side 0 [7]","set pindirs,1 side 0 [7]"
Data "set pindirs,0 side 1 [7]","set pindirs,1 side 1 [7]",""

sample3:
'Data ".origin 5"
'Data "start:"
Data "jmp y-- 12"
Data "irq wait 0 rel"
'Data ".word 999"
Data "set x,7"
Data "out pindirs,1 [7]"
Data "nop side 1 [2]"
Data "wait 1 pin 1 [4]"
Data "in pins,1 [7]"
Data "jmp x--,3 side 0 [7]"
'Data "alabel:"
Data "out pindirs,1 [7]"
Data "nop side 1 [7]"
Data "wait 1 pin,1 [7]"
Data "jmp pin 0 side 0 [2]"
Data ".wrap target"
Data "out x,6"
Data "out y 1"
Data "jmp !x 2"
Data "out null,32"
Data "out exec, 16"
Data "jmp x-- 16"
Data ".wrap"
Data ""

sample4:
Data "out x,1 side 1"
Data "jmp !x,3 [6]"
Data "jmp 0 side 0 [7]"
Data "jmp 4 [7]"
'Data "label1:"
Data "out x,1 side 0"
Data "jmp !x,7 [6]"
Data "jmp 4 side 1 [7]"
Data "jmp 0,[7]"
Data ""

sample5:
Data "wait 1 pin 0 [11]"
Data "jmp pin,4"
Data "in x,1"
Data "jmp 0"
Data "in y,1 [1]"
Data ".wrap target"
Data "wait 0 pin,0 [11]"
Data "jmp pin,9"
Data "in y,1"
Data "jmp 0"
Data "in x,1 [1]"
Data ".wrap"
Data ""

sample6:   'problem with this sample. Why is bit 12 not set on official assembler?
Data ".wrap target"
Data "pull block side 0"
Data "in osr,1 side 0"
Data "out null,8 side 0"
Data "in osr,1 side 0"
Data "out null,8 side 0"
Data "in osr,1 side 0"
Data "out null,32 side 0"
Data "pull block side 0"
Data "in osr,1 side 1"
Data "out null,8 side 1"
Data "in osr,1 side 1"
Data "out null,8 side 1"
Data "in osr,1 side 1"
Data "out null,32 side 1"
Data "in null,26 side 1"
Data "pull block side 1"
Data "mov pins :: isr side 1"
Data ".wrap"
Data ""

sample7:
Data ".wrap target"
Data "pull ifempty block"
Data "set x,2"
Data "in osr,5"
Data "out null,5"
Data "in null,3"
Data "jmp x--,2"
Data "in y,8"
Data "mov isr :: isr"
Data "out nul,1"
Data "set x,31"
Data "set pins,0"
Data "mov pins,isr [6]"
Data "set pins,1"
Data "in isr,1 [6]"
Data "jmp x--,10"
Data ".wrap"
Data ""

sample8:
Data ".wrap target"
Data "pull block"
Data "mov x ! osr"
Data "pull block"
Data "mov y,osr"
Data "jmp 6"
Data "jmp x--,6"
Data "jmp y--,5"
Data "mov isr ! x"
Data "push block"
Data ".wrap"
Data ""

sample9:
Data "wait 1 pin,0 [11]"
Data "jmp pin,4"
Data "in x,1"
Data "jmp 0"
Data "in y,1 [1]"
Data ".wrap target"
Data "wait 0 pin,0 [11]"
Data "jmp pin,9"
Data "in y,1"
Data "jmp 0"
Data "in x,1 [1]"
Data ".wrap"
Data ""

sample10:
Data ".wrap target"
Data "out x,1 side 1"
Data "jmp !x,3 [6]"
Data "jmp 0 side 0 [7]"
Data "jmp 4 [7]"
Data "out x,1 side 0"
Data "jmp !x,7 [6]"
Data "jmp 4 side 1 [7]"
Data "jmp 0 [7]"
Data ".wrap"
Data ""

samplex:
Data "nop side 1 [7]"
Data ""                                                                                             