// *
// * File:   defaultPin.c
// * Author: Nathan
// *
// * Created on 13. Dezember 2015, 20:25
// *
// **************************************************************************
//
// Copyright 2015 Nathan
//
// Licensed under the Apache License, Version 2.0 (the "License"); 
// you may not use this file except in compliance with the License. 
// You may obtain a copy of the License at 
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software 
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
// How to build: compiler V1.33 or V1.34 
// -- header file -- (required) part of  Micromite Firmware package                 
// CFunctions.h  <-- (version >= 5.1)
// --compiler--
// compile options: -fpic -membedded-data -mno-long-calls -fno-jump-tables -mno-jals -mno-abicalls  -mgpopt -Wuninitialized -Wunused-variable -Wunused-value -Wunreachable-codeompile option
// optimization: O1
// exclude: floating point
// -- linker --
// exclude standard libraries
// do not link startup code
// exclude floating-point library
// -- translation into basic --
// cfgen.exe is a good choice to do so (merge option, csub), VersionSep 2015 ++
//
// V1.0 first test version                                            Nov. 2015
// V1.1 fix casting bug for unsigned char, reorder call               May. 2016
//
// defaultPin(mode) -- report / set unconf pins to default value
// mode:     function:
// 0  print actual unconfigured pins
// 1  input, pull down
// 2  input, pull up
// 3  output, low
// 4  output, high
//
//

#define _SUPPRESS_PLIB_WARNING
#define _DISABLE_OPENADC10_CONFIGPORT_WARNING

#include <xc.h>			   // Required for SFR defs
#include  "CFunctions.h"

//
// make some address calculations to get the flash position of the actual
// function. This should be possilbe by fp pointer, too.
// I do not trust the fp, lets use the ra register instead
//

 __attribute__((noinline)) void getFPCs(void *b, volatile unsigned int *c)
     {
         *c = (unsigned int) (__builtin_return_address (0) - b ) ;     
     }
 
 void printPinNum (unsigned char i) { // tons of time, no need to optimize
                  unsigned char p = (i / 100) + '0' ;
                  unsigned int r = i % 100 ;
                  unsigned char p1 = (r / 10) + '0' ;
                  unsigned char p2 = (r % 10) + '0' ;
                  putConsole(p);
                  putConsole(p1),
                  putConsole(p2);
                  putConsole('\r');
                  putConsole('\n');
                  
 } 
//
// we use const var so we have to use the main
//
void main(long long *_value) {
volatile unsigned int libOffs ;
getFPCs(&&getFPCLab,&libOffs) ; // warning can be ignored, stupid editor
getFPCLab: { }
static const unsigned char _outStr[] = "undefined Pins info:\r\n" ;
static const unsigned char _excl28Pin[] = {
        1,8,
        11,12, // console
        13,19,20,27,28 
} ;
static const unsigned char _excl44Pin[] = {
        6,7,16,17,18,28,29,
        33,34, //console
        39,40 
} ;
static const unsigned char _excl64Pin[] = {
        7,9,10,18,20,25,26,33,34,
        35,36,37,38,39,40,41,56,57,   
        58,6 // console
} ;
static const unsigned char _excl100Pin[] = {
        2,13,15,16,30,31,36,37,45,46,
        54,55,56,57,62,63,64,65,75,85,86,
        87,89 // console
} ;

unsigned char pinNum = NBRPINS ;
unsigned char * PinExcl = 0 ;
unsigned char PinExclLen = 0 ;
unsigned char value = 0 ;
if (_value != NULL) {value = (unsigned char)*_value;}
unsigned char * outStr = (unsigned char *)((void *)_outStr + libOffs) ;

switch (pinNum) { 
  case 28:
        PinExcl = (unsigned char *)_excl28Pin ;
        PinExclLen = sizeof(_excl28Pin);
  break ;
  case 44:
        PinExcl = (unsigned char *)_excl44Pin ;
        PinExclLen = sizeof(_excl44Pin); 
  break ;
  case 64:
        PinExcl = (unsigned char *)_excl64Pin ;
        PinExclLen = sizeof(_excl64Pin);
  break ;
  case 100:
        PinExcl = (unsigned char *)_excl100Pin ;
        PinExclLen = sizeof(_excl100Pin);
  break ;
  default:
        return ;
  break ;
}
PinExcl = (unsigned char *) ((void *)PinExcl + libOffs );

unsigned char xarray[pinNum+1],i;
for ( i = 0 ; i<=pinNum ;i++){ xarray[i] = 0 ; } // set to zero
for ( i = 0 ; i < PinExclLen ; i++) {            // fill up look up table
    xarray[PinExcl[i]] = 1 ; 
}
for ( i = 1 ; i<=pinNum ;i++){
    if (xarray[i] == 0 && ExtCurrentConfig[i] == 0) {
        int a = 0,b = 0 ;
         switch (value) { // experimentle 
             case 1: // input pull down
                 a =  EXT_DIG_IN ;
                 b =  CNPDSET ;
                 break ;
             case 2: // input pull up
                 a = EXT_DIG_IN ;
                 b = CNPUSET ;
                 break ;
             case 3: // output low
                 a = EXT_DIG_OUT ;
                 b = LATCLR ;
                 break ;
             case 4: // output high
                 a = EXT_DIG_OUT ;
                 b = LATSET ;
                 break ;
             case 0: // print the pins
                 while(*outStr){ putConsole(*outStr); outStr++; };
                 printPinNum(i);
                 break ;
         }
         if ( a ) {
           ExtCfg(i, a,0);
           PinSetBit(i, b);
         }
         
    }
}
return ;
}