option explicit
option base 0

const SWAP_SWAP = 0
const SWAP_COPY = 1
dim integer swapType = SWAP_SWAP
dim integer writePage = 1
dim integer displayPage = 0

dim integer frameNum = 0
dim integer vsyncCount = 0
dim integer simSyncCount = 0
dim float pageCopyDurMs = 0.0

setSwapType SWAP_SWAP

mode 1,16,0,onVerticalBlank

const CUBE_NUM_VERTS = 8
const CUBE_NUM_EDGES = 12
const CUBE_NUM_FACES = 6
const CUBE_NUM_VERTS_PER_FACE = 4
dim float cube_vx(CUBE_NUM_VERTS - 1) ' vertex x
dim float cube_vy(CUBE_NUM_VERTS - 1) ' vertex y
dim float cube_vz(CUBE_NUM_VERTS - 1) ' vertex z
dim float cube_esi(CUBE_NUM_EDGES - 1) ' edge start index
dim float cube_eei(CUBE_NUM_EDGES - 1) ' edge end index
dim integer cube_fvi(CUBE_NUM_FACES * CUBE_NUM_VERTS_PER_FACE - 1) ' vert indices for each face

dim float znear = 1.0
dim float zfar = 10.0
dim float zrange = zfar - znear

dim float texty = mm.vres

cube_vx(0) = -0.5
cube_vy(0) = -0.5
cube_vz(0) = -0.5

cube_vx(1) = 0.5
cube_vy(1) = -0.5
cube_vz(1) = -0.5

cube_vx(2) = 0.5
cube_vy(2) = 0.5
cube_vz(2) = -0.5

cube_vx(3) = -0.5
cube_vy(3) = 0.5
cube_vz(3) = -0.5

cube_vx(4) = -0.5
cube_vy(4) = -0.5
cube_vz(4) = 0.5

cube_vx(5) = 0.5
cube_vy(5) = -0.5
cube_vz(5) = 0.5

cube_vx(6) = 0.5
cube_vy(6) = 0.5
cube_vz(6) = 0.5

cube_vx(7) = -0.5
cube_vy(7) = 0.5
cube_vz(7) = 0.5

' front
cube_esi(0) = 0
cube_eei(0) = 1
cube_esi(1) = 1
cube_eei(1) = 2
cube_esi(2) = 2
cube_eei(2) = 3
cube_esi(3) = 3
cube_eei(3) = 0

' sides
cube_esi(4) = 0
cube_eei(4) = 4
cube_esi(5) = 1
cube_eei(5) = 5
cube_esi(6) = 2
cube_eei(6) = 6
cube_esi(7) = 3
cube_eei(7) = 7

' back
cube_esi(8) = 4
cube_eei(8) = 5
cube_esi(9) = 5
cube_eei(9) = 6
cube_esi(10) = 6
cube_eei(10) = 7
cube_esi(11) = 7
cube_eei(11) = 4

'vertex indices for face 0
cube_fvi(0) = 3
cube_fvi(1) = 2
cube_fvi(2) = 1
cube_fvi(3) = 0
'vertex indices for face 1
cube_fvi(4) = 4
cube_fvi(5) = 5
cube_fvi(6) = 6
cube_fvi(7) = 7
'vertex indices for face 2
cube_fvi(8) = 0
cube_fvi(9) = 1
cube_fvi(10) = 5
cube_fvi(11) = 4
'vertex indices for face 3
cube_fvi(12) = 1
cube_fvi(13) = 2
cube_fvi(14) = 6
cube_fvi(15) = 5
'vertex indices for face 4
cube_fvi(16) = 2
cube_fvi(17) = 3
cube_fvi(18) = 7
cube_fvi(19) = 6
'vertex indices for face 5
cube_fvi(20) = 3
cube_fvi(21) = 0
cube_fvi(22) = 4
cube_fvi(23) = 7


main

end

' main
sub main
  local float frameStartTime = 0.0
  local float frameDurMs = 0.0
  local float frameDurSecs = 0.0
  local float fps = 0.0
  local integer waitCount = 0
  local float waitStartTime = 0.0
  local float waitDurMs = 0.0
  local float renderStartTime = 0.0
  local float renderDurMs = 0.0

  local float camx = int(mm.hres / 2)
  local float camy = int(mm.vres / 2)   
  local float camz = 1.5
  local float camvz = 10.0

  local float cubeYaw = 0.0
  local float cubePitch = 0.0
  local float cubeRoll = 0.0
  local integer cubeCount = 0

  local float lastCubeYaw(2)
  local float lastCubePitch(2)
  local float lastCubeRoll(2)

  do
    frameStartTime = timer

    ' render
    'cls

    renderStartTime = timer
    
    'clear the previous cube position
    'renderSolidCube camx,camy,camz,lastCubeYaw(writePage),lastCubePitch(writePage),lastCubeRoll(writePage),&H000000,&H000000
    renderWiredCube  camx,camy,camz,lastCubeYaw(writePage),lastCubePitch(writePage),lastCubeRoll(writePage),&H000000

    for cubeCount = 0 to 0
      'renderSolidCube camx,camy,camz,cubeYaw - cubeCount * 0.05,cubePitch - cubeCount * 0.05,cubeRoll - cubeCount * 0.05,&HFFFFFF, rgb(0,0,255 - cubeCount * 32)
      renderWiredCube camx,camy,camz,cubeYaw - cubeCount * 0.05,cubePitch - cubeCount * 0.05,cubeRoll - cubeCount * 0.05,rgb(0,0,255 - cubeCount * 32)
    next cubeCount
    renderDurMs = timer - renderStartTime

    text 0,0,"fps: " + str$(fps,2,1) + " rd: " + str$(renderDurMs,3,2) + " wd: " + str$(waitDurMs,3,2)
    text 0,12,"pcd: " + str$(pageCopyDurMs,2,2) + " dp: " + str$(displayPage) + " wp: " + str$(writePage) 
    text (mm.hres - 40) * 0.5,texty, "Blarg!"

    ' simulate
    'camz = camz + frameDurSecs * camvz
    if (camz > 10.0 or camz < 1.1) then
      camvz = -camvz
    endif

    lastCubeYaw(writePage) = cubeYaw
    cubeYaw = cubeYaw + PI * 0.5 * frameDurSecs
    if (cubeYaw > PI * 2.0) then
      cubeYaw = cubeYaw - PI * 20
    endif

    lastCubePitch(writePage) = cubePitch
    cubePitch = cubePitch + PI * 0.25 * frameDurSecs
    if (cubePitch > PI * 2.0) then
      cubePitch = cubePitch - PI * 2.0
    endif

    lastCubeRoll(writePage) = cubeRoll
    'cubeRoll = cubeRoll + PI * 0.25 * frameDurSecs
    if (cubeRoll > PI * 2.0) then
      cubeRoll = cubeRoll - PI * 20
    endif

    textY = textY - 30.0 * frameDurSecs
    if (textY < -12) then
      textY = mm.vres
    endif

    ' wait for  vsync
    swapPages waitDurMs
    simSyncCount = vsyncCount

    frameDurMs = timer - frameStartTime
    frameDurSecs = frameDurMs / 1000.0
    fps = 1000.0 / frameDurMs
  loop
end sub

' setSwapType
sub setSwapType st as integer
  swapType = st
  if (swapType = SWAP_COPY) then
    displayPage = 0
    writePage = 1
  else
    displayPage = 0
    writePage = 1
  endif

  page display displayPage
  page write writePage
end sub

' swapPages
sub swapPages waitDurMs as float
  local float waitStartTime = timer
  if (swapType = SWAP_COPY) then
    page copy writePage to displayPage,D
    do while(simSyncCount >= vsyncCount or vsyncCount MOD 2 = 1)
    loop
  else    
    local integer t = displayPage
    displayPage = writePage
    writePage = t

    page display displayPage
    page write writePage
  endif

  waitDurMs = timer - waitStartTime
end sub

' copyPages
sub copyPages
  local float pageCopyStart = timer

  page copy writePage to displayPage,I
  
  pageCopyDurMs = timer - pageCopyStart
end sub

' on verticalBlank
sub onVerticalBlank
  frameNum = frameNum + 1
  vsyncCount = vsyncCount + 1

  'if (swapType = SWAP_COPY) then
  '  copyPages
  'endif

  vsyncCount = vsyncCount + 1
end sub

sub renderWiredCube camx as float, camy as float, camz as float, yaw as float, pitch as float, roll as float, clr as integer
  local integer v
  local integer e
  local integer esi
  local integer eei
  local float xscale = 32.0 * (mm.vres / mm.hres)
  local float yscale = 32.0
  local float x1
  local float y1
  local float yt
  local float z1
  local float invz1
  local float sineYaw = sin(yaw)
  local float cosYaw = cos(yaw)
  local float sinePitch = sin(pitch)
  local float cosPitch = cos(pitch)
  local float sineRoll = sin(roll)
  local float cosRoll = cos(roll)

  ' transformed and projected vertex positions in screen space
  local float tvx(12)
  local float tvy(12) 

  ' transform and project each vertex once
  for v = 0 to CUBE_NUM_VERTS - 1
    ' transform vertex
    
    ' yaw
    x1 = cube_vx(v) * cosYaw - cube_vz(v) * sineYaw
    z1 = cube_vx(v) * sineYaw + cube_vz(v) * cosYaw
    ' pitch
    y1 = cube_vy(v) * cosPitch - z1 * sinePitch
    z1 = cube_vy(v) * sinePitch + z1 * cosPitch
    ' roll
    'yt = x1 * sineRoll + y1 * cosRoll
    'x1 = x1 * cosRoll - y1 * sineRoll
    'y1 = yt

    ' project vertex
    invz1 = zrange / (z1 + camz)
    tvx(v) = (x1 * invz1 * xscale) + camx
    tvy(v) = (y1 * invz1 * yscale) + camy
  next v

  ' render each edge
  for e = 0 to CUBE_NUM_EDGES - 1
    esi = cube_esi(e)
    eei = cube_eei(e)
    line tvx(esi),tvy(esi),tvx(eei),tvy(eei),1,clr
  next e    
end sub

sub renderSolidCube camx as float, camy as float, camz as float, yaw as float, pitch as float, roll as float, eclr as integer, fclr as integer
  local integer v
  local integer e
  local integer esi
  local integer eei
  local float xscale = 32.0 * (mm.vres / mm.hres)
  local float yscale = 32.0
  local float x1
  local float y1
  local float yt
  local float z1
  local float invz1
  local float sineYaw = sin(yaw)
  local float cosYaw = cos(yaw)
  local float sinePitch = sin(pitch)
  local float cosPitch = cos(pitch)
  local float sineRoll = sin(roll)
  local float cosRoll = cos(roll)

  ' transformed and projected vertex positions in screen space
  local float tvx(12)
  local float tvy(12) 
  local float tvz(12) ' for sorting of faces
  local float cubeCenterZ

  ' transform and project each vertex once
  for v = 0 to CUBE_NUM_VERTS - 1
    ' transform vertex
    
    ' yaw
    x1 = cube_vx(v) * cosYaw - cube_vz(v) * sineYaw
    z1 = cube_vx(v) * sineYaw + cube_vz(v) * cosYaw
    ' pitch
    y1 = cube_vy(v) * cosPitch - z1 * sinePitch
    z1 = cube_vy(v) * sinePitch + z1 * cosPitch
    ' roll
    yt = x1 * sineRoll + y1 * cosRoll
    x1 = x1 * cosRoll - y1 * sineRoll
    y1 = yt

    ' project vertex
    invz1 = zrange / (z1 + camz)
    tvx(v) = (x1 * invz1 * xscale) + camx
    tvy(v) = (y1 * invz1 * yscale) + camy
    tvz(v) = z1
    'cubeCenterZ = cubeCenterZ + z1
  next v

  'cubeCenterZ = cubeCenterZ * (1.0 / CUBE_NUM_VERTS)

  ' render each face
  local integer f
  local integer fviStart
  local float fvx(4)
  local float fvy(4)  
  local float fvz(4)
  local integer fvxi(5)
  local integer fvyi(5)
  local float v1(2)
  local float v2(2)
  local float fnorm(2)
  local float cpz
  local float fcx(6)
  local float fcy(6)

  for f = 0 to CUBE_NUM_FACES - 1
    fviStart = f * CUBE_NUM_VERTS_PER_FACE

    fcx(f) = 0
    fcy(f) = 0

    for v = 0 to CUBE_NUM_VERTS_PER_FACE - 1  
      fvx(v) = tvx(cube_fvi(fviStart + v))
      fvy(v) = tvy(cube_fvi(fviStart + v))
      'fvz(v) = tvz(cube_fvi(fviStart + v))
      fcx(f) = fcx(f) + fvx(v)
      fcy(f) = fcy(f) + fvy(v)
    next v

    ' compute centroid of each face
    fcx(f) = fcx(f) * 0.25
    fcy(f) = fcy(f) * 0.25

    ' compute face normal from cross product of two edges
    v1(0) = fvx(1) - fvx(0) 
    v1(1) = fvy(1) - fvy(0)
    'v1(2) = fvz(1) - fvz(0)
    v2(0) = fvx(2) - fvx(0)
    v2(1) = fvy(2) - fvy(0)
    'v2(2) = fvz(2) - fvz(0)

    ' v_cross is a bit wacky with option base 0 due to DIMs declaring
    ' max array index instead of number of elements in the array
    'math v_cross v1(),v2(),fnorm()
 
    ' we only need to compute the z term of the cross product anyway
    ' this is about the same speed-wise as using v_cross to compute 
    ' x, y and z 
    'cpx = v1(1)*v2(2) - v1(2)*v2(1)
    ' cpy = v1(2)*v2(0) - v1(0)*v2(2)
    cpz = v1(0)*v2(1) - v1(1)*v2(0)

    ' skip if back facing (z is same sign as camera z)
    'if (fnorm(2) < 0.0) then  
    if (cpz < 0.0) then
      fvxi(0) = int(fvx(0))
      fvxi(1) = int(fvx(1))
      fvxi(2) = int(fvx(2))
      fvxi(3) = int(fvx(3))
      fvxi(4) = fvxi(0)

      fvyi(0) = int(fvy(0))
      fvyi(1) = int(fvy(1))
      fvyi(2) = int(fvy(2))
      fvyi(3) = int(fvy(3))
      fvyi(4) = fvyi(0)

      polygon 5,fvxi(),fvyi(),eclr,fclr
      
      text fcx(f),fcy(f),str$(f,1,0)
    endif
  next f
end sub


