dim vertex(11,3)   ' Store 11 vertex points of x, y and z co-ordinates

dim nodeCount%=11
dim plane(16,4)   ' Planes are made up of 3 or 4 vertexes

dim drawNodeX(16)  ' Stores the translated X,Y,Z co-ords of each node/vertex
dim drawNodeY(16)
dim drawNodeZ(16)

dim polyX(4)       ' The array we use to store the 4 points of the polygon
dim polyY(4)
' Vertex data is stored in 2 dimensional array where the 2nd dimension defines x, y or z
vertex(0,0)=32:vertex(0,1)=0:vertex(0,2)=76
vertex(1,0)=-32:vertex(1,1)=0:vertex(1,2)=76
vertex(2,0)=0:vertex(2,1)=26:vertex(2,2)=24
vertex(3,0)=-120:vertex(3,1)=-3:vertex(3,2)=-8
vertex(4,0)=120:vertex(4,1)=-3:vertex(4,2)=-8
vertex(5,0)=-88:vertex(5,1)=16:vertex(5,2)=-40
vertex(6,0)=88:vertex(6,1)=16:vertex(6,2)=-40
vertex(7,0)=128:vertex(7,1)=-8:vertex(7,2)=-40
vertex(8,0)=-128:vertex(8,1)=-8:vertex(8,2)=-40
vertex(9,0)=0:vertex(9,1)=26:vertex(9,2)=-40
vertex(10,0)=-32:vertex(10,1)=-24:vertex(10,2)=-40
vertex(11,0)=32:vertex(11,1)=-24:vertex(11,2)=-40

plane(0,0)=2:plane(0,1)=1:plane(0,2)=0
plane(1,0)=0:plane(1,1)=1:plane(1,2)=10:plane(1,3)=11 
plane(2,0)=6:plane(2,1)=2:plane(2,2)=0
plane(3,0)=0:plane(3,1)=4:plane(3,2)=6
plane(4,0)=7:plane(4,1)=4:plane(4,2)=0:plane(4,3)=11
plane(5,0)=1:plane(5,1)=2:plane(5,2)=5
plane(6,0)=5:plane(6,1)=3:plane(6,2)=1
plane(7,0)=1:plane(7,1)=3:plane(7,2)=8:plane(7,3)=10
plane(8,0)=9:plane(8,1)=5:plane(8,2)=2
plane(9,0)=2:plane(9,1)=6:plane(9,2)=9
plane(10,0)=3:plane(10,1)=5:plane(10,2)=8
plane(11,0)=7:plane(11,1)=6:plane(11,2)=4
plane(12,0)=10:plane(12,1)=8:plane(12,2)=5
plane(13,0)=11:plane(13,1)=7:plane(13,2)=4
plane(14,0)=9:plane(14,1)=10:plane(14,2)=8:plane(14,3)=5
plane(15,0)=9:plane(15,1)=6:plane(15,2)=7:plane(15,3)=11
plane(16,0)=9:plane(16,1)=11:plane(16,2)=10

sub rotate(ax, ay, az)
   snz=sin(az)
   csz=cos(az)
   sny=sin(ay)
   csy=cos(ay)
   snx=sin(ax)
   csx=cos(ax)
   for n=0 to nodeCount%
     x=vertex(n,0)  'x
     y=vertex(n,1)  'y
     ' Rotate around z
     drawNodeX(n)=x*csz-y*snz
     drawNodeY(n)=y*csz+x*snz
     drawNodeZ(n)=vertex(n,2)  'z 

     ' Rotate around y
     x=drawNodeX(n)
     z=drawNodeZ(n)
     drawNodeX(n)=x*csy+z*sny
     drawNodeZ(n)=z*csy-x*sny

     ' Rotate around x
     y=drawNodeY(n)
     z=drawNodeZ(n)
     drawNodeY(n)=y*csx-z*snx
     drawNodeZ(n)=z*csx+y*snx

   next n
end sub

anglex=0:angley=0:anglez=0
'Main loop
do
  tts=timer
  page write 1
  cls
  anglex=anglex-0.00005
  angley=angley+0.01
  anglez=anglez+0.025  
  rotate(anglex,angley,anglez)
  tt2=timer
  for v=0 to 16
    p1=plane(v,0)
    p2=plane(v,1)
    p3=plane(v,2)
    p4=plane(v,3)
    x1=drawNodeX(p1)
    y1=drawNodeY(p1)
'    z1=drawNodeZ(p1)
    x2=drawNodeX(p2)
    y2=drawNodeY(p2)
'    z2=drawNodeZ(p2)
    x3=drawNodeX(p3)
    y3=drawNodeY(p3)
'    z3=drawNodeZ(p3)
    dx1=x1-x2
    dy1=y1-y2
    dx2=x1-x3
    dy2=y1-y3
'    crossX=y1*z2-z1*y2
'    crossY=z1*x2-x1*z2
    crossZ=dx1*dy2-dy1*dx2
 '   norm=sqr(crossx*crossx+crossy*crossy+crossz*crossz)
 '   lightLevel=128+ (127*(crossY/norm))    
    'dotproduct=x1*x2+y1*y2+drawNodeZ(p1)*drawNodez(p2)
    if crossZ>0 then
      if p4=0 then
        triangle 400+x1,300+y1,400+x2,300+y2,400+x3,300+y3,rgb(0,0,0), rgb(128+v*5,255,255)
      else   'It's a 4 point plane
        x4=drawNodeX(p4)
        y4=drawNodeY(p4)
        polyX(0)=x1+400
        polyY(0)=y1+300
        polyX(1)=x2+400
        polyY(1)=y2+300
        polyX(2)=x3+400
        polyY(2)=y3+300
        polyX(3)=x4+400
        polyY(3)=y4+300
        polygon 4,polyx(), polyy(),rgb(0,0,0),rgb(128+v*5,255,255)        
      endif
    endif
  next v

  timerTotal=timer-tts
  timerRotate=tt2-tts
  timerDraw=timer-tt2
  fps=fps*0.9+0.1*(1000/timerTotal)
  print "FPS: " +str$(fps)
  print "Rotate: " + str$(timerRotate) +" ms"
  print "Draw: " + str$(timerDraw) + " ms"  
  page copy 1,0

loop
