timer=0
option explicit
option base 0
option default none
option angle degrees
mode 1,8
const VERTS=5    ' Max of zero based array. So this is for 6 vertices and 8 planes
const PLANES=7
const RX=2   ' X Rotation
const RY=1   ' Y Rotation
const RZ=0.5 ' Z Rotation

dim float p1,p2,p3,x1,x2,x3,y1,y2,y3,z1,z2,z3,dx1,dx2,dy1,dy2
dim float snx,sny,snz,csx,csy,csz,x,y,z, finalTime,fps,nx,ny,nz,v1,v2,v3, opv
dim integer k,v,n,t
dim float dnx(VERTS)  ' Stores the translated X,Y,Z co-ords of each node/vertex
dim float dny(VERTS)
dim float dnz(VERTS)

dim integer cl(PLANES) ' The colour of each side/plane
cl(0)=rgb(0,255,255)
cl(1)=rgb(255,128,0)
cl(2)=rgb(128,255,0)
cl(3)=rgb(128,0,255)
cl(4)=rgb(255,0,0)
cl(5)=rgb(0,255,0)
cl(6)=rgb(0,0,255)
cl(7)=rgb(255,255,0)

' Vertex data is stored in 2 dimensional array where the 2nd dimension defines x, y or z
dim float vx(VERTS)   ' Store 6 vertex points of x, y and z co-ordinates
dim float vy(VERTS)
dim float vz(VERTS)
vx(0)=0:vy(0)=250:vz(0)=0
vx(1)=250:vy(1)=0:vz(1)=0
vx(2)=-250:vy(2)=0:vz(2)=0
vx(3)=0:vy(3)=-250:vz(3)=0
vx(4)=0:vy(4)=0:vz(4)=250
vx(5)=0:vy(5)=0:vz(5)=-250

dim float pn(PLANES,3)   ' Planes are made up of 3 or 4 vertexes
pn(0,0)=0:pn(0,1)=5:pn(0,2)=2
pn(1,0)=0:pn(1,1)=1:pn(1,2)=5 
pn(2,0)=0:pn(2,1)=2:pn(2,2)=4
pn(3,0)=0:pn(3,1)=4:pn(3,2)=1
pn(4,0)=3:pn(4,1)=2:pn(4,2)=5
pn(5,0)=3:pn(5,1)=5:pn(5,2)=1
pn(6,0)=3:pn(6,1)=1:pn(6,2)=4
pn(7,0)=3:pn(7,1)=4:pn(7,2)=2

' Pre-process the object and see if any planes are parallel but opposite direction of any
' other plane. If it is, then we can deduce whether the second plane is visible from the 
' visibilty of the opposing plane
' This masively reduces the calculation time for all 3d primitives with an even number of sides
' greater than or equal to 6. So cubes, walls, doors, cylinders, poly-spheres all benefit greatly
' from this pre-calc. It' less effective on complex shapes, but does not make them any slower
' So it's always worth doing. 
' Note: this code is not specific to the octohedron - it works on any shape
dim integer op(PLANES)   ' Oposite plane number (if any)
dim integer rn(PLANES)   ' Has this plane been rendered (reset to zero evert new frame)
' Calculate the normal vector (as cross product) for each plane in the object
' Store these 3d normal vectors in crx(),cry(),crz() arrays
dim float crx(PLANES)
dim float cry(PLANES)
dim float crz(PLANES)
for n=0 to PLANES
  p1=pn(n,0):p2=pn(n,1):p3=pn(n,2)
  x1=vx(p1):y1=vy(p1):z1=vz(p1):x2=vx(p2):y2=vy(p2):z2=vz(p2)
  x3=vx(p3):y3=vy(p3):z3=vz(p3)
  crz(n)=(x1-x2)*(y1-y3)-(y1-y2)*(x1-x3)
  crx(n)=(z1-z2)*(y1-y3)-(y1-y2)*(z1-z3)
  cry(n)=(x1-x2)*(z1-z3)-(z1-z2)*(x1-x3)
next n
'Look at each plane's normal vector and see if any of the preceeding planes are exactly opposite
for n=1 to PLANES
  op(n)=n   ' By default, if the value is the same as the plane number, then it will be calculated
  for v=0 to n-1
    if crx(n)=-crx(v) and cry(n)=-cry(v) and crz(n)=-crz(v) then
      op(n)=v  ' Plane v is the opposite plane of n
      exit for
    endif
  next v
next n

' Preprocess vertexes and see if any are mirrored
' ov(x) holds the index of the opposite vertex + 1 (so that we can use zero to represent no mirror)
dim integer ov(VERTS)
dim float opx(VERTS),opy(VERTS),opz(VERTS)   ' used to store the opposite vertexes values each loop
for n=1 to VERTS
  ov(n)=0
  for v=0 to n-1
    if vx(v)=-vx(n) and vy(v)=-vy(n) and vz(v)=-vz(n) then
      ov(n)=v+1
      exit for
    endif
  next v
next n
' The above code produces the following values for my octohedron, but it will be different 
' for any other 3D shape
'op(0)=0
'op(1)=1
'op(2)=2
'op(3)=3
'op(4)=3   ' Opposite to plane 3
'op(5)=2   ' Opposite to plane 2
'op(6)=0   ' Opposite to plane 0
'op(7)=1   ' Opposite to plane 1 

'ov(0)=0
'ov(1)=0
'ov(2)=2   'opposite to vertex 1
'ov(3)=1   'opposite to vertex 0
'ov(4)=0
'ov(5)=5   'opposite to vertex 4

'page write 1
cls
'Main loop
dim float ax,ay,az
for k=0 to 719
  inc ax,rx: inc ay,ry: inc az,rz
  snz=sin(az):csz=cos(az):sny=sin(ay):csy=cos(ay):snx=sin(ax):csx=cos(ax)
  for n=0 to VERTS ' Rotate vertices
    if ov(n) then ' there is a mirror for this vertex - invert the x,y and z and bob's yer uncle
      opv=ov(n)-1
      ' Apply real world transform for perspective
      v1=800/(1000-opz(opv))
      dnx(n)=v1*opx(opv):dny(n)=v1*opy(opv)   ' this is a mirror vertex
    else
      x=vx(n):y=vy(n):z=vz(n)
      nx=x*csz-y*snz:ny=y*csz+x*snz ' Rotate around z
      nz=z*csy-nx*sny:nx=nx*csy+z*sny    ' Rotate around y 
      z=nz:nz=z*csx+ny*snx:ny=ny*csx-z*snx    ' Rotate around x
      opx(n)=-nx:opy(n)=-ny:opz(n)=-nz ' Record the rotated positions for mirrored vertices
      ' Apply real world transform for perspective
      '800 viewplane distance, 1000 object distance from viewer
      v1=800/(1000-nz):dnx(n)=nx*v1:dny(n)=ny*v1  
    endif
  next n

  box 192,94,416,413,0,0,0

  math set 1,rn() ' if rn(x)=0 then that side has been rendered
  for v=0 to PLANES ' Draw faces 
    if rn(op(v)) then ' we have not rendered the opposite side yet
      p1=pn(v,0):p2=pn(v,1):p3=pn(v,2)
      dx1=dnx(p1):dy1=dny(p1)
      if (dx1-dnx(p2))*(dy1-dny(p3))>(dy1-dny(p2))*(dx1-dnx(p3)) then   ' Cross product
        triangle 400+dx1,300+dy1,400+dnx(p2),300+dny(p2),400+dnx(p3),300+dny(p3),cl(v),cl(v)
        rn(v)=0   ' Remember that this face was rendered
      end if
    endif
  next v
'  page copy 1,0,i
next k

'Output final stats
finalTime= timer
print finalTime
fps=(720/finalTime)*1000
print "FPS:" + str$(fps)
' Calculate rotations around center of object (i.e. spin)
snz=sin(649*RZ):csz=cos(649*RZ):sny=sin(649*RY):csy=cos(649*RY):snx=sin(649*RX):csx=cos(649*RX)
for n=0 to VERTS ' Rotate vertices
  x=vx(n):y=vy(n):z=vz(n)
  nx=x*csz-y*snz:ny=y*csz+x*snz ' Rotate around z
  nz=z*csy-nx*sny:nx=nx*csy+z*sny    ' Rotate around y 
  z=nz:nz=z*csx+ny*snx:ny=ny*csx-z*snx    ' Rotate around x
  print "Vertices: " + str$(n) + "  " + str$(nx) + "," + str$(ny) + "," + str$(nz)
next n
'Page copy 1,0
