'
' pt.bas  - simpel drawing program
'
' for PicoMiteVGAUSB using USB-keyboard and USB-mouse
'
' by Peter63
'
' using mode 2 ,  320x240 4-bit colour
'
'

' --- program variables ---

Dim c1(16) As integer ' PicoMiteVGA color's (cmode=1)
cmode=1

Dim i As integer ' used often in for...next -loops
Dim t As integer ' keypress in main-loop
Dim mc As integer ' active mouse color in paint window
mc=8

Dim x,y,b As integer ' mouse info
Dim xold,yold As integer ' used in mouse move

Dim pentype As integer ' pen type
pentype=1
Dim brushtype As integer
brushtype=1

Dim penmode As integer
penmode=2 ' 1=pen, 2=brush


' read in colour's to c1(i)
Restore col1:For i=1 To 16:Read c1(i):Next


' activate mouse cursor (create mouse-sprite file, if missing
On error skip 1
Sprite load "mouse.spr",,1
If MM.Errno Then
  Print "Mouse-sprite file missing...  wait..."
  Print "it is created, if it is missing..."
  make_sprite_mouse ' create mouse cursor
  Pause 4000
End If
Sprite load "mouse.spr",,1


' --- layout ---
MODE 2
CLS
Font 8

FRAMEBUFFER create ' F

Box 0,0,319,40,1 ' draw a frame around the top of the screen

show_col_palett ' drawing out a color palette

xold=0:yold=0 ' used in mouse movement

'x=100:y=100

Mouse set 2,100,100

draw_pen_layout

draw_brush_layout

' show marker for selected color
k=156:Line k+1,28,k+5,28,1,c1(16)

' show marker brushtype
k=250:Line k+3,10,k+8,10,1,c1(16)

Text 5,3,"S = Save BMP"
Text 5,12,"L = Load BMP"
Text 5,21,"C = Clear Display"
Text 5,30,"Paint by Peter63 v 0.1"

' ------ MAIN-LOOP ------
Do

t=Asc(Inkey$)

' get mouse info
x=DEVICE(mouse 2,X)
y=DEVICE(mouse 2,Y)
b=DEVICE(mouse 2,L)

Text 260,30,"X "+Str$(x)+" "
Text 285,30,"Y "+Str$(y)+" "


If xold<>x Or yold<>y Then
  Sprite show(1),x,y,cmode
  xold=x:yold=y
End If


If b And y>50 Then ' left mouse button

  If penmode=1 Then ' pentype
    ' square pentypes
    If pentype=1 Then Box x-6,y-6,6,6,1,c1(mc),c1(mc)
    If pentype=2 Then Box x-4,y-4,4,4,1,c1(mc),c1(mc)
    If pentype=3 Then Box x-3,y-3,3,3,1,c1(mc),c1(mc)
    If pentype=4 Then Box x-2,y-2,2,2,1,c1(mc),c1(mc)
    ' circle pentype
    If pentype=5 Then Circle x-4,y-4,4,1,,c1(mc),c1(mc)
    If pentype=6 Then Circle x-3,y-3,3,1,,c1(mc),c1(mc)
    If pentype=7 Then Circle x-2,y-2,2,1,,c1(mc),c1(mc)
    If pentype=8 Then Circle x-1,y-1,1,1,,c1(mc),c1(mc)
  End If

  If penmode=2 Then

    If brushtype=1 Then
      Pixel x-1,y-1,c1(mc)
    End If
    If brushtype=2 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-4,y-2,c1(mc)
      Pixel x-2,y-4,c1(mc)
    End If
    If brushtype=3 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-6,y-2,c1(mc)
      Pixel x-3,y-3,c1(mc)
      Pixel x-5,y-4,c1(mc)
      Pixel x-2,y-5,c1(mc)
      Pixel x-4,y-6,c1(mc)
    End If
    If brushtype=4 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-6,y-1,c1(mc)
      Pixel x-6,y-6,c1(mc)
      Pixel x-1,y-6,c1(mc)
    End If
    If brushtype=5 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-3,y-3,c1(mc)
      Pixel x-5,y-5,c1(mc)
    End If

  End If

End If

If b And y<40 Then ' mouse in tool area

  ' --- inside the color palette area
  k=100:s=7
  For i=1 To 16
    If (x>k And x<k+s) And (y>30 And y<30+s) Then
      Line 100,28,228,28,1,c1(1)
      mc=i
      Line k+1,28,k+5,28,1,c1(16) ' highlight selected color
      Exit For
    End If
  Inc k,8
  Next

  ' --- Pen area
  k=122:s=12
  For i=1 To 8
    If (x>k And x<k+s) And (y>12 And y<12+s) Then
      Line 122,10,228,10,1,c1(1) ' clear pen
      Line 250,10,315,10,1,c1(1) ' clear brush
      pentype=i
      Line k+3,10,k+8,10,1,c1(16)
      penmode=1
      Exit For
    End If
  Inc k,12
  Next

  ' --- Brush area
  k=250:s=12
  For i=1 To 5
    If (x>k And x<k+s) And (y>12 And y<12+s) Then
      Line 122,10,228,10,1,c1(1) ' clear pen
      Line 250,10,315,10,1,c1(1) ' clear brush
      brushtype=i
      Line k+3,10,k+8,10,1,c1(16)
      penmode=2
      Exit For
    End If
  Inc k,12
  Next



End If

' P = change pen type
If t=80 Or t=112 Then
  Inc pentype
  If pentype>8 Then pentype=1
End If

If t=83 Or t=115 Then ' S = save display to a file (on SD-card)
  Sprite hide(1)
  Save image "pic1.bmp",0,42,319,198 ' OK part of the screen
  Sprite show(1),x,y,cmode
End If

If t=67 Or t=99 Then ' C = clear display (new)
  Sprite hide(1)
  Box 0,42,319,198,1,c1(1),c1(1)
  Sprite show(1),x,y,cmode
End If

If t=76 Or t=108 Then ' L = load file to diaplay
  Sprite hide(1)
  Load image "pic1.bmp",0,42
  Sprite show(1),x,y,cmode
End If

Loop ' --- MAIN-LOOP END


End


' --- pentype screen layout
Sub draw_pen_layout

Local i,x,y

Text 107,15,"Pen"
For i=122 To 210 Step 12
  Box i,12,12,12,1,c1(2)
Next
' - draw pentypes to screen
Box 125,15,6,6,1,c1(16),c1(16)
Box 138,15,4,4,1,c1(16),c1(16)
Box 150,15,3,3,1,c1(16),c1(16)
Box 163,15,2,2,1,c1(16),c1(16)
Circle 175,18,4,1,,c1(16),c1(16)
Circle 188,18,3,1,,c1(16),c1(16)
Circle 200,18,2,1,,c1(16),c1(16)
Circle 211,18,1,1,,c1(16),c1(16)
End Sub

' --- brush screen layout
Sub draw_brush_layout
Local i
Text 225,15,"Brush"
For i=250 To 300 Step 12
  Box i,12,12,12,1,c1(2)
Next

' - draw brush types to tool screen layout

' brushtype=1
Pixel 256,18,c1(16)

' brushtype=2
x=270:y=20
Pixel x-1,y-1,c1(16)
Pixel x-4,y-2,c1(16)
Pixel x-2,y-4,c1(16)

' brushtype=3
x=283:y=21
Pixel x-1,y-1,c1(16)
Pixel x-6,y-2,c1(16)
Pixel x-3,y-3,c1(16)
Pixel x-5,y-4,c1(16)
Pixel x-2,y-5,c1(16)
Pixel x-4,y-6,c1(16)

' brushtype=4
x=295:y=21
Pixel x-1,y-1,c1(16)
Pixel x-6,y-1,c1(16)
Pixel x-6,y-6,c1(16)
Pixel x-1,y-6,c1(16)

' brushtype=5
x=307:y=21
Pixel x-1,y-1,c1(16)
Pixel x-3,y-3,c1(16)
Pixel x-5,y-5,c1(16)

End Sub


' make a sprite mouse "mouse.spr"
Sub make_sprite_mouse

Open "mouse.spr" As output For #1
Print #1,"16,1"
Print #1,"7777770000000000"
Print #1,"7777770000000000"
Print #1,"7777000000000000"
Print #1,"7707700000000000"
Print #1,"7700770000000000"
Print #1,"7700077000000000"
Print #1,"0000007700000000"
Print #1,"0000000770000000"
Print #1,"0000000070000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Close #1

End Sub


' --- show color-palett to use from
Sub show_col_palett
Local x,y,z
Box 98,26,132,14,1,c1(16)
x=100:y=30:z=0
For i=1 To 16
  Box (x+z),y,7,7,1,c1(i),c1(i)
  Inc z,8
Next
End Sub


col1:
Data RGB(black),RGB(blue),RGB(myrtle),RGB(cobalt)
Data RGB(midgreen),RGB(cerulean),RGB(green),RGB(cyan)
Data RGB(red),RGB(magenta),RGB(rust),RGB(fuchsia)
Data RGB(brown),RGB(lilac),RGB(yellow),RGB(white)
