'
' pt.bas  - simpel drawing program
'
' for PicoMiteVGAUSB using USB-keyboard and USB-mouse
'
' tested and works on PicoMiteHDMIUSB
'
' by Peter63 ver 0.2
'
' using mode 2 ,  320x240 4-bit colour
'
'

' --- program variables ---

Dim c1(16) As integer ' PicoMiteVGA color's (cmode=1)
cmode=1

Dim i As integer ' used often in for...next -loops
Dim t As integer ' keypress in main-loop
Dim mc As integer ' active mouse color in paint window
'mc=8
mc=2 ' draw color

Dim x,y,b As integer ' mouse info
Dim xold,yold As integer ' used in mouse move

Dim pentype As integer ' pen type
pentype=1
Dim brushtype As integer
brushtype=1

Dim penmode As integer
penmode=2 ' 1=pen, 2=brush

Dim x1,y1,x2,y2 As integer ' used to draw line


' read in colour's to c1(i)
Restore col1:For i=1 To 16:Read c1(i):Next


' activate mouse cursor (create mouse-sprite file, if missing
On error skip 1
Sprite load "mouse.spr",,1
If MM.Errno Then
  Print "Mouse-sprite file missing...  wait..."
  Print "it is created, if it is missing..."
  make_sprite_mouse ' create mouse cursor
  Pause 4000
End If
Sprite load "mouse.spr",,1


' --- layout ---
MODE 2
CLS
Font 8

FRAMEBUFFER create ' F

upper_top_layout


' ------ MAIN-LOOP ------
Do

t=Asc(Inkey$)

' get mouse info
x=DEVICE(mouse 2,X)
y=DEVICE(mouse 2,Y)
b=DEVICE(mouse 2,L)

Text 260,30,"X "+Str$(x)+" "
Text 285,30,"Y "+Str$(y)+" "

If xold<>x Or yold<>y Then
  Sprite show(1),x,y,cmode
  xold=x:yold=y
End If


If b And y>50 Then ' left mouse button

  If penmode=1 Then ' pentype
    ' square pentypes
    If pentype=1 Then Box x-6,y-6,6,6,1,c1(mc),c1(mc)
    If pentype=2 Then Box x-4,y-4,4,4,1,c1(mc),c1(mc)
    If pentype=3 Then Box x-3,y-3,3,3,1,c1(mc),c1(mc)
    If pentype=4 Then Box x-2,y-2,2,2,1,c1(mc),c1(mc)
    ' circle pentype
    If pentype=5 Then Circle x-4,y-4,4,1,,c1(mc),c1(mc)
    If pentype=6 Then Circle x-3,y-3,3,1,,c1(mc),c1(mc)
    If pentype=7 Then Circle x-2,y-2,2,1,,c1(mc),c1(mc)
    If pentype=8 Then Circle x-1,y-1,1,1,,c1(mc),c1(mc)
  End If

  If penmode=2 Then

    If brushtype=1 Then
      Pixel x-1,y-1,c1(mc)
    End If
    If brushtype=2 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-4,y-2,c1(mc)
      Pixel x-2,y-4,c1(mc)
    End If
    If brushtype=3 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-6,y-2,c1(mc)
      Pixel x-3,y-3,c1(mc)
      Pixel x-5,y-4,c1(mc)
      Pixel x-2,y-5,c1(mc)
      Pixel x-4,y-6,c1(mc)
    End If
    If brushtype=4 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-6,y-1,c1(mc)
      Pixel x-6,y-6,c1(mc)
      Pixel x-1,y-6,c1(mc)
    End If
    If brushtype=5 Then
      Pixel x-1,y-1,c1(mc)
      Pixel x-3,y-3,c1(mc)
      Pixel x-5,y-5,c1(mc)
    End If

  End If

End If

If b And y<40 Then ' mouse in tool area

  ' --- inside the color palette area
  k=100:s=7
  For i=1 To 16
    If (x>k And x<k+s) And (y>30 And y<30+s) Then
      Line 100,28,228,28,1,c1(1)
      mc=i
      Line k+1,28,k+5,28,1,c1(16) ' highlight selected color
      Exit For
    End If
  Inc k,8
  Next

  ' --- Pen area
  k=122:s=12
  For i=1 To 8
    If (x>k And x<k+s) And (y>12 And y<12+s) Then
      Line 122,10,228,10,1,c1(1) ' clear pen
      Line 250,10,315,10,1,c1(1) ' clear brush
      pentype=i
      Line k+3,10,k+8,10,1,c1(16)
      penmode=1
      Exit For
    End If
  Inc k,12
  Next

  ' --- Brush area
  k=250:s=12
  For i=1 To 5
    If (x>k And x<k+s) And (y>12 And y<12+s) Then
      Line 122,10,228,10,1,c1(1) ' clear pen
      Line 250,10,315,10,1,c1(1) ' clear brush
      brushtype=i
      Line k+3,10,k+8,10,1,c1(16)
      penmode=2
      Exit For
    End If
  Inc k,12
  Next



End If

' P = change pen type
If t=80 Or t=112 Then
  Inc pentype
  If pentype>8 Then pentype=1
End If

If t=83 Or t=115 Then ' S = save display to a file
  save_image
End If

If t=67 Or t=99 Then ' C = clear display image
  clear_image
End If

If t=76 Or t=108 Then ' L = load file to display
  load_image
End If

If t=63 Then ' ? = help menu
  FRAMEBUFFER copy N,F ' save the actual display
  ' print new stuff to the screen
  Text 0,0,"   Test FRAMBUFFER copy N,F   "
  Pause 4000
  FRAMEBUFFER copy F,N ' restore display

End If


If t=84 Or t=116 Then draw_line ' T = line draw

If t=66 Or t=98 Then draw_box ' B = box draw

If t=79 Or t=111 Then draw_circle ' O = circle draw



Loop ' --- MAIN-LOOP END


End


' --- upper top layout
Sub upper_top_layout

Box 0,0,319,40,1,c1(16),c1(1) ' draw a frame around the top of the screen
Box 0,40,319,4,1,c1(1),c1(1) ' clear a part under top frame

show_col_palett ' drawing out a color palette

xold=0:yold=0 ' used in mouse movement

Mouse set 2,100,100

draw_pen_layout
draw_brush_layout

' show marker for selected color
'k=156:Line k+1,28,k+5,28,1,c1(16)
k=108:Line k+1,28,k+5,28,1,c1(16)


' show marker brushtype
k=250:Line k+3,10,k+8,10,1,c1(16)

Text 5,3,"S = Save BMP"
Text 5,12,"L = Load BMP"
Text 5,21,"C = Clear Display"
Text 5,30,"Paint by Peter63 v 0.2"

lcb_text


End Sub





' --- clear display image
Sub clear_image
  Local t

  Sprite hide(1)

  FRAMEBUFFER copy N,F ' save the actual display

  Box 90,70,150,100,1,c1(16),c1(1)
  Text 94,94,"Clear display  Y / N ? "

  t=0

  Do

  t=Asc(Inkey$)

  If t=89 Or t=121 Then ' Y
    Box 0,42,320,198,1,c1(1),c1(1)
    Exit Do
  End If

  If t=78 Or t=110 Or t=27 Then ' N or Esc
    FRAMEBUFFER copy F,N ' restore display
    Exit Do
  End If

  Loop

  Sprite show(1),x,y,cmode

End Sub




' --- save display to a BMP file
Sub save_image
  Sprite hide(1) ' hide mouse cursor
  FRAMEBUFFER copy N,F ' save the actual display

  Box 90,70,150,100,1,c1(16),c1(1)
  Text 94,74,"Save to a BMP file"
  Text 94,94,"Enter file name? "
  Text 94,120,"(ESC to skip)"
  enter_string(165,94,ss$,ec)
  If ec=13 And Len(ss$)>0 Then
    FRAMEBUFFER copy F,N ' restore display
    Save image ss$,0,42,319,198 ' OK part of the screen
  End If

  FRAMEBUFFER copy F,N ' restore display
  Sprite show(1),x,y,cmode

End Sub

' --- load a BMP file
Sub load_image
  'Sprite hide(1)
  'Load image "pic1.bmp",0,42
  'Sprite show(1),x,y,cmode

  Sprite hide(1) ' hide mouse cursor
  FRAMEBUFFER copy N,F ' save the actual display

  Box 90,70,150,100,1,c1(16),c1(1)
  Text 94,74,"Load a BMP file"
  Text 94,94,"Enter file name? "
  Text 94,120,"(ESC to skip)"
  enter_string(165,94,ss$,ec)
  If ec=13 And Len(ss$)>0 Then
    'FRAMEBUFFER copy F,N ' restore display
    On error skip 1
    Load image ss$,0,42
    If MM.Errno Then
      Text 94,140,MM.ErrMsg$
      Pause 4000
      FRAMEBUFFER copy F,N ' restore display
      Sprite show(1),x,y,cmode
      Exit Sub
    End If
    Sprite show(1),x,y,cmode
    Exit Sub
  End If

  FRAMEBUFFER copy F,N ' restore display
  Sprite show(1),x,y,cmode

End Sub


' --- enter a string
Sub enter_string(x,y,ss$,ec)
Local t,p
ss$=""
p=0
Do
t=Asc(Inkey$)
If (t>64 And t<91) Or (t>96 And t<123) Or (t>48 And t<58) Then
  ' A-Z or a-z or 0-9
  ss$=ss$+Chr$(t)
  Text x,y,ss$+" "
  p=p+1
End If
If t=8 And p>0 Then
  ss$=Left$(ss$,p-1)
  Text x,y,ss$+" "
  p=p-1
End If
If t=27 Then ec=27:Exit Do
If t=13 Then ec=13:Exit Do

Loop

End Sub




' --- draw a line to the screen
Sub draw_line
Local t,x,y,xold,yold,b1,b2
Local xold2,yold2
xold=0:yold=0
xold2=0:yold2=0
b1=0:b2=0

  ' Show status line-draw routine
  Text 100,2,"LINE: start and then endpoint (ESC for cancel)"
  Sprite hide(1) ' hide mouse cursor
  FRAMEBUFFER copy N,F ' save the actual display

  Do
  t=Asc(Inkey$)

  ' get mouse info
  x1=DEVICE(mouse 2,X)
  y1=DEVICE(mouse 2,Y)
  b1=DEVICE(mouse 2,L)

  If xold<>x1 Or yold<>y1 Then
    Sprite show(1),x1,y1,cmode
    xold=x1:yold=y1
  End If


  If b1 And y1>50 Then ' left mouse button
    Pause 200

    xold2=0:yold2=0

    Do

      t=Asc(Inkey$)

      ' get mouse info
      x2=DEVICE(mouse 2,X)
      y2=DEVICE(mouse 2,Y)
      b2=DEVICE(mouse 2,L)

      If xold2<>x2 Or yold2<>y2 Then
        Sprite hide(1) ' hide mouse cursor
        xold2=x2:yold2=y2
        FRAMEBUFFER copy F,N ' restore display
        Line x1,y1,x2,y2,1,c1(mc)
        Sprite show(1),x2,y2,cmode

      End If


    If b2 And y2>50 Then Exit Do

    If t=27 Then Exit Do

    Loop

  End If

  If b2 Then Exit Do

  If t=27 Then Exit Do

  Loop


  Sprite hide(1) ' hide mouse cursor
  FRAMEBUFFER copy F,N ' restore display

  'Text 100,2,Space$(50)
  lcb_text

  If t=27 Then
    Sprite show(1),x2,y2,cmode
    Exit Sub
  End If

  ' draw a line
  Line x1,y1,x2,y2,1,c1(mc)
  Pause 200


End Sub


' --- draw a cicle to the screen
Sub draw_circle
Local t,x,y,xold,yold,b1,b2
Local x1,y1,x2,y2
Local xold2,yold2
Local r,a
xold=0:yold=0
xold2=0:yold2=0
b1=0:b2=0

  ' Show status circle-draw routine
  Text 100,2,"CIRCLE: center and then radius (ESC for cancel)"
  Sprite hide(1) ' hide mouse cursor
  FRAMEBUFFER copy N,F ' save the actual display

  Do
  t=Asc(Inkey$)

  ' get mouse info
  x1=DEVICE(mouse 2,X)
  y1=DEVICE(mouse 2,Y)
  b1=DEVICE(mouse 2,L)

  If xold<>x1 Or yold<>y1 Then
    Sprite show(1),x1,y1,cmode
    xold=x1:yold=y1
  End If


  If b1 And y1>50 Then ' left mouse button
    Pause 200

    xold2=0:yold2=0

    Do

      t=Asc(Inkey$)

      ' get mouse info
      x2=DEVICE(mouse 2,X)
      y2=DEVICE(mouse 2,Y)
      b2=DEVICE(mouse 2,L)

      If xold2<>x2 Or yold2<>y2 Then
        Sprite hide(1) ' hide mouse cursor
        xold2=x2:yold2=y2
        FRAMEBUFFER copy F,N ' restore display
        r=Sqr(((x2-x1)^2)+((y2-y1)^2)) ' distance two points
        If (x2-x1)<>0 Then
          a=Atn((y2-y1)/(x2-x1)) ' aspect
          Else
          a=1
        End If
        Circle x1,y1,r,1,a,c1(mc)
        Sprite show(1),x2,y2,cmode

      End If


    If b2 And y2>50 Then Exit Do

    If t=27 Then Exit Do

    Loop

  End If

  If b2 Then Exit Do

  If t=27 Then Exit Do

  Loop


  Sprite hide(1) ' hide mouse cursor

  FRAMEBUFFER copy F,N ' restore display

  Text 100,2,Space$(50)

  If t=27 Then Exit Sub

  If t<>27 Then
    Text 100,2,"CIRCLE: Fill Y/N ?"
    t=0
    Do
      t=Asc(Inkey$)
      If t=84 Or t=121 Then ' Y
        Circle x1,y1,r,1,a,c1(mc),c1(mc)
        Exit Do
      End If
      If t=78 Or t=110 Then ' N
        Circle x1,y1,r,1,a,c1(mc)
        Exit Do
      End If
      If t=27 Then Exit Do
    Loop
  End If

  lcb_text

  upper_top_layout

  Pause 200


End Sub

' header-text layout Line,Circle,Box
Sub lcb_text
Text 100,2,Space$(50)
Text 100,2,"T = Line , B = Box , O = Circle"
End Sub


' --- draw a box to the screen
Sub draw_box
Local t,x,y,xold,yold,b1,b2
Local x1,y1,x2,y2
Local xold2,yold2
xold=0:yold=0
xold2=0:yold2=0
b1=0:b2=0

  ' Show status box-draw routine
  Text 100,2,"BOX: start and then endpoint (ESC for cancel)"
  Sprite hide(1) ' hide mouse cursor
  FRAMEBUFFER copy N,F ' save the actual display

  Do
  t=Asc(Inkey$)

  ' get mouse info
  x1=DEVICE(mouse 2,X)
  y1=DEVICE(mouse 2,Y)
  b1=DEVICE(mouse 2,L)

  If xold<>x1 Or yold<>y1 Then
    Sprite show(1),x1,y1,cmode
    xold=x1:yold=y1
  End If


  If b1 And y1>50 Then ' left mouse button
    Pause 200

    xold2=0:yold2=0

    Do

      t=Asc(Inkey$)

      ' get mouse info
      x2=DEVICE(mouse 2,X)
      y2=DEVICE(mouse 2,Y)
      b2=DEVICE(mouse 2,L)

      If xold2<>x2 Or yold2<>y2 Then
        Sprite hide(1) ' hide mouse cursor
        xold2=x2:yold2=y2
        FRAMEBUFFER copy F,N ' restore display
        Box x1,y1,x2-x1,y2-y1,1,c1(mc)
        Sprite show(1),x2,y2,cmode

      End If


    If b2 And y2>50 Then Exit Do

    If t=27 Then Exit Do

    Loop

  End If

  If b2 Then Exit Do

  If t=27 Then Exit Do

  Loop


  Sprite hide(1) ' hide mouse cursor

  FRAMEBUFFER copy F,N ' restore display

  Text 100,2,Space$(50)

  If t=27 Then Exit Sub

  If t<>27 Then
    Text 100,2,"BOX: Fill Y/N ?"
    t=0
    Do
      t=Asc(Inkey$)
      If t=84 Or t=121 Then ' Y
        Box x1,y1,x2-x1,y2-y1,1,c1(mc),c1(mc)
        Exit Do
      End If
      If t=78 Or t=110 Then ' N
        Box x1,y1,x2-x1,y2-y1,1,c1(mc)
        Exit Do
      End If
      If t=27 Then Exit Do
    Loop
  End If

  lcb_text

  Pause 200


End Sub






' --- pentype screen layout
Sub draw_pen_layout

Local i,x,y

Text 107,15,"Pen"
For i=122 To 210 Step 12
  Box i,12,12,12,1,c1(2)
Next
' - draw pentypes to screen
Box 125,15,6,6,1,c1(16),c1(16)
Box 138,15,4,4,1,c1(16),c1(16)
Box 150,15,3,3,1,c1(16),c1(16)
Box 163,15,2,2,1,c1(16),c1(16)
Circle 175,18,4,1,,c1(16),c1(16)
Circle 188,18,3,1,,c1(16),c1(16)
Circle 200,18,2,1,,c1(16),c1(16)
Circle 211,18,1,1,,c1(16),c1(16)
End Sub

' --- brush screen layout
Sub draw_brush_layout
Local i
Text 225,15,"Brush"
For i=250 To 300 Step 12
  Box i,12,12,12,1,c1(2)
Next

' - draw brush types to tool screen layout

' brushtype=1
Pixel 256,18,c1(16)

' brushtype=2
x=270:y=20
Pixel x-1,y-1,c1(16)
Pixel x-4,y-2,c1(16)
Pixel x-2,y-4,c1(16)

' brushtype=3
x=283:y=21
Pixel x-1,y-1,c1(16)
Pixel x-6,y-2,c1(16)
Pixel x-3,y-3,c1(16)
Pixel x-5,y-4,c1(16)
Pixel x-2,y-5,c1(16)
Pixel x-4,y-6,c1(16)

' brushtype=4
x=295:y=21
Pixel x-1,y-1,c1(16)
Pixel x-6,y-1,c1(16)
Pixel x-6,y-6,c1(16)
Pixel x-1,y-6,c1(16)

' brushtype=5
x=307:y=21
Pixel x-1,y-1,c1(16)
Pixel x-3,y-3,c1(16)
Pixel x-5,y-5,c1(16)

End Sub


' make a sprite mouse "mouse.spr"
Sub make_sprite_mouse

' ver 0.1 mouse-cursor
'Open "mouse.spr" As output For #1
'Print #1,"16,1"
'Print #1,"7777770000000000"
'Print #1,"7777770000000000"
'Print #1,"7777000000000000"
'Print #1,"7707700000000000"
'Print #1,"7700770000000000"
'Print #1,"7700077000000000"
'Print #1,"0000007700000000"
'Print #1,"0000000770000000"
'Print #1,"0000000070000000"
'Print #1,"0000000000000000"
'Print #1,"0000000000000000"
'Print #1,"0000000000000000"
'Print #1,"0000000000000000"
'Print #1,"0000000000000000"
'Print #1,"0000000000000000"
'Print #1,"0000000000000000"
'close #1

' ver 0.2 mouse-cursor
Open "mouse.spr" As output For #1
Print #1,"16,1"
Print #1,"7777770000000000"
Print #1,"7700000000000000"
Print #1,"7070000000000000"
Print #1,"7007000000000000"
Print #1,"7000700000000000"
Print #1,"7000070000000000"
Print #1,"0000007000000000"
Print #1,"0000000700000000"
Print #1,"0000000070000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Print #1,"0000000000000000"
Close #1

End Sub


' --- show color-palett to use from
Sub show_col_palett
Local x,y,z
Box 98,26,132,14,1,c1(16)
x=100:y=30:z=0
For i=1 To 16
  Box (x+z),y,7,7,1,c1(i),c1(i)
  Inc z,8
Next
End Sub


col1:
Data RGB(black),RGB(blue),RGB(myrtle),RGB(cobalt)
Data RGB(midgreen),RGB(cerulean),RGB(green),RGB(cyan)
Data RGB(red),RGB(magenta),RGB(rust),RGB(fuchsia)
Data RGB(brown),RGB(lilac),RGB(yellow),RGB(white)
