'
' Sprite editor program, using keyboard
'
' tested on:
' PicoMiteVGA MMBasic USB RP2350A Edition V6.00.01R10
' PicoMiteHDMI USB MMBasic USB RP2350A Edition V6.00.01
'
' ed.bas
'
' by Peter63 v0.1
'
'create_64file_sprite

Option default integer
MODE 2
Font 8
CLS

sfile$="sprite.spr" ' default sprite file

page=1 ' current help menu page

' create_new_64buff ' create new "64buff.dat" file  for random access use


' --- program variables ---
Dim m$(16) As string  ' editor surface 16x16
Dim z$(16) As string  ' editor surface 16x16 - for mod in editor

Dim c1(15) As integer ' colour_Maximite color's (cmode=0)
Dim c2(15) As integer ' PicoMiteVGA color's (cmode=1)


x=1 ' cursor position column (1 to 16)
y=1 ' cursor position row (1 to 16)

' colour code:
' 0=colour_Maximite CMM1/CMM2, 1=PicoMiteVGA (RGB121)
cmode = 1

FRAMEBUFFER create ' framebuffer F

Restore col1 ' read in color value for colour_Maximite
For i=0 To 15
Read c1(i)
Next

Restore col2 ' read in color value for PicoMiteVGA
For i=0 To 15
Read c2(i)
Next



' make a editor surface 16x16
' and clear it with spaces (ASCII=32)
For i= 1 To 16
m$(i)=String$(16," ")
Next


' --- startup layout ---
Font 8
Text 0,0," 0123456789ABCDEF "
Text 0,104," 0123456789ABCDEF"
Text 95,0,"   SPRITE editor 16x16   by Peter63 (V0.1)"

show_page
'show_menu1


Font 8
' show vertical text editor 0-9, A-F
For i=0 To 9
Text 70,6+(i*6),Chr$(48+i)
Next
For i=0 To 5
Text 70,66+(i*6),Chr$(65+i)
Next



show_cmode_palett ' show current color palett

'load1 ' show saved editor file on startup "ed16.spr"

show_mem_col ' update editor

layout64 ' show 64 sprite buffert


' --- main loop ---

'Text 280,50,Str$(MM.Info(heap))

Do

Font 8
Text x*4,y*6,"X"

t=Asc(Inkey$)

If (t>47 And t<58) Then ' set color pixel in editor (0-9)
  MID$(m$(y),x,1)=Chr$(t)
  show_mem_col
End If
If (t>64 And t<71) Then ' set color pixel in editor (A-F)
  MID$(m$(y),x,1)=Chr$(t)
  show_mem_col
End If
If (t>96 And t<103) Then ' set color pixel in editor (a-f)
  MID$(m$(y),x,1)=UCase$(Chr$(t))
  show_mem_col
End If
If t=32 Then ' set transparent color (SPACE)
  MID$(m$(y),x,1)=Chr$(t)
  show_mem_col
End If


If t=130 And x>1 Then
  Inc x,-1 ' move cursor left
  show_mem_col
End If
If t=131 And x<16 Then
  Inc x,1 ' move cursor right
  show_mem_col
End If
If t=129 And y<16 Then
  Inc y,1 ' move cursor down
  show_mem_col
End If
If t=128 And y>1 Then
  Inc y,-1 ' move cursor up
  show_mem_col
End If

If t=132 Then insert1 ' Insert = insert pixel in editor
If t=127 Then delete1 ' Delete = delete pixel in editor

If t=152 Then save_to_pos ' F8 = save to position #n
If t=151 Then load_pos_to_editor ' F7 = load pos to editor

If t=149 Then save_sprite_file ' F5 save sprite file...
If t=148 Then load_sprite_file ' F4 load sprite file...

If t=33 Then change_cmode ' ! = change cmode

If t=153 Then delete_col ' F9 = Delete Column
If t=154 Then insert_col 'F10 = Insert Column

If t=155 Then delete_row ' F11 = Delete Row
If t=156 Then insert_row ' F12 = Insert Row

If t=82 Or t=114 Then rotate ' R = Rotate

If t=72 Or t=104 Then hflip ' H = Horizontal Flip

If t=86 Or t=118 Then vflip ' V = Vertical Flip

If t=90 Or t=122 Then zoom_editor ' Z = zoom editor (reduce)

If t=63 Then ' ? = show ASC-code in editor
  show_mem
  Pause 1000
  show_mem_col
End If

If t=136 Then ' Page/Up menu-page
  Inc page,-1
  show_page
End If

If t=137 Then ' Page/Down menu-page
  Inc page
  show_page
End If

If t=83 Or t=115 Then ' S = scroll editor
  scroll_editor
  show_mem_col
  show_page ' show menu page
End If

If t=145 Then ' F1 = animation...
  animation_setup
  show_page
End If


If t=42 Then ' * = clear editor (new)
  clear_editor
  show_mem_col
End If


Loop ' ------ MAIN LOOP END ------

FRAMEBUFFER close ' framebuffer close all


End



' --- zoom editor (reduce zoom)
Sub zoom_editor
Local xs,ys
xs=x:ys=y ' save editor cursor position

' make zoom moves
y=8:delete_row:delete_row
y=1:insert_row
x=8:delete_col:delete_col
x=1:insert_col

x=xs:y=ys ' restore cursor pos
End Sub


' --- vertical flip
Sub vflip
Local i,k

' save editor
For i=1 To 16:z$(i)=m$(i):Next

For i=1 To 16
  m$(i)=""
  For k=16 To 1 Step-1
    m$(i)=m$(i)+Mid$(z$(i),k,1)
  Next
Next

show_mem_col

End Sub


' --- horizontal flip
Sub hflip
Local i
' save editor
For i=1 To 16:z$(i)=m$(i):Next
For i=1 To 16
  m$(i)=z$(17-i)
Next
show_mem_col
End Sub


' --- rotate (editor) -clockwise
Sub rotate
Local i,k
' save editor
For i=1 To 16:z$(i)=m$(i):Next
For i=1 To 16
  m$(i)=""
  For k=16 To 1 Step-1
    m$(i)=m$(i)+Mid$(z$(k),i,1)
  Next
Next
show_mem_col
End Sub


' --- F10 insert column
Sub insert_col
Local i
' x = is cursor column position from main loop
If x=1 Then
  For i=1 To 16
    m$(i)=" "+Left$(m$(i),15)
  Next
End If
If x>1 Then
  For i=1 To 16
    m$(i)=Left$(m$(i),x-1)+" "+Mid$(m$(i),x,16-x)
  Next
End If

show_mem_col

End Sub


' --- F9 delete column
Sub delete_col
Local i
' x = is cursor column position from main loop
If x=1 Then
  For i=1 To 16
    m$(i)=Mid$(m$(i),2,15)+" "
  Next
End If
If x>1 Then
  For i=1 To 16
    m$(i)=Left$(m$(i),x-1)+Right$(m$(i),15-x+1)+" "
  Next
End If

show_mem_col

End Sub





' --- scroll editor (Up/Down , Left/Right using cursor key)
Sub scroll_editor
Local i,k

' save editor
For i=1 To 16:z$(i)=m$(i):Next

clear_menu
Text 100,15,"- - - SCROLL EDITOR - - -"
Text 100,26,"Use arrow keys to scroll editor."
Text 100,34,"Press Enter when you're done."
Text 100,42,"Press ESC to skip"


Do

k=Asc(Inkey$)

If k=128 Then
  scroll_editor_up
  show_mem_col
End If
If k=129 Then
  scroll_editor_down
  show_mem_col
End If
If k=131 Then
  scroll_editor_right
  show_mem_col
End If
If k=130 Then
  scroll_editor_left
  show_mem_col
End If

If k=27 Then  ' Skip - restore editor
  For i=1 To 16:m$(i)=z$(i):Next
  show_mem_col
  Exit Do
End If

Loop Until k=13


End Sub


' --- scroll editor left
Sub scroll_editor_left
Local i
For i=1 To 16
m$(i)=Mid$(m$(i),2,15)+Left$(m$(i),1)
Next
End Sub

' --- scroll editor right
Sub scroll_editor_right
Local i
For i=1 To 16
m$(i)=Right$(m$(i),1)+Mid$(m$(i),1,15)
Next
End Sub

' --- scroll editor up
Sub scroll_editor_up
Local i,s$
s$=m$(1)
For i=2 To 16
m$(i-1)=m$(i)
Next
m$(16)=s$
End Sub

' --- scroll editor down
Sub scroll_editor_down
Local i,s$
s$=m$(16)
For i=15 To 1 Step -1
m$(i+1)=m$(i)
Next
m$(1)=s$
End Sub


' --- animation setup
Sub animation_setup
Local s,e,t,i,k
Local xs,ys ' sprite position
Local xold,yold,told ' used in moving sprite

clear_menu

Box 160,60,150,50,1,RGB(blue)
'Load png "150x50-bg3.png",160,60

Text 100,15,"- - - ANIMATION SETUP - - -"
Text 100,26,"Enter the start and end position."
Text 100,34,"Enter time in milliseconds (default=500)"
Text 100,42,"Change time with plus and minus keys."
Text 100,50,"( STOP animation with Esc key )"
Text 100,70,"Start:":Input s
Text 100,78,"  End:":Input e
Text 100,86," Time:":Input t

If s<1 Or s>63 Then Exit Sub
If e<1 Or s>63 Then Exit Sub
If e<s Then Exit Sub

If t<1 Or t>1000 Then t=250

i=s
xs=230
ys=80
xold=0:yold=0 ' to save last position
told=0

Do
If t<>told Then Text 100,86," Time:? "+Str$(t)+" ":told=t


k=Asc(Inkey$)
'Sprite show i,180,80,1

' check if position has changed (then redraw)
'If xs<>xold Then
  Sprite show i,xs,ys,1
'  xold=xs:yold=ys ' save pos
'End If

Pause t
Sprite hide i
Inc i
If i>e Then i=s
If k=43 And t<1000 Then Inc t,50 ' +
If k=45 And t>0 Then   Inc t,-50 ' -

If k=128 And ys>65 Then Inc ys,-4 ' Up
If k=129 And ys<90 Then Inc ys,4 ' Down
If k=130 And xs>167 Then Inc xs,-4 ' move left
If k=131 And xs<290 Then Inc xs,4 ' move right

'FRAMEBUFFER wait

Loop Until k=27

layout64_update

End Sub


' --- calling this if PageUp/PageDown is pressed
Sub show_page
Local s$,i

If page<1 Then page=1
If page>4 Then page=4
clear_menu
show_page_number
If page=1 Then Restore menu1
If page=2 Then Restore menu2
If page=3 Then Restore menu3
If page=4 Then Restore menu4

' show page
i=10
Do
Read s$
If s$="!" Then Exit Do
Text 95,i,s$
Inc i,8
Loop

End Sub


' --- clear menu area
Sub clear_menu
Box 94,10,220,100,1,RGB(black),fill
End Sub



' --- show page number upper right corner
Sub show_page_number
Local s$
s$="Page "+Str$(page)+"/4"
Text 270,0,s$
End Sub



menu1:
Data "     Cursor Key = move cursor     ? = show ASC-code"
Data "PageUp/PageDown = help text       * = clear editor"
Data "  Insert/Delete = pixel in editor"
Data "  0-9/A-F/SPACE = set color"
Data " "
Data "F11 = delete row                 F9 = delete column"
Data "F12 = insert row                F10 = insert column"
Data "  S = Scroll editor"
Data "  R = Rotate clockwise"
Data "  H = Horizonal Flip             F7 = load sprite"
Data "  V = Vertical Flip              F8 = save sprite"
Data "  Z = Reduce zoom"
Data "!"


menu2:
Data " F5 = save sprite file"
Data " F4 = load sprite file"
Data "                      "
Data " F1 = animation..."
Data "!"

menu3:
Data " "
Data "!"

menu4:
Data "!"


' --- save a sprite file
Sub save_sprite_file
clear_menu
Local s$

Text 100,90,"( to skip = press enter )"
Text 100,50,"Save sprite file, enter a filename..."
Text 100,70,"File-name",s$
Input s$
If s$="" Then
  show_page
  Exit Sub
End If

sfile$=s$
create_64file_sprite ' create sprite file
layout64 ' update screen layout
show_page ' show menu page


End Sub


' --- load a sprite file
Sub load_sprite_file
clear_menu
Local s$

Text 100,80,"( to skip = press enter )"
Text 100,40,"Load sprite file, enter a filename..."
Text 100,60,"File-name",s$
Input s$
If s$="" Then
  show_page
  Exit Sub
End If

sfile$=s$

load_64file_sprite ' load sprite file (also to buffer)

'create_64file_sprite ' save sprite file
'layout64 ' update screen layout
layout64_update
show_page ' show menu page


End Sub


' --- save editor to position #n
Sub save_to_pos
Local n
clear_menu

Font 8

Text 100,50,"Sprite in Editor is saved to a location."
Text 100,90,"( to skip = press enter )"
Text 100,70,"Save to position:"
Input s$
n=Val(s$)
If s$="" Or n<1 Or n>63 Then
  show_page
  Exit Sub
End If


save_to_64buff(n) ' save to pos #n

Text 100,70,Space$(40) 'erase input text

' to show sprite on screen
create_64file_sprite ' F5 save sprite file

layout64 ' update screen layout
show_page ' show menu page

End Sub


' --- load pos #n, to editor
Sub load_pos_to_editor
clear_menu
Font 8
Local i,n,s$
Text 100,50,"Inserting a new sprite in the editor."
Text 100,90,"( to skip = press enter )"
Text 100,70,"Load from position:"
Input s$
n=Val(s$)
If s$="" Or n<1 Or n>63 Then
  show_page
  Exit Sub
End If

Text 100,70,Space$(40) 'erase input text

Open "64buff.dat" For random As  #1
Seek #1,256*(n-1)+1
  For i=1 To 16
    m$(i)=Input$(16,#1)
  Next i
Close #1

show_mem_col ' update editor
show_page ' show menu page

End Sub



' --- show cmode color palett
Sub show_cmode_palett
Font 8
Local i
For i=0 To 15
If cmode=0 Then Text 77,6+(i*6),"  ",,,,,c1(i)
If cmode=1 Then Text 77,6+(i*6),"  ",,,,,c2(i)
Next
End Sub



' --- Change cmode (F9)
Sub change_cmode
If cmode=0 Then
  cmode=1
  Else
  cmode=0
End If
show_mem_col
show_cmode_palett
layout64
End Sub

' --- Insert new row in editor
Sub insert_row
Local i
For i=16 To y Step -1
  m$(i)=m$(i-1)
Next
m$(y)=Space$(16)
show_mem_col
End Sub

' --- Delete row in editor
Sub delete_row
Local i
For i=y+1 To 16
  m$(i-1)=m$(i)
Next
m$(16)=Space$(16) ' clear the last row
show_mem_col ' update editor
End Sub

' --- Insert pixel in editor
Sub insert1
' x is col in editor
' y is row in editor
If x=1 Then m$(y)=" "+Mid$(m$(y),1,15)
If x>1 Then m$(y)=Left$(m$(y),x-1)+" "+Mid$(m$(y),x,16-x)
show_mem_col ' update editor
End Sub

' --- Delete pixel in editor
Sub delete1
If x=1 Then m$(y)=Right$(m$(y),15)+" "
If x>1 Then m$(y)=Left$(m$(y),x-1)+Right$(m$(y),15-x+1)+" "
show_mem_col ' update editor
End Sub


' --- clear sprite editor (to transparent)
Sub clear_editor
For i= 1 To 16
m$(i)=String$(16," ")
Next
End Sub


' --- save editor sprite
'Sub save1
'Local i
'Open "ed16.spr" For output As  #1
'Print #1,"16,1"
'For i=1 To 16
'Print #1,m$(i)
'Next
'Close #1
'End Sub



' --- open editor file and read in sprite data
'Sub load1
'Local i,s$
'Open "ed16.spr" For input As  #1
'Line Input #1,s$ ' read in first line "16,1"
'For i=1 To 16
'Line Input #1,m$(i)
'If Len(m$(i))<16 Then ' fix len to 16 characters
'  m$(i)=m$(i)+Space$(16-Len(m$(i)))
'End If
'Next
'Close #1
'End Sub


' --- show editor in number's
Sub show_mem
Font 8
Local i
For i=1 To 16
Text 4,i*6,m$(i)
Next
End Sub

' --- show editor in color
Sub show_mem_col
Font 8
Local i,x,ci,c$,t
Color RGB(white),RGB(black)
For i=1 To 16
  For x=1 To 16
    c$=Mid$(m$(i),x,1)
    t=Asc(c$)
    ci=Val(c$) ' take out color number
    If Mid$(m$(i),x,1)=" " Then ci=0 ' show transparent as black in editor
    If t>64 And t<71 Then ci=t-55 ' A-F color in editor (fix to 10-15)
    If cmode=0 Then
      Text x*4,i*6," ",,,,,c1(ci) ' font 8 = 4x8
      Else
      Text x*4,i*6," ",,,,,c2(ci) ' font 8 = 4x8
    End If
  Next x
Next i
' show current cmode status
Font 8
If cmode=0 Then Text 210,232,"! = CMM1/CMM2            "
If cmode=1 Then Text 210,232,"! = PicoMiteVGA (RGB121) "


End Sub


' cmode=0 Colour_Maximite CMM1/CMM2
col1:
Data RGB(black),RGB(blue),RGB(green),RGB(cyan)
Data RGB(red),RGB(magenta),RGB(yellow),RGB(white)
Data RGB(myrtle),RGB(cobalt),RGB(midgreen),RGB(cerulean)
Data RGB(rust),RGB(fuchsia),RGB(brown),RGB(lilac)


' cmode=1 PicoMiteVGA RGB121
col2:
Data RGB(black),RGB(blue),RGB(myrtle),RGB(cobalt)
Data RGB(midgreen),RGB(cerulean),RGB(green),RGB(cyan)
Data RGB(red),RGB(magenta),RGB(rust),RGB(fuchsia)
Data RGB(brown),RGB(lilac),RGB(yellow),RGB(white)



' --- layout 64 sprite view
Sub layout64

Sprite close all


' new way
load_64file_sprite
load_64sprite

layout64_update


' show sprite filename (bottom of display)
Text 0,232,"sprite file-name: "+sfile$

End Sub


' --- update sprite on screen
Sub layout64_update


Box 0,110,320,120,1,RGB(black),fill


Font 8
Local x,y,i
i=1
For x=0 To 319 Step 20
' sprite 1-16
Text x+7,120-8,Str$(i)
Box x,120,20,20,1,RGB(blue)
Sprite show i,x+2,122,cmode

' sprite 17-32
Text x+7,150-8,Str$(i+16)
Box x,150,20,20,1,RGB(blue)
Sprite show(i+16),x+2,152,cmode

' sprite 33-48
Text x+7,180-8,Str$(i+32)
Box x,180,20,20,1,RGB(blue)
Sprite show(i+32),x+2,182,cmode

' sprite 49-64
If i<16 Then Text x+7,210-8,Str$(i+48)
If i<16 Then Box x,210,20,20,1,RGB(blue)
If i<16 Then Sprite show(i+48),x+2,212,cmode

Inc i
Next

' show sprite filename (bottom of display)
Text 0,232,"sprite file-name: "+sfile$

End Sub


' --- load sprite file to sprite's (sfile$)
Sub load_64sprite
Sprite close all
If cmode=0 Then Sprite load sfile$,,0
If cmode=1 Then Sprite load sfile$,,1
End Sub


' --- create sprite file (default=spr1.spr)
' --- using 64buff.data
Sub create_64file_sprite
Local i,n

Open sfile$ For output As  #1
Open "64buff.dat" For random As  #2

Print #1,"16,63"
For n=1 To 63
  'Print #1,"16,"+Str$(n)
  Print #1,"' "+Str$(n)
  Seek #2,256*(n-1)+1
  For i=1 To 16
    Print #1,Input$(16,#2)
  Next i
Next n
Flush #2
Close #2
Flush #1
Close #1
End Sub

' --- load sprite file (default=spr1.spr)
' --- also load to 64buff.data
Sub load_64file_sprite
Local i,n,s$

On error skip 1

Open sfile$ For input As  #1
If MM.Errno Then
  Text 100,80,"*** "+MM.ErrMsg$+" ***"
  Pause 3000
  Exit Sub
End If

Open "64buff.dat" For random As  #2


Line Input #1,s$ ' Print #1,"16,63"
For n=1 To 63
  'Print #1,"16,"+Str$(n)
  Line Input #1,s$ ' Print #1,"' "+Str$(n)
  Seek #2,256*(n-1)+1
  For i=1 To 16 ' read data save to buffer file
    Line Input #1,s$
    If Len(s$)<>16 Then Print Len(s$): Input s$
    Print #2,s$; ' read in whitout CR,LF
  Next i
Next n
Flush #2
Close #2
Flush #1
Close #1

load_64sprite
layout64_update

End Sub


' --- create empty file 64buff.dat
' 16384 bytes (16384/64=256, 256/16=16)
Sub create_new_64buff
Local i,n
Open "64buff.dat" For output As  #1
Local n,i
For n=1 To 64
  For i=1 To 16
    Print #1,Space$(16);
  Next i
Next n
Close #1
End Sub


' --- save editor to 64buff -file using random file
Sub save_to_64buff(n)
Local i
Open "64buff.dat" For random As  #1
Seek #1,256*(n-1)+1
  For i=1 To 16
    Print #1,m$(i);
  Next i
Flush #1
Close #1


End Sub
