'JDY-41_INIT.BAS
'JDY-41 2.4GHz Wireless serial port module
'Experimental program for understanding reading and writing of module parameters
'Fredrik Nissfolk 7.11.2024
'Tested only on "standard PicoMite" RP2040.
'All data outputs on console.
'Set your own parameter settings in the DIM-statements below
OPTION EXPLICIT
OPTION DEFAULT NONE
'
'==============================================================================
'FILL IN THE REQUIRED PARAMETER-SETTINGS HERE:
'Basic settings:
dim as string Baud$=chr$(&h04) 'baud rate ?01=1200...04=9600, 05=19200, 06=38400
DIM as string Chan$=CHR$(&h00) 'channel ?Channel range 00...FF?
dim as string Pwr$=chr$(&h09)  'transmitting power (01=-25db....09=+12db)
dim as string CLSS$=CHR$(&hA0) 'CLSS type
dim as string wirelessID.1$=CHR$(&h12) 'wireless ID byte 1
dim as string wirelessID.2$=CHR$(&h34) 'wireless ID byte 2
dim as string wirelessID.3$=CHR$(&h56) 'wireless ID byte 3
dim as string wirelessID.4$=CHR$(&h78) 'wireless ID byte 4
dim as string ACK$=chr$(&h01) 'ACK response (=00: no response, =01: +ACK response)

'Settings for Serial port designated address communication:
dim as string AddrComm.1$=chr$(&hFF)'address byte 1 for specific receiver
dim as string AddrComm.2$=chr$(&hFF)'address byte 2 for specific receiver
dim as string AddrComm.3$=chr$(&hFF)'address byte 3 for specific receiver
dim as string AddrComm.4$=chr$(&hFF)'address byte 4 for specific receiver
'Note: (if the target address is FFFFFFFF, it means to send data to all devices
'
'Device ID has no effect on the operation. Set at factory, but can be changed.
'Return to factory device ID by setting to 0.
DIM as STRING deviceID.1$=chr$(&h00)  'deviceID byte 1
DIM as STRING deviceID.2$=chr$(&h00)  'deviceID byte 2
DIM as STRING deviceID.3$=chr$(&h00)  'deviceID byte 3
DIM as STRING deviceID.4$=chr$(&h00)  'deviceID byte 4
'Datasheeet for JDY-41: https://arduino.ua/files/JDY-41%20Manual.pdf
'==============================================================================

dim as integer param(15),L,I
dim as string parname$(15),dat$


setpin gp1,gp0,COM1 'SETPIN rx, tx, COM1
pin(GP2)=1
PIN(GP3)=1
setpin GP2,DOUT 'CS. If high then module in sleep.
setpin GP3,dout 'SET. Low for parameter programming. High for normal operation.
open "COM1:9600" as #1 'Default 9600 baud
L=LOC(#1) 'cleanup UART buffer
for I=1 to L
dat$=input$(1,#1):print "In input buffer: &h";hex$(asc(dat$),2);" ";dat$
next I
ResetJDY
ReadParameters
ParamConfig   ' to set baud,chan, pwr, tx type, wirelessID, ACK
ReadParameters
ReadVersionNbr ' firmware version nbr
ReadDeviceID  'factory set (or user set) device ID
ConfigureDeviceID 'Reset to factory ID or change to user set device ID.
ReadDeviceID
AddressCommunication 'Transmitting to a specific receiver
'ReadParameters
'ResetJDY
END

SUB AddressCommunication
'In the "normal" case a transmission can be received by all receivers that have
'the same wireless ID. If the transmission is intended only for a specific 
'receiver with a different wireless ID, then the "Address Communication" is 
'required.
'Example: Currently, the 77778888 device needs to send 55667788 data instructions 
'to 11112222 device as follows, 
'B1CA11112222556677880D0A
' -B1CA indicates the instruction head
' -11112222 indicates the address of the target device 
'   (if the target address is FFFFFFFF, it means to send data to all devices)
' -55667788 indicates the data sent to the target device
' -0D0A terminator
print" "
Print "AddressCommunication:"
pin(GP2)=0  'CS
pin(GP3)=0  'SET
Pause 500
'First a dummy. 
PRINT #1,CHR$(&hB1);chr$(&hCA);AddrComm.1$;AddrComm.2$;AddrComm.3$;AddrComm.4$;
pause 500
'The data to be sent to the target device: (eg. transmitters wireless ID)
print #1,wirelessID.1$;wirelessID.2$;wirelessID.3$;wirelessID.4$
pause 1000
L=LOC(#1)
IF L=0 then L=1: endif
for I=1 to L
dat$=input$(1,#1):print "   dummy AddressCommunication: &h";hex$(asc(dat$),2);" ";dat$
next I
Pause 1000
PRINT #1,CHR$(&hB1);chr$(&hCA);AddrComm.1$;AddrComm.2$;AddrComm.3$;AddrComm.4$;
pause 500
'The data to be sent to the target device: (eg. transmitters wireless ID)
print #1,wirelessID.1$;wirelessID.2$;wirelessID.3$;wirelessID.4$
pause 1000
L=LOC(#1)
IF L=0 then L=1: endif
for I=1 to L
dat$=input$(1,#1):print "   After AddressCommunication: &h";hex$(asc(dat$),2);" ";dat$
next I
ResetJDY
end sub


sub ParamConfig 'A9E1xxxxxx0D0A
'ex:  A9 E1   04   00   09    a0   66 77 88 55   01    00     0D 0A
'           baud  chan  pwr  CLSS  deviceID     ACK  no func
print" "
Print "ParamConfig:"
pin(GP2)=0  'CS
pin(GP3)=0  'SET
pause 200
'dat$=input$(20,#1)
Pause 500 'First a dummy read may be required
PRINT #1,CHR$(&hA9);chr$(&hE1);
pause 10 
print #1,Baud$;Chan$;Pwr$;CLSS$;
pause 10 ' --------------device ID-----------------
PRINT #1,wirelessID.1$;wirelessID.2$;wirelessID.3$;wirelessID.4$;
pause 10'
PRINT #1,ACK$;chr$(&h00)
pause 1000
L=LOC(#1)
for I=1 to L 'display dummy read
dat$=input$(1,#1):print "   dummy ParamConfig: &h";hex$(asc(dat$),2);" ";dat$
next I
PAUSE 10 'not sure if the pauses are required
PRINT #1,CHR$(&hA9);chr$(&hE1);
pause 10
print #1,CHR$(&h04);chr$(&h00);chr$(&h09);chr$(&hA0);
pause 10
PRINT #1,CHR$(&h12);chr$(&h34);CHR$(&h56);chr$(&h78);
pause 10
PRINT #1,chr$(&h01);chr$(&h00)
pause 1000
L=LOC(#1)
for I=1 to L 'print the received data
dat$=input$(1,#1):print "   ParamConfig: &h";hex$(asc(dat$),2);" ";dat$
next I
'PIN(GP3)=1:PIN(GP2)=1:pause 1000:PIN(GP3)=0:PIN(GP2)=0
ResetJDY 'Required. Otherwise "ReadParameters" SUB will not show updated data.
end sub

sub ResetJDY  'ABE30D0A 
pin(GP2)=0  'CS
pin(GP3)=0  'SET
print " "
PRINT "ResetJDY:"
pause 100
PRINT #1,CHR$(&hAB);CHR$(&hE3)';chr$(&h0D);chr$(&h0A) 'first attempt
pause 100
'dat$=input$(8,#1) 'dummy read
pause 100
PRINT #1,CHR$(&hAB);CHR$(&hE3)';chr$(&h0D);chr$(&h0A) '
pause 100

'print "Reset: "
L=LOC(#1)
for I=1 to L 'check if the reset gives any reply
dat$=input$(1,#1):print "   ResetJDY: &h";hex$(asc(dat$),2);" ";dat$
next I

end sub

SUB ReadDeviceID 'F2AD0D0A
'Note: the general device ID does not need to be configured. The module comes 
'with the unique ID number when leaving the factory, and each module is 
'different. If you need to restore the factory ID number after configuring 
'the ID, please configure the ID to 0 to automatically restore the factory ID.
'NOTE: THIS IS NOT THE SAME AS THE "WIRELESS ID"!
parname$(1)="instruction head (&hF2)" 'names of parameters for "ReadParameters" SUB.
parname$(2)="instruction head (&hAD)"
parname$(3)="ID byte 1"
parname$(4)="ID byte 2"
parname$(5)="ID byte 3"
parname$(6)="ID byte 4"
parname$(7)="terminator"
parname$(8)="terminator"
parname$(9)=" "
parname$(10)=" "
parname$(11)=" "
parname$(12)=" "
parname$(13)=" "
parname$(14)=" "
PRINT " "
PRINT "ReadDeviceID:"
pause 100
PRINT #1,CHR$(&hF2);CHR$(&hAD)';chr$(&h0D);chr$(&h0A) 'first attempt
pause 500
L=LOC(#1)
for I=1 to L
dat$=input$(1,#1):print "   dummy device ID: &h";hex$(asc(dat$),2);" ";parname$(I)
next I
pause 500
PRINT #1,CHR$(&hF2);CHR$(&hAD)';chr$(&h0D);chr$(&h0A) '
pause 500
'print "Device ID: "
L=LOC(#1)
for I=1 to L
dat$=input$(1,#1):print "   device ID: &h";hex$(asc(dat$),2);" ";parname$(I)
next I
end SUB 

SUB ReadVersionNbr 'ABCD0D0A
'Read version number instruction
'ABCD0D0A
'Return:+V2\r\n
'Seems to need a dummy read at first
'Note: My modules return +V6
print " "
PRINT "Read version nbr:"
pause 100
PRINT #1,CHR$(&hAB);CHR$(&hCD);chr$(&h0D);chr$(&h0A) 'first attempt
pause 100
'dat$=input$(4,#1) 'dummy read
pause 200
PRINT #1,CHR$(&hAB);CHR$(&hCD);chr$(&h0D);chr$(&h0A) '
pause 200
L=LOC(#1)
dat$=input$(L,#1)
print "   version number: ";dat$
END SUB

SUB ReadParameters 'AAE20D0A
'6.4 Parameter reading instruction
'AAE20D0A
'Return: AA E2 04 00 09 a0 66 77 88 55 00 05 0D 0A
'AAE2 indicates the instruction head
'04 indicates that the baud rate is 9600
'00 indicates that the channel is 0
'09 indicates that the transmitting power is +12db
'A0 indicates CLSS type is transparent
'66778855 means wireless ID
'00 indicates no ACK response
'00 no function
'0D0A indicates the terminator
'
'When configuring MCU or USB to serial port tool, the CS and SET pins must 
'be pulled down, and the default baud rate is 9600
'Note: The configuration instruction should be issued in HEXADECIMAL format
parname$(1)="instruction head (&hAA)" 'names of parameters for "ReadParameters" SUB.
parname$(2)="instruction head (&hCD)"
parname$(3)="baud rate ?01=1200...04=9600, 05=19200, 06=38400?"
parname$(4)="channel ?Channel range 00...FF?"
parname$(5)="transmitting power (01=-25db....09=+12db)"
parname$(6)="CLSS type"
parname$(7)="wireless ID byte 1"
parname$(8)="wireless ID byte 2"
parname$(9)="wireless ID byte 3"
parname$(10)="wireless ID byte 4"
parname$(11)="ACK response (=00: no response, =01: +ACK response)"
parname$(12)="no function"
parname$(13)="terminator"
parname$(14)="terminator"

PRINT" "
PRINT "ReadParameters:"
 pause 100
 pin(GP2)=0  'CS
 pin(GP3)=0  'SET
 pause 100
'Seems to be necessary to make a first "scrap" read after power-up before
'the real data read. Module first responds with "+Wake".
PRINT #1,CHR$(&hAA);CHR$(&hE2)';chr$(&h0D);chr$(&h0A)
pause 1000
L=LOC(#1)
if L=0 then L=1: endif
dat$=input$(L,#1):print"   dummy: "; dat$;asc(dat$);" &h";hex$(asc(dat$),L)
pause 1000
PRINT #1,CHR$(&hAA);CHR$(&hE2)';chr$(&h0D);chr$(&h0A)
pause 1000
L=LOC(#1)
if L=0 then L=1: endif
for I=1 to L
dat$=input$(1,#1):print "   char nbr: &h";hex$(asc(dat$),2);" ";parname$(I)
param(I)=ASC(dat$)
next I
'for I=1 to 14:print param(I):next I
end SUB

SUB ConfigureDeviceID 'F1AExxxx0D0A
'Note: the general device ID does not need to be configured. The module comes 
'with the unique ID number when leaving the factory, and each module is 
'different.
'If you need to restore the factory ID number after configuring the ID, 
'please configure the ID to 0 to automatically restore the factory ID.

print" "
Print "ConfigureDeviceID:"
pin(GP2)=0  'CS
pin(GP3)=0  'SET
pause 200
'dat$=input$(20,#1)
Pause 500
'First a dummy. 
PRINT #1,CHR$(&hF1);chr$(&hAE);deviceID.1$;deviceID.2$;deviceID.3$;deviceID.4$
pause 1000
L=LOC(#1)
IF L=0 then L=1: endif
for I=1 to L
dat$=input$(1,#1):print "   dummy SetID: &h";hex$(asc(dat$),2);" ";dat$
next I
Pause 1000
PRINT #1,CHR$(&hF1);chr$(&hAE);deviceID.1$;deviceID.2$;deviceID.3$;deviceID.4$
pause 1000
L=LOC(#1)
IF L=0 then L=1: endif
for I=1 to L
dat$=input$(1,#1):print "   After SetID: &h";hex$(asc(dat$),2);" ";dat$
next I
ResetJDY
end sub