/**
  * @brief RTC Initialization Function
  * @param None
  * @retval None
  */
/* RTC init function */
static void MX_RTC_Init(void)
{

  /* USER CODE BEGIN RTC_Init 0 */

  /* USER CODE END RTC_Init 0 */

  RTC_TimeTypeDef sTime;
  RTC_DateTypeDef sDate;

  /* USER CODE BEGIN RTC_Init 1 */

  /* USER CODE END RTC_Init 1 */

    /**Initialize RTC Only
    */
  hrtc.Instance = RTC;
  hrtc.Init.HourFormat = RTC_HOURFORMAT_24;
  hrtc.Init.AsynchPrediv = 7;
  hrtc.Init.SynchPrediv = 4095;
  hrtc.Init.OutPut = RTC_OUTPUT_DISABLE;
  hrtc.Init.OutPutPolarity = RTC_OUTPUT_POLARITY_HIGH;
  hrtc.Init.OutPutType = RTC_OUTPUT_TYPE_OPENDRAIN;
  hrtc.Init.OutPutRemap = RTC_OUTPUT_REMAP_NONE;

  /* USER CODE BEGIN RTC_Init 2 */
  if (HAL_RTC_GetTime(&hrtc, &sTime, RTC_FORMAT_BIN) != HAL_OK)
  {
	  SystemError=1;Error_Handler();
  }

  if (HAL_RTC_GetDate(&hrtc, &sDate, RTC_FORMAT_BIN) != HAL_OK)
  {
	  SystemError=1;Error_Handler();
  }
 // RtcGetTime();
  if(sDate.Year<18){
	  /* USER CODE END RTC_Init 2 */
	  if (HAL_RTC_Init(&hrtc) != HAL_OK)
		{
		  SystemError=1;Error_Handler();
		}
		/**Initialize RTC and set the Time and Date
		*/
	  sTime.Hours = 0;
	  sTime.Minutes = 0;
	  sTime.Seconds = 0;
	  sTime.DayLightSaving = RTC_DAYLIGHTSAVING_NONE;
	  sTime.StoreOperation = RTC_STOREOPERATION_RESET;
	  if (HAL_RTC_SetTime(&hrtc, &sTime, RTC_FORMAT_BIN) != HAL_OK)
	  {
		  SystemError=1;Error_Handler();
	  }
	  /* USER CODE BEGIN RTC_Init 3 */

	  /* USER CODE END RTC_Init 3 */

	  sDate.WeekDay = RTC_WEEKDAY_MONDAY;
	  sDate.Month = RTC_MONTH_JANUARY;
	  sDate.Date = 1;
	  sDate.Year = 0;

	  if (HAL_RTC_SetDate(&hrtc, &sDate, RTC_FORMAT_BIN) != HAL_OK)
	  {
		  SystemError=1;Error_Handler();
	  }
	  /* USER CODE BEGIN RTC_Init 4 */
	}
	  /* USER CODE END RTC_Init 4 */

}