'Mandelbrot Explorer V0.9 for Color Maximite 2
'By the Sasquatch
'Based on enhancements to Peter Mather's MandelBrot CSUB
'www.thebackshed.com

Setup:
  'Screen Resolutin set here, Should work at any reasonable resolution
  Mode 1,8  '800 X 600 for compatabliliy with MMBasic V5.05.04
'  Mode 9,8  '1024 X 768 Nice but a bit slower to render
  CLS


  XMax = MM.HRES - 1
  YMax = MM.VRES - 1
  XCursor = XMax / 2
  YCursor = YMax / 2

  KeyCount = 1

  CONST True = 1
  CONST False = 0
  FileName$ = "MandelBrot.bmp"

  Depth% = 64 
  Scale! = 1.0
  XCenter! = -0.75
  YCenter! = 0.0

  Dim Clut(255) as Integer
  For X = 0 To 255
    Clut(X) = Map(X)
  Next X

  Refresh = True
  Done = False
  RollColors = False

  T = Timer

  MakeSprite

  HelpScreen

MainLoop:
Do  'Main Loop Starts Here
  Key$ = Inkey$

  'Process Cursor Keys
  If KeyDown(0) Then
    For X = 1 to KeyDown(0)
      K = KeyDown(X)
      Select case K
        case 128  'Up Arrow  
          YCursor = YCursor - 1
          If YCursor < 0 Then YCursor = 0
        case 129  'Down Arrow
          YCursor = YCursor + 1
          If YCursor > YMax Then YCursor = YMax
        case 130  'Left Arrow
          XCursor = XCursor - 1
          If XCursor < 0 Then XCursor = 0
        case 131  'Right Arrow
          XCursor = XCursor + 1
          If XCursor > XMax Then XCursor = XMax
      End Select
    Next X

    ' Refresh Cursor Sprite
    If K >= 128 And K <= 131 Then
      Sprite Show 1,XCursor-15,YCursor-15,1
      'Make the cursor move faster if key held down
      KeyCount = KeyCount + 1
      If KeyCount > 18 Then KeyCount = 18
      Pause(190 - KeyCount * 10)
    EndIf

  Else
    ' If Key not pressed, reset key held count
    KeyCount = 1
  EndIf

  'Now Check for other Key Commands
  If Key$ <> "" Then 

    If Key$ = Chr$(134) Then
    'Home Key Reset everything
      Scale! = 1.0
      XCenter = -0.75
      YCenter = 0.0
      Refresh = True
      RollColors = False
      Map Reset

    Else IF Key$ = "C" or Key$ = "c" Then
      'Re center at cursor    
      UpdateToCursor
      Refresh = True

    Else IF Key$ = "I" Or Key$ = "i" Then
      'Zoom in at cursor center
      UpdateToCursor
      Scale = Scale * 2
      Refresh = True

    Else IF Key$ = "O" Or Key$ = "o" Then
      'Zoom out at cursor center
      UpdateToCursor
      Scale = Scale / 2
      Refresh = True

    'Else if Key$ = "Z" or Key$ = "z"
      'Zoom to frame cursor

    Else IF Key$ = "Q" Or Key$ = "q" Then
      'Time to Quit
      Done = True

    Else IF Key$ = "S" Or Key$ = "s" Then
      'Save as Bitmap
      Print @(0,0) "Save Bitmap - Please Be Patient "
      Print "Saving the image will take a few seconds "
      Print "File name for Save [";FileName$;"]";
      Input ;Res$
      If Res$ <> "" Then
          FileName$ = Res$    
      EndIf
      'Hide the cursor Sprite
      If Sprite(X,1) > -1 Then Sprite Hide 1
      'Refresh the Image
      Mandelbrot Depth%,Scale!,XCenter!,YCenter!
      'Now save to file
      Save Image FileName$
      Print @(0,0) "Save Image Done "
      Key$ = Inkey$   'Flush the keyboard buffer
      Refresh = True

    Else IF Key$ = "D" Or Key$ = "d" Then
      'Prompt for new Depth
      Print @(0,0) "Input Depth (Iterations) ["+STR$(Depth%)+"]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) > 0 And Val(Res$) < 1025 Then
        Depth% = Val(Res$)
      EndIf
      Refresh = True

    Else IF Key$ = "E" Or Key$ = "e" Then
     'Propmt for new coordinates
     Print @(0,0) "Enter Scale ["+STR$(Scale!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > 0.0 And Val(Res$) < 1025 Then
        SCALE! = Val(Res$)
      EndIf
     Print "Enter X Center ["+STR$(XCenter!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > -2.0 And Val(Res$) < 2.0 Then
        XCenter! = Val(Res$)
      EndIf
     Print "Enter Y Center ["+STR$(YCenter!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > -2.0 And Val(Res$) < 2.0 Then
        YCenter! = Val(Res$)
      EndIf
      Refresh = True
    
    Else IF Key$ = "L" Or Key$ = "l" Then
      'List Current Coordinates
      Print @(0,0) "Scale = ";Scale!;" "
      Print "X Center = ";XCenter!;" "
      Print "Y Center = ";YCenter!;" "
      Print "Depth = ";Depth%;" "

    Else IF Key$ = "H" Or Key$ = "h" Or Key$ = "?" Then
      'Show Help Screen
      If Sprite(X,1) > -1 Then Sprite Hide 1
      HelpScreen
      Refresh = True

'    Else IF Key$ = "F" Or Key$ = "f" Then
      'File Menu???

    Else IF Key$ = "R" Or Key$ = "r" Then
      'Toggle Roll Colors On/Off
      If RollColors Then
        RollColors = False
      else
        RollColors = True
      EndIf

    Else IF Key$ = "M" Or Key$ = "m" Then
      'Reset Color Map 
       RollColors = False
       Map Reset
    EndIf

  EndIf

  If Refresh Then
    'Hide the cursor sprite
    If Sprite(X,1) > -1 Then Sprite Hide 1
    'Call the Mandelbrot CSUB to render the image
    Mandelbrot Depth%,Scale!,XCenter!,YCenter!
    Refresh = False
    'Put this here to clear the Inkey$ buffer 
    'because normal keyboard input is halted during CSUB render
    Key$ = Inkey$
    'Reset Cursor position to center screen
    XCursor = XMax / 2
    YCursor = YMax / 2
    'Show the cursor sprite
    Sprite Show 1,XCursor-15,YCursor-15,1
  EndIf

  If RollColors And Timer - T > 500 Then
    T = Timer
    Temp = Clut(0)
    For X = 0 to 254
       Clut(X) = Clut(X+1)
       Map(X) = Clut(X)
    Next X
    Clut(255) = Temp
    Map(255) = Temp
    Map Set
  EndIf

Loop While Not Done  'End of Main Loop

Map Reset
CLS

END


Sub UpdateToCursor
  'Calculate new Mandelbrot coordinates from cursor position
  XCenter! = XCenter! + (XCursor - XMax / 2) / XMax * 3 / Scale!
  YCenter! = YCenter! + (YMax / 2 - YCursor) / YMax * 3 / Scale!
End Sub


SUB MakeSprite
  'Draw the cursor sprite and then read from screen
  CLS
  Line 15,0,15,29,1
  Line 0,15,29,15,1
  Circle 15,15,10,1
  Sprite Read 1,0,0,30,30
  CLS
End Sub


Sub HelpScreen
  'Because we all need a little help sometimes :)
  CLS
  Print : Print
  Print "Mandelbrot Explorer V0.9 for Color Maximite 2"
  Print 
  Print "By the Sasquatch"
  Print "Based on enhancements to Peter Mather's MandelBrot CSUB"
  Print "www.thebackshed.com"
  Print : Print
  Print "Cursor Command Keys:"
  Print "   <Arrow Keys> - Move Cursor"
  Print "         <Home> - Reset to default coordinates"
  Print "              I - zoom In at cursor"
  Print "              O - zoom Out at cursor"
'  Print "              Z - Zoom to frame cursor"
  Print : Print
  Print "Color Command Keys:"
  Print "              R - toggle Roll Colors on/off"
  Print "              M - reset color Map"
  Print : Print
  Print "Coordinate Command Keys:"
  Print "              D - change Depth (iterations)"
  Print "              E - Enter new coordinates"
  Print "              L - List current coordinates"
  Print : Print
  Print "System Command Keys:"
'  Print "              F - File Menu
  Print "            H,? - Help screen"
  Print "              S - Save bitmap file"
  Print "              Q - Quit program"
  Print 
  Print "Note: Press <Enter> at any prompt to retain current value"

  Print : Print
  Print "Press any key to Continue"
  Do While Inkey$ = "" : Loop
  CLS
End Sub


'Mandelbrot CSub 
'Mandelbrot(Depth,Scale,XCenter,YCenter)
'File Mandelbrot.bas written 07-07-2020 18:10:39
CSUB mandelbrot
  00000000
  B097B590 60F8AF00 607A60B9 4B9C603B 681B681B 4B9B637B 681B681B 2300633B 
  230062FB 230163BB E11B63FB 643B2301 6C3BE110 3A90EE07 6AE7EEF8 EE076B7B 
  EEB83A90 EEC67AE7 EEB77A87 EEB67AE7 EE376B00 68BB5B46 6B00ED93 7B06EE85 
  6B08EEB0 6B06EE27 ED93687B EE367B00 ED877B07 6BFB7B08 3A90EE07 6AE7EEF8 
  EE076B3B EEB83A90 EEC67AE7 EEB77A87 EEB67AE7 EE376B00 68BB5B46 6B00ED93 
  7B06EE85 6B08EEB0 6B06EE27 ED93683B EE367B00 ED877B07 F04F7B06 F04F0200 
  E9C70300 F04F2314 F04F0200 E9C70300 23012312 E039647B 7B14ED97 6B07EE27 
  7B12ED97 7B07EE27 7B47EE36 6B08ED97 7B07EE36 7B04ED87 7B14ED97 6B07EE37 
  7B12ED97 7B07EE26 6B06ED97 7B07EE36 7B12ED87 2304E9D7 2314E9C7 7B14ED97 
  6B07EE27 7B12ED97 7B07EE27 7B07EE36 6B00EEB1 7BC6EEB4 FA10EEF1 6C7BDD03 
  4B5163BB 6C7B647B 647B3301 681B68FB 429A6C7A 68FBDBC0 6C7A681B D10B429A 
  681B4B4A 6C3B461C 6B3A1E58 1AD36BFB 46192200 E06A47A0 EE076BBB EEB83A90 
  ED9F7BE7 EE276B3D EEFD7B06 EE177BC7 425A3A90 B2D2B2DB 4253BF58 6BBB62FB 
  F003425A F0020303 BF580203 2B014253 4B36D10D 461C681B 1E586C3B 6BFB6B3A 
  6AFA1AD1 43134B32 47A0461A 6BBBE03F F003425A F0020303 BF580203 2B024253 
  4B2AD10D 461C681B 1E586C3B 6BFB6B3A 6AFB1AD1 037FF443 47A0461A 6BBBE027 
  F003425A F0020303 BF580203 2B034253 4B1ED10D 461C681B 1E586C3B 6BFB6B3A 
  6AFB1AD1 437FF443 47A0461A 6BBBE00F 0303F003 D10A2B00 681B4B14 6C3B461C 
  6B3A1E58 1AD36BFB 46196AFA 6C3B47A0 643B3301 6B7B6C3A F77F429A 6BFBAEEA 
  63FB3301 6B3B6BFA F77F429A BF00AEDF 375CBF00 BD9046BD 00000000 40A0B200 
  080002EC 080002F0 000F423F 08000338 00FFFF00 
End CSUB
