'Mandelbrot Explorer V0.97T for Color Maximite 2
'By the Sasquatch
'Based on enhancements to Peter Mather's MandelBrot CSUB
'www.thebackshed.com

Setup:
  'Screen Resolution set here, Should work at any reasonable resolution
  Mode 1,8  '800 X 600 for compatabliliy with MMBasic V5.05.04
'  Mode 9,8  '1024 X 768 Nice but a bit slower to render
  CLS


  XMax = MM.HRES - 1
  YMax = MM.VRES - 1
  XCursor = XMax / 2
  YCursor = YMax / 2

  KeyCount = 1

  CONST True = 1
  CONST False = 0
  FileName$ = "MandelBrot.bmp"

  Zoom = 2.0
  Depth% = 64 
  Scale! = 1.0
  XCenter! = -0.7
  YCenter! = 0.0

  Dim Clut(256) as Integer
  For X = 0 To 255
    Clut(X) = Map(X)
  Next X

  Refresh = True
  Done = False
  RollColors = False
  CList = False

  T = Timer

  MakeSprite

  HelpScreen

MainLoop:
Do  'Main Loop Starts Here

  'Process Cursor Keys
  If KeyDown(0) Then
    For X = 1 to KeyDown(0)
      K = KeyDown(X)
      Select case K
        case 128  'Up Arrow  
          YCursor = YCursor - 1
          If YCursor < 0 Then YCursor = 0
        case 129  'Down Arrow
          YCursor = YCursor + 1
          If YCursor > YMax Then YCursor = YMax
        case 130  'Left Arrow
          XCursor = XCursor - 1
          If XCursor < 0 Then XCursor = 0
        case 131  'Right Arrow
          XCursor = XCursor + 1
          If XCursor > XMax Then XCursor = XMax
      End Select
    Next X

    ' Refresh Cursor Sprite
    If K >= 128 And K <= 131 Then
      Sprite Show 1,XCursor-15,YCursor-15,1
      'Make the cursor move faster if key held down
      KeyCount = KeyCount + 1
      If KeyCount > 18 Then KeyCount = 18
      Pause(190 - KeyCount * 10)
    EndIf

  Else
    ' If Key not pressed, reset key held count
    KeyCount = 1
    K = 0
  EndIf

  'Now Check for other Key Commands
  If K <> 0 Then 

    If K = 134 Then
    'Home Key Reset everything
      Zoom = 2.0
      Depth% = 64
      Scale! = 1.0
      XCenter = -0.70
      YCenter = 0.0
      Refresh = True
      RollColors = False
      Map Reset

    Else IF K = 67 or K = 99 Then  'C or c
      'Re center at cursor    
      UpdateToCursor
      Refresh = True

    Else IF K = 73 Or K = 105 Then 'I or i
      'Zoom in at cursor center
      UpdateToCursor
      Scale = Scale * Zoom
      Refresh = True

    Else IF K = 79 Or K = 111 Then  'O or o
      'Zoom out at cursor center
      UpdateToCursor
      Scale = Scale / Zoom
      Refresh = True

    Else if K = 90 or K = 122 Then  'Z or z
      'Change Zoom Factor
      Page Copy 1 To 0,B
      Print @(0,0) "Enter Zoom Factor ["+STR$(Zoom)+"]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) > 0 And Val(Res$) < 100.0 Then
        Zoom = Val(Res$)
      EndIf
      Page Copy 1 To 0,B
      Sprite Show 1,XCursor-15,YCursor-15,1    

    Else IF K = 81 Or K = 113 Then  'Q or q
      'Time to Quit
      Done = True

    Else IF K = 83 Or K = 115 Then  'S or s
      'Save as Bitmap
      Print @(0,0) "Save Bitmap - Please Be Patient "
      Print "Saving the image will take a few seconds "
      Print "File name for Save [";FileName$;"]";
      Input ;Res$
      If Res$ <> "" Then
          FileName$ = Res$    
      EndIf
      'Hide the cursor Sprite
      If Sprite(X,1) > -1 Then Sprite Hide 1
      'Refresh the Image
      Page Copy 1 To 0,B
      'Now save to file
      Save Image FileName$
      Print @(0,0) "Save Image Done "
      Refresh = True

    Else IF K = 68 Or K = 100 Then  'D or d
      'Prompt for new Depth
      Page Copy 1 To 0,B
      Print @(0,0) "Enter Depth (Iterations) ["+STR$(Depth%)+"]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) > 0 And Val(Res$) < 1025 Then
        Depth% = Val(Res$)
        Refresh = True
      Else
        Page Copy 1 To 0,B
        Pause(500)  
      EndIf

    Else IF K = 69 Or K = 101 Then  'E or e
     'Propmt for new coordinates
     Page Copy 1 To 0,B
     Print @(0,0) "Enter Scale ["+STR$(Scale!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > 0.0 And Val(Res$) < 1E10 Then
        SCALE! = Val(Res$)
        Refresh = True
      EndIf
     Print "Enter X Center ["+STR$(XCenter!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > -2.0 And Val(Res$) < 2.0 Then
        XCenter! = Val(Res$)
        Refresh = True
      EndIf
     Print "Enter Y Center ["+STR$(YCenter!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > -2.0 And Val(Res$) < 2.0 Then
        YCenter! = Val(Res$)
        Refresh = True
      EndIf
     If Not Refresh Then
       Page Copy 1 To 0,B
       Pause(500)
     EndIf
    
    Else IF K = 76 Or K = 108 Then  'L or l
      'List Current Coordinates On/Off
      If CList Then
        CList = False
        Page Copy 1 To 0,B
      Else 
        CList = True
      End If
      Pause(500)

    Else IF K = 72 Or K = 104 Or K = 63 Then 'H or h or ?
      'Show Help Screen
      If Sprite(X,1) > -1 Then Sprite Hide 1
      HelpScreen
      Page Copy 1 To 0,B
      Sprite Show 1,XCursor-15,YCursor-15,1    
      Pause(500)

'    Else IF K = 70 Or K = 102 Then  'F or f
      'File Menu???

    Else IF K = 82 Or K = 114 Then  'R or r
      'Toggle Roll Colors On/Off
      If RollColors Then
        RollColors = False
      else
        RollColors = True
      EndIf
      Pause(500)

    Else IF K = 77 Or K = 109 Then  'M or m
      'Reset Color Map 
       RollColors = False
       Map Reset

'    Else IF K = 85 Or K = 117 Then  'U or u
      'Undo last coordinate change 

    EndIf

  EndIf  'If K <> 0 Then

  If Refresh Then
    'Hide the cursor sprite
    If Sprite(X,1) > -1 Then Sprite Hide 1
    'Call the Mandelbrot CSUB to render the image
    Mandelbrot Depth%,Scale!,XCenter!,YCenter!
    Page Copy 0 TO 1
    Refresh = False
    XCursor = XMax / 2
    YCursor = YMax / 2
    'Show the cursor sprite
    Sprite Show 1,XCursor-15,YCursor-15,1    
    Pause(500)
  EndIf

  If CList Then
      Print @(0,0)"X Center = [";XCenter!;"] ";
      Print XCenter! + (XCursor - XMax / 2) / XMax * 3 / Scale!;" "
      Print "Y Center = [";YCenter!;"] ";
      Print YCenter! + (YMax / 2 - YCursor) / YMax * 3 / Scale!;" "
      Print "Scale = [";Scale!;"] "
      Print "Depth = [";Depth%;"] "
  EndIf


  If RollColors And Timer - T > 750 Then
    T = Timer
    Temp = Clut(0)
    For X = 0 to 254
       Clut(X) = Clut(X+1)
       Map(X) = Clut(X)
    Next X
    Clut(255) = Temp
    Map(255) = Temp
    Map Set
  EndIf

Loop While Not Done  'End of Main Loop

Map Reset
CLS

END


Sub UpdateToCursor
  'Calculate new Mandelbrot coordinates from cursor position
  XCenter! = XCenter! + (XCursor - XMax / 2) / XMax * 3 / Scale!
  YCenter! = YCenter! + (YMax / 2 - YCursor) / YMax * 3 / Scale!
End Sub


SUB MakeSprite
  'Draw the cursor sprite and then read from screen
  CLS
  Line 15,0,15,29,1
  Line 0,15,29,15,1
  Circle 15,15,10,1
  Circle 15,15,2,1,,0,0
  Sprite Read 1,0,0,30,30
  CLS
End Sub


Sub HelpScreen
  'Because we all need a little help sometimes :)
  CLS
  Print : Print
  Print "Mandelbrot Explorer V0.97T for Color Maximite 2"
  Print 
  Print "By the Sasquatch"
  Print "Based on enhancements to Peter Mather's MandelBrot CSUB"
  Print "www.thebackshed.com"
  Print : Print
  Print "Cursor Command Keys:"
  Print "   <Arrow Keys> - Move Cursor"
  Print "         <Home> - Reset to default coordinates"
  Print "              I - zoom In at cursor"
  Print "              O - zoom Out at cursor"
  Print "              Z - change Zoom factor"
  Print : Print
  Print "Color Command Keys:"
  Print "              R - toggle Roll Colors on/off"
  Print "              M - reset color Map"
  Print : Print
  Print "Coordinate Command Keys:"
  Print "              D - change Depth (iterations)"
  Print "              E - Enter new coordinates"
  Print "              L - Toggle coordinates List On/Off"
'  Print "              U - Undo the last coordinate change"
  Print : Print
  Print "System Command Keys:"
'  Print "              F - File Menu
  Print "            H,? - Help screen"
  Print "              S - Save bitmap file"
  Print "              Q - Quit program"
  Print 
  Print "Note: Press <Enter> at any prompt to retain current value"
  Print : Print
  On Error Skip 1
  Load JPG "Mandelbrotaxes.jpg",XMax-360,100
  Print "Press any key to Continue"
  Pause(500)
  Do While Inkey$ = ""
    Pause(100)
  Loop
  CLS
End Sub


'Mandelbrot CSub 
'Mandelbrot(Depth,Scale,XCenter,YCenter)
'File mandelbrot.bas written 06-09-2020 09:14:51
'Test version calls RoutineChecks() excessivly
CSUB mandelbrot
  00000000
  B097B590 60F8AF00 607A60B9 4B9E603B 681B681B 4B9D637B 681B681B 2300633B 
  230062FB 230163BB E11E63FB 643B2301 4B97E113 4798681B EE076C3B EEF83A90 
  6B7B6AE7 3A90EE07 7AE7EEB8 7A87EEC6 7AE7EEB7 6B00EEB6 5B46EE37 ED9368BB 
  EE856B00 EEB07B06 EE276B08 687B6B06 7B00ED93 7B07EE36 7B08ED87 EE076BFB 
  EEF83A90 6B3B6AE7 3A90EE07 7AE7EEB8 7A87EEC6 7AE7EEB7 6B00EEB6 5B46EE37 
  ED9368BB EE856B00 EEB07B06 EE276B08 683B6B06 7B00ED93 7B07EE36 7B06ED87 
  0200F04F 0300F04F 2314E9C7 0200F04F 0300F04F 2312E9C7 647B2301 ED97E039 
  EE277B14 ED976B07 EE277B12 EE367B07 ED977B47 EE366B08 ED877B07 ED977B04 
  EE377B14 ED976B07 EE267B12 ED977B07 EE366B06 ED877B07 E9D77B12 E9C72304 
  ED972314 EE277B14 ED976B07 EE277B12 EE367B07 EEB17B07 EEB46B00 EEF17BC6 
  DD03FA10 63BB6C7B 647B4B52 33016C7B 68FB647B 6C7A681B DBC0429A 681B68FB 
  429A6C7A 4B4CD10B 461C681B 1E586C3B 6BFB6B3A 22001AD3 47A04619 6BBBE06A 
  3A90EE07 7BE7EEB8 6B3DED9F 7B06EE27 7BC7EEFD 3A90EE17 B2DB425A BF58B2D2 
  62FB4253 425A6BBB 0303F003 0203F002 4253BF58 D10D2B01 681B4B37 6C3B461C 
  6B3A1E58 1AD16BFB 4B346AFA 461A4313 E03F47A0 425A6BBB 0303F003 0203F002 
  4253BF58 D10D2B02 681B4B2B 6C3B461C 6B3A1E58 1AD16BFB F4436AFB 461A037F 
  E02747A0 425A6BBB 0303F003 0203F002 4253BF58 D10D2B03 681B4B1F 6C3B461C
  6B3A1E58 1AD16BFB F4436AFB 461A437F E00F47A0 F0036BBB 2B000303 4B16D10A 
  461C681B 1E586C3B 6BFB6B3A 6AFA1AD3 47A04619 33016C3B 6C3A643B 429A6B7B 
  AEE7F77F 33016BFB 6BFA63FB 429A6B3B AEDCF77F BF00BF00 46BD375C BF00BD90 
  00000000 40A0B200 080002EC 080002F0 0800033C 000F423F 08000338 00FFFF00 
End CSUB
