#include "ARMCFunctions.h"
void mandelbrot(int *itermax,MMFLOAT *magnify, MMFLOAT *xcenter, MMFLOAT *ycenter){
double x,xx,y,cx,cy;
   int iteration,hx,hy;
//   double magnify=1.0; 
   int hxres = HRes;        /* horizonal resolution        */
   int hyres = VRes;        /* vertical resolution        */
   int lastiter=0, theiter=0;

   for (hy=1;hy<=hyres;hy++)  
     {
       RoutineChecks();
       for (hx=1;hx<=hxres;hx++)  
          {
           cx = (((float)hx)/((float)hxres)-0.5)/ *magnify * 3.0 + *xcenter;
           cy = (((float)hy)/((float)hyres)-0.5)/ *magnify * 3.0 + *ycenter;
           x = 0.0; y = 0.0;
           for (iteration=1;iteration<*itermax;iteration++)  
             {
               xx = x*x-y*y+cx;
               y = 2.0*x*y+cy;
               x = xx;
               if (x*x+y*y > 4.0){
                   theiter=iteration;
                   iteration = 999999;
             }
          }
           if (iteration== *itermax)  
             DrawPixel(hx-1,hyres - hy,0x00);
           else 
            {
              lastiter=((int)((MMFLOAT)theiter * 2137.0)) % 256;
              if(theiter% 4==1)DrawPixel(hx-1,hyres - hy,0xFFFF00 | lastiter );
              else if(theiter% 4==2)DrawPixel(hx-1,hyres - hy,0xFF0000 | lastiter );
              else if(theiter% 4==3)DrawPixel(hx-1,hyres - hy,0xFF00 | lastiter );
              else if(theiter% 4==0)DrawPixel(hx-1,hyres - hy, lastiter );
            }
         }
     }
}
