'Mandelbrot
'By The Sasquatch
'For PicoMiteVGA or PicoMite with LCD

If MM.Device$ = "PicoMiteVGA" Then
  MODE 2  'Works in Mode1 or Mode2 on PicoMiteVGA
EndIf

CLS

Dim CMap%(16)

CMap%(0) = RGB(0,0,0)
CMap%(1) = RGB(0,85,0)
CMap%(2) = RGB(0,170,0)
CMap%(3) = RGB(0,255,0)
CMap%(4) = RGB(0,0,255)
CMap%(5) = RGB(0,55,255)
CMap%(6) = RGB(0,170,255)
CMap%(7) = RGB(0,255,255)
CMap%(8) = RGB(255,0,0)
CMap%(9) = RGB(255,85,0)
CMap%(10) = RGB(255,170,0)
CMap%(11) = RGB(255,255,0)
CMap%(12) = RGB(255,0,255)
CMap%(13) = RGB(255,85,255)
CMap%(14) = RGB(255,170,255)
CMap%(15) = RGB(255,255,255)

XMax = MM.HRes - 1
YMax = MM.VRes - 1
XM = MM.HRes - 1
YM = MM.VRes - 1

Timer = 0
Mandelbrot(32,1.0,-0.7,0.0)
Print Timer/1000

'Pure MMBASCIC version of the Mandelbrot Sub
'Mandelbrot(Depth,Scale,XCenter,YCenter)
'Variable names shortened for efficiency
Sub Mandelbrot(IMax%,Mag!,XCen!,YCen!)  'Maximum Iterations (Depth), Magnification (Scale)
                                         'X-Center, Y-Center
  For HY = 1 To YMax    'Step through each Row (Line) of pixels (Y-Axis)
    CY = (HY / YMax - 0.5) / Mag! * 3.0 - YCen!

    For HX = 1 To XMax   'Step through each Pixel in the Row (X-Axis)
      CX = (HX / XMax - 0.5) / Mag! * 3.0 + XCen!

      X = 0.0:Y = 0.0

      For Iter = 1 To IMax%      'Step from 1 to Maximum Iterations
        XSqr = X * X
        YSqr = Y * Y

        If XSqr + YSqr > 4 Then Exit For  'If "radius" greater than escape value stop
                                            'C^2 = A^2 + B^2 or R^2 = X^2 + Y^2

        Y = 2 * X * Y + CY     'Iterate next value
        X = XSqr - YSqr + CX

      Next Iter

      If Iter - 1 < IMax% Then   'If we didn't reach the Maximum number of iterations (Depth)
        Pixel HX-1,HY-1,CMap%(Iter Mod 15) 'color the pixel based on number of Iterations
      Else
        Pixel HX-1,HY-1,CMap%(0)  'Otherwise Make the Pixel black
      EndIf

    Next HX

  Next HY
End Sub


'Pure MMBASCIC version of the Mandelbrot Sub
'Mandelbrot(Depth,Scale,XCenter,YCenter)
'Variable names shortened for efficiency
Sub Mandelbrot2(IM%,Ma!,XC!,YC!)
  For HY=1To YM
    CY=(HY/YM-.5)/Ma!*3-YC!
    For HX=1To XM
      CX=(HX/XM-.5)/Ma!*3+XC!
      X=0:Y=0
      For It=1To IM%
        XS=X*X
        YS=Y*Y
        If XS+YS>4Then Exit For
        Y=2*X*Y+CY
        X=XS-YS+CX
      Next It
      If It-1<IM% Then
        Pixel HX-1,HY-1,CMap%(It Mod 15)
      Else
        Pixel HX-1,HY-1,CMap%(0)
      EndIf
    Next HX
  Next HY
End Sub
